// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThrottleReason {
    #[allow(missing_docs)] // documentation missing in model
    CallerRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentInvocationLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    FunctionInvocationRateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ReservedFunctionConcurrentInvocationLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ReservedFunctionInvocationRateLimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThrottleReason {
    fn from(s: &str) -> Self {
        match s {
            "CallerRateLimitExceeded" => ThrottleReason::CallerRateLimitExceeded,
            "ConcurrentInvocationLimitExceeded" => {
                ThrottleReason::ConcurrentInvocationLimitExceeded
            }
            "FunctionInvocationRateLimitExceeded" => {
                ThrottleReason::FunctionInvocationRateLimitExceeded
            }
            "ReservedFunctionConcurrentInvocationLimitExceeded" => {
                ThrottleReason::ReservedFunctionConcurrentInvocationLimitExceeded
            }
            "ReservedFunctionInvocationRateLimitExceeded" => {
                ThrottleReason::ReservedFunctionInvocationRateLimitExceeded
            }
            other => ThrottleReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThrottleReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThrottleReason::from(s))
    }
}
impl ThrottleReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThrottleReason::CallerRateLimitExceeded => "CallerRateLimitExceeded",
            ThrottleReason::ConcurrentInvocationLimitExceeded => {
                "ConcurrentInvocationLimitExceeded"
            }
            ThrottleReason::FunctionInvocationRateLimitExceeded => {
                "FunctionInvocationRateLimitExceeded"
            }
            ThrottleReason::ReservedFunctionConcurrentInvocationLimitExceeded => {
                "ReservedFunctionConcurrentInvocationLimitExceeded"
            }
            ThrottleReason::ReservedFunctionInvocationRateLimitExceeded => {
                "ReservedFunctionInvocationRateLimitExceeded"
            }
            ThrottleReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CallerRateLimitExceeded",
            "ConcurrentInvocationLimitExceeded",
            "FunctionInvocationRateLimitExceeded",
            "ReservedFunctionConcurrentInvocationLimitExceeded",
            "ReservedFunctionInvocationRateLimitExceeded",
        ]
    }
}
impl AsRef<str> for ThrottleReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A configuration object that specifies the destination of an event after Lambda processes it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationConfig {
    /// <p>The destination configuration for successful invocations.</p>
    pub on_success: std::option::Option<crate::model::OnSuccess>,
    /// <p>The destination configuration for failed invocations.</p>
    pub on_failure: std::option::Option<crate::model::OnFailure>,
}
impl DestinationConfig {
    /// <p>The destination configuration for successful invocations.</p>
    pub fn on_success(&self) -> std::option::Option<&crate::model::OnSuccess> {
        self.on_success.as_ref()
    }
    /// <p>The destination configuration for failed invocations.</p>
    pub fn on_failure(&self) -> std::option::Option<&crate::model::OnFailure> {
        self.on_failure.as_ref()
    }
}
impl std::fmt::Debug for DestinationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationConfig");
        formatter.field("on_success", &self.on_success);
        formatter.field("on_failure", &self.on_failure);
        formatter.finish()
    }
}
/// See [`DestinationConfig`](crate::model::DestinationConfig)
pub mod destination_config {
    /// A builder for [`DestinationConfig`](crate::model::DestinationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_success: std::option::Option<crate::model::OnSuccess>,
        pub(crate) on_failure: std::option::Option<crate::model::OnFailure>,
    }
    impl Builder {
        /// <p>The destination configuration for successful invocations.</p>
        pub fn on_success(mut self, input: crate::model::OnSuccess) -> Self {
            self.on_success = Some(input);
            self
        }
        /// <p>The destination configuration for successful invocations.</p>
        pub fn set_on_success(
            mut self,
            input: std::option::Option<crate::model::OnSuccess>,
        ) -> Self {
            self.on_success = input;
            self
        }
        /// <p>The destination configuration for failed invocations.</p>
        pub fn on_failure(mut self, input: crate::model::OnFailure) -> Self {
            self.on_failure = Some(input);
            self
        }
        /// <p>The destination configuration for failed invocations.</p>
        pub fn set_on_failure(
            mut self,
            input: std::option::Option<crate::model::OnFailure>,
        ) -> Self {
            self.on_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationConfig`](crate::model::DestinationConfig)
        pub fn build(self) -> crate::model::DestinationConfig {
            crate::model::DestinationConfig {
                on_success: self.on_success,
                on_failure: self.on_failure,
            }
        }
    }
}
impl DestinationConfig {
    /// Creates a new builder-style object to manufacture [`DestinationConfig`](crate::model::DestinationConfig)
    pub fn builder() -> crate::model::destination_config::Builder {
        crate::model::destination_config::Builder::default()
    }
}

/// <p>A destination for events that failed processing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnFailure {
    /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
    pub destination: std::option::Option<std::string::String>,
}
impl OnFailure {
    /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
}
impl std::fmt::Debug for OnFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnFailure");
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`OnFailure`](crate::model::OnFailure)
pub mod on_failure {
    /// A builder for [`OnFailure`](crate::model::OnFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`OnFailure`](crate::model::OnFailure)
        pub fn build(self) -> crate::model::OnFailure {
            crate::model::OnFailure {
                destination: self.destination,
            }
        }
    }
}
impl OnFailure {
    /// Creates a new builder-style object to manufacture [`OnFailure`](crate::model::OnFailure)
    pub fn builder() -> crate::model::on_failure::Builder {
        crate::model::on_failure::Builder::default()
    }
}

/// <p>A destination for events that were processed successfully.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnSuccess {
    /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
    pub destination: std::option::Option<std::string::String>,
}
impl OnSuccess {
    /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
}
impl std::fmt::Debug for OnSuccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnSuccess");
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`OnSuccess`](crate::model::OnSuccess)
pub mod on_success {
    /// A builder for [`OnSuccess`](crate::model::OnSuccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination resource.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`OnSuccess`](crate::model::OnSuccess)
        pub fn build(self) -> crate::model::OnSuccess {
            crate::model::OnSuccess {
                destination: self.destination,
            }
        }
    }
}
impl OnSuccess {
    /// Creates a new builder-style object to manufacture [`OnSuccess`](crate::model::OnSuccess)
    pub fn builder() -> crate::model::on_success::Builder {
        crate::model::on_success::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Architecture {
    #[allow(missing_docs)] // documentation missing in model
    Arm64,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Architecture {
    fn from(s: &str) -> Self {
        match s {
            "arm64" => Architecture::Arm64,
            "x86_64" => Architecture::X8664,
            other => Architecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Architecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Architecture::from(s))
    }
}
impl Architecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Architecture::Arm64 => "arm64",
            Architecture::X8664 => "x86_64",
            Architecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["arm64", "x86_64"]
    }
}
impl AsRef<str> for Architecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Response to GetFunctionConfiguration request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageConfigResponse {
    /// <p>Configuration values that override the container image Dockerfile.</p>
    pub image_config: std::option::Option<crate::model::ImageConfig>,
    /// <p>Error response to GetFunctionConfiguration.</p>
    pub error: std::option::Option<crate::model::ImageConfigError>,
}
impl ImageConfigResponse {
    /// <p>Configuration values that override the container image Dockerfile.</p>
    pub fn image_config(&self) -> std::option::Option<&crate::model::ImageConfig> {
        self.image_config.as_ref()
    }
    /// <p>Error response to GetFunctionConfiguration.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ImageConfigError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for ImageConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageConfigResponse");
        formatter.field("image_config", &self.image_config);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ImageConfigResponse`](crate::model::ImageConfigResponse)
pub mod image_config_response {
    /// A builder for [`ImageConfigResponse`](crate::model::ImageConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_config: std::option::Option<crate::model::ImageConfig>,
        pub(crate) error: std::option::Option<crate::model::ImageConfigError>,
    }
    impl Builder {
        /// <p>Configuration values that override the container image Dockerfile.</p>
        pub fn image_config(mut self, input: crate::model::ImageConfig) -> Self {
            self.image_config = Some(input);
            self
        }
        /// <p>Configuration values that override the container image Dockerfile.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.image_config = input;
            self
        }
        /// <p>Error response to GetFunctionConfiguration.</p>
        pub fn error(mut self, input: crate::model::ImageConfigError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Error response to GetFunctionConfiguration.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ImageConfigError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageConfigResponse`](crate::model::ImageConfigResponse)
        pub fn build(self) -> crate::model::ImageConfigResponse {
            crate::model::ImageConfigResponse {
                image_config: self.image_config,
                error: self.error,
            }
        }
    }
}
impl ImageConfigResponse {
    /// Creates a new builder-style object to manufacture [`ImageConfigResponse`](crate::model::ImageConfigResponse)
    pub fn builder() -> crate::model::image_config_response::Builder {
        crate::model::image_config_response::Builder::default()
    }
}

/// <p>Error response to GetFunctionConfiguration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageConfigError {
    /// <p>Error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>Error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ImageConfigError {
    /// <p>Error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>Error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ImageConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageConfigError");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ImageConfigError`](crate::model::ImageConfigError)
pub mod image_config_error {
    /// A builder for [`ImageConfigError`](crate::model::ImageConfigError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>Error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>Error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageConfigError`](crate::model::ImageConfigError)
        pub fn build(self) -> crate::model::ImageConfigError {
            crate::model::ImageConfigError {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ImageConfigError {
    /// Creates a new builder-style object to manufacture [`ImageConfigError`](crate::model::ImageConfigError)
    pub fn builder() -> crate::model::image_config_error::Builder {
        crate::model::image_config_error::Builder::default()
    }
}

/// <p>Configuration values that override the container image Dockerfile settings. See
/// <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms">Container settings</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageConfig {
    /// <p>Specifies the entry point to their application, which is typically the location of the runtime
    /// executable.</p>
    pub entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies parameters that you want to pass in with ENTRYPOINT. </p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the working directory.</p>
    pub working_directory: std::option::Option<std::string::String>,
}
impl ImageConfig {
    /// <p>Specifies the entry point to their application, which is typically the location of the runtime
    /// executable.</p>
    pub fn entry_point(&self) -> std::option::Option<&[std::string::String]> {
        self.entry_point.as_deref()
    }
    /// <p>Specifies parameters that you want to pass in with ENTRYPOINT. </p>
    pub fn command(&self) -> std::option::Option<&[std::string::String]> {
        self.command.as_deref()
    }
    /// <p>Specifies the working directory.</p>
    pub fn working_directory(&self) -> std::option::Option<&str> {
        self.working_directory.as_deref()
    }
}
impl std::fmt::Debug for ImageConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageConfig");
        formatter.field("entry_point", &self.entry_point);
        formatter.field("command", &self.command);
        formatter.field("working_directory", &self.working_directory);
        formatter.finish()
    }
}
/// See [`ImageConfig`](crate::model::ImageConfig)
pub mod image_config {
    /// A builder for [`ImageConfig`](crate::model::ImageConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) working_directory: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entry_point`.
        ///
        /// To override the contents of this collection use [`set_entry_point`](Self::set_entry_point).
        ///
        /// <p>Specifies the entry point to their application, which is typically the location of the runtime
        /// executable.</p>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entry_point.unwrap_or_default();
            v.push(input.into());
            self.entry_point = Some(v);
            self
        }
        /// <p>Specifies the entry point to their application, which is typically the location of the runtime
        /// executable.</p>
        pub fn set_entry_point(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entry_point = input;
            self
        }
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>Specifies parameters that you want to pass in with ENTRYPOINT. </p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>Specifies parameters that you want to pass in with ENTRYPOINT. </p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// <p>Specifies the working directory.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>Specifies the working directory.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageConfig`](crate::model::ImageConfig)
        pub fn build(self) -> crate::model::ImageConfig {
            crate::model::ImageConfig {
                entry_point: self.entry_point,
                command: self.command,
                working_directory: self.working_directory,
            }
        }
    }
}
impl ImageConfig {
    /// Creates a new builder-style object to manufacture [`ImageConfig`](crate::model::ImageConfig)
    pub fn builder() -> crate::model::image_config::Builder {
        crate::model::image_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageType {
    #[allow(missing_docs)] // documentation missing in model
    Image,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageType {
    fn from(s: &str) -> Self {
        match s {
            "Image" => PackageType::Image,
            "Zip" => PackageType::Zip,
            other => PackageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageType::from(s))
    }
}
impl PackageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageType::Image => "Image",
            PackageType::Zip => "Zip",
            PackageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Image", "Zip"]
    }
}
impl AsRef<str> for PackageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the connection between a Lambda function and an
/// <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemConfig {
    /// <p>The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The path where the function can access the file system, starting with <code>/mnt/</code>.</p>
    pub local_mount_path: std::option::Option<std::string::String>,
}
impl FileSystemConfig {
    /// <p>The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The path where the function can access the file system, starting with <code>/mnt/</code>.</p>
    pub fn local_mount_path(&self) -> std::option::Option<&str> {
        self.local_mount_path.as_deref()
    }
}
impl std::fmt::Debug for FileSystemConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemConfig");
        formatter.field("arn", &self.arn);
        formatter.field("local_mount_path", &self.local_mount_path);
        formatter.finish()
    }
}
/// See [`FileSystemConfig`](crate::model::FileSystemConfig)
pub mod file_system_config {
    /// A builder for [`FileSystemConfig`](crate::model::FileSystemConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) local_mount_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The path where the function can access the file system, starting with <code>/mnt/</code>.</p>
        pub fn local_mount_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_mount_path = Some(input.into());
            self
        }
        /// <p>The path where the function can access the file system, starting with <code>/mnt/</code>.</p>
        pub fn set_local_mount_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_mount_path = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemConfig`](crate::model::FileSystemConfig)
        pub fn build(self) -> crate::model::FileSystemConfig {
            crate::model::FileSystemConfig {
                arn: self.arn,
                local_mount_path: self.local_mount_path,
            }
        }
    }
}
impl FileSystemConfig {
    /// Creates a new builder-style object to manufacture [`FileSystemConfig`](crate::model::FileSystemConfig)
    pub fn builder() -> crate::model::file_system_config::Builder {
        crate::model::file_system_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastUpdateStatusReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    EniLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ImageAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ImageDeleted,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientRolePermissions,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    InvalidImage,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSubnet,
    #[allow(missing_docs)] // documentation missing in model
    SubnetOutOfIpAddresses,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastUpdateStatusReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "EniLimitExceeded" => LastUpdateStatusReasonCode::EniLimitExceeded,
            "ImageAccessDenied" => LastUpdateStatusReasonCode::ImageAccessDenied,
            "ImageDeleted" => LastUpdateStatusReasonCode::ImageDeleted,
            "InsufficientRolePermissions" => {
                LastUpdateStatusReasonCode::InsufficientRolePermissions
            }
            "InternalError" => LastUpdateStatusReasonCode::InternalError,
            "InvalidConfiguration" => LastUpdateStatusReasonCode::InvalidConfiguration,
            "InvalidImage" => LastUpdateStatusReasonCode::InvalidImage,
            "InvalidSecurityGroup" => LastUpdateStatusReasonCode::InvalidSecurityGroup,
            "InvalidSubnet" => LastUpdateStatusReasonCode::InvalidSubnet,
            "SubnetOutOfIPAddresses" => LastUpdateStatusReasonCode::SubnetOutOfIpAddresses,
            other => LastUpdateStatusReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastUpdateStatusReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastUpdateStatusReasonCode::from(s))
    }
}
impl LastUpdateStatusReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastUpdateStatusReasonCode::EniLimitExceeded => "EniLimitExceeded",
            LastUpdateStatusReasonCode::ImageAccessDenied => "ImageAccessDenied",
            LastUpdateStatusReasonCode::ImageDeleted => "ImageDeleted",
            LastUpdateStatusReasonCode::InsufficientRolePermissions => {
                "InsufficientRolePermissions"
            }
            LastUpdateStatusReasonCode::InternalError => "InternalError",
            LastUpdateStatusReasonCode::InvalidConfiguration => "InvalidConfiguration",
            LastUpdateStatusReasonCode::InvalidImage => "InvalidImage",
            LastUpdateStatusReasonCode::InvalidSecurityGroup => "InvalidSecurityGroup",
            LastUpdateStatusReasonCode::InvalidSubnet => "InvalidSubnet",
            LastUpdateStatusReasonCode::SubnetOutOfIpAddresses => "SubnetOutOfIPAddresses",
            LastUpdateStatusReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EniLimitExceeded",
            "ImageAccessDenied",
            "ImageDeleted",
            "InsufficientRolePermissions",
            "InternalError",
            "InvalidConfiguration",
            "InvalidImage",
            "InvalidSecurityGroup",
            "InvalidSubnet",
            "SubnetOutOfIPAddresses",
        ]
    }
}
impl AsRef<str> for LastUpdateStatusReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => LastUpdateStatus::Failed,
            "InProgress" => LastUpdateStatus::InProgress,
            "Successful" => LastUpdateStatus::Successful,
            other => LastUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastUpdateStatus::from(s))
    }
}
impl LastUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastUpdateStatus::Failed => "Failed",
            LastUpdateStatus::InProgress => "InProgress",
            LastUpdateStatus::Successful => "Successful",
            LastUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Successful"]
    }
}
impl AsRef<str> for LastUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    EniLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    ImageAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ImageDeleted,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientRolePermissions,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    InvalidImage,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSubnet,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    #[allow(missing_docs)] // documentation missing in model
    SubnetOutOfIpAddresses,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "Creating" => StateReasonCode::Creating,
            "EniLimitExceeded" => StateReasonCode::EniLimitExceeded,
            "Idle" => StateReasonCode::Idle,
            "ImageAccessDenied" => StateReasonCode::ImageAccessDenied,
            "ImageDeleted" => StateReasonCode::ImageDeleted,
            "InsufficientRolePermissions" => StateReasonCode::InsufficientRolePermissions,
            "InternalError" => StateReasonCode::InternalError,
            "InvalidConfiguration" => StateReasonCode::InvalidConfiguration,
            "InvalidImage" => StateReasonCode::InvalidImage,
            "InvalidSecurityGroup" => StateReasonCode::InvalidSecurityGroup,
            "InvalidSubnet" => StateReasonCode::InvalidSubnet,
            "Restoring" => StateReasonCode::Restoring,
            "SubnetOutOfIPAddresses" => StateReasonCode::SubnetOutOfIpAddresses,
            other => StateReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateReasonCode::from(s))
    }
}
impl StateReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateReasonCode::Creating => "Creating",
            StateReasonCode::EniLimitExceeded => "EniLimitExceeded",
            StateReasonCode::Idle => "Idle",
            StateReasonCode::ImageAccessDenied => "ImageAccessDenied",
            StateReasonCode::ImageDeleted => "ImageDeleted",
            StateReasonCode::InsufficientRolePermissions => "InsufficientRolePermissions",
            StateReasonCode::InternalError => "InternalError",
            StateReasonCode::InvalidConfiguration => "InvalidConfiguration",
            StateReasonCode::InvalidImage => "InvalidImage",
            StateReasonCode::InvalidSecurityGroup => "InvalidSecurityGroup",
            StateReasonCode::InvalidSubnet => "InvalidSubnet",
            StateReasonCode::Restoring => "Restoring",
            StateReasonCode::SubnetOutOfIpAddresses => "SubnetOutOfIPAddresses",
            StateReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Creating",
            "EniLimitExceeded",
            "Idle",
            "ImageAccessDenied",
            "ImageDeleted",
            "InsufficientRolePermissions",
            "InternalError",
            "InvalidConfiguration",
            "InvalidImage",
            "InvalidSecurityGroup",
            "InvalidSubnet",
            "Restoring",
            "SubnetOutOfIPAddresses",
        ]
    }
}
impl AsRef<str> for StateReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "Active" => State::Active,
            "Failed" => State::Failed,
            "Inactive" => State::Inactive,
            "Pending" => State::Pending,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Active => "Active",
            State::Failed => "Failed",
            State::Inactive => "Inactive",
            State::Pending => "Pending",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Failed", "Inactive", "Pending"]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
/// layer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Layer {
    /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The size of the layer archive in bytes.</p>
    pub code_size: i64,
    /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
}
impl Layer {
    /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The size of the layer archive in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
}
impl std::fmt::Debug for Layer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Layer");
        formatter.field("arn", &self.arn);
        formatter.field("code_size", &self.code_size);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.finish()
    }
}
/// See [`Layer`](crate::model::Layer)
pub mod layer {
    /// A builder for [`Layer`](crate::model::Layer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The size of the layer archive in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the layer archive in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Layer`](crate::model::Layer)
        pub fn build(self) -> crate::model::Layer {
            crate::model::Layer {
                arn: self.arn,
                code_size: self.code_size.unwrap_or_default(),
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
            }
        }
    }
}
impl Layer {
    /// Creates a new builder-style object to manufacture [`Layer`](crate::model::Layer)
    pub fn builder() -> crate::model::layer::Builder {
        crate::model::layer::Builder::default()
    }
}

/// <p>The function's X-Ray tracing configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TracingConfigResponse {
    /// <p>The tracing mode.</p>
    pub mode: std::option::Option<crate::model::TracingMode>,
}
impl TracingConfigResponse {
    /// <p>The tracing mode.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::TracingMode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for TracingConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TracingConfigResponse");
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`TracingConfigResponse`](crate::model::TracingConfigResponse)
pub mod tracing_config_response {
    /// A builder for [`TracingConfigResponse`](crate::model::TracingConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::TracingMode>,
    }
    impl Builder {
        /// <p>The tracing mode.</p>
        pub fn mode(mut self, input: crate::model::TracingMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The tracing mode.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::TracingMode>) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`TracingConfigResponse`](crate::model::TracingConfigResponse)
        pub fn build(self) -> crate::model::TracingConfigResponse {
            crate::model::TracingConfigResponse { mode: self.mode }
        }
    }
}
impl TracingConfigResponse {
    /// Creates a new builder-style object to manufacture [`TracingConfigResponse`](crate::model::TracingConfigResponse)
    pub fn builder() -> crate::model::tracing_config_response::Builder {
        crate::model::tracing_config_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TracingMode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    PassThrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TracingMode {
    fn from(s: &str) -> Self {
        match s {
            "Active" => TracingMode::Active,
            "PassThrough" => TracingMode::PassThrough,
            other => TracingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TracingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TracingMode::from(s))
    }
}
impl TracingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TracingMode::Active => "Active",
            TracingMode::PassThrough => "PassThrough",
            TracingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "PassThrough"]
    }
}
impl AsRef<str> for TracingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The results of an operation to update or read environment variables. If the operation is successful, the
/// response contains the environment variables. If it failed, the response contains details about the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentResponse {
    /// <p>Environment variable key-value pairs.</p>
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Error messages for environment variables that couldn't be applied.</p>
    pub error: std::option::Option<crate::model::EnvironmentError>,
}
impl EnvironmentResponse {
    /// <p>Environment variable key-value pairs.</p>
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
    /// <p>Error messages for environment variables that couldn't be applied.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::EnvironmentError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentResponse");
        formatter.field("variables", &"*** Sensitive Data Redacted ***");
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`EnvironmentResponse`](crate::model::EnvironmentResponse)
pub mod environment_response {
    /// A builder for [`EnvironmentResponse`](crate::model::EnvironmentResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error: std::option::Option<crate::model::EnvironmentError>,
    }
    impl Builder {
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>Environment variable key-value pairs.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>Environment variable key-value pairs.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>Error messages for environment variables that couldn't be applied.</p>
        pub fn error(mut self, input: crate::model::EnvironmentError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Error messages for environment variables that couldn't be applied.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::EnvironmentError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentResponse`](crate::model::EnvironmentResponse)
        pub fn build(self) -> crate::model::EnvironmentResponse {
            crate::model::EnvironmentResponse {
                variables: self.variables,
                error: self.error,
            }
        }
    }
}
impl EnvironmentResponse {
    /// Creates a new builder-style object to manufacture [`EnvironmentResponse`](crate::model::EnvironmentResponse)
    pub fn builder() -> crate::model::environment_response::Builder {
        crate::model::environment_response::Builder::default()
    }
}

/// <p>Error messages for environment variables that couldn't be applied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl EnvironmentError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentError");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EnvironmentError`](crate::model::EnvironmentError)
pub mod environment_error {
    /// A builder for [`EnvironmentError`](crate::model::EnvironmentError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentError`](crate::model::EnvironmentError)
        pub fn build(self) -> crate::model::EnvironmentError {
            crate::model::EnvironmentError {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl EnvironmentError {
    /// Creates a new builder-style object to manufacture [`EnvironmentError`](crate::model::EnvironmentError)
    pub fn builder() -> crate::model::environment_error::Builder {
        crate::model::environment_error::Builder::default()
    }
}

/// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">dead-letter queue</a> for
/// failed asynchronous invocations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeadLetterConfig {
    /// <p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl DeadLetterConfig {
    /// <p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for DeadLetterConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeadLetterConfig");
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}
/// See [`DeadLetterConfig`](crate::model::DeadLetterConfig)
pub mod dead_letter_config {
    /// A builder for [`DeadLetterConfig`](crate::model::DeadLetterConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeadLetterConfig`](crate::model::DeadLetterConfig)
        pub fn build(self) -> crate::model::DeadLetterConfig {
            crate::model::DeadLetterConfig {
                target_arn: self.target_arn,
            }
        }
    }
}
impl DeadLetterConfig {
    /// Creates a new builder-style object to manufacture [`DeadLetterConfig`](crate::model::DeadLetterConfig)
    pub fn builder() -> crate::model::dead_letter_config::Builder {
        crate::model::dead_letter_config::Builder::default()
    }
}

/// <p>The VPC security groups and subnets that are attached to a Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigResponse {
    /// <p>A list of VPC subnet IDs.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of VPC security groups IDs.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl VpcConfigResponse {
    /// <p>A list of VPC subnet IDs.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of VPC security groups IDs.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for VpcConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigResponse");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`VpcConfigResponse`](crate::model::VpcConfigResponse)
pub mod vpc_config_response {
    /// A builder for [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of VPC security groups IDs.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups IDs.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigResponse`](crate::model::VpcConfigResponse)
        pub fn build(self) -> crate::model::VpcConfigResponse {
            crate::model::VpcConfigResponse {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl VpcConfigResponse {
    /// Creates a new builder-style object to manufacture [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    pub fn builder() -> crate::model::vpc_config_response::Builder {
        crate::model::vpc_config_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Runtime {
    #[allow(missing_docs)] // documentation missing in model
    Dotnetcore10,
    #[allow(missing_docs)] // documentation missing in model
    Dotnetcore20,
    #[allow(missing_docs)] // documentation missing in model
    Dotnetcore21,
    #[allow(missing_docs)] // documentation missing in model
    Dotnetcore31,
    #[allow(missing_docs)] // documentation missing in model
    Go1x,
    #[allow(missing_docs)] // documentation missing in model
    Java11,
    #[allow(missing_docs)] // documentation missing in model
    Java8,
    #[allow(missing_docs)] // documentation missing in model
    Java8al2,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs10x,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs12x,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs14x,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs43,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs43edge,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs610,
    #[allow(missing_docs)] // documentation missing in model
    Nodejs810,
    #[allow(missing_docs)] // documentation missing in model
    Provided,
    #[allow(missing_docs)] // documentation missing in model
    Providedal2,
    #[allow(missing_docs)] // documentation missing in model
    Python27,
    #[allow(missing_docs)] // documentation missing in model
    Python36,
    #[allow(missing_docs)] // documentation missing in model
    Python37,
    #[allow(missing_docs)] // documentation missing in model
    Python38,
    #[allow(missing_docs)] // documentation missing in model
    Python39,
    #[allow(missing_docs)] // documentation missing in model
    Ruby25,
    #[allow(missing_docs)] // documentation missing in model
    Ruby27,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Runtime {
    fn from(s: &str) -> Self {
        match s {
            "dotnetcore1.0" => Runtime::Dotnetcore10,
            "dotnetcore2.0" => Runtime::Dotnetcore20,
            "dotnetcore2.1" => Runtime::Dotnetcore21,
            "dotnetcore3.1" => Runtime::Dotnetcore31,
            "go1.x" => Runtime::Go1x,
            "java11" => Runtime::Java11,
            "java8" => Runtime::Java8,
            "java8.al2" => Runtime::Java8al2,
            "nodejs" => Runtime::Nodejs,
            "nodejs10.x" => Runtime::Nodejs10x,
            "nodejs12.x" => Runtime::Nodejs12x,
            "nodejs14.x" => Runtime::Nodejs14x,
            "nodejs4.3" => Runtime::Nodejs43,
            "nodejs4.3-edge" => Runtime::Nodejs43edge,
            "nodejs6.10" => Runtime::Nodejs610,
            "nodejs8.10" => Runtime::Nodejs810,
            "provided" => Runtime::Provided,
            "provided.al2" => Runtime::Providedal2,
            "python2.7" => Runtime::Python27,
            "python3.6" => Runtime::Python36,
            "python3.7" => Runtime::Python37,
            "python3.8" => Runtime::Python38,
            "python3.9" => Runtime::Python39,
            "ruby2.5" => Runtime::Ruby25,
            "ruby2.7" => Runtime::Ruby27,
            other => Runtime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Runtime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Runtime::from(s))
    }
}
impl Runtime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Runtime::Dotnetcore10 => "dotnetcore1.0",
            Runtime::Dotnetcore20 => "dotnetcore2.0",
            Runtime::Dotnetcore21 => "dotnetcore2.1",
            Runtime::Dotnetcore31 => "dotnetcore3.1",
            Runtime::Go1x => "go1.x",
            Runtime::Java11 => "java11",
            Runtime::Java8 => "java8",
            Runtime::Java8al2 => "java8.al2",
            Runtime::Nodejs => "nodejs",
            Runtime::Nodejs10x => "nodejs10.x",
            Runtime::Nodejs12x => "nodejs12.x",
            Runtime::Nodejs14x => "nodejs14.x",
            Runtime::Nodejs43 => "nodejs4.3",
            Runtime::Nodejs43edge => "nodejs4.3-edge",
            Runtime::Nodejs610 => "nodejs6.10",
            Runtime::Nodejs810 => "nodejs8.10",
            Runtime::Provided => "provided",
            Runtime::Providedal2 => "provided.al2",
            Runtime::Python27 => "python2.7",
            Runtime::Python36 => "python3.6",
            Runtime::Python37 => "python3.7",
            Runtime::Python38 => "python3.8",
            Runtime::Python39 => "python3.9",
            Runtime::Ruby25 => "ruby2.5",
            Runtime::Ruby27 => "ruby2.7",
            Runtime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "dotnetcore1.0",
            "dotnetcore2.0",
            "dotnetcore2.1",
            "dotnetcore3.1",
            "go1.x",
            "java11",
            "java8",
            "java8.al2",
            "nodejs",
            "nodejs10.x",
            "nodejs12.x",
            "nodejs14.x",
            "nodejs4.3",
            "nodejs4.3-edge",
            "nodejs6.10",
            "nodejs8.10",
            "provided",
            "provided.al2",
            "python2.7",
            "python3.6",
            "python3.7",
            "python3.8",
            "python3.9",
            "ruby2.5",
            "ruby2.7",
        ]
    }
}
impl AsRef<str> for Runtime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a> tracing configuration.
/// To sample and record incoming requests, set <code>Mode</code> to <code>Active</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TracingConfig {
    /// <p>The tracing mode.</p>
    pub mode: std::option::Option<crate::model::TracingMode>,
}
impl TracingConfig {
    /// <p>The tracing mode.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::TracingMode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for TracingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TracingConfig");
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`TracingConfig`](crate::model::TracingConfig)
pub mod tracing_config {
    /// A builder for [`TracingConfig`](crate::model::TracingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::TracingMode>,
    }
    impl Builder {
        /// <p>The tracing mode.</p>
        pub fn mode(mut self, input: crate::model::TracingMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The tracing mode.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::TracingMode>) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`TracingConfig`](crate::model::TracingConfig)
        pub fn build(self) -> crate::model::TracingConfig {
            crate::model::TracingConfig { mode: self.mode }
        }
    }
}
impl TracingConfig {
    /// Creates a new builder-style object to manufacture [`TracingConfig`](crate::model::TracingConfig)
    pub fn builder() -> crate::model::tracing_config::Builder {
        crate::model::tracing_config::Builder::default()
    }
}

/// <p>A function's environment variable settings.
/// You can use environment variables to adjust your function's behavior without updating code.
/// An environment variable is a pair of strings that are stored in a function's version-specific configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Environment {
    /// <p>Environment variable key-value pairs. For more information, see
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Using Lambda environment variables</a>.</p>
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Environment {
    /// <p>Environment variable key-value pairs. For more information, see
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Using Lambda environment variables</a>.</p>
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
}
impl std::fmt::Debug for Environment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Environment");
        formatter.field("variables", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Environment`](crate::model::Environment)
pub mod environment {
    /// A builder for [`Environment`](crate::model::Environment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>Environment variable key-value pairs. For more information, see
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Using Lambda environment variables</a>.</p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// <p>Environment variable key-value pairs. For more information, see
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Using Lambda environment variables</a>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Consumes the builder and constructs a [`Environment`](crate::model::Environment)
        pub fn build(self) -> crate::model::Environment {
            crate::model::Environment {
                variables: self.variables,
            }
        }
    }
}
impl Environment {
    /// Creates a new builder-style object to manufacture [`Environment`](crate::model::Environment)
    pub fn builder() -> crate::model::environment::Builder {
        crate::model::environment::Builder::default()
    }
}

/// <p>The VPC security groups and subnets that are attached to a Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>A list of VPC subnet IDs.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of VPC security groups IDs.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfig {
    /// <p>A list of VPC subnet IDs.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of VPC security groups IDs.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of VPC subnet IDs.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of VPC security groups IDs.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of VPC security groups IDs.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FunctionResponseType {
    #[allow(missing_docs)] // documentation missing in model
    ReportBatchItemFailures,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FunctionResponseType {
    fn from(s: &str) -> Self {
        match s {
            "ReportBatchItemFailures" => FunctionResponseType::ReportBatchItemFailures,
            other => FunctionResponseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FunctionResponseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FunctionResponseType::from(s))
    }
}
impl FunctionResponseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FunctionResponseType::ReportBatchItemFailures => "ReportBatchItemFailures",
            FunctionResponseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ReportBatchItemFailures"]
    }
}
impl AsRef<str> for FunctionResponseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The self-managed Apache Kafka cluster for your event source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelfManagedEventSource {
    /// <p>The list of bootstrap servers for your Kafka brokers in the following format: <code>"KAFKA_BOOTSTRAP_SERVERS":
    /// ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]</code>.</p>
    pub endpoints: std::option::Option<
        std::collections::HashMap<crate::model::EndPointType, std::vec::Vec<std::string::String>>,
    >,
}
impl SelfManagedEventSource {
    /// <p>The list of bootstrap servers for your Kafka brokers in the following format: <code>"KAFKA_BOOTSTRAP_SERVERS":
    /// ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]</code>.</p>
    pub fn endpoints(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::EndPointType, std::vec::Vec<std::string::String>>,
    > {
        self.endpoints.as_ref()
    }
}
impl std::fmt::Debug for SelfManagedEventSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelfManagedEventSource");
        formatter.field("endpoints", &self.endpoints);
        formatter.finish()
    }
}
/// See [`SelfManagedEventSource`](crate::model::SelfManagedEventSource)
pub mod self_managed_event_source {
    /// A builder for [`SelfManagedEventSource`](crate::model::SelfManagedEventSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoints: std::option::Option<
            std::collections::HashMap<
                crate::model::EndPointType,
                std::vec::Vec<std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>The list of bootstrap servers for your Kafka brokers in the following format: <code>"KAFKA_BOOTSTRAP_SERVERS":
        /// ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]</code>.</p>
        pub fn endpoints(
            mut self,
            k: impl Into<crate::model::EndPointType>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.endpoints.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.endpoints = Some(hash_map);
            self
        }
        /// <p>The list of bootstrap servers for your Kafka brokers in the following format: <code>"KAFKA_BOOTSTRAP_SERVERS":
        /// ["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]</code>.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::EndPointType,
                    std::vec::Vec<std::string::String>,
                >,
            >,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`SelfManagedEventSource`](crate::model::SelfManagedEventSource)
        pub fn build(self) -> crate::model::SelfManagedEventSource {
            crate::model::SelfManagedEventSource {
                endpoints: self.endpoints,
            }
        }
    }
}
impl SelfManagedEventSource {
    /// Creates a new builder-style object to manufacture [`SelfManagedEventSource`](crate::model::SelfManagedEventSource)
    pub fn builder() -> crate::model::self_managed_event_source::Builder {
        crate::model::self_managed_event_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndPointType {
    #[allow(missing_docs)] // documentation missing in model
    KafkaBootstrapServers,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndPointType {
    fn from(s: &str) -> Self {
        match s {
            "KAFKA_BOOTSTRAP_SERVERS" => EndPointType::KafkaBootstrapServers,
            other => EndPointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndPointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndPointType::from(s))
    }
}
impl EndPointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndPointType::KafkaBootstrapServers => "KAFKA_BOOTSTRAP_SERVERS",
            EndPointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KAFKA_BOOTSTRAP_SERVERS"]
    }
}
impl AsRef<str> for EndPointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>To secure and define access to your event source, you can specify the authentication protocol, VPC components, or virtual host.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceAccessConfiguration {
    /// <p>The type of authentication protocol, VPC components, or virtual host for your event source. For example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VPC_SUBNET</code> - The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VPC_SECURITY_GROUP</code> - The VPC security group used to manage access to your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SASL_SCRAM_256_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SASL_SCRAM_512_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VIRTUAL_HOST</code> - (Amazon MQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::SourceAccessType>,
    /// <p>The value for your chosen configuration in <code>Type</code>. For example: <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.</p>
    pub uri: std::option::Option<std::string::String>,
}
impl SourceAccessConfiguration {
    /// <p>The type of authentication protocol, VPC components, or virtual host for your event source. For example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VPC_SUBNET</code> - The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VPC_SECURITY_GROUP</code> - The VPC security group used to manage access to your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SASL_SCRAM_256_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SASL_SCRAM_512_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VIRTUAL_HOST</code> - (Amazon MQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SourceAccessType> {
        self.r#type.as_ref()
    }
    /// <p>The value for your chosen configuration in <code>Type</code>. For example: <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
}
impl std::fmt::Debug for SourceAccessConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceAccessConfiguration");
        formatter.field("r#type", &self.r#type);
        formatter.field("uri", &self.uri);
        formatter.finish()
    }
}
/// See [`SourceAccessConfiguration`](crate::model::SourceAccessConfiguration)
pub mod source_access_configuration {
    /// A builder for [`SourceAccessConfiguration`](crate::model::SourceAccessConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SourceAccessType>,
        pub(crate) uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of authentication protocol, VPC components, or virtual host for your event source. For example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPC_SUBNET</code> - The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPC_SECURITY_GROUP</code> - The VPC security group used to manage access to your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SASL_SCRAM_256_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SASL_SCRAM_512_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VIRTUAL_HOST</code> - (Amazon MQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::SourceAccessType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of authentication protocol, VPC components, or virtual host for your event source. For example: <code>"Type":"SASL_SCRAM_512_AUTH"</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BASIC_AUTH</code> - (Amazon MQ) The Secrets Manager secret that stores your broker credentials.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC_AUTH</code> - (Self-managed Apache Kafka) The Secrets Manager ARN of your secret key used for SASL/PLAIN authentication of your Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPC_SUBNET</code> - The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your self-managed Apache Kafka cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPC_SECURITY_GROUP</code> - The VPC security group used to manage access to your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SASL_SCRAM_256_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SASL_SCRAM_512_AUTH</code> - The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed Apache Kafka brokers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VIRTUAL_HOST</code> - (Amazon MQ) The name of the virtual host in your RabbitMQ broker. Lambda uses this RabbitMQ host as the event source.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SourceAccessType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value for your chosen configuration in <code>Type</code>. For example: <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The value for your chosen configuration in <code>Type</code>. For example: <code>"URI": "arn:aws:secretsmanager:us-east-1:01234567890:secret:MyBrokerSecretName"</code>.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceAccessConfiguration`](crate::model::SourceAccessConfiguration)
        pub fn build(self) -> crate::model::SourceAccessConfiguration {
            crate::model::SourceAccessConfiguration {
                r#type: self.r#type,
                uri: self.uri,
            }
        }
    }
}
impl SourceAccessConfiguration {
    /// Creates a new builder-style object to manufacture [`SourceAccessConfiguration`](crate::model::SourceAccessConfiguration)
    pub fn builder() -> crate::model::source_access_configuration::Builder {
        crate::model::source_access_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceAccessType {
    #[allow(missing_docs)] // documentation missing in model
    BasicAuth,
    #[allow(missing_docs)] // documentation missing in model
    SaslScram256Auth,
    #[allow(missing_docs)] // documentation missing in model
    SaslScram512Auth,
    #[allow(missing_docs)] // documentation missing in model
    VirtualHost,
    #[allow(missing_docs)] // documentation missing in model
    VpcSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    VpcSubnet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceAccessType {
    fn from(s: &str) -> Self {
        match s {
            "BASIC_AUTH" => SourceAccessType::BasicAuth,
            "SASL_SCRAM_256_AUTH" => SourceAccessType::SaslScram256Auth,
            "SASL_SCRAM_512_AUTH" => SourceAccessType::SaslScram512Auth,
            "VIRTUAL_HOST" => SourceAccessType::VirtualHost,
            "VPC_SECURITY_GROUP" => SourceAccessType::VpcSecurityGroup,
            "VPC_SUBNET" => SourceAccessType::VpcSubnet,
            other => SourceAccessType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceAccessType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceAccessType::from(s))
    }
}
impl SourceAccessType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceAccessType::BasicAuth => "BASIC_AUTH",
            SourceAccessType::SaslScram256Auth => "SASL_SCRAM_256_AUTH",
            SourceAccessType::SaslScram512Auth => "SASL_SCRAM_512_AUTH",
            SourceAccessType::VirtualHost => "VIRTUAL_HOST",
            SourceAccessType::VpcSecurityGroup => "VPC_SECURITY_GROUP",
            SourceAccessType::VpcSubnet => "VPC_SUBNET",
            SourceAccessType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BASIC_AUTH",
            "SASL_SCRAM_256_AUTH",
            "SASL_SCRAM_512_AUTH",
            "VIRTUAL_HOST",
            "VPC_SECURITY_GROUP",
            "VPC_SUBNET",
        ]
    }
}
impl AsRef<str> for SourceAccessType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSourcePosition {
    #[allow(missing_docs)] // documentation missing in model
    AtTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    Latest,
    #[allow(missing_docs)] // documentation missing in model
    TrimHorizon,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSourcePosition {
    fn from(s: &str) -> Self {
        match s {
            "AT_TIMESTAMP" => EventSourcePosition::AtTimestamp,
            "LATEST" => EventSourcePosition::Latest,
            "TRIM_HORIZON" => EventSourcePosition::TrimHorizon,
            other => EventSourcePosition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSourcePosition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSourcePosition::from(s))
    }
}
impl EventSourcePosition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSourcePosition::AtTimestamp => "AT_TIMESTAMP",
            EventSourcePosition::Latest => "LATEST",
            EventSourcePosition::TrimHorizon => "TRIM_HORIZON",
            EventSourcePosition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AT_TIMESTAMP", "LATEST", "TRIM_HORIZON"]
    }
}
impl AsRef<str> for EventSourcePosition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Code signing configuration</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigningConfig {
    /// <p>Unique identifer for the Code signing configuration.</p>
    pub code_signing_config_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>Code signing configuration description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>List of allowed publishers.</p>
    pub allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
    /// <p>The code signing policy controls the validation failure action for signature mismatch or expiry.</p>
    pub code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
    /// <p>The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD). </p>
    pub last_modified: std::option::Option<std::string::String>,
}
impl CodeSigningConfig {
    /// <p>Unique identifer for the Code signing configuration.</p>
    pub fn code_signing_config_id(&self) -> std::option::Option<&str> {
        self.code_signing_config_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>Code signing configuration description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>List of allowed publishers.</p>
    pub fn allowed_publishers(&self) -> std::option::Option<&crate::model::AllowedPublishers> {
        self.allowed_publishers.as_ref()
    }
    /// <p>The code signing policy controls the validation failure action for signature mismatch or expiry.</p>
    pub fn code_signing_policies(&self) -> std::option::Option<&crate::model::CodeSigningPolicies> {
        self.code_signing_policies.as_ref()
    }
    /// <p>The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD). </p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
}
impl std::fmt::Debug for CodeSigningConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigningConfig");
        formatter.field("code_signing_config_id", &self.code_signing_config_id);
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("description", &self.description);
        formatter.field("allowed_publishers", &self.allowed_publishers);
        formatter.field("code_signing_policies", &self.code_signing_policies);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`CodeSigningConfig`](crate::model::CodeSigningConfig)
pub mod code_signing_config {
    /// A builder for [`CodeSigningConfig`](crate::model::CodeSigningConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_id: std::option::Option<std::string::String>,
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
        pub(crate) code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifer for the Code signing configuration.</p>
        pub fn code_signing_config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_id = Some(input.into());
            self
        }
        /// <p>Unique identifer for the Code signing configuration.</p>
        pub fn set_code_signing_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>Code signing configuration description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Code signing configuration description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>List of allowed publishers.</p>
        pub fn allowed_publishers(mut self, input: crate::model::AllowedPublishers) -> Self {
            self.allowed_publishers = Some(input);
            self
        }
        /// <p>List of allowed publishers.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.allowed_publishers = input;
            self
        }
        /// <p>The code signing policy controls the validation failure action for signature mismatch or expiry.</p>
        pub fn code_signing_policies(mut self, input: crate::model::CodeSigningPolicies) -> Self {
            self.code_signing_policies = Some(input);
            self
        }
        /// <p>The code signing policy controls the validation failure action for signature mismatch or expiry.</p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.code_signing_policies = input;
            self
        }
        /// <p>The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD). </p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the Code signing configuration was last modified, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD). </p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigningConfig`](crate::model::CodeSigningConfig)
        pub fn build(self) -> crate::model::CodeSigningConfig {
            crate::model::CodeSigningConfig {
                code_signing_config_id: self.code_signing_config_id,
                code_signing_config_arn: self.code_signing_config_arn,
                description: self.description,
                allowed_publishers: self.allowed_publishers,
                code_signing_policies: self.code_signing_policies,
                last_modified: self.last_modified,
            }
        }
    }
}
impl CodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`CodeSigningConfig`](crate::model::CodeSigningConfig)
    pub fn builder() -> crate::model::code_signing_config::Builder {
        crate::model::code_signing_config::Builder::default()
    }
}

/// <p>Code signing configuration <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html#config-codesigning-policies">policies</a> specify the validation failure action for signature mismatch or
/// expiry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigningPolicies {
    /// <p>Code signing configuration policy for deployment validation failure. If you set the policy to
    /// <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
    /// policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
    /// <p>Default value: <code>Warn</code>
    /// </p>
    pub untrusted_artifact_on_deployment: std::option::Option<crate::model::CodeSigningPolicy>,
}
impl CodeSigningPolicies {
    /// <p>Code signing configuration policy for deployment validation failure. If you set the policy to
    /// <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
    /// policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
    /// <p>Default value: <code>Warn</code>
    /// </p>
    pub fn untrusted_artifact_on_deployment(
        &self,
    ) -> std::option::Option<&crate::model::CodeSigningPolicy> {
        self.untrusted_artifact_on_deployment.as_ref()
    }
}
impl std::fmt::Debug for CodeSigningPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigningPolicies");
        formatter.field(
            "untrusted_artifact_on_deployment",
            &self.untrusted_artifact_on_deployment,
        );
        formatter.finish()
    }
}
/// See [`CodeSigningPolicies`](crate::model::CodeSigningPolicies)
pub mod code_signing_policies {
    /// A builder for [`CodeSigningPolicies`](crate::model::CodeSigningPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) untrusted_artifact_on_deployment:
            std::option::Option<crate::model::CodeSigningPolicy>,
    }
    impl Builder {
        /// <p>Code signing configuration policy for deployment validation failure. If you set the policy to
        /// <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
        /// policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
        /// <p>Default value: <code>Warn</code>
        /// </p>
        pub fn untrusted_artifact_on_deployment(
            mut self,
            input: crate::model::CodeSigningPolicy,
        ) -> Self {
            self.untrusted_artifact_on_deployment = Some(input);
            self
        }
        /// <p>Code signing configuration policy for deployment validation failure. If you set the policy to
        /// <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
        /// policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
        /// <p>Default value: <code>Warn</code>
        /// </p>
        pub fn set_untrusted_artifact_on_deployment(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicy>,
        ) -> Self {
            self.untrusted_artifact_on_deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigningPolicies`](crate::model::CodeSigningPolicies)
        pub fn build(self) -> crate::model::CodeSigningPolicies {
            crate::model::CodeSigningPolicies {
                untrusted_artifact_on_deployment: self.untrusted_artifact_on_deployment,
            }
        }
    }
}
impl CodeSigningPolicies {
    /// Creates a new builder-style object to manufacture [`CodeSigningPolicies`](crate::model::CodeSigningPolicies)
    pub fn builder() -> crate::model::code_signing_policies::Builder {
        crate::model::code_signing_policies::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CodeSigningPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Enforce,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CodeSigningPolicy {
    fn from(s: &str) -> Self {
        match s {
            "Enforce" => CodeSigningPolicy::Enforce,
            "Warn" => CodeSigningPolicy::Warn,
            other => CodeSigningPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CodeSigningPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CodeSigningPolicy::from(s))
    }
}
impl CodeSigningPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CodeSigningPolicy::Enforce => "Enforce",
            CodeSigningPolicy::Warn => "Warn",
            CodeSigningPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Enforce", "Warn"]
    }
}
impl AsRef<str> for CodeSigningPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>List of signing profiles that can sign a code package. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllowedPublishers {
    /// <p>The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user
    /// who can sign a code package. </p>
    pub signing_profile_version_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AllowedPublishers {
    /// <p>The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user
    /// who can sign a code package. </p>
    pub fn signing_profile_version_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.signing_profile_version_arns.as_deref()
    }
}
impl std::fmt::Debug for AllowedPublishers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllowedPublishers");
        formatter.field(
            "signing_profile_version_arns",
            &self.signing_profile_version_arns,
        );
        formatter.finish()
    }
}
/// See [`AllowedPublishers`](crate::model::AllowedPublishers)
pub mod allowed_publishers {
    /// A builder for [`AllowedPublishers`](crate::model::AllowedPublishers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_profile_version_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `signing_profile_version_arns`.
        ///
        /// To override the contents of this collection use [`set_signing_profile_version_arns`](Self::set_signing_profile_version_arns).
        ///
        /// <p>The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user
        /// who can sign a code package. </p>
        pub fn signing_profile_version_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.signing_profile_version_arns.unwrap_or_default();
            v.push(input.into());
            self.signing_profile_version_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user
        /// who can sign a code package. </p>
        pub fn set_signing_profile_version_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.signing_profile_version_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`AllowedPublishers`](crate::model::AllowedPublishers)
        pub fn build(self) -> crate::model::AllowedPublishers {
            crate::model::AllowedPublishers {
                signing_profile_version_arns: self.signing_profile_version_arns,
            }
        }
    }
}
impl AllowedPublishers {
    /// Creates a new builder-style object to manufacture [`AllowedPublishers`](crate::model::AllowedPublishers)
    pub fn builder() -> crate::model::allowed_publishers::Builder {
        crate::model::allowed_publishers::Builder::default()
    }
}

/// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">traffic-shifting</a> configuration of a Lambda function alias.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AliasRoutingConfiguration {
    /// <p>The second version, and the percentage of traffic that's routed to it.</p>
    pub additional_version_weights:
        std::option::Option<std::collections::HashMap<std::string::String, f64>>,
}
impl AliasRoutingConfiguration {
    /// <p>The second version, and the percentage of traffic that's routed to it.</p>
    pub fn additional_version_weights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.additional_version_weights.as_ref()
    }
}
impl std::fmt::Debug for AliasRoutingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AliasRoutingConfiguration");
        formatter.field(
            "additional_version_weights",
            &self.additional_version_weights,
        );
        formatter.finish()
    }
}
/// See [`AliasRoutingConfiguration`](crate::model::AliasRoutingConfiguration)
pub mod alias_routing_configuration {
    /// A builder for [`AliasRoutingConfiguration`](crate::model::AliasRoutingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_version_weights:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    }
    impl Builder {
        /// Adds a key-value pair to `additional_version_weights`.
        ///
        /// To override the contents of this collection use [`set_additional_version_weights`](Self::set_additional_version_weights).
        ///
        /// <p>The second version, and the percentage of traffic that's routed to it.</p>
        pub fn additional_version_weights(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<f64>,
        ) -> Self {
            let mut hash_map = self.additional_version_weights.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_version_weights = Some(hash_map);
            self
        }
        /// <p>The second version, and the percentage of traffic that's routed to it.</p>
        pub fn set_additional_version_weights(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.additional_version_weights = input;
            self
        }
        /// Consumes the builder and constructs a [`AliasRoutingConfiguration`](crate::model::AliasRoutingConfiguration)
        pub fn build(self) -> crate::model::AliasRoutingConfiguration {
            crate::model::AliasRoutingConfiguration {
                additional_version_weights: self.additional_version_weights,
            }
        }
    }
}
impl AliasRoutingConfiguration {
    /// Creates a new builder-style object to manufacture [`AliasRoutingConfiguration`](crate::model::AliasRoutingConfiguration)
    pub fn builder() -> crate::model::alias_routing_configuration::Builder {
        crate::model::alias_routing_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedConcurrencyStatusEnum {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedConcurrencyStatusEnum {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ProvisionedConcurrencyStatusEnum::Failed,
            "IN_PROGRESS" => ProvisionedConcurrencyStatusEnum::InProgress,
            "READY" => ProvisionedConcurrencyStatusEnum::Ready,
            other => ProvisionedConcurrencyStatusEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedConcurrencyStatusEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedConcurrencyStatusEnum::from(s))
    }
}
impl ProvisionedConcurrencyStatusEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedConcurrencyStatusEnum::Failed => "FAILED",
            ProvisionedConcurrencyStatusEnum::InProgress => "IN_PROGRESS",
            ProvisionedConcurrencyStatusEnum::Ready => "READY",
            ProvisionedConcurrencyStatusEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "READY"]
    }
}
impl AsRef<str> for ProvisionedConcurrencyStatusEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
/// layer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerVersionContentOutput {
    /// <p>A link to the layer archive in Amazon S3 that is valid for 10 minutes.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash of the layer archive.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The size of the layer archive in bytes.</p>
    pub code_size: i64,
    /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
}
impl LayerVersionContentOutput {
    /// <p>A link to the layer archive in Amazon S3 that is valid for 10 minutes.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The SHA-256 hash of the layer archive.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The size of the layer archive in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
}
impl std::fmt::Debug for LayerVersionContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerVersionContentOutput");
        formatter.field("location", &self.location);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("code_size", &self.code_size);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.finish()
    }
}
/// See [`LayerVersionContentOutput`](crate::model::LayerVersionContentOutput)
pub mod layer_version_content_output {
    /// A builder for [`LayerVersionContentOutput`](crate::model::LayerVersionContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A link to the layer archive in Amazon S3 that is valid for 10 minutes.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A link to the layer archive in Amazon S3 that is valid for 10 minutes.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The SHA-256 hash of the layer archive.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash of the layer archive.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The size of the layer archive in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the layer archive in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN)  of a signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerVersionContentOutput`](crate::model::LayerVersionContentOutput)
        pub fn build(self) -> crate::model::LayerVersionContentOutput {
            crate::model::LayerVersionContentOutput {
                location: self.location,
                code_sha256: self.code_sha256,
                code_size: self.code_size.unwrap_or_default(),
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
            }
        }
    }
}
impl LayerVersionContentOutput {
    /// Creates a new builder-style object to manufacture [`LayerVersionContentOutput`](crate::model::LayerVersionContentOutput)
    pub fn builder() -> crate::model::layer_version_content_output::Builder {
        crate::model::layer_version_content_output::Builder::default()
    }
}

/// <p>A ZIP archive that contains the contents of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
/// layer</a>. You can specify either an Amazon S3 location,
/// or upload a layer archive directly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerVersionContentInput {
    /// <p>The Amazon S3 bucket of the layer archive.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 key of the layer archive.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>For versioned objects, the version of the layer archive object to use.</p>
    pub s3_object_version: std::option::Option<std::string::String>,
    /// <p>The base64-encoded contents of the layer archive. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
    /// you.</p>
    pub zip_file: std::option::Option<aws_smithy_types::Blob>,
}
impl LayerVersionContentInput {
    /// <p>The Amazon S3 bucket of the layer archive.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 key of the layer archive.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>For versioned objects, the version of the layer archive object to use.</p>
    pub fn s3_object_version(&self) -> std::option::Option<&str> {
        self.s3_object_version.as_deref()
    }
    /// <p>The base64-encoded contents of the layer archive. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
    /// you.</p>
    pub fn zip_file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.zip_file.as_ref()
    }
}
impl std::fmt::Debug for LayerVersionContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerVersionContentInput");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("s3_object_version", &self.s3_object_version);
        formatter.field("zip_file", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LayerVersionContentInput`](crate::model::LayerVersionContentInput)
pub mod layer_version_content_input {
    /// A builder for [`LayerVersionContentInput`](crate::model::LayerVersionContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) s3_object_version: std::option::Option<std::string::String>,
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket of the layer archive.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket of the layer archive.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 key of the layer archive.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 key of the layer archive.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>For versioned objects, the version of the layer archive object to use.</p>
        pub fn s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_object_version = Some(input.into());
            self
        }
        /// <p>For versioned objects, the version of the layer archive object to use.</p>
        pub fn set_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_object_version = input;
            self
        }
        /// <p>The base64-encoded contents of the layer archive. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>The base64-encoded contents of the layer archive. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerVersionContentInput`](crate::model::LayerVersionContentInput)
        pub fn build(self) -> crate::model::LayerVersionContentInput {
            crate::model::LayerVersionContentInput {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                s3_object_version: self.s3_object_version,
                zip_file: self.zip_file,
            }
        }
    }
}
impl LayerVersionContentInput {
    /// Creates a new builder-style object to manufacture [`LayerVersionContentInput`](crate::model::LayerVersionContentInput)
    pub fn builder() -> crate::model::layer_version_content_input::Builder {
        crate::model::layer_version_content_input::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionConfiguration {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed CMK.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the master function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl FunctionConfiguration {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed CMK.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the master function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for FunctionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionConfiguration");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`FunctionConfiguration`](crate::model::FunctionConfiguration)
pub mod function_configuration {
    /// A builder for [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed CMK.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed CMK.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the master function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the master function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionConfiguration`](crate::model::FunctionConfiguration)
        pub fn build(self) -> crate::model::FunctionConfiguration {
            crate::model::FunctionConfiguration {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl FunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    pub fn builder() -> crate::model::function_configuration::Builder {
        crate::model::function_configuration::Builder::default()
    }
}

/// <p>Details about the provisioned concurrency configuration for a function alias or version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedConcurrencyConfigListItem {
    /// <p>The Amazon Resource Name (ARN) of the alias or version.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The amount of provisioned concurrency requested.</p>
    pub requested_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency available.</p>
    pub available_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub allocated_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The status of the allocation process.</p>
    pub status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub last_modified: std::option::Option<std::string::String>,
}
impl ProvisionedConcurrencyConfigListItem {
    /// <p>The Amazon Resource Name (ARN) of the alias or version.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The amount of provisioned concurrency requested.</p>
    pub fn requested_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.requested_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency available.</p>
    pub fn available_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.available_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub fn allocated_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.allocated_provisioned_concurrent_executions
    }
    /// <p>The status of the allocation process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProvisionedConcurrencyStatusEnum> {
        self.status.as_ref()
    }
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
}
impl std::fmt::Debug for ProvisionedConcurrencyConfigListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedConcurrencyConfigListItem");
        formatter.field("function_arn", &self.function_arn);
        formatter.field(
            "requested_provisioned_concurrent_executions",
            &self.requested_provisioned_concurrent_executions,
        );
        formatter.field(
            "available_provisioned_concurrent_executions",
            &self.available_provisioned_concurrent_executions,
        );
        formatter.field(
            "allocated_provisioned_concurrent_executions",
            &self.allocated_provisioned_concurrent_executions,
        );
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`ProvisionedConcurrencyConfigListItem`](crate::model::ProvisionedConcurrencyConfigListItem)
pub mod provisioned_concurrency_config_list_item {
    /// A builder for [`ProvisionedConcurrencyConfigListItem`](crate::model::ProvisionedConcurrencyConfigListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) requested_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) available_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) allocated_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the alias or version.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alias or version.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn requested_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.requested_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn set_requested_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.requested_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn available_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.available_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn set_available_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.available_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn allocated_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.allocated_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn set_allocated_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocated_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn status(mut self, input: crate::model::ProvisionedConcurrencyStatusEnum) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedConcurrencyConfigListItem`](crate::model::ProvisionedConcurrencyConfigListItem)
        pub fn build(self) -> crate::model::ProvisionedConcurrencyConfigListItem {
            crate::model::ProvisionedConcurrencyConfigListItem {
                function_arn: self.function_arn,
                requested_provisioned_concurrent_executions: self
                    .requested_provisioned_concurrent_executions,
                available_provisioned_concurrent_executions: self
                    .available_provisioned_concurrent_executions,
                allocated_provisioned_concurrent_executions: self
                    .allocated_provisioned_concurrent_executions,
                status: self.status,
                status_reason: self.status_reason,
                last_modified: self.last_modified,
            }
        }
    }
}
impl ProvisionedConcurrencyConfigListItem {
    /// Creates a new builder-style object to manufacture [`ProvisionedConcurrencyConfigListItem`](crate::model::ProvisionedConcurrencyConfigListItem)
    pub fn builder() -> crate::model::provisioned_concurrency_config_list_item::Builder {
        crate::model::provisioned_concurrency_config_list_item::Builder::default()
    }
}

/// <p>Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
/// layer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerVersionsListItem {
    /// <p>The ARN of the layer version.</p>
    pub layer_version_arn: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version: i64,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>.</p>
    pub created_date: std::option::Option<std::string::String>,
    /// <p>The layer's compatible runtimes.</p>
    pub compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
    /// <p>The layer's open-source license.</p>
    pub license_info: std::option::Option<std::string::String>,
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub compatible_architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl LayerVersionsListItem {
    /// <p>The ARN of the layer version.</p>
    pub fn layer_version_arn(&self) -> std::option::Option<&str> {
        self.layer_version_arn.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The description of the version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>.</p>
    pub fn created_date(&self) -> std::option::Option<&str> {
        self.created_date.as_deref()
    }
    /// <p>The layer's compatible runtimes.</p>
    pub fn compatible_runtimes(&self) -> std::option::Option<&[crate::model::Runtime]> {
        self.compatible_runtimes.as_deref()
    }
    /// <p>The layer's open-source license.</p>
    pub fn license_info(&self) -> std::option::Option<&str> {
        self.license_info.as_deref()
    }
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub fn compatible_architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.compatible_architectures.as_deref()
    }
}
impl std::fmt::Debug for LayerVersionsListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerVersionsListItem");
        formatter.field("layer_version_arn", &self.layer_version_arn);
        formatter.field("version", &self.version);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("compatible_runtimes", &self.compatible_runtimes);
        formatter.field("license_info", &self.license_info);
        formatter.field("compatible_architectures", &self.compatible_architectures);
        formatter.finish()
    }
}
/// See [`LayerVersionsListItem`](crate::model::LayerVersionsListItem)
pub mod layer_versions_list_item {
    /// A builder for [`LayerVersionsListItem`](crate::model::LayerVersionsListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_version_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<std::string::String>,
        pub(crate) compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        pub(crate) license_info: std::option::Option<std::string::String>,
        pub(crate) compatible_architectures:
            std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The ARN of the layer version.</p>
        pub fn layer_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_layer_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.layer_version_arn = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>.</p>
        pub fn created_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_date = Some(input.into());
            self
        }
        /// <p>The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>.</p>
        pub fn set_created_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_date = input;
            self
        }
        /// Appends an item to `compatible_runtimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>The layer's compatible runtimes.</p>
        pub fn compatible_runtimes(mut self, input: impl Into<crate::model::Runtime>) -> Self {
            let mut v = self.compatible_runtimes.unwrap_or_default();
            v.push(input.into());
            self.compatible_runtimes = Some(v);
            self
        }
        /// <p>The layer's compatible runtimes.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.compatible_runtimes = input;
            self
        }
        /// <p>The layer's open-source license.</p>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_info = Some(input.into());
            self
        }
        /// <p>The layer's open-source license.</p>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_info = input;
            self
        }
        /// Appends an item to `compatible_architectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(
            mut self,
            input: impl Into<crate::model::Architecture>,
        ) -> Self {
            let mut v = self.compatible_architectures.unwrap_or_default();
            v.push(input.into());
            self.compatible_architectures = Some(v);
            self
        }
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.compatible_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerVersionsListItem`](crate::model::LayerVersionsListItem)
        pub fn build(self) -> crate::model::LayerVersionsListItem {
            crate::model::LayerVersionsListItem {
                layer_version_arn: self.layer_version_arn,
                version: self.version.unwrap_or_default(),
                description: self.description,
                created_date: self.created_date,
                compatible_runtimes: self.compatible_runtimes,
                license_info: self.license_info,
                compatible_architectures: self.compatible_architectures,
            }
        }
    }
}
impl LayerVersionsListItem {
    /// Creates a new builder-style object to manufacture [`LayerVersionsListItem`](crate::model::LayerVersionsListItem)
    pub fn builder() -> crate::model::layer_versions_list_item::Builder {
        crate::model::layer_versions_list_item::Builder::default()
    }
}

/// <p>Details about an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
/// layer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayersListItem {
    /// <p>The name of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
    pub layer_arn: std::option::Option<std::string::String>,
    /// <p>The newest version of the layer.</p>
    pub latest_matching_version: std::option::Option<crate::model::LayerVersionsListItem>,
}
impl LayersListItem {
    /// <p>The name of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
    pub fn layer_arn(&self) -> std::option::Option<&str> {
        self.layer_arn.as_deref()
    }
    /// <p>The newest version of the layer.</p>
    pub fn latest_matching_version(
        &self,
    ) -> std::option::Option<&crate::model::LayerVersionsListItem> {
        self.latest_matching_version.as_ref()
    }
}
impl std::fmt::Debug for LayersListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayersListItem");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("layer_arn", &self.layer_arn);
        formatter.field("latest_matching_version", &self.latest_matching_version);
        formatter.finish()
    }
}
/// See [`LayersListItem`](crate::model::LayersListItem)
pub mod layers_list_item {
    /// A builder for [`LayersListItem`](crate::model::LayersListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) layer_arn: std::option::Option<std::string::String>,
        pub(crate) latest_matching_version:
            std::option::Option<crate::model::LayerVersionsListItem>,
    }
    impl Builder {
        /// <p>The name of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
        pub fn layer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function layer.</p>
        pub fn set_layer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_arn = input;
            self
        }
        /// <p>The newest version of the layer.</p>
        pub fn latest_matching_version(
            mut self,
            input: crate::model::LayerVersionsListItem,
        ) -> Self {
            self.latest_matching_version = Some(input);
            self
        }
        /// <p>The newest version of the layer.</p>
        pub fn set_latest_matching_version(
            mut self,
            input: std::option::Option<crate::model::LayerVersionsListItem>,
        ) -> Self {
            self.latest_matching_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LayersListItem`](crate::model::LayersListItem)
        pub fn build(self) -> crate::model::LayersListItem {
            crate::model::LayersListItem {
                layer_name: self.layer_name,
                layer_arn: self.layer_arn,
                latest_matching_version: self.latest_matching_version,
            }
        }
    }
}
impl LayersListItem {
    /// Creates a new builder-style object to manufacture [`LayersListItem`](crate::model::LayersListItem)
    pub fn builder() -> crate::model::layers_list_item::Builder {
        crate::model::layers_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FunctionVersion {
    #[allow(missing_docs)] // documentation missing in model
    All,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FunctionVersion {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => FunctionVersion::All,
            other => FunctionVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FunctionVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FunctionVersion::from(s))
    }
}
impl FunctionVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FunctionVersion::All => "ALL",
            FunctionVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL"]
    }
}
impl AsRef<str> for FunctionVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionEventInvokeConfig {
    /// <p>The date and time that the configuration was last updated.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl FunctionEventInvokeConfig {
    /// <p>The date and time that the configuration was last updated.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for FunctionEventInvokeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionEventInvokeConfig");
        formatter.field("last_modified", &self.last_modified);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}
/// See [`FunctionEventInvokeConfig`](crate::model::FunctionEventInvokeConfig)
pub mod function_event_invoke_config {
    /// A builder for [`FunctionEventInvokeConfig`](crate::model::FunctionEventInvokeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionEventInvokeConfig`](crate::model::FunctionEventInvokeConfig)
        pub fn build(self) -> crate::model::FunctionEventInvokeConfig {
            crate::model::FunctionEventInvokeConfig {
                last_modified: self.last_modified,
                function_arn: self.function_arn,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            }
        }
    }
}
impl FunctionEventInvokeConfig {
    /// Creates a new builder-style object to manufacture [`FunctionEventInvokeConfig`](crate::model::FunctionEventInvokeConfig)
    pub fn builder() -> crate::model::function_event_invoke_config::Builder {
        crate::model::function_event_invoke_config::Builder::default()
    }
}

/// <p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSourceMappingConfiguration {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub last_processing_result: std::option::Option<std::string::String>,
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl EventSourceMappingConfiguration {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub fn last_processing_result(&self) -> std::option::Option<&str> {
        self.last_processing_result.as_deref()
    }
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for EventSourceMappingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSourceMappingConfiguration");
        formatter.field("uuid", &self.uuid);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("batch_size", &self.batch_size);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_processing_result", &self.last_processing_result);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("destination_config", &self.destination_config);
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}
/// See [`EventSourceMappingConfiguration`](crate::model::EventSourceMappingConfiguration)
pub mod event_source_mapping_configuration {
    /// A builder for [`EventSourceMappingConfiguration`](crate::model::EventSourceMappingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_processing_result: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn last_processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_processing_result = Some(input.into());
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn set_last_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_processing_result = input;
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input.into());
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input.into());
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSourceMappingConfiguration`](crate::model::EventSourceMappingConfiguration)
        pub fn build(self) -> crate::model::EventSourceMappingConfiguration {
            crate::model::EventSourceMappingConfiguration {
                uuid: self.uuid,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                batch_size: self.batch_size,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                event_source_arn: self.event_source_arn,
                function_arn: self.function_arn,
                last_modified: self.last_modified,
                last_processing_result: self.last_processing_result,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                destination_config: self.destination_config,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            }
        }
    }
}
impl EventSourceMappingConfiguration {
    /// Creates a new builder-style object to manufacture [`EventSourceMappingConfiguration`](crate::model::EventSourceMappingConfiguration)
    pub fn builder() -> crate::model::event_source_mapping_configuration::Builder {
        crate::model::event_source_mapping_configuration::Builder::default()
    }
}

/// <p>Provides configuration information about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AliasConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl AliasConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for AliasConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AliasConfiguration");
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`AliasConfiguration`](crate::model::AliasConfiguration)
pub mod alias_configuration {
    /// A builder for [`AliasConfiguration`](crate::model::AliasConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AliasConfiguration`](crate::model::AliasConfiguration)
        pub fn build(self) -> crate::model::AliasConfiguration {
            crate::model::AliasConfiguration {
                alias_arn: self.alias_arn,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
                revision_id: self.revision_id,
            }
        }
    }
}
impl AliasConfiguration {
    /// Creates a new builder-style object to manufacture [`AliasConfiguration`](crate::model::AliasConfiguration)
    pub fn builder() -> crate::model::alias_configuration::Builder {
        crate::model::alias_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Tail,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "None" => LogType::None,
            "Tail" => LogType::Tail,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::None => "None",
            LogType::Tail => "Tail",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["None", "Tail"]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvocationType {
    #[allow(missing_docs)] // documentation missing in model
    DryRun,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    RequestResponse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvocationType {
    fn from(s: &str) -> Self {
        match s {
            "DryRun" => InvocationType::DryRun,
            "Event" => InvocationType::Event,
            "RequestResponse" => InvocationType::RequestResponse,
            other => InvocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvocationType::from(s))
    }
}
impl InvocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvocationType::DryRun => "DryRun",
            InvocationType::Event => "Event",
            InvocationType::RequestResponse => "RequestResponse",
            InvocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DryRun", "Event", "RequestResponse"]
    }
}
impl AsRef<str> for InvocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Concurrency {
    /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
    pub reserved_concurrent_executions: std::option::Option<i32>,
}
impl Concurrency {
    /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
    pub fn reserved_concurrent_executions(&self) -> std::option::Option<i32> {
        self.reserved_concurrent_executions
    }
}
impl std::fmt::Debug for Concurrency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Concurrency");
        formatter.field(
            "reserved_concurrent_executions",
            &self.reserved_concurrent_executions,
        );
        formatter.finish()
    }
}
/// See [`Concurrency`](crate::model::Concurrency)
pub mod concurrency {
    /// A builder for [`Concurrency`](crate::model::Concurrency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
        pub fn reserved_concurrent_executions(mut self, input: i32) -> Self {
            self.reserved_concurrent_executions = Some(input);
            self
        }
        /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reserved_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`Concurrency`](crate::model::Concurrency)
        pub fn build(self) -> crate::model::Concurrency {
            crate::model::Concurrency {
                reserved_concurrent_executions: self.reserved_concurrent_executions,
            }
        }
    }
}
impl Concurrency {
    /// Creates a new builder-style object to manufacture [`Concurrency`](crate::model::Concurrency)
    pub fn builder() -> crate::model::concurrency::Builder {
        crate::model::concurrency::Builder::default()
    }
}

/// <p>Details about a function's deployment package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionCodeLocation {
    /// <p>The service that's hosting the file.</p>
    pub repository_type: std::option::Option<std::string::String>,
    /// <p>A presigned URL that you can use to download the deployment package.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>URI of a container image in the Amazon ECR registry.</p>
    pub image_uri: std::option::Option<std::string::String>,
    /// <p>The resolved URI for the image.</p>
    pub resolved_image_uri: std::option::Option<std::string::String>,
}
impl FunctionCodeLocation {
    /// <p>The service that's hosting the file.</p>
    pub fn repository_type(&self) -> std::option::Option<&str> {
        self.repository_type.as_deref()
    }
    /// <p>A presigned URL that you can use to download the deployment package.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>URI of a container image in the Amazon ECR registry.</p>
    pub fn image_uri(&self) -> std::option::Option<&str> {
        self.image_uri.as_deref()
    }
    /// <p>The resolved URI for the image.</p>
    pub fn resolved_image_uri(&self) -> std::option::Option<&str> {
        self.resolved_image_uri.as_deref()
    }
}
impl std::fmt::Debug for FunctionCodeLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionCodeLocation");
        formatter.field("repository_type", &self.repository_type);
        formatter.field("location", &self.location);
        formatter.field("image_uri", &self.image_uri);
        formatter.field("resolved_image_uri", &self.resolved_image_uri);
        formatter.finish()
    }
}
/// See [`FunctionCodeLocation`](crate::model::FunctionCodeLocation)
pub mod function_code_location {
    /// A builder for [`FunctionCodeLocation`](crate::model::FunctionCodeLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_type: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) image_uri: std::option::Option<std::string::String>,
        pub(crate) resolved_image_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service that's hosting the file.</p>
        pub fn repository_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_type = Some(input.into());
            self
        }
        /// <p>The service that's hosting the file.</p>
        pub fn set_repository_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_type = input;
            self
        }
        /// <p>A presigned URL that you can use to download the deployment package.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A presigned URL that you can use to download the deployment package.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_uri = Some(input.into());
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_uri = input;
            self
        }
        /// <p>The resolved URI for the image.</p>
        pub fn resolved_image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_image_uri = Some(input.into());
            self
        }
        /// <p>The resolved URI for the image.</p>
        pub fn set_resolved_image_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_image_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionCodeLocation`](crate::model::FunctionCodeLocation)
        pub fn build(self) -> crate::model::FunctionCodeLocation {
            crate::model::FunctionCodeLocation {
                repository_type: self.repository_type,
                location: self.location,
                image_uri: self.image_uri,
                resolved_image_uri: self.resolved_image_uri,
            }
        }
    }
}
impl FunctionCodeLocation {
    /// Creates a new builder-style object to manufacture [`FunctionCodeLocation`](crate::model::FunctionCodeLocation)
    pub fn builder() -> crate::model::function_code_location::Builder {
        crate::model::function_code_location::Builder::default()
    }
}

/// <p>The number of functions and amount of storage in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountUsage {
    /// <p>The amount of storage space, in bytes, that's being used by deployment packages and layer archives.</p>
    pub total_code_size: i64,
    /// <p>The number of Lambda functions.</p>
    pub function_count: i64,
}
impl AccountUsage {
    /// <p>The amount of storage space, in bytes, that's being used by deployment packages and layer archives.</p>
    pub fn total_code_size(&self) -> i64 {
        self.total_code_size
    }
    /// <p>The number of Lambda functions.</p>
    pub fn function_count(&self) -> i64 {
        self.function_count
    }
}
impl std::fmt::Debug for AccountUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountUsage");
        formatter.field("total_code_size", &self.total_code_size);
        formatter.field("function_count", &self.function_count);
        formatter.finish()
    }
}
/// See [`AccountUsage`](crate::model::AccountUsage)
pub mod account_usage {
    /// A builder for [`AccountUsage`](crate::model::AccountUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_code_size: std::option::Option<i64>,
        pub(crate) function_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The amount of storage space, in bytes, that's being used by deployment packages and layer archives.</p>
        pub fn total_code_size(mut self, input: i64) -> Self {
            self.total_code_size = Some(input);
            self
        }
        /// <p>The amount of storage space, in bytes, that's being used by deployment packages and layer archives.</p>
        pub fn set_total_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.total_code_size = input;
            self
        }
        /// <p>The number of Lambda functions.</p>
        pub fn function_count(mut self, input: i64) -> Self {
            self.function_count = Some(input);
            self
        }
        /// <p>The number of Lambda functions.</p>
        pub fn set_function_count(mut self, input: std::option::Option<i64>) -> Self {
            self.function_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountUsage`](crate::model::AccountUsage)
        pub fn build(self) -> crate::model::AccountUsage {
            crate::model::AccountUsage {
                total_code_size: self.total_code_size.unwrap_or_default(),
                function_count: self.function_count.unwrap_or_default(),
            }
        }
    }
}
impl AccountUsage {
    /// Creates a new builder-style object to manufacture [`AccountUsage`](crate::model::AccountUsage)
    pub fn builder() -> crate::model::account_usage::Builder {
        crate::model::account_usage::Builder::default()
    }
}

/// <p>Limits that are related to concurrency and storage. All file and storage sizes are in bytes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLimit {
    /// <p>The amount of storage space that you can use for all deployment packages and layer archives.</p>
    pub total_code_size: i64,
    /// <p>The maximum size of a function's deployment package and layers when they're extracted.</p>
    pub code_size_unzipped: i64,
    /// <p>The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger
    /// files.</p>
    pub code_size_zipped: i64,
    /// <p>The maximum number of simultaneous function executions.</p>
    pub concurrent_executions: i32,
    /// <p>The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
    /// functions with <a>PutFunctionConcurrency</a>.</p>
    pub unreserved_concurrent_executions: std::option::Option<i32>,
}
impl AccountLimit {
    /// <p>The amount of storage space that you can use for all deployment packages and layer archives.</p>
    pub fn total_code_size(&self) -> i64 {
        self.total_code_size
    }
    /// <p>The maximum size of a function's deployment package and layers when they're extracted.</p>
    pub fn code_size_unzipped(&self) -> i64 {
        self.code_size_unzipped
    }
    /// <p>The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger
    /// files.</p>
    pub fn code_size_zipped(&self) -> i64 {
        self.code_size_zipped
    }
    /// <p>The maximum number of simultaneous function executions.</p>
    pub fn concurrent_executions(&self) -> i32 {
        self.concurrent_executions
    }
    /// <p>The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
    /// functions with <a>PutFunctionConcurrency</a>.</p>
    pub fn unreserved_concurrent_executions(&self) -> std::option::Option<i32> {
        self.unreserved_concurrent_executions
    }
}
impl std::fmt::Debug for AccountLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLimit");
        formatter.field("total_code_size", &self.total_code_size);
        formatter.field("code_size_unzipped", &self.code_size_unzipped);
        formatter.field("code_size_zipped", &self.code_size_zipped);
        formatter.field("concurrent_executions", &self.concurrent_executions);
        formatter.field(
            "unreserved_concurrent_executions",
            &self.unreserved_concurrent_executions,
        );
        formatter.finish()
    }
}
/// See [`AccountLimit`](crate::model::AccountLimit)
pub mod account_limit {
    /// A builder for [`AccountLimit`](crate::model::AccountLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_code_size: std::option::Option<i64>,
        pub(crate) code_size_unzipped: std::option::Option<i64>,
        pub(crate) code_size_zipped: std::option::Option<i64>,
        pub(crate) concurrent_executions: std::option::Option<i32>,
        pub(crate) unreserved_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of storage space that you can use for all deployment packages and layer archives.</p>
        pub fn total_code_size(mut self, input: i64) -> Self {
            self.total_code_size = Some(input);
            self
        }
        /// <p>The amount of storage space that you can use for all deployment packages and layer archives.</p>
        pub fn set_total_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.total_code_size = input;
            self
        }
        /// <p>The maximum size of a function's deployment package and layers when they're extracted.</p>
        pub fn code_size_unzipped(mut self, input: i64) -> Self {
            self.code_size_unzipped = Some(input);
            self
        }
        /// <p>The maximum size of a function's deployment package and layers when they're extracted.</p>
        pub fn set_code_size_unzipped(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size_unzipped = input;
            self
        }
        /// <p>The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger
        /// files.</p>
        pub fn code_size_zipped(mut self, input: i64) -> Self {
            self.code_size_zipped = Some(input);
            self
        }
        /// <p>The maximum size of a deployment package when it's uploaded directly to Lambda. Use Amazon S3 for larger
        /// files.</p>
        pub fn set_code_size_zipped(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size_zipped = input;
            self
        }
        /// <p>The maximum number of simultaneous function executions.</p>
        pub fn concurrent_executions(mut self, input: i32) -> Self {
            self.concurrent_executions = Some(input);
            self
        }
        /// <p>The maximum number of simultaneous function executions.</p>
        pub fn set_concurrent_executions(mut self, input: std::option::Option<i32>) -> Self {
            self.concurrent_executions = input;
            self
        }
        /// <p>The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
        /// functions with <a>PutFunctionConcurrency</a>.</p>
        pub fn unreserved_concurrent_executions(mut self, input: i32) -> Self {
            self.unreserved_concurrent_executions = Some(input);
            self
        }
        /// <p>The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
        /// functions with <a>PutFunctionConcurrency</a>.</p>
        pub fn set_unreserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.unreserved_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLimit`](crate::model::AccountLimit)
        pub fn build(self) -> crate::model::AccountLimit {
            crate::model::AccountLimit {
                total_code_size: self.total_code_size.unwrap_or_default(),
                code_size_unzipped: self.code_size_unzipped.unwrap_or_default(),
                code_size_zipped: self.code_size_zipped.unwrap_or_default(),
                concurrent_executions: self.concurrent_executions.unwrap_or_default(),
                unreserved_concurrent_executions: self.unreserved_concurrent_executions,
            }
        }
    }
}
impl AccountLimit {
    /// Creates a new builder-style object to manufacture [`AccountLimit`](crate::model::AccountLimit)
    pub fn builder() -> crate::model::account_limit::Builder {
        crate::model::account_limit::Builder::default()
    }
}

/// <p>The code for the Lambda function. You can specify either an object in Amazon S3, upload a .zip file archive deployment
/// package directly, or specify the URI of a container image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionCode {
    /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
    /// you.</p>
    pub zip_file: std::option::Option<aws_smithy_types::Blob>,
    /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 key of the deployment package.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>For versioned objects, the version of the deployment package object to use.</p>
    pub s3_object_version: std::option::Option<std::string::String>,
    /// <p>URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p>
    pub image_uri: std::option::Option<std::string::String>,
}
impl FunctionCode {
    /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
    /// you.</p>
    pub fn zip_file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.zip_file.as_ref()
    }
    /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 key of the deployment package.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>For versioned objects, the version of the deployment package object to use.</p>
    pub fn s3_object_version(&self) -> std::option::Option<&str> {
        self.s3_object_version.as_deref()
    }
    /// <p>URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p>
    pub fn image_uri(&self) -> std::option::Option<&str> {
        self.image_uri.as_deref()
    }
}
impl std::fmt::Debug for FunctionCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionCode");
        formatter.field("zip_file", &"*** Sensitive Data Redacted ***");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("s3_object_version", &self.s3_object_version);
        formatter.field("image_uri", &self.image_uri);
        formatter.finish()
    }
}
/// See [`FunctionCode`](crate::model::FunctionCode)
pub mod function_code {
    /// A builder for [`FunctionCode`](crate::model::FunctionCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) s3_object_version: std::option::Option<std::string::String>,
        pub(crate) image_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_object_version = Some(input.into());
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn set_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_object_version = input;
            self
        }
        /// <p>URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p>
        pub fn image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_uri = Some(input.into());
            self
        }
        /// <p>URI of a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR registry.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionCode`](crate::model::FunctionCode)
        pub fn build(self) -> crate::model::FunctionCode {
            crate::model::FunctionCode {
                zip_file: self.zip_file,
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                s3_object_version: self.s3_object_version,
                image_uri: self.image_uri,
            }
        }
    }
}
impl FunctionCode {
    /// Creates a new builder-style object to manufacture [`FunctionCode`](crate::model::FunctionCode)
    pub fn builder() -> crate::model::function_code::Builder {
        crate::model::function_code::Builder::default()
    }
}
