// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddLFTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_lf_tags_to_resource`](crate::client::Client::add_lf_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddLFTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddLFTagsToResource {
    _private: (),
}
impl AddLFTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddLfTagsToResourceInput`](crate::input::AddLfTagsToResourceInput)
    pub fn builder() -> crate::input::add_lf_tags_to_resource_input::Builder {
        crate::input::add_lf_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddLFTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddLFTagsToResource {
    type Output = std::result::Result<
        crate::output::AddLfTagsToResourceOutput,
        crate::error::AddLFTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_lf_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_lf_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `BatchGrantPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_grant_permissions`](crate::client::Client::batch_grant_permissions).
///
/// See [`crate::client::fluent_builders::BatchGrantPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGrantPermissions {
    _private: (),
}
impl BatchGrantPermissions {
    /// Creates a new builder-style object to manufacture [`BatchGrantPermissionsInput`](crate::input::BatchGrantPermissionsInput)
    pub fn builder() -> crate::input::batch_grant_permissions_input::Builder {
        crate::input::batch_grant_permissions_input::Builder::default()
    }
    /// Creates a new `BatchGrantPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGrantPermissions {
    type Output = std::result::Result<
        crate::output::BatchGrantPermissionsOutput,
        crate::error::BatchGrantPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_grant_permissions_error(response)
        } else {
            crate::operation_deser::parse_batch_grant_permissions_response(response)
        }
    }
}

/// Operation shape for `BatchRevokePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_revoke_permissions`](crate::client::Client::batch_revoke_permissions).
///
/// See [`crate::client::fluent_builders::BatchRevokePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchRevokePermissions {
    _private: (),
}
impl BatchRevokePermissions {
    /// Creates a new builder-style object to manufacture [`BatchRevokePermissionsInput`](crate::input::BatchRevokePermissionsInput)
    pub fn builder() -> crate::input::batch_revoke_permissions_input::Builder {
        crate::input::batch_revoke_permissions_input::Builder::default()
    }
    /// Creates a new `BatchRevokePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchRevokePermissions {
    type Output = std::result::Result<
        crate::output::BatchRevokePermissionsOutput,
        crate::error::BatchRevokePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_revoke_permissions_error(response)
        } else {
            crate::operation_deser::parse_batch_revoke_permissions_response(response)
        }
    }
}

/// Operation shape for `CancelTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_transaction`](crate::client::Client::cancel_transaction).
///
/// See [`crate::client::fluent_builders::CancelTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelTransaction {
    _private: (),
}
impl CancelTransaction {
    /// Creates a new builder-style object to manufacture [`CancelTransactionInput`](crate::input::CancelTransactionInput)
    pub fn builder() -> crate::input::cancel_transaction_input::Builder {
        crate::input::cancel_transaction_input::Builder::default()
    }
    /// Creates a new `CancelTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelTransaction {
    type Output = std::result::Result<
        crate::output::CancelTransactionOutput,
        crate::error::CancelTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_transaction_error(response)
        } else {
            crate::operation_deser::parse_cancel_transaction_response(response)
        }
    }
}

/// Operation shape for `CommitTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`commit_transaction`](crate::client::Client::commit_transaction).
///
/// See [`crate::client::fluent_builders::CommitTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CommitTransaction {
    _private: (),
}
impl CommitTransaction {
    /// Creates a new builder-style object to manufacture [`CommitTransactionInput`](crate::input::CommitTransactionInput)
    pub fn builder() -> crate::input::commit_transaction_input::Builder {
        crate::input::commit_transaction_input::Builder::default()
    }
    /// Creates a new `CommitTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CommitTransaction {
    type Output = std::result::Result<
        crate::output::CommitTransactionOutput,
        crate::error::CommitTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_commit_transaction_error(response)
        } else {
            crate::operation_deser::parse_commit_transaction_response(response)
        }
    }
}

/// Operation shape for `CreateDataCellsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_cells_filter`](crate::client::Client::create_data_cells_filter).
///
/// See [`crate::client::fluent_builders::CreateDataCellsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataCellsFilter {
    _private: (),
}
impl CreateDataCellsFilter {
    /// Creates a new builder-style object to manufacture [`CreateDataCellsFilterInput`](crate::input::CreateDataCellsFilterInput)
    pub fn builder() -> crate::input::create_data_cells_filter_input::Builder {
        crate::input::create_data_cells_filter_input::Builder::default()
    }
    /// Creates a new `CreateDataCellsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataCellsFilter {
    type Output = std::result::Result<
        crate::output::CreateDataCellsFilterOutput,
        crate::error::CreateDataCellsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_cells_filter_error(response)
        } else {
            crate::operation_deser::parse_create_data_cells_filter_response(response)
        }
    }
}

/// Operation shape for `CreateLFTag`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_lf_tag`](crate::client::Client::create_lf_tag).
///
/// See [`crate::client::fluent_builders::CreateLFTag`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLFTag {
    _private: (),
}
impl CreateLFTag {
    /// Creates a new builder-style object to manufacture [`CreateLfTagInput`](crate::input::CreateLfTagInput)
    pub fn builder() -> crate::input::create_lf_tag_input::Builder {
        crate::input::create_lf_tag_input::Builder::default()
    }
    /// Creates a new `CreateLFTag` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLFTag {
    type Output =
        std::result::Result<crate::output::CreateLfTagOutput, crate::error::CreateLFTagError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_lf_tag_error(response)
        } else {
            crate::operation_deser::parse_create_lf_tag_response(response)
        }
    }
}

/// Operation shape for `DeleteDataCellsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_cells_filter`](crate::client::Client::delete_data_cells_filter).
///
/// See [`crate::client::fluent_builders::DeleteDataCellsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataCellsFilter {
    _private: (),
}
impl DeleteDataCellsFilter {
    /// Creates a new builder-style object to manufacture [`DeleteDataCellsFilterInput`](crate::input::DeleteDataCellsFilterInput)
    pub fn builder() -> crate::input::delete_data_cells_filter_input::Builder {
        crate::input::delete_data_cells_filter_input::Builder::default()
    }
    /// Creates a new `DeleteDataCellsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataCellsFilter {
    type Output = std::result::Result<
        crate::output::DeleteDataCellsFilterOutput,
        crate::error::DeleteDataCellsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_cells_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_data_cells_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteLFTag`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lf_tag`](crate::client::Client::delete_lf_tag).
///
/// See [`crate::client::fluent_builders::DeleteLFTag`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLFTag {
    _private: (),
}
impl DeleteLFTag {
    /// Creates a new builder-style object to manufacture [`DeleteLfTagInput`](crate::input::DeleteLfTagInput)
    pub fn builder() -> crate::input::delete_lf_tag_input::Builder {
        crate::input::delete_lf_tag_input::Builder::default()
    }
    /// Creates a new `DeleteLFTag` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLFTag {
    type Output =
        std::result::Result<crate::output::DeleteLfTagOutput, crate::error::DeleteLFTagError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lf_tag_error(response)
        } else {
            crate::operation_deser::parse_delete_lf_tag_response(response)
        }
    }
}

/// Operation shape for `DeleteObjectsOnCancel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_objects_on_cancel`](crate::client::Client::delete_objects_on_cancel).
///
/// See [`crate::client::fluent_builders::DeleteObjectsOnCancel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteObjectsOnCancel {
    _private: (),
}
impl DeleteObjectsOnCancel {
    /// Creates a new builder-style object to manufacture [`DeleteObjectsOnCancelInput`](crate::input::DeleteObjectsOnCancelInput)
    pub fn builder() -> crate::input::delete_objects_on_cancel_input::Builder {
        crate::input::delete_objects_on_cancel_input::Builder::default()
    }
    /// Creates a new `DeleteObjectsOnCancel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteObjectsOnCancel {
    type Output = std::result::Result<
        crate::output::DeleteObjectsOnCancelOutput,
        crate::error::DeleteObjectsOnCancelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_objects_on_cancel_error(response)
        } else {
            crate::operation_deser::parse_delete_objects_on_cancel_response(response)
        }
    }
}

/// Operation shape for `DeregisterResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_resource`](crate::client::Client::deregister_resource).
///
/// See [`crate::client::fluent_builders::DeregisterResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterResource {
    _private: (),
}
impl DeregisterResource {
    /// Creates a new builder-style object to manufacture [`DeregisterResourceInput`](crate::input::DeregisterResourceInput)
    pub fn builder() -> crate::input::deregister_resource_input::Builder {
        crate::input::deregister_resource_input::Builder::default()
    }
    /// Creates a new `DeregisterResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterResource {
    type Output = std::result::Result<
        crate::output::DeregisterResourceOutput,
        crate::error::DeregisterResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_resource_error(response)
        } else {
            crate::operation_deser::parse_deregister_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource`](crate::client::Client::describe_resource).
///
/// See [`crate::client::fluent_builders::DescribeResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResource {
    _private: (),
}
impl DescribeResource {
    /// Creates a new builder-style object to manufacture [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    pub fn builder() -> crate::input::describe_resource_input::Builder {
        crate::input::describe_resource_input::Builder::default()
    }
    /// Creates a new `DescribeResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResource {
    type Output = std::result::Result<
        crate::output::DescribeResourceOutput,
        crate::error::DescribeResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_response(response)
        }
    }
}

/// Operation shape for `DescribeTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transaction`](crate::client::Client::describe_transaction).
///
/// See [`crate::client::fluent_builders::DescribeTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransaction {
    _private: (),
}
impl DescribeTransaction {
    /// Creates a new builder-style object to manufacture [`DescribeTransactionInput`](crate::input::DescribeTransactionInput)
    pub fn builder() -> crate::input::describe_transaction_input::Builder {
        crate::input::describe_transaction_input::Builder::default()
    }
    /// Creates a new `DescribeTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransaction {
    type Output = std::result::Result<
        crate::output::DescribeTransactionOutput,
        crate::error::DescribeTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transaction_error(response)
        } else {
            crate::operation_deser::parse_describe_transaction_response(response)
        }
    }
}

/// Operation shape for `ExtendTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`extend_transaction`](crate::client::Client::extend_transaction).
///
/// See [`crate::client::fluent_builders::ExtendTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExtendTransaction {
    _private: (),
}
impl ExtendTransaction {
    /// Creates a new builder-style object to manufacture [`ExtendTransactionInput`](crate::input::ExtendTransactionInput)
    pub fn builder() -> crate::input::extend_transaction_input::Builder {
        crate::input::extend_transaction_input::Builder::default()
    }
    /// Creates a new `ExtendTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExtendTransaction {
    type Output = std::result::Result<
        crate::output::ExtendTransactionOutput,
        crate::error::ExtendTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_extend_transaction_error(response)
        } else {
            crate::operation_deser::parse_extend_transaction_response(response)
        }
    }
}

/// Operation shape for `GetDataLakeSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_lake_settings`](crate::client::Client::get_data_lake_settings).
///
/// See [`crate::client::fluent_builders::GetDataLakeSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataLakeSettings {
    _private: (),
}
impl GetDataLakeSettings {
    /// Creates a new builder-style object to manufacture [`GetDataLakeSettingsInput`](crate::input::GetDataLakeSettingsInput)
    pub fn builder() -> crate::input::get_data_lake_settings_input::Builder {
        crate::input::get_data_lake_settings_input::Builder::default()
    }
    /// Creates a new `GetDataLakeSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataLakeSettings {
    type Output = std::result::Result<
        crate::output::GetDataLakeSettingsOutput,
        crate::error::GetDataLakeSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_lake_settings_error(response)
        } else {
            crate::operation_deser::parse_get_data_lake_settings_response(response)
        }
    }
}

/// Operation shape for `GetEffectivePermissionsForPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_effective_permissions_for_path`](crate::client::Client::get_effective_permissions_for_path).
///
/// See [`crate::client::fluent_builders::GetEffectivePermissionsForPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEffectivePermissionsForPath {
    _private: (),
}
impl GetEffectivePermissionsForPath {
    /// Creates a new builder-style object to manufacture [`GetEffectivePermissionsForPathInput`](crate::input::GetEffectivePermissionsForPathInput)
    pub fn builder() -> crate::input::get_effective_permissions_for_path_input::Builder {
        crate::input::get_effective_permissions_for_path_input::Builder::default()
    }
    /// Creates a new `GetEffectivePermissionsForPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEffectivePermissionsForPath {
    type Output = std::result::Result<
        crate::output::GetEffectivePermissionsForPathOutput,
        crate::error::GetEffectivePermissionsForPathError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_effective_permissions_for_path_error(response)
        } else {
            crate::operation_deser::parse_get_effective_permissions_for_path_response(response)
        }
    }
}

/// Operation shape for `GetLFTag`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lf_tag`](crate::client::Client::get_lf_tag).
///
/// See [`crate::client::fluent_builders::GetLFTag`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLFTag {
    _private: (),
}
impl GetLFTag {
    /// Creates a new builder-style object to manufacture [`GetLfTagInput`](crate::input::GetLfTagInput)
    pub fn builder() -> crate::input::get_lf_tag_input::Builder {
        crate::input::get_lf_tag_input::Builder::default()
    }
    /// Creates a new `GetLFTag` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLFTag {
    type Output = std::result::Result<crate::output::GetLfTagOutput, crate::error::GetLFTagError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lf_tag_error(response)
        } else {
            crate::operation_deser::parse_get_lf_tag_response(response)
        }
    }
}

/// Operation shape for `GetQueryState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_state`](crate::client::Client::get_query_state).
///
/// See [`crate::client::fluent_builders::GetQueryState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryState {
    _private: (),
}
impl GetQueryState {
    /// Creates a new builder-style object to manufacture [`GetQueryStateInput`](crate::input::GetQueryStateInput)
    pub fn builder() -> crate::input::get_query_state_input::Builder {
        crate::input::get_query_state_input::Builder::default()
    }
    /// Creates a new `GetQueryState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryState {
    type Output =
        std::result::Result<crate::output::GetQueryStateOutput, crate::error::GetQueryStateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_state_error(response)
        } else {
            crate::operation_deser::parse_get_query_state_response(response)
        }
    }
}

/// Operation shape for `GetQueryStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_statistics`](crate::client::Client::get_query_statistics).
///
/// See [`crate::client::fluent_builders::GetQueryStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryStatistics {
    _private: (),
}
impl GetQueryStatistics {
    /// Creates a new builder-style object to manufacture [`GetQueryStatisticsInput`](crate::input::GetQueryStatisticsInput)
    pub fn builder() -> crate::input::get_query_statistics_input::Builder {
        crate::input::get_query_statistics_input::Builder::default()
    }
    /// Creates a new `GetQueryStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryStatistics {
    type Output = std::result::Result<
        crate::output::GetQueryStatisticsOutput,
        crate::error::GetQueryStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_query_statistics_response(response)
        }
    }
}

/// Operation shape for `GetResourceLFTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_lf_tags`](crate::client::Client::get_resource_lf_tags).
///
/// See [`crate::client::fluent_builders::GetResourceLFTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceLFTags {
    _private: (),
}
impl GetResourceLFTags {
    /// Creates a new builder-style object to manufacture [`GetResourceLfTagsInput`](crate::input::GetResourceLfTagsInput)
    pub fn builder() -> crate::input::get_resource_lf_tags_input::Builder {
        crate::input::get_resource_lf_tags_input::Builder::default()
    }
    /// Creates a new `GetResourceLFTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceLFTags {
    type Output = std::result::Result<
        crate::output::GetResourceLfTagsOutput,
        crate::error::GetResourceLFTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_lf_tags_error(response)
        } else {
            crate::operation_deser::parse_get_resource_lf_tags_response(response)
        }
    }
}

/// Operation shape for `GetTableObjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_table_objects`](crate::client::Client::get_table_objects).
///
/// See [`crate::client::fluent_builders::GetTableObjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTableObjects {
    _private: (),
}
impl GetTableObjects {
    /// Creates a new builder-style object to manufacture [`GetTableObjectsInput`](crate::input::GetTableObjectsInput)
    pub fn builder() -> crate::input::get_table_objects_input::Builder {
        crate::input::get_table_objects_input::Builder::default()
    }
    /// Creates a new `GetTableObjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTableObjects {
    type Output = std::result::Result<
        crate::output::GetTableObjectsOutput,
        crate::error::GetTableObjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_table_objects_error(response)
        } else {
            crate::operation_deser::parse_get_table_objects_response(response)
        }
    }
}

/// Operation shape for `GetTemporaryGluePartitionCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_temporary_glue_partition_credentials`](crate::client::Client::get_temporary_glue_partition_credentials).
///
/// See [`crate::client::fluent_builders::GetTemporaryGluePartitionCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemporaryGluePartitionCredentials {
    _private: (),
}
impl GetTemporaryGluePartitionCredentials {
    /// Creates a new builder-style object to manufacture [`GetTemporaryGluePartitionCredentialsInput`](crate::input::GetTemporaryGluePartitionCredentialsInput)
    pub fn builder() -> crate::input::get_temporary_glue_partition_credentials_input::Builder {
        crate::input::get_temporary_glue_partition_credentials_input::Builder::default()
    }
    /// Creates a new `GetTemporaryGluePartitionCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemporaryGluePartitionCredentials {
    type Output = std::result::Result<
        crate::output::GetTemporaryGluePartitionCredentialsOutput,
        crate::error::GetTemporaryGluePartitionCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_temporary_glue_partition_credentials_error(response)
        } else {
            crate::operation_deser::parse_get_temporary_glue_partition_credentials_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTemporaryGlueTableCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_temporary_glue_table_credentials`](crate::client::Client::get_temporary_glue_table_credentials).
///
/// See [`crate::client::fluent_builders::GetTemporaryGlueTableCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemporaryGlueTableCredentials {
    _private: (),
}
impl GetTemporaryGlueTableCredentials {
    /// Creates a new builder-style object to manufacture [`GetTemporaryGlueTableCredentialsInput`](crate::input::GetTemporaryGlueTableCredentialsInput)
    pub fn builder() -> crate::input::get_temporary_glue_table_credentials_input::Builder {
        crate::input::get_temporary_glue_table_credentials_input::Builder::default()
    }
    /// Creates a new `GetTemporaryGlueTableCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemporaryGlueTableCredentials {
    type Output = std::result::Result<
        crate::output::GetTemporaryGlueTableCredentialsOutput,
        crate::error::GetTemporaryGlueTableCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_temporary_glue_table_credentials_error(response)
        } else {
            crate::operation_deser::parse_get_temporary_glue_table_credentials_response(response)
        }
    }
}

/// Operation shape for `GetWorkUnitResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_work_unit_results`](crate::client::Client::get_work_unit_results).
///
/// See [`crate::client::fluent_builders::GetWorkUnitResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkUnitResults {
    _private: (),
}
impl GetWorkUnitResults {
    /// Creates a new builder-style object to manufacture [`GetWorkUnitResultsInput`](crate::input::GetWorkUnitResultsInput)
    pub fn builder() -> crate::input::get_work_unit_results_input::Builder {
        crate::input::get_work_unit_results_input::Builder::default()
    }
    /// Creates a new `GetWorkUnitResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for GetWorkUnitResults {
    type Output = std::result::Result<
        crate::output::GetWorkUnitResultsOutput,
        crate::error::GetWorkUnitResultsError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_get_work_unit_results(
            response,
        ))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_get_work_unit_results_error(response)
    }
}

/// Operation shape for `GetWorkUnits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_work_units`](crate::client::Client::get_work_units).
///
/// See [`crate::client::fluent_builders::GetWorkUnits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkUnits {
    _private: (),
}
impl GetWorkUnits {
    /// Creates a new builder-style object to manufacture [`GetWorkUnitsInput`](crate::input::GetWorkUnitsInput)
    pub fn builder() -> crate::input::get_work_units_input::Builder {
        crate::input::get_work_units_input::Builder::default()
    }
    /// Creates a new `GetWorkUnits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkUnits {
    type Output =
        std::result::Result<crate::output::GetWorkUnitsOutput, crate::error::GetWorkUnitsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_work_units_error(response)
        } else {
            crate::operation_deser::parse_get_work_units_response(response)
        }
    }
}

/// Operation shape for `GrantPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`grant_permissions`](crate::client::Client::grant_permissions).
///
/// See [`crate::client::fluent_builders::GrantPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GrantPermissions {
    _private: (),
}
impl GrantPermissions {
    /// Creates a new builder-style object to manufacture [`GrantPermissionsInput`](crate::input::GrantPermissionsInput)
    pub fn builder() -> crate::input::grant_permissions_input::Builder {
        crate::input::grant_permissions_input::Builder::default()
    }
    /// Creates a new `GrantPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GrantPermissions {
    type Output = std::result::Result<
        crate::output::GrantPermissionsOutput,
        crate::error::GrantPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_grant_permissions_error(response)
        } else {
            crate::operation_deser::parse_grant_permissions_response(response)
        }
    }
}

/// Operation shape for `ListDataCellsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_cells_filter`](crate::client::Client::list_data_cells_filter).
///
/// See [`crate::client::fluent_builders::ListDataCellsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataCellsFilter {
    _private: (),
}
impl ListDataCellsFilter {
    /// Creates a new builder-style object to manufacture [`ListDataCellsFilterInput`](crate::input::ListDataCellsFilterInput)
    pub fn builder() -> crate::input::list_data_cells_filter_input::Builder {
        crate::input::list_data_cells_filter_input::Builder::default()
    }
    /// Creates a new `ListDataCellsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataCellsFilter {
    type Output = std::result::Result<
        crate::output::ListDataCellsFilterOutput,
        crate::error::ListDataCellsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_cells_filter_error(response)
        } else {
            crate::operation_deser::parse_list_data_cells_filter_response(response)
        }
    }
}

/// Operation shape for `ListLFTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lf_tags`](crate::client::Client::list_lf_tags).
///
/// See [`crate::client::fluent_builders::ListLFTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLFTags {
    _private: (),
}
impl ListLFTags {
    /// Creates a new builder-style object to manufacture [`ListLfTagsInput`](crate::input::ListLfTagsInput)
    pub fn builder() -> crate::input::list_lf_tags_input::Builder {
        crate::input::list_lf_tags_input::Builder::default()
    }
    /// Creates a new `ListLFTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLFTags {
    type Output =
        std::result::Result<crate::output::ListLfTagsOutput, crate::error::ListLFTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lf_tags_error(response)
        } else {
            crate::operation_deser::parse_list_lf_tags_response(response)
        }
    }
}

/// Operation shape for `ListPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permissions`](crate::client::Client::list_permissions).
///
/// See [`crate::client::fluent_builders::ListPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissions {
    _private: (),
}
impl ListPermissions {
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
    /// Creates a new `ListPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissions {
    type Output = std::result::Result<
        crate::output::ListPermissionsOutput,
        crate::error::ListPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permissions_error(response)
        } else {
            crate::operation_deser::parse_list_permissions_response(response)
        }
    }
}

/// Operation shape for `ListResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources`](crate::client::Client::list_resources).
///
/// See [`crate::client::fluent_builders::ListResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResources {
    _private: (),
}
impl ListResources {
    /// Creates a new builder-style object to manufacture [`ListResourcesInput`](crate::input::ListResourcesInput)
    pub fn builder() -> crate::input::list_resources_input::Builder {
        crate::input::list_resources_input::Builder::default()
    }
    /// Creates a new `ListResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResources {
    type Output =
        std::result::Result<crate::output::ListResourcesOutput, crate::error::ListResourcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_error(response)
        } else {
            crate::operation_deser::parse_list_resources_response(response)
        }
    }
}

/// Operation shape for `ListTableStorageOptimizers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_table_storage_optimizers`](crate::client::Client::list_table_storage_optimizers).
///
/// See [`crate::client::fluent_builders::ListTableStorageOptimizers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTableStorageOptimizers {
    _private: (),
}
impl ListTableStorageOptimizers {
    /// Creates a new builder-style object to manufacture [`ListTableStorageOptimizersInput`](crate::input::ListTableStorageOptimizersInput)
    pub fn builder() -> crate::input::list_table_storage_optimizers_input::Builder {
        crate::input::list_table_storage_optimizers_input::Builder::default()
    }
    /// Creates a new `ListTableStorageOptimizers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTableStorageOptimizers {
    type Output = std::result::Result<
        crate::output::ListTableStorageOptimizersOutput,
        crate::error::ListTableStorageOptimizersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_table_storage_optimizers_error(response)
        } else {
            crate::operation_deser::parse_list_table_storage_optimizers_response(response)
        }
    }
}

/// Operation shape for `ListTransactions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_transactions`](crate::client::Client::list_transactions).
///
/// See [`crate::client::fluent_builders::ListTransactions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTransactions {
    _private: (),
}
impl ListTransactions {
    /// Creates a new builder-style object to manufacture [`ListTransactionsInput`](crate::input::ListTransactionsInput)
    pub fn builder() -> crate::input::list_transactions_input::Builder {
        crate::input::list_transactions_input::Builder::default()
    }
    /// Creates a new `ListTransactions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTransactions {
    type Output = std::result::Result<
        crate::output::ListTransactionsOutput,
        crate::error::ListTransactionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_transactions_error(response)
        } else {
            crate::operation_deser::parse_list_transactions_response(response)
        }
    }
}

/// Operation shape for `PutDataLakeSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_data_lake_settings`](crate::client::Client::put_data_lake_settings).
///
/// See [`crate::client::fluent_builders::PutDataLakeSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDataLakeSettings {
    _private: (),
}
impl PutDataLakeSettings {
    /// Creates a new builder-style object to manufacture [`PutDataLakeSettingsInput`](crate::input::PutDataLakeSettingsInput)
    pub fn builder() -> crate::input::put_data_lake_settings_input::Builder {
        crate::input::put_data_lake_settings_input::Builder::default()
    }
    /// Creates a new `PutDataLakeSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDataLakeSettings {
    type Output = std::result::Result<
        crate::output::PutDataLakeSettingsOutput,
        crate::error::PutDataLakeSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_data_lake_settings_error(response)
        } else {
            crate::operation_deser::parse_put_data_lake_settings_response(response)
        }
    }
}

/// Operation shape for `RegisterResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_resource`](crate::client::Client::register_resource).
///
/// See [`crate::client::fluent_builders::RegisterResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterResource {
    _private: (),
}
impl RegisterResource {
    /// Creates a new builder-style object to manufacture [`RegisterResourceInput`](crate::input::RegisterResourceInput)
    pub fn builder() -> crate::input::register_resource_input::Builder {
        crate::input::register_resource_input::Builder::default()
    }
    /// Creates a new `RegisterResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterResource {
    type Output = std::result::Result<
        crate::output::RegisterResourceOutput,
        crate::error::RegisterResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_resource_error(response)
        } else {
            crate::operation_deser::parse_register_resource_response(response)
        }
    }
}

/// Operation shape for `RemoveLFTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_lf_tags_from_resource`](crate::client::Client::remove_lf_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveLFTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveLFTagsFromResource {
    _private: (),
}
impl RemoveLFTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveLfTagsFromResourceInput`](crate::input::RemoveLfTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_lf_tags_from_resource_input::Builder {
        crate::input::remove_lf_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveLFTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveLFTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveLfTagsFromResourceOutput,
        crate::error::RemoveLFTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_lf_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_lf_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `RevokePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_permissions`](crate::client::Client::revoke_permissions).
///
/// See [`crate::client::fluent_builders::RevokePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokePermissions {
    _private: (),
}
impl RevokePermissions {
    /// Creates a new builder-style object to manufacture [`RevokePermissionsInput`](crate::input::RevokePermissionsInput)
    pub fn builder() -> crate::input::revoke_permissions_input::Builder {
        crate::input::revoke_permissions_input::Builder::default()
    }
    /// Creates a new `RevokePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokePermissions {
    type Output = std::result::Result<
        crate::output::RevokePermissionsOutput,
        crate::error::RevokePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_permissions_error(response)
        } else {
            crate::operation_deser::parse_revoke_permissions_response(response)
        }
    }
}

/// Operation shape for `SearchDatabasesByLFTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_databases_by_lf_tags`](crate::client::Client::search_databases_by_lf_tags).
///
/// See [`crate::client::fluent_builders::SearchDatabasesByLFTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchDatabasesByLFTags {
    _private: (),
}
impl SearchDatabasesByLFTags {
    /// Creates a new builder-style object to manufacture [`SearchDatabasesByLfTagsInput`](crate::input::SearchDatabasesByLfTagsInput)
    pub fn builder() -> crate::input::search_databases_by_lf_tags_input::Builder {
        crate::input::search_databases_by_lf_tags_input::Builder::default()
    }
    /// Creates a new `SearchDatabasesByLFTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchDatabasesByLFTags {
    type Output = std::result::Result<
        crate::output::SearchDatabasesByLfTagsOutput,
        crate::error::SearchDatabasesByLFTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_databases_by_lf_tags_error(response)
        } else {
            crate::operation_deser::parse_search_databases_by_lf_tags_response(response)
        }
    }
}

/// Operation shape for `SearchTablesByLFTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_tables_by_lf_tags`](crate::client::Client::search_tables_by_lf_tags).
///
/// See [`crate::client::fluent_builders::SearchTablesByLFTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchTablesByLFTags {
    _private: (),
}
impl SearchTablesByLFTags {
    /// Creates a new builder-style object to manufacture [`SearchTablesByLfTagsInput`](crate::input::SearchTablesByLfTagsInput)
    pub fn builder() -> crate::input::search_tables_by_lf_tags_input::Builder {
        crate::input::search_tables_by_lf_tags_input::Builder::default()
    }
    /// Creates a new `SearchTablesByLFTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchTablesByLFTags {
    type Output = std::result::Result<
        crate::output::SearchTablesByLfTagsOutput,
        crate::error::SearchTablesByLFTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_tables_by_lf_tags_error(response)
        } else {
            crate::operation_deser::parse_search_tables_by_lf_tags_response(response)
        }
    }
}

/// Operation shape for `StartQueryPlanning`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_query_planning`](crate::client::Client::start_query_planning).
///
/// See [`crate::client::fluent_builders::StartQueryPlanning`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartQueryPlanning {
    _private: (),
}
impl StartQueryPlanning {
    /// Creates a new builder-style object to manufacture [`StartQueryPlanningInput`](crate::input::StartQueryPlanningInput)
    pub fn builder() -> crate::input::start_query_planning_input::Builder {
        crate::input::start_query_planning_input::Builder::default()
    }
    /// Creates a new `StartQueryPlanning` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartQueryPlanning {
    type Output = std::result::Result<
        crate::output::StartQueryPlanningOutput,
        crate::error::StartQueryPlanningError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_query_planning_error(response)
        } else {
            crate::operation_deser::parse_start_query_planning_response(response)
        }
    }
}

/// Operation shape for `StartTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_transaction`](crate::client::Client::start_transaction).
///
/// See [`crate::client::fluent_builders::StartTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTransaction {
    _private: (),
}
impl StartTransaction {
    /// Creates a new builder-style object to manufacture [`StartTransactionInput`](crate::input::StartTransactionInput)
    pub fn builder() -> crate::input::start_transaction_input::Builder {
        crate::input::start_transaction_input::Builder::default()
    }
    /// Creates a new `StartTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTransaction {
    type Output = std::result::Result<
        crate::output::StartTransactionOutput,
        crate::error::StartTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_transaction_error(response)
        } else {
            crate::operation_deser::parse_start_transaction_response(response)
        }
    }
}

/// Operation shape for `UpdateLFTag`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_lf_tag`](crate::client::Client::update_lf_tag).
///
/// See [`crate::client::fluent_builders::UpdateLFTag`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLFTag {
    _private: (),
}
impl UpdateLFTag {
    /// Creates a new builder-style object to manufacture [`UpdateLfTagInput`](crate::input::UpdateLfTagInput)
    pub fn builder() -> crate::input::update_lf_tag_input::Builder {
        crate::input::update_lf_tag_input::Builder::default()
    }
    /// Creates a new `UpdateLFTag` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLFTag {
    type Output =
        std::result::Result<crate::output::UpdateLfTagOutput, crate::error::UpdateLFTagError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_lf_tag_error(response)
        } else {
            crate::operation_deser::parse_update_lf_tag_response(response)
        }
    }
}

/// Operation shape for `UpdateResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource`](crate::client::Client::update_resource).
///
/// See [`crate::client::fluent_builders::UpdateResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResource {
    _private: (),
}
impl UpdateResource {
    /// Creates a new builder-style object to manufacture [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    pub fn builder() -> crate::input::update_resource_input::Builder {
        crate::input::update_resource_input::Builder::default()
    }
    /// Creates a new `UpdateResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResource {
    type Output =
        std::result::Result<crate::output::UpdateResourceOutput, crate::error::UpdateResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_error(response)
        } else {
            crate::operation_deser::parse_update_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateTableObjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_table_objects`](crate::client::Client::update_table_objects).
///
/// See [`crate::client::fluent_builders::UpdateTableObjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTableObjects {
    _private: (),
}
impl UpdateTableObjects {
    /// Creates a new builder-style object to manufacture [`UpdateTableObjectsInput`](crate::input::UpdateTableObjectsInput)
    pub fn builder() -> crate::input::update_table_objects_input::Builder {
        crate::input::update_table_objects_input::Builder::default()
    }
    /// Creates a new `UpdateTableObjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTableObjects {
    type Output = std::result::Result<
        crate::output::UpdateTableObjectsOutput,
        crate::error::UpdateTableObjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_table_objects_error(response)
        } else {
            crate::operation_deser::parse_update_table_objects_response(response)
        }
    }
}

/// Operation shape for `UpdateTableStorageOptimizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_table_storage_optimizer`](crate::client::Client::update_table_storage_optimizer).
///
/// See [`crate::client::fluent_builders::UpdateTableStorageOptimizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTableStorageOptimizer {
    _private: (),
}
impl UpdateTableStorageOptimizer {
    /// Creates a new builder-style object to manufacture [`UpdateTableStorageOptimizerInput`](crate::input::UpdateTableStorageOptimizerInput)
    pub fn builder() -> crate::input::update_table_storage_optimizer_input::Builder {
        crate::input::update_table_storage_optimizer_input::Builder::default()
    }
    /// Creates a new `UpdateTableStorageOptimizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTableStorageOptimizer {
    type Output = std::result::Result<
        crate::output::UpdateTableStorageOptimizerOutput,
        crate::error::UpdateTableStorageOptimizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_table_storage_optimizer_error(response)
        } else {
            crate::operation_deser::parse_update_table_storage_optimizer_response(response)
        }
    }
}
