// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Lake Formation
///
/// Client for invoking operations on AWS Lake Formation. Each operation on AWS Lake Formation is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lakeformation::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lakeformation::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lakeformation::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AddLFTagsToResource`](crate::client::fluent_builders::AddLFTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::AddLFTagsToResource::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::AddLFTagsToResource::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::AddLFTagsToResource::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::AddLFTagsToResource::set_resource): <p>The database, table, or column resource to which to attach an LF-tag.</p>
    ///   - [`lf_tags(Vec<LfTagPair>)`](crate::client::fluent_builders::AddLFTagsToResource::lf_tags) / [`set_lf_tags(Option<Vec<LfTagPair>>)`](crate::client::fluent_builders::AddLFTagsToResource::set_lf_tags): <p>The LF-tags to attach to the resource.</p>
    /// - On success, responds with [`AddLfTagsToResourceOutput`](crate::output::AddLfTagsToResourceOutput) with field(s):
    ///   - [`failures(Option<Vec<LfTagError>>)`](crate::output::AddLfTagsToResourceOutput::failures): <p>A list of failures to tag the resource.</p>
    /// - On failure, responds with [`SdkError<AddLFTagsToResourceError>`](crate::error::AddLFTagsToResourceError)
    pub fn add_lf_tags_to_resource(&self) -> fluent_builders::AddLFTagsToResource<C, M, R> {
        fluent_builders::AddLFTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGrantPermissions`](crate::client::fluent_builders::BatchGrantPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::BatchGrantPermissions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::BatchGrantPermissions::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`entries(Vec<BatchPermissionsRequestEntry>)`](crate::client::fluent_builders::BatchGrantPermissions::entries) / [`set_entries(Option<Vec<BatchPermissionsRequestEntry>>)`](crate::client::fluent_builders::BatchGrantPermissions::set_entries): <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
    /// - On success, responds with [`BatchGrantPermissionsOutput`](crate::output::BatchGrantPermissionsOutput) with field(s):
    ///   - [`failures(Option<Vec<BatchPermissionsFailureEntry>>)`](crate::output::BatchGrantPermissionsOutput::failures): <p>A list of failures to grant permissions to the resources.</p>
    /// - On failure, responds with [`SdkError<BatchGrantPermissionsError>`](crate::error::BatchGrantPermissionsError)
    pub fn batch_grant_permissions(&self) -> fluent_builders::BatchGrantPermissions<C, M, R> {
        fluent_builders::BatchGrantPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchRevokePermissions`](crate::client::fluent_builders::BatchRevokePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::BatchRevokePermissions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::BatchRevokePermissions::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`entries(Vec<BatchPermissionsRequestEntry>)`](crate::client::fluent_builders::BatchRevokePermissions::entries) / [`set_entries(Option<Vec<BatchPermissionsRequestEntry>>)`](crate::client::fluent_builders::BatchRevokePermissions::set_entries): <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
    /// - On success, responds with [`BatchRevokePermissionsOutput`](crate::output::BatchRevokePermissionsOutput) with field(s):
    ///   - [`failures(Option<Vec<BatchPermissionsFailureEntry>>)`](crate::output::BatchRevokePermissionsOutput::failures): <p>A list of failures to revoke permissions to the resources.</p>
    /// - On failure, responds with [`SdkError<BatchRevokePermissionsError>`](crate::error::BatchRevokePermissionsError)
    pub fn batch_revoke_permissions(&self) -> fluent_builders::BatchRevokePermissions<C, M, R> {
        fluent_builders::BatchRevokePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelTransaction`](crate::client::fluent_builders::CancelTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::CancelTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::CancelTransaction::set_transaction_id): <p>The transaction to cancel.</p>
    /// - On success, responds with [`CancelTransactionOutput`](crate::output::CancelTransactionOutput)

    /// - On failure, responds with [`SdkError<CancelTransactionError>`](crate::error::CancelTransactionError)
    pub fn cancel_transaction(&self) -> fluent_builders::CancelTransaction<C, M, R> {
        fluent_builders::CancelTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CommitTransaction`](crate::client::fluent_builders::CommitTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::CommitTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::CommitTransaction::set_transaction_id): <p>The transaction to commit.</p>
    /// - On success, responds with [`CommitTransactionOutput`](crate::output::CommitTransactionOutput) with field(s):
    ///   - [`transaction_status(Option<TransactionStatus>)`](crate::output::CommitTransactionOutput::transaction_status): <p>The status of the transaction.</p>
    /// - On failure, responds with [`SdkError<CommitTransactionError>`](crate::error::CommitTransactionError)
    pub fn commit_transaction(&self) -> fluent_builders::CommitTransaction<C, M, R> {
        fluent_builders::CommitTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataCellsFilter`](crate::client::fluent_builders::CreateDataCellsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_data(DataCellsFilter)`](crate::client::fluent_builders::CreateDataCellsFilter::table_data) / [`set_table_data(Option<DataCellsFilter>)`](crate::client::fluent_builders::CreateDataCellsFilter::set_table_data): <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
    /// - On success, responds with [`CreateDataCellsFilterOutput`](crate::output::CreateDataCellsFilterOutput)

    /// - On failure, responds with [`SdkError<CreateDataCellsFilterError>`](crate::error::CreateDataCellsFilterError)
    pub fn create_data_cells_filter(&self) -> fluent_builders::CreateDataCellsFilter<C, M, R> {
        fluent_builders::CreateDataCellsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLFTag`](crate::client::fluent_builders::CreateLFTag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::CreateLFTag::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::CreateLFTag::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`tag_key(impl Into<String>)`](crate::client::fluent_builders::CreateLFTag::tag_key) / [`set_tag_key(Option<String>)`](crate::client::fluent_builders::CreateLFTag::set_tag_key): <p>The key-name for the LF-tag.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::CreateLFTag::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLFTag::set_tag_values): <p>A list of possible values an attribute can take.</p>
    /// - On success, responds with [`CreateLfTagOutput`](crate::output::CreateLfTagOutput)

    /// - On failure, responds with [`SdkError<CreateLFTagError>`](crate::error::CreateLFTagError)
    pub fn create_lf_tag(&self) -> fluent_builders::CreateLFTag<C, M, R> {
        fluent_builders::CreateLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataCellsFilter`](crate::client::fluent_builders::DeleteDataCellsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_catalog_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::table_catalog_id) / [`set_table_catalog_id(Option<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::set_table_catalog_id): <p>The ID of the catalog to which the table belongs.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::set_database_name): <p>A database in the Glue Data Catalog.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::set_table_name): <p>A table in the database.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDataCellsFilter::set_name): <p>The name given by the user to the data filter cell.</p>
    /// - On success, responds with [`DeleteDataCellsFilterOutput`](crate::output::DeleteDataCellsFilterOutput)

    /// - On failure, responds with [`SdkError<DeleteDataCellsFilterError>`](crate::error::DeleteDataCellsFilterError)
    pub fn delete_data_cells_filter(&self) -> fluent_builders::DeleteDataCellsFilter<C, M, R> {
        fluent_builders::DeleteDataCellsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLFTag`](crate::client::fluent_builders::DeleteLFTag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLFTag::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::DeleteLFTag::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`tag_key(impl Into<String>)`](crate::client::fluent_builders::DeleteLFTag::tag_key) / [`set_tag_key(Option<String>)`](crate::client::fluent_builders::DeleteLFTag::set_tag_key): <p>The key-name for the LF-tag to delete.</p>
    /// - On success, responds with [`DeleteLfTagOutput`](crate::output::DeleteLfTagOutput)

    /// - On failure, responds with [`SdkError<DeleteLFTagError>`](crate::error::DeleteLFTagError)
    pub fn delete_lf_tag(&self) -> fluent_builders::DeleteLFTag<C, M, R> {
        fluent_builders::DeleteLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteObjectsOnCancel`](crate::client::fluent_builders::DeleteObjectsOnCancel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::set_catalog_id): <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::set_database_name): <p>The database that contains the governed table.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::set_table_name): <p>The name of the governed table.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::set_transaction_id): <p>ID of the transaction that the writes occur in.</p>
    ///   - [`objects(Vec<VirtualObject>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::objects) / [`set_objects(Option<Vec<VirtualObject>>)`](crate::client::fluent_builders::DeleteObjectsOnCancel::set_objects): <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
    /// - On success, responds with [`DeleteObjectsOnCancelOutput`](crate::output::DeleteObjectsOnCancelOutput)

    /// - On failure, responds with [`SdkError<DeleteObjectsOnCancelError>`](crate::error::DeleteObjectsOnCancelError)
    pub fn delete_objects_on_cancel(&self) -> fluent_builders::DeleteObjectsOnCancel<C, M, R> {
        fluent_builders::DeleteObjectsOnCancel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterResource`](crate::client::fluent_builders::DeregisterResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeregisterResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeregisterResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
    /// - On success, responds with [`DeregisterResourceOutput`](crate::output::DeregisterResourceOutput)

    /// - On failure, responds with [`SdkError<DeregisterResourceError>`](crate::error::DeregisterResourceError)
    pub fn deregister_resource(&self) -> fluent_builders::DeregisterResource<C, M, R> {
        fluent_builders::DeregisterResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResource`](crate::client::fluent_builders::DescribeResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DescribeResource::set_resource_arn): <p>The resource ARN.</p>
    /// - On success, responds with [`DescribeResourceOutput`](crate::output::DescribeResourceOutput) with field(s):
    ///   - [`resource_info(Option<ResourceInfo>)`](crate::output::DescribeResourceOutput::resource_info): <p>A structure containing information about an Lake Formation resource.</p>
    /// - On failure, responds with [`SdkError<DescribeResourceError>`](crate::error::DescribeResourceError)
    pub fn describe_resource(&self) -> fluent_builders::DescribeResource<C, M, R> {
        fluent_builders::DescribeResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransaction`](crate::client::fluent_builders::DescribeTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::DescribeTransaction::set_transaction_id): <p>The transaction for which to return status.</p>
    /// - On success, responds with [`DescribeTransactionOutput`](crate::output::DescribeTransactionOutput) with field(s):
    ///   - [`transaction_description(Option<TransactionDescription>)`](crate::output::DescribeTransactionOutput::transaction_description): <p>Returns a <code>TransactionDescription</code> object containing information about the transaction.</p>
    /// - On failure, responds with [`SdkError<DescribeTransactionError>`](crate::error::DescribeTransactionError)
    pub fn describe_transaction(&self) -> fluent_builders::DescribeTransaction<C, M, R> {
        fluent_builders::DescribeTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExtendTransaction`](crate::client::fluent_builders::ExtendTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::ExtendTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::ExtendTransaction::set_transaction_id): <p>The transaction to extend.</p>
    /// - On success, responds with [`ExtendTransactionOutput`](crate::output::ExtendTransactionOutput)

    /// - On failure, responds with [`SdkError<ExtendTransactionError>`](crate::error::ExtendTransactionError)
    pub fn extend_transaction(&self) -> fluent_builders::ExtendTransaction<C, M, R> {
        fluent_builders::ExtendTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataLakeSettings`](crate::client::fluent_builders::GetDataLakeSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GetDataLakeSettings::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GetDataLakeSettings::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    /// - On success, responds with [`GetDataLakeSettingsOutput`](crate::output::GetDataLakeSettingsOutput) with field(s):
    ///   - [`data_lake_settings(Option<DataLakeSettings>)`](crate::output::GetDataLakeSettingsOutput::data_lake_settings): <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
    /// - On failure, responds with [`SdkError<GetDataLakeSettingsError>`](crate::error::GetDataLakeSettingsError)
    pub fn get_data_lake_settings(&self) -> fluent_builders::GetDataLakeSettings<C, M, R> {
        fluent_builders::GetDataLakeSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEffectivePermissionsForPath`](crate::client::fluent_builders::GetEffectivePermissionsForPath) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEffectivePermissionsForPath::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::set_next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEffectivePermissionsForPath::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`GetEffectivePermissionsForPathOutput`](crate::output::GetEffectivePermissionsForPathOutput) with field(s):
    ///   - [`permissions(Option<Vec<PrincipalResourcePermissions>>)`](crate::output::GetEffectivePermissionsForPathOutput::permissions): <p>A list of the permissions for the specified table or database resource located at the path in Amazon S3.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEffectivePermissionsForPathOutput::next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    /// - On failure, responds with [`SdkError<GetEffectivePermissionsForPathError>`](crate::error::GetEffectivePermissionsForPathError)
    pub fn get_effective_permissions_for_path(
        &self,
    ) -> fluent_builders::GetEffectivePermissionsForPath<C, M, R> {
        fluent_builders::GetEffectivePermissionsForPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLFTag`](crate::client::fluent_builders::GetLFTag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GetLFTag::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GetLFTag::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`tag_key(impl Into<String>)`](crate::client::fluent_builders::GetLFTag::tag_key) / [`set_tag_key(Option<String>)`](crate::client::fluent_builders::GetLFTag::set_tag_key): <p>The key-name for the LF-tag.</p>
    /// - On success, responds with [`GetLfTagOutput`](crate::output::GetLfTagOutput) with field(s):
    ///   - [`catalog_id(Option<String>)`](crate::output::GetLfTagOutput::catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`tag_key(Option<String>)`](crate::output::GetLfTagOutput::tag_key): <p>The key-name for the LF-tag.</p>
    ///   - [`tag_values(Option<Vec<String>>)`](crate::output::GetLfTagOutput::tag_values): <p>A list of possible values an attribute can take.</p>
    /// - On failure, responds with [`SdkError<GetLFTagError>`](crate::error::GetLFTagError)
    pub fn get_lf_tag(&self) -> fluent_builders::GetLFTag<C, M, R> {
        fluent_builders::GetLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQueryState`](crate::client::fluent_builders::GetQueryState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::GetQueryState::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::GetQueryState::set_query_id): <p>The ID of the plan query operation.</p>
    /// - On success, responds with [`GetQueryStateOutput`](crate::output::GetQueryStateOutput) with field(s):
    ///   - [`error(Option<String>)`](crate::output::GetQueryStateOutput::error): <p>An error message when the operation fails.</p>
    ///   - [`state(Option<QueryStateString>)`](crate::output::GetQueryStateOutput::state): <p>The state of a query previously submitted. The possible states are:</p>  <ul>   <li> <p>PENDING: the query is pending.</p> </li>   <li> <p>WORKUNITS_AVAILABLE: some work units are ready for retrieval and execution.</p> </li>   <li> <p>FINISHED: the query planning finished successfully, and all work units are ready for retrieval and execution.</p> </li>   <li> <p>ERROR: an error occurred with the query, such as an invalid query ID or a backend error.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetQueryStateError>`](crate::error::GetQueryStateError)
    pub fn get_query_state(&self) -> fluent_builders::GetQueryState<C, M, R> {
        fluent_builders::GetQueryState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQueryStatistics`](crate::client::fluent_builders::GetQueryStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::GetQueryStatistics::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::GetQueryStatistics::set_query_id): <p>The ID of the plan query operation.</p>
    /// - On success, responds with [`GetQueryStatisticsOutput`](crate::output::GetQueryStatisticsOutput) with field(s):
    ///   - [`execution_statistics(Option<ExecutionStatistics>)`](crate::output::GetQueryStatisticsOutput::execution_statistics): <p>An <code>ExecutionStatistics</code> structure containing execution statistics.</p>
    ///   - [`planning_statistics(Option<PlanningStatistics>)`](crate::output::GetQueryStatisticsOutput::planning_statistics): <p>A <code>PlanningStatistics</code> structure containing query planning statistics.</p>
    ///   - [`query_submission_time(Option<DateTime>)`](crate::output::GetQueryStatisticsOutput::query_submission_time): <p>The time that the query was submitted.</p>
    /// - On failure, responds with [`SdkError<GetQueryStatisticsError>`](crate::error::GetQueryStatisticsError)
    pub fn get_query_statistics(&self) -> fluent_builders::GetQueryStatistics<C, M, R> {
        fluent_builders::GetQueryStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceLFTags`](crate::client::fluent_builders::GetResourceLFTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GetResourceLFTags::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GetResourceLFTags::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::GetResourceLFTags::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::GetResourceLFTags::set_resource): <p>The database, table, or column resource for which you want to return LF-tags.</p>
    ///   - [`show_assigned_lf_tags(bool)`](crate::client::fluent_builders::GetResourceLFTags::show_assigned_lf_tags) / [`set_show_assigned_lf_tags(Option<bool>)`](crate::client::fluent_builders::GetResourceLFTags::set_show_assigned_lf_tags): <p>Indicates whether to show the assigned LF-tags.</p>
    /// - On success, responds with [`GetResourceLfTagsOutput`](crate::output::GetResourceLfTagsOutput) with field(s):
    ///   - [`lf_tag_on_database(Option<Vec<LfTagPair>>)`](crate::output::GetResourceLfTagsOutput::lf_tag_on_database): <p>A list of LF-tags applied to a database resource.</p>
    ///   - [`lf_tags_on_table(Option<Vec<LfTagPair>>)`](crate::output::GetResourceLfTagsOutput::lf_tags_on_table): <p>A list of LF-tags applied to a table resource.</p>
    ///   - [`lf_tags_on_columns(Option<Vec<ColumnLfTag>>)`](crate::output::GetResourceLfTagsOutput::lf_tags_on_columns): <p>A list of LF-tags applied to a column resource.</p>
    /// - On failure, responds with [`SdkError<GetResourceLFTagsError>`](crate::error::GetResourceLFTagsError)
    pub fn get_resource_lf_tags(&self) -> fluent_builders::GetResourceLFTags<C, M, R> {
        fluent_builders::GetResourceLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTableObjects`](crate::client::fluent_builders::GetTableObjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTableObjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_catalog_id): <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_database_name): <p>The database containing the governed table.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_table_name): <p>The governed table for which to retrieve objects.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_transaction_id): <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
    ///   - [`query_as_of_time(DateTime)`](crate::client::fluent_builders::GetTableObjects::query_as_of_time) / [`set_query_as_of_time(Option<DateTime>)`](crate::client::fluent_builders::GetTableObjects::set_query_as_of_time): <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
    ///   - [`partition_predicate(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::partition_predicate) / [`set_partition_predicate(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_partition_predicate): <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>  <ul>   <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>   <li> <p>The logical operators supported are: AND</p> </li>   <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetTableObjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetTableObjects::set_max_results): <p>Specifies how many values to return in a page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTableObjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTableObjects::set_next_token): <p>A continuation token if this is not the first call to retrieve these objects.</p>
    /// - On success, responds with [`GetTableObjectsOutput`](crate::output::GetTableObjectsOutput) with field(s):
    ///   - [`objects(Option<Vec<PartitionObjects>>)`](crate::output::GetTableObjectsOutput::objects): <p>A list of objects organized by partition keys.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTableObjectsOutput::next_token): <p>A continuation token indicating whether additional data is available.</p>
    /// - On failure, responds with [`SdkError<GetTableObjectsError>`](crate::error::GetTableObjectsError)
    pub fn get_table_objects(&self) -> fluent_builders::GetTableObjects<C, M, R> {
        fluent_builders::GetTableObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTemporaryGluePartitionCredentials`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_arn(impl Into<String>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::table_arn) / [`set_table_arn(Option<String>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_table_arn): <p>The ARN of the partitions' table.</p>
    ///   - [`partition(PartitionValueList)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::partition) / [`set_partition(Option<PartitionValueList>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_partition): <p>A list of partition values identifying a single partition.</p>
    ///   - [`permissions(Vec<Permission>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::permissions) / [`set_permissions(Option<Vec<Permission>>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_permissions): <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    ///   - [`duration_seconds(i32)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::duration_seconds) / [`set_duration_seconds(Option<i32>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_duration_seconds): <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    ///   - [`audit_context(AuditContext)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::audit_context) / [`set_audit_context(Option<AuditContext>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_audit_context): <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    ///   - [`supported_permission_types(Vec<PermissionType>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::supported_permission_types) / [`set_supported_permission_types(Option<Vec<PermissionType>>)`](crate::client::fluent_builders::GetTemporaryGluePartitionCredentials::set_supported_permission_types): <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    /// - On success, responds with [`GetTemporaryGluePartitionCredentialsOutput`](crate::output::GetTemporaryGluePartitionCredentialsOutput) with field(s):
    ///   - [`access_key_id(Option<String>)`](crate::output::GetTemporaryGluePartitionCredentialsOutput::access_key_id): <p>The access key ID for the temporary credentials.</p>
    ///   - [`secret_access_key(Option<String>)`](crate::output::GetTemporaryGluePartitionCredentialsOutput::secret_access_key): <p>The secret key for the temporary credentials.</p>
    ///   - [`session_token(Option<String>)`](crate::output::GetTemporaryGluePartitionCredentialsOutput::session_token): <p>The session token for the temporary credentials.</p>
    ///   - [`expiration(Option<DateTime>)`](crate::output::GetTemporaryGluePartitionCredentialsOutput::expiration): <p>The date and time when the temporary credentials expire.</p>
    /// - On failure, responds with [`SdkError<GetTemporaryGluePartitionCredentialsError>`](crate::error::GetTemporaryGluePartitionCredentialsError)
    pub fn get_temporary_glue_partition_credentials(
        &self,
    ) -> fluent_builders::GetTemporaryGluePartitionCredentials<C, M, R> {
        fluent_builders::GetTemporaryGluePartitionCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTemporaryGlueTableCredentials`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_arn(impl Into<String>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::table_arn) / [`set_table_arn(Option<String>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::set_table_arn): <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
    ///   - [`permissions(Vec<Permission>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::permissions) / [`set_permissions(Option<Vec<Permission>>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::set_permissions): <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    ///   - [`duration_seconds(i32)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::duration_seconds) / [`set_duration_seconds(Option<i32>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::set_duration_seconds): <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    ///   - [`audit_context(AuditContext)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::audit_context) / [`set_audit_context(Option<AuditContext>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::set_audit_context): <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    ///   - [`supported_permission_types(Vec<PermissionType>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::supported_permission_types) / [`set_supported_permission_types(Option<Vec<PermissionType>>)`](crate::client::fluent_builders::GetTemporaryGlueTableCredentials::set_supported_permission_types): <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    /// - On success, responds with [`GetTemporaryGlueTableCredentialsOutput`](crate::output::GetTemporaryGlueTableCredentialsOutput) with field(s):
    ///   - [`access_key_id(Option<String>)`](crate::output::GetTemporaryGlueTableCredentialsOutput::access_key_id): <p>The access key ID for the temporary credentials.</p>
    ///   - [`secret_access_key(Option<String>)`](crate::output::GetTemporaryGlueTableCredentialsOutput::secret_access_key): <p>The secret key for the temporary credentials.</p>
    ///   - [`session_token(Option<String>)`](crate::output::GetTemporaryGlueTableCredentialsOutput::session_token): <p>The session token for the temporary credentials.</p>
    ///   - [`expiration(Option<DateTime>)`](crate::output::GetTemporaryGlueTableCredentialsOutput::expiration): <p>The date and time when the temporary credentials expire.</p>
    /// - On failure, responds with [`SdkError<GetTemporaryGlueTableCredentialsError>`](crate::error::GetTemporaryGlueTableCredentialsError)
    pub fn get_temporary_glue_table_credentials(
        &self,
    ) -> fluent_builders::GetTemporaryGlueTableCredentials<C, M, R> {
        fluent_builders::GetTemporaryGlueTableCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkUnitResults`](crate::client::fluent_builders::GetWorkUnitResults) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkUnitResults::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::GetWorkUnitResults::set_query_id): <p>The ID of the plan query operation for which to get results.</p>
    ///   - [`work_unit_id(i64)`](crate::client::fluent_builders::GetWorkUnitResults::work_unit_id) / [`set_work_unit_id(i64)`](crate::client::fluent_builders::GetWorkUnitResults::set_work_unit_id): <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
    ///   - [`work_unit_token(impl Into<String>)`](crate::client::fluent_builders::GetWorkUnitResults::work_unit_token) / [`set_work_unit_token(Option<String>)`](crate::client::fluent_builders::GetWorkUnitResults::set_work_unit_token): <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
    /// - On success, responds with [`GetWorkUnitResultsOutput`](crate::output::GetWorkUnitResultsOutput) with field(s):
    ///   - [`result_stream(byte_stream::ByteStream)`](crate::output::GetWorkUnitResultsOutput::result_stream): <p>Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0 messages.</p>
    /// - On failure, responds with [`SdkError<GetWorkUnitResultsError>`](crate::error::GetWorkUnitResultsError)
    pub fn get_work_unit_results(&self) -> fluent_builders::GetWorkUnitResults<C, M, R> {
        fluent_builders::GetWorkUnitResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkUnits`](crate::client::fluent_builders::GetWorkUnits) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetWorkUnits::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetWorkUnits::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetWorkUnits::set_next_token): <p>A continuation token, if this is a continuation call.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetWorkUnits::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::GetWorkUnits::set_page_size): <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkUnits::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::GetWorkUnits::set_query_id): <p>The ID of the plan query operation.</p>
    /// - On success, responds with [`GetWorkUnitsOutput`](crate::output::GetWorkUnitsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetWorkUnitsOutput::next_token): <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    ///   - [`query_id(Option<String>)`](crate::output::GetWorkUnitsOutput::query_id): <p>The ID of the plan query operation.</p>
    ///   - [`work_unit_ranges(Option<Vec<WorkUnitRange>>)`](crate::output::GetWorkUnitsOutput::work_unit_ranges): <p>A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the execution service.</p>
    /// - On failure, responds with [`SdkError<GetWorkUnitsError>`](crate::error::GetWorkUnitsError)
    pub fn get_work_units(&self) -> fluent_builders::GetWorkUnits<C, M, R> {
        fluent_builders::GetWorkUnits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GrantPermissions`](crate::client::fluent_builders::GrantPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::GrantPermissions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::GrantPermissions::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`principal(DataLakePrincipal)`](crate::client::fluent_builders::GrantPermissions::principal) / [`set_principal(Option<DataLakePrincipal>)`](crate::client::fluent_builders::GrantPermissions::set_principal): <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>  <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::GrantPermissions::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::GrantPermissions::set_resource): <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
    ///   - [`permissions(Vec<Permission>)`](crate::client::fluent_builders::GrantPermissions::permissions) / [`set_permissions(Option<Vec<Permission>>)`](crate::client::fluent_builders::GrantPermissions::set_permissions): <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
    ///   - [`permissions_with_grant_option(Vec<Permission>)`](crate::client::fluent_builders::GrantPermissions::permissions_with_grant_option) / [`set_permissions_with_grant_option(Option<Vec<Permission>>)`](crate::client::fluent_builders::GrantPermissions::set_permissions_with_grant_option): <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
    /// - On success, responds with [`GrantPermissionsOutput`](crate::output::GrantPermissionsOutput)

    /// - On failure, responds with [`SdkError<GrantPermissionsError>`](crate::error::GrantPermissionsError)
    pub fn grant_permissions(&self) -> fluent_builders::GrantPermissions<C, M, R> {
        fluent_builders::GrantPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataCellsFilter`](crate::client::fluent_builders::ListDataCellsFilter) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataCellsFilter::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`table(TableResource)`](crate::client::fluent_builders::ListDataCellsFilter::table) / [`set_table(Option<TableResource>)`](crate::client::fluent_builders::ListDataCellsFilter::set_table): <p>A table in the Glue Data Catalog.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataCellsFilter::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataCellsFilter::set_next_token): <p>A continuation token, if this is a continuation call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataCellsFilter::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataCellsFilter::set_max_results): <p>The maximum size of the response.</p>
    /// - On success, responds with [`ListDataCellsFilterOutput`](crate::output::ListDataCellsFilterOutput) with field(s):
    ///   - [`data_cells_filters(Option<Vec<DataCellsFilter>>)`](crate::output::ListDataCellsFilterOutput::data_cells_filters): <p>A list of <code>DataCellFilter</code> structures.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataCellsFilterOutput::next_token): <p>A continuation token, if not all requested data cell filters have been returned.</p>
    /// - On failure, responds with [`SdkError<ListDataCellsFilterError>`](crate::error::ListDataCellsFilterError)
    pub fn list_data_cells_filter(&self) -> fluent_builders::ListDataCellsFilter<C, M, R> {
        fluent_builders::ListDataCellsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLFTags`](crate::client::fluent_builders::ListLFTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLFTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::ListLFTags::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::ListLFTags::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`resource_share_type(ResourceShareType)`](crate::client::fluent_builders::ListLFTags::resource_share_type) / [`set_resource_share_type(Option<ResourceShareType>)`](crate::client::fluent_builders::ListLFTags::set_resource_share_type): <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLFTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLFTags::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLFTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLFTags::set_next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    /// - On success, responds with [`ListLfTagsOutput`](crate::output::ListLfTagsOutput) with field(s):
    ///   - [`lf_tags(Option<Vec<LfTagPair>>)`](crate::output::ListLfTagsOutput::lf_tags): <p>A list of LF-tags that the requested has permission to view.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLfTagsOutput::next_token): <p>A continuation token, present if the current list segment is not the last.</p>
    /// - On failure, responds with [`SdkError<ListLFTagsError>`](crate::error::ListLFTagsError)
    pub fn list_lf_tags(&self) -> fluent_builders::ListLFTags<C, M, R> {
        fluent_builders::ListLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissions`](crate::client::fluent_builders::ListPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`principal(DataLakePrincipal)`](crate::client::fluent_builders::ListPermissions::principal) / [`set_principal(Option<DataLakePrincipal>)`](crate::client::fluent_builders::ListPermissions::set_principal): <p>Specifies a principal to filter the permissions returned.</p>
    ///   - [`resource_type(DataLakeResourceType)`](crate::client::fluent_builders::ListPermissions::resource_type) / [`set_resource_type(Option<DataLakeResourceType>)`](crate::client::fluent_builders::ListPermissions::set_resource_type): <p>Specifies a resource type to filter the permissions returned.</p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::ListPermissions::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::ListPermissions::set_resource): <p>A resource where you will get a list of the principal permissions.</p>  <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissions::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`include_related(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::include_related) / [`set_include_related(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_include_related): <p>Indicates that related permissions should be included in the results.</p>
    /// - On success, responds with [`ListPermissionsOutput`](crate::output::ListPermissionsOutput) with field(s):
    ///   - [`principal_resource_permissions(Option<Vec<PrincipalResourcePermissions>>)`](crate::output::ListPermissionsOutput::principal_resource_permissions): <p>A list of principals and their permissions on the resource for the specified principal and resource types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionsOutput::next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    /// - On failure, responds with [`SdkError<ListPermissionsError>`](crate::error::ListPermissionsError)
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions<C, M, R> {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResources`](crate::client::fluent_builders::ListResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_condition_list(Vec<FilterCondition>)`](crate::client::fluent_builders::ListResources::filter_condition_list) / [`set_filter_condition_list(Option<Vec<FilterCondition>>)`](crate::client::fluent_builders::ListResources::set_filter_condition_list): <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResources::set_max_results): <p>The maximum number of resource results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResources::set_next_token): <p>A continuation token, if this is not the first call to retrieve these resources.</p>
    /// - On success, responds with [`ListResourcesOutput`](crate::output::ListResourcesOutput) with field(s):
    ///   - [`resource_info_list(Option<Vec<ResourceInfo>>)`](crate::output::ListResourcesOutput::resource_info_list): <p>A summary of the data lake resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesOutput::next_token): <p>A continuation token, if this is not the first call to retrieve these resources.</p>
    /// - On failure, responds with [`SdkError<ListResourcesError>`](crate::error::ListResourcesError)
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTableStorageOptimizers`](crate::client::fluent_builders::ListTableStorageOptimizers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTableStorageOptimizers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_catalog_id): <p>The Catalog ID of the table.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_database_name): <p>Name of the database where the table is present.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_table_name): <p>Name of the table.</p>
    ///   - [`storage_optimizer_type(OptimizerType)`](crate::client::fluent_builders::ListTableStorageOptimizers::storage_optimizer_type) / [`set_storage_optimizer_type(Option<OptimizerType>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_storage_optimizer_type): <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTableStorageOptimizers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_max_results): <p>The number of storage optimizers to return on each call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTableStorageOptimizers::set_next_token): <p>A continuation token, if this is a continuation call.</p>
    /// - On success, responds with [`ListTableStorageOptimizersOutput`](crate::output::ListTableStorageOptimizersOutput) with field(s):
    ///   - [`storage_optimizer_list(Option<Vec<StorageOptimizer>>)`](crate::output::ListTableStorageOptimizersOutput::storage_optimizer_list): <p>A list of the storage optimizers associated with a table.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTableStorageOptimizersOutput::next_token): <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    /// - On failure, responds with [`SdkError<ListTableStorageOptimizersError>`](crate::error::ListTableStorageOptimizersError)
    pub fn list_table_storage_optimizers(
        &self,
    ) -> fluent_builders::ListTableStorageOptimizers<C, M, R> {
        fluent_builders::ListTableStorageOptimizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTransactions`](crate::client::fluent_builders::ListTransactions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTransactions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::ListTransactions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::ListTransactions::set_catalog_id): <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
    ///   - [`status_filter(TransactionStatusFilter)`](crate::client::fluent_builders::ListTransactions::status_filter) / [`set_status_filter(Option<TransactionStatusFilter>)`](crate::client::fluent_builders::ListTransactions::set_status_filter): <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTransactions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTransactions::set_max_results): <p>The maximum number of transactions to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTransactions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTransactions::set_next_token): <p>A continuation token if this is not the first call to retrieve transactions.</p>
    /// - On success, responds with [`ListTransactionsOutput`](crate::output::ListTransactionsOutput) with field(s):
    ///   - [`transactions(Option<Vec<TransactionDescription>>)`](crate::output::ListTransactionsOutput::transactions): <p>A list of transactions. The record for each transaction is a <code>TransactionDescription</code> object.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTransactionsOutput::next_token): <p>A continuation token indicating whether additional data is available.</p>
    /// - On failure, responds with [`SdkError<ListTransactionsError>`](crate::error::ListTransactionsError)
    pub fn list_transactions(&self) -> fluent_builders::ListTransactions<C, M, R> {
        fluent_builders::ListTransactions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDataLakeSettings`](crate::client::fluent_builders::PutDataLakeSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::PutDataLakeSettings::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::PutDataLakeSettings::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`data_lake_settings(DataLakeSettings)`](crate::client::fluent_builders::PutDataLakeSettings::data_lake_settings) / [`set_data_lake_settings(Option<DataLakeSettings>)`](crate::client::fluent_builders::PutDataLakeSettings::set_data_lake_settings): <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
    /// - On success, responds with [`PutDataLakeSettingsOutput`](crate::output::PutDataLakeSettingsOutput)

    /// - On failure, responds with [`SdkError<PutDataLakeSettingsError>`](crate::error::PutDataLakeSettingsError)
    pub fn put_data_lake_settings(&self) -> fluent_builders::PutDataLakeSettings<C, M, R> {
        fluent_builders::PutDataLakeSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterResource`](crate::client::fluent_builders::RegisterResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RegisterResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
    ///   - [`use_service_linked_role(bool)`](crate::client::fluent_builders::RegisterResource::use_service_linked_role) / [`set_use_service_linked_role(Option<bool>)`](crate::client::fluent_builders::RegisterResource::set_use_service_linked_role): <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>  <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterResource::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::RegisterResource::set_role_arn): <p>The identifier for the role that registers the resource.</p>
    /// - On success, responds with [`RegisterResourceOutput`](crate::output::RegisterResourceOutput)

    /// - On failure, responds with [`SdkError<RegisterResourceError>`](crate::error::RegisterResourceError)
    pub fn register_resource(&self) -> fluent_builders::RegisterResource<C, M, R> {
        fluent_builders::RegisterResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveLFTagsFromResource`](crate::client::fluent_builders::RemoveLFTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::RemoveLFTagsFromResource::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::RemoveLFTagsFromResource::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::RemoveLFTagsFromResource::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::RemoveLFTagsFromResource::set_resource): <p>The database, table, or column resource where you want to remove an LF-tag.</p>
    ///   - [`lf_tags(Vec<LfTagPair>)`](crate::client::fluent_builders::RemoveLFTagsFromResource::lf_tags) / [`set_lf_tags(Option<Vec<LfTagPair>>)`](crate::client::fluent_builders::RemoveLFTagsFromResource::set_lf_tags): <p>The LF-tags to be removed from the resource.</p>
    /// - On success, responds with [`RemoveLfTagsFromResourceOutput`](crate::output::RemoveLfTagsFromResourceOutput) with field(s):
    ///   - [`failures(Option<Vec<LfTagError>>)`](crate::output::RemoveLfTagsFromResourceOutput::failures): <p>A list of failures to untag a resource.</p>
    /// - On failure, responds with [`SdkError<RemoveLFTagsFromResourceError>`](crate::error::RemoveLFTagsFromResourceError)
    pub fn remove_lf_tags_from_resource(
        &self,
    ) -> fluent_builders::RemoveLFTagsFromResource<C, M, R> {
        fluent_builders::RemoveLFTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokePermissions`](crate::client::fluent_builders::RevokePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::RevokePermissions::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::RevokePermissions::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`principal(DataLakePrincipal)`](crate::client::fluent_builders::RevokePermissions::principal) / [`set_principal(Option<DataLakePrincipal>)`](crate::client::fluent_builders::RevokePermissions::set_principal): <p>The principal to be revoked permissions on the resource.</p>
    ///   - [`resource(Resource)`](crate::client::fluent_builders::RevokePermissions::resource) / [`set_resource(Option<Resource>)`](crate::client::fluent_builders::RevokePermissions::set_resource): <p>The resource to which permissions are to be revoked.</p>
    ///   - [`permissions(Vec<Permission>)`](crate::client::fluent_builders::RevokePermissions::permissions) / [`set_permissions(Option<Vec<Permission>>)`](crate::client::fluent_builders::RevokePermissions::set_permissions): <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    ///   - [`permissions_with_grant_option(Vec<Permission>)`](crate::client::fluent_builders::RevokePermissions::permissions_with_grant_option) / [`set_permissions_with_grant_option(Option<Vec<Permission>>)`](crate::client::fluent_builders::RevokePermissions::set_permissions_with_grant_option): <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
    /// - On success, responds with [`RevokePermissionsOutput`](crate::output::RevokePermissionsOutput)

    /// - On failure, responds with [`SdkError<RevokePermissionsError>`](crate::error::RevokePermissionsError)
    pub fn revoke_permissions(&self) -> fluent_builders::RevokePermissions<C, M, R> {
        fluent_builders::RevokePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchDatabasesByLFTags`](crate::client::fluent_builders::SearchDatabasesByLFTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchDatabasesByLFTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::set_next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchDatabasesByLFTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`expression(Vec<LfTag>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::expression) / [`set_expression(Option<Vec<LfTag>>)`](crate::client::fluent_builders::SearchDatabasesByLFTags::set_expression): <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
    /// - On success, responds with [`SearchDatabasesByLfTagsOutput`](crate::output::SearchDatabasesByLfTagsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::SearchDatabasesByLfTagsOutput::next_token): <p>A continuation token, present if the current list segment is not the last.</p>
    ///   - [`database_list(Option<Vec<TaggedDatabase>>)`](crate::output::SearchDatabasesByLfTagsOutput::database_list): <p>A list of databases that meet the LF-tag conditions.</p>
    /// - On failure, responds with [`SdkError<SearchDatabasesByLFTagsError>`](crate::error::SearchDatabasesByLFTagsError)
    pub fn search_databases_by_lf_tags(&self) -> fluent_builders::SearchDatabasesByLFTags<C, M, R> {
        fluent_builders::SearchDatabasesByLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchTablesByLFTags`](crate::client::fluent_builders::SearchTablesByLFTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchTablesByLFTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchTablesByLFTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchTablesByLFTags::set_next_token): <p>A continuation token, if this is not the first call to retrieve this list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchTablesByLFTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchTablesByLFTags::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::SearchTablesByLFTags::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::SearchTablesByLFTags::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`expression(Vec<LfTag>)`](crate::client::fluent_builders::SearchTablesByLFTags::expression) / [`set_expression(Option<Vec<LfTag>>)`](crate::client::fluent_builders::SearchTablesByLFTags::set_expression): <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
    /// - On success, responds with [`SearchTablesByLfTagsOutput`](crate::output::SearchTablesByLfTagsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::SearchTablesByLfTagsOutput::next_token): <p>A continuation token, present if the current list segment is not the last.</p>
    ///   - [`table_list(Option<Vec<TaggedTable>>)`](crate::output::SearchTablesByLfTagsOutput::table_list): <p>A list of tables that meet the LF-tag conditions.</p>
    /// - On failure, responds with [`SdkError<SearchTablesByLFTagsError>`](crate::error::SearchTablesByLFTagsError)
    pub fn search_tables_by_lf_tags(&self) -> fluent_builders::SearchTablesByLFTags<C, M, R> {
        fluent_builders::SearchTablesByLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartQueryPlanning`](crate::client::fluent_builders::StartQueryPlanning) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_planning_context(QueryPlanningContext)`](crate::client::fluent_builders::StartQueryPlanning::query_planning_context) / [`set_query_planning_context(Option<QueryPlanningContext>)`](crate::client::fluent_builders::StartQueryPlanning::set_query_planning_context): <p>A structure containing information about the query plan.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::StartQueryPlanning::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::StartQueryPlanning::set_query_string): <p>A PartiQL query statement used as an input to the planner service.</p>
    /// - On success, responds with [`StartQueryPlanningOutput`](crate::output::StartQueryPlanningOutput) with field(s):
    ///   - [`query_id(Option<String>)`](crate::output::StartQueryPlanningOutput::query_id): <p>The ID of the plan query operation can be used to fetch the actual work unit descriptors that are produced as the result of the operation. The ID is also used to get the query state and as an input to the <code>Execute</code> operation.</p>
    /// - On failure, responds with [`SdkError<StartQueryPlanningError>`](crate::error::StartQueryPlanningError)
    pub fn start_query_planning(&self) -> fluent_builders::StartQueryPlanning<C, M, R> {
        fluent_builders::StartQueryPlanning::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTransaction`](crate::client::fluent_builders::StartTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transaction_type(TransactionType)`](crate::client::fluent_builders::StartTransaction::transaction_type) / [`set_transaction_type(Option<TransactionType>)`](crate::client::fluent_builders::StartTransaction::set_transaction_type): <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
    /// - On success, responds with [`StartTransactionOutput`](crate::output::StartTransactionOutput) with field(s):
    ///   - [`transaction_id(Option<String>)`](crate::output::StartTransactionOutput::transaction_id): <p>An opaque identifier for the transaction.</p>
    /// - On failure, responds with [`SdkError<StartTransactionError>`](crate::error::StartTransactionError)
    pub fn start_transaction(&self) -> fluent_builders::StartTransaction<C, M, R> {
        fluent_builders::StartTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLFTag`](crate::client::fluent_builders::UpdateLFTag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLFTag::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::UpdateLFTag::set_catalog_id): <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    ///   - [`tag_key(impl Into<String>)`](crate::client::fluent_builders::UpdateLFTag::tag_key) / [`set_tag_key(Option<String>)`](crate::client::fluent_builders::UpdateLFTag::set_tag_key): <p>The key-name for the LF-tag for which to add or delete values.</p>
    ///   - [`tag_values_to_delete(Vec<String>)`](crate::client::fluent_builders::UpdateLFTag::tag_values_to_delete) / [`set_tag_values_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLFTag::set_tag_values_to_delete): <p>A list of LF-tag values to delete from the LF-tag.</p>
    ///   - [`tag_values_to_add(Vec<String>)`](crate::client::fluent_builders::UpdateLFTag::tag_values_to_add) / [`set_tag_values_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLFTag::set_tag_values_to_add): <p>A list of LF-tag values to add from the LF-tag.</p>
    /// - On success, responds with [`UpdateLfTagOutput`](crate::output::UpdateLfTagOutput)

    /// - On failure, responds with [`SdkError<UpdateLFTagError>`](crate::error::UpdateLFTagError)
    pub fn update_lf_tag(&self) -> fluent_builders::UpdateLFTag<C, M, R> {
        fluent_builders::UpdateLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResource`](crate::client::fluent_builders::UpdateResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_role_arn): <p>The new role to use for the given resource registered in Lake Formation.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateResource::set_resource_arn): <p>The resource ARN.</p>
    /// - On success, responds with [`UpdateResourceOutput`](crate::output::UpdateResourceOutput)

    /// - On failure, responds with [`SdkError<UpdateResourceError>`](crate::error::UpdateResourceError)
    pub fn update_resource(&self) -> fluent_builders::UpdateResource<C, M, R> {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTableObjects`](crate::client::fluent_builders::UpdateTableObjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTableObjects::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::UpdateTableObjects::set_catalog_id): <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTableObjects::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::UpdateTableObjects::set_database_name): <p>The database containing the governed table to update.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTableObjects::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTableObjects::set_table_name): <p>The governed table to update.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTableObjects::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::UpdateTableObjects::set_transaction_id): <p>The transaction at which to do the write.</p>
    ///   - [`write_operations(Vec<WriteOperation>)`](crate::client::fluent_builders::UpdateTableObjects::write_operations) / [`set_write_operations(Option<Vec<WriteOperation>>)`](crate::client::fluent_builders::UpdateTableObjects::set_write_operations): <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
    /// - On success, responds with [`UpdateTableObjectsOutput`](crate::output::UpdateTableObjectsOutput)

    /// - On failure, responds with [`SdkError<UpdateTableObjectsError>`](crate::error::UpdateTableObjectsError)
    pub fn update_table_objects(&self) -> fluent_builders::UpdateTableObjects<C, M, R> {
        fluent_builders::UpdateTableObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTableStorageOptimizer`](crate::client::fluent_builders::UpdateTableStorageOptimizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`catalog_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::catalog_id) / [`set_catalog_id(Option<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::set_catalog_id): <p>The Catalog ID of the table.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::set_database_name): <p>Name of the database where the table is present.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::set_table_name): <p>Name of the table for which to enable the storage optimizer.</p>
    ///   - [`storage_optimizer_config(HashMap<OptimizerType, HashMap<String, String>>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::storage_optimizer_config) / [`set_storage_optimizer_config(Option<HashMap<OptimizerType, HashMap<String, String>>>)`](crate::client::fluent_builders::UpdateTableStorageOptimizer::set_storage_optimizer_config): <p>Name of the table for which to enable the storage optimizer.</p>
    /// - On success, responds with [`UpdateTableStorageOptimizerOutput`](crate::output::UpdateTableStorageOptimizerOutput) with field(s):
    ///   - [`result(Option<String>)`](crate::output::UpdateTableStorageOptimizerOutput::result): <p>A response indicating the success of failure of the operation.</p>
    /// - On failure, responds with [`SdkError<UpdateTableStorageOptimizerError>`](crate::error::UpdateTableStorageOptimizerError)
    pub fn update_table_storage_optimizer(
        &self,
    ) -> fluent_builders::UpdateTableStorageOptimizer<C, M, R> {
        fluent_builders::UpdateTableStorageOptimizer::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddLFTagsToResource`.
    ///
    /// <p>Attaches one or more LF-tags to an existing resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddLFTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_lf_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddLFTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddLFTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddLfTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddLFTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddLfTagsToResourceInputOperationOutputAlias,
                crate::output::AddLfTagsToResourceOutput,
                crate::error::AddLFTagsToResourceError,
                crate::input::AddLfTagsToResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `LFTags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The LF-tags to attach to the resource.</p>
        pub fn lf_tags(mut self, input: crate::model::LfTagPair) -> Self {
            self.inner = self.inner.lf_tags(input);
            self
        }
        /// <p>The LF-tags to attach to the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.inner = self.inner.set_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGrantPermissions`.
    ///
    /// <p>Batch operation to grant permissions to the principal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGrantPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_grant_permissions_input::Builder,
    }
    impl<C, M, R> BatchGrantPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGrantPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGrantPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGrantPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGrantPermissionsInputOperationOutputAlias,
                crate::output::BatchGrantPermissionsOutput,
                crate::error::BatchGrantPermissionsError,
                crate::input::BatchGrantPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn entries(mut self, input: crate::model::BatchPermissionsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchRevokePermissions`.
    ///
    /// <p>Batch operation to revoke permissions from the principal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchRevokePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_revoke_permissions_input::Builder,
    }
    impl<C, M, R> BatchRevokePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchRevokePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchRevokePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchRevokePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchRevokePermissionsInputOperationOutputAlias,
                crate::output::BatchRevokePermissionsOutput,
                crate::error::BatchRevokePermissionsError,
                crate::input::BatchRevokePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn entries(mut self, input: crate::model::BatchPermissionsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelTransaction`.
    ///
    /// <p>Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_transaction_input::Builder,
    }
    impl<C, M, R> CancelTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelTransactionInputOperationOutputAlias,
                crate::output::CancelTransactionOutput,
                crate::error::CancelTransactionError,
                crate::input::CancelTransactionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The transaction to cancel.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction to cancel.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CommitTransaction`.
    ///
    /// <p>Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted. This API action is idempotent if called multiple times for the same transaction.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CommitTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::commit_transaction_input::Builder,
    }
    impl<C, M, R> CommitTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CommitTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CommitTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::CommitTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CommitTransactionInputOperationOutputAlias,
                crate::output::CommitTransactionOutput,
                crate::error::CommitTransactionError,
                crate::input::CommitTransactionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The transaction to commit.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction to commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataCellsFilter`.
    ///
    /// <p>Creates a data cell filter to allow one to grant access to certain columns on certain rows.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataCellsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_cells_filter_input::Builder,
    }
    impl<C, M, R> CreateDataCellsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataCellsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataCellsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataCellsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataCellsFilterInputOperationOutputAlias,
                crate::output::CreateDataCellsFilterOutput,
                crate::error::CreateDataCellsFilterError,
                crate::input::CreateDataCellsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
        pub fn table_data(mut self, input: crate::model::DataCellsFilter) -> Self {
            self.inner = self.inner.table_data(input);
            self
        }
        /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
        pub fn set_table_data(
            mut self,
            input: std::option::Option<crate::model::DataCellsFilter>,
        ) -> Self {
            self.inner = self.inner.set_table_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLFTag`.
    ///
    /// <p>Creates an LF-tag with the specified name and values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lf_tag_input::Builder,
    }
    impl<C, M, R> CreateLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLfTagInputOperationOutputAlias,
                crate::output::CreateLfTagOutput,
                crate::error::CreateLFTagError,
                crate::input::CreateLfTagInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataCellsFilter`.
    ///
    /// <p>Deletes a data cell filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataCellsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_cells_filter_input::Builder,
    }
    impl<C, M, R> DeleteDataCellsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataCellsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataCellsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataCellsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataCellsFilterInputOperationOutputAlias,
                crate::output::DeleteDataCellsFilterOutput,
                crate::error::DeleteDataCellsFilterError,
                crate::input::DeleteDataCellsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn table_catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_catalog_id(input.into());
            self
        }
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn set_table_catalog_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_catalog_id(input);
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A table in the database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>A table in the database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLFTag`.
    ///
    /// <p>Deletes the specified LF-tag key name. If the attribute key does not exist or the LF-tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the LF-tag key is still attached with resources. You can consider untagging resources with this LF-tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lf_tag_input::Builder,
    }
    impl<C, M, R> DeleteLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLfTagInputOperationOutputAlias,
                crate::output::DeleteLfTagOutput,
                crate::error::DeleteLFTagError,
                crate::input::DeleteLfTagInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the LF-tag to delete.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(input.into());
            self
        }
        /// <p>The key-name for the LF-tag to delete.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObjectsOnCancel`.
    ///
    /// <p>For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels. </p>
    /// <p> The Glue ETL library function <code>write_dynamic_frame.from_catalog()</code> includes an option to automatically call <code>DeleteObjectsOnCancel</code> before writes. For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes">Rolling Back Amazon S3 Writes</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteObjectsOnCancel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_objects_on_cancel_input::Builder,
    }
    impl<C, M, R> DeleteObjectsOnCancel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteObjectsOnCancel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectsOnCancelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectsOnCancelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteObjectsOnCancelInputOperationOutputAlias,
                crate::output::DeleteObjectsOnCancelOutput,
                crate::error::DeleteObjectsOnCancelError,
                crate::input::DeleteObjectsOnCancelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database that contains the governed table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The database that contains the governed table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the governed table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the governed table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>ID of the transaction that the writes occur in.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>ID of the transaction that the writes occur in.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// Appends an item to `Objects`.
        ///
        /// To override the contents of this collection use [`set_objects`](Self::set_objects).
        ///
        /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
        pub fn objects(mut self, input: crate::model::VirtualObject) -> Self {
            self.inner = self.inner.objects(input);
            self
        }
        /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
        pub fn set_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualObject>>,
        ) -> Self {
            self.inner = self.inner.set_objects(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterResource`.
    ///
    /// <p>Deregisters the resource as managed by the Data Catalog.</p>
    /// <p>When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_resource_input::Builder,
    }
    impl<C, M, R> DeregisterResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterResourceInputOperationOutputAlias,
                crate::output::DeregisterResourceOutput,
                crate::error::DeregisterResourceError,
                crate::input::DeregisterResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResource`.
    ///
    /// <p>Retrieves the current data access role for the given resource registered in Lake Formation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_input::Builder,
    }
    impl<C, M, R> DescribeResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceInputOperationOutputAlias,
                crate::output::DescribeResourceOutput,
                crate::error::DescribeResourceError,
                crate::input::DescribeResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTransaction`.
    ///
    /// <p>Returns the details of a single transaction.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_transaction_input::Builder,
    }
    impl<C, M, R> DescribeTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTransactionInputOperationOutputAlias,
                crate::output::DescribeTransactionOutput,
                crate::error::DescribeTransactionError,
                crate::input::DescribeTransactionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The transaction for which to return status.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction for which to return status.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExtendTransaction`.
    ///
    /// <p>Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted.</p>
    /// <p>Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExtendTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::extend_transaction_input::Builder,
    }
    impl<C, M, R> ExtendTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExtendTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExtendTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExtendTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExtendTransactionInputOperationOutputAlias,
                crate::output::ExtendTransactionOutput,
                crate::error::ExtendTransactionError,
                crate::input::ExtendTransactionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The transaction to extend.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction to extend.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataLakeSettings`.
    ///
    /// <p>Retrieves the list of the data lake administrators of a Lake Formation-managed data lake. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataLakeSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_lake_settings_input::Builder,
    }
    impl<C, M, R> GetDataLakeSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataLakeSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataLakeSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataLakeSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataLakeSettingsInputOperationOutputAlias,
                crate::output::GetDataLakeSettingsOutput,
                crate::error::GetDataLakeSettingsError,
                crate::input::GetDataLakeSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEffectivePermissionsForPath`.
    ///
    /// <p>Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEffectivePermissionsForPath<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_effective_permissions_for_path_input::Builder,
    }
    impl<C, M, R> GetEffectivePermissionsForPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEffectivePermissionsForPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEffectivePermissionsForPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEffectivePermissionsForPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEffectivePermissionsForPathInputOperationOutputAlias,
                crate::output::GetEffectivePermissionsForPathOutput,
                crate::error::GetEffectivePermissionsForPathError,
                crate::input::GetEffectivePermissionsForPathInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEffectivePermissionsForPathPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetEffectivePermissionsForPathPaginator<C, M, R> {
            crate::paginator::GetEffectivePermissionsForPathPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLFTag`.
    ///
    /// <p>Returns an LF-tag definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lf_tag_input::Builder,
    }
    impl<C, M, R> GetLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLfTagInputOperationOutputAlias,
                crate::output::GetLfTagOutput,
                crate::error::GetLFTagError,
                crate::input::GetLfTagInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryState`.
    ///
    /// <p>Returns the state of a query previously submitted. Clients are expected to poll <code>GetQueryState</code> to monitor the current state of the planning before retrieving the work units. A query state is only visible to the principal that made the initial call to <code>StartQueryPlanning</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQueryState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_state_input::Builder,
    }
    impl<C, M, R> GetQueryState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueryState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueryStateInputOperationOutputAlias,
                crate::output::GetQueryStateOutput,
                crate::error::GetQueryStateError,
                crate::input::GetQueryStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryStatistics`.
    ///
    /// <p>Retrieves statistics on the planning and execution of a query.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQueryStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_statistics_input::Builder,
    }
    impl<C, M, R> GetQueryStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueryStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueryStatisticsInputOperationOutputAlias,
                crate::output::GetQueryStatisticsOutput,
                crate::error::GetQueryStatisticsError,
                crate::input::GetQueryStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceLFTags`.
    ///
    /// <p>Returns the LF-tags applied to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_lf_tags_input::Builder,
    }
    impl<C, M, R> GetResourceLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceLfTagsInputOperationOutputAlias,
                crate::output::GetResourceLfTagsOutput,
                crate::error::GetResourceLFTagsError,
                crate::input::GetResourceLfTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p>Indicates whether to show the assigned LF-tags.</p>
        pub fn show_assigned_lf_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.show_assigned_lf_tags(input);
            self
        }
        /// <p>Indicates whether to show the assigned LF-tags.</p>
        pub fn set_show_assigned_lf_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_assigned_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTableObjects`.
    ///
    /// <p>Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTableObjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_table_objects_input::Builder,
    }
    impl<C, M, R> GetTableObjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTableObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableObjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTableObjectsInputOperationOutputAlias,
                crate::output::GetTableObjectsOutput,
                crate::error::GetTableObjectsError,
                crate::input::GetTableObjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTableObjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTableObjectsPaginator<C, M, R> {
            crate::paginator::GetTableObjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database containing the governed table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The database containing the governed table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The governed table for which to retrieve objects.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The governed table for which to retrieve objects.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_as_of_time(input);
            self
        }
        /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_as_of_time(input);
            self
        }
        /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
        /// <ul>
        /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
        /// <li> <p>The logical operators supported are: AND</p> </li>
        /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
        /// </ul>
        pub fn partition_predicate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_predicate(input.into());
            self
        }
        /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
        /// <ul>
        /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
        /// <li> <p>The logical operators supported are: AND</p> </li>
        /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
        /// </ul>
        pub fn set_partition_predicate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partition_predicate(input);
            self
        }
        /// <p>Specifies how many values to return in a page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies how many values to return in a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemporaryGluePartitionCredentials`.
    ///
    /// <p>This API is identical to <code>GetTemporaryTableCredentials</code> except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTemporaryGluePartitionCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_temporary_glue_partition_credentials_input::Builder,
    }
    impl<C, M, R> GetTemporaryGluePartitionCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemporaryGluePartitionCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemporaryGluePartitionCredentialsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetTemporaryGluePartitionCredentialsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemporaryGluePartitionCredentialsInputOperationOutputAlias,
                crate::output::GetTemporaryGluePartitionCredentialsOutput,
                crate::error::GetTemporaryGluePartitionCredentialsError,
                crate::input::GetTemporaryGluePartitionCredentialsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the partitions' table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(input.into());
            self
        }
        /// <p>The ARN of the partitions' table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// <p>A list of partition values identifying a single partition.</p>
        pub fn partition(mut self, input: crate::model::PartitionValueList) -> Self {
            self.inner = self.inner.partition(input);
            self
        }
        /// <p>A list of partition values identifying a single partition.</p>
        pub fn set_partition(
            mut self,
            input: std::option::Option<crate::model::PartitionValueList>,
        ) -> Self {
            self.inner = self.inner.set_partition(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_seconds(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn audit_context(mut self, input: crate::model::AuditContext) -> Self {
            self.inner = self.inner.audit_context(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn set_audit_context(
            mut self,
            input: std::option::Option<crate::model::AuditContext>,
        ) -> Self {
            self.inner = self.inner.set_audit_context(input);
            self
        }
        /// Appends an item to `SupportedPermissionTypes`.
        ///
        /// To override the contents of this collection use [`set_supported_permission_types`](Self::set_supported_permission_types).
        ///
        /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn supported_permission_types(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.supported_permission_types(input);
            self
        }
        /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn set_supported_permission_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.inner = self.inner.set_supported_permission_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemporaryGlueTableCredentials`.
    ///
    /// <p>Allows a caller in a secure environment to assume a role with permission to access Amazon S3. In order to vend such credentials, Lake Formation assumes the role associated with a registered location, for example an Amazon S3 bucket, with a scope down policy which restricts the access to a single prefix.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTemporaryGlueTableCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_temporary_glue_table_credentials_input::Builder,
    }
    impl<C, M, R> GetTemporaryGlueTableCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemporaryGlueTableCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemporaryGlueTableCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemporaryGlueTableCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemporaryGlueTableCredentialsInputOperationOutputAlias,
                crate::output::GetTemporaryGlueTableCredentialsOutput,
                crate::error::GetTemporaryGlueTableCredentialsError,
                crate::input::GetTemporaryGlueTableCredentialsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(input.into());
            self
        }
        /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_seconds(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn audit_context(mut self, input: crate::model::AuditContext) -> Self {
            self.inner = self.inner.audit_context(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn set_audit_context(
            mut self,
            input: std::option::Option<crate::model::AuditContext>,
        ) -> Self {
            self.inner = self.inner.set_audit_context(input);
            self
        }
        /// Appends an item to `SupportedPermissionTypes`.
        ///
        /// To override the contents of this collection use [`set_supported_permission_types`](Self::set_supported_permission_types).
        ///
        /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn supported_permission_types(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.supported_permission_types(input);
            self
        }
        /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn set_supported_permission_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.inner = self.inner.set_supported_permission_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkUnitResults`.
    ///
    /// <p>Returns the work units resulting from the query. Work units can be executed in any order and in parallel. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkUnitResults<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_work_unit_results_input::Builder,
    }
    impl<C, M, R> GetWorkUnitResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkUnitResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkUnitResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkUnitResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkUnitResultsInputOperationOutputAlias,
                crate::output::GetWorkUnitResultsOutput,
                crate::error::GetWorkUnitResultsError,
                crate::input::GetWorkUnitResultsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the plan query operation for which to get results.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID of the plan query operation for which to get results.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
        /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
        pub fn work_unit_id(mut self, input: i64) -> Self {
            self.inner = self.inner.work_unit_id(input);
            self
        }
        /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
        pub fn set_work_unit_id(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_work_unit_id(input);
            self
        }
        /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
        pub fn work_unit_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_unit_token(input.into());
            self
        }
        /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
        pub fn set_work_unit_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_work_unit_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkUnits`.
    ///
    /// <p>Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkUnits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_work_units_input::Builder,
    }
    impl<C, M, R> GetWorkUnits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkUnits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkUnitsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkUnitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkUnitsInputOperationOutputAlias,
                crate::output::GetWorkUnitsOutput,
                crate::error::GetWorkUnitsError,
                crate::input::GetWorkUnitsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetWorkUnitsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetWorkUnitsPaginator<C, M, R> {
            crate::paginator::GetWorkUnitsPaginator::new(self.handle, self.inner)
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GrantPermissions`.
    ///
    /// <p>Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>
    /// <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GrantPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::grant_permissions_input::Builder,
    }
    impl<C, M, R> GrantPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GrantPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GrantPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GrantPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GrantPermissionsInputOperationOutputAlias,
                crate::output::GrantPermissionsOutput,
                crate::error::GrantPermissionsError,
                crate::input::GrantPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(input);
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `PermissionsWithGrantOption`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn permissions_with_grant_option(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions_with_grant_option(input);
            self
        }
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_with_grant_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataCellsFilter`.
    ///
    /// <p>Lists all the data cell filters on a table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataCellsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_cells_filter_input::Builder,
    }
    impl<C, M, R> ListDataCellsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataCellsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataCellsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataCellsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataCellsFilterInputOperationOutputAlias,
                crate::output::ListDataCellsFilterOutput,
                crate::error::ListDataCellsFilterError,
                crate::input::ListDataCellsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataCellsFilterPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataCellsFilterPaginator<C, M, R> {
            crate::paginator::ListDataCellsFilterPaginator::new(self.handle, self.inner)
        }
        /// <p>A table in the Glue Data Catalog.</p>
        pub fn table(mut self, input: crate::model::TableResource) -> Self {
            self.inner = self.inner.table(input);
            self
        }
        /// <p>A table in the Glue Data Catalog.</p>
        pub fn set_table(
            mut self,
            input: std::option::Option<crate::model::TableResource>,
        ) -> Self {
            self.inner = self.inner.set_table(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLFTags`.
    ///
    /// <p>Lists LF-tags that the requester has permission to view. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lf_tags_input::Builder,
    }
    impl<C, M, R> ListLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLfTagsInputOperationOutputAlias,
                crate::output::ListLfTagsOutput,
                crate::error::ListLFTagsError,
                crate::input::ListLfTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLfTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLfTagsPaginator<C, M, R> {
            crate::paginator::ListLfTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
        pub fn resource_share_type(mut self, input: crate::model::ResourceShareType) -> Self {
            self.inner = self.inner.resource_share_type(input);
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
        pub fn set_resource_share_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareType>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_type(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.</p>
    /// <p>This operation returns only those permissions that have been explicitly granted.</p>
    /// <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl<C, M, R> ListPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionsInputOperationOutputAlias,
                crate::output::ListPermissionsOutput,
                crate::error::ListPermissionsError,
                crate::input::ListPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionsPaginator<C, M, R> {
            crate::paginator::ListPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(input);
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn resource_type(mut self, input: crate::model::DataLakeResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::DataLakeResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Indicates that related permissions should be included in the results.</p>
        pub fn include_related(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_related(input.into());
            self
        }
        /// <p>Indicates that related permissions should be included in the results.</p>
        pub fn set_include_related(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_include_related(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists the resources registered to be managed by the Data Catalog.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourcesPaginator<C, M, R> {
            crate::paginator::ListResourcesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `FilterConditionList`.
        ///
        /// To override the contents of this collection use [`set_filter_condition_list`](Self::set_filter_condition_list).
        ///
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn filter_condition_list(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.filter_condition_list(input);
            self
        }
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn set_filter_condition_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        ) -> Self {
            self.inner = self.inner.set_filter_condition_list(input);
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTableStorageOptimizers`.
    ///
    /// <p>Returns the configuration of all storage optimizers associated with a specified table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTableStorageOptimizers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_table_storage_optimizers_input::Builder,
    }
    impl<C, M, R> ListTableStorageOptimizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTableStorageOptimizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTableStorageOptimizersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTableStorageOptimizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTableStorageOptimizersInputOperationOutputAlias,
                crate::output::ListTableStorageOptimizersOutput,
                crate::error::ListTableStorageOptimizersError,
                crate::input::ListTableStorageOptimizersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTableStorageOptimizersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListTableStorageOptimizersPaginator<C, M, R> {
            crate::paginator::ListTableStorageOptimizersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>Name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
        pub fn storage_optimizer_type(mut self, input: crate::model::OptimizerType) -> Self {
            self.inner = self.inner.storage_optimizer_type(input);
            self
        }
        /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
        pub fn set_storage_optimizer_type(
            mut self,
            input: std::option::Option<crate::model::OptimizerType>,
        ) -> Self {
            self.inner = self.inner.set_storage_optimizer_type(input);
            self
        }
        /// <p>The number of storage optimizers to return on each call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of storage optimizers to return on each call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTransactions`.
    ///
    /// <p>Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.</p>
    /// <p>This operation can help you identify uncommitted transactions or to get information about transactions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTransactions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_transactions_input::Builder,
    }
    impl<C, M, R> ListTransactions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTransactions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTransactionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTransactionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTransactionsInputOperationOutputAlias,
                crate::output::ListTransactionsOutput,
                crate::error::ListTransactionsError,
                crate::input::ListTransactionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTransactionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTransactionsPaginator<C, M, R> {
            crate::paginator::ListTransactionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
        pub fn status_filter(mut self, input: crate::model::TransactionStatusFilter) -> Self {
            self.inner = self.inner.status_filter(input);
            self
        }
        /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::TransactionStatusFilter>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of transactions to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of transactions to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDataLakeSettings`.
    ///
    /// <p>Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake Formation Permissions</a>.</p>
    /// <p>This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDataLakeSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_data_lake_settings_input::Builder,
    }
    impl<C, M, R> PutDataLakeSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDataLakeSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDataLakeSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDataLakeSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDataLakeSettingsInputOperationOutputAlias,
                crate::output::PutDataLakeSettingsOutput,
                crate::error::PutDataLakeSettingsError,
                crate::input::PutDataLakeSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
        pub fn data_lake_settings(mut self, input: crate::model::DataLakeSettings) -> Self {
            self.inner = self.inner.data_lake_settings(input);
            self
        }
        /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
        pub fn set_data_lake_settings(
            mut self,
            input: std::option::Option<crate::model::DataLakeSettings>,
        ) -> Self {
            self.inner = self.inner.set_data_lake_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterResource`.
    ///
    /// <p>Registers the resource as managed by the Data Catalog.</p>
    /// <p>To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.</p>
    /// <p>The following request registers a new location and gives Lake Formation permission to use the service-linked role to access that location.</p>
    /// <p> <code>ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true</code> </p>
    /// <p>If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:</p>
    /// <p> <code>arn:aws:iam::12345:role/my-data-access-role</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_resource_input::Builder,
    }
    impl<C, M, R> RegisterResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterResourceInputOperationOutputAlias,
                crate::output::RegisterResourceOutput,
                crate::error::RegisterResourceError,
                crate::input::RegisterResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn use_service_linked_role(mut self, input: bool) -> Self {
            self.inner = self.inner.use_service_linked_role(input);
            self
        }
        /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn set_use_service_linked_role(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_service_linked_role(input);
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveLFTagsFromResource`.
    ///
    /// <p>Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveLFTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_lf_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveLFTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveLFTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveLfTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveLFTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveLfTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveLfTagsFromResourceOutput,
                crate::error::RemoveLFTagsFromResourceError,
                crate::input::RemoveLfTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `LFTags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The LF-tags to be removed from the resource.</p>
        pub fn lf_tags(mut self, input: crate::model::LfTagPair) -> Self {
            self.inner = self.inner.lf_tags(input);
            self
        }
        /// <p>The LF-tags to be removed from the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.inner = self.inner.set_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokePermissions`.
    ///
    /// <p>Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_permissions_input::Builder,
    }
    impl<C, M, R> RevokePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokePermissionsInputOperationOutputAlias,
                crate::output::RevokePermissionsOutput,
                crate::error::RevokePermissionsError,
                crate::input::RevokePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(input);
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `PermissionsWithGrantOption`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn permissions_with_grant_option(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.permissions_with_grant_option(input);
            self
        }
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_with_grant_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDatabasesByLFTags`.
    ///
    /// <p>This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant, the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given <code>TagConditions</code> are valid to verify whether the returned resources can be shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchDatabasesByLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_databases_by_lf_tags_input::Builder,
    }
    impl<C, M, R> SearchDatabasesByLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDatabasesByLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDatabasesByLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDatabasesByLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDatabasesByLfTagsInputOperationOutputAlias,
                crate::output::SearchDatabasesByLfTagsOutput,
                crate::error::SearchDatabasesByLFTagsError,
                crate::input::SearchDatabasesByLfTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchDatabasesByLfTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchDatabasesByLfTagsPaginator<C, M, R> {
            crate::paginator::SearchDatabasesByLfTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn expression(mut self, input: crate::model::LfTag) -> Self {
            self.inner = self.inner.expression(input);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchTablesByLFTags`.
    ///
    /// <p>This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify whether the returned resources can be shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchTablesByLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_tables_by_lf_tags_input::Builder,
    }
    impl<C, M, R> SearchTablesByLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchTablesByLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchTablesByLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchTablesByLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchTablesByLfTagsInputOperationOutputAlias,
                crate::output::SearchTablesByLfTagsOutput,
                crate::error::SearchTablesByLFTagsError,
                crate::input::SearchTablesByLfTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchTablesByLfTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchTablesByLfTagsPaginator<C, M, R> {
            crate::paginator::SearchTablesByLfTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn expression(mut self, input: crate::model::LfTag) -> Self {
            self.inner = self.inner.expression(input);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartQueryPlanning`.
    ///
    /// <p>Submits a request to process a query statement.</p>
    /// <p>This operation generates work units that can be retrieved with the <code>GetWorkUnits</code> operation as soon as the query state is WORKUNITS_AVAILABLE or FINISHED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartQueryPlanning<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_query_planning_input::Builder,
    }
    impl<C, M, R> StartQueryPlanning<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartQueryPlanning`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartQueryPlanningOutput,
            aws_smithy_http::result::SdkError<crate::error::StartQueryPlanningError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartQueryPlanningInputOperationOutputAlias,
                crate::output::StartQueryPlanningOutput,
                crate::error::StartQueryPlanningError,
                crate::input::StartQueryPlanningInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A structure containing information about the query plan.</p>
        pub fn query_planning_context(mut self, input: crate::model::QueryPlanningContext) -> Self {
            self.inner = self.inner.query_planning_context(input);
            self
        }
        /// <p>A structure containing information about the query plan.</p>
        pub fn set_query_planning_context(
            mut self,
            input: std::option::Option<crate::model::QueryPlanningContext>,
        ) -> Self {
            self.inner = self.inner.set_query_planning_context(input);
            self
        }
        /// <p>A PartiQL query statement used as an input to the planner service.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>A PartiQL query statement used as an input to the planner service.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTransaction`.
    ///
    /// <p>Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to identify a transaction.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_transaction_input::Builder,
    }
    impl<C, M, R> StartTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTransactionInputOperationOutputAlias,
                crate::output::StartTransactionOutput,
                crate::error::StartTransactionError,
                crate::input::StartTransactionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
        pub fn transaction_type(mut self, input: crate::model::TransactionType) -> Self {
            self.inner = self.inner.transaction_type(input);
            self
        }
        /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
        pub fn set_transaction_type(
            mut self,
            input: std::option::Option<crate::model::TransactionType>,
        ) -> Self {
            self.inner = self.inner.set_transaction_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLFTag`.
    ///
    /// <p>Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key's value. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lf_tag_input::Builder,
    }
    impl<C, M, R> UpdateLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLfTagInputOperationOutputAlias,
                crate::output::UpdateLfTagOutput,
                crate::error::UpdateLFTagError,
                crate::input::UpdateLfTagInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the LF-tag for which to add or delete values.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(input.into());
            self
        }
        /// <p>The key-name for the LF-tag for which to add or delete values.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
        /// Appends an item to `TagValuesToDelete`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_delete`](Self::set_tag_values_to_delete).
        ///
        /// <p>A list of LF-tag values to delete from the LF-tag.</p>
        pub fn tag_values_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values_to_delete(input.into());
            self
        }
        /// <p>A list of LF-tag values to delete from the LF-tag.</p>
        pub fn set_tag_values_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values_to_delete(input);
            self
        }
        /// Appends an item to `TagValuesToAdd`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_add`](Self::set_tag_values_to_add).
        ///
        /// <p>A list of LF-tag values to add from the LF-tag.</p>
        pub fn tag_values_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values_to_add(input.into());
            self
        }
        /// <p>A list of LF-tag values to add from the LF-tag.</p>
        pub fn set_tag_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values_to_add(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResource`.
    ///
    /// <p>Updates the data access role used for vending access to the given (registered) resource in Lake Formation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_input::Builder,
    }
    impl<C, M, R> UpdateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceInputOperationOutputAlias,
                crate::output::UpdateResourceOutput,
                crate::error::UpdateResourceError,
                crate::input::UpdateResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new role to use for the given resource registered in Lake Formation.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The new role to use for the given resource registered in Lake Formation.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTableObjects`.
    ///
    /// <p>Updates the manifest of Amazon S3 objects that make up the specified governed table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTableObjects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_table_objects_input::Builder,
    }
    impl<C, M, R> UpdateTableObjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTableObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableObjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTableObjectsInputOperationOutputAlias,
                crate::output::UpdateTableObjectsOutput,
                crate::error::UpdateTableObjectsError,
                crate::input::UpdateTableObjectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database containing the governed table to update.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The database containing the governed table to update.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The governed table to update.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The governed table to update.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The transaction at which to do the write.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The transaction at which to do the write.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// Appends an item to `WriteOperations`.
        ///
        /// To override the contents of this collection use [`set_write_operations`](Self::set_write_operations).
        ///
        /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
        pub fn write_operations(mut self, input: crate::model::WriteOperation) -> Self {
            self.inner = self.inner.write_operations(input);
            self
        }
        /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
        pub fn set_write_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WriteOperation>>,
        ) -> Self {
            self.inner = self.inner.set_write_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTableStorageOptimizer`.
    ///
    /// <p>Updates the configuration of the storage optimizers for a table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTableStorageOptimizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_table_storage_optimizer_input::Builder,
    }
    impl<C, M, R> UpdateTableStorageOptimizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTableStorageOptimizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableStorageOptimizerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableStorageOptimizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTableStorageOptimizerInputOperationOutputAlias,
                crate::output::UpdateTableStorageOptimizerOutput,
                crate::error::UpdateTableStorageOptimizerError,
                crate::input::UpdateTableStorageOptimizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(input.into());
            self
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `StorageOptimizerConfig`.
        ///
        /// To override the contents of this collection use [`set_storage_optimizer_config`](Self::set_storage_optimizer_config).
        ///
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn storage_optimizer_config(
            mut self,
            k: crate::model::OptimizerType,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.storage_optimizer_config(k, v);
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn set_storage_optimizer_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::OptimizerType,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_storage_optimizer_config(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
