// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddLfTagsToResourceInput`](crate::input::AddLfTagsToResourceInput)
pub mod add_lf_tags_to_resource_input {
    /// A builder for [`AddLfTagsToResourceInput`](crate::input::AddLfTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `lf_tags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The LF-tags to attach to the resource.</p>
        pub fn lf_tags(mut self, input: crate::model::LfTagPair) -> Self {
            let mut v = self.lf_tags.unwrap_or_default();
            v.push(input);
            self.lf_tags = Some(v);
            self
        }
        /// <p>The LF-tags to attach to the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddLfTagsToResourceInput`](crate::input::AddLfTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddLfTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddLfTagsToResourceInput {
                catalog_id: self.catalog_id,
                resource: self.resource,
                lf_tags: self.lf_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddLfTagsToResourceInputOperationOutputAlias = crate::operation::AddLFTagsToResource;
#[doc(hidden)]
pub type AddLfTagsToResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddLfTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddLFTagsToResource`](crate::operation::AddLFTagsToResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddLFTagsToResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddLfTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/AddLFTagsToResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddLfTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddLfTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_lf_tags_to_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddLFTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddLFTagsToResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddLfTagsToResourceInput`](crate::input::AddLfTagsToResourceInput)
    pub fn builder() -> crate::input::add_lf_tags_to_resource_input::Builder {
        crate::input::add_lf_tags_to_resource_input::Builder::default()
    }
}

/// See [`BatchGrantPermissionsInput`](crate::input::BatchGrantPermissionsInput)
pub mod batch_grant_permissions_input {
    /// A builder for [`BatchGrantPermissionsInput`](crate::input::BatchGrantPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn entries(mut self, input: crate::model::BatchPermissionsRequestEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGrantPermissionsInput`](crate::input::BatchGrantPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGrantPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGrantPermissionsInput {
                catalog_id: self.catalog_id,
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGrantPermissionsInputOperationOutputAlias = crate::operation::BatchGrantPermissions;
#[doc(hidden)]
pub type BatchGrantPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGrantPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGrantPermissions`](crate::operation::BatchGrantPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGrantPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGrantPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/BatchGrantPermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGrantPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGrantPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_grant_permissions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGrantPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGrantPermissions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGrantPermissionsInput`](crate::input::BatchGrantPermissionsInput)
    pub fn builder() -> crate::input::batch_grant_permissions_input::Builder {
        crate::input::batch_grant_permissions_input::Builder::default()
    }
}

/// See [`BatchRevokePermissionsInput`](crate::input::BatchRevokePermissionsInput)
pub mod batch_revoke_permissions_input {
    /// A builder for [`BatchRevokePermissionsInput`](crate::input::BatchRevokePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn entries(mut self, input: crate::model::BatchPermissionsRequestEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchRevokePermissionsInput`](crate::input::BatchRevokePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchRevokePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchRevokePermissionsInput {
                catalog_id: self.catalog_id,
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchRevokePermissionsInputOperationOutputAlias = crate::operation::BatchRevokePermissions;
#[doc(hidden)]
pub type BatchRevokePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchRevokePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`BatchRevokePermissions`](crate::operation::BatchRevokePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchRevokePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchRevokePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/BatchRevokePermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchRevokePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchRevokePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_revoke_permissions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchRevokePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchRevokePermissions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchRevokePermissionsInput`](crate::input::BatchRevokePermissionsInput)
    pub fn builder() -> crate::input::batch_revoke_permissions_input::Builder {
        crate::input::batch_revoke_permissions_input::Builder::default()
    }
}

/// See [`CancelTransactionInput`](crate::input::CancelTransactionInput)
pub mod cancel_transaction_input {
    /// A builder for [`CancelTransactionInput`](crate::input::CancelTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The transaction to cancel.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction to cancel.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelTransactionInput`](crate::input::CancelTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelTransactionInput {
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelTransactionInputOperationOutputAlias = crate::operation::CancelTransaction;
#[doc(hidden)]
pub type CancelTransactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelTransactionInput {
    /// Consumes the builder and constructs an Operation<[`CancelTransaction`](crate::operation::CancelTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelTransaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CancelTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelTransaction",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelTransactionInput`](crate::input::CancelTransactionInput)
    pub fn builder() -> crate::input::cancel_transaction_input::Builder {
        crate::input::cancel_transaction_input::Builder::default()
    }
}

/// See [`CommitTransactionInput`](crate::input::CommitTransactionInput)
pub mod commit_transaction_input {
    /// A builder for [`CommitTransactionInput`](crate::input::CommitTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The transaction to commit.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction to commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CommitTransactionInput`](crate::input::CommitTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CommitTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CommitTransactionInput {
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CommitTransactionInputOperationOutputAlias = crate::operation::CommitTransaction;
#[doc(hidden)]
pub type CommitTransactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CommitTransactionInput {
    /// Consumes the builder and constructs an Operation<[`CommitTransaction`](crate::operation::CommitTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CommitTransaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CommitTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CommitTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CommitTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CommitTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_commit_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CommitTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CommitTransaction",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CommitTransactionInput`](crate::input::CommitTransactionInput)
    pub fn builder() -> crate::input::commit_transaction_input::Builder {
        crate::input::commit_transaction_input::Builder::default()
    }
}

/// See [`CreateDataCellsFilterInput`](crate::input::CreateDataCellsFilterInput)
pub mod create_data_cells_filter_input {
    /// A builder for [`CreateDataCellsFilterInput`](crate::input::CreateDataCellsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_data: std::option::Option<crate::model::DataCellsFilter>,
    }
    impl Builder {
        /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
        pub fn table_data(mut self, input: crate::model::DataCellsFilter) -> Self {
            self.table_data = Some(input);
            self
        }
        /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
        pub fn set_table_data(
            mut self,
            input: std::option::Option<crate::model::DataCellsFilter>,
        ) -> Self {
            self.table_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataCellsFilterInput`](crate::input::CreateDataCellsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataCellsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataCellsFilterInput {
                table_data: self.table_data,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataCellsFilterInputOperationOutputAlias = crate::operation::CreateDataCellsFilter;
#[doc(hidden)]
pub type CreateDataCellsFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataCellsFilterInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataCellsFilter`](crate::operation::CreateDataCellsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataCellsFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataCellsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateDataCellsFilter").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataCellsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataCellsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_cells_filter(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataCellsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataCellsFilter",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataCellsFilterInput`](crate::input::CreateDataCellsFilterInput)
    pub fn builder() -> crate::input::create_data_cells_filter_input::Builder {
        crate::input::create_data_cells_filter_input::Builder::default()
    }
}

/// See [`CreateLfTagInput`](crate::input::CreateLfTagInput)
pub mod create_lf_tag_input {
    /// A builder for [`CreateLfTagInput`](crate::input::CreateLfTagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLfTagInput`](crate::input::CreateLfTagInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLfTagInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLfTagInput {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLfTagInputOperationOutputAlias = crate::operation::CreateLFTag;
#[doc(hidden)]
pub type CreateLfTagInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLfTagInput {
    /// Consumes the builder and constructs an Operation<[`CreateLFTag`](crate::operation::CreateLFTag)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLFTag,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLfTagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CreateLFTag").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLfTagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLfTagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_lf_tag(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLFTag::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLFTag",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLfTagInput`](crate::input::CreateLfTagInput)
    pub fn builder() -> crate::input::create_lf_tag_input::Builder {
        crate::input::create_lf_tag_input::Builder::default()
    }
}

/// See [`DeleteDataCellsFilterInput`](crate::input::DeleteDataCellsFilterInput)
pub mod delete_data_cells_filter_input {
    /// A builder for [`DeleteDataCellsFilterInput`](crate::input::DeleteDataCellsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn table_catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn set_table_catalog_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_catalog_id = input;
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A table in the database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>A table in the database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataCellsFilterInput`](crate::input::DeleteDataCellsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataCellsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataCellsFilterInput {
                table_catalog_id: self.table_catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataCellsFilterInputOperationOutputAlias = crate::operation::DeleteDataCellsFilter;
#[doc(hidden)]
pub type DeleteDataCellsFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataCellsFilterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataCellsFilter`](crate::operation::DeleteDataCellsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataCellsFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataCellsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteDataCellsFilter").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataCellsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataCellsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_data_cells_filter(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataCellsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataCellsFilter",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataCellsFilterInput`](crate::input::DeleteDataCellsFilterInput)
    pub fn builder() -> crate::input::delete_data_cells_filter_input::Builder {
        crate::input::delete_data_cells_filter_input::Builder::default()
    }
}

/// See [`DeleteLfTagInput`](crate::input::DeleteLfTagInput)
pub mod delete_lf_tag_input {
    /// A builder for [`DeleteLfTagInput`](crate::input::DeleteLfTagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag to delete.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag to delete.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLfTagInput`](crate::input::DeleteLfTagInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLfTagInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLfTagInput {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLfTagInputOperationOutputAlias = crate::operation::DeleteLFTag;
#[doc(hidden)]
pub type DeleteLfTagInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLfTagInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLFTag`](crate::operation::DeleteLFTag)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLFTag,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLfTagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteLFTag").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLfTagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLfTagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_lf_tag(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLFTag::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLFTag",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLfTagInput`](crate::input::DeleteLfTagInput)
    pub fn builder() -> crate::input::delete_lf_tag_input::Builder {
        crate::input::delete_lf_tag_input::Builder::default()
    }
}

/// See [`DeleteObjectsOnCancelInput`](crate::input::DeleteObjectsOnCancelInput)
pub mod delete_objects_on_cancel_input {
    /// A builder for [`DeleteObjectsOnCancelInput`](crate::input::DeleteObjectsOnCancelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) objects: std::option::Option<std::vec::Vec<crate::model::VirtualObject>>,
    }
    impl Builder {
        /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database that contains the governed table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database that contains the governed table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the governed table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the governed table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>ID of the transaction that the writes occur in.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>ID of the transaction that the writes occur in.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Appends an item to `objects`.
        ///
        /// To override the contents of this collection use [`set_objects`](Self::set_objects).
        ///
        /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
        pub fn objects(mut self, input: crate::model::VirtualObject) -> Self {
            let mut v = self.objects.unwrap_or_default();
            v.push(input);
            self.objects = Some(v);
            self
        }
        /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
        pub fn set_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualObject>>,
        ) -> Self {
            self.objects = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectsOnCancelInput`](crate::input::DeleteObjectsOnCancelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectsOnCancelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectsOnCancelInput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                transaction_id: self.transaction_id,
                objects: self.objects,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectsOnCancelInputOperationOutputAlias = crate::operation::DeleteObjectsOnCancel;
#[doc(hidden)]
pub type DeleteObjectsOnCancelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectsOnCancelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObjectsOnCancel`](crate::operation::DeleteObjectsOnCancel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObjectsOnCancel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectsOnCancelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeleteObjectsOnCancel").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectsOnCancelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectsOnCancelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_objects_on_cancel(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObjectsOnCancel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObjectsOnCancel",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectsOnCancelInput`](crate::input::DeleteObjectsOnCancelInput)
    pub fn builder() -> crate::input::delete_objects_on_cancel_input::Builder {
        crate::input::delete_objects_on_cancel_input::Builder::default()
    }
}

/// See [`DeregisterResourceInput`](crate::input::DeregisterResourceInput)
pub mod deregister_resource_input {
    /// A builder for [`DeregisterResourceInput`](crate::input::DeregisterResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterResourceInput`](crate::input::DeregisterResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterResourceInputOperationOutputAlias = crate::operation::DeregisterResource;
#[doc(hidden)]
pub type DeregisterResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterResourceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterResource`](crate::operation::DeregisterResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DeregisterResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterResourceInput`](crate::input::DeregisterResourceInput)
    pub fn builder() -> crate::input::deregister_resource_input::Builder {
        crate::input::deregister_resource_input::Builder::default()
    }
}

/// See [`DescribeResourceInput`](crate::input::DescribeResourceInput)
pub mod describe_resource_input {
    /// A builder for [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceInput`](crate::input::DescribeResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourceInputOperationOutputAlias = crate::operation::DescribeResource;
#[doc(hidden)]
pub type DescribeResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResource`](crate::operation::DescribeResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourceInput`](crate::input::DescribeResourceInput)
    pub fn builder() -> crate::input::describe_resource_input::Builder {
        crate::input::describe_resource_input::Builder::default()
    }
}

/// See [`DescribeTransactionInput`](crate::input::DescribeTransactionInput)
pub mod describe_transaction_input {
    /// A builder for [`DescribeTransactionInput`](crate::input::DescribeTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The transaction for which to return status.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction for which to return status.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTransactionInput`](crate::input::DescribeTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTransactionInput {
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTransactionInputOperationOutputAlias = crate::operation::DescribeTransaction;
#[doc(hidden)]
pub type DescribeTransactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTransactionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTransaction`](crate::operation::DescribeTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTransaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTransaction",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTransactionInput`](crate::input::DescribeTransactionInput)
    pub fn builder() -> crate::input::describe_transaction_input::Builder {
        crate::input::describe_transaction_input::Builder::default()
    }
}

/// See [`ExtendTransactionInput`](crate::input::ExtendTransactionInput)
pub mod extend_transaction_input {
    /// A builder for [`ExtendTransactionInput`](crate::input::ExtendTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The transaction to extend.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction to extend.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendTransactionInput`](crate::input::ExtendTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExtendTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExtendTransactionInput {
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ExtendTransactionInputOperationOutputAlias = crate::operation::ExtendTransaction;
#[doc(hidden)]
pub type ExtendTransactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExtendTransactionInput {
    /// Consumes the builder and constructs an Operation<[`ExtendTransaction`](crate::operation::ExtendTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExtendTransaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExtendTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ExtendTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExtendTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExtendTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_extend_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExtendTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExtendTransaction",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExtendTransactionInput`](crate::input::ExtendTransactionInput)
    pub fn builder() -> crate::input::extend_transaction_input::Builder {
        crate::input::extend_transaction_input::Builder::default()
    }
}

/// See [`GetDataLakeSettingsInput`](crate::input::GetDataLakeSettingsInput)
pub mod get_data_lake_settings_input {
    /// A builder for [`GetDataLakeSettingsInput`](crate::input::GetDataLakeSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataLakeSettingsInput`](crate::input::GetDataLakeSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataLakeSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataLakeSettingsInput {
                catalog_id: self.catalog_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataLakeSettingsInputOperationOutputAlias = crate::operation::GetDataLakeSettings;
#[doc(hidden)]
pub type GetDataLakeSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDataLakeSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetDataLakeSettings`](crate::operation::GetDataLakeSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataLakeSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataLakeSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetDataLakeSettings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataLakeSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataLakeSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_data_lake_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataLakeSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataLakeSettings",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataLakeSettingsInput`](crate::input::GetDataLakeSettingsInput)
    pub fn builder() -> crate::input::get_data_lake_settings_input::Builder {
        crate::input::get_data_lake_settings_input::Builder::default()
    }
}

/// See [`GetEffectivePermissionsForPathInput`](crate::input::GetEffectivePermissionsForPathInput)
pub mod get_effective_permissions_for_path_input {
    /// A builder for [`GetEffectivePermissionsForPathInput`](crate::input::GetEffectivePermissionsForPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEffectivePermissionsForPathInput`](crate::input::GetEffectivePermissionsForPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEffectivePermissionsForPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEffectivePermissionsForPathInput {
                catalog_id: self.catalog_id,
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEffectivePermissionsForPathInputOperationOutputAlias =
    crate::operation::GetEffectivePermissionsForPath;
#[doc(hidden)]
pub type GetEffectivePermissionsForPathInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetEffectivePermissionsForPathInput {
    /// Consumes the builder and constructs an Operation<[`GetEffectivePermissionsForPath`](crate::operation::GetEffectivePermissionsForPath)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEffectivePermissionsForPath,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEffectivePermissionsForPathInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetEffectivePermissionsForPath").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEffectivePermissionsForPathInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEffectivePermissionsForPathInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_effective_permissions_for_path(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEffectivePermissionsForPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEffectivePermissionsForPath",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEffectivePermissionsForPathInput`](crate::input::GetEffectivePermissionsForPathInput)
    pub fn builder() -> crate::input::get_effective_permissions_for_path_input::Builder {
        crate::input::get_effective_permissions_for_path_input::Builder::default()
    }
}

/// See [`GetLfTagInput`](crate::input::GetLfTagInput)
pub mod get_lf_tag_input {
    /// A builder for [`GetLfTagInput`](crate::input::GetLfTagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLfTagInput`](crate::input::GetLfTagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetLfTagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetLfTagInput {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLfTagInputOperationOutputAlias = crate::operation::GetLFTag;
#[doc(hidden)]
pub type GetLfTagInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLfTagInput {
    /// Consumes the builder and constructs an Operation<[`GetLFTag`](crate::operation::GetLFTag)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLFTag,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLfTagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetLFTag").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLfTagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLfTagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_lf_tag(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetLFTag::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetLFTag",
                    "lakeformation",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLfTagInput`](crate::input::GetLfTagInput)
    pub fn builder() -> crate::input::get_lf_tag_input::Builder {
        crate::input::get_lf_tag_input::Builder::default()
    }
}

/// See [`GetQueryStateInput`](crate::input::GetQueryStateInput)
pub mod get_query_state_input {
    /// A builder for [`GetQueryStateInput`](crate::input::GetQueryStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryStateInput`](crate::input::GetQueryStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryStateInput {
                query_id: self.query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQueryStateInputOperationOutputAlias = crate::operation::GetQueryState;
#[doc(hidden)]
pub type GetQueryStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetQueryStateInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryState`](crate::operation::GetQueryState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQueryStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetQueryState").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQueryStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQueryStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_query_state(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("query-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryState",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQueryStateInput`](crate::input::GetQueryStateInput)
    pub fn builder() -> crate::input::get_query_state_input::Builder {
        crate::input::get_query_state_input::Builder::default()
    }
}

/// See [`GetQueryStatisticsInput`](crate::input::GetQueryStatisticsInput)
pub mod get_query_statistics_input {
    /// A builder for [`GetQueryStatisticsInput`](crate::input::GetQueryStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryStatisticsInput`](crate::input::GetQueryStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryStatisticsInput {
                query_id: self.query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQueryStatisticsInputOperationOutputAlias = crate::operation::GetQueryStatistics;
#[doc(hidden)]
pub type GetQueryStatisticsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetQueryStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryStatistics`](crate::operation::GetQueryStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQueryStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetQueryStatistics").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQueryStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQueryStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_query_statistics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("query-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryStatistics",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQueryStatisticsInput`](crate::input::GetQueryStatisticsInput)
    pub fn builder() -> crate::input::get_query_statistics_input::Builder {
        crate::input::get_query_statistics_input::Builder::default()
    }
}

/// See [`GetResourceLfTagsInput`](crate::input::GetResourceLfTagsInput)
pub mod get_resource_lf_tags_input {
    /// A builder for [`GetResourceLfTagsInput`](crate::input::GetResourceLfTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) show_assigned_lf_tags: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// <p>Indicates whether to show the assigned LF-tags.</p>
        pub fn show_assigned_lf_tags(mut self, input: bool) -> Self {
            self.show_assigned_lf_tags = Some(input);
            self
        }
        /// <p>Indicates whether to show the assigned LF-tags.</p>
        pub fn set_show_assigned_lf_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.show_assigned_lf_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceLfTagsInput`](crate::input::GetResourceLfTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceLfTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceLfTagsInput {
                catalog_id: self.catalog_id,
                resource: self.resource,
                show_assigned_lf_tags: self.show_assigned_lf_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceLfTagsInputOperationOutputAlias = crate::operation::GetResourceLFTags;
#[doc(hidden)]
pub type GetResourceLfTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceLfTagsInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceLFTags`](crate::operation::GetResourceLFTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceLFTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceLfTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetResourceLFTags").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceLfTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceLfTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_lf_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceLFTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceLFTags",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceLfTagsInput`](crate::input::GetResourceLfTagsInput)
    pub fn builder() -> crate::input::get_resource_lf_tags_input::Builder {
        crate::input::get_resource_lf_tags_input::Builder::default()
    }
}

/// See [`GetTableObjectsInput`](crate::input::GetTableObjectsInput)
pub mod get_table_objects_input {
    /// A builder for [`GetTableObjectsInput`](crate::input::GetTableObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) query_as_of_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) partition_predicate: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database containing the governed table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database containing the governed table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The governed table for which to retrieve objects.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The governed table for which to retrieve objects.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.query_as_of_time = Some(input);
            self
        }
        /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.query_as_of_time = input;
            self
        }
        /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
        /// <ul>
        /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
        /// <li> <p>The logical operators supported are: AND</p> </li>
        /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
        /// </ul>
        pub fn partition_predicate(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition_predicate = Some(input.into());
            self
        }
        /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
        /// <ul>
        /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
        /// <li> <p>The logical operators supported are: AND</p> </li>
        /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
        /// </ul>
        pub fn set_partition_predicate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partition_predicate = input;
            self
        }
        /// <p>Specifies how many values to return in a page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies how many values to return in a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableObjectsInput`](crate::input::GetTableObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTableObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTableObjectsInput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                transaction_id: self.transaction_id,
                query_as_of_time: self.query_as_of_time,
                partition_predicate: self.partition_predicate,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTableObjectsInputOperationOutputAlias = crate::operation::GetTableObjects;
#[doc(hidden)]
pub type GetTableObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTableObjectsInput {
    /// Consumes the builder and constructs an Operation<[`GetTableObjects`](crate::operation::GetTableObjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTableObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTableObjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetTableObjects").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTableObjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTableObjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_table_objects(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTableObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTableObjects",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTableObjectsInput`](crate::input::GetTableObjectsInput)
    pub fn builder() -> crate::input::get_table_objects_input::Builder {
        crate::input::get_table_objects_input::Builder::default()
    }
}

/// See [`GetTemporaryGluePartitionCredentialsInput`](crate::input::GetTemporaryGluePartitionCredentialsInput)
pub mod get_temporary_glue_partition_credentials_input {
    /// A builder for [`GetTemporaryGluePartitionCredentialsInput`](crate::input::GetTemporaryGluePartitionCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<crate::model::PartitionValueList>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) duration_seconds: std::option::Option<i32>,
        pub(crate) audit_context: std::option::Option<crate::model::AuditContext>,
        pub(crate) supported_permission_types:
            std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
    }
    impl Builder {
        /// <p>The ARN of the partitions' table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the partitions' table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>A list of partition values identifying a single partition.</p>
        pub fn partition(mut self, input: crate::model::PartitionValueList) -> Self {
            self.partition = Some(input);
            self
        }
        /// <p>A list of partition values identifying a single partition.</p>
        pub fn set_partition(
            mut self,
            input: std::option::Option<crate::model::PartitionValueList>,
        ) -> Self {
            self.partition = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn audit_context(mut self, input: crate::model::AuditContext) -> Self {
            self.audit_context = Some(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn set_audit_context(
            mut self,
            input: std::option::Option<crate::model::AuditContext>,
        ) -> Self {
            self.audit_context = input;
            self
        }
        /// Appends an item to `supported_permission_types`.
        ///
        /// To override the contents of this collection use [`set_supported_permission_types`](Self::set_supported_permission_types).
        ///
        /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn supported_permission_types(mut self, input: crate::model::PermissionType) -> Self {
            let mut v = self.supported_permission_types.unwrap_or_default();
            v.push(input);
            self.supported_permission_types = Some(v);
            self
        }
        /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn set_supported_permission_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.supported_permission_types = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemporaryGluePartitionCredentialsInput`](crate::input::GetTemporaryGluePartitionCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTemporaryGluePartitionCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTemporaryGluePartitionCredentialsInput {
                table_arn: self.table_arn,
                partition: self.partition,
                permissions: self.permissions,
                duration_seconds: self.duration_seconds,
                audit_context: self.audit_context,
                supported_permission_types: self.supported_permission_types,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTemporaryGluePartitionCredentialsInputOperationOutputAlias =
    crate::operation::GetTemporaryGluePartitionCredentials;
#[doc(hidden)]
pub type GetTemporaryGluePartitionCredentialsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetTemporaryGluePartitionCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`GetTemporaryGluePartitionCredentials`](crate::operation::GetTemporaryGluePartitionCredentials)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTemporaryGluePartitionCredentials,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTemporaryGluePartitionCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetTemporaryGluePartitionCredentials")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTemporaryGluePartitionCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTemporaryGluePartitionCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_temporary_glue_partition_credentials(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTemporaryGluePartitionCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTemporaryGluePartitionCredentials",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTemporaryGluePartitionCredentialsInput`](crate::input::GetTemporaryGluePartitionCredentialsInput)
    pub fn builder() -> crate::input::get_temporary_glue_partition_credentials_input::Builder {
        crate::input::get_temporary_glue_partition_credentials_input::Builder::default()
    }
}

/// See [`GetTemporaryGlueTableCredentialsInput`](crate::input::GetTemporaryGlueTableCredentialsInput)
pub mod get_temporary_glue_table_credentials_input {
    /// A builder for [`GetTemporaryGlueTableCredentialsInput`](crate::input::GetTemporaryGlueTableCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) duration_seconds: std::option::Option<i32>,
        pub(crate) audit_context: std::option::Option<crate::model::AuditContext>,
        pub(crate) supported_permission_types:
            std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
    }
    impl Builder {
        /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn audit_context(mut self, input: crate::model::AuditContext) -> Self {
            self.audit_context = Some(input);
            self
        }
        /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
        pub fn set_audit_context(
            mut self,
            input: std::option::Option<crate::model::AuditContext>,
        ) -> Self {
            self.audit_context = input;
            self
        }
        /// Appends an item to `supported_permission_types`.
        ///
        /// To override the contents of this collection use [`set_supported_permission_types`](Self::set_supported_permission_types).
        ///
        /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn supported_permission_types(mut self, input: crate::model::PermissionType) -> Self {
            let mut v = self.supported_permission_types.unwrap_or_default();
            v.push(input);
            self.supported_permission_types = Some(v);
            self
        }
        /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
        pub fn set_supported_permission_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
        ) -> Self {
            self.supported_permission_types = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemporaryGlueTableCredentialsInput`](crate::input::GetTemporaryGlueTableCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTemporaryGlueTableCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTemporaryGlueTableCredentialsInput {
                table_arn: self.table_arn,
                permissions: self.permissions,
                duration_seconds: self.duration_seconds,
                audit_context: self.audit_context,
                supported_permission_types: self.supported_permission_types,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTemporaryGlueTableCredentialsInputOperationOutputAlias =
    crate::operation::GetTemporaryGlueTableCredentials;
#[doc(hidden)]
pub type GetTemporaryGlueTableCredentialsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetTemporaryGlueTableCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`GetTemporaryGlueTableCredentials`](crate::operation::GetTemporaryGlueTableCredentials)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTemporaryGlueTableCredentials,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTemporaryGlueTableCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetTemporaryGlueTableCredentials").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTemporaryGlueTableCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTemporaryGlueTableCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_temporary_glue_table_credentials(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTemporaryGlueTableCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTemporaryGlueTableCredentials",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTemporaryGlueTableCredentialsInput`](crate::input::GetTemporaryGlueTableCredentialsInput)
    pub fn builder() -> crate::input::get_temporary_glue_table_credentials_input::Builder {
        crate::input::get_temporary_glue_table_credentials_input::Builder::default()
    }
}

/// See [`GetWorkUnitResultsInput`](crate::input::GetWorkUnitResultsInput)
pub mod get_work_unit_results_input {
    /// A builder for [`GetWorkUnitResultsInput`](crate::input::GetWorkUnitResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) work_unit_id: std::option::Option<i64>,
        pub(crate) work_unit_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the plan query operation for which to get results.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the plan query operation for which to get results.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
        pub fn work_unit_id(mut self, input: i64) -> Self {
            self.work_unit_id = Some(input);
            self
        }
        /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
        pub fn set_work_unit_id(mut self, input: std::option::Option<i64>) -> Self {
            self.work_unit_id = input;
            self
        }
        /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
        pub fn work_unit_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_unit_token = Some(input.into());
            self
        }
        /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
        pub fn set_work_unit_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.work_unit_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkUnitResultsInput`](crate::input::GetWorkUnitResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkUnitResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkUnitResultsInput {
                query_id: self.query_id,
                work_unit_id: self.work_unit_id.unwrap_or_default(),
                work_unit_token: self.work_unit_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkUnitResultsInputOperationOutputAlias = crate::operation::GetWorkUnitResults;
#[doc(hidden)]
pub type GetWorkUnitResultsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorkUnitResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkUnitResults`](crate::operation::GetWorkUnitResults)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkUnitResults,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkUnitResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetWorkUnitResults").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkUnitResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkUnitResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_work_unit_results(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkUnitResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkUnitResults",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkUnitResultsInput`](crate::input::GetWorkUnitResultsInput)
    pub fn builder() -> crate::input::get_work_unit_results_input::Builder {
        crate::input::get_work_unit_results_input::Builder::default()
    }
}

/// See [`GetWorkUnitsInput`](crate::input::GetWorkUnitsInput)
pub mod get_work_units_input {
    /// A builder for [`GetWorkUnitsInput`](crate::input::GetWorkUnitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the plan query operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkUnitsInput`](crate::input::GetWorkUnitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkUnitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkUnitsInput {
                next_token: self.next_token,
                page_size: self.page_size,
                query_id: self.query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkUnitsInputOperationOutputAlias = crate::operation::GetWorkUnits;
#[doc(hidden)]
pub type GetWorkUnitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorkUnitsInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkUnits`](crate::operation::GetWorkUnits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkUnits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkUnitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GetWorkUnits").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkUnitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkUnitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_work_units(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("query-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkUnits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkUnits",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkUnitsInput`](crate::input::GetWorkUnitsInput)
    pub fn builder() -> crate::input::get_work_units_input::Builder {
        crate::input::get_work_units_input::Builder::default()
    }
}

/// See [`GrantPermissionsInput`](crate::input::GrantPermissionsInput)
pub mod grant_permissions_input {
    /// A builder for [`GrantPermissionsInput`](crate::input::GrantPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) permissions_with_grant_option:
            std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `permissions_with_grant_option`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn permissions_with_grant_option(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions_with_grant_option.unwrap_or_default();
            v.push(input);
            self.permissions_with_grant_option = Some(v);
            self
        }
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions_with_grant_option = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantPermissionsInput`](crate::input::GrantPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GrantPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GrantPermissionsInput {
                catalog_id: self.catalog_id,
                principal: self.principal,
                resource: self.resource,
                permissions: self.permissions,
                permissions_with_grant_option: self.permissions_with_grant_option,
            })
        }
    }
}
#[doc(hidden)]
pub type GrantPermissionsInputOperationOutputAlias = crate::operation::GrantPermissions;
#[doc(hidden)]
pub type GrantPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GrantPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`GrantPermissions`](crate::operation::GrantPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GrantPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GrantPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/GrantPermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GrantPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GrantPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_grant_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GrantPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GrantPermissions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GrantPermissionsInput`](crate::input::GrantPermissionsInput)
    pub fn builder() -> crate::input::grant_permissions_input::Builder {
        crate::input::grant_permissions_input::Builder::default()
    }
}

/// See [`ListDataCellsFilterInput`](crate::input::ListDataCellsFilterInput)
pub mod list_data_cells_filter_input {
    /// A builder for [`ListDataCellsFilterInput`](crate::input::ListDataCellsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table: std::option::Option<crate::model::TableResource>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A table in the Glue Data Catalog.</p>
        pub fn table(mut self, input: crate::model::TableResource) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>A table in the Glue Data Catalog.</p>
        pub fn set_table(
            mut self,
            input: std::option::Option<crate::model::TableResource>,
        ) -> Self {
            self.table = input;
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataCellsFilterInput`](crate::input::ListDataCellsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataCellsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataCellsFilterInput {
                table: self.table,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataCellsFilterInputOperationOutputAlias = crate::operation::ListDataCellsFilter;
#[doc(hidden)]
pub type ListDataCellsFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataCellsFilterInput {
    /// Consumes the builder and constructs an Operation<[`ListDataCellsFilter`](crate::operation::ListDataCellsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataCellsFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataCellsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListDataCellsFilter").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataCellsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataCellsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_data_cells_filter(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataCellsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataCellsFilter",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataCellsFilterInput`](crate::input::ListDataCellsFilterInput)
    pub fn builder() -> crate::input::list_data_cells_filter_input::Builder {
        crate::input::list_data_cells_filter_input::Builder::default()
    }
}

/// See [`ListLfTagsInput`](crate::input::ListLfTagsInput)
pub mod list_lf_tags_input {
    /// A builder for [`ListLfTagsInput`](crate::input::ListLfTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource_share_type: std::option::Option<crate::model::ResourceShareType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
        pub fn resource_share_type(mut self, input: crate::model::ResourceShareType) -> Self {
            self.resource_share_type = Some(input);
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
        pub fn set_resource_share_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareType>,
        ) -> Self {
            self.resource_share_type = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLfTagsInput`](crate::input::ListLfTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLfTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLfTagsInput {
                catalog_id: self.catalog_id,
                resource_share_type: self.resource_share_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLfTagsInputOperationOutputAlias = crate::operation::ListLFTags;
#[doc(hidden)]
pub type ListLfTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLfTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListLFTags`](crate::operation::ListLFTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLFTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLfTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListLFTags").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLfTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLfTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_lf_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLFTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLFTags",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLfTagsInput`](crate::input::ListLfTagsInput)
    pub fn builder() -> crate::input::list_lf_tags_input::Builder {
        crate::input::list_lf_tags_input::Builder::default()
    }
}

/// See [`ListPermissionsInput`](crate::input::ListPermissionsInput)
pub mod list_permissions_input {
    /// A builder for [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) resource_type: std::option::Option<crate::model::DataLakeResourceType>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) include_related: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn resource_type(mut self, input: crate::model::DataLakeResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::DataLakeResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Indicates that related permissions should be included in the results.</p>
        pub fn include_related(mut self, input: impl Into<std::string::String>) -> Self {
            self.include_related = Some(input.into());
            self
        }
        /// <p>Indicates that related permissions should be included in the results.</p>
        pub fn set_include_related(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.include_related = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsInput`](crate::input::ListPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionsInput {
                catalog_id: self.catalog_id,
                principal: self.principal,
                resource_type: self.resource_type,
                resource: self.resource,
                next_token: self.next_token,
                max_results: self.max_results,
                include_related: self.include_related,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionsInputOperationOutputAlias = crate::operation::ListPermissions;
#[doc(hidden)]
pub type ListPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissions`](crate::operation::ListPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListPermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
}

/// See [`ListResourcesInput`](crate::input::ListResourcesInput)
pub mod list_resources_input {
    /// A builder for [`ListResourcesInput`](crate::input::ListResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_condition_list:
            std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filter_condition_list`.
        ///
        /// To override the contents of this collection use [`set_filter_condition_list`](Self::set_filter_condition_list).
        ///
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn filter_condition_list(mut self, input: crate::model::FilterCondition) -> Self {
            let mut v = self.filter_condition_list.unwrap_or_default();
            v.push(input);
            self.filter_condition_list = Some(v);
            self
        }
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn set_filter_condition_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        ) -> Self {
            self.filter_condition_list = input;
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesInput`](crate::input::ListResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourcesInput {
                filter_condition_list: self.filter_condition_list,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourcesInputOperationOutputAlias = crate::operation::ListResources;
#[doc(hidden)]
pub type ListResourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListResources`](crate::operation::ListResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListResources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_resources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResources",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourcesInput`](crate::input::ListResourcesInput)
    pub fn builder() -> crate::input::list_resources_input::Builder {
        crate::input::list_resources_input::Builder::default()
    }
}

/// See [`ListTableStorageOptimizersInput`](crate::input::ListTableStorageOptimizersInput)
pub mod list_table_storage_optimizers_input {
    /// A builder for [`ListTableStorageOptimizersInput`](crate::input::ListTableStorageOptimizersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) storage_optimizer_type: std::option::Option<crate::model::OptimizerType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Catalog ID of the table.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
        pub fn storage_optimizer_type(mut self, input: crate::model::OptimizerType) -> Self {
            self.storage_optimizer_type = Some(input);
            self
        }
        /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
        pub fn set_storage_optimizer_type(
            mut self,
            input: std::option::Option<crate::model::OptimizerType>,
        ) -> Self {
            self.storage_optimizer_type = input;
            self
        }
        /// <p>The number of storage optimizers to return on each call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of storage optimizers to return on each call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableStorageOptimizersInput`](crate::input::ListTableStorageOptimizersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTableStorageOptimizersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTableStorageOptimizersInput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                storage_optimizer_type: self.storage_optimizer_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTableStorageOptimizersInputOperationOutputAlias =
    crate::operation::ListTableStorageOptimizers;
#[doc(hidden)]
pub type ListTableStorageOptimizersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTableStorageOptimizersInput {
    /// Consumes the builder and constructs an Operation<[`ListTableStorageOptimizers`](crate::operation::ListTableStorageOptimizers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTableStorageOptimizers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTableStorageOptimizersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListTableStorageOptimizers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTableStorageOptimizersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTableStorageOptimizersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_table_storage_optimizers(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTableStorageOptimizers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTableStorageOptimizers",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTableStorageOptimizersInput`](crate::input::ListTableStorageOptimizersInput)
    pub fn builder() -> crate::input::list_table_storage_optimizers_input::Builder {
        crate::input::list_table_storage_optimizers_input::Builder::default()
    }
}

/// See [`ListTransactionsInput`](crate::input::ListTransactionsInput)
pub mod list_transactions_input {
    /// A builder for [`ListTransactionsInput`](crate::input::ListTransactionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<crate::model::TransactionStatusFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
        pub fn status_filter(mut self, input: crate::model::TransactionStatusFilter) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::TransactionStatusFilter>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of transactions to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of transactions to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTransactionsInput`](crate::input::ListTransactionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTransactionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTransactionsInput {
                catalog_id: self.catalog_id,
                status_filter: self.status_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTransactionsInputOperationOutputAlias = crate::operation::ListTransactions;
#[doc(hidden)]
pub type ListTransactionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTransactionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTransactions`](crate::operation::ListTransactions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTransactions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTransactionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListTransactions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTransactionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTransactionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_transactions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTransactions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTransactions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTransactionsInput`](crate::input::ListTransactionsInput)
    pub fn builder() -> crate::input::list_transactions_input::Builder {
        crate::input::list_transactions_input::Builder::default()
    }
}

/// See [`PutDataLakeSettingsInput`](crate::input::PutDataLakeSettingsInput)
pub mod put_data_lake_settings_input {
    /// A builder for [`PutDataLakeSettingsInput`](crate::input::PutDataLakeSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) data_lake_settings: std::option::Option<crate::model::DataLakeSettings>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
        pub fn data_lake_settings(mut self, input: crate::model::DataLakeSettings) -> Self {
            self.data_lake_settings = Some(input);
            self
        }
        /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
        pub fn set_data_lake_settings(
            mut self,
            input: std::option::Option<crate::model::DataLakeSettings>,
        ) -> Self {
            self.data_lake_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDataLakeSettingsInput`](crate::input::PutDataLakeSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDataLakeSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDataLakeSettingsInput {
                catalog_id: self.catalog_id,
                data_lake_settings: self.data_lake_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDataLakeSettingsInputOperationOutputAlias = crate::operation::PutDataLakeSettings;
#[doc(hidden)]
pub type PutDataLakeSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutDataLakeSettingsInput {
    /// Consumes the builder and constructs an Operation<[`PutDataLakeSettings`](crate::operation::PutDataLakeSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDataLakeSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutDataLakeSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/PutDataLakeSettings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutDataLakeSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutDataLakeSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_data_lake_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDataLakeSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDataLakeSettings",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutDataLakeSettingsInput`](crate::input::PutDataLakeSettingsInput)
    pub fn builder() -> crate::input::put_data_lake_settings_input::Builder {
        crate::input::put_data_lake_settings_input::Builder::default()
    }
}

/// See [`RegisterResourceInput`](crate::input::RegisterResourceInput)
pub mod register_resource_input {
    /// A builder for [`RegisterResourceInput`](crate::input::RegisterResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) use_service_linked_role: std::option::Option<bool>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn use_service_linked_role(mut self, input: bool) -> Self {
            self.use_service_linked_role = Some(input);
            self
        }
        /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn set_use_service_linked_role(mut self, input: std::option::Option<bool>) -> Self {
            self.use_service_linked_role = input;
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterResourceInput`](crate::input::RegisterResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterResourceInput {
                resource_arn: self.resource_arn,
                use_service_linked_role: self.use_service_linked_role,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterResourceInputOperationOutputAlias = crate::operation::RegisterResource;
#[doc(hidden)]
pub type RegisterResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterResourceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterResource`](crate::operation::RegisterResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/RegisterResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterResourceInput`](crate::input::RegisterResourceInput)
    pub fn builder() -> crate::input::register_resource_input::Builder {
        crate::input::register_resource_input::Builder::default()
    }
}

/// See [`RemoveLfTagsFromResourceInput`](crate::input::RemoveLfTagsFromResourceInput)
pub mod remove_lf_tags_from_resource_input {
    /// A builder for [`RemoveLfTagsFromResourceInput`](crate::input::RemoveLfTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `lf_tags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The LF-tags to be removed from the resource.</p>
        pub fn lf_tags(mut self, input: crate::model::LfTagPair) -> Self {
            let mut v = self.lf_tags.unwrap_or_default();
            v.push(input);
            self.lf_tags = Some(v);
            self
        }
        /// <p>The LF-tags to be removed from the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveLfTagsFromResourceInput`](crate::input::RemoveLfTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveLfTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveLfTagsFromResourceInput {
                catalog_id: self.catalog_id,
                resource: self.resource,
                lf_tags: self.lf_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveLfTagsFromResourceInputOperationOutputAlias =
    crate::operation::RemoveLFTagsFromResource;
#[doc(hidden)]
pub type RemoveLfTagsFromResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveLfTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveLFTagsFromResource`](crate::operation::RemoveLFTagsFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveLFTagsFromResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveLfTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/RemoveLFTagsFromResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveLfTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveLfTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_lf_tags_from_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveLFTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveLFTagsFromResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveLfTagsFromResourceInput`](crate::input::RemoveLfTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_lf_tags_from_resource_input::Builder {
        crate::input::remove_lf_tags_from_resource_input::Builder::default()
    }
}

/// See [`RevokePermissionsInput`](crate::input::RevokePermissionsInput)
pub mod revoke_permissions_input {
    /// A builder for [`RevokePermissionsInput`](crate::input::RevokePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) permissions_with_grant_option:
            std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
        pub fn permissions(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `permissions_with_grant_option`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn permissions_with_grant_option(mut self, input: crate::model::Permission) -> Self {
            let mut v = self.permissions_with_grant_option.unwrap_or_default();
            v.push(input);
            self.permissions_with_grant_option = Some(v);
            self
        }
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions_with_grant_option = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokePermissionsInput`](crate::input::RevokePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokePermissionsInput {
                catalog_id: self.catalog_id,
                principal: self.principal,
                resource: self.resource,
                permissions: self.permissions,
                permissions_with_grant_option: self.permissions_with_grant_option,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokePermissionsInputOperationOutputAlias = crate::operation::RevokePermissions;
#[doc(hidden)]
pub type RevokePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RevokePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`RevokePermissions`](crate::operation::RevokePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/RevokePermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokePermissions",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokePermissionsInput`](crate::input::RevokePermissionsInput)
    pub fn builder() -> crate::input::revoke_permissions_input::Builder {
        crate::input::revoke_permissions_input::Builder::default()
    }
}

/// See [`SearchDatabasesByLfTagsInput`](crate::input::SearchDatabasesByLfTagsInput)
pub mod search_databases_by_lf_tags_input {
    /// A builder for [`SearchDatabasesByLfTagsInput`](crate::input::SearchDatabasesByLfTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
    }
    impl Builder {
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Appends an item to `expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn expression(mut self, input: crate::model::LfTag) -> Self {
            let mut v = self.expression.unwrap_or_default();
            v.push(input);
            self.expression = Some(v);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchDatabasesByLfTagsInput`](crate::input::SearchDatabasesByLfTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchDatabasesByLfTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchDatabasesByLfTagsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                catalog_id: self.catalog_id,
                expression: self.expression,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchDatabasesByLfTagsInputOperationOutputAlias =
    crate::operation::SearchDatabasesByLFTags;
#[doc(hidden)]
pub type SearchDatabasesByLfTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchDatabasesByLfTagsInput {
    /// Consumes the builder and constructs an Operation<[`SearchDatabasesByLFTags`](crate::operation::SearchDatabasesByLFTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchDatabasesByLFTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchDatabasesByLfTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/SearchDatabasesByLFTags").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchDatabasesByLfTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchDatabasesByLfTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_databases_by_lf_tags(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchDatabasesByLFTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchDatabasesByLFTags",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchDatabasesByLfTagsInput`](crate::input::SearchDatabasesByLfTagsInput)
    pub fn builder() -> crate::input::search_databases_by_lf_tags_input::Builder {
        crate::input::search_databases_by_lf_tags_input::Builder::default()
    }
}

/// See [`SearchTablesByLfTagsInput`](crate::input::SearchTablesByLfTagsInput)
pub mod search_tables_by_lf_tags_input {
    /// A builder for [`SearchTablesByLfTagsInput`](crate::input::SearchTablesByLfTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
    }
    impl Builder {
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Appends an item to `expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn expression(mut self, input: crate::model::LfTag) -> Self {
            let mut v = self.expression.unwrap_or_default();
            v.push(input);
            self.expression = Some(v);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchTablesByLfTagsInput`](crate::input::SearchTablesByLfTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchTablesByLfTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchTablesByLfTagsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                catalog_id: self.catalog_id,
                expression: self.expression,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchTablesByLfTagsInputOperationOutputAlias = crate::operation::SearchTablesByLFTags;
#[doc(hidden)]
pub type SearchTablesByLfTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchTablesByLfTagsInput {
    /// Consumes the builder and constructs an Operation<[`SearchTablesByLFTags`](crate::operation::SearchTablesByLFTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchTablesByLFTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchTablesByLfTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/SearchTablesByLFTags").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchTablesByLfTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchTablesByLfTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_tables_by_lf_tags(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchTablesByLFTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchTablesByLFTags",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchTablesByLfTagsInput`](crate::input::SearchTablesByLfTagsInput)
    pub fn builder() -> crate::input::search_tables_by_lf_tags_input::Builder {
        crate::input::search_tables_by_lf_tags_input::Builder::default()
    }
}

/// See [`StartQueryPlanningInput`](crate::input::StartQueryPlanningInput)
pub mod start_query_planning_input {
    /// A builder for [`StartQueryPlanningInput`](crate::input::StartQueryPlanningInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_planning_context: std::option::Option<crate::model::QueryPlanningContext>,
        pub(crate) query_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A structure containing information about the query plan.</p>
        pub fn query_planning_context(mut self, input: crate::model::QueryPlanningContext) -> Self {
            self.query_planning_context = Some(input);
            self
        }
        /// <p>A structure containing information about the query plan.</p>
        pub fn set_query_planning_context(
            mut self,
            input: std::option::Option<crate::model::QueryPlanningContext>,
        ) -> Self {
            self.query_planning_context = input;
            self
        }
        /// <p>A PartiQL query statement used as an input to the planner service.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>A PartiQL query statement used as an input to the planner service.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// Consumes the builder and constructs a [`StartQueryPlanningInput`](crate::input::StartQueryPlanningInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartQueryPlanningInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartQueryPlanningInput {
                query_planning_context: self.query_planning_context,
                query_string: self.query_string,
            })
        }
    }
}
#[doc(hidden)]
pub type StartQueryPlanningInputOperationOutputAlias = crate::operation::StartQueryPlanning;
#[doc(hidden)]
pub type StartQueryPlanningInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartQueryPlanningInput {
    /// Consumes the builder and constructs an Operation<[`StartQueryPlanning`](crate::operation::StartQueryPlanning)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartQueryPlanning,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartQueryPlanningInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StartQueryPlanning").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartQueryPlanningInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartQueryPlanningInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_query_planning(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("query-")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartQueryPlanning::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartQueryPlanning",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartQueryPlanningInput`](crate::input::StartQueryPlanningInput)
    pub fn builder() -> crate::input::start_query_planning_input::Builder {
        crate::input::start_query_planning_input::Builder::default()
    }
}

/// See [`StartTransactionInput`](crate::input::StartTransactionInput)
pub mod start_transaction_input {
    /// A builder for [`StartTransactionInput`](crate::input::StartTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_type: std::option::Option<crate::model::TransactionType>,
    }
    impl Builder {
        /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
        pub fn transaction_type(mut self, input: crate::model::TransactionType) -> Self {
            self.transaction_type = Some(input);
            self
        }
        /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
        pub fn set_transaction_type(
            mut self,
            input: std::option::Option<crate::model::TransactionType>,
        ) -> Self {
            self.transaction_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTransactionInput`](crate::input::StartTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartTransactionInput {
                transaction_type: self.transaction_type,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTransactionInputOperationOutputAlias = crate::operation::StartTransaction;
#[doc(hidden)]
pub type StartTransactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartTransactionInput {
    /// Consumes the builder and constructs an Operation<[`StartTransaction`](crate::operation::StartTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTransaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StartTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartTransaction",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTransactionInput`](crate::input::StartTransactionInput)
    pub fn builder() -> crate::input::start_transaction_input::Builder {
        crate::input::start_transaction_input::Builder::default()
    }
}

/// See [`UpdateLfTagInput`](crate::input::UpdateLfTagInput)
pub mod update_lf_tag_input {
    /// A builder for [`UpdateLfTagInput`](crate::input::UpdateLfTagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag for which to add or delete values.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag for which to add or delete values.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values_to_delete`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_delete`](Self::set_tag_values_to_delete).
        ///
        /// <p>A list of LF-tag values to delete from the LF-tag.</p>
        pub fn tag_values_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values_to_delete.unwrap_or_default();
            v.push(input.into());
            self.tag_values_to_delete = Some(v);
            self
        }
        /// <p>A list of LF-tag values to delete from the LF-tag.</p>
        pub fn set_tag_values_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values_to_delete = input;
            self
        }
        /// Appends an item to `tag_values_to_add`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_add`](Self::set_tag_values_to_add).
        ///
        /// <p>A list of LF-tag values to add from the LF-tag.</p>
        pub fn tag_values_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values_to_add.unwrap_or_default();
            v.push(input.into());
            self.tag_values_to_add = Some(v);
            self
        }
        /// <p>A list of LF-tag values to add from the LF-tag.</p>
        pub fn set_tag_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values_to_add = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLfTagInput`](crate::input::UpdateLfTagInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLfTagInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLfTagInput {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
                tag_values_to_delete: self.tag_values_to_delete,
                tag_values_to_add: self.tag_values_to_add,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLfTagInputOperationOutputAlias = crate::operation::UpdateLFTag;
#[doc(hidden)]
pub type UpdateLfTagInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLfTagInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLFTag`](crate::operation::UpdateLFTag)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLFTag,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLfTagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateLFTag").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLfTagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLfTagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_lf_tag(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLFTag::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLFTag",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLfTagInput`](crate::input::UpdateLfTagInput)
    pub fn builder() -> crate::input::update_lf_tag_input::Builder {
        crate::input::update_lf_tag_input::Builder::default()
    }
}

/// See [`UpdateResourceInput`](crate::input::UpdateResourceInput)
pub mod update_resource_input {
    /// A builder for [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The new role to use for the given resource registered in Lake Formation.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The new role to use for the given resource registered in Lake Formation.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceInput`](crate::input::UpdateResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceInput {
                role_arn: self.role_arn,
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceInputOperationOutputAlias = crate::operation::UpdateResource;
#[doc(hidden)]
pub type UpdateResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResource`](crate::operation::UpdateResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResource",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceInput`](crate::input::UpdateResourceInput)
    pub fn builder() -> crate::input::update_resource_input::Builder {
        crate::input::update_resource_input::Builder::default()
    }
}

/// See [`UpdateTableObjectsInput`](crate::input::UpdateTableObjectsInput)
pub mod update_table_objects_input {
    /// A builder for [`UpdateTableObjectsInput`](crate::input::UpdateTableObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) write_operations:
            std::option::Option<std::vec::Vec<crate::model::WriteOperation>>,
    }
    impl Builder {
        /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database containing the governed table to update.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database containing the governed table to update.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The governed table to update.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The governed table to update.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The transaction at which to do the write.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction at which to do the write.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Appends an item to `write_operations`.
        ///
        /// To override the contents of this collection use [`set_write_operations`](Self::set_write_operations).
        ///
        /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
        pub fn write_operations(mut self, input: crate::model::WriteOperation) -> Self {
            let mut v = self.write_operations.unwrap_or_default();
            v.push(input);
            self.write_operations = Some(v);
            self
        }
        /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
        pub fn set_write_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WriteOperation>>,
        ) -> Self {
            self.write_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableObjectsInput`](crate::input::UpdateTableObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTableObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTableObjectsInput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                transaction_id: self.transaction_id,
                write_operations: self.write_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTableObjectsInputOperationOutputAlias = crate::operation::UpdateTableObjects;
#[doc(hidden)]
pub type UpdateTableObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTableObjectsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTableObjects`](crate::operation::UpdateTableObjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTableObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTableObjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateTableObjects").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTableObjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTableObjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_table_objects(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTableObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTableObjects",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTableObjectsInput`](crate::input::UpdateTableObjectsInput)
    pub fn builder() -> crate::input::update_table_objects_input::Builder {
        crate::input::update_table_objects_input::Builder::default()
    }
}

/// See [`UpdateTableStorageOptimizerInput`](crate::input::UpdateTableStorageOptimizerInput)
pub mod update_table_storage_optimizer_input {
    /// A builder for [`UpdateTableStorageOptimizerInput`](crate::input::UpdateTableStorageOptimizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) storage_optimizer_config: std::option::Option<
            std::collections::HashMap<
                crate::model::OptimizerType,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// <p>The Catalog ID of the table.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The Catalog ID of the table.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Name of the database where the table is present.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `storage_optimizer_config`.
        ///
        /// To override the contents of this collection use [`set_storage_optimizer_config`](Self::set_storage_optimizer_config).
        ///
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn storage_optimizer_config(
            mut self,
            k: crate::model::OptimizerType,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.storage_optimizer_config.unwrap_or_default();
            hash_map.insert(k, v);
            self.storage_optimizer_config = Some(hash_map);
            self
        }
        /// <p>Name of the table for which to enable the storage optimizer.</p>
        pub fn set_storage_optimizer_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::OptimizerType,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.storage_optimizer_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableStorageOptimizerInput`](crate::input::UpdateTableStorageOptimizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTableStorageOptimizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTableStorageOptimizerInput {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                storage_optimizer_config: self.storage_optimizer_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTableStorageOptimizerInputOperationOutputAlias =
    crate::operation::UpdateTableStorageOptimizer;
#[doc(hidden)]
pub type UpdateTableStorageOptimizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTableStorageOptimizerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTableStorageOptimizer`](crate::operation::UpdateTableStorageOptimizer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTableStorageOptimizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTableStorageOptimizerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UpdateTableStorageOptimizer").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTableStorageOptimizerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTableStorageOptimizerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_table_storage_optimizer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTableStorageOptimizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTableStorageOptimizer",
            "lakeformation",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTableStorageOptimizerInput`](crate::input::UpdateTableStorageOptimizerInput)
    pub fn builder() -> crate::input::update_table_storage_optimizer_input::Builder {
        crate::input::update_table_storage_optimizer_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableStorageOptimizerInput {
    /// <p>The Catalog ID of the table.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>Name of the database where the table is present.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Name of the table for which to enable the storage optimizer.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Name of the table for which to enable the storage optimizer.</p>
    pub storage_optimizer_config: std::option::Option<
        std::collections::HashMap<
            crate::model::OptimizerType,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
}
impl UpdateTableStorageOptimizerInput {
    /// <p>The Catalog ID of the table.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>Name of the database where the table is present.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Name of the table for which to enable the storage optimizer.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Name of the table for which to enable the storage optimizer.</p>
    pub fn storage_optimizer_config(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::OptimizerType,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.storage_optimizer_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateTableStorageOptimizerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableStorageOptimizerInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("storage_optimizer_config", &self.storage_optimizer_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableObjectsInput {
    /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database containing the governed table to update.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The governed table to update.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The transaction at which to do the write.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
    pub write_operations: std::option::Option<std::vec::Vec<crate::model::WriteOperation>>,
}
impl UpdateTableObjectsInput {
    /// <p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database containing the governed table to update.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The governed table to update.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The transaction at which to do the write.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>
    pub fn write_operations(&self) -> std::option::Option<&[crate::model::WriteOperation]> {
        self.write_operations.as_deref()
    }
}
impl std::fmt::Debug for UpdateTableObjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableObjectsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("write_operations", &self.write_operations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceInput {
    /// <p>The new role to use for the given resource registered in Lake Formation.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl UpdateResourceInput {
    /// <p>The new role to use for the given resource registered in Lake Formation.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceInput");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag for which to add or delete values.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>A list of LF-tag values to delete from the LF-tag.</p>
    pub tag_values_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of LF-tag values to add from the LF-tag.</p>
    pub tag_values_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag for which to add or delete values.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>A list of LF-tag values to delete from the LF-tag.</p>
    pub fn tag_values_to_delete(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values_to_delete.as_deref()
    }
    /// <p>A list of LF-tag values to add from the LF-tag.</p>
    pub fn tag_values_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values_to_add.as_deref()
    }
}
impl std::fmt::Debug for UpdateLfTagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLfTagInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values_to_delete", &self.tag_values_to_delete);
        formatter.field("tag_values_to_add", &self.tag_values_to_add);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTransactionInput {
    /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
    pub transaction_type: std::option::Option<crate::model::TransactionType>,
}
impl StartTransactionInput {
    /// <p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>
    pub fn transaction_type(&self) -> std::option::Option<&crate::model::TransactionType> {
        self.transaction_type.as_ref()
    }
}
impl std::fmt::Debug for StartTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTransactionInput");
        formatter.field("transaction_type", &self.transaction_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartQueryPlanningInput {
    /// <p>A structure containing information about the query plan.</p>
    pub query_planning_context: std::option::Option<crate::model::QueryPlanningContext>,
    /// <p>A PartiQL query statement used as an input to the planner service.</p>
    pub query_string: std::option::Option<std::string::String>,
}
impl StartQueryPlanningInput {
    /// <p>A structure containing information about the query plan.</p>
    pub fn query_planning_context(
        &self,
    ) -> std::option::Option<&crate::model::QueryPlanningContext> {
        self.query_planning_context.as_ref()
    }
    /// <p>A PartiQL query statement used as an input to the planner service.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
}
impl std::fmt::Debug for StartQueryPlanningInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartQueryPlanningInput");
        formatter.field("query_planning_context", &self.query_planning_context);
        formatter.field("query_string", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchTablesByLfTagsInput {
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
    pub expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
}
impl SearchTablesByLfTagsInput {
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
    pub fn expression(&self) -> std::option::Option<&[crate::model::LfTag]> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for SearchTablesByLfTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchTablesByLfTagsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchDatabasesByLfTagsInput {
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
    pub expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
}
impl SearchDatabasesByLfTagsInput {
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
    pub fn expression(&self) -> std::option::Option<&[crate::model::LfTag]> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for SearchDatabasesByLfTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchDatabasesByLfTagsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokePermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The principal to be revoked permissions on the resource.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The resource to which permissions are to be revoked.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
    pub permissions_with_grant_option: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl RevokePermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The principal to be revoked permissions on the resource.</p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>The resource to which permissions are to be revoked.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
    pub fn permissions_with_grant_option(
        &self,
    ) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions_with_grant_option.as_deref()
    }
}
impl std::fmt::Debug for RevokePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokePermissionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("principal", &self.principal);
        formatter.field("resource", &self.resource);
        formatter.field("permissions", &self.permissions);
        formatter.field(
            "permissions_with_grant_option",
            &self.permissions_with_grant_option,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveLfTagsFromResourceInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The LF-tags to be removed from the resource.</p>
    pub lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
}
impl RemoveLfTagsFromResourceInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database, table, or column resource where you want to remove an LF-tag.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The LF-tags to be removed from the resource.</p>
    pub fn lf_tags(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tags.as_deref()
    }
}
impl std::fmt::Debug for RemoveLfTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveLfTagsFromResourceInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource", &self.resource);
        formatter.field("lf_tags", &self.lf_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
    /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
    pub use_service_linked_role: std::option::Option<bool>,
    /// <p>The identifier for the role that registers the resource.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl RegisterResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
    /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
    pub fn use_service_linked_role(&self) -> std::option::Option<bool> {
        self.use_service_linked_role
    }
    /// <p>The identifier for the role that registers the resource.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for RegisterResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("use_service_linked_role", &self.use_service_linked_role);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDataLakeSettingsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
    pub data_lake_settings: std::option::Option<crate::model::DataLakeSettings>,
}
impl PutDataLakeSettingsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>
    pub fn data_lake_settings(&self) -> std::option::Option<&crate::model::DataLakeSettings> {
        self.data_lake_settings.as_ref()
    }
}
impl std::fmt::Debug for PutDataLakeSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDataLakeSettingsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("data_lake_settings", &self.data_lake_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTransactionsInput {
    /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
    pub status_filter: std::option::Option<crate::model::TransactionStatusFilter>,
    /// <p>The maximum number of transactions to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTransactionsInput {
    /// <p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::TransactionStatusFilter> {
        self.status_filter.as_ref()
    }
    /// <p>The maximum number of transactions to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A continuation token if this is not the first call to retrieve transactions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTransactionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTransactionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("status_filter", &self.status_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableStorageOptimizersInput {
    /// <p>The Catalog ID of the table.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>Name of the database where the table is present.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
    pub storage_optimizer_type: std::option::Option<crate::model::OptimizerType>,
    /// <p>The number of storage optimizers to return on each call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A continuation token, if this is a continuation call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTableStorageOptimizersInput {
    /// <p>The Catalog ID of the table.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>Name of the database where the table is present.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>
    pub fn storage_optimizer_type(&self) -> std::option::Option<&crate::model::OptimizerType> {
        self.storage_optimizer_type.as_ref()
    }
    /// <p>The number of storage optimizers to return on each call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A continuation token, if this is a continuation call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTableStorageOptimizersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableStorageOptimizersInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("storage_optimizer_type", &self.storage_optimizer_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesInput {
    /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
    pub filter_condition_list: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
    /// <p>The maximum number of resource results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourcesInput {
    /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
    pub fn filter_condition_list(&self) -> std::option::Option<&[crate::model::FilterCondition]> {
        self.filter_condition_list.as_deref()
    }
    /// <p>The maximum number of resource results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesInput");
        formatter.field("filter_condition_list", &self.filter_condition_list);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>Specifies a principal to filter the permissions returned.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>Specifies a resource type to filter the permissions returned.</p>
    pub resource_type: std::option::Option<crate::model::DataLakeResourceType>,
    /// <p>A resource where you will get a list of the principal permissions.</p>
    /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Indicates that related permissions should be included in the results.</p>
    pub include_related: std::option::Option<std::string::String>,
}
impl ListPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>Specifies a principal to filter the permissions returned.</p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>Specifies a resource type to filter the permissions returned.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::DataLakeResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>A resource where you will get a list of the principal permissions.</p>
    /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Indicates that related permissions should be included in the results.</p>
    pub fn include_related(&self) -> std::option::Option<&str> {
        self.include_related.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("principal", &self.principal);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("include_related", &self.include_related);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLfTagsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
    pub resource_share_type: std::option::Option<crate::model::ResourceShareType>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLfTagsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>
    pub fn resource_share_type(&self) -> std::option::Option<&crate::model::ResourceShareType> {
        self.resource_share_type.as_ref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLfTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLfTagsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource_share_type", &self.resource_share_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataCellsFilterInput {
    /// <p>A table in the Glue Data Catalog.</p>
    pub table: std::option::Option<crate::model::TableResource>,
    /// <p>A continuation token, if this is a continuation call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDataCellsFilterInput {
    /// <p>A table in the Glue Data Catalog.</p>
    pub fn table(&self) -> std::option::Option<&crate::model::TableResource> {
        self.table.as_ref()
    }
    /// <p>A continuation token, if this is a continuation call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDataCellsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataCellsFilterInput");
        formatter.field("table", &self.table);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
    /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
    pub permissions_with_grant_option: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl GrantPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
    /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
    pub fn permissions_with_grant_option(
        &self,
    ) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions_with_grant_option.as_deref()
    }
}
impl std::fmt::Debug for GrantPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantPermissionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("principal", &self.principal);
        formatter.field("resource", &self.resource);
        formatter.field("permissions", &self.permissions);
        formatter.field(
            "permissions_with_grant_option",
            &self.permissions_with_grant_option,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkUnitsInput {
    /// <p>A continuation token, if this is a continuation call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
    pub page_size: std::option::Option<i32>,
    /// <p>The ID of the plan query operation.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl GetWorkUnitsInput {
    /// <p>A continuation token, if this is a continuation call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command's output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
    /// <p>The ID of the plan query operation.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for GetWorkUnitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkUnitsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkUnitResultsInput {
    /// <p>The ID of the plan query operation for which to get results.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
    pub work_unit_id: i64,
    /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
    pub work_unit_token: std::option::Option<std::string::String>,
}
impl GetWorkUnitResultsInput {
    /// <p>The ID of the plan query operation for which to get results.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
    pub fn work_unit_id(&self) -> i64 {
        self.work_unit_id
    }
    /// <p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>
    pub fn work_unit_token(&self) -> std::option::Option<&str> {
        self.work_unit_token.as_deref()
    }
}
impl std::fmt::Debug for GetWorkUnitResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkUnitResultsInput");
        formatter.field("query_id", &self.query_id);
        formatter.field("work_unit_id", &self.work_unit_id);
        formatter.field("work_unit_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTemporaryGlueTableCredentialsInput {
    /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    pub duration_seconds: std::option::Option<i32>,
    /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    pub audit_context: std::option::Option<crate::model::AuditContext>,
    /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    pub supported_permission_types:
        std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
}
impl GetTemporaryGlueTableCredentialsInput {
    /// <p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    pub fn duration_seconds(&self) -> std::option::Option<i32> {
        self.duration_seconds
    }
    /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    pub fn audit_context(&self) -> std::option::Option<&crate::model::AuditContext> {
        self.audit_context.as_ref()
    }
    /// <p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    pub fn supported_permission_types(
        &self,
    ) -> std::option::Option<&[crate::model::PermissionType]> {
        self.supported_permission_types.as_deref()
    }
}
impl std::fmt::Debug for GetTemporaryGlueTableCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTemporaryGlueTableCredentialsInput");
        formatter.field("table_arn", &self.table_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("audit_context", &self.audit_context);
        formatter.field(
            "supported_permission_types",
            &self.supported_permission_types,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTemporaryGluePartitionCredentialsInput {
    /// <p>The ARN of the partitions' table.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>A list of partition values identifying a single partition.</p>
    pub partition: std::option::Option<crate::model::PartitionValueList>,
    /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    pub duration_seconds: std::option::Option<i32>,
    /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    pub audit_context: std::option::Option<crate::model::AuditContext>,
    /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    pub supported_permission_types:
        std::option::Option<std::vec::Vec<crate::model::PermissionType>>,
}
impl GetTemporaryGluePartitionCredentialsInput {
    /// <p>The ARN of the partitions' table.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>A list of partition values identifying a single partition.</p>
    pub fn partition(&self) -> std::option::Option<&crate::model::PartitionValueList> {
        self.partition.as_ref()
    }
    /// <p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>
    pub fn duration_seconds(&self) -> std::option::Option<i32> {
        self.duration_seconds
    }
    /// <p>A structure representing context to access a resource (column names, query ID, etc).</p>
    pub fn audit_context(&self) -> std::option::Option<&crate::model::AuditContext> {
        self.audit_context.as_ref()
    }
    /// <p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>
    pub fn supported_permission_types(
        &self,
    ) -> std::option::Option<&[crate::model::PermissionType]> {
        self.supported_permission_types.as_deref()
    }
}
impl std::fmt::Debug for GetTemporaryGluePartitionCredentialsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTemporaryGluePartitionCredentialsInput");
        formatter.field("table_arn", &self.table_arn);
        formatter.field("partition", &self.partition);
        formatter.field("permissions", &self.permissions);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("audit_context", &self.audit_context);
        formatter.field(
            "supported_permission_types",
            &self.supported_permission_types,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableObjectsInput {
    /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database containing the governed table.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The governed table for which to retrieve objects.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
    pub query_as_of_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
    /// <ul>
    /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
    /// <li> <p>The logical operators supported are: AND</p> </li>
    /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
    /// </ul>
    pub partition_predicate: std::option::Option<std::string::String>,
    /// <p>Specifies how many values to return in a page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTableObjectsInput {
    /// <p>The catalog containing the governed table. Defaults to the caller’s account.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database containing the governed table.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The governed table for which to retrieve objects.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>
    pub fn query_as_of_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.query_as_of_time.as_ref()
    }
    /// <p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
    /// <ul>
    /// <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li>
    /// <li> <p>The logical operators supported are: AND</p> </li>
    /// <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li>
    /// </ul>
    pub fn partition_predicate(&self) -> std::option::Option<&str> {
        self.partition_predicate.as_deref()
    }
    /// <p>Specifies how many values to return in a page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A continuation token if this is not the first call to retrieve these objects.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTableObjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableObjectsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("query_as_of_time", &self.query_as_of_time);
        formatter.field("partition_predicate", &self.partition_predicate);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceLfTagsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>Indicates whether to show the assigned LF-tags.</p>
    pub show_assigned_lf_tags: std::option::Option<bool>,
}
impl GetResourceLfTagsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database, table, or column resource for which you want to return LF-tags.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>Indicates whether to show the assigned LF-tags.</p>
    pub fn show_assigned_lf_tags(&self) -> std::option::Option<bool> {
        self.show_assigned_lf_tags
    }
}
impl std::fmt::Debug for GetResourceLfTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceLfTagsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource", &self.resource);
        formatter.field("show_assigned_lf_tags", &self.show_assigned_lf_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryStatisticsInput {
    /// <p>The ID of the plan query operation.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl GetQueryStatisticsInput {
    /// <p>The ID of the plan query operation.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for GetQueryStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryStatisticsInput");
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryStateInput {
    /// <p>The ID of the plan query operation.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl GetQueryStateInput {
    /// <p>The ID of the plan query operation.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for GetQueryStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryStateInput");
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
}
impl GetLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
}
impl std::fmt::Debug for GetLfTagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLfTagInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEffectivePermissionsForPathInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetEffectivePermissionsForPathInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetEffectivePermissionsForPathInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEffectivePermissionsForPathInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataLakeSettingsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
}
impl GetDataLakeSettingsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
}
impl std::fmt::Debug for GetDataLakeSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataLakeSettingsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendTransactionInput {
    /// <p>The transaction to extend.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl ExtendTransactionInput {
    /// <p>The transaction to extend.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for ExtendTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendTransactionInput");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTransactionInput {
    /// <p>The transaction for which to return status.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl DescribeTransactionInput {
    /// <p>The transaction for which to return status.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTransactionInput");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourceInput {
    /// <p>The resource ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DescribeResourceInput {
    /// <p>The resource ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DeregisterResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DeregisterResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectsOnCancelInput {
    /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database that contains the governed table.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the governed table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>ID of the transaction that the writes occur in.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
    pub objects: std::option::Option<std::vec::Vec<crate::model::VirtualObject>>,
}
impl DeleteObjectsOnCancelInput {
    /// <p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database that contains the governed table.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the governed table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>ID of the transaction that the writes occur in.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>
    pub fn objects(&self) -> std::option::Option<&[crate::model::VirtualObject]> {
        self.objects.as_deref()
    }
}
impl std::fmt::Debug for DeleteObjectsOnCancelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectsOnCancelInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("objects", &self.objects);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag to delete.</p>
    pub tag_key: std::option::Option<std::string::String>,
}
impl DeleteLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag to delete.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
}
impl std::fmt::Debug for DeleteLfTagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLfTagInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataCellsFilterInput {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub table_catalog_id: std::option::Option<std::string::String>,
    /// <p>A database in the Glue Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A table in the database.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name given by the user to the data filter cell.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDataCellsFilterInput {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub fn table_catalog_id(&self) -> std::option::Option<&str> {
        self.table_catalog_id.as_deref()
    }
    /// <p>A database in the Glue Data Catalog.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>A table in the database.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name given by the user to the data filter cell.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataCellsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataCellsFilterInput");
        formatter.field("table_catalog_id", &self.table_catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>A list of possible values an attribute can take.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateLfTagInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>A list of possible values an attribute can take.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for CreateLfTagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLfTagInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataCellsFilterInput {
    /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
    pub table_data: std::option::Option<crate::model::DataCellsFilter>,
}
impl CreateDataCellsFilterInput {
    /// <p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>
    pub fn table_data(&self) -> std::option::Option<&crate::model::DataCellsFilter> {
        self.table_data.as_ref()
    }
}
impl std::fmt::Debug for CreateDataCellsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataCellsFilterInput");
        formatter.field("table_data", &self.table_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommitTransactionInput {
    /// <p>The transaction to commit.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl CommitTransactionInput {
    /// <p>The transaction to commit.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for CommitTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommitTransactionInput");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelTransactionInput {
    /// <p>The transaction to cancel.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl CancelTransactionInput {
    /// <p>The transaction to cancel.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for CancelTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelTransactionInput");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRevokePermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
}
impl BatchRevokePermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::BatchPermissionsRequestEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for BatchRevokePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRevokePermissionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGrantPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
}
impl BatchGrantPermissionsInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::BatchPermissionsRequestEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for BatchGrantPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGrantPermissionsInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddLfTagsToResourceInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The LF-tags to attach to the resource.</p>
    pub lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
}
impl AddLfTagsToResourceInput {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database, table, or column resource to which to attach an LF-tag.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The LF-tags to attach to the resource.</p>
    pub fn lf_tags(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tags.as_deref()
    }
}
impl std::fmt::Debug for AddLfTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddLfTagsToResourceInput");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource", &self.resource);
        formatter.field("lf_tags", &self.lf_tags);
        formatter.finish()
    }
}
