// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptimizerType {
    #[allow(missing_docs)] // documentation missing in model
    Generic,
    #[allow(missing_docs)] // documentation missing in model
    Compaction,
    #[allow(missing_docs)] // documentation missing in model
    GarbageCollection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptimizerType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => OptimizerType::Generic,
            "COMPACTION" => OptimizerType::Compaction,
            "GARBAGE_COLLECTION" => OptimizerType::GarbageCollection,
            other => OptimizerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptimizerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptimizerType::from(s))
    }
}
impl OptimizerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptimizerType::Generic => "ALL",
            OptimizerType::Compaction => "COMPACTION",
            OptimizerType::GarbageCollection => "GARBAGE_COLLECTION",
            OptimizerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "COMPACTION", "GARBAGE_COLLECTION"]
    }
}
impl AsRef<str> for OptimizerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines an object to add to or delete from a governed table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteOperation {
    /// <p>A new object to add to the governed table.</p>
    pub add_object: std::option::Option<crate::model::AddObjectInput>,
    /// <p>An object to delete from the governed table.</p>
    pub delete_object: std::option::Option<crate::model::DeleteObjectInput>,
}
impl WriteOperation {
    /// <p>A new object to add to the governed table.</p>
    pub fn add_object(&self) -> std::option::Option<&crate::model::AddObjectInput> {
        self.add_object.as_ref()
    }
    /// <p>An object to delete from the governed table.</p>
    pub fn delete_object(&self) -> std::option::Option<&crate::model::DeleteObjectInput> {
        self.delete_object.as_ref()
    }
}
impl std::fmt::Debug for WriteOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteOperation");
        formatter.field("add_object", &self.add_object);
        formatter.field("delete_object", &self.delete_object);
        formatter.finish()
    }
}
/// See [`WriteOperation`](crate::model::WriteOperation)
pub mod write_operation {
    /// A builder for [`WriteOperation`](crate::model::WriteOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_object: std::option::Option<crate::model::AddObjectInput>,
        pub(crate) delete_object: std::option::Option<crate::model::DeleteObjectInput>,
    }
    impl Builder {
        /// <p>A new object to add to the governed table.</p>
        pub fn add_object(mut self, input: crate::model::AddObjectInput) -> Self {
            self.add_object = Some(input);
            self
        }
        /// <p>A new object to add to the governed table.</p>
        pub fn set_add_object(
            mut self,
            input: std::option::Option<crate::model::AddObjectInput>,
        ) -> Self {
            self.add_object = input;
            self
        }
        /// <p>An object to delete from the governed table.</p>
        pub fn delete_object(mut self, input: crate::model::DeleteObjectInput) -> Self {
            self.delete_object = Some(input);
            self
        }
        /// <p>An object to delete from the governed table.</p>
        pub fn set_delete_object(
            mut self,
            input: std::option::Option<crate::model::DeleteObjectInput>,
        ) -> Self {
            self.delete_object = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteOperation`](crate::model::WriteOperation)
        pub fn build(self) -> crate::model::WriteOperation {
            crate::model::WriteOperation {
                add_object: self.add_object,
                delete_object: self.delete_object,
            }
        }
    }
}
impl WriteOperation {
    /// Creates a new builder-style object to manufacture [`WriteOperation`](crate::model::WriteOperation)
    pub fn builder() -> crate::model::write_operation::Builder {
        crate::model::write_operation::Builder::default()
    }
}

/// <p>An object to delete from the governed table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectInput {
    /// <p>The Amazon S3 location of the object to delete.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the governed table.</p>
    pub partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteObjectInput {
    /// <p>The Amazon S3 location of the object to delete.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the governed table.</p>
    pub fn partition_values(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_values.as_deref()
    }
}
impl std::fmt::Debug for DeleteObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectInput");
        formatter.field("uri", &self.uri);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("partition_values", &self.partition_values);
        formatter.finish()
    }
}
/// See [`DeleteObjectInput`](crate::model::DeleteObjectInput)
pub mod delete_object_input {
    /// A builder for [`DeleteObjectInput`](crate::model::DeleteObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon S3 location of the object to delete.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the object to delete.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Appends an item to `partition_values`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the governed table.</p>
        pub fn partition_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_values.unwrap_or_default();
            v.push(input.into());
            self.partition_values = Some(v);
            self
        }
        /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the governed table.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectInput`](crate::model::DeleteObjectInput)
        pub fn build(self) -> crate::model::DeleteObjectInput {
            crate::model::DeleteObjectInput {
                uri: self.uri,
                e_tag: self.e_tag,
                partition_values: self.partition_values,
            }
        }
    }
}
impl DeleteObjectInput {
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::model::DeleteObjectInput)
    pub fn builder() -> crate::model::delete_object_input::Builder {
        crate::model::delete_object_input::Builder::default()
    }
}

/// <p>A new object to add to the governed table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddObjectInput {
    /// <p>The Amazon S3 location of the object.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>The size of the Amazon S3 object in bytes.</p>
    pub size: i64,
    /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the table.</p>
    /// <p>The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p>
    pub partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AddObjectInput {
    /// <p>The Amazon S3 location of the object.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>The size of the Amazon S3 object in bytes.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the table.</p>
    /// <p>The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p>
    pub fn partition_values(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_values.as_deref()
    }
}
impl std::fmt::Debug for AddObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddObjectInput");
        formatter.field("uri", &self.uri);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("size", &self.size);
        formatter.field("partition_values", &self.partition_values);
        formatter.finish()
    }
}
/// See [`AddObjectInput`](crate::model::AddObjectInput)
pub mod add_object_input {
    /// A builder for [`AddObjectInput`](crate::model::AddObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon S3 location of the object.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the object.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>The size of the Amazon S3 object in bytes.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the Amazon S3 object in bytes.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Appends an item to `partition_values`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the table.</p>
        /// <p>The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p>
        pub fn partition_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_values.unwrap_or_default();
            v.push(input.into());
            self.partition_values = Some(v);
            self
        }
        /// <p>A list of partition values for the object. A value must be specified for each partition key associated with the table.</p>
        /// <p>The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AddObjectInput`](crate::model::AddObjectInput)
        pub fn build(self) -> crate::model::AddObjectInput {
            crate::model::AddObjectInput {
                uri: self.uri,
                e_tag: self.e_tag,
                size: self.size.unwrap_or_default(),
                partition_values: self.partition_values,
            }
        }
    }
}
impl AddObjectInput {
    /// Creates a new builder-style object to manufacture [`AddObjectInput`](crate::model::AddObjectInput)
    pub fn builder() -> crate::model::add_object_input::Builder {
        crate::model::add_object_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransactionType {
    #[allow(missing_docs)] // documentation missing in model
    ReadAndWrite,
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransactionType {
    fn from(s: &str) -> Self {
        match s {
            "READ_AND_WRITE" => TransactionType::ReadAndWrite,
            "READ_ONLY" => TransactionType::ReadOnly,
            other => TransactionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransactionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransactionType::from(s))
    }
}
impl TransactionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransactionType::ReadAndWrite => "READ_AND_WRITE",
            TransactionType::ReadOnly => "READ_ONLY",
            TransactionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["READ_AND_WRITE", "READ_ONLY"]
    }
}
impl AsRef<str> for TransactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing information about the query plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryPlanningContext {
    /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The database containing the table.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
    pub query_as_of_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A map consisting of key-value pairs.</p>
    pub query_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl QueryPlanningContext {
    /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The database containing the table.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
    pub fn query_as_of_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.query_as_of_time.as_ref()
    }
    /// <p>A map consisting of key-value pairs.</p>
    pub fn query_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.query_parameters.as_ref()
    }
    /// <p>The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for QueryPlanningContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryPlanningContext");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("query_as_of_time", &self.query_as_of_time);
        formatter.field("query_parameters", &self.query_parameters);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}
/// See [`QueryPlanningContext`](crate::model::QueryPlanningContext)
pub mod query_planning_context {
    /// A builder for [`QueryPlanningContext`](crate::model::QueryPlanningContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) query_as_of_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) query_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The database containing the table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database containing the table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.query_as_of_time = Some(input);
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.query_as_of_time = input;
            self
        }
        /// Adds a key-value pair to `query_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>A map consisting of key-value pairs.</p>
        pub fn query_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.query_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.query_parameters = Some(hash_map);
            self
        }
        /// <p>A map consisting of key-value pairs.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.query_parameters = input;
            self
        }
        /// <p>The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryPlanningContext`](crate::model::QueryPlanningContext)
        pub fn build(self) -> crate::model::QueryPlanningContext {
            crate::model::QueryPlanningContext {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                query_as_of_time: self.query_as_of_time,
                query_parameters: self.query_parameters,
                transaction_id: self.transaction_id,
            }
        }
    }
}
impl QueryPlanningContext {
    /// Creates a new builder-style object to manufacture [`QueryPlanningContext`](crate::model::QueryPlanningContext)
    pub fn builder() -> crate::model::query_planning_context::Builder {
        crate::model::query_planning_context::Builder::default()
    }
}

/// <p>A structure describing a table resource with LF-tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaggedTable {
    /// <p>A table that has LF-tags attached to it.</p>
    pub table: std::option::Option<crate::model::TableResource>,
    /// <p>A list of LF-tags attached to the database where the table resides.</p>
    pub lf_tag_on_database: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    /// <p>A list of LF-tags attached to the table.</p>
    pub lf_tags_on_table: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    /// <p>A list of LF-tags attached to columns in the table.</p>
    pub lf_tags_on_columns: std::option::Option<std::vec::Vec<crate::model::ColumnLfTag>>,
}
impl TaggedTable {
    /// <p>A table that has LF-tags attached to it.</p>
    pub fn table(&self) -> std::option::Option<&crate::model::TableResource> {
        self.table.as_ref()
    }
    /// <p>A list of LF-tags attached to the database where the table resides.</p>
    pub fn lf_tag_on_database(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tag_on_database.as_deref()
    }
    /// <p>A list of LF-tags attached to the table.</p>
    pub fn lf_tags_on_table(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tags_on_table.as_deref()
    }
    /// <p>A list of LF-tags attached to columns in the table.</p>
    pub fn lf_tags_on_columns(&self) -> std::option::Option<&[crate::model::ColumnLfTag]> {
        self.lf_tags_on_columns.as_deref()
    }
}
impl std::fmt::Debug for TaggedTable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaggedTable");
        formatter.field("table", &self.table);
        formatter.field("lf_tag_on_database", &self.lf_tag_on_database);
        formatter.field("lf_tags_on_table", &self.lf_tags_on_table);
        formatter.field("lf_tags_on_columns", &self.lf_tags_on_columns);
        formatter.finish()
    }
}
/// See [`TaggedTable`](crate::model::TaggedTable)
pub mod tagged_table {
    /// A builder for [`TaggedTable`](crate::model::TaggedTable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table: std::option::Option<crate::model::TableResource>,
        pub(crate) lf_tag_on_database: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        pub(crate) lf_tags_on_table: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        pub(crate) lf_tags_on_columns:
            std::option::Option<std::vec::Vec<crate::model::ColumnLfTag>>,
    }
    impl Builder {
        /// <p>A table that has LF-tags attached to it.</p>
        pub fn table(mut self, input: crate::model::TableResource) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>A table that has LF-tags attached to it.</p>
        pub fn set_table(
            mut self,
            input: std::option::Option<crate::model::TableResource>,
        ) -> Self {
            self.table = input;
            self
        }
        /// Appends an item to `lf_tag_on_database`.
        ///
        /// To override the contents of this collection use [`set_lf_tag_on_database`](Self::set_lf_tag_on_database).
        ///
        /// <p>A list of LF-tags attached to the database where the table resides.</p>
        pub fn lf_tag_on_database(mut self, input: impl Into<crate::model::LfTagPair>) -> Self {
            let mut v = self.lf_tag_on_database.unwrap_or_default();
            v.push(input.into());
            self.lf_tag_on_database = Some(v);
            self
        }
        /// <p>A list of LF-tags attached to the database where the table resides.</p>
        pub fn set_lf_tag_on_database(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tag_on_database = input;
            self
        }
        /// Appends an item to `lf_tags_on_table`.
        ///
        /// To override the contents of this collection use [`set_lf_tags_on_table`](Self::set_lf_tags_on_table).
        ///
        /// <p>A list of LF-tags attached to the table.</p>
        pub fn lf_tags_on_table(mut self, input: impl Into<crate::model::LfTagPair>) -> Self {
            let mut v = self.lf_tags_on_table.unwrap_or_default();
            v.push(input.into());
            self.lf_tags_on_table = Some(v);
            self
        }
        /// <p>A list of LF-tags attached to the table.</p>
        pub fn set_lf_tags_on_table(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tags_on_table = input;
            self
        }
        /// Appends an item to `lf_tags_on_columns`.
        ///
        /// To override the contents of this collection use [`set_lf_tags_on_columns`](Self::set_lf_tags_on_columns).
        ///
        /// <p>A list of LF-tags attached to columns in the table.</p>
        pub fn lf_tags_on_columns(mut self, input: impl Into<crate::model::ColumnLfTag>) -> Self {
            let mut v = self.lf_tags_on_columns.unwrap_or_default();
            v.push(input.into());
            self.lf_tags_on_columns = Some(v);
            self
        }
        /// <p>A list of LF-tags attached to columns in the table.</p>
        pub fn set_lf_tags_on_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLfTag>>,
        ) -> Self {
            self.lf_tags_on_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`TaggedTable`](crate::model::TaggedTable)
        pub fn build(self) -> crate::model::TaggedTable {
            crate::model::TaggedTable {
                table: self.table,
                lf_tag_on_database: self.lf_tag_on_database,
                lf_tags_on_table: self.lf_tags_on_table,
                lf_tags_on_columns: self.lf_tags_on_columns,
            }
        }
    }
}
impl TaggedTable {
    /// Creates a new builder-style object to manufacture [`TaggedTable`](crate::model::TaggedTable)
    pub fn builder() -> crate::model::tagged_table::Builder {
        crate::model::tagged_table::Builder::default()
    }
}

/// <p>A structure containing the name of a column resource and the LF-tags attached to it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnLfTag {
    /// <p>The name of a column resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The LF-tags attached to a column resource.</p>
    pub lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
}
impl ColumnLfTag {
    /// <p>The name of a column resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The LF-tags attached to a column resource.</p>
    pub fn lf_tags(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tags.as_deref()
    }
}
impl std::fmt::Debug for ColumnLfTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnLfTag");
        formatter.field("name", &self.name);
        formatter.field("lf_tags", &self.lf_tags);
        formatter.finish()
    }
}
/// See [`ColumnLfTag`](crate::model::ColumnLfTag)
pub mod column_lf_tag {
    /// A builder for [`ColumnLfTag`](crate::model::ColumnLfTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    }
    impl Builder {
        /// <p>The name of a column resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a column resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `lf_tags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The LF-tags attached to a column resource.</p>
        pub fn lf_tags(mut self, input: impl Into<crate::model::LfTagPair>) -> Self {
            let mut v = self.lf_tags.unwrap_or_default();
            v.push(input.into());
            self.lf_tags = Some(v);
            self
        }
        /// <p>The LF-tags attached to a column resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnLfTag`](crate::model::ColumnLfTag)
        pub fn build(self) -> crate::model::ColumnLfTag {
            crate::model::ColumnLfTag {
                name: self.name,
                lf_tags: self.lf_tags,
            }
        }
    }
}
impl ColumnLfTag {
    /// Creates a new builder-style object to manufacture [`ColumnLfTag`](crate::model::ColumnLfTag)
    pub fn builder() -> crate::model::column_lf_tag::Builder {
        crate::model::column_lf_tag::Builder::default()
    }
}

/// <p>A structure containing an LF-tag key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LfTagPair {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>A list of possible values an attribute can take.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LfTagPair {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>A list of possible values an attribute can take.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for LfTagPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LfTagPair");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`LfTagPair`](crate::model::LfTagPair)
pub mod lf_tag_pair {
    /// A builder for [`LfTagPair`](crate::model::LfTagPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`LfTagPair`](crate::model::LfTagPair)
        pub fn build(self) -> crate::model::LfTagPair {
            crate::model::LfTagPair {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl LfTagPair {
    /// Creates a new builder-style object to manufacture [`LfTagPair`](crate::model::LfTagPair)
    pub fn builder() -> crate::model::lf_tag_pair::Builder {
        crate::model::lf_tag_pair::Builder::default()
    }
}

/// <p>A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A wildcard object representing every table under a database.</p>
    ///
    /// <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>
    pub table_wildcard: std::option::Option<crate::model::TableWildcard>,
}
impl TableResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A wildcard object representing every table under a database.</p>
    ///
    /// <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>
    pub fn table_wildcard(&self) -> std::option::Option<&crate::model::TableWildcard> {
        self.table_wildcard.as_ref()
    }
}
impl std::fmt::Debug for TableResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("name", &self.name);
        formatter.field("table_wildcard", &self.table_wildcard);
        formatter.finish()
    }
}
/// See [`TableResource`](crate::model::TableResource)
pub mod table_resource {
    /// A builder for [`TableResource`](crate::model::TableResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) table_wildcard: std::option::Option<crate::model::TableWildcard>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A wildcard object representing every table under a database.</p>
        ///
        /// <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>
        pub fn table_wildcard(mut self, input: crate::model::TableWildcard) -> Self {
            self.table_wildcard = Some(input);
            self
        }
        /// <p>A wildcard object representing every table under a database.</p>
        ///
        /// <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>
        pub fn set_table_wildcard(
            mut self,
            input: std::option::Option<crate::model::TableWildcard>,
        ) -> Self {
            self.table_wildcard = input;
            self
        }
        /// Consumes the builder and constructs a [`TableResource`](crate::model::TableResource)
        pub fn build(self) -> crate::model::TableResource {
            crate::model::TableResource {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                name: self.name,
                table_wildcard: self.table_wildcard,
            }
        }
    }
}
impl TableResource {
    /// Creates a new builder-style object to manufacture [`TableResource`](crate::model::TableResource)
    pub fn builder() -> crate::model::table_resource::Builder {
        crate::model::table_resource::Builder::default()
    }
}

/// <p>A wildcard object representing every table under a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableWildcard {}
impl std::fmt::Debug for TableWildcard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableWildcard");
        formatter.finish()
    }
}
/// See [`TableWildcard`](crate::model::TableWildcard)
pub mod table_wildcard {
    /// A builder for [`TableWildcard`](crate::model::TableWildcard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TableWildcard`](crate::model::TableWildcard)
        pub fn build(self) -> crate::model::TableWildcard {
            crate::model::TableWildcard {}
        }
    }
}
impl TableWildcard {
    /// Creates a new builder-style object to manufacture [`TableWildcard`](crate::model::TableWildcard)
    pub fn builder() -> crate::model::table_wildcard::Builder {
        crate::model::table_wildcard::Builder::default()
    }
}

/// <p>A structure that allows an admin to grant user permissions on certain conditions. For example, granting a role access to all columns that do not have the LF-tag 'PII' in tables that have the LF-tag 'Prod'.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LfTag {
    /// <p>The key-name for the LF-tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>A list of possible values an attribute can take.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LfTag {
    /// <p>The key-name for the LF-tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>A list of possible values an attribute can take.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for LfTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LfTag");
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`LfTag`](crate::model::LfTag)
pub mod lf_tag {
    /// A builder for [`LfTag`](crate::model::LfTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`LfTag`](crate::model::LfTag)
        pub fn build(self) -> crate::model::LfTag {
            crate::model::LfTag {
                tag_key: self.tag_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl LfTag {
    /// Creates a new builder-style object to manufacture [`LfTag`](crate::model::LfTag)
    pub fn builder() -> crate::model::lf_tag::Builder {
        crate::model::lf_tag::Builder::default()
    }
}

/// <p>A structure describing a database resource with LF-tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaggedDatabase {
    /// <p>A database that has LF-tags attached to it.</p>
    pub database: std::option::Option<crate::model::DatabaseResource>,
    /// <p>A list of LF-tags attached to the database.</p>
    pub lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
}
impl TaggedDatabase {
    /// <p>A database that has LF-tags attached to it.</p>
    pub fn database(&self) -> std::option::Option<&crate::model::DatabaseResource> {
        self.database.as_ref()
    }
    /// <p>A list of LF-tags attached to the database.</p>
    pub fn lf_tags(&self) -> std::option::Option<&[crate::model::LfTagPair]> {
        self.lf_tags.as_deref()
    }
}
impl std::fmt::Debug for TaggedDatabase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaggedDatabase");
        formatter.field("database", &self.database);
        formatter.field("lf_tags", &self.lf_tags);
        formatter.finish()
    }
}
/// See [`TaggedDatabase`](crate::model::TaggedDatabase)
pub mod tagged_database {
    /// A builder for [`TaggedDatabase`](crate::model::TaggedDatabase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database: std::option::Option<crate::model::DatabaseResource>,
        pub(crate) lf_tags: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
    }
    impl Builder {
        /// <p>A database that has LF-tags attached to it.</p>
        pub fn database(mut self, input: crate::model::DatabaseResource) -> Self {
            self.database = Some(input);
            self
        }
        /// <p>A database that has LF-tags attached to it.</p>
        pub fn set_database(
            mut self,
            input: std::option::Option<crate::model::DatabaseResource>,
        ) -> Self {
            self.database = input;
            self
        }
        /// Appends an item to `lf_tags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>A list of LF-tags attached to the database.</p>
        pub fn lf_tags(mut self, input: impl Into<crate::model::LfTagPair>) -> Self {
            let mut v = self.lf_tags.unwrap_or_default();
            v.push(input.into());
            self.lf_tags = Some(v);
            self
        }
        /// <p>A list of LF-tags attached to the database.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.lf_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TaggedDatabase`](crate::model::TaggedDatabase)
        pub fn build(self) -> crate::model::TaggedDatabase {
            crate::model::TaggedDatabase {
                database: self.database,
                lf_tags: self.lf_tags,
            }
        }
    }
}
impl TaggedDatabase {
    /// Creates a new builder-style object to manufacture [`TaggedDatabase`](crate::model::TaggedDatabase)
    pub fn builder() -> crate::model::tagged_database::Builder {
        crate::model::tagged_database::Builder::default()
    }
}

/// <p>A structure for the database object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the database resource. Unique to the Data Catalog.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DatabaseResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The name of the database resource. Unique to the Data Catalog.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DatabaseResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DatabaseResource`](crate::model::DatabaseResource)
pub mod database_resource {
    /// A builder for [`DatabaseResource`](crate::model::DatabaseResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the database resource. Unique to the Data Catalog.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the database resource. Unique to the Data Catalog.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseResource`](crate::model::DatabaseResource)
        pub fn build(self) -> crate::model::DatabaseResource {
            crate::model::DatabaseResource {
                catalog_id: self.catalog_id,
                name: self.name,
            }
        }
    }
}
impl DatabaseResource {
    /// Creates a new builder-style object to manufacture [`DatabaseResource`](crate::model::DatabaseResource)
    pub fn builder() -> crate::model::database_resource::Builder {
        crate::model::database_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Alter,
    #[allow(missing_docs)] // documentation missing in model
    AlterTag,
    #[allow(missing_docs)] // documentation missing in model
    AssociateTag,
    #[allow(missing_docs)] // documentation missing in model
    CreateDatabase,
    #[allow(missing_docs)] // documentation missing in model
    CreateTable,
    #[allow(missing_docs)] // documentation missing in model
    CreateTag,
    #[allow(missing_docs)] // documentation missing in model
    DataLocationAccess,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteTag,
    #[allow(missing_docs)] // documentation missing in model
    Describe,
    #[allow(missing_docs)] // documentation missing in model
    DescribeTag,
    #[allow(missing_docs)] // documentation missing in model
    Drop,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    #[allow(missing_docs)] // documentation missing in model
    Select,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Permission::All,
            "ALTER" => Permission::Alter,
            "ALTER_TAG" => Permission::AlterTag,
            "ASSOCIATE_TAG" => Permission::AssociateTag,
            "CREATE_DATABASE" => Permission::CreateDatabase,
            "CREATE_TABLE" => Permission::CreateTable,
            "CREATE_TAG" => Permission::CreateTag,
            "DATA_LOCATION_ACCESS" => Permission::DataLocationAccess,
            "DELETE" => Permission::Delete,
            "DELETE_TAG" => Permission::DeleteTag,
            "DESCRIBE" => Permission::Describe,
            "DESCRIBE_TAG" => Permission::DescribeTag,
            "DROP" => Permission::Drop,
            "INSERT" => Permission::Insert,
            "SELECT" => Permission::Select,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::All => "ALL",
            Permission::Alter => "ALTER",
            Permission::AlterTag => "ALTER_TAG",
            Permission::AssociateTag => "ASSOCIATE_TAG",
            Permission::CreateDatabase => "CREATE_DATABASE",
            Permission::CreateTable => "CREATE_TABLE",
            Permission::CreateTag => "CREATE_TAG",
            Permission::DataLocationAccess => "DATA_LOCATION_ACCESS",
            Permission::Delete => "DELETE",
            Permission::DeleteTag => "DELETE_TAG",
            Permission::Describe => "DESCRIBE",
            Permission::DescribeTag => "DESCRIBE_TAG",
            Permission::Drop => "DROP",
            Permission::Insert => "INSERT",
            Permission::Select => "SELECT",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "ALTER",
            "ALTER_TAG",
            "ASSOCIATE_TAG",
            "CREATE_DATABASE",
            "CREATE_TABLE",
            "CREATE_TAG",
            "DATA_LOCATION_ACCESS",
            "DELETE",
            "DELETE_TAG",
            "DESCRIBE",
            "DESCRIBE_TAG",
            "DROP",
            "INSERT",
            "SELECT",
        ]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure for the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog: std::option::Option<crate::model::CatalogResource>,
    /// <p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>
    pub database: std::option::Option<crate::model::DatabaseResource>,
    /// <p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
    pub table: std::option::Option<crate::model::TableResource>,
    /// <p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>
    pub table_with_columns: std::option::Option<crate::model::TableWithColumnsResource>,
    /// <p>The location of an Amazon S3 path where permissions are granted or revoked. </p>
    pub data_location: std::option::Option<crate::model::DataLocationResource>,
    /// <p>A data cell filter.</p>
    pub data_cells_filter: std::option::Option<crate::model::DataCellsFilterResource>,
    /// <p>The LF-tag key and values attached to a resource.</p>
    pub lf_tag: std::option::Option<crate::model::LfTagKeyResource>,
    /// <p>A list of LF-tag conditions that define a resource's LF-tag policy.</p>
    pub lf_tag_policy: std::option::Option<crate::model::LfTagPolicyResource>,
}
impl Resource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog(&self) -> std::option::Option<&crate::model::CatalogResource> {
        self.catalog.as_ref()
    }
    /// <p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>
    pub fn database(&self) -> std::option::Option<&crate::model::DatabaseResource> {
        self.database.as_ref()
    }
    /// <p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
    pub fn table(&self) -> std::option::Option<&crate::model::TableResource> {
        self.table.as_ref()
    }
    /// <p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>
    pub fn table_with_columns(
        &self,
    ) -> std::option::Option<&crate::model::TableWithColumnsResource> {
        self.table_with_columns.as_ref()
    }
    /// <p>The location of an Amazon S3 path where permissions are granted or revoked. </p>
    pub fn data_location(&self) -> std::option::Option<&crate::model::DataLocationResource> {
        self.data_location.as_ref()
    }
    /// <p>A data cell filter.</p>
    pub fn data_cells_filter(&self) -> std::option::Option<&crate::model::DataCellsFilterResource> {
        self.data_cells_filter.as_ref()
    }
    /// <p>The LF-tag key and values attached to a resource.</p>
    pub fn lf_tag(&self) -> std::option::Option<&crate::model::LfTagKeyResource> {
        self.lf_tag.as_ref()
    }
    /// <p>A list of LF-tag conditions that define a resource's LF-tag policy.</p>
    pub fn lf_tag_policy(&self) -> std::option::Option<&crate::model::LfTagPolicyResource> {
        self.lf_tag_policy.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("catalog", &self.catalog);
        formatter.field("database", &self.database);
        formatter.field("table", &self.table);
        formatter.field("table_with_columns", &self.table_with_columns);
        formatter.field("data_location", &self.data_location);
        formatter.field("data_cells_filter", &self.data_cells_filter);
        formatter.field("lf_tag", &self.lf_tag);
        formatter.field("lf_tag_policy", &self.lf_tag_policy);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<crate::model::CatalogResource>,
        pub(crate) database: std::option::Option<crate::model::DatabaseResource>,
        pub(crate) table: std::option::Option<crate::model::TableResource>,
        pub(crate) table_with_columns: std::option::Option<crate::model::TableWithColumnsResource>,
        pub(crate) data_location: std::option::Option<crate::model::DataLocationResource>,
        pub(crate) data_cells_filter: std::option::Option<crate::model::DataCellsFilterResource>,
        pub(crate) lf_tag: std::option::Option<crate::model::LfTagKeyResource>,
        pub(crate) lf_tag_policy: std::option::Option<crate::model::LfTagPolicyResource>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog(mut self, input: crate::model::CatalogResource) -> Self {
            self.catalog = Some(input);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog(
            mut self,
            input: std::option::Option<crate::model::CatalogResource>,
        ) -> Self {
            self.catalog = input;
            self
        }
        /// <p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>
        pub fn database(mut self, input: crate::model::DatabaseResource) -> Self {
            self.database = Some(input);
            self
        }
        /// <p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>
        pub fn set_database(
            mut self,
            input: std::option::Option<crate::model::DatabaseResource>,
        ) -> Self {
            self.database = input;
            self
        }
        /// <p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
        pub fn table(mut self, input: crate::model::TableResource) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
        pub fn set_table(
            mut self,
            input: std::option::Option<crate::model::TableResource>,
        ) -> Self {
            self.table = input;
            self
        }
        /// <p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>
        pub fn table_with_columns(mut self, input: crate::model::TableWithColumnsResource) -> Self {
            self.table_with_columns = Some(input);
            self
        }
        /// <p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>
        pub fn set_table_with_columns(
            mut self,
            input: std::option::Option<crate::model::TableWithColumnsResource>,
        ) -> Self {
            self.table_with_columns = input;
            self
        }
        /// <p>The location of an Amazon S3 path where permissions are granted or revoked. </p>
        pub fn data_location(mut self, input: crate::model::DataLocationResource) -> Self {
            self.data_location = Some(input);
            self
        }
        /// <p>The location of an Amazon S3 path where permissions are granted or revoked. </p>
        pub fn set_data_location(
            mut self,
            input: std::option::Option<crate::model::DataLocationResource>,
        ) -> Self {
            self.data_location = input;
            self
        }
        /// <p>A data cell filter.</p>
        pub fn data_cells_filter(mut self, input: crate::model::DataCellsFilterResource) -> Self {
            self.data_cells_filter = Some(input);
            self
        }
        /// <p>A data cell filter.</p>
        pub fn set_data_cells_filter(
            mut self,
            input: std::option::Option<crate::model::DataCellsFilterResource>,
        ) -> Self {
            self.data_cells_filter = input;
            self
        }
        /// <p>The LF-tag key and values attached to a resource.</p>
        pub fn lf_tag(mut self, input: crate::model::LfTagKeyResource) -> Self {
            self.lf_tag = Some(input);
            self
        }
        /// <p>The LF-tag key and values attached to a resource.</p>
        pub fn set_lf_tag(
            mut self,
            input: std::option::Option<crate::model::LfTagKeyResource>,
        ) -> Self {
            self.lf_tag = input;
            self
        }
        /// <p>A list of LF-tag conditions that define a resource's LF-tag policy.</p>
        pub fn lf_tag_policy(mut self, input: crate::model::LfTagPolicyResource) -> Self {
            self.lf_tag_policy = Some(input);
            self
        }
        /// <p>A list of LF-tag conditions that define a resource's LF-tag policy.</p>
        pub fn set_lf_tag_policy(
            mut self,
            input: std::option::Option<crate::model::LfTagPolicyResource>,
        ) -> Self {
            self.lf_tag_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                catalog: self.catalog,
                database: self.database,
                table: self.table,
                table_with_columns: self.table_with_columns,
                data_location: self.data_location,
                data_cells_filter: self.data_cells_filter,
                lf_tag: self.lf_tag,
                lf_tag_policy: self.lf_tag_policy,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>A structure containing a list of LF-tag conditions that apply to a resource's LF-tag policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LfTagPolicyResource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The resource type for which the LF-tag policy applies.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>A list of LF-tag conditions that apply to the resource's LF-tag policy.</p>
    pub expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
}
impl LfTagPolicyResource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The resource type for which the LF-tag policy applies.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>A list of LF-tag conditions that apply to the resource's LF-tag policy.</p>
    pub fn expression(&self) -> std::option::Option<&[crate::model::LfTag]> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for LfTagPolicyResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LfTagPolicyResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`LfTagPolicyResource`](crate::model::LfTagPolicyResource)
pub mod lf_tag_policy_resource {
    /// A builder for [`LfTagPolicyResource`](crate::model::LfTagPolicyResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) expression: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The resource type for which the LF-tag policy applies.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type for which the LF-tag policy applies.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of LF-tag conditions that apply to the resource's LF-tag policy.</p>
        pub fn expression(mut self, input: impl Into<crate::model::LfTag>) -> Self {
            let mut v = self.expression.unwrap_or_default();
            v.push(input.into());
            self.expression = Some(v);
            self
        }
        /// <p>A list of LF-tag conditions that apply to the resource's LF-tag policy.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`LfTagPolicyResource`](crate::model::LfTagPolicyResource)
        pub fn build(self) -> crate::model::LfTagPolicyResource {
            crate::model::LfTagPolicyResource {
                catalog_id: self.catalog_id,
                resource_type: self.resource_type,
                expression: self.expression,
            }
        }
    }
}
impl LfTagPolicyResource {
    /// Creates a new builder-style object to manufacture [`LfTagPolicyResource`](crate::model::LfTagPolicyResource)
    pub fn builder() -> crate::model::lf_tag_policy_resource::Builder {
        crate::model::lf_tag_policy_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Database,
    #[allow(missing_docs)] // documentation missing in model
    Table,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "DATABASE" => ResourceType::Database,
            "TABLE" => ResourceType::Table,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Database => "DATABASE",
            ResourceType::Table => "TABLE",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATABASE", "TABLE"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing an LF-tag key and values for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LfTagKeyResource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The key-name for the LF-tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>A list of possible values an attribute can take.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LfTagKeyResource {
    /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The key-name for the LF-tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>A list of possible values an attribute can take.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for LfTagKeyResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LfTagKeyResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`LfTagKeyResource`](crate::model::LfTagKeyResource)
pub mod lf_tag_key_resource {
    /// A builder for [`LfTagKeyResource`](crate::model::LfTagKeyResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key-name for the LF-tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`LfTagKeyResource`](crate::model::LfTagKeyResource)
        pub fn build(self) -> crate::model::LfTagKeyResource {
            crate::model::LfTagKeyResource {
                catalog_id: self.catalog_id,
                tag_key: self.tag_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl LfTagKeyResource {
    /// Creates a new builder-style object to manufacture [`LfTagKeyResource`](crate::model::LfTagKeyResource)
    pub fn builder() -> crate::model::lf_tag_key_resource::Builder {
        crate::model::lf_tag_key_resource::Builder::default()
    }
}

/// <p>A structure for a data cells filter resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCellsFilterResource {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub table_catalog_id: std::option::Option<std::string::String>,
    /// <p>A database in the Glue Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the data cells filter. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DataCellsFilterResource {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub fn table_catalog_id(&self) -> std::option::Option<&str> {
        self.table_catalog_id.as_deref()
    }
    /// <p>A database in the Glue Data Catalog.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the data cells filter. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DataCellsFilterResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCellsFilterResource");
        formatter.field("table_catalog_id", &self.table_catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DataCellsFilterResource`](crate::model::DataCellsFilterResource)
pub mod data_cells_filter_resource {
    /// A builder for [`DataCellsFilterResource`](crate::model::DataCellsFilterResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn table_catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn set_table_catalog_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_catalog_id = input;
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the data cells filter. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data cells filter. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCellsFilterResource`](crate::model::DataCellsFilterResource)
        pub fn build(self) -> crate::model::DataCellsFilterResource {
            crate::model::DataCellsFilterResource {
                table_catalog_id: self.table_catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                name: self.name,
            }
        }
    }
}
impl DataCellsFilterResource {
    /// Creates a new builder-style object to manufacture [`DataCellsFilterResource`](crate::model::DataCellsFilterResource)
    pub fn builder() -> crate::model::data_cells_filter_resource::Builder {
        crate::model::data_cells_filter_resource::Builder::default()
    }
}

/// <p>A structure for a data location object where permissions are granted or revoked. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataLocationResource {
    /// <p>The identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DataLocationResource {
    /// <p>The identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DataLocationResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataLocationResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`DataLocationResource`](crate::model::DataLocationResource)
pub mod data_location_resource {
    /// A builder for [`DataLocationResource`](crate::model::DataLocationResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DataLocationResource`](crate::model::DataLocationResource)
        pub fn build(self) -> crate::model::DataLocationResource {
            crate::model::DataLocationResource {
                catalog_id: self.catalog_id,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl DataLocationResource {
    /// Creates a new builder-style object to manufacture [`DataLocationResource`](crate::model::DataLocationResource)
    pub fn builder() -> crate::model::data_location_resource::Builder {
        crate::model::data_location_resource::Builder::default()
    }
}

/// <p>A structure for a table with columns object. This object is only used when granting a SELECT permission.</p>
/// <p>This object must take a value for at least one of <code>ColumnsNames</code>, <code>ColumnsIndexes</code>, or <code>ColumnsWildcard</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableWithColumnsResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
    pub column_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
    pub column_wildcard: std::option::Option<crate::model::ColumnWildcard>,
}
impl TableWithColumnsResource {
    /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
    pub fn catalog_id(&self) -> std::option::Option<&str> {
        self.catalog_id.as_deref()
    }
    /// <p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
    pub fn column_names(&self) -> std::option::Option<&[std::string::String]> {
        self.column_names.as_deref()
    }
    /// <p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
    pub fn column_wildcard(&self) -> std::option::Option<&crate::model::ColumnWildcard> {
        self.column_wildcard.as_ref()
    }
}
impl std::fmt::Debug for TableWithColumnsResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableWithColumnsResource");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("name", &self.name);
        formatter.field("column_names", &self.column_names);
        formatter.field("column_wildcard", &self.column_wildcard);
        formatter.finish()
    }
}
/// See [`TableWithColumnsResource`](crate::model::TableWithColumnsResource)
pub mod table_with_columns_resource {
    /// A builder for [`TableWithColumnsResource`](crate::model::TableWithColumnsResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) column_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) column_wildcard: std::option::Option<crate::model::ColumnWildcard>,
    }
    impl Builder {
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `column_names`.
        ///
        /// To override the contents of this collection use [`set_column_names`](Self::set_column_names).
        ///
        /// <p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
        pub fn column_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.column_names.unwrap_or_default();
            v.push(input.into());
            self.column_names = Some(v);
            self
        }
        /// <p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
        pub fn set_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.column_names = input;
            self
        }
        /// <p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
        pub fn column_wildcard(mut self, input: crate::model::ColumnWildcard) -> Self {
            self.column_wildcard = Some(input);
            self
        }
        /// <p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>
        pub fn set_column_wildcard(
            mut self,
            input: std::option::Option<crate::model::ColumnWildcard>,
        ) -> Self {
            self.column_wildcard = input;
            self
        }
        /// Consumes the builder and constructs a [`TableWithColumnsResource`](crate::model::TableWithColumnsResource)
        pub fn build(self) -> crate::model::TableWithColumnsResource {
            crate::model::TableWithColumnsResource {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                name: self.name,
                column_names: self.column_names,
                column_wildcard: self.column_wildcard,
            }
        }
    }
}
impl TableWithColumnsResource {
    /// Creates a new builder-style object to manufacture [`TableWithColumnsResource`](crate::model::TableWithColumnsResource)
    pub fn builder() -> crate::model::table_with_columns_resource::Builder {
        crate::model::table_with_columns_resource::Builder::default()
    }
}

/// <p>A wildcard object, consisting of an optional list of excluded column names or indexes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnWildcard {
    /// <p>Excludes column names. Any column with this name will be excluded.</p>
    pub excluded_column_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ColumnWildcard {
    /// <p>Excludes column names. Any column with this name will be excluded.</p>
    pub fn excluded_column_names(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_column_names.as_deref()
    }
}
impl std::fmt::Debug for ColumnWildcard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnWildcard");
        formatter.field("excluded_column_names", &self.excluded_column_names);
        formatter.finish()
    }
}
/// See [`ColumnWildcard`](crate::model::ColumnWildcard)
pub mod column_wildcard {
    /// A builder for [`ColumnWildcard`](crate::model::ColumnWildcard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excluded_column_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `excluded_column_names`.
        ///
        /// To override the contents of this collection use [`set_excluded_column_names`](Self::set_excluded_column_names).
        ///
        /// <p>Excludes column names. Any column with this name will be excluded.</p>
        pub fn excluded_column_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_column_names.unwrap_or_default();
            v.push(input.into());
            self.excluded_column_names = Some(v);
            self
        }
        /// <p>Excludes column names. Any column with this name will be excluded.</p>
        pub fn set_excluded_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_column_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnWildcard`](crate::model::ColumnWildcard)
        pub fn build(self) -> crate::model::ColumnWildcard {
            crate::model::ColumnWildcard {
                excluded_column_names: self.excluded_column_names,
            }
        }
    }
}
impl ColumnWildcard {
    /// Creates a new builder-style object to manufacture [`ColumnWildcard`](crate::model::ColumnWildcard)
    pub fn builder() -> crate::model::column_wildcard::Builder {
        crate::model::column_wildcard::Builder::default()
    }
}

/// <p>A structure for the catalog object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CatalogResource {}
impl std::fmt::Debug for CatalogResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CatalogResource");
        formatter.finish()
    }
}
/// See [`CatalogResource`](crate::model::CatalogResource)
pub mod catalog_resource {
    /// A builder for [`CatalogResource`](crate::model::CatalogResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CatalogResource`](crate::model::CatalogResource)
        pub fn build(self) -> crate::model::CatalogResource {
            crate::model::CatalogResource {}
        }
    }
}
impl CatalogResource {
    /// Creates a new builder-style object to manufacture [`CatalogResource`](crate::model::CatalogResource)
    pub fn builder() -> crate::model::catalog_resource::Builder {
        crate::model::catalog_resource::Builder::default()
    }
}

/// <p>The AWS Lake Formation principal. Supported principals are IAM users or IAM roles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataLakePrincipal {
    /// <p>An identifier for the Lake Formation principal.</p>
    pub data_lake_principal_identifier: std::option::Option<std::string::String>,
}
impl DataLakePrincipal {
    /// <p>An identifier for the Lake Formation principal.</p>
    pub fn data_lake_principal_identifier(&self) -> std::option::Option<&str> {
        self.data_lake_principal_identifier.as_deref()
    }
}
impl std::fmt::Debug for DataLakePrincipal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataLakePrincipal");
        formatter.field(
            "data_lake_principal_identifier",
            &self.data_lake_principal_identifier,
        );
        formatter.finish()
    }
}
/// See [`DataLakePrincipal`](crate::model::DataLakePrincipal)
pub mod data_lake_principal {
    /// A builder for [`DataLakePrincipal`](crate::model::DataLakePrincipal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_lake_principal_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the Lake Formation principal.</p>
        pub fn data_lake_principal_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.data_lake_principal_identifier = Some(input.into());
            self
        }
        /// <p>An identifier for the Lake Formation principal.</p>
        pub fn set_data_lake_principal_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_lake_principal_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DataLakePrincipal`](crate::model::DataLakePrincipal)
        pub fn build(self) -> crate::model::DataLakePrincipal {
            crate::model::DataLakePrincipal {
                data_lake_principal_identifier: self.data_lake_principal_identifier,
            }
        }
    }
}
impl DataLakePrincipal {
    /// Creates a new builder-style object to manufacture [`DataLakePrincipal`](crate::model::DataLakePrincipal)
    pub fn builder() -> crate::model::data_lake_principal::Builder {
        crate::model::data_lake_principal::Builder::default()
    }
}

/// <p>A structure containing an error related to a <code>TagResource</code> or <code>UnTagResource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LfTagError {
    /// <p>The key-name of the LF-tag.</p>
    pub lf_tag: std::option::Option<crate::model::LfTagPair>,
    /// <p>An error that occurred with the attachment or detachment of the LF-tag.</p>
    pub error: std::option::Option<crate::model::ErrorDetail>,
}
impl LfTagError {
    /// <p>The key-name of the LF-tag.</p>
    pub fn lf_tag(&self) -> std::option::Option<&crate::model::LfTagPair> {
        self.lf_tag.as_ref()
    }
    /// <p>An error that occurred with the attachment or detachment of the LF-tag.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetail> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for LfTagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LfTagError");
        formatter.field("lf_tag", &self.lf_tag);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`LfTagError`](crate::model::LfTagError)
pub mod lf_tag_error {
    /// A builder for [`LfTagError`](crate::model::LfTagError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lf_tag: std::option::Option<crate::model::LfTagPair>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetail>,
    }
    impl Builder {
        /// <p>The key-name of the LF-tag.</p>
        pub fn lf_tag(mut self, input: crate::model::LfTagPair) -> Self {
            self.lf_tag = Some(input);
            self
        }
        /// <p>The key-name of the LF-tag.</p>
        pub fn set_lf_tag(mut self, input: std::option::Option<crate::model::LfTagPair>) -> Self {
            self.lf_tag = input;
            self
        }
        /// <p>An error that occurred with the attachment or detachment of the LF-tag.</p>
        pub fn error(mut self, input: crate::model::ErrorDetail) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An error that occurred with the attachment or detachment of the LF-tag.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetail>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`LfTagError`](crate::model::LfTagError)
        pub fn build(self) -> crate::model::LfTagError {
            crate::model::LfTagError {
                lf_tag: self.lf_tag,
                error: self.error,
            }
        }
    }
}
impl LfTagError {
    /// Creates a new builder-style object to manufacture [`LfTagError`](crate::model::LfTagError)
    pub fn builder() -> crate::model::lf_tag_error::Builder {
        crate::model::lf_tag_error::Builder::default()
    }
}

/// <p>Contains details about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetail {
    /// <p>The code associated with this error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>A message describing the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl ErrorDetail {
    /// <p>The code associated with this error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>A message describing the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetail");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ErrorDetail`](crate::model::ErrorDetail)
pub mod error_detail {
    /// A builder for [`ErrorDetail`](crate::model::ErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code associated with this error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The code associated with this error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A message describing the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message describing the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetail`](crate::model::ErrorDetail)
        pub fn build(self) -> crate::model::ErrorDetail {
            crate::model::ErrorDetail {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl ErrorDetail {
    /// Creates a new builder-style object to manufacture [`ErrorDetail`](crate::model::ErrorDetail)
    pub fn builder() -> crate::model::error_detail::Builder {
        crate::model::error_detail::Builder::default()
    }
}

/// <p>A structure representing a list of Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataLakeSettings {
    /// <p>A list of Lake Formation principals. Supported principals are IAM users or IAM roles.</p>
    pub data_lake_admins: std::option::Option<std::vec::Vec<crate::model::DataLakePrincipal>>,
    /// <p>Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. You can override this default setting when you create a database.</p>
    ///
    /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
    ///
    /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
    pub create_database_default_permissions:
        std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
    /// <p>Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.</p>
    ///
    /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
    ///
    /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
    pub create_table_default_permissions:
        std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
    /// <p>A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
    ///
    /// <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>
    pub trusted_resource_owners: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DataLakeSettings {
    /// <p>A list of Lake Formation principals. Supported principals are IAM users or IAM roles.</p>
    pub fn data_lake_admins(&self) -> std::option::Option<&[crate::model::DataLakePrincipal]> {
        self.data_lake_admins.as_deref()
    }
    /// <p>Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. You can override this default setting when you create a database.</p>
    ///
    /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
    ///
    /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
    pub fn create_database_default_permissions(
        &self,
    ) -> std::option::Option<&[crate::model::PrincipalPermissions]> {
        self.create_database_default_permissions.as_deref()
    }
    /// <p>Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.</p>
    ///
    /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
    ///
    /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
    pub fn create_table_default_permissions(
        &self,
    ) -> std::option::Option<&[crate::model::PrincipalPermissions]> {
        self.create_table_default_permissions.as_deref()
    }
    /// <p>A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
    ///
    /// <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>
    pub fn trusted_resource_owners(&self) -> std::option::Option<&[std::string::String]> {
        self.trusted_resource_owners.as_deref()
    }
}
impl std::fmt::Debug for DataLakeSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataLakeSettings");
        formatter.field("data_lake_admins", &self.data_lake_admins);
        formatter.field(
            "create_database_default_permissions",
            &self.create_database_default_permissions,
        );
        formatter.field(
            "create_table_default_permissions",
            &self.create_table_default_permissions,
        );
        formatter.field("trusted_resource_owners", &self.trusted_resource_owners);
        formatter.finish()
    }
}
/// See [`DataLakeSettings`](crate::model::DataLakeSettings)
pub mod data_lake_settings {
    /// A builder for [`DataLakeSettings`](crate::model::DataLakeSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_lake_admins:
            std::option::Option<std::vec::Vec<crate::model::DataLakePrincipal>>,
        pub(crate) create_database_default_permissions:
            std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        pub(crate) create_table_default_permissions:
            std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        pub(crate) trusted_resource_owners: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `data_lake_admins`.
        ///
        /// To override the contents of this collection use [`set_data_lake_admins`](Self::set_data_lake_admins).
        ///
        /// <p>A list of Lake Formation principals. Supported principals are IAM users or IAM roles.</p>
        pub fn data_lake_admins(
            mut self,
            input: impl Into<crate::model::DataLakePrincipal>,
        ) -> Self {
            let mut v = self.data_lake_admins.unwrap_or_default();
            v.push(input.into());
            self.data_lake_admins = Some(v);
            self
        }
        /// <p>A list of Lake Formation principals. Supported principals are IAM users or IAM roles.</p>
        pub fn set_data_lake_admins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataLakePrincipal>>,
        ) -> Self {
            self.data_lake_admins = input;
            self
        }
        /// Appends an item to `create_database_default_permissions`.
        ///
        /// To override the contents of this collection use [`set_create_database_default_permissions`](Self::set_create_database_default_permissions).
        ///
        /// <p>Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. You can override this default setting when you create a database.</p>
        ///
        /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
        ///
        /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
        pub fn create_database_default_permissions(
            mut self,
            input: impl Into<crate::model::PrincipalPermissions>,
        ) -> Self {
            let mut v = self.create_database_default_permissions.unwrap_or_default();
            v.push(input.into());
            self.create_database_default_permissions = Some(v);
            self
        }
        /// <p>Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. You can override this default setting when you create a database.</p>
        ///
        /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
        ///
        /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
        pub fn set_create_database_default_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        ) -> Self {
            self.create_database_default_permissions = input;
            self
        }
        /// Appends an item to `create_table_default_permissions`.
        ///
        /// To override the contents of this collection use [`set_create_table_default_permissions`](Self::set_create_table_default_permissions).
        ///
        /// <p>Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.</p>
        ///
        /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
        ///
        /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
        pub fn create_table_default_permissions(
            mut self,
            input: impl Into<crate::model::PrincipalPermissions>,
        ) -> Self {
            let mut v = self.create_table_default_permissions.unwrap_or_default();
            v.push(input.into());
            self.create_table_default_permissions = Some(v);
            self
        }
        /// <p>Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.</p>
        ///
        /// <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p>
        ///
        /// <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>
        pub fn set_create_table_default_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        ) -> Self {
            self.create_table_default_permissions = input;
            self
        }
        /// Appends an item to `trusted_resource_owners`.
        ///
        /// To override the contents of this collection use [`set_trusted_resource_owners`](Self::set_trusted_resource_owners).
        ///
        /// <p>A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
        ///
        /// <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>
        pub fn trusted_resource_owners(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trusted_resource_owners.unwrap_or_default();
            v.push(input.into());
            self.trusted_resource_owners = Some(v);
            self
        }
        /// <p>A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
        ///
        /// <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>
        pub fn set_trusted_resource_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trusted_resource_owners = input;
            self
        }
        /// Consumes the builder and constructs a [`DataLakeSettings`](crate::model::DataLakeSettings)
        pub fn build(self) -> crate::model::DataLakeSettings {
            crate::model::DataLakeSettings {
                data_lake_admins: self.data_lake_admins,
                create_database_default_permissions: self.create_database_default_permissions,
                create_table_default_permissions: self.create_table_default_permissions,
                trusted_resource_owners: self.trusted_resource_owners,
            }
        }
    }
}
impl DataLakeSettings {
    /// Creates a new builder-style object to manufacture [`DataLakeSettings`](crate::model::DataLakeSettings)
    pub fn builder() -> crate::model::data_lake_settings::Builder {
        crate::model::data_lake_settings::Builder::default()
    }
}

/// <p>Permissions granted to a principal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrincipalPermissions {
    /// <p>The principal who is granted permissions.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The permissions that are granted to the principal.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl PrincipalPermissions {
    /// <p>The principal who is granted permissions.</p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>The permissions that are granted to the principal.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
}
impl std::fmt::Debug for PrincipalPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrincipalPermissions");
        formatter.field("principal", &self.principal);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`PrincipalPermissions`](crate::model::PrincipalPermissions)
pub mod principal_permissions {
    /// A builder for [`PrincipalPermissions`](crate::model::PrincipalPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p>The principal who is granted permissions.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The principal who is granted permissions.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions that are granted to the principal.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions that are granted to the principal.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`PrincipalPermissions`](crate::model::PrincipalPermissions)
        pub fn build(self) -> crate::model::PrincipalPermissions {
            crate::model::PrincipalPermissions {
                principal: self.principal,
                permissions: self.permissions,
            }
        }
    }
}
impl PrincipalPermissions {
    /// Creates a new builder-style object to manufacture [`PrincipalPermissions`](crate::model::PrincipalPermissions)
    pub fn builder() -> crate::model::principal_permissions::Builder {
        crate::model::principal_permissions::Builder::default()
    }
}

/// <p>A structure that contains information about a transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactionDescription {
    /// <p>The ID of the transaction.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>A status of ACTIVE, COMMITTED, or ABORTED.</p>
    pub transaction_status: std::option::Option<crate::model::TransactionStatus>,
    /// <p>The time when the transaction started.</p>
    pub transaction_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the transaction committed or aborted, if it is not currently active.</p>
    pub transaction_end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TransactionDescription {
    /// <p>The ID of the transaction.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>A status of ACTIVE, COMMITTED, or ABORTED.</p>
    pub fn transaction_status(&self) -> std::option::Option<&crate::model::TransactionStatus> {
        self.transaction_status.as_ref()
    }
    /// <p>The time when the transaction started.</p>
    pub fn transaction_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.transaction_start_time.as_ref()
    }
    /// <p>The time when the transaction committed or aborted, if it is not currently active.</p>
    pub fn transaction_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.transaction_end_time.as_ref()
    }
}
impl std::fmt::Debug for TransactionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactionDescription");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("transaction_status", &self.transaction_status);
        formatter.field("transaction_start_time", &self.transaction_start_time);
        formatter.field("transaction_end_time", &self.transaction_end_time);
        formatter.finish()
    }
}
/// See [`TransactionDescription`](crate::model::TransactionDescription)
pub mod transaction_description {
    /// A builder for [`TransactionDescription`](crate::model::TransactionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) transaction_status: std::option::Option<crate::model::TransactionStatus>,
        pub(crate) transaction_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transaction_end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the transaction.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The ID of the transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>A status of ACTIVE, COMMITTED, or ABORTED.</p>
        pub fn transaction_status(mut self, input: crate::model::TransactionStatus) -> Self {
            self.transaction_status = Some(input);
            self
        }
        /// <p>A status of ACTIVE, COMMITTED, or ABORTED.</p>
        pub fn set_transaction_status(
            mut self,
            input: std::option::Option<crate::model::TransactionStatus>,
        ) -> Self {
            self.transaction_status = input;
            self
        }
        /// <p>The time when the transaction started.</p>
        pub fn transaction_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.transaction_start_time = Some(input);
            self
        }
        /// <p>The time when the transaction started.</p>
        pub fn set_transaction_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.transaction_start_time = input;
            self
        }
        /// <p>The time when the transaction committed or aborted, if it is not currently active.</p>
        pub fn transaction_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.transaction_end_time = Some(input);
            self
        }
        /// <p>The time when the transaction committed or aborted, if it is not currently active.</p>
        pub fn set_transaction_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.transaction_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactionDescription`](crate::model::TransactionDescription)
        pub fn build(self) -> crate::model::TransactionDescription {
            crate::model::TransactionDescription {
                transaction_id: self.transaction_id,
                transaction_status: self.transaction_status,
                transaction_start_time: self.transaction_start_time,
                transaction_end_time: self.transaction_end_time,
            }
        }
    }
}
impl TransactionDescription {
    /// Creates a new builder-style object to manufacture [`TransactionDescription`](crate::model::TransactionDescription)
    pub fn builder() -> crate::model::transaction_description::Builder {
        crate::model::transaction_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransactionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Committed,
    #[allow(missing_docs)] // documentation missing in model
    CommitInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransactionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => TransactionStatus::Aborted,
            "ACTIVE" => TransactionStatus::Active,
            "COMMITTED" => TransactionStatus::Committed,
            "COMMIT_IN_PROGRESS" => TransactionStatus::CommitInProgress,
            other => TransactionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransactionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransactionStatus::from(s))
    }
}
impl TransactionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransactionStatus::Aborted => "ABORTED",
            TransactionStatus::Active => "ACTIVE",
            TransactionStatus::Committed => "COMMITTED",
            TransactionStatus::CommitInProgress => "COMMIT_IN_PROGRESS",
            TransactionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORTED", "ACTIVE", "COMMITTED", "COMMIT_IN_PROGRESS"]
    }
}
impl AsRef<str> for TransactionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransactionStatusFilter {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Committed,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransactionStatusFilter {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => TransactionStatusFilter::Aborted,
            "ACTIVE" => TransactionStatusFilter::Active,
            "ALL" => TransactionStatusFilter::All,
            "COMMITTED" => TransactionStatusFilter::Committed,
            "COMPLETED" => TransactionStatusFilter::Completed,
            other => TransactionStatusFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransactionStatusFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransactionStatusFilter::from(s))
    }
}
impl TransactionStatusFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransactionStatusFilter::Aborted => "ABORTED",
            TransactionStatusFilter::Active => "ACTIVE",
            TransactionStatusFilter::All => "ALL",
            TransactionStatusFilter::Committed => "COMMITTED",
            TransactionStatusFilter::Completed => "COMPLETED",
            TransactionStatusFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORTED", "ACTIVE", "ALL", "COMMITTED", "COMPLETED"]
    }
}
impl AsRef<str> for TransactionStatusFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure describing the configuration and details of a storage optimizer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageOptimizer {
    /// <p>The specific type of storage optimizer. The supported value is <code>compaction</code>.</p>
    pub storage_optimizer_type: std::option::Option<crate::model::OptimizerType>,
    /// <p>A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code> indicates true or false for acceleration.</p>
    pub config:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A message that contains information about any error (if present).</p>
    ///
    /// <p>When an acceleration result has an enabled status, the error message is empty.</p>
    /// <p>When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>A message that contains information about any warnings (if present).</p>
    pub warnings: std::option::Option<std::string::String>,
    /// <p>When an acceleration result has an enabled status, contains the details of the last job run.</p>
    pub last_run_details: std::option::Option<std::string::String>,
}
impl StorageOptimizer {
    /// <p>The specific type of storage optimizer. The supported value is <code>compaction</code>.</p>
    pub fn storage_optimizer_type(&self) -> std::option::Option<&crate::model::OptimizerType> {
        self.storage_optimizer_type.as_ref()
    }
    /// <p>A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code> indicates true or false for acceleration.</p>
    pub fn config(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.config.as_ref()
    }
    /// <p>A message that contains information about any error (if present).</p>
    ///
    /// <p>When an acceleration result has an enabled status, the error message is empty.</p>
    /// <p>When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>A message that contains information about any warnings (if present).</p>
    pub fn warnings(&self) -> std::option::Option<&str> {
        self.warnings.as_deref()
    }
    /// <p>When an acceleration result has an enabled status, contains the details of the last job run.</p>
    pub fn last_run_details(&self) -> std::option::Option<&str> {
        self.last_run_details.as_deref()
    }
}
impl std::fmt::Debug for StorageOptimizer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageOptimizer");
        formatter.field("storage_optimizer_type", &self.storage_optimizer_type);
        formatter.field("config", &self.config);
        formatter.field("error_message", &self.error_message);
        formatter.field("warnings", &self.warnings);
        formatter.field("last_run_details", &self.last_run_details);
        formatter.finish()
    }
}
/// See [`StorageOptimizer`](crate::model::StorageOptimizer)
pub mod storage_optimizer {
    /// A builder for [`StorageOptimizer`](crate::model::StorageOptimizer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_optimizer_type: std::option::Option<crate::model::OptimizerType>,
        pub(crate) config: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::string::String>,
        pub(crate) last_run_details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specific type of storage optimizer. The supported value is <code>compaction</code>.</p>
        pub fn storage_optimizer_type(mut self, input: crate::model::OptimizerType) -> Self {
            self.storage_optimizer_type = Some(input);
            self
        }
        /// <p>The specific type of storage optimizer. The supported value is <code>compaction</code>.</p>
        pub fn set_storage_optimizer_type(
            mut self,
            input: std::option::Option<crate::model::OptimizerType>,
        ) -> Self {
            self.storage_optimizer_type = input;
            self
        }
        /// Adds a key-value pair to `config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code> indicates true or false for acceleration.</p>
        pub fn config(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.config.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.config = Some(hash_map);
            self
        }
        /// <p>A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code> indicates true or false for acceleration.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.config = input;
            self
        }
        /// <p>A message that contains information about any error (if present).</p>
        ///
        /// <p>When an acceleration result has an enabled status, the error message is empty.</p>
        /// <p>When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that contains information about any error (if present).</p>
        ///
        /// <p>When an acceleration result has an enabled status, the error message is empty.</p>
        /// <p>When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>A message that contains information about any warnings (if present).</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            self.warnings = Some(input.into());
            self
        }
        /// <p>A message that contains information about any warnings (if present).</p>
        pub fn set_warnings(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warnings = input;
            self
        }
        /// <p>When an acceleration result has an enabled status, contains the details of the last job run.</p>
        pub fn last_run_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_run_details = Some(input.into());
            self
        }
        /// <p>When an acceleration result has an enabled status, contains the details of the last job run.</p>
        pub fn set_last_run_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_run_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageOptimizer`](crate::model::StorageOptimizer)
        pub fn build(self) -> crate::model::StorageOptimizer {
            crate::model::StorageOptimizer {
                storage_optimizer_type: self.storage_optimizer_type,
                config: self.config,
                error_message: self.error_message,
                warnings: self.warnings,
                last_run_details: self.last_run_details,
            }
        }
    }
}
impl StorageOptimizer {
    /// Creates a new builder-style object to manufacture [`StorageOptimizer`](crate::model::StorageOptimizer)
    pub fn builder() -> crate::model::storage_optimizer::Builder {
        crate::model::storage_optimizer::Builder::default()
    }
}

/// <p>A structure containing information about an Lake Formation resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInfo {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The IAM role that registered a resource.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The date and time the resource was last modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl ResourceInfo {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The IAM role that registered a resource.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The date and time the resource was last modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
}
impl std::fmt::Debug for ResourceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInfo");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`ResourceInfo`](crate::model::ResourceInfo)
pub mod resource_info {
    /// A builder for [`ResourceInfo`](crate::model::ResourceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The IAM role that registered a resource.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that registered a resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The date and time the resource was last modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time the resource was last modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInfo`](crate::model::ResourceInfo)
        pub fn build(self) -> crate::model::ResourceInfo {
            crate::model::ResourceInfo {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
                last_modified: self.last_modified,
            }
        }
    }
}
impl ResourceInfo {
    /// Creates a new builder-style object to manufacture [`ResourceInfo`](crate::model::ResourceInfo)
    pub fn builder() -> crate::model::resource_info::Builder {
        crate::model::resource_info::Builder::default()
    }
}

/// <p>This structure describes the filtering of columns in a table based on a filter condition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterCondition {
    /// <p>The field to filter in the filter condition.</p>
    pub field: std::option::Option<crate::model::FieldNameString>,
    /// <p>The comparison operator used in the filter condition.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>A string with values used in evaluating the filter condition.</p>
    pub string_value_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FilterCondition {
    /// <p>The field to filter in the filter condition.</p>
    pub fn field(&self) -> std::option::Option<&crate::model::FieldNameString> {
        self.field.as_ref()
    }
    /// <p>The comparison operator used in the filter condition.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>A string with values used in evaluating the filter condition.</p>
    pub fn string_value_list(&self) -> std::option::Option<&[std::string::String]> {
        self.string_value_list.as_deref()
    }
}
impl std::fmt::Debug for FilterCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterCondition");
        formatter.field("field", &self.field);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("string_value_list", &self.string_value_list);
        formatter.finish()
    }
}
/// See [`FilterCondition`](crate::model::FilterCondition)
pub mod filter_condition {
    /// A builder for [`FilterCondition`](crate::model::FilterCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<crate::model::FieldNameString>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) string_value_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The field to filter in the filter condition.</p>
        pub fn field(mut self, input: crate::model::FieldNameString) -> Self {
            self.field = Some(input);
            self
        }
        /// <p>The field to filter in the filter condition.</p>
        pub fn set_field(
            mut self,
            input: std::option::Option<crate::model::FieldNameString>,
        ) -> Self {
            self.field = input;
            self
        }
        /// <p>The comparison operator used in the filter condition.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The comparison operator used in the filter condition.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// Appends an item to `string_value_list`.
        ///
        /// To override the contents of this collection use [`set_string_value_list`](Self::set_string_value_list).
        ///
        /// <p>A string with values used in evaluating the filter condition.</p>
        pub fn string_value_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_value_list.unwrap_or_default();
            v.push(input.into());
            self.string_value_list = Some(v);
            self
        }
        /// <p>A string with values used in evaluating the filter condition.</p>
        pub fn set_string_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterCondition`](crate::model::FilterCondition)
        pub fn build(self) -> crate::model::FilterCondition {
            crate::model::FilterCondition {
                field: self.field,
                comparison_operator: self.comparison_operator,
                string_value_list: self.string_value_list,
            }
        }
    }
}
impl FilterCondition {
    /// Creates a new builder-style object to manufacture [`FilterCondition`](crate::model::FilterCondition)
    pub fn builder() -> crate::model::filter_condition::Builder {
        crate::model::filter_condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    BeginsWith,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Le,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    NotContains,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "BEGINS_WITH" => ComparisonOperator::BeginsWith,
            "BETWEEN" => ComparisonOperator::Between,
            "CONTAINS" => ComparisonOperator::Contains,
            "EQ" => ComparisonOperator::Eq,
            "GE" => ComparisonOperator::Ge,
            "GT" => ComparisonOperator::Gt,
            "IN" => ComparisonOperator::In,
            "LE" => ComparisonOperator::Le,
            "LT" => ComparisonOperator::Lt,
            "NE" => ComparisonOperator::Ne,
            "NOT_CONTAINS" => ComparisonOperator::NotContains,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::BeginsWith => "BEGINS_WITH",
            ComparisonOperator::Between => "BETWEEN",
            ComparisonOperator::Contains => "CONTAINS",
            ComparisonOperator::Eq => "EQ",
            ComparisonOperator::Ge => "GE",
            ComparisonOperator::Gt => "GT",
            ComparisonOperator::In => "IN",
            ComparisonOperator::Le => "LE",
            ComparisonOperator::Lt => "LT",
            ComparisonOperator::Ne => "NE",
            ComparisonOperator::NotContains => "NOT_CONTAINS",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BEGINS_WITH",
            "BETWEEN",
            "CONTAINS",
            "EQ",
            "GE",
            "GT",
            "IN",
            "LE",
            "LT",
            "NE",
            "NOT_CONTAINS",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FieldNameString {
    #[allow(missing_docs)] // documentation missing in model
    LastModified,
    #[allow(missing_docs)] // documentation missing in model
    ResourceArn,
    #[allow(missing_docs)] // documentation missing in model
    RoleArn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FieldNameString {
    fn from(s: &str) -> Self {
        match s {
            "LAST_MODIFIED" => FieldNameString::LastModified,
            "RESOURCE_ARN" => FieldNameString::ResourceArn,
            "ROLE_ARN" => FieldNameString::RoleArn,
            other => FieldNameString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FieldNameString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FieldNameString::from(s))
    }
}
impl FieldNameString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FieldNameString::LastModified => "LAST_MODIFIED",
            FieldNameString::ResourceArn => "RESOURCE_ARN",
            FieldNameString::RoleArn => "ROLE_ARN",
            FieldNameString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAST_MODIFIED", "RESOURCE_ARN", "ROLE_ARN"]
    }
}
impl AsRef<str> for FieldNameString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The permissions granted or revoked on a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrincipalResourcePermissions {
    /// <p>The Data Lake principal to be granted or revoked permissions.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The resource where permissions are to be granted or revoked.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The permissions to be granted or revoked on the resource.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>
    pub permissions_with_grant_option: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>
    pub additional_details: std::option::Option<crate::model::DetailsMap>,
}
impl PrincipalResourcePermissions {
    /// <p>The Data Lake principal to be granted or revoked permissions.</p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>The resource where permissions are to be granted or revoked.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The permissions to be granted or revoked on the resource.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>
    pub fn permissions_with_grant_option(
        &self,
    ) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions_with_grant_option.as_deref()
    }
    /// <p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>
    pub fn additional_details(&self) -> std::option::Option<&crate::model::DetailsMap> {
        self.additional_details.as_ref()
    }
}
impl std::fmt::Debug for PrincipalResourcePermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrincipalResourcePermissions");
        formatter.field("principal", &self.principal);
        formatter.field("resource", &self.resource);
        formatter.field("permissions", &self.permissions);
        formatter.field(
            "permissions_with_grant_option",
            &self.permissions_with_grant_option,
        );
        formatter.field("additional_details", &self.additional_details);
        formatter.finish()
    }
}
/// See [`PrincipalResourcePermissions`](crate::model::PrincipalResourcePermissions)
pub mod principal_resource_permissions {
    /// A builder for [`PrincipalResourcePermissions`](crate::model::PrincipalResourcePermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) permissions_with_grant_option:
            std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) additional_details: std::option::Option<crate::model::DetailsMap>,
    }
    impl Builder {
        /// <p>The Data Lake principal to be granted or revoked permissions.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The Data Lake principal to be granted or revoked permissions.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// <p>The resource where permissions are to be granted or revoked.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource where permissions are to be granted or revoked.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions to be granted or revoked on the resource.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions to be granted or revoked on the resource.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `permissions_with_grant_option`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>
        pub fn permissions_with_grant_option(
            mut self,
            input: impl Into<crate::model::Permission>,
        ) -> Self {
            let mut v = self.permissions_with_grant_option.unwrap_or_default();
            v.push(input.into());
            self.permissions_with_grant_option = Some(v);
            self
        }
        /// <p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions_with_grant_option = input;
            self
        }
        /// <p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>
        pub fn additional_details(mut self, input: crate::model::DetailsMap) -> Self {
            self.additional_details = Some(input);
            self
        }
        /// <p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>
        pub fn set_additional_details(
            mut self,
            input: std::option::Option<crate::model::DetailsMap>,
        ) -> Self {
            self.additional_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PrincipalResourcePermissions`](crate::model::PrincipalResourcePermissions)
        pub fn build(self) -> crate::model::PrincipalResourcePermissions {
            crate::model::PrincipalResourcePermissions {
                principal: self.principal,
                resource: self.resource,
                permissions: self.permissions,
                permissions_with_grant_option: self.permissions_with_grant_option,
                additional_details: self.additional_details,
            }
        }
    }
}
impl PrincipalResourcePermissions {
    /// Creates a new builder-style object to manufacture [`PrincipalResourcePermissions`](crate::model::PrincipalResourcePermissions)
    pub fn builder() -> crate::model::principal_resource_permissions::Builder {
        crate::model::principal_resource_permissions::Builder::default()
    }
}

/// <p>A structure containing the additional details to be returned in the <code>AdditionalDetails</code> attribute of <code>PrincipalResourcePermissions</code>.</p>
///
/// <p>If a catalog resource is shared through Resource Access Manager (RAM), then there will exist a corresponding RAM resource share ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetailsMap {
    /// <p>A resource share ARN for a catalog resource shared through RAM.</p>
    pub resource_share: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DetailsMap {
    /// <p>A resource share ARN for a catalog resource shared through RAM.</p>
    pub fn resource_share(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share.as_deref()
    }
}
impl std::fmt::Debug for DetailsMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetailsMap");
        formatter.field("resource_share", &self.resource_share);
        formatter.finish()
    }
}
/// See [`DetailsMap`](crate::model::DetailsMap)
pub mod details_map {
    /// A builder for [`DetailsMap`](crate::model::DetailsMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_share`.
        ///
        /// To override the contents of this collection use [`set_resource_share`](Self::set_resource_share).
        ///
        /// <p>A resource share ARN for a catalog resource shared through RAM.</p>
        pub fn resource_share(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share.unwrap_or_default();
            v.push(input.into());
            self.resource_share = Some(v);
            self
        }
        /// <p>A resource share ARN for a catalog resource shared through RAM.</p>
        pub fn set_resource_share(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share = input;
            self
        }
        /// Consumes the builder and constructs a [`DetailsMap`](crate::model::DetailsMap)
        pub fn build(self) -> crate::model::DetailsMap {
            crate::model::DetailsMap {
                resource_share: self.resource_share,
            }
        }
    }
}
impl DetailsMap {
    /// Creates a new builder-style object to manufacture [`DetailsMap`](crate::model::DetailsMap)
    pub fn builder() -> crate::model::details_map::Builder {
        crate::model::details_map::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataLakeResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Catalog,
    #[allow(missing_docs)] // documentation missing in model
    Database,
    #[allow(missing_docs)] // documentation missing in model
    DataLocation,
    #[allow(missing_docs)] // documentation missing in model
    LfTag,
    #[allow(missing_docs)] // documentation missing in model
    LfTagPolicy,
    #[allow(missing_docs)] // documentation missing in model
    LfTagPolicyDatabase,
    #[allow(missing_docs)] // documentation missing in model
    LfTagPolicyTable,
    #[allow(missing_docs)] // documentation missing in model
    Table,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataLakeResourceType {
    fn from(s: &str) -> Self {
        match s {
            "CATALOG" => DataLakeResourceType::Catalog,
            "DATABASE" => DataLakeResourceType::Database,
            "DATA_LOCATION" => DataLakeResourceType::DataLocation,
            "LF_TAG" => DataLakeResourceType::LfTag,
            "LF_TAG_POLICY" => DataLakeResourceType::LfTagPolicy,
            "LF_TAG_POLICY_DATABASE" => DataLakeResourceType::LfTagPolicyDatabase,
            "LF_TAG_POLICY_TABLE" => DataLakeResourceType::LfTagPolicyTable,
            "TABLE" => DataLakeResourceType::Table,
            other => DataLakeResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataLakeResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataLakeResourceType::from(s))
    }
}
impl DataLakeResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataLakeResourceType::Catalog => "CATALOG",
            DataLakeResourceType::Database => "DATABASE",
            DataLakeResourceType::DataLocation => "DATA_LOCATION",
            DataLakeResourceType::LfTag => "LF_TAG",
            DataLakeResourceType::LfTagPolicy => "LF_TAG_POLICY",
            DataLakeResourceType::LfTagPolicyDatabase => "LF_TAG_POLICY_DATABASE",
            DataLakeResourceType::LfTagPolicyTable => "LF_TAG_POLICY_TABLE",
            DataLakeResourceType::Table => "TABLE",
            DataLakeResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CATALOG",
            "DATABASE",
            "DATA_LOCATION",
            "LF_TAG",
            "LF_TAG_POLICY",
            "LF_TAG_POLICY_DATABASE",
            "LF_TAG_POLICY_TABLE",
            "TABLE",
        ]
    }
}
impl AsRef<str> for DataLakeResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Foreign,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ResourceShareType::All,
            "FOREIGN" => ResourceShareType::Foreign,
            other => ResourceShareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareType::from(s))
    }
}
impl ResourceShareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareType::All => "ALL",
            ResourceShareType::Foreign => "FOREIGN",
            ResourceShareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FOREIGN"]
    }
}
impl AsRef<str> for ResourceShareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that describes certain columns on certain rows.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCellsFilter {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub table_catalog_id: std::option::Option<std::string::String>,
    /// <p>A database in the Glue Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A table in the database.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name given by the user to the data filter cell.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A PartiQL predicate.</p>
    pub row_filter: std::option::Option<crate::model::RowFilter>,
    /// <p>A list of column names.</p>
    pub column_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A wildcard with exclusions.</p>
    pub column_wildcard: std::option::Option<crate::model::ColumnWildcard>,
}
impl DataCellsFilter {
    /// <p>The ID of the catalog to which the table belongs.</p>
    pub fn table_catalog_id(&self) -> std::option::Option<&str> {
        self.table_catalog_id.as_deref()
    }
    /// <p>A database in the Glue Data Catalog.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>A table in the database.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name given by the user to the data filter cell.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A PartiQL predicate.</p>
    pub fn row_filter(&self) -> std::option::Option<&crate::model::RowFilter> {
        self.row_filter.as_ref()
    }
    /// <p>A list of column names.</p>
    pub fn column_names(&self) -> std::option::Option<&[std::string::String]> {
        self.column_names.as_deref()
    }
    /// <p>A wildcard with exclusions.</p>
    pub fn column_wildcard(&self) -> std::option::Option<&crate::model::ColumnWildcard> {
        self.column_wildcard.as_ref()
    }
}
impl std::fmt::Debug for DataCellsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCellsFilter");
        formatter.field("table_catalog_id", &self.table_catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("name", &self.name);
        formatter.field("row_filter", &self.row_filter);
        formatter.field("column_names", &self.column_names);
        formatter.field("column_wildcard", &self.column_wildcard);
        formatter.finish()
    }
}
/// See [`DataCellsFilter`](crate::model::DataCellsFilter)
pub mod data_cells_filter {
    /// A builder for [`DataCellsFilter`](crate::model::DataCellsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) row_filter: std::option::Option<crate::model::RowFilter>,
        pub(crate) column_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) column_wildcard: std::option::Option<crate::model::ColumnWildcard>,
    }
    impl Builder {
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn table_catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the catalog to which the table belongs.</p>
        pub fn set_table_catalog_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_catalog_id = input;
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>A database in the Glue Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A table in the database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>A table in the database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name given by the user to the data filter cell.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A PartiQL predicate.</p>
        pub fn row_filter(mut self, input: crate::model::RowFilter) -> Self {
            self.row_filter = Some(input);
            self
        }
        /// <p>A PartiQL predicate.</p>
        pub fn set_row_filter(
            mut self,
            input: std::option::Option<crate::model::RowFilter>,
        ) -> Self {
            self.row_filter = input;
            self
        }
        /// Appends an item to `column_names`.
        ///
        /// To override the contents of this collection use [`set_column_names`](Self::set_column_names).
        ///
        /// <p>A list of column names.</p>
        pub fn column_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.column_names.unwrap_or_default();
            v.push(input.into());
            self.column_names = Some(v);
            self
        }
        /// <p>A list of column names.</p>
        pub fn set_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.column_names = input;
            self
        }
        /// <p>A wildcard with exclusions.</p>
        pub fn column_wildcard(mut self, input: crate::model::ColumnWildcard) -> Self {
            self.column_wildcard = Some(input);
            self
        }
        /// <p>A wildcard with exclusions.</p>
        pub fn set_column_wildcard(
            mut self,
            input: std::option::Option<crate::model::ColumnWildcard>,
        ) -> Self {
            self.column_wildcard = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCellsFilter`](crate::model::DataCellsFilter)
        pub fn build(self) -> crate::model::DataCellsFilter {
            crate::model::DataCellsFilter {
                table_catalog_id: self.table_catalog_id,
                database_name: self.database_name,
                table_name: self.table_name,
                name: self.name,
                row_filter: self.row_filter,
                column_names: self.column_names,
                column_wildcard: self.column_wildcard,
            }
        }
    }
}
impl DataCellsFilter {
    /// Creates a new builder-style object to manufacture [`DataCellsFilter`](crate::model::DataCellsFilter)
    pub fn builder() -> crate::model::data_cells_filter::Builder {
        crate::model::data_cells_filter::Builder::default()
    }
}

/// <p>A PartiQL predicate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RowFilter {
    /// <p>A filter expression.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>A wildcard for all rows.</p>
    pub all_rows_wildcard: std::option::Option<crate::model::AllRowsWildcard>,
}
impl RowFilter {
    /// <p>A filter expression.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>A wildcard for all rows.</p>
    pub fn all_rows_wildcard(&self) -> std::option::Option<&crate::model::AllRowsWildcard> {
        self.all_rows_wildcard.as_ref()
    }
}
impl std::fmt::Debug for RowFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RowFilter");
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("all_rows_wildcard", &self.all_rows_wildcard);
        formatter.finish()
    }
}
/// See [`RowFilter`](crate::model::RowFilter)
pub mod row_filter {
    /// A builder for [`RowFilter`](crate::model::RowFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) all_rows_wildcard: std::option::Option<crate::model::AllRowsWildcard>,
    }
    impl Builder {
        /// <p>A filter expression.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>A filter expression.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>A wildcard for all rows.</p>
        pub fn all_rows_wildcard(mut self, input: crate::model::AllRowsWildcard) -> Self {
            self.all_rows_wildcard = Some(input);
            self
        }
        /// <p>A wildcard for all rows.</p>
        pub fn set_all_rows_wildcard(
            mut self,
            input: std::option::Option<crate::model::AllRowsWildcard>,
        ) -> Self {
            self.all_rows_wildcard = input;
            self
        }
        /// Consumes the builder and constructs a [`RowFilter`](crate::model::RowFilter)
        pub fn build(self) -> crate::model::RowFilter {
            crate::model::RowFilter {
                filter_expression: self.filter_expression,
                all_rows_wildcard: self.all_rows_wildcard,
            }
        }
    }
}
impl RowFilter {
    /// Creates a new builder-style object to manufacture [`RowFilter`](crate::model::RowFilter)
    pub fn builder() -> crate::model::row_filter::Builder {
        crate::model::row_filter::Builder::default()
    }
}

/// <p>A structure that you pass to indicate you want all rows in a filter. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllRowsWildcard {}
impl std::fmt::Debug for AllRowsWildcard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllRowsWildcard");
        formatter.finish()
    }
}
/// See [`AllRowsWildcard`](crate::model::AllRowsWildcard)
pub mod all_rows_wildcard {
    /// A builder for [`AllRowsWildcard`](crate::model::AllRowsWildcard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AllRowsWildcard`](crate::model::AllRowsWildcard)
        pub fn build(self) -> crate::model::AllRowsWildcard {
            crate::model::AllRowsWildcard {}
        }
    }
}
impl AllRowsWildcard {
    /// Creates a new builder-style object to manufacture [`AllRowsWildcard`](crate::model::AllRowsWildcard)
    pub fn builder() -> crate::model::all_rows_wildcard::Builder {
        crate::model::all_rows_wildcard::Builder::default()
    }
}

/// <p>Defines the valid range of work unit IDs for querying the execution service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkUnitRange {
    /// <p>Defines the maximum work unit ID in the range. The maximum value is inclusive.</p>
    pub work_unit_id_max: i64,
    /// <p>Defines the minimum work unit ID in the range.</p>
    pub work_unit_id_min: i64,
    /// <p>A work token used to query the execution service.</p>
    pub work_unit_token: std::option::Option<std::string::String>,
}
impl WorkUnitRange {
    /// <p>Defines the maximum work unit ID in the range. The maximum value is inclusive.</p>
    pub fn work_unit_id_max(&self) -> i64 {
        self.work_unit_id_max
    }
    /// <p>Defines the minimum work unit ID in the range.</p>
    pub fn work_unit_id_min(&self) -> i64 {
        self.work_unit_id_min
    }
    /// <p>A work token used to query the execution service.</p>
    pub fn work_unit_token(&self) -> std::option::Option<&str> {
        self.work_unit_token.as_deref()
    }
}
impl std::fmt::Debug for WorkUnitRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkUnitRange");
        formatter.field("work_unit_id_max", &self.work_unit_id_max);
        formatter.field("work_unit_id_min", &self.work_unit_id_min);
        formatter.field("work_unit_token", &self.work_unit_token);
        formatter.finish()
    }
}
/// See [`WorkUnitRange`](crate::model::WorkUnitRange)
pub mod work_unit_range {
    /// A builder for [`WorkUnitRange`](crate::model::WorkUnitRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_unit_id_max: std::option::Option<i64>,
        pub(crate) work_unit_id_min: std::option::Option<i64>,
        pub(crate) work_unit_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Defines the maximum work unit ID in the range. The maximum value is inclusive.</p>
        pub fn work_unit_id_max(mut self, input: i64) -> Self {
            self.work_unit_id_max = Some(input);
            self
        }
        /// <p>Defines the maximum work unit ID in the range. The maximum value is inclusive.</p>
        pub fn set_work_unit_id_max(mut self, input: std::option::Option<i64>) -> Self {
            self.work_unit_id_max = input;
            self
        }
        /// <p>Defines the minimum work unit ID in the range.</p>
        pub fn work_unit_id_min(mut self, input: i64) -> Self {
            self.work_unit_id_min = Some(input);
            self
        }
        /// <p>Defines the minimum work unit ID in the range.</p>
        pub fn set_work_unit_id_min(mut self, input: std::option::Option<i64>) -> Self {
            self.work_unit_id_min = input;
            self
        }
        /// <p>A work token used to query the execution service.</p>
        pub fn work_unit_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_unit_token = Some(input.into());
            self
        }
        /// <p>A work token used to query the execution service.</p>
        pub fn set_work_unit_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.work_unit_token = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkUnitRange`](crate::model::WorkUnitRange)
        pub fn build(self) -> crate::model::WorkUnitRange {
            crate::model::WorkUnitRange {
                work_unit_id_max: self.work_unit_id_max.unwrap_or_default(),
                work_unit_id_min: self.work_unit_id_min.unwrap_or_default(),
                work_unit_token: self.work_unit_token,
            }
        }
    }
}
impl WorkUnitRange {
    /// Creates a new builder-style object to manufacture [`WorkUnitRange`](crate::model::WorkUnitRange)
    pub fn builder() -> crate::model::work_unit_range::Builder {
        crate::model::work_unit_range::Builder::default()
    }
}

/// <p>A structure containing a list of partition values and table objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartitionObjects {
    /// <p>A list of partition values.</p>
    pub partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of table objects</p>
    pub objects: std::option::Option<std::vec::Vec<crate::model::TableObject>>,
}
impl PartitionObjects {
    /// <p>A list of partition values.</p>
    pub fn partition_values(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_values.as_deref()
    }
    /// <p>A list of table objects</p>
    pub fn objects(&self) -> std::option::Option<&[crate::model::TableObject]> {
        self.objects.as_deref()
    }
}
impl std::fmt::Debug for PartitionObjects {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartitionObjects");
        formatter.field("partition_values", &self.partition_values);
        formatter.field("objects", &self.objects);
        formatter.finish()
    }
}
/// See [`PartitionObjects`](crate::model::PartitionObjects)
pub mod partition_objects {
    /// A builder for [`PartitionObjects`](crate::model::PartitionObjects)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partition_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) objects: std::option::Option<std::vec::Vec<crate::model::TableObject>>,
    }
    impl Builder {
        /// Appends an item to `partition_values`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values.</p>
        pub fn partition_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_values.unwrap_or_default();
            v.push(input.into());
            self.partition_values = Some(v);
            self
        }
        /// <p>A list of partition values.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_values = input;
            self
        }
        /// Appends an item to `objects`.
        ///
        /// To override the contents of this collection use [`set_objects`](Self::set_objects).
        ///
        /// <p>A list of table objects</p>
        pub fn objects(mut self, input: impl Into<crate::model::TableObject>) -> Self {
            let mut v = self.objects.unwrap_or_default();
            v.push(input.into());
            self.objects = Some(v);
            self
        }
        /// <p>A list of table objects</p>
        pub fn set_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableObject>>,
        ) -> Self {
            self.objects = input;
            self
        }
        /// Consumes the builder and constructs a [`PartitionObjects`](crate::model::PartitionObjects)
        pub fn build(self) -> crate::model::PartitionObjects {
            crate::model::PartitionObjects {
                partition_values: self.partition_values,
                objects: self.objects,
            }
        }
    }
}
impl PartitionObjects {
    /// Creates a new builder-style object to manufacture [`PartitionObjects`](crate::model::PartitionObjects)
    pub fn builder() -> crate::model::partition_objects::Builder {
        crate::model::partition_objects::Builder::default()
    }
}

/// <p>Specifies the details of a governed table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableObject {
    /// <p>The Amazon S3 location of the object.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>The size of the Amazon S3 object in bytes.</p>
    pub size: i64,
}
impl TableObject {
    /// <p>The Amazon S3 location of the object.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>The size of the Amazon S3 object in bytes.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
}
impl std::fmt::Debug for TableObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableObject");
        formatter.field("uri", &self.uri);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`TableObject`](crate::model::TableObject)
pub mod table_object {
    /// A builder for [`TableObject`](crate::model::TableObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon S3 location of the object.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the object.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>The size of the Amazon S3 object in bytes.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the Amazon S3 object in bytes.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`TableObject`](crate::model::TableObject)
        pub fn build(self) -> crate::model::TableObject {
            crate::model::TableObject {
                uri: self.uri,
                e_tag: self.e_tag,
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl TableObject {
    /// Creates a new builder-style object to manufacture [`TableObject`](crate::model::TableObject)
    pub fn builder() -> crate::model::table_object::Builder {
        crate::model::table_object::Builder::default()
    }
}

/// <p>Statistics related to the processing of a query statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlanningStatistics {
    /// <p>An estimate of the data that was scanned in bytes.</p>
    pub estimated_data_to_scan_bytes: i64,
    /// <p>The time that it took to process the request.</p>
    pub planning_time_millis: i64,
    /// <p>The time the request was in queue to be processed.</p>
    pub queue_time_millis: i64,
    /// <p>The number of work units generated.</p>
    pub work_units_generated_count: i64,
}
impl PlanningStatistics {
    /// <p>An estimate of the data that was scanned in bytes.</p>
    pub fn estimated_data_to_scan_bytes(&self) -> i64 {
        self.estimated_data_to_scan_bytes
    }
    /// <p>The time that it took to process the request.</p>
    pub fn planning_time_millis(&self) -> i64 {
        self.planning_time_millis
    }
    /// <p>The time the request was in queue to be processed.</p>
    pub fn queue_time_millis(&self) -> i64 {
        self.queue_time_millis
    }
    /// <p>The number of work units generated.</p>
    pub fn work_units_generated_count(&self) -> i64 {
        self.work_units_generated_count
    }
}
impl std::fmt::Debug for PlanningStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlanningStatistics");
        formatter.field(
            "estimated_data_to_scan_bytes",
            &self.estimated_data_to_scan_bytes,
        );
        formatter.field("planning_time_millis", &self.planning_time_millis);
        formatter.field("queue_time_millis", &self.queue_time_millis);
        formatter.field(
            "work_units_generated_count",
            &self.work_units_generated_count,
        );
        formatter.finish()
    }
}
/// See [`PlanningStatistics`](crate::model::PlanningStatistics)
pub mod planning_statistics {
    /// A builder for [`PlanningStatistics`](crate::model::PlanningStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_data_to_scan_bytes: std::option::Option<i64>,
        pub(crate) planning_time_millis: std::option::Option<i64>,
        pub(crate) queue_time_millis: std::option::Option<i64>,
        pub(crate) work_units_generated_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>An estimate of the data that was scanned in bytes.</p>
        pub fn estimated_data_to_scan_bytes(mut self, input: i64) -> Self {
            self.estimated_data_to_scan_bytes = Some(input);
            self
        }
        /// <p>An estimate of the data that was scanned in bytes.</p>
        pub fn set_estimated_data_to_scan_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.estimated_data_to_scan_bytes = input;
            self
        }
        /// <p>The time that it took to process the request.</p>
        pub fn planning_time_millis(mut self, input: i64) -> Self {
            self.planning_time_millis = Some(input);
            self
        }
        /// <p>The time that it took to process the request.</p>
        pub fn set_planning_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.planning_time_millis = input;
            self
        }
        /// <p>The time the request was in queue to be processed.</p>
        pub fn queue_time_millis(mut self, input: i64) -> Self {
            self.queue_time_millis = Some(input);
            self
        }
        /// <p>The time the request was in queue to be processed.</p>
        pub fn set_queue_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.queue_time_millis = input;
            self
        }
        /// <p>The number of work units generated.</p>
        pub fn work_units_generated_count(mut self, input: i64) -> Self {
            self.work_units_generated_count = Some(input);
            self
        }
        /// <p>The number of work units generated.</p>
        pub fn set_work_units_generated_count(mut self, input: std::option::Option<i64>) -> Self {
            self.work_units_generated_count = input;
            self
        }
        /// Consumes the builder and constructs a [`PlanningStatistics`](crate::model::PlanningStatistics)
        pub fn build(self) -> crate::model::PlanningStatistics {
            crate::model::PlanningStatistics {
                estimated_data_to_scan_bytes: self.estimated_data_to_scan_bytes.unwrap_or_default(),
                planning_time_millis: self.planning_time_millis.unwrap_or_default(),
                queue_time_millis: self.queue_time_millis.unwrap_or_default(),
                work_units_generated_count: self.work_units_generated_count.unwrap_or_default(),
            }
        }
    }
}
impl PlanningStatistics {
    /// Creates a new builder-style object to manufacture [`PlanningStatistics`](crate::model::PlanningStatistics)
    pub fn builder() -> crate::model::planning_statistics::Builder {
        crate::model::planning_statistics::Builder::default()
    }
}

/// <p>Statistics related to the processing of a query statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionStatistics {
    /// <p>The average time the request took to be executed.</p>
    pub average_execution_time_millis: i64,
    /// <p>The amount of data that was scanned in bytes.</p>
    pub data_scanned_bytes: i64,
    /// <p>The number of work units executed.</p>
    pub work_units_executed_count: i64,
}
impl ExecutionStatistics {
    /// <p>The average time the request took to be executed.</p>
    pub fn average_execution_time_millis(&self) -> i64 {
        self.average_execution_time_millis
    }
    /// <p>The amount of data that was scanned in bytes.</p>
    pub fn data_scanned_bytes(&self) -> i64 {
        self.data_scanned_bytes
    }
    /// <p>The number of work units executed.</p>
    pub fn work_units_executed_count(&self) -> i64 {
        self.work_units_executed_count
    }
}
impl std::fmt::Debug for ExecutionStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionStatistics");
        formatter.field(
            "average_execution_time_millis",
            &self.average_execution_time_millis,
        );
        formatter.field("data_scanned_bytes", &self.data_scanned_bytes);
        formatter.field("work_units_executed_count", &self.work_units_executed_count);
        formatter.finish()
    }
}
/// See [`ExecutionStatistics`](crate::model::ExecutionStatistics)
pub mod execution_statistics {
    /// A builder for [`ExecutionStatistics`](crate::model::ExecutionStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) average_execution_time_millis: std::option::Option<i64>,
        pub(crate) data_scanned_bytes: std::option::Option<i64>,
        pub(crate) work_units_executed_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The average time the request took to be executed.</p>
        pub fn average_execution_time_millis(mut self, input: i64) -> Self {
            self.average_execution_time_millis = Some(input);
            self
        }
        /// <p>The average time the request took to be executed.</p>
        pub fn set_average_execution_time_millis(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.average_execution_time_millis = input;
            self
        }
        /// <p>The amount of data that was scanned in bytes.</p>
        pub fn data_scanned_bytes(mut self, input: i64) -> Self {
            self.data_scanned_bytes = Some(input);
            self
        }
        /// <p>The amount of data that was scanned in bytes.</p>
        pub fn set_data_scanned_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.data_scanned_bytes = input;
            self
        }
        /// <p>The number of work units executed.</p>
        pub fn work_units_executed_count(mut self, input: i64) -> Self {
            self.work_units_executed_count = Some(input);
            self
        }
        /// <p>The number of work units executed.</p>
        pub fn set_work_units_executed_count(mut self, input: std::option::Option<i64>) -> Self {
            self.work_units_executed_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionStatistics`](crate::model::ExecutionStatistics)
        pub fn build(self) -> crate::model::ExecutionStatistics {
            crate::model::ExecutionStatistics {
                average_execution_time_millis: self
                    .average_execution_time_millis
                    .unwrap_or_default(),
                data_scanned_bytes: self.data_scanned_bytes.unwrap_or_default(),
                work_units_executed_count: self.work_units_executed_count.unwrap_or_default(),
            }
        }
    }
}
impl ExecutionStatistics {
    /// Creates a new builder-style object to manufacture [`ExecutionStatistics`](crate::model::ExecutionStatistics)
    pub fn builder() -> crate::model::execution_statistics::Builder {
        crate::model::execution_statistics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryStateString {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    WorkunitsAvailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryStateString {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => QueryStateString::Error,
            "EXPIRED" => QueryStateString::Expired,
            "FINISHED" => QueryStateString::Finished,
            "PENDING" => QueryStateString::Pending,
            "WORKUNITS_AVAILABLE" => QueryStateString::WorkunitsAvailable,
            other => QueryStateString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryStateString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryStateString::from(s))
    }
}
impl QueryStateString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryStateString::Error => "ERROR",
            QueryStateString::Expired => "EXPIRED",
            QueryStateString::Finished => "FINISHED",
            QueryStateString::Pending => "PENDING",
            QueryStateString::WorkunitsAvailable => "WORKUNITS_AVAILABLE",
            QueryStateString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ERROR",
            "EXPIRED",
            "FINISHED",
            "PENDING",
            "WORKUNITS_AVAILABLE",
        ]
    }
}
impl AsRef<str> for QueryStateString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that defines an Amazon S3 object to be deleted if a transaction cancels, provided that
/// <code>VirtualPut</code> was called before writing the object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualObject {
    /// <p>The path to the Amazon S3 object. Must start with s3://</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The ETag of the Amazon S3 object.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl VirtualObject {
    /// <p>The path to the Amazon S3 object. Must start with s3://</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The ETag of the Amazon S3 object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
}
impl std::fmt::Debug for VirtualObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualObject");
        formatter.field("uri", &self.uri);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`VirtualObject`](crate::model::VirtualObject)
pub mod virtual_object {
    /// A builder for [`VirtualObject`](crate::model::VirtualObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path to the Amazon S3 object. Must start with s3://</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The path to the Amazon S3 object. Must start with s3://</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The ETag of the Amazon S3 object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The ETag of the Amazon S3 object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualObject`](crate::model::VirtualObject)
        pub fn build(self) -> crate::model::VirtualObject {
            crate::model::VirtualObject {
                uri: self.uri,
                e_tag: self.e_tag,
            }
        }
    }
}
impl VirtualObject {
    /// Creates a new builder-style object to manufacture [`VirtualObject`](crate::model::VirtualObject)
    pub fn builder() -> crate::model::virtual_object::Builder {
        crate::model::virtual_object::Builder::default()
    }
}

/// <p>A list of failures when performing a batch grant or batch revoke operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPermissionsFailureEntry {
    /// <p>An identifier for an entry of the batch request.</p>
    pub request_entry: std::option::Option<crate::model::BatchPermissionsRequestEntry>,
    /// <p>An error message that applies to the failure of the entry.</p>
    pub error: std::option::Option<crate::model::ErrorDetail>,
}
impl BatchPermissionsFailureEntry {
    /// <p>An identifier for an entry of the batch request.</p>
    pub fn request_entry(
        &self,
    ) -> std::option::Option<&crate::model::BatchPermissionsRequestEntry> {
        self.request_entry.as_ref()
    }
    /// <p>An error message that applies to the failure of the entry.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetail> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchPermissionsFailureEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPermissionsFailureEntry");
        formatter.field("request_entry", &self.request_entry);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchPermissionsFailureEntry`](crate::model::BatchPermissionsFailureEntry)
pub mod batch_permissions_failure_entry {
    /// A builder for [`BatchPermissionsFailureEntry`](crate::model::BatchPermissionsFailureEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_entry: std::option::Option<crate::model::BatchPermissionsRequestEntry>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetail>,
    }
    impl Builder {
        /// <p>An identifier for an entry of the batch request.</p>
        pub fn request_entry(mut self, input: crate::model::BatchPermissionsRequestEntry) -> Self {
            self.request_entry = Some(input);
            self
        }
        /// <p>An identifier for an entry of the batch request.</p>
        pub fn set_request_entry(
            mut self,
            input: std::option::Option<crate::model::BatchPermissionsRequestEntry>,
        ) -> Self {
            self.request_entry = input;
            self
        }
        /// <p>An error message that applies to the failure of the entry.</p>
        pub fn error(mut self, input: crate::model::ErrorDetail) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An error message that applies to the failure of the entry.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetail>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPermissionsFailureEntry`](crate::model::BatchPermissionsFailureEntry)
        pub fn build(self) -> crate::model::BatchPermissionsFailureEntry {
            crate::model::BatchPermissionsFailureEntry {
                request_entry: self.request_entry,
                error: self.error,
            }
        }
    }
}
impl BatchPermissionsFailureEntry {
    /// Creates a new builder-style object to manufacture [`BatchPermissionsFailureEntry`](crate::model::BatchPermissionsFailureEntry)
    pub fn builder() -> crate::model::batch_permissions_failure_entry::Builder {
        crate::model::batch_permissions_failure_entry::Builder::default()
    }
}

/// <p>A permission to a resource granted by batch operation to the principal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPermissionsRequestEntry {
    /// <p>A unique identifier for the batch permissions request entry.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The principal to be granted a permission.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The resource to which the principal is to be granted a permission.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The permissions to be granted.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>Indicates if the option to pass permissions is granted.</p>
    pub permissions_with_grant_option: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl BatchPermissionsRequestEntry {
    /// <p>A unique identifier for the batch permissions request entry.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The principal to be granted a permission.</p>
    pub fn principal(&self) -> std::option::Option<&crate::model::DataLakePrincipal> {
        self.principal.as_ref()
    }
    /// <p>The resource to which the principal is to be granted a permission.</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The permissions to be granted.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>Indicates if the option to pass permissions is granted.</p>
    pub fn permissions_with_grant_option(
        &self,
    ) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions_with_grant_option.as_deref()
    }
}
impl std::fmt::Debug for BatchPermissionsRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPermissionsRequestEntry");
        formatter.field("id", &self.id);
        formatter.field("principal", &self.principal);
        formatter.field("resource", &self.resource);
        formatter.field("permissions", &self.permissions);
        formatter.field(
            "permissions_with_grant_option",
            &self.permissions_with_grant_option,
        );
        formatter.finish()
    }
}
/// See [`BatchPermissionsRequestEntry`](crate::model::BatchPermissionsRequestEntry)
pub mod batch_permissions_request_entry {
    /// A builder for [`BatchPermissionsRequestEntry`](crate::model::BatchPermissionsRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) permissions_with_grant_option:
            std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p>A unique identifier for the batch permissions request entry.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the batch permissions request entry.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The principal to be granted a permission.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The principal to be granted a permission.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// <p>The resource to which the principal is to be granted a permission.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The resource to which the principal is to be granted a permission.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions to be granted.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions to be granted.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `permissions_with_grant_option`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates if the option to pass permissions is granted.</p>
        pub fn permissions_with_grant_option(
            mut self,
            input: impl Into<crate::model::Permission>,
        ) -> Self {
            let mut v = self.permissions_with_grant_option.unwrap_or_default();
            v.push(input.into());
            self.permissions_with_grant_option = Some(v);
            self
        }
        /// <p>Indicates if the option to pass permissions is granted.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions_with_grant_option = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPermissionsRequestEntry`](crate::model::BatchPermissionsRequestEntry)
        pub fn build(self) -> crate::model::BatchPermissionsRequestEntry {
            crate::model::BatchPermissionsRequestEntry {
                id: self.id,
                principal: self.principal,
                resource: self.resource,
                permissions: self.permissions,
                permissions_with_grant_option: self.permissions_with_grant_option,
            }
        }
    }
}
impl BatchPermissionsRequestEntry {
    /// Creates a new builder-style object to manufacture [`BatchPermissionsRequestEntry`](crate::model::BatchPermissionsRequestEntry)
    pub fn builder() -> crate::model::batch_permissions_request_entry::Builder {
        crate::model::batch_permissions_request_entry::Builder::default()
    }
}
