// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>Contains details about an error where the query request expired.</p>
    ExpiredException(crate::error::ExpiredException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>Contains details about an error related to a resource which is not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// <p>Contains details about an error related to statistics not being ready.</p>
    StatisticsNotReadyYetException(crate::error::StatisticsNotReadyYetException),
    /// <p>Contains details about an error where the query request was throttled.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>Contains details about an error related to a transaction that was cancelled.</p>
    TransactionCanceledException(crate::error::TransactionCanceledException),
    /// <p>Contains details about an error related to a transaction commit that was in progress.</p>
    TransactionCommitInProgressException(crate::error::TransactionCommitInProgressException),
    /// <p>Contains details about an error where the specified transaction has already been committed and cannot be used for <code>UpdateTableObjects</code>.</p>
    TransactionCommittedException(crate::error::TransactionCommittedException),
    /// <p>Contains details about an error related to work units not being ready.</p>
    WorkUnitsNotReadyYetException(crate::error::WorkUnitsNotReadyYetException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AlreadyExistsException(inner) => inner.fmt(f),
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::EntityNotFoundException(inner) => inner.fmt(f),
            Error::ExpiredException(inner) => inner.fmt(f),
            Error::GlueEncryptionException(inner) => inner.fmt(f),
            Error::InternalServiceException(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::OperationTimeoutException(inner) => inner.fmt(f),
            Error::ResourceNotReadyException(inner) => inner.fmt(f),
            Error::ResourceNumberLimitExceededException(inner) => inner.fmt(f),
            Error::StatisticsNotReadyYetException(inner) => inner.fmt(f),
            Error::ThrottledException(inner) => inner.fmt(f),
            Error::TransactionCanceledException(inner) => inner.fmt(f),
            Error::TransactionCommitInProgressException(inner) => inner.fmt(f),
            Error::TransactionCommittedException(inner) => inner.fmt(f),
            Error::WorkUnitsNotReadyYetException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddLFTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddLFTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddLFTagsToResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AddLFTagsToResourceErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::AddLFTagsToResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::AddLFTagsToResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::AddLFTagsToResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::AddLFTagsToResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::AddLFTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGrantPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGrantPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGrantPermissionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGrantPermissionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGrantPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchRevokePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchRevokePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchRevokePermissionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchRevokePermissionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchRevokePermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelTransactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelTransactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelTransactionErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::CancelTransactionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CancelTransactionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CancelTransactionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CancelTransactionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CancelTransactionErrorKind::TransactionCommitInProgressException(
                    inner,
                ) => Error::TransactionCommitInProgressException(inner),
                crate::error::CancelTransactionErrorKind::TransactionCommittedException(inner) => {
                    Error::TransactionCommittedException(inner)
                }
                crate::error::CancelTransactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CommitTransactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CommitTransactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CommitTransactionErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::CommitTransactionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CommitTransactionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CommitTransactionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CommitTransactionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CommitTransactionErrorKind::TransactionCanceledException(inner) => {
                    Error::TransactionCanceledException(inner)
                }
                crate::error::CommitTransactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDataCellsFilterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDataCellsFilterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDataCellsFilterErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateDataCellsFilterErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::CreateDataCellsFilterErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::CreateDataCellsFilterErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::CreateDataCellsFilterErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateDataCellsFilterErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::CreateDataCellsFilterErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateDataCellsFilterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLFTagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateLFTagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLFTagErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateLFTagErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreateLFTagErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateLFTagErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateLFTagErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateLFTagErrorKind::ResourceNumberLimitExceededException(inner) => {
                    Error::ResourceNumberLimitExceededException(inner)
                }
                crate::error::CreateLFTagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDataCellsFilterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDataCellsFilterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDataCellsFilterErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDataCellsFilterErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteDataCellsFilterErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteDataCellsFilterErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDataCellsFilterErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteDataCellsFilterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLFTagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteLFTagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLFTagErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteLFTagErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteLFTagErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteLFTagErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteLFTagErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteLFTagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteObjectsOnCancelError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteObjectsOnCancelError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteObjectsOnCancelErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::DeleteObjectsOnCancelErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteObjectsOnCancelErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteObjectsOnCancelErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteObjectsOnCancelErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteObjectsOnCancelErrorKind::ResourceNotReadyException(inner) => {
                    Error::ResourceNotReadyException(inner)
                }
                crate::error::DeleteObjectsOnCancelErrorKind::TransactionCanceledException(
                    inner,
                ) => Error::TransactionCanceledException(inner),
                crate::error::DeleteObjectsOnCancelErrorKind::TransactionCommittedException(
                    inner,
                ) => Error::TransactionCommittedException(inner),
                crate::error::DeleteObjectsOnCancelErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeregisterResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeregisterResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeregisterResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeregisterResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DescribeResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DescribeResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTransactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTransactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTransactionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DescribeTransactionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DescribeTransactionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeTransactionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DescribeTransactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExtendTransactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ExtendTransactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExtendTransactionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ExtendTransactionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ExtendTransactionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ExtendTransactionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ExtendTransactionErrorKind::TransactionCanceledException(inner) => {
                    Error::TransactionCanceledException(inner)
                }
                crate::error::ExtendTransactionErrorKind::TransactionCommitInProgressException(
                    inner,
                ) => Error::TransactionCommitInProgressException(inner),
                crate::error::ExtendTransactionErrorKind::TransactionCommittedException(inner) => {
                    Error::TransactionCommittedException(inner)
                }
                crate::error::ExtendTransactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDataLakeSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDataLakeSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDataLakeSettingsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetDataLakeSettingsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDataLakeSettingsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDataLakeSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetEffectivePermissionsForPathError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetEffectivePermissionsForPathError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetEffectivePermissionsForPathErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::GetEffectivePermissionsForPathErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::GetEffectivePermissionsForPathErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetEffectivePermissionsForPathErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::GetEffectivePermissionsForPathErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLFTagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetLFTagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLFTagErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLFTagErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetLFTagErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetLFTagErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetLFTagErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetLFTagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetQueryStateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetQueryStateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetQueryStateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetQueryStateErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetQueryStateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetQueryStateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetQueryStatisticsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetQueryStatisticsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetQueryStatisticsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetQueryStatisticsErrorKind::ExpiredException(inner) => {
                    Error::ExpiredException(inner)
                }
                crate::error::GetQueryStatisticsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetQueryStatisticsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetQueryStatisticsErrorKind::StatisticsNotReadyYetException(
                    inner,
                ) => Error::StatisticsNotReadyYetException(inner),
                crate::error::GetQueryStatisticsErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::GetQueryStatisticsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourceLFTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourceLFTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourceLFTagsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetResourceLFTagsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTableObjectsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTableObjectsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTableObjectsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTableObjectsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTableObjectsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTableObjectsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTableObjectsErrorKind::ResourceNotReadyException(inner) => {
                    Error::ResourceNotReadyException(inner)
                }
                crate::error::GetTableObjectsErrorKind::TransactionCanceledException(inner) => {
                    Error::TransactionCanceledException(inner)
                }
                crate::error::GetTableObjectsErrorKind::TransactionCommittedException(inner) => {
                    Error::TransactionCommittedException(inner)
                }
                crate::error::GetTableObjectsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkUnitResultsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetWorkUnitResultsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkUnitResultsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetWorkUnitResultsErrorKind::ExpiredException(inner) => {
                    Error::ExpiredException(inner)
                }
                crate::error::GetWorkUnitResultsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetWorkUnitResultsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkUnitResultsErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::GetWorkUnitResultsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkUnitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetWorkUnitsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkUnitsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetWorkUnitsErrorKind::ExpiredException(inner) => {
                    Error::ExpiredException(inner)
                }
                crate::error::GetWorkUnitsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetWorkUnitsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkUnitsErrorKind::WorkUnitsNotReadyYetException(inner) => {
                    Error::WorkUnitsNotReadyYetException(inner)
                }
                crate::error::GetWorkUnitsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GrantPermissionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GrantPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GrantPermissionsErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::GrantPermissionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GrantPermissionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GrantPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDataCellsFilterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDataCellsFilterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDataCellsFilterErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDataCellsFilterErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListDataCellsFilterErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListDataCellsFilterErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListDataCellsFilterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLFTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListLFTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListLFTagsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListLFTagsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListLFTagsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListLFTagsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListLFTagsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListLFTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPermissionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListPermissionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListPermissionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourcesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListResourcesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListResourcesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTableStorageOptimizersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTableStorageOptimizersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTableStorageOptimizersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListTableStorageOptimizersErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::ListTableStorageOptimizersErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::ListTableStorageOptimizersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListTableStorageOptimizersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTransactionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTransactionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTransactionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListTransactionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListTransactionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListTransactionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutDataLakeSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutDataLakeSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutDataLakeSettingsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::PutDataLakeSettingsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PutDataLakeSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RegisterResourceErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::RegisterResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::RegisterResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::RegisterResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::RegisterResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::RegisterResourceErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::RegisterResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveLFTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveLFTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveLFTagsFromResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::RemoveLFTagsFromResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokePermissionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RevokePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RevokePermissionsErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::RevokePermissionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::RevokePermissionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::RevokePermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchDatabasesByLFTagsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SearchDatabasesByLFTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchDatabasesByLFTagsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SearchDatabasesByLFTagsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::SearchDatabasesByLFTagsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::SearchDatabasesByLFTagsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::SearchDatabasesByLFTagsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SearchDatabasesByLFTagsErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::SearchDatabasesByLFTagsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchTablesByLFTagsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SearchTablesByLFTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchTablesByLFTagsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::SearchTablesByLFTagsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartQueryPlanningError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartQueryPlanningError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartQueryPlanningErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StartQueryPlanningErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartQueryPlanningErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartQueryPlanningErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::StartQueryPlanningErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartTransactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartTransactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartTransactionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartTransactionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartTransactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateLFTagError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateLFTagError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateLFTagErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateLFTagErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateLFTagErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateLFTagErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateLFTagErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateLFTagErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateLFTagErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTableObjectsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTableObjectsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTableObjectsErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::UpdateTableObjectsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::ResourceNotReadyException(inner) => {
                    Error::ResourceNotReadyException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::TransactionCanceledException(inner) => {
                    Error::TransactionCanceledException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::TransactionCommitInProgressException(
                    inner,
                ) => Error::TransactionCommitInProgressException(inner),
                crate::error::UpdateTableObjectsErrorKind::TransactionCommittedException(inner) => {
                    Error::TransactionCommittedException(inner)
                }
                crate::error::UpdateTableObjectsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTableStorageOptimizerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTableStorageOptimizerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTableStorageOptimizerErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::UpdateTableStorageOptimizerErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::UpdateTableStorageOptimizerErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::UpdateTableStorageOptimizerErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::UpdateTableStorageOptimizerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
