// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddLFTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddLFTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddLFTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddLFTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddLFTagsToResourceErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddLFTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddLFTagsToResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            AddLFTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddLFTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddLFTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddLFTagsToResourceError {
    /// Creates a new `AddLFTagsToResourceError`.
    pub fn new(kind: AddLFTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddLFTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddLFTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddLFTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddLFTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `AddLFTagsToResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLFTagsToResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for AddLFTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddLFTagsToResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            AddLFTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGrantPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGrantPermissionsError {
    /// Kind of error that occurred.
    pub kind: BatchGrantPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGrantPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGrantPermissionsErrorKind {
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGrantPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGrantPermissionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGrantPermissionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGrantPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGrantPermissionsError {
    fn code(&self) -> Option<&str> {
        BatchGrantPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGrantPermissionsError {
    /// Creates a new `BatchGrantPermissionsError`.
    pub fn new(kind: BatchGrantPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGrantPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGrantPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGrantPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGrantPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchGrantPermissionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGrantPermissionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `BatchGrantPermissionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGrantPermissionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGrantPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGrantPermissionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGrantPermissionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGrantPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchRevokePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchRevokePermissionsError {
    /// Kind of error that occurred.
    pub kind: BatchRevokePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchRevokePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchRevokePermissionsErrorKind {
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchRevokePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchRevokePermissionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchRevokePermissionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchRevokePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchRevokePermissionsError {
    fn code(&self) -> Option<&str> {
        BatchRevokePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchRevokePermissionsError {
    /// Creates a new `BatchRevokePermissionsError`.
    pub fn new(kind: BatchRevokePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchRevokePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchRevokePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchRevokePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchRevokePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchRevokePermissionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchRevokePermissionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `BatchRevokePermissionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchRevokePermissionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchRevokePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchRevokePermissionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchRevokePermissionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchRevokePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLFTagError {
    /// Kind of error that occurred.
    pub kind: CreateLFTagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLFTagErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLFTagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLFTagErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateLFTagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLFTagError {
    fn code(&self) -> Option<&str> {
        CreateLFTagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLFTagError {
    /// Creates a new `CreateLFTagError`.
    pub fn new(kind: CreateLFTagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLFTagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLFTagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLFTagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLFTagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateLFTagErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateLFTagErrorKind::EntityNotFoundException(_))
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLFTagErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateLFTagErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLFTagErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns true if the error kind is `CreateLFTagErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLFTagErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateLFTagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLFTagErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLFTagErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateLFTagErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateLFTagErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateLFTagErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateLFTagErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateLFTagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLFTagError {
    /// Kind of error that occurred.
    pub kind: DeleteLFTagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLFTagErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLFTagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLFTagErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLFTagErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteLFTagErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteLFTagErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteLFTagErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteLFTagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLFTagError {
    fn code(&self) -> Option<&str> {
        DeleteLFTagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLFTagError {
    /// Creates a new `DeleteLFTagError`.
    pub fn new(kind: DeleteLFTagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLFTagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLFTagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLFTagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLFTagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteLFTagErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteLFTagErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteLFTagErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteLFTagErrorKind::EntityNotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteLFTagErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLFTagErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeleteLFTagErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteLFTagErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `DeleteLFTagErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLFTagErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteLFTagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLFTagErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLFTagErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteLFTagErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteLFTagErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteLFTagErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteLFTagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterResourceError {
    /// Kind of error that occurred.
    pub kind: DeregisterResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterResourceErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeregisterResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeregisterResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeregisterResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeregisterResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterResourceError {
    fn code(&self) -> Option<&str> {
        DeregisterResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterResourceError {
    /// Creates a new `DeregisterResourceError`.
    pub fn new(kind: DeregisterResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeregisterResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeregisterResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DeregisterResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `DeregisterResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeregisterResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeregisterResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeregisterResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeregisterResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeregisterResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourceError {
    /// Kind of error that occurred.
    pub kind: DescribeResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourceErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DescribeResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourceError {
    fn code(&self) -> Option<&str> {
        DescribeResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourceError {
    /// Creates a new `DescribeResourceError`.
    pub fn new(kind: DescribeResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `DescribeResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DescribeResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DescribeResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DescribeResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataLakeSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataLakeSettingsError {
    /// Kind of error that occurred.
    pub kind: GetDataLakeSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataLakeSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataLakeSettingsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataLakeSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataLakeSettingsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetDataLakeSettingsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDataLakeSettingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDataLakeSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataLakeSettingsError {
    fn code(&self) -> Option<&str> {
        GetDataLakeSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataLakeSettingsError {
    /// Creates a new `GetDataLakeSettingsError`.
    pub fn new(kind: GetDataLakeSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataLakeSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataLakeSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataLakeSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataLakeSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDataLakeSettingsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataLakeSettingsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetDataLakeSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataLakeSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetDataLakeSettingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataLakeSettingsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GetDataLakeSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataLakeSettingsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetDataLakeSettingsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDataLakeSettingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDataLakeSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEffectivePermissionsForPath` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEffectivePermissionsForPathError {
    /// Kind of error that occurred.
    pub kind: GetEffectivePermissionsForPathErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEffectivePermissionsForPath` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEffectivePermissionsForPathErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEffectivePermissionsForPathError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEffectivePermissionsForPathErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEffectivePermissionsForPathErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetEffectivePermissionsForPathErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetEffectivePermissionsForPathErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetEffectivePermissionsForPathErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEffectivePermissionsForPathError {
    fn code(&self) -> Option<&str> {
        GetEffectivePermissionsForPathError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEffectivePermissionsForPathError {
    /// Creates a new `GetEffectivePermissionsForPathError`.
    pub fn new(
        kind: GetEffectivePermissionsForPathErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEffectivePermissionsForPathError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEffectivePermissionsForPathErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEffectivePermissionsForPathError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEffectivePermissionsForPathErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEffectivePermissionsForPathErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePermissionsForPathErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetEffectivePermissionsForPathErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePermissionsForPathErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetEffectivePermissionsForPathErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePermissionsForPathErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `GetEffectivePermissionsForPathErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePermissionsForPathErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetEffectivePermissionsForPathError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEffectivePermissionsForPathErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            GetEffectivePermissionsForPathErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetEffectivePermissionsForPathErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetEffectivePermissionsForPathErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            GetEffectivePermissionsForPathErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLFTagError {
    /// Kind of error that occurred.
    pub kind: GetLFTagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLFTagErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLFTagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLFTagErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLFTagErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetLFTagErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetLFTagErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetLFTagErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetLFTagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLFTagError {
    fn code(&self) -> Option<&str> {
        GetLFTagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLFTagError {
    /// Creates a new `GetLFTagError`.
    pub fn new(kind: GetLFTagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLFTagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLFTagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLFTagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLFTagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLFTagErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLFTagErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetLFTagErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLFTagErrorKind::EntityNotFoundException(_))
    }
    /// Returns true if the error kind is `GetLFTagErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetLFTagErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `GetLFTagErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetLFTagErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `GetLFTagErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetLFTagErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetLFTagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLFTagErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLFTagErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetLFTagErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetLFTagErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetLFTagErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetLFTagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceLFTagsError {
    /// Kind of error that occurred.
    pub kind: GetResourceLFTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceLFTagsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceLFTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceLFTagsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetResourceLFTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceLFTagsError {
    fn code(&self) -> Option<&str> {
        GetResourceLFTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceLFTagsError {
    /// Creates a new `GetResourceLFTagsError`.
    pub fn new(kind: GetResourceLFTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceLFTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceLFTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceLFTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceLFTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `GetResourceLFTagsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLFTagsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetResourceLFTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceLFTagsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetResourceLFTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GrantPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GrantPermissionsError {
    /// Kind of error that occurred.
    pub kind: GrantPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GrantPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GrantPermissionsErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GrantPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GrantPermissionsErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GrantPermissionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GrantPermissionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GrantPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GrantPermissionsError {
    fn code(&self) -> Option<&str> {
        GrantPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GrantPermissionsError {
    /// Creates a new `GrantPermissionsError`.
    pub fn new(kind: GrantPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GrantPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GrantPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GrantPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GrantPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GrantPermissionsErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantPermissionsErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GrantPermissionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantPermissionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GrantPermissionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantPermissionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GrantPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GrantPermissionsErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GrantPermissionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GrantPermissionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GrantPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLFTagsError {
    /// Kind of error that occurred.
    pub kind: ListLFTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLFTagsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLFTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLFTagsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListLFTagsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListLFTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListLFTagsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListLFTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLFTagsError {
    fn code(&self) -> Option<&str> {
        ListLFTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLFTagsError {
    /// Creates a new `ListLFTagsError`.
    pub fn new(kind: ListLFTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLFTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLFTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLFTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLFTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLFTagsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListLFTagsErrorKind::EntityNotFoundException(_))
    }
    /// Returns true if the error kind is `ListLFTagsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListLFTagsErrorKind::InternalServiceException(_))
    }
    /// Returns true if the error kind is `ListLFTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListLFTagsErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `ListLFTagsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLFTagsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListLFTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLFTagsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListLFTagsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListLFTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListLFTagsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListLFTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionsError {
    fn code(&self) -> Option<&str> {
        ListPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionsError {
    /// Creates a new `ListPermissionsError`.
    pub fn new(kind: ListPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPermissionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListPermissionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `ListPermissionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPermissionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPermissionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesError {
    /// Kind of error that occurred.
    pub kind: ListResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesError {
    fn code(&self) -> Option<&str> {
        ListResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesError {
    /// Creates a new `ListResourcesError`.
    pub fn new(kind: ListResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListResourcesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `ListResourcesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `ListResourcesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListResourcesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListResourcesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDataLakeSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDataLakeSettingsError {
    /// Kind of error that occurred.
    pub kind: PutDataLakeSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDataLakeSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDataLakeSettingsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDataLakeSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDataLakeSettingsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutDataLakeSettingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutDataLakeSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDataLakeSettingsError {
    fn code(&self) -> Option<&str> {
        PutDataLakeSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDataLakeSettingsError {
    /// Creates a new `PutDataLakeSettingsError`.
    pub fn new(kind: PutDataLakeSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDataLakeSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDataLakeSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDataLakeSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDataLakeSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutDataLakeSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDataLakeSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `PutDataLakeSettingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDataLakeSettingsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for PutDataLakeSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDataLakeSettingsErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutDataLakeSettingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutDataLakeSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterResourceError {
    /// Kind of error that occurred.
    pub kind: RegisterResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterResourceErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterResourceErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            RegisterResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RegisterResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RegisterResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            RegisterResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterResourceError {
    fn code(&self) -> Option<&str> {
        RegisterResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterResourceError {
    /// Creates a new `RegisterResourceError`.
    pub fn new(kind: RegisterResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RegisterResourceErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterResourceErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `RegisterResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `RegisterResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `RegisterResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for RegisterResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterResourceErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            RegisterResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            RegisterResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            RegisterResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            RegisterResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveLFTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveLFTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveLFTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveLFTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveLFTagsFromResourceErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveLFTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveLFTagsFromResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            RemoveLFTagsFromResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            RemoveLFTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveLFTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveLFTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveLFTagsFromResourceError {
    /// Creates a new `RemoveLFTagsFromResourceError`.
    pub fn new(kind: RemoveLFTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveLFTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveLFTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveLFTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveLFTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `RemoveLFTagsFromResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLFTagsFromResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for RemoveLFTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveLFTagsFromResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            RemoveLFTagsFromResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            RemoveLFTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokePermissionsError {
    /// Kind of error that occurred.
    pub kind: RevokePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokePermissionsErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokePermissionsErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RevokePermissionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            RevokePermissionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RevokePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokePermissionsError {
    fn code(&self) -> Option<&str> {
        RevokePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokePermissionsError {
    /// Creates a new `RevokePermissionsError`.
    pub fn new(kind: RevokePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RevokePermissionsErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokePermissionsErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `RevokePermissionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokePermissionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `RevokePermissionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokePermissionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for RevokePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokePermissionsErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RevokePermissionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            RevokePermissionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            RevokePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchDatabasesByLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchDatabasesByLFTagsError {
    /// Kind of error that occurred.
    pub kind: SearchDatabasesByLFTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchDatabasesByLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchDatabasesByLFTagsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchDatabasesByLFTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchDatabasesByLFTagsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            SearchDatabasesByLFTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchDatabasesByLFTagsError {
    fn code(&self) -> Option<&str> {
        SearchDatabasesByLFTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchDatabasesByLFTagsError {
    /// Creates a new `SearchDatabasesByLFTagsError`.
    pub fn new(kind: SearchDatabasesByLFTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchDatabasesByLFTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchDatabasesByLFTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchDatabasesByLFTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchDatabasesByLFTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `SearchDatabasesByLFTagsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDatabasesByLFTagsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for SearchDatabasesByLFTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchDatabasesByLFTagsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::InternalServiceException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            SearchDatabasesByLFTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchTablesByLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchTablesByLFTagsError {
    /// Kind of error that occurred.
    pub kind: SearchTablesByLFTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchTablesByLFTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchTablesByLFTagsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchTablesByLFTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchTablesByLFTagsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            SearchTablesByLFTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchTablesByLFTagsError {
    fn code(&self) -> Option<&str> {
        SearchTablesByLFTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchTablesByLFTagsError {
    /// Creates a new `SearchTablesByLFTagsError`.
    pub fn new(kind: SearchTablesByLFTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchTablesByLFTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchTablesByLFTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchTablesByLFTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchTablesByLFTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `SearchTablesByLFTagsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesByLFTagsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for SearchTablesByLFTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchTablesByLFTagsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::InternalServiceException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            SearchTablesByLFTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLFTagError {
    /// Kind of error that occurred.
    pub kind: UpdateLFTagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLFTag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLFTagErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLFTagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLFTagErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateLFTagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLFTagError {
    fn code(&self) -> Option<&str> {
        UpdateLFTagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLFTagError {
    /// Creates a new `UpdateLFTagError`.
    pub fn new(kind: UpdateLFTagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLFTagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLFTagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLFTagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLFTagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateLFTagErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLFTagErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateLFTagErrorKind::EntityNotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLFTagErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateLFTagErrorKind::InvalidInputException(_))
    }
    /// Returns true if the error kind is `UpdateLFTagErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLFTagErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateLFTagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLFTagErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateLFTagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceError {
    fn code(&self) -> Option<&str> {
        UpdateResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceError {
    /// Creates a new `UpdateResourceError`.
    pub fn new(kind: UpdateResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The operation timed out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationTimeoutException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationTimeoutException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationTimeoutException {}
/// See [`OperationTimeoutException`](crate::error::OperationTimeoutException)
pub mod operation_timeout_exception {
    /// A builder for [`OperationTimeoutException`](crate::error::OperationTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationTimeoutException`](crate::error::OperationTimeoutException)
        pub fn build(self) -> crate::error::OperationTimeoutException {
            crate::error::OperationTimeoutException {
                message: self.message,
            }
        }
    }
}
impl OperationTimeoutException {
    /// Creates a new builder-style object to manufacture [`OperationTimeoutException`](crate::error::OperationTimeoutException)
    pub fn builder() -> crate::error::operation_timeout_exception::Builder {
        crate::error::operation_timeout_exception::Builder::default()
    }
}

/// <p>The input provided was not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>An internal service error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>A specified entity does not exist</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityNotFoundException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityNotFoundException {}
/// See [`EntityNotFoundException`](crate::error::EntityNotFoundException)
pub mod entity_not_found_exception {
    /// A builder for [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityNotFoundException`](crate::error::EntityNotFoundException)
        pub fn build(self) -> crate::error::EntityNotFoundException {
            crate::error::EntityNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EntityNotFoundException {
    /// Creates a new builder-style object to manufacture [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    pub fn builder() -> crate::error::entity_not_found_exception::Builder {
        crate::error::entity_not_found_exception::Builder::default()
    }
}

/// <p>Two processes are trying to modify a resource simultaneously.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>Access to a resource was denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>An encryption operation failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlueEncryptionException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlueEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlueEncryptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GlueEncryptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GlueEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GlueEncryptionException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for GlueEncryptionException {}
/// See [`GlueEncryptionException`](crate::error::GlueEncryptionException)
pub mod glue_encryption_exception {
    /// A builder for [`GlueEncryptionException`](crate::error::GlueEncryptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GlueEncryptionException`](crate::error::GlueEncryptionException)
        pub fn build(self) -> crate::error::GlueEncryptionException {
            crate::error::GlueEncryptionException {
                message: self.message,
            }
        }
    }
}
impl GlueEncryptionException {
    /// Creates a new builder-style object to manufacture [`GlueEncryptionException`](crate::error::GlueEncryptionException)
    pub fn builder() -> crate::error::glue_encryption_exception::Builder {
        crate::error::glue_encryption_exception::Builder::default()
    }
}

/// <p>A resource to be created or added already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>A resource numerical limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNumberLimitExceededException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNumberLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNumberLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNumberLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNumberLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNumberLimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNumberLimitExceededException {}
/// See [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
pub mod resource_number_limit_exceeded_exception {
    /// A builder for [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
        pub fn build(self) -> crate::error::ResourceNumberLimitExceededException {
            crate::error::ResourceNumberLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceNumberLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
    pub fn builder() -> crate::error::resource_number_limit_exceeded_exception::Builder {
        crate::error::resource_number_limit_exceeded_exception::Builder::default()
    }
}
