// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSLakeFormation`.
///
/// This client allows ergonomic access to a `AWSLakeFormation`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddLFTagsToResource` operation.
    ///
    /// See [`AddLFTagsToResource`](crate::client::fluent_builders::AddLFTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_lf_tags_to_resource(&self) -> fluent_builders::AddLFTagsToResource<C, M, R> {
        fluent_builders::AddLFTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGrantPermissions` operation.
    ///
    /// See [`BatchGrantPermissions`](crate::client::fluent_builders::BatchGrantPermissions) for more information about the
    /// operation and its arguments.
    pub fn batch_grant_permissions(&self) -> fluent_builders::BatchGrantPermissions<C, M, R> {
        fluent_builders::BatchGrantPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchRevokePermissions` operation.
    ///
    /// See [`BatchRevokePermissions`](crate::client::fluent_builders::BatchRevokePermissions) for more information about the
    /// operation and its arguments.
    pub fn batch_revoke_permissions(&self) -> fluent_builders::BatchRevokePermissions<C, M, R> {
        fluent_builders::BatchRevokePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLFTag` operation.
    ///
    /// See [`CreateLFTag`](crate::client::fluent_builders::CreateLFTag) for more information about the
    /// operation and its arguments.
    pub fn create_lf_tag(&self) -> fluent_builders::CreateLFTag<C, M, R> {
        fluent_builders::CreateLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLFTag` operation.
    ///
    /// See [`DeleteLFTag`](crate::client::fluent_builders::DeleteLFTag) for more information about the
    /// operation and its arguments.
    pub fn delete_lf_tag(&self) -> fluent_builders::DeleteLFTag<C, M, R> {
        fluent_builders::DeleteLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterResource` operation.
    ///
    /// See [`DeregisterResource`](crate::client::fluent_builders::DeregisterResource) for more information about the
    /// operation and its arguments.
    pub fn deregister_resource(&self) -> fluent_builders::DeregisterResource<C, M, R> {
        fluent_builders::DeregisterResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResource` operation.
    ///
    /// See [`DescribeResource`](crate::client::fluent_builders::DescribeResource) for more information about the
    /// operation and its arguments.
    pub fn describe_resource(&self) -> fluent_builders::DescribeResource<C, M, R> {
        fluent_builders::DescribeResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataLakeSettings` operation.
    ///
    /// See [`GetDataLakeSettings`](crate::client::fluent_builders::GetDataLakeSettings) for more information about the
    /// operation and its arguments.
    pub fn get_data_lake_settings(&self) -> fluent_builders::GetDataLakeSettings<C, M, R> {
        fluent_builders::GetDataLakeSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEffectivePermissionsForPath` operation.
    ///
    /// See [`GetEffectivePermissionsForPath`](crate::client::fluent_builders::GetEffectivePermissionsForPath) for more information about the
    /// operation and its arguments.
    pub fn get_effective_permissions_for_path(
        &self,
    ) -> fluent_builders::GetEffectivePermissionsForPath<C, M, R> {
        fluent_builders::GetEffectivePermissionsForPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLFTag` operation.
    ///
    /// See [`GetLFTag`](crate::client::fluent_builders::GetLFTag) for more information about the
    /// operation and its arguments.
    pub fn get_lf_tag(&self) -> fluent_builders::GetLFTag<C, M, R> {
        fluent_builders::GetLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceLFTags` operation.
    ///
    /// See [`GetResourceLFTags`](crate::client::fluent_builders::GetResourceLFTags) for more information about the
    /// operation and its arguments.
    pub fn get_resource_lf_tags(&self) -> fluent_builders::GetResourceLFTags<C, M, R> {
        fluent_builders::GetResourceLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GrantPermissions` operation.
    ///
    /// See [`GrantPermissions`](crate::client::fluent_builders::GrantPermissions) for more information about the
    /// operation and its arguments.
    pub fn grant_permissions(&self) -> fluent_builders::GrantPermissions<C, M, R> {
        fluent_builders::GrantPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLFTags` operation.
    ///
    /// See [`ListLFTags`](crate::client::fluent_builders::ListLFTags) for more information about the
    /// operation and its arguments.
    pub fn list_lf_tags(&self) -> fluent_builders::ListLFTags<C, M, R> {
        fluent_builders::ListLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPermissions` operation.
    ///
    /// See [`ListPermissions`](crate::client::fluent_builders::ListPermissions) for more information about the
    /// operation and its arguments.
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions<C, M, R> {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResources` operation.
    ///
    /// See [`ListResources`](crate::client::fluent_builders::ListResources) for more information about the
    /// operation and its arguments.
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDataLakeSettings` operation.
    ///
    /// See [`PutDataLakeSettings`](crate::client::fluent_builders::PutDataLakeSettings) for more information about the
    /// operation and its arguments.
    pub fn put_data_lake_settings(&self) -> fluent_builders::PutDataLakeSettings<C, M, R> {
        fluent_builders::PutDataLakeSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterResource` operation.
    ///
    /// See [`RegisterResource`](crate::client::fluent_builders::RegisterResource) for more information about the
    /// operation and its arguments.
    pub fn register_resource(&self) -> fluent_builders::RegisterResource<C, M, R> {
        fluent_builders::RegisterResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveLFTagsFromResource` operation.
    ///
    /// See [`RemoveLFTagsFromResource`](crate::client::fluent_builders::RemoveLFTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_lf_tags_from_resource(
        &self,
    ) -> fluent_builders::RemoveLFTagsFromResource<C, M, R> {
        fluent_builders::RemoveLFTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokePermissions` operation.
    ///
    /// See [`RevokePermissions`](crate::client::fluent_builders::RevokePermissions) for more information about the
    /// operation and its arguments.
    pub fn revoke_permissions(&self) -> fluent_builders::RevokePermissions<C, M, R> {
        fluent_builders::RevokePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchDatabasesByLFTags` operation.
    ///
    /// See [`SearchDatabasesByLFTags`](crate::client::fluent_builders::SearchDatabasesByLFTags) for more information about the
    /// operation and its arguments.
    pub fn search_databases_by_lf_tags(&self) -> fluent_builders::SearchDatabasesByLFTags<C, M, R> {
        fluent_builders::SearchDatabasesByLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchTablesByLFTags` operation.
    ///
    /// See [`SearchTablesByLFTags`](crate::client::fluent_builders::SearchTablesByLFTags) for more information about the
    /// operation and its arguments.
    pub fn search_tables_by_lf_tags(&self) -> fluent_builders::SearchTablesByLFTags<C, M, R> {
        fluent_builders::SearchTablesByLFTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLFTag` operation.
    ///
    /// See [`UpdateLFTag`](crate::client::fluent_builders::UpdateLFTag) for more information about the
    /// operation and its arguments.
    pub fn update_lf_tag(&self) -> fluent_builders::UpdateLFTag<C, M, R> {
        fluent_builders::UpdateLFTag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResource` operation.
    ///
    /// See [`UpdateResource`](crate::client::fluent_builders::UpdateResource) for more information about the
    /// operation and its arguments.
    pub fn update_resource(&self) -> fluent_builders::UpdateResource<C, M, R> {
        fluent_builders::UpdateResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddLFTagsToResource`.
    ///
    /// <p>Attaches one or more tags to an existing resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddLFTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_lf_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddLFTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddLFTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddLfTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddLFTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddLfTagsToResourceInputOperationOutputAlias,
                crate::output::AddLfTagsToResourceOutput,
                crate::error::AddLFTagsToResourceError,
                crate::input::AddLfTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The resource to which to attach a tag.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The resource to which to attach a tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `LFTags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The tags to attach to the resource.</p>
        pub fn lf_tags(mut self, inp: impl Into<crate::model::LfTagPair>) -> Self {
            self.inner = self.inner.lf_tags(inp);
            self
        }
        /// <p>The tags to attach to the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.inner = self.inner.set_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGrantPermissions`.
    ///
    /// <p>Batch operation to grant permissions to the principal.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGrantPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_grant_permissions_input::Builder,
    }
    impl<C, M, R> BatchGrantPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGrantPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGrantPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGrantPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGrantPermissionsInputOperationOutputAlias,
                crate::output::BatchGrantPermissionsOutput,
                crate::error::BatchGrantPermissionsError,
                crate::input::BatchGrantPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::BatchPermissionsRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchRevokePermissions`.
    ///
    /// <p>Batch operation to revoke permissions from the principal.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchRevokePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_revoke_permissions_input::Builder,
    }
    impl<C, M, R> BatchRevokePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchRevokePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchRevokePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchRevokePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchRevokePermissionsInputOperationOutputAlias,
                crate::output::BatchRevokePermissionsOutput,
                crate::error::BatchRevokePermissionsError,
                crate::input::BatchRevokePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::BatchPermissionsRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPermissionsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLFTag`.
    ///
    /// <p>Creates a tag with the specified name and values.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lf_tag_input::Builder,
    }
    impl<C, M, R> CreateLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLfTagInputOperationOutputAlias,
                crate::output::CreateLfTagOutput,
                crate::error::CreateLFTagError,
                crate::input::CreateLfTagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the tag.</p>
        pub fn tag_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(inp);
            self
        }
        /// <p>The key-name for the tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A list of possible values an attribute can take.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A list of possible values an attribute can take.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLFTag`.
    ///
    /// <p>Deletes the specified tag key name. If the attribute key does not exist or the tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the tag key is still attached with resources. You can consider untagging resources with this tag key.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lf_tag_input::Builder,
    }
    impl<C, M, R> DeleteLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLfTagInputOperationOutputAlias,
                crate::output::DeleteLfTagOutput,
                crate::error::DeleteLFTagError,
                crate::input::DeleteLfTagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the tag to delete.</p>
        pub fn tag_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(inp);
            self
        }
        /// <p>The key-name for the tag to delete.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterResource`.
    ///
    /// <p>Deregisters the resource as managed by the Data Catalog.</p>
    ///
    /// <p>When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_resource_input::Builder,
    }
    impl<C, M, R> DeregisterResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterResourceInputOperationOutputAlias,
                crate::output::DeregisterResourceOutput,
                crate::error::DeregisterResourceError,
                crate::input::DeregisterResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResource`.
    ///
    /// <p>Retrieves the current data access role for the given resource registered in AWS Lake Formation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_input::Builder,
    }
    impl<C, M, R> DescribeResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceInputOperationOutputAlias,
                crate::output::DescribeResourceOutput,
                crate::error::DescribeResourceError,
                crate::input::DescribeResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataLakeSettings`.
    ///
    /// <p>Retrieves the list of the data lake administrators of a Lake Formation-managed data lake. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataLakeSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_lake_settings_input::Builder,
    }
    impl<C, M, R> GetDataLakeSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataLakeSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataLakeSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataLakeSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataLakeSettingsInputOperationOutputAlias,
                crate::output::GetDataLakeSettingsOutput,
                crate::error::GetDataLakeSettingsError,
                crate::input::GetDataLakeSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEffectivePermissionsForPath`.
    ///
    /// <p>Returns the Lake Formation permissions for a specified table or database resource located
    /// at a path in Amazon S3. <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEffectivePermissionsForPath<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_effective_permissions_for_path_input::Builder,
    }
    impl<C, M, R> GetEffectivePermissionsForPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEffectivePermissionsForPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEffectivePermissionsForPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEffectivePermissionsForPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEffectivePermissionsForPathInputOperationOutputAlias,
                crate::output::GetEffectivePermissionsForPathOutput,
                crate::error::GetEffectivePermissionsForPathError,
                crate::input::GetEffectivePermissionsForPathInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLFTag`.
    ///
    /// <p>Returns a tag definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lf_tag_input::Builder,
    }
    impl<C, M, R> GetLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLfTagInputOperationOutputAlias,
                crate::output::GetLfTagOutput,
                crate::error::GetLFTagError,
                crate::input::GetLfTagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the tag.</p>
        pub fn tag_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(inp);
            self
        }
        /// <p>The key-name for the tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceLFTags`.
    ///
    /// <p>Returns the tags applied to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_lf_tags_input::Builder,
    }
    impl<C, M, R> GetResourceLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceLfTagsInputOperationOutputAlias,
                crate::output::GetResourceLfTagsOutput,
                crate::error::GetResourceLFTagsError,
                crate::input::GetResourceLfTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The resource for which you want to return tags.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The resource for which you want to return tags.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p>Indicates whether to show the assigned tags.</p>
        pub fn show_assigned_lf_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.show_assigned_lf_tags(inp);
            self
        }
        /// <p>Indicates whether to show the assigned tags.</p>
        pub fn set_show_assigned_lf_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_assigned_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GrantPermissions`.
    ///
    /// <p>Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>
    /// <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GrantPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::grant_permissions_input::Builder,
    }
    impl<C, M, R> GrantPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GrantPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GrantPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GrantPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GrantPermissionsInputOperationOutputAlias,
                crate::output::GrantPermissionsOutput,
                crate::error::GrantPermissionsError,
                crate::input::GrantPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn principal(mut self, inp: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p>
        /// <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog, databases, and tables.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation resources. </p>
        pub fn permissions(mut self, inp: impl Into<crate::model::Permission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation resources. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `PermissionsWithGrantOption`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn permissions_with_grant_option(
            mut self,
            inp: impl Into<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.permissions_with_grant_option(inp);
            self
        }
        /// <p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_with_grant_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLFTags`.
    ///
    /// <p>Lists tags that the requester has permission to view. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lf_tags_input::Builder,
    }
    impl<C, M, R> ListLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLfTagsInputOperationOutputAlias,
                crate::output::ListLfTagsOutput,
                crate::error::ListLFTagsError,
                crate::input::ListLfTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account tags and shared tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share tags that the requester can view. If no resource share type is passed, lists tags in the given catalog ID that the requester has permission to view.</p>
        pub fn resource_share_type(mut self, inp: crate::model::ResourceShareType) -> Self {
            self.inner = self.inner.resource_share_type(inp);
            self
        }
        /// <p>If resource share type is <code>ALL</code>, returns both in-account tags and shared tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share tags that the requester can view. If no resource share type is passed, lists tags in the given catalog ID that the requester has permission to view.</p>
        pub fn set_resource_share_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareType>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_type(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.</p>
    /// <p>This operation returns only those permissions that have been explicitly granted.</p>
    /// <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl<C, M, R> ListPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionsInputOperationOutputAlias,
                crate::output::ListPermissionsOutput,
                crate::error::ListPermissionsError,
                crate::input::ListPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn principal(mut self, inp: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>Specifies a principal to filter the permissions returned.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn resource_type(mut self, inp: crate::model::DataLakeResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Specifies a resource type to filter the permissions returned.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::DataLakeResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>A resource where you will get a list of the principal permissions.</p>
        /// <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists the resources registered to be managed by the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `FilterConditionList`.
        ///
        /// To override the contents of this collection use [`set_filter_condition_list`](Self::set_filter_condition_list).
        ///
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn filter_condition_list(
            mut self,
            inp: impl Into<crate::model::FilterCondition>,
        ) -> Self {
            self.inner = self.inner.filter_condition_list(inp);
            self
        }
        /// <p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>
        pub fn set_filter_condition_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        ) -> Self {
            self.inner = self.inner.set_filter_condition_list(input);
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of resource results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve these resources.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDataLakeSettings`.
    ///
    /// <p>Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake Formation Permissions</a>.</p>
    ///
    /// <p>This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutDataLakeSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_data_lake_settings_input::Builder,
    }
    impl<C, M, R> PutDataLakeSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDataLakeSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDataLakeSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDataLakeSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDataLakeSettingsInputOperationOutputAlias,
                crate::output::PutDataLakeSettingsOutput,
                crate::error::PutDataLakeSettingsError,
                crate::input::PutDataLakeSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A structure representing a list of AWS Lake Formation principals designated as data lake administrators.</p>
        pub fn data_lake_settings(mut self, inp: crate::model::DataLakeSettings) -> Self {
            self.inner = self.inner.data_lake_settings(inp);
            self
        }
        /// <p>A structure representing a list of AWS Lake Formation principals designated as data lake administrators.</p>
        pub fn set_data_lake_settings(
            mut self,
            input: std::option::Option<crate::model::DataLakeSettings>,
        ) -> Self {
            self.inner = self.inner.set_data_lake_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterResource`.
    ///
    /// <p>Registers the resource as managed by the Data Catalog.</p>
    ///
    /// <p>To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.</p>
    ///
    /// <p>The following request registers a new location and gives AWS Lake Formation permission to use the service-linked role to access that location.</p>
    ///
    /// <p>
    /// <code>ResourceArn = arn:aws:s3:::my-bucket
    /// UseServiceLinkedRole = true</code>
    /// </p>
    ///
    /// <p>If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:</p>
    ///
    /// <p>
    /// <code>arn:aws:iam::12345:role/my-data-access-role</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_resource_input::Builder,
    }
    impl<C, M, R> RegisterResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterResourceInputOperationOutputAlias,
                crate::output::RegisterResourceOutput,
                crate::error::RegisterResourceError,
                crate::input::RegisterResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        ///
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn use_service_linked_role(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_service_linked_role(inp);
            self
        }
        /// <p>Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p>
        ///
        /// <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>
        pub fn set_use_service_linked_role(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_service_linked_role(input);
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The identifier for the role that registers the resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveLFTagsFromResource`.
    ///
    /// <p>Removes a tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveLFTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_lf_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveLFTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveLFTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveLfTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveLFTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveLfTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveLfTagsFromResourceOutput,
                crate::error::RemoveLFTagsFromResourceError,
                crate::input::RemoveLfTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The resource where you want to remove a tag.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The resource where you want to remove a tag.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `LFTags`.
        ///
        /// To override the contents of this collection use [`set_lf_tags`](Self::set_lf_tags).
        ///
        /// <p>The tags to be removed from the resource.</p>
        pub fn lf_tags(mut self, inp: impl Into<crate::model::LfTagPair>) -> Self {
            self.inner = self.inner.lf_tags(inp);
            self
        }
        /// <p>The tags to be removed from the resource.</p>
        pub fn set_lf_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTagPair>>,
        ) -> Self {
            self.inner = self.inner.set_lf_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokePermissions`.
    ///
    /// <p>Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_permissions_input::Builder,
    }
    impl<C, M, R> RevokePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokePermissionsInputOperationOutputAlias,
                crate::output::RevokePermissionsOutput,
                crate::error::RevokePermissionsError,
                crate::input::RevokePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn principal(mut self, inp: crate::model::DataLakePrincipal) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The principal to be revoked permissions on the resource.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The resource to which permissions are to be revoked.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security
        /// and Access Control to Metadata and Data</a>.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::Permission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security
        /// and Access Control to Metadata and Data</a>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `PermissionsWithGrantOption`.
        ///
        /// To override the contents of this collection use [`set_permissions_with_grant_option`](Self::set_permissions_with_grant_option).
        ///
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn permissions_with_grant_option(
            mut self,
            inp: impl Into<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.permissions_with_grant_option(inp);
            self
        }
        /// <p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>
        pub fn set_permissions_with_grant_option(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_with_grant_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDatabasesByLFTags`.
    ///
    /// <p>This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant, the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given <code>TagConditions</code> are valid to verify whether the returned resources can be shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchDatabasesByLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_databases_by_lf_tags_input::Builder,
    }
    impl<C, M, R> SearchDatabasesByLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDatabasesByLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDatabasesByLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDatabasesByLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDatabasesByLfTagsInputOperationOutputAlias,
                crate::output::SearchDatabasesByLfTagsOutput,
                crate::error::SearchDatabasesByLFTagsError,
                crate::input::SearchDatabasesByLfTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn expression(mut self, inp: impl Into<crate::model::LfTag>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchTablesByLFTags`.
    ///
    /// <p>This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by admins who want to grant user permissions on certain LFTags. Before making a grant, the admin can use <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify whether the returned resources can be shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchTablesByLFTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_tables_by_lf_tags_input::Builder,
    }
    impl<C, M, R> SearchTablesByLFTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchTablesByLFTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchTablesByLfTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchTablesByLFTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchTablesByLfTagsInputOperationOutputAlias,
                crate::output::SearchTablesByLfTagsOutput,
                crate::error::SearchTablesByLFTagsError,
                crate::input::SearchTablesByLfTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve this list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `Expression`.
        ///
        /// To override the contents of this collection use [`set_expression`](Self::set_expression).
        ///
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn expression(mut self, inp: impl Into<crate::model::LfTag>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LfTag>>,
        ) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLFTag`.
    ///
    /// <p>Updates the list of possible values for the specified tag key. If the tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the tag key's value.  </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLFTag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lf_tag_input::Builder,
    }
    impl<C, M, R> UpdateLFTag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLFTag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLfTagOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLFTagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLfTagInputOperationOutputAlias,
                crate::output::UpdateLfTagOutput,
                crate::error::UpdateLFTagError,
                crate::input::UpdateLfTagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The key-name for the tag for which to add or delete values.</p>
        pub fn tag_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(inp);
            self
        }
        /// <p>The key-name for the tag for which to add or delete values.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
        /// Appends an item to `TagValuesToDelete`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_delete`](Self::set_tag_values_to_delete).
        ///
        /// <p>A list of tag values to delete from the tag.</p>
        pub fn tag_values_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values_to_delete(inp);
            self
        }
        /// <p>A list of tag values to delete from the tag.</p>
        pub fn set_tag_values_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values_to_delete(input);
            self
        }
        /// Appends an item to `TagValuesToAdd`.
        ///
        /// To override the contents of this collection use [`set_tag_values_to_add`](Self::set_tag_values_to_add).
        ///
        /// <p>A list of tag values to add from the tag.</p>
        pub fn tag_values_to_add(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values_to_add(inp);
            self
        }
        /// <p>A list of tag values to add from the tag.</p>
        pub fn set_tag_values_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values_to_add(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResource`.
    ///
    /// <p>Updates the data access role used for vending access to the given (registered) resource in AWS Lake Formation. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_input::Builder,
    }
    impl<C, M, R> UpdateResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceInputOperationOutputAlias,
                crate::output::UpdateResourceOutput,
                crate::error::UpdateResourceError,
                crate::input::UpdateResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The new role to use for the given resource registered in AWS Lake Formation.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The new role to use for the given resource registered in AWS Lake Formation.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
