// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_key_deletion_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelKeyDeletionOutput, crate::error::CancelKeyDeletionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelKeyDeletionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelKeyDeletionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::CancelKeyDeletionError {
            meta: generic,
            kind: crate::error::CancelKeyDeletionErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::CancelKeyDeletionError {
            meta: generic,
            kind: crate::error::CancelKeyDeletionErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::CancelKeyDeletionError {
            meta: generic,
            kind: crate::error::CancelKeyDeletionErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::CancelKeyDeletionError {
            meta: generic,
            kind: crate::error::CancelKeyDeletionErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CancelKeyDeletionError {
            meta: generic,
            kind: crate::error::CancelKeyDeletionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelKeyDeletionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_key_deletion_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelKeyDeletionOutput, crate::error::CancelKeyDeletionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_key_deletion_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_key_deletion(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelKeyDeletionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_connect_custom_key_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConnectCustomKeyStoreOutput,
    crate::error::ConnectCustomKeyStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConnectCustomKeyStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudHsmClusterInvalidConfigurationException" => crate::error::ConnectCustomKeyStoreError { meta: generic, kind: crate::error::ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_invalid_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotActiveException" => crate::error::ConnectCustomKeyStoreError { meta: generic, kind: crate::error::ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreInvalidStateException" => crate::error::ConnectCustomKeyStoreError { meta: generic, kind: crate::error::ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreNotFoundException" => crate::error::ConnectCustomKeyStoreError { meta: generic, kind: crate::error::ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSInternalException" => crate::error::ConnectCustomKeyStoreError { meta: generic, kind: crate::error::ConnectCustomKeyStoreErrorKind::KmsInternalException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ConnectCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ConnectCustomKeyStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_connect_custom_key_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConnectCustomKeyStoreOutput,
    crate::error::ConnectCustomKeyStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::connect_custom_key_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyTimeoutException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidAliasNameException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::InvalidAliasNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_alias_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_alias_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_key_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomKeyStoreOutput,
    crate::error::CreateCustomKeyStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCustomKeyStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudHsmClusterInUseException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterInvalidConfigurationException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_invalid_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotActiveException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotFoundException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreNameInUseException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IncorrectTrustAnchorException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::incorrect_trust_anchor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_trust_anchor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSInternalException" => crate::error::CreateCustomKeyStoreError { meta: generic, kind: crate::error::CreateCustomKeyStoreErrorKind::KmsInternalException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCustomKeyStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_key_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomKeyStoreOutput,
    crate::error::CreateCustomKeyStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_custom_key_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_custom_key_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCustomKeyStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_grant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGrantOutput, crate::error::CreateGrantError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGrantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGrantError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::CreateGrantError {
                meta: generic,
                kind: crate::error::CreateGrantErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantTokenException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateGrantError {
            meta: generic,
            kind: crate::error::CreateGrantErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGrantError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_grant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGrantOutput, crate::error::CreateGrantError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_grant_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_grant(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGrantError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyOutput, crate::error::CreateKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudHsmClusterInvalidConfigurationException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_invalid_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CustomKeyStoreInvalidStateException" => {
            crate::error::CreateKeyError {
                meta: generic,
                kind: crate::error::CreateKeyErrorKind::CustomKeyStoreInvalidStateException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "CustomKeyStoreNotFoundException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::CustomKeyStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::custom_key_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyTimeoutException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::TagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::CreateKeyError {
            meta: generic,
            kind: crate::error::CreateKeyErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyOutput, crate::error::CreateKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrypt_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DecryptOutput, crate::error::DecryptError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DecryptError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DecryptError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::DecryptError {
                meta: generic,
                kind: crate::error::DecryptErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "IncorrectKeyException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::IncorrectKeyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incorrect_key_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_key_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCiphertextException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::InvalidCiphertextException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_ciphertext_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ciphertext_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantTokenException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DecryptError {
            meta: generic,
            kind: crate::error::DecryptErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DecryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DecryptError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_decrypt_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DecryptOutput, crate::error::DecryptError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::decrypt_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_decrypt(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DecryptError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_key_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomKeyStoreOutput,
    crate::error::DeleteCustomKeyStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomKeyStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCustomKeyStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomKeyStoreHasCMKsException" => crate::error::DeleteCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::custom_key_store_has_cm_ks_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_has_cm_ks_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomKeyStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CustomKeyStoreInvalidStateException" => crate::error::DeleteCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomKeyStoreError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "CustomKeyStoreNotFoundException" => crate::error::DeleteCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::custom_key_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomKeyStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DeleteCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DeleteCustomKeyStoreErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomKeyStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCustomKeyStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_key_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomKeyStoreOutput,
    crate::error::DeleteCustomKeyStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_custom_key_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_imported_key_material_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteImportedKeyMaterialOutput,
    crate::error::DeleteImportedKeyMaterialError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteImportedKeyMaterialError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::DeleteImportedKeyMaterialError {
            meta: generic,
            kind: crate::error::DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteImportedKeyMaterialError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteImportedKeyMaterialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_imported_key_material_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteImportedKeyMaterialOutput,
    crate::error::DeleteImportedKeyMaterialError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_imported_key_material_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_key_stores_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomKeyStoresOutput,
    crate::error::DescribeCustomKeyStoresError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCustomKeyStoresError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCustomKeyStoresError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomKeyStoreNotFoundException" => crate::error::DescribeCustomKeyStoresError {
            meta: generic,
            kind: crate::error::DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::custom_key_store_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomKeyStoresError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidMarkerException" => crate::error::DescribeCustomKeyStoresError {
            meta: generic,
            kind: crate::error::DescribeCustomKeyStoresErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomKeyStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DescribeCustomKeyStoresError {
            meta: generic,
            kind: crate::error::DescribeCustomKeyStoresErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomKeyStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCustomKeyStoresError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_key_stores_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomKeyStoresOutput,
    crate::error::DescribeCustomKeyStoresError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_custom_key_stores_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_custom_key_stores(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCustomKeyStoresError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeKeyOutput, crate::error::DescribeKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DescribeKeyError {
            meta: generic,
            kind: crate::error::DescribeKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::DescribeKeyError {
            meta: generic,
            kind: crate::error::DescribeKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DescribeKeyError {
            meta: generic,
            kind: crate::error::DescribeKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DescribeKeyError {
            meta: generic,
            kind: crate::error::DescribeKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeKeyOutput, crate::error::DescribeKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableKeyOutput, crate::error::DisableKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DisableKeyError {
            meta: generic,
            kind: crate::error::DisableKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::DisableKeyError {
            meta: generic,
            kind: crate::error::DisableKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DisableKeyError {
            meta: generic,
            kind: crate::error::DisableKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::DisableKeyError {
            meta: generic,
            kind: crate::error::DisableKeyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DisableKeyError {
            meta: generic,
            kind: crate::error::DisableKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableKeyOutput, crate::error::DisableKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_key_rotation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableKeyRotationOutput,
    crate::error::DisableKeyRotationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableKeyRotationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableKeyRotationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::DisableKeyRotationError {
                meta: generic,
                kind: crate::error::DisableKeyRotationErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::DisableKeyRotationError {
            meta: generic,
            kind: crate::error::DisableKeyRotationErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableKeyRotationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_key_rotation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableKeyRotationOutput,
    crate::error::DisableKeyRotationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_key_rotation_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disconnect_custom_key_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisconnectCustomKeyStoreOutput,
    crate::error::DisconnectCustomKeyStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisconnectCustomKeyStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisconnectCustomKeyStoreError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomKeyStoreInvalidStateException" => crate::error::DisconnectCustomKeyStoreError {
            meta: generic,
            kind:
                crate::error::DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectCustomKeyStoreError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "CustomKeyStoreNotFoundException" => crate::error::DisconnectCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::custom_key_store_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectCustomKeyStoreError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "KMSInternalException" => crate::error::DisconnectCustomKeyStoreError {
            meta: generic,
            kind: crate::error::DisconnectCustomKeyStoreErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectCustomKeyStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisconnectCustomKeyStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disconnect_custom_key_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisconnectCustomKeyStoreOutput,
    crate::error::DisconnectCustomKeyStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disconnect_custom_key_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableKeyOutput, crate::error::EnableKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::EnableKeyError {
            meta: generic,
            kind: crate::error::EnableKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableKeyOutput, crate::error::EnableKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_key_rotation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableKeyRotationOutput, crate::error::EnableKeyRotationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableKeyRotationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableKeyRotationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::EnableKeyRotationError {
                meta: generic,
                kind: crate::error::EnableKeyRotationErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::EnableKeyRotationError {
            meta: generic,
            kind: crate::error::EnableKeyRotationErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKeyRotationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableKeyRotationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_key_rotation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableKeyRotationOutput, crate::error::EnableKeyRotationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_key_rotation_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_encrypt_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EncryptOutput, crate::error::EncryptError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EncryptError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EncryptError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::EncryptError {
                meta: generic,
                kind: crate::error::EncryptErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::EncryptError {
            meta: generic,
            kind: crate::error::EncryptErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EncryptError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_encrypt_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EncryptOutput, crate::error::EncryptError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::encrypt_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_encrypt(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EncryptError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateDataKeyOutput, crate::error::GenerateDataKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateDataKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateDataKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::GenerateDataKeyError {
                meta: generic,
                kind: crate::error::GenerateDataKeyErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GenerateDataKeyError {
            meta: generic,
            kind: crate::error::GenerateDataKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateDataKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateDataKeyOutput, crate::error::GenerateDataKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_data_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_data_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateDataKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyPairOutput,
    crate::error::GenerateDataKeyPairError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateDataKeyPairError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::GenerateDataKeyPairError {
                meta: generic,
                kind: crate::error::GenerateDataKeyPairErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GenerateDataKeyPairError {
            meta: generic,
            kind: crate::error::GenerateDataKeyPairErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateDataKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyPairOutput,
    crate::error::GenerateDataKeyPairError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_data_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_data_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateDataKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_pair_without_plaintext_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyPairWithoutPlaintextOutput,
    crate::error::GenerateDataKeyPairWithoutPlaintextError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DisabledException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGrantTokenException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidKeyUsageException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KeyUnavailableException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSInternalException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSInvalidStateException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::GenerateDataKeyPairWithoutPlaintextError { meta: generic, kind: crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GenerateDataKeyPairWithoutPlaintextError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_pair_without_plaintext_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyPairWithoutPlaintextOutput,
    crate::error::GenerateDataKeyPairWithoutPlaintextError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::generate_data_key_pair_without_plaintext_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_data_key_pair_without_plaintext(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyPairWithoutPlaintextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_without_plaintext_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyWithoutPlaintextOutput,
    crate::error::GenerateDataKeyWithoutPlaintextError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind:
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::dependency_timeout_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DisabledException" => {
            crate::error::GenerateDataKeyWithoutPlaintextError {
                meta: generic,
                kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind:
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_grant_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidKeyUsageException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_key_usage_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "KeyUnavailableException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::key_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "KMSInternalException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::kms_invalid_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::GenerateDataKeyWithoutPlaintextError {
            meta: generic,
            kind: crate::error::GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateDataKeyWithoutPlaintextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_data_key_without_plaintext_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateDataKeyWithoutPlaintextOutput,
    crate::error::GenerateDataKeyWithoutPlaintextError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::generate_data_key_without_plaintext_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_generate_data_key_without_plaintext(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GenerateDataKeyWithoutPlaintextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_random_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateRandomOutput, crate::error::GenerateRandomError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateRandomError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateRandomError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomKeyStoreInvalidStateException" => {
            crate::error::GenerateRandomError {
                meta: generic,
                kind: crate::error::GenerateRandomErrorKind::CustomKeyStoreInvalidStateException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateRandomError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "CustomKeyStoreNotFoundException" => crate::error::GenerateRandomError {
            meta: generic,
            kind: crate::error::GenerateRandomErrorKind::CustomKeyStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::custom_key_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateRandomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyTimeoutException" => crate::error::GenerateRandomError {
            meta: generic,
            kind: crate::error::GenerateRandomErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateRandomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GenerateRandomError {
            meta: generic,
            kind: crate::error::GenerateRandomErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateRandomError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateRandomError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_random_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateRandomOutput, crate::error::GenerateRandomError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_random_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_random(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateRandomError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPolicyOutput, crate::error::GetKeyPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GetKeyPolicyError {
            meta: generic,
            kind: crate::error::GetKeyPolicyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::GetKeyPolicyError {
            meta: generic,
            kind: crate::error::GetKeyPolicyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GetKeyPolicyError {
            meta: generic,
            kind: crate::error::GetKeyPolicyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GetKeyPolicyError {
            meta: generic,
            kind: crate::error::GetKeyPolicyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetKeyPolicyError {
            meta: generic,
            kind: crate::error::GetKeyPolicyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPolicyOutput, crate::error::GetKeyPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_key_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetKeyPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_rotation_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetKeyRotationStatusOutput,
    crate::error::GetKeyRotationStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyRotationStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetKeyRotationStatusError {
            meta: generic,
            kind: crate::error::GetKeyRotationStatusErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyRotationStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_rotation_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetKeyRotationStatusOutput,
    crate::error::GetKeyRotationStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_rotation_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_key_rotation_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetKeyRotationStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_parameters_for_import_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetParametersForImportOutput,
    crate::error::GetParametersForImportError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetParametersForImportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetParametersForImportError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetParametersForImportError {
            meta: generic,
            kind: crate::error::GetParametersForImportErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetParametersForImportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetParametersForImportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_parameters_for_import_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetParametersForImportOutput,
    crate::error::GetParametersForImportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_parameters_for_import_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_parameters_for_import(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetParametersForImportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::GetPublicKeyError {
                meta: generic,
                kind: crate::error::GetPublicKeyErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantTokenException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_public_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_public_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPublicKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_key_material_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportKeyMaterialOutput, crate::error::ImportKeyMaterialError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportKeyMaterialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportKeyMaterialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExpiredImportTokenException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::ExpiredImportTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::expired_import_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_import_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectKeyMaterialException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::IncorrectKeyMaterialException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_key_material_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_key_material_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCiphertextException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::InvalidCiphertextException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_ciphertext_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ciphertext_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidImportTokenException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::InvalidImportTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_import_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_import_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ImportKeyMaterialError {
            meta: generic,
            kind: crate::error::ImportKeyMaterialErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyMaterialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportKeyMaterialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_key_material_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportKeyMaterialOutput, crate::error::ImportKeyMaterialError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_key_material_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAliasesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMarkerException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_aliases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_grants_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGrantsOutput, crate::error::ListGrantsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGrantsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGrantsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantIdException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::InvalidGrantIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_grant_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMarkerException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ListGrantsError {
            meta: generic,
            kind: crate::error::ListGrantsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGrantsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_grants_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGrantsOutput, crate::error::ListGrantsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_grants_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_grants(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGrantsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeyPoliciesOutput, crate::error::ListKeyPoliciesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListKeyPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListKeyPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ListKeyPoliciesError {
            meta: generic,
            kind: crate::error::ListKeyPoliciesErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ListKeyPoliciesError {
            meta: generic,
            kind: crate::error::ListKeyPoliciesErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListKeyPoliciesError {
            meta: generic,
            kind: crate::error::ListKeyPoliciesErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ListKeyPoliciesError {
            meta: generic,
            kind: crate::error::ListKeyPoliciesErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ListKeyPoliciesError {
            meta: generic,
            kind: crate::error::ListKeyPoliciesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeyPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListKeyPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeyPoliciesOutput, crate::error::ListKeyPoliciesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_key_policies_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_key_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListKeyPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeysOutput, crate::error::ListKeysError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ListKeysError {
            meta: generic,
            kind: crate::error::ListKeysErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMarkerException" => crate::error::ListKeysError {
            meta: generic,
            kind: crate::error::ListKeysErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListKeysError {
            meta: generic,
            kind: crate::error::ListKeysErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeysOutput, crate::error::ListKeysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_keys_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resource_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListResourceTagsOutput, crate::error::ListResourceTagsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourceTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListResourceTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArnException" => crate::error::ListResourceTagsError {
            meta: generic,
            kind: crate::error::ListResourceTagsErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMarkerException" => crate::error::ListResourceTagsError {
            meta: generic,
            kind: crate::error::ListResourceTagsErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListResourceTagsError {
            meta: generic,
            kind: crate::error::ListResourceTagsErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ListResourceTagsError {
            meta: generic,
            kind: crate::error::ListResourceTagsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListResourceTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resource_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListResourceTagsOutput, crate::error::ListResourceTagsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resource_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resource_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourceTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_retirable_grants_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRetirableGrantsOutput,
    crate::error::ListRetirableGrantsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRetirableGrantsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRetirableGrantsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ListRetirableGrantsError {
            meta: generic,
            kind: crate::error::ListRetirableGrantsErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRetirableGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ListRetirableGrantsError {
            meta: generic,
            kind: crate::error::ListRetirableGrantsErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRetirableGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMarkerException" => crate::error::ListRetirableGrantsError {
            meta: generic,
            kind: crate::error::ListRetirableGrantsErrorKind::InvalidMarkerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_marker_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_marker_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRetirableGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ListRetirableGrantsError {
            meta: generic,
            kind: crate::error::ListRetirableGrantsErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRetirableGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ListRetirableGrantsError {
            meta: generic,
            kind: crate::error::ListRetirableGrantsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRetirableGrantsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRetirableGrantsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_retirable_grants_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRetirableGrantsOutput,
    crate::error::ListRetirableGrantsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_retirable_grants_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_retirable_grants(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRetirableGrantsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_key_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutKeyPolicyOutput, crate::error::PutKeyPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutKeyPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutKeyPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::PutKeyPolicyError {
            meta: generic,
            kind: crate::error::PutKeyPolicyErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutKeyPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutKeyPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_key_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutKeyPolicyOutput, crate::error::PutKeyPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_key_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_re_encrypt_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReEncryptOutput, crate::error::ReEncryptError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReEncryptError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReEncryptError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::ReEncryptError {
                meta: generic,
                kind: crate::error::ReEncryptErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "IncorrectKeyException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::IncorrectKeyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::incorrect_key_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_key_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCiphertextException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::InvalidCiphertextException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_ciphertext_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_ciphertext_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantTokenException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ReEncryptError {
            meta: generic,
            kind: crate::error::ReEncryptErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReEncryptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReEncryptError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_re_encrypt_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReEncryptOutput, crate::error::ReEncryptError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::re_encrypt_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_re_encrypt(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReEncryptError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_replicate_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReplicateKeyOutput, crate::error::ReplicateKeyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReplicateKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReplicateKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExistsException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::ReplicateKeyError {
                meta: generic,
                kind: crate::error::ReplicateKeyErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocumentException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_malformed_policy_document_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::TagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ReplicateKeyError {
            meta: generic,
            kind: crate::error::ReplicateKeyErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReplicateKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReplicateKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_replicate_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReplicateKeyOutput, crate::error::ReplicateKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::replicate_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_replicate_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReplicateKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retire_grant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RetireGrantOutput, crate::error::RetireGrantError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RetireGrantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RetireGrantError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantIdException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::InvalidGrantIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_grant_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantTokenException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RetireGrantError {
            meta: generic,
            kind: crate::error::RetireGrantErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RetireGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RetireGrantError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_retire_grant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RetireGrantOutput, crate::error::RetireGrantError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::retire_grant_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_grant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeGrantOutput, crate::error::RevokeGrantError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeGrantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeGrantError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGrantIdException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::InvalidGrantIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_grant_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RevokeGrantError {
            meta: generic,
            kind: crate::error::RevokeGrantErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RevokeGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeGrantError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_grant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RevokeGrantOutput, crate::error::RevokeGrantError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_grant_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_schedule_key_deletion_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ScheduleKeyDeletionOutput,
    crate::error::ScheduleKeyDeletionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ScheduleKeyDeletionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::ScheduleKeyDeletionError {
            meta: generic,
            kind: crate::error::ScheduleKeyDeletionErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::ScheduleKeyDeletionError {
            meta: generic,
            kind: crate::error::ScheduleKeyDeletionErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::ScheduleKeyDeletionError {
            meta: generic,
            kind: crate::error::ScheduleKeyDeletionErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::ScheduleKeyDeletionError {
            meta: generic,
            kind: crate::error::ScheduleKeyDeletionErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ScheduleKeyDeletionError {
            meta: generic,
            kind: crate::error::ScheduleKeyDeletionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ScheduleKeyDeletionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_schedule_key_deletion_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ScheduleKeyDeletionOutput,
    crate::error::ScheduleKeyDeletionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::schedule_key_deletion_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_schedule_key_deletion(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ScheduleKeyDeletionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_sign_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignOutput, crate::error::SignError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SignError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SignError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::SignError {
                meta: generic,
                kind: crate::error::SignErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::SignError {
            meta: generic,
            kind: crate::error::SignErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SignError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SignError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_sign_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SignOutput, crate::error::SignError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::sign_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_sign(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SignError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArnException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArnException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_key_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomKeyStoreOutput,
    crate::error::UpdateCustomKeyStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateCustomKeyStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudHsmClusterInvalidConfigurationException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_invalid_configuration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotActiveException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotFoundException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudHsmClusterNotRelatedException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_hsm_cluster_not_related_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_hsm_cluster_not_related_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreInvalidStateException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreNameInUseException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_name_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_name_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomKeyStoreNotFoundException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_key_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_custom_key_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSInternalException" => crate::error::UpdateCustomKeyStoreError { meta: generic, kind: crate::error::UpdateCustomKeyStoreErrorKind::KmsInternalException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomKeyStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateCustomKeyStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_key_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomKeyStoreOutput,
    crate::error::UpdateCustomKeyStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_custom_key_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_key_description_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateKeyDescriptionOutput,
    crate::error::UpdateKeyDescriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateKeyDescriptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::UpdateKeyDescriptionError {
            meta: generic,
            kind: crate::error::UpdateKeyDescriptionErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArnException" => crate::error::UpdateKeyDescriptionError {
            meta: generic,
            kind: crate::error::UpdateKeyDescriptionErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::UpdateKeyDescriptionError {
            meta: generic,
            kind: crate::error::UpdateKeyDescriptionErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::UpdateKeyDescriptionError {
            meta: generic,
            kind: crate::error::UpdateKeyDescriptionErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdateKeyDescriptionError {
            meta: generic,
            kind: crate::error::UpdateKeyDescriptionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateKeyDescriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_key_description_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateKeyDescriptionOutput,
    crate::error::UpdateKeyDescriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_key_description_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_primary_region_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePrimaryRegionOutput,
    crate::error::UpdatePrimaryRegionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePrimaryRegionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DisabledException" => {
            crate::error::UpdatePrimaryRegionError {
                meta: generic,
                kind: crate::error::UpdatePrimaryRegionErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidArnException" => crate::error::UpdatePrimaryRegionError {
            meta: generic,
            kind: crate::error::UpdatePrimaryRegionErrorKind::InvalidArnException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::UpdatePrimaryRegionError {
            meta: generic,
            kind: crate::error::UpdatePrimaryRegionErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::UpdatePrimaryRegionError {
            meta: generic,
            kind: crate::error::UpdatePrimaryRegionErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::UpdatePrimaryRegionError {
            meta: generic,
            kind: crate::error::UpdatePrimaryRegionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::UpdatePrimaryRegionError {
            meta: generic,
            kind: crate::error::UpdatePrimaryRegionErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdatePrimaryRegionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdatePrimaryRegionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_primary_region_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePrimaryRegionOutput,
    crate::error::UpdatePrimaryRegionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_primary_region_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyOutput, crate::error::VerifyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::VerifyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependencyTimeoutException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::DependencyTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledException" => {
            crate::error::VerifyError {
                meta: generic,
                kind: crate::error::VerifyErrorKind::DisabledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::disabled_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidGrantTokenException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::InvalidGrantTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_grant_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_grant_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidKeyUsageException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::InvalidKeyUsageException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_key_usage_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_key_usage_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyUnavailableException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::KeyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_key_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInternalException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::KmsInternalException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_internal_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_internal_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidSignatureException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::KmsInvalidSignatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::kms_invalid_signature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_signature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::VerifyError {
            meta: generic,
            kind: crate::error::VerifyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::VerifyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::VerifyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyOutput, crate::error::VerifyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_verify(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::VerifyError::unhandled)?;
        output.build()
    })
}
