// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Key Management Service
///
/// Client for invoking operations on AWS Key Management Service. Each operation on AWS Key Management Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_kms::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_kms::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_kms::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelKeyDeletion`](crate::client::fluent_builders::CancelKeyDeletion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::CancelKeyDeletion::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::CancelKeyDeletion::set_key_id): <p>Identifies the KMS key whose deletion is being canceled.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`CancelKeyDeletionOutput`](crate::output::CancelKeyDeletionOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::CancelKeyDeletionOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is canceled.</p>
    /// - On failure, responds with [`SdkError<CancelKeyDeletionError>`](crate::error::CancelKeyDeletionError)
    pub fn cancel_key_deletion(&self) -> fluent_builders::CancelKeyDeletion {
        fluent_builders::CancelKeyDeletion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConnectCustomKeyStore`](crate::client::fluent_builders::ConnectCustomKeyStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::ConnectCustomKeyStore::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::ConnectCustomKeyStore::set_custom_key_store_id): <p>Enter the key store ID of the custom key store that you want to connect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// - On success, responds with [`ConnectCustomKeyStoreOutput`](crate::output::ConnectCustomKeyStoreOutput)

    /// - On failure, responds with [`SdkError<ConnectCustomKeyStoreError>`](crate::error::ConnectCustomKeyStoreError)
    pub fn connect_custom_key_store(&self) -> fluent_builders::ConnectCustomKeyStore {
        fluent_builders::ConnectCustomKeyStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAlias`](crate::client::fluent_builders::CreateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_alias_name): <p>Specifies the alias name. This value must begin with <code>alias/</code> followed by a name, such as <code>alias/ExampleAlias</code>. </p>  <p>The <code>AliasName</code> value must be string of 1-256 characters. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). The alias name cannot begin with <code>alias/aws/</code>. The <code>alias/aws/</code> prefix is reserved for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>.</p>
    ///   - [`target_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::target_key_id) / [`set_target_key_id(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_target_key_id): <p>Associates the alias with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>. The KMS key must be in the same Amazon Web Services Region. </p>  <p>A valid key ID is required. If you supply a null or empty string value, this operation returns an error.</p>  <p>For help finding the key ID and ARN, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn">Finding the Key ID and ARN</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`CreateAliasOutput`](crate::output::CreateAliasOutput)

    /// - On failure, responds with [`SdkError<CreateAliasError>`](crate::error::CreateAliasError)
    pub fn create_alias(&self) -> fluent_builders::CreateAlias {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomKeyStore`](crate::client::fluent_builders::CreateCustomKeyStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::custom_key_store_name) / [`set_custom_key_store_name(Option<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::set_custom_key_store_name): <p>Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account.</p>
    ///   - [`cloud_hsm_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::cloud_hsm_cluster_id) / [`set_cloud_hsm_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::set_cloud_hsm_cluster_id): <p>Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    ///   - [`trust_anchor_certificate(impl Into<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::trust_anchor_certificate) / [`set_trust_anchor_certificate(Option<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::set_trust_anchor_certificate): <p>Enter the content of the trust anchor certificate for the cluster. This is the content of the <code>customerCA.crt</code> file that you created when you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the cluster</a>.</p>
    ///   - [`key_store_password(impl Into<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::key_store_password) / [`set_key_store_password(Option<String>)`](crate::client::fluent_builders::CreateCustomKeyStore::set_key_store_password): <p>Enter the password of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user (CU) account</a> in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.</p>  <p>The password must be a string of 7 to 32 characters. Its value is case sensitive.</p>  <p>This parameter tells KMS the <code>kmsuser</code> account password; it does not change the password in the CloudHSM cluster.</p>
    /// - On success, responds with [`CreateCustomKeyStoreOutput`](crate::output::CreateCustomKeyStoreOutput) with field(s):
    ///   - [`custom_key_store_id(Option<String>)`](crate::output::CreateCustomKeyStoreOutput::custom_key_store_id): <p>A unique identifier for the new custom key store.</p>
    /// - On failure, responds with [`SdkError<CreateCustomKeyStoreError>`](crate::error::CreateCustomKeyStoreError)
    pub fn create_custom_key_store(&self) -> fluent_builders::CreateCustomKeyStore {
        fluent_builders::CreateCustomKeyStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGrant`](crate::client::fluent_builders::CreateGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_key_id): <p>Identifies the KMS key for the grant. The grant gives principals permission to use this KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`grantee_principal(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::grantee_principal) / [`set_grantee_principal(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_grantee_principal): <p>The identity that gets the permissions specified in the grant.</p>  <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, IAM roles, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`retiring_principal(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::retiring_principal) / [`set_retiring_principal(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_retiring_principal): <p>The principal that has permission to use the <code>RetireGrant</code> operation to retire the grant. </p>  <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>  <p>The grant determines the retiring principal. Other principals might have permission to retire the grant or revoke the grant. For details, see <code>RevokeGrant</code> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete">Retiring and revoking grants</a> in the <i>Key Management Service Developer Guide</i>. </p>
    ///   - [`operations(Vec<GrantOperation>)`](crate::client::fluent_builders::CreateGrant::operations) / [`set_operations(Option<Vec<GrantOperation>>)`](crate::client::fluent_builders::CreateGrant::set_operations): <p>A list of operations that the grant permits. </p>  <p>The operation must be supported on the KMS key. For example, you cannot create a grant for a symmetric KMS key that allows the <code>Sign</code> operation, or a grant for an asymmetric KMS key that allows the <code>GenerateDataKey</code> operation. If you try, KMS returns a <code>ValidationError</code> exception. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations">Grant operations</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`constraints(GrantConstraints)`](crate::client::fluent_builders::CreateGrant::constraints) / [`set_constraints(Option<GrantConstraints>)`](crate::client::fluent_builders::CreateGrant::set_constraints): <p>Specifies a grant constraint. </p>  <p>KMS supports the <code>EncryptionContextEquals</code> and <code>EncryptionContextSubset</code> grant constraints. Each constraint value can include up to 8 encryption context pairs. The encryption context value in each constraint cannot exceed 384 characters.</p>  <p>These grant constraints allow the permissions in the grant only when the encryption context in the request matches (<code>EncryptionContextEquals</code>) or includes (<code>EncryptionContextSubset</code>) the encryption context specified in this structure. For information about grant constraints, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-grant-overview.html#grant-constraints">Using grant constraints</a> in the <i>Key Management Service Developer Guide</i>. For more information about encryption context, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. </p>  <p>The encryption context grant constraints are supported only on operations that include an encryption context. You cannot use an encryption context grant constraint for cryptographic operations with asymmetric KMS keys or for management operations, such as <code>DescribeKey</code> or <code>RetireGrant</code>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::CreateGrant::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::CreateGrant::set_grant_tokens): <p>A list of grant tokens. </p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_name): <p>A friendly name for the grant. Use this value to prevent the unintended creation of duplicate grants when retrying this request.</p>  <p>When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended duplicates when you retry the <code>CreateGrant</code> request.</p>  <p>When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if the grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note that the returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate <code>GrantId</code> is returned. All grant tokens for the same grant ID can be used interchangeably.</p>
    /// - On success, responds with [`CreateGrantOutput`](crate::output::CreateGrantOutput) with field(s):
    ///   - [`grant_token(Option<String>)`](crate::output::CreateGrantOutput::grant_token): <p>The grant token.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`grant_id(Option<String>)`](crate::output::CreateGrantOutput::grant_id): <p>The unique identifier for the grant.</p>  <p>You can use the <code>GrantId</code> in a <code>ListGrants</code>, <code>RetireGrant</code>, or <code>RevokeGrant</code> operation.</p>
    /// - On failure, responds with [`SdkError<CreateGrantError>`](crate::error::CreateGrantError)
    pub fn create_grant(&self) -> fluent_builders::CreateGrant {
        fluent_builders::CreateGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKey`](crate::client::fluent_builders::CreateKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateKey::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateKey::set_policy): <p>The key policy to attach to the KMS key.</p>  <p>If you provide a key policy, it must meet the following criteria:</p>  <ul>   <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>CreateKey</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>   <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>  </ul>  <p>If you do not provide a key policy, KMS attaches a default key policy to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default Key Policy</a> in the <i>Key Management Service Developer Guide</i>. </p>  <p>The key policy size quota is 32 kilobytes (32768 bytes).</p>  <p>For help writing and formatting a JSON policy document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateKey::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateKey::set_description): <p>A description of the KMS key.</p>  <p>Use a description that helps you decide whether the KMS key is appropriate for a task. The default value is an empty string (no description).</p>  <p>To set or change the description after the key is created, use <code>UpdateKeyDescription</code>.</p>
    ///   - [`key_usage(KeyUsageType)`](crate::client::fluent_builders::CreateKey::key_usage) / [`set_key_usage(Option<KeyUsageType>)`](crate::client::fluent_builders::CreateKey::set_key_usage): <p>Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code>. This parameter is required only for asymmetric KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.</p>  <p>Select only one valid value.</p>  <ul>   <li> <p>For symmetric KMS keys, omit the parameter or specify <code>ENCRYPT_DECRYPT</code>.</p> </li>   <li> <p>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code>.</p> </li>   <li> <p>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code>.</p> </li>  </ul>
    ///   - [`customer_master_key_spec(CustomerMasterKeySpec)`](crate::client::fluent_builders::CreateKey::customer_master_key_spec) / [`set_customer_master_key_spec(Option<CustomerMasterKeySpec>)`](crate::client::fluent_builders::CreateKey::set_customer_master_key_spec): <p>Instead, use the <code>KeySpec</code> parameter.</p>  <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> parameters work the same way. Only the names differ. We recommend that you use <code>KeySpec</code> parameter in your code. However, to avoid breaking changes, KMS will support both parameters.</p>
    ///   - [`key_spec(KeySpec)`](crate::client::fluent_builders::CreateKey::key_spec) / [`set_key_spec(Option<KeySpec>)`](crate::client::fluent_builders::CreateKey::set_key_spec): <p>Specifies the type of KMS key to create. The default value, <code>SYMMETRIC_DEFAULT</code>, creates a KMS key with a 256-bit symmetric key for encryption and decryption. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">How to Choose Your KMS key Configuration</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>  <p>The <code>KeySpec</code> determines whether the KMS key contains a symmetric key or an asymmetric key pair. It also determines the encryption algorithms or signing algorithms that the KMS key supports. You can't change the <code>KeySpec</code> after the KMS key is created. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm">kms:EncryptionAlgorithm</a> or <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm">kms:Signing Algorithm</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p> <important>   <p> <a href="http://aws.amazon.com/kms/features/#AWS_Service_Integration">Amazon Web Services services that are integrated with KMS</a> use symmetric KMS keys to protect your data. These services do not support asymmetric KMS keys. For help determining whether a KMS key is symmetric or asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>  </important>  <p>KMS supports the following key specs for KMS keys:</p>  <ul>   <li> <p>Symmetric key (default)</p>    <ul>     <li> <p> <code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</p> </li>    </ul> </li>   <li> <p>Asymmetric RSA key pairs</p>    <ul>     <li> <p> <code>RSA_2048</code> </p> </li>     <li> <p> <code>RSA_3072</code> </p> </li>     <li> <p> <code>RSA_4096</code> </p> </li>    </ul> </li>   <li> <p>Asymmetric NIST-recommended elliptic curve key pairs</p>    <ul>     <li> <p> <code>ECC_NIST_P256</code> (secp256r1)</p> </li>     <li> <p> <code>ECC_NIST_P384</code> (secp384r1)</p> </li>     <li> <p> <code>ECC_NIST_P521</code> (secp521r1)</p> </li>    </ul> </li>   <li> <p>Other asymmetric elliptic curve key pairs</p>    <ul>     <li> <p> <code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</p> </li>    </ul> </li>  </ul>
    ///   - [`origin(OriginType)`](crate::client::fluent_builders::CreateKey::origin) / [`set_origin(Option<OriginType>)`](crate::client::fluent_builders::CreateKey::set_origin): <p>The source of the key material for the KMS key. You cannot change the origin after you create the KMS key. The default is <code>AWS_KMS</code>, which means that KMS creates the key material.</p>  <p>To create a KMS key with no key material (for imported key material), set the value to <code>EXTERNAL</code>. For more information about importing key material into KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>. This value is valid only for symmetric KMS keys.</p>  <p>To create a KMS key in an KMS <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and create its key material in the associated CloudHSM cluster, set this value to <code>AWS_CLOUDHSM</code>. You must also use the <code>CustomKeyStoreId</code> parameter to identify the custom key store. This value is valid only for symmetric KMS keys.</p>
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::CreateKey::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::CreateKey::set_custom_key_store_id): <p>Creates the KMS key in the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and the key material in its associated CloudHSM cluster. To create a KMS key in a custom key store, you must also specify the <code>Origin</code> parameter with a value of <code>AWS_CLOUDHSM</code>. The CloudHSM cluster that is associated with the custom key store must have at least two active HSMs, each in a different Availability Zone in the Region.</p>  <p>This parameter is valid only for symmetric KMS keys and regional KMS keys. You cannot create an asymmetric KMS key or a multi-Region key in a custom key store.</p>  <p>To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>  <p>The response includes the custom key store ID and the ID of the CloudHSM cluster.</p>  <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    ///   - [`bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::CreateKey::bypass_policy_lockout_safety_check) / [`set_bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::CreateKey::set_bypass_policy_lockout_safety_check): <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>   <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>   <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>  </important>  <p>Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>  <p>The default value is false.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateKey::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateKey::set_tags): <p>Assigns one or more tags to the KMS key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>   <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>  </note>  <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>  <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>  <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
    ///   - [`multi_region(bool)`](crate::client::fluent_builders::CreateKey::multi_region) / [`set_multi_region(Option<bool>)`](crate::client::fluent_builders::CreateKey::set_multi_region): <p>Creates a multi-Region primary key that you can replicate into other Amazon Web Services Regions. You cannot change this value after you create the KMS key. </p>  <p>For a multi-Region key, set this parameter to <code>True</code>. For a single-Region KMS key, omit this parameter or set it to <code>False</code>. The default value is <code>False</code>.</p>  <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>  <p>This value creates a <i>primary key</i>, not a replica. To create a <i>replica key</i>, use the <code>ReplicateKey</code> operation. </p>  <p>You can create a symmetric or asymmetric multi-Region key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.</p>
    /// - On success, responds with [`CreateKeyOutput`](crate::output::CreateKeyOutput) with field(s):
    ///   - [`key_metadata(Option<KeyMetadata>)`](crate::output::CreateKeyOutput::key_metadata): <p>Metadata associated with the KMS key.</p>
    /// - On failure, responds with [`SdkError<CreateKeyError>`](crate::error::CreateKeyError)
    pub fn create_key(&self) -> fluent_builders::CreateKey {
        fluent_builders::CreateKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Decrypt`](crate::client::fluent_builders::Decrypt) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ciphertext_blob(Blob)`](crate::client::fluent_builders::Decrypt::ciphertext_blob) / [`set_ciphertext_blob(Option<Blob>)`](crate::client::fluent_builders::Decrypt::set_ciphertext_blob): <p>Ciphertext to be decrypted. The blob includes metadata.</p>
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::Decrypt::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Decrypt::set_encryption_context): <p>Specifies the encryption context to use when decrypting the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::Decrypt::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::Decrypt::set_grant_tokens): <p>A list of grant tokens. </p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::Decrypt::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::Decrypt::set_key_id): <p>Specifies the KMS key that KMS uses to decrypt the ciphertext. Enter a key ID of the KMS key that was used to encrypt the ciphertext. </p>  <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`encryption_algorithm(EncryptionAlgorithmSpec)`](crate::client::fluent_builders::Decrypt::encryption_algorithm) / [`set_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::client::fluent_builders::Decrypt::set_encryption_algorithm): <p>Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the <code>Decrypt</code> operation fails.</p>  <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the only supported algorithm that is valid for symmetric KMS keys.</p>
    /// - On success, responds with [`DecryptOutput`](crate::output::DecryptOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::DecryptOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
    ///   - [`plaintext(Option<Blob>)`](crate::output::DecryptOutput::plaintext): <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::output::DecryptOutput::encryption_algorithm): <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
    /// - On failure, responds with [`SdkError<DecryptError>`](crate::error::DecryptError)
    pub fn decrypt(&self) -> fluent_builders::Decrypt {
        fluent_builders::Decrypt::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAlias`](crate::client::fluent_builders::DeleteAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_alias_name): <p>The alias to be deleted. The alias name must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>.</p>
    /// - On success, responds with [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteAliasError>`](crate::error::DeleteAliasError)
    pub fn delete_alias(&self) -> fluent_builders::DeleteAlias {
        fluent_builders::DeleteAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomKeyStore`](crate::client::fluent_builders::DeleteCustomKeyStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomKeyStore::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomKeyStore::set_custom_key_store_id): <p>Enter the ID of the custom key store you want to delete. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// - On success, responds with [`DeleteCustomKeyStoreOutput`](crate::output::DeleteCustomKeyStoreOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomKeyStoreError>`](crate::error::DeleteCustomKeyStoreError)
    pub fn delete_custom_key_store(&self) -> fluent_builders::DeleteCustomKeyStore {
        fluent_builders::DeleteCustomKeyStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImportedKeyMaterial`](crate::client::fluent_builders::DeleteImportedKeyMaterial) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::DeleteImportedKeyMaterial::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::DeleteImportedKeyMaterial::set_key_id): <p>Identifies the KMS key from which you are deleting imported key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`DeleteImportedKeyMaterialOutput`](crate::output::DeleteImportedKeyMaterialOutput)

    /// - On failure, responds with [`SdkError<DeleteImportedKeyMaterialError>`](crate::error::DeleteImportedKeyMaterialError)
    pub fn delete_imported_key_material(&self) -> fluent_builders::DeleteImportedKeyMaterial {
        fluent_builders::DeleteImportedKeyMaterial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomKeyStores`](crate::client::fluent_builders::DescribeCustomKeyStores) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::set_custom_key_store_id): <p>Gets only information about the specified custom key store. Enter the key store ID.</p>  <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
    ///   - [`custom_key_store_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::custom_key_store_name) / [`set_custom_key_store_name(Option<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::set_custom_key_store_name): <p>Gets only information about the specified custom key store. Enter the friendly name of the custom key store.</p>  <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeCustomKeyStores::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeCustomKeyStores::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCustomKeyStores::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    /// - On success, responds with [`DescribeCustomKeyStoresOutput`](crate::output::DescribeCustomKeyStoresOutput) with field(s):
    ///   - [`custom_key_stores(Option<Vec<CustomKeyStoresListEntry>>)`](crate::output::DescribeCustomKeyStoresOutput::custom_key_stores): <p>Contains metadata about each custom key store.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeCustomKeyStoresOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::DescribeCustomKeyStoresOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomKeyStoresError>`](crate::error::DescribeCustomKeyStoresError)
    pub fn describe_custom_key_stores(&self) -> fluent_builders::DescribeCustomKeyStores {
        fluent_builders::DescribeCustomKeyStores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeKey`](crate::client::fluent_builders::DescribeKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::DescribeKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::DescribeKey::set_key_id): <p>Describes the specified KMS key. </p>  <p>If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias with no key ID), KMS associates the alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk">Amazon Web Services managed key</a> and returns its <code>KeyId</code> and <code>Arn</code> in the response.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::DescribeKey::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeKey::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`DescribeKeyOutput`](crate::output::DescribeKeyOutput) with field(s):
    ///   - [`key_metadata(Option<KeyMetadata>)`](crate::output::DescribeKeyOutput::key_metadata): <p>Metadata associated with the key.</p>
    /// - On failure, responds with [`SdkError<DescribeKeyError>`](crate::error::DescribeKeyError)
    pub fn describe_key(&self) -> fluent_builders::DescribeKey {
        fluent_builders::DescribeKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableKey`](crate::client::fluent_builders::DisableKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::DisableKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::DisableKey::set_key_id): <p>Identifies the KMS key to disable.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`DisableKeyOutput`](crate::output::DisableKeyOutput)

    /// - On failure, responds with [`SdkError<DisableKeyError>`](crate::error::DisableKeyError)
    pub fn disable_key(&self) -> fluent_builders::DisableKey {
        fluent_builders::DisableKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableKeyRotation`](crate::client::fluent_builders::DisableKeyRotation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::DisableKeyRotation::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::DisableKeyRotation::set_key_id): <p>Identifies a symmetric KMS key. You cannot enable or disable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`DisableKeyRotationOutput`](crate::output::DisableKeyRotationOutput)

    /// - On failure, responds with [`SdkError<DisableKeyRotationError>`](crate::error::DisableKeyRotationError)
    pub fn disable_key_rotation(&self) -> fluent_builders::DisableKeyRotation {
        fluent_builders::DisableKeyRotation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectCustomKeyStore`](crate::client::fluent_builders::DisconnectCustomKeyStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectCustomKeyStore::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::DisconnectCustomKeyStore::set_custom_key_store_id): <p>Enter the ID of the custom key store you want to disconnect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// - On success, responds with [`DisconnectCustomKeyStoreOutput`](crate::output::DisconnectCustomKeyStoreOutput)

    /// - On failure, responds with [`SdkError<DisconnectCustomKeyStoreError>`](crate::error::DisconnectCustomKeyStoreError)
    pub fn disconnect_custom_key_store(&self) -> fluent_builders::DisconnectCustomKeyStore {
        fluent_builders::DisconnectCustomKeyStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableKey`](crate::client::fluent_builders::EnableKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::EnableKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::EnableKey::set_key_id): <p>Identifies the KMS key to enable.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`EnableKeyOutput`](crate::output::EnableKeyOutput)

    /// - On failure, responds with [`SdkError<EnableKeyError>`](crate::error::EnableKeyError)
    pub fn enable_key(&self) -> fluent_builders::EnableKey {
        fluent_builders::EnableKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableKeyRotation`](crate::client::fluent_builders::EnableKeyRotation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::EnableKeyRotation::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::EnableKeyRotation::set_key_id): <p>Identifies a symmetric KMS key. You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`EnableKeyRotationOutput`](crate::output::EnableKeyRotationOutput)

    /// - On failure, responds with [`SdkError<EnableKeyRotationError>`](crate::error::EnableKeyRotationError)
    pub fn enable_key_rotation(&self) -> fluent_builders::EnableKeyRotation {
        fluent_builders::EnableKeyRotation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Encrypt`](crate::client::fluent_builders::Encrypt) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::Encrypt::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::Encrypt::set_key_id): <p>Identifies the KMS key to use in the encryption operation.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`plaintext(Blob)`](crate::client::fluent_builders::Encrypt::plaintext) / [`set_plaintext(Option<Blob>)`](crate::client::fluent_builders::Encrypt::set_plaintext): <p>Data to be encrypted.</p>
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::Encrypt::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Encrypt::set_encryption_context): <p>Specifies the encryption context that will be used to encrypt the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context. </p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::Encrypt::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::Encrypt::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`encryption_algorithm(EncryptionAlgorithmSpec)`](crate::client::fluent_builders::Encrypt::encryption_algorithm) / [`set_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::client::fluent_builders::Encrypt::set_encryption_algorithm): <p>Specifies the encryption algorithm that KMS will use to encrypt the plaintext message. The algorithm must be compatible with the KMS key that you specify.</p>  <p>This parameter is required only for asymmetric KMS keys. The default value, <code>SYMMETRIC_DEFAULT</code>, is the algorithm used for symmetric KMS keys. If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.</p>
    /// - On success, responds with [`EncryptOutput`](crate::output::EncryptOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::output::EncryptOutput::ciphertext_blob): <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`key_id(Option<String>)`](crate::output::EncryptOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    ///   - [`encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::output::EncryptOutput::encryption_algorithm): <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    /// - On failure, responds with [`SdkError<EncryptError>`](crate::error::EncryptError)
    pub fn encrypt(&self) -> fluent_builders::Encrypt {
        fluent_builders::Encrypt::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateDataKey`](crate::client::fluent_builders::GenerateDataKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GenerateDataKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GenerateDataKey::set_key_id): <p>Identifies the symmetric KMS key that encrypts the data key.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::GenerateDataKey::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GenerateDataKey::set_encryption_context): <p>Specifies the encryption context that will be used when encrypting the data key.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`number_of_bytes(i32)`](crate::client::fluent_builders::GenerateDataKey::number_of_bytes) / [`set_number_of_bytes(Option<i32>)`](crate::client::fluent_builders::GenerateDataKey::set_number_of_bytes): <p>Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the <code>KeySpec</code> parameter.</p>  <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
    ///   - [`key_spec(DataKeySpec)`](crate::client::fluent_builders::GenerateDataKey::key_spec) / [`set_key_spec(Option<DataKeySpec>)`](crate::client::fluent_builders::GenerateDataKey::set_key_spec): <p>Specifies the length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>  <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::GenerateDataKey::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::GenerateDataKey::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`GenerateDataKeyOutput`](crate::output::GenerateDataKeyOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::output::GenerateDataKeyOutput::ciphertext_blob): <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`plaintext(Option<Blob>)`](crate::output::GenerateDataKeyOutput::plaintext): <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of KMS. Then, remove it from memory as soon as possible.</p>
    ///   - [`key_id(Option<String>)`](crate::output::GenerateDataKeyOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    /// - On failure, responds with [`SdkError<GenerateDataKeyError>`](crate::error::GenerateDataKeyError)
    pub fn generate_data_key(&self) -> fluent_builders::GenerateDataKey {
        fluent_builders::GenerateDataKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateDataKeyPair`](crate::client::fluent_builders::GenerateDataKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::GenerateDataKeyPair::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GenerateDataKeyPair::set_encryption_context): <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GenerateDataKeyPair::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GenerateDataKeyPair::set_key_id): <p>Specifies the symmetric KMS key that encrypts the private key in the data key pair. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`key_pair_spec(DataKeyPairSpec)`](crate::client::fluent_builders::GenerateDataKeyPair::key_pair_spec) / [`set_key_pair_spec(Option<DataKeyPairSpec>)`](crate::client::fluent_builders::GenerateDataKeyPair::set_key_pair_spec): <p>Determines the type of data key pair that is generated. </p>  <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::GenerateDataKeyPair::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::GenerateDataKeyPair::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`GenerateDataKeyPairOutput`](crate::output::GenerateDataKeyPairOutput) with field(s):
    ///   - [`private_key_ciphertext_blob(Option<Blob>)`](crate::output::GenerateDataKeyPairOutput::private_key_ciphertext_blob): <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`private_key_plaintext(Option<Blob>)`](crate::output::GenerateDataKeyPairOutput::private_key_plaintext): <p>The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`public_key(Option<Blob>)`](crate::output::GenerateDataKeyPairOutput::public_key): <p>The public key (in plaintext).</p>
    ///   - [`key_id(Option<String>)`](crate::output::GenerateDataKeyPairOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    ///   - [`key_pair_spec(Option<DataKeyPairSpec>)`](crate::output::GenerateDataKeyPairOutput::key_pair_spec): <p>The type of data key pair that was generated.</p>
    /// - On failure, responds with [`SdkError<GenerateDataKeyPairError>`](crate::error::GenerateDataKeyPairError)
    pub fn generate_data_key_pair(&self) -> fluent_builders::GenerateDataKeyPair {
        fluent_builders::GenerateDataKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateDataKeyPairWithoutPlaintext`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::set_encryption_context): <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::set_key_id): <p>Specifies the KMS key that encrypts the private key in the data key pair. You must specify a symmetric KMS key. You cannot use an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation. </p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`key_pair_spec(DataKeyPairSpec)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::key_pair_spec) / [`set_key_pair_spec(Option<DataKeyPairSpec>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::set_key_pair_spec): <p>Determines the type of data key pair that is generated.</p>  <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`GenerateDataKeyPairWithoutPlaintextOutput`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput) with field(s):
    ///   - [`private_key_ciphertext_blob(Option<Blob>)`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput::private_key_ciphertext_blob): <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`public_key(Option<Blob>)`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput::public_key): <p>The public key (in plaintext).</p>
    ///   - [`key_id(Option<String>)`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    ///   - [`key_pair_spec(Option<DataKeyPairSpec>)`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput::key_pair_spec): <p>The type of data key pair that was generated.</p>
    /// - On failure, responds with [`SdkError<GenerateDataKeyPairWithoutPlaintextError>`](crate::error::GenerateDataKeyPairWithoutPlaintextError)
    pub fn generate_data_key_pair_without_plaintext(
        &self,
    ) -> fluent_builders::GenerateDataKeyPairWithoutPlaintext {
        fluent_builders::GenerateDataKeyPairWithoutPlaintext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateDataKeyWithoutPlaintext`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::set_key_id): <p>The identifier of the symmetric KMS key that encrypts the data key.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::encryption_context) / [`set_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::set_encryption_context): <p>Specifies the encryption context that will be used when encrypting the data key.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`key_spec(DataKeySpec)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::key_spec) / [`set_key_spec(Option<DataKeySpec>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::set_key_spec): <p>The length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>
    ///   - [`number_of_bytes(i32)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::number_of_bytes) / [`set_number_of_bytes(Option<i32>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::set_number_of_bytes): <p>The length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the <code>KeySpec</code> field instead of this one.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`GenerateDataKeyWithoutPlaintextOutput`](crate::output::GenerateDataKeyWithoutPlaintextOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::output::GenerateDataKeyWithoutPlaintextOutput::ciphertext_blob): <p>The encrypted data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`key_id(Option<String>)`](crate::output::GenerateDataKeyWithoutPlaintextOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    /// - On failure, responds with [`SdkError<GenerateDataKeyWithoutPlaintextError>`](crate::error::GenerateDataKeyWithoutPlaintextError)
    pub fn generate_data_key_without_plaintext(
        &self,
    ) -> fluent_builders::GenerateDataKeyWithoutPlaintext {
        fluent_builders::GenerateDataKeyWithoutPlaintext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateRandom`](crate::client::fluent_builders::GenerateRandom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`number_of_bytes(i32)`](crate::client::fluent_builders::GenerateRandom::number_of_bytes) / [`set_number_of_bytes(Option<i32>)`](crate::client::fluent_builders::GenerateRandom::set_number_of_bytes): <p>The length of the byte string.</p>
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::GenerateRandom::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::GenerateRandom::set_custom_key_store_id): <p>Generates the random byte string in the CloudHSM cluster that is associated with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// - On success, responds with [`GenerateRandomOutput`](crate::output::GenerateRandomOutput) with field(s):
    ///   - [`plaintext(Option<Blob>)`](crate::output::GenerateRandomOutput::plaintext): <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    /// - On failure, responds with [`SdkError<GenerateRandomError>`](crate::error::GenerateRandomError)
    pub fn generate_random(&self) -> fluent_builders::GenerateRandom {
        fluent_builders::GenerateRandom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKeyPolicy`](crate::client::fluent_builders::GetKeyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetKeyPolicy::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetKeyPolicy::set_key_id): <p>Gets the key policy for the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::GetKeyPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::GetKeyPolicy::set_policy_name): <p>Specifies the name of the key policy. The only valid name is <code>default</code>. To get the names of key policies, use <code>ListKeyPolicies</code>.</p>
    /// - On success, responds with [`GetKeyPolicyOutput`](crate::output::GetKeyPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetKeyPolicyOutput::policy): <p>A key policy document in JSON format.</p>
    /// - On failure, responds with [`SdkError<GetKeyPolicyError>`](crate::error::GetKeyPolicyError)
    pub fn get_key_policy(&self) -> fluent_builders::GetKeyPolicy {
        fluent_builders::GetKeyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKeyRotationStatus`](crate::client::fluent_builders::GetKeyRotationStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetKeyRotationStatus::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetKeyRotationStatus::set_key_id): <p>Gets the rotation status for the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// - On success, responds with [`GetKeyRotationStatusOutput`](crate::output::GetKeyRotationStatusOutput) with field(s):
    ///   - [`key_rotation_enabled(bool)`](crate::output::GetKeyRotationStatusOutput::key_rotation_enabled): <p>A Boolean value that specifies whether key rotation is enabled.</p>
    /// - On failure, responds with [`SdkError<GetKeyRotationStatusError>`](crate::error::GetKeyRotationStatusError)
    pub fn get_key_rotation_status(&self) -> fluent_builders::GetKeyRotationStatus {
        fluent_builders::GetKeyRotationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParametersForImport`](crate::client::fluent_builders::GetParametersForImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetParametersForImport::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetParametersForImport::set_key_id): <p>The identifier of the symmetric KMS key into which you will import key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`wrapping_algorithm(AlgorithmSpec)`](crate::client::fluent_builders::GetParametersForImport::wrapping_algorithm) / [`set_wrapping_algorithm(Option<AlgorithmSpec>)`](crate::client::fluent_builders::GetParametersForImport::set_wrapping_algorithm): <p>The algorithm you will use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`wrapping_key_spec(WrappingKeySpec)`](crate::client::fluent_builders::GetParametersForImport::wrapping_key_spec) / [`set_wrapping_key_spec(Option<WrappingKeySpec>)`](crate::client::fluent_builders::GetParametersForImport::set_wrapping_key_spec): <p>The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.</p>
    /// - On success, responds with [`GetParametersForImportOutput`](crate::output::GetParametersForImportOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::GetParametersForImportOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    ///   - [`import_token(Option<Blob>)`](crate::output::GetParametersForImportOutput::import_token): <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    ///   - [`public_key(Option<Blob>)`](crate::output::GetParametersForImportOutput::public_key): <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    ///   - [`parameters_valid_to(Option<DateTime>)`](crate::output::GetParametersForImportOutput::parameters_valid_to): <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    /// - On failure, responds with [`SdkError<GetParametersForImportError>`](crate::error::GetParametersForImportError)
    pub fn get_parameters_for_import(&self) -> fluent_builders::GetParametersForImport {
        fluent_builders::GetParametersForImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPublicKey`](crate::client::fluent_builders::GetPublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::GetPublicKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::GetPublicKey::set_key_id): <p>Identifies the asymmetric KMS key that includes the public key.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::GetPublicKey::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::GetPublicKey::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::GetPublicKeyOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key from which the public key was downloaded.</p>
    ///   - [`public_key(Option<Blob>)`](crate::output::GetPublicKeyOutput::public_key): <p>The exported public key. </p>  <p>The value is a DER-encoded X.509 public key, also known as <code>SubjectPublicKeyInfo</code> (SPKI), as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>  <p></p>
    ///   - [`customer_master_key_spec(Option<CustomerMasterKeySpec>)`](crate::output::GetPublicKeyOutput::customer_master_key_spec): <p>Instead, use the <code>KeySpec</code> field in the <code>GetPublicKey</code> response.</p>  <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same value. We recommend that you use the <code>KeySpec</code> field in your code. However, to avoid breaking changes, KMS will support both fields.</p>
    ///   - [`key_spec(Option<KeySpec>)`](crate::output::GetPublicKeyOutput::key_spec): <p>The type of the of the public key that was downloaded.</p>
    ///   - [`key_usage(Option<KeyUsageType>)`](crate::output::GetPublicKeyOutput::key_usage): <p>The permitted use of the public key. Valid values are <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code>. </p>  <p>This information is critical. If a public key with <code>SIGN_VERIFY</code> key usage encrypts data outside of KMS, the ciphertext cannot be decrypted. </p>
    ///   - [`encryption_algorithms(Option<Vec<EncryptionAlgorithmSpec>>)`](crate::output::GetPublicKeyOutput::encryption_algorithms): <p>The encryption algorithms that KMS supports for this key. </p>  <p>This information is critical. If a public key encrypts data outside of KMS by using an unsupported encryption algorithm, the ciphertext cannot be decrypted. </p>  <p>This field appears in the response only when the <code>KeyUsage</code> of the public key is <code>ENCRYPT_DECRYPT</code>.</p>
    ///   - [`signing_algorithms(Option<Vec<SigningAlgorithmSpec>>)`](crate::output::GetPublicKeyOutput::signing_algorithms): <p>The signing algorithms that KMS supports for this key.</p>  <p>This field appears in the response only when the <code>KeyUsage</code> of the public key is <code>SIGN_VERIFY</code>.</p>
    /// - On failure, responds with [`SdkError<GetPublicKeyError>`](crate::error::GetPublicKeyError)
    pub fn get_public_key(&self) -> fluent_builders::GetPublicKey {
        fluent_builders::GetPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportKeyMaterial`](crate::client::fluent_builders::ImportKeyMaterial) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ImportKeyMaterial::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ImportKeyMaterial::set_key_id): <p>The identifier of the symmetric KMS key that receives the imported key material. The KMS key's <code>Origin</code> must be <code>EXTERNAL</code>. This must be the same KMS key specified in the <code>KeyID</code> parameter of the corresponding <code>GetParametersForImport</code> request.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`import_token(Blob)`](crate::client::fluent_builders::ImportKeyMaterial::import_token) / [`set_import_token(Option<Blob>)`](crate::client::fluent_builders::ImportKeyMaterial::set_import_token): <p>The import token that you received in the response to a previous <code>GetParametersForImport</code> request. It must be from the same response that contained the public key that you used to encrypt the key material.</p>
    ///   - [`encrypted_key_material(Blob)`](crate::client::fluent_builders::ImportKeyMaterial::encrypted_key_material) / [`set_encrypted_key_material(Option<Blob>)`](crate::client::fluent_builders::ImportKeyMaterial::set_encrypted_key_material): <p>The encrypted key material to import. The key material must be encrypted with the public wrapping key that <code>GetParametersForImport</code> returned, using the wrapping algorithm that you specified in the same <code>GetParametersForImport</code> request.</p>
    ///   - [`valid_to(DateTime)`](crate::client::fluent_builders::ImportKeyMaterial::valid_to) / [`set_valid_to(Option<DateTime>)`](crate::client::fluent_builders::ImportKeyMaterial::set_valid_to): <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. You must omit this parameter when the <code>ExpirationModel</code> parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. Otherwise it is required.</p>
    ///   - [`expiration_model(ExpirationModelType)`](crate::client::fluent_builders::ImportKeyMaterial::expiration_model) / [`set_expiration_model(Option<ExpirationModelType>)`](crate::client::fluent_builders::ImportKeyMaterial::set_expiration_model): <p>Specifies whether the key material expires. The default is <code>KEY_MATERIAL_EXPIRES</code>, in which case you must include the <code>ValidTo</code> parameter. When this parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>, you must omit the <code>ValidTo</code> parameter.</p>
    /// - On success, responds with [`ImportKeyMaterialOutput`](crate::output::ImportKeyMaterialOutput)

    /// - On failure, responds with [`SdkError<ImportKeyMaterialError>`](crate::error::ImportKeyMaterialError)
    pub fn import_key_material(&self) -> fluent_builders::ImportKeyMaterial {
        fluent_builders::ImportKeyMaterial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAliases`](crate::client::fluent_builders::ListAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ListAliases::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ListAliases::set_key_id): <p>Lists only aliases that are associated with the specified KMS key. Enter a KMS key in your Amazon Web Services account. </p>  <p>This parameter is optional. If you omit it, <code>ListAliases</code> returns all aliases in the account and Region.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListAliases::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListAliases::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListAliases::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListAliases::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    /// - On success, responds with [`ListAliasesOutput`](crate::output::ListAliasesOutput) with field(s):
    ///   - [`aliases(Option<Vec<AliasListEntry>>)`](crate::output::ListAliasesOutput::aliases): <p>A list of aliases.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListAliasesOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::ListAliasesOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListAliasesError>`](crate::error::ListAliasesError)
    pub fn list_aliases(&self) -> fluent_builders::ListAliases {
        fluent_builders::ListAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGrants`](crate::client::fluent_builders::ListGrants) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGrants::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGrants::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListGrants::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListGrants::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListGrants::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ListGrants::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ListGrants::set_key_id): <p>Returns only grants for the specified KMS key. This parameter is required.</p>  <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`grant_id(impl Into<String>)`](crate::client::fluent_builders::ListGrants::grant_id) / [`set_grant_id(Option<String>)`](crate::client::fluent_builders::ListGrants::set_grant_id): <p>Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant. </p>
    ///   - [`grantee_principal(impl Into<String>)`](crate::client::fluent_builders::ListGrants::grantee_principal) / [`set_grantee_principal(Option<String>)`](crate::client::fluent_builders::ListGrants::set_grantee_principal): <p>Returns only grants where the specified principal is the grantee principal for the grant.</p>
    /// - On success, responds with [`ListGrantsOutput`](crate::output::ListGrantsOutput) with field(s):
    ///   - [`grants(Option<Vec<GrantListEntry>>)`](crate::output::ListGrantsOutput::grants): <p>A list of grants.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListGrantsOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::ListGrantsOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListGrantsError>`](crate::error::ListGrantsError)
    pub fn list_grants(&self) -> fluent_builders::ListGrants {
        fluent_builders::ListGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeyPolicies`](crate::client::fluent_builders::ListKeyPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKeyPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ListKeyPolicies::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ListKeyPolicies::set_key_id): <p>Gets the names of key policies for the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListKeyPolicies::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListKeyPolicies::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>  <p>Only one policy can be attached to a key.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListKeyPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListKeyPolicies::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    /// - On success, responds with [`ListKeyPoliciesOutput`](crate::output::ListKeyPoliciesOutput) with field(s):
    ///   - [`policy_names(Option<Vec<String>>)`](crate::output::ListKeyPoliciesOutput::policy_names): <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListKeyPoliciesOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::ListKeyPoliciesOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListKeyPoliciesError>`](crate::error::ListKeyPoliciesError)
    pub fn list_key_policies(&self) -> fluent_builders::ListKeyPolicies {
        fluent_builders::ListKeyPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeys`](crate::client::fluent_builders::ListKeys) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKeys::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListKeys::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListKeys::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListKeys::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListKeys::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    /// - On success, responds with [`ListKeysOutput`](crate::output::ListKeysOutput) with field(s):
    ///   - [`keys(Option<Vec<KeyListEntry>>)`](crate::output::ListKeysOutput::keys): <p>A list of KMS keys.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListKeysOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::ListKeysOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListKeysError>`](crate::error::ListKeysError)
    pub fn list_keys(&self) -> fluent_builders::ListKeys {
        fluent_builders::ListKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceTags`](crate::client::fluent_builders::ListResourceTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ListResourceTags::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ListResourceTags::set_key_id): <p>Gets tags on the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListResourceTags::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListResourceTags::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 50, inclusive. If you do not include a value, it defaults to 50.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListResourceTags::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListResourceTags::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>  <p>Do not attempt to construct this value. Use only the value of <code>NextMarker</code> from the truncated response you just received.</p>
    /// - On success, responds with [`ListResourceTagsOutput`](crate::output::ListResourceTagsOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListResourceTagsOutput::tags): <p>A list of tags. Each tag consists of a tag key and a tag value.</p> <note>   <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>  </note>
    ///   - [`next_marker(Option<String>)`](crate::output::ListResourceTagsOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>  <p>Do not assume or infer any information from this value.</p>
    ///   - [`truncated(bool)`](crate::output::ListResourceTagsOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListResourceTagsError>`](crate::error::ListResourceTagsError)
    pub fn list_resource_tags(&self) -> fluent_builders::ListResourceTags {
        fluent_builders::ListResourceTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRetirableGrants`](crate::client::fluent_builders::ListRetirableGrants) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRetirableGrants::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRetirableGrants::set_limit): <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>  <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListRetirableGrants::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListRetirableGrants::set_marker): <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
    ///   - [`retiring_principal(impl Into<String>)`](crate::client::fluent_builders::ListRetirableGrants::retiring_principal) / [`set_retiring_principal(Option<String>)`](crate::client::fluent_builders::ListRetirableGrants::set_retiring_principal): <p>The retiring principal for which to list grants. Enter a principal in your Amazon Web Services account.</p>  <p>To specify the retiring principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
    /// - On success, responds with [`ListRetirableGrantsOutput`](crate::output::ListRetirableGrantsOutput) with field(s):
    ///   - [`grants(Option<Vec<GrantListEntry>>)`](crate::output::ListRetirableGrantsOutput::grants): <p>A list of grants.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListRetirableGrantsOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::output::ListRetirableGrantsOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListRetirableGrantsError>`](crate::error::ListRetirableGrantsError)
    pub fn list_retirable_grants(&self) -> fluent_builders::ListRetirableGrants {
        fluent_builders::ListRetirableGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutKeyPolicy`](crate::client::fluent_builders::PutKeyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::PutKeyPolicy::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::PutKeyPolicy::set_key_id): <p>Sets the key policy on the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::PutKeyPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::PutKeyPolicy::set_policy_name): <p>The name of the key policy. The only valid value is <code>default</code>.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutKeyPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutKeyPolicy::set_policy): <p>The key policy to attach to the KMS key.</p>  <p>The key policy must meet the following criteria:</p>  <ul>   <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i>Key Management Service Developer Guide</i>.</p> </li>   <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>  </ul>  <p>The key policy cannot exceed 32 kilobytes (32768 bytes). For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource Quotas</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::PutKeyPolicy::bypass_policy_lockout_safety_check) / [`set_bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::PutKeyPolicy::set_bypass_policy_lockout_safety_check): <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>   <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>   <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>  </important>  <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>  <p>The default value is false.</p>
    /// - On success, responds with [`PutKeyPolicyOutput`](crate::output::PutKeyPolicyOutput)

    /// - On failure, responds with [`SdkError<PutKeyPolicyError>`](crate::error::PutKeyPolicyError)
    pub fn put_key_policy(&self) -> fluent_builders::PutKeyPolicy {
        fluent_builders::PutKeyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReEncrypt`](crate::client::fluent_builders::ReEncrypt) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ciphertext_blob(Blob)`](crate::client::fluent_builders::ReEncrypt::ciphertext_blob) / [`set_ciphertext_blob(Option<Blob>)`](crate::client::fluent_builders::ReEncrypt::set_ciphertext_blob): <p>Ciphertext of the data to reencrypt.</p>
    ///   - [`source_encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::ReEncrypt::source_encryption_context) / [`set_source_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ReEncrypt::set_source_encryption_context): <p>Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`source_key_id(impl Into<String>)`](crate::client::fluent_builders::ReEncrypt::source_key_id) / [`set_source_key_id(Option<String>)`](crate::client::fluent_builders::ReEncrypt::set_source_key_id): <p>Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted. Enter a key ID of the KMS key that was used to encrypt the ciphertext.</p>  <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`destination_key_id(impl Into<String>)`](crate::client::fluent_builders::ReEncrypt::destination_key_id) / [`set_destination_key_id(Option<String>)`](crate::client::fluent_builders::ReEncrypt::set_destination_key_id): <p>A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric or asymmetric KMS key with a <code>KeyUsage</code> value of <code>ENCRYPT_DECRYPT</code>. To find the <code>KeyUsage</code> value of a KMS key, use the <code>DescribeKey</code> operation.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`destination_encryption_context(HashMap<String, String>)`](crate::client::fluent_builders::ReEncrypt::destination_encryption_context) / [`set_destination_encryption_context(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ReEncrypt::set_destination_encryption_context): <p>Specifies that encryption context to use when the reencrypting the data.</p>  <p>A destination encryption context is valid only when the destination KMS key is a symmetric KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.</p>  <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`source_encryption_algorithm(EncryptionAlgorithmSpec)`](crate::client::fluent_builders::ReEncrypt::source_encryption_algorithm) / [`set_source_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::client::fluent_builders::ReEncrypt::set_source_encryption_algorithm): <p>Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the algorithm used for symmetric KMS keys.</p>  <p>Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.</p>  <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.</p>
    ///   - [`destination_encryption_algorithm(EncryptionAlgorithmSpec)`](crate::client::fluent_builders::ReEncrypt::destination_encryption_algorithm) / [`set_destination_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::client::fluent_builders::ReEncrypt::set_destination_encryption_algorithm): <p>Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the encryption algorithm used for symmetric KMS keys.</p>  <p>This parameter is required only when the destination KMS key is an asymmetric KMS key.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::ReEncrypt::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::ReEncrypt::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`ReEncryptOutput`](crate::output::ReEncryptOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::output::ReEncryptOutput::ciphertext_blob): <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`source_key_id(Option<String>)`](crate::output::ReEncryptOutput::source_key_id): <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
    ///   - [`key_id(Option<String>)`](crate::output::ReEncryptOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
    ///   - [`source_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::output::ReEncryptOutput::source_encryption_algorithm): <p>The encryption algorithm that was used to decrypt the ciphertext before it was reencrypted.</p>
    ///   - [`destination_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::output::ReEncryptOutput::destination_encryption_algorithm): <p>The encryption algorithm that was used to reencrypt the data.</p>
    /// - On failure, responds with [`SdkError<ReEncryptError>`](crate::error::ReEncryptError)
    pub fn re_encrypt(&self) -> fluent_builders::ReEncrypt {
        fluent_builders::ReEncrypt::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReplicateKey`](crate::client::fluent_builders::ReplicateKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ReplicateKey::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ReplicateKey::set_key_id): <p>Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a multi-Region primary key, use the <code>DescribeKey</code> operation to check the value of the <code>MultiRegionKeyType</code> property.</p>  <p>Specify the key ID or key ARN of a multi-Region primary key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`replica_region(impl Into<String>)`](crate::client::fluent_builders::ReplicateKey::replica_region) / [`set_replica_region(Option<String>)`](crate::client::fluent_builders::ReplicateKey::set_replica_region): <p>The Region ID of the Amazon Web Services Region for this replica key. </p>  <p>Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web Services Regions in which KMS is supported, see <a href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p>The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. </p>  <p>For information about Amazon Web Services partitions, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the <i>Amazon Web Services General Reference</i>.</a> For information about enabling and disabling Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a Region</a> in the <i>Amazon Web Services General Reference</i>.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::ReplicateKey::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::ReplicateKey::set_policy): <p>The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS attaches the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key policy</a> to the KMS key.</p>  <p>The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>  <p>If you provide a key policy, it must meet the following criteria:</p>  <ul>   <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>   <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p> </li>   <li> <p>The key policy size quota is 32 kilobytes (32768 bytes).</p> </li>  </ul>
    ///   - [`bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::ReplicateKey::bypass_policy_lockout_safety_check) / [`set_bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::ReplicateKey::set_bypass_policy_lockout_safety_check): <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>   <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>   <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>  </important>  <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>  <p>The default value is false.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ReplicateKey::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ReplicateKey::set_description): <p>A description of the KMS key. The default value is an empty string (no description).</p>  <p>The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::ReplicateKey::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ReplicateKey::set_tags): <p>Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>   <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>  </note>  <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>  <p>Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>  <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>  <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
    /// - On success, responds with [`ReplicateKeyOutput`](crate::output::ReplicateKeyOutput) with field(s):
    ///   - [`replica_key_metadata(Option<KeyMetadata>)`](crate::output::ReplicateKeyOutput::replica_key_metadata): <p>Displays details about the new replica key, including its Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. It also includes the ARN and Amazon Web Services Region of its primary key and other replica keys.</p>
    ///   - [`replica_policy(Option<String>)`](crate::output::ReplicateKeyOutput::replica_policy): <p>The key policy of the new replica key. The value is a key policy document in JSON format.</p>
    ///   - [`replica_tags(Option<Vec<Tag>>)`](crate::output::ReplicateKeyOutput::replica_tags): <p>The tags on the new replica key. The value is a list of tag key and tag value pairs.</p>
    /// - On failure, responds with [`SdkError<ReplicateKeyError>`](crate::error::ReplicateKeyError)
    pub fn replicate_key(&self) -> fluent_builders::ReplicateKey {
        fluent_builders::ReplicateKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetireGrant`](crate::client::fluent_builders::RetireGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_token(impl Into<String>)`](crate::client::fluent_builders::RetireGrant::grant_token) / [`set_grant_token(Option<String>)`](crate::client::fluent_builders::RetireGrant::set_grant_token): <p>Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.</p>  <p>Only the <code>CreateGrant</code> operation returns a grant token. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency">Eventual consistency</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::RetireGrant::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::RetireGrant::set_key_id): <p>The key ARN KMS key associated with the grant. To find the key ARN, use the <code>ListKeys</code> operation.</p>  <p>For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p>
    ///   - [`grant_id(impl Into<String>)`](crate::client::fluent_builders::RetireGrant::grant_id) / [`set_grant_id(Option<String>)`](crate::client::fluent_builders::RetireGrant::set_grant_id): <p>Identifies the grant to retire. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>  <ul>   <li> <p>Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123</p> </li>  </ul>
    /// - On success, responds with [`RetireGrantOutput`](crate::output::RetireGrantOutput)

    /// - On failure, responds with [`SdkError<RetireGrantError>`](crate::error::RetireGrantError)
    pub fn retire_grant(&self) -> fluent_builders::RetireGrant {
        fluent_builders::RetireGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeGrant`](crate::client::fluent_builders::RevokeGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::RevokeGrant::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::RevokeGrant::set_key_id): <p>A unique identifier for the KMS key associated with the grant. To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>  <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`grant_id(impl Into<String>)`](crate::client::fluent_builders::RevokeGrant::grant_id) / [`set_grant_id(Option<String>)`](crate::client::fluent_builders::RevokeGrant::set_grant_id): <p>Identifies the grant to revoke. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>
    /// - On success, responds with [`RevokeGrantOutput`](crate::output::RevokeGrantOutput)

    /// - On failure, responds with [`SdkError<RevokeGrantError>`](crate::error::RevokeGrantError)
    pub fn revoke_grant(&self) -> fluent_builders::RevokeGrant {
        fluent_builders::RevokeGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ScheduleKeyDeletion`](crate::client::fluent_builders::ScheduleKeyDeletion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::ScheduleKeyDeletion::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::ScheduleKeyDeletion::set_key_id): <p>The unique identifier of the KMS key to delete.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`pending_window_in_days(i32)`](crate::client::fluent_builders::ScheduleKeyDeletion::pending_window_in_days) / [`set_pending_window_in_days(Option<i32>)`](crate::client::fluent_builders::ScheduleKeyDeletion::set_pending_window_in_days): <p>The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.</p>  <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p>  <p>This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.</p>
    /// - On success, responds with [`ScheduleKeyDeletionOutput`](crate::output::ScheduleKeyDeletionOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::ScheduleKeyDeletionOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
    ///   - [`deletion_date(Option<DateTime>)`](crate::output::ScheduleKeyDeletionOutput::deletion_date): <p>The date and time after which KMS deletes the KMS key.</p>  <p>If the KMS key is a multi-Region primary key with replica keys, this field does not appear. The deletion date for the primary key isn't known until its last replica key is deleted.</p>
    ///   - [`key_state(Option<KeyState>)`](crate::output::ScheduleKeyDeletionOutput::key_state): <p>The current status of the KMS key.</p>  <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`pending_window_in_days(Option<i32>)`](crate::output::ScheduleKeyDeletionOutput::pending_window_in_days): <p>The waiting period before the KMS key is deleted. </p>  <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p>
    /// - On failure, responds with [`SdkError<ScheduleKeyDeletionError>`](crate::error::ScheduleKeyDeletionError)
    pub fn schedule_key_deletion(&self) -> fluent_builders::ScheduleKeyDeletion {
        fluent_builders::ScheduleKeyDeletion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Sign`](crate::client::fluent_builders::Sign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::Sign::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::Sign::set_key_id): <p>Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The <code>KeyUsage</code> type of the KMS key must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`message(Blob)`](crate::client::fluent_builders::Sign::message) / [`set_message(Option<Blob>)`](crate::client::fluent_builders::Sign::set_message): <p>Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide the message digest.</p>  <p>If you provide a message, KMS generates a hash digest of the message and then signs it.</p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::Sign::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::Sign::set_message_type): <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::Sign::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::Sign::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    ///   - [`signing_algorithm(SigningAlgorithmSpec)`](crate::client::fluent_builders::Sign::signing_algorithm) / [`set_signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::client::fluent_builders::Sign::set_signing_algorithm): <p>Specifies the signing algorithm to use when signing the message. </p>  <p>Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key.</p>
    /// - On success, responds with [`SignOutput`](crate::output::SignOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::SignOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    ///   - [`signature(Option<Blob>)`](crate::output::SignOutput::signature): <p>The cryptographic signature that was generated for the message. </p>  <ul>   <li> <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p> </li>   <li> <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANS X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses. </p> </li>  </ul>  <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::output::SignOutput::signing_algorithm): <p>The signing algorithm that was used to sign the message.</p>
    /// - On failure, responds with [`SdkError<SignError>`](crate::error::SignError)
    pub fn sign(&self) -> fluent_builders::Sign {
        fluent_builders::Sign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::TagResource::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::TagResource::set_key_id): <p>Identifies a customer managed key in the account and Region.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags. </p>  <p>Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string. </p>  <p>You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::UntagResource::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::UntagResource::set_key_id): <p>Identifies the KMS key from which you are removing tags.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAlias`](crate::client::fluent_builders::UpdateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_alias_name): <p>Identifies the alias that is changing its KMS key. This value must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>. You cannot use UpdateAlias to change the alias name.</p>
    ///   - [`target_key_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::target_key_id) / [`set_target_key_id(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_target_key_id): <p>Identifies the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> to associate with the alias. You don't have permission to associate an alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>.</p>  <p>The KMS key must be in the same Amazon Web Services account and Region as the alias. Also, the new target KMS key must be the same type as the current target KMS key (both symmetric or both asymmetric) and they must have the same key usage. </p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>  <p>To verify that the alias is mapped to the correct KMS key, use <code>ListAliases</code>.</p>
    /// - On success, responds with [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)

    /// - On failure, responds with [`SdkError<UpdateAliasError>`](crate::error::UpdateAliasError)
    pub fn update_alias(&self) -> fluent_builders::UpdateAlias {
        fluent_builders::UpdateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomKeyStore`](crate::client::fluent_builders::UpdateCustomKeyStore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`custom_key_store_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::custom_key_store_id) / [`set_custom_key_store_id(Option<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::set_custom_key_store_id): <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    ///   - [`new_custom_key_store_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::new_custom_key_store_name) / [`set_new_custom_key_store_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::set_new_custom_key_store_name): <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p>
    ///   - [`key_store_password(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::key_store_password) / [`set_key_store_password(Option<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::set_key_store_password): <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store.</p>  <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    ///   - [`cloud_hsm_cluster_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::cloud_hsm_cluster_id) / [`set_cloud_hsm_cluster_id(Option<String>)`](crate::client::fluent_builders::UpdateCustomKeyStore::set_cloud_hsm_cluster_id): <p>Associates the custom key store with a related CloudHSM cluster. </p>  <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// - On success, responds with [`UpdateCustomKeyStoreOutput`](crate::output::UpdateCustomKeyStoreOutput)

    /// - On failure, responds with [`SdkError<UpdateCustomKeyStoreError>`](crate::error::UpdateCustomKeyStoreError)
    pub fn update_custom_key_store(&self) -> fluent_builders::UpdateCustomKeyStore {
        fluent_builders::UpdateCustomKeyStore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateKeyDescription`](crate::client::fluent_builders::UpdateKeyDescription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::UpdateKeyDescription::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::UpdateKeyDescription::set_key_id): <p>Updates the description of the specified KMS key.</p>  <p>Specify the key ID or key ARN of the KMS key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateKeyDescription::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateKeyDescription::set_description): <p>New description for the KMS key.</p>
    /// - On success, responds with [`UpdateKeyDescriptionOutput`](crate::output::UpdateKeyDescriptionOutput)

    /// - On failure, responds with [`SdkError<UpdateKeyDescriptionError>`](crate::error::UpdateKeyDescriptionError)
    pub fn update_key_description(&self) -> fluent_builders::UpdateKeyDescription {
        fluent_builders::UpdateKeyDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePrimaryRegion`](crate::client::fluent_builders::UpdatePrimaryRegion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePrimaryRegion::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::UpdatePrimaryRegion::set_key_id): <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>  <p>Specify the key ID or key ARN of a multi-Region primary key.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    ///   - [`primary_region(impl Into<String>)`](crate::client::fluent_builders::UpdatePrimaryRegion::primary_region) / [`set_primary_region(Option<String>)`](crate::client::fluent_builders::UpdatePrimaryRegion::set_primary_region): <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region. </p>  <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    /// - On success, responds with [`UpdatePrimaryRegionOutput`](crate::output::UpdatePrimaryRegionOutput)

    /// - On failure, responds with [`SdkError<UpdatePrimaryRegionError>`](crate::error::UpdatePrimaryRegionError)
    pub fn update_primary_region(&self) -> fluent_builders::UpdatePrimaryRegion {
        fluent_builders::UpdatePrimaryRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Verify`](crate::client::fluent_builders::Verify) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::Verify::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::Verify::set_key_id): <p>Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.</p>  <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
    ///   - [`message(Blob)`](crate::client::fluent_builders::Verify::message) / [`set_message(Option<Blob>)`](crate::client::fluent_builders::Verify::set_message): <p>Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the <code>MessageType</code> parameter with a value of <code>DIGEST</code>.</p>  <p>If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.</p>
    ///   - [`message_type(MessageType)`](crate::client::fluent_builders::Verify::message_type) / [`set_message_type(Option<MessageType>)`](crate::client::fluent_builders::Verify::set_message_type): <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p> <important>   <p>Use the <code>DIGEST</code> value only when the value of the <code>Message</code> parameter is a message digest. If you use the <code>DIGEST</code> value with a raw message, the security of the verification operation can be compromised.</p>  </important>
    ///   - [`signature(Blob)`](crate::client::fluent_builders::Verify::signature) / [`set_signature(Option<Blob>)`](crate::client::fluent_builders::Verify::set_signature): <p>The signature that the <code>Sign</code> operation generated.</p>
    ///   - [`signing_algorithm(SigningAlgorithmSpec)`](crate::client::fluent_builders::Verify::signing_algorithm) / [`set_signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::client::fluent_builders::Verify::set_signing_algorithm): <p>The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.</p>
    ///   - [`grant_tokens(Vec<String>)`](crate::client::fluent_builders::Verify::grant_tokens) / [`set_grant_tokens(Option<Vec<String>>)`](crate::client::fluent_builders::Verify::set_grant_tokens): <p>A list of grant tokens.</p>  <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`VerifyOutput`](crate::output::VerifyOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::output::VerifyOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    ///   - [`signature_valid(bool)`](crate::output::VerifyOutput::signature_valid): <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception. </p>
    ///   - [`signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::output::VerifyOutput::signing_algorithm): <p>The signing algorithm that was used to verify the signature.</p>
    /// - On failure, responds with [`SdkError<VerifyError>`](crate::error::VerifyError)
    pub fn verify(&self) -> fluent_builders::Verify {
        fluent_builders::Verify::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelKeyDeletion`.
    ///
    /// <p>Cancels the deletion of a KMS key. When this operation succeeds, the key state of the KMS key is <code>Disabled</code>. To enable the KMS key, use <code>EnableKey</code>. </p>
    /// <p>For more information about scheduling and canceling deletion of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CancelKeyDeletion</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>ScheduleKeyDeletion</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelKeyDeletion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_key_deletion_input::Builder,
    }
    impl CancelKeyDeletion {
        /// Creates a new `CancelKeyDeletion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelKeyDeletionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelKeyDeletionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key whose deletion is being canceled.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key whose deletion is being canceled.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConnectCustomKeyStore`.
    ///
    /// <p>Connects or reconnects a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> to its associated CloudHSM cluster.</p>
    /// <p>The custom key store must be connected before you can create KMS keys in the key store or use the KMS keys it contains. You can disconnect and reconnect a custom key store at any time.</p>
    /// <p>To connect a custom key store, its associated CloudHSM cluster must have at least one active HSM. To get the number of active HSMs in a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation. To add HSMs to the cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation. Also, the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user</a> (CU) must not be logged into the cluster. This prevents KMS from using this account to log in.</p>
    /// <p>The connection process can take an extended amount of time to complete; up to 20 minutes. This operation starts the connection process, but it does not wait for it to complete. When it succeeds, this operation quickly returns an HTTP 200 response and a JSON object with no properties. However, this response does not indicate that the custom key store is connected. To get the connection state of the custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// <p>During the connection process, KMS finds the CloudHSM cluster that is associated with the custom key store, creates the connection infrastructure, connects to the cluster, logs into the CloudHSM client as the <code>kmsuser</code> CU, and rotates its password.</p>
    /// <p>The <code>ConnectCustomKeyStore</code> operation might fail for various reasons. To find the reason, use the <code>DescribeCustomKeyStores</code> operation and see the <code>ConnectionErrorCode</code> in the response. For help interpreting the <code>ConnectionErrorCode</code>, see <code>CustomKeyStoresListEntry</code>.</p>
    /// <p>To fix the failure, use the <code>DisconnectCustomKeyStore</code> operation to disconnect the custom key store, correct the error, use the <code>UpdateCustomKeyStore</code> operation if necessary, and then use <code>ConnectCustomKeyStore</code> again.</p>
    /// <p>If you are having trouble connecting or disconnecting a custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ConnectCustomKeyStore</a> (IAM policy)</p>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DeleteCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DescribeCustomKeyStores</code> </p> </li>
    /// <li> <p> <code>DisconnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>UpdateCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConnectCustomKeyStore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::connect_custom_key_store_input::Builder,
    }
    impl ConnectCustomKeyStore {
        /// Creates a new `ConnectCustomKeyStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConnectCustomKeyStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::ConnectCustomKeyStoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enter the key store ID of the custom key store that you want to connect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Enter the key store ID of the custom key store that you want to connect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Creates a friendly name for a KMS key. </p> <note>
    /// <p>Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    /// <p>You can use an alias to identify a KMS key in the KMS console, in the <code>DescribeKey</code> operation and in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a>, such as <code>Encrypt</code> and <code>GenerateDataKey</code>. You can also change the KMS key that's associated with the alias (<code>UpdateAlias</code>) or delete the alias (<code>DeleteAlias</code>) at any time. These operations don't affect the underlying KMS key. </p>
    /// <p>You can associate the alias with any customer managed key in the same Amazon Web Services Region. Each alias is associated with only one KMS key at a time, but a KMS key can have multiple aliases. A valid KMS key is required. You can't create an alias without a KMS key.</p>
    /// <p>The alias must be unique in the account and Region, but you can have aliases with the same name in different Regions. For detailed information about aliases, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html">Using aliases</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>This operation does not return a response. To get the alias that you created, use the <code>ListAliases</code> operation.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on an alias in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CreateAlias</a> on the alias (IAM policy).</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CreateAlias</a> on the KMS key (key policy).</p> </li>
    /// </ul>
    /// <p>For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access">Controlling access to aliases</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>DeleteAlias</code> </p> </li>
    /// <li> <p> <code>ListAliases</code> </p> </li>
    /// <li> <p> <code>UpdateAlias</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl CreateAlias {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the alias name. This value must begin with <code>alias/</code> followed by a name, such as <code>alias/ExampleAlias</code>. </p>
        /// <p>The <code>AliasName</code> value must be string of 1-256 characters. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). The alias name cannot begin with <code>alias/aws/</code>. The <code>alias/aws/</code> prefix is reserved for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>Specifies the alias name. This value must begin with <code>alias/</code> followed by a name, such as <code>alias/ExampleAlias</code>. </p>
        /// <p>The <code>AliasName</code> value must be string of 1-256 characters. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). The alias name cannot begin with <code>alias/aws/</code>. The <code>alias/aws/</code> prefix is reserved for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed keys</a>.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>Associates the alias with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>. The KMS key must be in the same Amazon Web Services Region. </p>
        /// <p>A valid key ID is required. If you supply a null or empty string value, this operation returns an error.</p>
        /// <p>For help finding the key ID and ARN, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn">Finding the Key ID and ARN</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn target_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_key_id(input.into());
            self
        }
        /// <p>Associates the alias with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>. The KMS key must be in the same Amazon Web Services Region. </p>
        /// <p>A valid key ID is required. If you supply a null or empty string value, this operation returns an error.</p>
        /// <p>For help finding the key ID and ARN, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn">Finding the Key ID and ARN</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_target_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomKeyStore`.
    ///
    /// <p>Creates a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> that is associated with an <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html">CloudHSM cluster</a> that you own and manage.</p>
    /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    /// <p>Before you create the custom key store, you must assemble the required elements, including an CloudHSM cluster that fulfills the requirements for a custom key store. For details about the required elements, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>When the operation completes successfully, it returns the ID of the new custom key store. Before you can use your new custom key store, you need to use the <code>ConnectCustomKeyStore</code> operation to connect the new key store to its CloudHSM cluster. Even if you are not going to use your custom key store immediately, you might want to connect it to verify that all settings are correct and then disconnect it until you are ready to use it.</p>
    /// <p>For help with failures, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CreateCustomKeyStore</a> (IAM policy).</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ConnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DeleteCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DescribeCustomKeyStores</code> </p> </li>
    /// <li> <p> <code>DisconnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>UpdateCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomKeyStore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_key_store_input::Builder,
    }
    impl CreateCustomKeyStore {
        /// Creates a new `CreateCustomKeyStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomKeyStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomKeyStoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account.</p>
        pub fn custom_key_store_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_name(input.into());
            self
        }
        /// <p>Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account.</p>
        pub fn set_custom_key_store_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_name(input);
            self
        }
        /// <p>Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
        pub fn cloud_hsm_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_hsm_cluster_id(input.into());
            self
        }
        /// <p>Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
        pub fn set_cloud_hsm_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_hsm_cluster_id(input);
            self
        }
        /// <p>Enter the content of the trust anchor certificate for the cluster. This is the content of the <code>customerCA.crt</code> file that you created when you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the cluster</a>.</p>
        pub fn trust_anchor_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_anchor_certificate(input.into());
            self
        }
        /// <p>Enter the content of the trust anchor certificate for the cluster. This is the content of the <code>customerCA.crt</code> file that you created when you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the cluster</a>.</p>
        pub fn set_trust_anchor_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trust_anchor_certificate(input);
            self
        }
        /// <p>Enter the password of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user (CU) account</a> in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.</p>
        /// <p>The password must be a string of 7 to 32 characters. Its value is case sensitive.</p>
        /// <p>This parameter tells KMS the <code>kmsuser</code> account password; it does not change the password in the CloudHSM cluster.</p>
        pub fn key_store_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_store_password(input.into());
            self
        }
        /// <p>Enter the password of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user (CU) account</a> in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.</p>
        /// <p>The password must be a string of 7 to 32 characters. Its value is case sensitive.</p>
        /// <p>This parameter tells KMS the <code>kmsuser</code> account password; it does not change the password in the CloudHSM cluster.</p>
        pub fn set_key_store_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_store_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGrant`.
    ///
    /// <p>Adds a grant to a KMS key. </p>
    /// <p>A <i>grant</i> is a policy instrument that allows Amazon Web Services principals to use KMS keys in cryptographic operations. It also can allow them to view a KMS key (<code>DescribeKey</code>) and create and manage grants. When authorizing access to a KMS key, grants are considered along with key policies and IAM policies. Grants are often used for temporary permissions because you can create one, use its permissions, and delete it without changing your key policies or IAM policies. </p>
    /// <p>For detailed information about grants, including grant terminology, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Using grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. For examples of working with grants in several programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html">Programming grants</a>. </p>
    /// <p>The <code>CreateGrant</code> operation returns a <code>GrantToken</code> and a <code>GrantId</code>.</p>
    /// <ul>
    /// <li> <p>When you create, retire, or revoke a grant, there might be a brief delay, usually less than five minutes, until the grant is available throughout KMS. This state is known as <i>eventual consistency</i>. Once the grant has achieved eventual consistency, the grantee principal can use the permissions in the grant without identifying the grant. </p> <p>However, to use the permissions in the grant immediately, use the <code>GrantToken</code> that <code>CreateGrant</code> returns. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>
    /// <li> <p>The <code>CreateGrant</code> operation also returns a <code>GrantId</code>. You can use the <code>GrantId</code> and a key identifier to identify the grant in the <code>RetireGrant</code> and <code>RevokeGrant</code> operations. To find the grant ID, use the <code>ListGrants</code> or <code>ListRetirableGrants</code> operations.</p> </li>
    /// </ul>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation on a KMS key in a different Amazon Web Services account, specify the key ARN in the value of the <code>KeyId</code> parameter. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CreateGrant</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ListGrants</code> </p> </li>
    /// <li> <p> <code>ListRetirableGrants</code> </p> </li>
    /// <li> <p> <code>RetireGrant</code> </p> </li>
    /// <li> <p> <code>RevokeGrant</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGrant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_grant_input::Builder,
    }
    impl CreateGrant {
        /// Creates a new `CreateGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGrantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key for the grant. The grant gives principals permission to use this KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key for the grant. The grant gives principals permission to use this KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The identity that gets the permissions specified in the grant.</p>
        /// <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, IAM roles, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn grantee_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_principal(input.into());
            self
        }
        /// <p>The identity that gets the permissions specified in the grant.</p>
        /// <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, IAM roles, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_grantee_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grantee_principal(input);
            self
        }
        /// <p>The principal that has permission to use the <code>RetireGrant</code> operation to retire the grant. </p>
        /// <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The grant determines the retiring principal. Other principals might have permission to retire the grant or revoke the grant. For details, see <code>RevokeGrant</code> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete">Retiring and revoking grants</a> in the <i>Key Management Service Developer Guide</i>. </p>
        pub fn retiring_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.retiring_principal(input.into());
            self
        }
        /// <p>The principal that has permission to use the <code>RetireGrant</code> operation to retire the grant. </p>
        /// <p>To specify the principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax to use for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The grant determines the retiring principal. Other principals might have permission to retire the grant or revoke the grant. For details, see <code>RevokeGrant</code> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete">Retiring and revoking grants</a> in the <i>Key Management Service Developer Guide</i>. </p>
        pub fn set_retiring_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_retiring_principal(input);
            self
        }
        /// Appends an item to `Operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>A list of operations that the grant permits. </p>
        /// <p>The operation must be supported on the KMS key. For example, you cannot create a grant for a symmetric KMS key that allows the <code>Sign</code> operation, or a grant for an asymmetric KMS key that allows the <code>GenerateDataKey</code> operation. If you try, KMS returns a <code>ValidationError</code> exception. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations">Grant operations</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn operations(mut self, input: crate::model::GrantOperation) -> Self {
            self.inner = self.inner.operations(input);
            self
        }
        /// <p>A list of operations that the grant permits. </p>
        /// <p>The operation must be supported on the KMS key. For example, you cannot create a grant for a symmetric KMS key that allows the <code>Sign</code> operation, or a grant for an asymmetric KMS key that allows the <code>GenerateDataKey</code> operation. If you try, KMS returns a <code>ValidationError</code> exception. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations">Grant operations</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantOperation>>,
        ) -> Self {
            self.inner = self.inner.set_operations(input);
            self
        }
        /// <p>Specifies a grant constraint. </p>
        /// <p>KMS supports the <code>EncryptionContextEquals</code> and <code>EncryptionContextSubset</code> grant constraints. Each constraint value can include up to 8 encryption context pairs. The encryption context value in each constraint cannot exceed 384 characters.</p>
        /// <p>These grant constraints allow the permissions in the grant only when the encryption context in the request matches (<code>EncryptionContextEquals</code>) or includes (<code>EncryptionContextSubset</code>) the encryption context specified in this structure. For information about grant constraints, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-grant-overview.html#grant-constraints">Using grant constraints</a> in the <i>Key Management Service Developer Guide</i>. For more information about encryption context, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. </p>
        /// <p>The encryption context grant constraints are supported only on operations that include an encryption context. You cannot use an encryption context grant constraint for cryptographic operations with asymmetric KMS keys or for management operations, such as <code>DescribeKey</code> or <code>RetireGrant</code>.</p>
        pub fn constraints(mut self, input: crate::model::GrantConstraints) -> Self {
            self.inner = self.inner.constraints(input);
            self
        }
        /// <p>Specifies a grant constraint. </p>
        /// <p>KMS supports the <code>EncryptionContextEquals</code> and <code>EncryptionContextSubset</code> grant constraints. Each constraint value can include up to 8 encryption context pairs. The encryption context value in each constraint cannot exceed 384 characters.</p>
        /// <p>These grant constraints allow the permissions in the grant only when the encryption context in the request matches (<code>EncryptionContextEquals</code>) or includes (<code>EncryptionContextSubset</code>) the encryption context specified in this structure. For information about grant constraints, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-grant-overview.html#grant-constraints">Using grant constraints</a> in the <i>Key Management Service Developer Guide</i>. For more information about encryption context, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. </p>
        /// <p>The encryption context grant constraints are supported only on operations that include an encryption context. You cannot use an encryption context grant constraint for cryptographic operations with asymmetric KMS keys or for management operations, such as <code>DescribeKey</code> or <code>RetireGrant</code>.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::GrantConstraints>,
        ) -> Self {
            self.inner = self.inner.set_constraints(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens. </p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens. </p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
        /// <p>A friendly name for the grant. Use this value to prevent the unintended creation of duplicate grants when retrying this request.</p>
        /// <p>When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended duplicates when you retry the <code>CreateGrant</code> request.</p>
        /// <p>When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if the grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note that the returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate <code>GrantId</code> is returned. All grant tokens for the same grant ID can be used interchangeably.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name for the grant. Use this value to prevent the unintended creation of duplicate grants when retrying this request.</p>
        /// <p>When this value is absent, all <code>CreateGrant</code> requests result in a new grant with a unique <code>GrantId</code> even if all the supplied parameters are identical. This can result in unintended duplicates when you retry the <code>CreateGrant</code> request.</p>
        /// <p>When this value is present, you can retry a <code>CreateGrant</code> request with identical parameters; if the grant already exists, the original <code>GrantId</code> is returned without creating a new grant. Note that the returned grant token is unique with every <code>CreateGrant</code> request, even when a duplicate <code>GrantId</code> is returned. All grant tokens for the same grant ID can be used interchangeably.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKey`.
    ///
    /// <p>Creates a unique customer managed <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms-keys">KMS key</a> in your Amazon Web Services account and Region.</p> <note>
    /// <p>KMS is replacing the term <i>customer master key (CMK)</i> with <i>KMS key</i> and <i>KMS key</i>. The concept has not changed. To prevent breaking changes, KMS is keeping some variations of this term.</p>
    /// </note>
    /// <p>You can use the <code>CreateKey</code> operation to create symmetric or asymmetric KMS keys.</p>
    /// <ul>
    /// <li> <p> <b>Symmetric KMS keys</b> contain a 256-bit symmetric key that never leaves KMS unencrypted. To use the KMS key, you must call KMS. You can use a symmetric KMS key to encrypt and decrypt small amounts of data, but they are typically used to generate <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys">data keys</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-key-pairs">data keys pairs</a>. For details, see <code>GenerateDataKey</code> and <code>GenerateDataKeyPair</code>.</p> </li>
    /// <li> <p> <b>Asymmetric KMS keys</b> can contain an RSA key pair or an Elliptic Curve (ECC) key pair. The private key in an asymmetric KMS key never leaves KMS unencrypted. However, you can use the <code>GetPublicKey</code> operation to download the public key so it can be used outside of KMS. KMS keys with RSA key pairs can be used to encrypt or decrypt data or sign and verify messages (but not both). KMS keys with ECC key pairs can be used only to sign and verify messages.</p> </li>
    /// </ul>
    /// <p>For information about symmetric and asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>To create different types of KMS keys, use the following guidance:</p>
    /// <dl>
    /// <dt>
    /// Asymmetric KMS keys
    /// </dt>
    /// <dd>
    /// <p>To create an asymmetric KMS key, use the <code>KeySpec</code> parameter to specify the type of key material in the KMS key. Then, use the <code>KeyUsage</code> parameter to determine whether the KMS key will be used to encrypt and decrypt or sign and verify. You can't change these properties after the KMS key is created.</p>
    /// <p> </p>
    /// </dd>
    /// <dt>
    /// Symmetric KMS keys
    /// </dt>
    /// <dd>
    /// <p>When creating a symmetric KMS key, you don't need to specify the <code>KeySpec</code> or <code>KeyUsage</code> parameters. The default value for <code>KeySpec</code>, <code>SYMMETRIC_DEFAULT</code>, and the default value for <code>KeyUsage</code>, <code>ENCRYPT_DECRYPT</code>, are the only valid values for symmetric KMS keys. </p>
    /// <p> </p>
    /// </dd>
    /// <dt>
    /// Multi-Region primary keys
    /// </dt>
    /// <dt>
    /// Imported key material
    /// </dt>
    /// <dd>
    /// <p>To create a multi-Region <i>primary key</i> in the local Amazon Web Services Region, use the <code>MultiRegion</code> parameter with a value of <code>True</code>. To create a multi-Region <i>replica key</i>, that is, a KMS key with the same key ID and key material as a primary key, but in a different Amazon Web Services Region, use the <code>ReplicateKey</code> operation. To change a replica key to a primary key, and its primary key to a replica key, use the <code>UpdatePrimaryRegion</code> operation.</p>
    /// <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>You can create symmetric and asymmetric multi-Region keys and multi-Region keys with imported key material. You cannot create multi-Region keys in a custom key store.</p>
    /// <p> </p>
    /// </dd>
    /// <dd>
    /// <p>To import your own key material, begin by creating a symmetric KMS key with no key material. To do this, use the <code>Origin</code> parameter of <code>CreateKey</code> with a value of <code>EXTERNAL</code>. Next, use <code>GetParametersForImport</code> operation to get a public key and import token, and use the public key to encrypt your key material. Then, use <code>ImportKeyMaterial</code> with your import token to import the key material. For step-by-step instructions, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. You cannot import the key material into an asymmetric KMS key.</p>
    /// <p>To create a multi-Region primary key with imported key material, use the <code>Origin</code> parameter of <code>CreateKey</code> with a value of <code>EXTERNAL</code> and the <code>MultiRegion</code> parameter with a value of <code>True</code>. To create replicas of the multi-Region primary key, use the <code>ReplicateKey</code> operation. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> </p>
    /// </dd>
    /// <dt>
    /// Custom key store
    /// </dt>
    /// <dd>
    /// <p>To create a symmetric KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, use the <code>CustomKeyStoreId</code> parameter to specify the custom key store. You must also use the <code>Origin</code> parameter with a value of <code>AWS_CLOUDHSM</code>. The CloudHSM cluster that is associated with the custom key store must have at least two active HSMs in different Availability Zones in the Amazon Web Services Region. </p>
    /// <p>You cannot create an asymmetric KMS key in a custom key store. For information about custom key stores in KMS see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Using Custom Key Stores</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
    /// </dd>
    /// </dl>
    /// <p> <b>Cross-account use</b>: No. You cannot use this operation to create a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:CreateKey</a> (IAM policy). To use the <code>Tags</code> parameter, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> (IAM policy). For examples and information about related permissions, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policy-example-create-key">Allow a user to create KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>DescribeKey</code> </p> </li>
    /// <li> <p> <code>ListKeys</code> </p> </li>
    /// <li> <p> <code>ScheduleKeyDeletion</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_key_input::Builder,
    }
    impl CreateKey {
        /// Creates a new `CreateKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The key policy to attach to the KMS key.</p>
        /// <p>If you provide a key policy, it must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>CreateKey</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If you do not provide a key policy, KMS attaches a default key policy to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default Key Policy</a> in the <i>Key Management Service Developer Guide</i>. </p>
        /// <p>The key policy size quota is 32 kilobytes (32768 bytes).</p>
        /// <p>For help writing and formatting a JSON policy document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The key policy to attach to the KMS key.</p>
        /// <p>If you provide a key policy, it must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>CreateKey</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>
        /// </ul>
        /// <p>If you do not provide a key policy, KMS attaches a default key policy to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default Key Policy</a> in the <i>Key Management Service Developer Guide</i>. </p>
        /// <p>The key policy size quota is 32 kilobytes (32768 bytes).</p>
        /// <p>For help writing and formatting a JSON policy document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>A description of the KMS key.</p>
        /// <p>Use a description that helps you decide whether the KMS key is appropriate for a task. The default value is an empty string (no description).</p>
        /// <p>To set or change the description after the key is created, use <code>UpdateKeyDescription</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the KMS key.</p>
        /// <p>Use a description that helps you decide whether the KMS key is appropriate for a task. The default value is an empty string (no description).</p>
        /// <p>To set or change the description after the key is created, use <code>UpdateKeyDescription</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code>. This parameter is required only for asymmetric KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.</p>
        /// <p>Select only one valid value.</p>
        /// <ul>
        /// <li> <p>For symmetric KMS keys, omit the parameter or specify <code>ENCRYPT_DECRYPT</code>.</p> </li>
        /// <li> <p>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code>.</p> </li>
        /// <li> <p>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code>.</p> </li>
        /// </ul>
        pub fn key_usage(mut self, input: crate::model::KeyUsageType) -> Self {
            self.inner = self.inner.key_usage(input);
            self
        }
        /// <p>Determines the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key. The default value is <code>ENCRYPT_DECRYPT</code>. This parameter is required only for asymmetric KMS keys. You can't change the <code>KeyUsage</code> value after the KMS key is created.</p>
        /// <p>Select only one valid value.</p>
        /// <ul>
        /// <li> <p>For symmetric KMS keys, omit the parameter or specify <code>ENCRYPT_DECRYPT</code>.</p> </li>
        /// <li> <p>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code>.</p> </li>
        /// <li> <p>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code>.</p> </li>
        /// </ul>
        pub fn set_key_usage(
            mut self,
            input: std::option::Option<crate::model::KeyUsageType>,
        ) -> Self {
            self.inner = self.inner.set_key_usage(input);
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> parameter.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> parameters work the same way. Only the names differ. We recommend that you use <code>KeySpec</code> parameter in your code. However, to avoid breaking changes, KMS will support both parameters.</p>
        pub fn customer_master_key_spec(
            mut self,
            input: crate::model::CustomerMasterKeySpec,
        ) -> Self {
            self.inner = self.inner.customer_master_key_spec(input);
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> parameter.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> parameters work the same way. Only the names differ. We recommend that you use <code>KeySpec</code> parameter in your code. However, to avoid breaking changes, KMS will support both parameters.</p>
        pub fn set_customer_master_key_spec(
            mut self,
            input: std::option::Option<crate::model::CustomerMasterKeySpec>,
        ) -> Self {
            self.inner = self.inner.set_customer_master_key_spec(input);
            self
        }
        /// <p>Specifies the type of KMS key to create. The default value, <code>SYMMETRIC_DEFAULT</code>, creates a KMS key with a 256-bit symmetric key for encryption and decryption. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">How to Choose Your KMS key Configuration</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// <p>The <code>KeySpec</code> determines whether the KMS key contains a symmetric key or an asymmetric key pair. It also determines the encryption algorithms or signing algorithms that the KMS key supports. You can't change the <code>KeySpec</code> after the KMS key is created. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm">kms:EncryptionAlgorithm</a> or <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm">kms:Signing Algorithm</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p> <important>
        /// <p> <a href="http://aws.amazon.com/kms/features/#AWS_Service_Integration">Amazon Web Services services that are integrated with KMS</a> use symmetric KMS keys to protect your data. These services do not support asymmetric KMS keys. For help determining whether a KMS key is symmetric or asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>KMS supports the following key specs for KMS keys:</p>
        /// <ul>
        /// <li> <p>Symmetric key (default)</p>
        /// <ul>
        /// <li> <p> <code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</p> </li>
        /// </ul> </li>
        /// <li> <p>Asymmetric RSA key pairs</p>
        /// <ul>
        /// <li> <p> <code>RSA_2048</code> </p> </li>
        /// <li> <p> <code>RSA_3072</code> </p> </li>
        /// <li> <p> <code>RSA_4096</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Asymmetric NIST-recommended elliptic curve key pairs</p>
        /// <ul>
        /// <li> <p> <code>ECC_NIST_P256</code> (secp256r1)</p> </li>
        /// <li> <p> <code>ECC_NIST_P384</code> (secp384r1)</p> </li>
        /// <li> <p> <code>ECC_NIST_P521</code> (secp521r1)</p> </li>
        /// </ul> </li>
        /// <li> <p>Other asymmetric elliptic curve key pairs</p>
        /// <ul>
        /// <li> <p> <code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn key_spec(mut self, input: crate::model::KeySpec) -> Self {
            self.inner = self.inner.key_spec(input);
            self
        }
        /// <p>Specifies the type of KMS key to create. The default value, <code>SYMMETRIC_DEFAULT</code>, creates a KMS key with a 256-bit symmetric key for encryption and decryption. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">How to Choose Your KMS key Configuration</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// <p>The <code>KeySpec</code> determines whether the KMS key contains a symmetric key or an asymmetric key pair. It also determines the encryption algorithms or signing algorithms that the KMS key supports. You can't change the <code>KeySpec</code> after the KMS key is created. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm">kms:EncryptionAlgorithm</a> or <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm">kms:Signing Algorithm</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p> <important>
        /// <p> <a href="http://aws.amazon.com/kms/features/#AWS_Service_Integration">Amazon Web Services services that are integrated with KMS</a> use symmetric KMS keys to protect your data. These services do not support asymmetric KMS keys. For help determining whether a KMS key is symmetric or asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>KMS supports the following key specs for KMS keys:</p>
        /// <ul>
        /// <li> <p>Symmetric key (default)</p>
        /// <ul>
        /// <li> <p> <code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</p> </li>
        /// </ul> </li>
        /// <li> <p>Asymmetric RSA key pairs</p>
        /// <ul>
        /// <li> <p> <code>RSA_2048</code> </p> </li>
        /// <li> <p> <code>RSA_3072</code> </p> </li>
        /// <li> <p> <code>RSA_4096</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Asymmetric NIST-recommended elliptic curve key pairs</p>
        /// <ul>
        /// <li> <p> <code>ECC_NIST_P256</code> (secp256r1)</p> </li>
        /// <li> <p> <code>ECC_NIST_P384</code> (secp384r1)</p> </li>
        /// <li> <p> <code>ECC_NIST_P521</code> (secp521r1)</p> </li>
        /// </ul> </li>
        /// <li> <p>Other asymmetric elliptic curve key pairs</p>
        /// <ul>
        /// <li> <p> <code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_key_spec(mut self, input: std::option::Option<crate::model::KeySpec>) -> Self {
            self.inner = self.inner.set_key_spec(input);
            self
        }
        /// <p>The source of the key material for the KMS key. You cannot change the origin after you create the KMS key. The default is <code>AWS_KMS</code>, which means that KMS creates the key material.</p>
        /// <p>To create a KMS key with no key material (for imported key material), set the value to <code>EXTERNAL</code>. For more information about importing key material into KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>. This value is valid only for symmetric KMS keys.</p>
        /// <p>To create a KMS key in an KMS <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and create its key material in the associated CloudHSM cluster, set this value to <code>AWS_CLOUDHSM</code>. You must also use the <code>CustomKeyStoreId</code> parameter to identify the custom key store. This value is valid only for symmetric KMS keys.</p>
        pub fn origin(mut self, input: crate::model::OriginType) -> Self {
            self.inner = self.inner.origin(input);
            self
        }
        /// <p>The source of the key material for the KMS key. You cannot change the origin after you create the KMS key. The default is <code>AWS_KMS</code>, which means that KMS creates the key material.</p>
        /// <p>To create a KMS key with no key material (for imported key material), set the value to <code>EXTERNAL</code>. For more information about importing key material into KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>. This value is valid only for symmetric KMS keys.</p>
        /// <p>To create a KMS key in an KMS <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and create its key material in the associated CloudHSM cluster, set this value to <code>AWS_CLOUDHSM</code>. You must also use the <code>CustomKeyStoreId</code> parameter to identify the custom key store. This value is valid only for symmetric KMS keys.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::OriginType>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
        /// <p>Creates the KMS key in the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and the key material in its associated CloudHSM cluster. To create a KMS key in a custom key store, you must also specify the <code>Origin</code> parameter with a value of <code>AWS_CLOUDHSM</code>. The CloudHSM cluster that is associated with the custom key store must have at least two active HSMs, each in a different Availability Zone in the Region.</p>
        /// <p>This parameter is valid only for symmetric KMS keys and regional KMS keys. You cannot create an asymmetric KMS key or a multi-Region key in a custom key store.</p>
        /// <p>To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        /// <p>The response includes the custom key store ID and the ID of the CloudHSM cluster.</p>
        /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Creates the KMS key in the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> and the key material in its associated CloudHSM cluster. To create a KMS key in a custom key store, you must also specify the <code>Origin</code> parameter with a value of <code>AWS_CLOUDHSM</code>. The CloudHSM cluster that is associated with the custom key store must have at least two active HSMs, each in a different Availability Zone in the Region.</p>
        /// <p>This parameter is valid only for symmetric KMS keys and regional KMS keys. You cannot create an asymmetric KMS key or a multi-Region key in a custom key store.</p>
        /// <p>To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        /// <p>The response includes the custom key store ID and the ID of the CloudHSM cluster.</p>
        /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// </important>
        /// <p>Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn bypass_policy_lockout_safety_check(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_policy_lockout_safety_check(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
        /// </important>
        /// <p>Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bypass_policy_lockout_safety_check(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags to the KMS key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        /// <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>
        /// <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        /// <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Assigns one or more tags to the KMS key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        /// <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>
        /// <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        /// <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Creates a multi-Region primary key that you can replicate into other Amazon Web Services Regions. You cannot change this value after you create the KMS key. </p>
        /// <p>For a multi-Region key, set this parameter to <code>True</code>. For a single-Region KMS key, omit this parameter or set it to <code>False</code>. The default value is <code>False</code>.</p>
        /// <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>This value creates a <i>primary key</i>, not a replica. To create a <i>replica key</i>, use the <code>ReplicateKey</code> operation. </p>
        /// <p>You can create a symmetric or asymmetric multi-Region key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.</p>
        pub fn multi_region(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_region(input);
            self
        }
        /// <p>Creates a multi-Region primary key that you can replicate into other Amazon Web Services Regions. You cannot change this value after you create the KMS key. </p>
        /// <p>For a multi-Region key, set this parameter to <code>True</code>. For a single-Region KMS key, omit this parameter or set it to <code>False</code>. The default value is <code>False</code>.</p>
        /// <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>This value creates a <i>primary key</i>, not a replica. To create a <i>replica key</i>, use the <code>ReplicateKey</code> operation. </p>
        /// <p>You can create a symmetric or asymmetric multi-Region key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.</p>
        pub fn set_multi_region(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Decrypt`.
    ///
    /// <p>Decrypts ciphertext that was encrypted by a KMS key using any of the following operations:</p>
    /// <ul>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyWithoutPlaintext</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPairWithoutPlaintext</code> </p> </li>
    /// </ul>
    /// <p>You can use this operation to decrypt ciphertext that was encrypted under a symmetric or asymmetric KMS key. When the KMS key is asymmetric, you must specify the KMS key and the encryption algorithm that was used to encrypt the ciphertext. For information about symmetric and asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The Decrypt operation also decrypts ciphertext that was encrypted outside of KMS by the public key in an KMS asymmetric KMS key. However, it cannot decrypt ciphertext produced by other libraries, such as the <a href="https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/">Amazon Web Services Encryption SDK</a> or <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 client-side encryption</a>. These libraries return a ciphertext format that is incompatible with KMS.</p>
    /// <p>If the ciphertext was encrypted under a symmetric KMS key, the <code>KeyId</code> parameter is optional. KMS can get this information from metadata that it adds to the symmetric ciphertext blob. This feature adds durability to your implementation by ensuring that authorized users can decrypt ciphertext decades after it was encrypted, even if they've lost track of the key ID. However, specifying the KMS key is always recommended as a best practice. When you use the <code>KeyId</code> parameter to specify a KMS key, KMS only uses the KMS key you specify. If the ciphertext was encrypted under a different KMS key, the <code>Decrypt</code> operation fails. This practice ensures that you use the KMS key that you intend.</p>
    /// <p>Whenever possible, use key policies to give users permission to call the <code>Decrypt</code> operation on a particular KMS key, instead of using IAM policies. Otherwise, you might create an IAM user policy that gives the user <code>Decrypt</code> permission on all KMS keys. This user could decrypt ciphertext that was encrypted by KMS keys in other accounts if the key policy for the cross-account KMS key permits it. If you must use an IAM policy for <code>Decrypt</code> permissions, limit the user to particular KMS keys or particular trusted accounts. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policies-best-practices">Best practices for IAM policies</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Applications in Amazon Web Services Nitro Enclaves can call this operation by using the <a href="https://github.com/aws/aws-nitro-enclaves-sdk-c">Amazon Web Services Nitro Enclaves Development Kit</a>. For information about the supporting parameters, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves use KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:Decrypt</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// <li> <p> <code>ReEncrypt</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Decrypt {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::decrypt_input::Builder,
    }
    impl Decrypt {
        /// Creates a new `Decrypt`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DecryptOutput,
            aws_smithy_http::result::SdkError<crate::error::DecryptError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Ciphertext to be decrypted. The blob includes metadata.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.ciphertext_blob(input);
            self
        }
        /// <p>Ciphertext to be decrypted. The blob includes metadata.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_ciphertext_blob(input);
            self
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context to use when decrypting the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context to use when decrypting the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens. </p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens. </p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
        /// <p>Specifies the KMS key that KMS uses to decrypt the ciphertext. Enter a key ID of the KMS key that was used to encrypt the ciphertext. </p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Specifies the KMS key that KMS uses to decrypt the ciphertext. Enter a key ID of the KMS key that was used to encrypt the ciphertext. </p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the <code>Decrypt</code> operation fails.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the only supported algorithm that is valid for symmetric KMS keys.</p>
        pub fn encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.inner = self.inner.encryption_algorithm(input);
            self
        }
        /// <p>Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the <code>Decrypt</code> operation fails.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the only supported algorithm that is valid for symmetric KMS keys.</p>
        pub fn set_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_encryption_algorithm(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlias`.
    ///
    /// <p>Deletes the specified alias. </p> <note>
    /// <p>Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    /// <p>Because an alias is not a property of a KMS key, you can delete and change the aliases of a KMS key without affecting the KMS key. Also, aliases do not appear in the response from the <code>DescribeKey</code> operation. To get the aliases of all KMS keys, use the <code>ListAliases</code> operation. </p>
    /// <p>Each KMS key can have multiple aliases. To change the alias of a KMS key, use <code>DeleteAlias</code> to delete the current alias and <code>CreateAlias</code> to create a new alias. To associate an existing alias with a different KMS key, call <code>UpdateAlias</code>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on an alias in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DeleteAlias</a> on the alias (IAM policy).</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DeleteAlias</a> on the KMS key (key policy).</p> </li>
    /// </ul>
    /// <p>For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access">Controlling access to aliases</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateAlias</code> </p> </li>
    /// <li> <p> <code>ListAliases</code> </p> </li>
    /// <li> <p> <code>UpdateAlias</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_alias_input::Builder,
    }
    impl DeleteAlias {
        /// Creates a new `DeleteAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias to be deleted. The alias name must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The alias to be deleted. The alias name must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomKeyStore`.
    ///
    /// <p>Deletes a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. This operation does not delete the CloudHSM cluster that is associated with the custom key store, or affect any users or keys in the cluster.</p>
    /// <p>The custom key store that you delete cannot contain any KMS <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS keys</a>. Before deleting the key store, verify that you will never need to use any of the KMS keys in the key store for any <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a>. Then, use <code>ScheduleKeyDeletion</code> to delete the KMS keys from the key store. When the scheduled waiting period expires, the <code>ScheduleKeyDeletion</code> operation deletes the KMS keys. Then it makes a best effort to delete the key material from the associated cluster. However, you might need to manually <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key">delete the orphaned key material</a> from the cluster and its backups.</p>
    /// <p>After all KMS keys are deleted from KMS, use <code>DisconnectCustomKeyStore</code> to disconnect the key store from KMS. Then, you can delete the custom key store.</p>
    /// <p>Instead of deleting the custom key store, consider using <code>DisconnectCustomKeyStore</code> to disconnect it from KMS. While the key store is disconnected, you cannot create or use the KMS keys in the key store. But, you do not need to delete KMS keys and you can reconnect a disconnected custom key store at any time.</p>
    /// <p>If the operation succeeds, it returns a JSON object with no properties.</p>
    /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DeleteCustomKeyStore</a> (IAM policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ConnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>CreateCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DescribeCustomKeyStores</code> </p> </li>
    /// <li> <p> <code>DisconnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>UpdateCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomKeyStore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_key_store_input::Builder,
    }
    impl DeleteCustomKeyStore {
        /// Creates a new `DeleteCustomKeyStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomKeyStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomKeyStoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enter the ID of the custom key store you want to delete. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Enter the ID of the custom key store you want to delete. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImportedKeyMaterial`.
    ///
    /// <p>Deletes key material that you previously imported. This operation makes the specified KMS key unusable. For more information about importing key material into KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>. </p>
    /// <p>When the specified KMS key is in the <code>PendingDeletion</code> state, this operation does not change the KMS key's state. Otherwise, it changes the KMS key's state to <code>PendingImport</code>.</p>
    /// <p>After you delete key material, you can use <code>ImportKeyMaterial</code> to reimport the same key material into the KMS key.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DeleteImportedKeyMaterial</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>GetParametersForImport</code> </p> </li>
    /// <li> <p> <code>ImportKeyMaterial</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImportedKeyMaterial {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_imported_key_material_input::Builder,
    }
    impl DeleteImportedKeyMaterial {
        /// Creates a new `DeleteImportedKeyMaterial`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImportedKeyMaterialOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImportedKeyMaterialError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key from which you are deleting imported key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key from which you are deleting imported key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomKeyStores`.
    ///
    /// <p>Gets information about <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key stores</a> in the account and Region.</p>
    /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    /// <p>By default, this operation returns information about all custom key stores in the account and Region. To get only information about a particular custom key store, use either the <code>CustomKeyStoreName</code> or <code>CustomKeyStoreId</code> parameter (but not both).</p>
    /// <p>To determine whether the custom key store is connected to its CloudHSM cluster, use the <code>ConnectionState</code> element in the response. If an attempt to connect the custom key store failed, the <code>ConnectionState</code> value is <code>FAILED</code> and the <code>ConnectionErrorCode</code> element in the response indicates the cause of the failure. For help interpreting the <code>ConnectionErrorCode</code>, see <code>CustomKeyStoresListEntry</code>.</p>
    /// <p>Custom key stores have a <code>DISCONNECTED</code> connection state if the key store has never been connected or you use the <code>DisconnectCustomKeyStore</code> operation to disconnect it. If your custom key store state is <code>CONNECTED</code> but you are having trouble using it, make sure that its associated CloudHSM cluster is active and contains the minimum number of HSMs required for the operation, if any.</p>
    /// <p> For help repairing your custom key store, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting Custom Key Stores</a> topic in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DescribeCustomKeyStores</a> (IAM policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ConnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>CreateCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DeleteCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DisconnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>UpdateCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomKeyStores {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_key_stores_input::Builder,
    }
    impl DescribeCustomKeyStores {
        /// Creates a new `DescribeCustomKeyStores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomKeyStoresOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomKeyStoresError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Gets only information about the specified custom key store. Enter the key store ID.</p>
        /// <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Gets only information about the specified custom key store. Enter the key store ID.</p>
        /// <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
        /// <p>Gets only information about the specified custom key store. Enter the friendly name of the custom key store.</p>
        /// <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
        pub fn custom_key_store_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_name(input.into());
            self
        }
        /// <p>Gets only information about the specified custom key store. Enter the friendly name of the custom key store.</p>
        /// <p>By default, this operation gets information about all custom key stores in the account and Region. To limit the output to a particular custom key store, you can use either the <code>CustomKeyStoreId</code> or <code>CustomKeyStoreName</code> parameter, but not both.</p>
        pub fn set_custom_key_store_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_name(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKey`.
    ///
    /// <p>Provides detailed information about a KMS key. You can run <code>DescribeKey</code> on a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> or an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>.</p>
    /// <p>This detailed information includes the key ARN, creation date (and deletion date, if applicable), the key state, and the origin and expiration date (if any) of the key material. It includes fields, like <code>KeySpec</code>, that help you distinguish symmetric from asymmetric KMS keys. It also provides information that is particularly important to asymmetric keys, such as the key usage (encryption or signing) and the encryption algorithms or signing algorithms that the KMS key supports. For KMS keys in custom key stores, it includes information about the custom key store, such as the key store ID and the CloudHSM cluster ID. For multi-Region keys, it displays the primary key and all related replica keys. </p>
    /// <p> <code>DescribeKey</code> does not return the following information:</p>
    /// <ul>
    /// <li> <p>Aliases associated with the KMS key. To get this information, use <code>ListAliases</code>.</p> </li>
    /// <li> <p>Whether automatic key rotation is enabled on the KMS key. To get this information, use <code>GetKeyRotationStatus</code>. Also, some key states prevent a KMS key from being automatically rotated. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works">How Automatic Key Rotation Works</a> in <i>Key Management Service Developer Guide</i>.</p> </li>
    /// <li> <p>Tags on the KMS key. To get this information, use <code>ListResourceTags</code>.</p> </li>
    /// <li> <p>Key policies and grants on the KMS key. To get this information, use <code>GetKeyPolicy</code> and <code>ListGrants</code>.</p> </li>
    /// </ul>
    /// <p>If you call the <code>DescribeKey</code> operation on a <i>predefined Amazon Web Services alias</i>, that is, an Amazon Web Services alias with no key ID, KMS creates an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>. Then, it associates the alias with the new KMS key, and returns the <code>KeyId</code> and <code>Arn</code> of the new KMS key in the response.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DescribeKey</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>GetKeyPolicy</code> </p> </li>
    /// <li> <p> <code>GetKeyRotationStatus</code> </p> </li>
    /// <li> <p> <code>ListAliases</code> </p> </li>
    /// <li> <p> <code>ListGrants</code> </p> </li>
    /// <li> <p> <code>ListKeys</code> </p> </li>
    /// <li> <p> <code>ListResourceTags</code> </p> </li>
    /// <li> <p> <code>ListRetirableGrants</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_key_input::Builder,
    }
    impl DescribeKey {
        /// Creates a new `DescribeKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Describes the specified KMS key. </p>
        /// <p>If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias with no key ID), KMS associates the alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk">Amazon Web Services managed key</a> and returns its <code>KeyId</code> and <code>Arn</code> in the response.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Describes the specified KMS key. </p>
        /// <p>If you specify a predefined Amazon Web Services alias (an Amazon Web Services alias with no key ID), KMS associates the alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk">Amazon Web Services managed key</a> and returns its <code>KeyId</code> and <code>Arn</code> in the response.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableKey`.
    ///
    /// <p>Sets the state of a KMS key to disabled. This change temporarily prevents use of the KMS key for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a>. </p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DisableKey</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>EnableKey</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_key_input::Builder,
    }
    impl DisableKey {
        /// Creates a new `DisableKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key to disable.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key to disable.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableKeyRotation`.
    ///
    /// <p>Disables <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">automatic rotation of the key material</a> for the specified symmetric KMS key.</p>
    /// <p> You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DisableKeyRotation</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>EnableKeyRotation</code> </p> </li>
    /// <li> <p> <code>GetKeyRotationStatus</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableKeyRotation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_key_rotation_input::Builder,
    }
    impl DisableKeyRotation {
        /// Creates a new `DisableKeyRotation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableKeyRotationOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableKeyRotationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies a symmetric KMS key. You cannot enable or disable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies a symmetric KMS key. You cannot enable or disable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectCustomKeyStore`.
    ///
    /// <p>Disconnects the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> from its associated CloudHSM cluster. While a custom key store is disconnected, you can manage the custom key store and its KMS keys, but you cannot create or use KMS keys in the custom key store. You can reconnect the custom key store at any time.</p> <note>
    /// <p>While a custom key store is disconnected, all attempts to create KMS keys in the custom key store or to use existing KMS keys in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> will fail. This action can prevent users from storing and accessing sensitive data.</p>
    /// </note>
    /// <p></p>
    /// <p>To find the connection state of a custom key store, use the <code>DescribeCustomKeyStores</code> operation. To reconnect a custom key store, use the <code>ConnectCustomKeyStore</code> operation.</p>
    /// <p>If the operation succeeds, it returns a JSON object with no properties.</p>
    /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:DisconnectCustomKeyStore</a> (IAM policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ConnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>CreateCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DeleteCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DescribeCustomKeyStores</code> </p> </li>
    /// <li> <p> <code>UpdateCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectCustomKeyStore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_custom_key_store_input::Builder,
    }
    impl DisconnectCustomKeyStore {
        /// Creates a new `DisconnectCustomKeyStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectCustomKeyStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectCustomKeyStoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enter the ID of the custom key store you want to disconnect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Enter the ID of the custom key store you want to disconnect. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableKey`.
    ///
    /// <p>Sets the key state of a KMS key to enabled. This allows you to use the KMS key for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a>. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:EnableKey</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>DisableKey</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_key_input::Builder,
    }
    impl EnableKey {
        /// Creates a new `EnableKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key to enable.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key to enable.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableKeyRotation`.
    ///
    /// <p>Enables <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">automatic rotation of the key material</a> for the specified symmetric KMS key.</p>
    /// <p>You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:EnableKeyRotation</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>DisableKeyRotation</code> </p> </li>
    /// <li> <p> <code>GetKeyRotationStatus</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableKeyRotation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_key_rotation_input::Builder,
    }
    impl EnableKeyRotation {
        /// Creates a new `EnableKeyRotation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableKeyRotationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableKeyRotationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies a symmetric KMS key. You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies a symmetric KMS key. You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Encrypt`.
    ///
    /// <p>Encrypts plaintext into ciphertext by using a KMS key. The <code>Encrypt</code> operation has two primary use cases:</p>
    /// <ul>
    /// <li> <p>You can encrypt small amounts of arbitrary data, such as a personal identifier or database password, or other sensitive information. </p> </li>
    /// <li> <p>You can use the <code>Encrypt</code> operation to move encrypted data from one Amazon Web Services Region to another. For example, in Region A, generate a data key and use the plaintext key to encrypt your data. Then, in Region A, use the <code>Encrypt</code> operation to encrypt the plaintext data key under a KMS key in Region B. Now, you can move the encrypted data and the encrypted data key to Region B. When necessary, you can decrypt the encrypted data key and the encrypted data entirely within in Region B.</p> </li>
    /// </ul>
    /// <p>You don't need to use the <code>Encrypt</code> operation to encrypt a data key. The <code>GenerateDataKey</code> and <code>GenerateDataKeyPair</code> operations return a plaintext data key and an encrypted copy of that data key.</p>
    /// <p>When you encrypt data, you must specify a symmetric or asymmetric KMS key to use in the encryption operation. The KMS key must have a <code>KeyUsage</code> value of <code>ENCRYPT_DECRYPT.</code> To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation. </p>
    /// <p>If you use a symmetric KMS key, you can use an encryption context to add additional security to your encryption operation. If you specify an <code>EncryptionContext</code> when encrypting data, you must specify the same encryption context (a case-sensitive exact match) when decrypting the data. Otherwise, the request to decrypt fails with an <code>InvalidCiphertextException</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>If you specify an asymmetric KMS key, you must also specify the encryption algorithm. The algorithm must be compatible with the KMS key type.</p> <important>
    /// <p>When you use an asymmetric KMS key to encrypt or reencrypt data, be sure to record the KMS key and encryption algorithm that you choose. You will be required to provide the same KMS key and encryption algorithm when you decrypt the data. If the KMS key and algorithm do not match the values used to encrypt the data, the decrypt operation fails.</p>
    /// <p>You are not required to supply the key ID and encryption algorithm when you decrypt with symmetric KMS keys because KMS stores this information in the ciphertext blob. KMS cannot store metadata in ciphertext generated with asymmetric keys. The standard format for asymmetric key ciphertext does not include configurable fields.</p>
    /// </important>
    /// <p>The maximum size of the data that you can encrypt varies with the type of KMS key and the encryption algorithm that you choose.</p>
    /// <ul>
    /// <li> <p>Symmetric KMS keys</p>
    /// <ul>
    /// <li> <p> <code>SYMMETRIC_DEFAULT</code>: 4096 bytes</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>RSA_2048</code> </p>
    /// <ul>
    /// <li> <p> <code>RSAES_OAEP_SHA_1</code>: 214 bytes</p> </li>
    /// <li> <p> <code>RSAES_OAEP_SHA_256</code>: 190 bytes</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>RSA_3072</code> </p>
    /// <ul>
    /// <li> <p> <code>RSAES_OAEP_SHA_1</code>: 342 bytes</p> </li>
    /// <li> <p> <code>RSAES_OAEP_SHA_256</code>: 318 bytes</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>RSA_4096</code> </p>
    /// <ul>
    /// <li> <p> <code>RSAES_OAEP_SHA_1</code>: 470 bytes</p> </li>
    /// <li> <p> <code>RSAES_OAEP_SHA_256</code>: 446 bytes</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:Encrypt</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Encrypt {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::encrypt_input::Builder,
    }
    impl Encrypt {
        /// Creates a new `Encrypt`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EncryptOutput,
            aws_smithy_http::result::SdkError<crate::error::EncryptError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key to use in the encryption operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key to use in the encryption operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Data to be encrypted.</p>
        pub fn plaintext(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.plaintext(input);
            self
        }
        /// <p>Data to be encrypted.</p>
        pub fn set_plaintext(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_plaintext(input);
            self
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context that will be used to encrypt the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context. </p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context that will be used to encrypt the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric KMS key. The standard asymmetric encryption algorithms that KMS uses do not support an encryption context. </p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to encrypt the plaintext message. The algorithm must be compatible with the KMS key that you specify.</p>
        /// <p>This parameter is required only for asymmetric KMS keys. The default value, <code>SYMMETRIC_DEFAULT</code>, is the algorithm used for symmetric KMS keys. If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.</p>
        pub fn encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.inner = self.inner.encryption_algorithm(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to encrypt the plaintext message. The algorithm must be compatible with the KMS key that you specify.</p>
        /// <p>This parameter is required only for asymmetric KMS keys. The default value, <code>SYMMETRIC_DEFAULT</code>, is the algorithm used for symmetric KMS keys. If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.</p>
        pub fn set_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_encryption_algorithm(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateDataKey`.
    ///
    /// <p>Generates a unique symmetric data key for client-side encryption. This operation returns a plaintext copy of the data key and a copy that is encrypted under a KMS key that you specify. You can use the plaintext key to encrypt your data outside of KMS and store the encrypted data key with the encrypted data.</p>
    /// <p> <code>GenerateDataKey</code> returns a unique data key for each request. The bytes in the plaintext key are not related to the caller or the KMS key.</p>
    /// <p>To generate a data key, specify the symmetric KMS key that will be used to encrypt the data key. You cannot use an asymmetric KMS key to generate data keys. To get the type of your KMS key, use the <code>DescribeKey</code> operation. You must also specify the length of the data key. Use either the <code>KeySpec</code> or <code>NumberOfBytes</code> parameters (but not both). For 128-bit and 256-bit data keys, use the <code>KeySpec</code> parameter. </p>
    /// <p>To get only an encrypted copy of the data key, use <code>GenerateDataKeyWithoutPlaintext</code>. To generate an asymmetric data key pair, use the <code>GenerateDataKeyPair</code> or <code>GenerateDataKeyPairWithoutPlaintext</code> operation. To get a cryptographically secure random byte string, use <code>GenerateRandom</code>.</p>
    /// <p>You can use the optional encryption context to add additional security to the encryption operation. If you specify an <code>EncryptionContext</code>, you must specify the same encryption context (a case-sensitive exact match) when decrypting the encrypted data key. Otherwise, the request to decrypt fails with an <code>InvalidCiphertextException</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Applications in Amazon Web Services Nitro Enclaves can call this operation by using the <a href="https://github.com/aws/aws-nitro-enclaves-sdk-c">Amazon Web Services Nitro Enclaves Development Kit</a>. For information about the supporting parameters, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves use KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>How to use your data key</b> </p>
    /// <p>We recommend that you use the following pattern to encrypt data locally in your application. You can write your own code or use a client-side encryption library, such as the <a href="https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/">Amazon Web Services Encryption SDK</a>, the <a href="https://docs.aws.amazon.com/dynamodb-encryption-client/latest/devguide/">Amazon DynamoDB Encryption Client</a>, or <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 client-side encryption</a> to do these tasks for you.</p>
    /// <p>To encrypt data outside of KMS:</p>
    /// <ol>
    /// <li> <p>Use the <code>GenerateDataKey</code> operation to get a data key.</p> </li>
    /// <li> <p>Use the plaintext data key (in the <code>Plaintext</code> field of the response) to encrypt your data outside of KMS. Then erase the plaintext data key from memory.</p> </li>
    /// <li> <p>Store the encrypted data key (in the <code>CiphertextBlob</code> field of the response) with the encrypted data.</p> </li>
    /// </ol>
    /// <p>To decrypt data outside of KMS:</p>
    /// <ol>
    /// <li> <p>Use the <code>Decrypt</code> operation to decrypt the encrypted data key. The operation returns a plaintext copy of the data key.</p> </li>
    /// <li> <p>Use the plaintext data key to decrypt data outside of KMS, then erase the plaintext data key from memory.</p> </li>
    /// </ol>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GenerateDataKey</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPairWithoutPlaintext</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyWithoutPlaintext</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateDataKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_data_key_input::Builder,
    }
    impl GenerateDataKey {
        /// Creates a new `GenerateDataKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateDataKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the symmetric KMS key that encrypts the data key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the symmetric KMS key that encrypts the data key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context that will be used when encrypting the data key.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context that will be used when encrypting the data key.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// <p>Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the <code>KeySpec</code> parameter.</p>
        /// <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
        pub fn number_of_bytes(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_bytes(input);
            self
        }
        /// <p>Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the <code>KeySpec</code> parameter.</p>
        /// <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
        pub fn set_number_of_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_bytes(input);
            self
        }
        /// <p>Specifies the length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>
        /// <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
        pub fn key_spec(mut self, input: crate::model::DataKeySpec) -> Self {
            self.inner = self.inner.key_spec(input);
            self
        }
        /// <p>Specifies the length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>
        /// <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p>
        pub fn set_key_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeySpec>,
        ) -> Self {
            self.inner = self.inner.set_key_spec(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateDataKeyPair`.
    ///
    /// <p>Generates a unique asymmetric data key pair. The <code>GenerateDataKeyPair</code> operation returns a plaintext public key, a plaintext private key, and a copy of the private key that is encrypted under the symmetric KMS key you specify. You can use the data key pair to perform asymmetric cryptography and implement digital signatures outside of KMS.</p>
    /// <p>You can use the public key that <code>GenerateDataKeyPair</code> returns to encrypt data or verify a signature outside of KMS. Then, store the encrypted private key with the data. When you are ready to decrypt data or sign a message, you can use the <code>Decrypt</code> operation to decrypt the encrypted private key.</p>
    /// <p>To generate a data key pair, you must specify a symmetric KMS key to encrypt the private key in a data key pair. You cannot use an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation. </p>
    /// <p>Use the <code>KeyPairSpec</code> parameter to choose an RSA or Elliptic Curve (ECC) data key pair. KMS recommends that your use ECC key pairs for signing, and use RSA key pairs for either encryption or signing, but not both. However, KMS cannot enforce any restrictions on the use of data key pairs outside of KMS.</p>
    /// <p>If you are using the data key pair to encrypt data, or for any operation where you don't immediately need a private key, consider using the <code>GenerateDataKeyPairWithoutPlaintext</code> operation. <code>GenerateDataKeyPairWithoutPlaintext</code> returns a plaintext public key and an encrypted private key, but omits the plaintext private key that you need only to decrypt ciphertext or sign a message. Later, when you need to decrypt the data or sign a message, use the <code>Decrypt</code> operation to decrypt the encrypted private key in the data key pair.</p>
    /// <p> <code>GenerateDataKeyPair</code> returns a unique data key pair for each request. The bytes in the keys are not related to the caller or the KMS key that is used to encrypt the private key. The public key is a DER-encoded X.509 SubjectPublicKeyInfo, as specified in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. The private key is a DER-encoded PKCS8 PrivateKeyInfo, as specified in <a href="https://tools.ietf.org/html/rfc5958">RFC 5958</a>.</p>
    /// <p>You can use the optional encryption context to add additional security to the encryption operation. If you specify an <code>EncryptionContext</code>, you must specify the same encryption context (a case-sensitive exact match) when decrypting the encrypted data key. Otherwise, the request to decrypt fails with an <code>InvalidCiphertextException</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GenerateDataKeyPair</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPairWithoutPlaintext</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyWithoutPlaintext</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateDataKeyPair {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_data_key_pair_input::Builder,
    }
    impl GenerateDataKeyPair {
        /// Creates a new `GenerateDataKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateDataKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyPairError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// <p>Specifies the symmetric KMS key that encrypts the private key in the data key pair. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Specifies the symmetric KMS key that encrypts the private key in the data key pair. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Determines the type of data key pair that is generated. </p>
        /// <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
        pub fn key_pair_spec(mut self, input: crate::model::DataKeyPairSpec) -> Self {
            self.inner = self.inner.key_pair_spec(input);
            self
        }
        /// <p>Determines the type of data key pair that is generated. </p>
        /// <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
        pub fn set_key_pair_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeyPairSpec>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_spec(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateDataKeyPairWithoutPlaintext`.
    ///
    /// <p>Generates a unique asymmetric data key pair. The <code>GenerateDataKeyPairWithoutPlaintext</code> operation returns a plaintext public key and a copy of the private key that is encrypted under the symmetric KMS key you specify. Unlike <code>GenerateDataKeyPair</code>, this operation does not return a plaintext private key. </p>
    /// <p>You can use the public key that <code>GenerateDataKeyPairWithoutPlaintext</code> returns to encrypt data or verify a signature outside of KMS. Then, store the encrypted private key with the data. When you are ready to decrypt data or sign a message, you can use the <code>Decrypt</code> operation to decrypt the encrypted private key.</p>
    /// <p>To generate a data key pair, you must specify a symmetric KMS key to encrypt the private key in a data key pair. You cannot use an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation. </p>
    /// <p>Use the <code>KeyPairSpec</code> parameter to choose an RSA or Elliptic Curve (ECC) data key pair. KMS recommends that your use ECC key pairs for signing, and use RSA key pairs for either encryption or signing, but not both. However, KMS cannot enforce any restrictions on the use of data key pairs outside of KMS.</p>
    /// <p> <code>GenerateDataKeyPairWithoutPlaintext</code> returns a unique data key pair for each request. The bytes in the key are not related to the caller or KMS key that is used to encrypt the private key. The public key is a DER-encoded X.509 SubjectPublicKeyInfo, as specified in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>.</p>
    /// <p>You can use the optional encryption context to add additional security to the encryption operation. If you specify an <code>EncryptionContext</code>, you must specify the same encryption context (a case-sensitive exact match) when decrypting the encrypted data key. Otherwise, the request to decrypt fails with an <code>InvalidCiphertextException</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GenerateDataKeyPairWithoutPlaintext</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyWithoutPlaintext</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateDataKeyPairWithoutPlaintext {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_data_key_pair_without_plaintext_input::Builder,
    }
    impl GenerateDataKeyPairWithoutPlaintext {
        /// Creates a new `GenerateDataKeyPairWithoutPlaintext`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateDataKeyPairWithoutPlaintextOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GenerateDataKeyPairWithoutPlaintextError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context that will be used when encrypting the private key in the data key pair.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// <p>Specifies the KMS key that encrypts the private key in the data key pair. You must specify a symmetric KMS key. You cannot use an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation. </p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Specifies the KMS key that encrypts the private key in the data key pair. You must specify a symmetric KMS key. You cannot use an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation. </p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Determines the type of data key pair that is generated.</p>
        /// <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
        pub fn key_pair_spec(mut self, input: crate::model::DataKeyPairSpec) -> Self {
            self.inner = self.inner.key_pair_spec(input);
            self
        }
        /// <p>Determines the type of data key pair that is generated.</p>
        /// <p>The KMS rule that restricts the use of asymmetric RSA KMS keys to encrypt and decrypt or to sign and verify (but not both), and the rule that permits you to use ECC KMS keys only to sign and verify, are not effective on data key pairs, which are used outside of KMS.</p>
        pub fn set_key_pair_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeyPairSpec>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_spec(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateDataKeyWithoutPlaintext`.
    ///
    /// <p>Generates a unique symmetric data key. This operation returns a data key that is encrypted under a KMS key that you specify. To request an asymmetric data key pair, use the <code>GenerateDataKeyPair</code> or <code>GenerateDataKeyPairWithoutPlaintext</code> operations.</p>
    /// <p> <code>GenerateDataKeyWithoutPlaintext</code> is identical to the <code>GenerateDataKey</code> operation except that returns only the encrypted copy of the data key. This operation is useful for systems that need to encrypt data at some point, but not immediately. When you need to encrypt the data, you call the <code>Decrypt</code> operation on the encrypted copy of the key. </p>
    /// <p>It's also useful in distributed systems with different levels of trust. For example, you might store encrypted data in containers. One component of your system creates new containers and stores an encrypted data key with each container. Then, a different component puts the data into the containers. That component first decrypts the data key, uses the plaintext data key to encrypt data, puts the encrypted data into the container, and then destroys the plaintext data key. In this system, the component that creates the containers never sees the plaintext data key.</p>
    /// <p> <code>GenerateDataKeyWithoutPlaintext</code> returns a unique data key for each request. The bytes in the keys are not related to the caller or KMS key that is used to encrypt the private key.</p>
    /// <p>To generate a data key, you must specify the symmetric KMS key that is used to encrypt the data key. You cannot use an asymmetric KMS key to generate a data key. To get the type of your KMS key, use the <code>DescribeKey</code> operation.</p>
    /// <p>If the operation succeeds, you will find the encrypted copy of the data key in the <code>CiphertextBlob</code> field.</p>
    /// <p>You can use the optional encryption context to add additional security to the encryption operation. If you specify an <code>EncryptionContext</code>, you must specify the same encryption context (a case-sensitive exact match) when decrypting the encrypted data key. Otherwise, the request to decrypt fails with an <code>InvalidCiphertextException</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GenerateDataKeyWithoutPlaintext</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPairWithoutPlaintext</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateDataKeyWithoutPlaintext {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_data_key_without_plaintext_input::Builder,
    }
    impl GenerateDataKeyWithoutPlaintext {
        /// Creates a new `GenerateDataKeyWithoutPlaintext`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateDataKeyWithoutPlaintextOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyWithoutPlaintextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the symmetric KMS key that encrypts the data key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The identifier of the symmetric KMS key that encrypts the data key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Adds a key-value pair to `EncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_encryption_context`](Self::set_encryption_context).
        ///
        /// <p>Specifies the encryption context that will be used when encrypting the data key.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context that will be used when encrypting the data key.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_encryption_context(input);
            self
        }
        /// <p>The length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>
        pub fn key_spec(mut self, input: crate::model::DataKeySpec) -> Self {
            self.inner = self.inner.key_spec(input);
            self
        }
        /// <p>The length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p>
        pub fn set_key_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeySpec>,
        ) -> Self {
            self.inner = self.inner.set_key_spec(input);
            self
        }
        /// <p>The length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the <code>KeySpec</code> field instead of this one.</p>
        pub fn number_of_bytes(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_bytes(input);
            self
        }
        /// <p>The length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit and 256-bit symmetric keys), we recommend that you use the <code>KeySpec</code> field instead of this one.</p>
        pub fn set_number_of_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_bytes(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateRandom`.
    ///
    /// <p>Returns a random byte string that is cryptographically secure.</p>
    /// <p>By default, the random byte string is generated in KMS. To generate the byte string in the CloudHSM cluster that is associated with a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, specify the custom key store ID.</p>
    /// <p>Applications in Amazon Web Services Nitro Enclaves can call this operation by using the <a href="https://github.com/aws/aws-nitro-enclaves-sdk-c">Amazon Web Services Nitro Enclaves Development Kit</a>. For information about the supporting parameters, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves use KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>For more information about entropy and random number generation, see <a href="https://docs.aws.amazon.com/kms/latest/cryptographic-details/">Key Management Service Cryptographic Details</a>.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GenerateRandom</a> (IAM policy)</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateRandom {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_random_input::Builder,
    }
    impl GenerateRandom {
        /// Creates a new `GenerateRandom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateRandomOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateRandomError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The length of the byte string.</p>
        pub fn number_of_bytes(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_bytes(input);
            self
        }
        /// <p>The length of the byte string.</p>
        pub fn set_number_of_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_bytes(input);
            self
        }
        /// <p>Generates the random byte string in the CloudHSM cluster that is associated with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Generates the random byte string in the CloudHSM cluster that is associated with the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyPolicy`.
    ///
    /// <p>Gets a key policy attached to the specified KMS key.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GetKeyPolicy</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>PutKeyPolicy</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKeyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_key_policy_input::Builder,
    }
    impl GetKeyPolicy {
        /// Creates a new `GetKeyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Gets the key policy for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Gets the key policy for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Specifies the name of the key policy. The only valid name is <code>default</code>. To get the names of key policies, use <code>ListKeyPolicies</code>.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>Specifies the name of the key policy. The only valid name is <code>default</code>. To get the names of key policies, use <code>ListKeyPolicies</code>.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyRotationStatus`.
    ///
    /// <p>Gets a Boolean value that indicates whether <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">automatic rotation of the key material</a> is enabled for the specified KMS key.</p>
    /// <p>You cannot enable automatic rotation of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS keys</a>, KMS keys with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a>, or KMS keys in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>. To enable or disable automatic rotation of a set of related <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-replica-key">multi-Region keys</a>, set the property on the primary key. The key rotation status for these KMS keys is always <code>false</code>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <ul>
    /// <li> <p>Disabled: The key rotation status does not change when you disable a KMS key. However, while the KMS key is disabled, KMS does not rotate the key material.</p> </li>
    /// <li> <p>Pending deletion: While a KMS key is pending deletion, its key rotation status is <code>false</code> and KMS does not rotate the key material. If you cancel the deletion, the original key rotation status is restored.</p> </li>
    /// </ul>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation on a KMS key in a different Amazon Web Services account, specify the key ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GetKeyRotationStatus</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>DisableKeyRotation</code> </p> </li>
    /// <li> <p> <code>EnableKeyRotation</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKeyRotationStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_key_rotation_status_input::Builder,
    }
    impl GetKeyRotationStatus {
        /// Creates a new `GetKeyRotationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyRotationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyRotationStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Gets the rotation status for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Gets the rotation status for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParametersForImport`.
    ///
    /// <p>Returns the items you need to import key material into a symmetric, customer managed KMS key. For more information about importing key material into KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>This operation returns a public key and an import token. Use the public key to encrypt the symmetric key material. Store the import token to send with a subsequent <code>ImportKeyMaterial</code> request.</p>
    /// <p>You must specify the key ID of the symmetric KMS key into which you will import key material. This KMS key's <code>Origin</code> must be <code>EXTERNAL</code>. You must also specify the wrapping algorithm and type of wrapping key (public key) that you will use to encrypt the key material. You cannot perform this operation on an asymmetric KMS key or on any KMS key in a different Amazon Web Services account.</p>
    /// <p>To import key material, you must use the public key and import token from the same response. These items are valid for 24 hours. The expiration date and time appear in the <code>GetParametersForImport</code> response. You cannot use an expired token in an <code>ImportKeyMaterial</code> request. If your key and token expire, send another <code>GetParametersForImport</code> request.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GetParametersForImport</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ImportKeyMaterial</code> </p> </li>
    /// <li> <p> <code>DeleteImportedKeyMaterial</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParametersForImport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parameters_for_import_input::Builder,
    }
    impl GetParametersForImport {
        /// Creates a new `GetParametersForImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParametersForImportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParametersForImportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the symmetric KMS key into which you will import key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The identifier of the symmetric KMS key into which you will import key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The algorithm you will use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn wrapping_algorithm(mut self, input: crate::model::AlgorithmSpec) -> Self {
            self.inner = self.inner.wrapping_algorithm(input);
            self
        }
        /// <p>The algorithm you will use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_wrapping_algorithm(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_wrapping_algorithm(input);
            self
        }
        /// <p>The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.</p>
        pub fn wrapping_key_spec(mut self, input: crate::model::WrappingKeySpec) -> Self {
            self.inner = self.inner.wrapping_key_spec(input);
            self
        }
        /// <p>The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.</p>
        pub fn set_wrapping_key_spec(
            mut self,
            input: std::option::Option<crate::model::WrappingKeySpec>,
        ) -> Self {
            self.inner = self.inner.set_wrapping_key_spec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicKey`.
    ///
    /// <p>Returns the public key of an asymmetric KMS key. Unlike the private key of a asymmetric KMS key, which never leaves KMS unencrypted, callers with <code>kms:GetPublicKey</code> permission can download the public key of an asymmetric KMS key. You can share the public key to allow others to encrypt messages and verify signatures outside of KMS. For information about symmetric and asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>You do not need to download the public key. Instead, you can use the public key within KMS by calling the <code>Encrypt</code>, <code>ReEncrypt</code>, or <code>Verify</code> operations with the identifier of an asymmetric KMS key. When you use the public key within KMS, you benefit from the authentication, authorization, and logging that are part of every KMS operation. You also reduce of risk of encrypting data that cannot be decrypted. These features are not effective outside of KMS. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/download-public-key.html#download-public-key-considerations">Special Considerations for Downloading Public Keys</a>.</p>
    /// <p>To help you use the public key safely outside of KMS, <code>GetPublicKey</code> returns important information about the public key in the response, including:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeySpec">KeySpec</a>: The type of key material in the public key, such as <code>RSA_4096</code> or <code>ECC_NIST_P521</code>.</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage">KeyUsage</a>: Whether the key is used for encryption or signing.</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms">EncryptionAlgorithms</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms">SigningAlgorithms</a>: A list of the encryption algorithms or the signing algorithms for the key.</p> </li>
    /// </ul>
    /// <p>Although KMS cannot enforce these restrictions on external operations, it is crucial that you use this information to prevent the public key from being used improperly. For example, you can prevent a public signing key from being used encrypt data, or prevent a public key from being used with an encryption algorithm that is not supported by KMS. You can also avoid errors, such as using the wrong signing algorithm in a verification operation.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:GetPublicKey</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>CreateKey</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_public_key_input::Builder,
    }
    impl GetPublicKey {
        /// Creates a new `GetPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the asymmetric KMS key that includes the public key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the asymmetric KMS key that includes the public key.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportKeyMaterial`.
    ///
    /// <p>Imports key material into an existing symmetric KMS KMS key that was created without key material. After you successfully import key material into a KMS key, you can <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material">reimport the same key material</a> into that KMS key, but you cannot import different key material. </p>
    /// <p>You cannot perform this operation on an asymmetric KMS key or on any KMS key in a different Amazon Web Services account. For more information about creating KMS keys with no key material and then importing key material, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">Importing Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Before using this operation, call <code>GetParametersForImport</code>. Its response includes a public key and an import token. Use the public key to encrypt the key material. Then, submit the import token from the same <code>GetParametersForImport</code> response.</p>
    /// <p>When calling this operation, you must specify the following values:</p>
    /// <ul>
    /// <li> <p>The key ID or key ARN of a KMS key with no key material. Its <code>Origin</code> must be <code>EXTERNAL</code>.</p> <p>To create a KMS key with no key material, call <code>CreateKey</code> and set the value of its <code>Origin</code> parameter to <code>EXTERNAL</code>. To get the <code>Origin</code> of a KMS key, call <code>DescribeKey</code>.)</p> </li>
    /// <li> <p>The encrypted key material. To get the public key to encrypt the key material, call <code>GetParametersForImport</code>.</p> </li>
    /// <li> <p>The import token that <code>GetParametersForImport</code> returned. You must use a public key and token from the same <code>GetParametersForImport</code> response.</p> </li>
    /// <li> <p>Whether the key material expires and if so, when. If you set an expiration date, KMS deletes the key material from the KMS key on the specified date, and the KMS key becomes unusable. To use the KMS key again, you must reimport the same key material. The only way to change an expiration date is by reimporting the same key material and specifying a new expiration date. </p> </li>
    /// </ul>
    /// <p>When this operation is successful, the key state of the KMS key changes from <code>PendingImport</code> to <code>Enabled</code>, and you can use the KMS key.</p>
    /// <p>If this operation fails, use the exception to help determine the problem. If the error is related to the key material, the import token, or wrapping key, use <code>GetParametersForImport</code> to get a new public key and import token for the KMS key and repeat the import procedure. For help, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#importing-keys-overview">How To Import Key Material</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ImportKeyMaterial</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>DeleteImportedKeyMaterial</code> </p> </li>
    /// <li> <p> <code>GetParametersForImport</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportKeyMaterial {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_key_material_input::Builder,
    }
    impl ImportKeyMaterial {
        /// Creates a new `ImportKeyMaterial`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportKeyMaterialOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportKeyMaterialError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the symmetric KMS key that receives the imported key material. The KMS key's <code>Origin</code> must be <code>EXTERNAL</code>. This must be the same KMS key specified in the <code>KeyID</code> parameter of the corresponding <code>GetParametersForImport</code> request.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The identifier of the symmetric KMS key that receives the imported key material. The KMS key's <code>Origin</code> must be <code>EXTERNAL</code>. This must be the same KMS key specified in the <code>KeyID</code> parameter of the corresponding <code>GetParametersForImport</code> request.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The import token that you received in the response to a previous <code>GetParametersForImport</code> request. It must be from the same response that contained the public key that you used to encrypt the key material.</p>
        pub fn import_token(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.import_token(input);
            self
        }
        /// <p>The import token that you received in the response to a previous <code>GetParametersForImport</code> request. It must be from the same response that contained the public key that you used to encrypt the key material.</p>
        pub fn set_import_token(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_import_token(input);
            self
        }
        /// <p>The encrypted key material to import. The key material must be encrypted with the public wrapping key that <code>GetParametersForImport</code> returned, using the wrapping algorithm that you specified in the same <code>GetParametersForImport</code> request.</p>
        pub fn encrypted_key_material(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.encrypted_key_material(input);
            self
        }
        /// <p>The encrypted key material to import. The key material must be encrypted with the public wrapping key that <code>GetParametersForImport</code> returned, using the wrapping algorithm that you specified in the same <code>GetParametersForImport</code> request.</p>
        pub fn set_encrypted_key_material(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_encrypted_key_material(input);
            self
        }
        /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. You must omit this parameter when the <code>ExpirationModel</code> parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. Otherwise it is required.</p>
        pub fn valid_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.valid_to(input);
            self
        }
        /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. You must omit this parameter when the <code>ExpirationModel</code> parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>. Otherwise it is required.</p>
        pub fn set_valid_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_valid_to(input);
            self
        }
        /// <p>Specifies whether the key material expires. The default is <code>KEY_MATERIAL_EXPIRES</code>, in which case you must include the <code>ValidTo</code> parameter. When this parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>, you must omit the <code>ValidTo</code> parameter.</p>
        pub fn expiration_model(mut self, input: crate::model::ExpirationModelType) -> Self {
            self.inner = self.inner.expiration_model(input);
            self
        }
        /// <p>Specifies whether the key material expires. The default is <code>KEY_MATERIAL_EXPIRES</code>, in which case you must include the <code>ValidTo</code> parameter. When this parameter is set to <code>KEY_MATERIAL_DOES_NOT_EXPIRE</code>, you must omit the <code>ValidTo</code> parameter.</p>
        pub fn set_expiration_model(
            mut self,
            input: std::option::Option<crate::model::ExpirationModelType>,
        ) -> Self {
            self.inner = self.inner.set_expiration_model(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAliases`.
    ///
    /// <p>Gets a list of aliases in the caller's Amazon Web Services account and region. For more information about aliases, see <code>CreateAlias</code>.</p>
    /// <p>By default, the <code>ListAliases</code> operation returns all aliases in the account and region. To get only the aliases associated with a particular KMS key, use the <code>KeyId</code> parameter.</p>
    /// <p>The <code>ListAliases</code> response can include aliases that you created and associated with your customer managed keys, and aliases that Amazon Web Services created and associated with Amazon Web Services managed keys in your account. You can recognize Amazon Web Services aliases because their names have the format <code>aws/
    /// <service-name></service-name></code>, such as <code>aws/dynamodb</code>.</p>
    /// <p>The response might also include aliases that have no <code>TargetKeyId</code> field. These are predefined aliases that Amazon Web Services has created but has not yet associated with a KMS key. Aliases that Amazon Web Services creates in your account, including predefined aliases, do not count against your <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit">KMS aliases quota</a>.</p>
    /// <p> <b>Cross-account use</b>: No. <code>ListAliases</code> does not return aliases in other Amazon Web Services accounts.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListAliases</a> (IAM policy)</p>
    /// <p>For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access">Controlling access to aliases</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateAlias</code> </p> </li>
    /// <li> <p> <code>DeleteAlias</code> </p> </li>
    /// <li> <p> <code>UpdateAlias</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aliases_input::Builder,
    }
    impl ListAliases {
        /// Creates a new `ListAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAliasesPaginator {
            crate::paginator::ListAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>Lists only aliases that are associated with the specified KMS key. Enter a KMS key in your Amazon Web Services account. </p>
        /// <p>This parameter is optional. If you omit it, <code>ListAliases</code> returns all aliases in the account and Region.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Lists only aliases that are associated with the specified KMS key. Enter a KMS key in your Amazon Web Services account. </p>
        /// <p>This parameter is optional. If you omit it, <code>ListAliases</code> returns all aliases in the account and Region.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGrants`.
    ///
    /// <p>Gets a list of all grants for the specified KMS key. </p>
    /// <p>You must specify the KMS key in all requests. You can filter the grant list by grant ID or grantee principal.</p>
    /// <p>For detailed information about grants, including grant terminology, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Using grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. For examples of working with grants in several programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html">Programming grants</a>. </p> <note>
    /// <p>The <code>GranteePrincipal</code> field in the <code>ListGrants</code> response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the <code>GranteePrincipal</code> field contains the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services">service principal</a>, which might represent several different grantee principals.</p>
    /// </note>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation on a KMS key in a different Amazon Web Services account, specify the key ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListGrants</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateGrant</code> </p> </li>
    /// <li> <p> <code>ListRetirableGrants</code> </p> </li>
    /// <li> <p> <code>RetireGrant</code> </p> </li>
    /// <li> <p> <code>RevokeGrant</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGrants {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_grants_input::Builder,
    }
    impl ListGrants {
        /// Creates a new `ListGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGrantsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGrantsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGrantsPaginator {
            crate::paginator::ListGrantsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Returns only grants for the specified KMS key. This parameter is required.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Returns only grants for the specified KMS key. This parameter is required.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant. </p>
        pub fn grant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_id(input.into());
            self
        }
        /// <p>Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant. </p>
        pub fn set_grant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_id(input);
            self
        }
        /// <p>Returns only grants where the specified principal is the grantee principal for the grant.</p>
        pub fn grantee_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grantee_principal(input.into());
            self
        }
        /// <p>Returns only grants where the specified principal is the grantee principal for the grant.</p>
        pub fn set_grantee_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grantee_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyPolicies`.
    ///
    /// <p>Gets the names of the key policies that are attached to a KMS key. This operation is designed to get policy names that you can use in a <code>GetKeyPolicy</code> operation. However, the only valid policy name is <code>default</code>. </p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListKeyPolicies</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>GetKeyPolicy</code> </p> </li>
    /// <li> <p> <code>PutKeyPolicy</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeyPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_key_policies_input::Builder,
    }
    impl ListKeyPolicies {
        /// Creates a new `ListKeyPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKeyPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKeyPoliciesPaginator {
            crate::paginator::ListKeyPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>Gets the names of key policies for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Gets the names of key policies for the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>
        /// <p>Only one policy can be attached to a key.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>
        /// <p>Only one policy can be attached to a key.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeys`.
    ///
    /// <p>Gets a list of all KMS keys in the caller's Amazon Web Services account and Region.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListKeys</a> (IAM policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>DescribeKey</code> </p> </li>
    /// <li> <p> <code>ListAliases</code> </p> </li>
    /// <li> <p> <code>ListResourceTags</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeys {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_keys_input::Builder,
    }
    impl ListKeys {
        /// Creates a new `ListKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKeysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKeysPaginator {
            crate::paginator::ListKeysPaginator::new(self.handle, self.inner)
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceTags`.
    ///
    /// <p>Returns all tags on the specified KMS key.</p>
    /// <p>For general information about tags, including the format and syntax, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>. For information about using tags in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListResourceTags</a> (key policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>ReplicateKey</code> </p> </li>
    /// <li> <p> <code>TagResource</code> </p> </li>
    /// <li> <p> <code>UntagResource</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_tags_input::Builder,
    }
    impl ListResourceTags {
        /// Creates a new `ListResourceTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Gets tags on the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Gets tags on the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 50, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 50, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        /// <p>Do not attempt to construct this value. Use only the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        /// <p>Do not attempt to construct this value. Use only the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRetirableGrants`.
    ///
    /// <p>Returns information about all grants in the Amazon Web Services account and Region that have the specified retiring principal. </p>
    /// <p>You can specify any principal in your Amazon Web Services account. The grants that are returned include grants for KMS keys in your Amazon Web Services account and other Amazon Web Services accounts. You might use this operation to determine which grants you may retire. To retire a grant, use the <code>RetireGrant</code> operation.</p>
    /// <p>For detailed information about grants, including grant terminology, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Using grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. For examples of working with grants in several programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html">Programming grants</a>. </p>
    /// <p> <b>Cross-account use</b>: You must specify a principal in your Amazon Web Services account. However, this operation can return grants in any Amazon Web Services account. You do not need <code>kms:ListRetirableGrants</code> permission (or any other additional permission) in any Amazon Web Services account other than your own.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ListRetirableGrants</a> (IAM policy) in your Amazon Web Services account.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateGrant</code> </p> </li>
    /// <li> <p> <code>ListGrants</code> </p> </li>
    /// <li> <p> <code>RetireGrant</code> </p> </li>
    /// <li> <p> <code>RevokeGrant</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRetirableGrants {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_retirable_grants_input::Builder,
    }
    impl ListRetirableGrants {
        /// Creates a new `ListRetirableGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRetirableGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRetirableGrantsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p>
        /// <p>This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The retiring principal for which to list grants. Enter a principal in your Amazon Web Services account.</p>
        /// <p>To specify the retiring principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn retiring_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.retiring_principal(input.into());
            self
        }
        /// <p>The retiring principal for which to list grants. Enter a principal in your Amazon Web Services account.</p>
        /// <p>To specify the retiring principal, use the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web Services Identity and Access Management (IAM)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_retiring_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_retiring_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutKeyPolicy`.
    ///
    /// <p>Attaches a key policy to the specified KMS key. </p>
    /// <p>For more information about key policies, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key Policies</a> in the <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>. For examples of adding a key policy in multiple programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-key-policies.html#put-policy">Setting a key policy</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:PutKeyPolicy</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>GetKeyPolicy</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutKeyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_key_policy_input::Builder,
    }
    impl PutKeyPolicy {
        /// Creates a new `PutKeyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutKeyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutKeyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Sets the key policy on the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Sets the key policy on the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The name of the key policy. The only valid value is <code>default</code>.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the key policy. The only valid value is <code>default</code>.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The key policy to attach to the KMS key.</p>
        /// <p>The key policy must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>
        /// </ul>
        /// <p>The key policy cannot exceed 32 kilobytes (32768 bytes). For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource Quotas</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The key policy to attach to the KMS key.</p>
        /// <p>The key policy must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must allow the principal that is making the <code>PutKeyPolicy</code> request to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> </li>
        /// </ul>
        /// <p>The key policy cannot exceed 32 kilobytes (32768 bytes). For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource Quotas</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn bypass_policy_lockout_safety_check(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_policy_lockout_safety_check(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bypass_policy_lockout_safety_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReEncrypt`.
    ///
    /// <p>Decrypts ciphertext and then reencrypts it entirely within KMS. You can use this operation to change the KMS key under which data is encrypted, such as when you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-manually">manually rotate</a> a KMS key or change the KMS key that protects a ciphertext. You can also use it to reencrypt ciphertext under the same KMS key, such as to change the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a> of a ciphertext.</p>
    /// <p>The <code>ReEncrypt</code> operation can decrypt ciphertext that was encrypted by using an KMS KMS key in an KMS operation, such as <code>Encrypt</code> or <code>GenerateDataKey</code>. It can also decrypt ciphertext that was encrypted by using the public key of an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks">asymmetric KMS key</a> outside of KMS. However, it cannot decrypt ciphertext produced by other libraries, such as the <a href="https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/">Amazon Web Services Encryption SDK</a> or <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 client-side encryption</a>. These libraries return a ciphertext format that is incompatible with KMS.</p>
    /// <p>When you use the <code>ReEncrypt</code> operation, you need to provide information for the decrypt operation and the subsequent encrypt operation.</p>
    /// <ul>
    /// <li> <p>If your ciphertext was encrypted under an asymmetric KMS key, you must use the <code>SourceKeyId</code> parameter to identify the KMS key that encrypted the ciphertext. You must also supply the encryption algorithm that was used. This information is required to decrypt the data.</p> </li>
    /// <li> <p>If your ciphertext was encrypted under a symmetric KMS key, the <code>SourceKeyId</code> parameter is optional. KMS can get this information from metadata that it adds to the symmetric ciphertext blob. This feature adds durability to your implementation by ensuring that authorized users can decrypt ciphertext decades after it was encrypted, even if they've lost track of the key ID. However, specifying the source KMS key is always recommended as a best practice. When you use the <code>SourceKeyId</code> parameter to specify a KMS key, KMS uses only the KMS key you specify. If the ciphertext was encrypted under a different KMS key, the <code>ReEncrypt</code> operation fails. This practice ensures that you use the KMS key that you intend.</p> </li>
    /// <li> <p>To reencrypt the data, you must use the <code>DestinationKeyId</code> parameter specify the KMS key that re-encrypts the data after it is decrypted. You can select a symmetric or asymmetric KMS key. If the destination KMS key is an asymmetric KMS key, you must also provide the encryption algorithm. The algorithm that you choose must be compatible with the KMS key.</p> <important>
    /// <p>When you use an asymmetric KMS key to encrypt or reencrypt data, be sure to record the KMS key and encryption algorithm that you choose. You will be required to provide the same KMS key and encryption algorithm when you decrypt the data. If the KMS key and algorithm do not match the values used to encrypt the data, the decrypt operation fails.</p>
    /// <p>You are not required to supply the key ID and encryption algorithm when you decrypt with symmetric KMS keys because KMS stores this information in the ciphertext blob. KMS cannot store metadata in ciphertext generated with asymmetric keys. The standard format for asymmetric key ciphertext does not include configurable fields.</p>
    /// </important> </li>
    /// </ul>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. The source KMS key and destination KMS key can be in different Amazon Web Services accounts. Either or both KMS keys can be in a different account than the caller. To specify a KMS key in a different account, you must use its key ARN or alias ARN.</p>
    /// <p> <b>Required permissions</b>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ReEncryptFrom</a> permission on the source KMS key (key policy)</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:ReEncryptTo</a> permission on the destination KMS key (key policy)</p> </li>
    /// </ul>
    /// <p>To permit reencryption from or to a KMS key, include the <code>"kms:ReEncrypt*"</code> permission in your <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">key policy</a>. This permission is automatically included in the key policy when you use the console to create a KMS key. But you must include it manually when you create a KMS key programmatically or when you use the <code>PutKeyPolicy</code> operation to set a key policy.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>Decrypt</code> </p> </li>
    /// <li> <p> <code>Encrypt</code> </p> </li>
    /// <li> <p> <code>GenerateDataKey</code> </p> </li>
    /// <li> <p> <code>GenerateDataKeyPair</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReEncrypt {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::re_encrypt_input::Builder,
    }
    impl ReEncrypt {
        /// Creates a new `ReEncrypt`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReEncryptOutput,
            aws_smithy_http::result::SdkError<crate::error::ReEncryptError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Ciphertext of the data to reencrypt.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.ciphertext_blob(input);
            self
        }
        /// <p>Ciphertext of the data to reencrypt.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_ciphertext_blob(input);
            self
        }
        /// Adds a key-value pair to `SourceEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_source_encryption_context`](Self::set_source_encryption_context).
        ///
        /// <p>Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn source_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_source_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_source_encryption_context(input);
            self
        }
        /// <p>Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted. Enter a key ID of the KMS key that was used to encrypt the ciphertext.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn source_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_key_id(input.into());
            self
        }
        /// <p>Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted. Enter a key ID of the KMS key that was used to encrypt the ciphertext.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_source_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_key_id(input);
            self
        }
        /// <p>A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric or asymmetric KMS key with a <code>KeyUsage</code> value of <code>ENCRYPT_DECRYPT</code>. To find the <code>KeyUsage</code> value of a KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn destination_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_key_id(input.into());
            self
        }
        /// <p>A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric or asymmetric KMS key with a <code>KeyUsage</code> value of <code>ENCRYPT_DECRYPT</code>. To find the <code>KeyUsage</code> value of a KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_destination_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_key_id(input);
            self
        }
        /// Adds a key-value pair to `DestinationEncryptionContext`.
        ///
        /// To override the contents of this collection use [`set_destination_encryption_context`](Self::set_destination_encryption_context).
        ///
        /// <p>Specifies that encryption context to use when the reencrypting the data.</p>
        /// <p>A destination encryption context is valid only when the destination KMS key is a symmetric KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn destination_encryption_context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .destination_encryption_context(k.into(), v.into());
            self
        }
        /// <p>Specifies that encryption context to use when the reencrypting the data.</p>
        /// <p>A destination encryption context is valid only when the destination KMS key is a symmetric KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.</p>
        /// <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represents additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is optional when encrypting with a symmetric KMS key, but it is highly recommended.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption Context</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_destination_encryption_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_encryption_context(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the algorithm used for symmetric KMS keys.</p>
        /// <p>Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.</p>
        pub fn source_encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.inner = self.inner.source_encryption_algorithm(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the algorithm used for symmetric KMS keys.</p>
        /// <p>Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.</p>
        /// <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.</p>
        pub fn set_source_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_source_encryption_algorithm(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the encryption algorithm used for symmetric KMS keys.</p>
        /// <p>This parameter is required only when the destination KMS key is an asymmetric KMS key.</p>
        pub fn destination_encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.inner = self.inner.destination_encryption_algorithm(input);
            self
        }
        /// <p>Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the encryption algorithm used for symmetric KMS keys.</p>
        /// <p>This parameter is required only when the destination KMS key is an asymmetric KMS key.</p>
        pub fn set_destination_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_destination_encryption_algorithm(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReplicateKey`.
    ///
    /// <p>Replicates a multi-Region key into the specified Region. This operation creates a multi-Region replica key based on a multi-Region primary key in a different Region of the same Amazon Web Services partition. You can create multiple replicas of a primary key, but each must be in a different Region. To create a multi-Region primary key, use the <code>CreateKey</code> operation.</p>
    /// <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>A <i>replica key</i> is a fully-functional KMS key that can be used independently of its primary and peer replica keys. A primary key and its replica keys share properties that make them interoperable. They have the same <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">key ID</a> and key material. They also have the same <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec">key spec</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage">key usage</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin">key material origin</a>, and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">automatic key rotation status</a>. KMS automatically synchronizes these shared properties among related multi-Region keys. All other properties of a replica key can differ, including its <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">key policy</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">tags</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html">aliases</a>, and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. KMS pricing and quotas for KMS keys apply to each primary key and replica key.</p>
    /// <p>When this operation completes, the new replica key has a transient key state of <code>Creating</code>. This key state changes to <code>Enabled</code> (or <code>PendingImport</code>) after a few seconds when the process of creating the new replica key is complete. While the key state is <code>Creating</code>, you can manage key, but you cannot yet use it in cryptographic operations. If you are creating and using the replica key programmatically, retry on <code>KMSInvalidStateException</code> or call <code>DescribeKey</code> to check its <code>KeyState</code> value before using it. For details about the <code>Creating</code> key state, see <a href="kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The CloudTrail log of a <code>ReplicateKey</code> operation records a <code>ReplicateKey</code> operation in the primary key's Region and a <code>CreateKey</code> operation in the replica key's Region.</p>
    /// <p>If you replicate a multi-Region primary key with imported key material, the replica key is created with no key material. You must import the same key material that you imported into the primary key. For details, see <a href="kms/latest/developerguide/multi-region-keys-import.html">Importing key material into multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>To convert a replica key to a primary key, use the <code>UpdatePrimaryRegion</code> operation.</p> <note>
    /// <p> <code>ReplicateKey</code> uses different default values for the <code>KeyPolicy</code> and <code>Tags</code> parameters than those used in the KMS console. For details, see the parameter descriptions.</p>
    /// </note>
    /// <p> <b>Cross-account use</b>: No. You cannot use this operation to create a replica key in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b>: </p>
    /// <ul>
    /// <li> <p> <code>kms:ReplicateKey</code> on the primary key (in the primary key's Region). Include this permission in the primary key's key policy.</p> </li>
    /// <li> <p> <code>kms:CreateKey</code> in an IAM policy in the replica Region.</p> </li>
    /// <li> <p>To use the <code>Tags</code> parameter, <code>kms:TagResource</code> in an IAM policy in the replica Region.</p> </li>
    /// </ul>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>UpdatePrimaryRegion</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReplicateKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::replicate_key_input::Builder,
    }
    impl ReplicateKey {
        /// Creates a new `ReplicateKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReplicateKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::ReplicateKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a multi-Region primary key, use the <code>DescribeKey</code> operation to check the value of the <code>MultiRegionKeyType</code> property.</p>
        /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a multi-Region primary key, use the <code>DescribeKey</code> operation to check the value of the <code>MultiRegionKeyType</code> property.</p>
        /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The Region ID of the Amazon Web Services Region for this replica key. </p>
        /// <p>Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web Services Regions in which KMS is supported, see <a href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. </p>
        /// <p>For information about Amazon Web Services partitions, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the <i>Amazon Web Services General Reference</i>.</a> For information about enabling and disabling Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a Region</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn replica_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replica_region(input.into());
            self
        }
        /// <p>The Region ID of the Amazon Web Services Region for this replica key. </p>
        /// <p>Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web Services Regions in which KMS is supported, see <a href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p>The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. </p>
        /// <p>For information about Amazon Web Services partitions, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) in the <i>Amazon Web Services General Reference</i>.</a> For information about enabling and disabling Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a Region</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_replica_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replica_region(input);
            self
        }
        /// <p>The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS attaches the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key policy</a> to the KMS key.</p>
        /// <p>The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        /// <p>If you provide a key policy, it must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p> </li>
        /// <li> <p>The key policy size quota is 32 kilobytes (32768 bytes).</p> </li>
        /// </ul>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS attaches the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key policy</a> to the KMS key.</p>
        /// <p>The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        /// <p>If you provide a key policy, it must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.</p> </li>
        /// <li> <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p> </li>
        /// <li> <p>The key policy size quota is 32 kilobytes (32768 bytes).</p> </li>
        /// </ul>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn bypass_policy_lockout_safety_check(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_policy_lockout_safety_check(input);
            self
        }
        /// <p>A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
        /// <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>
        /// <p>For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.</p>
        /// </important>
        /// <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <code>PutKeyPolicy</code> request on the KMS key.</p>
        /// <p>The default value is false.</p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bypass_policy_lockout_safety_check(input);
            self
        }
        /// <p>A description of the KMS key. The default value is an empty string (no description).</p>
        /// <p>The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the KMS key. The default value is an empty string (no description).</p>
        /// <p>The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        /// <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>
        /// <p>Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        /// <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        /// <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the <code>TagResource</code> operation.</p> <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        /// <p>To use this parameter, you must have <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> permission in an IAM policy.</p>
        /// <p>Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. KMS does not synchronize this property.</p>
        /// <p>Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        /// <p>When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetireGrant`.
    ///
    /// <p>Deletes a grant. Typically, you retire a grant when you no longer need its permissions. To identify the grant to retire, use a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">grant token</a>, or both the grant ID and a key identifier (key ID or key ARN) of the KMS key. The <code>CreateGrant</code> operation returns both values.</p>
    /// <p>This operation can be called by the <i>retiring principal</i> for a grant, by the <i>grantee principal</i> if the grant allows the <code>RetireGrant</code> operation, and by the Amazon Web Services account (root user) in which the grant is created. It can also be called by principals to whom permission for retiring a grant is delegated. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete">Retiring and revoking grants</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>For detailed information about grants, including grant terminology, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Using grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. For examples of working with grants in several programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html">Programming grants</a>. </p>
    /// <p> <b>Cross-account use</b>: Yes. You can retire a grant on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions:</b>:Permission to retire a grant is determined primarily by the grant. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete">Retiring and revoking grants</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateGrant</code> </p> </li>
    /// <li> <p> <code>ListGrants</code> </p> </li>
    /// <li> <p> <code>ListRetirableGrants</code> </p> </li>
    /// <li> <p> <code>RevokeGrant</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetireGrant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retire_grant_input::Builder,
    }
    impl RetireGrant {
        /// Creates a new `RetireGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetireGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::RetireGrantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.</p>
        /// <p>Only the <code>CreateGrant</code> operation returns a grant token. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency">Eventual consistency</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_token(input.into());
            self
        }
        /// <p>Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.</p>
        /// <p>Only the <code>CreateGrant</code> operation returns a grant token. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency">Eventual consistency</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_token(input);
            self
        }
        /// <p>The key ARN KMS key associated with the grant. To find the key ARN, use the <code>ListKeys</code> operation.</p>
        /// <p>For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The key ARN KMS key associated with the grant. To find the key ARN, use the <code>ListKeys</code> operation.</p>
        /// <p>For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Identifies the grant to retire. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>
        /// <ul>
        /// <li> <p>Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123</p> </li>
        /// </ul>
        pub fn grant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_id(input.into());
            self
        }
        /// <p>Identifies the grant to retire. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>
        /// <ul>
        /// <li> <p>Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123</p> </li>
        /// </ul>
        pub fn set_grant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeGrant`.
    ///
    /// <p>Deletes the specified grant. You revoke a grant to terminate the permissions that the grant allows. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/managing-grants.html#grant-delete">Retiring and revoking grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
    /// <p>When you create, retire, or revoke a grant, there might be a brief delay, usually less than five minutes, until the grant is available throughout KMS. This state is known as <i>eventual consistency</i>. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency">Eventual consistency</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. </p>
    /// <p>For detailed information about grants, including grant terminology, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html">Using grants</a> in the <i> <i>Key Management Service Developer Guide</i> </i>. For examples of working with grants in several programming languages, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html">Programming grants</a>. </p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation on a KMS key in a different Amazon Web Services account, specify the key ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:RevokeGrant</a> (key policy).</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateGrant</code> </p> </li>
    /// <li> <p> <code>ListGrants</code> </p> </li>
    /// <li> <p> <code>ListRetirableGrants</code> </p> </li>
    /// <li> <p> <code>RetireGrant</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeGrant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_grant_input::Builder,
    }
    impl RevokeGrant {
        /// Creates a new `RevokeGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeGrantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the KMS key associated with the grant. To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>A unique identifier for the KMS key associated with the grant. To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        /// <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Identifies the grant to revoke. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>
        pub fn grant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_id(input.into());
            self
        }
        /// <p>Identifies the grant to revoke. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p>
        pub fn set_grant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ScheduleKeyDeletion`.
    ///
    /// <p>Schedules the deletion of a KMS key. By default, KMS applies a waiting period of 30 days, but you can specify a waiting period of 7-30 days. When this operation is successful, the key state of the KMS key changes to <code>PendingDeletion</code> and the key can't be used in any cryptographic operations. It remains in this state for the duration of the waiting period. Before the waiting period ends, you can use <code>CancelKeyDeletion</code> to cancel the deletion of the KMS key. After the waiting period ends, KMS deletes the KMS key, its key material, and all KMS data associated with it, including all aliases that refer to it.</p> <important>
    /// <p>Deleting a KMS key is a destructive and potentially dangerous operation. When a KMS key is deleted, all data that was encrypted under the KMS key is unrecoverable. (The only exception is a multi-Region replica key.) To prevent the use of a KMS key without deleting it, use <code>DisableKey</code>. </p>
    /// </important>
    /// <p>If you schedule deletion of a KMS key from a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, when the waiting period expires, <code>ScheduleKeyDeletion</code> deletes the KMS key from KMS. Then KMS makes a best effort to delete the key material from the associated CloudHSM cluster. However, you might need to manually <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key">delete the orphaned key material</a> from the cluster and its backups.</p>
    /// <p>You can schedule the deletion of a multi-Region primary key and its replica keys at any time. However, KMS will not delete a multi-Region primary key with existing replica keys. If you schedule the deletion of a primary key with replicas, its key state changes to <code>PendingReplicaDeletion</code> and it cannot be replicated or used in cryptographic operations. This status can continue indefinitely. When the last of its replicas keys is deleted (not just scheduled), the key state of the primary key changes to <code>PendingDeletion</code> and its waiting period (<code>PendingWindowInDays</code>) begins. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>. </p>
    /// <p>For more information about scheduling a KMS key for deletion, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: kms:ScheduleKeyDeletion (key policy)</p>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CancelKeyDeletion</code> </p> </li>
    /// <li> <p> <code>DisableKey</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ScheduleKeyDeletion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::schedule_key_deletion_input::Builder,
    }
    impl ScheduleKeyDeletion {
        /// Creates a new `ScheduleKeyDeletion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScheduleKeyDeletionOutput,
            aws_smithy_http::result::SdkError<crate::error::ScheduleKeyDeletionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the KMS key to delete.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The unique identifier of the KMS key to delete.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.</p>
        /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p>
        /// <p>This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.</p>
        pub fn pending_window_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.pending_window_in_days(input);
            self
        }
        /// <p>The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.</p>
        /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.</p>
        /// <p>This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.</p>
        pub fn set_pending_window_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_pending_window_in_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Sign`.
    ///
    /// <p>Creates a <a href="https://en.wikipedia.org/wiki/Digital_signature">digital signature</a> for a message or message digest by using the private key in an asymmetric KMS key. To verify the signature, use the <code>Verify</code> operation, or use the public key in the same asymmetric KMS key outside of KMS. For information about symmetric and asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Digital signatures are generated and verified by using asymmetric key pair, such as an RSA or ECC pair that is represented by an asymmetric KMS key. The key owner (or an authorized user) uses their private key to sign a message. Anyone with the public key can verify that the message was signed with that particular private key and that the message hasn't changed since it was signed. </p>
    /// <p>To use the <code>Sign</code> operation, provide the following information:</p>
    /// <ul>
    /// <li> <p>Use the <code>KeyId</code> parameter to identify an asymmetric KMS key with a <code>KeyUsage</code> value of <code>SIGN_VERIFY</code>. To get the <code>KeyUsage</code> value of a KMS key, use the <code>DescribeKey</code> operation. The caller must have <code>kms:Sign</code> permission on the KMS key.</p> </li>
    /// <li> <p>Use the <code>Message</code> parameter to specify the message or message digest to sign. You can submit messages of up to 4096 bytes. To sign a larger message, generate a hash digest of the message, and then provide the hash digest in the <code>Message</code> parameter. To indicate whether the message is a full message or a digest, use the <code>MessageType</code> parameter.</p> </li>
    /// <li> <p>Choose a signing algorithm that is compatible with the KMS key. </p> </li>
    /// </ul> <important>
    /// <p>When signing a message, be sure to record the KMS key and the signing algorithm. This information is required to verify the signature.</p>
    /// </important>
    /// <p>To verify the signature that this operation generates, use the <code>Verify</code> operation. Or use the <code>GetPublicKey</code> operation to download the public key and then use the public key to verify the signature outside of KMS. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:Sign</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>Verify</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Sign {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::sign_input::Builder,
    }
    impl Sign {
        /// Creates a new `Sign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SignOutput,
            aws_smithy_http::result::SdkError<crate::error::SignError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The <code>KeyUsage</code> type of the KMS key must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The <code>KeyUsage</code> type of the KMS key must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide the message digest.</p>
        /// <p>If you provide a message, KMS generates a hash digest of the message and then signs it.</p>
        pub fn message(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.message(input);
            self
        }
        /// <p>Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide the message digest.</p>
        /// <p>If you provide a message, KMS generates a hash digest of the message and then signs it.</p>
        pub fn set_message(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
        /// <p>Specifies the signing algorithm to use when signing the message. </p>
        /// <p>Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithmSpec) -> Self {
            self.inner = self.inner.signing_algorithm(input);
            self
        }
        /// <p>Specifies the signing algorithm to use when signing the message. </p>
        /// <p>Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_signing_algorithm(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or edits tags on a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>.</p> <note>
    /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    /// <p>Each tag consists of a tag key and a tag value, both of which are case-sensitive strings. The tag value can be an empty (null) string. To add a tag, specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.</p>
    /// <p>You can use this operation to tag a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>, but you cannot tag an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>, an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk">Amazon Web Services owned key</a>, a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#keystore-concept">custom key store</a>, or an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#alias-concept">alias</a>.</p>
    /// <p>You can also add tags to a KMS key while creating it (<code>CreateKey</code>) or replicating it (<code>ReplicateKey</code>).</p>
    /// <p>For information about using tags in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a>. For general information about tags, including the format and syntax, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:TagResource</a> (key policy)</p>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>ListResourceTags</code> </p> </li>
    /// <li> <p> <code>ReplicateKey</code> </p> </li>
    /// <li> <p> <code>UntagResource</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies a customer managed key in the account and Region.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies a customer managed key in the account and Region.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. </p>
        /// <p>Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string. </p>
        /// <p>You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags. </p>
        /// <p>Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string. </p>
        /// <p>You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes tags from a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a>. To delete a tag, specify the tag key and the KMS key.</p> <note>
    /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    /// <p>When it succeeds, the <code>UntagResource</code> operation doesn't return any output. Also, if the specified tag key isn't found on the KMS key, it doesn't throw an exception or return a response. To confirm that the operation worked, use the <code>ListResourceTags</code> operation.</p>
    /// <p>For information about using tags in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a>. For general information about tags, including the format and syntax, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account.</p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UntagResource</a> (key policy)</p>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>ListResourceTags</code> </p> </li>
    /// <li> <p> <code>ReplicateKey</code> </p> </li>
    /// <li> <p> <code>TagResource</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the KMS key from which you are removing tags.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the KMS key from which you are removing tags.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>One or more tag keys. Specify only the tag keys, not the tag values.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAlias`.
    ///
    /// <p>Associates an existing KMS alias with a different KMS key. Each alias is associated with only one KMS key at a time, although a KMS key can have multiple aliases. The alias and the KMS key must be in the same Amazon Web Services account and Region.</p> <note>
    /// <p>Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    /// <p>The current and new KMS key must be the same type (both symmetric or both asymmetric), and they must have the same key usage (<code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code>). This restriction prevents errors in code that uses aliases. If you must assign an alias to a different type of KMS key, use <code>DeleteAlias</code> to delete the old alias and <code>CreateAlias</code> to create a new alias.</p>
    /// <p>You cannot use <code>UpdateAlias</code> to change an alias name. To change an alias name, use <code>DeleteAlias</code> to delete the old alias and <code>CreateAlias</code> to create a new alias.</p>
    /// <p>Because an alias is not a property of a KMS key, you can create, update, and delete the aliases of a KMS key without affecting the KMS key. Also, aliases do not appear in the response from the <code>DescribeKey</code> operation. To get the aliases of all KMS keys in the account, use the <code>ListAliases</code> operation. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UpdateAlias</a> on the alias (IAM policy).</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UpdateAlias</a> on the current KMS key (key policy).</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UpdateAlias</a> on the new KMS key (key policy).</p> </li>
    /// </ul>
    /// <p>For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access">Controlling access to aliases</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateAlias</code> </p> </li>
    /// <li> <p> <code>DeleteAlias</code> </p> </li>
    /// <li> <p> <code>ListAliases</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_alias_input::Builder,
    }
    impl UpdateAlias {
        /// Creates a new `UpdateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the alias that is changing its KMS key. This value must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>. You cannot use UpdateAlias to change the alias name.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>Identifies the alias that is changing its KMS key. This value must begin with <code>alias/</code> followed by the alias name, such as <code>alias/ExampleAlias</code>. You cannot use UpdateAlias to change the alias name.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>Identifies the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> to associate with the alias. You don't have permission to associate an alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>.</p>
        /// <p>The KMS key must be in the same Amazon Web Services account and Region as the alias. Also, the new target KMS key must be the same type as the current target KMS key (both symmetric or both asymmetric) and they must have the same key usage. </p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        /// <p>To verify that the alias is mapped to the correct KMS key, use <code>ListAliases</code>.</p>
        pub fn target_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_key_id(input.into());
            self
        }
        /// <p>Identifies the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> to associate with the alias. You don't have permission to associate an alias with an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed key</a>.</p>
        /// <p>The KMS key must be in the same Amazon Web Services account and Region as the alias. Also, the new target KMS key must be the same type as the current target KMS key (both symmetric or both asymmetric) and they must have the same key usage. </p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        /// <p>To verify that the alias is mapped to the correct KMS key, use <code>ListAliases</code>.</p>
        pub fn set_target_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomKeyStore`.
    ///
    /// <p>Changes the properties of a custom key store. Use the <code>CustomKeyStoreId</code> parameter to identify the custom key store you want to edit. Use the remaining parameters to change the properties of the custom key store.</p>
    /// <p>You can only update a custom key store that is disconnected. To disconnect the custom key store, use <code>DisconnectCustomKeyStore</code>. To reconnect the custom key store after the update completes, use <code>ConnectCustomKeyStore</code>. To find the connection state of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// <p>The <code>CustomKeyStoreId</code> parameter is required in all commands. Use the other parameters of <code>UpdateCustomKeyStore</code> to edit your key store settings.</p>
    /// <ul>
    /// <li> <p>Use the <code>NewCustomKeyStoreName</code> parameter to change the friendly name of the custom key store to the value that you specify.</p> <p> </p> </li>
    /// <li> <p>Use the <code>KeyStorePassword</code> parameter tell KMS the current password of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser"> <code>kmsuser</code> crypto user (CU)</a> in the associated CloudHSM cluster. You can use this parameter to <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-password">fix connection failures</a> that occur when KMS cannot log into the associated cluster because the <code>kmsuser</code> password has changed. This value does not change the password in the CloudHSM cluster.</p> <p> </p> </li>
    /// <li> <p>Use the <code>CloudHsmClusterId</code> parameter to associate the custom key store with a different, but related, CloudHSM cluster. You can use this parameter to repair a custom key store if its CloudHSM cluster becomes corrupted or is deleted, or when you need to create or restore a cluster from a backup. </p> </li>
    /// </ul>
    /// <p>If the operation succeeds, it returns a JSON object with no properties.</p>
    /// <p>This operation is part of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">Custom Key Store feature</a> feature in KMS, which combines the convenience and extensive integration of KMS with the isolation and control of a single-tenant key store.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a custom key store in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UpdateCustomKeyStore</a> (IAM policy)</p>
    /// <p> <b>Related operations:</b> </p>
    /// <ul>
    /// <li> <p> <code>ConnectCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>CreateCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DeleteCustomKeyStore</code> </p> </li>
    /// <li> <p> <code>DescribeCustomKeyStores</code> </p> </li>
    /// <li> <p> <code>DisconnectCustomKeyStore</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomKeyStore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_key_store_input::Builder,
    }
    impl UpdateCustomKeyStore {
        /// Creates a new `UpdateCustomKeyStore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomKeyStoreOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomKeyStoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_key_store_id(input.into());
            self
        }
        /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_key_store_id(input);
            self
        }
        /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p>
        pub fn new_custom_key_store_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_custom_key_store_name(input.into());
            self
        }
        /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p>
        pub fn set_new_custom_key_store_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_custom_key_store_name(input);
            self
        }
        /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store.</p>
        /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
        pub fn key_store_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_store_password(input.into());
            self
        }
        /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store.</p>
        /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
        pub fn set_key_store_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_store_password(input);
            self
        }
        /// <p>Associates the custom key store with a related CloudHSM cluster. </p>
        /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
        pub fn cloud_hsm_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_hsm_cluster_id(input.into());
            self
        }
        /// <p>Associates the custom key store with a related CloudHSM cluster. </p>
        /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
        pub fn set_cloud_hsm_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_hsm_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateKeyDescription`.
    ///
    /// <p>Updates the description of a KMS key. To see the description of a KMS key, use <code>DescribeKey</code>. </p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot perform this operation on a KMS key in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:UpdateKeyDescription</a> (key policy)</p>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>DescribeKey</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateKeyDescription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_key_description_input::Builder,
    }
    impl UpdateKeyDescription {
        /// Creates a new `UpdateKeyDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateKeyDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateKeyDescriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Updates the description of the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Updates the description of the specified KMS key.</p>
        /// <p>Specify the key ID or key ARN of the KMS key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>New description for the KMS key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>New description for the KMS key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePrimaryRegion`.
    ///
    /// <p>Changes the primary key of a multi-Region key. </p>
    /// <p>This operation changes the replica key in the specified Region to a primary key and changes the former primary key to a replica key. For example, suppose you have a primary key in <code>us-east-1</code> and a replica key in <code>eu-west-2</code>. If you run <code>UpdatePrimaryRegion</code> with a <code>PrimaryRegion</code> value of <code>eu-west-2</code>, the primary key is now the key in <code>eu-west-2</code>, and the key in <code>us-east-1</code> becomes a replica key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-update">Updating the primary Region</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>This operation supports <i>multi-Region keys</i>, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>The <i>primary key</i> of a multi-Region key is the source for properties that are always shared by primary and replica keys, including the key material, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">key ID</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec">key spec</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage">key usage</a>, <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin">key material origin</a>, and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">automatic key rotation</a>. It's the only key that can be replicated. You cannot <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">delete the primary key</a> until all replica keys are deleted.</p>
    /// <p>The key ID and primary Region that you specify uniquely identify the replica key that will become the primary key. The primary Region must already have a replica key. This operation does not create a KMS key in the specified Region. To find the replica keys, use the <code>DescribeKey</code> operation on the primary key or any replica key. To create a replica key, use the <code>ReplicateKey</code> operation.</p>
    /// <p>You can run this operation while using the affected multi-Region keys in cryptographic operations. This operation should not delay, interrupt, or cause failures in cryptographic operations. </p>
    /// <p>Even after this operation completes, the process of updating the primary Region might still be in progress for a few more seconds. Operations such as <code>DescribeKey</code> might display both the old and new primary keys as replicas. The old and new primary keys have a transient key state of <code>Updating</code>. The original key state is restored when the update is complete. While the key state is <code>Updating</code>, you can use the keys in cryptographic operations, but you cannot replicate the new primary key or perform certain management operations, such as enabling or disabling these keys. For details about the <code>Updating</code> key state, see <a href="kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>This operation does not return any output. To verify that primary key is changed, use the <code>DescribeKey</code> operation.</p>
    /// <p> <b>Cross-account use</b>: No. You cannot use this operation in a different Amazon Web Services account. </p>
    /// <p> <b>Required permissions</b>: </p>
    /// <ul>
    /// <li> <p> <code>kms:UpdatePrimaryRegion</code> on the current primary key (in the primary key's Region). Include this permission primary key's key policy.</p> </li>
    /// <li> <p> <code>kms:UpdatePrimaryRegion</code> on the current replica key (in the replica key's Region). Include this permission in the replica key's key policy.</p> </li>
    /// </ul>
    /// <p> <b>Related operations</b> </p>
    /// <ul>
    /// <li> <p> <code>CreateKey</code> </p> </li>
    /// <li> <p> <code>ReplicateKey</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePrimaryRegion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_primary_region_input::Builder,
    }
    impl UpdatePrimaryRegion {
        /// Creates a new `UpdatePrimaryRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePrimaryRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryRegionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
        /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
        /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region. </p>
        /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_region(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region. </p>
        /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Verify`.
    ///
    /// <p>Verifies a digital signature that was generated by the <code>Sign</code> operation. </p>
    /// <p></p>
    /// <p>Verification confirms that an authorized user signed the message with the specified KMS key and signing algorithm, and the message hasn't changed since it was signed. If the signature is verified, the value of the <code>SignatureValid</code> field in the response is <code>True</code>. If the signature verification fails, the <code>Verify</code> operation fails with an <code>KMSInvalidSignatureException</code> exception.</p>
    /// <p>A digital signature is generated by using the private key in an asymmetric KMS key. The signature is verified by using the public key in the same asymmetric KMS key. For information about symmetric and asymmetric KMS keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>To verify a digital signature, you can use the <code>Verify</code> operation. Specify the same asymmetric KMS key, message, and signing algorithm that were used to produce the signature.</p>
    /// <p>You can also verify the digital signature by using the public key of the KMS key outside of KMS. Use the <code>GetPublicKey</code> operation to download the public key in the asymmetric KMS key and then use the public key to verify the signature outside of KMS. The advantage of using the <code>Verify</code> operation is that it is performed within KMS. As a result, it's easy to call, the operation is performed within the FIPS boundary, it is logged in CloudTrail, and you can use key policy and IAM policy to determine who is authorized to use the KMS key to verify signatures.</p>
    /// <p>The KMS key that you use for this operation must be in a compatible key state. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p> <b>Cross-account use</b>: Yes. To perform this operation with a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN in the value of the <code>KeyId</code> parameter. </p>
    /// <p> <b>Required permissions</b>: <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">kms:Verify</a> (key policy)</p>
    /// <p> <b>Related operations</b>: <code>Sign</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Verify {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::verify_input::Builder,
    }
    impl Verify {
        /// Creates a new `Verify`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.</p>
        /// <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the <code>MessageType</code> parameter with a value of <code>DIGEST</code>.</p>
        /// <p>If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.</p>
        pub fn message(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.message(input);
            self
        }
        /// <p>Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the <code>MessageType</code> parameter with a value of <code>DIGEST</code>.</p>
        /// <p>If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.</p>
        pub fn set_message(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p> <important>
        /// <p>Use the <code>DIGEST</code> value only when the value of the <code>Message</code> parameter is a message digest. If you use the <code>DIGEST</code> value with a raw message, the security of the verification operation can be compromised.</p>
        /// </important>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.inner = self.inner.message_type(input);
            self
        }
        /// <p>Tells KMS whether the value of the <code>Message</code> parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter <code>DIGEST</code>.</p> <important>
        /// <p>Use the <code>DIGEST</code> value only when the value of the <code>Message</code> parameter is a message digest. If you use the <code>DIGEST</code> value with a raw message, the security of the verification operation can be compromised.</p>
        /// </important>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.inner = self.inner.set_message_type(input);
            self
        }
        /// <p>The signature that the <code>Sign</code> operation generated.</p>
        pub fn signature(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.signature(input);
            self
        }
        /// <p>The signature that the <code>Sign</code> operation generated.</p>
        pub fn set_signature(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_signature(input);
            self
        }
        /// <p>The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithmSpec) -> Self {
            self.inner = self.inner.signing_algorithm(input);
            self
        }
        /// <p>The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithmSpec>,
        ) -> Self {
            self.inner = self.inner.set_signing_algorithm(input);
            self
        }
        /// Appends an item to `GrantTokens`.
        ///
        /// To override the contents of this collection use [`set_grant_tokens`](Self::set_grant_tokens).
        ///
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_tokens(input.into());
            self
        }
        /// <p>A list of grant tokens.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_tokens(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
