// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The request was rejected because the specified CloudHSM cluster is already associated with a custom key store or it shares a backup history with a cluster that is associated with a custom key store. Each custom key store must be associated with a different CloudHSM cluster.</p>
    /// <p>Clusters that share a backup history have the same cluster certificate. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    CloudHsmClusterInUseException(crate::error::CloudHsmClusterInUseException),
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the configuration requirements for a custom key store.</p>
    /// <ul>
    /// <li> <p>The cluster must be configured with private subnets in at least two different Availability Zones in the Region.</p> </li>
    /// <li> <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for the cluster</a> (cloudhsm-cluster-<i>
    /// <cluster-id></cluster-id></i>-sg) must include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group ID. These rules are set by default when you create the cluster. Do not delete or change them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p> </li>
    /// <li> <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs, use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p> <p>For the <code>CreateCustomKeyStore</code>, <code>UpdateCustomKeyStore</code>, and <code>CreateKey</code> operations, the CloudHSM cluster must have at least two active HSMs, each in a different Availability Zone. For the <code>ConnectCustomKeyStore</code> operation, the CloudHSM must contain at least one active HSM.</p> </li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with a custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a> in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security Group</a> in the <i> <i>CloudHSM User Guide</i> </i>. </p>
    CloudHsmClusterInvalidConfigurationException(
        crate::error::CloudHsmClusterInvalidConfigurationException,
    ),
    /// <p>The request was rejected because the CloudHSM cluster that is associated with the custom key store is not active. Initialize and activate the cluster and try the command again. For detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
    CloudHsmClusterNotActiveException(crate::error::CloudHsmClusterNotActiveException),
    /// <p>The request was rejected because KMS cannot find the CloudHSM cluster with the specified cluster ID. Retry the request with a different cluster ID.</p>
    CloudHsmClusterNotFoundException(crate::error::CloudHsmClusterNotFoundException),
    /// <p>The request was rejected because the specified CloudHSM cluster has a different cluster certificate than the original cluster. You cannot use the operation to specify an unrelated cluster.</p>
    /// <p>Specify a cluster that shares a backup history with the original cluster. This includes clusters that were created from a backup of the current cluster, and clusters that were created from the same backup that produced the current cluster.</p>
    /// <p>Clusters that share a backup history have the same cluster certificate. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    CloudHsmClusterNotRelatedException(crate::error::CloudHsmClusterNotRelatedException),
    /// <p>The request was rejected because the custom key store contains KMS keys. After verifying that you do not need to use the KMS keys, use the <code>ScheduleKeyDeletion</code> operation to delete the KMS keys. After they are deleted, you can delete the custom key store.</p>
    CustomKeyStoreHasCmKsException(crate::error::CustomKeyStoreHasCmKsException),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key store. To get the <code>ConnectionState</code> of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li> <p>You requested the <code>CreateKey</code> or <code>GenerateRandom</code> operation in a custom key store that is not connected. These operations are valid only when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p> </li>
    /// <li> <p>You requested the <code>UpdateCustomKeyStore</code> or <code>DeleteCustomKeyStore</code> operation on a custom key store that is not disconnected. This operation is valid only when the custom key store <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p> </li>
    /// <li> <p>You requested the <code>ConnectCustomKeyStore</code> operation on a custom key store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code> values.</p> </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because the specified custom key store name is already assigned to another custom key store in the account. Try again with a custom key store name that is unique in the account.</p>
    CustomKeyStoreNameInUseException(crate::error::CustomKeyStoreNameInUseException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The system timed out while trying to fulfill the request. The request can be retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified import token is expired. Use <code>GetParametersForImport</code> to get a new import token and public key, use the new public key to encrypt the key material, and then try the request again.</p>
    ExpiredImportTokenException(crate::error::ExpiredImportTokenException),
    /// <p>The request was rejected because the specified KMS key cannot decrypt the data. The <code>KeyId</code> in a <code>Decrypt</code> request and the <code>SourceKeyId</code> in a <code>ReEncrypt</code> request must identify the same KMS key that was used to encrypt the ciphertext.</p>
    IncorrectKeyException(crate::error::IncorrectKeyException),
    /// <p>The request was rejected because the key material in the request is, expired, invalid, or is not the same key material that was previously imported into this KMS key.</p>
    IncorrectKeyMaterialException(crate::error::IncorrectKeyMaterialException),
    /// <p>The request was rejected because the trust anchor certificate in the request is not the trust anchor certificate for the specified CloudHSM cluster.</p>
    /// <p>When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create the trust anchor certificate and save it in the <code>customerCA.crt</code> file.</p>
    IncorrectTrustAnchorException(crate::error::IncorrectTrustAnchorException),
    /// <p>The request was rejected because the specified alias name is not valid.</p>
    InvalidAliasNameException(crate::error::InvalidAliasNameException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>From the <code>Decrypt</code> or <code>ReEncrypt</code> operation, the request was rejected because the specified ciphertext, or additional authenticated data incorporated into the ciphertext, such as the encryption context, is corrupted, missing, or otherwise invalid.</p>
    /// <p>From the <code>ImportKeyMaterial</code> operation, the request was rejected because KMS could not decrypt the encrypted (wrapped) key material. </p>
    InvalidCiphertextException(crate::error::InvalidCiphertextException),
    /// <p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>
    InvalidGrantIdException(crate::error::InvalidGrantIdException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected because the provided import token is invalid or is associated with a different KMS key.</p>
    InvalidImportTokenException(crate::error::InvalidImportTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li> <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.</p> </li>
    /// <li> <p>The encryption algorithm or signing algorithm specified for the operation is incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p> </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the <code>DescribeKey</code> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the marker that specifies where pagination should next begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the signature verification failed. Signature verification fails when it cannot confirm that signature was produced by signing the specified message with the specified KMS key and signing algorithm.</p>
    KmsInvalidSignatureException(crate::error::KmsInvalidSignatureException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified policy is not syntactically or semantically correct.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the specified entity or resource could not be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because one or more tags are not valid.</p>
    TagException(crate::error::TagException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AlreadyExistsException(inner) => inner.fmt(f),
            Error::CloudHsmClusterInUseException(inner) => inner.fmt(f),
            Error::CloudHsmClusterInvalidConfigurationException(inner) => inner.fmt(f),
            Error::CloudHsmClusterNotActiveException(inner) => inner.fmt(f),
            Error::CloudHsmClusterNotFoundException(inner) => inner.fmt(f),
            Error::CloudHsmClusterNotRelatedException(inner) => inner.fmt(f),
            Error::CustomKeyStoreHasCmKsException(inner) => inner.fmt(f),
            Error::CustomKeyStoreInvalidStateException(inner) => inner.fmt(f),
            Error::CustomKeyStoreNameInUseException(inner) => inner.fmt(f),
            Error::CustomKeyStoreNotFoundException(inner) => inner.fmt(f),
            Error::DependencyTimeoutException(inner) => inner.fmt(f),
            Error::DisabledException(inner) => inner.fmt(f),
            Error::ExpiredImportTokenException(inner) => inner.fmt(f),
            Error::IncorrectKeyException(inner) => inner.fmt(f),
            Error::IncorrectKeyMaterialException(inner) => inner.fmt(f),
            Error::IncorrectTrustAnchorException(inner) => inner.fmt(f),
            Error::InvalidAliasNameException(inner) => inner.fmt(f),
            Error::InvalidArnException(inner) => inner.fmt(f),
            Error::InvalidCiphertextException(inner) => inner.fmt(f),
            Error::InvalidGrantIdException(inner) => inner.fmt(f),
            Error::InvalidGrantTokenException(inner) => inner.fmt(f),
            Error::InvalidImportTokenException(inner) => inner.fmt(f),
            Error::InvalidKeyUsageException(inner) => inner.fmt(f),
            Error::InvalidMarkerException(inner) => inner.fmt(f),
            Error::KmsInternalException(inner) => inner.fmt(f),
            Error::KmsInvalidSignatureException(inner) => inner.fmt(f),
            Error::KmsInvalidStateException(inner) => inner.fmt(f),
            Error::KeyUnavailableException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::MalformedPolicyDocumentException(inner) => inner.fmt(f),
            Error::NotFoundException(inner) => inner.fmt(f),
            Error::TagException(inner) => inner.fmt(f),
            Error::UnsupportedOperationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelKeyDeletionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelKeyDeletionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelKeyDeletionErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::CancelKeyDeletionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::CancelKeyDeletionErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::CancelKeyDeletionErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::CancelKeyDeletionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CancelKeyDeletionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConnectCustomKeyStoreError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConnectCustomKeyStoreError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(inner) => Error::CloudHsmClusterInvalidConfigurationException(inner),
                crate::error::ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(inner) => Error::CloudHsmClusterNotActiveException(inner),
                crate::error::ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(inner) => Error::CustomKeyStoreInvalidStateException(inner),
                crate::error::ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(inner) => Error::CustomKeyStoreNotFoundException(inner),
                crate::error::ConnectCustomKeyStoreErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::ConnectCustomKeyStoreErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAliasErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateAliasErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::CreateAliasErrorKind::InvalidAliasNameException(inner) => {
                    Error::InvalidAliasNameException(inner)
                }
                crate::error::CreateAliasErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::CreateAliasErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::CreateAliasErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateAliasErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomKeyStoreError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomKeyStoreError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException(inner) => Error::CloudHsmClusterInUseException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(inner) => Error::CloudHsmClusterInvalidConfigurationException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(inner) => Error::CloudHsmClusterNotActiveException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(inner) => Error::CloudHsmClusterNotFoundException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(inner) => Error::CustomKeyStoreNameInUseException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException(inner) => Error::IncorrectTrustAnchorException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::CreateCustomKeyStoreErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGrantErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::CreateGrantErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::CreateGrantErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::CreateGrantErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::CreateGrantErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::CreateGrantErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::CreateGrantErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateGrantErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException(
                    inner,
                ) => Error::CloudHsmClusterInvalidConfigurationException(inner),
                crate::error::CreateKeyErrorKind::CustomKeyStoreInvalidStateException(inner) => {
                    Error::CustomKeyStoreInvalidStateException(inner)
                }
                crate::error::CreateKeyErrorKind::CustomKeyStoreNotFoundException(inner) => {
                    Error::CustomKeyStoreNotFoundException(inner)
                }
                crate::error::CreateKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::CreateKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::CreateKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::CreateKeyErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateKeyErrorKind::MalformedPolicyDocumentException(inner) => {
                    Error::MalformedPolicyDocumentException(inner)
                }
                crate::error::CreateKeyErrorKind::TagException(inner) => Error::TagException(inner),
                crate::error::CreateKeyErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::CreateKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DecryptError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DecryptError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DecryptErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::DecryptErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::DecryptErrorKind::IncorrectKeyException(inner) => {
                    Error::IncorrectKeyException(inner)
                }
                crate::error::DecryptErrorKind::InvalidCiphertextException(inner) => {
                    Error::InvalidCiphertextException(inner)
                }
                crate::error::DecryptErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::DecryptErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::DecryptErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::DecryptErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DecryptErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::DecryptErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DecryptErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAliasErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::DeleteAliasErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DeleteAliasErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::DeleteAliasErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomKeyStoreError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomKeyStoreError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException(inner) => Error::CustomKeyStoreHasCmKsException(inner),
                crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(inner) => Error::CustomKeyStoreInvalidStateException(inner),
                crate::error::DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(inner) => Error::CustomKeyStoreNotFoundException(inner),
                crate::error::DeleteCustomKeyStoreErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::DeleteCustomKeyStoreErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteImportedKeyMaterialError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteImportedKeyMaterialError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException(
                    inner,
                ) => Error::DependencyTimeoutException(inner),
                crate::error::DeleteImportedKeyMaterialErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DeleteImportedKeyMaterialErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException(
                    inner,
                ) => Error::KmsInvalidStateException(inner),
                crate::error::DeleteImportedKeyMaterialErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::DeleteImportedKeyMaterialErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCustomKeyStoresError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCustomKeyStoresError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException(
                    inner,
                ) => Error::CustomKeyStoreNotFoundException(inner),
                crate::error::DescribeCustomKeyStoresErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::DescribeCustomKeyStoresErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DescribeCustomKeyStoresErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::DescribeKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DescribeKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DescribeKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DescribeKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::DisableKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DisableKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DisableKeyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::DisableKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DisableKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableKeyRotationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableKeyRotationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableKeyRotationErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::DisableKeyRotationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisconnectCustomKeyStoreError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisconnectCustomKeyStoreError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(inner) => Error::CustomKeyStoreInvalidStateException(inner),
                crate::error::DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(inner) => Error::CustomKeyStoreNotFoundException(inner),
                crate::error::DisconnectCustomKeyStoreErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::DisconnectCustomKeyStoreErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::EnableKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::EnableKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::EnableKeyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::EnableKeyErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::EnableKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::EnableKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableKeyRotationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableKeyRotationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableKeyRotationErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::EnableKeyRotationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EncryptError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EncryptError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EncryptErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::EncryptErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::EncryptErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::EncryptErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::EncryptErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::EncryptErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::EncryptErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::EncryptErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::EncryptErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GenerateDataKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GenerateDataKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyPairError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyPairError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GenerateDataKeyPairErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GenerateDataKeyPairErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::GenerateDataKeyPairErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GenerateDataKeyPairWithoutPlaintextError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GenerateDataKeyPairWithoutPlaintextError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException(inner) => Error::DependencyTimeoutException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException(inner) => Error::DisabledException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException(inner) => Error::InvalidGrantTokenException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException(inner) => Error::InvalidKeyUsageException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException(inner) => Error::KeyUnavailableException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException(inner) => Error::UnsupportedOperationException(inner),
                crate::error::GenerateDataKeyPairWithoutPlaintextErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GenerateDataKeyWithoutPlaintextError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GenerateDataKeyWithoutPlaintextError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException(inner) => Error::DependencyTimeoutException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::DisabledException(inner) => Error::DisabledException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException(inner) => Error::InvalidGrantTokenException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException(inner) => Error::InvalidKeyUsageException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException(inner) => Error::KeyUnavailableException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException(inner) => Error::KmsInvalidStateException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GenerateDataKeyWithoutPlaintextErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GenerateRandomError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GenerateRandomError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GenerateRandomErrorKind::CustomKeyStoreInvalidStateException(
                    inner,
                ) => Error::CustomKeyStoreInvalidStateException(inner),
                crate::error::GenerateRandomErrorKind::CustomKeyStoreNotFoundException(inner) => {
                    Error::CustomKeyStoreNotFoundException(inner)
                }
                crate::error::GenerateRandomErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GenerateRandomErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GenerateRandomErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetKeyPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyPolicyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GetKeyPolicyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetKeyPolicyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GetKeyPolicyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GetKeyPolicyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetKeyPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyRotationStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetKeyRotationStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyRotationStatusErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GetKeyRotationStatusErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetKeyRotationStatusErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GetKeyRotationStatusErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GetKeyRotationStatusErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetKeyRotationStatusErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::GetKeyRotationStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetParametersForImportError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetParametersForImportError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetParametersForImportErrorKind::DependencyTimeoutException(
                    inner,
                ) => Error::DependencyTimeoutException(inner),
                crate::error::GetParametersForImportErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetParametersForImportErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GetParametersForImportErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GetParametersForImportErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetParametersForImportErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::GetParametersForImportErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPublicKeyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::GetPublicKeyErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::GetPublicKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::GetPublicKeyErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::GetPublicKeyErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::GetPublicKeyErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::GetPublicKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::GetPublicKeyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::GetPublicKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetPublicKeyErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::GetPublicKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportKeyMaterialError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportKeyMaterialError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportKeyMaterialErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::ExpiredImportTokenException(inner) => {
                    Error::ExpiredImportTokenException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::IncorrectKeyMaterialException(inner) => {
                    Error::IncorrectKeyMaterialException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::InvalidCiphertextException(inner) => {
                    Error::InvalidCiphertextException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::InvalidImportTokenException(inner) => {
                    Error::InvalidImportTokenException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::ImportKeyMaterialErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAliasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListAliasesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAliasesErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ListAliasesErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListAliasesErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::ListAliasesErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListAliasesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListAliasesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGrantsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListGrantsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGrantsErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ListGrantsErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListGrantsErrorKind::InvalidGrantIdException(inner) => {
                    Error::InvalidGrantIdException(inner)
                }
                crate::error::ListGrantsErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::ListGrantsErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListGrantsErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ListGrantsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListGrantsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListKeyPoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListKeyPoliciesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListKeyPoliciesErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ListKeyPoliciesErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListKeyPoliciesErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListKeyPoliciesErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ListKeyPoliciesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListKeyPoliciesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListKeysError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListKeysError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListKeysErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ListKeysErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::ListKeysErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListKeysErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceTagsErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListResourceTagsErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::ListResourceTagsErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListResourceTagsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListResourceTagsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListRetirableGrantsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListRetirableGrantsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListRetirableGrantsErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ListRetirableGrantsErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ListRetirableGrantsErrorKind::InvalidMarkerException(inner) => {
                    Error::InvalidMarkerException(inner)
                }
                crate::error::ListRetirableGrantsErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ListRetirableGrantsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListRetirableGrantsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutKeyPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutKeyPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutKeyPolicyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::MalformedPolicyDocumentException(inner) => {
                    Error::MalformedPolicyDocumentException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::PutKeyPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ReEncryptError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ReEncryptError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ReEncryptErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ReEncryptErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::ReEncryptErrorKind::IncorrectKeyException(inner) => {
                    Error::IncorrectKeyException(inner)
                }
                crate::error::ReEncryptErrorKind::InvalidCiphertextException(inner) => {
                    Error::InvalidCiphertextException(inner)
                }
                crate::error::ReEncryptErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::ReEncryptErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::ReEncryptErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::ReEncryptErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ReEncryptErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ReEncryptErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ReEncryptErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ReplicateKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ReplicateKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ReplicateKeyErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::ReplicateKeyErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::ReplicateKeyErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ReplicateKeyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ReplicateKeyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ReplicateKeyErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::ReplicateKeyErrorKind::MalformedPolicyDocumentException(inner) => {
                    Error::MalformedPolicyDocumentException(inner)
                }
                crate::error::ReplicateKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ReplicateKeyErrorKind::TagException(inner) => {
                    Error::TagException(inner)
                }
                crate::error::ReplicateKeyErrorKind::UnsupportedOperationException(inner) => {
                    Error::UnsupportedOperationException(inner)
                }
                crate::error::ReplicateKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RetireGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RetireGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RetireGrantErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::RetireGrantErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::RetireGrantErrorKind::InvalidGrantIdException(inner) => {
                    Error::InvalidGrantIdException(inner)
                }
                crate::error::RetireGrantErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::RetireGrantErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::RetireGrantErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::RetireGrantErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::RetireGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RevokeGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RevokeGrantErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::RevokeGrantErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::RevokeGrantErrorKind::InvalidGrantIdException(inner) => {
                    Error::InvalidGrantIdException(inner)
                }
                crate::error::RevokeGrantErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::RevokeGrantErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::RevokeGrantErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::RevokeGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ScheduleKeyDeletionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ScheduleKeyDeletionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ScheduleKeyDeletionErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::ScheduleKeyDeletionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::ScheduleKeyDeletionErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::ScheduleKeyDeletionErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::ScheduleKeyDeletionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ScheduleKeyDeletionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SignError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SignError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SignErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::SignErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::SignErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::SignErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::SignErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::SignErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::SignErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::SignErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SignErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::TagResourceErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::TagResourceErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::TagResourceErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::TagException(inner) => {
                    Error::TagException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UntagResourceErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::UntagResourceErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::UntagResourceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::TagException(inner) => {
                    Error::TagException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAliasErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::UpdateAliasErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::UpdateAliasErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::UpdateAliasErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateAliasErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCustomKeyStoreError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCustomKeyStoreError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(inner) => Error::CloudHsmClusterInvalidConfigurationException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(inner) => Error::CloudHsmClusterNotActiveException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(inner) => Error::CloudHsmClusterNotFoundException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException(inner) => Error::CloudHsmClusterNotRelatedException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(inner) => Error::CustomKeyStoreInvalidStateException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(inner) => Error::CustomKeyStoreNameInUseException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(inner) => Error::CustomKeyStoreNotFoundException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::KmsInternalException(inner) => Error::KmsInternalException(inner),
                crate::error::UpdateCustomKeyStoreErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateKeyDescriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateKeyDescriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateKeyDescriptionErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::UpdateKeyDescriptionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UpdateKeyDescriptionErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::UpdateKeyDescriptionErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::UpdateKeyDescriptionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateKeyDescriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryRegionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePrimaryRegionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePrimaryRegionErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::UpdatePrimaryRegionErrorKind::InvalidArnException(inner) => {
                    Error::InvalidArnException(inner)
                }
                crate::error::UpdatePrimaryRegionErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::UpdatePrimaryRegionErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::UpdatePrimaryRegionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdatePrimaryRegionErrorKind::UnsupportedOperationException(
                    inner,
                ) => Error::UnsupportedOperationException(inner),
                crate::error::UpdatePrimaryRegionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::VerifyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::VerifyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::VerifyErrorKind::DependencyTimeoutException(inner) => {
                    Error::DependencyTimeoutException(inner)
                }
                crate::error::VerifyErrorKind::DisabledException(inner) => {
                    Error::DisabledException(inner)
                }
                crate::error::VerifyErrorKind::InvalidGrantTokenException(inner) => {
                    Error::InvalidGrantTokenException(inner)
                }
                crate::error::VerifyErrorKind::InvalidKeyUsageException(inner) => {
                    Error::InvalidKeyUsageException(inner)
                }
                crate::error::VerifyErrorKind::KeyUnavailableException(inner) => {
                    Error::KeyUnavailableException(inner)
                }
                crate::error::VerifyErrorKind::KmsInternalException(inner) => {
                    Error::KmsInternalException(inner)
                }
                crate::error::VerifyErrorKind::KmsInvalidSignatureException(inner) => {
                    Error::KmsInvalidSignatureException(inner)
                }
                crate::error::VerifyErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::VerifyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::VerifyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
