// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MacAlgorithmSpec {
    #[allow(missing_docs)] // documentation missing in model
    HmacSha224,
    #[allow(missing_docs)] // documentation missing in model
    HmacSha256,
    #[allow(missing_docs)] // documentation missing in model
    HmacSha384,
    #[allow(missing_docs)] // documentation missing in model
    HmacSha512,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MacAlgorithmSpec {
    fn from(s: &str) -> Self {
        match s {
            "HMAC_SHA_224" => MacAlgorithmSpec::HmacSha224,
            "HMAC_SHA_256" => MacAlgorithmSpec::HmacSha256,
            "HMAC_SHA_384" => MacAlgorithmSpec::HmacSha384,
            "HMAC_SHA_512" => MacAlgorithmSpec::HmacSha512,
            other => MacAlgorithmSpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MacAlgorithmSpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MacAlgorithmSpec::from(s))
    }
}
impl MacAlgorithmSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MacAlgorithmSpec::HmacSha224 => "HMAC_SHA_224",
            MacAlgorithmSpec::HmacSha256 => "HMAC_SHA_256",
            MacAlgorithmSpec::HmacSha384 => "HMAC_SHA_384",
            MacAlgorithmSpec::HmacSha512 => "HMAC_SHA_512",
            MacAlgorithmSpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "HMAC_SHA_224",
            "HMAC_SHA_256",
            "HMAC_SHA_384",
            "HMAC_SHA_512",
        ]
    }
}
impl AsRef<str> for MacAlgorithmSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SigningAlgorithmSpec {
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha256,
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha384,
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha512,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha256,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha384,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha512,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha256,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha384,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha512,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SigningAlgorithmSpec {
    fn from(s: &str) -> Self {
        match s {
            "ECDSA_SHA_256" => SigningAlgorithmSpec::EcdsaSha256,
            "ECDSA_SHA_384" => SigningAlgorithmSpec::EcdsaSha384,
            "ECDSA_SHA_512" => SigningAlgorithmSpec::EcdsaSha512,
            "RSASSA_PKCS1_V1_5_SHA_256" => SigningAlgorithmSpec::RsassaPkcs1V15Sha256,
            "RSASSA_PKCS1_V1_5_SHA_384" => SigningAlgorithmSpec::RsassaPkcs1V15Sha384,
            "RSASSA_PKCS1_V1_5_SHA_512" => SigningAlgorithmSpec::RsassaPkcs1V15Sha512,
            "RSASSA_PSS_SHA_256" => SigningAlgorithmSpec::RsassaPssSha256,
            "RSASSA_PSS_SHA_384" => SigningAlgorithmSpec::RsassaPssSha384,
            "RSASSA_PSS_SHA_512" => SigningAlgorithmSpec::RsassaPssSha512,
            other => SigningAlgorithmSpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SigningAlgorithmSpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SigningAlgorithmSpec::from(s))
    }
}
impl SigningAlgorithmSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningAlgorithmSpec::EcdsaSha256 => "ECDSA_SHA_256",
            SigningAlgorithmSpec::EcdsaSha384 => "ECDSA_SHA_384",
            SigningAlgorithmSpec::EcdsaSha512 => "ECDSA_SHA_512",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha256 => "RSASSA_PKCS1_V1_5_SHA_256",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha384 => "RSASSA_PKCS1_V1_5_SHA_384",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha512 => "RSASSA_PKCS1_V1_5_SHA_512",
            SigningAlgorithmSpec::RsassaPssSha256 => "RSASSA_PSS_SHA_256",
            SigningAlgorithmSpec::RsassaPssSha384 => "RSASSA_PSS_SHA_384",
            SigningAlgorithmSpec::RsassaPssSha512 => "RSASSA_PSS_SHA_512",
            SigningAlgorithmSpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ECDSA_SHA_256",
            "ECDSA_SHA_384",
            "ECDSA_SHA_512",
            "RSASSA_PKCS1_V1_5_SHA_256",
            "RSASSA_PKCS1_V1_5_SHA_384",
            "RSASSA_PKCS1_V1_5_SHA_512",
            "RSASSA_PSS_SHA_256",
            "RSASSA_PSS_SHA_384",
            "RSASSA_PSS_SHA_512",
        ]
    }
}
impl AsRef<str> for SigningAlgorithmSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageType {
    #[allow(missing_docs)] // documentation missing in model
    Digest,
    #[allow(missing_docs)] // documentation missing in model
    Raw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageType {
    fn from(s: &str) -> Self {
        match s {
            "DIGEST" => MessageType::Digest,
            "RAW" => MessageType::Raw,
            other => MessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageType::from(s))
    }
}
impl MessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageType::Digest => "DIGEST",
            MessageType::Raw => "RAW",
            MessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIGEST", "RAW"]
    }
}
impl AsRef<str> for MessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p>
/// <p>For information about the rules that apply to tag keys and tag values, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub tag_value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn tag_value(&self) -> std::option::Option<&str> {
        self.tag_value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_value", &self.tag_value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn tag_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_tag_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                tag_key: self.tag_key,
                tag_value: self.tag_value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyState {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeletion,
    #[allow(missing_docs)] // documentation missing in model
    PendingImport,
    #[allow(missing_docs)] // documentation missing in model
    PendingReplicaDeletion,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyState {
    fn from(s: &str) -> Self {
        match s {
            "Creating" => KeyState::Creating,
            "Disabled" => KeyState::Disabled,
            "Enabled" => KeyState::Enabled,
            "PendingDeletion" => KeyState::PendingDeletion,
            "PendingImport" => KeyState::PendingImport,
            "PendingReplicaDeletion" => KeyState::PendingReplicaDeletion,
            "Unavailable" => KeyState::Unavailable,
            "Updating" => KeyState::Updating,
            other => KeyState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyState::from(s))
    }
}
impl KeyState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyState::Creating => "Creating",
            KeyState::Disabled => "Disabled",
            KeyState::Enabled => "Enabled",
            KeyState::PendingDeletion => "PendingDeletion",
            KeyState::PendingImport => "PendingImport",
            KeyState::PendingReplicaDeletion => "PendingReplicaDeletion",
            KeyState::Unavailable => "Unavailable",
            KeyState::Updating => "Updating",
            KeyState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Creating",
            "Disabled",
            "Enabled",
            "PendingDeletion",
            "PendingImport",
            "PendingReplicaDeletion",
            "Unavailable",
            "Updating",
        ]
    }
}
impl AsRef<str> for KeyState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains metadata about a KMS key.</p>
/// <p>This data type is used as a response element for the <code>CreateKey</code> and <code>DescribeKey</code> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyMetadata {
    /// <p>The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The globally unique identifier for the KMS key.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key. For examples, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Key Management Service (KMS)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the KMS key was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the KMS key is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true, otherwise it is false.</p>
    pub enabled: bool,
    /// <p>The description of the KMS key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key.</p>
    pub key_usage: std::option::Option<crate::model::KeyUsageType>,
    /// <p>The current status of the KMS key.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub key_state: std::option::Option<crate::model::KeyState>,
    /// <p>The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its <code>KeyState</code> is <code>PendingDeletion</code>.</p>
    /// <p>When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is <code>PendingReplicaDeletion</code> and the length of its waiting period is displayed in the <code>PendingDeletionWindowInDays</code> field.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.</p>
    pub valid_to: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The source of the key material for the KMS key. When this value is <code>AWS_KMS</code>, KMS created the key material. When this value is <code>EXTERNAL</code>, the key material was imported or the KMS key doesn't have any key material. When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated with a custom key store.</p>
    pub origin: std::option::Option<crate::model::OriginType>,
    /// <p>A unique identifier for the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> that contains the KMS key. This value is present only when the KMS key is created in a custom key store.</p>
    pub custom_key_store_id: std::option::Option<std::string::String>,
    /// <p>The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, KMS creates the key material for the KMS key in the associated CloudHSM cluster. This value is present only when the KMS key is created in a custom key store.</p>
    pub cloud_hsm_cluster_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the KMS key's key material expires. This value is present only when <code>Origin</code> is <code>EXTERNAL</code>, otherwise this value is omitted.</p>
    pub expiration_model: std::option::Option<crate::model::ExpirationModelType>,
    /// <p>The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub key_manager: std::option::Option<crate::model::KeyManagerType>,
    /// <p>Instead, use the <code>KeySpec</code> field.</p>
    /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same value. We recommend that you use the <code>KeySpec</code> field in your code. However, to avoid breaking changes, KMS will support both fields.</p>
    pub customer_master_key_spec: std::option::Option<crate::model::CustomerMasterKeySpec>,
    /// <p>Describes the type of key material in the KMS key.</p>
    pub key_spec: std::option::Option<crate::model::KeySpec>,
    /// <p>The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.</p>
    /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>ENCRYPT_DECRYPT</code>.</p>
    pub encryption_algorithms:
        std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
    /// <p>The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.</p>
    /// <p>This field appears only when the <code>KeyUsage</code> of the KMS key is <code>SIGN_VERIFY</code>.</p>
    pub signing_algorithms: std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
    /// <p>Indicates whether the KMS key is a multi-Region (<code>True</code>) or regional (<code>False</code>) key. This value is <code>True</code> for multi-Region primary and replica keys and <code>False</code> for regional KMS keys.</p>
    /// <p>For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub multi_region: std::option::Option<bool>,
    /// <p>Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the <code>MultiRegion</code> field is <code>True</code>.</p>
    /// <p>For more information about any listed KMS key, use the <code>DescribeKey</code> operation.</p>
    /// <ul>
    /// <li> <p> <code>MultiRegionKeyType</code> indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p> </li>
    /// <li> <p> <code>PrimaryKey</code> displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.</p> </li>
    /// <li> <p> <code>ReplicaKeys</code> displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p> </li>
    /// </ul>
    pub multi_region_configuration: std::option::Option<crate::model::MultiRegionConfiguration>,
    /// <p>The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the <code>KeyState</code> of the KMS key is <code>PendingReplicaDeletion</code>. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.</p>
    /// <p>When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the <code>DeletionDate</code> field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the <code>KeyState</code> of the scheduled primary key changes from <code>PendingReplicaDeletion</code> to <code>PendingDeletion</code> and the deletion date appears in the <code>DeletionDate</code> field.</p>
    pub pending_deletion_window_in_days: std::option::Option<i32>,
    /// <p>The message authentication code (MAC) algorithm that the HMAC KMS key supports.</p>
    /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>GENERATE_VERIFY_MAC</code>.</p>
    pub mac_algorithms: std::option::Option<std::vec::Vec<crate::model::MacAlgorithmSpec>>,
}
impl KeyMetadata {
    /// <p>The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The globally unique identifier for the KMS key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the KMS key. For examples, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Key Management Service (KMS)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the KMS key was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Specifies whether the KMS key is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true, otherwise it is false.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The description of the KMS key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key.</p>
    pub fn key_usage(&self) -> std::option::Option<&crate::model::KeyUsageType> {
        self.key_usage.as_ref()
    }
    /// <p>The current status of the KMS key.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub fn key_state(&self) -> std::option::Option<&crate::model::KeyState> {
        self.key_state.as_ref()
    }
    /// <p>The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its <code>KeyState</code> is <code>PendingDeletion</code>.</p>
    /// <p>When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is <code>PendingReplicaDeletion</code> and the length of its waiting period is displayed in the <code>PendingDeletionWindowInDays</code> field.</p>
    pub fn deletion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_date.as_ref()
    }
    /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.</p>
    pub fn valid_to(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_to.as_ref()
    }
    /// <p>The source of the key material for the KMS key. When this value is <code>AWS_KMS</code>, KMS created the key material. When this value is <code>EXTERNAL</code>, the key material was imported or the KMS key doesn't have any key material. When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated with a custom key store.</p>
    pub fn origin(&self) -> std::option::Option<&crate::model::OriginType> {
        self.origin.as_ref()
    }
    /// <p>A unique identifier for the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> that contains the KMS key. This value is present only when the KMS key is created in a custom key store.</p>
    pub fn custom_key_store_id(&self) -> std::option::Option<&str> {
        self.custom_key_store_id.as_deref()
    }
    /// <p>The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, KMS creates the key material for the KMS key in the associated CloudHSM cluster. This value is present only when the KMS key is created in a custom key store.</p>
    pub fn cloud_hsm_cluster_id(&self) -> std::option::Option<&str> {
        self.cloud_hsm_cluster_id.as_deref()
    }
    /// <p>Specifies whether the KMS key's key material expires. This value is present only when <code>Origin</code> is <code>EXTERNAL</code>, otherwise this value is omitted.</p>
    pub fn expiration_model(&self) -> std::option::Option<&crate::model::ExpirationModelType> {
        self.expiration_model.as_ref()
    }
    /// <p>The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub fn key_manager(&self) -> std::option::Option<&crate::model::KeyManagerType> {
        self.key_manager.as_ref()
    }
    /// <p>Instead, use the <code>KeySpec</code> field.</p>
    /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same value. We recommend that you use the <code>KeySpec</code> field in your code. However, to avoid breaking changes, KMS will support both fields.</p>
    pub fn customer_master_key_spec(
        &self,
    ) -> std::option::Option<&crate::model::CustomerMasterKeySpec> {
        self.customer_master_key_spec.as_ref()
    }
    /// <p>Describes the type of key material in the KMS key.</p>
    pub fn key_spec(&self) -> std::option::Option<&crate::model::KeySpec> {
        self.key_spec.as_ref()
    }
    /// <p>The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.</p>
    /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>ENCRYPT_DECRYPT</code>.</p>
    pub fn encryption_algorithms(
        &self,
    ) -> std::option::Option<&[crate::model::EncryptionAlgorithmSpec]> {
        self.encryption_algorithms.as_deref()
    }
    /// <p>The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.</p>
    /// <p>This field appears only when the <code>KeyUsage</code> of the KMS key is <code>SIGN_VERIFY</code>.</p>
    pub fn signing_algorithms(&self) -> std::option::Option<&[crate::model::SigningAlgorithmSpec]> {
        self.signing_algorithms.as_deref()
    }
    /// <p>Indicates whether the KMS key is a multi-Region (<code>True</code>) or regional (<code>False</code>) key. This value is <code>True</code> for multi-Region primary and replica keys and <code>False</code> for regional KMS keys.</p>
    /// <p>For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub fn multi_region(&self) -> std::option::Option<bool> {
        self.multi_region
    }
    /// <p>Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the <code>MultiRegion</code> field is <code>True</code>.</p>
    /// <p>For more information about any listed KMS key, use the <code>DescribeKey</code> operation.</p>
    /// <ul>
    /// <li> <p> <code>MultiRegionKeyType</code> indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p> </li>
    /// <li> <p> <code>PrimaryKey</code> displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.</p> </li>
    /// <li> <p> <code>ReplicaKeys</code> displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p> </li>
    /// </ul>
    pub fn multi_region_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MultiRegionConfiguration> {
        self.multi_region_configuration.as_ref()
    }
    /// <p>The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the <code>KeyState</code> of the KMS key is <code>PendingReplicaDeletion</code>. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.</p>
    /// <p>When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the <code>DeletionDate</code> field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the <code>KeyState</code> of the scheduled primary key changes from <code>PendingReplicaDeletion</code> to <code>PendingDeletion</code> and the deletion date appears in the <code>DeletionDate</code> field.</p>
    pub fn pending_deletion_window_in_days(&self) -> std::option::Option<i32> {
        self.pending_deletion_window_in_days
    }
    /// <p>The message authentication code (MAC) algorithm that the HMAC KMS key supports.</p>
    /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>GENERATE_VERIFY_MAC</code>.</p>
    pub fn mac_algorithms(&self) -> std::option::Option<&[crate::model::MacAlgorithmSpec]> {
        self.mac_algorithms.as_deref()
    }
}
impl std::fmt::Debug for KeyMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyMetadata");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("key_id", &self.key_id);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("enabled", &self.enabled);
        formatter.field("description", &self.description);
        formatter.field("key_usage", &self.key_usage);
        formatter.field("key_state", &self.key_state);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.field("valid_to", &self.valid_to);
        formatter.field("origin", &self.origin);
        formatter.field("custom_key_store_id", &self.custom_key_store_id);
        formatter.field("cloud_hsm_cluster_id", &self.cloud_hsm_cluster_id);
        formatter.field("expiration_model", &self.expiration_model);
        formatter.field("key_manager", &self.key_manager);
        formatter.field("customer_master_key_spec", &self.customer_master_key_spec);
        formatter.field("key_spec", &self.key_spec);
        formatter.field("encryption_algorithms", &self.encryption_algorithms);
        formatter.field("signing_algorithms", &self.signing_algorithms);
        formatter.field("multi_region", &self.multi_region);
        formatter.field(
            "multi_region_configuration",
            &self.multi_region_configuration,
        );
        formatter.field(
            "pending_deletion_window_in_days",
            &self.pending_deletion_window_in_days,
        );
        formatter.field("mac_algorithms", &self.mac_algorithms);
        formatter.finish()
    }
}
/// See [`KeyMetadata`](crate::model::KeyMetadata)
pub mod key_metadata {
    /// A builder for [`KeyMetadata`](crate::model::KeyMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) key_usage: std::option::Option<crate::model::KeyUsageType>,
        pub(crate) key_state: std::option::Option<crate::model::KeyState>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_to: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) origin: std::option::Option<crate::model::OriginType>,
        pub(crate) custom_key_store_id: std::option::Option<std::string::String>,
        pub(crate) cloud_hsm_cluster_id: std::option::Option<std::string::String>,
        pub(crate) expiration_model: std::option::Option<crate::model::ExpirationModelType>,
        pub(crate) key_manager: std::option::Option<crate::model::KeyManagerType>,
        pub(crate) customer_master_key_spec:
            std::option::Option<crate::model::CustomerMasterKeySpec>,
        pub(crate) key_spec: std::option::Option<crate::model::KeySpec>,
        pub(crate) encryption_algorithms:
            std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
        pub(crate) signing_algorithms:
            std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
        pub(crate) multi_region: std::option::Option<bool>,
        pub(crate) multi_region_configuration:
            std::option::Option<crate::model::MultiRegionConfiguration>,
        pub(crate) pending_deletion_window_in_days: std::option::Option<i32>,
        pub(crate) mac_algorithms:
            std::option::Option<std::vec::Vec<crate::model::MacAlgorithmSpec>>,
    }
    impl Builder {
        /// <p>The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The globally unique identifier for the KMS key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The globally unique identifier for the KMS key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key. For examples, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Key Management Service (KMS)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key. For examples, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Key Management Service (KMS)</a> in the Example ARNs section of the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the KMS key was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the KMS key was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Specifies whether the KMS key is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true, otherwise it is false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the KMS key is enabled. When <code>KeyState</code> is <code>Enabled</code> this value is true, otherwise it is false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The description of the KMS key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the KMS key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key.</p>
        pub fn key_usage(mut self, input: crate::model::KeyUsageType) -> Self {
            self.key_usage = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> for which you can use the KMS key.</p>
        pub fn set_key_usage(
            mut self,
            input: std::option::Option<crate::model::KeyUsageType>,
        ) -> Self {
            self.key_usage = input;
            self
        }
        /// <p>The current status of the KMS key.</p>
        /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn key_state(mut self, input: crate::model::KeyState) -> Self {
            self.key_state = Some(input);
            self
        }
        /// <p>The current status of the KMS key.</p>
        /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_key_state(mut self, input: std::option::Option<crate::model::KeyState>) -> Self {
            self.key_state = input;
            self
        }
        /// <p>The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its <code>KeyState</code> is <code>PendingDeletion</code>.</p>
        /// <p>When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is <code>PendingReplicaDeletion</code> and the length of its waiting period is displayed in the <code>PendingDeletionWindowInDays</code> field.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its <code>KeyState</code> is <code>PendingDeletion</code>.</p>
        /// <p>When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is <code>PendingReplicaDeletion</code> and the length of its waiting period is displayed in the <code>PendingDeletionWindowInDays</code> field.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.</p>
        pub fn valid_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_to = Some(input);
            self
        }
        /// <p>The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose <code>Origin</code> is <code>EXTERNAL</code> and whose <code>ExpirationModel</code> is <code>KEY_MATERIAL_EXPIRES</code>, otherwise this value is omitted.</p>
        pub fn set_valid_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_to = input;
            self
        }
        /// <p>The source of the key material for the KMS key. When this value is <code>AWS_KMS</code>, KMS created the key material. When this value is <code>EXTERNAL</code>, the key material was imported or the KMS key doesn't have any key material. When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated with a custom key store.</p>
        pub fn origin(mut self, input: crate::model::OriginType) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>The source of the key material for the KMS key. When this value is <code>AWS_KMS</code>, KMS created the key material. When this value is <code>EXTERNAL</code>, the key material was imported or the KMS key doesn't have any key material. When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the CloudHSM cluster associated with a custom key store.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::OriginType>) -> Self {
            self.origin = input;
            self
        }
        /// <p>A unique identifier for the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> that contains the KMS key. This value is present only when the KMS key is created in a custom key store.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_key_store_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> that contains the KMS key. This value is present only when the KMS key is created in a custom key store.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_key_store_id = input;
            self
        }
        /// <p>The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, KMS creates the key material for the KMS key in the associated CloudHSM cluster. This value is present only when the KMS key is created in a custom key store.</p>
        pub fn cloud_hsm_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_hsm_cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a>, KMS creates the key material for the KMS key in the associated CloudHSM cluster. This value is present only when the KMS key is created in a custom key store.</p>
        pub fn set_cloud_hsm_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_hsm_cluster_id = input;
            self
        }
        /// <p>Specifies whether the KMS key's key material expires. This value is present only when <code>Origin</code> is <code>EXTERNAL</code>, otherwise this value is omitted.</p>
        pub fn expiration_model(mut self, input: crate::model::ExpirationModelType) -> Self {
            self.expiration_model = Some(input);
            self
        }
        /// <p>Specifies whether the KMS key's key material expires. This value is present only when <code>Origin</code> is <code>EXTERNAL</code>, otherwise this value is omitted.</p>
        pub fn set_expiration_model(
            mut self,
            input: std::option::Option<crate::model::ExpirationModelType>,
        ) -> Self {
            self.expiration_model = input;
            self
        }
        /// <p>The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn key_manager(mut self, input: crate::model::KeyManagerType) -> Self {
            self.key_manager = Some(input);
            self
        }
        /// <p>The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_key_manager(
            mut self,
            input: std::option::Option<crate::model::KeyManagerType>,
        ) -> Self {
            self.key_manager = input;
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> field.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same value. We recommend that you use the <code>KeySpec</code> field in your code. However, to avoid breaking changes, KMS will support both fields.</p>
        pub fn customer_master_key_spec(
            mut self,
            input: crate::model::CustomerMasterKeySpec,
        ) -> Self {
            self.customer_master_key_spec = Some(input);
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> field.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same value. We recommend that you use the <code>KeySpec</code> field in your code. However, to avoid breaking changes, KMS will support both fields.</p>
        pub fn set_customer_master_key_spec(
            mut self,
            input: std::option::Option<crate::model::CustomerMasterKeySpec>,
        ) -> Self {
            self.customer_master_key_spec = input;
            self
        }
        /// <p>Describes the type of key material in the KMS key.</p>
        pub fn key_spec(mut self, input: crate::model::KeySpec) -> Self {
            self.key_spec = Some(input);
            self
        }
        /// <p>Describes the type of key material in the KMS key.</p>
        pub fn set_key_spec(mut self, input: std::option::Option<crate::model::KeySpec>) -> Self {
            self.key_spec = input;
            self
        }
        /// Appends an item to `encryption_algorithms`.
        ///
        /// To override the contents of this collection use [`set_encryption_algorithms`](Self::set_encryption_algorithms).
        ///
        /// <p>The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.</p>
        /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>ENCRYPT_DECRYPT</code>.</p>
        pub fn encryption_algorithms(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            let mut v = self.encryption_algorithms.unwrap_or_default();
            v.push(input);
            self.encryption_algorithms = Some(v);
            self
        }
        /// <p>The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.</p>
        /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>ENCRYPT_DECRYPT</code>.</p>
        pub fn set_encryption_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
        ) -> Self {
            self.encryption_algorithms = input;
            self
        }
        /// Appends an item to `signing_algorithms`.
        ///
        /// To override the contents of this collection use [`set_signing_algorithms`](Self::set_signing_algorithms).
        ///
        /// <p>The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.</p>
        /// <p>This field appears only when the <code>KeyUsage</code> of the KMS key is <code>SIGN_VERIFY</code>.</p>
        pub fn signing_algorithms(mut self, input: crate::model::SigningAlgorithmSpec) -> Self {
            let mut v = self.signing_algorithms.unwrap_or_default();
            v.push(input);
            self.signing_algorithms = Some(v);
            self
        }
        /// <p>The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.</p>
        /// <p>This field appears only when the <code>KeyUsage</code> of the KMS key is <code>SIGN_VERIFY</code>.</p>
        pub fn set_signing_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
        ) -> Self {
            self.signing_algorithms = input;
            self
        }
        /// <p>Indicates whether the KMS key is a multi-Region (<code>True</code>) or regional (<code>False</code>) key. This value is <code>True</code> for multi-Region primary and replica keys and <code>False</code> for regional KMS keys.</p>
        /// <p>For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn multi_region(mut self, input: bool) -> Self {
            self.multi_region = Some(input);
            self
        }
        /// <p>Indicates whether the KMS key is a multi-Region (<code>True</code>) or regional (<code>False</code>) key. This value is <code>True</code> for multi-Region primary and replica keys and <code>False</code> for regional KMS keys.</p>
        /// <p>For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_multi_region(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region = input;
            self
        }
        /// <p>Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the <code>MultiRegion</code> field is <code>True</code>.</p>
        /// <p>For more information about any listed KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <ul>
        /// <li> <p> <code>MultiRegionKeyType</code> indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p> </li>
        /// <li> <p> <code>PrimaryKey</code> displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.</p> </li>
        /// <li> <p> <code>ReplicaKeys</code> displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p> </li>
        /// </ul>
        pub fn multi_region_configuration(
            mut self,
            input: crate::model::MultiRegionConfiguration,
        ) -> Self {
            self.multi_region_configuration = Some(input);
            self
        }
        /// <p>Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the <code>MultiRegion</code> field is <code>True</code>.</p>
        /// <p>For more information about any listed KMS key, use the <code>DescribeKey</code> operation.</p>
        /// <ul>
        /// <li> <p> <code>MultiRegionKeyType</code> indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p> </li>
        /// <li> <p> <code>PrimaryKey</code> displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.</p> </li>
        /// <li> <p> <code>ReplicaKeys</code> displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p> </li>
        /// </ul>
        pub fn set_multi_region_configuration(
            mut self,
            input: std::option::Option<crate::model::MultiRegionConfiguration>,
        ) -> Self {
            self.multi_region_configuration = input;
            self
        }
        /// <p>The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the <code>KeyState</code> of the KMS key is <code>PendingReplicaDeletion</code>. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.</p>
        /// <p>When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the <code>DeletionDate</code> field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the <code>KeyState</code> of the scheduled primary key changes from <code>PendingReplicaDeletion</code> to <code>PendingDeletion</code> and the deletion date appears in the <code>DeletionDate</code> field.</p>
        pub fn pending_deletion_window_in_days(mut self, input: i32) -> Self {
            self.pending_deletion_window_in_days = Some(input);
            self
        }
        /// <p>The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the <code>KeyState</code> of the KMS key is <code>PendingReplicaDeletion</code>. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.</p>
        /// <p>When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the <code>DeletionDate</code> field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the <code>KeyState</code> of the scheduled primary key changes from <code>PendingReplicaDeletion</code> to <code>PendingDeletion</code> and the deletion date appears in the <code>DeletionDate</code> field.</p>
        pub fn set_pending_deletion_window_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.pending_deletion_window_in_days = input;
            self
        }
        /// Appends an item to `mac_algorithms`.
        ///
        /// To override the contents of this collection use [`set_mac_algorithms`](Self::set_mac_algorithms).
        ///
        /// <p>The message authentication code (MAC) algorithm that the HMAC KMS key supports.</p>
        /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>GENERATE_VERIFY_MAC</code>.</p>
        pub fn mac_algorithms(mut self, input: crate::model::MacAlgorithmSpec) -> Self {
            let mut v = self.mac_algorithms.unwrap_or_default();
            v.push(input);
            self.mac_algorithms = Some(v);
            self
        }
        /// <p>The message authentication code (MAC) algorithm that the HMAC KMS key supports.</p>
        /// <p>This value is present only when the <code>KeyUsage</code> of the KMS key is <code>GENERATE_VERIFY_MAC</code>.</p>
        pub fn set_mac_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MacAlgorithmSpec>>,
        ) -> Self {
            self.mac_algorithms = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyMetadata`](crate::model::KeyMetadata)
        pub fn build(self) -> crate::model::KeyMetadata {
            crate::model::KeyMetadata {
                aws_account_id: self.aws_account_id,
                key_id: self.key_id,
                arn: self.arn,
                creation_date: self.creation_date,
                enabled: self.enabled.unwrap_or_default(),
                description: self.description,
                key_usage: self.key_usage,
                key_state: self.key_state,
                deletion_date: self.deletion_date,
                valid_to: self.valid_to,
                origin: self.origin,
                custom_key_store_id: self.custom_key_store_id,
                cloud_hsm_cluster_id: self.cloud_hsm_cluster_id,
                expiration_model: self.expiration_model,
                key_manager: self.key_manager,
                customer_master_key_spec: self.customer_master_key_spec,
                key_spec: self.key_spec,
                encryption_algorithms: self.encryption_algorithms,
                signing_algorithms: self.signing_algorithms,
                multi_region: self.multi_region,
                multi_region_configuration: self.multi_region_configuration,
                pending_deletion_window_in_days: self.pending_deletion_window_in_days,
                mac_algorithms: self.mac_algorithms,
            }
        }
    }
}
impl KeyMetadata {
    /// Creates a new builder-style object to manufacture [`KeyMetadata`](crate::model::KeyMetadata)
    pub fn builder() -> crate::model::key_metadata::Builder {
        crate::model::key_metadata::Builder::default()
    }
}

/// <p>Describes the configuration of this multi-Region key. This field appears only when the KMS key is a primary or replica of a multi-Region key.</p>
/// <p>For more information about any listed KMS key, use the <code>DescribeKey</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionConfiguration {
    /// <p>Indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p>
    pub multi_region_key_type: std::option::Option<crate::model::MultiRegionKeyType>,
    /// <p>Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.</p>
    pub primary_key: std::option::Option<crate::model::MultiRegionKey>,
    /// <p>displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p>
    pub replica_keys: std::option::Option<std::vec::Vec<crate::model::MultiRegionKey>>,
}
impl MultiRegionConfiguration {
    /// <p>Indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p>
    pub fn multi_region_key_type(&self) -> std::option::Option<&crate::model::MultiRegionKeyType> {
        self.multi_region_key_type.as_ref()
    }
    /// <p>Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.</p>
    pub fn primary_key(&self) -> std::option::Option<&crate::model::MultiRegionKey> {
        self.primary_key.as_ref()
    }
    /// <p>displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p>
    pub fn replica_keys(&self) -> std::option::Option<&[crate::model::MultiRegionKey]> {
        self.replica_keys.as_deref()
    }
}
impl std::fmt::Debug for MultiRegionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionConfiguration");
        formatter.field("multi_region_key_type", &self.multi_region_key_type);
        formatter.field("primary_key", &self.primary_key);
        formatter.field("replica_keys", &self.replica_keys);
        formatter.finish()
    }
}
/// See [`MultiRegionConfiguration`](crate::model::MultiRegionConfiguration)
pub mod multi_region_configuration {
    /// A builder for [`MultiRegionConfiguration`](crate::model::MultiRegionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multi_region_key_type: std::option::Option<crate::model::MultiRegionKeyType>,
        pub(crate) primary_key: std::option::Option<crate::model::MultiRegionKey>,
        pub(crate) replica_keys: std::option::Option<std::vec::Vec<crate::model::MultiRegionKey>>,
    }
    impl Builder {
        /// <p>Indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p>
        pub fn multi_region_key_type(mut self, input: crate::model::MultiRegionKeyType) -> Self {
            self.multi_region_key_type = Some(input);
            self
        }
        /// <p>Indicates whether the KMS key is a <code>PRIMARY</code> or <code>REPLICA</code> key.</p>
        pub fn set_multi_region_key_type(
            mut self,
            input: std::option::Option<crate::model::MultiRegionKeyType>,
        ) -> Self {
            self.multi_region_key_type = input;
            self
        }
        /// <p>Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.</p>
        pub fn primary_key(mut self, input: crate::model::MultiRegionKey) -> Self {
            self.primary_key = Some(input);
            self
        }
        /// <p>Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.</p>
        pub fn set_primary_key(
            mut self,
            input: std::option::Option<crate::model::MultiRegionKey>,
        ) -> Self {
            self.primary_key = input;
            self
        }
        /// Appends an item to `replica_keys`.
        ///
        /// To override the contents of this collection use [`set_replica_keys`](Self::set_replica_keys).
        ///
        /// <p>displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p>
        pub fn replica_keys(mut self, input: crate::model::MultiRegionKey) -> Self {
            let mut v = self.replica_keys.unwrap_or_default();
            v.push(input);
            self.replica_keys = Some(v);
            self
        }
        /// <p>displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.</p>
        pub fn set_replica_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiRegionKey>>,
        ) -> Self {
            self.replica_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionConfiguration`](crate::model::MultiRegionConfiguration)
        pub fn build(self) -> crate::model::MultiRegionConfiguration {
            crate::model::MultiRegionConfiguration {
                multi_region_key_type: self.multi_region_key_type,
                primary_key: self.primary_key,
                replica_keys: self.replica_keys,
            }
        }
    }
}
impl MultiRegionConfiguration {
    /// Creates a new builder-style object to manufacture [`MultiRegionConfiguration`](crate::model::MultiRegionConfiguration)
    pub fn builder() -> crate::model::multi_region_configuration::Builder {
        crate::model::multi_region_configuration::Builder::default()
    }
}

/// <p>Describes the primary or replica key in a multi-Region key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionKey {
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub region: std::option::Option<std::string::String>,
}
impl MultiRegionKey {
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for MultiRegionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionKey");
        formatter.field("arn", &self.arn);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`MultiRegionKey`](crate::model::MultiRegionKey)
pub mod multi_region_key {
    /// A builder for [`MultiRegionKey`](crate::model::MultiRegionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionKey`](crate::model::MultiRegionKey)
        pub fn build(self) -> crate::model::MultiRegionKey {
            crate::model::MultiRegionKey {
                arn: self.arn,
                region: self.region,
            }
        }
    }
}
impl MultiRegionKey {
    /// Creates a new builder-style object to manufacture [`MultiRegionKey`](crate::model::MultiRegionKey)
    pub fn builder() -> crate::model::multi_region_key::Builder {
        crate::model::multi_region_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MultiRegionKeyType {
    #[allow(missing_docs)] // documentation missing in model
    Primary,
    #[allow(missing_docs)] // documentation missing in model
    Replica,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MultiRegionKeyType {
    fn from(s: &str) -> Self {
        match s {
            "PRIMARY" => MultiRegionKeyType::Primary,
            "REPLICA" => MultiRegionKeyType::Replica,
            other => MultiRegionKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MultiRegionKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MultiRegionKeyType::from(s))
    }
}
impl MultiRegionKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MultiRegionKeyType::Primary => "PRIMARY",
            MultiRegionKeyType::Replica => "REPLICA",
            MultiRegionKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIMARY", "REPLICA"]
    }
}
impl AsRef<str> for MultiRegionKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionAlgorithmSpec {
    #[allow(missing_docs)] // documentation missing in model
    RsaesOaepSha1,
    #[allow(missing_docs)] // documentation missing in model
    RsaesOaepSha256,
    #[allow(missing_docs)] // documentation missing in model
    SymmetricDefault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionAlgorithmSpec {
    fn from(s: &str) -> Self {
        match s {
            "RSAES_OAEP_SHA_1" => EncryptionAlgorithmSpec::RsaesOaepSha1,
            "RSAES_OAEP_SHA_256" => EncryptionAlgorithmSpec::RsaesOaepSha256,
            "SYMMETRIC_DEFAULT" => EncryptionAlgorithmSpec::SymmetricDefault,
            other => EncryptionAlgorithmSpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionAlgorithmSpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionAlgorithmSpec::from(s))
    }
}
impl EncryptionAlgorithmSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionAlgorithmSpec::RsaesOaepSha1 => "RSAES_OAEP_SHA_1",
            EncryptionAlgorithmSpec::RsaesOaepSha256 => "RSAES_OAEP_SHA_256",
            EncryptionAlgorithmSpec::SymmetricDefault => "SYMMETRIC_DEFAULT",
            EncryptionAlgorithmSpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "RSAES_OAEP_SHA_1",
            "RSAES_OAEP_SHA_256",
            "SYMMETRIC_DEFAULT",
        ]
    }
}
impl AsRef<str> for EncryptionAlgorithmSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeySpec {
    #[allow(missing_docs)] // documentation missing in model
    EccNistP256,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP384,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP521,
    #[allow(missing_docs)] // documentation missing in model
    EccSecgP256K1,
    #[allow(missing_docs)] // documentation missing in model
    Hmac224,
    #[allow(missing_docs)] // documentation missing in model
    Hmac256,
    #[allow(missing_docs)] // documentation missing in model
    Hmac384,
    #[allow(missing_docs)] // documentation missing in model
    Hmac512,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa3072,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    #[allow(missing_docs)] // documentation missing in model
    SymmetricDefault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeySpec {
    fn from(s: &str) -> Self {
        match s {
            "ECC_NIST_P256" => KeySpec::EccNistP256,
            "ECC_NIST_P384" => KeySpec::EccNistP384,
            "ECC_NIST_P521" => KeySpec::EccNistP521,
            "ECC_SECG_P256K1" => KeySpec::EccSecgP256K1,
            "HMAC_224" => KeySpec::Hmac224,
            "HMAC_256" => KeySpec::Hmac256,
            "HMAC_384" => KeySpec::Hmac384,
            "HMAC_512" => KeySpec::Hmac512,
            "RSA_2048" => KeySpec::Rsa2048,
            "RSA_3072" => KeySpec::Rsa3072,
            "RSA_4096" => KeySpec::Rsa4096,
            "SYMMETRIC_DEFAULT" => KeySpec::SymmetricDefault,
            other => KeySpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeySpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeySpec::from(s))
    }
}
impl KeySpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeySpec::EccNistP256 => "ECC_NIST_P256",
            KeySpec::EccNistP384 => "ECC_NIST_P384",
            KeySpec::EccNistP521 => "ECC_NIST_P521",
            KeySpec::EccSecgP256K1 => "ECC_SECG_P256K1",
            KeySpec::Hmac224 => "HMAC_224",
            KeySpec::Hmac256 => "HMAC_256",
            KeySpec::Hmac384 => "HMAC_384",
            KeySpec::Hmac512 => "HMAC_512",
            KeySpec::Rsa2048 => "RSA_2048",
            KeySpec::Rsa3072 => "RSA_3072",
            KeySpec::Rsa4096 => "RSA_4096",
            KeySpec::SymmetricDefault => "SYMMETRIC_DEFAULT",
            KeySpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ECC_NIST_P256",
            "ECC_NIST_P384",
            "ECC_NIST_P521",
            "ECC_SECG_P256K1",
            "HMAC_224",
            "HMAC_256",
            "HMAC_384",
            "HMAC_512",
            "RSA_2048",
            "RSA_3072",
            "RSA_4096",
            "SYMMETRIC_DEFAULT",
        ]
    }
}
impl AsRef<str> for KeySpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomerMasterKeySpec {
    #[allow(missing_docs)] // documentation missing in model
    EccNistP256,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP384,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP521,
    #[allow(missing_docs)] // documentation missing in model
    EccSecgP256K1,
    #[allow(missing_docs)] // documentation missing in model
    Hmac224,
    #[allow(missing_docs)] // documentation missing in model
    Hmac256,
    #[allow(missing_docs)] // documentation missing in model
    Hmac384,
    #[allow(missing_docs)] // documentation missing in model
    Hmac512,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa3072,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    #[allow(missing_docs)] // documentation missing in model
    SymmetricDefault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomerMasterKeySpec {
    fn from(s: &str) -> Self {
        match s {
            "ECC_NIST_P256" => CustomerMasterKeySpec::EccNistP256,
            "ECC_NIST_P384" => CustomerMasterKeySpec::EccNistP384,
            "ECC_NIST_P521" => CustomerMasterKeySpec::EccNistP521,
            "ECC_SECG_P256K1" => CustomerMasterKeySpec::EccSecgP256K1,
            "HMAC_224" => CustomerMasterKeySpec::Hmac224,
            "HMAC_256" => CustomerMasterKeySpec::Hmac256,
            "HMAC_384" => CustomerMasterKeySpec::Hmac384,
            "HMAC_512" => CustomerMasterKeySpec::Hmac512,
            "RSA_2048" => CustomerMasterKeySpec::Rsa2048,
            "RSA_3072" => CustomerMasterKeySpec::Rsa3072,
            "RSA_4096" => CustomerMasterKeySpec::Rsa4096,
            "SYMMETRIC_DEFAULT" => CustomerMasterKeySpec::SymmetricDefault,
            other => CustomerMasterKeySpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomerMasterKeySpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomerMasterKeySpec::from(s))
    }
}
impl CustomerMasterKeySpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomerMasterKeySpec::EccNistP256 => "ECC_NIST_P256",
            CustomerMasterKeySpec::EccNistP384 => "ECC_NIST_P384",
            CustomerMasterKeySpec::EccNistP521 => "ECC_NIST_P521",
            CustomerMasterKeySpec::EccSecgP256K1 => "ECC_SECG_P256K1",
            CustomerMasterKeySpec::Hmac224 => "HMAC_224",
            CustomerMasterKeySpec::Hmac256 => "HMAC_256",
            CustomerMasterKeySpec::Hmac384 => "HMAC_384",
            CustomerMasterKeySpec::Hmac512 => "HMAC_512",
            CustomerMasterKeySpec::Rsa2048 => "RSA_2048",
            CustomerMasterKeySpec::Rsa3072 => "RSA_3072",
            CustomerMasterKeySpec::Rsa4096 => "RSA_4096",
            CustomerMasterKeySpec::SymmetricDefault => "SYMMETRIC_DEFAULT",
            CustomerMasterKeySpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ECC_NIST_P256",
            "ECC_NIST_P384",
            "ECC_NIST_P521",
            "ECC_SECG_P256K1",
            "HMAC_224",
            "HMAC_256",
            "HMAC_384",
            "HMAC_512",
            "RSA_2048",
            "RSA_3072",
            "RSA_4096",
            "SYMMETRIC_DEFAULT",
        ]
    }
}
impl AsRef<str> for CustomerMasterKeySpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyManagerType {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    Customer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyManagerType {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => KeyManagerType::Aws,
            "CUSTOMER" => KeyManagerType::Customer,
            other => KeyManagerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyManagerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyManagerType::from(s))
    }
}
impl KeyManagerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyManagerType::Aws => "AWS",
            KeyManagerType::Customer => "CUSTOMER",
            KeyManagerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "CUSTOMER"]
    }
}
impl AsRef<str> for KeyManagerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpirationModelType {
    #[allow(missing_docs)] // documentation missing in model
    KeyMaterialDoesNotExpire,
    #[allow(missing_docs)] // documentation missing in model
    KeyMaterialExpires,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpirationModelType {
    fn from(s: &str) -> Self {
        match s {
            "KEY_MATERIAL_DOES_NOT_EXPIRE" => ExpirationModelType::KeyMaterialDoesNotExpire,
            "KEY_MATERIAL_EXPIRES" => ExpirationModelType::KeyMaterialExpires,
            other => ExpirationModelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpirationModelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpirationModelType::from(s))
    }
}
impl ExpirationModelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpirationModelType::KeyMaterialDoesNotExpire => "KEY_MATERIAL_DOES_NOT_EXPIRE",
            ExpirationModelType::KeyMaterialExpires => "KEY_MATERIAL_EXPIRES",
            ExpirationModelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEY_MATERIAL_DOES_NOT_EXPIRE", "KEY_MATERIAL_EXPIRES"]
    }
}
impl AsRef<str> for ExpirationModelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginType {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudhsm,
    #[allow(missing_docs)] // documentation missing in model
    AwsKms,
    #[allow(missing_docs)] // documentation missing in model
    External,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CLOUDHSM" => OriginType::AwsCloudhsm,
            "AWS_KMS" => OriginType::AwsKms,
            "EXTERNAL" => OriginType::External,
            other => OriginType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginType::from(s))
    }
}
impl OriginType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginType::AwsCloudhsm => "AWS_CLOUDHSM",
            OriginType::AwsKms => "AWS_KMS",
            OriginType::External => "EXTERNAL",
            OriginType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_CLOUDHSM", "AWS_KMS", "EXTERNAL"]
    }
}
impl AsRef<str> for OriginType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyUsageType {
    #[allow(missing_docs)] // documentation missing in model
    EncryptDecrypt,
    #[allow(missing_docs)] // documentation missing in model
    GenerateVerifyMac,
    #[allow(missing_docs)] // documentation missing in model
    SignVerify,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyUsageType {
    fn from(s: &str) -> Self {
        match s {
            "ENCRYPT_DECRYPT" => KeyUsageType::EncryptDecrypt,
            "GENERATE_VERIFY_MAC" => KeyUsageType::GenerateVerifyMac,
            "SIGN_VERIFY" => KeyUsageType::SignVerify,
            other => KeyUsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyUsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyUsageType::from(s))
    }
}
impl KeyUsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyUsageType::EncryptDecrypt => "ENCRYPT_DECRYPT",
            KeyUsageType::GenerateVerifyMac => "GENERATE_VERIFY_MAC",
            KeyUsageType::SignVerify => "SIGN_VERIFY",
            KeyUsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENCRYPT_DECRYPT", "GENERATE_VERIFY_MAC", "SIGN_VERIFY"]
    }
}
impl AsRef<str> for KeyUsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a grant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantListEntry {
    /// <p>The unique identifier for the KMS key to which the grant applies.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the grant.</p>
    pub grant_id: std::option::Option<std::string::String>,
    /// <p>The friendly name that identifies the grant. If a name was provided in the <code>CreateGrant</code> request, that name is returned. Otherwise this value is null.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date and time when the grant was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identity that gets the permissions in the grant.</p>
    /// <p>The <code>GranteePrincipal</code> field in the <code>ListGrants</code> response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the <code>GranteePrincipal</code> field contains the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services">service principal</a>, which might represent several different grantee principals.</p>
    pub grantee_principal: std::option::Option<std::string::String>,
    /// <p>The principal that can retire the grant.</p>
    pub retiring_principal: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account under which the grant was issued.</p>
    pub issuing_account: std::option::Option<std::string::String>,
    /// <p>The list of operations permitted by the grant.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::GrantOperation>>,
    /// <p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.</p>
    pub constraints: std::option::Option<crate::model::GrantConstraints>,
}
impl GrantListEntry {
    /// <p>The unique identifier for the KMS key to which the grant applies.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The unique identifier for the grant.</p>
    pub fn grant_id(&self) -> std::option::Option<&str> {
        self.grant_id.as_deref()
    }
    /// <p>The friendly name that identifies the grant. If a name was provided in the <code>CreateGrant</code> request, that name is returned. Otherwise this value is null.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date and time when the grant was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The identity that gets the permissions in the grant.</p>
    /// <p>The <code>GranteePrincipal</code> field in the <code>ListGrants</code> response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the <code>GranteePrincipal</code> field contains the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services">service principal</a>, which might represent several different grantee principals.</p>
    pub fn grantee_principal(&self) -> std::option::Option<&str> {
        self.grantee_principal.as_deref()
    }
    /// <p>The principal that can retire the grant.</p>
    pub fn retiring_principal(&self) -> std::option::Option<&str> {
        self.retiring_principal.as_deref()
    }
    /// <p>The Amazon Web Services account under which the grant was issued.</p>
    pub fn issuing_account(&self) -> std::option::Option<&str> {
        self.issuing_account.as_deref()
    }
    /// <p>The list of operations permitted by the grant.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::GrantOperation]> {
        self.operations.as_deref()
    }
    /// <p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.</p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::GrantConstraints> {
        self.constraints.as_ref()
    }
}
impl std::fmt::Debug for GrantListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantListEntry");
        formatter.field("key_id", &self.key_id);
        formatter.field("grant_id", &self.grant_id);
        formatter.field("name", &self.name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("grantee_principal", &self.grantee_principal);
        formatter.field("retiring_principal", &self.retiring_principal);
        formatter.field("issuing_account", &self.issuing_account);
        formatter.field("operations", &self.operations);
        formatter.field("constraints", &self.constraints);
        formatter.finish()
    }
}
/// See [`GrantListEntry`](crate::model::GrantListEntry)
pub mod grant_list_entry {
    /// A builder for [`GrantListEntry`](crate::model::GrantListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) grant_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grantee_principal: std::option::Option<std::string::String>,
        pub(crate) retiring_principal: std::option::Option<std::string::String>,
        pub(crate) issuing_account: std::option::Option<std::string::String>,
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::GrantOperation>>,
        pub(crate) constraints: std::option::Option<crate::model::GrantConstraints>,
    }
    impl Builder {
        /// <p>The unique identifier for the KMS key to which the grant applies.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the KMS key to which the grant applies.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The unique identifier for the grant.</p>
        pub fn grant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the grant.</p>
        pub fn set_grant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_id = input;
            self
        }
        /// <p>The friendly name that identifies the grant. If a name was provided in the <code>CreateGrant</code> request, that name is returned. Otherwise this value is null.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name that identifies the grant. If a name was provided in the <code>CreateGrant</code> request, that name is returned. Otherwise this value is null.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date and time when the grant was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the grant was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The identity that gets the permissions in the grant.</p>
        /// <p>The <code>GranteePrincipal</code> field in the <code>ListGrants</code> response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the <code>GranteePrincipal</code> field contains the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services">service principal</a>, which might represent several different grantee principals.</p>
        pub fn grantee_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_principal = Some(input.into());
            self
        }
        /// <p>The identity that gets the permissions in the grant.</p>
        /// <p>The <code>GranteePrincipal</code> field in the <code>ListGrants</code> response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the <code>GranteePrincipal</code> field contains the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services">service principal</a>, which might represent several different grantee principals.</p>
        pub fn set_grantee_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grantee_principal = input;
            self
        }
        /// <p>The principal that can retire the grant.</p>
        pub fn retiring_principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.retiring_principal = Some(input.into());
            self
        }
        /// <p>The principal that can retire the grant.</p>
        pub fn set_retiring_principal(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retiring_principal = input;
            self
        }
        /// <p>The Amazon Web Services account under which the grant was issued.</p>
        pub fn issuing_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuing_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account under which the grant was issued.</p>
        pub fn set_issuing_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.issuing_account = input;
            self
        }
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>The list of operations permitted by the grant.</p>
        pub fn operations(mut self, input: crate::model::GrantOperation) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input);
            self.operations = Some(v);
            self
        }
        /// <p>The list of operations permitted by the grant.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantOperation>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// <p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.</p>
        pub fn constraints(mut self, input: crate::model::GrantConstraints) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::GrantConstraints>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantListEntry`](crate::model::GrantListEntry)
        pub fn build(self) -> crate::model::GrantListEntry {
            crate::model::GrantListEntry {
                key_id: self.key_id,
                grant_id: self.grant_id,
                name: self.name,
                creation_date: self.creation_date,
                grantee_principal: self.grantee_principal,
                retiring_principal: self.retiring_principal,
                issuing_account: self.issuing_account,
                operations: self.operations,
                constraints: self.constraints,
            }
        }
    }
}
impl GrantListEntry {
    /// Creates a new builder-style object to manufacture [`GrantListEntry`](crate::model::GrantListEntry)
    pub fn builder() -> crate::model::grant_list_entry::Builder {
        crate::model::grant_list_entry::Builder::default()
    }
}

/// <p>Use this structure to allow <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> in the grant only when the operation request includes the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a>. </p>
/// <p>KMS applies the grant constraints only to cryptographic operations that support an encryption context, that is, all cryptographic operations with a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#symmetric-cmks">symmetric encryption KMS key</a>. Grant constraints are not applied to operations that do not support an encryption context, such as cryptographic operations with HMAC KMS keys or asymmetric KMS keys, and management operations, such as <code>DescribeKey</code> or <code>RetireGrant</code>.</p> <important>
/// <p>In a cryptographic operation, the encryption context in the decryption operation must be an exact, case-sensitive match for the keys and values in the encryption context of the encryption operation. Only the order of the pairs can vary.</p>
/// <p>However, in a grant constraint, the key in each key-value pair is not case sensitive, but the value is case sensitive.</p>
/// <p>To avoid confusion, do not use multiple encryption context pairs that differ only by case. To require a fully case-sensitive encryption context, use the <code>kms:EncryptionContext:</code> and <code>kms:EncryptionContextKeys</code> conditions in an IAM or key policy. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-context">kms:EncryptionContext:</a> in the <i> <i>Key Management Service Developer Guide</i> </i>.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantConstraints {
    /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>
    pub encryption_context_subset:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>
    pub encryption_context_equals:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GrantConstraints {
    /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>
    pub fn encryption_context_subset(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.encryption_context_subset.as_ref()
    }
    /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>
    pub fn encryption_context_equals(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.encryption_context_equals.as_ref()
    }
}
impl std::fmt::Debug for GrantConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantConstraints");
        formatter.field("encryption_context_subset", &self.encryption_context_subset);
        formatter.field("encryption_context_equals", &self.encryption_context_equals);
        formatter.finish()
    }
}
/// See [`GrantConstraints`](crate::model::GrantConstraints)
pub mod grant_constraints {
    /// A builder for [`GrantConstraints`](crate::model::GrantConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_context_subset: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) encryption_context_equals: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `encryption_context_subset`.
        ///
        /// To override the contents of this collection use [`set_encryption_context_subset`](Self::set_encryption_context_subset).
        ///
        /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>
        pub fn encryption_context_subset(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.encryption_context_subset.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.encryption_context_subset = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>
        pub fn set_encryption_context_subset(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.encryption_context_subset = input;
            self
        }
        /// Adds a key-value pair to `encryption_context_equals`.
        ///
        /// To override the contents of this collection use [`set_encryption_context_equals`](Self::set_encryption_context_equals).
        ///
        /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>
        pub fn encryption_context_equals(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.encryption_context_equals.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.encryption_context_equals = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>
        pub fn set_encryption_context_equals(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.encryption_context_equals = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantConstraints`](crate::model::GrantConstraints)
        pub fn build(self) -> crate::model::GrantConstraints {
            crate::model::GrantConstraints {
                encryption_context_subset: self.encryption_context_subset,
                encryption_context_equals: self.encryption_context_equals,
            }
        }
    }
}
impl GrantConstraints {
    /// Creates a new builder-style object to manufacture [`GrantConstraints`](crate::model::GrantConstraints)
    pub fn builder() -> crate::model::grant_constraints::Builder {
        crate::model::grant_constraints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GrantOperation {
    #[allow(missing_docs)] // documentation missing in model
    CreateGrant,
    #[allow(missing_docs)] // documentation missing in model
    Decrypt,
    #[allow(missing_docs)] // documentation missing in model
    DescribeKey,
    #[allow(missing_docs)] // documentation missing in model
    Encrypt,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKey,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyPair,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyPairWithoutPlaintext,
    #[allow(missing_docs)] // documentation missing in model
    GenerateDataKeyWithoutPlaintext,
    #[allow(missing_docs)] // documentation missing in model
    GenerateMac,
    #[allow(missing_docs)] // documentation missing in model
    GetPublicKey,
    #[allow(missing_docs)] // documentation missing in model
    ReEncryptFrom,
    #[allow(missing_docs)] // documentation missing in model
    ReEncryptTo,
    #[allow(missing_docs)] // documentation missing in model
    RetireGrant,
    #[allow(missing_docs)] // documentation missing in model
    Sign,
    #[allow(missing_docs)] // documentation missing in model
    Verify,
    #[allow(missing_docs)] // documentation missing in model
    VerifyMac,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GrantOperation {
    fn from(s: &str) -> Self {
        match s {
            "CreateGrant" => GrantOperation::CreateGrant,
            "Decrypt" => GrantOperation::Decrypt,
            "DescribeKey" => GrantOperation::DescribeKey,
            "Encrypt" => GrantOperation::Encrypt,
            "GenerateDataKey" => GrantOperation::GenerateDataKey,
            "GenerateDataKeyPair" => GrantOperation::GenerateDataKeyPair,
            "GenerateDataKeyPairWithoutPlaintext" => {
                GrantOperation::GenerateDataKeyPairWithoutPlaintext
            }
            "GenerateDataKeyWithoutPlaintext" => GrantOperation::GenerateDataKeyWithoutPlaintext,
            "GenerateMac" => GrantOperation::GenerateMac,
            "GetPublicKey" => GrantOperation::GetPublicKey,
            "ReEncryptFrom" => GrantOperation::ReEncryptFrom,
            "ReEncryptTo" => GrantOperation::ReEncryptTo,
            "RetireGrant" => GrantOperation::RetireGrant,
            "Sign" => GrantOperation::Sign,
            "Verify" => GrantOperation::Verify,
            "VerifyMac" => GrantOperation::VerifyMac,
            other => GrantOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GrantOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GrantOperation::from(s))
    }
}
impl GrantOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GrantOperation::CreateGrant => "CreateGrant",
            GrantOperation::Decrypt => "Decrypt",
            GrantOperation::DescribeKey => "DescribeKey",
            GrantOperation::Encrypt => "Encrypt",
            GrantOperation::GenerateDataKey => "GenerateDataKey",
            GrantOperation::GenerateDataKeyPair => "GenerateDataKeyPair",
            GrantOperation::GenerateDataKeyPairWithoutPlaintext => {
                "GenerateDataKeyPairWithoutPlaintext"
            }
            GrantOperation::GenerateDataKeyWithoutPlaintext => "GenerateDataKeyWithoutPlaintext",
            GrantOperation::GenerateMac => "GenerateMac",
            GrantOperation::GetPublicKey => "GetPublicKey",
            GrantOperation::ReEncryptFrom => "ReEncryptFrom",
            GrantOperation::ReEncryptTo => "ReEncryptTo",
            GrantOperation::RetireGrant => "RetireGrant",
            GrantOperation::Sign => "Sign",
            GrantOperation::Verify => "Verify",
            GrantOperation::VerifyMac => "VerifyMac",
            GrantOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreateGrant",
            "Decrypt",
            "DescribeKey",
            "Encrypt",
            "GenerateDataKey",
            "GenerateDataKeyPair",
            "GenerateDataKeyPairWithoutPlaintext",
            "GenerateDataKeyWithoutPlaintext",
            "GenerateMac",
            "GetPublicKey",
            "ReEncryptFrom",
            "ReEncryptTo",
            "RetireGrant",
            "Sign",
            "Verify",
            "VerifyMac",
        ]
    }
}
impl AsRef<str> for GrantOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about each entry in the key list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyListEntry {
    /// <p>Unique identifier of the key.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>ARN of the key.</p>
    pub key_arn: std::option::Option<std::string::String>,
}
impl KeyListEntry {
    /// <p>Unique identifier of the key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>ARN of the key.</p>
    pub fn key_arn(&self) -> std::option::Option<&str> {
        self.key_arn.as_deref()
    }
}
impl std::fmt::Debug for KeyListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyListEntry");
        formatter.field("key_id", &self.key_id);
        formatter.field("key_arn", &self.key_arn);
        formatter.finish()
    }
}
/// See [`KeyListEntry`](crate::model::KeyListEntry)
pub mod key_list_entry {
    /// A builder for [`KeyListEntry`](crate::model::KeyListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifier of the key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>ARN of the key.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>ARN of the key.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyListEntry`](crate::model::KeyListEntry)
        pub fn build(self) -> crate::model::KeyListEntry {
            crate::model::KeyListEntry {
                key_id: self.key_id,
                key_arn: self.key_arn,
            }
        }
    }
}
impl KeyListEntry {
    /// Creates a new builder-style object to manufacture [`KeyListEntry`](crate::model::KeyListEntry)
    pub fn builder() -> crate::model::key_list_entry::Builder {
        crate::model::key_list_entry::Builder::default()
    }
}

/// <p>Contains information about an alias.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AliasListEntry {
    /// <p>String that contains the alias. This value begins with <code>alias/</code>.</p>
    pub alias_name: std::option::Option<std::string::String>,
    /// <p>String that contains the key ARN.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>String that contains the key identifier of the KMS key associated with the alias.</p>
    pub target_key_id: std::option::Option<std::string::String>,
    /// <p>Date and time that the alias was most recently created in the account and Region. Formatted as Unix time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date and time that the alias was most recently associated with a KMS key in the account and Region. Formatted as Unix time.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl AliasListEntry {
    /// <p>String that contains the alias. This value begins with <code>alias/</code>.</p>
    pub fn alias_name(&self) -> std::option::Option<&str> {
        self.alias_name.as_deref()
    }
    /// <p>String that contains the key ARN.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>String that contains the key identifier of the KMS key associated with the alias.</p>
    pub fn target_key_id(&self) -> std::option::Option<&str> {
        self.target_key_id.as_deref()
    }
    /// <p>Date and time that the alias was most recently created in the account and Region. Formatted as Unix time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Date and time that the alias was most recently associated with a KMS key in the account and Region. Formatted as Unix time.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
}
impl std::fmt::Debug for AliasListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AliasListEntry");
        formatter.field("alias_name", &self.alias_name);
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("target_key_id", &self.target_key_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.finish()
    }
}
/// See [`AliasListEntry`](crate::model::AliasListEntry)
pub mod alias_list_entry {
    /// A builder for [`AliasListEntry`](crate::model::AliasListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) target_key_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>String that contains the alias. This value begins with <code>alias/</code>.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>String that contains the alias. This value begins with <code>alias/</code>.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>String that contains the key ARN.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>String that contains the key ARN.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>String that contains the key identifier of the KMS key associated with the alias.</p>
        pub fn target_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_key_id = Some(input.into());
            self
        }
        /// <p>String that contains the key identifier of the KMS key associated with the alias.</p>
        pub fn set_target_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_key_id = input;
            self
        }
        /// <p>Date and time that the alias was most recently created in the account and Region. Formatted as Unix time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Date and time that the alias was most recently created in the account and Region. Formatted as Unix time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Date and time that the alias was most recently associated with a KMS key in the account and Region. Formatted as Unix time.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>Date and time that the alias was most recently associated with a KMS key in the account and Region. Formatted as Unix time.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AliasListEntry`](crate::model::AliasListEntry)
        pub fn build(self) -> crate::model::AliasListEntry {
            crate::model::AliasListEntry {
                alias_name: self.alias_name,
                alias_arn: self.alias_arn,
                target_key_id: self.target_key_id,
                creation_date: self.creation_date,
                last_updated_date: self.last_updated_date,
            }
        }
    }
}
impl AliasListEntry {
    /// Creates a new builder-style object to manufacture [`AliasListEntry`](crate::model::AliasListEntry)
    pub fn builder() -> crate::model::alias_list_entry::Builder {
        crate::model::alias_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WrappingKeySpec {
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WrappingKeySpec {
    fn from(s: &str) -> Self {
        match s {
            "RSA_2048" => WrappingKeySpec::Rsa2048,
            other => WrappingKeySpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WrappingKeySpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WrappingKeySpec::from(s))
    }
}
impl WrappingKeySpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WrappingKeySpec::Rsa2048 => "RSA_2048",
            WrappingKeySpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RSA_2048"]
    }
}
impl AsRef<str> for WrappingKeySpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlgorithmSpec {
    #[allow(missing_docs)] // documentation missing in model
    RsaesOaepSha1,
    #[allow(missing_docs)] // documentation missing in model
    RsaesOaepSha256,
    #[allow(missing_docs)] // documentation missing in model
    RsaesPkcs1V15,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlgorithmSpec {
    fn from(s: &str) -> Self {
        match s {
            "RSAES_OAEP_SHA_1" => AlgorithmSpec::RsaesOaepSha1,
            "RSAES_OAEP_SHA_256" => AlgorithmSpec::RsaesOaepSha256,
            "RSAES_PKCS1_V1_5" => AlgorithmSpec::RsaesPkcs1V15,
            other => AlgorithmSpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlgorithmSpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlgorithmSpec::from(s))
    }
}
impl AlgorithmSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlgorithmSpec::RsaesOaepSha1 => "RSAES_OAEP_SHA_1",
            AlgorithmSpec::RsaesOaepSha256 => "RSAES_OAEP_SHA_256",
            AlgorithmSpec::RsaesPkcs1V15 => "RSAES_PKCS1_V1_5",
            AlgorithmSpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256", "RSAES_PKCS1_V1_5"]
    }
}
impl AsRef<str> for AlgorithmSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataKeySpec {
    #[allow(missing_docs)] // documentation missing in model
    Aes128,
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataKeySpec {
    fn from(s: &str) -> Self {
        match s {
            "AES_128" => DataKeySpec::Aes128,
            "AES_256" => DataKeySpec::Aes256,
            other => DataKeySpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataKeySpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataKeySpec::from(s))
    }
}
impl DataKeySpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataKeySpec::Aes128 => "AES_128",
            DataKeySpec::Aes256 => "AES_256",
            DataKeySpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES_128", "AES_256"]
    }
}
impl AsRef<str> for DataKeySpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataKeyPairSpec {
    #[allow(missing_docs)] // documentation missing in model
    EccNistP256,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP384,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP521,
    #[allow(missing_docs)] // documentation missing in model
    EccSecgP256K1,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa3072,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataKeyPairSpec {
    fn from(s: &str) -> Self {
        match s {
            "ECC_NIST_P256" => DataKeyPairSpec::EccNistP256,
            "ECC_NIST_P384" => DataKeyPairSpec::EccNistP384,
            "ECC_NIST_P521" => DataKeyPairSpec::EccNistP521,
            "ECC_SECG_P256K1" => DataKeyPairSpec::EccSecgP256K1,
            "RSA_2048" => DataKeyPairSpec::Rsa2048,
            "RSA_3072" => DataKeyPairSpec::Rsa3072,
            "RSA_4096" => DataKeyPairSpec::Rsa4096,
            other => DataKeyPairSpec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataKeyPairSpec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataKeyPairSpec::from(s))
    }
}
impl DataKeyPairSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataKeyPairSpec::EccNistP256 => "ECC_NIST_P256",
            DataKeyPairSpec::EccNistP384 => "ECC_NIST_P384",
            DataKeyPairSpec::EccNistP521 => "ECC_NIST_P521",
            DataKeyPairSpec::EccSecgP256K1 => "ECC_SECG_P256K1",
            DataKeyPairSpec::Rsa2048 => "RSA_2048",
            DataKeyPairSpec::Rsa3072 => "RSA_3072",
            DataKeyPairSpec::Rsa4096 => "RSA_4096",
            DataKeyPairSpec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ECC_NIST_P256",
            "ECC_NIST_P384",
            "ECC_NIST_P521",
            "ECC_SECG_P256K1",
            "RSA_2048",
            "RSA_3072",
            "RSA_4096",
        ]
    }
}
impl AsRef<str> for DataKeyPairSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about each custom key store in the custom key store list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomKeyStoresListEntry {
    /// <p>A unique identifier for the custom key store.</p>
    pub custom_key_store_id: std::option::Option<std::string::String>,
    /// <p>The user-specified friendly name for the custom key store.</p>
    pub custom_key_store_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the CloudHSM cluster that is associated with the custom key store.</p>
    pub cloud_hsm_cluster_id: std::option::Option<std::string::String>,
    /// <p>The trust anchor certificate of the associated CloudHSM cluster. When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create this certificate and save it in the <code>customerCA.crt</code> file.</p>
    pub trust_anchor_certificate: std::option::Option<std::string::String>,
    /// <p>Indicates whether the custom key store is connected to its CloudHSM cluster.</p>
    /// <p>You can create and use KMS keys in your custom key stores only when its connection state is <code>CONNECTED</code>.</p>
    /// <p>The value is <code>DISCONNECTED</code> if the key store has never been connected or you use the <code>DisconnectCustomKeyStore</code> operation to disconnect it. If the value is <code>CONNECTED</code> but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.</p>
    /// <p>A value of <code>FAILED</code> indicates that an attempt to connect was unsuccessful. The <code>ConnectionErrorCode</code> field in the response indicates the cause of the failure. For help resolving a connection failure, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionStateType>,
    /// <p>Describes the connection error. This field appears in the response only when the <code>ConnectionState</code> is <code>FAILED</code>. For help resolving these errors, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>CLUSTER_NOT_FOUND</code> - KMS cannot find the CloudHSM cluster with the specified cluster ID.</p> </li>
    /// <li> <p> <code>INSUFFICIENT_CLOUDHSM_HSMS</code> - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.</p> </li>
    /// <li> <p> <code>INTERNAL_ERROR</code> - KMS could not complete the request due to an internal error. Retry the request. For <code>ConnectCustomKeyStore</code> requests, disconnect the custom key store before trying to connect again.</p> </li>
    /// <li> <p> <code>INVALID_CREDENTIALS</code> - KMS does not have the correct password for the <code>kmsuser</code> crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
    /// <li> <p> <code>NETWORK_ERRORS</code> - Network errors are preventing KMS from connecting to the custom key store.</p> </li>
    /// <li> <p> <code>SUBNET_NOT_FOUND</code> - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
    /// <li> <p> <code>USER_LOCKED_OUT</code> - The <code>kmsuser</code> CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
    /// <li> <p> <code>USER_LOGGED_IN</code> - The <code>kmsuser</code> CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the <code>kmsuser</code> account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the <code>kmsuser</code> CU out of the cluster. If you changed the <code>kmsuser</code> password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2">How to Log Out and Reconnect</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
    /// <li> <p> <code>USER_NOT_FOUND</code> - KMS cannot find a <code>kmsuser</code> CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a <code>kmsuser</code> CU account in the cluster, and then update the key store password value for the custom key store.</p> </li>
    /// </ul>
    pub connection_error_code: std::option::Option<crate::model::ConnectionErrorCodeType>,
    /// <p>The date and time when the custom key store was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl CustomKeyStoresListEntry {
    /// <p>A unique identifier for the custom key store.</p>
    pub fn custom_key_store_id(&self) -> std::option::Option<&str> {
        self.custom_key_store_id.as_deref()
    }
    /// <p>The user-specified friendly name for the custom key store.</p>
    pub fn custom_key_store_name(&self) -> std::option::Option<&str> {
        self.custom_key_store_name.as_deref()
    }
    /// <p>A unique identifier for the CloudHSM cluster that is associated with the custom key store.</p>
    pub fn cloud_hsm_cluster_id(&self) -> std::option::Option<&str> {
        self.cloud_hsm_cluster_id.as_deref()
    }
    /// <p>The trust anchor certificate of the associated CloudHSM cluster. When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create this certificate and save it in the <code>customerCA.crt</code> file.</p>
    pub fn trust_anchor_certificate(&self) -> std::option::Option<&str> {
        self.trust_anchor_certificate.as_deref()
    }
    /// <p>Indicates whether the custom key store is connected to its CloudHSM cluster.</p>
    /// <p>You can create and use KMS keys in your custom key stores only when its connection state is <code>CONNECTED</code>.</p>
    /// <p>The value is <code>DISCONNECTED</code> if the key store has never been connected or you use the <code>DisconnectCustomKeyStore</code> operation to disconnect it. If the value is <code>CONNECTED</code> but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.</p>
    /// <p>A value of <code>FAILED</code> indicates that an attempt to connect was unsuccessful. The <code>ConnectionErrorCode</code> field in the response indicates the cause of the failure. For help resolving a connection failure, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::ConnectionStateType> {
        self.connection_state.as_ref()
    }
    /// <p>Describes the connection error. This field appears in the response only when the <code>ConnectionState</code> is <code>FAILED</code>. For help resolving these errors, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>CLUSTER_NOT_FOUND</code> - KMS cannot find the CloudHSM cluster with the specified cluster ID.</p> </li>
    /// <li> <p> <code>INSUFFICIENT_CLOUDHSM_HSMS</code> - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.</p> </li>
    /// <li> <p> <code>INTERNAL_ERROR</code> - KMS could not complete the request due to an internal error. Retry the request. For <code>ConnectCustomKeyStore</code> requests, disconnect the custom key store before trying to connect again.</p> </li>
    /// <li> <p> <code>INVALID_CREDENTIALS</code> - KMS does not have the correct password for the <code>kmsuser</code> crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
    /// <li> <p> <code>NETWORK_ERRORS</code> - Network errors are preventing KMS from connecting to the custom key store.</p> </li>
    /// <li> <p> <code>SUBNET_NOT_FOUND</code> - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
    /// <li> <p> <code>USER_LOCKED_OUT</code> - The <code>kmsuser</code> CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
    /// <li> <p> <code>USER_LOGGED_IN</code> - The <code>kmsuser</code> CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the <code>kmsuser</code> account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the <code>kmsuser</code> CU out of the cluster. If you changed the <code>kmsuser</code> password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2">How to Log Out and Reconnect</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
    /// <li> <p> <code>USER_NOT_FOUND</code> - KMS cannot find a <code>kmsuser</code> CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a <code>kmsuser</code> CU account in the cluster, and then update the key store password value for the custom key store.</p> </li>
    /// </ul>
    pub fn connection_error_code(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionErrorCodeType> {
        self.connection_error_code.as_ref()
    }
    /// <p>The date and time when the custom key store was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CustomKeyStoresListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomKeyStoresListEntry");
        formatter.field("custom_key_store_id", &self.custom_key_store_id);
        formatter.field("custom_key_store_name", &self.custom_key_store_name);
        formatter.field("cloud_hsm_cluster_id", &self.cloud_hsm_cluster_id);
        formatter.field("trust_anchor_certificate", &self.trust_anchor_certificate);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("connection_error_code", &self.connection_error_code);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CustomKeyStoresListEntry`](crate::model::CustomKeyStoresListEntry)
pub mod custom_key_stores_list_entry {
    /// A builder for [`CustomKeyStoresListEntry`](crate::model::CustomKeyStoresListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_key_store_id: std::option::Option<std::string::String>,
        pub(crate) custom_key_store_name: std::option::Option<std::string::String>,
        pub(crate) cloud_hsm_cluster_id: std::option::Option<std::string::String>,
        pub(crate) trust_anchor_certificate: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionStateType>,
        pub(crate) connection_error_code:
            std::option::Option<crate::model::ConnectionErrorCodeType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the custom key store.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_key_store_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the custom key store.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_key_store_id = input;
            self
        }
        /// <p>The user-specified friendly name for the custom key store.</p>
        pub fn custom_key_store_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_key_store_name = Some(input.into());
            self
        }
        /// <p>The user-specified friendly name for the custom key store.</p>
        pub fn set_custom_key_store_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_key_store_name = input;
            self
        }
        /// <p>A unique identifier for the CloudHSM cluster that is associated with the custom key store.</p>
        pub fn cloud_hsm_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_hsm_cluster_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the CloudHSM cluster that is associated with the custom key store.</p>
        pub fn set_cloud_hsm_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_hsm_cluster_id = input;
            self
        }
        /// <p>The trust anchor certificate of the associated CloudHSM cluster. When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create this certificate and save it in the <code>customerCA.crt</code> file.</p>
        pub fn trust_anchor_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.trust_anchor_certificate = Some(input.into());
            self
        }
        /// <p>The trust anchor certificate of the associated CloudHSM cluster. When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create this certificate and save it in the <code>customerCA.crt</code> file.</p>
        pub fn set_trust_anchor_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trust_anchor_certificate = input;
            self
        }
        /// <p>Indicates whether the custom key store is connected to its CloudHSM cluster.</p>
        /// <p>You can create and use KMS keys in your custom key stores only when its connection state is <code>CONNECTED</code>.</p>
        /// <p>The value is <code>DISCONNECTED</code> if the key store has never been connected or you use the <code>DisconnectCustomKeyStore</code> operation to disconnect it. If the value is <code>CONNECTED</code> but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.</p>
        /// <p>A value of <code>FAILED</code> indicates that an attempt to connect was unsuccessful. The <code>ConnectionErrorCode</code> field in the response indicates the cause of the failure. For help resolving a connection failure, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionStateType) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>Indicates whether the custom key store is connected to its CloudHSM cluster.</p>
        /// <p>You can create and use KMS keys in your custom key stores only when its connection state is <code>CONNECTED</code>.</p>
        /// <p>The value is <code>DISCONNECTED</code> if the key store has never been connected or you use the <code>DisconnectCustomKeyStore</code> operation to disconnect it. If the value is <code>CONNECTED</code> but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.</p>
        /// <p>A value of <code>FAILED</code> indicates that an attempt to connect was unsuccessful. The <code>ConnectionErrorCode</code> field in the response indicates the cause of the failure. For help resolving a connection failure, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html">Troubleshooting a Custom Key Store</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionStateType>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>Describes the connection error. This field appears in the response only when the <code>ConnectionState</code> is <code>FAILED</code>. For help resolving these errors, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>CLUSTER_NOT_FOUND</code> - KMS cannot find the CloudHSM cluster with the specified cluster ID.</p> </li>
        /// <li> <p> <code>INSUFFICIENT_CLOUDHSM_HSMS</code> - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.</p> </li>
        /// <li> <p> <code>INTERNAL_ERROR</code> - KMS could not complete the request due to an internal error. Retry the request. For <code>ConnectCustomKeyStore</code> requests, disconnect the custom key store before trying to connect again.</p> </li>
        /// <li> <p> <code>INVALID_CREDENTIALS</code> - KMS does not have the correct password for the <code>kmsuser</code> crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
        /// <li> <p> <code>NETWORK_ERRORS</code> - Network errors are preventing KMS from connecting to the custom key store.</p> </li>
        /// <li> <p> <code>SUBNET_NOT_FOUND</code> - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p> <code>USER_LOCKED_OUT</code> - The <code>kmsuser</code> CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
        /// <li> <p> <code>USER_LOGGED_IN</code> - The <code>kmsuser</code> CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the <code>kmsuser</code> account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the <code>kmsuser</code> CU out of the cluster. If you changed the <code>kmsuser</code> password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2">How to Log Out and Reconnect</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p> <code>USER_NOT_FOUND</code> - KMS cannot find a <code>kmsuser</code> CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a <code>kmsuser</code> CU account in the cluster, and then update the key store password value for the custom key store.</p> </li>
        /// </ul>
        pub fn connection_error_code(
            mut self,
            input: crate::model::ConnectionErrorCodeType,
        ) -> Self {
            self.connection_error_code = Some(input);
            self
        }
        /// <p>Describes the connection error. This field appears in the response only when the <code>ConnectionState</code> is <code>FAILED</code>. For help resolving these errors, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>CLUSTER_NOT_FOUND</code> - KMS cannot find the CloudHSM cluster with the specified cluster ID.</p> </li>
        /// <li> <p> <code>INSUFFICIENT_CLOUDHSM_HSMS</code> - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.</p> </li>
        /// <li> <p> <code>INTERNAL_ERROR</code> - KMS could not complete the request due to an internal error. Retry the request. For <code>ConnectCustomKeyStore</code> requests, disconnect the custom key store before trying to connect again.</p> </li>
        /// <li> <p> <code>INVALID_CREDENTIALS</code> - KMS does not have the correct password for the <code>kmsuser</code> crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
        /// <li> <p> <code>NETWORK_ERRORS</code> - Network errors are preventing KMS from connecting to the custom key store.</p> </li>
        /// <li> <p> <code>SUBNET_NOT_FOUND</code> - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed">How to Fix a Connection Failure</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p> <code>USER_LOCKED_OUT</code> - The <code>kmsuser</code> CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the <code>kmsuser</code> account password and update the key store password value for the custom key store.</p> </li>
        /// <li> <p> <code>USER_LOGGED_IN</code> - The <code>kmsuser</code> CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the <code>kmsuser</code> account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the <code>kmsuser</code> CU out of the cluster. If you changed the <code>kmsuser</code> password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2">How to Log Out and Reconnect</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// <li> <p> <code>USER_NOT_FOUND</code> - KMS cannot find a <code>kmsuser</code> CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a <code>kmsuser</code> CU account in the cluster, and then update the key store password value for the custom key store.</p> </li>
        /// </ul>
        pub fn set_connection_error_code(
            mut self,
            input: std::option::Option<crate::model::ConnectionErrorCodeType>,
        ) -> Self {
            self.connection_error_code = input;
            self
        }
        /// <p>The date and time when the custom key store was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the custom key store was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomKeyStoresListEntry`](crate::model::CustomKeyStoresListEntry)
        pub fn build(self) -> crate::model::CustomKeyStoresListEntry {
            crate::model::CustomKeyStoresListEntry {
                custom_key_store_id: self.custom_key_store_id,
                custom_key_store_name: self.custom_key_store_name,
                cloud_hsm_cluster_id: self.cloud_hsm_cluster_id,
                trust_anchor_certificate: self.trust_anchor_certificate,
                connection_state: self.connection_state,
                connection_error_code: self.connection_error_code,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CustomKeyStoresListEntry {
    /// Creates a new builder-style object to manufacture [`CustomKeyStoresListEntry`](crate::model::CustomKeyStoresListEntry)
    pub fn builder() -> crate::model::custom_key_stores_list_entry::Builder {
        crate::model::custom_key_stores_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionErrorCodeType {
    #[allow(missing_docs)] // documentation missing in model
    ClusterNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientCloudhsmHsms,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCredentials,
    #[allow(missing_docs)] // documentation missing in model
    NetworkErrors,
    #[allow(missing_docs)] // documentation missing in model
    SubnetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UserLockedOut,
    #[allow(missing_docs)] // documentation missing in model
    UserLoggedIn,
    #[allow(missing_docs)] // documentation missing in model
    UserNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionErrorCodeType {
    fn from(s: &str) -> Self {
        match s {
            "CLUSTER_NOT_FOUND" => ConnectionErrorCodeType::ClusterNotFound,
            "INSUFFICIENT_CLOUDHSM_HSMS" => ConnectionErrorCodeType::InsufficientCloudhsmHsms,
            "INTERNAL_ERROR" => ConnectionErrorCodeType::InternalError,
            "INVALID_CREDENTIALS" => ConnectionErrorCodeType::InvalidCredentials,
            "NETWORK_ERRORS" => ConnectionErrorCodeType::NetworkErrors,
            "SUBNET_NOT_FOUND" => ConnectionErrorCodeType::SubnetNotFound,
            "USER_LOCKED_OUT" => ConnectionErrorCodeType::UserLockedOut,
            "USER_LOGGED_IN" => ConnectionErrorCodeType::UserLoggedIn,
            "USER_NOT_FOUND" => ConnectionErrorCodeType::UserNotFound,
            other => ConnectionErrorCodeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionErrorCodeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionErrorCodeType::from(s))
    }
}
impl ConnectionErrorCodeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionErrorCodeType::ClusterNotFound => "CLUSTER_NOT_FOUND",
            ConnectionErrorCodeType::InsufficientCloudhsmHsms => "INSUFFICIENT_CLOUDHSM_HSMS",
            ConnectionErrorCodeType::InternalError => "INTERNAL_ERROR",
            ConnectionErrorCodeType::InvalidCredentials => "INVALID_CREDENTIALS",
            ConnectionErrorCodeType::NetworkErrors => "NETWORK_ERRORS",
            ConnectionErrorCodeType::SubnetNotFound => "SUBNET_NOT_FOUND",
            ConnectionErrorCodeType::UserLockedOut => "USER_LOCKED_OUT",
            ConnectionErrorCodeType::UserLoggedIn => "USER_LOGGED_IN",
            ConnectionErrorCodeType::UserNotFound => "USER_NOT_FOUND",
            ConnectionErrorCodeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLUSTER_NOT_FOUND",
            "INSUFFICIENT_CLOUDHSM_HSMS",
            "INTERNAL_ERROR",
            "INVALID_CREDENTIALS",
            "NETWORK_ERRORS",
            "SUBNET_NOT_FOUND",
            "USER_LOCKED_OUT",
            "USER_LOGGED_IN",
            "USER_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for ConnectionErrorCodeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStateType {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Connecting,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    Disconnecting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStateType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => ConnectionStateType::Connected,
            "CONNECTING" => ConnectionStateType::Connecting,
            "DISCONNECTED" => ConnectionStateType::Disconnected,
            "DISCONNECTING" => ConnectionStateType::Disconnecting,
            "FAILED" => ConnectionStateType::Failed,
            other => ConnectionStateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStateType::from(s))
    }
}
impl ConnectionStateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStateType::Connected => "CONNECTED",
            ConnectionStateType::Connecting => "CONNECTING",
            ConnectionStateType::Disconnected => "DISCONNECTED",
            ConnectionStateType::Disconnecting => "DISCONNECTING",
            ConnectionStateType::Failed => "FAILED",
            ConnectionStateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONNECTED",
            "CONNECTING",
            "DISCONNECTED",
            "DISCONNECTING",
            "FAILED",
        ]
    }
}
impl AsRef<str> for ConnectionStateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
