// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelKeyDeletion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_key_deletion`](crate::client::Client::cancel_key_deletion).
///
/// See [`crate::client::fluent_builders::CancelKeyDeletion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelKeyDeletion {
    _private: (),
}
impl CancelKeyDeletion {
    /// Creates a new builder-style object to manufacture [`CancelKeyDeletionInput`](crate::input::CancelKeyDeletionInput)
    pub fn builder() -> crate::input::cancel_key_deletion_input::Builder {
        crate::input::cancel_key_deletion_input::Builder::default()
    }
    /// Creates a new `CancelKeyDeletion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelKeyDeletion {
    type Output = std::result::Result<
        crate::output::CancelKeyDeletionOutput,
        crate::error::CancelKeyDeletionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_key_deletion_error(response)
        } else {
            crate::operation_deser::parse_cancel_key_deletion_response(response)
        }
    }
}

/// Operation shape for `ConnectCustomKeyStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`connect_custom_key_store`](crate::client::Client::connect_custom_key_store).
///
/// See [`crate::client::fluent_builders::ConnectCustomKeyStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConnectCustomKeyStore {
    _private: (),
}
impl ConnectCustomKeyStore {
    /// Creates a new builder-style object to manufacture [`ConnectCustomKeyStoreInput`](crate::input::ConnectCustomKeyStoreInput)
    pub fn builder() -> crate::input::connect_custom_key_store_input::Builder {
        crate::input::connect_custom_key_store_input::Builder::default()
    }
    /// Creates a new `ConnectCustomKeyStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConnectCustomKeyStore {
    type Output = std::result::Result<
        crate::output::ConnectCustomKeyStoreOutput,
        crate::error::ConnectCustomKeyStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_connect_custom_key_store_error(response)
        } else {
            crate::operation_deser::parse_connect_custom_key_store_response(response)
        }
    }
}

/// Operation shape for `CreateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alias`](crate::client::Client::create_alias).
///
/// See [`crate::client::fluent_builders::CreateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlias {
    _private: (),
}
impl CreateAlias {
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
    /// Creates a new `CreateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlias {
    type Output =
        std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_alias_error(response)
        } else {
            crate::operation_deser::parse_create_alias_response(response)
        }
    }
}

/// Operation shape for `CreateCustomKeyStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_key_store`](crate::client::Client::create_custom_key_store).
///
/// See [`crate::client::fluent_builders::CreateCustomKeyStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomKeyStore {
    _private: (),
}
impl CreateCustomKeyStore {
    /// Creates a new builder-style object to manufacture [`CreateCustomKeyStoreInput`](crate::input::CreateCustomKeyStoreInput)
    pub fn builder() -> crate::input::create_custom_key_store_input::Builder {
        crate::input::create_custom_key_store_input::Builder::default()
    }
    /// Creates a new `CreateCustomKeyStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomKeyStore {
    type Output = std::result::Result<
        crate::output::CreateCustomKeyStoreOutput,
        crate::error::CreateCustomKeyStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_key_store_error(response)
        } else {
            crate::operation_deser::parse_create_custom_key_store_response(response)
        }
    }
}

/// Operation shape for `CreateGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_grant`](crate::client::Client::create_grant).
///
/// See [`crate::client::fluent_builders::CreateGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGrant {
    _private: (),
}
impl CreateGrant {
    /// Creates a new builder-style object to manufacture [`CreateGrantInput`](crate::input::CreateGrantInput)
    pub fn builder() -> crate::input::create_grant_input::Builder {
        crate::input::create_grant_input::Builder::default()
    }
    /// Creates a new `CreateGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGrant {
    type Output =
        std::result::Result<crate::output::CreateGrantOutput, crate::error::CreateGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_grant_error(response)
        } else {
            crate::operation_deser::parse_create_grant_response(response)
        }
    }
}

/// Operation shape for `CreateKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_key`](crate::client::Client::create_key).
///
/// See [`crate::client::fluent_builders::CreateKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKey {
    _private: (),
}
impl CreateKey {
    /// Creates a new builder-style object to manufacture [`CreateKeyInput`](crate::input::CreateKeyInput)
    pub fn builder() -> crate::input::create_key_input::Builder {
        crate::input::create_key_input::Builder::default()
    }
    /// Creates a new `CreateKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKey {
    type Output = std::result::Result<crate::output::CreateKeyOutput, crate::error::CreateKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_key_error(response)
        } else {
            crate::operation_deser::parse_create_key_response(response)
        }
    }
}

/// Operation shape for `Decrypt`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decrypt`](crate::client::Client::decrypt).
///
/// See [`crate::client::fluent_builders::Decrypt`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Decrypt {
    _private: (),
}
impl Decrypt {
    /// Creates a new builder-style object to manufacture [`DecryptInput`](crate::input::DecryptInput)
    pub fn builder() -> crate::input::decrypt_input::Builder {
        crate::input::decrypt_input::Builder::default()
    }
    /// Creates a new `Decrypt` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Decrypt {
    type Output = std::result::Result<crate::output::DecryptOutput, crate::error::DecryptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decrypt_error(response)
        } else {
            crate::operation_deser::parse_decrypt_response(response)
        }
    }
}

/// Operation shape for `DeleteAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alias`](crate::client::Client::delete_alias).
///
/// See [`crate::client::fluent_builders::DeleteAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlias {
    _private: (),
}
impl DeleteAlias {
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
    /// Creates a new `DeleteAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlias {
    type Output =
        std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomKeyStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_key_store`](crate::client::Client::delete_custom_key_store).
///
/// See [`crate::client::fluent_builders::DeleteCustomKeyStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomKeyStore {
    _private: (),
}
impl DeleteCustomKeyStore {
    /// Creates a new builder-style object to manufacture [`DeleteCustomKeyStoreInput`](crate::input::DeleteCustomKeyStoreInput)
    pub fn builder() -> crate::input::delete_custom_key_store_input::Builder {
        crate::input::delete_custom_key_store_input::Builder::default()
    }
    /// Creates a new `DeleteCustomKeyStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomKeyStore {
    type Output = std::result::Result<
        crate::output::DeleteCustomKeyStoreOutput,
        crate::error::DeleteCustomKeyStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_key_store_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_key_store_response(response)
        }
    }
}

/// Operation shape for `DeleteImportedKeyMaterial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_imported_key_material`](crate::client::Client::delete_imported_key_material).
///
/// See [`crate::client::fluent_builders::DeleteImportedKeyMaterial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImportedKeyMaterial {
    _private: (),
}
impl DeleteImportedKeyMaterial {
    /// Creates a new builder-style object to manufacture [`DeleteImportedKeyMaterialInput`](crate::input::DeleteImportedKeyMaterialInput)
    pub fn builder() -> crate::input::delete_imported_key_material_input::Builder {
        crate::input::delete_imported_key_material_input::Builder::default()
    }
    /// Creates a new `DeleteImportedKeyMaterial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImportedKeyMaterial {
    type Output = std::result::Result<
        crate::output::DeleteImportedKeyMaterialOutput,
        crate::error::DeleteImportedKeyMaterialError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_imported_key_material_error(response)
        } else {
            crate::operation_deser::parse_delete_imported_key_material_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomKeyStores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_key_stores`](crate::client::Client::describe_custom_key_stores).
///
/// See [`crate::client::fluent_builders::DescribeCustomKeyStores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomKeyStores {
    _private: (),
}
impl DescribeCustomKeyStores {
    /// Creates a new builder-style object to manufacture [`DescribeCustomKeyStoresInput`](crate::input::DescribeCustomKeyStoresInput)
    pub fn builder() -> crate::input::describe_custom_key_stores_input::Builder {
        crate::input::describe_custom_key_stores_input::Builder::default()
    }
    /// Creates a new `DescribeCustomKeyStores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomKeyStores {
    type Output = std::result::Result<
        crate::output::DescribeCustomKeyStoresOutput,
        crate::error::DescribeCustomKeyStoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_key_stores_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_key_stores_response(response)
        }
    }
}

/// Operation shape for `DescribeKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_key`](crate::client::Client::describe_key).
///
/// See [`crate::client::fluent_builders::DescribeKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeKey {
    _private: (),
}
impl DescribeKey {
    /// Creates a new builder-style object to manufacture [`DescribeKeyInput`](crate::input::DescribeKeyInput)
    pub fn builder() -> crate::input::describe_key_input::Builder {
        crate::input::describe_key_input::Builder::default()
    }
    /// Creates a new `DescribeKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeKey {
    type Output =
        std::result::Result<crate::output::DescribeKeyOutput, crate::error::DescribeKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_key_error(response)
        } else {
            crate::operation_deser::parse_describe_key_response(response)
        }
    }
}

/// Operation shape for `DisableKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_key`](crate::client::Client::disable_key).
///
/// See [`crate::client::fluent_builders::DisableKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableKey {
    _private: (),
}
impl DisableKey {
    /// Creates a new builder-style object to manufacture [`DisableKeyInput`](crate::input::DisableKeyInput)
    pub fn builder() -> crate::input::disable_key_input::Builder {
        crate::input::disable_key_input::Builder::default()
    }
    /// Creates a new `DisableKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableKey {
    type Output =
        std::result::Result<crate::output::DisableKeyOutput, crate::error::DisableKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_key_error(response)
        } else {
            crate::operation_deser::parse_disable_key_response(response)
        }
    }
}

/// Operation shape for `DisableKeyRotation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_key_rotation`](crate::client::Client::disable_key_rotation).
///
/// See [`crate::client::fluent_builders::DisableKeyRotation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableKeyRotation {
    _private: (),
}
impl DisableKeyRotation {
    /// Creates a new builder-style object to manufacture [`DisableKeyRotationInput`](crate::input::DisableKeyRotationInput)
    pub fn builder() -> crate::input::disable_key_rotation_input::Builder {
        crate::input::disable_key_rotation_input::Builder::default()
    }
    /// Creates a new `DisableKeyRotation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableKeyRotation {
    type Output = std::result::Result<
        crate::output::DisableKeyRotationOutput,
        crate::error::DisableKeyRotationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_key_rotation_error(response)
        } else {
            crate::operation_deser::parse_disable_key_rotation_response(response)
        }
    }
}

/// Operation shape for `DisconnectCustomKeyStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_custom_key_store`](crate::client::Client::disconnect_custom_key_store).
///
/// See [`crate::client::fluent_builders::DisconnectCustomKeyStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectCustomKeyStore {
    _private: (),
}
impl DisconnectCustomKeyStore {
    /// Creates a new builder-style object to manufacture [`DisconnectCustomKeyStoreInput`](crate::input::DisconnectCustomKeyStoreInput)
    pub fn builder() -> crate::input::disconnect_custom_key_store_input::Builder {
        crate::input::disconnect_custom_key_store_input::Builder::default()
    }
    /// Creates a new `DisconnectCustomKeyStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectCustomKeyStore {
    type Output = std::result::Result<
        crate::output::DisconnectCustomKeyStoreOutput,
        crate::error::DisconnectCustomKeyStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_custom_key_store_error(response)
        } else {
            crate::operation_deser::parse_disconnect_custom_key_store_response(response)
        }
    }
}

/// Operation shape for `EnableKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_key`](crate::client::Client::enable_key).
///
/// See [`crate::client::fluent_builders::EnableKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableKey {
    _private: (),
}
impl EnableKey {
    /// Creates a new builder-style object to manufacture [`EnableKeyInput`](crate::input::EnableKeyInput)
    pub fn builder() -> crate::input::enable_key_input::Builder {
        crate::input::enable_key_input::Builder::default()
    }
    /// Creates a new `EnableKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableKey {
    type Output = std::result::Result<crate::output::EnableKeyOutput, crate::error::EnableKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_key_error(response)
        } else {
            crate::operation_deser::parse_enable_key_response(response)
        }
    }
}

/// Operation shape for `EnableKeyRotation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_key_rotation`](crate::client::Client::enable_key_rotation).
///
/// See [`crate::client::fluent_builders::EnableKeyRotation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableKeyRotation {
    _private: (),
}
impl EnableKeyRotation {
    /// Creates a new builder-style object to manufacture [`EnableKeyRotationInput`](crate::input::EnableKeyRotationInput)
    pub fn builder() -> crate::input::enable_key_rotation_input::Builder {
        crate::input::enable_key_rotation_input::Builder::default()
    }
    /// Creates a new `EnableKeyRotation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableKeyRotation {
    type Output = std::result::Result<
        crate::output::EnableKeyRotationOutput,
        crate::error::EnableKeyRotationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_key_rotation_error(response)
        } else {
            crate::operation_deser::parse_enable_key_rotation_response(response)
        }
    }
}

/// Operation shape for `Encrypt`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`encrypt`](crate::client::Client::encrypt).
///
/// See [`crate::client::fluent_builders::Encrypt`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Encrypt {
    _private: (),
}
impl Encrypt {
    /// Creates a new builder-style object to manufacture [`EncryptInput`](crate::input::EncryptInput)
    pub fn builder() -> crate::input::encrypt_input::Builder {
        crate::input::encrypt_input::Builder::default()
    }
    /// Creates a new `Encrypt` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Encrypt {
    type Output = std::result::Result<crate::output::EncryptOutput, crate::error::EncryptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_encrypt_error(response)
        } else {
            crate::operation_deser::parse_encrypt_response(response)
        }
    }
}

/// Operation shape for `GenerateDataKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_data_key`](crate::client::Client::generate_data_key).
///
/// See [`crate::client::fluent_builders::GenerateDataKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateDataKey {
    _private: (),
}
impl GenerateDataKey {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyInput`](crate::input::GenerateDataKeyInput)
    pub fn builder() -> crate::input::generate_data_key_input::Builder {
        crate::input::generate_data_key_input::Builder::default()
    }
    /// Creates a new `GenerateDataKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateDataKey {
    type Output = std::result::Result<
        crate::output::GenerateDataKeyOutput,
        crate::error::GenerateDataKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_data_key_error(response)
        } else {
            crate::operation_deser::parse_generate_data_key_response(response)
        }
    }
}

/// Operation shape for `GenerateDataKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_data_key_pair`](crate::client::Client::generate_data_key_pair).
///
/// See [`crate::client::fluent_builders::GenerateDataKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateDataKeyPair {
    _private: (),
}
impl GenerateDataKeyPair {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyPairInput`](crate::input::GenerateDataKeyPairInput)
    pub fn builder() -> crate::input::generate_data_key_pair_input::Builder {
        crate::input::generate_data_key_pair_input::Builder::default()
    }
    /// Creates a new `GenerateDataKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateDataKeyPair {
    type Output = std::result::Result<
        crate::output::GenerateDataKeyPairOutput,
        crate::error::GenerateDataKeyPairError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_data_key_pair_error(response)
        } else {
            crate::operation_deser::parse_generate_data_key_pair_response(response)
        }
    }
}

/// Operation shape for `GenerateDataKeyPairWithoutPlaintext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_data_key_pair_without_plaintext`](crate::client::Client::generate_data_key_pair_without_plaintext).
///
/// See [`crate::client::fluent_builders::GenerateDataKeyPairWithoutPlaintext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateDataKeyPairWithoutPlaintext {
    _private: (),
}
impl GenerateDataKeyPairWithoutPlaintext {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyPairWithoutPlaintextInput`](crate::input::GenerateDataKeyPairWithoutPlaintextInput)
    pub fn builder() -> crate::input::generate_data_key_pair_without_plaintext_input::Builder {
        crate::input::generate_data_key_pair_without_plaintext_input::Builder::default()
    }
    /// Creates a new `GenerateDataKeyPairWithoutPlaintext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateDataKeyPairWithoutPlaintext {
    type Output = std::result::Result<
        crate::output::GenerateDataKeyPairWithoutPlaintextOutput,
        crate::error::GenerateDataKeyPairWithoutPlaintextError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_data_key_pair_without_plaintext_error(response)
        } else {
            crate::operation_deser::parse_generate_data_key_pair_without_plaintext_response(
                response,
            )
        }
    }
}

/// Operation shape for `GenerateDataKeyWithoutPlaintext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_data_key_without_plaintext`](crate::client::Client::generate_data_key_without_plaintext).
///
/// See [`crate::client::fluent_builders::GenerateDataKeyWithoutPlaintext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateDataKeyWithoutPlaintext {
    _private: (),
}
impl GenerateDataKeyWithoutPlaintext {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyWithoutPlaintextInput`](crate::input::GenerateDataKeyWithoutPlaintextInput)
    pub fn builder() -> crate::input::generate_data_key_without_plaintext_input::Builder {
        crate::input::generate_data_key_without_plaintext_input::Builder::default()
    }
    /// Creates a new `GenerateDataKeyWithoutPlaintext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateDataKeyWithoutPlaintext {
    type Output = std::result::Result<
        crate::output::GenerateDataKeyWithoutPlaintextOutput,
        crate::error::GenerateDataKeyWithoutPlaintextError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_data_key_without_plaintext_error(response)
        } else {
            crate::operation_deser::parse_generate_data_key_without_plaintext_response(response)
        }
    }
}

/// Operation shape for `GenerateRandom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_random`](crate::client::Client::generate_random).
///
/// See [`crate::client::fluent_builders::GenerateRandom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateRandom {
    _private: (),
}
impl GenerateRandom {
    /// Creates a new builder-style object to manufacture [`GenerateRandomInput`](crate::input::GenerateRandomInput)
    pub fn builder() -> crate::input::generate_random_input::Builder {
        crate::input::generate_random_input::Builder::default()
    }
    /// Creates a new `GenerateRandom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateRandom {
    type Output =
        std::result::Result<crate::output::GenerateRandomOutput, crate::error::GenerateRandomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_random_error(response)
        } else {
            crate::operation_deser::parse_generate_random_response(response)
        }
    }
}

/// Operation shape for `GetKeyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_policy`](crate::client::Client::get_key_policy).
///
/// See [`crate::client::fluent_builders::GetKeyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyPolicy {
    _private: (),
}
impl GetKeyPolicy {
    /// Creates a new builder-style object to manufacture [`GetKeyPolicyInput`](crate::input::GetKeyPolicyInput)
    pub fn builder() -> crate::input::get_key_policy_input::Builder {
        crate::input::get_key_policy_input::Builder::default()
    }
    /// Creates a new `GetKeyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyPolicy {
    type Output =
        std::result::Result<crate::output::GetKeyPolicyOutput, crate::error::GetKeyPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_policy_error(response)
        } else {
            crate::operation_deser::parse_get_key_policy_response(response)
        }
    }
}

/// Operation shape for `GetKeyRotationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_rotation_status`](crate::client::Client::get_key_rotation_status).
///
/// See [`crate::client::fluent_builders::GetKeyRotationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyRotationStatus {
    _private: (),
}
impl GetKeyRotationStatus {
    /// Creates a new builder-style object to manufacture [`GetKeyRotationStatusInput`](crate::input::GetKeyRotationStatusInput)
    pub fn builder() -> crate::input::get_key_rotation_status_input::Builder {
        crate::input::get_key_rotation_status_input::Builder::default()
    }
    /// Creates a new `GetKeyRotationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyRotationStatus {
    type Output = std::result::Result<
        crate::output::GetKeyRotationStatusOutput,
        crate::error::GetKeyRotationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_rotation_status_error(response)
        } else {
            crate::operation_deser::parse_get_key_rotation_status_response(response)
        }
    }
}

/// Operation shape for `GetParametersForImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_parameters_for_import`](crate::client::Client::get_parameters_for_import).
///
/// See [`crate::client::fluent_builders::GetParametersForImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetParametersForImport {
    _private: (),
}
impl GetParametersForImport {
    /// Creates a new builder-style object to manufacture [`GetParametersForImportInput`](crate::input::GetParametersForImportInput)
    pub fn builder() -> crate::input::get_parameters_for_import_input::Builder {
        crate::input::get_parameters_for_import_input::Builder::default()
    }
    /// Creates a new `GetParametersForImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetParametersForImport {
    type Output = std::result::Result<
        crate::output::GetParametersForImportOutput,
        crate::error::GetParametersForImportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_parameters_for_import_error(response)
        } else {
            crate::operation_deser::parse_get_parameters_for_import_response(response)
        }
    }
}

/// Operation shape for `GetPublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_public_key`](crate::client::Client::get_public_key).
///
/// See [`crate::client::fluent_builders::GetPublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPublicKey {
    _private: (),
}
impl GetPublicKey {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
    pub fn builder() -> crate::input::get_public_key_input::Builder {
        crate::input::get_public_key_input::Builder::default()
    }
    /// Creates a new `GetPublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPublicKey {
    type Output =
        std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_public_key_error(response)
        } else {
            crate::operation_deser::parse_get_public_key_response(response)
        }
    }
}

/// Operation shape for `ImportKeyMaterial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_key_material`](crate::client::Client::import_key_material).
///
/// See [`crate::client::fluent_builders::ImportKeyMaterial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportKeyMaterial {
    _private: (),
}
impl ImportKeyMaterial {
    /// Creates a new builder-style object to manufacture [`ImportKeyMaterialInput`](crate::input::ImportKeyMaterialInput)
    pub fn builder() -> crate::input::import_key_material_input::Builder {
        crate::input::import_key_material_input::Builder::default()
    }
    /// Creates a new `ImportKeyMaterial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportKeyMaterial {
    type Output = std::result::Result<
        crate::output::ImportKeyMaterialOutput,
        crate::error::ImportKeyMaterialError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_key_material_error(response)
        } else {
            crate::operation_deser::parse_import_key_material_response(response)
        }
    }
}

/// Operation shape for `ListAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aliases`](crate::client::Client::list_aliases).
///
/// See [`crate::client::fluent_builders::ListAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAliases {
    _private: (),
}
impl ListAliases {
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
    /// Creates a new `ListAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAliases {
    type Output =
        std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_aliases_response(response)
        }
    }
}

/// Operation shape for `ListGrants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_grants`](crate::client::Client::list_grants).
///
/// See [`crate::client::fluent_builders::ListGrants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGrants {
    _private: (),
}
impl ListGrants {
    /// Creates a new builder-style object to manufacture [`ListGrantsInput`](crate::input::ListGrantsInput)
    pub fn builder() -> crate::input::list_grants_input::Builder {
        crate::input::list_grants_input::Builder::default()
    }
    /// Creates a new `ListGrants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGrants {
    type Output =
        std::result::Result<crate::output::ListGrantsOutput, crate::error::ListGrantsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_grants_error(response)
        } else {
            crate::operation_deser::parse_list_grants_response(response)
        }
    }
}

/// Operation shape for `ListKeyPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_key_policies`](crate::client::Client::list_key_policies).
///
/// See [`crate::client::fluent_builders::ListKeyPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKeyPolicies {
    _private: (),
}
impl ListKeyPolicies {
    /// Creates a new builder-style object to manufacture [`ListKeyPoliciesInput`](crate::input::ListKeyPoliciesInput)
    pub fn builder() -> crate::input::list_key_policies_input::Builder {
        crate::input::list_key_policies_input::Builder::default()
    }
    /// Creates a new `ListKeyPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKeyPolicies {
    type Output = std::result::Result<
        crate::output::ListKeyPoliciesOutput,
        crate::error::ListKeyPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_key_policies_error(response)
        } else {
            crate::operation_deser::parse_list_key_policies_response(response)
        }
    }
}

/// Operation shape for `ListKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_keys`](crate::client::Client::list_keys).
///
/// See [`crate::client::fluent_builders::ListKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKeys {
    _private: (),
}
impl ListKeys {
    /// Creates a new builder-style object to manufacture [`ListKeysInput`](crate::input::ListKeysInput)
    pub fn builder() -> crate::input::list_keys_input::Builder {
        crate::input::list_keys_input::Builder::default()
    }
    /// Creates a new `ListKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKeys {
    type Output = std::result::Result<crate::output::ListKeysOutput, crate::error::ListKeysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_keys_error(response)
        } else {
            crate::operation_deser::parse_list_keys_response(response)
        }
    }
}

/// Operation shape for `ListResourceTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_tags`](crate::client::Client::list_resource_tags).
///
/// See [`crate::client::fluent_builders::ListResourceTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceTags {
    _private: (),
}
impl ListResourceTags {
    /// Creates a new builder-style object to manufacture [`ListResourceTagsInput`](crate::input::ListResourceTagsInput)
    pub fn builder() -> crate::input::list_resource_tags_input::Builder {
        crate::input::list_resource_tags_input::Builder::default()
    }
    /// Creates a new `ListResourceTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceTags {
    type Output = std::result::Result<
        crate::output::ListResourceTagsOutput,
        crate::error::ListResourceTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_tags_error(response)
        } else {
            crate::operation_deser::parse_list_resource_tags_response(response)
        }
    }
}

/// Operation shape for `ListRetirableGrants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_retirable_grants`](crate::client::Client::list_retirable_grants).
///
/// See [`crate::client::fluent_builders::ListRetirableGrants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRetirableGrants {
    _private: (),
}
impl ListRetirableGrants {
    /// Creates a new builder-style object to manufacture [`ListRetirableGrantsInput`](crate::input::ListRetirableGrantsInput)
    pub fn builder() -> crate::input::list_retirable_grants_input::Builder {
        crate::input::list_retirable_grants_input::Builder::default()
    }
    /// Creates a new `ListRetirableGrants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRetirableGrants {
    type Output = std::result::Result<
        crate::output::ListRetirableGrantsOutput,
        crate::error::ListRetirableGrantsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_retirable_grants_error(response)
        } else {
            crate::operation_deser::parse_list_retirable_grants_response(response)
        }
    }
}

/// Operation shape for `PutKeyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_key_policy`](crate::client::Client::put_key_policy).
///
/// See [`crate::client::fluent_builders::PutKeyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutKeyPolicy {
    _private: (),
}
impl PutKeyPolicy {
    /// Creates a new builder-style object to manufacture [`PutKeyPolicyInput`](crate::input::PutKeyPolicyInput)
    pub fn builder() -> crate::input::put_key_policy_input::Builder {
        crate::input::put_key_policy_input::Builder::default()
    }
    /// Creates a new `PutKeyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutKeyPolicy {
    type Output =
        std::result::Result<crate::output::PutKeyPolicyOutput, crate::error::PutKeyPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_key_policy_error(response)
        } else {
            crate::operation_deser::parse_put_key_policy_response(response)
        }
    }
}

/// Operation shape for `ReEncrypt`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`re_encrypt`](crate::client::Client::re_encrypt).
///
/// See [`crate::client::fluent_builders::ReEncrypt`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReEncrypt {
    _private: (),
}
impl ReEncrypt {
    /// Creates a new builder-style object to manufacture [`ReEncryptInput`](crate::input::ReEncryptInput)
    pub fn builder() -> crate::input::re_encrypt_input::Builder {
        crate::input::re_encrypt_input::Builder::default()
    }
    /// Creates a new `ReEncrypt` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReEncrypt {
    type Output = std::result::Result<crate::output::ReEncryptOutput, crate::error::ReEncryptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_re_encrypt_error(response)
        } else {
            crate::operation_deser::parse_re_encrypt_response(response)
        }
    }
}

/// Operation shape for `ReplicateKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replicate_key`](crate::client::Client::replicate_key).
///
/// See [`crate::client::fluent_builders::ReplicateKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplicateKey {
    _private: (),
}
impl ReplicateKey {
    /// Creates a new builder-style object to manufacture [`ReplicateKeyInput`](crate::input::ReplicateKeyInput)
    pub fn builder() -> crate::input::replicate_key_input::Builder {
        crate::input::replicate_key_input::Builder::default()
    }
    /// Creates a new `ReplicateKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplicateKey {
    type Output =
        std::result::Result<crate::output::ReplicateKeyOutput, crate::error::ReplicateKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replicate_key_error(response)
        } else {
            crate::operation_deser::parse_replicate_key_response(response)
        }
    }
}

/// Operation shape for `RetireGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retire_grant`](crate::client::Client::retire_grant).
///
/// See [`crate::client::fluent_builders::RetireGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetireGrant {
    _private: (),
}
impl RetireGrant {
    /// Creates a new builder-style object to manufacture [`RetireGrantInput`](crate::input::RetireGrantInput)
    pub fn builder() -> crate::input::retire_grant_input::Builder {
        crate::input::retire_grant_input::Builder::default()
    }
    /// Creates a new `RetireGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetireGrant {
    type Output =
        std::result::Result<crate::output::RetireGrantOutput, crate::error::RetireGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retire_grant_error(response)
        } else {
            crate::operation_deser::parse_retire_grant_response(response)
        }
    }
}

/// Operation shape for `RevokeGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_grant`](crate::client::Client::revoke_grant).
///
/// See [`crate::client::fluent_builders::RevokeGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeGrant {
    _private: (),
}
impl RevokeGrant {
    /// Creates a new builder-style object to manufacture [`RevokeGrantInput`](crate::input::RevokeGrantInput)
    pub fn builder() -> crate::input::revoke_grant_input::Builder {
        crate::input::revoke_grant_input::Builder::default()
    }
    /// Creates a new `RevokeGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeGrant {
    type Output =
        std::result::Result<crate::output::RevokeGrantOutput, crate::error::RevokeGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_grant_error(response)
        } else {
            crate::operation_deser::parse_revoke_grant_response(response)
        }
    }
}

/// Operation shape for `ScheduleKeyDeletion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`schedule_key_deletion`](crate::client::Client::schedule_key_deletion).
///
/// See [`crate::client::fluent_builders::ScheduleKeyDeletion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ScheduleKeyDeletion {
    _private: (),
}
impl ScheduleKeyDeletion {
    /// Creates a new builder-style object to manufacture [`ScheduleKeyDeletionInput`](crate::input::ScheduleKeyDeletionInput)
    pub fn builder() -> crate::input::schedule_key_deletion_input::Builder {
        crate::input::schedule_key_deletion_input::Builder::default()
    }
    /// Creates a new `ScheduleKeyDeletion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ScheduleKeyDeletion {
    type Output = std::result::Result<
        crate::output::ScheduleKeyDeletionOutput,
        crate::error::ScheduleKeyDeletionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_schedule_key_deletion_error(response)
        } else {
            crate::operation_deser::parse_schedule_key_deletion_response(response)
        }
    }
}

/// Operation shape for `Sign`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`sign`](crate::client::Client::sign).
///
/// See [`crate::client::fluent_builders::Sign`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Sign {
    _private: (),
}
impl Sign {
    /// Creates a new builder-style object to manufacture [`SignInput`](crate::input::SignInput)
    pub fn builder() -> crate::input::sign_input::Builder {
        crate::input::sign_input::Builder::default()
    }
    /// Creates a new `Sign` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Sign {
    type Output = std::result::Result<crate::output::SignOutput, crate::error::SignError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_sign_error(response)
        } else {
            crate::operation_deser::parse_sign_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_alias`](crate::client::Client::update_alias).
///
/// See [`crate::client::fluent_builders::UpdateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAlias {
    _private: (),
}
impl UpdateAlias {
    /// Creates a new builder-style object to manufacture [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    pub fn builder() -> crate::input::update_alias_input::Builder {
        crate::input::update_alias_input::Builder::default()
    }
    /// Creates a new `UpdateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAlias {
    type Output =
        std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_alias_error(response)
        } else {
            crate::operation_deser::parse_update_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateCustomKeyStore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_key_store`](crate::client::Client::update_custom_key_store).
///
/// See [`crate::client::fluent_builders::UpdateCustomKeyStore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomKeyStore {
    _private: (),
}
impl UpdateCustomKeyStore {
    /// Creates a new builder-style object to manufacture [`UpdateCustomKeyStoreInput`](crate::input::UpdateCustomKeyStoreInput)
    pub fn builder() -> crate::input::update_custom_key_store_input::Builder {
        crate::input::update_custom_key_store_input::Builder::default()
    }
    /// Creates a new `UpdateCustomKeyStore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomKeyStore {
    type Output = std::result::Result<
        crate::output::UpdateCustomKeyStoreOutput,
        crate::error::UpdateCustomKeyStoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_key_store_error(response)
        } else {
            crate::operation_deser::parse_update_custom_key_store_response(response)
        }
    }
}

/// Operation shape for `UpdateKeyDescription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_key_description`](crate::client::Client::update_key_description).
///
/// See [`crate::client::fluent_builders::UpdateKeyDescription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateKeyDescription {
    _private: (),
}
impl UpdateKeyDescription {
    /// Creates a new builder-style object to manufacture [`UpdateKeyDescriptionInput`](crate::input::UpdateKeyDescriptionInput)
    pub fn builder() -> crate::input::update_key_description_input::Builder {
        crate::input::update_key_description_input::Builder::default()
    }
    /// Creates a new `UpdateKeyDescription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateKeyDescription {
    type Output = std::result::Result<
        crate::output::UpdateKeyDescriptionOutput,
        crate::error::UpdateKeyDescriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_key_description_error(response)
        } else {
            crate::operation_deser::parse_update_key_description_response(response)
        }
    }
}

/// Operation shape for `UpdatePrimaryRegion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_primary_region`](crate::client::Client::update_primary_region).
///
/// See [`crate::client::fluent_builders::UpdatePrimaryRegion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePrimaryRegion {
    _private: (),
}
impl UpdatePrimaryRegion {
    /// Creates a new builder-style object to manufacture [`UpdatePrimaryRegionInput`](crate::input::UpdatePrimaryRegionInput)
    pub fn builder() -> crate::input::update_primary_region_input::Builder {
        crate::input::update_primary_region_input::Builder::default()
    }
    /// Creates a new `UpdatePrimaryRegion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePrimaryRegion {
    type Output = std::result::Result<
        crate::output::UpdatePrimaryRegionOutput,
        crate::error::UpdatePrimaryRegionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_primary_region_error(response)
        } else {
            crate::operation_deser::parse_update_primary_region_response(response)
        }
    }
}

/// Operation shape for `Verify`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify`](crate::client::Client::verify).
///
/// See [`crate::client::fluent_builders::Verify`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Verify {
    _private: (),
}
impl Verify {
    /// Creates a new builder-style object to manufacture [`VerifyInput`](crate::input::VerifyInput)
    pub fn builder() -> crate::input::verify_input::Builder {
        crate::input::verify_input::Builder::default()
    }
    /// Creates a new `Verify` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Verify {
    type Output = std::result::Result<crate::output::VerifyOutput, crate::error::VerifyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_error(response)
        } else {
            crate::operation_deser::parse_verify_response(response)
        }
    }
}
