// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that indicates whether the signature was verified. A value of
    /// <code>True</code> indicates that the <code>Signature</code> was produced by signing the
    /// <code>Message</code> with the specified <code>KeyID</code> and
    /// <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code>
    /// operation fails with a <code>KMSInvalidSignatureException</code> exception. </p>
    pub signature_valid: bool,
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub signing_algorithm: std::option::Option<crate::model::SigningAlgorithmSpec>,
}
impl VerifyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>A Boolean value that indicates whether the signature was verified. A value of
    /// <code>True</code> indicates that the <code>Signature</code> was produced by signing the
    /// <code>Message</code> with the specified <code>KeyID</code> and
    /// <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code>
    /// operation fails with a <code>KMSInvalidSignatureException</code> exception. </p>
    pub fn signature_valid(&self) -> bool {
        self.signature_valid
    }
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub fn signing_algorithm(&self) -> std::option::Option<&crate::model::SigningAlgorithmSpec> {
        self.signing_algorithm.as_ref()
    }
}
impl std::fmt::Debug for VerifyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("signature_valid", &self.signature_valid);
        formatter.field("signing_algorithm", &self.signing_algorithm);
        formatter.finish()
    }
}
/// See [`VerifyOutput`](crate::output::VerifyOutput)
pub mod verify_output {
    /// A builder for [`VerifyOutput`](crate::output::VerifyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) signature_valid: std::option::Option<bool>,
        pub(crate) signing_algorithm: std::option::Option<crate::model::SigningAlgorithmSpec>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>A Boolean value that indicates whether the signature was verified. A value of
        /// <code>True</code> indicates that the <code>Signature</code> was produced by signing the
        /// <code>Message</code> with the specified <code>KeyID</code> and
        /// <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code>
        /// operation fails with a <code>KMSInvalidSignatureException</code> exception. </p>
        pub fn signature_valid(mut self, input: bool) -> Self {
            self.signature_valid = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether the signature was verified. A value of
        /// <code>True</code> indicates that the <code>Signature</code> was produced by signing the
        /// <code>Message</code> with the specified <code>KeyID</code> and
        /// <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code>
        /// operation fails with a <code>KMSInvalidSignatureException</code> exception. </p>
        pub fn set_signature_valid(mut self, input: std::option::Option<bool>) -> Self {
            self.signature_valid = input;
            self
        }
        /// <p>The signing algorithm that was used to verify the signature.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithmSpec) -> Self {
            self.signing_algorithm = Some(input);
            self
        }
        /// <p>The signing algorithm that was used to verify the signature.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithmSpec>,
        ) -> Self {
            self.signing_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyOutput`](crate::output::VerifyOutput)
        pub fn build(self) -> crate::output::VerifyOutput {
            crate::output::VerifyOutput {
                key_id: self.key_id,
                signature_valid: self.signature_valid.unwrap_or_default(),
                signing_algorithm: self.signing_algorithm,
            }
        }
    }
}
impl VerifyOutput {
    /// Creates a new builder-style object to manufacture [`VerifyOutput`](crate::output::VerifyOutput)
    pub fn builder() -> crate::output::verify_output::Builder {
        crate::output::verify_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePrimaryRegionOutput {}
impl std::fmt::Debug for UpdatePrimaryRegionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePrimaryRegionOutput");
        formatter.finish()
    }
}
/// See [`UpdatePrimaryRegionOutput`](crate::output::UpdatePrimaryRegionOutput)
pub mod update_primary_region_output {
    /// A builder for [`UpdatePrimaryRegionOutput`](crate::output::UpdatePrimaryRegionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdatePrimaryRegionOutput`](crate::output::UpdatePrimaryRegionOutput)
        pub fn build(self) -> crate::output::UpdatePrimaryRegionOutput {
            crate::output::UpdatePrimaryRegionOutput {}
        }
    }
}
impl UpdatePrimaryRegionOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePrimaryRegionOutput`](crate::output::UpdatePrimaryRegionOutput)
    pub fn builder() -> crate::output::update_primary_region_output::Builder {
        crate::output::update_primary_region_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateKeyDescriptionOutput {}
impl std::fmt::Debug for UpdateKeyDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateKeyDescriptionOutput");
        formatter.finish()
    }
}
/// See [`UpdateKeyDescriptionOutput`](crate::output::UpdateKeyDescriptionOutput)
pub mod update_key_description_output {
    /// A builder for [`UpdateKeyDescriptionOutput`](crate::output::UpdateKeyDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateKeyDescriptionOutput`](crate::output::UpdateKeyDescriptionOutput)
        pub fn build(self) -> crate::output::UpdateKeyDescriptionOutput {
            crate::output::UpdateKeyDescriptionOutput {}
        }
    }
}
impl UpdateKeyDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateKeyDescriptionOutput`](crate::output::UpdateKeyDescriptionOutput)
    pub fn builder() -> crate::output::update_key_description_output::Builder {
        crate::output::update_key_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomKeyStoreOutput {}
impl std::fmt::Debug for UpdateCustomKeyStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomKeyStoreOutput");
        formatter.finish()
    }
}
/// See [`UpdateCustomKeyStoreOutput`](crate::output::UpdateCustomKeyStoreOutput)
pub mod update_custom_key_store_output {
    /// A builder for [`UpdateCustomKeyStoreOutput`](crate::output::UpdateCustomKeyStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCustomKeyStoreOutput`](crate::output::UpdateCustomKeyStoreOutput)
        pub fn build(self) -> crate::output::UpdateCustomKeyStoreOutput {
            crate::output::UpdateCustomKeyStoreOutput {}
        }
    }
}
impl UpdateCustomKeyStoreOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCustomKeyStoreOutput`](crate::output::UpdateCustomKeyStoreOutput)
    pub fn builder() -> crate::output::update_custom_key_store_output::Builder {
        crate::output::update_custom_key_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAliasOutput {}
impl std::fmt::Debug for UpdateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAliasOutput");
        formatter.finish()
    }
}
/// See [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
pub mod update_alias_output {
    /// A builder for [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
        pub fn build(self) -> crate::output::UpdateAliasOutput {
            crate::output::UpdateAliasOutput {}
        }
    }
}
impl UpdateAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    pub fn builder() -> crate::output::update_alias_output::Builder {
        crate::output::update_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The cryptographic signature that was generated for the message. </p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is
    /// defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC
    /// 8017</a>.</p>
    /// </li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or
    /// <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as
    /// defined by ANS X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>.
    /// This is the most commonly used signature format and is appropriate for most uses.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub signature: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub signing_algorithm: std::option::Option<crate::model::SigningAlgorithmSpec>,
}
impl SignOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The cryptographic signature that was generated for the message. </p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is
    /// defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC
    /// 8017</a>.</p>
    /// </li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or
    /// <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as
    /// defined by ANS X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>.
    /// This is the most commonly used signature format and is appropriate for most uses.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn signature(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.signature.as_ref()
    }
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub fn signing_algorithm(&self) -> std::option::Option<&crate::model::SigningAlgorithmSpec> {
        self.signing_algorithm.as_ref()
    }
}
impl std::fmt::Debug for SignOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("signature", &self.signature);
        formatter.field("signing_algorithm", &self.signing_algorithm);
        formatter.finish()
    }
}
/// See [`SignOutput`](crate::output::SignOutput)
pub mod sign_output {
    /// A builder for [`SignOutput`](crate::output::SignOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) signature: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) signing_algorithm: std::option::Option<crate::model::SigningAlgorithmSpec>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The cryptographic signature that was generated for the message. </p>
        /// <ul>
        /// <li>
        /// <p>When used with the supported RSA signing algorithms, the encoding of this value is
        /// defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC
        /// 8017</a>.</p>
        /// </li>
        /// <li>
        /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or
        /// <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as
        /// defined by ANS X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>.
        /// This is the most commonly used signature format and is appropriate for most uses.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn signature(mut self, input: aws_smithy_types::Blob) -> Self {
            self.signature = Some(input);
            self
        }
        /// <p>The cryptographic signature that was generated for the message. </p>
        /// <ul>
        /// <li>
        /// <p>When used with the supported RSA signing algorithms, the encoding of this value is
        /// defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC
        /// 8017</a>.</p>
        /// </li>
        /// <li>
        /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or
        /// <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as
        /// defined by ANS X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>.
        /// This is the most commonly used signature format and is appropriate for most uses.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_signature(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.signature = input;
            self
        }
        /// <p>The signing algorithm that was used to sign the message.</p>
        pub fn signing_algorithm(mut self, input: crate::model::SigningAlgorithmSpec) -> Self {
            self.signing_algorithm = Some(input);
            self
        }
        /// <p>The signing algorithm that was used to sign the message.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<crate::model::SigningAlgorithmSpec>,
        ) -> Self {
            self.signing_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`SignOutput`](crate::output::SignOutput)
        pub fn build(self) -> crate::output::SignOutput {
            crate::output::SignOutput {
                key_id: self.key_id,
                signature: self.signature,
                signing_algorithm: self.signing_algorithm,
            }
        }
    }
}
impl SignOutput {
    /// Creates a new builder-style object to manufacture [`SignOutput`](crate::output::SignOutput)
    pub fn builder() -> crate::output::sign_output::Builder {
        crate::output::sign_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleKeyDeletionOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The date and time after which KMS deletes the KMS key.</p>
    /// <p>If the KMS key is a multi-Region primary key with replica keys, this field does not
    /// appear. The deletion date for the primary key isn't known until its last replica key is
    /// deleted.</p>
    pub deletion_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the KMS key.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub key_state: std::option::Option<crate::model::KeyState>,
    /// <p>The waiting period before the KMS key is deleted. </p>
    /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when
    /// the last of its replica keys is deleted. Otherwise, the waiting period begins
    /// immediately.</p>
    pub pending_window_in_days: std::option::Option<i32>,
}
impl ScheduleKeyDeletionOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The date and time after which KMS deletes the KMS key.</p>
    /// <p>If the KMS key is a multi-Region primary key with replica keys, this field does not
    /// appear. The deletion date for the primary key isn't known until its last replica key is
    /// deleted.</p>
    pub fn deletion_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.deletion_date.as_ref()
    }
    /// <p>The current status of the KMS key.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>Key Management Service Developer Guide</i>.</p>
    pub fn key_state(&self) -> std::option::Option<&crate::model::KeyState> {
        self.key_state.as_ref()
    }
    /// <p>The waiting period before the KMS key is deleted. </p>
    /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when
    /// the last of its replica keys is deleted. Otherwise, the waiting period begins
    /// immediately.</p>
    pub fn pending_window_in_days(&self) -> std::option::Option<i32> {
        self.pending_window_in_days
    }
}
impl std::fmt::Debug for ScheduleKeyDeletionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleKeyDeletionOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("deletion_date", &self.deletion_date);
        formatter.field("key_state", &self.key_state);
        formatter.field("pending_window_in_days", &self.pending_window_in_days);
        formatter.finish()
    }
}
/// See [`ScheduleKeyDeletionOutput`](crate::output::ScheduleKeyDeletionOutput)
pub mod schedule_key_deletion_output {
    /// A builder for [`ScheduleKeyDeletionOutput`](crate::output::ScheduleKeyDeletionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) deletion_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) key_state: std::option::Option<crate::model::KeyState>,
        pub(crate) pending_window_in_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is scheduled.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The date and time after which KMS deletes the KMS key.</p>
        /// <p>If the KMS key is a multi-Region primary key with replica keys, this field does not
        /// appear. The deletion date for the primary key isn't known until its last replica key is
        /// deleted.</p>
        pub fn deletion_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deletion_date = Some(input);
            self
        }
        /// <p>The date and time after which KMS deletes the KMS key.</p>
        /// <p>If the KMS key is a multi-Region primary key with replica keys, this field does not
        /// appear. The deletion date for the primary key isn't known until its last replica key is
        /// deleted.</p>
        pub fn set_deletion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deletion_date = input;
            self
        }
        /// <p>The current status of the KMS key.</p>
        /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
        /// key</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn key_state(mut self, input: crate::model::KeyState) -> Self {
            self.key_state = Some(input);
            self
        }
        /// <p>The current status of the KMS key.</p>
        /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
        /// key</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_key_state(mut self, input: std::option::Option<crate::model::KeyState>) -> Self {
            self.key_state = input;
            self
        }
        /// <p>The waiting period before the KMS key is deleted. </p>
        /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when
        /// the last of its replica keys is deleted. Otherwise, the waiting period begins
        /// immediately.</p>
        pub fn pending_window_in_days(mut self, input: i32) -> Self {
            self.pending_window_in_days = Some(input);
            self
        }
        /// <p>The waiting period before the KMS key is deleted. </p>
        /// <p>If the KMS key is a multi-Region primary key with replicas, the waiting period begins when
        /// the last of its replica keys is deleted. Otherwise, the waiting period begins
        /// immediately.</p>
        pub fn set_pending_window_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_window_in_days = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleKeyDeletionOutput`](crate::output::ScheduleKeyDeletionOutput)
        pub fn build(self) -> crate::output::ScheduleKeyDeletionOutput {
            crate::output::ScheduleKeyDeletionOutput {
                key_id: self.key_id,
                deletion_date: self.deletion_date,
                key_state: self.key_state,
                pending_window_in_days: self.pending_window_in_days,
            }
        }
    }
}
impl ScheduleKeyDeletionOutput {
    /// Creates a new builder-style object to manufacture [`ScheduleKeyDeletionOutput`](crate::output::ScheduleKeyDeletionOutput)
    pub fn builder() -> crate::output::schedule_key_deletion_output::Builder {
        crate::output::schedule_key_deletion_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeGrantOutput {}
impl std::fmt::Debug for RevokeGrantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeGrantOutput");
        formatter.finish()
    }
}
/// See [`RevokeGrantOutput`](crate::output::RevokeGrantOutput)
pub mod revoke_grant_output {
    /// A builder for [`RevokeGrantOutput`](crate::output::RevokeGrantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RevokeGrantOutput`](crate::output::RevokeGrantOutput)
        pub fn build(self) -> crate::output::RevokeGrantOutput {
            crate::output::RevokeGrantOutput {}
        }
    }
}
impl RevokeGrantOutput {
    /// Creates a new builder-style object to manufacture [`RevokeGrantOutput`](crate::output::RevokeGrantOutput)
    pub fn builder() -> crate::output::revoke_grant_output::Builder {
        crate::output::revoke_grant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetireGrantOutput {}
impl std::fmt::Debug for RetireGrantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetireGrantOutput");
        formatter.finish()
    }
}
/// See [`RetireGrantOutput`](crate::output::RetireGrantOutput)
pub mod retire_grant_output {
    /// A builder for [`RetireGrantOutput`](crate::output::RetireGrantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RetireGrantOutput`](crate::output::RetireGrantOutput)
        pub fn build(self) -> crate::output::RetireGrantOutput {
            crate::output::RetireGrantOutput {}
        }
    }
}
impl RetireGrantOutput {
    /// Creates a new builder-style object to manufacture [`RetireGrantOutput`](crate::output::RetireGrantOutput)
    pub fn builder() -> crate::output::retire_grant_output::Builder {
        crate::output::retire_grant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicateKeyOutput {
    /// <p>Displays details about the new replica key, including its Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) and
    /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. It also
    /// includes the ARN and Amazon Web Services Region of its primary key and other replica keys.</p>
    pub replica_key_metadata: std::option::Option<crate::model::KeyMetadata>,
    /// <p>The key policy of the new replica key. The value is a key policy document in JSON
    /// format.</p>
    pub replica_policy: std::option::Option<std::string::String>,
    /// <p>The tags on the new replica key. The value is a list of tag key and tag value
    /// pairs.</p>
    pub replica_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ReplicateKeyOutput {
    /// <p>Displays details about the new replica key, including its Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) and
    /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. It also
    /// includes the ARN and Amazon Web Services Region of its primary key and other replica keys.</p>
    pub fn replica_key_metadata(&self) -> std::option::Option<&crate::model::KeyMetadata> {
        self.replica_key_metadata.as_ref()
    }
    /// <p>The key policy of the new replica key. The value is a key policy document in JSON
    /// format.</p>
    pub fn replica_policy(&self) -> std::option::Option<&str> {
        self.replica_policy.as_deref()
    }
    /// <p>The tags on the new replica key. The value is a list of tag key and tag value
    /// pairs.</p>
    pub fn replica_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.replica_tags.as_deref()
    }
}
impl std::fmt::Debug for ReplicateKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicateKeyOutput");
        formatter.field("replica_key_metadata", &self.replica_key_metadata);
        formatter.field("replica_policy", &self.replica_policy);
        formatter.field("replica_tags", &self.replica_tags);
        formatter.finish()
    }
}
/// See [`ReplicateKeyOutput`](crate::output::ReplicateKeyOutput)
pub mod replicate_key_output {
    /// A builder for [`ReplicateKeyOutput`](crate::output::ReplicateKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replica_key_metadata: std::option::Option<crate::model::KeyMetadata>,
        pub(crate) replica_policy: std::option::Option<std::string::String>,
        pub(crate) replica_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Displays details about the new replica key, including its Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) and
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. It also
        /// includes the ARN and Amazon Web Services Region of its primary key and other replica keys.</p>
        pub fn replica_key_metadata(mut self, input: crate::model::KeyMetadata) -> Self {
            self.replica_key_metadata = Some(input);
            self
        }
        /// <p>Displays details about the new replica key, including its Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) and
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">key state</a>. It also
        /// includes the ARN and Amazon Web Services Region of its primary key and other replica keys.</p>
        pub fn set_replica_key_metadata(
            mut self,
            input: std::option::Option<crate::model::KeyMetadata>,
        ) -> Self {
            self.replica_key_metadata = input;
            self
        }
        /// <p>The key policy of the new replica key. The value is a key policy document in JSON
        /// format.</p>
        pub fn replica_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.replica_policy = Some(input.into());
            self
        }
        /// <p>The key policy of the new replica key. The value is a key policy document in JSON
        /// format.</p>
        pub fn set_replica_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replica_policy = input;
            self
        }
        /// Appends an item to `replica_tags`.
        ///
        /// To override the contents of this collection use [`set_replica_tags`](Self::set_replica_tags).
        ///
        /// <p>The tags on the new replica key. The value is a list of tag key and tag value
        /// pairs.</p>
        pub fn replica_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.replica_tags.unwrap_or_default();
            v.push(input.into());
            self.replica_tags = Some(v);
            self
        }
        /// <p>The tags on the new replica key. The value is a list of tag key and tag value
        /// pairs.</p>
        pub fn set_replica_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.replica_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicateKeyOutput`](crate::output::ReplicateKeyOutput)
        pub fn build(self) -> crate::output::ReplicateKeyOutput {
            crate::output::ReplicateKeyOutput {
                replica_key_metadata: self.replica_key_metadata,
                replica_policy: self.replica_policy,
                replica_tags: self.replica_tags,
            }
        }
    }
}
impl ReplicateKeyOutput {
    /// Creates a new builder-style object to manufacture [`ReplicateKeyOutput`](crate::output::ReplicateKeyOutput)
    pub fn builder() -> crate::output::replicate_key_output::Builder {
        crate::output::replicate_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReEncryptOutput {
    /// <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
    pub source_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The encryption algorithm that was used to decrypt the ciphertext before it was
    /// reencrypted.</p>
    pub source_encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
    /// <p>The encryption algorithm that was used to reencrypt the data.</p>
    pub destination_encryption_algorithm:
        std::option::Option<crate::model::EncryptionAlgorithmSpec>,
}
impl ReEncryptOutput {
    /// <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ciphertext_blob.as_ref()
    }
    /// <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
    pub fn source_key_id(&self) -> std::option::Option<&str> {
        self.source_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The encryption algorithm that was used to decrypt the ciphertext before it was
    /// reencrypted.</p>
    pub fn source_encryption_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAlgorithmSpec> {
        self.source_encryption_algorithm.as_ref()
    }
    /// <p>The encryption algorithm that was used to reencrypt the data.</p>
    pub fn destination_encryption_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAlgorithmSpec> {
        self.destination_encryption_algorithm.as_ref()
    }
}
impl std::fmt::Debug for ReEncryptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReEncryptOutput");
        formatter.field("ciphertext_blob", &self.ciphertext_blob);
        formatter.field("source_key_id", &self.source_key_id);
        formatter.field("key_id", &self.key_id);
        formatter.field(
            "source_encryption_algorithm",
            &self.source_encryption_algorithm,
        );
        formatter.field(
            "destination_encryption_algorithm",
            &self.destination_encryption_algorithm,
        );
        formatter.finish()
    }
}
/// See [`ReEncryptOutput`](crate::output::ReEncryptOutput)
pub mod re_encrypt_output {
    /// A builder for [`ReEncryptOutput`](crate::output::ReEncryptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) source_key_id: std::option::Option<std::string::String>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) source_encryption_algorithm:
            std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        pub(crate) destination_encryption_algorithm:
            std::option::Option<crate::model::EncryptionAlgorithmSpec>,
    }
    impl Builder {
        /// <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ciphertext_blob = Some(input);
            self
        }
        /// <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ciphertext_blob = input;
            self
        }
        /// <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
        pub fn source_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_key_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
        pub fn set_source_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The encryption algorithm that was used to decrypt the ciphertext before it was
        /// reencrypted.</p>
        pub fn source_encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.source_encryption_algorithm = Some(input);
            self
        }
        /// <p>The encryption algorithm that was used to decrypt the ciphertext before it was
        /// reencrypted.</p>
        pub fn set_source_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.source_encryption_algorithm = input;
            self
        }
        /// <p>The encryption algorithm that was used to reencrypt the data.</p>
        pub fn destination_encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.destination_encryption_algorithm = Some(input);
            self
        }
        /// <p>The encryption algorithm that was used to reencrypt the data.</p>
        pub fn set_destination_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.destination_encryption_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`ReEncryptOutput`](crate::output::ReEncryptOutput)
        pub fn build(self) -> crate::output::ReEncryptOutput {
            crate::output::ReEncryptOutput {
                ciphertext_blob: self.ciphertext_blob,
                source_key_id: self.source_key_id,
                key_id: self.key_id,
                source_encryption_algorithm: self.source_encryption_algorithm,
                destination_encryption_algorithm: self.destination_encryption_algorithm,
            }
        }
    }
}
impl ReEncryptOutput {
    /// Creates a new builder-style object to manufacture [`ReEncryptOutput`](crate::output::ReEncryptOutput)
    pub fn builder() -> crate::output::re_encrypt_output::Builder {
        crate::output::re_encrypt_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutKeyPolicyOutput {}
impl std::fmt::Debug for PutKeyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutKeyPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutKeyPolicyOutput`](crate::output::PutKeyPolicyOutput)
pub mod put_key_policy_output {
    /// A builder for [`PutKeyPolicyOutput`](crate::output::PutKeyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutKeyPolicyOutput`](crate::output::PutKeyPolicyOutput)
        pub fn build(self) -> crate::output::PutKeyPolicyOutput {
            crate::output::PutKeyPolicyOutput {}
        }
    }
}
impl PutKeyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutKeyPolicyOutput`](crate::output::PutKeyPolicyOutput)
    pub fn builder() -> crate::output::put_key_policy_output::Builder {
        crate::output::put_key_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRetirableGrantsOutput {
    /// <p>A list of grants.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListRetirableGrantsOutput {
    /// <p>A list of grants.</p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::GrantListEntry]> {
        self.grants.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListRetirableGrantsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRetirableGrantsOutput");
        formatter.field("grants", &self.grants);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListRetirableGrantsOutput`](crate::output::ListRetirableGrantsOutput)
pub mod list_retirable_grants_output {
    /// A builder for [`ListRetirableGrantsOutput`](crate::output::ListRetirableGrantsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of grants.</p>
        pub fn grants(mut self, input: impl Into<crate::model::GrantListEntry>) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input.into());
            self.grants = Some(v);
            self
        }
        /// <p>A list of grants.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRetirableGrantsOutput`](crate::output::ListRetirableGrantsOutput)
        pub fn build(self) -> crate::output::ListRetirableGrantsOutput {
            crate::output::ListRetirableGrantsOutput {
                grants: self.grants,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListRetirableGrantsOutput {
    /// Creates a new builder-style object to manufacture [`ListRetirableGrantsOutput`](crate::output::ListRetirableGrantsOutput)
    pub fn builder() -> crate::output::list_retirable_grants_output::Builder {
        crate::output::list_retirable_grants_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceTagsOutput {
    /// <p>A list of tags. Each tag consists of a tag key and a tag value.</p>
    /// <note>
    /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    /// <p>Do not assume or infer any information from this value.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListResourceTagsOutput {
    /// <p>A list of tags. Each tag consists of a tag key and a tag value.</p>
    /// <note>
    /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    /// <p>Do not assume or infer any information from this value.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListResourceTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListResourceTagsOutput`](crate::output::ListResourceTagsOutput)
pub mod list_resource_tags_output {
    /// A builder for [`ListResourceTagsOutput`](crate::output::ListResourceTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. Each tag consists of a tag key and a tag value.</p>
        /// <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. Each tag consists of a tag key and a tag value.</p>
        /// <note>
        /// <p>Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">Using ABAC in KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        /// <p>Do not assume or infer any information from this value.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        /// <p>Do not assume or infer any information from this value.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceTagsOutput`](crate::output::ListResourceTagsOutput)
        pub fn build(self) -> crate::output::ListResourceTagsOutput {
            crate::output::ListResourceTagsOutput {
                tags: self.tags,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListResourceTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceTagsOutput`](crate::output::ListResourceTagsOutput)
    pub fn builder() -> crate::output::list_resource_tags_output::Builder {
        crate::output::list_resource_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeysOutput {
    /// <p>A list of KMS keys.</p>
    pub keys: std::option::Option<std::vec::Vec<crate::model::KeyListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListKeysOutput {
    /// <p>A list of KMS keys.</p>
    pub fn keys(&self) -> std::option::Option<&[crate::model::KeyListEntry]> {
        self.keys.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeysOutput");
        formatter.field("keys", &self.keys);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListKeysOutput`](crate::output::ListKeysOutput)
pub mod list_keys_output {
    /// A builder for [`ListKeysOutput`](crate::output::ListKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keys: std::option::Option<std::vec::Vec<crate::model::KeyListEntry>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of KMS keys.</p>
        pub fn keys(mut self, input: impl Into<crate::model::KeyListEntry>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>A list of KMS keys.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyListEntry>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeysOutput`](crate::output::ListKeysOutput)
        pub fn build(self) -> crate::output::ListKeysOutput {
            crate::output::ListKeysOutput {
                keys: self.keys,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListKeysOutput`](crate::output::ListKeysOutput)
    pub fn builder() -> crate::output::list_keys_output::Builder {
        crate::output::list_keys_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyPoliciesOutput {
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListKeyPoliciesOutput {
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListKeyPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyPoliciesOutput");
        formatter.field("policy_names", &self.policy_names);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListKeyPoliciesOutput`](crate::output::ListKeyPoliciesOutput)
pub mod list_key_policies_output {
    /// A builder for [`ListKeyPoliciesOutput`](crate::output::ListKeyPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyPoliciesOutput`](crate::output::ListKeyPoliciesOutput)
        pub fn build(self) -> crate::output::ListKeyPoliciesOutput {
            crate::output::ListKeyPoliciesOutput {
                policy_names: self.policy_names,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListKeyPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListKeyPoliciesOutput`](crate::output::ListKeyPoliciesOutput)
    pub fn builder() -> crate::output::list_key_policies_output::Builder {
        crate::output::list_key_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGrantsOutput {
    /// <p>A list of grants.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListGrantsOutput {
    /// <p>A list of grants.</p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::GrantListEntry]> {
        self.grants.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListGrantsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGrantsOutput");
        formatter.field("grants", &self.grants);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListGrantsOutput`](crate::output::ListGrantsOutput)
pub mod list_grants_output {
    /// A builder for [`ListGrantsOutput`](crate::output::ListGrantsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of grants.</p>
        pub fn grants(mut self, input: impl Into<crate::model::GrantListEntry>) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input.into());
            self.grants = Some(v);
            self
        }
        /// <p>A list of grants.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantListEntry>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGrantsOutput`](crate::output::ListGrantsOutput)
        pub fn build(self) -> crate::output::ListGrantsOutput {
            crate::output::ListGrantsOutput {
                grants: self.grants,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListGrantsOutput {
    /// Creates a new builder-style object to manufacture [`ListGrantsOutput`](crate::output::ListGrantsOutput)
    pub fn builder() -> crate::output::list_grants_output::Builder {
        crate::output::list_grants_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAliasesOutput {
    /// <p>A list of aliases.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::AliasListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl ListAliasesOutput {
    /// <p>A list of aliases.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::AliasListEntry]> {
        self.aliases.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for ListAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAliasesOutput");
        formatter.field("aliases", &self.aliases);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ListAliasesOutput`](crate::output::ListAliasesOutput)
pub mod list_aliases_output {
    /// A builder for [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::AliasListEntry>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>A list of aliases.</p>
        pub fn aliases(mut self, input: impl Into<crate::model::AliasListEntry>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>A list of aliases.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasListEntry>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesOutput`](crate::output::ListAliasesOutput)
        pub fn build(self) -> crate::output::ListAliasesOutput {
            crate::output::ListAliasesOutput {
                aliases: self.aliases,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ListAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    pub fn builder() -> crate::output::list_aliases_output::Builder {
        crate::output::list_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportKeyMaterialOutput {}
impl std::fmt::Debug for ImportKeyMaterialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportKeyMaterialOutput");
        formatter.finish()
    }
}
/// See [`ImportKeyMaterialOutput`](crate::output::ImportKeyMaterialOutput)
pub mod import_key_material_output {
    /// A builder for [`ImportKeyMaterialOutput`](crate::output::ImportKeyMaterialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ImportKeyMaterialOutput`](crate::output::ImportKeyMaterialOutput)
        pub fn build(self) -> crate::output::ImportKeyMaterialOutput {
            crate::output::ImportKeyMaterialOutput {}
        }
    }
}
impl ImportKeyMaterialOutput {
    /// Creates a new builder-style object to manufacture [`ImportKeyMaterialOutput`](crate::output::ImportKeyMaterialOutput)
    pub fn builder() -> crate::output::import_key_material_output::Builder {
        crate::output::import_key_material_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicKeyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key from which the public key was
    /// downloaded.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The exported public key. </p>
    /// <p>The value is a DER-encoded X.509 public key, also known as
    /// <code>SubjectPublicKeyInfo</code> (SPKI), as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    /// <p></p>
    pub public_key: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Instead, use the <code>KeySpec</code> field in the <code>GetPublicKey</code>
    /// response.</p>
    /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same
    /// value. We recommend that you use the <code>KeySpec</code> field in your code. However, to
    /// avoid breaking changes, KMS will support both fields.</p>
    pub customer_master_key_spec: std::option::Option<crate::model::CustomerMasterKeySpec>,
    /// <p>The type of the of the public key that was downloaded.</p>
    pub key_spec: std::option::Option<crate::model::KeySpec>,
    /// <p>The permitted use of the public key. Valid values are <code>ENCRYPT_DECRYPT</code> or
    /// <code>SIGN_VERIFY</code>. </p>
    /// <p>This information is critical. If a public key with <code>SIGN_VERIFY</code> key usage
    /// encrypts data outside of KMS, the ciphertext cannot be decrypted. </p>
    pub key_usage: std::option::Option<crate::model::KeyUsageType>,
    /// <p>The encryption algorithms that KMS supports for this key. </p>
    /// <p>This information is critical. If a public key encrypts data outside of KMS by using an
    /// unsupported encryption algorithm, the ciphertext cannot be decrypted. </p>
    /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
    /// is <code>ENCRYPT_DECRYPT</code>.</p>
    pub encryption_algorithms:
        std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
    /// <p>The signing algorithms that KMS supports for this key.</p>
    /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
    /// is <code>SIGN_VERIFY</code>.</p>
    pub signing_algorithms: std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
}
impl GetPublicKeyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key from which the public key was
    /// downloaded.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The exported public key. </p>
    /// <p>The value is a DER-encoded X.509 public key, also known as
    /// <code>SubjectPublicKeyInfo</code> (SPKI), as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    /// <p></p>
    pub fn public_key(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.public_key.as_ref()
    }
    /// <p>Instead, use the <code>KeySpec</code> field in the <code>GetPublicKey</code>
    /// response.</p>
    /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same
    /// value. We recommend that you use the <code>KeySpec</code> field in your code. However, to
    /// avoid breaking changes, KMS will support both fields.</p>
    pub fn customer_master_key_spec(
        &self,
    ) -> std::option::Option<&crate::model::CustomerMasterKeySpec> {
        self.customer_master_key_spec.as_ref()
    }
    /// <p>The type of the of the public key that was downloaded.</p>
    pub fn key_spec(&self) -> std::option::Option<&crate::model::KeySpec> {
        self.key_spec.as_ref()
    }
    /// <p>The permitted use of the public key. Valid values are <code>ENCRYPT_DECRYPT</code> or
    /// <code>SIGN_VERIFY</code>. </p>
    /// <p>This information is critical. If a public key with <code>SIGN_VERIFY</code> key usage
    /// encrypts data outside of KMS, the ciphertext cannot be decrypted. </p>
    pub fn key_usage(&self) -> std::option::Option<&crate::model::KeyUsageType> {
        self.key_usage.as_ref()
    }
    /// <p>The encryption algorithms that KMS supports for this key. </p>
    /// <p>This information is critical. If a public key encrypts data outside of KMS by using an
    /// unsupported encryption algorithm, the ciphertext cannot be decrypted. </p>
    /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
    /// is <code>ENCRYPT_DECRYPT</code>.</p>
    pub fn encryption_algorithms(
        &self,
    ) -> std::option::Option<&[crate::model::EncryptionAlgorithmSpec]> {
        self.encryption_algorithms.as_deref()
    }
    /// <p>The signing algorithms that KMS supports for this key.</p>
    /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
    /// is <code>SIGN_VERIFY</code>.</p>
    pub fn signing_algorithms(&self) -> std::option::Option<&[crate::model::SigningAlgorithmSpec]> {
        self.signing_algorithms.as_deref()
    }
}
impl std::fmt::Debug for GetPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicKeyOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("public_key", &self.public_key);
        formatter.field("customer_master_key_spec", &self.customer_master_key_spec);
        formatter.field("key_spec", &self.key_spec);
        formatter.field("key_usage", &self.key_usage);
        formatter.field("encryption_algorithms", &self.encryption_algorithms);
        formatter.field("signing_algorithms", &self.signing_algorithms);
        formatter.finish()
    }
}
/// See [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
pub mod get_public_key_output {
    /// A builder for [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) public_key: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) customer_master_key_spec:
            std::option::Option<crate::model::CustomerMasterKeySpec>,
        pub(crate) key_spec: std::option::Option<crate::model::KeySpec>,
        pub(crate) key_usage: std::option::Option<crate::model::KeyUsageType>,
        pub(crate) encryption_algorithms:
            std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
        pub(crate) signing_algorithms:
            std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key from which the public key was
        /// downloaded.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key from which the public key was
        /// downloaded.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The exported public key. </p>
        /// <p>The value is a DER-encoded X.509 public key, also known as
        /// <code>SubjectPublicKeyInfo</code> (SPKI), as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        /// <p></p>
        pub fn public_key(mut self, input: aws_smithy_types::Blob) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The exported public key. </p>
        /// <p>The value is a DER-encoded X.509 public key, also known as
        /// <code>SubjectPublicKeyInfo</code> (SPKI), as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        /// <p></p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> field in the <code>GetPublicKey</code>
        /// response.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same
        /// value. We recommend that you use the <code>KeySpec</code> field in your code. However, to
        /// avoid breaking changes, KMS will support both fields.</p>
        pub fn customer_master_key_spec(
            mut self,
            input: crate::model::CustomerMasterKeySpec,
        ) -> Self {
            self.customer_master_key_spec = Some(input);
            self
        }
        /// <p>Instead, use the <code>KeySpec</code> field in the <code>GetPublicKey</code>
        /// response.</p>
        /// <p>The <code>KeySpec</code> and <code>CustomerMasterKeySpec</code> fields have the same
        /// value. We recommend that you use the <code>KeySpec</code> field in your code. However, to
        /// avoid breaking changes, KMS will support both fields.</p>
        pub fn set_customer_master_key_spec(
            mut self,
            input: std::option::Option<crate::model::CustomerMasterKeySpec>,
        ) -> Self {
            self.customer_master_key_spec = input;
            self
        }
        /// <p>The type of the of the public key that was downloaded.</p>
        pub fn key_spec(mut self, input: crate::model::KeySpec) -> Self {
            self.key_spec = Some(input);
            self
        }
        /// <p>The type of the of the public key that was downloaded.</p>
        pub fn set_key_spec(mut self, input: std::option::Option<crate::model::KeySpec>) -> Self {
            self.key_spec = input;
            self
        }
        /// <p>The permitted use of the public key. Valid values are <code>ENCRYPT_DECRYPT</code> or
        /// <code>SIGN_VERIFY</code>. </p>
        /// <p>This information is critical. If a public key with <code>SIGN_VERIFY</code> key usage
        /// encrypts data outside of KMS, the ciphertext cannot be decrypted. </p>
        pub fn key_usage(mut self, input: crate::model::KeyUsageType) -> Self {
            self.key_usage = Some(input);
            self
        }
        /// <p>The permitted use of the public key. Valid values are <code>ENCRYPT_DECRYPT</code> or
        /// <code>SIGN_VERIFY</code>. </p>
        /// <p>This information is critical. If a public key with <code>SIGN_VERIFY</code> key usage
        /// encrypts data outside of KMS, the ciphertext cannot be decrypted. </p>
        pub fn set_key_usage(
            mut self,
            input: std::option::Option<crate::model::KeyUsageType>,
        ) -> Self {
            self.key_usage = input;
            self
        }
        /// Appends an item to `encryption_algorithms`.
        ///
        /// To override the contents of this collection use [`set_encryption_algorithms`](Self::set_encryption_algorithms).
        ///
        /// <p>The encryption algorithms that KMS supports for this key. </p>
        /// <p>This information is critical. If a public key encrypts data outside of KMS by using an
        /// unsupported encryption algorithm, the ciphertext cannot be decrypted. </p>
        /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
        /// is <code>ENCRYPT_DECRYPT</code>.</p>
        pub fn encryption_algorithms(
            mut self,
            input: impl Into<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            let mut v = self.encryption_algorithms.unwrap_or_default();
            v.push(input.into());
            self.encryption_algorithms = Some(v);
            self
        }
        /// <p>The encryption algorithms that KMS supports for this key. </p>
        /// <p>This information is critical. If a public key encrypts data outside of KMS by using an
        /// unsupported encryption algorithm, the ciphertext cannot be decrypted. </p>
        /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
        /// is <code>ENCRYPT_DECRYPT</code>.</p>
        pub fn set_encryption_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithmSpec>>,
        ) -> Self {
            self.encryption_algorithms = input;
            self
        }
        /// Appends an item to `signing_algorithms`.
        ///
        /// To override the contents of this collection use [`set_signing_algorithms`](Self::set_signing_algorithms).
        ///
        /// <p>The signing algorithms that KMS supports for this key.</p>
        /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
        /// is <code>SIGN_VERIFY</code>.</p>
        pub fn signing_algorithms(
            mut self,
            input: impl Into<crate::model::SigningAlgorithmSpec>,
        ) -> Self {
            let mut v = self.signing_algorithms.unwrap_or_default();
            v.push(input.into());
            self.signing_algorithms = Some(v);
            self
        }
        /// <p>The signing algorithms that KMS supports for this key.</p>
        /// <p>This field appears in the response only when the <code>KeyUsage</code> of the public key
        /// is <code>SIGN_VERIFY</code>.</p>
        pub fn set_signing_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningAlgorithmSpec>>,
        ) -> Self {
            self.signing_algorithms = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
        pub fn build(self) -> crate::output::GetPublicKeyOutput {
            crate::output::GetPublicKeyOutput {
                key_id: self.key_id,
                public_key: self.public_key,
                customer_master_key_spec: self.customer_master_key_spec,
                key_spec: self.key_spec,
                key_usage: self.key_usage,
                encryption_algorithms: self.encryption_algorithms,
                signing_algorithms: self.signing_algorithms,
            }
        }
    }
}
impl GetPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
    pub fn builder() -> crate::output::get_public_key_output::Builder {
        crate::output::get_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParametersForImportOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same KMS key specified in the <code>GetParametersForImport</code>
    /// request.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The import token to send in a subsequent <a>ImportKeyMaterial</a>
    /// request.</p>
    pub import_token: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.</p>
    pub public_key: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The time at which the import token and public key are no longer valid. After this time,
    /// you cannot use them to make an <a>ImportKeyMaterial</a> request and you must send
    /// another <code>GetParametersForImport</code> request to get new ones.</p>
    pub parameters_valid_to: std::option::Option<aws_smithy_types::Instant>,
}
impl GetParametersForImportOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same KMS key specified in the <code>GetParametersForImport</code>
    /// request.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The import token to send in a subsequent <a>ImportKeyMaterial</a>
    /// request.</p>
    pub fn import_token(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.import_token.as_ref()
    }
    /// <p>The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.</p>
    pub fn public_key(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.public_key.as_ref()
    }
    /// <p>The time at which the import token and public key are no longer valid. After this time,
    /// you cannot use them to make an <a>ImportKeyMaterial</a> request and you must send
    /// another <code>GetParametersForImport</code> request to get new ones.</p>
    pub fn parameters_valid_to(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.parameters_valid_to.as_ref()
    }
}
impl std::fmt::Debug for GetParametersForImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParametersForImportOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("import_token", &self.import_token);
        formatter.field("public_key", &"*** Sensitive Data Redacted ***");
        formatter.field("parameters_valid_to", &self.parameters_valid_to);
        formatter.finish()
    }
}
/// See [`GetParametersForImportOutput`](crate::output::GetParametersForImportOutput)
pub mod get_parameters_for_import_output {
    /// A builder for [`GetParametersForImportOutput`](crate::output::GetParametersForImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) import_token: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) public_key: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) parameters_valid_to: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same KMS key specified in the <code>GetParametersForImport</code>
        /// request.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <a>ImportKeyMaterial</a> request. This is the same KMS key specified in the <code>GetParametersForImport</code>
        /// request.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The import token to send in a subsequent <a>ImportKeyMaterial</a>
        /// request.</p>
        pub fn import_token(mut self, input: aws_smithy_types::Blob) -> Self {
            self.import_token = Some(input);
            self
        }
        /// <p>The import token to send in a subsequent <a>ImportKeyMaterial</a>
        /// request.</p>
        pub fn set_import_token(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.import_token = input;
            self
        }
        /// <p>The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.</p>
        pub fn public_key(mut self, input: aws_smithy_types::Blob) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key to use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The time at which the import token and public key are no longer valid. After this time,
        /// you cannot use them to make an <a>ImportKeyMaterial</a> request and you must send
        /// another <code>GetParametersForImport</code> request to get new ones.</p>
        pub fn parameters_valid_to(mut self, input: aws_smithy_types::Instant) -> Self {
            self.parameters_valid_to = Some(input);
            self
        }
        /// <p>The time at which the import token and public key are no longer valid. After this time,
        /// you cannot use them to make an <a>ImportKeyMaterial</a> request and you must send
        /// another <code>GetParametersForImport</code> request to get new ones.</p>
        pub fn set_parameters_valid_to(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.parameters_valid_to = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParametersForImportOutput`](crate::output::GetParametersForImportOutput)
        pub fn build(self) -> crate::output::GetParametersForImportOutput {
            crate::output::GetParametersForImportOutput {
                key_id: self.key_id,
                import_token: self.import_token,
                public_key: self.public_key,
                parameters_valid_to: self.parameters_valid_to,
            }
        }
    }
}
impl GetParametersForImportOutput {
    /// Creates a new builder-style object to manufacture [`GetParametersForImportOutput`](crate::output::GetParametersForImportOutput)
    pub fn builder() -> crate::output::get_parameters_for_import_output::Builder {
        crate::output::get_parameters_for_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyRotationStatusOutput {
    /// <p>A Boolean value that specifies whether key rotation is enabled.</p>
    pub key_rotation_enabled: bool,
}
impl GetKeyRotationStatusOutput {
    /// <p>A Boolean value that specifies whether key rotation is enabled.</p>
    pub fn key_rotation_enabled(&self) -> bool {
        self.key_rotation_enabled
    }
}
impl std::fmt::Debug for GetKeyRotationStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyRotationStatusOutput");
        formatter.field("key_rotation_enabled", &self.key_rotation_enabled);
        formatter.finish()
    }
}
/// See [`GetKeyRotationStatusOutput`](crate::output::GetKeyRotationStatusOutput)
pub mod get_key_rotation_status_output {
    /// A builder for [`GetKeyRotationStatusOutput`](crate::output::GetKeyRotationStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_rotation_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A Boolean value that specifies whether key rotation is enabled.</p>
        pub fn key_rotation_enabled(mut self, input: bool) -> Self {
            self.key_rotation_enabled = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether key rotation is enabled.</p>
        pub fn set_key_rotation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.key_rotation_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyRotationStatusOutput`](crate::output::GetKeyRotationStatusOutput)
        pub fn build(self) -> crate::output::GetKeyRotationStatusOutput {
            crate::output::GetKeyRotationStatusOutput {
                key_rotation_enabled: self.key_rotation_enabled.unwrap_or_default(),
            }
        }
    }
}
impl GetKeyRotationStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetKeyRotationStatusOutput`](crate::output::GetKeyRotationStatusOutput)
    pub fn builder() -> crate::output::get_key_rotation_status_output::Builder {
        crate::output::get_key_rotation_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyPolicyOutput {
    /// <p>A key policy document in JSON format.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetKeyPolicyOutput {
    /// <p>A key policy document in JSON format.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetKeyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetKeyPolicyOutput`](crate::output::GetKeyPolicyOutput)
pub mod get_key_policy_output {
    /// A builder for [`GetKeyPolicyOutput`](crate::output::GetKeyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A key policy document in JSON format.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A key policy document in JSON format.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyPolicyOutput`](crate::output::GetKeyPolicyOutput)
        pub fn build(self) -> crate::output::GetKeyPolicyOutput {
            crate::output::GetKeyPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetKeyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetKeyPolicyOutput`](crate::output::GetKeyPolicyOutput)
    pub fn builder() -> crate::output::get_key_policy_output::Builder {
        crate::output::get_key_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateRandomOutput {
    /// <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub plaintext: std::option::Option<aws_smithy_types::Blob>,
}
impl GenerateRandomOutput {
    /// <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn plaintext(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.plaintext.as_ref()
    }
}
impl std::fmt::Debug for GenerateRandomOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateRandomOutput");
        formatter.field("plaintext", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GenerateRandomOutput`](crate::output::GenerateRandomOutput)
pub mod generate_random_output {
    /// A builder for [`GenerateRandomOutput`](crate::output::GenerateRandomOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) plaintext: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn plaintext(mut self, input: aws_smithy_types::Blob) -> Self {
            self.plaintext = Some(input);
            self
        }
        /// <p>The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_plaintext(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.plaintext = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateRandomOutput`](crate::output::GenerateRandomOutput)
        pub fn build(self) -> crate::output::GenerateRandomOutput {
            crate::output::GenerateRandomOutput {
                plaintext: self.plaintext,
            }
        }
    }
}
impl GenerateRandomOutput {
    /// Creates a new builder-style object to manufacture [`GenerateRandomOutput`](crate::output::GenerateRandomOutput)
    pub fn builder() -> crate::output::generate_random_output::Builder {
        crate::output::generate_random_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateDataKeyWithoutPlaintextOutput {
    /// <p>The encrypted data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    pub key_id: std::option::Option<std::string::String>,
}
impl GenerateDataKeyWithoutPlaintextOutput {
    /// <p>The encrypted data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ciphertext_blob.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateDataKeyWithoutPlaintextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateDataKeyWithoutPlaintextOutput");
        formatter.field("ciphertext_blob", &self.ciphertext_blob);
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`GenerateDataKeyWithoutPlaintextOutput`](crate::output::GenerateDataKeyWithoutPlaintextOutput)
pub mod generate_data_key_without_plaintext_output {
    /// A builder for [`GenerateDataKeyWithoutPlaintextOutput`](crate::output::GenerateDataKeyWithoutPlaintextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encrypted data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ciphertext_blob = Some(input);
            self
        }
        /// <p>The encrypted data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ciphertext_blob = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateDataKeyWithoutPlaintextOutput`](crate::output::GenerateDataKeyWithoutPlaintextOutput)
        pub fn build(self) -> crate::output::GenerateDataKeyWithoutPlaintextOutput {
            crate::output::GenerateDataKeyWithoutPlaintextOutput {
                ciphertext_blob: self.ciphertext_blob,
                key_id: self.key_id,
            }
        }
    }
}
impl GenerateDataKeyWithoutPlaintextOutput {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyWithoutPlaintextOutput`](crate::output::GenerateDataKeyWithoutPlaintextOutput)
    pub fn builder() -> crate::output::generate_data_key_without_plaintext_output::Builder {
        crate::output::generate_data_key_without_plaintext_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateDataKeyPairWithoutPlaintextOutput {
    /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub private_key_ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The public key (in plaintext).</p>
    pub public_key: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The type of data key pair that was generated.</p>
    pub key_pair_spec: std::option::Option<crate::model::DataKeyPairSpec>,
}
impl GenerateDataKeyPairWithoutPlaintextOutput {
    /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn private_key_ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.private_key_ciphertext_blob.as_ref()
    }
    /// <p>The public key (in plaintext).</p>
    pub fn public_key(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.public_key.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The type of data key pair that was generated.</p>
    pub fn key_pair_spec(&self) -> std::option::Option<&crate::model::DataKeyPairSpec> {
        self.key_pair_spec.as_ref()
    }
}
impl std::fmt::Debug for GenerateDataKeyPairWithoutPlaintextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateDataKeyPairWithoutPlaintextOutput");
        formatter.field(
            "private_key_ciphertext_blob",
            &self.private_key_ciphertext_blob,
        );
        formatter.field("public_key", &self.public_key);
        formatter.field("key_id", &self.key_id);
        formatter.field("key_pair_spec", &self.key_pair_spec);
        formatter.finish()
    }
}
/// See [`GenerateDataKeyPairWithoutPlaintextOutput`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput)
pub mod generate_data_key_pair_without_plaintext_output {
    /// A builder for [`GenerateDataKeyPairWithoutPlaintextOutput`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) private_key_ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) public_key: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) key_pair_spec: std::option::Option<crate::model::DataKeyPairSpec>,
    }
    impl Builder {
        /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn private_key_ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.private_key_ciphertext_blob = Some(input);
            self
        }
        /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_private_key_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.private_key_ciphertext_blob = input;
            self
        }
        /// <p>The public key (in plaintext).</p>
        pub fn public_key(mut self, input: aws_smithy_types::Blob) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key (in plaintext).</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The type of data key pair that was generated.</p>
        pub fn key_pair_spec(mut self, input: crate::model::DataKeyPairSpec) -> Self {
            self.key_pair_spec = Some(input);
            self
        }
        /// <p>The type of data key pair that was generated.</p>
        pub fn set_key_pair_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeyPairSpec>,
        ) -> Self {
            self.key_pair_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateDataKeyPairWithoutPlaintextOutput`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput)
        pub fn build(self) -> crate::output::GenerateDataKeyPairWithoutPlaintextOutput {
            crate::output::GenerateDataKeyPairWithoutPlaintextOutput {
                private_key_ciphertext_blob: self.private_key_ciphertext_blob,
                public_key: self.public_key,
                key_id: self.key_id,
                key_pair_spec: self.key_pair_spec,
            }
        }
    }
}
impl GenerateDataKeyPairWithoutPlaintextOutput {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyPairWithoutPlaintextOutput`](crate::output::GenerateDataKeyPairWithoutPlaintextOutput)
    pub fn builder() -> crate::output::generate_data_key_pair_without_plaintext_output::Builder {
        crate::output::generate_data_key_pair_without_plaintext_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateDataKeyPairOutput {
    /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub private_key_ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub private_key_plaintext: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The public key (in plaintext).</p>
    pub public_key: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The type of data key pair that was generated.</p>
    pub key_pair_spec: std::option::Option<crate::model::DataKeyPairSpec>,
}
impl GenerateDataKeyPairOutput {
    /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn private_key_ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.private_key_ciphertext_blob.as_ref()
    }
    /// <p>The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn private_key_plaintext(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.private_key_plaintext.as_ref()
    }
    /// <p>The public key (in plaintext).</p>
    pub fn public_key(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.public_key.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The type of data key pair that was generated.</p>
    pub fn key_pair_spec(&self) -> std::option::Option<&crate::model::DataKeyPairSpec> {
        self.key_pair_spec.as_ref()
    }
}
impl std::fmt::Debug for GenerateDataKeyPairOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateDataKeyPairOutput");
        formatter.field(
            "private_key_ciphertext_blob",
            &self.private_key_ciphertext_blob,
        );
        formatter.field("private_key_plaintext", &"*** Sensitive Data Redacted ***");
        formatter.field("public_key", &self.public_key);
        formatter.field("key_id", &self.key_id);
        formatter.field("key_pair_spec", &self.key_pair_spec);
        formatter.finish()
    }
}
/// See [`GenerateDataKeyPairOutput`](crate::output::GenerateDataKeyPairOutput)
pub mod generate_data_key_pair_output {
    /// A builder for [`GenerateDataKeyPairOutput`](crate::output::GenerateDataKeyPairOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) private_key_ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) private_key_plaintext: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) public_key: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) key_pair_spec: std::option::Option<crate::model::DataKeyPairSpec>,
    }
    impl Builder {
        /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn private_key_ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.private_key_ciphertext_blob = Some(input);
            self
        }
        /// <p>The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_private_key_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.private_key_ciphertext_blob = input;
            self
        }
        /// <p>The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn private_key_plaintext(mut self, input: aws_smithy_types::Blob) -> Self {
            self.private_key_plaintext = Some(input);
            self
        }
        /// <p>The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_private_key_plaintext(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.private_key_plaintext = input;
            self
        }
        /// <p>The public key (in plaintext).</p>
        pub fn public_key(mut self, input: aws_smithy_types::Blob) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key (in plaintext).</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the private key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The type of data key pair that was generated.</p>
        pub fn key_pair_spec(mut self, input: crate::model::DataKeyPairSpec) -> Self {
            self.key_pair_spec = Some(input);
            self
        }
        /// <p>The type of data key pair that was generated.</p>
        pub fn set_key_pair_spec(
            mut self,
            input: std::option::Option<crate::model::DataKeyPairSpec>,
        ) -> Self {
            self.key_pair_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateDataKeyPairOutput`](crate::output::GenerateDataKeyPairOutput)
        pub fn build(self) -> crate::output::GenerateDataKeyPairOutput {
            crate::output::GenerateDataKeyPairOutput {
                private_key_ciphertext_blob: self.private_key_ciphertext_blob,
                private_key_plaintext: self.private_key_plaintext,
                public_key: self.public_key,
                key_id: self.key_id,
                key_pair_spec: self.key_pair_spec,
            }
        }
    }
}
impl GenerateDataKeyPairOutput {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyPairOutput`](crate::output::GenerateDataKeyPairOutput)
    pub fn builder() -> crate::output::generate_data_key_pair_output::Builder {
        crate::output::generate_data_key_pair_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateDataKeyOutput {
    /// <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of
    /// KMS. Then, remove it from memory as soon as possible.</p>
    pub plaintext: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    pub key_id: std::option::Option<std::string::String>,
}
impl GenerateDataKeyOutput {
    /// <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ciphertext_blob.as_ref()
    }
    /// <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of
    /// KMS. Then, remove it from memory as soon as possible.</p>
    pub fn plaintext(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.plaintext.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateDataKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateDataKeyOutput");
        formatter.field("ciphertext_blob", &self.ciphertext_blob);
        formatter.field("plaintext", &"*** Sensitive Data Redacted ***");
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`GenerateDataKeyOutput`](crate::output::GenerateDataKeyOutput)
pub mod generate_data_key_output {
    /// A builder for [`GenerateDataKeyOutput`](crate::output::GenerateDataKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) plaintext: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ciphertext_blob = Some(input);
            self
        }
        /// <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ciphertext_blob = input;
            self
        }
        /// <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of
        /// KMS. Then, remove it from memory as soon as possible.</p>
        pub fn plaintext(mut self, input: aws_smithy_types::Blob) -> Self {
            self.plaintext = Some(input);
            self
        }
        /// <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of
        /// KMS. Then, remove it from memory as soon as possible.</p>
        pub fn set_plaintext(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.plaintext = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateDataKeyOutput`](crate::output::GenerateDataKeyOutput)
        pub fn build(self) -> crate::output::GenerateDataKeyOutput {
            crate::output::GenerateDataKeyOutput {
                ciphertext_blob: self.ciphertext_blob,
                plaintext: self.plaintext,
                key_id: self.key_id,
            }
        }
    }
}
impl GenerateDataKeyOutput {
    /// Creates a new builder-style object to manufacture [`GenerateDataKeyOutput`](crate::output::GenerateDataKeyOutput)
    pub fn builder() -> crate::output::generate_data_key_output::Builder {
        crate::output::generate_data_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptOutput {
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
}
impl EncryptOutput {
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ciphertext_blob.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub fn encryption_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAlgorithmSpec> {
        self.encryption_algorithm.as_ref()
    }
}
impl std::fmt::Debug for EncryptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptOutput");
        formatter.field("ciphertext_blob", &self.ciphertext_blob);
        formatter.field("key_id", &self.key_id);
        formatter.field("encryption_algorithm", &self.encryption_algorithm);
        formatter.finish()
    }
}
/// See [`EncryptOutput`](crate::output::EncryptOutput)
pub mod encrypt_output {
    /// A builder for [`EncryptOutput`](crate::output::EncryptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ciphertext_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
    }
    impl Builder {
        /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn ciphertext_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ciphertext_blob = Some(input);
            self
        }
        /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_ciphertext_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ciphertext_blob = input;
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
        pub fn encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.encryption_algorithm = Some(input);
            self
        }
        /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
        pub fn set_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.encryption_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptOutput`](crate::output::EncryptOutput)
        pub fn build(self) -> crate::output::EncryptOutput {
            crate::output::EncryptOutput {
                ciphertext_blob: self.ciphertext_blob,
                key_id: self.key_id,
                encryption_algorithm: self.encryption_algorithm,
            }
        }
    }
}
impl EncryptOutput {
    /// Creates a new builder-style object to manufacture [`EncryptOutput`](crate::output::EncryptOutput)
    pub fn builder() -> crate::output::encrypt_output::Builder {
        crate::output::encrypt_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableKeyRotationOutput {}
impl std::fmt::Debug for EnableKeyRotationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableKeyRotationOutput");
        formatter.finish()
    }
}
/// See [`EnableKeyRotationOutput`](crate::output::EnableKeyRotationOutput)
pub mod enable_key_rotation_output {
    /// A builder for [`EnableKeyRotationOutput`](crate::output::EnableKeyRotationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableKeyRotationOutput`](crate::output::EnableKeyRotationOutput)
        pub fn build(self) -> crate::output::EnableKeyRotationOutput {
            crate::output::EnableKeyRotationOutput {}
        }
    }
}
impl EnableKeyRotationOutput {
    /// Creates a new builder-style object to manufacture [`EnableKeyRotationOutput`](crate::output::EnableKeyRotationOutput)
    pub fn builder() -> crate::output::enable_key_rotation_output::Builder {
        crate::output::enable_key_rotation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableKeyOutput {}
impl std::fmt::Debug for EnableKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableKeyOutput");
        formatter.finish()
    }
}
/// See [`EnableKeyOutput`](crate::output::EnableKeyOutput)
pub mod enable_key_output {
    /// A builder for [`EnableKeyOutput`](crate::output::EnableKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableKeyOutput`](crate::output::EnableKeyOutput)
        pub fn build(self) -> crate::output::EnableKeyOutput {
            crate::output::EnableKeyOutput {}
        }
    }
}
impl EnableKeyOutput {
    /// Creates a new builder-style object to manufacture [`EnableKeyOutput`](crate::output::EnableKeyOutput)
    pub fn builder() -> crate::output::enable_key_output::Builder {
        crate::output::enable_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectCustomKeyStoreOutput {}
impl std::fmt::Debug for DisconnectCustomKeyStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectCustomKeyStoreOutput");
        formatter.finish()
    }
}
/// See [`DisconnectCustomKeyStoreOutput`](crate::output::DisconnectCustomKeyStoreOutput)
pub mod disconnect_custom_key_store_output {
    /// A builder for [`DisconnectCustomKeyStoreOutput`](crate::output::DisconnectCustomKeyStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisconnectCustomKeyStoreOutput`](crate::output::DisconnectCustomKeyStoreOutput)
        pub fn build(self) -> crate::output::DisconnectCustomKeyStoreOutput {
            crate::output::DisconnectCustomKeyStoreOutput {}
        }
    }
}
impl DisconnectCustomKeyStoreOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectCustomKeyStoreOutput`](crate::output::DisconnectCustomKeyStoreOutput)
    pub fn builder() -> crate::output::disconnect_custom_key_store_output::Builder {
        crate::output::disconnect_custom_key_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableKeyRotationOutput {}
impl std::fmt::Debug for DisableKeyRotationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableKeyRotationOutput");
        formatter.finish()
    }
}
/// See [`DisableKeyRotationOutput`](crate::output::DisableKeyRotationOutput)
pub mod disable_key_rotation_output {
    /// A builder for [`DisableKeyRotationOutput`](crate::output::DisableKeyRotationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableKeyRotationOutput`](crate::output::DisableKeyRotationOutput)
        pub fn build(self) -> crate::output::DisableKeyRotationOutput {
            crate::output::DisableKeyRotationOutput {}
        }
    }
}
impl DisableKeyRotationOutput {
    /// Creates a new builder-style object to manufacture [`DisableKeyRotationOutput`](crate::output::DisableKeyRotationOutput)
    pub fn builder() -> crate::output::disable_key_rotation_output::Builder {
        crate::output::disable_key_rotation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableKeyOutput {}
impl std::fmt::Debug for DisableKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableKeyOutput");
        formatter.finish()
    }
}
/// See [`DisableKeyOutput`](crate::output::DisableKeyOutput)
pub mod disable_key_output {
    /// A builder for [`DisableKeyOutput`](crate::output::DisableKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableKeyOutput`](crate::output::DisableKeyOutput)
        pub fn build(self) -> crate::output::DisableKeyOutput {
            crate::output::DisableKeyOutput {}
        }
    }
}
impl DisableKeyOutput {
    /// Creates a new builder-style object to manufacture [`DisableKeyOutput`](crate::output::DisableKeyOutput)
    pub fn builder() -> crate::output::disable_key_output::Builder {
        crate::output::disable_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKeyOutput {
    /// <p>Metadata associated with the key.</p>
    pub key_metadata: std::option::Option<crate::model::KeyMetadata>,
}
impl DescribeKeyOutput {
    /// <p>Metadata associated with the key.</p>
    pub fn key_metadata(&self) -> std::option::Option<&crate::model::KeyMetadata> {
        self.key_metadata.as_ref()
    }
}
impl std::fmt::Debug for DescribeKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKeyOutput");
        formatter.field("key_metadata", &self.key_metadata);
        formatter.finish()
    }
}
/// See [`DescribeKeyOutput`](crate::output::DescribeKeyOutput)
pub mod describe_key_output {
    /// A builder for [`DescribeKeyOutput`](crate::output::DescribeKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_metadata: std::option::Option<crate::model::KeyMetadata>,
    }
    impl Builder {
        /// <p>Metadata associated with the key.</p>
        pub fn key_metadata(mut self, input: crate::model::KeyMetadata) -> Self {
            self.key_metadata = Some(input);
            self
        }
        /// <p>Metadata associated with the key.</p>
        pub fn set_key_metadata(
            mut self,
            input: std::option::Option<crate::model::KeyMetadata>,
        ) -> Self {
            self.key_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKeyOutput`](crate::output::DescribeKeyOutput)
        pub fn build(self) -> crate::output::DescribeKeyOutput {
            crate::output::DescribeKeyOutput {
                key_metadata: self.key_metadata,
            }
        }
    }
}
impl DescribeKeyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeKeyOutput`](crate::output::DescribeKeyOutput)
    pub fn builder() -> crate::output::describe_key_output::Builder {
        crate::output::describe_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomKeyStoresOutput {
    /// <p>Contains metadata about each custom key store.</p>
    pub custom_key_stores:
        std::option::Option<std::vec::Vec<crate::model::CustomKeyStoresListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub truncated: bool,
}
impl DescribeCustomKeyStoresOutput {
    /// <p>Contains metadata about each custom key store.</p>
    pub fn custom_key_stores(
        &self,
    ) -> std::option::Option<&[crate::model::CustomKeyStoresListEntry]> {
        self.custom_key_stores.as_deref()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the
    /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this
    /// value is true, the list in this response is truncated. To get more items, pass the value of
    /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
    /// subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for DescribeCustomKeyStoresOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomKeyStoresOutput");
        formatter.field("custom_key_stores", &self.custom_key_stores);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`DescribeCustomKeyStoresOutput`](crate::output::DescribeCustomKeyStoresOutput)
pub mod describe_custom_key_stores_output {
    /// A builder for [`DescribeCustomKeyStoresOutput`](crate::output::DescribeCustomKeyStoresOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_key_stores:
            std::option::Option<std::vec::Vec<crate::model::CustomKeyStoresListEntry>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `custom_key_stores`.
        ///
        /// To override the contents of this collection use [`set_custom_key_stores`](Self::set_custom_key_stores).
        ///
        /// <p>Contains metadata about each custom key store.</p>
        pub fn custom_key_stores(
            mut self,
            input: impl Into<crate::model::CustomKeyStoresListEntry>,
        ) -> Self {
            let mut v = self.custom_key_stores.unwrap_or_default();
            v.push(input.into());
            self.custom_key_stores = Some(v);
            self
        }
        /// <p>Contains metadata about each custom key store.</p>
        pub fn set_custom_key_stores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomKeyStoresListEntry>>,
        ) -> Self {
            self.custom_key_stores = input;
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When <code>Truncated</code> is true, this element is present and contains the
        /// value to use for the <code>Marker</code> parameter in a subsequent request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items in the list. When this
        /// value is true, the list in this response is truncated. To get more items, pass the value of
        /// the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a
        /// subsequent request.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomKeyStoresOutput`](crate::output::DescribeCustomKeyStoresOutput)
        pub fn build(self) -> crate::output::DescribeCustomKeyStoresOutput {
            crate::output::DescribeCustomKeyStoresOutput {
                custom_key_stores: self.custom_key_stores,
                next_marker: self.next_marker,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl DescribeCustomKeyStoresOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomKeyStoresOutput`](crate::output::DescribeCustomKeyStoresOutput)
    pub fn builder() -> crate::output::describe_custom_key_stores_output::Builder {
        crate::output::describe_custom_key_stores_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImportedKeyMaterialOutput {}
impl std::fmt::Debug for DeleteImportedKeyMaterialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImportedKeyMaterialOutput");
        formatter.finish()
    }
}
/// See [`DeleteImportedKeyMaterialOutput`](crate::output::DeleteImportedKeyMaterialOutput)
pub mod delete_imported_key_material_output {
    /// A builder for [`DeleteImportedKeyMaterialOutput`](crate::output::DeleteImportedKeyMaterialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteImportedKeyMaterialOutput`](crate::output::DeleteImportedKeyMaterialOutput)
        pub fn build(self) -> crate::output::DeleteImportedKeyMaterialOutput {
            crate::output::DeleteImportedKeyMaterialOutput {}
        }
    }
}
impl DeleteImportedKeyMaterialOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImportedKeyMaterialOutput`](crate::output::DeleteImportedKeyMaterialOutput)
    pub fn builder() -> crate::output::delete_imported_key_material_output::Builder {
        crate::output::delete_imported_key_material_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomKeyStoreOutput {}
impl std::fmt::Debug for DeleteCustomKeyStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomKeyStoreOutput");
        formatter.finish()
    }
}
/// See [`DeleteCustomKeyStoreOutput`](crate::output::DeleteCustomKeyStoreOutput)
pub mod delete_custom_key_store_output {
    /// A builder for [`DeleteCustomKeyStoreOutput`](crate::output::DeleteCustomKeyStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCustomKeyStoreOutput`](crate::output::DeleteCustomKeyStoreOutput)
        pub fn build(self) -> crate::output::DeleteCustomKeyStoreOutput {
            crate::output::DeleteCustomKeyStoreOutput {}
        }
    }
}
impl DeleteCustomKeyStoreOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomKeyStoreOutput`](crate::output::DeleteCustomKeyStoreOutput)
    pub fn builder() -> crate::output::delete_custom_key_store_output::Builder {
        crate::output::delete_custom_key_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAliasOutput {}
impl std::fmt::Debug for DeleteAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
pub mod delete_alias_output {
    /// A builder for [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
        pub fn build(self) -> crate::output::DeleteAliasOutput {
            crate::output::DeleteAliasOutput {}
        }
    }
}
impl DeleteAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    pub fn builder() -> crate::output::delete_alias_output::Builder {
        crate::output::delete_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecryptOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub plaintext: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
    pub encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
}
impl DecryptOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn plaintext(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.plaintext.as_ref()
    }
    /// <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
    pub fn encryption_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAlgorithmSpec> {
        self.encryption_algorithm.as_ref()
    }
}
impl std::fmt::Debug for DecryptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecryptOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("plaintext", &"*** Sensitive Data Redacted ***");
        formatter.field("encryption_algorithm", &self.encryption_algorithm);
        formatter.finish()
    }
}
/// See [`DecryptOutput`](crate::output::DecryptOutput)
pub mod decrypt_output {
    /// A builder for [`DecryptOutput`](crate::output::DecryptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) plaintext: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn plaintext(mut self, input: aws_smithy_types::Blob) -> Self {
            self.plaintext = Some(input);
            self
        }
        /// <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
        pub fn set_plaintext(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.plaintext = input;
            self
        }
        /// <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
        pub fn encryption_algorithm(
            mut self,
            input: crate::model::EncryptionAlgorithmSpec,
        ) -> Self {
            self.encryption_algorithm = Some(input);
            self
        }
        /// <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
        pub fn set_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmSpec>,
        ) -> Self {
            self.encryption_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`DecryptOutput`](crate::output::DecryptOutput)
        pub fn build(self) -> crate::output::DecryptOutput {
            crate::output::DecryptOutput {
                key_id: self.key_id,
                plaintext: self.plaintext,
                encryption_algorithm: self.encryption_algorithm,
            }
        }
    }
}
impl DecryptOutput {
    /// Creates a new builder-style object to manufacture [`DecryptOutput`](crate::output::DecryptOutput)
    pub fn builder() -> crate::output::decrypt_output::Builder {
        crate::output::decrypt_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeyOutput {
    /// <p>Metadata associated with the KMS key.</p>
    pub key_metadata: std::option::Option<crate::model::KeyMetadata>,
}
impl CreateKeyOutput {
    /// <p>Metadata associated with the KMS key.</p>
    pub fn key_metadata(&self) -> std::option::Option<&crate::model::KeyMetadata> {
        self.key_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeyOutput");
        formatter.field("key_metadata", &self.key_metadata);
        formatter.finish()
    }
}
/// See [`CreateKeyOutput`](crate::output::CreateKeyOutput)
pub mod create_key_output {
    /// A builder for [`CreateKeyOutput`](crate::output::CreateKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_metadata: std::option::Option<crate::model::KeyMetadata>,
    }
    impl Builder {
        /// <p>Metadata associated with the KMS key.</p>
        pub fn key_metadata(mut self, input: crate::model::KeyMetadata) -> Self {
            self.key_metadata = Some(input);
            self
        }
        /// <p>Metadata associated with the KMS key.</p>
        pub fn set_key_metadata(
            mut self,
            input: std::option::Option<crate::model::KeyMetadata>,
        ) -> Self {
            self.key_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyOutput`](crate::output::CreateKeyOutput)
        pub fn build(self) -> crate::output::CreateKeyOutput {
            crate::output::CreateKeyOutput {
                key_metadata: self.key_metadata,
            }
        }
    }
}
impl CreateKeyOutput {
    /// Creates a new builder-style object to manufacture [`CreateKeyOutput`](crate::output::CreateKeyOutput)
    pub fn builder() -> crate::output::create_key_output::Builder {
        crate::output::create_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGrantOutput {
    /// <p>The grant token.</p>
    /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    pub grant_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the grant.</p>
    /// <p>You can use the <code>GrantId</code> in a <a>ListGrants</a>, <a>RetireGrant</a>, or <a>RevokeGrant</a> operation.</p>
    pub grant_id: std::option::Option<std::string::String>,
}
impl CreateGrantOutput {
    /// <p>The grant token.</p>
    /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    pub fn grant_token(&self) -> std::option::Option<&str> {
        self.grant_token.as_deref()
    }
    /// <p>The unique identifier for the grant.</p>
    /// <p>You can use the <code>GrantId</code> in a <a>ListGrants</a>, <a>RetireGrant</a>, or <a>RevokeGrant</a> operation.</p>
    pub fn grant_id(&self) -> std::option::Option<&str> {
        self.grant_id.as_deref()
    }
}
impl std::fmt::Debug for CreateGrantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGrantOutput");
        formatter.field("grant_token", &self.grant_token);
        formatter.field("grant_id", &self.grant_id);
        formatter.finish()
    }
}
/// See [`CreateGrantOutput`](crate::output::CreateGrantOutput)
pub mod create_grant_output {
    /// A builder for [`CreateGrantOutput`](crate::output::CreateGrantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_token: std::option::Option<std::string::String>,
        pub(crate) grant_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The grant token.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the
        /// <i>Key Management Service Developer Guide</i>.</p>
        pub fn grant_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_token = Some(input.into());
            self
        }
        /// <p>The grant token.</p>
        /// <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the
        /// <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_grant_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_token = input;
            self
        }
        /// <p>The unique identifier for the grant.</p>
        /// <p>You can use the <code>GrantId</code> in a <a>ListGrants</a>, <a>RetireGrant</a>, or <a>RevokeGrant</a> operation.</p>
        pub fn grant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the grant.</p>
        /// <p>You can use the <code>GrantId</code> in a <a>ListGrants</a>, <a>RetireGrant</a>, or <a>RevokeGrant</a> operation.</p>
        pub fn set_grant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGrantOutput`](crate::output::CreateGrantOutput)
        pub fn build(self) -> crate::output::CreateGrantOutput {
            crate::output::CreateGrantOutput {
                grant_token: self.grant_token,
                grant_id: self.grant_id,
            }
        }
    }
}
impl CreateGrantOutput {
    /// Creates a new builder-style object to manufacture [`CreateGrantOutput`](crate::output::CreateGrantOutput)
    pub fn builder() -> crate::output::create_grant_output::Builder {
        crate::output::create_grant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomKeyStoreOutput {
    /// <p>A unique identifier for the new custom key store.</p>
    pub custom_key_store_id: std::option::Option<std::string::String>,
}
impl CreateCustomKeyStoreOutput {
    /// <p>A unique identifier for the new custom key store.</p>
    pub fn custom_key_store_id(&self) -> std::option::Option<&str> {
        self.custom_key_store_id.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomKeyStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomKeyStoreOutput");
        formatter.field("custom_key_store_id", &self.custom_key_store_id);
        formatter.finish()
    }
}
/// See [`CreateCustomKeyStoreOutput`](crate::output::CreateCustomKeyStoreOutput)
pub mod create_custom_key_store_output {
    /// A builder for [`CreateCustomKeyStoreOutput`](crate::output::CreateCustomKeyStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_key_store_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the new custom key store.</p>
        pub fn custom_key_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_key_store_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the new custom key store.</p>
        pub fn set_custom_key_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_key_store_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomKeyStoreOutput`](crate::output::CreateCustomKeyStoreOutput)
        pub fn build(self) -> crate::output::CreateCustomKeyStoreOutput {
            crate::output::CreateCustomKeyStoreOutput {
                custom_key_store_id: self.custom_key_store_id,
            }
        }
    }
}
impl CreateCustomKeyStoreOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomKeyStoreOutput`](crate::output::CreateCustomKeyStoreOutput)
    pub fn builder() -> crate::output::create_custom_key_store_output::Builder {
        crate::output::create_custom_key_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasOutput {}
impl std::fmt::Debug for CreateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasOutput");
        formatter.finish()
    }
}
/// See [`CreateAliasOutput`](crate::output::CreateAliasOutput)
pub mod create_alias_output {
    /// A builder for [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateAliasOutput`](crate::output::CreateAliasOutput)
        pub fn build(self) -> crate::output::CreateAliasOutput {
            crate::output::CreateAliasOutput {}
        }
    }
}
impl CreateAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    pub fn builder() -> crate::output::create_alias_output::Builder {
        crate::output::create_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectCustomKeyStoreOutput {}
impl std::fmt::Debug for ConnectCustomKeyStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectCustomKeyStoreOutput");
        formatter.finish()
    }
}
/// See [`ConnectCustomKeyStoreOutput`](crate::output::ConnectCustomKeyStoreOutput)
pub mod connect_custom_key_store_output {
    /// A builder for [`ConnectCustomKeyStoreOutput`](crate::output::ConnectCustomKeyStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ConnectCustomKeyStoreOutput`](crate::output::ConnectCustomKeyStoreOutput)
        pub fn build(self) -> crate::output::ConnectCustomKeyStoreOutput {
            crate::output::ConnectCustomKeyStoreOutput {}
        }
    }
}
impl ConnectCustomKeyStoreOutput {
    /// Creates a new builder-style object to manufacture [`ConnectCustomKeyStoreOutput`](crate::output::ConnectCustomKeyStoreOutput)
    pub fn builder() -> crate::output::connect_custom_key_store_output::Builder {
        crate::output::connect_custom_key_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelKeyDeletionOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is canceled.</p>
    pub key_id: std::option::Option<std::string::String>,
}
impl CancelKeyDeletionOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is canceled.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for CancelKeyDeletionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelKeyDeletionOutput");
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`CancelKeyDeletionOutput`](crate::output::CancelKeyDeletionOutput)
pub mod cancel_key_deletion_output {
    /// A builder for [`CancelKeyDeletionOutput`](crate::output::CancelKeyDeletionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is canceled.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key whose deletion is canceled.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelKeyDeletionOutput`](crate::output::CancelKeyDeletionOutput)
        pub fn build(self) -> crate::output::CancelKeyDeletionOutput {
            crate::output::CancelKeyDeletionOutput {
                key_id: self.key_id,
            }
        }
    }
}
impl CancelKeyDeletionOutput {
    /// Creates a new builder-style object to manufacture [`CancelKeyDeletionOutput`](crate::output::CancelKeyDeletionOutput)
    pub fn builder() -> crate::output::cancel_key_deletion_output::Builder {
        crate::output::cancel_key_deletion_output::Builder::default()
    }
}
