// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelKeyDeletion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelKeyDeletionError {
    /// Kind of error that occurred.
    pub kind: CancelKeyDeletionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelKeyDeletion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelKeyDeletionErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelKeyDeletionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelKeyDeletionErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            CancelKeyDeletionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CancelKeyDeletionErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            CancelKeyDeletionErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            CancelKeyDeletionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CancelKeyDeletionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelKeyDeletionError {
    fn code(&self) -> Option<&str> {
        CancelKeyDeletionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelKeyDeletionError {
    /// Creates a new `CancelKeyDeletionError`.
    pub fn new(kind: CancelKeyDeletionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelKeyDeletionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelKeyDeletionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelKeyDeletionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelKeyDeletionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelKeyDeletionErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelKeyDeletionErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelKeyDeletionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelKeyDeletionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelKeyDeletionErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelKeyDeletionErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelKeyDeletionErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelKeyDeletionErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelKeyDeletionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CancelKeyDeletionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CancelKeyDeletionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelKeyDeletionErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            CancelKeyDeletionErrorKind::InvalidArnException(_inner) => Some(_inner),
            CancelKeyDeletionErrorKind::KmsInternalException(_inner) => Some(_inner),
            CancelKeyDeletionErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            CancelKeyDeletionErrorKind::NotFoundException(_inner) => Some(_inner),
            CancelKeyDeletionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConnectCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConnectCustomKeyStoreError {
    /// Kind of error that occurred.
    pub kind: ConnectCustomKeyStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConnectCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConnectCustomKeyStoreErrorKind {
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the
    /// configuration requirements for a custom key store.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>The cluster must be configured with private subnets in at least two different
    /// Availability Zones in the Region.</p>
    /// </li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for
    /// the cluster</a> (cloudhsm-cluster-<i><cluster-id></i>-sg) must
    /// include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The
    /// <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group
    /// ID. These rules are set by default when you create the cluster. Do not delete or change
    /// them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs,
    /// use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
    /// <p>For the <a>CreateCustomKeyStore</a>, <a>UpdateCustomKeyStore</a>, and <a>CreateKey</a> operations, the CloudHSM cluster must have at least two
    /// active HSMs, each in a different Availability Zone. For the <a>ConnectCustomKeyStore</a> operation, the CloudHSM must contain at least one active
    /// HSM.</p>
    /// </li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with a
    /// custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a>
    /// in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster,
    /// see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private
    /// Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see
    /// <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security
    /// Group</a> in the <i>
    /// <i>CloudHSM User Guide</i>
    /// </i>. </p>
    CloudHsmClusterInvalidConfigurationException(
        crate::error::CloudHsmClusterInvalidConfigurationException,
    ),
    /// <p>The request was rejected because the CloudHSM cluster that is associated with the custom key
    /// store is not active. Initialize and activate the cluster and try the command again. For
    /// detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
    CloudHsmClusterNotActiveException(crate::error::CloudHsmClusterNotActiveException),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConnectCustomKeyStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                _inner.fmt(f)
            }
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ConnectCustomKeyStoreErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ConnectCustomKeyStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConnectCustomKeyStoreError {
    fn code(&self) -> Option<&str> {
        ConnectCustomKeyStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConnectCustomKeyStoreError {
    /// Creates a new `ConnectCustomKeyStoreError`.
    pub fn new(kind: ConnectCustomKeyStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConnectCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConnectCustomKeyStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConnectCustomKeyStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConnectCustomKeyStoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException`.
    pub fn is_cloud_hsm_cluster_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException`.
    pub fn is_cloud_hsm_cluster_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ConnectCustomKeyStoreErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConnectCustomKeyStoreErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for ConnectCustomKeyStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(
                _inner,
            ) => Some(_inner),
            ConnectCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                Some(_inner)
            }
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                Some(_inner)
            }
            ConnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => Some(_inner),
            ConnectCustomKeyStoreErrorKind::KmsInternalException(_inner) => Some(_inner),
            ConnectCustomKeyStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAliasErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified alias name is not valid.</p>
    InvalidAliasNameException(crate::error::InvalidAliasNameException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAliasErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::InvalidAliasNameException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAliasError {
    fn code(&self) -> Option<&str> {
        CreateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAliasError {
    /// Creates a new `CreateAliasError`.
    pub fn new(kind: CreateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InvalidAliasNameException`.
    pub fn is_invalid_alias_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::InvalidAliasNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAliasErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateAliasErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            CreateAliasErrorKind::InvalidAliasNameException(_inner) => Some(_inner),
            CreateAliasErrorKind::KmsInternalException(_inner) => Some(_inner),
            CreateAliasErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            CreateAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomKeyStoreError {
    /// Kind of error that occurred.
    pub kind: CreateCustomKeyStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomKeyStoreErrorKind {
    /// <p>The request was rejected because the specified CloudHSM cluster is already associated with a
    /// custom key store or it shares a backup history with a cluster that is associated with a custom
    /// key store. Each custom key store must be associated with a different CloudHSM cluster.</p>
    /// <p>Clusters that share a backup history have the same cluster certificate. To view the
    /// cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    CloudHsmClusterInUseException(crate::error::CloudHsmClusterInUseException),
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the
    /// configuration requirements for a custom key store.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>The cluster must be configured with private subnets in at least two different
    /// Availability Zones in the Region.</p>
    /// </li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for
    /// the cluster</a> (cloudhsm-cluster-<i><cluster-id></i>-sg) must
    /// include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The
    /// <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group
    /// ID. These rules are set by default when you create the cluster. Do not delete or change
    /// them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs,
    /// use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
    /// <p>For the <a>CreateCustomKeyStore</a>, <a>UpdateCustomKeyStore</a>, and <a>CreateKey</a> operations, the CloudHSM cluster must have at least two
    /// active HSMs, each in a different Availability Zone. For the <a>ConnectCustomKeyStore</a> operation, the CloudHSM must contain at least one active
    /// HSM.</p>
    /// </li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with a
    /// custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a>
    /// in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster,
    /// see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private
    /// Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see
    /// <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security
    /// Group</a> in the <i>
    /// <i>CloudHSM User Guide</i>
    /// </i>. </p>
    CloudHsmClusterInvalidConfigurationException(
        crate::error::CloudHsmClusterInvalidConfigurationException,
    ),
    /// <p>The request was rejected because the CloudHSM cluster that is associated with the custom key
    /// store is not active. Initialize and activate the cluster and try the command again. For
    /// detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
    CloudHsmClusterNotActiveException(crate::error::CloudHsmClusterNotActiveException),
    /// <p>The request was rejected because KMS cannot find the CloudHSM cluster with the specified
    /// cluster ID. Retry the request with a different cluster ID.</p>
    CloudHsmClusterNotFoundException(crate::error::CloudHsmClusterNotFoundException),
    /// <p>The request was rejected because the specified custom key store name is already assigned
    /// to another custom key store in the account. Try again with a custom key store name that is
    /// unique in the account.</p>
    CustomKeyStoreNameInUseException(crate::error::CustomKeyStoreNameInUseException),
    /// <p>The request was rejected because the trust anchor certificate in the request is not the
    /// trust anchor certificate for the specified CloudHSM cluster.</p>
    /// <p>When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create the trust anchor certificate and save it in the
    /// <code>customerCA.crt</code> file.</p>
    IncorrectTrustAnchorException(crate::error::IncorrectTrustAnchorException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomKeyStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException(_inner) => _inner.fmt(f),
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException(_inner) => _inner.fmt(f),
            CreateCustomKeyStoreErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            CreateCustomKeyStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomKeyStoreError {
    fn code(&self) -> Option<&str> {
        CreateCustomKeyStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomKeyStoreError {
    /// Creates a new `CreateCustomKeyStoreError`.
    pub fn new(kind: CreateCustomKeyStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomKeyStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomKeyStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomKeyStoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException`.
    pub fn is_cloud_hsm_cluster_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException`.
    pub fn is_cloud_hsm_cluster_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException`.
    pub fn is_cloud_hsm_cluster_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException`.
    pub fn is_cloud_hsm_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException`.
    pub fn is_custom_key_store_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException`.
    pub fn is_incorrect_trust_anchor_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomKeyStoreErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomKeyStoreErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for CreateCustomKeyStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInUseException(_inner) => Some(_inner),
            CreateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                Some(_inner)
            }
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                Some(_inner)
            }
            CreateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_inner) => Some(_inner),
            CreateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_inner) => Some(_inner),
            CreateCustomKeyStoreErrorKind::IncorrectTrustAnchorException(_inner) => Some(_inner),
            CreateCustomKeyStoreErrorKind::KmsInternalException(_inner) => Some(_inner),
            CreateCustomKeyStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGrantError {
    /// Kind of error that occurred.
    pub kind: CreateGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGrantErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGrantErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::DisabledException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGrantError {
    fn code(&self) -> Option<&str> {
        CreateGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGrantError {
    /// Creates a new `CreateGrantError`.
    pub fn new(kind: CreateGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for CreateGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGrantErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            CreateGrantErrorKind::DisabledException(_inner) => Some(_inner),
            CreateGrantErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateGrantErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            CreateGrantErrorKind::KmsInternalException(_inner) => Some(_inner),
            CreateGrantErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            CreateGrantErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGrantErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateKeyError {
    /// Kind of error that occurred.
    pub kind: CreateKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateKeyErrorKind {
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the
    /// configuration requirements for a custom key store.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>The cluster must be configured with private subnets in at least two different
    /// Availability Zones in the Region.</p>
    /// </li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for
    /// the cluster</a> (cloudhsm-cluster-<i><cluster-id></i>-sg) must
    /// include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The
    /// <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group
    /// ID. These rules are set by default when you create the cluster. Do not delete or change
    /// them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs,
    /// use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
    /// <p>For the <a>CreateCustomKeyStore</a>, <a>UpdateCustomKeyStore</a>, and <a>CreateKey</a> operations, the CloudHSM cluster must have at least two
    /// active HSMs, each in a different Availability Zone. For the <a>ConnectCustomKeyStore</a> operation, the CloudHSM must contain at least one active
    /// HSM.</p>
    /// </li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with a
    /// custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a>
    /// in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster,
    /// see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private
    /// Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see
    /// <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security
    /// Group</a> in the <i>
    /// <i>CloudHSM User Guide</i>
    /// </i>. </p>
    CloudHsmClusterInvalidConfigurationException(
        crate::error::CloudHsmClusterInvalidConfigurationException,
    ),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified policy is not syntactically or semantically
    /// correct.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because one or more tags are not valid.</p>
    TagException(crate::error::TagException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            CreateKeyErrorKind::CustomKeyStoreInvalidStateException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::CustomKeyStoreNotFoundException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::TagException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateKeyError {
    fn code(&self) -> Option<&str> {
        CreateKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateKeyError {
    /// Creates a new `CreateKeyError`.
    pub fn new(kind: CreateKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException`.
    pub fn is_cloud_hsm_cluster_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::TagException`.
    pub fn is_tag_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyErrorKind::TagException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateKeyErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                Some(_inner)
            }
            CreateKeyErrorKind::CustomKeyStoreInvalidStateException(_inner) => Some(_inner),
            CreateKeyErrorKind::CustomKeyStoreNotFoundException(_inner) => Some(_inner),
            CreateKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            CreateKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            CreateKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            CreateKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateKeyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            CreateKeyErrorKind::TagException(_inner) => Some(_inner),
            CreateKeyErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Decrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DecryptError {
    /// Kind of error that occurred.
    pub kind: DecryptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Decrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DecryptErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified KMS key cannot decrypt the data. The
    /// <code>KeyId</code> in a <a>Decrypt</a> request and the <code>SourceKeyId</code>
    /// in a <a>ReEncrypt</a> request must identify the same KMS key that was used to
    /// encrypt the ciphertext.</p>
    IncorrectKeyException(crate::error::IncorrectKeyException),
    /// <p>From the <a>Decrypt</a> or <a>ReEncrypt</a> operation, the request
    /// was rejected because the specified ciphertext, or additional authenticated data incorporated
    /// into the ciphertext, such as the encryption context, is corrupted, missing, or otherwise
    /// invalid.</p>
    /// <p>From the <a>ImportKeyMaterial</a> operation, the request was rejected because
    /// KMS could not decrypt the encrypted (wrapped) key material. </p>
    InvalidCiphertextException(crate::error::InvalidCiphertextException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DecryptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DecryptErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DecryptErrorKind::DisabledException(_inner) => _inner.fmt(f),
            DecryptErrorKind::IncorrectKeyException(_inner) => _inner.fmt(f),
            DecryptErrorKind::InvalidCiphertextException(_inner) => _inner.fmt(f),
            DecryptErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            DecryptErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            DecryptErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            DecryptErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DecryptErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            DecryptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DecryptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DecryptError {
    fn code(&self) -> Option<&str> {
        DecryptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DecryptError {
    /// Creates a new `DecryptError`.
    pub fn new(kind: DecryptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DecryptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DecryptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DecryptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DecryptErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::DependencyTimeoutException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::IncorrectKeyException`.
    pub fn is_incorrect_key_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::IncorrectKeyException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::InvalidCiphertextException`.
    pub fn is_invalid_ciphertext_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::InvalidCiphertextException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::InvalidGrantTokenException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::InvalidKeyUsageException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::KeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `DecryptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DecryptErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DecryptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DecryptErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DecryptErrorKind::DisabledException(_inner) => Some(_inner),
            DecryptErrorKind::IncorrectKeyException(_inner) => Some(_inner),
            DecryptErrorKind::InvalidCiphertextException(_inner) => Some(_inner),
            DecryptErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            DecryptErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            DecryptErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            DecryptErrorKind::KmsInternalException(_inner) => Some(_inner),
            DecryptErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            DecryptErrorKind::NotFoundException(_inner) => Some(_inner),
            DecryptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAliasErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAliasErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAliasError {
    fn code(&self) -> Option<&str> {
        DeleteAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAliasError {
    /// Creates a new `DeleteAliasError`.
    pub fn new(kind: DeleteAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAliasErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DeleteAliasErrorKind::KmsInternalException(_inner) => Some(_inner),
            DeleteAliasErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            DeleteAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomKeyStoreError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomKeyStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomKeyStoreErrorKind {
    /// <p>The request was rejected because the custom key store contains KMS keys. After verifying
    /// that you do not need to use the KMS keys, use the <a>ScheduleKeyDeletion</a>
    /// operation to delete the KMS keys. After they are deleted, you can delete the custom key
    /// store.</p>
    CustomKeyStoreHasCmKsException(crate::error::CustomKeyStoreHasCmKsException),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomKeyStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException(_inner) => _inner.fmt(f),
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => _inner.fmt(f),
            DeleteCustomKeyStoreErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DeleteCustomKeyStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomKeyStoreError {
    fn code(&self) -> Option<&str> {
        DeleteCustomKeyStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomKeyStoreError {
    /// Creates a new `DeleteCustomKeyStoreError`.
    pub fn new(kind: DeleteCustomKeyStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomKeyStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomKeyStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomKeyStoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException`.
    pub fn is_custom_key_store_has_cm_ks_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomKeyStoreErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomKeyStoreErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for DeleteCustomKeyStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreHasCmKsException(_inner) => Some(_inner),
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                Some(_inner)
            }
            DeleteCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => Some(_inner),
            DeleteCustomKeyStoreErrorKind::KmsInternalException(_inner) => Some(_inner),
            DeleteCustomKeyStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteImportedKeyMaterial` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteImportedKeyMaterialError {
    /// Kind of error that occurred.
    pub kind: DeleteImportedKeyMaterialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteImportedKeyMaterial` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteImportedKeyMaterialErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteImportedKeyMaterialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DeleteImportedKeyMaterialErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DeleteImportedKeyMaterialErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            DeleteImportedKeyMaterialErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteImportedKeyMaterialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteImportedKeyMaterialError {
    fn code(&self) -> Option<&str> {
        DeleteImportedKeyMaterialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteImportedKeyMaterialError {
    /// Creates a new `DeleteImportedKeyMaterialError`.
    pub fn new(kind: DeleteImportedKeyMaterialErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteImportedKeyMaterialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteImportedKeyMaterialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteImportedKeyMaterialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteImportedKeyMaterialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteImportedKeyMaterialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteImportedKeyMaterialErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DeleteImportedKeyMaterialErrorKind::InvalidArnException(_inner) => Some(_inner),
            DeleteImportedKeyMaterialErrorKind::KmsInternalException(_inner) => Some(_inner),
            DeleteImportedKeyMaterialErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            DeleteImportedKeyMaterialErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteImportedKeyMaterialErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            DeleteImportedKeyMaterialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomKeyStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomKeyStoresError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomKeyStoresErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomKeyStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomKeyStoresErrorKind {
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomKeyStoresError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCustomKeyStoresErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            DescribeCustomKeyStoresErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DescribeCustomKeyStoresErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomKeyStoresError {
    fn code(&self) -> Option<&str> {
        DescribeCustomKeyStoresError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomKeyStoresError {
    /// Creates a new `DescribeCustomKeyStoresError`.
    pub fn new(kind: DescribeCustomKeyStoresErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomKeyStoresError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomKeyStoresErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomKeyStoresError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomKeyStoresErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomKeyStoresErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomKeyStoresErrorKind::InvalidMarkerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomKeyStoresErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomKeyStoresErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for DescribeCustomKeyStoresError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomKeyStoresErrorKind::CustomKeyStoreNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCustomKeyStoresErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            DescribeCustomKeyStoresErrorKind::KmsInternalException(_inner) => Some(_inner),
            DescribeCustomKeyStoresErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeKeyError {
    /// Kind of error that occurred.
    pub kind: DescribeKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeKeyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DescribeKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DescribeKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DescribeKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeKeyError {
    fn code(&self) -> Option<&str> {
        DescribeKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeKeyError {
    /// Creates a new `DescribeKeyError`.
    pub fn new(kind: DescribeKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DescribeKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `DescribeKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeKeyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DescribeKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DescribeKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            DescribeKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            DescribeKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableKeyError {
    /// Kind of error that occurred.
    pub kind: DisableKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableKeyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DisableKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DisableKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DisableKeyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            DisableKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisableKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableKeyError {
    fn code(&self) -> Option<&str> {
        DisableKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableKeyError {
    /// Creates a new `DisableKeyError`.
    pub fn new(kind: DisableKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, DisableKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `DisableKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, DisableKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `DisableKeyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DisableKeyErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `DisableKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DisableKeyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DisableKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DisableKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            DisableKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            DisableKeyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            DisableKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DisableKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableKeyRotation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableKeyRotationError {
    /// Kind of error that occurred.
    pub kind: DisableKeyRotationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableKeyRotation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableKeyRotationErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableKeyRotationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableKeyRotationErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::DisabledException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DisableKeyRotationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableKeyRotationError {
    fn code(&self) -> Option<&str> {
        DisableKeyRotationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableKeyRotationError {
    /// Creates a new `DisableKeyRotationError`.
    pub fn new(kind: DisableKeyRotationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableKeyRotationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableKeyRotationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableKeyRotationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableKeyRotationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::DisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKeyRotationErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKeyRotationErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DisableKeyRotationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableKeyRotationErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::DisabledException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::InvalidArnException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::KmsInternalException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::NotFoundException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DisableKeyRotationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisconnectCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisconnectCustomKeyStoreError {
    /// Kind of error that occurred.
    pub kind: DisconnectCustomKeyStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisconnectCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisconnectCustomKeyStoreErrorKind {
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisconnectCustomKeyStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisconnectCustomKeyStoreErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            DisconnectCustomKeyStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisconnectCustomKeyStoreError {
    fn code(&self) -> Option<&str> {
        DisconnectCustomKeyStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisconnectCustomKeyStoreError {
    /// Creates a new `DisconnectCustomKeyStoreError`.
    pub fn new(kind: DisconnectCustomKeyStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisconnectCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisconnectCustomKeyStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisconnectCustomKeyStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisconnectCustomKeyStoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisconnectCustomKeyStoreErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisconnectCustomKeyStoreErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for DisconnectCustomKeyStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                Some(_inner)
            }
            DisconnectCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => {
                Some(_inner)
            }
            DisconnectCustomKeyStoreErrorKind::KmsInternalException(_inner) => Some(_inner),
            DisconnectCustomKeyStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableKeyError {
    /// Kind of error that occurred.
    pub kind: EnableKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableKeyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            EnableKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableKeyError {
    fn code(&self) -> Option<&str> {
        EnableKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableKeyError {
    /// Creates a new `EnableKeyError`.
    pub fn new(kind: EnableKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for EnableKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            EnableKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            EnableKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            EnableKeyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            EnableKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            EnableKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableKeyRotation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableKeyRotationError {
    /// Kind of error that occurred.
    pub kind: EnableKeyRotationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableKeyRotation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableKeyRotationErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableKeyRotationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableKeyRotationErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::DisabledException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            EnableKeyRotationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableKeyRotationError {
    fn code(&self) -> Option<&str> {
        EnableKeyRotationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableKeyRotationError {
    /// Creates a new `EnableKeyRotationError`.
    pub fn new(kind: EnableKeyRotationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableKeyRotationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableKeyRotationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableKeyRotationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableKeyRotationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyRotationErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyRotationErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyRotationErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyRotationErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyRotationErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, EnableKeyRotationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `EnableKeyRotationErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKeyRotationErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for EnableKeyRotationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableKeyRotationErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::DisabledException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::InvalidArnException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::KmsInternalException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::NotFoundException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            EnableKeyRotationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Encrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EncryptError {
    /// Kind of error that occurred.
    pub kind: EncryptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Encrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EncryptErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EncryptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EncryptErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            EncryptErrorKind::DisabledException(_inner) => _inner.fmt(f),
            EncryptErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            EncryptErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            EncryptErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            EncryptErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            EncryptErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            EncryptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            EncryptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EncryptError {
    fn code(&self) -> Option<&str> {
        EncryptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EncryptError {
    /// Creates a new `EncryptError`.
    pub fn new(kind: EncryptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EncryptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EncryptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EncryptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EncryptErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::DependencyTimeoutException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::InvalidGrantTokenException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::InvalidKeyUsageException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::KeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `EncryptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, EncryptErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for EncryptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EncryptErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            EncryptErrorKind::DisabledException(_inner) => Some(_inner),
            EncryptErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            EncryptErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            EncryptErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            EncryptErrorKind::KmsInternalException(_inner) => Some(_inner),
            EncryptErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            EncryptErrorKind::NotFoundException(_inner) => Some(_inner),
            EncryptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateDataKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateDataKeyError {
    /// Kind of error that occurred.
    pub kind: GenerateDataKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateDataKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateDataKeyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateDataKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateDataKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::DisabledException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GenerateDataKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateDataKeyError {
    fn code(&self) -> Option<&str> {
        GenerateDataKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateDataKeyError {
    /// Creates a new `GenerateDataKeyError`.
    pub fn new(kind: GenerateDataKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateDataKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateDataKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateDataKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateDataKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, GenerateDataKeyErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::InvalidKeyUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::KeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GenerateDataKeyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GenerateDataKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateDataKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::DisabledException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateDataKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateDataKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateDataKeyPairError {
    /// Kind of error that occurred.
    pub kind: GenerateDataKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateDataKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateDataKeyPairErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateDataKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateDataKeyPairErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::DisabledException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GenerateDataKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateDataKeyPairError {
    fn code(&self) -> Option<&str> {
        GenerateDataKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateDataKeyPairError {
    /// Creates a new `GenerateDataKeyPairError`.
    pub fn new(kind: GenerateDataKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateDataKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateDataKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateDataKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateDataKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::DisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::InvalidKeyUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::KeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GenerateDataKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateDataKeyPairErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::DisabledException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::KmsInternalException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GenerateDataKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateDataKeyPairWithoutPlaintext` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateDataKeyPairWithoutPlaintextError {
    /// Kind of error that occurred.
    pub kind: GenerateDataKeyPairWithoutPlaintextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateDataKeyPairWithoutPlaintext` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateDataKeyPairWithoutPlaintextErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateDataKeyPairWithoutPlaintextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateDataKeyPairWithoutPlaintextError {
    fn code(&self) -> Option<&str> {
        GenerateDataKeyPairWithoutPlaintextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateDataKeyPairWithoutPlaintextError {
    /// Creates a new `GenerateDataKeyPairWithoutPlaintextError`.
    pub fn new(
        kind: GenerateDataKeyPairWithoutPlaintextErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateDataKeyPairWithoutPlaintextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateDataKeyPairWithoutPlaintextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateDataKeyPairWithoutPlaintextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateDataKeyPairWithoutPlaintextErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GenerateDataKeyPairWithoutPlaintextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateDataKeyPairWithoutPlaintextErrorKind::DependencyTimeoutException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::DisabledException(_inner) => Some(_inner),
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidGrantTokenException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::InvalidKeyUsageException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInternalException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::KmsInvalidStateException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateDataKeyPairWithoutPlaintextErrorKind::UnsupportedOperationException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyPairWithoutPlaintextErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GenerateDataKeyWithoutPlaintext` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateDataKeyWithoutPlaintextError {
    /// Kind of error that occurred.
    pub kind: GenerateDataKeyWithoutPlaintextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateDataKeyWithoutPlaintext` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateDataKeyWithoutPlaintextErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateDataKeyWithoutPlaintextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::DisabledException(_inner) => _inner.fmt(f),
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GenerateDataKeyWithoutPlaintextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateDataKeyWithoutPlaintextError {
    fn code(&self) -> Option<&str> {
        GenerateDataKeyWithoutPlaintextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateDataKeyWithoutPlaintextError {
    /// Creates a new `GenerateDataKeyWithoutPlaintextError`.
    pub fn new(
        kind: GenerateDataKeyWithoutPlaintextErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateDataKeyWithoutPlaintextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateDataKeyWithoutPlaintextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateDataKeyWithoutPlaintextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateDataKeyWithoutPlaintextErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::DisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GenerateDataKeyWithoutPlaintextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateDataKeyWithoutPlaintextErrorKind::DependencyTimeoutException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::DisabledException(_inner) => Some(_inner),
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidGrantTokenException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::InvalidKeyUsageException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::KeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInternalException(_inner) => Some(_inner),
            GenerateDataKeyWithoutPlaintextErrorKind::KmsInvalidStateException(_inner) => {
                Some(_inner)
            }
            GenerateDataKeyWithoutPlaintextErrorKind::NotFoundException(_inner) => Some(_inner),
            GenerateDataKeyWithoutPlaintextErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateRandom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateRandomError {
    /// Kind of error that occurred.
    pub kind: GenerateRandomErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateRandom` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateRandomErrorKind {
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateRandomError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateRandomErrorKind::CustomKeyStoreInvalidStateException(_inner) => _inner.fmt(f),
            GenerateRandomErrorKind::CustomKeyStoreNotFoundException(_inner) => _inner.fmt(f),
            GenerateRandomErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GenerateRandomErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GenerateRandomErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateRandomError {
    fn code(&self) -> Option<&str> {
        GenerateRandomError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateRandomError {
    /// Creates a new `GenerateRandomError`.
    pub fn new(kind: GenerateRandomErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateRandomError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateRandomErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateRandomError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateRandomErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateRandomErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateRandomErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateRandomErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateRandomErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateRandomErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateRandomErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateRandomErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, GenerateRandomErrorKind::KmsInternalException(_))
    }
}
impl std::error::Error for GenerateRandomError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateRandomErrorKind::CustomKeyStoreInvalidStateException(_inner) => Some(_inner),
            GenerateRandomErrorKind::CustomKeyStoreNotFoundException(_inner) => Some(_inner),
            GenerateRandomErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GenerateRandomErrorKind::KmsInternalException(_inner) => Some(_inner),
            GenerateRandomErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyPolicyError {
    /// Kind of error that occurred.
    pub kind: GetKeyPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyPolicyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyPolicyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GetKeyPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetKeyPolicyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GetKeyPolicyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GetKeyPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetKeyPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyPolicyError {
    fn code(&self) -> Option<&str> {
        GetKeyPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyPolicyError {
    /// Creates a new `GetKeyPolicyError`.
    pub fn new(kind: GetKeyPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyPolicyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPolicyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPolicyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPolicyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPolicyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPolicyErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPolicyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetKeyPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyPolicyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GetKeyPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetKeyPolicyErrorKind::KmsInternalException(_inner) => Some(_inner),
            GetKeyPolicyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GetKeyPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetKeyPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyRotationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyRotationStatusError {
    /// Kind of error that occurred.
    pub kind: GetKeyRotationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyRotationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyRotationStatusErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyRotationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyRotationStatusErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetKeyRotationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyRotationStatusError {
    fn code(&self) -> Option<&str> {
        GetKeyRotationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyRotationStatusError {
    /// Creates a new `GetKeyRotationStatusError`.
    pub fn new(kind: GetKeyRotationStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyRotationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyRotationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyRotationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyRotationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyRotationStatusErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyRotationStatusErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetKeyRotationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyRotationStatusErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::KmsInternalException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::NotFoundException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetKeyRotationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParametersForImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParametersForImportError {
    /// Kind of error that occurred.
    pub kind: GetParametersForImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParametersForImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParametersForImportErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParametersForImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParametersForImportErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetParametersForImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParametersForImportError {
    fn code(&self) -> Option<&str> {
        GetParametersForImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParametersForImportError {
    /// Creates a new `GetParametersForImportError`.
    pub fn new(kind: GetParametersForImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParametersForImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParametersForImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParametersForImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParametersForImportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersForImportErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersForImportErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetParametersForImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParametersForImportErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::KmsInternalException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetParametersForImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPublicKeyError {
    /// Kind of error that occurred.
    pub kind: GetPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPublicKeyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPublicKeyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::DisabledException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPublicKeyError {
    fn code(&self) -> Option<&str> {
        GetPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPublicKeyError {
    /// Creates a new `GetPublicKeyError`.
    pub fn new(kind: GetPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::InvalidKeyUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::KeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPublicKeyErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPublicKeyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::DisabledException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportKeyMaterial` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportKeyMaterialError {
    /// Kind of error that occurred.
    pub kind: ImportKeyMaterialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportKeyMaterial` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportKeyMaterialErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified import token is expired. Use <a>GetParametersForImport</a> to get a new import token and public key, use the new
    /// public key to encrypt the key material, and then try the request again.</p>
    ExpiredImportTokenException(crate::error::ExpiredImportTokenException),
    /// <p>The request was rejected because the key material in the request is, expired, invalid, or
    /// is not the same key material that was previously imported into this KMS key.</p>
    IncorrectKeyMaterialException(crate::error::IncorrectKeyMaterialException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>From the <a>Decrypt</a> or <a>ReEncrypt</a> operation, the request
    /// was rejected because the specified ciphertext, or additional authenticated data incorporated
    /// into the ciphertext, such as the encryption context, is corrupted, missing, or otherwise
    /// invalid.</p>
    /// <p>From the <a>ImportKeyMaterial</a> operation, the request was rejected because
    /// KMS could not decrypt the encrypted (wrapped) key material. </p>
    InvalidCiphertextException(crate::error::InvalidCiphertextException),
    /// <p>The request was rejected because the provided import token is invalid or is associated
    /// with a different KMS key.</p>
    InvalidImportTokenException(crate::error::InvalidImportTokenException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportKeyMaterialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportKeyMaterialErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::ExpiredImportTokenException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::IncorrectKeyMaterialException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::InvalidCiphertextException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::InvalidImportTokenException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ImportKeyMaterialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportKeyMaterialError {
    fn code(&self) -> Option<&str> {
        ImportKeyMaterialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportKeyMaterialError {
    /// Creates a new `ImportKeyMaterialError`.
    pub fn new(kind: ImportKeyMaterialErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportKeyMaterialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportKeyMaterialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportKeyMaterialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportKeyMaterialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::ExpiredImportTokenException`.
    pub fn is_expired_import_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::ExpiredImportTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::IncorrectKeyMaterialException`.
    pub fn is_incorrect_key_material_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::IncorrectKeyMaterialException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::InvalidCiphertextException`.
    pub fn is_invalid_ciphertext_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::InvalidCiphertextException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::InvalidImportTokenException`.
    pub fn is_invalid_import_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::InvalidImportTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportKeyMaterialErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ImportKeyMaterialErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyMaterialErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ImportKeyMaterialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportKeyMaterialErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::ExpiredImportTokenException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::IncorrectKeyMaterialException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::InvalidArnException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::InvalidCiphertextException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::InvalidImportTokenException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::KmsInternalException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ImportKeyMaterialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAliasesError {
    /// Kind of error that occurred.
    pub kind: ListAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAliasesErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAliasesErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAliasesError {
    fn code(&self) -> Option<&str> {
        ListAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAliasesError {
    /// Creates a new `ListAliasesError`.
    pub fn new(kind: ListAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAliasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::InvalidMarkerException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAliasesErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ListAliasesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListAliasesErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            ListAliasesErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListAliasesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGrantsError {
    /// Kind of error that occurred.
    pub kind: ListGrantsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGrantsErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>
    InvalidGrantIdException(crate::error::InvalidGrantIdException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGrantsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGrantsErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::InvalidGrantIdException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListGrantsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGrantsError {
    fn code(&self) -> Option<&str> {
        ListGrantsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGrantsError {
    /// Creates a new `ListGrantsError`.
    pub fn new(kind: ListGrantsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGrantsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGrantsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGrantsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGrantsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGrantsErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::InvalidGrantIdException`.
    pub fn is_invalid_grant_id_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::InvalidGrantIdException(_))
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::InvalidMarkerException(_))
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `ListGrantsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListGrantsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListGrantsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGrantsErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ListGrantsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListGrantsErrorKind::InvalidGrantIdException(_inner) => Some(_inner),
            ListGrantsErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            ListGrantsErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListGrantsErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ListGrantsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListGrantsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListKeyPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListKeyPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListKeyPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListKeyPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListKeyPoliciesErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListKeyPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListKeyPoliciesErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ListKeyPoliciesErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListKeyPoliciesErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListKeyPoliciesErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ListKeyPoliciesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListKeyPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListKeyPoliciesError {
    fn code(&self) -> Option<&str> {
        ListKeyPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListKeyPoliciesError {
    /// Creates a new `ListKeyPoliciesError`.
    pub fn new(kind: ListKeyPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListKeyPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListKeyPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListKeyPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListKeyPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListKeyPoliciesErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPoliciesErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPoliciesErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ListKeyPoliciesErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ListKeyPoliciesErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPoliciesErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPoliciesErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeyPoliciesErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeyPoliciesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListKeyPoliciesErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListKeyPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListKeyPoliciesErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ListKeyPoliciesErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListKeyPoliciesErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListKeyPoliciesErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ListKeyPoliciesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListKeyPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListKeysError {
    /// Kind of error that occurred.
    pub kind: ListKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListKeysErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListKeysErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ListKeysErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            ListKeysErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListKeysError {
    fn code(&self) -> Option<&str> {
        ListKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListKeysError {
    /// Creates a new `ListKeysError`.
    pub fn new(kind: ListKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListKeysErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(&self.kind, ListKeysErrorKind::DependencyTimeoutException(_))
    }
    /// Returns `true` if the error kind is `ListKeysErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(&self.kind, ListKeysErrorKind::InvalidMarkerException(_))
    }
    /// Returns `true` if the error kind is `ListKeysErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, ListKeysErrorKind::KmsInternalException(_))
    }
}
impl std::error::Error for ListKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListKeysErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ListKeysErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            ListKeysErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceTagsError {
    /// Kind of error that occurred.
    pub kind: ListResourceTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceTagsErrorKind {
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceTagsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListResourceTagsErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            ListResourceTagsErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListResourceTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListResourceTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceTagsError {
    fn code(&self) -> Option<&str> {
        ListResourceTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceTagsError {
    /// Creates a new `ListResourceTagsError`.
    pub fn new(kind: ListResourceTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceTagsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTagsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTagsErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTagsErrorKind::InvalidMarkerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTagsErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTagsErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListResourceTagsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ListResourceTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceTagsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListResourceTagsErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            ListResourceTagsErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListResourceTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListResourceTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRetirableGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRetirableGrantsError {
    /// Kind of error that occurred.
    pub kind: ListRetirableGrantsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRetirableGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRetirableGrantsErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the marker that specifies where pagination should next
    /// begin is not valid.</p>
    InvalidMarkerException(crate::error::InvalidMarkerException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRetirableGrantsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRetirableGrantsErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ListRetirableGrantsErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ListRetirableGrantsErrorKind::InvalidMarkerException(_inner) => _inner.fmt(f),
            ListRetirableGrantsErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ListRetirableGrantsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRetirableGrantsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRetirableGrantsError {
    fn code(&self) -> Option<&str> {
        ListRetirableGrantsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRetirableGrantsError {
    /// Creates a new `ListRetirableGrantsError`.
    pub fn new(kind: ListRetirableGrantsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRetirableGrantsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRetirableGrantsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRetirableGrantsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRetirableGrantsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRetirableGrantsErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetirableGrantsErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetirableGrantsErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetirableGrantsErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetirableGrantsErrorKind::InvalidMarkerException`.
    pub fn is_invalid_marker_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetirableGrantsErrorKind::InvalidMarkerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetirableGrantsErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetirableGrantsErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetirableGrantsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetirableGrantsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListRetirableGrantsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRetirableGrantsErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ListRetirableGrantsErrorKind::InvalidArnException(_inner) => Some(_inner),
            ListRetirableGrantsErrorKind::InvalidMarkerException(_inner) => Some(_inner),
            ListRetirableGrantsErrorKind::KmsInternalException(_inner) => Some(_inner),
            ListRetirableGrantsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRetirableGrantsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutKeyPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutKeyPolicyError {
    /// Kind of error that occurred.
    pub kind: PutKeyPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutKeyPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutKeyPolicyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified policy is not syntactically or semantically
    /// correct.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutKeyPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutKeyPolicyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            PutKeyPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutKeyPolicyError {
    fn code(&self) -> Option<&str> {
        PutKeyPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutKeyPolicyError {
    /// Creates a new `PutKeyPolicyError`.
    pub fn new(kind: PutKeyPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutKeyPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutKeyPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutKeyPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutKeyPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeyPolicyErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, PutKeyPolicyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, PutKeyPolicyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeyPolicyErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutKeyPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeyPolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutKeyPolicyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutKeyPolicyErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutKeyPolicyErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for PutKeyPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutKeyPolicyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::InvalidArnException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::KmsInternalException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            PutKeyPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReEncrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReEncryptError {
    /// Kind of error that occurred.
    pub kind: ReEncryptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReEncrypt` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReEncryptErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified KMS key cannot decrypt the data. The
    /// <code>KeyId</code> in a <a>Decrypt</a> request and the <code>SourceKeyId</code>
    /// in a <a>ReEncrypt</a> request must identify the same KMS key that was used to
    /// encrypt the ciphertext.</p>
    IncorrectKeyException(crate::error::IncorrectKeyException),
    /// <p>From the <a>Decrypt</a> or <a>ReEncrypt</a> operation, the request
    /// was rejected because the specified ciphertext, or additional authenticated data incorporated
    /// into the ciphertext, such as the encryption context, is corrupted, missing, or otherwise
    /// invalid.</p>
    /// <p>From the <a>ImportKeyMaterial</a> operation, the request was rejected because
    /// KMS could not decrypt the encrypted (wrapped) key material. </p>
    InvalidCiphertextException(crate::error::InvalidCiphertextException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReEncryptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReEncryptErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::DisabledException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::IncorrectKeyException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::InvalidCiphertextException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ReEncryptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReEncryptError {
    fn code(&self) -> Option<&str> {
        ReEncryptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReEncryptError {
    /// Creates a new `ReEncryptError`.
    pub fn new(kind: ReEncryptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReEncryptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReEncryptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReEncryptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReEncryptErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReEncryptErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::IncorrectKeyException`.
    pub fn is_incorrect_key_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::IncorrectKeyException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::InvalidCiphertextException`.
    pub fn is_invalid_ciphertext_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReEncryptErrorKind::InvalidCiphertextException(_)
        )
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReEncryptErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::InvalidKeyUsageException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::KeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `ReEncryptErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ReEncryptErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for ReEncryptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReEncryptErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ReEncryptErrorKind::DisabledException(_inner) => Some(_inner),
            ReEncryptErrorKind::IncorrectKeyException(_inner) => Some(_inner),
            ReEncryptErrorKind::InvalidCiphertextException(_inner) => Some(_inner),
            ReEncryptErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            ReEncryptErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            ReEncryptErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            ReEncryptErrorKind::KmsInternalException(_inner) => Some(_inner),
            ReEncryptErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ReEncryptErrorKind::NotFoundException(_inner) => Some(_inner),
            ReEncryptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReplicateKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReplicateKeyError {
    /// Kind of error that occurred.
    pub kind: ReplicateKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReplicateKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReplicateKeyErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified policy is not syntactically or semantically
    /// correct.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because one or more tags are not valid.</p>
    TagException(crate::error::TagException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReplicateKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReplicateKeyErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::DisabledException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::TagException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ReplicateKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReplicateKeyError {
    fn code(&self) -> Option<&str> {
        ReplicateKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReplicateKeyError {
    /// Creates a new `ReplicateKeyError`.
    pub fn new(kind: ReplicateKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReplicateKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReplicateKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReplicateKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReplicateKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReplicateKeyErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReplicateKeyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::TagException`.
    pub fn is_tag_exception(&self) -> bool {
        matches!(&self.kind, ReplicateKeyErrorKind::TagException(_))
    }
    /// Returns `true` if the error kind is `ReplicateKeyErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReplicateKeyErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ReplicateKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReplicateKeyErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::DisabledException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::InvalidArnException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::KmsInternalException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::TagException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ReplicateKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetireGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetireGrantError {
    /// Kind of error that occurred.
    pub kind: RetireGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetireGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetireGrantErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>
    InvalidGrantIdException(crate::error::InvalidGrantIdException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetireGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetireGrantErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::InvalidGrantIdException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RetireGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetireGrantError {
    fn code(&self) -> Option<&str> {
        RetireGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetireGrantError {
    /// Creates a new `RetireGrantError`.
    pub fn new(kind: RetireGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetireGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetireGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetireGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetireGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetireGrantErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, RetireGrantErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::InvalidGrantIdException`.
    pub fn is_invalid_grant_id_exception(&self) -> bool {
        matches!(&self.kind, RetireGrantErrorKind::InvalidGrantIdException(_))
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetireGrantErrorKind::InvalidGrantTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, RetireGrantErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetireGrantErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RetireGrantErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RetireGrantErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RetireGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetireGrantErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            RetireGrantErrorKind::InvalidArnException(_inner) => Some(_inner),
            RetireGrantErrorKind::InvalidGrantIdException(_inner) => Some(_inner),
            RetireGrantErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            RetireGrantErrorKind::KmsInternalException(_inner) => Some(_inner),
            RetireGrantErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            RetireGrantErrorKind::NotFoundException(_inner) => Some(_inner),
            RetireGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeGrantError {
    /// Kind of error that occurred.
    pub kind: RevokeGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeGrantErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>
    InvalidGrantIdException(crate::error::InvalidGrantIdException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeGrantErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::InvalidGrantIdException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RevokeGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeGrantError {
    fn code(&self) -> Option<&str> {
        RevokeGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeGrantError {
    /// Creates a new `RevokeGrantError`.
    pub fn new(kind: RevokeGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeGrantErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, RevokeGrantErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::InvalidGrantIdException`.
    pub fn is_invalid_grant_id_exception(&self) -> bool {
        matches!(&self.kind, RevokeGrantErrorKind::InvalidGrantIdException(_))
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, RevokeGrantErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeGrantErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeGrantErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RevokeGrantErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RevokeGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeGrantErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            RevokeGrantErrorKind::InvalidArnException(_inner) => Some(_inner),
            RevokeGrantErrorKind::InvalidGrantIdException(_inner) => Some(_inner),
            RevokeGrantErrorKind::KmsInternalException(_inner) => Some(_inner),
            RevokeGrantErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            RevokeGrantErrorKind::NotFoundException(_inner) => Some(_inner),
            RevokeGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ScheduleKeyDeletion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ScheduleKeyDeletionError {
    /// Kind of error that occurred.
    pub kind: ScheduleKeyDeletionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ScheduleKeyDeletion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ScheduleKeyDeletionErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ScheduleKeyDeletionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ScheduleKeyDeletionErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            ScheduleKeyDeletionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            ScheduleKeyDeletionErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            ScheduleKeyDeletionErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            ScheduleKeyDeletionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ScheduleKeyDeletionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ScheduleKeyDeletionError {
    fn code(&self) -> Option<&str> {
        ScheduleKeyDeletionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ScheduleKeyDeletionError {
    /// Creates a new `ScheduleKeyDeletionError`.
    pub fn new(kind: ScheduleKeyDeletionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ScheduleKeyDeletionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ScheduleKeyDeletionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ScheduleKeyDeletionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ScheduleKeyDeletionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ScheduleKeyDeletionErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScheduleKeyDeletionErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `ScheduleKeyDeletionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScheduleKeyDeletionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ScheduleKeyDeletionErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScheduleKeyDeletionErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ScheduleKeyDeletionErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScheduleKeyDeletionErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ScheduleKeyDeletionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScheduleKeyDeletionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ScheduleKeyDeletionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ScheduleKeyDeletionErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            ScheduleKeyDeletionErrorKind::InvalidArnException(_inner) => Some(_inner),
            ScheduleKeyDeletionErrorKind::KmsInternalException(_inner) => Some(_inner),
            ScheduleKeyDeletionErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            ScheduleKeyDeletionErrorKind::NotFoundException(_inner) => Some(_inner),
            ScheduleKeyDeletionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Sign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SignError {
    /// Kind of error that occurred.
    pub kind: SignErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Sign` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SignErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SignError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SignErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            SignErrorKind::DisabledException(_inner) => _inner.fmt(f),
            SignErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            SignErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            SignErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            SignErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            SignErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            SignErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SignErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SignError {
    fn code(&self) -> Option<&str> {
        SignError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SignError {
    /// Creates a new `SignError`.
    pub fn new(kind: SignErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SignError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SignErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SignError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SignErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SignErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::DependencyTimeoutException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::InvalidGrantTokenException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::InvalidKeyUsageException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::KeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `SignErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SignErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for SignError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SignErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            SignErrorKind::DisabledException(_inner) => Some(_inner),
            SignErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            SignErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            SignErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            SignErrorKind::KmsInternalException(_inner) => Some(_inner),
            SignErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            SignErrorKind::NotFoundException(_inner) => Some(_inner),
            SignErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because one or more tags are not valid.</p>
    TagException(crate::error::TagException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagException`.
    pub fn is_tag_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TagException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            TagResourceErrorKind::KmsInternalException(_inner) => Some(_inner),
            TagResourceErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TagException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because one or more tags are not valid.</p>
    TagException(crate::error::TagException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArnException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TagException`.
    pub fn is_tag_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidArnException(_inner) => Some(_inner),
            UntagResourceErrorKind::KmsInternalException(_inner) => Some(_inner),
            UntagResourceErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAliasErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
    /// <i>Key Management Service Developer Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAliasErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAliasError {
    fn code(&self) -> Option<&str> {
        UpdateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAliasError {
    /// Creates a new `UpdateAliasError`.
    pub fn new(kind: UpdateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UpdateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAliasErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            UpdateAliasErrorKind::KmsInternalException(_inner) => Some(_inner),
            UpdateAliasErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            UpdateAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomKeyStoreError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomKeyStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomKeyStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomKeyStoreErrorKind {
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the
    /// configuration requirements for a custom key store.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>The cluster must be configured with private subnets in at least two different
    /// Availability Zones in the Region.</p>
    /// </li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for
    /// the cluster</a> (cloudhsm-cluster-<i><cluster-id></i>-sg) must
    /// include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The
    /// <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group
    /// ID. These rules are set by default when you create the cluster. Do not delete or change
    /// them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs,
    /// use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
    /// <p>For the <a>CreateCustomKeyStore</a>, <a>UpdateCustomKeyStore</a>, and <a>CreateKey</a> operations, the CloudHSM cluster must have at least two
    /// active HSMs, each in a different Availability Zone. For the <a>ConnectCustomKeyStore</a> operation, the CloudHSM must contain at least one active
    /// HSM.</p>
    /// </li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with a
    /// custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a>
    /// in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster,
    /// see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private
    /// Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see
    /// <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security
    /// Group</a> in the <i>
    /// <i>CloudHSM User Guide</i>
    /// </i>. </p>
    CloudHsmClusterInvalidConfigurationException(
        crate::error::CloudHsmClusterInvalidConfigurationException,
    ),
    /// <p>The request was rejected because the CloudHSM cluster that is associated with the custom key
    /// store is not active. Initialize and activate the cluster and try the command again. For
    /// detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
    CloudHsmClusterNotActiveException(crate::error::CloudHsmClusterNotActiveException),
    /// <p>The request was rejected because KMS cannot find the CloudHSM cluster with the specified
    /// cluster ID. Retry the request with a different cluster ID.</p>
    CloudHsmClusterNotFoundException(crate::error::CloudHsmClusterNotFoundException),
    /// <p>The request was rejected because the specified CloudHSM cluster has a different cluster
    /// certificate than the original cluster. You cannot use the operation to specify an unrelated
    /// cluster.</p>
    /// <p>Specify a cluster that shares a backup history with the original cluster. This includes
    /// clusters that were created from a backup of the current cluster, and clusters that were
    /// created from the same backup that produced the current cluster.</p>
    /// <p>Clusters that share a backup history have the same cluster certificate. To view the
    /// cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    CloudHsmClusterNotRelatedException(crate::error::CloudHsmClusterNotRelatedException),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
    /// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
    /// operation in a custom key store that is not connected. These operations are valid only
    /// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
    /// disconnected. This operation is valid only when the custom key store
    /// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
    /// </li>
    /// <li>
    /// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
    /// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
    /// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
    /// values.</p>
    /// </li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because the specified custom key store name is already assigned
    /// to another custom key store in the account. Try again with a custom key store name that is
    /// unique in the account.</p>
    CustomKeyStoreNameInUseException(crate::error::CustomKeyStoreNameInUseException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified
    /// key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomKeyStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => _inner.fmt(f),
            UpdateCustomKeyStoreErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            UpdateCustomKeyStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomKeyStoreError {
    fn code(&self) -> Option<&str> {
        UpdateCustomKeyStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomKeyStoreError {
    /// Creates a new `UpdateCustomKeyStoreError`.
    pub fn new(kind: UpdateCustomKeyStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomKeyStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomKeyStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomKeyStoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException`.
    pub fn is_cloud_hsm_cluster_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException`.
    pub fn is_cloud_hsm_cluster_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException`.
    pub fn is_cloud_hsm_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException`.
    pub fn is_cloud_hsm_cluster_not_related_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException`.
    pub fn is_custom_key_store_name_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomKeyStoreErrorKind::KmsInternalException(_)
        )
    }
}
impl std::error::Error for UpdateCustomKeyStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterInvalidConfigurationException(_inner) => {
                Some(_inner)
            }
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotActiveException(_inner) => {
                Some(_inner)
            }
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotFoundException(_inner) => Some(_inner),
            UpdateCustomKeyStoreErrorKind::CloudHsmClusterNotRelatedException(_inner) => {
                Some(_inner)
            }
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreInvalidStateException(_inner) => {
                Some(_inner)
            }
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNameInUseException(_inner) => Some(_inner),
            UpdateCustomKeyStoreErrorKind::CustomKeyStoreNotFoundException(_inner) => Some(_inner),
            UpdateCustomKeyStoreErrorKind::KmsInternalException(_inner) => Some(_inner),
            UpdateCustomKeyStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateKeyDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateKeyDescriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateKeyDescriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateKeyDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateKeyDescriptionErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateKeyDescriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateKeyDescriptionErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            UpdateKeyDescriptionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdateKeyDescriptionErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            UpdateKeyDescriptionErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            UpdateKeyDescriptionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateKeyDescriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateKeyDescriptionError {
    fn code(&self) -> Option<&str> {
        UpdateKeyDescriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateKeyDescriptionError {
    /// Creates a new `UpdateKeyDescriptionError`.
    pub fn new(kind: UpdateKeyDescriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateKeyDescriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateKeyDescriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateKeyDescriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateKeyDescriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateKeyDescriptionErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyDescriptionErrorKind::DependencyTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyDescriptionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyDescriptionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyDescriptionErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyDescriptionErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyDescriptionErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyDescriptionErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyDescriptionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyDescriptionErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateKeyDescriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateKeyDescriptionErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            UpdateKeyDescriptionErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdateKeyDescriptionErrorKind::KmsInternalException(_inner) => Some(_inner),
            UpdateKeyDescriptionErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            UpdateKeyDescriptionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateKeyDescriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePrimaryRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePrimaryRegionError {
    /// Kind of error that occurred.
    pub kind: UpdatePrimaryRegionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePrimaryRegion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePrimaryRegionErrorKind {
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
    /// valid.</p>
    InvalidArnException(crate::error::InvalidArnException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request was rejected because a specified parameter is not supported or a specified
    /// resource is not valid for this operation.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePrimaryRegionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePrimaryRegionErrorKind::DisabledException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::InvalidArnException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            UpdatePrimaryRegionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePrimaryRegionError {
    fn code(&self) -> Option<&str> {
        UpdatePrimaryRegionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePrimaryRegionError {
    /// Creates a new `UpdatePrimaryRegionError`.
    pub fn new(kind: UpdatePrimaryRegionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePrimaryRegionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePrimaryRegionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePrimaryRegionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePrimaryRegionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::DisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::InvalidArnException`.
    pub fn is_invalid_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::InvalidArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::KmsInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePrimaryRegionErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePrimaryRegionErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdatePrimaryRegionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePrimaryRegionErrorKind::DisabledException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::InvalidArnException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::KmsInternalException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            UpdatePrimaryRegionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Verify` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyError {
    /// Kind of error that occurred.
    pub kind: VerifyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Verify` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyErrorKind {
    /// <p>The system timed out while trying to fulfill the request. The request can be
    /// retried.</p>
    DependencyTimeoutException(crate::error::DependencyTimeoutException),
    /// <p>The request was rejected because the specified KMS key is not enabled.</p>
    DisabledException(crate::error::DisabledException),
    /// <p>The request was rejected because the specified grant token is not valid.</p>
    InvalidGrantTokenException(crate::error::InvalidGrantTokenException),
    /// <p>The request was rejected for one of the following reasons: </p>
    /// <ul>
    /// <li>
    /// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>The encryption algorithm or signing algorithm specified for the operation is
    /// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
    /// </li>
    /// </ul>
    /// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
    /// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
    /// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
    /// a KMS key, use the <a>DescribeKey</a> operation.</p>
    /// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
    /// <a>DescribeKey</a> operation.</p>
    InvalidKeyUsageException(crate::error::InvalidKeyUsageException),
    /// <p>The request was rejected because the specified KMS key was not available. You can retry
    /// the request.</p>
    KeyUnavailableException(crate::error::KeyUnavailableException),
    /// <p>The request was rejected because an internal exception occurred. The request can be
    /// retried.</p>
    KmsInternalException(crate::error::KmsInternalException),
    /// <p>The request was rejected because the signature verification failed. Signature verification
    /// fails when it cannot confirm that signature was produced by signing the specified message with
    /// the specified KMS key and signing algorithm.</p>
    KmsInvalidSignatureException(crate::error::KmsInvalidSignatureException),
    /// <p>The request was rejected because the state of the specified resource is not valid for this
    /// request.</p>
    /// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
    /// key</a> in the <i>
    /// <i>Key Management Service Developer Guide</i>
    /// </i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource could not be
    /// found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyErrorKind::DependencyTimeoutException(_inner) => _inner.fmt(f),
            VerifyErrorKind::DisabledException(_inner) => _inner.fmt(f),
            VerifyErrorKind::InvalidGrantTokenException(_inner) => _inner.fmt(f),
            VerifyErrorKind::InvalidKeyUsageException(_inner) => _inner.fmt(f),
            VerifyErrorKind::KeyUnavailableException(_inner) => _inner.fmt(f),
            VerifyErrorKind::KmsInternalException(_inner) => _inner.fmt(f),
            VerifyErrorKind::KmsInvalidSignatureException(_inner) => _inner.fmt(f),
            VerifyErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            VerifyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            VerifyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyError {
    fn code(&self) -> Option<&str> {
        VerifyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyError {
    /// Creates a new `VerifyError`.
    pub fn new(kind: VerifyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::DependencyTimeoutException`.
    pub fn is_dependency_timeout_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::DependencyTimeoutException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::DisabledException`.
    pub fn is_disabled_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::DisabledException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::InvalidGrantTokenException`.
    pub fn is_invalid_grant_token_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::InvalidGrantTokenException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::InvalidKeyUsageException`.
    pub fn is_invalid_key_usage_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::InvalidKeyUsageException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::KeyUnavailableException`.
    pub fn is_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::KeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::KmsInvalidSignatureException`.
    pub fn is_kms_invalid_signature_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::KmsInvalidSignatureException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `VerifyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, VerifyErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for VerifyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyErrorKind::DependencyTimeoutException(_inner) => Some(_inner),
            VerifyErrorKind::DisabledException(_inner) => Some(_inner),
            VerifyErrorKind::InvalidGrantTokenException(_inner) => Some(_inner),
            VerifyErrorKind::InvalidKeyUsageException(_inner) => Some(_inner),
            VerifyErrorKind::KeyUnavailableException(_inner) => Some(_inner),
            VerifyErrorKind::KmsInternalException(_inner) => Some(_inner),
            VerifyErrorKind::KmsInvalidSignatureException(_inner) => Some(_inner),
            VerifyErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            VerifyErrorKind::NotFoundException(_inner) => Some(_inner),
            VerifyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was rejected because the specified entity or resource could not be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because the state of the specified resource is not valid for this
/// request.</p>
/// <p>For more information about how key state affects the use of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS
/// key</a> in the <i>
/// <i>Key Management Service Developer Guide</i>
/// </i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInvalidStateException [KMSInvalidStateException]")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidStateException {}
/// See [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
pub mod kms_invalid_state_exception {
    /// A builder for [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
        pub fn build(self) -> crate::error::KmsInvalidStateException {
            crate::error::KmsInvalidStateException {
                message: self.message,
            }
        }
    }
}
impl KmsInvalidStateException {
    /// Creates a new builder-style object to manufacture [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    pub fn builder() -> crate::error::kms_invalid_state_exception::Builder {
        crate::error::kms_invalid_state_exception::Builder::default()
    }
}

/// <p>The request was rejected because the signature verification failed. Signature verification
/// fails when it cannot confirm that signature was produced by signing the specified message with
/// the specified KMS key and signing algorithm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidSignatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInvalidSignatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidSignatureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidSignatureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidSignatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "KmsInvalidSignatureException [KMSInvalidSignatureException]"
        )?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidSignatureException {}
/// See [`KmsInvalidSignatureException`](crate::error::KmsInvalidSignatureException)
pub mod kms_invalid_signature_exception {
    /// A builder for [`KmsInvalidSignatureException`](crate::error::KmsInvalidSignatureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidSignatureException`](crate::error::KmsInvalidSignatureException)
        pub fn build(self) -> crate::error::KmsInvalidSignatureException {
            crate::error::KmsInvalidSignatureException {
                message: self.message,
            }
        }
    }
}
impl KmsInvalidSignatureException {
    /// Creates a new builder-style object to manufacture [`KmsInvalidSignatureException`](crate::error::KmsInvalidSignatureException)
    pub fn builder() -> crate::error::kms_invalid_signature_exception::Builder {
        crate::error::kms_invalid_signature_exception::Builder::default()
    }
}

/// <p>The request was rejected because an internal exception occurred. The request can be
/// retried.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInternalException [KMSInternalException]")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInternalException {}
/// See [`KmsInternalException`](crate::error::KmsInternalException)
pub mod kms_internal_exception {
    /// A builder for [`KmsInternalException`](crate::error::KmsInternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInternalException`](crate::error::KmsInternalException)
        pub fn build(self) -> crate::error::KmsInternalException {
            crate::error::KmsInternalException {
                message: self.message,
            }
        }
    }
}
impl KmsInternalException {
    /// Creates a new builder-style object to manufacture [`KmsInternalException`](crate::error::KmsInternalException)
    pub fn builder() -> crate::error::kms_internal_exception::Builder {
        crate::error::kms_internal_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified KMS key was not available. You can retry
/// the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeyUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeyUnavailableException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeyUnavailableException {}
/// See [`KeyUnavailableException`](crate::error::KeyUnavailableException)
pub mod key_unavailable_exception {
    /// A builder for [`KeyUnavailableException`](crate::error::KeyUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyUnavailableException`](crate::error::KeyUnavailableException)
        pub fn build(self) -> crate::error::KeyUnavailableException {
            crate::error::KeyUnavailableException {
                message: self.message,
            }
        }
    }
}
impl KeyUnavailableException {
    /// Creates a new builder-style object to manufacture [`KeyUnavailableException`](crate::error::KeyUnavailableException)
    pub fn builder() -> crate::error::key_unavailable_exception::Builder {
        crate::error::key_unavailable_exception::Builder::default()
    }
}

/// <p>The request was rejected for one of the following reasons: </p>
/// <ul>
/// <li>
/// <p>The <code>KeyUsage</code> value of the KMS key is incompatible with the API
/// operation.</p>
/// </li>
/// <li>
/// <p>The encryption algorithm or signing algorithm specified for the operation is
/// incompatible with the type of key material in the KMS key <code>(KeySpec</code>).</p>
/// </li>
/// </ul>
/// <p>For encrypting, decrypting, re-encrypting, and generating data keys, the
/// <code>KeyUsage</code> must be <code>ENCRYPT_DECRYPT</code>. For signing and verifying, the
/// <code>KeyUsage</code> must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of
/// a KMS key, use the <a>DescribeKey</a> operation.</p>
/// <p>To find the encryption or signing algorithms supported for a particular KMS key, use the
/// <a>DescribeKey</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKeyUsageException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKeyUsageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKeyUsageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKeyUsageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKeyUsageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKeyUsageException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKeyUsageException {}
/// See [`InvalidKeyUsageException`](crate::error::InvalidKeyUsageException)
pub mod invalid_key_usage_exception {
    /// A builder for [`InvalidKeyUsageException`](crate::error::InvalidKeyUsageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKeyUsageException`](crate::error::InvalidKeyUsageException)
        pub fn build(self) -> crate::error::InvalidKeyUsageException {
            crate::error::InvalidKeyUsageException {
                message: self.message,
            }
        }
    }
}
impl InvalidKeyUsageException {
    /// Creates a new builder-style object to manufacture [`InvalidKeyUsageException`](crate::error::InvalidKeyUsageException)
    pub fn builder() -> crate::error::invalid_key_usage_exception::Builder {
        crate::error::invalid_key_usage_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified grant token is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGrantTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGrantTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGrantTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGrantTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGrantTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGrantTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGrantTokenException {}
/// See [`InvalidGrantTokenException`](crate::error::InvalidGrantTokenException)
pub mod invalid_grant_token_exception {
    /// A builder for [`InvalidGrantTokenException`](crate::error::InvalidGrantTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGrantTokenException`](crate::error::InvalidGrantTokenException)
        pub fn build(self) -> crate::error::InvalidGrantTokenException {
            crate::error::InvalidGrantTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidGrantTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidGrantTokenException`](crate::error::InvalidGrantTokenException)
    pub fn builder() -> crate::error::invalid_grant_token_exception::Builder {
        crate::error::invalid_grant_token_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified KMS key is not enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DisabledException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for DisabledException {}
/// See [`DisabledException`](crate::error::DisabledException)
pub mod disabled_exception {
    /// A builder for [`DisabledException`](crate::error::DisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisabledException`](crate::error::DisabledException)
        pub fn build(self) -> crate::error::DisabledException {
            crate::error::DisabledException {
                message: self.message,
            }
        }
    }
}
impl DisabledException {
    /// Creates a new builder-style object to manufacture [`DisabledException`](crate::error::DisabledException)
    pub fn builder() -> crate::error::disabled_exception::Builder {
        crate::error::disabled_exception::Builder::default()
    }
}

/// <p>The system timed out while trying to fulfill the request. The request can be
/// retried.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyTimeoutException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyTimeoutException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyTimeoutException {}
/// See [`DependencyTimeoutException`](crate::error::DependencyTimeoutException)
pub mod dependency_timeout_exception {
    /// A builder for [`DependencyTimeoutException`](crate::error::DependencyTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyTimeoutException`](crate::error::DependencyTimeoutException)
        pub fn build(self) -> crate::error::DependencyTimeoutException {
            crate::error::DependencyTimeoutException {
                message: self.message,
            }
        }
    }
}
impl DependencyTimeoutException {
    /// Creates a new builder-style object to manufacture [`DependencyTimeoutException`](crate::error::DependencyTimeoutException)
    pub fn builder() -> crate::error::dependency_timeout_exception::Builder {
        crate::error::dependency_timeout_exception::Builder::default()
    }
}

/// <p>The request was rejected because a specified parameter is not supported or a specified
/// resource is not valid for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>The request was rejected because a specified ARN, or an ARN in a key policy, is not
/// valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArnException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArnException {}
/// See [`InvalidArnException`](crate::error::InvalidArnException)
pub mod invalid_arn_exception {
    /// A builder for [`InvalidArnException`](crate::error::InvalidArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArnException`](crate::error::InvalidArnException)
        pub fn build(self) -> crate::error::InvalidArnException {
            crate::error::InvalidArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidArnException {
    /// Creates a new builder-style object to manufacture [`InvalidArnException`](crate::error::InvalidArnException)
    pub fn builder() -> crate::error::invalid_arn_exception::Builder {
        crate::error::invalid_arn_exception::Builder::default()
    }
}

/// <p>The request was rejected because KMS cannot find a custom key store with the specified
/// key store name or ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomKeyStoreNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomKeyStoreNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomKeyStoreNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomKeyStoreNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomKeyStoreNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomKeyStoreNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomKeyStoreNotFoundException {}
/// See [`CustomKeyStoreNotFoundException`](crate::error::CustomKeyStoreNotFoundException)
pub mod custom_key_store_not_found_exception {
    /// A builder for [`CustomKeyStoreNotFoundException`](crate::error::CustomKeyStoreNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomKeyStoreNotFoundException`](crate::error::CustomKeyStoreNotFoundException)
        pub fn build(self) -> crate::error::CustomKeyStoreNotFoundException {
            crate::error::CustomKeyStoreNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CustomKeyStoreNotFoundException {
    /// Creates a new builder-style object to manufacture [`CustomKeyStoreNotFoundException`](crate::error::CustomKeyStoreNotFoundException)
    pub fn builder() -> crate::error::custom_key_store_not_found_exception::Builder {
        crate::error::custom_key_store_not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified custom key store name is already assigned
/// to another custom key store in the account. Try again with a custom key store name that is
/// unique in the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomKeyStoreNameInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomKeyStoreNameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomKeyStoreNameInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomKeyStoreNameInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomKeyStoreNameInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomKeyStoreNameInUseException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomKeyStoreNameInUseException {}
/// See [`CustomKeyStoreNameInUseException`](crate::error::CustomKeyStoreNameInUseException)
pub mod custom_key_store_name_in_use_exception {
    /// A builder for [`CustomKeyStoreNameInUseException`](crate::error::CustomKeyStoreNameInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomKeyStoreNameInUseException`](crate::error::CustomKeyStoreNameInUseException)
        pub fn build(self) -> crate::error::CustomKeyStoreNameInUseException {
            crate::error::CustomKeyStoreNameInUseException {
                message: self.message,
            }
        }
    }
}
impl CustomKeyStoreNameInUseException {
    /// Creates a new builder-style object to manufacture [`CustomKeyStoreNameInUseException`](crate::error::CustomKeyStoreNameInUseException)
    pub fn builder() -> crate::error::custom_key_store_name_in_use_exception::Builder {
        crate::error::custom_key_store_name_in_use_exception::Builder::default()
    }
}

/// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key
/// store. To get the <code>ConnectionState</code> of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
/// <p>This exception is thrown under the following conditions:</p>
/// <ul>
/// <li>
/// <p>You requested the <a>CreateKey</a> or <a>GenerateRandom</a>
/// operation in a custom key store that is not connected. These operations are valid only
/// when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p>
/// </li>
/// <li>
/// <p>You requested the <a>UpdateCustomKeyStore</a> or <a>DeleteCustomKeyStore</a> operation on a custom key store that is not
/// disconnected. This operation is valid only when the custom key store
/// <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p>
/// </li>
/// <li>
/// <p>You requested the <a>ConnectCustomKeyStore</a> operation on a custom key
/// store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or
/// <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code>
/// values.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomKeyStoreInvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomKeyStoreInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomKeyStoreInvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomKeyStoreInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomKeyStoreInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomKeyStoreInvalidStateException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomKeyStoreInvalidStateException {}
/// See [`CustomKeyStoreInvalidStateException`](crate::error::CustomKeyStoreInvalidStateException)
pub mod custom_key_store_invalid_state_exception {
    /// A builder for [`CustomKeyStoreInvalidStateException`](crate::error::CustomKeyStoreInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomKeyStoreInvalidStateException`](crate::error::CustomKeyStoreInvalidStateException)
        pub fn build(self) -> crate::error::CustomKeyStoreInvalidStateException {
            crate::error::CustomKeyStoreInvalidStateException {
                message: self.message,
            }
        }
    }
}
impl CustomKeyStoreInvalidStateException {
    /// Creates a new builder-style object to manufacture [`CustomKeyStoreInvalidStateException`](crate::error::CustomKeyStoreInvalidStateException)
    pub fn builder() -> crate::error::custom_key_store_invalid_state_exception::Builder {
        crate::error::custom_key_store_invalid_state_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified CloudHSM cluster has a different cluster
/// certificate than the original cluster. You cannot use the operation to specify an unrelated
/// cluster.</p>
/// <p>Specify a cluster that shares a backup history with the original cluster. This includes
/// clusters that were created from a backup of the current cluster, and clusters that were
/// created from the same backup that produced the current cluster.</p>
/// <p>Clusters that share a backup history have the same cluster certificate. To view the
/// cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmClusterNotRelatedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudHsmClusterNotRelatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmClusterNotRelatedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudHsmClusterNotRelatedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmClusterNotRelatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmClusterNotRelatedException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmClusterNotRelatedException {}
/// See [`CloudHsmClusterNotRelatedException`](crate::error::CloudHsmClusterNotRelatedException)
pub mod cloud_hsm_cluster_not_related_exception {
    /// A builder for [`CloudHsmClusterNotRelatedException`](crate::error::CloudHsmClusterNotRelatedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmClusterNotRelatedException`](crate::error::CloudHsmClusterNotRelatedException)
        pub fn build(self) -> crate::error::CloudHsmClusterNotRelatedException {
            crate::error::CloudHsmClusterNotRelatedException {
                message: self.message,
            }
        }
    }
}
impl CloudHsmClusterNotRelatedException {
    /// Creates a new builder-style object to manufacture [`CloudHsmClusterNotRelatedException`](crate::error::CloudHsmClusterNotRelatedException)
    pub fn builder() -> crate::error::cloud_hsm_cluster_not_related_exception::Builder {
        crate::error::cloud_hsm_cluster_not_related_exception::Builder::default()
    }
}

/// <p>The request was rejected because KMS cannot find the CloudHSM cluster with the specified
/// cluster ID. Retry the request with a different cluster ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmClusterNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudHsmClusterNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmClusterNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudHsmClusterNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmClusterNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmClusterNotFoundException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmClusterNotFoundException {}
/// See [`CloudHsmClusterNotFoundException`](crate::error::CloudHsmClusterNotFoundException)
pub mod cloud_hsm_cluster_not_found_exception {
    /// A builder for [`CloudHsmClusterNotFoundException`](crate::error::CloudHsmClusterNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmClusterNotFoundException`](crate::error::CloudHsmClusterNotFoundException)
        pub fn build(self) -> crate::error::CloudHsmClusterNotFoundException {
            crate::error::CloudHsmClusterNotFoundException {
                message: self.message,
            }
        }
    }
}
impl CloudHsmClusterNotFoundException {
    /// Creates a new builder-style object to manufacture [`CloudHsmClusterNotFoundException`](crate::error::CloudHsmClusterNotFoundException)
    pub fn builder() -> crate::error::cloud_hsm_cluster_not_found_exception::Builder {
        crate::error::cloud_hsm_cluster_not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because the CloudHSM cluster that is associated with the custom key
/// store is not active. Initialize and activate the cluster and try the command again. For
/// detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmClusterNotActiveException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudHsmClusterNotActiveException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmClusterNotActiveException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudHsmClusterNotActiveException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmClusterNotActiveException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmClusterNotActiveException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmClusterNotActiveException {}
/// See [`CloudHsmClusterNotActiveException`](crate::error::CloudHsmClusterNotActiveException)
pub mod cloud_hsm_cluster_not_active_exception {
    /// A builder for [`CloudHsmClusterNotActiveException`](crate::error::CloudHsmClusterNotActiveException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmClusterNotActiveException`](crate::error::CloudHsmClusterNotActiveException)
        pub fn build(self) -> crate::error::CloudHsmClusterNotActiveException {
            crate::error::CloudHsmClusterNotActiveException {
                message: self.message,
            }
        }
    }
}
impl CloudHsmClusterNotActiveException {
    /// Creates a new builder-style object to manufacture [`CloudHsmClusterNotActiveException`](crate::error::CloudHsmClusterNotActiveException)
    pub fn builder() -> crate::error::cloud_hsm_cluster_not_active_exception::Builder {
        crate::error::cloud_hsm_cluster_not_active_exception::Builder::default()
    }
}

/// <p>The request was rejected because the associated CloudHSM cluster did not meet the
/// configuration requirements for a custom key store.</p>
///
/// <ul>
/// <li>
/// <p>The cluster must be configured with private subnets in at least two different
/// Availability Zones in the Region.</p>
/// </li>
/// <li>
/// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for
/// the cluster</a> (cloudhsm-cluster-<i><cluster-id></i>-sg) must
/// include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The
/// <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group
/// ID. These rules are set by default when you create the cluster. Do not delete or change
/// them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p>
/// </li>
/// <li>
/// <p>The cluster must contain at least as many HSMs as the operation requires. To add HSMs,
/// use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
/// <p>For the <a>CreateCustomKeyStore</a>, <a>UpdateCustomKeyStore</a>, and <a>CreateKey</a> operations, the CloudHSM cluster must have at least two
/// active HSMs, each in a different Availability Zone. For the <a>ConnectCustomKeyStore</a> operation, the CloudHSM must contain at least one active
/// HSM.</p>
/// </li>
/// </ul>
/// <p>For information about the requirements for an CloudHSM cluster that is associated with a
/// custom key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a>
/// in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster,
/// see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private
/// Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see
/// <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security
/// Group</a> in the <i>
/// <i>CloudHSM User Guide</i>
/// </i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmClusterInvalidConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudHsmClusterInvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmClusterInvalidConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudHsmClusterInvalidConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmClusterInvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmClusterInvalidConfigurationException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmClusterInvalidConfigurationException {}
/// See [`CloudHsmClusterInvalidConfigurationException`](crate::error::CloudHsmClusterInvalidConfigurationException)
pub mod cloud_hsm_cluster_invalid_configuration_exception {
    /// A builder for [`CloudHsmClusterInvalidConfigurationException`](crate::error::CloudHsmClusterInvalidConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmClusterInvalidConfigurationException`](crate::error::CloudHsmClusterInvalidConfigurationException)
        pub fn build(self) -> crate::error::CloudHsmClusterInvalidConfigurationException {
            crate::error::CloudHsmClusterInvalidConfigurationException {
                message: self.message,
            }
        }
    }
}
impl CloudHsmClusterInvalidConfigurationException {
    /// Creates a new builder-style object to manufacture [`CloudHsmClusterInvalidConfigurationException`](crate::error::CloudHsmClusterInvalidConfigurationException)
    pub fn builder() -> crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder {
        crate::error::cloud_hsm_cluster_invalid_configuration_exception::Builder::default()
    }
}

/// <p>The request was rejected because a quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html">Quotas</a> in the
/// <i>Key Management Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request was rejected because one or more tags are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagException {}
/// See [`TagException`](crate::error::TagException)
pub mod tag_exception {
    /// A builder for [`TagException`](crate::error::TagException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagException`](crate::error::TagException)
        pub fn build(self) -> crate::error::TagException {
            crate::error::TagException {
                message: self.message,
            }
        }
    }
}
impl TagException {
    /// Creates a new builder-style object to manufacture [`TagException`](crate::error::TagException)
    pub fn builder() -> crate::error::tag_exception::Builder {
        crate::error::tag_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified <code>GrantId</code> is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGrantIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGrantIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGrantIdException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGrantIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGrantIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGrantIdException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGrantIdException {}
/// See [`InvalidGrantIdException`](crate::error::InvalidGrantIdException)
pub mod invalid_grant_id_exception {
    /// A builder for [`InvalidGrantIdException`](crate::error::InvalidGrantIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGrantIdException`](crate::error::InvalidGrantIdException)
        pub fn build(self) -> crate::error::InvalidGrantIdException {
            crate::error::InvalidGrantIdException {
                message: self.message,
            }
        }
    }
}
impl InvalidGrantIdException {
    /// Creates a new builder-style object to manufacture [`InvalidGrantIdException`](crate::error::InvalidGrantIdException)
    pub fn builder() -> crate::error::invalid_grant_id_exception::Builder {
        crate::error::invalid_grant_id_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified policy is not syntactically or semantically
/// correct.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedPolicyDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedPolicyDocumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedPolicyDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedPolicyDocumentException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedPolicyDocumentException {}
/// See [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
pub mod malformed_policy_document_exception {
    /// A builder for [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
        pub fn build(self) -> crate::error::MalformedPolicyDocumentException {
            crate::error::MalformedPolicyDocumentException {
                message: self.message,
            }
        }
    }
}
impl MalformedPolicyDocumentException {
    /// Creates a new builder-style object to manufacture [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    pub fn builder() -> crate::error::malformed_policy_document_exception::Builder {
        crate::error::malformed_policy_document_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to create a resource that already
/// exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>From the <a>Decrypt</a> or <a>ReEncrypt</a> operation, the request
/// was rejected because the specified ciphertext, or additional authenticated data incorporated
/// into the ciphertext, such as the encryption context, is corrupted, missing, or otherwise
/// invalid.</p>
/// <p>From the <a>ImportKeyMaterial</a> operation, the request was rejected because
/// KMS could not decrypt the encrypted (wrapped) key material. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCiphertextException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCiphertextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCiphertextException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCiphertextException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCiphertextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCiphertextException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCiphertextException {}
/// See [`InvalidCiphertextException`](crate::error::InvalidCiphertextException)
pub mod invalid_ciphertext_exception {
    /// A builder for [`InvalidCiphertextException`](crate::error::InvalidCiphertextException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCiphertextException`](crate::error::InvalidCiphertextException)
        pub fn build(self) -> crate::error::InvalidCiphertextException {
            crate::error::InvalidCiphertextException {
                message: self.message,
            }
        }
    }
}
impl InvalidCiphertextException {
    /// Creates a new builder-style object to manufacture [`InvalidCiphertextException`](crate::error::InvalidCiphertextException)
    pub fn builder() -> crate::error::invalid_ciphertext_exception::Builder {
        crate::error::invalid_ciphertext_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified KMS key cannot decrypt the data. The
/// <code>KeyId</code> in a <a>Decrypt</a> request and the <code>SourceKeyId</code>
/// in a <a>ReEncrypt</a> request must identify the same KMS key that was used to
/// encrypt the ciphertext.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectKeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncorrectKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectKeyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectKeyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectKeyException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectKeyException {}
/// See [`IncorrectKeyException`](crate::error::IncorrectKeyException)
pub mod incorrect_key_exception {
    /// A builder for [`IncorrectKeyException`](crate::error::IncorrectKeyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectKeyException`](crate::error::IncorrectKeyException)
        pub fn build(self) -> crate::error::IncorrectKeyException {
            crate::error::IncorrectKeyException {
                message: self.message,
            }
        }
    }
}
impl IncorrectKeyException {
    /// Creates a new builder-style object to manufacture [`IncorrectKeyException`](crate::error::IncorrectKeyException)
    pub fn builder() -> crate::error::incorrect_key_exception::Builder {
        crate::error::incorrect_key_exception::Builder::default()
    }
}

/// <p>The request was rejected because the marker that specifies where pagination should next
/// begin is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidMarkerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidMarkerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidMarkerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidMarkerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidMarkerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidMarkerException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidMarkerException {}
/// See [`InvalidMarkerException`](crate::error::InvalidMarkerException)
pub mod invalid_marker_exception {
    /// A builder for [`InvalidMarkerException`](crate::error::InvalidMarkerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidMarkerException`](crate::error::InvalidMarkerException)
        pub fn build(self) -> crate::error::InvalidMarkerException {
            crate::error::InvalidMarkerException {
                message: self.message,
            }
        }
    }
}
impl InvalidMarkerException {
    /// Creates a new builder-style object to manufacture [`InvalidMarkerException`](crate::error::InvalidMarkerException)
    pub fn builder() -> crate::error::invalid_marker_exception::Builder {
        crate::error::invalid_marker_exception::Builder::default()
    }
}

/// <p>The request was rejected because the provided import token is invalid or is associated
/// with a different KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidImportTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidImportTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidImportTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidImportTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidImportTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidImportTokenException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidImportTokenException {}
/// See [`InvalidImportTokenException`](crate::error::InvalidImportTokenException)
pub mod invalid_import_token_exception {
    /// A builder for [`InvalidImportTokenException`](crate::error::InvalidImportTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidImportTokenException`](crate::error::InvalidImportTokenException)
        pub fn build(self) -> crate::error::InvalidImportTokenException {
            crate::error::InvalidImportTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidImportTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidImportTokenException`](crate::error::InvalidImportTokenException)
    pub fn builder() -> crate::error::invalid_import_token_exception::Builder {
        crate::error::invalid_import_token_exception::Builder::default()
    }
}

/// <p>The request was rejected because the key material in the request is, expired, invalid, or
/// is not the same key material that was previously imported into this KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectKeyMaterialException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncorrectKeyMaterialException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectKeyMaterialException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectKeyMaterialException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectKeyMaterialException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectKeyMaterialException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectKeyMaterialException {}
/// See [`IncorrectKeyMaterialException`](crate::error::IncorrectKeyMaterialException)
pub mod incorrect_key_material_exception {
    /// A builder for [`IncorrectKeyMaterialException`](crate::error::IncorrectKeyMaterialException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectKeyMaterialException`](crate::error::IncorrectKeyMaterialException)
        pub fn build(self) -> crate::error::IncorrectKeyMaterialException {
            crate::error::IncorrectKeyMaterialException {
                message: self.message,
            }
        }
    }
}
impl IncorrectKeyMaterialException {
    /// Creates a new builder-style object to manufacture [`IncorrectKeyMaterialException`](crate::error::IncorrectKeyMaterialException)
    pub fn builder() -> crate::error::incorrect_key_material_exception::Builder {
        crate::error::incorrect_key_material_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified import token is expired. Use <a>GetParametersForImport</a> to get a new import token and public key, use the new
/// public key to encrypt the key material, and then try the request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredImportTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredImportTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredImportTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredImportTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredImportTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredImportTokenException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredImportTokenException {}
/// See [`ExpiredImportTokenException`](crate::error::ExpiredImportTokenException)
pub mod expired_import_token_exception {
    /// A builder for [`ExpiredImportTokenException`](crate::error::ExpiredImportTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredImportTokenException`](crate::error::ExpiredImportTokenException)
        pub fn build(self) -> crate::error::ExpiredImportTokenException {
            crate::error::ExpiredImportTokenException {
                message: self.message,
            }
        }
    }
}
impl ExpiredImportTokenException {
    /// Creates a new builder-style object to manufacture [`ExpiredImportTokenException`](crate::error::ExpiredImportTokenException)
    pub fn builder() -> crate::error::expired_import_token_exception::Builder {
        crate::error::expired_import_token_exception::Builder::default()
    }
}

/// <p>The request was rejected because the custom key store contains KMS keys. After verifying
/// that you do not need to use the KMS keys, use the <a>ScheduleKeyDeletion</a>
/// operation to delete the KMS keys. After they are deleted, you can delete the custom key
/// store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomKeyStoreHasCmKsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomKeyStoreHasCmKsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomKeyStoreHasCmKsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomKeyStoreHasCmKsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomKeyStoreHasCmKsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "CustomKeyStoreHasCmKsException [CustomKeyStoreHasCMKsException]"
        )?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomKeyStoreHasCmKsException {}
/// See [`CustomKeyStoreHasCmKsException`](crate::error::CustomKeyStoreHasCmKsException)
pub mod custom_key_store_has_cm_ks_exception {
    /// A builder for [`CustomKeyStoreHasCmKsException`](crate::error::CustomKeyStoreHasCmKsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomKeyStoreHasCmKsException`](crate::error::CustomKeyStoreHasCmKsException)
        pub fn build(self) -> crate::error::CustomKeyStoreHasCmKsException {
            crate::error::CustomKeyStoreHasCmKsException {
                message: self.message,
            }
        }
    }
}
impl CustomKeyStoreHasCmKsException {
    /// Creates a new builder-style object to manufacture [`CustomKeyStoreHasCmKsException`](crate::error::CustomKeyStoreHasCmKsException)
    pub fn builder() -> crate::error::custom_key_store_has_cm_ks_exception::Builder {
        crate::error::custom_key_store_has_cm_ks_exception::Builder::default()
    }
}

/// <p>The request was rejected because the trust anchor certificate in the request is not the
/// trust anchor certificate for the specified CloudHSM cluster.</p>
/// <p>When you <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr">initialize the cluster</a>, you create the trust anchor certificate and save it in the
/// <code>customerCA.crt</code> file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectTrustAnchorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncorrectTrustAnchorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectTrustAnchorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectTrustAnchorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectTrustAnchorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectTrustAnchorException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectTrustAnchorException {}
/// See [`IncorrectTrustAnchorException`](crate::error::IncorrectTrustAnchorException)
pub mod incorrect_trust_anchor_exception {
    /// A builder for [`IncorrectTrustAnchorException`](crate::error::IncorrectTrustAnchorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectTrustAnchorException`](crate::error::IncorrectTrustAnchorException)
        pub fn build(self) -> crate::error::IncorrectTrustAnchorException {
            crate::error::IncorrectTrustAnchorException {
                message: self.message,
            }
        }
    }
}
impl IncorrectTrustAnchorException {
    /// Creates a new builder-style object to manufacture [`IncorrectTrustAnchorException`](crate::error::IncorrectTrustAnchorException)
    pub fn builder() -> crate::error::incorrect_trust_anchor_exception::Builder {
        crate::error::incorrect_trust_anchor_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified CloudHSM cluster is already associated with a
/// custom key store or it shares a backup history with a cluster that is associated with a custom
/// key store. Each custom key store must be associated with a different CloudHSM cluster.</p>
/// <p>Clusters that share a backup history have the same cluster certificate. To view the
/// cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmClusterInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudHsmClusterInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmClusterInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudHsmClusterInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmClusterInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmClusterInUseException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmClusterInUseException {}
/// See [`CloudHsmClusterInUseException`](crate::error::CloudHsmClusterInUseException)
pub mod cloud_hsm_cluster_in_use_exception {
    /// A builder for [`CloudHsmClusterInUseException`](crate::error::CloudHsmClusterInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmClusterInUseException`](crate::error::CloudHsmClusterInUseException)
        pub fn build(self) -> crate::error::CloudHsmClusterInUseException {
            crate::error::CloudHsmClusterInUseException {
                message: self.message,
            }
        }
    }
}
impl CloudHsmClusterInUseException {
    /// Creates a new builder-style object to manufacture [`CloudHsmClusterInUseException`](crate::error::CloudHsmClusterInUseException)
    pub fn builder() -> crate::error::cloud_hsm_cluster_in_use_exception::Builder {
        crate::error::cloud_hsm_cluster_in_use_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified alias name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAliasNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAliasNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAliasNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAliasNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAliasNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAliasNameException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAliasNameException {}
/// See [`InvalidAliasNameException`](crate::error::InvalidAliasNameException)
pub mod invalid_alias_name_exception {
    /// A builder for [`InvalidAliasNameException`](crate::error::InvalidAliasNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAliasNameException`](crate::error::InvalidAliasNameException)
        pub fn build(self) -> crate::error::InvalidAliasNameException {
            crate::error::InvalidAliasNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidAliasNameException {
    /// Creates a new builder-style object to manufacture [`InvalidAliasNameException`](crate::error::InvalidAliasNameException)
    pub fn builder() -> crate::error::invalid_alias_name_exception::Builder {
        crate::error::invalid_alias_name_exception::Builder::default()
    }
}
