// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure for the ICE server connection data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IceServer {
    /// <p>An array of URIs, in the form specified in the <a href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03">I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different
    /// addresses and/or protocols that can be used to reach the TURN server.</p>
    pub uris: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A username to login to the ICE server.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>A password to login to the ICE server.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The period of time, in seconds, during which the username and password are
    /// valid.</p>
    pub ttl: i32,
}
impl std::fmt::Debug for IceServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IceServer");
        formatter.field("uris", &self.uris);
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.field("ttl", &self.ttl);
        formatter.finish()
    }
}
/// See [`IceServer`](crate::model::IceServer)
pub mod ice_server {
    /// A builder for [`IceServer`](crate::model::IceServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uris: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `uris`.
        ///
        /// To override the contents of this collection use [`set_uris`](Self::set_uris).
        ///
        /// <p>An array of URIs, in the form specified in the <a href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03">I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different
        /// addresses and/or protocols that can be used to reach the TURN server.</p>
        pub fn uris(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.uris.unwrap_or_default();
            v.push(input.into());
            self.uris = Some(v);
            self
        }
        /// <p>An array of URIs, in the form specified in the <a href="https://tools.ietf.org/html/draft-petithuguenin-behave-turn-uris-03">I-D.petithuguenin-behave-turn-uris</a> spec. These URIs provide the different
        /// addresses and/or protocols that can be used to reach the TURN server.</p>
        pub fn set_uris(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.uris = input;
            self
        }
        /// <p>A username to login to the ICE server.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>A username to login to the ICE server.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>A password to login to the ICE server.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>A password to login to the ICE server.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The period of time, in seconds, during which the username and password are
        /// valid.</p>
        pub fn ttl(mut self, input: i32) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The period of time, in seconds, during which the username and password are
        /// valid.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`IceServer`](crate::model::IceServer)
        pub fn build(self) -> crate::model::IceServer {
            crate::model::IceServer {
                uris: self.uris,
                username: self.username,
                password: self.password,
                ttl: self.ttl.unwrap_or_default(),
            }
        }
    }
}
impl IceServer {
    /// Creates a new builder-style object to manufacture [`IceServer`](crate::model::IceServer)
    pub fn builder() -> crate::model::ice_server::Builder {
        crate::model::ice_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Service {
    #[allow(missing_docs)] // documentation missing in model
    Turn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Service {
    fn from(s: &str) -> Self {
        match s {
            "TURN" => Service::Turn,
            other => Service::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Service {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Service::from(s))
    }
}
impl Service {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Service::Turn => "TURN",
            Service::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TURN"]
    }
}
impl AsRef<str> for Service {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
