// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Your request was throttled because you have exceeded the limit of allowed client
    /// calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The specified client is invalid.</p>
    InvalidClientException(crate::error::InvalidClientException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>The specified resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>If the client session is expired. Once the client is connected, the session is valid
    /// for 45 minutes. Client should reconnect to the channel to continue sending/receiving
    /// messages.</p>
    SessionExpiredException(crate::error::SessionExpiredException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ClientLimitExceededException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::InvalidClientException(inner) => inner.fmt(f),
            Error::NotAuthorizedException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::SessionExpiredException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetIceServerConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetIceServerConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetIceServerConfigErrorKind::ClientLimitExceededException(inner) => {
                    Error::ClientLimitExceededException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::InvalidClientException(inner) => {
                    Error::InvalidClientException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::NotAuthorizedException(inner) => {
                    Error::NotAuthorizedException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::SessionExpiredException(inner) => {
                    Error::SessionExpiredException(inner)
                }
                crate::error::GetIceServerConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SendAlexaOfferToMasterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SendAlexaOfferToMasterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SendAlexaOfferToMasterErrorKind::ClientLimitExceededException(
                    inner,
                ) => Error::ClientLimitExceededException(inner),
                crate::error::SendAlexaOfferToMasterErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::SendAlexaOfferToMasterErrorKind::NotAuthorizedException(inner) => {
                    Error::NotAuthorizedException(inner)
                }
                crate::error::SendAlexaOfferToMasterErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::SendAlexaOfferToMasterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
