// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`GetIceServerConfigInput`](crate::input::GetIceServerConfigInput)
pub mod get_ice_server_config_input {
    /// A builder for [`GetIceServerConfigInput`](crate::input::GetIceServerConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between
        /// configured peers. </p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between
        /// configured peers. </p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid
        /// value.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid
        /// value.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>An optional user ID to be associated with the credentials.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>An optional user ID to be associated with the credentials.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIceServerConfigInput`](crate::input::GetIceServerConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIceServerConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIceServerConfigInput {
                channel_arn: self.channel_arn,
                client_id: self.client_id,
                service: self.service,
                username: self.username,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIceServerConfigInputOperationOutputAlias = crate::operation::GetIceServerConfig;
#[doc(hidden)]
pub type GetIceServerConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIceServerConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetIceServerConfig`](crate::operation::GetIceServerConfig)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIceServerConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIceServerConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/get-ice-server-config").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIceServerConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIceServerConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ice_server_config(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIceServerConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIceServerConfig",
            "kinesisvideosignaling",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIceServerConfigInput`](crate::input::GetIceServerConfigInput)
    pub fn builder() -> crate::input::get_ice_server_config_input::Builder {
        crate::input::get_ice_server_config_input::Builder::default()
    }
}

/// See [`SendAlexaOfferToMasterInput`](crate::input::SendAlexaOfferToMasterInput)
pub mod send_alexa_offer_to_master_input {
    /// A builder for [`SendAlexaOfferToMasterInput`](crate::input::SendAlexaOfferToMasterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) sender_client_id: std::option::Option<std::string::String>,
        pub(crate) message_payload: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the signaling channel by which Alexa and the master peer
        /// communicate.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signaling channel by which Alexa and the master peer
        /// communicate.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The unique identifier for the sender client.</p>
        pub fn sender_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_client_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the sender client.</p>
        pub fn set_sender_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sender_client_id = input;
            self
        }
        /// <p>The base64-encoded SDP offer content.</p>
        pub fn message_payload(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_payload = Some(input.into());
            self
        }
        /// <p>The base64-encoded SDP offer content.</p>
        pub fn set_message_payload(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_payload = input;
            self
        }
        /// Consumes the builder and constructs a [`SendAlexaOfferToMasterInput`](crate::input::SendAlexaOfferToMasterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendAlexaOfferToMasterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendAlexaOfferToMasterInput {
                channel_arn: self.channel_arn,
                sender_client_id: self.sender_client_id,
                message_payload: self.message_payload,
            })
        }
    }
}
#[doc(hidden)]
pub type SendAlexaOfferToMasterInputOperationOutputAlias = crate::operation::SendAlexaOfferToMaster;
#[doc(hidden)]
pub type SendAlexaOfferToMasterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendAlexaOfferToMasterInput {
    /// Consumes the builder and constructs an Operation<[`SendAlexaOfferToMaster`](crate::operation::SendAlexaOfferToMaster)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendAlexaOfferToMaster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendAlexaOfferToMasterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/send-alexa-offer-to-master").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendAlexaOfferToMasterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendAlexaOfferToMasterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_alexa_offer_to_master(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendAlexaOfferToMaster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendAlexaOfferToMaster",
            "kinesisvideosignaling",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendAlexaOfferToMasterInput`](crate::input::SendAlexaOfferToMasterInput)
    pub fn builder() -> crate::input::send_alexa_offer_to_master_input::Builder {
        crate::input::send_alexa_offer_to_master_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendAlexaOfferToMasterInput {
    /// <p>The ARN of the signaling channel by which Alexa and the master peer
    /// communicate.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the sender client.</p>
    pub sender_client_id: std::option::Option<std::string::String>,
    /// <p>The base64-encoded SDP offer content.</p>
    pub message_payload: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SendAlexaOfferToMasterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendAlexaOfferToMasterInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("sender_client_id", &self.sender_client_id);
        formatter.field("message_payload", &self.message_payload);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIceServerConfigInput {
    /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between
    /// configured peers. </p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid
    /// value.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>An optional user ID to be associated with the credentials.</p>
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetIceServerConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIceServerConfigInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("client_id", &self.client_id);
        formatter.field("service", &self.service);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
