// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a segment of video or other time-delimited data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fragment {
    /// <p>The unique identifier of the fragment. This value monotonically increases based on the ingestion order.</p>
    pub fragment_number: std::option::Option<std::string::String>,
    /// <p>The total fragment size, including information about the fragment and contained media data.</p>
    pub fragment_size_in_bytes: i64,
    /// <p>The timestamp from the producer corresponding to the fragment.</p>
    pub producer_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp from the AWS server corresponding to the fragment.</p>
    pub server_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The playback duration or other time value associated with the fragment.</p>
    pub fragment_length_in_milliseconds: i64,
}
impl Fragment {
    /// <p>The unique identifier of the fragment. This value monotonically increases based on the ingestion order.</p>
    pub fn fragment_number(&self) -> std::option::Option<&str> {
        self.fragment_number.as_deref()
    }
    /// <p>The total fragment size, including information about the fragment and contained media data.</p>
    pub fn fragment_size_in_bytes(&self) -> i64 {
        self.fragment_size_in_bytes
    }
    /// <p>The timestamp from the producer corresponding to the fragment.</p>
    pub fn producer_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.producer_timestamp.as_ref()
    }
    /// <p>The timestamp from the AWS server corresponding to the fragment.</p>
    pub fn server_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.server_timestamp.as_ref()
    }
    /// <p>The playback duration or other time value associated with the fragment.</p>
    pub fn fragment_length_in_milliseconds(&self) -> i64 {
        self.fragment_length_in_milliseconds
    }
}
impl std::fmt::Debug for Fragment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fragment");
        formatter.field("fragment_number", &self.fragment_number);
        formatter.field("fragment_size_in_bytes", &self.fragment_size_in_bytes);
        formatter.field("producer_timestamp", &self.producer_timestamp);
        formatter.field("server_timestamp", &self.server_timestamp);
        formatter.field(
            "fragment_length_in_milliseconds",
            &self.fragment_length_in_milliseconds,
        );
        formatter.finish()
    }
}
/// See [`Fragment`](crate::model::Fragment)
pub mod fragment {
    /// A builder for [`Fragment`](crate::model::Fragment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fragment_number: std::option::Option<std::string::String>,
        pub(crate) fragment_size_in_bytes: std::option::Option<i64>,
        pub(crate) producer_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) server_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) fragment_length_in_milliseconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier of the fragment. This value monotonically increases based on the ingestion order.</p>
        pub fn fragment_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.fragment_number = Some(input.into());
            self
        }
        /// <p>The unique identifier of the fragment. This value monotonically increases based on the ingestion order.</p>
        pub fn set_fragment_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fragment_number = input;
            self
        }
        /// <p>The total fragment size, including information about the fragment and contained media data.</p>
        pub fn fragment_size_in_bytes(mut self, input: i64) -> Self {
            self.fragment_size_in_bytes = Some(input);
            self
        }
        /// <p>The total fragment size, including information about the fragment and contained media data.</p>
        pub fn set_fragment_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.fragment_size_in_bytes = input;
            self
        }
        /// <p>The timestamp from the producer corresponding to the fragment.</p>
        pub fn producer_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.producer_timestamp = Some(input);
            self
        }
        /// <p>The timestamp from the producer corresponding to the fragment.</p>
        pub fn set_producer_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.producer_timestamp = input;
            self
        }
        /// <p>The timestamp from the AWS server corresponding to the fragment.</p>
        pub fn server_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.server_timestamp = Some(input);
            self
        }
        /// <p>The timestamp from the AWS server corresponding to the fragment.</p>
        pub fn set_server_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.server_timestamp = input;
            self
        }
        /// <p>The playback duration or other time value associated with the fragment.</p>
        pub fn fragment_length_in_milliseconds(mut self, input: i64) -> Self {
            self.fragment_length_in_milliseconds = Some(input);
            self
        }
        /// <p>The playback duration or other time value associated with the fragment.</p>
        pub fn set_fragment_length_in_milliseconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.fragment_length_in_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`Fragment`](crate::model::Fragment)
        pub fn build(self) -> crate::model::Fragment {
            crate::model::Fragment {
                fragment_number: self.fragment_number,
                fragment_size_in_bytes: self.fragment_size_in_bytes.unwrap_or_default(),
                producer_timestamp: self.producer_timestamp,
                server_timestamp: self.server_timestamp,
                fragment_length_in_milliseconds: self
                    .fragment_length_in_milliseconds
                    .unwrap_or_default(),
            }
        }
    }
}
impl Fragment {
    /// Creates a new builder-style object to manufacture [`Fragment`](crate::model::Fragment)
    pub fn builder() -> crate::model::fragment::Builder {
        crate::model::fragment::Builder::default()
    }
}

/// <p>Describes the timestamp range and timestamp origin of a range of fragments.</p>
/// <p>Only fragments with a start timestamp greater than or equal to the given start time and less than or equal to the end time are returned. For example, if a stream contains fragments with the following start timestamps: </p>
/// <ul>
/// <li> <p>00:00:00</p> </li>
/// <li> <p>00:00:02</p> </li>
/// <li> <p>00:00:04</p> </li>
/// <li> <p>00:00:06</p> </li>
/// </ul>
/// <p> A fragment selector range with a start time of 00:00:01 and end time of 00:00:04 would return the fragments with start times of 00:00:02 and 00:00:04. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FragmentSelector {
    /// <p>The origin of the timestamps to use (Server or Producer).</p>
    pub fragment_selector_type: std::option::Option<crate::model::FragmentSelectorType>,
    /// <p>The range of timestamps to return.</p>
    pub timestamp_range: std::option::Option<crate::model::TimestampRange>,
}
impl FragmentSelector {
    /// <p>The origin of the timestamps to use (Server or Producer).</p>
    pub fn fragment_selector_type(
        &self,
    ) -> std::option::Option<&crate::model::FragmentSelectorType> {
        self.fragment_selector_type.as_ref()
    }
    /// <p>The range of timestamps to return.</p>
    pub fn timestamp_range(&self) -> std::option::Option<&crate::model::TimestampRange> {
        self.timestamp_range.as_ref()
    }
}
impl std::fmt::Debug for FragmentSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FragmentSelector");
        formatter.field("fragment_selector_type", &self.fragment_selector_type);
        formatter.field("timestamp_range", &self.timestamp_range);
        formatter.finish()
    }
}
/// See [`FragmentSelector`](crate::model::FragmentSelector)
pub mod fragment_selector {
    /// A builder for [`FragmentSelector`](crate::model::FragmentSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fragment_selector_type: std::option::Option<crate::model::FragmentSelectorType>,
        pub(crate) timestamp_range: std::option::Option<crate::model::TimestampRange>,
    }
    impl Builder {
        /// <p>The origin of the timestamps to use (Server or Producer).</p>
        pub fn fragment_selector_type(mut self, input: crate::model::FragmentSelectorType) -> Self {
            self.fragment_selector_type = Some(input);
            self
        }
        /// <p>The origin of the timestamps to use (Server or Producer).</p>
        pub fn set_fragment_selector_type(
            mut self,
            input: std::option::Option<crate::model::FragmentSelectorType>,
        ) -> Self {
            self.fragment_selector_type = input;
            self
        }
        /// <p>The range of timestamps to return.</p>
        pub fn timestamp_range(mut self, input: crate::model::TimestampRange) -> Self {
            self.timestamp_range = Some(input);
            self
        }
        /// <p>The range of timestamps to return.</p>
        pub fn set_timestamp_range(
            mut self,
            input: std::option::Option<crate::model::TimestampRange>,
        ) -> Self {
            self.timestamp_range = input;
            self
        }
        /// Consumes the builder and constructs a [`FragmentSelector`](crate::model::FragmentSelector)
        pub fn build(self) -> crate::model::FragmentSelector {
            crate::model::FragmentSelector {
                fragment_selector_type: self.fragment_selector_type,
                timestamp_range: self.timestamp_range,
            }
        }
    }
}
impl FragmentSelector {
    /// Creates a new builder-style object to manufacture [`FragmentSelector`](crate::model::FragmentSelector)
    pub fn builder() -> crate::model::fragment_selector::Builder {
        crate::model::fragment_selector::Builder::default()
    }
}

/// <p>The range of timestamps for which to return fragments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampRange {
    /// <p>The starting timestamp in the range of timestamps for which to return fragments.</p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ending timestamp in the range of timestamps for which to return fragments.</p>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimestampRange {
    /// <p>The starting timestamp in the range of timestamps for which to return fragments.</p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The ending timestamp in the range of timestamps for which to return fragments.</p>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
}
impl std::fmt::Debug for TimestampRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampRange");
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.finish()
    }
}
/// See [`TimestampRange`](crate::model::TimestampRange)
pub mod timestamp_range {
    /// A builder for [`TimestampRange`](crate::model::TimestampRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The starting timestamp in the range of timestamps for which to return fragments.</p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The starting timestamp in the range of timestamps for which to return fragments.</p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The ending timestamp in the range of timestamps for which to return fragments.</p>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The ending timestamp in the range of timestamps for which to return fragments.</p>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampRange`](crate::model::TimestampRange)
        pub fn build(self) -> crate::model::TimestampRange {
            crate::model::TimestampRange {
                start_timestamp: self.start_timestamp,
                end_timestamp: self.end_timestamp,
            }
        }
    }
}
impl TimestampRange {
    /// Creates a new builder-style object to manufacture [`TimestampRange`](crate::model::TimestampRange)
    pub fn builder() -> crate::model::timestamp_range::Builder {
        crate::model::timestamp_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FragmentSelectorType {
    #[allow(missing_docs)] // documentation missing in model
    ProducerTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ServerTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FragmentSelectorType {
    fn from(s: &str) -> Self {
        match s {
            "PRODUCER_TIMESTAMP" => FragmentSelectorType::ProducerTimestamp,
            "SERVER_TIMESTAMP" => FragmentSelectorType::ServerTimestamp,
            other => FragmentSelectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FragmentSelectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FragmentSelectorType::from(s))
    }
}
impl FragmentSelectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FragmentSelectorType::ProducerTimestamp => "PRODUCER_TIMESTAMP",
            FragmentSelectorType::ServerTimestamp => "SERVER_TIMESTAMP",
            FragmentSelectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRODUCER_TIMESTAMP", "SERVER_TIMESTAMP"]
    }
}
impl AsRef<str> for FragmentSelectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains the <code>Timestamp</code>, <code>Error</code>, and <code>ImageContent</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This field is used to manage gaps on images or to better understand the pagination window.</p>
    pub time_stamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error. An error will be returned if: </p>
    /// <ul>
    /// <li> <p>There is no media that exists for the specified <code>Timestamp</code>.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>The media for the specified time does not allow an image to be extracted. In this case the media is audio only, or the incorrect media has been ingested.</p> </li>
    /// </ul>
    pub error: std::option::Option<crate::model::ImageError>,
    /// <p>An attribute of the <code>Image</code> object that is Base64 encoded.</p>
    pub image_content: std::option::Option<std::string::String>,
}
impl Image {
    /// <p>An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This field is used to manage gaps on images or to better understand the pagination window.</p>
    pub fn time_stamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_stamp.as_ref()
    }
    /// <p>The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error. An error will be returned if: </p>
    /// <ul>
    /// <li> <p>There is no media that exists for the specified <code>Timestamp</code>.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>The media for the specified time does not allow an image to be extracted. In this case the media is audio only, or the incorrect media has been ingested.</p> </li>
    /// </ul>
    pub fn error(&self) -> std::option::Option<&crate::model::ImageError> {
        self.error.as_ref()
    }
    /// <p>An attribute of the <code>Image</code> object that is Base64 encoded.</p>
    pub fn image_content(&self) -> std::option::Option<&str> {
        self.image_content.as_deref()
    }
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("time_stamp", &self.time_stamp);
        formatter.field("error", &self.error);
        formatter.field("image_content", &self.image_content);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_stamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error: std::option::Option<crate::model::ImageError>,
        pub(crate) image_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This field is used to manage gaps on images or to better understand the pagination window.</p>
        pub fn time_stamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_stamp = Some(input);
            self
        }
        /// <p>An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This field is used to manage gaps on images or to better understand the pagination window.</p>
        pub fn set_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_stamp = input;
            self
        }
        /// <p>The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error. An error will be returned if: </p>
        /// <ul>
        /// <li> <p>There is no media that exists for the specified <code>Timestamp</code>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>The media for the specified time does not allow an image to be extracted. In this case the media is audio only, or the incorrect media has been ingested.</p> </li>
        /// </ul>
        pub fn error(mut self, input: crate::model::ImageError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error. An error will be returned if: </p>
        /// <ul>
        /// <li> <p>There is no media that exists for the specified <code>Timestamp</code>.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>The media for the specified time does not allow an image to be extracted. In this case the media is audio only, or the incorrect media has been ingested.</p> </li>
        /// </ul>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ImageError>) -> Self {
            self.error = input;
            self
        }
        /// <p>An attribute of the <code>Image</code> object that is Base64 encoded.</p>
        pub fn image_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_content = Some(input.into());
            self
        }
        /// <p>An attribute of the <code>Image</code> object that is Base64 encoded.</p>
        pub fn set_image_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_content = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                time_stamp: self.time_stamp,
                error: self.error,
                image_content: self.image_content,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageError {
    #[allow(missing_docs)] // documentation missing in model
    MediaError,
    #[allow(missing_docs)] // documentation missing in model
    NoMedia,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageError {
    fn from(s: &str) -> Self {
        match s {
            "MEDIA_ERROR" => ImageError::MediaError,
            "NO_MEDIA" => ImageError::NoMedia,
            other => ImageError::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageError {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageError::from(s))
    }
}
impl ImageError {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageError::MediaError => "MEDIA_ERROR",
            ImageError::NoMedia => "NO_MEDIA",
            ImageError::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MEDIA_ERROR", "NO_MEDIA"]
    }
}
impl AsRef<str> for ImageError {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FormatConfigKey {
    #[allow(missing_docs)] // documentation missing in model
    JpegQuality,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FormatConfigKey {
    fn from(s: &str) -> Self {
        match s {
            "JPEGQuality" => FormatConfigKey::JpegQuality,
            other => FormatConfigKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FormatConfigKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FormatConfigKey::from(s))
    }
}
impl FormatConfigKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FormatConfigKey::JpegQuality => "JPEGQuality",
            FormatConfigKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JPEGQuality"]
    }
}
impl AsRef<str> for FormatConfigKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Format {
    #[allow(missing_docs)] // documentation missing in model
    Jpeg,
    #[allow(missing_docs)] // documentation missing in model
    Png,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Format {
    fn from(s: &str) -> Self {
        match s {
            "JPEG" => Format::Jpeg,
            "PNG" => Format::Png,
            other => Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Format::from(s))
    }
}
impl Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Format::Jpeg => "JPEG",
            Format::Png => "PNG",
            Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JPEG", "PNG"]
    }
}
impl AsRef<str> for Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageSelectorType {
    #[allow(missing_docs)] // documentation missing in model
    ProducerTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ServerTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageSelectorType {
    fn from(s: &str) -> Self {
        match s {
            "PRODUCER_TIMESTAMP" => ImageSelectorType::ProducerTimestamp,
            "SERVER_TIMESTAMP" => ImageSelectorType::ServerTimestamp,
            other => ImageSelectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageSelectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageSelectorType::from(s))
    }
}
impl ImageSelectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageSelectorType::ProducerTimestamp => "PRODUCER_TIMESTAMP",
            ImageSelectorType::ServerTimestamp => "SERVER_TIMESTAMP",
            ImageSelectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRODUCER_TIMESTAMP", "SERVER_TIMESTAMP"]
    }
}
impl AsRef<str> for ImageSelectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsDisplayFragmentTimestamp {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsDisplayFragmentTimestamp {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => HlsDisplayFragmentTimestamp::Always,
            "NEVER" => HlsDisplayFragmentTimestamp::Never,
            other => HlsDisplayFragmentTimestamp::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsDisplayFragmentTimestamp {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsDisplayFragmentTimestamp::from(s))
    }
}
impl HlsDisplayFragmentTimestamp {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsDisplayFragmentTimestamp::Always => "ALWAYS",
            HlsDisplayFragmentTimestamp::Never => "NEVER",
            HlsDisplayFragmentTimestamp::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "NEVER"]
    }
}
impl AsRef<str> for HlsDisplayFragmentTimestamp {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsDiscontinuityMode {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    #[allow(missing_docs)] // documentation missing in model
    OnDiscontinuity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsDiscontinuityMode {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => HlsDiscontinuityMode::Always,
            "NEVER" => HlsDiscontinuityMode::Never,
            "ON_DISCONTINUITY" => HlsDiscontinuityMode::OnDiscontinuity,
            other => HlsDiscontinuityMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsDiscontinuityMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsDiscontinuityMode::from(s))
    }
}
impl HlsDiscontinuityMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsDiscontinuityMode::Always => "ALWAYS",
            HlsDiscontinuityMode::Never => "NEVER",
            HlsDiscontinuityMode::OnDiscontinuity => "ON_DISCONTINUITY",
            HlsDiscontinuityMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "NEVER", "ON_DISCONTINUITY"]
    }
}
impl AsRef<str> for HlsDiscontinuityMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerFormat {
    #[allow(missing_docs)] // documentation missing in model
    FragmentedMp4,
    #[allow(missing_docs)] // documentation missing in model
    MpegTs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerFormat {
    fn from(s: &str) -> Self {
        match s {
            "FRAGMENTED_MP4" => ContainerFormat::FragmentedMp4,
            "MPEG_TS" => ContainerFormat::MpegTs,
            other => ContainerFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerFormat::from(s))
    }
}
impl ContainerFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerFormat::FragmentedMp4 => "FRAGMENTED_MP4",
            ContainerFormat::MpegTs => "MPEG_TS",
            ContainerFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAGMENTED_MP4", "MPEG_TS"]
    }
}
impl AsRef<str> for ContainerFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the range of timestamps for the requested media, and the source of the timestamps.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsFragmentSelector {
    /// <p>The source of the timestamps for the requested media.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</code> value) are included. </p>
    /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
    /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
    pub fragment_selector_type: std::option::Option<crate::model::HlsFragmentSelectorType>,
    /// <p>The start and end of the timestamp range for the requested media.</p>
    /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
    pub timestamp_range: std::option::Option<crate::model::HlsTimestampRange>,
}
impl HlsFragmentSelector {
    /// <p>The source of the timestamps for the requested media.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</code> value) are included. </p>
    /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
    /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
    pub fn fragment_selector_type(
        &self,
    ) -> std::option::Option<&crate::model::HlsFragmentSelectorType> {
        self.fragment_selector_type.as_ref()
    }
    /// <p>The start and end of the timestamp range for the requested media.</p>
    /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
    pub fn timestamp_range(&self) -> std::option::Option<&crate::model::HlsTimestampRange> {
        self.timestamp_range.as_ref()
    }
}
impl std::fmt::Debug for HlsFragmentSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsFragmentSelector");
        formatter.field("fragment_selector_type", &self.fragment_selector_type);
        formatter.field("timestamp_range", &self.timestamp_range);
        formatter.finish()
    }
}
/// See [`HlsFragmentSelector`](crate::model::HlsFragmentSelector)
pub mod hls_fragment_selector {
    /// A builder for [`HlsFragmentSelector`](crate::model::HlsFragmentSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fragment_selector_type:
            std::option::Option<crate::model::HlsFragmentSelectorType>,
        pub(crate) timestamp_range: std::option::Option<crate::model::HlsTimestampRange>,
    }
    impl Builder {
        /// <p>The source of the timestamps for the requested media.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</code> value) are included. </p>
        /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
        /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
        pub fn fragment_selector_type(
            mut self,
            input: crate::model::HlsFragmentSelectorType,
        ) -> Self {
            self.fragment_selector_type = Some(input);
            self
        }
        /// <p>The source of the timestamps for the requested media.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</code> value) are included. </p>
        /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetHLSStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
        /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
        pub fn set_fragment_selector_type(
            mut self,
            input: std::option::Option<crate::model::HlsFragmentSelectorType>,
        ) -> Self {
            self.fragment_selector_type = input;
            self
        }
        /// <p>The start and end of the timestamp range for the requested media.</p>
        /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
        pub fn timestamp_range(mut self, input: crate::model::HlsTimestampRange) -> Self {
            self.timestamp_range = Some(input);
            self
        }
        /// <p>The start and end of the timestamp range for the requested media.</p>
        /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
        pub fn set_timestamp_range(
            mut self,
            input: std::option::Option<crate::model::HlsTimestampRange>,
        ) -> Self {
            self.timestamp_range = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsFragmentSelector`](crate::model::HlsFragmentSelector)
        pub fn build(self) -> crate::model::HlsFragmentSelector {
            crate::model::HlsFragmentSelector {
                fragment_selector_type: self.fragment_selector_type,
                timestamp_range: self.timestamp_range,
            }
        }
    }
}
impl HlsFragmentSelector {
    /// Creates a new builder-style object to manufacture [`HlsFragmentSelector`](crate::model::HlsFragmentSelector)
    pub fn builder() -> crate::model::hls_fragment_selector::Builder {
        crate::model::hls_fragment_selector::Builder::default()
    }
}

/// <p>The start and end of the timestamp range for the requested media.</p>
/// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsTimestampRange {
    /// <p>The start of the timestamp range for the requested media.</p>
    /// <p>If the <code>HLSTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required. </p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
    /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
    /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
    /// </note>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl HlsTimestampRange {
    /// <p>The start of the timestamp range for the requested media.</p>
    /// <p>If the <code>HLSTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required. </p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
    /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
    /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
    /// </note>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
}
impl std::fmt::Debug for HlsTimestampRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsTimestampRange");
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.finish()
    }
}
/// See [`HlsTimestampRange`](crate::model::HlsTimestampRange)
pub mod hls_timestamp_range {
    /// A builder for [`HlsTimestampRange`](crate::model::HlsTimestampRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start of the timestamp range for the requested media.</p>
        /// <p>If the <code>HLSTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required. </p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The start of the timestamp range for the requested media.</p>
        /// <p>If the <code>HLSTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required. </p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
        /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
        /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
        /// </note>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
        /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
        /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
        /// </note>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsTimestampRange`](crate::model::HlsTimestampRange)
        pub fn build(self) -> crate::model::HlsTimestampRange {
            crate::model::HlsTimestampRange {
                start_timestamp: self.start_timestamp,
                end_timestamp: self.end_timestamp,
            }
        }
    }
}
impl HlsTimestampRange {
    /// Creates a new builder-style object to manufacture [`HlsTimestampRange`](crate::model::HlsTimestampRange)
    pub fn builder() -> crate::model::hls_timestamp_range::Builder {
        crate::model::hls_timestamp_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsFragmentSelectorType {
    #[allow(missing_docs)] // documentation missing in model
    ProducerTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ServerTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsFragmentSelectorType {
    fn from(s: &str) -> Self {
        match s {
            "PRODUCER_TIMESTAMP" => HlsFragmentSelectorType::ProducerTimestamp,
            "SERVER_TIMESTAMP" => HlsFragmentSelectorType::ServerTimestamp,
            other => HlsFragmentSelectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsFragmentSelectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsFragmentSelectorType::from(s))
    }
}
impl HlsFragmentSelectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsFragmentSelectorType::ProducerTimestamp => "PRODUCER_TIMESTAMP",
            HlsFragmentSelectorType::ServerTimestamp => "SERVER_TIMESTAMP",
            HlsFragmentSelectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRODUCER_TIMESTAMP", "SERVER_TIMESTAMP"]
    }
}
impl AsRef<str> for HlsFragmentSelectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsPlaybackMode {
    #[allow(missing_docs)] // documentation missing in model
    Live,
    #[allow(missing_docs)] // documentation missing in model
    LiveReplay,
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsPlaybackMode {
    fn from(s: &str) -> Self {
        match s {
            "LIVE" => HlsPlaybackMode::Live,
            "LIVE_REPLAY" => HlsPlaybackMode::LiveReplay,
            "ON_DEMAND" => HlsPlaybackMode::OnDemand,
            other => HlsPlaybackMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsPlaybackMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsPlaybackMode::from(s))
    }
}
impl HlsPlaybackMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsPlaybackMode::Live => "LIVE",
            HlsPlaybackMode::LiveReplay => "LIVE_REPLAY",
            HlsPlaybackMode::OnDemand => "ON_DEMAND",
            HlsPlaybackMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LIVE", "LIVE_REPLAY", "ON_DEMAND"]
    }
}
impl AsRef<str> for HlsPlaybackMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the range of timestamps for the requested media, and the source of the timestamps. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashFragmentSelector {
    /// <p>The source of the timestamps for the requested media.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</code> value) are included. </p>
    /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
    /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
    pub fragment_selector_type: std::option::Option<crate::model::DashFragmentSelectorType>,
    /// <p>The start and end of the timestamp range for the requested media.</p>
    /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
    pub timestamp_range: std::option::Option<crate::model::DashTimestampRange>,
}
impl DashFragmentSelector {
    /// <p>The source of the timestamps for the requested media.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</code> value) are included. </p>
    /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
    /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
    /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
    pub fn fragment_selector_type(
        &self,
    ) -> std::option::Option<&crate::model::DashFragmentSelectorType> {
        self.fragment_selector_type.as_ref()
    }
    /// <p>The start and end of the timestamp range for the requested media.</p>
    /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
    pub fn timestamp_range(&self) -> std::option::Option<&crate::model::DashTimestampRange> {
        self.timestamp_range.as_ref()
    }
}
impl std::fmt::Debug for DashFragmentSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashFragmentSelector");
        formatter.field("fragment_selector_type", &self.fragment_selector_type);
        formatter.field("timestamp_range", &self.timestamp_range);
        formatter.finish()
    }
}
/// See [`DashFragmentSelector`](crate::model::DashFragmentSelector)
pub mod dash_fragment_selector {
    /// A builder for [`DashFragmentSelector`](crate::model::DashFragmentSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fragment_selector_type:
            std::option::Option<crate::model::DashFragmentSelectorType>,
        pub(crate) timestamp_range: std::option::Option<crate::model::DashTimestampRange>,
    }
    impl Builder {
        /// <p>The source of the timestamps for the requested media.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</code> value) are included. </p>
        /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
        /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
        pub fn fragment_selector_type(
            mut self,
            input: crate::model::DashFragmentSelectorType,
        ) -> Self {
            self.fragment_selector_type = Some(input);
            self
        }
        /// <p>The source of the timestamps for the requested media.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified <code>FragmentSelector$TimestampRange</code> is included in the media playlist. In addition, the fragments with producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment (up to the <code>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</code> value) are included. </p>
        /// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
        /// <p>When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and <code>GetDASHStreamingSessionURLInput$PlaybackMode</code> is <code>LIVE</code>, the producer timestamps are used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer timestamps with values now, they are not included in the HLS media playlist.</p>
        /// <p>The default is <code>SERVER_TIMESTAMP</code>.</p>
        pub fn set_fragment_selector_type(
            mut self,
            input: std::option::Option<crate::model::DashFragmentSelectorType>,
        ) -> Self {
            self.fragment_selector_type = input;
            self
        }
        /// <p>The start and end of the timestamp range for the requested media.</p>
        /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
        pub fn timestamp_range(mut self, input: crate::model::DashTimestampRange) -> Self {
            self.timestamp_range = Some(input);
            self
        }
        /// <p>The start and end of the timestamp range for the requested media.</p>
        /// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
        pub fn set_timestamp_range(
            mut self,
            input: std::option::Option<crate::model::DashTimestampRange>,
        ) -> Self {
            self.timestamp_range = input;
            self
        }
        /// Consumes the builder and constructs a [`DashFragmentSelector`](crate::model::DashFragmentSelector)
        pub fn build(self) -> crate::model::DashFragmentSelector {
            crate::model::DashFragmentSelector {
                fragment_selector_type: self.fragment_selector_type,
                timestamp_range: self.timestamp_range,
            }
        }
    }
}
impl DashFragmentSelector {
    /// Creates a new builder-style object to manufacture [`DashFragmentSelector`](crate::model::DashFragmentSelector)
    pub fn builder() -> crate::model::dash_fragment_selector::Builder {
        crate::model::dash_fragment_selector::Builder::default()
    }
}

/// <p>The start and end of the timestamp range for the requested media.</p>
/// <p>This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.</p>
/// <p>The values in <code>DASHimestampRange</code> are inclusive. Fragments that start exactly at or after the start time are included in the session. Fragments that start before the start time and continue past it are not included in the session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashTimestampRange {
    /// <p>The start of the timestamp range for the requested media.</p>
    /// <p>If the <code>DASHTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required.</p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
    /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
    /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
    /// </note>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DashTimestampRange {
    /// <p>The start of the timestamp range for the requested media.</p>
    /// <p>If the <code>DASHTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required.</p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
    /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
    /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
    /// </note>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DashTimestampRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashTimestampRange");
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.finish()
    }
}
/// See [`DashTimestampRange`](crate::model::DashTimestampRange)
pub mod dash_timestamp_range {
    /// A builder for [`DashTimestampRange`](crate::model::DashTimestampRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start of the timestamp range for the requested media.</p>
        /// <p>If the <code>DASHTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required.</p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The start of the timestamp range for the requested media.</p>
        /// <p>If the <code>DASHTimestampRange</code> value is specified, the <code>StartTimestamp</code> value is required.</p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
        /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
        /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
        /// </note>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The end of the timestamp range for the requested media. This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value.</p>
        /// <p>If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past.</p>
        /// <p>The <code>EndTimestamp</code> value is required for <code>ON_DEMAND</code> mode, but optional for <code>LIVE_REPLAY</code> mode. If the <code>EndTimestamp</code> is not set for <code>LIVE_REPLAY</code> mode then the session will continue to include newly ingested fragments until the session expires.</p> <note>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.</p>
        /// </note>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DashTimestampRange`](crate::model::DashTimestampRange)
        pub fn build(self) -> crate::model::DashTimestampRange {
            crate::model::DashTimestampRange {
                start_timestamp: self.start_timestamp,
                end_timestamp: self.end_timestamp,
            }
        }
    }
}
impl DashTimestampRange {
    /// Creates a new builder-style object to manufacture [`DashTimestampRange`](crate::model::DashTimestampRange)
    pub fn builder() -> crate::model::dash_timestamp_range::Builder {
        crate::model::dash_timestamp_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashFragmentSelectorType {
    #[allow(missing_docs)] // documentation missing in model
    ProducerTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ServerTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashFragmentSelectorType {
    fn from(s: &str) -> Self {
        match s {
            "PRODUCER_TIMESTAMP" => DashFragmentSelectorType::ProducerTimestamp,
            "SERVER_TIMESTAMP" => DashFragmentSelectorType::ServerTimestamp,
            other => DashFragmentSelectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashFragmentSelectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashFragmentSelectorType::from(s))
    }
}
impl DashFragmentSelectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashFragmentSelectorType::ProducerTimestamp => "PRODUCER_TIMESTAMP",
            DashFragmentSelectorType::ServerTimestamp => "SERVER_TIMESTAMP",
            DashFragmentSelectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRODUCER_TIMESTAMP", "SERVER_TIMESTAMP"]
    }
}
impl AsRef<str> for DashFragmentSelectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashDisplayFragmentNumber {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashDisplayFragmentNumber {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => DashDisplayFragmentNumber::Always,
            "NEVER" => DashDisplayFragmentNumber::Never,
            other => DashDisplayFragmentNumber::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashDisplayFragmentNumber {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashDisplayFragmentNumber::from(s))
    }
}
impl DashDisplayFragmentNumber {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashDisplayFragmentNumber::Always => "ALWAYS",
            DashDisplayFragmentNumber::Never => "NEVER",
            DashDisplayFragmentNumber::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "NEVER"]
    }
}
impl AsRef<str> for DashDisplayFragmentNumber {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashDisplayFragmentTimestamp {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashDisplayFragmentTimestamp {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => DashDisplayFragmentTimestamp::Always,
            "NEVER" => DashDisplayFragmentTimestamp::Never,
            other => DashDisplayFragmentTimestamp::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashDisplayFragmentTimestamp {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashDisplayFragmentTimestamp::from(s))
    }
}
impl DashDisplayFragmentTimestamp {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashDisplayFragmentTimestamp::Always => "ALWAYS",
            DashDisplayFragmentTimestamp::Never => "NEVER",
            DashDisplayFragmentTimestamp::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "NEVER"]
    }
}
impl AsRef<str> for DashDisplayFragmentTimestamp {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashPlaybackMode {
    #[allow(missing_docs)] // documentation missing in model
    Live,
    #[allow(missing_docs)] // documentation missing in model
    LiveReplay,
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashPlaybackMode {
    fn from(s: &str) -> Self {
        match s {
            "LIVE" => DashPlaybackMode::Live,
            "LIVE_REPLAY" => DashPlaybackMode::LiveReplay,
            "ON_DEMAND" => DashPlaybackMode::OnDemand,
            other => DashPlaybackMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashPlaybackMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashPlaybackMode::from(s))
    }
}
impl DashPlaybackMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashPlaybackMode::Live => "LIVE",
            DashPlaybackMode::LiveReplay => "LIVE_REPLAY",
            DashPlaybackMode::OnDemand => "ON_DEMAND",
            DashPlaybackMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LIVE", "LIVE_REPLAY", "ON_DEMAND"]
    }
}
impl AsRef<str> for DashPlaybackMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the timestamp range and timestamp origin of a range of fragments.</p>
/// <p>Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the clip will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClipFragmentSelector {
    /// <p>The origin of the timestamps to use (Server or Producer).</p>
    pub fragment_selector_type: std::option::Option<crate::model::ClipFragmentSelectorType>,
    /// <p>The range of timestamps to return.</p>
    pub timestamp_range: std::option::Option<crate::model::ClipTimestampRange>,
}
impl ClipFragmentSelector {
    /// <p>The origin of the timestamps to use (Server or Producer).</p>
    pub fn fragment_selector_type(
        &self,
    ) -> std::option::Option<&crate::model::ClipFragmentSelectorType> {
        self.fragment_selector_type.as_ref()
    }
    /// <p>The range of timestamps to return.</p>
    pub fn timestamp_range(&self) -> std::option::Option<&crate::model::ClipTimestampRange> {
        self.timestamp_range.as_ref()
    }
}
impl std::fmt::Debug for ClipFragmentSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClipFragmentSelector");
        formatter.field("fragment_selector_type", &self.fragment_selector_type);
        formatter.field("timestamp_range", &self.timestamp_range);
        formatter.finish()
    }
}
/// See [`ClipFragmentSelector`](crate::model::ClipFragmentSelector)
pub mod clip_fragment_selector {
    /// A builder for [`ClipFragmentSelector`](crate::model::ClipFragmentSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fragment_selector_type:
            std::option::Option<crate::model::ClipFragmentSelectorType>,
        pub(crate) timestamp_range: std::option::Option<crate::model::ClipTimestampRange>,
    }
    impl Builder {
        /// <p>The origin of the timestamps to use (Server or Producer).</p>
        pub fn fragment_selector_type(
            mut self,
            input: crate::model::ClipFragmentSelectorType,
        ) -> Self {
            self.fragment_selector_type = Some(input);
            self
        }
        /// <p>The origin of the timestamps to use (Server or Producer).</p>
        pub fn set_fragment_selector_type(
            mut self,
            input: std::option::Option<crate::model::ClipFragmentSelectorType>,
        ) -> Self {
            self.fragment_selector_type = input;
            self
        }
        /// <p>The range of timestamps to return.</p>
        pub fn timestamp_range(mut self, input: crate::model::ClipTimestampRange) -> Self {
            self.timestamp_range = Some(input);
            self
        }
        /// <p>The range of timestamps to return.</p>
        pub fn set_timestamp_range(
            mut self,
            input: std::option::Option<crate::model::ClipTimestampRange>,
        ) -> Self {
            self.timestamp_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ClipFragmentSelector`](crate::model::ClipFragmentSelector)
        pub fn build(self) -> crate::model::ClipFragmentSelector {
            crate::model::ClipFragmentSelector {
                fragment_selector_type: self.fragment_selector_type,
                timestamp_range: self.timestamp_range,
            }
        }
    }
}
impl ClipFragmentSelector {
    /// Creates a new builder-style object to manufacture [`ClipFragmentSelector`](crate::model::ClipFragmentSelector)
    pub fn builder() -> crate::model::clip_fragment_selector::Builder {
        crate::model::clip_fragment_selector::Builder::default()
    }
}

/// <p>The range of timestamps for which to return fragments.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClipTimestampRange {
    /// <p>The starting timestamp in the range of timestamps for which to return fragments. </p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the timestamp range for the requested media.</p>
    /// <p>This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past. </p>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session. </p>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ClipTimestampRange {
    /// <p>The starting timestamp in the range of timestamps for which to return fragments. </p>
    /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
    pub fn start_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_timestamp.as_ref()
    }
    /// <p>The end of the timestamp range for the requested media.</p>
    /// <p>This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past. </p>
    /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session. </p>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ClipTimestampRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClipTimestampRange");
        formatter.field("start_timestamp", &self.start_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.finish()
    }
}
/// See [`ClipTimestampRange`](crate::model::ClipTimestampRange)
pub mod clip_timestamp_range {
    /// A builder for [`ClipTimestampRange`](crate::model::ClipTimestampRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The starting timestamp in the range of timestamps for which to return fragments. </p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn start_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_timestamp = Some(input);
            self
        }
        /// <p>The starting timestamp in the range of timestamps for which to return fragments. </p>
        /// <p>Only fragments that start exactly at or after <code>StartTimestamp</code> are included in the session. Fragments that start before <code>StartTimestamp</code> and continue past it aren't included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the <code>StartTimestamp</code> must be later than the stream head. </p>
        pub fn set_start_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_timestamp = input;
            self
        }
        /// <p>The end of the timestamp range for the requested media.</p>
        /// <p>This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past. </p>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session. </p>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The end of the timestamp range for the requested media.</p>
        /// <p>This value must be within 24 hours of the specified <code>StartTimestamp</code>, and it must be later than the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is <code>SERVER_TIMESTAMP</code>, this value must be in the past. </p>
        /// <p>This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session. </p>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ClipTimestampRange`](crate::model::ClipTimestampRange)
        pub fn build(self) -> crate::model::ClipTimestampRange {
            crate::model::ClipTimestampRange {
                start_timestamp: self.start_timestamp,
                end_timestamp: self.end_timestamp,
            }
        }
    }
}
impl ClipTimestampRange {
    /// Creates a new builder-style object to manufacture [`ClipTimestampRange`](crate::model::ClipTimestampRange)
    pub fn builder() -> crate::model::clip_timestamp_range::Builder {
        crate::model::clip_timestamp_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClipFragmentSelectorType {
    #[allow(missing_docs)] // documentation missing in model
    ProducerTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ServerTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClipFragmentSelectorType {
    fn from(s: &str) -> Self {
        match s {
            "PRODUCER_TIMESTAMP" => ClipFragmentSelectorType::ProducerTimestamp,
            "SERVER_TIMESTAMP" => ClipFragmentSelectorType::ServerTimestamp,
            other => ClipFragmentSelectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClipFragmentSelectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClipFragmentSelectorType::from(s))
    }
}
impl ClipFragmentSelectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClipFragmentSelectorType::ProducerTimestamp => "PRODUCER_TIMESTAMP",
            ClipFragmentSelectorType::ServerTimestamp => "SERVER_TIMESTAMP",
            ClipFragmentSelectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRODUCER_TIMESTAMP", "SERVER_TIMESTAMP"]
    }
}
impl AsRef<str> for ClipFragmentSelectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
