// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Kinesis Video Streams
///
/// Client for invoking operations on Amazon Kinesis Video Streams. Each operation on Amazon Kinesis Video Streams is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_kinesisvideo::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_kinesisvideo::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_kinesisvideo::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateSignalingChannel`](crate::client::fluent_builders::CreateSignalingChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::CreateSignalingChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::CreateSignalingChannel::set_channel_name): <p>A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.</p>
    ///   - [`channel_type(ChannelType)`](crate::client::fluent_builders::CreateSignalingChannel::channel_type) / [`set_channel_type(Option<ChannelType>)`](crate::client::fluent_builders::CreateSignalingChannel::set_channel_type): <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type. </p>
    ///   - [`single_master_configuration(SingleMasterConfiguration)`](crate::client::fluent_builders::CreateSignalingChannel::single_master_configuration) / [`set_single_master_configuration(Option<SingleMasterConfiguration>)`](crate::client::fluent_builders::CreateSignalingChannel::set_single_master_configuration): <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSignalingChannel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSignalingChannel::set_tags): <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    /// - On success, responds with [`CreateSignalingChannelOutput`](crate::output::CreateSignalingChannelOutput) with field(s):
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateSignalingChannelOutput::channel_arn): <p>The Amazon Resource Name (ARN) of the created channel.</p>
    /// - On failure, responds with [`SdkError<CreateSignalingChannelError>`](crate::error::CreateSignalingChannelError)
    pub fn create_signaling_channel(&self) -> fluent_builders::CreateSignalingChannel {
        fluent_builders::CreateSignalingChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStream`](crate::client::fluent_builders::CreateStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_name(impl Into<String>)`](crate::client::fluent_builders::CreateStream::device_name) / [`set_device_name(Option<String>)`](crate::client::fluent_builders::CreateStream::set_device_name): <p>The name of the device that is writing to the stream. </p> <note>   <p>In the current implementation, Kinesis Video Streams does not use this name.</p>  </note>
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::CreateStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::CreateStream::set_stream_name): <p>A name for the stream that you are creating.</p>  <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    ///   - [`media_type(impl Into<String>)`](crate::client::fluent_builders::CreateStream::media_type) / [`set_media_type(Option<String>)`](crate::client::fluent_builders::CreateStream::set_media_type): <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>  <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>  <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateStream::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateStream::set_kms_key_id): <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>  <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.</p>  <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
    ///   - [`data_retention_in_hours(i32)`](crate::client::fluent_builders::CreateStream::data_retention_in_hours) / [`set_data_retention_in_hours(Option<i32>)`](crate::client::fluent_builders::CreateStream::set_data_retention_in_hours): <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>  <p>The default value is 0, indicating that the stream does not persist data.</p>  <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStream::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStream::set_tags): <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    /// - On success, responds with [`CreateStreamOutput`](crate::output::CreateStreamOutput) with field(s):
    ///   - [`stream_arn(Option<String>)`](crate::output::CreateStreamOutput::stream_arn): <p>The Amazon Resource Name (ARN) of the stream.</p>
    /// - On failure, responds with [`SdkError<CreateStreamError>`](crate::error::CreateStreamError)
    pub fn create_stream(&self) -> fluent_builders::CreateStream {
        fluent_builders::CreateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSignalingChannel`](crate::client::fluent_builders::DeleteSignalingChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteSignalingChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DeleteSignalingChannel::set_channel_arn): <p>The Amazon Resource Name (ARN) of the signaling channel that you want to delete.</p>
    ///   - [`current_version(impl Into<String>)`](crate::client::fluent_builders::DeleteSignalingChannel::current_version) / [`set_current_version(Option<String>)`](crate::client::fluent_builders::DeleteSignalingChannel::set_current_version): <p>The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the <code>DescribeSignalingChannel</code> or <code>ListSignalingChannels</code> API operations.</p>
    /// - On success, responds with [`DeleteSignalingChannelOutput`](crate::output::DeleteSignalingChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteSignalingChannelError>`](crate::error::DeleteSignalingChannelError)
    pub fn delete_signaling_channel(&self) -> fluent_builders::DeleteSignalingChannel {
        fluent_builders::DeleteSignalingChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStream`](crate::client::fluent_builders::DeleteStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::DeleteStream::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
    ///   - [`current_version(impl Into<String>)`](crate::client::fluent_builders::DeleteStream::current_version) / [`set_current_version(Option<String>)`](crate::client::fluent_builders::DeleteStream::set_current_version): <p>Optional: The version of the stream that you want to delete. </p>  <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>  <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
    /// - On success, responds with [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)

    /// - On failure, responds with [`SdkError<DeleteStreamError>`](crate::error::DeleteStreamError)
    pub fn delete_stream(&self) -> fluent_builders::DeleteStream {
        fluent_builders::DeleteStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSignalingChannel`](crate::client::fluent_builders::DescribeSignalingChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSignalingChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::DescribeSignalingChannel::set_channel_name): <p>The name of the signaling channel that you want to describe.</p>
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeSignalingChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::DescribeSignalingChannel::set_channel_arn): <p>The ARN of the signaling channel that you want to describe.</p>
    /// - On success, responds with [`DescribeSignalingChannelOutput`](crate::output::DescribeSignalingChannelOutput) with field(s):
    ///   - [`channel_info(Option<ChannelInfo>)`](crate::output::DescribeSignalingChannelOutput::channel_info): <p>A structure that encapsulates the specified signaling channel's metadata and properties.</p>
    /// - On failure, responds with [`SdkError<DescribeSignalingChannelError>`](crate::error::DescribeSignalingChannelError)
    pub fn describe_signaling_channel(&self) -> fluent_builders::DescribeSignalingChannel {
        fluent_builders::DescribeSignalingChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStream`](crate::client::fluent_builders::DescribeStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::DescribeStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::DescribeStream::set_stream_name): <p>The name of the stream.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::DescribeStream::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream.</p>
    /// - On success, responds with [`DescribeStreamOutput`](crate::output::DescribeStreamOutput) with field(s):
    ///   - [`stream_info(Option<StreamInfo>)`](crate::output::DescribeStreamOutput::stream_info): <p>An object that describes the stream.</p>
    /// - On failure, responds with [`SdkError<DescribeStreamError>`](crate::error::DescribeStreamError)
    pub fn describe_stream(&self) -> fluent_builders::DescribeStream {
        fluent_builders::DescribeStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataEndpoint`](crate::client::fluent_builders::GetDataEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::GetDataEndpoint::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::GetDataEndpoint::set_stream_name): <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::GetDataEndpoint::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::GetDataEndpoint::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request. </p>
    ///   - [`api_name(ApiName)`](crate::client::fluent_builders::GetDataEndpoint::api_name) / [`set_api_name(Option<ApiName>)`](crate::client::fluent_builders::GetDataEndpoint::set_api_name): <p>The name of the API action for which to get an endpoint.</p>
    /// - On success, responds with [`GetDataEndpointOutput`](crate::output::GetDataEndpointOutput) with field(s):
    ///   - [`data_endpoint(Option<String>)`](crate::output::GetDataEndpointOutput::data_endpoint): <p>The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your application.</p>
    /// - On failure, responds with [`SdkError<GetDataEndpointError>`](crate::error::GetDataEndpointError)
    pub fn get_data_endpoint(&self) -> fluent_builders::GetDataEndpoint {
        fluent_builders::GetDataEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSignalingChannelEndpoint`](crate::client::fluent_builders::GetSignalingChannelEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetSignalingChannelEndpoint::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetSignalingChannelEndpoint::set_channel_arn): <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.</p>
    ///   - [`single_master_channel_endpoint_configuration(SingleMasterChannelEndpointConfiguration)`](crate::client::fluent_builders::GetSignalingChannelEndpoint::single_master_channel_endpoint_configuration) / [`set_single_master_channel_endpoint_configuration(Option<SingleMasterChannelEndpointConfiguration>)`](crate::client::fluent_builders::GetSignalingChannelEndpoint::set_single_master_channel_endpoint_configuration): <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    /// - On success, responds with [`GetSignalingChannelEndpointOutput`](crate::output::GetSignalingChannelEndpointOutput) with field(s):
    ///   - [`resource_endpoint_list(Option<Vec<ResourceEndpointListItem>>)`](crate::output::GetSignalingChannelEndpointOutput::resource_endpoint_list): <p>A list of endpoints for the specified signaling channel.</p>
    /// - On failure, responds with [`SdkError<GetSignalingChannelEndpointError>`](crate::error::GetSignalingChannelEndpointError)
    pub fn get_signaling_channel_endpoint(&self) -> fluent_builders::GetSignalingChannelEndpoint {
        fluent_builders::GetSignalingChannelEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSignalingChannels`](crate::client::fluent_builders::ListSignalingChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSignalingChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSignalingChannels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSignalingChannels::set_max_results): <p>The maximum number of channels to return in the response. The default is 500.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSignalingChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSignalingChannels::set_next_token): <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
    ///   - [`channel_name_condition(ChannelNameCondition)`](crate::client::fluent_builders::ListSignalingChannels::channel_name_condition) / [`set_channel_name_condition(Option<ChannelNameCondition>)`](crate::client::fluent_builders::ListSignalingChannels::set_channel_name_condition): <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    /// - On success, responds with [`ListSignalingChannelsOutput`](crate::output::ListSignalingChannelsOutput) with field(s):
    ///   - [`channel_info_list(Option<Vec<ChannelInfo>>)`](crate::output::ListSignalingChannelsOutput::channel_info_list): <p>An array of <code>ChannelInfo</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSignalingChannelsOutput::next_token): <p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request.</p>
    /// - On failure, responds with [`SdkError<ListSignalingChannelsError>`](crate::error::ListSignalingChannelsError)
    pub fn list_signaling_channels(&self) -> fluent_builders::ListSignalingChannels {
        fluent_builders::ListSignalingChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreams`](crate::client::fluent_builders::ListStreams) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreams::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreams::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListStreams::set_max_results): <p>The maximum number of streams to return in the response. The default is 10,000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreams::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreams::set_next_token): <p>If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your next request.</p>
    ///   - [`stream_name_condition(StreamNameCondition)`](crate::client::fluent_builders::ListStreams::stream_name_condition) / [`set_stream_name_condition(Option<StreamNameCondition>)`](crate::client::fluent_builders::ListStreams::set_stream_name_condition): <p>Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. </p>
    /// - On success, responds with [`ListStreamsOutput`](crate::output::ListStreamsOutput) with field(s):
    ///   - [`stream_info_list(Option<Vec<StreamInfo>>)`](crate::output::ListStreamsOutput::stream_info_list): <p>An array of <code>StreamInfo</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamsOutput::next_token): <p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request. </p>
    /// - On failure, responds with [`SdkError<ListStreamsError>`](crate::error::ListStreamsError)
    pub fn list_streams(&self) -> fluent_builders::ListStreams {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. </p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A map of tag keys and values associated with the specified signaling channel.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForStream`](crate::client::fluent_builders::ListTagsForStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForStream::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForStream::set_next_token): <p>If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForStream::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream that you want to list tags for.</p>
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::ListTagsForStream::set_stream_name): <p>The name of the stream that you want to list tags for.</p>
    /// - On success, responds with [`ListTagsForStreamOutput`](crate::output::ListTagsForStreamOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForStreamOutput::next_token): <p>If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForStreamOutput::tags): <p>A map of tag keys and values associated with the specified stream.</p>
    /// - On failure, responds with [`SdkError<ListTagsForStreamError>`](crate::error::ListTagsForStreamError)
    pub fn list_tags_for_stream(&self) -> fluent_builders::ListTagsForStream {
        fluent_builders::ListTagsForStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagStream`](crate::client::fluent_builders::TagStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::TagStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::TagStream::set_stream_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to.</p>
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::TagStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::TagStream::set_stream_name): <p>The name of the stream that you want to add the tag or tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagStream::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagStream::set_tags): <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
    /// - On success, responds with [`TagStreamOutput`](crate::output::TagStreamOutput)

    /// - On failure, responds with [`SdkError<TagStreamError>`](crate::error::TagStreamError)
    pub fn tag_stream(&self) -> fluent_builders::TagStream {
        fluent_builders::TagStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.</p>
    ///   - [`tag_key_list(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_key_list) / [`set_tag_key_list(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_key_list): <p>A list of the keys of the tags that you want to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagStream`](crate::client::fluent_builders::UntagStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::UntagStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::UntagStream::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags from.</p>
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::UntagStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::UntagStream::set_stream_name): <p>The name of the stream that you want to remove tags from.</p>
    ///   - [`tag_key_list(Vec<String>)`](crate::client::fluent_builders::UntagStream::tag_key_list) / [`set_tag_key_list(Option<Vec<String>>)`](crate::client::fluent_builders::UntagStream::set_tag_key_list): <p>A list of the keys of the tags that you want to remove.</p>
    /// - On success, responds with [`UntagStreamOutput`](crate::output::UntagStreamOutput)

    /// - On failure, responds with [`SdkError<UntagStreamError>`](crate::error::UntagStreamError)
    pub fn untag_stream(&self) -> fluent_builders::UntagStream {
        fluent_builders::UntagStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataRetention`](crate::client::fluent_builders::UpdateDataRetention) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataRetention::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::UpdateDataRetention::set_stream_name): <p>The name of the stream whose retention period you want to change.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDataRetention::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::UpdateDataRetention::set_stream_arn): <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
    ///   - [`current_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDataRetention::current_version) / [`set_current_version(Option<String>)`](crate::client::fluent_builders::UpdateDataRetention::set_current_version): <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
    ///   - [`operation(UpdateDataRetentionOperation)`](crate::client::fluent_builders::UpdateDataRetention::operation) / [`set_operation(Option<UpdateDataRetentionOperation>)`](crate::client::fluent_builders::UpdateDataRetention::set_operation): <p>Indicates whether you want to increase or decrease the retention period.</p>
    ///   - [`data_retention_change_in_hours(i32)`](crate::client::fluent_builders::UpdateDataRetention::data_retention_change_in_hours) / [`set_data_retention_change_in_hours(Option<i32>)`](crate::client::fluent_builders::UpdateDataRetention::set_data_retention_change_in_hours): <p>The retention period, in hours. The value you specify replaces the current value. The maximum value for this parameter is 87600 (ten years).</p>
    /// - On success, responds with [`UpdateDataRetentionOutput`](crate::output::UpdateDataRetentionOutput)

    /// - On failure, responds with [`SdkError<UpdateDataRetentionError>`](crate::error::UpdateDataRetentionError)
    pub fn update_data_retention(&self) -> fluent_builders::UpdateDataRetention {
        fluent_builders::UpdateDataRetention::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSignalingChannel`](crate::client::fluent_builders::UpdateSignalingChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateSignalingChannel::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::UpdateSignalingChannel::set_channel_arn): <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
    ///   - [`current_version(impl Into<String>)`](crate::client::fluent_builders::UpdateSignalingChannel::current_version) / [`set_current_version(Option<String>)`](crate::client::fluent_builders::UpdateSignalingChannel::set_current_version): <p>The current version of the signaling channel that you want to update.</p>
    ///   - [`single_master_configuration(SingleMasterConfiguration)`](crate::client::fluent_builders::UpdateSignalingChannel::single_master_configuration) / [`set_single_master_configuration(Option<SingleMasterConfiguration>)`](crate::client::fluent_builders::UpdateSignalingChannel::set_single_master_configuration): <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update. </p>
    /// - On success, responds with [`UpdateSignalingChannelOutput`](crate::output::UpdateSignalingChannelOutput)

    /// - On failure, responds with [`SdkError<UpdateSignalingChannelError>`](crate::error::UpdateSignalingChannelError)
    pub fn update_signaling_channel(&self) -> fluent_builders::UpdateSignalingChannel {
        fluent_builders::UpdateSignalingChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStream`](crate::client::fluent_builders::UpdateStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_stream_name): <p>The name of the stream whose metadata you want to update.</p>  <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_stream_arn): <p>The ARN of the stream whose metadata you want to update.</p>
    ///   - [`current_version(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::current_version) / [`set_current_version(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_current_version): <p>The version of the stream whose metadata you want to update.</p>
    ///   - [`device_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::device_name) / [`set_device_name(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_device_name): <p>The name of the device that is writing to the stream. </p> <note>   <p> In the current implementation, Kinesis Video Streams does not use this name. </p>  </note>
    ///   - [`media_type(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::media_type) / [`set_media_type(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_media_type): <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>  <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
    /// - On success, responds with [`UpdateStreamOutput`](crate::output::UpdateStreamOutput)

    /// - On failure, responds with [`SdkError<UpdateStreamError>`](crate::error::UpdateStreamError)
    pub fn update_stream(&self) -> fluent_builders::UpdateStream {
        fluent_builders::UpdateStream::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateSignalingChannel`.
    ///
    /// <p>Creates a signaling channel. </p>
    /// <p> <code>CreateSignalingChannel</code> is an asynchronous operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSignalingChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_signaling_channel_input::Builder,
    }
    impl CreateSignalingChannel {
        /// Creates a new `CreateSignalingChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSignalingChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSignalingChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type. </p>
        pub fn channel_type(mut self, input: crate::model::ChannelType) -> Self {
            self.inner = self.inner.channel_type(input);
            self
        }
        /// <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type. </p>
        pub fn set_channel_type(
            mut self,
            input: std::option::Option<crate::model::ChannelType>,
        ) -> Self {
            self.inner = self.inner.set_channel_type(input);
            self
        }
        /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type. </p>
        pub fn single_master_configuration(
            mut self,
            input: crate::model::SingleMasterConfiguration,
        ) -> Self {
            self.inner = self.inner.single_master_configuration(input);
            self
        }
        /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type. </p>
        pub fn set_single_master_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_single_master_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStream`.
    ///
    /// <p>Creates a new Kinesis video stream. </p>
    /// <p>When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream's metadata, Kinesis Video Streams updates the version. </p>
    /// <p> <code>CreateStream</code> is an asynchronous operation.</p>
    /// <p>For information about how the service works, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html">How it Works</a>. </p>
    /// <p>You must have permissions for the <code>KinesisVideo:CreateStream</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_stream_input::Builder,
    }
    impl CreateStream {
        /// Creates a new `CreateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the device that is writing to the stream. </p> <note>
        /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
        /// </note>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(input.into());
            self
        }
        /// <p>The name of the device that is writing to the stream. </p> <note>
        /// <p>In the current implementation, Kinesis Video Streams does not use this name.</p>
        /// </note>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>A name for the stream that you are creating.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>A name for the stream that you are creating.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
        /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
        /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_type(input.into());
            self
        }
        /// <p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
        /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
        /// <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_type(input);
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
        /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p>
        /// <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
        pub fn data_retention_in_hours(mut self, input: i32) -> Self {
            self.inner = self.inner.data_retention_in_hours(input);
            self
        }
        /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>
        pub fn set_data_retention_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_data_retention_in_hours(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSignalingChannel`.
    ///
    /// <p>Deletes a specified signaling channel. <code>DeleteSignalingChannel</code> is an asynchronous operation. If you don't specify the channel's current version, the most recent version is deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSignalingChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_signaling_channel_input::Builder,
    }
    impl DeleteSignalingChannel {
        /// Creates a new `DeleteSignalingChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSignalingChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSignalingChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to delete.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to delete.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the <code>DescribeSignalingChannel</code> or <code>ListSignalingChannels</code> API operations.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the <code>DescribeSignalingChannel</code> or <code>ListSignalingChannels</code> API operations.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStream`.
    ///
    /// <p>Deletes a Kinesis video stream and the data contained in the stream. </p>
    /// <p>This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.</p>
    /// <p> </p>
    /// <p> To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p>
    /// <p>This operation requires permission for the <code>KinesisVideo:DeleteStream</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_stream_input::Builder,
    }
    impl DeleteStream {
        /// Creates a new `DeleteStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>Optional: The version of the stream that you want to delete. </p>
        /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
        /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>Optional: The version of the stream that you want to delete. </p>
        /// <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
        /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSignalingChannel`.
    ///
    /// <p>Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSignalingChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_signaling_channel_input::Builder,
    }
    impl DescribeSignalingChannel {
        /// Creates a new `DescribeSignalingChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSignalingChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSignalingChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signaling channel that you want to describe.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the signaling channel that you want to describe.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>The ARN of the signaling channel that you want to describe.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The ARN of the signaling channel that you want to describe.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStream`.
    ///
    /// <p>Returns the most current information about the specified stream. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_stream_input::Builder,
    }
    impl DescribeStream {
        /// Creates a new `DescribeStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataEndpoint`.
    ///
    /// <p>Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the <code>GetMedia</code> or <code>GetMediaForFragmentList</code> operations) or write to it (using the <code>PutMedia</code> operation). </p> <note>
    /// <p>The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.</p>
    /// </note>
    /// <p>In the request, specify the stream either by <code>StreamName</code> or <code>StreamARN</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_data_endpoint_input::Builder,
    }
    impl GetDataEndpoint {
        /// Creates a new `GetDataEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request. </p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request. </p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The name of the API action for which to get an endpoint.</p>
        pub fn api_name(mut self, input: crate::model::ApiName) -> Self {
            self.inner = self.inner.api_name(input);
            self
        }
        /// <p>The name of the API action for which to get an endpoint.</p>
        pub fn set_api_name(mut self, input: std::option::Option<crate::model::ApiName>) -> Self {
            self.inner = self.inner.set_api_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSignalingChannelEndpoint`.
    ///
    /// <p>Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the <code>SingleMasterChannelEndpointConfiguration</code> input parameter, which consists of the <code>Protocols</code> and <code>Role</code> properties.</p>
    /// <p> <code>Protocols</code> is used to determine the communication mechanism. For example, if you specify <code>WSS</code> as the protocol, this API produces a secure websocket endpoint. If you specify <code>HTTPS</code> as the protocol, this API generates an HTTPS endpoint. </p>
    /// <p> <code>Role</code> determines the messaging permissions. A <code>MASTER</code> role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A <code>VIEWER</code> role results in this API generating an endpoint that a client can use to communicate only with a <code>MASTER</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSignalingChannelEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_signaling_channel_endpoint_input::Builder,
    }
    impl GetSignalingChannelEndpoint {
        /// Creates a new `GetSignalingChannelEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSignalingChannelEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSignalingChannelEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.</p>
        pub fn single_master_channel_endpoint_configuration(
            mut self,
            input: crate::model::SingleMasterChannelEndpointConfiguration,
        ) -> Self {
            self.inner = self
                .inner
                .single_master_channel_endpoint_configuration(input);
            self
        }
        /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.</p>
        pub fn set_single_master_channel_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterChannelEndpointConfiguration>,
        ) -> Self {
            self.inner = self
                .inner
                .set_single_master_channel_endpoint_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSignalingChannels`.
    ///
    /// <p>Returns an array of <code>ChannelInfo</code> objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a <code>ChannelNameCondition</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSignalingChannels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_signaling_channels_input::Builder,
    }
    impl ListSignalingChannels {
        /// Creates a new `ListSignalingChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSignalingChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSignalingChannelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSignalingChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSignalingChannelsPaginator {
            crate::paginator::ListSignalingChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of channels to return in the response. The default is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of channels to return in the response. The default is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
        pub fn channel_name_condition(mut self, input: crate::model::ChannelNameCondition) -> Self {
            self.inner = self.inner.channel_name_condition(input);
            self
        }
        /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
        pub fn set_channel_name_condition(
            mut self,
            input: std::option::Option<crate::model::ChannelNameCondition>,
        ) -> Self {
            self.inner = self.inner.set_channel_name_condition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Returns an array of <code>StreamInfo</code> objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a <code>StreamNameCondition</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreams {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl ListStreams {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamsPaginator {
            crate::paginator::ListStreamsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of streams to return in the response. The default is 10,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of streams to return in the response. The default is 10,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. </p>
        pub fn stream_name_condition(mut self, input: crate::model::StreamNameCondition) -> Self {
            self.inner = self.inner.stream_name_condition(input);
            self
        }
        /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. </p>
        pub fn set_stream_name_condition(
            mut self,
            input: std::option::Option<crate::model::StreamNameCondition>,
        ) -> Self {
            self.inner = self.inner.set_stream_name_condition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags associated with the specified signaling channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForStream`.
    ///
    /// <p>Returns a list of tags associated with the specified stream.</p>
    /// <p>In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_stream_input::Builder,
    }
    impl ListTagsForStream {
        /// Creates a new `ListTagsForStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags for.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags for.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The name of the stream that you want to list tags for.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream that you want to list tags for.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a signaling channel. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagStream`.
    ///
    /// <p>Adds one or more tags to a stream. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>
    /// <p>You must provide either the <code>StreamName</code> or the <code>StreamARN</code>.</p>
    /// <p>This operation requires permission for the <code>KinesisVideo:TagStream</code> action.</p>
    /// <p>Kinesis video streams support up to 50 tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_stream_input::Builder,
    }
    impl TagStream {
        /// Creates a new `TagStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::TagStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The name of the stream that you want to add the tag or tags to.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream that you want to add the tag or tags to.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(input.into());
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagStream`.
    ///
    /// <p>Removes one or more tags from a stream. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.</p>
    /// <p>In the request, you must provide the <code>StreamName</code> or <code>StreamARN</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_stream_input::Builder,
    }
    impl UntagStream {
        /// Creates a new `UntagStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags from.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags from.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The name of the stream that you want to remove tags from.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream that you want to remove tags from.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(input.into());
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataRetention`.
    ///
    /// <p> Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the <code>Operation</code> parameter in the request body. In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p> <note>
    /// <p>The retention period that you specify replaces the current value.</p>
    /// </note>
    /// <p>This operation requires permission for the <code>KinesisVideo:UpdateDataRetention</code> action.</p>
    /// <p>Changing the data retention period affects the data in the stream as follows:</p>
    /// <ul>
    /// <li> <p>If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.</p> </li>
    /// <li> <p>If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataRetention {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_retention_input::Builder,
    }
    impl UpdateDataRetention {
        /// Creates a new `UpdateDataRetention`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataRetentionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataRetentionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream whose retention period you want to change.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream whose retention period you want to change.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
        /// <p>Indicates whether you want to increase or decrease the retention period.</p>
        pub fn operation(mut self, input: crate::model::UpdateDataRetentionOperation) -> Self {
            self.inner = self.inner.operation(input);
            self
        }
        /// <p>Indicates whether you want to increase or decrease the retention period.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::UpdateDataRetentionOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>The retention period, in hours. The value you specify replaces the current value. The maximum value for this parameter is 87600 (ten years).</p>
        pub fn data_retention_change_in_hours(mut self, input: i32) -> Self {
            self.inner = self.inner.data_retention_change_in_hours(input);
            self
        }
        /// <p>The retention period, in hours. The value you specify replaces the current value. The maximum value for this parameter is 87600 (ten years).</p>
        pub fn set_data_retention_change_in_hours(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_data_retention_change_in_hours(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSignalingChannel`.
    ///
    /// <p>Updates the existing signaling channel. This is an asynchronous operation and takes time to complete. </p>
    /// <p>If the <code>MessageTtlSeconds</code> value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous <code>MessageTtlSeconds</code> value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSignalingChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_signaling_channel_input::Builder,
    }
    impl UpdateSignalingChannel {
        /// Creates a new `UpdateSignalingChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSignalingChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSignalingChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The current version of the signaling channel that you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The current version of the signaling channel that you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
        /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update. </p>
        pub fn single_master_configuration(
            mut self,
            input: crate::model::SingleMasterConfiguration,
        ) -> Self {
            self.inner = self.inner.single_master_configuration(input);
            self
        }
        /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update. </p>
        pub fn set_single_master_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_single_master_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStream`.
    ///
    /// <p>Updates stream metadata, such as the device name and media type.</p>
    /// <p>You must provide the stream name or the Amazon Resource Name (ARN) of the stream.</p>
    /// <p>To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p>
    /// <p> <code>UpdateStream</code> is an asynchronous operation, and takes time to complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_stream_input::Builder,
    }
    impl UpdateStream {
        /// Creates a new `UpdateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream whose metadata you want to update.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name of the stream whose metadata you want to update.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
        /// <p>The ARN of the stream whose metadata you want to update.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The ARN of the stream whose metadata you want to update.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The version of the stream whose metadata you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The version of the stream whose metadata you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
        /// <p>The name of the device that is writing to the stream. </p> <note>
        /// <p> In the current implementation, Kinesis Video Streams does not use this name. </p>
        /// </note>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(input.into());
            self
        }
        /// <p>The name of the device that is writing to the stream. </p> <note>
        /// <p> In the current implementation, Kinesis Video Streams does not use this name. </p>
        /// </note>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
        /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_type(input.into());
            self
        }
        /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p>
        /// <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_media_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
