// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSignalingChannelError {
    /// Kind of error that occurred.
    pub kind: CreateSignalingChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSignalingChannelErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You have reached the maximum limit of active signaling channels for this AWS account in this region.</p>
    AccountChannelLimitExceededException(crate::error::AccountChannelLimitExceededException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>
    TagsPerResourceExceededLimitException(crate::error::TagsPerResourceExceededLimitException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSignalingChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSignalingChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSignalingChannelErrorKind::AccountChannelLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateSignalingChannelErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            CreateSignalingChannelErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateSignalingChannelErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateSignalingChannelErrorKind::TagsPerResourceExceededLimitException(_inner) => {
                _inner.fmt(f)
            }
            CreateSignalingChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSignalingChannelError {
    fn code(&self) -> Option<&str> {
        CreateSignalingChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSignalingChannelError {
    /// Creates a new `CreateSignalingChannelError`.
    pub fn new(kind: CreateSignalingChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSignalingChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSignalingChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSignalingChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSignalingChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::AccountChannelLimitExceededException`.
    pub fn is_account_channel_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::AccountChannelLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSignalingChannelErrorKind::TagsPerResourceExceededLimitException`.
    pub fn is_tags_per_resource_exceeded_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSignalingChannelErrorKind::TagsPerResourceExceededLimitException(_)
        )
    }
}
impl std::error::Error for CreateSignalingChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSignalingChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSignalingChannelErrorKind::AccountChannelLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateSignalingChannelErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            CreateSignalingChannelErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateSignalingChannelErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateSignalingChannelErrorKind::TagsPerResourceExceededLimitException(_inner) => {
                Some(_inner)
            }
            CreateSignalingChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamError {
    /// Kind of error that occurred.
    pub kind: CreateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamErrorKind {
    /// <p>The number of streams created for the account is too high.</p>
    AccountStreamLimitExceededException(crate::error::AccountStreamLimitExceededException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>Not implemented. </p>
    DeviceStreamLimitExceededException(crate::error::DeviceStreamLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Not implemented.</p>
    InvalidDeviceException(crate::error::InvalidDeviceException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>
    TagsPerResourceExceededLimitException(crate::error::TagsPerResourceExceededLimitException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamErrorKind::AccountStreamLimitExceededException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::DeviceStreamLimitExceededException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::InvalidDeviceException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::TagsPerResourceExceededLimitException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamError {
    fn code(&self) -> Option<&str> {
        CreateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamError {
    /// Creates a new `CreateStreamError`.
    pub fn new(kind: CreateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::AccountStreamLimitExceededException`.
    pub fn is_account_stream_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::AccountStreamLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::DeviceStreamLimitExceededException`.
    pub fn is_device_stream_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::DeviceStreamLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::InvalidDeviceException`.
    pub fn is_invalid_device_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::InvalidDeviceException(_))
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::TagsPerResourceExceededLimitException`.
    pub fn is_tags_per_resource_exceeded_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::TagsPerResourceExceededLimitException(_)
        )
    }
}
impl std::error::Error for CreateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamErrorKind::AccountStreamLimitExceededException(_inner) => Some(_inner),
            CreateStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            CreateStreamErrorKind::DeviceStreamLimitExceededException(_inner) => Some(_inner),
            CreateStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateStreamErrorKind::InvalidDeviceException(_inner) => Some(_inner),
            CreateStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateStreamErrorKind::TagsPerResourceExceededLimitException(_inner) => Some(_inner),
            CreateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSignalingChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteSignalingChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSignalingChannelErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSignalingChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSignalingChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            DeleteSignalingChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSignalingChannelError {
    fn code(&self) -> Option<&str> {
        DeleteSignalingChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSignalingChannelError {
    /// Creates a new `DeleteSignalingChannelError`.
    pub fn new(kind: DeleteSignalingChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSignalingChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSignalingChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSignalingChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSignalingChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSignalingChannelErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSignalingChannelErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for DeleteSignalingChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSignalingChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::VersionMismatchException(_inner) => Some(_inner),
            DeleteSignalingChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamError {
    fn code(&self) -> Option<&str> {
        DeleteStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamError {
    /// Creates a new `DeleteStreamError`.
    pub fn new(kind: DeleteStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for DeleteStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            DeleteStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeleteStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamErrorKind::VersionMismatchException(_inner) => Some(_inner),
            DeleteStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSignalingChannelError {
    /// Kind of error that occurred.
    pub kind: DescribeSignalingChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSignalingChannelErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSignalingChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSignalingChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeSignalingChannelErrorKind::ClientLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSignalingChannelErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeSignalingChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSignalingChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSignalingChannelError {
    fn code(&self) -> Option<&str> {
        DescribeSignalingChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSignalingChannelError {
    /// Creates a new `DescribeSignalingChannelError`.
    pub fn new(kind: DescribeSignalingChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSignalingChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSignalingChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSignalingChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSignalingChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSignalingChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSignalingChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSignalingChannelErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSignalingChannelErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSignalingChannelErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSignalingChannelErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSignalingChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSignalingChannelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSignalingChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSignalingChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeSignalingChannelErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            DescribeSignalingChannelErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeSignalingChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSignalingChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStreamError {
    /// Kind of error that occurred.
    pub kind: DescribeStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStreamError {
    fn code(&self) -> Option<&str> {
        DescribeStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStreamError {
    /// Creates a new `DescribeStreamError`.
    pub fn new(kind: DescribeStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            DescribeStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataEndpointError {
    /// Kind of error that occurred.
    pub kind: GetDataEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataEndpointErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataEndpointErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            GetDataEndpointErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            GetDataEndpointErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            GetDataEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataEndpointError {
    fn code(&self) -> Option<&str> {
        GetDataEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataEndpointError {
    /// Creates a new `GetDataEndpointError`.
    pub fn new(kind: GetDataEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataEndpointErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataEndpointErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataEndpointErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataEndpointErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataEndpointErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataEndpointErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDataEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataEndpointErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            GetDataEndpointErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            GetDataEndpointErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            GetDataEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSignalingChannelEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSignalingChannelEndpointError {
    /// Kind of error that occurred.
    pub kind: GetSignalingChannelEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSignalingChannelEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSignalingChannelEndpointErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSignalingChannelEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSignalingChannelEndpointErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSignalingChannelEndpointErrorKind::ClientLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetSignalingChannelEndpointErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            GetSignalingChannelEndpointErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            GetSignalingChannelEndpointErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetSignalingChannelEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSignalingChannelEndpointError {
    fn code(&self) -> Option<&str> {
        GetSignalingChannelEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSignalingChannelEndpointError {
    /// Creates a new `GetSignalingChannelEndpointError`.
    pub fn new(kind: GetSignalingChannelEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSignalingChannelEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSignalingChannelEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSignalingChannelEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSignalingChannelEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSignalingChannelEndpointErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSignalingChannelEndpointErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSignalingChannelEndpointErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSignalingChannelEndpointErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSignalingChannelEndpointErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSignalingChannelEndpointErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSignalingChannelEndpointErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSignalingChannelEndpointErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSignalingChannelEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSignalingChannelEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSignalingChannelEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSignalingChannelEndpointErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSignalingChannelEndpointErrorKind::ClientLimitExceededException(_inner) => {
                Some(_inner)
            }
            GetSignalingChannelEndpointErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            GetSignalingChannelEndpointErrorKind::ResourceInUseException(_inner) => Some(_inner),
            GetSignalingChannelEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSignalingChannelEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSignalingChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSignalingChannelsError {
    /// Kind of error that occurred.
    pub kind: ListSignalingChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSignalingChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSignalingChannelsErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSignalingChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSignalingChannelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSignalingChannelsErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            ListSignalingChannelsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListSignalingChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSignalingChannelsError {
    fn code(&self) -> Option<&str> {
        ListSignalingChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSignalingChannelsError {
    /// Creates a new `ListSignalingChannelsError`.
    pub fn new(kind: ListSignalingChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSignalingChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSignalingChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSignalingChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSignalingChannelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSignalingChannelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSignalingChannelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSignalingChannelsErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSignalingChannelsErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSignalingChannelsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSignalingChannelsErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for ListSignalingChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSignalingChannelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSignalingChannelsErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            ListSignalingChannelsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListSignalingChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamsError {
    /// Kind of error that occurred.
    pub kind: ListStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamsErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamsErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            ListStreamsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamsError {
    fn code(&self) -> Option<&str> {
        ListStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamsError {
    /// Creates a new `ListStreamsError`.
    pub fn new(kind: ListStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStreamsErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamsErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStreamsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamsErrorKind::InvalidArgumentException(_)
        )
    }
}
impl std::error::Error for ListStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamsErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            ListStreamsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForStreamError {
    /// Kind of error that occurred.
    pub kind: ListTagsForStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The format of the <code>StreamARN</code> is invalid.</p>
    InvalidResourceFormatException(crate::error::InvalidResourceFormatException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::InvalidResourceFormatException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForStreamError {
    fn code(&self) -> Option<&str> {
        ListTagsForStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForStreamError {
    /// Creates a new `ListTagsForStreamError`.
    pub fn new(kind: ListTagsForStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::InvalidResourceFormatException`.
    pub fn is_invalid_resource_format_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::InvalidResourceFormatException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::InvalidResourceFormatException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>
    TagsPerResourceExceededLimitException(crate::error::TagsPerResourceExceededLimitException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagsPerResourceExceededLimitException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagsPerResourceExceededLimitException`.
    pub fn is_tags_per_resource_exceeded_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagsPerResourceExceededLimitException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TagsPerResourceExceededLimitException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagStreamError {
    /// Kind of error that occurred.
    pub kind: TagStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The format of the <code>StreamARN</code> is invalid.</p>
    InvalidResourceFormatException(crate::error::InvalidResourceFormatException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>
    TagsPerResourceExceededLimitException(crate::error::TagsPerResourceExceededLimitException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::InvalidResourceFormatException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::TagsPerResourceExceededLimitException(_inner) => _inner.fmt(f),
            TagStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagStreamError {
    fn code(&self) -> Option<&str> {
        TagStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagStreamError {
    /// Creates a new `TagStreamError`.
    pub fn new(kind: TagStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, TagStreamErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::InvalidResourceFormatException`.
    pub fn is_invalid_resource_format_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagStreamErrorKind::InvalidResourceFormatException(_)
        )
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, TagStreamErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagStreamErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagStreamErrorKind::TagsPerResourceExceededLimitException`.
    pub fn is_tags_per_resource_exceeded_limit_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagStreamErrorKind::TagsPerResourceExceededLimitException(_)
        )
    }
}
impl std::error::Error for TagStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            TagStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            TagStreamErrorKind::InvalidResourceFormatException(_inner) => Some(_inner),
            TagStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            TagStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagStreamErrorKind::TagsPerResourceExceededLimitException(_inner) => Some(_inner),
            TagStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagStreamError {
    /// Kind of error that occurred.
    pub kind: UntagStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The format of the <code>StreamARN</code> is invalid.</p>
    InvalidResourceFormatException(crate::error::InvalidResourceFormatException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            UntagStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UntagStreamErrorKind::InvalidResourceFormatException(_inner) => _inner.fmt(f),
            UntagStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UntagStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagStreamError {
    fn code(&self) -> Option<&str> {
        UntagStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagStreamError {
    /// Creates a new `UntagStreamError`.
    pub fn new(kind: UntagStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagStreamErrorKind::InvalidResourceFormatException`.
    pub fn is_invalid_resource_format_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagStreamErrorKind::InvalidResourceFormatException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, UntagStreamErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `UntagStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            UntagStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UntagStreamErrorKind::InvalidResourceFormatException(_inner) => Some(_inner),
            UntagStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UntagStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataRetention` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataRetentionError {
    /// Kind of error that occurred.
    pub kind: UpdateDataRetentionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataRetention` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataRetentionErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataRetentionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataRetentionErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateDataRetentionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataRetentionError {
    fn code(&self) -> Option<&str> {
        UpdateDataRetentionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataRetentionError {
    /// Creates a new `UpdateDataRetentionError`.
    pub fn new(kind: UpdateDataRetentionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataRetentionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataRetentionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataRetentionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataRetentionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataRetentionErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataRetentionErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateDataRetentionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataRetentionErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateDataRetentionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSignalingChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateSignalingChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSignalingChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSignalingChannelErrorKind {
    /// <p>You do not have required permissions to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSignalingChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSignalingChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateSignalingChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSignalingChannelError {
    fn code(&self) -> Option<&str> {
        UpdateSignalingChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSignalingChannelError {
    /// Creates a new `UpdateSignalingChannelError`.
    pub fn new(kind: UpdateSignalingChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSignalingChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSignalingChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSignalingChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSignalingChannelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSignalingChannelErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSignalingChannelErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateSignalingChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSignalingChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateSignalingChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStreamError {
    /// Kind of error that occurred.
    pub kind: UpdateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStreamErrorKind {
    /// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
    ClientLimitExceededException(crate::error::ClientLimitExceededException),
    /// <p>The value for this input parameter is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The caller is not authorized to perform this operation.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>The signaling channel is currently not available for this operation.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStreamErrorKind::ClientLimitExceededException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStreamError {
    fn code(&self) -> Option<&str> {
        UpdateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStreamError {
    /// Creates a new `UpdateStreamError`.
    pub fn new(kind: UpdateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::ClientLimitExceededException`.
    pub fn is_client_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamErrorKind::ClientLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateStreamErrorKind::NotAuthorizedException(_))
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateStreamErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStreamErrorKind::ClientLimitExceededException(_inner) => Some(_inner),
            UpdateStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateStreamErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            UpdateStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStreamErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VersionMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl VersionMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VersionMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "VersionMismatchException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for VersionMismatchException {}
/// See [`VersionMismatchException`](crate::error::VersionMismatchException)
pub mod version_mismatch_exception {
    /// A builder for [`VersionMismatchException`](crate::error::VersionMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionMismatchException`](crate::error::VersionMismatchException)
        pub fn build(self) -> crate::error::VersionMismatchException {
            crate::error::VersionMismatchException {
                message: self.message,
            }
        }
    }
}
impl VersionMismatchException {
    /// Creates a new builder-style object to manufacture [`VersionMismatchException`](crate::error::VersionMismatchException)
    pub fn builder() -> crate::error::version_mismatch_exception::Builder {
        crate::error::version_mismatch_exception::Builder::default()
    }
}

/// <p>Amazon Kinesis Video Streams can't find the stream that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The signaling channel is currently not available for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The caller is not authorized to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotAuthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotAuthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotAuthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotAuthorizedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotAuthorizedException {}
/// See [`NotAuthorizedException`](crate::error::NotAuthorizedException)
pub mod not_authorized_exception {
    /// A builder for [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotAuthorizedException`](crate::error::NotAuthorizedException)
        pub fn build(self) -> crate::error::NotAuthorizedException {
            crate::error::NotAuthorizedException {
                message: self.message,
            }
        }
    }
}
impl NotAuthorizedException {
    /// Creates a new builder-style object to manufacture [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    pub fn builder() -> crate::error::not_authorized_exception::Builder {
        crate::error::not_authorized_exception::Builder::default()
    }
}

/// <p>The value for this input parameter is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgumentException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgumentException {}
/// See [`InvalidArgumentException`](crate::error::InvalidArgumentException)
pub mod invalid_argument_exception {
    /// A builder for [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgumentException`](crate::error::InvalidArgumentException)
        pub fn build(self) -> crate::error::InvalidArgumentException {
            crate::error::InvalidArgumentException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgumentException {
    /// Creates a new builder-style object to manufacture [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    pub fn builder() -> crate::error::invalid_argument_exception::Builder {
        crate::error::invalid_argument_exception::Builder::default()
    }
}

/// <p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClientLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClientLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientLimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientLimitExceededException {}
/// See [`ClientLimitExceededException`](crate::error::ClientLimitExceededException)
pub mod client_limit_exceeded_exception {
    /// A builder for [`ClientLimitExceededException`](crate::error::ClientLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientLimitExceededException`](crate::error::ClientLimitExceededException)
        pub fn build(self) -> crate::error::ClientLimitExceededException {
            crate::error::ClientLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ClientLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ClientLimitExceededException`](crate::error::ClientLimitExceededException)
    pub fn builder() -> crate::error::client_limit_exceeded_exception::Builder {
        crate::error::client_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You do not have required permissions to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The format of the <code>StreamARN</code> is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceFormatException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceFormatException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceFormatException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceFormatException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceFormatException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceFormatException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceFormatException {}
/// See [`InvalidResourceFormatException`](crate::error::InvalidResourceFormatException)
pub mod invalid_resource_format_exception {
    /// A builder for [`InvalidResourceFormatException`](crate::error::InvalidResourceFormatException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceFormatException`](crate::error::InvalidResourceFormatException)
        pub fn build(self) -> crate::error::InvalidResourceFormatException {
            crate::error::InvalidResourceFormatException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceFormatException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceFormatException`](crate::error::InvalidResourceFormatException)
    pub fn builder() -> crate::error::invalid_resource_format_exception::Builder {
        crate::error::invalid_resource_format_exception::Builder::default()
    }
}

/// <p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagsPerResourceExceededLimitException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagsPerResourceExceededLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagsPerResourceExceededLimitException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagsPerResourceExceededLimitException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagsPerResourceExceededLimitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagsPerResourceExceededLimitException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagsPerResourceExceededLimitException {}
/// See [`TagsPerResourceExceededLimitException`](crate::error::TagsPerResourceExceededLimitException)
pub mod tags_per_resource_exceeded_limit_exception {
    /// A builder for [`TagsPerResourceExceededLimitException`](crate::error::TagsPerResourceExceededLimitException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagsPerResourceExceededLimitException`](crate::error::TagsPerResourceExceededLimitException)
        pub fn build(self) -> crate::error::TagsPerResourceExceededLimitException {
            crate::error::TagsPerResourceExceededLimitException {
                message: self.message,
            }
        }
    }
}
impl TagsPerResourceExceededLimitException {
    /// Creates a new builder-style object to manufacture [`TagsPerResourceExceededLimitException`](crate::error::TagsPerResourceExceededLimitException)
    pub fn builder() -> crate::error::tags_per_resource_exceeded_limit_exception::Builder {
        crate::error::tags_per_resource_exceeded_limit_exception::Builder::default()
    }
}

/// <p>Not implemented.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDeviceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDeviceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDeviceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDeviceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDeviceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDeviceException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDeviceException {}
/// See [`InvalidDeviceException`](crate::error::InvalidDeviceException)
pub mod invalid_device_exception {
    /// A builder for [`InvalidDeviceException`](crate::error::InvalidDeviceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDeviceException`](crate::error::InvalidDeviceException)
        pub fn build(self) -> crate::error::InvalidDeviceException {
            crate::error::InvalidDeviceException {
                message: self.message,
            }
        }
    }
}
impl InvalidDeviceException {
    /// Creates a new builder-style object to manufacture [`InvalidDeviceException`](crate::error::InvalidDeviceException)
    pub fn builder() -> crate::error::invalid_device_exception::Builder {
        crate::error::invalid_device_exception::Builder::default()
    }
}

/// <p>Not implemented. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceStreamLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeviceStreamLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceStreamLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DeviceStreamLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DeviceStreamLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DeviceStreamLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for DeviceStreamLimitExceededException {}
/// See [`DeviceStreamLimitExceededException`](crate::error::DeviceStreamLimitExceededException)
pub mod device_stream_limit_exceeded_exception {
    /// A builder for [`DeviceStreamLimitExceededException`](crate::error::DeviceStreamLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceStreamLimitExceededException`](crate::error::DeviceStreamLimitExceededException)
        pub fn build(self) -> crate::error::DeviceStreamLimitExceededException {
            crate::error::DeviceStreamLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl DeviceStreamLimitExceededException {
    /// Creates a new builder-style object to manufacture [`DeviceStreamLimitExceededException`](crate::error::DeviceStreamLimitExceededException)
    pub fn builder() -> crate::error::device_stream_limit_exceeded_exception::Builder {
        crate::error::device_stream_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The number of streams created for the account is too high.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountStreamLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountStreamLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountStreamLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountStreamLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountStreamLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountStreamLimitExceededException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountStreamLimitExceededException {}
/// See [`AccountStreamLimitExceededException`](crate::error::AccountStreamLimitExceededException)
pub mod account_stream_limit_exceeded_exception {
    /// A builder for [`AccountStreamLimitExceededException`](crate::error::AccountStreamLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountStreamLimitExceededException`](crate::error::AccountStreamLimitExceededException)
        pub fn build(self) -> crate::error::AccountStreamLimitExceededException {
            crate::error::AccountStreamLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl AccountStreamLimitExceededException {
    /// Creates a new builder-style object to manufacture [`AccountStreamLimitExceededException`](crate::error::AccountStreamLimitExceededException)
    pub fn builder() -> crate::error::account_stream_limit_exceeded_exception::Builder {
        crate::error::account_stream_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You have reached the maximum limit of active signaling channels for this AWS account in this region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountChannelLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountChannelLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountChannelLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountChannelLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountChannelLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountChannelLimitExceededException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountChannelLimitExceededException {}
/// See [`AccountChannelLimitExceededException`](crate::error::AccountChannelLimitExceededException)
pub mod account_channel_limit_exceeded_exception {
    /// A builder for [`AccountChannelLimitExceededException`](crate::error::AccountChannelLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountChannelLimitExceededException`](crate::error::AccountChannelLimitExceededException)
        pub fn build(self) -> crate::error::AccountChannelLimitExceededException {
            crate::error::AccountChannelLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl AccountChannelLimitExceededException {
    /// Creates a new builder-style object to manufacture [`AccountChannelLimitExceededException`](crate::error::AccountChannelLimitExceededException)
    pub fn builder() -> crate::error::account_channel_limit_exceeded_exception::Builder {
        crate::error::account_channel_limit_exceeded_exception::Builder::default()
    }
}
