// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateSignalingChannelInput`](crate::input::CreateSignalingChannelInput)
pub mod create_signaling_channel_input {
    /// A builder for [`CreateSignalingChannelInput`](crate::input::CreateSignalingChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) channel_type: std::option::Option<crate::model::ChannelType>,
        pub(crate) single_master_configuration:
            std::option::Option<crate::model::SingleMasterConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS
        /// account and AWS Region.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS
        /// account and AWS Region.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>A type of the signaling channel that you are creating. Currently,
        /// <code>SINGLE_MASTER</code> is the only supported channel type. </p>
        pub fn channel_type(mut self, input: crate::model::ChannelType) -> Self {
            self.channel_type = Some(input);
            self
        }
        /// <p>A type of the signaling channel that you are creating. Currently,
        /// <code>SINGLE_MASTER</code> is the only supported channel type. </p>
        pub fn set_channel_type(
            mut self,
            input: std::option::Option<crate::model::ChannelType>,
        ) -> Self {
            self.channel_type = input;
            self
        }
        /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel
        /// type. </p>
        pub fn single_master_configuration(
            mut self,
            input: crate::model::SingleMasterConfiguration,
        ) -> Self {
            self.single_master_configuration = Some(input);
            self
        }
        /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel
        /// type. </p>
        pub fn set_single_master_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterConfiguration>,
        ) -> Self {
            self.single_master_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSignalingChannelInput`](crate::input::CreateSignalingChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSignalingChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSignalingChannelInput {
                channel_name: self.channel_name,
                channel_type: self.channel_type,
                single_master_configuration: self.single_master_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSignalingChannelInputOperationOutputAlias = crate::operation::CreateSignalingChannel;
#[doc(hidden)]
pub type CreateSignalingChannelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSignalingChannelInput {
    /// Consumes the builder and constructs an Operation<[`CreateSignalingChannel`](crate::operation::CreateSignalingChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSignalingChannel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSignalingChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createSignalingChannel").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSignalingChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSignalingChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_signaling_channel(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSignalingChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSignalingChannel",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSignalingChannelInput`](crate::input::CreateSignalingChannelInput)
    pub fn builder() -> crate::input::create_signaling_channel_input::Builder {
        crate::input::create_signaling_channel_input::Builder::default()
    }
}

/// See [`CreateStreamInput`](crate::input::CreateStreamInput)
pub mod create_stream_input {
    /// A builder for [`CreateStreamInput`](crate::input::CreateStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) media_type: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) data_retention_in_hours: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the device that is writing to the stream. </p>
        /// <note>
        /// <p>In the current implementation, Kinesis Video Streams does not use this
        /// name.</p>
        /// </note>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device that is writing to the stream. </p>
        /// <note>
        /// <p>In the current implementation, Kinesis Video Streams does not use this
        /// name.</p>
        /// </note>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>A name for the stream that you are creating.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each
        /// account and region.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>A name for the stream that you are creating.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each
        /// account and region.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The media type of the stream. Consumers of the stream can use this information when
        /// processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
        /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
        /// for guidelines.</p>
        ///
        /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
        /// <p>This parameter is optional; the default value is <code>null</code> (or empty in
        /// JSON).</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_type = Some(input.into());
            self
        }
        /// <p>The media type of the stream. Consumers of the stream can use this information when
        /// processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
        /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
        /// for guidelines.</p>
        ///
        /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
        /// <p>This parameter is optional; the default value is <code>null</code> (or empty in
        /// JSON).</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_type = input;
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video
        /// Streams to use to encrypt stream data.</p>
        /// <p>If no key ID is specified, the default, Kinesis Video-managed key
        /// (<code>aws/kinesisvideo</code>) is used.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video
        /// Streams to use to encrypt stream data.</p>
        /// <p>If no key ID is specified, the default, Kinesis Video-managed key
        /// (<code>aws/kinesisvideo</code>) is used.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video
        /// Streams retains the data in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume
        /// the fragments that remain in the service host buffer, which has a retention time limit
        /// of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the
        /// buffer when either limit is reached.</p>
        pub fn data_retention_in_hours(mut self, input: i32) -> Self {
            self.data_retention_in_hours = Some(input);
            self
        }
        /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video
        /// Streams retains the data in a data store that is associated with the stream.</p>
        /// <p>The default value is 0, indicating that the stream does not persist data.</p>
        /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume
        /// the fragments that remain in the service host buffer, which has a retention time limit
        /// of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the
        /// buffer when either limit is reached.</p>
        pub fn set_data_retention_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.data_retention_in_hours = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
        /// (the value is optional).</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
        /// (the value is optional).</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamInput`](crate::input::CreateStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamInput {
                device_name: self.device_name,
                stream_name: self.stream_name,
                media_type: self.media_type,
                kms_key_id: self.kms_key_id,
                data_retention_in_hours: self.data_retention_in_hours,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamInputOperationOutputAlias = crate::operation::CreateStream;
#[doc(hidden)]
pub type CreateStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStreamInput {
    /// Consumes the builder and constructs an Operation<[`CreateStream`](crate::operation::CreateStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamInput`](crate::input::CreateStreamInput)
    pub fn builder() -> crate::input::create_stream_input::Builder {
        crate::input::create_stream_input::Builder::default()
    }
}

/// See [`DeleteSignalingChannelInput`](crate::input::DeleteSignalingChannelInput)
pub mod delete_signaling_channel_input {
    /// A builder for [`DeleteSignalingChannelInput`](crate::input::DeleteSignalingChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
        /// delete.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
        /// delete.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The current version of the signaling channel that you want to delete. You can obtain
        /// the current version by invoking the <code>DescribeSignalingChannel</code> or
        /// <code>ListSignalingChannels</code> API operations.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the signaling channel that you want to delete. You can obtain
        /// the current version by invoking the <code>DescribeSignalingChannel</code> or
        /// <code>ListSignalingChannels</code> API operations.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSignalingChannelInput`](crate::input::DeleteSignalingChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSignalingChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSignalingChannelInput {
                channel_arn: self.channel_arn,
                current_version: self.current_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSignalingChannelInputOperationOutputAlias = crate::operation::DeleteSignalingChannel;
#[doc(hidden)]
pub type DeleteSignalingChannelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSignalingChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSignalingChannel`](crate::operation::DeleteSignalingChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSignalingChannel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSignalingChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteSignalingChannel").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSignalingChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSignalingChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_signaling_channel(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSignalingChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSignalingChannel",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSignalingChannelInput`](crate::input::DeleteSignalingChannelInput)
    pub fn builder() -> crate::input::delete_signaling_channel_input::Builder {
        crate::input::delete_signaling_channel_input::Builder::default()
    }
}

/// See [`DeleteStreamInput`](crate::input::DeleteStreamInput)
pub mod delete_stream_input {
    /// A builder for [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>Optional: The version of the stream that you want to delete. </p>
        /// <p>Specify the version as a safeguard to ensure that your are deleting the correct
        /// stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
        /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the
        /// stream.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>Optional: The version of the stream that you want to delete. </p>
        /// <p>Specify the version as a safeguard to ensure that your are deleting the correct
        /// stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
        /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the
        /// stream.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStreamInput`](crate::input::DeleteStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStreamInput {
                stream_arn: self.stream_arn,
                current_version: self.current_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStreamInputOperationOutputAlias = crate::operation::DeleteStream;
#[doc(hidden)]
pub type DeleteStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStreamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStream`](crate::operation::DeleteStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    pub fn builder() -> crate::input::delete_stream_input::Builder {
        crate::input::delete_stream_input::Builder::default()
    }
}

/// See [`DescribeSignalingChannelInput`](crate::input::DescribeSignalingChannelInput)
pub mod describe_signaling_channel_input {
    /// A builder for [`DescribeSignalingChannelInput`](crate::input::DescribeSignalingChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the signaling channel that you want to describe.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>The name of the signaling channel that you want to describe.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>The ARN of the signaling channel that you want to describe.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signaling channel that you want to describe.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSignalingChannelInput`](crate::input::DescribeSignalingChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSignalingChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSignalingChannelInput {
                channel_name: self.channel_name,
                channel_arn: self.channel_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSignalingChannelInputOperationOutputAlias =
    crate::operation::DescribeSignalingChannel;
#[doc(hidden)]
pub type DescribeSignalingChannelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSignalingChannelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSignalingChannel`](crate::operation::DescribeSignalingChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSignalingChannel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSignalingChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describeSignalingChannel").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSignalingChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSignalingChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_signaling_channel(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSignalingChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSignalingChannel",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSignalingChannelInput`](crate::input::DescribeSignalingChannelInput)
    pub fn builder() -> crate::input::describe_signaling_channel_input::Builder {
        crate::input::describe_signaling_channel_input::Builder::default()
    }
}

/// See [`DescribeStreamInput`](crate::input::DescribeStreamInput)
pub mod describe_stream_input {
    /// A builder for [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamInput`](crate::input::DescribeStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStreamInput {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStreamInputOperationOutputAlias = crate::operation::DescribeStream;
#[doc(hidden)]
pub type DescribeStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStreamInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStream`](crate::operation::DescribeStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describeStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    pub fn builder() -> crate::input::describe_stream_input::Builder {
        crate::input::describe_stream_input::Builder::default()
    }
}

/// See [`GetDataEndpointInput`](crate::input::GetDataEndpointInput)
pub mod get_data_endpoint_input {
    /// A builder for [`GetDataEndpointInput`](crate::input::GetDataEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) api_name: std::option::Option<crate::model::ApiName>,
    }
    impl Builder {
        /// <p>The name of the stream that you want to get the endpoint for. You must specify
        /// either this parameter or a <code>StreamARN</code> in the request.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream that you want to get the endpoint for. You must specify
        /// either this parameter or a <code>StreamARN</code> in the request.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for.
        /// You must specify either this parameter or a <code>StreamName</code> in the request.
        /// </p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for.
        /// You must specify either this parameter or a <code>StreamName</code> in the request.
        /// </p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The name of the API action for which to get an endpoint.</p>
        pub fn api_name(mut self, input: crate::model::ApiName) -> Self {
            self.api_name = Some(input);
            self
        }
        /// <p>The name of the API action for which to get an endpoint.</p>
        pub fn set_api_name(mut self, input: std::option::Option<crate::model::ApiName>) -> Self {
            self.api_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataEndpointInput`](crate::input::GetDataEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataEndpointInput {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                api_name: self.api_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataEndpointInputOperationOutputAlias = crate::operation::GetDataEndpoint;
#[doc(hidden)]
pub type GetDataEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDataEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetDataEndpoint`](crate::operation::GetDataEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getDataEndpoint").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_data_endpoint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataEndpoint",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataEndpointInput`](crate::input::GetDataEndpointInput)
    pub fn builder() -> crate::input::get_data_endpoint_input::Builder {
        crate::input::get_data_endpoint_input::Builder::default()
    }
}

/// See [`GetSignalingChannelEndpointInput`](crate::input::GetSignalingChannelEndpointInput)
pub mod get_signaling_channel_endpoint_input {
    /// A builder for [`GetSignalingChannelEndpointInput`](crate::input::GetSignalingChannelEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) single_master_channel_endpoint_configuration:
            std::option::Option<crate::model::SingleMasterChannelEndpointConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an
        /// endpoint.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an
        /// endpoint.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code>
        /// channel type.</p>
        pub fn single_master_channel_endpoint_configuration(
            mut self,
            input: crate::model::SingleMasterChannelEndpointConfiguration,
        ) -> Self {
            self.single_master_channel_endpoint_configuration = Some(input);
            self
        }
        /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code>
        /// channel type.</p>
        pub fn set_single_master_channel_endpoint_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterChannelEndpointConfiguration>,
        ) -> Self {
            self.single_master_channel_endpoint_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSignalingChannelEndpointInput`](crate::input::GetSignalingChannelEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSignalingChannelEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSignalingChannelEndpointInput {
                channel_arn: self.channel_arn,
                single_master_channel_endpoint_configuration: self
                    .single_master_channel_endpoint_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSignalingChannelEndpointInputOperationOutputAlias =
    crate::operation::GetSignalingChannelEndpoint;
#[doc(hidden)]
pub type GetSignalingChannelEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSignalingChannelEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetSignalingChannelEndpoint`](crate::operation::GetSignalingChannelEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSignalingChannelEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSignalingChannelEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getSignalingChannelEndpoint").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSignalingChannelEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSignalingChannelEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_signaling_channel_endpoint(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSignalingChannelEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSignalingChannelEndpoint",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSignalingChannelEndpointInput`](crate::input::GetSignalingChannelEndpointInput)
    pub fn builder() -> crate::input::get_signaling_channel_endpoint_input::Builder {
        crate::input::get_signaling_channel_endpoint_input::Builder::default()
    }
}

/// See [`ListSignalingChannelsInput`](crate::input::ListSignalingChannelsInput)
pub mod list_signaling_channels_input {
    /// A builder for [`ListSignalingChannelsInput`](crate::input::ListSignalingChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) channel_name_condition: std::option::Option<crate::model::ChannelNameCondition>,
    }
    impl Builder {
        /// <p>The maximum number of channels to return in the response. The default is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of channels to return in the response. The default is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code>
        /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
        /// get another batch of channels, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code>
        /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
        /// get another batch of channels, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
        pub fn channel_name_condition(mut self, input: crate::model::ChannelNameCondition) -> Self {
            self.channel_name_condition = Some(input);
            self
        }
        /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
        pub fn set_channel_name_condition(
            mut self,
            input: std::option::Option<crate::model::ChannelNameCondition>,
        ) -> Self {
            self.channel_name_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSignalingChannelsInput`](crate::input::ListSignalingChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSignalingChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSignalingChannelsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                channel_name_condition: self.channel_name_condition,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSignalingChannelsInputOperationOutputAlias = crate::operation::ListSignalingChannels;
#[doc(hidden)]
pub type ListSignalingChannelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSignalingChannelsInput {
    /// Consumes the builder and constructs an Operation<[`ListSignalingChannels`](crate::operation::ListSignalingChannels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSignalingChannels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSignalingChannelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listSignalingChannels").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSignalingChannelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSignalingChannelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_signaling_channels(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSignalingChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSignalingChannels",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSignalingChannelsInput`](crate::input::ListSignalingChannelsInput)
    pub fn builder() -> crate::input::list_signaling_channels_input::Builder {
        crate::input::list_signaling_channels_input::Builder::default()
    }
}

/// See [`ListStreamsInput`](crate::input::ListStreamsInput)
pub mod list_streams_input {
    /// A builder for [`ListStreamsInput`](crate::input::ListStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) stream_name_condition: std::option::Option<crate::model::StreamNameCondition>,
    }
    impl Builder {
        /// <p>The maximum number of streams to return in the response. The default is
        /// 10,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of streams to return in the response. The default is
        /// 10,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListStreams</code>
        /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
        /// get another batch of streams, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you specify this parameter, when the result of a <code>ListStreams</code>
        /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
        /// get another batch of streams, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you
        /// can specify only the prefix of a stream name as a condition. </p>
        pub fn stream_name_condition(mut self, input: crate::model::StreamNameCondition) -> Self {
            self.stream_name_condition = Some(input);
            self
        }
        /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you
        /// can specify only the prefix of a stream name as a condition. </p>
        pub fn set_stream_name_condition(
            mut self,
            input: std::option::Option<crate::model::StreamNameCondition>,
        ) -> Self {
            self.stream_name_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamsInput`](crate::input::ListStreamsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStreamsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStreamsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                stream_name_condition: self.stream_name_condition,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStreamsInputOperationOutputAlias = crate::operation::ListStreams;
#[doc(hidden)]
pub type ListStreamsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStreamsInput {
    /// Consumes the builder and constructs an Operation<[`ListStreams`](crate::operation::ListStreams)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStreams,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStreamsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listStreams").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStreamsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStreamsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_streams(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStreams::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStreams",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStreamsInput`](crate::input::ListStreamsInput)
    pub fn builder() -> crate::input::list_streams_input::Builder {
        crate::input::list_streams_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code>
        /// call is truncated, the response includes a token that you can use in the next request to
        /// fetch the next batch of tags. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code>
        /// call is truncated, the response includes a token that you can use in the next request to
        /// fetch the next batch of tags. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list
        /// tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list
        /// tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                next_token: self.next_token,
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListTagsForResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTagsForStreamInput`](crate::input::ListTagsForStreamInput)
pub mod list_tags_for_stream_input {
    /// A builder for [`ListTagsForStreamInput`](crate::input::ListTagsForStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code>
        /// call is truncated, the response includes a token that you can use in the next request to
        /// fetch the next batch of tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code>
        /// call is truncated, the response includes a token that you can use in the next request to
        /// fetch the next batch of tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags
        /// for.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags
        /// for.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The name of the stream that you want to list tags for.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream that you want to list tags for.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForStreamInput`](crate::input::ListTagsForStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForStreamInput {
                next_token: self.next_token,
                stream_arn: self.stream_arn,
                stream_name: self.stream_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForStreamInputOperationOutputAlias = crate::operation::ListTagsForStream;
#[doc(hidden)]
pub type ListTagsForStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForStreamInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForStream`](crate::operation::ListTagsForStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listTagsForStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForStreamInput`](crate::input::ListTagsForStreamInput)
    pub fn builder() -> crate::input::list_tags_for_stream_input::Builder {
        crate::input::list_tags_for_stream_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add
        /// tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add
        /// tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified signaling channel. Each tag is a
        /// key-value pair.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with the specified signaling channel. Each tag is a
        /// key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/TagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TagStreamInput`](crate::input::TagStreamInput)
pub mod tag_stream_input {
    /// A builder for [`TagStreamInput`](crate::input::TagStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags
        /// to.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags
        /// to.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The name of the stream that you want to add the tag or tags to.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream that you want to add the tag or tags to.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
        /// (the value is optional).</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
        /// (the value is optional).</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagStreamInput`](crate::input::TagStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::TagStreamInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::TagStreamInput {
                stream_arn: self.stream_arn,
                stream_name: self.stream_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagStreamInputOperationOutputAlias = crate::operation::TagStream;
#[doc(hidden)]
pub type TagStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagStreamInput {
    /// Consumes the builder and constructs an Operation<[`TagStream`](crate::operation::TagStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tagStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::TagStream::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "TagStream",
                    "kinesisvideo",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagStreamInput`](crate::input::TagStreamInput)
    pub fn builder() -> crate::input::tag_stream_input::Builder {
        crate::input::tag_stream_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove
        /// tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove
        /// tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_key_list`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_key_list.unwrap_or_default();
            v.push(input.into());
            self.tag_key_list = Some(v);
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_key_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_key_list: self.tag_key_list,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/UntagResource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UntagStreamInput`](crate::input::UntagStreamInput)
pub mod untag_stream_input {
    /// A builder for [`UntagStreamInput`](crate::input::UntagStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags
        /// from.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags
        /// from.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The name of the stream that you want to remove tags from.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream that you want to remove tags from.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Appends an item to `tag_key_list`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_key_list.unwrap_or_default();
            v.push(input.into());
            self.tag_key_list = Some(v);
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_key_list = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagStreamInput`](crate::input::UntagStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagStreamInput {
                stream_arn: self.stream_arn,
                stream_name: self.stream_name,
                tag_key_list: self.tag_key_list,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagStreamInputOperationOutputAlias = crate::operation::UntagStream;
#[doc(hidden)]
pub type UntagStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagStreamInput {
    /// Consumes the builder and constructs an Operation<[`UntagStream`](crate::operation::UntagStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/untagStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagStreamInput`](crate::input::UntagStreamInput)
    pub fn builder() -> crate::input::untag_stream_input::Builder {
        crate::input::untag_stream_input::Builder::default()
    }
}

/// See [`UpdateDataRetentionInput`](crate::input::UpdateDataRetentionInput)
pub mod update_data_retention_input {
    /// A builder for [`UpdateDataRetentionInput`](crate::input::UpdateDataRetentionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::UpdateDataRetentionOperation>,
        pub(crate) data_retention_change_in_hours: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the stream whose retention period you want to change.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream whose retention period you want to change.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to
        /// change.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to
        /// change.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The version of the stream whose retention period you want to change. To get the
        /// version, call either the <code>DescribeStream</code> or the <code>ListStreams</code>
        /// API.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The version of the stream whose retention period you want to change. To get the
        /// version, call either the <code>DescribeStream</code> or the <code>ListStreams</code>
        /// API.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>Indicates whether you want to increase or decrease the retention period.</p>
        pub fn operation(mut self, input: crate::model::UpdateDataRetentionOperation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>Indicates whether you want to increase or decrease the retention period.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::UpdateDataRetentionOperation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The retention period, in hours. The value you specify replaces the current value.
        /// The maximum value for this parameter is 87600 (ten years).</p>
        pub fn data_retention_change_in_hours(mut self, input: i32) -> Self {
            self.data_retention_change_in_hours = Some(input);
            self
        }
        /// <p>The retention period, in hours. The value you specify replaces the current value.
        /// The maximum value for this parameter is 87600 (ten years).</p>
        pub fn set_data_retention_change_in_hours(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_retention_change_in_hours = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataRetentionInput`](crate::input::UpdateDataRetentionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataRetentionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataRetentionInput {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                current_version: self.current_version,
                operation: self.operation,
                data_retention_change_in_hours: self.data_retention_change_in_hours,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataRetentionInputOperationOutputAlias = crate::operation::UpdateDataRetention;
#[doc(hidden)]
pub type UpdateDataRetentionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDataRetentionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataRetention`](crate::operation::UpdateDataRetention)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataRetention,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDataRetentionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateDataRetention").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDataRetentionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDataRetentionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_data_retention(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataRetention::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataRetention",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataRetentionInput`](crate::input::UpdateDataRetentionInput)
    pub fn builder() -> crate::input::update_data_retention_input::Builder {
        crate::input::update_data_retention_input::Builder::default()
    }
}

/// See [`UpdateSignalingChannelInput`](crate::input::UpdateSignalingChannelInput)
pub mod update_signaling_channel_input {
    /// A builder for [`UpdateSignalingChannelInput`](crate::input::UpdateSignalingChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) single_master_configuration:
            std::option::Option<crate::model::SingleMasterConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
        /// update.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
        /// update.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The current version of the signaling channel that you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the signaling channel that you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of
        /// the signaling channel that you want to update. </p>
        pub fn single_master_configuration(
            mut self,
            input: crate::model::SingleMasterConfiguration,
        ) -> Self {
            self.single_master_configuration = Some(input);
            self
        }
        /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of
        /// the signaling channel that you want to update. </p>
        pub fn set_single_master_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterConfiguration>,
        ) -> Self {
            self.single_master_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSignalingChannelInput`](crate::input::UpdateSignalingChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSignalingChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSignalingChannelInput {
                channel_arn: self.channel_arn,
                current_version: self.current_version,
                single_master_configuration: self.single_master_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSignalingChannelInputOperationOutputAlias = crate::operation::UpdateSignalingChannel;
#[doc(hidden)]
pub type UpdateSignalingChannelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSignalingChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSignalingChannel`](crate::operation::UpdateSignalingChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSignalingChannel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSignalingChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateSignalingChannel").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSignalingChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSignalingChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_signaling_channel(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSignalingChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSignalingChannel",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSignalingChannelInput`](crate::input::UpdateSignalingChannelInput)
    pub fn builder() -> crate::input::update_signaling_channel_input::Builder {
        crate::input::update_signaling_channel_input::Builder::default()
    }
}

/// See [`UpdateStreamInput`](crate::input::UpdateStreamInput)
pub mod update_stream_input {
    /// A builder for [`UpdateStreamInput`](crate::input::UpdateStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) media_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stream whose metadata you want to update.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each
        /// account and region.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream whose metadata you want to update.</p>
        /// <p>The stream name is an identifier for the stream, and must be unique for each
        /// account and region.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The ARN of the stream whose metadata you want to update.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the stream whose metadata you want to update.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The version of the stream whose metadata you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The version of the stream whose metadata you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The name of the device that is writing to the stream. </p>
        /// <note>
        /// <p> In the current implementation, Kinesis Video Streams does not use this name.
        /// </p>
        /// </note>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device that is writing to the stream. </p>
        /// <note>
        /// <p> In the current implementation, Kinesis Video Streams does not use this name.
        /// </p>
        /// </note>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content
        /// that the stream contains to the consumers of the stream. For more information about
        /// media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
        /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
        /// Requirements</a>.</p>
        /// <p>To play video on the console, you must specify the correct video type. For example,
        /// if the video in the stream is H.264, specify <code>video/h264</code> as the
        /// <code>MediaType</code>.</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_type = Some(input.into());
            self
        }
        /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content
        /// that the stream contains to the consumers of the stream. For more information about
        /// media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
        /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
        /// Requirements</a>.</p>
        /// <p>To play video on the console, you must specify the correct video type. For example,
        /// if the video in the stream is H.264, specify <code>video/h264</code> as the
        /// <code>MediaType</code>.</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStreamInput`](crate::input::UpdateStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStreamInput {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                current_version: self.current_version,
                device_name: self.device_name,
                media_type: self.media_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStreamInputOperationOutputAlias = crate::operation::UpdateStream;
#[doc(hidden)]
pub type UpdateStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStreamInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStream`](crate::operation::UpdateStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateStream").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_stream(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStream",
            "kinesisvideo",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStreamInput`](crate::input::UpdateStreamInput)
    pub fn builder() -> crate::input::update_stream_input::Builder {
        crate::input::update_stream_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamInput {
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each
    /// account and region.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>The name of the device that is writing to the stream. </p>
    /// <note>
    /// <p> In the current implementation, Kinesis Video Streams does not use this name.
    /// </p>
    /// </note>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content
    /// that the stream contains to the consumers of the stream. For more information about
    /// media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
    /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
    /// Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example,
    /// if the video in the stream is H.264, specify <code>video/h264</code> as the
    /// <code>MediaType</code>.</p>
    pub media_type: std::option::Option<std::string::String>,
}
impl UpdateStreamInput {
    /// <p>The name of the stream whose metadata you want to update.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each
    /// account and region.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The ARN of the stream whose metadata you want to update.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The version of the stream whose metadata you want to update.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>The name of the device that is writing to the stream. </p>
    /// <note>
    /// <p> In the current implementation, Kinesis Video Streams does not use this name.
    /// </p>
    /// </note>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The stream's media type. Use <code>MediaType</code> to specify the type of content
    /// that the stream contains to the consumers of the stream. For more information about
    /// media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
    /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
    /// Requirements</a>.</p>
    /// <p>To play video on the console, you must specify the correct video type. For example,
    /// if the video in the stream is H.264, specify <code>video/h264</code> as the
    /// <code>MediaType</code>.</p>
    pub fn media_type(&self) -> std::option::Option<&str> {
        self.media_type.as_deref()
    }
}
impl std::fmt::Debug for UpdateStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamInput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("current_version", &self.current_version);
        formatter.field("device_name", &self.device_name);
        formatter.field("media_type", &self.media_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSignalingChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
    /// update.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the signaling channel that you want to update.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of
    /// the signaling channel that you want to update. </p>
    pub single_master_configuration: std::option::Option<crate::model::SingleMasterConfiguration>,
}
impl UpdateSignalingChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
    /// update.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The current version of the signaling channel that you want to update.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of
    /// the signaling channel that you want to update. </p>
    pub fn single_master_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SingleMasterConfiguration> {
        self.single_master_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateSignalingChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSignalingChannelInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("current_version", &self.current_version);
        formatter.field(
            "single_master_configuration",
            &self.single_master_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataRetentionInput {
    /// <p>The name of the stream whose retention period you want to change.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to
    /// change.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The version of the stream whose retention period you want to change. To get the
    /// version, call either the <code>DescribeStream</code> or the <code>ListStreams</code>
    /// API.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>Indicates whether you want to increase or decrease the retention period.</p>
    pub operation: std::option::Option<crate::model::UpdateDataRetentionOperation>,
    /// <p>The retention period, in hours. The value you specify replaces the current value.
    /// The maximum value for this parameter is 87600 (ten years).</p>
    pub data_retention_change_in_hours: std::option::Option<i32>,
}
impl UpdateDataRetentionInput {
    /// <p>The name of the stream whose retention period you want to change.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to
    /// change.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The version of the stream whose retention period you want to change. To get the
    /// version, call either the <code>DescribeStream</code> or the <code>ListStreams</code>
    /// API.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>Indicates whether you want to increase or decrease the retention period.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::UpdateDataRetentionOperation> {
        self.operation.as_ref()
    }
    /// <p>The retention period, in hours. The value you specify replaces the current value.
    /// The maximum value for this parameter is 87600 (ten years).</p>
    pub fn data_retention_change_in_hours(&self) -> std::option::Option<i32> {
        self.data_retention_change_in_hours
    }
}
impl std::fmt::Debug for UpdateDataRetentionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataRetentionInput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("current_version", &self.current_version);
        formatter.field("operation", &self.operation);
        formatter.field(
            "data_retention_change_in_hours",
            &self.data_retention_change_in_hours,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags
    /// from.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The name of the stream that you want to remove tags from.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to remove tags
    /// from.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name of the stream that you want to remove tags from.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub fn tag_key_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_key_list.as_deref()
    }
}
impl std::fmt::Debug for UntagStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagStreamInput");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("tag_key_list", &self.tag_key_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove
    /// tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove
    /// tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub fn tag_key_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_key_list.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_key_list", &self.tag_key_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags
    /// to.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The name of the stream that you want to add the tag or tags to.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
    /// (the value is optional).</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags
    /// to.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name of the stream that you want to add the tag or tags to.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
    /// (the value is optional).</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagStreamInput");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add
    /// tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags to associate with the specified signaling channel. Each tag is a
    /// key-value pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add
    /// tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags to associate with the specified signaling channel. Each tag is a
    /// key-value pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForStreamInput {
    /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code>
    /// call is truncated, the response includes a token that you can use in the next request to
    /// fetch the next batch of tags.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags
    /// for.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The name of the stream that you want to list tags for.</p>
    pub stream_name: std::option::Option<std::string::String>,
}
impl ListTagsForStreamInput {
    /// <p>If you specify this parameter and the result of a <code>ListTagsForStream</code>
    /// call is truncated, the response includes a token that you can use in the next request to
    /// fetch the next batch of tags.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to list tags
    /// for.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name of the stream that you want to list tags for.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForStreamInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_name", &self.stream_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code>
    /// call is truncated, the response includes a token that you can use in the next request to
    /// fetch the next batch of tags. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list
    /// tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>If you specify this parameter and the result of a <code>ListTagsForResource</code>
    /// call is truncated, the response includes a token that you can use in the next request to
    /// fetch the next batch of tags. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list
    /// tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamsInput {
    /// <p>The maximum number of streams to return in the response. The default is
    /// 10,000.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If you specify this parameter, when the result of a <code>ListStreams</code>
    /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
    /// get another batch of streams, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you
    /// can specify only the prefix of a stream name as a condition. </p>
    pub stream_name_condition: std::option::Option<crate::model::StreamNameCondition>,
}
impl ListStreamsInput {
    /// <p>The maximum number of streams to return in the response. The default is
    /// 10,000.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If you specify this parameter, when the result of a <code>ListStreams</code>
    /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
    /// get another batch of streams, provide this token in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Optional: Returns only streams that satisfy a specific condition. Currently, you
    /// can specify only the prefix of a stream name as a condition. </p>
    pub fn stream_name_condition(&self) -> std::option::Option<&crate::model::StreamNameCondition> {
        self.stream_name_condition.as_ref()
    }
}
impl std::fmt::Debug for ListStreamsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("stream_name_condition", &self.stream_name_condition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSignalingChannelsInput {
    /// <p>The maximum number of channels to return in the response. The default is 500.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code>
    /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
    /// get another batch of channels, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    pub channel_name_condition: std::option::Option<crate::model::ChannelNameCondition>,
}
impl ListSignalingChannelsInput {
    /// <p>The maximum number of channels to return in the response. The default is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code>
    /// operation is truncated, the call returns the <code>NextToken</code> in the response. To
    /// get another batch of channels, provide this token in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    pub fn channel_name_condition(
        &self,
    ) -> std::option::Option<&crate::model::ChannelNameCondition> {
        self.channel_name_condition.as_ref()
    }
}
impl std::fmt::Debug for ListSignalingChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSignalingChannelsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("channel_name_condition", &self.channel_name_condition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSignalingChannelEndpointInput {
    /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an
    /// endpoint.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code>
    /// channel type.</p>
    pub single_master_channel_endpoint_configuration:
        std::option::Option<crate::model::SingleMasterChannelEndpointConfiguration>,
}
impl GetSignalingChannelEndpointInput {
    /// <p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an
    /// endpoint.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code>
    /// channel type.</p>
    pub fn single_master_channel_endpoint_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SingleMasterChannelEndpointConfiguration> {
        self.single_master_channel_endpoint_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetSignalingChannelEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSignalingChannelEndpointInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field(
            "single_master_channel_endpoint_configuration",
            &self.single_master_channel_endpoint_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataEndpointInput {
    /// <p>The name of the stream that you want to get the endpoint for. You must specify
    /// either this parameter or a <code>StreamARN</code> in the request.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for.
    /// You must specify either this parameter or a <code>StreamName</code> in the request.
    /// </p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub api_name: std::option::Option<crate::model::ApiName>,
}
impl GetDataEndpointInput {
    /// <p>The name of the stream that you want to get the endpoint for. You must specify
    /// either this parameter or a <code>StreamARN</code> in the request.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for.
    /// You must specify either this parameter or a <code>StreamName</code> in the request.
    /// </p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name of the API action for which to get an endpoint.</p>
    pub fn api_name(&self) -> std::option::Option<&crate::model::ApiName> {
        self.api_name.as_ref()
    }
}
impl std::fmt::Debug for GetDataEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataEndpointInput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("api_name", &self.api_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStreamInput {
    /// <p>The name of the stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl DescribeStreamInput {
    /// <p>The name of the stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStreamInput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSignalingChannelInput {
    /// <p>The name of the signaling channel that you want to describe.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the signaling channel that you want to describe.</p>
    pub channel_arn: std::option::Option<std::string::String>,
}
impl DescribeSignalingChannelInput {
    /// <p>The name of the signaling channel that you want to describe.</p>
    pub fn channel_name(&self) -> std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>The ARN of the signaling channel that you want to describe.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSignalingChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSignalingChannelInput");
        formatter.field("channel_name", &self.channel_name);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>Optional: The version of the stream that you want to delete. </p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct
    /// stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the
    /// stream.</p>
    pub current_version: std::option::Option<std::string::String>,
}
impl DeleteStreamInput {
    /// <p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>Optional: The version of the stream that you want to delete. </p>
    /// <p>Specify the version as a safeguard to ensure that your are deleting the correct
    /// stream. To get the stream version, use the <code>DescribeStream</code> API.</p>
    /// <p>If not specified, only the <code>CreationTime</code> is checked before deleting the
    /// stream.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamInput");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("current_version", &self.current_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSignalingChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
    /// delete.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the signaling channel that you want to delete. You can obtain
    /// the current version by invoking the <code>DescribeSignalingChannel</code> or
    /// <code>ListSignalingChannels</code> API operations.</p>
    pub current_version: std::option::Option<std::string::String>,
}
impl DeleteSignalingChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the signaling channel that you want to
    /// delete.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The current version of the signaling channel that you want to delete. You can obtain
    /// the current version by invoking the <code>DescribeSignalingChannel</code> or
    /// <code>ListSignalingChannels</code> API operations.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteSignalingChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSignalingChannelInput");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("current_version", &self.current_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamInput {
    /// <p>The name of the device that is writing to the stream. </p>
    /// <note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this
    /// name.</p>
    /// </note>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each
    /// account and region.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The media type of the stream. Consumers of the stream can use this information when
    /// processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
    /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
    /// for guidelines.</p>
    ///
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in
    /// JSON).</p>
    pub media_type: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video
    /// Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key
    /// (<code>aws/kinesisvideo</code>) is used.</p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video
    /// Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume
    /// the fragments that remain in the service host buffer, which has a retention time limit
    /// of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the
    /// buffer when either limit is reached.</p>
    pub data_retention_in_hours: std::option::Option<i32>,
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
    /// (the value is optional).</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateStreamInput {
    /// <p>The name of the device that is writing to the stream. </p>
    /// <note>
    /// <p>In the current implementation, Kinesis Video Streams does not use this
    /// name.</p>
    /// </note>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>A name for the stream that you are creating.</p>
    /// <p>The stream name is an identifier for the stream, and must be unique for each
    /// account and region.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The media type of the stream. Consumers of the stream can use this information when
    /// processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media
    /// Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
    /// for guidelines.</p>
    ///
    /// <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p>
    /// <p>This parameter is optional; the default value is <code>null</code> (or empty in
    /// JSON).</p>
    pub fn media_type(&self) -> std::option::Option<&str> {
        self.media_type.as_deref()
    }
    /// <p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video
    /// Streams to use to encrypt stream data.</p>
    /// <p>If no key ID is specified, the default, Kinesis Video-managed key
    /// (<code>aws/kinesisvideo</code>) is used.</p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The number of hours that you want to retain the data in the stream. Kinesis Video
    /// Streams retains the data in a data store that is associated with the stream.</p>
    /// <p>The default value is 0, indicating that the stream does not persist data.</p>
    /// <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume
    /// the fragments that remain in the service host buffer, which has a retention time limit
    /// of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the
    /// buffer when either limit is reached.</p>
    pub fn data_retention_in_hours(&self) -> std::option::Option<i32> {
        self.data_retention_in_hours
    }
    /// <p>A list of tags to associate with the specified stream. Each tag is a key-value pair
    /// (the value is optional).</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamInput");
        formatter.field("device_name", &self.device_name);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("media_type", &self.media_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("data_retention_in_hours", &self.data_retention_in_hours);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSignalingChannelInput {
    /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS
    /// account and AWS Region.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>A type of the signaling channel that you are creating. Currently,
    /// <code>SINGLE_MASTER</code> is the only supported channel type. </p>
    pub channel_type: std::option::Option<crate::model::ChannelType>,
    /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel
    /// type. </p>
    pub single_master_configuration: std::option::Option<crate::model::SingleMasterConfiguration>,
    /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateSignalingChannelInput {
    /// <p>A name for the signaling channel that you are creating. It must be unique for each AWS
    /// account and AWS Region.</p>
    pub fn channel_name(&self) -> std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>A type of the signaling channel that you are creating. Currently,
    /// <code>SINGLE_MASTER</code> is the only supported channel type. </p>
    pub fn channel_type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.channel_type.as_ref()
    }
    /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel
    /// type. </p>
    pub fn single_master_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SingleMasterConfiguration> {
        self.single_master_configuration.as_ref()
    }
    /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateSignalingChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSignalingChannelInput");
        formatter.field("channel_name", &self.channel_name);
        formatter.field("channel_type", &self.channel_type);
        formatter.field(
            "single_master_configuration",
            &self.single_master_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
