// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateSignalingChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_signaling_channel`](crate::client::Client::create_signaling_channel).
///
/// See [`crate::client::fluent_builders::CreateSignalingChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSignalingChannel {
    _private: (),
}
impl CreateSignalingChannel {
    /// Creates a new builder-style object to manufacture [`CreateSignalingChannelInput`](crate::input::CreateSignalingChannelInput)
    pub fn builder() -> crate::input::create_signaling_channel_input::Builder {
        crate::input::create_signaling_channel_input::Builder::default()
    }
    /// Creates a new `CreateSignalingChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSignalingChannel {
    type Output = std::result::Result<
        crate::output::CreateSignalingChannelOutput,
        crate::error::CreateSignalingChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_signaling_channel_error(response)
        } else {
            crate::operation_deser::parse_create_signaling_channel_response(response)
        }
    }
}

/// Operation shape for `CreateStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stream`](crate::client::Client::create_stream).
///
/// See [`crate::client::fluent_builders::CreateStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStream {
    _private: (),
}
impl CreateStream {
    /// Creates a new builder-style object to manufacture [`CreateStreamInput`](crate::input::CreateStreamInput)
    pub fn builder() -> crate::input::create_stream_input::Builder {
        crate::input::create_stream_input::Builder::default()
    }
    /// Creates a new `CreateStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStream {
    type Output =
        std::result::Result<crate::output::CreateStreamOutput, crate::error::CreateStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stream_error(response)
        } else {
            crate::operation_deser::parse_create_stream_response(response)
        }
    }
}

/// Operation shape for `DeleteSignalingChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_signaling_channel`](crate::client::Client::delete_signaling_channel).
///
/// See [`crate::client::fluent_builders::DeleteSignalingChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSignalingChannel {
    _private: (),
}
impl DeleteSignalingChannel {
    /// Creates a new builder-style object to manufacture [`DeleteSignalingChannelInput`](crate::input::DeleteSignalingChannelInput)
    pub fn builder() -> crate::input::delete_signaling_channel_input::Builder {
        crate::input::delete_signaling_channel_input::Builder::default()
    }
    /// Creates a new `DeleteSignalingChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSignalingChannel {
    type Output = std::result::Result<
        crate::output::DeleteSignalingChannelOutput,
        crate::error::DeleteSignalingChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_signaling_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_signaling_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stream`](crate::client::Client::delete_stream).
///
/// See [`crate::client::fluent_builders::DeleteStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStream {
    _private: (),
}
impl DeleteStream {
    /// Creates a new builder-style object to manufacture [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    pub fn builder() -> crate::input::delete_stream_input::Builder {
        crate::input::delete_stream_input::Builder::default()
    }
    /// Creates a new `DeleteStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStream {
    type Output =
        std::result::Result<crate::output::DeleteStreamOutput, crate::error::DeleteStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stream_error(response)
        } else {
            crate::operation_deser::parse_delete_stream_response(response)
        }
    }
}

/// Operation shape for `DescribeImageGenerationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_generation_configuration`](crate::client::Client::describe_image_generation_configuration).
///
/// See [`crate::client::fluent_builders::DescribeImageGenerationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageGenerationConfiguration {
    _private: (),
}
impl DescribeImageGenerationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeImageGenerationConfigurationInput`](crate::input::DescribeImageGenerationConfigurationInput)
    pub fn builder() -> crate::input::describe_image_generation_configuration_input::Builder {
        crate::input::describe_image_generation_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeImageGenerationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageGenerationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeImageGenerationConfigurationOutput,
        crate::error::DescribeImageGenerationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_generation_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_image_generation_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notification_configuration`](crate::client::Client::describe_notification_configuration).
///
/// See [`crate::client::fluent_builders::DescribeNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotificationConfiguration {
    _private: (),
}
impl DescribeNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeNotificationConfigurationInput`](crate::input::DescribeNotificationConfigurationInput)
    pub fn builder() -> crate::input::describe_notification_configuration_input::Builder {
        crate::input::describe_notification_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeNotificationConfigurationOutput,
        crate::error::DescribeNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeSignalingChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_signaling_channel`](crate::client::Client::describe_signaling_channel).
///
/// See [`crate::client::fluent_builders::DescribeSignalingChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSignalingChannel {
    _private: (),
}
impl DescribeSignalingChannel {
    /// Creates a new builder-style object to manufacture [`DescribeSignalingChannelInput`](crate::input::DescribeSignalingChannelInput)
    pub fn builder() -> crate::input::describe_signaling_channel_input::Builder {
        crate::input::describe_signaling_channel_input::Builder::default()
    }
    /// Creates a new `DescribeSignalingChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSignalingChannel {
    type Output = std::result::Result<
        crate::output::DescribeSignalingChannelOutput,
        crate::error::DescribeSignalingChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_signaling_channel_error(response)
        } else {
            crate::operation_deser::parse_describe_signaling_channel_response(response)
        }
    }
}

/// Operation shape for `DescribeStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stream`](crate::client::Client::describe_stream).
///
/// See [`crate::client::fluent_builders::DescribeStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStream {
    _private: (),
}
impl DescribeStream {
    /// Creates a new builder-style object to manufacture [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    pub fn builder() -> crate::input::describe_stream_input::Builder {
        crate::input::describe_stream_input::Builder::default()
    }
    /// Creates a new `DescribeStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStream {
    type Output =
        std::result::Result<crate::output::DescribeStreamOutput, crate::error::DescribeStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stream_error(response)
        } else {
            crate::operation_deser::parse_describe_stream_response(response)
        }
    }
}

/// Operation shape for `GetDataEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_endpoint`](crate::client::Client::get_data_endpoint).
///
/// See [`crate::client::fluent_builders::GetDataEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataEndpoint {
    _private: (),
}
impl GetDataEndpoint {
    /// Creates a new builder-style object to manufacture [`GetDataEndpointInput`](crate::input::GetDataEndpointInput)
    pub fn builder() -> crate::input::get_data_endpoint_input::Builder {
        crate::input::get_data_endpoint_input::Builder::default()
    }
    /// Creates a new `GetDataEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataEndpoint {
    type Output = std::result::Result<
        crate::output::GetDataEndpointOutput,
        crate::error::GetDataEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_data_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetSignalingChannelEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_signaling_channel_endpoint`](crate::client::Client::get_signaling_channel_endpoint).
///
/// See [`crate::client::fluent_builders::GetSignalingChannelEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSignalingChannelEndpoint {
    _private: (),
}
impl GetSignalingChannelEndpoint {
    /// Creates a new builder-style object to manufacture [`GetSignalingChannelEndpointInput`](crate::input::GetSignalingChannelEndpointInput)
    pub fn builder() -> crate::input::get_signaling_channel_endpoint_input::Builder {
        crate::input::get_signaling_channel_endpoint_input::Builder::default()
    }
    /// Creates a new `GetSignalingChannelEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSignalingChannelEndpoint {
    type Output = std::result::Result<
        crate::output::GetSignalingChannelEndpointOutput,
        crate::error::GetSignalingChannelEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_signaling_channel_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_signaling_channel_endpoint_response(response)
        }
    }
}

/// Operation shape for `ListSignalingChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_signaling_channels`](crate::client::Client::list_signaling_channels).
///
/// See [`crate::client::fluent_builders::ListSignalingChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSignalingChannels {
    _private: (),
}
impl ListSignalingChannels {
    /// Creates a new builder-style object to manufacture [`ListSignalingChannelsInput`](crate::input::ListSignalingChannelsInput)
    pub fn builder() -> crate::input::list_signaling_channels_input::Builder {
        crate::input::list_signaling_channels_input::Builder::default()
    }
    /// Creates a new `ListSignalingChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSignalingChannels {
    type Output = std::result::Result<
        crate::output::ListSignalingChannelsOutput,
        crate::error::ListSignalingChannelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_signaling_channels_error(response)
        } else {
            crate::operation_deser::parse_list_signaling_channels_response(response)
        }
    }
}

/// Operation shape for `ListStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streams`](crate::client::Client::list_streams).
///
/// See [`crate::client::fluent_builders::ListStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreams {
    _private: (),
}
impl ListStreams {
    /// Creates a new builder-style object to manufacture [`ListStreamsInput`](crate::input::ListStreamsInput)
    pub fn builder() -> crate::input::list_streams_input::Builder {
        crate::input::list_streams_input::Builder::default()
    }
    /// Creates a new `ListStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreams {
    type Output =
        std::result::Result<crate::output::ListStreamsOutput, crate::error::ListStreamsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streams_error(response)
        } else {
            crate::operation_deser::parse_list_streams_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTagsForStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_stream`](crate::client::Client::list_tags_for_stream).
///
/// See [`crate::client::fluent_builders::ListTagsForStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForStream {
    _private: (),
}
impl ListTagsForStream {
    /// Creates a new builder-style object to manufacture [`ListTagsForStreamInput`](crate::input::ListTagsForStreamInput)
    pub fn builder() -> crate::input::list_tags_for_stream_input::Builder {
        crate::input::list_tags_for_stream_input::Builder::default()
    }
    /// Creates a new `ListTagsForStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForStream {
    type Output = std::result::Result<
        crate::output::ListTagsForStreamOutput,
        crate::error::ListTagsForStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_stream_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_stream_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TagStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_stream`](crate::client::Client::tag_stream).
///
/// See [`crate::client::fluent_builders::TagStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagStream {
    _private: (),
}
impl TagStream {
    /// Creates a new builder-style object to manufacture [`TagStreamInput`](crate::input::TagStreamInput)
    pub fn builder() -> crate::input::tag_stream_input::Builder {
        crate::input::tag_stream_input::Builder::default()
    }
    /// Creates a new `TagStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagStream {
    type Output = std::result::Result<crate::output::TagStreamOutput, crate::error::TagStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_stream_error(response)
        } else {
            crate::operation_deser::parse_tag_stream_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_stream`](crate::client::Client::untag_stream).
///
/// See [`crate::client::fluent_builders::UntagStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagStream {
    _private: (),
}
impl UntagStream {
    /// Creates a new builder-style object to manufacture [`UntagStreamInput`](crate::input::UntagStreamInput)
    pub fn builder() -> crate::input::untag_stream_input::Builder {
        crate::input::untag_stream_input::Builder::default()
    }
    /// Creates a new `UntagStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagStream {
    type Output =
        std::result::Result<crate::output::UntagStreamOutput, crate::error::UntagStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_stream_error(response)
        } else {
            crate::operation_deser::parse_untag_stream_response(response)
        }
    }
}

/// Operation shape for `UpdateDataRetention`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_retention`](crate::client::Client::update_data_retention).
///
/// See [`crate::client::fluent_builders::UpdateDataRetention`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataRetention {
    _private: (),
}
impl UpdateDataRetention {
    /// Creates a new builder-style object to manufacture [`UpdateDataRetentionInput`](crate::input::UpdateDataRetentionInput)
    pub fn builder() -> crate::input::update_data_retention_input::Builder {
        crate::input::update_data_retention_input::Builder::default()
    }
    /// Creates a new `UpdateDataRetention` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataRetention {
    type Output = std::result::Result<
        crate::output::UpdateDataRetentionOutput,
        crate::error::UpdateDataRetentionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_retention_error(response)
        } else {
            crate::operation_deser::parse_update_data_retention_response(response)
        }
    }
}

/// Operation shape for `UpdateImageGenerationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_image_generation_configuration`](crate::client::Client::update_image_generation_configuration).
///
/// See [`crate::client::fluent_builders::UpdateImageGenerationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateImageGenerationConfiguration {
    _private: (),
}
impl UpdateImageGenerationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateImageGenerationConfigurationInput`](crate::input::UpdateImageGenerationConfigurationInput)
    pub fn builder() -> crate::input::update_image_generation_configuration_input::Builder {
        crate::input::update_image_generation_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateImageGenerationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateImageGenerationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateImageGenerationConfigurationOutput,
        crate::error::UpdateImageGenerationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_image_generation_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_image_generation_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_notification_configuration`](crate::client::Client::update_notification_configuration).
///
/// See [`crate::client::fluent_builders::UpdateNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNotificationConfiguration {
    _private: (),
}
impl UpdateNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateNotificationConfigurationInput`](crate::input::UpdateNotificationConfigurationInput)
    pub fn builder() -> crate::input::update_notification_configuration_input::Builder {
        crate::input::update_notification_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateNotificationConfigurationOutput,
        crate::error::UpdateNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateSignalingChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_signaling_channel`](crate::client::Client::update_signaling_channel).
///
/// See [`crate::client::fluent_builders::UpdateSignalingChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSignalingChannel {
    _private: (),
}
impl UpdateSignalingChannel {
    /// Creates a new builder-style object to manufacture [`UpdateSignalingChannelInput`](crate::input::UpdateSignalingChannelInput)
    pub fn builder() -> crate::input::update_signaling_channel_input::Builder {
        crate::input::update_signaling_channel_input::Builder::default()
    }
    /// Creates a new `UpdateSignalingChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSignalingChannel {
    type Output = std::result::Result<
        crate::output::UpdateSignalingChannelOutput,
        crate::error::UpdateSignalingChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_signaling_channel_error(response)
        } else {
            crate::operation_deser::parse_update_signaling_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stream`](crate::client::Client::update_stream).
///
/// See [`crate::client::fluent_builders::UpdateStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStream {
    _private: (),
}
impl UpdateStream {
    /// Creates a new builder-style object to manufacture [`UpdateStreamInput`](crate::input::UpdateStreamInput)
    pub fn builder() -> crate::input::update_stream_input::Builder {
        crate::input::update_stream_input::Builder::default()
    }
    /// Creates a new `UpdateStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStream {
    type Output =
        std::result::Result<crate::output::UpdateStreamOutput, crate::error::UpdateStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stream_error(response)
        } else {
            crate::operation_deser::parse_update_stream_response(response)
        }
    }
}
