// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingleMasterConfiguration {
    /// <p>The period of time a signaling channel retains underlivered messages before they are
    /// discarded.</p>
    pub message_ttl_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for SingleMasterConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingleMasterConfiguration");
        formatter.field("message_ttl_seconds", &self.message_ttl_seconds);
        formatter.finish()
    }
}
/// See [`SingleMasterConfiguration`](crate::model::SingleMasterConfiguration)
pub mod single_master_configuration {
    /// A builder for [`SingleMasterConfiguration`](crate::model::SingleMasterConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_ttl_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The period of time a signaling channel retains underlivered messages before they are
        /// discarded.</p>
        pub fn message_ttl_seconds(mut self, input: i32) -> Self {
            self.message_ttl_seconds = Some(input);
            self
        }
        /// <p>The period of time a signaling channel retains underlivered messages before they are
        /// discarded.</p>
        pub fn set_message_ttl_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.message_ttl_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`SingleMasterConfiguration`](crate::model::SingleMasterConfiguration)
        pub fn build(self) -> crate::model::SingleMasterConfiguration {
            crate::model::SingleMasterConfiguration {
                message_ttl_seconds: self.message_ttl_seconds,
            }
        }
    }
}
impl SingleMasterConfiguration {
    /// Creates a new builder-style object to manufacture [`SingleMasterConfiguration`](crate::model::SingleMasterConfiguration)
    pub fn builder() -> crate::model::single_master_configuration::Builder {
        crate::model::single_master_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateDataRetentionOperation {
    #[allow(missing_docs)] // documentation missing in model
    DecreaseDataRetention,
    #[allow(missing_docs)] // documentation missing in model
    IncreaseDataRetention,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateDataRetentionOperation {
    fn from(s: &str) -> Self {
        match s {
            "DECREASE_DATA_RETENTION" => UpdateDataRetentionOperation::DecreaseDataRetention,
            "INCREASE_DATA_RETENTION" => UpdateDataRetentionOperation::IncreaseDataRetention,
            other => UpdateDataRetentionOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateDataRetentionOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateDataRetentionOperation::from(s))
    }
}
impl UpdateDataRetentionOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateDataRetentionOperation::DecreaseDataRetention => "DECREASE_DATA_RETENTION",
            UpdateDataRetentionOperation::IncreaseDataRetention => "INCREASE_DATA_RETENTION",
            UpdateDataRetentionOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DECREASE_DATA_RETENTION", "INCREASE_DATA_RETENTION"]
    }
}
impl AsRef<str> for UpdateDataRetentionOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key and value pair that is associated with the specified signaling channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag that is associated with the specified signaling channel.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag that is associated with the specified signaling channel.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag that is associated with the specified signaling channel.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag that is associated with the specified signaling channel.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag that is associated with the specified signaling channel.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag that is associated with the specified signaling channel.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An object describing a Kinesis video stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamInfo {
    /// <p>The name of the device that is associated with the stream.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The name of the stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The <code>MediaType</code> of the stream. </p>
    pub media_type: std::option::Option<std::string::String>,
    /// <p>The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video Streams
    /// uses to encrypt data on the stream.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The version of the stream.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The status of the stream.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>A time stamp that indicates when the stream was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>How long the stream retains data, in hours.</p>
    pub data_retention_in_hours: std::option::Option<i32>,
}
impl std::fmt::Debug for StreamInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamInfo");
        formatter.field("device_name", &self.device_name);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("media_type", &self.media_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("version", &self.version);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("data_retention_in_hours", &self.data_retention_in_hours);
        formatter.finish()
    }
}
/// See [`StreamInfo`](crate::model::StreamInfo)
pub mod stream_info {
    /// A builder for [`StreamInfo`](crate::model::StreamInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) media_type: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_retention_in_hours: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the device that is associated with the stream.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device that is associated with the stream.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The name of the stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The <code>MediaType</code> of the stream. </p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_type = Some(input.into());
            self
        }
        /// <p>The <code>MediaType</code> of the stream. </p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_type = input;
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video Streams
        /// uses to encrypt data on the stream.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video Streams
        /// uses to encrypt data on the stream.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The version of the stream.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the stream.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The status of the stream.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stream.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>A time stamp that indicates when the stream was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp that indicates when the stream was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>How long the stream retains data, in hours.</p>
        pub fn data_retention_in_hours(mut self, input: i32) -> Self {
            self.data_retention_in_hours = Some(input);
            self
        }
        /// <p>How long the stream retains data, in hours.</p>
        pub fn set_data_retention_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.data_retention_in_hours = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamInfo`](crate::model::StreamInfo)
        pub fn build(self) -> crate::model::StreamInfo {
            crate::model::StreamInfo {
                device_name: self.device_name,
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                media_type: self.media_type,
                kms_key_id: self.kms_key_id,
                version: self.version,
                status: self.status,
                creation_time: self.creation_time,
                data_retention_in_hours: self.data_retention_in_hours,
            }
        }
    }
}
impl StreamInfo {
    /// Creates a new builder-style object to manufacture [`StreamInfo`](crate::model::StreamInfo)
    pub fn builder() -> crate::model::stream_info::Builder {
        crate::model::stream_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => Status::Active,
            "CREATING" => Status::Creating,
            "DELETING" => Status::Deleting,
            "UPDATING" => Status::Updating,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Active => "ACTIVE",
            Status::Creating => "CREATING",
            Status::Deleting => "DELETING",
            Status::Updating => "UPDATING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the condition that streams must satisfy to be returned when you list
/// streams (see the <code>ListStreams</code> API). A condition has a comparison operation
/// and a value. Currently, you can specify only the <code>BEGINS_WITH</code> operator,
/// which finds streams whose names start with a given prefix. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamNameCondition {
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code>
    /// operator, which finds streams whose names start with a given prefix.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>A value to compare.</p>
    pub comparison_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StreamNameCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamNameCondition");
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("comparison_value", &self.comparison_value);
        formatter.finish()
    }
}
/// See [`StreamNameCondition`](crate::model::StreamNameCondition)
pub mod stream_name_condition {
    /// A builder for [`StreamNameCondition`](crate::model::StreamNameCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) comparison_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code>
        /// operator, which finds streams whose names start with a given prefix.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code>
        /// operator, which finds streams whose names start with a given prefix.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>A value to compare.</p>
        pub fn comparison_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.comparison_value = Some(input.into());
            self
        }
        /// <p>A value to compare.</p>
        pub fn set_comparison_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.comparison_value = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamNameCondition`](crate::model::StreamNameCondition)
        pub fn build(self) -> crate::model::StreamNameCondition {
            crate::model::StreamNameCondition {
                comparison_operator: self.comparison_operator,
                comparison_value: self.comparison_value,
            }
        }
    }
}
impl StreamNameCondition {
    /// Creates a new builder-style object to manufacture [`StreamNameCondition`](crate::model::StreamNameCondition)
    pub fn builder() -> crate::model::stream_name_condition::Builder {
        crate::model::stream_name_condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    BeginsWith,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "BEGINS_WITH" => ComparisonOperator::BeginsWith,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::BeginsWith => "BEGINS_WITH",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BEGINS_WITH"]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that encapsulates a signaling channel's metadata and properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelInfo {
    /// <p>The name of the signaling channel.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The type of the signaling channel.</p>
    pub channel_type: std::option::Option<crate::model::ChannelType>,
    /// <p>Current status of the signaling channel.</p>
    pub channel_status: std::option::Option<crate::model::Status>,
    /// <p>The time at which the signaling channel was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel
    /// type.</p>
    pub single_master_configuration: std::option::Option<crate::model::SingleMasterConfiguration>,
    /// <p>The current version of the signaling channel.</p>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelInfo");
        formatter.field("channel_name", &self.channel_name);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_type", &self.channel_type);
        formatter.field("channel_status", &self.channel_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "single_master_configuration",
            &self.single_master_configuration,
        );
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ChannelInfo`](crate::model::ChannelInfo)
pub mod channel_info {
    /// A builder for [`ChannelInfo`](crate::model::ChannelInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_type: std::option::Option<crate::model::ChannelType>,
        pub(crate) channel_status: std::option::Option<crate::model::Status>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) single_master_configuration:
            std::option::Option<crate::model::SingleMasterConfiguration>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the signaling channel.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>The name of the signaling channel.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The type of the signaling channel.</p>
        pub fn channel_type(mut self, input: crate::model::ChannelType) -> Self {
            self.channel_type = Some(input);
            self
        }
        /// <p>The type of the signaling channel.</p>
        pub fn set_channel_type(
            mut self,
            input: std::option::Option<crate::model::ChannelType>,
        ) -> Self {
            self.channel_type = input;
            self
        }
        /// <p>Current status of the signaling channel.</p>
        pub fn channel_status(mut self, input: crate::model::Status) -> Self {
            self.channel_status = Some(input);
            self
        }
        /// <p>Current status of the signaling channel.</p>
        pub fn set_channel_status(
            mut self,
            input: std::option::Option<crate::model::Status>,
        ) -> Self {
            self.channel_status = input;
            self
        }
        /// <p>The time at which the signaling channel was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the signaling channel was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel
        /// type.</p>
        pub fn single_master_configuration(
            mut self,
            input: crate::model::SingleMasterConfiguration,
        ) -> Self {
            self.single_master_configuration = Some(input);
            self
        }
        /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel
        /// type.</p>
        pub fn set_single_master_configuration(
            mut self,
            input: std::option::Option<crate::model::SingleMasterConfiguration>,
        ) -> Self {
            self.single_master_configuration = input;
            self
        }
        /// <p>The current version of the signaling channel.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The current version of the signaling channel.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelInfo`](crate::model::ChannelInfo)
        pub fn build(self) -> crate::model::ChannelInfo {
            crate::model::ChannelInfo {
                channel_name: self.channel_name,
                channel_arn: self.channel_arn,
                channel_type: self.channel_type,
                channel_status: self.channel_status,
                creation_time: self.creation_time,
                single_master_configuration: self.single_master_configuration,
                version: self.version,
            }
        }
    }
}
impl ChannelInfo {
    /// Creates a new builder-style object to manufacture [`ChannelInfo`](crate::model::ChannelInfo)
    pub fn builder() -> crate::model::channel_info::Builder {
        crate::model::channel_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelType {
    #[allow(missing_docs)] // documentation missing in model
    SingleMaster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelType {
    fn from(s: &str) -> Self {
        match s {
            "SINGLE_MASTER" => ChannelType::SingleMaster,
            other => ChannelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelType::from(s))
    }
}
impl ChannelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelType::SingleMaster => "SINGLE_MASTER",
            ChannelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SINGLE_MASTER"]
    }
}
impl AsRef<str> for ChannelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An optional input parameter for the <code>ListSignalingChannels</code> API. When this
/// parameter is specified while invoking <code>ListSignalingChannels</code>, the API
/// returns only the channels that satisfy a condition specified in
/// <code>ChannelNameCondition</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelNameCondition {
    /// <p>A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code>
    /// operator, which finds signaling channels whose names begin with a given prefix.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>A value to compare.</p>
    pub comparison_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelNameCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelNameCondition");
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("comparison_value", &self.comparison_value);
        formatter.finish()
    }
}
/// See [`ChannelNameCondition`](crate::model::ChannelNameCondition)
pub mod channel_name_condition {
    /// A builder for [`ChannelNameCondition`](crate::model::ChannelNameCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) comparison_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code>
        /// operator, which finds signaling channels whose names begin with a given prefix.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code>
        /// operator, which finds signaling channels whose names begin with a given prefix.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>A value to compare.</p>
        pub fn comparison_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.comparison_value = Some(input.into());
            self
        }
        /// <p>A value to compare.</p>
        pub fn set_comparison_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.comparison_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelNameCondition`](crate::model::ChannelNameCondition)
        pub fn build(self) -> crate::model::ChannelNameCondition {
            crate::model::ChannelNameCondition {
                comparison_operator: self.comparison_operator,
                comparison_value: self.comparison_value,
            }
        }
    }
}
impl ChannelNameCondition {
    /// Creates a new builder-style object to manufacture [`ChannelNameCondition`](crate::model::ChannelNameCondition)
    pub fn builder() -> crate::model::channel_name_condition::Builder {
        crate::model::channel_name_condition::Builder::default()
    }
}

/// <p>An object that describes the endpoint of the signaling channel returned by the
/// <code>GetSignalingChannelEndpoint</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceEndpointListItem {
    /// <p>The protocol of the signaling channel returned by the
    /// <code>GetSignalingChannelEndpoint</code> API.</p>
    pub protocol: std::option::Option<crate::model::ChannelProtocol>,
    /// <p>The endpoint of the signaling channel returned by the
    /// <code>GetSignalingChannelEndpoint</code> API.</p>
    pub resource_endpoint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceEndpointListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceEndpointListItem");
        formatter.field("protocol", &self.protocol);
        formatter.field("resource_endpoint", &self.resource_endpoint);
        formatter.finish()
    }
}
/// See [`ResourceEndpointListItem`](crate::model::ResourceEndpointListItem)
pub mod resource_endpoint_list_item {
    /// A builder for [`ResourceEndpointListItem`](crate::model::ResourceEndpointListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::ChannelProtocol>,
        pub(crate) resource_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The protocol of the signaling channel returned by the
        /// <code>GetSignalingChannelEndpoint</code> API.</p>
        pub fn protocol(mut self, input: crate::model::ChannelProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol of the signaling channel returned by the
        /// <code>GetSignalingChannelEndpoint</code> API.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ChannelProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The endpoint of the signaling channel returned by the
        /// <code>GetSignalingChannelEndpoint</code> API.</p>
        pub fn resource_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the signaling channel returned by the
        /// <code>GetSignalingChannelEndpoint</code> API.</p>
        pub fn set_resource_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceEndpointListItem`](crate::model::ResourceEndpointListItem)
        pub fn build(self) -> crate::model::ResourceEndpointListItem {
            crate::model::ResourceEndpointListItem {
                protocol: self.protocol,
                resource_endpoint: self.resource_endpoint,
            }
        }
    }
}
impl ResourceEndpointListItem {
    /// Creates a new builder-style object to manufacture [`ResourceEndpointListItem`](crate::model::ResourceEndpointListItem)
    pub fn builder() -> crate::model::resource_endpoint_list_item::Builder {
        crate::model::resource_endpoint_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Https,
    #[allow(missing_docs)] // documentation missing in model
    Wss,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTPS" => ChannelProtocol::Https,
            "WSS" => ChannelProtocol::Wss,
            other => ChannelProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelProtocol::from(s))
    }
}
impl ChannelProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelProtocol::Https => "HTTPS",
            ChannelProtocol::Wss => "WSS",
            ChannelProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTPS", "WSS"]
    }
}
impl AsRef<str> for ChannelProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains the endpoint configuration for the <code>SINGLE_MASTER</code>
/// channel type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SingleMasterChannelEndpointConfiguration {
    /// <p>This property is used to determine the nature of communication over this
    /// <code>SINGLE_MASTER</code> signaling channel. If <code>WSS</code> is specified, this
    /// API returns a websocket endpoint. If <code>HTTPS</code> is specified, this API returns
    /// an <code>HTTPS</code> endpoint.</p>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::ChannelProtocol>>,
    /// <p>This property is used to determine messaging permissions in this
    /// <code>SINGLE_MASTER</code> signaling channel. If <code>MASTER</code> is specified,
    /// this API returns an endpoint that a client can use to receive offers from and send
    /// answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is
    /// specified, this API returns an endpoint that a client can use only to send offers to
    /// another <code>MASTER</code> client on this signaling channel. </p>
    pub role: std::option::Option<crate::model::ChannelRole>,
}
impl std::fmt::Debug for SingleMasterChannelEndpointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SingleMasterChannelEndpointConfiguration");
        formatter.field("protocols", &self.protocols);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`SingleMasterChannelEndpointConfiguration`](crate::model::SingleMasterChannelEndpointConfiguration)
pub mod single_master_channel_endpoint_configuration {
    /// A builder for [`SingleMasterChannelEndpointConfiguration`](crate::model::SingleMasterChannelEndpointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::ChannelProtocol>>,
        pub(crate) role: std::option::Option<crate::model::ChannelRole>,
    }
    impl Builder {
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>This property is used to determine the nature of communication over this
        /// <code>SINGLE_MASTER</code> signaling channel. If <code>WSS</code> is specified, this
        /// API returns a websocket endpoint. If <code>HTTPS</code> is specified, this API returns
        /// an <code>HTTPS</code> endpoint.</p>
        pub fn protocols(mut self, input: impl Into<crate::model::ChannelProtocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>This property is used to determine the nature of communication over this
        /// <code>SINGLE_MASTER</code> signaling channel. If <code>WSS</code> is specified, this
        /// API returns a websocket endpoint. If <code>HTTPS</code> is specified, this API returns
        /// an <code>HTTPS</code> endpoint.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelProtocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>This property is used to determine messaging permissions in this
        /// <code>SINGLE_MASTER</code> signaling channel. If <code>MASTER</code> is specified,
        /// this API returns an endpoint that a client can use to receive offers from and send
        /// answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is
        /// specified, this API returns an endpoint that a client can use only to send offers to
        /// another <code>MASTER</code> client on this signaling channel. </p>
        pub fn role(mut self, input: crate::model::ChannelRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>This property is used to determine messaging permissions in this
        /// <code>SINGLE_MASTER</code> signaling channel. If <code>MASTER</code> is specified,
        /// this API returns an endpoint that a client can use to receive offers from and send
        /// answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is
        /// specified, this API returns an endpoint that a client can use only to send offers to
        /// another <code>MASTER</code> client on this signaling channel. </p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::ChannelRole>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`SingleMasterChannelEndpointConfiguration`](crate::model::SingleMasterChannelEndpointConfiguration)
        pub fn build(self) -> crate::model::SingleMasterChannelEndpointConfiguration {
            crate::model::SingleMasterChannelEndpointConfiguration {
                protocols: self.protocols,
                role: self.role,
            }
        }
    }
}
impl SingleMasterChannelEndpointConfiguration {
    /// Creates a new builder-style object to manufacture [`SingleMasterChannelEndpointConfiguration`](crate::model::SingleMasterChannelEndpointConfiguration)
    pub fn builder() -> crate::model::single_master_channel_endpoint_configuration::Builder {
        crate::model::single_master_channel_endpoint_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelRole {
    #[allow(missing_docs)] // documentation missing in model
    Master,
    #[allow(missing_docs)] // documentation missing in model
    Viewer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelRole {
    fn from(s: &str) -> Self {
        match s {
            "MASTER" => ChannelRole::Master,
            "VIEWER" => ChannelRole::Viewer,
            other => ChannelRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelRole::from(s))
    }
}
impl ChannelRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelRole::Master => "MASTER",
            ChannelRole::Viewer => "VIEWER",
            ChannelRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MASTER", "VIEWER"]
    }
}
impl AsRef<str> for ChannelRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiName {
    #[allow(missing_docs)] // documentation missing in model
    GetClip,
    #[allow(missing_docs)] // documentation missing in model
    GetDashStreamingSessionUrl,
    #[allow(missing_docs)] // documentation missing in model
    GetHlsStreamingSessionUrl,
    #[allow(missing_docs)] // documentation missing in model
    GetMedia,
    #[allow(missing_docs)] // documentation missing in model
    GetMediaForFragmentList,
    #[allow(missing_docs)] // documentation missing in model
    ListFragments,
    #[allow(missing_docs)] // documentation missing in model
    PutMedia,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiName {
    fn from(s: &str) -> Self {
        match s {
            "GET_CLIP" => ApiName::GetClip,
            "GET_DASH_STREAMING_SESSION_URL" => ApiName::GetDashStreamingSessionUrl,
            "GET_HLS_STREAMING_SESSION_URL" => ApiName::GetHlsStreamingSessionUrl,
            "GET_MEDIA" => ApiName::GetMedia,
            "GET_MEDIA_FOR_FRAGMENT_LIST" => ApiName::GetMediaForFragmentList,
            "LIST_FRAGMENTS" => ApiName::ListFragments,
            "PUT_MEDIA" => ApiName::PutMedia,
            other => ApiName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiName::from(s))
    }
}
impl ApiName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiName::GetClip => "GET_CLIP",
            ApiName::GetDashStreamingSessionUrl => "GET_DASH_STREAMING_SESSION_URL",
            ApiName::GetHlsStreamingSessionUrl => "GET_HLS_STREAMING_SESSION_URL",
            ApiName::GetMedia => "GET_MEDIA",
            ApiName::GetMediaForFragmentList => "GET_MEDIA_FOR_FRAGMENT_LIST",
            ApiName::ListFragments => "LIST_FRAGMENTS",
            ApiName::PutMedia => "PUT_MEDIA",
            ApiName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GET_CLIP",
            "GET_DASH_STREAMING_SESSION_URL",
            "GET_HLS_STREAMING_SESSION_URL",
            "GET_MEDIA",
            "GET_MEDIA_FOR_FRAGMENT_LIST",
            "LIST_FRAGMENTS",
            "PUT_MEDIA",
        ]
    }
}
impl AsRef<str> for ApiName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
