// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Kinesis Analytics
///
/// Client for invoking operations on Amazon Kinesis Analytics. Each operation on Amazon Kinesis Analytics is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_kinesisanalytics::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_kinesisanalytics::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_kinesisanalytics::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddApplicationCloudWatchLoggingOption`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::set_application_name): <p>The Kinesis Analytics application name.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::set_current_application_version_id): <p>The version ID of the Kinesis Analytics application.</p>
    ///   - [`cloud_watch_logging_option(CloudWatchLoggingOption)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::cloud_watch_logging_option) / [`set_cloud_watch_logging_option(Option<CloudWatchLoggingOption>)`](crate::client::fluent_builders::AddApplicationCloudWatchLoggingOption::set_cloud_watch_logging_option): <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.</p>
    /// - On success, responds with [`AddApplicationCloudWatchLoggingOptionOutput`](crate::output::AddApplicationCloudWatchLoggingOptionOutput)

    /// - On failure, responds with [`SdkError<AddApplicationCloudWatchLoggingOptionError>`](crate::error::AddApplicationCloudWatchLoggingOptionError)
    pub fn add_application_cloud_watch_logging_option(
        &self,
    ) -> fluent_builders::AddApplicationCloudWatchLoggingOption {
        fluent_builders::AddApplicationCloudWatchLoggingOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddApplicationInput`](crate::client::fluent_builders::AddApplicationInput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::AddApplicationInput::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::AddApplicationInput::set_application_name): <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::AddApplicationInput::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::AddApplicationInput::set_current_application_version_id): <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p>
    ///   - [`input(Input)`](crate::client::fluent_builders::AddApplicationInput::input) / [`set_input(Option<Input>)`](crate::client::fluent_builders::AddApplicationInput::set_input): <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
    /// - On success, responds with [`AddApplicationInputOutput`](crate::output::AddApplicationInputOutput)

    /// - On failure, responds with [`SdkError<AddApplicationInputError>`](crate::error::AddApplicationInputError)
    pub fn add_application_input(&self) -> fluent_builders::AddApplicationInput {
        fluent_builders::AddApplicationInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddApplicationInputProcessingConfiguration`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::set_application_name): <p>Name of the application to which you want to add the input processing configuration.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::set_current_application_version_id): <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
    ///   - [`input_id(impl Into<String>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::input_id) / [`set_input_id(Option<String>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::set_input_id): <p>The ID of the input configuration to add the input processing configuration to. You can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    ///   - [`input_processing_configuration(InputProcessingConfiguration)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::input_processing_configuration) / [`set_input_processing_configuration(Option<InputProcessingConfiguration>)`](crate::client::fluent_builders::AddApplicationInputProcessingConfiguration::set_input_processing_configuration): <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
    /// - On success, responds with [`AddApplicationInputProcessingConfigurationOutput`](crate::output::AddApplicationInputProcessingConfigurationOutput)

    /// - On failure, responds with [`SdkError<AddApplicationInputProcessingConfigurationError>`](crate::error::AddApplicationInputProcessingConfigurationError)
    pub fn add_application_input_processing_configuration(
        &self,
    ) -> fluent_builders::AddApplicationInputProcessingConfiguration {
        fluent_builders::AddApplicationInputProcessingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddApplicationOutput`](crate::client::fluent_builders::AddApplicationOutput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::AddApplicationOutput::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::AddApplicationOutput::set_application_name): <p>Name of the application to which you want to add the output configuration.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::AddApplicationOutput::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::AddApplicationOutput::set_current_application_version_id): <p>Version of the application to which you want to add the output configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
    ///   - [`output(Output)`](crate::client::fluent_builders::AddApplicationOutput::output) / [`set_output(Option<Output>)`](crate::client::fluent_builders::AddApplicationOutput::set_output): <p>An array of objects, each describing one output configuration. In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.</p>
    /// - On success, responds with [`AddApplicationOutputOutput`](crate::output::AddApplicationOutputOutput)

    /// - On failure, responds with [`SdkError<AddApplicationOutputError>`](crate::error::AddApplicationOutputError)
    pub fn add_application_output(&self) -> fluent_builders::AddApplicationOutput {
        fluent_builders::AddApplicationOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddApplicationReferenceDataSource`](crate::client::fluent_builders::AddApplicationReferenceDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::set_application_name): <p>Name of an existing application.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::set_current_application_version_id): <p>Version of the application for which you are adding the reference data source. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
    ///   - [`reference_data_source(ReferenceDataSource)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::reference_data_source) / [`set_reference_data_source(Option<ReferenceDataSource>)`](crate::client::fluent_builders::AddApplicationReferenceDataSource::set_reference_data_source): <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
    /// - On success, responds with [`AddApplicationReferenceDataSourceOutput`](crate::output::AddApplicationReferenceDataSourceOutput)

    /// - On failure, responds with [`SdkError<AddApplicationReferenceDataSourceError>`](crate::error::AddApplicationReferenceDataSourceError)
    pub fn add_application_reference_data_source(
        &self,
    ) -> fluent_builders::AddApplicationReferenceDataSource {
        fluent_builders::AddApplicationReferenceDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_application_name): <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
    ///   - [`application_description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::application_description) / [`set_application_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_application_description): <p>Summary description of the application.</p>
    ///   - [`inputs(Vec<Input>)`](crate::client::fluent_builders::CreateApplication::inputs) / [`set_inputs(Option<Vec<Input>>)`](crate::client::fluent_builders::CreateApplication::set_inputs): <p>Use this parameter to configure the application input.</p>  <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>  <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>  <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
    ///   - [`outputs(Vec<Output>)`](crate::client::fluent_builders::CreateApplication::outputs) / [`set_outputs(Option<Vec<Output>>)`](crate::client::fluent_builders::CreateApplication::set_outputs): <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>  <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any combination of the three.</p>  <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.</p>  <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
    ///   - [`cloud_watch_logging_options(Vec<CloudWatchLoggingOption>)`](crate::client::fluent_builders::CreateApplication::cloud_watch_logging_options) / [`set_cloud_watch_logging_options(Option<Vec<CloudWatchLoggingOption>>)`](crate::client::fluent_builders::CreateApplication::set_cloud_watch_logging_options): <p>Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>
    ///   - [`application_code(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::application_code) / [`set_application_code(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_application_code): <p>One or more SQL statements that read input data, transform it, and generate output. For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>. </p>  <p>You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.</p>  <p>Note that the application code must create the streams with names specified in the <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code must create these streams. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application_summary(Option<ApplicationSummary>)`](crate::output::CreateApplicationOutput::application_summary): <p>In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with a summary of the application it created, including the application Amazon Resource Name (ARN), name, and status.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_application_name): <p>Name of the Amazon Kinesis Analytics application to delete.</p>
    ///   - [`create_timestamp(DateTime)`](crate::client::fluent_builders::DeleteApplication::create_timestamp) / [`set_create_timestamp(Option<DateTime>)`](crate::client::fluent_builders::DeleteApplication::set_create_timestamp): <p> You can use the <code>DescribeApplication</code> operation to get this value. </p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplicationCloudWatchLoggingOption`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::set_application_name): <p>The Kinesis Analytics application name.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::set_current_application_version_id): <p>The version ID of the Kinesis Analytics application.</p>
    ///   - [`cloud_watch_logging_option_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::cloud_watch_logging_option_id) / [`set_cloud_watch_logging_option_id(Option<String>)`](crate::client::fluent_builders::DeleteApplicationCloudWatchLoggingOption::set_cloud_watch_logging_option_id): <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
    /// - On success, responds with [`DeleteApplicationCloudWatchLoggingOptionOutput`](crate::output::DeleteApplicationCloudWatchLoggingOptionOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationCloudWatchLoggingOptionError>`](crate::error::DeleteApplicationCloudWatchLoggingOptionError)
    pub fn delete_application_cloud_watch_logging_option(
        &self,
    ) -> fluent_builders::DeleteApplicationCloudWatchLoggingOption {
        fluent_builders::DeleteApplicationCloudWatchLoggingOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplicationInputProcessingConfiguration`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::set_application_name): <p>The Kinesis Analytics application name.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::set_current_application_version_id): <p>The version ID of the Kinesis Analytics application.</p>
    ///   - [`input_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::input_id) / [`set_input_id(Option<String>)`](crate::client::fluent_builders::DeleteApplicationInputProcessingConfiguration::set_input_id): <p>The ID of the input configuration from which to delete the input processing configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    /// - On success, responds with [`DeleteApplicationInputProcessingConfigurationOutput`](crate::output::DeleteApplicationInputProcessingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationInputProcessingConfigurationError>`](crate::error::DeleteApplicationInputProcessingConfigurationError)
    pub fn delete_application_input_processing_configuration(
        &self,
    ) -> fluent_builders::DeleteApplicationInputProcessingConfiguration {
        fluent_builders::DeleteApplicationInputProcessingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplicationOutput`](crate::client::fluent_builders::DeleteApplicationOutput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationOutput::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplicationOutput::set_application_name): <p>Amazon Kinesis Analytics application name.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::DeleteApplicationOutput::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::DeleteApplicationOutput::set_current_application_version_id): <p>Amazon Kinesis Analytics application version. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
    ///   - [`output_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationOutput::output_id) / [`set_output_id(Option<String>)`](crate::client::fluent_builders::DeleteApplicationOutput::set_output_id): <p>The ID of the configuration to delete. Each output configuration that is added to the application, either when the application is created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from the application configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific <code>OutputId</code>. </p>
    /// - On success, responds with [`DeleteApplicationOutputOutput`](crate::output::DeleteApplicationOutputOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationOutputError>`](crate::error::DeleteApplicationOutputError)
    pub fn delete_application_output(&self) -> fluent_builders::DeleteApplicationOutput {
        fluent_builders::DeleteApplicationOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplicationReferenceDataSource`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::set_application_name): <p>Name of an existing application.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::set_current_application_version_id): <p>Version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
    ///   - [`reference_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::reference_id) / [`set_reference_id(Option<String>)`](crate::client::fluent_builders::DeleteApplicationReferenceDataSource::set_reference_id): <p>ID of the reference data source. When you add a reference data source to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID. </p>
    /// - On success, responds with [`DeleteApplicationReferenceDataSourceOutput`](crate::output::DeleteApplicationReferenceDataSourceOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationReferenceDataSourceError>`](crate::error::DeleteApplicationReferenceDataSourceError)
    pub fn delete_application_reference_data_source(
        &self,
    ) -> fluent_builders::DeleteApplicationReferenceDataSource {
        fluent_builders::DeleteApplicationReferenceDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplication`](crate::client::fluent_builders::DescribeApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::DescribeApplication::set_application_name): <p>Name of the application.</p>
    /// - On success, responds with [`DescribeApplicationOutput`](crate::output::DescribeApplicationOutput) with field(s):
    ///   - [`application_detail(Option<ApplicationDetail>)`](crate::output::DescribeApplicationOutput::application_detail): <p>Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest version, and input and output configuration details.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationError>`](crate::error::DescribeApplicationError)
    pub fn describe_application(&self) -> fluent_builders::DescribeApplication {
        fluent_builders::DescribeApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DiscoverInputSchema`](crate::client::fluent_builders::DiscoverInputSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DiscoverInputSchema::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DiscoverInputSchema::set_resource_arn): <p>Amazon Resource Name (ARN) of the streaming source.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::DiscoverInputSchema::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::DiscoverInputSchema::set_role_arn): <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
    ///   - [`input_starting_position_configuration(InputStartingPositionConfiguration)`](crate::client::fluent_builders::DiscoverInputSchema::input_starting_position_configuration) / [`set_input_starting_position_configuration(Option<InputStartingPositionConfiguration>)`](crate::client::fluent_builders::DiscoverInputSchema::set_input_starting_position_configuration): <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
    ///   - [`s3_configuration(S3Configuration)`](crate::client::fluent_builders::DiscoverInputSchema::s3_configuration) / [`set_s3_configuration(Option<S3Configuration>)`](crate::client::fluent_builders::DiscoverInputSchema::set_s3_configuration): <p>Specify this parameter to discover a schema from data in an Amazon S3 object.</p>
    ///   - [`input_processing_configuration(InputProcessingConfiguration)`](crate::client::fluent_builders::DiscoverInputSchema::input_processing_configuration) / [`set_input_processing_configuration(Option<InputProcessingConfiguration>)`](crate::client::fluent_builders::DiscoverInputSchema::set_input_processing_configuration): <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
    /// - On success, responds with [`DiscoverInputSchemaOutput`](crate::output::DiscoverInputSchemaOutput) with field(s):
    ///   - [`input_schema(Option<SourceSchema>)`](crate::output::DiscoverInputSchemaOutput::input_schema): <p>Schema inferred from the streaming source. It identifies the format of the data in the streaming source and how each data element maps to corresponding columns in the in-application stream that you can create.</p>
    ///   - [`parsed_input_records(Option<Vec<Vec<String>>>)`](crate::output::DiscoverInputSchemaOutput::parsed_input_records): <p>An array of elements, where each element corresponds to a row in a stream record (a stream record can have more than one row).</p>
    ///   - [`processed_input_records(Option<Vec<String>>)`](crate::output::DiscoverInputSchemaOutput::processed_input_records): <p>Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code> parameter.</p>
    ///   - [`raw_input_records(Option<Vec<String>>)`](crate::output::DiscoverInputSchemaOutput::raw_input_records): <p>Raw stream data that was sampled to infer the schema.</p>
    /// - On failure, responds with [`SdkError<DiscoverInputSchemaError>`](crate::error::DiscoverInputSchemaError)
    pub fn discover_input_schema(&self) -> fluent_builders::DiscoverInputSchema {
        fluent_builders::DiscoverInputSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApplications`](crate::client::fluent_builders::ListApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListApplications::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListApplications::set_limit): <p>Maximum number of applications to list.</p>
    ///   - [`exclusive_start_application_name(impl Into<String>)`](crate::client::fluent_builders::ListApplications::exclusive_start_application_name) / [`set_exclusive_start_application_name(Option<String>)`](crate::client::fluent_builders::ListApplications::set_exclusive_start_application_name): <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
    /// - On success, responds with [`ListApplicationsOutput`](crate::output::ListApplicationsOutput) with field(s):
    ///   - [`application_summaries(Option<Vec<ApplicationSummary>>)`](crate::output::ListApplicationsOutput::application_summaries): <p>List of <code>ApplicationSummary</code> objects. </p>
    ///   - [`has_more_applications(Option<bool>)`](crate::output::ListApplicationsOutput::has_more_applications): <p>Returns true if there are more applications to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListApplicationsError>`](crate::error::ListApplicationsError)
    pub fn list_applications(&self) -> fluent_builders::ListApplications {
        fluent_builders::ListApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the application for which to retrieve tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The key-value tags assigned to the application.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartApplication`](crate::client::fluent_builders::StartApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::StartApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::StartApplication::set_application_name): <p>Name of the application.</p>
    ///   - [`input_configurations(Vec<InputConfiguration>)`](crate::client::fluent_builders::StartApplication::input_configurations) / [`set_input_configurations(Option<Vec<InputConfiguration>>)`](crate::client::fluent_builders::StartApplication::set_input_configurations): <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
    /// - On success, responds with [`StartApplicationOutput`](crate::output::StartApplicationOutput)

    /// - On failure, responds with [`SdkError<StartApplicationError>`](crate::error::StartApplicationError)
    pub fn start_application(&self) -> fluent_builders::StartApplication {
        fluent_builders::StartApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopApplication`](crate::client::fluent_builders::StopApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::StopApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::StopApplication::set_application_name): <p>Name of the running application to stop.</p>
    /// - On success, responds with [`StopApplicationOutput`](crate::output::StopApplicationOutput)

    /// - On failure, responds with [`SdkError<StopApplicationError>`](crate::error::StopApplicationError)
    pub fn stop_application(&self) -> fluent_builders::StopApplication {
        fluent_builders::StopApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the application to assign the tags.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value tags to assign to the application.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of keys of tags to remove from the specified application.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`application_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::application_name) / [`set_application_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_application_name): <p>Name of the Amazon Kinesis Analytics application to update.</p>
    ///   - [`current_application_version_id(i64)`](crate::client::fluent_builders::UpdateApplication::current_application_version_id) / [`set_current_application_version_id(Option<i64>)`](crate::client::fluent_builders::UpdateApplication::set_current_application_version_id): <p>The current application version ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
    ///   - [`application_update(ApplicationUpdate)`](crate::client::fluent_builders::UpdateApplication::application_update) / [`set_application_update(Option<ApplicationUpdate>)`](crate::client::fluent_builders::UpdateApplication::set_application_update): <p>Describes application updates.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput)

    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddApplicationCloudWatchLoggingOption`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Adds a CloudWatch log stream to monitor application configuration errors. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddApplicationCloudWatchLoggingOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_application_cloud_watch_logging_option_input::Builder,
    }
    impl AddApplicationCloudWatchLoggingOption {
        /// Creates a new `AddApplicationCloudWatchLoggingOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddApplicationCloudWatchLoggingOptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AddApplicationCloudWatchLoggingOptionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn cloud_watch_logging_option(
            mut self,
            input: crate::model::CloudWatchLoggingOption,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logging_option(input);
            self
        }
        /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn set_cloud_watch_logging_option(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOption>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logging_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddApplicationInput`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p> Adds a streaming source to your Amazon Kinesis application. For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>
    /// <p>You can add a streaming source either when you create an application or you can use this operation to add a streaming source after you create an application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_CreateApplication.html">CreateApplication</a>.</p>
    /// <p>Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version. </p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationInput</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddApplicationInput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_application_input_input::Builder,
    }
    impl AddApplicationInput {
        /// Creates a new `AddApplicationInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddApplicationInputOutput,
            aws_smithy_http::result::SdkError<crate::error::AddApplicationInputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.inner = self.inner.input(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddApplicationInputProcessingConfiguration`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Adds an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to an application. An input processor preprocesses records on the input stream before the application's SQL code executes. Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddApplicationInputProcessingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_application_input_processing_configuration_input::Builder,
    }
    impl AddApplicationInputProcessingConfiguration {
        /// Creates a new `AddApplicationInputProcessingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddApplicationInputProcessingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AddApplicationInputProcessingConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application to which you want to add the input processing configuration.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the application to which you want to add the input processing configuration.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The ID of the input configuration to add the input processing configuration to. You can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(input.into());
            self
        }
        /// <p>The ID of the input configuration to add the input processing configuration to. You can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
        pub fn input_processing_configuration(
            mut self,
            input: crate::model::InputProcessingConfiguration,
        ) -> Self {
            self.inner = self.inner.input_processing_configuration(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
        pub fn set_input_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_input_processing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddApplicationOutput`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Adds an external destination to your Amazon Kinesis Analytics application.</p>
    /// <p>If you want Amazon Kinesis Analytics to deliver data from an in-application stream within your application to an external destination (such as an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.</p>
    /// <p> You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Understanding Application Output (Destination)</a>. </p>
    /// <p> Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p>
    /// <p>For the limits on the number of application inputs and outputs you can configure, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationOutput</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddApplicationOutput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_application_output_input::Builder,
    }
    impl AddApplicationOutput {
        /// Creates a new `AddApplicationOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddApplicationOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::AddApplicationOutputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application to which you want to add the output configuration.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the application to which you want to add the output configuration.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Version of the application to which you want to add the output configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Version of the application to which you want to add the output configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>An array of objects, each describing one output configuration. In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.</p>
        pub fn output(mut self, input: crate::model::Output) -> Self {
            self.inner = self.inner.output(input);
            self
        }
        /// <p>An array of objects, each describing one output configuration. In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.</p>
        pub fn set_output(mut self, input: std::option::Option<crate::model::Output>) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddApplicationReferenceDataSource`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Adds a reference data source to an existing application.</p>
    /// <p>Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.</p>
    /// <p> For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. For the limits on data sources you can add to your application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>. </p>
    /// <p> This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationOutput</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddApplicationReferenceDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_application_reference_data_source_input::Builder,
    }
    impl AddApplicationReferenceDataSource {
        /// Creates a new `AddApplicationReferenceDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddApplicationReferenceDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddApplicationReferenceDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of an existing application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of an existing application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Version of the application for which you are adding the reference data source. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Version of the application for which you are adding the reference data source. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
        pub fn reference_data_source(mut self, input: crate::model::ReferenceDataSource) -> Self {
            self.inner = self.inner.reference_data_source(input);
            self
        }
        /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
        pub fn set_reference_data_source(
            mut self,
            input: std::option::Option<crate::model::ReferenceDataSource>,
        ) -> Self {
            self.inner = self.inner.set_reference_data_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p> Creates an Amazon Kinesis Analytics application. You can configure each application with one streaming source as input, application code to process the input, and up to three destinations where you want Amazon Kinesis Analytics to write the output data from your application. For an overview, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html">How it Works</a>. </p>
    /// <p>In the input configuration, you map the streaming source to an in-application stream, which you can think of as a constantly updating table. In the mapping, you must provide a schema for the in-application stream and map each data column in the in-application stream to a data element in the streaming source.</p>
    /// <p>Your application code is one or more SQL statements that read input data, transform it, and generate output. Your application code can create one or more SQL artifacts like SQL streams or pumps.</p>
    /// <p>In the output configuration, you can configure the application to write data from in-application streams created in your applications to up to three destinations.</p>
    /// <p> To read data from your source stream or write data to destination streams, Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating IAM roles. This operation requires permissions to perform the <code>kinesisanalytics:CreateApplication</code> action. </p>
    /// <p> For introductory exercises to create an Amazon Kinesis Analytics application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html">Getting Started</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_application_input::Builder,
    }
    impl CreateApplication {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Summary description of the application.</p>
        pub fn application_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_description(input.into());
            self
        }
        /// <p>Summary description of the application.</p>
        pub fn set_application_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_description(input);
            self
        }
        /// Appends an item to `Inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>Use this parameter to configure the application input.</p>
        /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
        /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
        /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
        pub fn inputs(mut self, input: crate::model::Input) -> Self {
            self.inner = self.inner.inputs(input);
            self
        }
        /// <p>Use this parameter to configure the application input.</p>
        /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
        /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
        /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Input>>,
        ) -> Self {
            self.inner = self.inner.set_inputs(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
        /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any combination of the three.</p>
        /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.</p>
        /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
        pub fn outputs(mut self, input: crate::model::Output) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
        /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any combination of the three.</p>
        /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.</p>
        /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// Appends an item to `CloudWatchLoggingOptions`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_logging_options`](Self::set_cloud_watch_logging_options).
        ///
        /// <p>Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: crate::model::CloudWatchLoggingOption,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logging_options(input);
            self
        }
        /// <p>Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOption>>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logging_options(input);
            self
        }
        /// <p>One or more SQL statements that read input data, transform it, and generate output. For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>. </p>
        /// <p>You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.</p>
        /// <p>Note that the application code must create the streams with names specified in the <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code must create these streams. </p>
        pub fn application_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_code(input.into());
            self
        }
        /// <p>One or more SQL statements that read input data, transform it, and generate output. For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>. </p>
        /// <p>You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.</p>
        /// <p>Note that the application code must create the streams with names specified in the <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code must create these streams. </p>
        pub fn set_application_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_code(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Deletes the specified application. Amazon Kinesis Analytics halts application execution and deletes the application, including any application artifacts (such as in-application streams, reference table, and application code).</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:DeleteApplication</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl DeleteApplication {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p> You can use the <code>DescribeApplication</code> operation to get this value. </p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.create_timestamp(input);
            self
        }
        /// <p> You can use the <code>DescribeApplication</code> operation to get this value. </p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_create_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationCloudWatchLoggingOption`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Deletes a CloudWatch log stream from an application. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplicationCloudWatchLoggingOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_cloud_watch_logging_option_input::Builder,
    }
    impl DeleteApplicationCloudWatchLoggingOption {
        /// Creates a new `DeleteApplicationCloudWatchLoggingOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationCloudWatchLoggingOptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteApplicationCloudWatchLoggingOptionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
        pub fn cloud_watch_logging_option_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logging_option_id(input.into());
            self
        }
        /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
        pub fn set_cloud_watch_logging_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logging_option_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationInputProcessingConfiguration`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Deletes an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> from an input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplicationInputProcessingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_input_processing_configuration_input::Builder,
    }
    impl DeleteApplicationInputProcessingConfiguration {
        /// Creates a new `DeleteApplicationInputProcessingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationInputProcessingConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteApplicationInputProcessingConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The ID of the input configuration from which to delete the input processing configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_id(input.into());
            self
        }
        /// <p>The ID of the input configuration from which to delete the input processing configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationOutput`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Deletes output destination configuration from your application configuration. Amazon Kinesis Analytics will no longer write data from the corresponding in-application stream to the external output destination.</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:DeleteApplicationOutput</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplicationOutput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_output_input::Builder,
    }
    impl DeleteApplicationOutput {
        /// Creates a new `DeleteApplicationOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationOutputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Amazon Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Amazon Kinesis Analytics application version. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Amazon Kinesis Analytics application version. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>The ID of the configuration to delete. Each output configuration that is added to the application, either when the application is created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from the application configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific <code>OutputId</code>. </p>
        pub fn output_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_id(input.into());
            self
        }
        /// <p>The ID of the configuration to delete. Each output configuration that is added to the application, either when the application is created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from the application configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific <code>OutputId</code>. </p>
        pub fn set_output_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplicationReferenceDataSource`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Deletes a reference data source configuration from the specified application configuration.</p>
    /// <p>If the application is running, Amazon Kinesis Analytics immediately removes the in-application table that you created using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation. </p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics.DeleteApplicationReferenceDataSource</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplicationReferenceDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_application_reference_data_source_input::Builder,
    }
    impl DeleteApplicationReferenceDataSource {
        /// Creates a new `DeleteApplicationReferenceDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationReferenceDataSourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteApplicationReferenceDataSourceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of an existing application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of an existing application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>Version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>Version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>ID of the reference data source. When you add a reference data source to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID. </p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reference_id(input.into());
            self
        }
        /// <p>ID of the reference data source. When you add a reference data source to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID. </p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reference_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Returns information about a specific Amazon Kinesis Analytics application.</p>
    /// <p>If you want to retrieve a list of all applications in your account, use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_ListApplications.html">ListApplications</a> operation.</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:DescribeApplication</code> action. You can use <code>DescribeApplication</code> to get the current application versionId, which you need to call other operations such as <code>Update</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_application_input::Builder,
    }
    impl DescribeApplication {
        /// Creates a new `DescribeApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DiscoverInputSchema`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.</p>
    /// <p> You can use the inferred schema when configuring a streaming source for your application. For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. Note that when you create an application using the Amazon Kinesis Analytics console, the console uses this operation to infer a schema and show it in the console user interface. </p>
    /// <p> This operation requires permissions to perform the <code>kinesisanalytics:DiscoverInputSchema</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DiscoverInputSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::discover_input_schema_input::Builder,
    }
    impl DiscoverInputSchema {
        /// Creates a new `DiscoverInputSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DiscoverInputSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DiscoverInputSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
        pub fn input_starting_position_configuration(
            mut self,
            input: crate::model::InputStartingPositionConfiguration,
        ) -> Self {
            self.inner = self.inner.input_starting_position_configuration(input);
            self
        }
        /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
        pub fn set_input_starting_position_configuration(
            mut self,
            input: std::option::Option<crate::model::InputStartingPositionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_input_starting_position_configuration(input);
            self
        }
        /// <p>Specify this parameter to discover a schema from data in an Amazon S3 object.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3Configuration) -> Self {
            self.inner = self.inner.s3_configuration(input);
            self
        }
        /// <p>Specify this parameter to discover a schema from data in an Amazon S3 object.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3Configuration>,
        ) -> Self {
            self.inner = self.inner.set_s3_configuration(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
        pub fn input_processing_configuration(
            mut self,
            input: crate::model::InputProcessingConfiguration,
        ) -> Self {
            self.inner = self.inner.input_processing_configuration(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
        pub fn set_input_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_input_processing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApplications`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Returns a list of Amazon Kinesis Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status. If the response returns the <code>HasMoreApplications</code> value as true, you can send another request by adding the <code>ExclusiveStartApplicationName</code> in the request body, and set the value of this to the last application name from the previous response. </p>
    /// <p>If you want detailed information about a specific application, use <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>.</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:ListApplications</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApplications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_applications_input::Builder,
    }
    impl ListApplications {
        /// Creates a new `ListApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApplicationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of applications to list.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Maximum number of applications to list.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
        pub fn exclusive_start_application_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_application_name(input.into());
            self
        }
        /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
        pub fn set_exclusive_start_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of key-value tags assigned to the application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the application for which to retrieve tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the application for which to retrieve tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Starts the specified Amazon Kinesis Analytics application. After creating an application, you must exclusively call this operation to start your application.</p>
    /// <p>After the application starts, it begins consuming the input data, processes it, and writes the output to the configured destination.</p>
    /// <p> The application status must be <code>READY</code> for you to start an application. You can get the application status in the console or using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    /// <p>After you start the application, you can stop the application from processing the input by calling the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html">StopApplication</a> operation.</p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:StartApplication</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_application_input::Builder,
    }
    impl StartApplication {
        /// Creates a new `StartApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// Appends an item to `InputConfigurations`.
        ///
        /// To override the contents of this collection use [`set_input_configurations`](Self::set_input_configurations).
        ///
        /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
        pub fn input_configurations(mut self, input: crate::model::InputConfiguration) -> Self {
            self.inner = self.inner.input_configurations(input);
            self
        }
        /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
        pub fn set_input_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_input_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Stops the application from processing input data. You can stop an application only if it is in the running state. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the application state. After the application is stopped, Amazon Kinesis Analytics stops reading data from the input, the application stops processing data, and there is no output written to the destination. </p>
    /// <p>This operation requires permissions to perform the <code>kinesisanalytics:StopApplication</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_application_input::Builder,
    }
    impl StopApplication {
        /// Creates a new `StopApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StopApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the running application to stop.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the running application to stop.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more key-value tags to a Kinesis Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the application to assign the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the application to assign the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags to assign to the application.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value tags to assign to the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a Kinesis Analytics application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys of tags to remove from the specified application.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of keys of tags to remove from the specified application.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <note>
    /// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
    /// </note>
    /// <p>Updates an existing Amazon Kinesis Analytics application. Using this API, you can update application code, input configuration, and output configuration. </p>
    /// <p>Note that Amazon Kinesis Analytics updates the <code>CurrentApplicationVersionId</code> each time you update your application. </p>
    /// <p>This operation requires permission for the <code>kinesisanalytics:UpdateApplication</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_input::Builder,
    }
    impl UpdateApplication {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_name(input.into());
            self
        }
        /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_name(input);
            self
        }
        /// <p>The current application version ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.inner = self.inner.current_application_version_id(input);
            self
        }
        /// <p>The current application version ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self.inner.set_current_application_version_id(input);
            self
        }
        /// <p>Describes application updates.</p>
        pub fn application_update(mut self, input: crate::model::ApplicationUpdate) -> Self {
            self.inner = self.inner.application_update(input);
            self
        }
        /// <p>Describes application updates.</p>
        pub fn set_application_update(
            mut self,
            input: std::option::Option<crate::model::ApplicationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_application_update(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
