// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddApplicationCloudWatchLoggingOptionInput`](crate::input::AddApplicationCloudWatchLoggingOptionInput)
pub mod add_application_cloud_watch_logging_option_input {
    /// A builder for [`AddApplicationCloudWatchLoggingOptionInput`](crate::input::AddApplicationCloudWatchLoggingOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) cloud_watch_logging_option:
            std::option::Option<crate::model::CloudWatchLoggingOption>,
    }
    impl Builder {
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN.
        /// Note: To write application messages to CloudWatch, the IAM role that is used must have
        /// the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn cloud_watch_logging_option(
            mut self,
            input: crate::model::CloudWatchLoggingOption,
        ) -> Self {
            self.cloud_watch_logging_option = Some(input);
            self
        }
        /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN.
        /// Note: To write application messages to CloudWatch, the IAM role that is used must have
        /// the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn set_cloud_watch_logging_option(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLoggingOption>,
        ) -> Self {
            self.cloud_watch_logging_option = input;
            self
        }
        /// Consumes the builder and constructs a [`AddApplicationCloudWatchLoggingOptionInput`](crate::input::AddApplicationCloudWatchLoggingOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddApplicationCloudWatchLoggingOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddApplicationCloudWatchLoggingOptionInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                cloud_watch_logging_option: self.cloud_watch_logging_option,
            })
        }
    }
}
#[doc(hidden)]
pub type AddApplicationCloudWatchLoggingOptionInputOperationOutputAlias =
    crate::operation::AddApplicationCloudWatchLoggingOption;
#[doc(hidden)]
pub type AddApplicationCloudWatchLoggingOptionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl AddApplicationCloudWatchLoggingOptionInput {
    /// Consumes the builder and constructs an Operation<[`AddApplicationCloudWatchLoggingOption`](crate::operation::AddApplicationCloudWatchLoggingOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddApplicationCloudWatchLoggingOption,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddApplicationCloudWatchLoggingOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddApplicationCloudWatchLoggingOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddApplicationCloudWatchLoggingOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.AddApplicationCloudWatchLoggingOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_application_cloud_watch_logging_option(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddApplicationCloudWatchLoggingOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddApplicationCloudWatchLoggingOption",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddApplicationCloudWatchLoggingOptionInput`](crate::input::AddApplicationCloudWatchLoggingOptionInput)
    pub fn builder() -> crate::input::add_application_cloud_watch_logging_option_input::Builder {
        crate::input::add_application_cloud_watch_logging_option_input::Builder::default()
    }
}

/// See [`AddApplicationInputInput`](crate::input::AddApplicationInputInput)
pub mod add_application_input_input {
    /// A builder for [`AddApplicationInputInput`](crate::input::AddApplicationInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) input: std::option::Option<crate::model::Input>,
    }
    impl Builder {
        /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation
        /// to find the current application version.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation
        /// to find the current application version.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`AddApplicationInputInput`](crate::input::AddApplicationInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddApplicationInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddApplicationInputInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                input: self.input,
            })
        }
    }
}
#[doc(hidden)]
pub type AddApplicationInputInputOperationOutputAlias = crate::operation::AddApplicationInput;
#[doc(hidden)]
pub type AddApplicationInputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddApplicationInputInput {
    /// Consumes the builder and constructs an Operation<[`AddApplicationInput`](crate::operation::AddApplicationInput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddApplicationInput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddApplicationInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddApplicationInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddApplicationInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.AddApplicationInput",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_application_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddApplicationInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddApplicationInput",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddApplicationInputInput`](crate::input::AddApplicationInputInput)
    pub fn builder() -> crate::input::add_application_input_input::Builder {
        crate::input::add_application_input_input::Builder::default()
    }
}

/// See [`AddApplicationInputProcessingConfigurationInput`](crate::input::AddApplicationInputProcessingConfigurationInput)
pub mod add_application_input_processing_configuration_input {
    /// A builder for [`AddApplicationInputProcessingConfigurationInput`](crate::input::AddApplicationInputProcessingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) input_processing_configuration:
            std::option::Option<crate::model::InputProcessingConfiguration>,
    }
    impl Builder {
        /// <p>Name of the application to which you want to add the input processing configuration.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application to which you want to add the input processing configuration.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>
        /// operation to get the current application version.  If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>
        /// operation to get the current application version.  If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The ID of the input configuration to add the input processing configuration to. You
        /// can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// <p>The ID of the input configuration to add the input processing configuration to. You
        /// can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
        pub fn input_processing_configuration(
            mut self,
            input: crate::model::InputProcessingConfiguration,
        ) -> Self {
            self.input_processing_configuration = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
        pub fn set_input_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfiguration>,
        ) -> Self {
            self.input_processing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AddApplicationInputProcessingConfigurationInput`](crate::input::AddApplicationInputProcessingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddApplicationInputProcessingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AddApplicationInputProcessingConfigurationInput {
                    application_name: self.application_name,
                    current_application_version_id: self.current_application_version_id,
                    input_id: self.input_id,
                    input_processing_configuration: self.input_processing_configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AddApplicationInputProcessingConfigurationInputOperationOutputAlias =
    crate::operation::AddApplicationInputProcessingConfiguration;
#[doc(hidden)]
pub type AddApplicationInputProcessingConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl AddApplicationInputProcessingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`AddApplicationInputProcessingConfiguration`](crate::operation::AddApplicationInputProcessingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddApplicationInputProcessingConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddApplicationInputProcessingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddApplicationInputProcessingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddApplicationInputProcessingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.AddApplicationInputProcessingConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_application_input_processing_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddApplicationInputProcessingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddApplicationInputProcessingConfiguration",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddApplicationInputProcessingConfigurationInput`](crate::input::AddApplicationInputProcessingConfigurationInput)
    pub fn builder() -> crate::input::add_application_input_processing_configuration_input::Builder
    {
        crate::input::add_application_input_processing_configuration_input::Builder::default()
    }
}

/// See [`AddApplicationOutputInput`](crate::input::AddApplicationOutputInput)
pub mod add_application_output_input {
    /// A builder for [`AddApplicationOutputInput`](crate::input::AddApplicationOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) output: std::option::Option<crate::model::Output>,
    }
    impl Builder {
        /// <p>Name of the application to which you want to add the output configuration.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application to which you want to add the output configuration.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Version of the application to which you want to add the output configuration. You
        /// can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current
        /// application version. If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned. </p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Version of the application to which you want to add the output configuration. You
        /// can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current
        /// application version. If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned. </p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>An array of objects, each describing one output configuration. In the output
        /// configuration, you specify the name of an in-application stream, a destination (that is,
        /// an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
        /// function), and record the formation to use when writing to the destination.</p>
        pub fn output(mut self, input: crate::model::Output) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>An array of objects, each describing one output configuration. In the output
        /// configuration, you specify the name of an in-application stream, a destination (that is,
        /// an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
        /// function), and record the formation to use when writing to the destination.</p>
        pub fn set_output(mut self, input: std::option::Option<crate::model::Output>) -> Self {
            self.output = input;
            self
        }
        /// Consumes the builder and constructs a [`AddApplicationOutputInput`](crate::input::AddApplicationOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddApplicationOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddApplicationOutputInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                output: self.output,
            })
        }
    }
}
#[doc(hidden)]
pub type AddApplicationOutputInputOperationOutputAlias = crate::operation::AddApplicationOutput;
#[doc(hidden)]
pub type AddApplicationOutputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddApplicationOutputInput {
    /// Consumes the builder and constructs an Operation<[`AddApplicationOutput`](crate::operation::AddApplicationOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddApplicationOutput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddApplicationOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddApplicationOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddApplicationOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.AddApplicationOutput",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_application_output(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddApplicationOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddApplicationOutput",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddApplicationOutputInput`](crate::input::AddApplicationOutputInput)
    pub fn builder() -> crate::input::add_application_output_input::Builder {
        crate::input::add_application_output_input::Builder::default()
    }
}

/// See [`AddApplicationReferenceDataSourceInput`](crate::input::AddApplicationReferenceDataSourceInput)
pub mod add_application_reference_data_source_input {
    /// A builder for [`AddApplicationReferenceDataSourceInput`](crate::input::AddApplicationReferenceDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) reference_data_source: std::option::Option<crate::model::ReferenceDataSource>,
    }
    impl Builder {
        /// <p>Name of an existing application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of an existing application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Version of the application for which you are adding the reference data source.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Version of the application for which you are adding the reference data source.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
        pub fn reference_data_source(mut self, input: crate::model::ReferenceDataSource) -> Self {
            self.reference_data_source = Some(input);
            self
        }
        /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
        pub fn set_reference_data_source(
            mut self,
            input: std::option::Option<crate::model::ReferenceDataSource>,
        ) -> Self {
            self.reference_data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`AddApplicationReferenceDataSourceInput`](crate::input::AddApplicationReferenceDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddApplicationReferenceDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddApplicationReferenceDataSourceInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                reference_data_source: self.reference_data_source,
            })
        }
    }
}
#[doc(hidden)]
pub type AddApplicationReferenceDataSourceInputOperationOutputAlias =
    crate::operation::AddApplicationReferenceDataSource;
#[doc(hidden)]
pub type AddApplicationReferenceDataSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddApplicationReferenceDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`AddApplicationReferenceDataSource`](crate::operation::AddApplicationReferenceDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddApplicationReferenceDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddApplicationReferenceDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddApplicationReferenceDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddApplicationReferenceDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.AddApplicationReferenceDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_application_reference_data_source(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddApplicationReferenceDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddApplicationReferenceDataSource",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddApplicationReferenceDataSourceInput`](crate::input::AddApplicationReferenceDataSourceInput)
    pub fn builder() -> crate::input::add_application_reference_data_source_input::Builder {
        crate::input::add_application_reference_data_source_input::Builder::default()
    }
}

/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) application_description: std::option::Option<std::string::String>,
        pub(crate) inputs: std::option::Option<std::vec::Vec<crate::model::Input>>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) cloud_watch_logging_options:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOption>>,
        pub(crate) application_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Summary description of the application.</p>
        pub fn application_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_description = Some(input.into());
            self
        }
        /// <p>Summary description of the application.</p>
        pub fn set_application_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_description = input;
            self
        }
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>Use this parameter to configure the application input.</p>
        /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
        /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of
        /// data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role
        /// that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
        /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
        pub fn inputs(mut self, input: impl Into<crate::model::Input>) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input.into());
            self.inputs = Some(v);
            self
        }
        /// <p>Use this parameter to configure the application input.</p>
        /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
        /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of
        /// data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role
        /// that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
        /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Input>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
        /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery
        /// streams, AWS Lambda destinations, or any combination of the three.</p>
        /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the
        /// destination stream or Lambda function on your behalf.</p>
        /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format
        /// of data in the stream (for example, JSON, CSV). You also must provide an IAM role that
        /// Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
        /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery
        /// streams, AWS Lambda destinations, or any combination of the three.</p>
        /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the
        /// destination stream or Lambda function on your behalf.</p>
        /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format
        /// of data in the stream (for example, JSON, CSV). You also must provide an IAM role that
        /// Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Appends an item to `cloud_watch_logging_options`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_logging_options`](Self::set_cloud_watch_logging_options).
        ///
        /// <p>Use this parameter to configure a CloudWatch log stream to monitor application
        /// configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
        /// CloudWatch Logs</a>.</p>
        pub fn cloud_watch_logging_options(
            mut self,
            input: impl Into<crate::model::CloudWatchLoggingOption>,
        ) -> Self {
            let mut v = self.cloud_watch_logging_options.unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_logging_options = Some(v);
            self
        }
        /// <p>Use this parameter to configure a CloudWatch log stream to monitor application
        /// configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
        /// CloudWatch Logs</a>.</p>
        pub fn set_cloud_watch_logging_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOption>>,
        ) -> Self {
            self.cloud_watch_logging_options = input;
            self
        }
        /// <p>One or more SQL statements that read input data, transform it, and generate output.
        /// For example, you can write a SQL statement that reads data from one in-application
        /// stream, generates a running average of the number of advertisement clicks by vendor, and
        /// insert resulting rows in another in-application stream using pumps. For more information
        /// about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
        /// Code</a>. </p>
        ///
        /// <p>You can provide such series of SQL statements,
        /// where output of one statement can be
        /// used as the input for the next statement. You store
        /// intermediate results by creating in-application streams and pumps.</p>
        ///
        /// <p>Note that the application code must create the streams with names
        /// specified in the <code>Outputs</code>. For example,
        /// if your <code>Outputs</code> defines output streams named
        /// <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>,
        /// then your application code must create these streams. </p>
        pub fn application_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_code = Some(input.into());
            self
        }
        /// <p>One or more SQL statements that read input data, transform it, and generate output.
        /// For example, you can write a SQL statement that reads data from one in-application
        /// stream, generates a running average of the number of advertisement clicks by vendor, and
        /// insert resulting rows in another in-application stream using pumps. For more information
        /// about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
        /// Code</a>. </p>
        ///
        /// <p>You can provide such series of SQL statements,
        /// where output of one statement can be
        /// used as the input for the next statement. You store
        /// intermediate results by creating in-application streams and pumps.</p>
        ///
        /// <p>Note that the application code must create the streams with names
        /// specified in the <code>Outputs</code>. For example,
        /// if your <code>Outputs</code> defines output streams named
        /// <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>,
        /// then your application code must create these streams. </p>
        pub fn set_application_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_code = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
        /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
        /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                application_name: self.application_name,
                application_description: self.application_description,
                inputs: self.inputs,
                outputs: self.outputs,
                cloud_watch_logging_options: self.cloud_watch_logging_options,
                application_code: self.application_code,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.CreateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>
        /// You can use the <code>DescribeApplication</code> operation to get this value.
        /// </p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>
        /// You can use the <code>DescribeApplication</code> operation to get this value.
        /// </p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput {
                application_name: self.application_name,
                create_timestamp: self.create_timestamp,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DeleteApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteApplicationCloudWatchLoggingOptionInput`](crate::input::DeleteApplicationCloudWatchLoggingOptionInput)
pub mod delete_application_cloud_watch_logging_option_input {
    /// A builder for [`DeleteApplicationCloudWatchLoggingOptionInput`](crate::input::DeleteApplicationCloudWatchLoggingOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) cloud_watch_logging_option_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to
        /// delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
        pub fn cloud_watch_logging_option_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = Some(input.into());
            self
        }
        /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to
        /// delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
        pub fn set_cloud_watch_logging_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationCloudWatchLoggingOptionInput`](crate::input::DeleteApplicationCloudWatchLoggingOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationCloudWatchLoggingOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteApplicationCloudWatchLoggingOptionInput {
                    application_name: self.application_name,
                    current_application_version_id: self.current_application_version_id,
                    cloud_watch_logging_option_id: self.cloud_watch_logging_option_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationCloudWatchLoggingOptionInputOperationOutputAlias =
    crate::operation::DeleteApplicationCloudWatchLoggingOption;
#[doc(hidden)]
pub type DeleteApplicationCloudWatchLoggingOptionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationCloudWatchLoggingOptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplicationCloudWatchLoggingOption`](crate::operation::DeleteApplicationCloudWatchLoggingOption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplicationCloudWatchLoggingOption,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationCloudWatchLoggingOptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationCloudWatchLoggingOptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationCloudWatchLoggingOptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DeleteApplicationCloudWatchLoggingOption",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application_cloud_watch_logging_option(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplicationCloudWatchLoggingOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplicationCloudWatchLoggingOption",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationCloudWatchLoggingOptionInput`](crate::input::DeleteApplicationCloudWatchLoggingOptionInput)
    pub fn builder() -> crate::input::delete_application_cloud_watch_logging_option_input::Builder {
        crate::input::delete_application_cloud_watch_logging_option_input::Builder::default()
    }
}

/// See [`DeleteApplicationInputProcessingConfigurationInput`](crate::input::DeleteApplicationInputProcessingConfigurationInput)
pub mod delete_application_input_processing_configuration_input {
    /// A builder for [`DeleteApplicationInputProcessingConfigurationInput`](crate::input::DeleteApplicationInputProcessingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) input_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>The Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>The version ID of the Kinesis Analytics application.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The ID of the input configuration from which to delete the input processing
        /// configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// <p>The ID of the input configuration from which to delete the input processing
        /// configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInputProcessingConfigurationInput`](crate::input::DeleteApplicationInputProcessingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInputProcessingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteApplicationInputProcessingConfigurationInput {
                    application_name: self.application_name,
                    current_application_version_id: self.current_application_version_id,
                    input_id: self.input_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputProcessingConfigurationInputOperationOutputAlias =
    crate::operation::DeleteApplicationInputProcessingConfiguration;
#[doc(hidden)]
pub type DeleteApplicationInputProcessingConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationInputProcessingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplicationInputProcessingConfiguration`](crate::operation::DeleteApplicationInputProcessingConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplicationInputProcessingConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationInputProcessingConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationInputProcessingConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationInputProcessingConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DeleteApplicationInputProcessingConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application_input_processing_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplicationInputProcessingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplicationInputProcessingConfiguration",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInputProcessingConfigurationInput`](crate::input::DeleteApplicationInputProcessingConfigurationInput)
    pub fn builder(
    ) -> crate::input::delete_application_input_processing_configuration_input::Builder {
        crate::input::delete_application_input_processing_configuration_input::Builder::default()
    }
}

/// See [`DeleteApplicationOutputInput`](crate::input::DeleteApplicationOutputInput)
pub mod delete_application_output_input {
    /// A builder for [`DeleteApplicationOutputInput`](crate::input::DeleteApplicationOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) output_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Kinesis Analytics application name.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Amazon Kinesis Analytics application name.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Amazon Kinesis Analytics application version.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.
        /// </p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Amazon Kinesis Analytics application version.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified is not the current version, the
        /// <code>ConcurrentModificationException</code> is returned.
        /// </p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>The ID of the configuration to delete.
        /// Each output configuration that is added to the application, either when the application is
        /// created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID.
        /// You need to provide the ID to uniquely identify the output configuration that you want to
        /// delete from the application configuration.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific
        /// <code>OutputId</code>.
        /// </p>
        pub fn output_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration to delete.
        /// Each output configuration that is added to the application, either when the application is
        /// created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID.
        /// You need to provide the ID to uniquely identify the output configuration that you want to
        /// delete from the application configuration.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific
        /// <code>OutputId</code>.
        /// </p>
        pub fn set_output_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationOutputInput`](crate::input::DeleteApplicationOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationOutputInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                output_id: self.output_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationOutputInputOperationOutputAlias =
    crate::operation::DeleteApplicationOutput;
#[doc(hidden)]
pub type DeleteApplicationOutputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationOutputInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplicationOutput`](crate::operation::DeleteApplicationOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplicationOutput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DeleteApplicationOutput",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application_output(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplicationOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplicationOutput",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationOutputInput`](crate::input::DeleteApplicationOutputInput)
    pub fn builder() -> crate::input::delete_application_output_input::Builder {
        crate::input::delete_application_output_input::Builder::default()
    }
}

/// See [`DeleteApplicationReferenceDataSourceInput`](crate::input::DeleteApplicationReferenceDataSourceInput)
pub mod delete_application_reference_data_source_input {
    /// A builder for [`DeleteApplicationReferenceDataSourceInput`](crate::input::DeleteApplicationReferenceDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of an existing application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of an existing application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Version of the application.  
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified
        /// is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>Version of the application.  
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
        /// If the version specified
        /// is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>ID of the reference data source. When you add a reference data source to your
        /// application using the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID.
        /// </p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>ID of the reference data source. When you add a reference data source to your
        /// application using the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID.
        /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID.
        /// </p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationReferenceDataSourceInput`](crate::input::DeleteApplicationReferenceDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationReferenceDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationReferenceDataSourceInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                reference_id: self.reference_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationReferenceDataSourceInputOperationOutputAlias =
    crate::operation::DeleteApplicationReferenceDataSource;
#[doc(hidden)]
pub type DeleteApplicationReferenceDataSourceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteApplicationReferenceDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplicationReferenceDataSource`](crate::operation::DeleteApplicationReferenceDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplicationReferenceDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApplicationReferenceDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApplicationReferenceDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApplicationReferenceDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DeleteApplicationReferenceDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_application_reference_data_source(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplicationReferenceDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplicationReferenceDataSource",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationReferenceDataSourceInput`](crate::input::DeleteApplicationReferenceDataSourceInput)
    pub fn builder() -> crate::input::delete_application_reference_data_source_input::Builder {
        crate::input::delete_application_reference_data_source_input::Builder::default()
    }
}

/// See [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
pub mod describe_application_input {
    /// A builder for [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationInput {
                application_name: self.application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationInputOperationOutputAlias = crate::operation::DescribeApplication;
#[doc(hidden)]
pub type DescribeApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplication`](crate::operation::DescribeApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DescribeApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationInput`](crate::input::DescribeApplicationInput)
    pub fn builder() -> crate::input::describe_application_input::Builder {
        crate::input::describe_application_input::Builder::default()
    }
}

/// See [`DiscoverInputSchemaInput`](crate::input::DiscoverInputSchemaInput)
pub mod discover_input_schema_input {
    /// A builder for [`DiscoverInputSchemaInput`](crate::input::DiscoverInputSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) input_starting_position_configuration:
            std::option::Option<crate::model::InputStartingPositionConfiguration>,
        pub(crate) s3_configuration: std::option::Option<crate::model::S3Configuration>,
        pub(crate) input_processing_configuration:
            std::option::Option<crate::model::InputProcessingConfiguration>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
        pub fn input_starting_position_configuration(
            mut self,
            input: crate::model::InputStartingPositionConfiguration,
        ) -> Self {
            self.input_starting_position_configuration = Some(input);
            self
        }
        /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
        pub fn set_input_starting_position_configuration(
            mut self,
            input: std::option::Option<crate::model::InputStartingPositionConfiguration>,
        ) -> Self {
            self.input_starting_position_configuration = input;
            self
        }
        /// <p>Specify this parameter to discover a schema from data in an Amazon S3
        /// object.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3Configuration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>Specify this parameter to discover a schema from data in an Amazon S3
        /// object.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3Configuration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
        pub fn input_processing_configuration(
            mut self,
            input: crate::model::InputProcessingConfiguration,
        ) -> Self {
            self.input_processing_configuration = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
        pub fn set_input_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfiguration>,
        ) -> Self {
            self.input_processing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DiscoverInputSchemaInput`](crate::input::DiscoverInputSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DiscoverInputSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DiscoverInputSchemaInput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
                input_starting_position_configuration: self.input_starting_position_configuration,
                s3_configuration: self.s3_configuration,
                input_processing_configuration: self.input_processing_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type DiscoverInputSchemaInputOperationOutputAlias = crate::operation::DiscoverInputSchema;
#[doc(hidden)]
pub type DiscoverInputSchemaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DiscoverInputSchemaInput {
    /// Consumes the builder and constructs an Operation<[`DiscoverInputSchema`](crate::operation::DiscoverInputSchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DiscoverInputSchema,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DiscoverInputSchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DiscoverInputSchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DiscoverInputSchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.DiscoverInputSchema",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_discover_input_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DiscoverInputSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DiscoverInputSchema",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DiscoverInputSchemaInput`](crate::input::DiscoverInputSchemaInput)
    pub fn builder() -> crate::input::discover_input_schema_input::Builder {
        crate::input::discover_input_schema_input::Builder::default()
    }
}

/// See [`ListApplicationsInput`](crate::input::ListApplicationsInput)
pub mod list_applications_input {
    /// A builder for [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) exclusive_start_application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of applications to list.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Maximum number of applications to list.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
        pub fn exclusive_start_application_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.exclusive_start_application_name = Some(input.into());
            self
        }
        /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
        pub fn set_exclusive_start_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApplicationsInput`](crate::input::ListApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApplicationsInput {
                limit: self.limit,
                exclusive_start_application_name: self.exclusive_start_application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApplicationsInputOperationOutputAlias = crate::operation::ListApplications;
#[doc(hidden)]
pub type ListApplicationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListApplications`](crate::operation::ListApplications)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApplications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.ListApplications",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_applications(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApplications",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApplicationsInput`](crate::input::ListApplicationsInput)
    pub fn builder() -> crate::input::list_applications_input::Builder {
        crate::input::list_applications_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the application for which to retrieve tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the application for which to retrieve tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartApplicationInput`](crate::input::StartApplicationInput)
pub mod start_application_input {
    /// A builder for [`StartApplicationInput`](crate::input::StartApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) input_configurations:
            std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
    }
    impl Builder {
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Appends an item to `input_configurations`.
        ///
        /// To override the contents of this collection use [`set_input_configurations`](Self::set_input_configurations).
        ///
        /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
        pub fn input_configurations(
            mut self,
            input: impl Into<crate::model::InputConfiguration>,
        ) -> Self {
            let mut v = self.input_configurations.unwrap_or_default();
            v.push(input.into());
            self.input_configurations = Some(v);
            self
        }
        /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
        pub fn set_input_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
        ) -> Self {
            self.input_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`StartApplicationInput`](crate::input::StartApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartApplicationInput {
                application_name: self.application_name,
                input_configurations: self.input_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type StartApplicationInputOperationOutputAlias = crate::operation::StartApplication;
#[doc(hidden)]
pub type StartApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartApplicationInput {
    /// Consumes the builder and constructs an Operation<[`StartApplication`](crate::operation::StartApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.StartApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartApplicationInput`](crate::input::StartApplicationInput)
    pub fn builder() -> crate::input::start_application_input::Builder {
        crate::input::start_application_input::Builder::default()
    }
}

/// See [`StopApplicationInput`](crate::input::StopApplicationInput)
pub mod stop_application_input {
    /// A builder for [`StopApplicationInput`](crate::input::StopApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the running application to stop.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the running application to stop.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopApplicationInput`](crate::input::StopApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopApplicationInput {
                application_name: self.application_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StopApplicationInputOperationOutputAlias = crate::operation::StopApplication;
#[doc(hidden)]
pub type StopApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopApplicationInput {
    /// Consumes the builder and constructs an Operation<[`StopApplication`](crate::operation::StopApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.StopApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopApplicationInput`](crate::input::StopApplicationInput)
    pub fn builder() -> crate::input::stop_application_input::Builder {
        crate::input::stop_application_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the application to assign the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the application to assign the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags to assign to the application.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key-value tags to assign to the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys of tags to remove from the specified application.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of keys of tags to remove from the specified application.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) current_application_version_id: std::option::Option<i64>,
        pub(crate) application_update: std::option::Option<crate::model::ApplicationUpdate>,
    }
    impl Builder {
        /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>The current application version ID. You can use the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn current_application_version_id(mut self, input: i64) -> Self {
            self.current_application_version_id = Some(input);
            self
        }
        /// <p>The current application version ID. You can use the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn set_current_application_version_id(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.current_application_version_id = input;
            self
        }
        /// <p>Describes application updates.</p>
        pub fn application_update(mut self, input: crate::model::ApplicationUpdate) -> Self {
            self.application_update = Some(input);
            self
        }
        /// <p>Describes application updates.</p>
        pub fn set_application_update(
            mut self,
            input: std::option::Option<crate::model::ApplicationUpdate>,
        ) -> Self {
            self.application_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                application_name: self.application_name,
                current_application_version_id: self.current_application_version_id,
                application_update: self.application_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KinesisAnalytics_20150814.UpdateApplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "kinesisanalytics",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The current application version ID. You can use the
    /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>Describes application updates.</p>
    pub application_update: std::option::Option<crate::model::ApplicationUpdate>,
}
impl UpdateApplicationInput {
    /// <p>Name of the Amazon Kinesis Analytics application to update.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The current application version ID. You can use the
    /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>Describes application updates.</p>
    pub fn application_update(&self) -> std::option::Option<&crate::model::ApplicationUpdate> {
        self.application_update.as_ref()
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("application_update", &self.application_update);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of keys of tags to remove from the specified application.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of keys of tags to remove from the specified application.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the application to assign the tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value tags to assign to the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ARN of the application to assign the tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key-value tags to assign to the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopApplicationInput {
    /// <p>Name of the running application to stop.</p>
    pub application_name: std::option::Option<std::string::String>,
}
impl StopApplicationInput {
    /// <p>Name of the running application to stop.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
}
impl std::fmt::Debug for StopApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartApplicationInput {
    /// <p>Name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
    pub input_configurations: std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
}
impl StartApplicationInput {
    /// <p>Name of the application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>
    pub fn input_configurations(&self) -> std::option::Option<&[crate::model::InputConfiguration]> {
        self.input_configurations.as_deref()
    }
}
impl std::fmt::Debug for StartApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("input_configurations", &self.input_configurations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the application for which to retrieve tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the application for which to retrieve tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApplicationsInput {
    /// <p>Maximum number of applications to list.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
    pub exclusive_start_application_name: std::option::Option<std::string::String>,
}
impl ListApplicationsInput {
    /// <p>Maximum number of applications to list.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Name of the application to start the list with. When using pagination to retrieve the list, you don't need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>
    pub fn exclusive_start_application_name(&self) -> std::option::Option<&str> {
        self.exclusive_start_application_name.as_deref()
    }
}
impl std::fmt::Debug for ListApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApplicationsInput");
        formatter.field("limit", &self.limit);
        formatter.field(
            "exclusive_start_application_name",
            &self.exclusive_start_application_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiscoverInputSchemaInput {
    /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
    pub input_starting_position_configuration:
        std::option::Option<crate::model::InputStartingPositionConfiguration>,
    /// <p>Specify this parameter to discover a schema from data in an Amazon S3
    /// object.</p>
    pub s3_configuration: std::option::Option<crate::model::S3Configuration>,
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
    pub input_processing_configuration:
        std::option::Option<crate::model::InputProcessingConfiguration>,
}
impl DiscoverInputSchemaInput {
    /// <p>Amazon Resource Name (ARN) of the streaming source.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>
    pub fn input_starting_position_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InputStartingPositionConfiguration> {
        self.input_starting_position_configuration.as_ref()
    }
    /// <p>Specify this parameter to discover a schema from data in an Amazon S3
    /// object.</p>
    pub fn s3_configuration(&self) -> std::option::Option<&crate::model::S3Configuration> {
        self.s3_configuration.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>
    pub fn input_processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InputProcessingConfiguration> {
        self.input_processing_configuration.as_ref()
    }
}
impl std::fmt::Debug for DiscoverInputSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiscoverInputSchemaInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "input_starting_position_configuration",
            &self.input_starting_position_configuration,
        );
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field(
            "input_processing_configuration",
            &self.input_processing_configuration,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationInput {
    /// <p>Name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
}
impl DescribeApplicationInput {
    /// <p>Name of the application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationReferenceDataSourceInput {
    /// <p>Name of an existing application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Version of the application.  
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified
    /// is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>ID of the reference data source. When you add a reference data source to your
    /// application using the
    /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID.
    /// </p>
    pub reference_id: std::option::Option<std::string::String>,
}
impl DeleteApplicationReferenceDataSourceInput {
    /// <p>Name of an existing application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Version of the application.  
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified
    /// is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>ID of the reference data source. When you add a reference data source to your
    /// application using the
    /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID.
    /// </p>
    pub fn reference_id(&self) -> std::option::Option<&str> {
        self.reference_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationReferenceDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationReferenceDataSourceInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("reference_id", &self.reference_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationOutputInput {
    /// <p>Amazon Kinesis Analytics application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Amazon Kinesis Analytics application version.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.
    /// </p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The ID of the configuration to delete.
    /// Each output configuration that is added to the application, either when the application is
    /// created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID.
    /// You need to provide the ID to uniquely identify the output configuration that you want to
    /// delete from the application configuration.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific
    /// <code>OutputId</code>.
    /// </p>
    pub output_id: std::option::Option<std::string::String>,
}
impl DeleteApplicationOutputInput {
    /// <p>Amazon Kinesis Analytics application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Amazon Kinesis Analytics application version.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.
    /// </p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The ID of the configuration to delete.
    /// Each output configuration that is added to the application, either when the application is
    /// created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID.
    /// You need to provide the ID to uniquely identify the output configuration that you want to
    /// delete from the application configuration.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific
    /// <code>OutputId</code>.
    /// </p>
    pub fn output_id(&self) -> std::option::Option<&str> {
        self.output_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationOutputInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("output_id", &self.output_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInputProcessingConfigurationInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The ID of the input configuration from which to delete the input processing
    /// configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    pub input_id: std::option::Option<std::string::String>,
}
impl DeleteApplicationInputProcessingConfigurationInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The ID of the input configuration from which to delete the input processing
    /// configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInputProcessingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInputProcessingConfigurationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("input_id", &self.input_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationCloudWatchLoggingOptionInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to
    /// delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
    pub cloud_watch_logging_option_id: std::option::Option<std::string::String>,
}
impl DeleteApplicationCloudWatchLoggingOptionInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to
    /// delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>
    pub fn cloud_watch_logging_option_id(&self) -> std::option::Option<&str> {
        self.cloud_watch_logging_option_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationCloudWatchLoggingOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationCloudWatchLoggingOptionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field(
            "cloud_watch_logging_option_id",
            &self.cloud_watch_logging_option_id,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>
    /// You can use the <code>DescribeApplication</code> operation to get this value.
    /// </p>
    pub create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteApplicationInput {
    /// <p>Name of the Amazon Kinesis Analytics application to delete.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>
    /// You can use the <code>DescribeApplication</code> operation to get this value.
    /// </p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.finish()
    }
}

/// <p>TBD</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Summary description of the application.</p>
    pub application_description: std::option::Option<std::string::String>,
    /// <p>Use this parameter to configure the application input.</p>
    /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
    /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of
    /// data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role
    /// that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
    /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
    pub inputs: std::option::Option<std::vec::Vec<crate::model::Input>>,
    /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
    /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery
    /// streams, AWS Lambda destinations, or any combination of the three.</p>
    /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the
    /// destination stream or Lambda function on your behalf.</p>
    /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format
    /// of data in the stream (for example, JSON, CSV). You also must provide an IAM role that
    /// Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>Use this parameter to configure a CloudWatch log stream to monitor application
    /// configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
    /// CloudWatch Logs</a>.</p>
    pub cloud_watch_logging_options:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOption>>,
    /// <p>One or more SQL statements that read input data, transform it, and generate output.
    /// For example, you can write a SQL statement that reads data from one in-application
    /// stream, generates a running average of the number of advertisement clicks by vendor, and
    /// insert resulting rows in another in-application stream using pumps. For more information
    /// about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
    /// Code</a>. </p>
    ///
    /// <p>You can provide such series of SQL statements,
    /// where output of one statement can be
    /// used as the input for the next statement. You store
    /// intermediate results by creating in-application streams and pumps.</p>
    ///
    /// <p>Note that the application code must create the streams with names
    /// specified in the <code>Outputs</code>. For example,
    /// if your <code>Outputs</code> defines output streams named
    /// <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>,
    /// then your application code must create these streams. </p>
    pub application_code: std::option::Option<std::string::String>,
    /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
    /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateApplicationInput {
    /// <p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Summary description of the application.</p>
    pub fn application_description(&self) -> std::option::Option<&str> {
        self.application_description.as_deref()
    }
    /// <p>Use this parameter to configure the application input.</p>
    /// <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p>
    /// <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of
    /// data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role
    /// that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p>
    /// <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>
    pub fn inputs(&self) -> std::option::Option<&[crate::model::Input]> {
        self.inputs.as_deref()
    }
    /// <p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p>
    /// <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery
    /// streams, AWS Lambda destinations, or any combination of the three.</p>
    /// <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the
    /// destination stream or Lambda function on your behalf.</p>
    /// <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format
    /// of data in the stream (for example, JSON, CSV). You also must provide an IAM role that
    /// Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>Use this parameter to configure a CloudWatch log stream to monitor application
    /// configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
    /// CloudWatch Logs</a>.</p>
    pub fn cloud_watch_logging_options(
        &self,
    ) -> std::option::Option<&[crate::model::CloudWatchLoggingOption]> {
        self.cloud_watch_logging_options.as_deref()
    }
    /// <p>One or more SQL statements that read input data, transform it, and generate output.
    /// For example, you can write a SQL statement that reads data from one in-application
    /// stream, generates a running average of the number of advertisement clicks by vendor, and
    /// insert resulting rows in another in-application stream using pumps. For more information
    /// about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
    /// Code</a>. </p>
    ///
    /// <p>You can provide such series of SQL statements,
    /// where output of one statement can be
    /// used as the input for the next statement. You store
    /// intermediate results by creating in-application streams and pumps.</p>
    ///
    /// <p>Note that the application code must create the streams with names
    /// specified in the <code>Outputs</code>. For example,
    /// if your <code>Outputs</code> defines output streams named
    /// <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>,
    /// then your application code must create these streams. </p>
    pub fn application_code(&self) -> std::option::Option<&str> {
        self.application_code.as_deref()
    }
    /// <p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
    /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field("application_description", &self.application_description);
        formatter.field("inputs", &self.inputs);
        formatter.field("outputs", &self.outputs);
        formatter.field(
            "cloud_watch_logging_options",
            &self.cloud_watch_logging_options,
        );
        formatter.field("application_code", &self.application_code);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddApplicationReferenceDataSourceInput {
    /// <p>Name of an existing application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Version of the application for which you are adding the reference data source.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
    pub reference_data_source: std::option::Option<crate::model::ReferenceDataSource>,
}
impl AddApplicationReferenceDataSourceInput {
    /// <p>Name of an existing application.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Version of the application for which you are adding the reference data source.
    /// You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version.
    /// If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>
    pub fn reference_data_source(&self) -> std::option::Option<&crate::model::ReferenceDataSource> {
        self.reference_data_source.as_ref()
    }
}
impl std::fmt::Debug for AddApplicationReferenceDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddApplicationReferenceDataSourceInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("reference_data_source", &self.reference_data_source);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddApplicationOutputInput {
    /// <p>Name of the application to which you want to add the output configuration.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Version of the application to which you want to add the output configuration. You
    /// can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current
    /// application version. If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned. </p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>An array of objects, each describing one output configuration. In the output
    /// configuration, you specify the name of an in-application stream, a destination (that is,
    /// an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
    /// function), and record the formation to use when writing to the destination.</p>
    pub output: std::option::Option<crate::model::Output>,
}
impl AddApplicationOutputInput {
    /// <p>Name of the application to which you want to add the output configuration.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Version of the application to which you want to add the output configuration. You
    /// can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current
    /// application version. If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned. </p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>An array of objects, each describing one output configuration. In the output
    /// configuration, you specify the name of an in-application stream, a destination (that is,
    /// an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
    /// function), and record the formation to use when writing to the destination.</p>
    pub fn output(&self) -> std::option::Option<&crate::model::Output> {
        self.output.as_ref()
    }
}
impl std::fmt::Debug for AddApplicationOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddApplicationOutputInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("output", &self.output);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddApplicationInputProcessingConfigurationInput {
    /// <p>Name of the application to which you want to add the input processing configuration.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>
    /// operation to get the current application version.  If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The ID of the input configuration to add the input processing configuration to. You
    /// can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    pub input_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
    pub input_processing_configuration:
        std::option::Option<crate::model::InputProcessingConfiguration>,
}
impl AddApplicationInputProcessingConfigurationInput {
    /// <p>Name of the application to which you want to add the input processing configuration.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>
    /// operation to get the current application version.  If the version specified is not the current version, the
    /// <code>ConcurrentModificationException</code> is returned.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The ID of the input configuration to add the input processing configuration to. You
    /// can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    pub fn input_id(&self) -> std::option::Option<&str> {
        self.input_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>
    pub fn input_processing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InputProcessingConfiguration> {
        self.input_processing_configuration.as_ref()
    }
}
impl std::fmt::Debug for AddApplicationInputProcessingConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddApplicationInputProcessingConfigurationInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("input_id", &self.input_id);
        formatter.field(
            "input_processing_configuration",
            &self.input_processing_configuration,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddApplicationInputInput {
    /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation
    /// to find the current application version.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
    pub input: std::option::Option<crate::model::Input>,
}
impl AddApplicationInputInput {
    /// <p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation
    /// to find the current application version.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::Input> {
        self.input.as_ref()
    }
}
impl std::fmt::Debug for AddApplicationInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddApplicationInputInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field("input", &self.input);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddApplicationCloudWatchLoggingOptionInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub current_application_version_id: std::option::Option<i64>,
    /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN.
    /// Note: To write application messages to CloudWatch, the IAM role that is used must have
    /// the <code>PutLogEvents</code> policy action enabled.</p>
    pub cloud_watch_logging_option: std::option::Option<crate::model::CloudWatchLoggingOption>,
}
impl AddApplicationCloudWatchLoggingOptionInput {
    /// <p>The Kinesis Analytics application name.</p>
    pub fn application_name(&self) -> std::option::Option<&str> {
        self.application_name.as_deref()
    }
    /// <p>The version ID of the Kinesis Analytics application.</p>
    pub fn current_application_version_id(&self) -> std::option::Option<i64> {
        self.current_application_version_id
    }
    /// <p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN.
    /// Note: To write application messages to CloudWatch, the IAM role that is used must have
    /// the <code>PutLogEvents</code> policy action enabled.</p>
    pub fn cloud_watch_logging_option(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLoggingOption> {
        self.cloud_watch_logging_option.as_ref()
    }
}
impl std::fmt::Debug for AddApplicationCloudWatchLoggingOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddApplicationCloudWatchLoggingOptionInput");
        formatter.field("application_name", &self.application_name);
        formatter.field(
            "current_application_version_id",
            &self.current_application_version_id,
        );
        formatter.field(
            "cloud_watch_logging_option",
            &self.cloud_watch_logging_option,
        );
        formatter.finish()
    }
}
