// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes updates to apply to an existing Amazon Kinesis Analytics application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationUpdate {
    /// <p>Describes application input configuration updates.</p>
    pub input_updates: std::option::Option<std::vec::Vec<crate::model::InputUpdate>>,
    /// <p>Describes application code updates.</p>
    pub application_code_update: std::option::Option<std::string::String>,
    /// <p>Describes application output configuration updates.</p>
    pub output_updates: std::option::Option<std::vec::Vec<crate::model::OutputUpdate>>,
    /// <p>Describes application reference data source updates.</p>
    pub reference_data_source_updates:
        std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceUpdate>>,
    /// <p>Describes application CloudWatch logging option updates.</p>
    pub cloud_watch_logging_option_updates:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOptionUpdate>>,
}
impl std::fmt::Debug for ApplicationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationUpdate");
        formatter.field("input_updates", &self.input_updates);
        formatter.field("application_code_update", &self.application_code_update);
        formatter.field("output_updates", &self.output_updates);
        formatter.field(
            "reference_data_source_updates",
            &self.reference_data_source_updates,
        );
        formatter.field(
            "cloud_watch_logging_option_updates",
            &self.cloud_watch_logging_option_updates,
        );
        formatter.finish()
    }
}
/// See [`ApplicationUpdate`](crate::model::ApplicationUpdate)
pub mod application_update {
    /// A builder for [`ApplicationUpdate`](crate::model::ApplicationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_updates: std::option::Option<std::vec::Vec<crate::model::InputUpdate>>,
        pub(crate) application_code_update: std::option::Option<std::string::String>,
        pub(crate) output_updates: std::option::Option<std::vec::Vec<crate::model::OutputUpdate>>,
        pub(crate) reference_data_source_updates:
            std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceUpdate>>,
        pub(crate) cloud_watch_logging_option_updates:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOptionUpdate>>,
    }
    impl Builder {
        /// Appends an item to `input_updates`.
        ///
        /// To override the contents of this collection use [`set_input_updates`](Self::set_input_updates).
        ///
        /// <p>Describes application input configuration updates.</p>
        pub fn input_updates(mut self, input: impl Into<crate::model::InputUpdate>) -> Self {
            let mut v = self.input_updates.unwrap_or_default();
            v.push(input.into());
            self.input_updates = Some(v);
            self
        }
        /// <p>Describes application input configuration updates.</p>
        pub fn set_input_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputUpdate>>,
        ) -> Self {
            self.input_updates = input;
            self
        }
        /// <p>Describes application code updates.</p>
        pub fn application_code_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_code_update = Some(input.into());
            self
        }
        /// <p>Describes application code updates.</p>
        pub fn set_application_code_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_code_update = input;
            self
        }
        /// Appends an item to `output_updates`.
        ///
        /// To override the contents of this collection use [`set_output_updates`](Self::set_output_updates).
        ///
        /// <p>Describes application output configuration updates.</p>
        pub fn output_updates(mut self, input: impl Into<crate::model::OutputUpdate>) -> Self {
            let mut v = self.output_updates.unwrap_or_default();
            v.push(input.into());
            self.output_updates = Some(v);
            self
        }
        /// <p>Describes application output configuration updates.</p>
        pub fn set_output_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputUpdate>>,
        ) -> Self {
            self.output_updates = input;
            self
        }
        /// Appends an item to `reference_data_source_updates`.
        ///
        /// To override the contents of this collection use [`set_reference_data_source_updates`](Self::set_reference_data_source_updates).
        ///
        /// <p>Describes application reference data source updates.</p>
        pub fn reference_data_source_updates(
            mut self,
            input: impl Into<crate::model::ReferenceDataSourceUpdate>,
        ) -> Self {
            let mut v = self.reference_data_source_updates.unwrap_or_default();
            v.push(input.into());
            self.reference_data_source_updates = Some(v);
            self
        }
        /// <p>Describes application reference data source updates.</p>
        pub fn set_reference_data_source_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceUpdate>>,
        ) -> Self {
            self.reference_data_source_updates = input;
            self
        }
        /// Appends an item to `cloud_watch_logging_option_updates`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_logging_option_updates`](Self::set_cloud_watch_logging_option_updates).
        ///
        /// <p>Describes application CloudWatch logging option updates.</p>
        pub fn cloud_watch_logging_option_updates(
            mut self,
            input: impl Into<crate::model::CloudWatchLoggingOptionUpdate>,
        ) -> Self {
            let mut v = self.cloud_watch_logging_option_updates.unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_logging_option_updates = Some(v);
            self
        }
        /// <p>Describes application CloudWatch logging option updates.</p>
        pub fn set_cloud_watch_logging_option_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOptionUpdate>>,
        ) -> Self {
            self.cloud_watch_logging_option_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationUpdate`](crate::model::ApplicationUpdate)
        pub fn build(self) -> crate::model::ApplicationUpdate {
            crate::model::ApplicationUpdate {
                input_updates: self.input_updates,
                application_code_update: self.application_code_update,
                output_updates: self.output_updates,
                reference_data_source_updates: self.reference_data_source_updates,
                cloud_watch_logging_option_updates: self.cloud_watch_logging_option_updates,
            }
        }
    }
}
impl ApplicationUpdate {
    /// Creates a new builder-style object to manufacture [`ApplicationUpdate`](crate::model::ApplicationUpdate)
    pub fn builder() -> crate::model::application_update::Builder {
        crate::model::application_update::Builder::default()
    }
}

/// <p>Describes CloudWatch logging option updates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLoggingOptionUpdate {
    /// <p>ID of the CloudWatch logging option to update</p>
    pub cloud_watch_logging_option_id: std::option::Option<std::string::String>,
    /// <p>ARN of the CloudWatch log to receive application messages.</p>
    pub log_stream_arn_update: std::option::Option<std::string::String>,
    /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchLoggingOptionUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLoggingOptionUpdate");
        formatter.field(
            "cloud_watch_logging_option_id",
            &self.cloud_watch_logging_option_id,
        );
        formatter.field("log_stream_arn_update", &self.log_stream_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`CloudWatchLoggingOptionUpdate`](crate::model::CloudWatchLoggingOptionUpdate)
pub mod cloud_watch_logging_option_update {
    /// A builder for [`CloudWatchLoggingOptionUpdate`](crate::model::CloudWatchLoggingOptionUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logging_option_id: std::option::Option<std::string::String>,
        pub(crate) log_stream_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the CloudWatch logging option to update</p>
        pub fn cloud_watch_logging_option_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = Some(input.into());
            self
        }
        /// <p>ID of the CloudWatch logging option to update</p>
        pub fn set_cloud_watch_logging_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = input;
            self
        }
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn log_stream_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn set_log_stream_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_arn_update = input;
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLoggingOptionUpdate`](crate::model::CloudWatchLoggingOptionUpdate)
        pub fn build(self) -> crate::model::CloudWatchLoggingOptionUpdate {
            crate::model::CloudWatchLoggingOptionUpdate {
                cloud_watch_logging_option_id: self.cloud_watch_logging_option_id,
                log_stream_arn_update: self.log_stream_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl CloudWatchLoggingOptionUpdate {
    /// Creates a new builder-style object to manufacture [`CloudWatchLoggingOptionUpdate`](crate::model::CloudWatchLoggingOptionUpdate)
    pub fn builder() -> crate::model::cloud_watch_logging_option_update::Builder {
        crate::model::cloud_watch_logging_option_update::Builder::default()
    }
}

/// <p>When you update a reference data source configuration for an application, this object provides all the updated values (such as the source bucket name and object key name), the in-application table name that is created, and updated mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferenceDataSourceUpdate {
    /// <p>ID of the reference data source being updated. You can use the
    /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>In-application table name that is created by this update.</p>
    pub table_name_update: std::option::Option<std::string::String>,
    /// <p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>
    pub s3_reference_data_source_update:
        std::option::Option<crate::model::S3ReferenceDataSourceUpdate>,
    /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. </p>
    pub reference_schema_update: std::option::Option<crate::model::SourceSchema>,
}
impl std::fmt::Debug for ReferenceDataSourceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferenceDataSourceUpdate");
        formatter.field("reference_id", &self.reference_id);
        formatter.field("table_name_update", &self.table_name_update);
        formatter.field(
            "s3_reference_data_source_update",
            &self.s3_reference_data_source_update,
        );
        formatter.field("reference_schema_update", &self.reference_schema_update);
        formatter.finish()
    }
}
/// See [`ReferenceDataSourceUpdate`](crate::model::ReferenceDataSourceUpdate)
pub mod reference_data_source_update {
    /// A builder for [`ReferenceDataSourceUpdate`](crate::model::ReferenceDataSourceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) table_name_update: std::option::Option<std::string::String>,
        pub(crate) s3_reference_data_source_update:
            std::option::Option<crate::model::S3ReferenceDataSourceUpdate>,
        pub(crate) reference_schema_update: std::option::Option<crate::model::SourceSchema>,
    }
    impl Builder {
        /// <p>ID of the reference data source being updated. You can use the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>ID of the reference data source being updated. You can use the
        /// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>In-application table name that is created by this update.</p>
        pub fn table_name_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name_update = Some(input.into());
            self
        }
        /// <p>In-application table name that is created by this update.</p>
        pub fn set_table_name_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_name_update = input;
            self
        }
        /// <p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>
        pub fn s3_reference_data_source_update(
            mut self,
            input: crate::model::S3ReferenceDataSourceUpdate,
        ) -> Self {
            self.s3_reference_data_source_update = Some(input);
            self
        }
        /// <p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>
        pub fn set_s3_reference_data_source_update(
            mut self,
            input: std::option::Option<crate::model::S3ReferenceDataSourceUpdate>,
        ) -> Self {
            self.s3_reference_data_source_update = input;
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. </p>
        pub fn reference_schema_update(mut self, input: crate::model::SourceSchema) -> Self {
            self.reference_schema_update = Some(input);
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. </p>
        pub fn set_reference_schema_update(
            mut self,
            input: std::option::Option<crate::model::SourceSchema>,
        ) -> Self {
            self.reference_schema_update = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferenceDataSourceUpdate`](crate::model::ReferenceDataSourceUpdate)
        pub fn build(self) -> crate::model::ReferenceDataSourceUpdate {
            crate::model::ReferenceDataSourceUpdate {
                reference_id: self.reference_id,
                table_name_update: self.table_name_update,
                s3_reference_data_source_update: self.s3_reference_data_source_update,
                reference_schema_update: self.reference_schema_update,
            }
        }
    }
}
impl ReferenceDataSourceUpdate {
    /// Creates a new builder-style object to manufacture [`ReferenceDataSourceUpdate`](crate::model::ReferenceDataSourceUpdate)
    pub fn builder() -> crate::model::reference_data_source_update::Builder {
        crate::model::reference_data_source_update::Builder::default()
    }
}

/// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceSchema {
    /// <p>Specifies the format of the records on the streaming source.</p>
    pub record_format: std::option::Option<crate::model::RecordFormat>,
    /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
    pub record_encoding: std::option::Option<std::string::String>,
    /// <p>A list of <code>RecordColumn</code> objects.</p>
    pub record_columns: std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
}
impl std::fmt::Debug for SourceSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceSchema");
        formatter.field("record_format", &self.record_format);
        formatter.field("record_encoding", &self.record_encoding);
        formatter.field("record_columns", &self.record_columns);
        formatter.finish()
    }
}
/// See [`SourceSchema`](crate::model::SourceSchema)
pub mod source_schema {
    /// A builder for [`SourceSchema`](crate::model::SourceSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_format: std::option::Option<crate::model::RecordFormat>,
        pub(crate) record_encoding: std::option::Option<std::string::String>,
        pub(crate) record_columns: std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
    }
    impl Builder {
        /// <p>Specifies the format of the records on the streaming source.</p>
        pub fn record_format(mut self, input: crate::model::RecordFormat) -> Self {
            self.record_format = Some(input);
            self
        }
        /// <p>Specifies the format of the records on the streaming source.</p>
        pub fn set_record_format(
            mut self,
            input: std::option::Option<crate::model::RecordFormat>,
        ) -> Self {
            self.record_format = input;
            self
        }
        /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
        pub fn record_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_encoding = Some(input.into());
            self
        }
        /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
        pub fn set_record_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_encoding = input;
            self
        }
        /// Appends an item to `record_columns`.
        ///
        /// To override the contents of this collection use [`set_record_columns`](Self::set_record_columns).
        ///
        /// <p>A list of <code>RecordColumn</code> objects.</p>
        pub fn record_columns(mut self, input: impl Into<crate::model::RecordColumn>) -> Self {
            let mut v = self.record_columns.unwrap_or_default();
            v.push(input.into());
            self.record_columns = Some(v);
            self
        }
        /// <p>A list of <code>RecordColumn</code> objects.</p>
        pub fn set_record_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
        ) -> Self {
            self.record_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceSchema`](crate::model::SourceSchema)
        pub fn build(self) -> crate::model::SourceSchema {
            crate::model::SourceSchema {
                record_format: self.record_format,
                record_encoding: self.record_encoding,
                record_columns: self.record_columns,
            }
        }
    }
}
impl SourceSchema {
    /// Creates a new builder-style object to manufacture [`SourceSchema`](crate::model::SourceSchema)
    pub fn builder() -> crate::model::source_schema::Builder {
        crate::model::source_schema::Builder::default()
    }
}

/// <p>Describes the mapping of each data element in the streaming
/// source to the corresponding column in the in-application stream.</p>
/// <p>Also used to describe the format of the reference data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordColumn {
    /// <p>Name of the column created in the in-application input stream or reference table.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Reference to the data element in the streaming input or the reference data source. This element
    /// is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code>.</p>
    pub mapping: std::option::Option<std::string::String>,
    /// <p>Type of column created in the in-application input stream or reference table.</p>
    pub sql_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RecordColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordColumn");
        formatter.field("name", &self.name);
        formatter.field("mapping", &self.mapping);
        formatter.field("sql_type", &self.sql_type);
        formatter.finish()
    }
}
/// See [`RecordColumn`](crate::model::RecordColumn)
pub mod record_column {
    /// A builder for [`RecordColumn`](crate::model::RecordColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mapping: std::option::Option<std::string::String>,
        pub(crate) sql_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the column created in the in-application input stream or reference table.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the column created in the in-application input stream or reference table.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Reference to the data element in the streaming input or the reference data source. This element
        /// is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code>.</p>
        pub fn mapping(mut self, input: impl Into<std::string::String>) -> Self {
            self.mapping = Some(input.into());
            self
        }
        /// <p>Reference to the data element in the streaming input or the reference data source. This element
        /// is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code>.</p>
        pub fn set_mapping(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mapping = input;
            self
        }
        /// <p>Type of column created in the in-application input stream or reference table.</p>
        pub fn sql_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_type = Some(input.into());
            self
        }
        /// <p>Type of column created in the in-application input stream or reference table.</p>
        pub fn set_sql_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordColumn`](crate::model::RecordColumn)
        pub fn build(self) -> crate::model::RecordColumn {
            crate::model::RecordColumn {
                name: self.name,
                mapping: self.mapping,
                sql_type: self.sql_type,
            }
        }
    }
}
impl RecordColumn {
    /// Creates a new builder-style object to manufacture [`RecordColumn`](crate::model::RecordColumn)
    pub fn builder() -> crate::model::record_column::Builder {
        crate::model::record_column::Builder::default()
    }
}

/// <p>
/// Describes the record format and relevant mapping information that
/// should be applied to schematize the records on the stream.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordFormat {
    /// <p>The type of record format.</p>
    pub record_format_type: std::option::Option<crate::model::RecordFormatType>,
    /// <p>When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.</p>
    pub mapping_parameters: std::option::Option<crate::model::MappingParameters>,
}
impl std::fmt::Debug for RecordFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordFormat");
        formatter.field("record_format_type", &self.record_format_type);
        formatter.field("mapping_parameters", &self.mapping_parameters);
        formatter.finish()
    }
}
/// See [`RecordFormat`](crate::model::RecordFormat)
pub mod record_format {
    /// A builder for [`RecordFormat`](crate::model::RecordFormat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_format_type: std::option::Option<crate::model::RecordFormatType>,
        pub(crate) mapping_parameters: std::option::Option<crate::model::MappingParameters>,
    }
    impl Builder {
        /// <p>The type of record format.</p>
        pub fn record_format_type(mut self, input: crate::model::RecordFormatType) -> Self {
            self.record_format_type = Some(input);
            self
        }
        /// <p>The type of record format.</p>
        pub fn set_record_format_type(
            mut self,
            input: std::option::Option<crate::model::RecordFormatType>,
        ) -> Self {
            self.record_format_type = input;
            self
        }
        /// <p>When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.</p>
        pub fn mapping_parameters(mut self, input: crate::model::MappingParameters) -> Self {
            self.mapping_parameters = Some(input);
            self
        }
        /// <p>When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.</p>
        pub fn set_mapping_parameters(
            mut self,
            input: std::option::Option<crate::model::MappingParameters>,
        ) -> Self {
            self.mapping_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordFormat`](crate::model::RecordFormat)
        pub fn build(self) -> crate::model::RecordFormat {
            crate::model::RecordFormat {
                record_format_type: self.record_format_type,
                mapping_parameters: self.mapping_parameters,
            }
        }
    }
}
impl RecordFormat {
    /// Creates a new builder-style object to manufacture [`RecordFormat`](crate::model::RecordFormat)
    pub fn builder() -> crate::model::record_format::Builder {
        crate::model::record_format::Builder::default()
    }
}

/// <p>When configuring application input
/// at the time of creating or updating an application,
/// provides additional mapping information specific to
/// the record format (such as JSON, CSV, or record fields delimited
/// by some delimiter) on the streaming source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MappingParameters {
    /// <p>Provides additional mapping information when JSON is the record format on the streaming source.</p>
    pub json_mapping_parameters: std::option::Option<crate::model::JsonMappingParameters>,
    /// <p>Provides additional mapping information when the record format uses delimiters
    /// (for example, CSV).</p>
    pub csv_mapping_parameters: std::option::Option<crate::model::CsvMappingParameters>,
}
impl std::fmt::Debug for MappingParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MappingParameters");
        formatter.field("json_mapping_parameters", &self.json_mapping_parameters);
        formatter.field("csv_mapping_parameters", &self.csv_mapping_parameters);
        formatter.finish()
    }
}
/// See [`MappingParameters`](crate::model::MappingParameters)
pub mod mapping_parameters {
    /// A builder for [`MappingParameters`](crate::model::MappingParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json_mapping_parameters:
            std::option::Option<crate::model::JsonMappingParameters>,
        pub(crate) csv_mapping_parameters: std::option::Option<crate::model::CsvMappingParameters>,
    }
    impl Builder {
        /// <p>Provides additional mapping information when JSON is the record format on the streaming source.</p>
        pub fn json_mapping_parameters(
            mut self,
            input: crate::model::JsonMappingParameters,
        ) -> Self {
            self.json_mapping_parameters = Some(input);
            self
        }
        /// <p>Provides additional mapping information when JSON is the record format on the streaming source.</p>
        pub fn set_json_mapping_parameters(
            mut self,
            input: std::option::Option<crate::model::JsonMappingParameters>,
        ) -> Self {
            self.json_mapping_parameters = input;
            self
        }
        /// <p>Provides additional mapping information when the record format uses delimiters
        /// (for example, CSV).</p>
        pub fn csv_mapping_parameters(mut self, input: crate::model::CsvMappingParameters) -> Self {
            self.csv_mapping_parameters = Some(input);
            self
        }
        /// <p>Provides additional mapping information when the record format uses delimiters
        /// (for example, CSV).</p>
        pub fn set_csv_mapping_parameters(
            mut self,
            input: std::option::Option<crate::model::CsvMappingParameters>,
        ) -> Self {
            self.csv_mapping_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`MappingParameters`](crate::model::MappingParameters)
        pub fn build(self) -> crate::model::MappingParameters {
            crate::model::MappingParameters {
                json_mapping_parameters: self.json_mapping_parameters,
                csv_mapping_parameters: self.csv_mapping_parameters,
            }
        }
    }
}
impl MappingParameters {
    /// Creates a new builder-style object to manufacture [`MappingParameters`](crate::model::MappingParameters)
    pub fn builder() -> crate::model::mapping_parameters::Builder {
        crate::model::mapping_parameters::Builder::default()
    }
}

/// <p>Provides additional mapping information when the record format
/// uses delimiters, such as CSV. For example, the following sample records
/// use CSV format, where the records use the <i>'\n'</i> as the row delimiter and a comma (",") as the column delimiter:
/// </p>
///
/// <p>
/// <code>"name1", "address1"</code>
/// </p>
/// <p>
/// <code>"name2", "address2"</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvMappingParameters {
    /// <p>Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.</p>
    pub record_row_delimiter: std::option::Option<std::string::String>,
    /// <p>Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.</p>
    pub record_column_delimiter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CsvMappingParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvMappingParameters");
        formatter.field("record_row_delimiter", &self.record_row_delimiter);
        formatter.field("record_column_delimiter", &self.record_column_delimiter);
        formatter.finish()
    }
}
/// See [`CsvMappingParameters`](crate::model::CsvMappingParameters)
pub mod csv_mapping_parameters {
    /// A builder for [`CsvMappingParameters`](crate::model::CsvMappingParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_row_delimiter: std::option::Option<std::string::String>,
        pub(crate) record_column_delimiter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.</p>
        pub fn record_row_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_row_delimiter = Some(input.into());
            self
        }
        /// <p>Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.</p>
        pub fn set_record_row_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_row_delimiter = input;
            self
        }
        /// <p>Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.</p>
        pub fn record_column_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_column_delimiter = Some(input.into());
            self
        }
        /// <p>Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.</p>
        pub fn set_record_column_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_column_delimiter = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvMappingParameters`](crate::model::CsvMappingParameters)
        pub fn build(self) -> crate::model::CsvMappingParameters {
            crate::model::CsvMappingParameters {
                record_row_delimiter: self.record_row_delimiter,
                record_column_delimiter: self.record_column_delimiter,
            }
        }
    }
}
impl CsvMappingParameters {
    /// Creates a new builder-style object to manufacture [`CsvMappingParameters`](crate::model::CsvMappingParameters)
    pub fn builder() -> crate::model::csv_mapping_parameters::Builder {
        crate::model::csv_mapping_parameters::Builder::default()
    }
}

/// <p>Provides additional mapping information when JSON is the record format on the streaming source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonMappingParameters {
    /// <p>Path to the top-level parent that contains the records.</p>
    pub record_row_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JsonMappingParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonMappingParameters");
        formatter.field("record_row_path", &self.record_row_path);
        formatter.finish()
    }
}
/// See [`JsonMappingParameters`](crate::model::JsonMappingParameters)
pub mod json_mapping_parameters {
    /// A builder for [`JsonMappingParameters`](crate::model::JsonMappingParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_row_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Path to the top-level parent that contains the records.</p>
        pub fn record_row_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_row_path = Some(input.into());
            self
        }
        /// <p>Path to the top-level parent that contains the records.</p>
        pub fn set_record_row_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_row_path = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonMappingParameters`](crate::model::JsonMappingParameters)
        pub fn build(self) -> crate::model::JsonMappingParameters {
            crate::model::JsonMappingParameters {
                record_row_path: self.record_row_path,
            }
        }
    }
}
impl JsonMappingParameters {
    /// Creates a new builder-style object to manufacture [`JsonMappingParameters`](crate::model::JsonMappingParameters)
    pub fn builder() -> crate::model::json_mapping_parameters::Builder {
        crate::model::json_mapping_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordFormatType {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordFormatType {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => RecordFormatType::Csv,
            "JSON" => RecordFormatType::Json,
            other => RecordFormatType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordFormatType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordFormatType::from(s))
    }
}
impl RecordFormatType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordFormatType::Csv => "CSV",
            RecordFormatType::Json => "JSON",
            RecordFormatType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for RecordFormatType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ReferenceDataSourceUpdate {
    /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
    pub bucket_arn_update: std::option::Option<std::string::String>,
    /// <p>Object key name.</p>
    pub file_key_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application.</p>
    pub reference_role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3ReferenceDataSourceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ReferenceDataSourceUpdate");
        formatter.field("bucket_arn_update", &self.bucket_arn_update);
        formatter.field("file_key_update", &self.file_key_update);
        formatter.field("reference_role_arn_update", &self.reference_role_arn_update);
        formatter.finish()
    }
}
/// See [`S3ReferenceDataSourceUpdate`](crate::model::S3ReferenceDataSourceUpdate)
pub mod s3_reference_data_source_update {
    /// A builder for [`S3ReferenceDataSourceUpdate`](crate::model::S3ReferenceDataSourceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn_update: std::option::Option<std::string::String>,
        pub(crate) file_key_update: std::option::Option<std::string::String>,
        pub(crate) reference_role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn bucket_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn set_bucket_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_arn_update = input;
            self
        }
        /// <p>Object key name.</p>
        pub fn file_key_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key_update = Some(input.into());
            self
        }
        /// <p>Object key name.</p>
        pub fn set_file_key_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_key_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application.</p>
        pub fn reference_role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application.</p>
        pub fn set_reference_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reference_role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ReferenceDataSourceUpdate`](crate::model::S3ReferenceDataSourceUpdate)
        pub fn build(self) -> crate::model::S3ReferenceDataSourceUpdate {
            crate::model::S3ReferenceDataSourceUpdate {
                bucket_arn_update: self.bucket_arn_update,
                file_key_update: self.file_key_update,
                reference_role_arn_update: self.reference_role_arn_update,
            }
        }
    }
}
impl S3ReferenceDataSourceUpdate {
    /// Creates a new builder-style object to manufacture [`S3ReferenceDataSourceUpdate`](crate::model::S3ReferenceDataSourceUpdate)
    pub fn builder() -> crate::model::s3_reference_data_source_update::Builder {
        crate::model::s3_reference_data_source_update::Builder::default()
    }
}

/// <p>
/// Describes updates to the output configuration identified by
/// the <code>OutputId</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputUpdate {
    /// <p>Identifies the specific output configuration that you want to update.</p>
    pub output_id: std::option::Option<std::string::String>,
    /// <p>If you want to specify a different in-application stream
    /// for this output configuration, use this field to
    /// specify the new in-application stream name.</p>
    pub name_update: std::option::Option<std::string::String>,
    /// <p>Describes an Amazon Kinesis stream as the destination for the output.</p>
    pub kinesis_streams_output_update:
        std::option::Option<crate::model::KinesisStreamsOutputUpdate>,
    /// <p>Describes an Amazon Kinesis Firehose delivery stream as the destination for the
    /// output.</p>
    pub kinesis_firehose_output_update:
        std::option::Option<crate::model::KinesisFirehoseOutputUpdate>,
    /// <p>Describes an AWS Lambda function as the destination for the output.</p>
    pub lambda_output_update: std::option::Option<crate::model::LambdaOutputUpdate>,
    /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
    pub destination_schema_update: std::option::Option<crate::model::DestinationSchema>,
}
impl std::fmt::Debug for OutputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputUpdate");
        formatter.field("output_id", &self.output_id);
        formatter.field("name_update", &self.name_update);
        formatter.field(
            "kinesis_streams_output_update",
            &self.kinesis_streams_output_update,
        );
        formatter.field(
            "kinesis_firehose_output_update",
            &self.kinesis_firehose_output_update,
        );
        formatter.field("lambda_output_update", &self.lambda_output_update);
        formatter.field("destination_schema_update", &self.destination_schema_update);
        formatter.finish()
    }
}
/// See [`OutputUpdate`](crate::model::OutputUpdate)
pub mod output_update {
    /// A builder for [`OutputUpdate`](crate::model::OutputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_id: std::option::Option<std::string::String>,
        pub(crate) name_update: std::option::Option<std::string::String>,
        pub(crate) kinesis_streams_output_update:
            std::option::Option<crate::model::KinesisStreamsOutputUpdate>,
        pub(crate) kinesis_firehose_output_update:
            std::option::Option<crate::model::KinesisFirehoseOutputUpdate>,
        pub(crate) lambda_output_update: std::option::Option<crate::model::LambdaOutputUpdate>,
        pub(crate) destination_schema_update: std::option::Option<crate::model::DestinationSchema>,
    }
    impl Builder {
        /// <p>Identifies the specific output configuration that you want to update.</p>
        pub fn output_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_id = Some(input.into());
            self
        }
        /// <p>Identifies the specific output configuration that you want to update.</p>
        pub fn set_output_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_id = input;
            self
        }
        /// <p>If you want to specify a different in-application stream
        /// for this output configuration, use this field to
        /// specify the new in-application stream name.</p>
        pub fn name_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_update = Some(input.into());
            self
        }
        /// <p>If you want to specify a different in-application stream
        /// for this output configuration, use this field to
        /// specify the new in-application stream name.</p>
        pub fn set_name_update(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_update = input;
            self
        }
        /// <p>Describes an Amazon Kinesis stream as the destination for the output.</p>
        pub fn kinesis_streams_output_update(
            mut self,
            input: crate::model::KinesisStreamsOutputUpdate,
        ) -> Self {
            self.kinesis_streams_output_update = Some(input);
            self
        }
        /// <p>Describes an Amazon Kinesis stream as the destination for the output.</p>
        pub fn set_kinesis_streams_output_update(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsOutputUpdate>,
        ) -> Self {
            self.kinesis_streams_output_update = input;
            self
        }
        /// <p>Describes an Amazon Kinesis Firehose delivery stream as the destination for the
        /// output.</p>
        pub fn kinesis_firehose_output_update(
            mut self,
            input: crate::model::KinesisFirehoseOutputUpdate,
        ) -> Self {
            self.kinesis_firehose_output_update = Some(input);
            self
        }
        /// <p>Describes an Amazon Kinesis Firehose delivery stream as the destination for the
        /// output.</p>
        pub fn set_kinesis_firehose_output_update(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseOutputUpdate>,
        ) -> Self {
            self.kinesis_firehose_output_update = input;
            self
        }
        /// <p>Describes an AWS Lambda function as the destination for the output.</p>
        pub fn lambda_output_update(mut self, input: crate::model::LambdaOutputUpdate) -> Self {
            self.lambda_output_update = Some(input);
            self
        }
        /// <p>Describes an AWS Lambda function as the destination for the output.</p>
        pub fn set_lambda_output_update(
            mut self,
            input: std::option::Option<crate::model::LambdaOutputUpdate>,
        ) -> Self {
            self.lambda_output_update = input;
            self
        }
        /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
        pub fn destination_schema_update(mut self, input: crate::model::DestinationSchema) -> Self {
            self.destination_schema_update = Some(input);
            self
        }
        /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
        pub fn set_destination_schema_update(
            mut self,
            input: std::option::Option<crate::model::DestinationSchema>,
        ) -> Self {
            self.destination_schema_update = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputUpdate`](crate::model::OutputUpdate)
        pub fn build(self) -> crate::model::OutputUpdate {
            crate::model::OutputUpdate {
                output_id: self.output_id,
                name_update: self.name_update,
                kinesis_streams_output_update: self.kinesis_streams_output_update,
                kinesis_firehose_output_update: self.kinesis_firehose_output_update,
                lambda_output_update: self.lambda_output_update,
                destination_schema_update: self.destination_schema_update,
            }
        }
    }
}
impl OutputUpdate {
    /// Creates a new builder-style object to manufacture [`OutputUpdate`](crate::model::OutputUpdate)
    pub fn builder() -> crate::model::output_update::Builder {
        crate::model::output_update::Builder::default()
    }
}

/// <p>Describes the data format when records are written to the destination.
/// For more information,
/// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.
///
///
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationSchema {
    /// <p>Specifies the format of the records on the output stream.</p>
    pub record_format_type: std::option::Option<crate::model::RecordFormatType>,
}
impl std::fmt::Debug for DestinationSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationSchema");
        formatter.field("record_format_type", &self.record_format_type);
        formatter.finish()
    }
}
/// See [`DestinationSchema`](crate::model::DestinationSchema)
pub mod destination_schema {
    /// A builder for [`DestinationSchema`](crate::model::DestinationSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_format_type: std::option::Option<crate::model::RecordFormatType>,
    }
    impl Builder {
        /// <p>Specifies the format of the records on the output stream.</p>
        pub fn record_format_type(mut self, input: crate::model::RecordFormatType) -> Self {
            self.record_format_type = Some(input);
            self
        }
        /// <p>Specifies the format of the records on the output stream.</p>
        pub fn set_record_format_type(
            mut self,
            input: std::option::Option<crate::model::RecordFormatType>,
        ) -> Self {
            self.record_format_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationSchema`](crate::model::DestinationSchema)
        pub fn build(self) -> crate::model::DestinationSchema {
            crate::model::DestinationSchema {
                record_format_type: self.record_format_type,
            }
        }
    }
}
impl DestinationSchema {
    /// Creates a new builder-style object to manufacture [`DestinationSchema`](crate::model::DestinationSchema)
    pub fn builder() -> crate::model::destination_schema::Builder {
        crate::model::destination_schema::Builder::default()
    }
}

/// <p>When updating an output configuration using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a>
/// operation, provides information about an AWS Lambda function configured as the
/// destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaOutputUpdate {
    /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
    /// <note>
    /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
    /// </p>
    /// </note>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LambdaOutputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaOutputUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`LambdaOutputUpdate`](crate::model::LambdaOutputUpdate)
pub mod lambda_output_update {
    /// A builder for [`LambdaOutputUpdate`](crate::model::LambdaOutputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaOutputUpdate`](crate::model::LambdaOutputUpdate)
        pub fn build(self) -> crate::model::LambdaOutputUpdate {
            crate::model::LambdaOutputUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl LambdaOutputUpdate {
    /// Creates a new builder-style object to manufacture [`LambdaOutputUpdate`](crate::model::LambdaOutputUpdate)
    pub fn builder() -> crate::model::lambda_output_update::Builder {
        crate::model::lambda_output_update::Builder::default()
    }
}

/// <p>
/// When updating an output configuration using the
/// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation,
/// provides information about an Amazon Kinesis Firehose delivery stream configured as
/// the destination.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseOutputUpdate {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.</p>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
    /// on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseOutputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseOutputUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseOutputUpdate`](crate::model::KinesisFirehoseOutputUpdate)
pub mod kinesis_firehose_output_update {
    /// A builder for [`KinesisFirehoseOutputUpdate`](crate::model::KinesisFirehoseOutputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.</p>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.</p>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseOutputUpdate`](crate::model::KinesisFirehoseOutputUpdate)
        pub fn build(self) -> crate::model::KinesisFirehoseOutputUpdate {
            crate::model::KinesisFirehoseOutputUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl KinesisFirehoseOutputUpdate {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseOutputUpdate`](crate::model::KinesisFirehoseOutputUpdate)
    pub fn builder() -> crate::model::kinesis_firehose_output_update::Builder {
        crate::model::kinesis_firehose_output_update::Builder::default()
    }
}

/// <p>
/// When updating an output configuration using the
/// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a>  operation,
/// provides information about an Amazon Kinesis stream configured as
/// the destination.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsOutputUpdate {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.</p>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsOutputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsOutputUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`KinesisStreamsOutputUpdate`](crate::model::KinesisStreamsOutputUpdate)
pub mod kinesis_streams_output_update {
    /// A builder for [`KinesisStreamsOutputUpdate`](crate::model::KinesisStreamsOutputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.</p>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.</p>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsOutputUpdate`](crate::model::KinesisStreamsOutputUpdate)
        pub fn build(self) -> crate::model::KinesisStreamsOutputUpdate {
            crate::model::KinesisStreamsOutputUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl KinesisStreamsOutputUpdate {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsOutputUpdate`](crate::model::KinesisStreamsOutputUpdate)
    pub fn builder() -> crate::model::kinesis_streams_output_update::Builder {
        crate::model::kinesis_streams_output_update::Builder::default()
    }
}

/// <p>Describes updates to a specific input configuration (identified by the
/// <code>InputId</code> of an application). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputUpdate {
    /// <p>Input ID of the application input to be updated.</p>
    pub input_id: std::option::Option<std::string::String>,
    /// <p>Name prefix for in-application streams that Amazon Kinesis Analytics creates
    /// for the specific streaming source.</p>
    pub name_prefix_update: std::option::Option<std::string::String>,
    /// <p>Describes updates for an input processing configuration.</p>
    pub input_processing_configuration_update:
        std::option::Option<crate::model::InputProcessingConfigurationUpdate>,
    /// <p>If an Amazon Kinesis stream is the streaming source to be updated, provides an
    /// updated stream Amazon Resource Name (ARN) and IAM role ARN.</p>
    pub kinesis_streams_input_update: std::option::Option<crate::model::KinesisStreamsInputUpdate>,
    /// <p>If an Amazon Kinesis Firehose delivery stream is the streaming source to be
    /// updated, provides an updated stream ARN and IAM role ARN.</p>
    pub kinesis_firehose_input_update:
        std::option::Option<crate::model::KinesisFirehoseInputUpdate>,
    /// <p>Describes the data format on the streaming source, and
    /// how record elements on the streaming source map to columns of the in-application stream that is created.</p>
    pub input_schema_update: std::option::Option<crate::model::InputSchemaUpdate>,
    /// <p>Describes the parallelism updates (the number in-application
    /// streams Amazon Kinesis Analytics creates for the specific streaming source).</p>
    pub input_parallelism_update: std::option::Option<crate::model::InputParallelismUpdate>,
}
impl std::fmt::Debug for InputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputUpdate");
        formatter.field("input_id", &self.input_id);
        formatter.field("name_prefix_update", &self.name_prefix_update);
        formatter.field(
            "input_processing_configuration_update",
            &self.input_processing_configuration_update,
        );
        formatter.field(
            "kinesis_streams_input_update",
            &self.kinesis_streams_input_update,
        );
        formatter.field(
            "kinesis_firehose_input_update",
            &self.kinesis_firehose_input_update,
        );
        formatter.field("input_schema_update", &self.input_schema_update);
        formatter.field("input_parallelism_update", &self.input_parallelism_update);
        formatter.finish()
    }
}
/// See [`InputUpdate`](crate::model::InputUpdate)
pub mod input_update {
    /// A builder for [`InputUpdate`](crate::model::InputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) name_prefix_update: std::option::Option<std::string::String>,
        pub(crate) input_processing_configuration_update:
            std::option::Option<crate::model::InputProcessingConfigurationUpdate>,
        pub(crate) kinesis_streams_input_update:
            std::option::Option<crate::model::KinesisStreamsInputUpdate>,
        pub(crate) kinesis_firehose_input_update:
            std::option::Option<crate::model::KinesisFirehoseInputUpdate>,
        pub(crate) input_schema_update: std::option::Option<crate::model::InputSchemaUpdate>,
        pub(crate) input_parallelism_update:
            std::option::Option<crate::model::InputParallelismUpdate>,
    }
    impl Builder {
        /// <p>Input ID of the application input to be updated.</p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// <p>Input ID of the application input to be updated.</p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// <p>Name prefix for in-application streams that Amazon Kinesis Analytics creates
        /// for the specific streaming source.</p>
        pub fn name_prefix_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix_update = Some(input.into());
            self
        }
        /// <p>Name prefix for in-application streams that Amazon Kinesis Analytics creates
        /// for the specific streaming source.</p>
        pub fn set_name_prefix_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_prefix_update = input;
            self
        }
        /// <p>Describes updates for an input processing configuration.</p>
        pub fn input_processing_configuration_update(
            mut self,
            input: crate::model::InputProcessingConfigurationUpdate,
        ) -> Self {
            self.input_processing_configuration_update = Some(input);
            self
        }
        /// <p>Describes updates for an input processing configuration.</p>
        pub fn set_input_processing_configuration_update(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfigurationUpdate>,
        ) -> Self {
            self.input_processing_configuration_update = input;
            self
        }
        /// <p>If an Amazon Kinesis stream is the streaming source to be updated, provides an
        /// updated stream Amazon Resource Name (ARN) and IAM role ARN.</p>
        pub fn kinesis_streams_input_update(
            mut self,
            input: crate::model::KinesisStreamsInputUpdate,
        ) -> Self {
            self.kinesis_streams_input_update = Some(input);
            self
        }
        /// <p>If an Amazon Kinesis stream is the streaming source to be updated, provides an
        /// updated stream Amazon Resource Name (ARN) and IAM role ARN.</p>
        pub fn set_kinesis_streams_input_update(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsInputUpdate>,
        ) -> Self {
            self.kinesis_streams_input_update = input;
            self
        }
        /// <p>If an Amazon Kinesis Firehose delivery stream is the streaming source to be
        /// updated, provides an updated stream ARN and IAM role ARN.</p>
        pub fn kinesis_firehose_input_update(
            mut self,
            input: crate::model::KinesisFirehoseInputUpdate,
        ) -> Self {
            self.kinesis_firehose_input_update = Some(input);
            self
        }
        /// <p>If an Amazon Kinesis Firehose delivery stream is the streaming source to be
        /// updated, provides an updated stream ARN and IAM role ARN.</p>
        pub fn set_kinesis_firehose_input_update(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseInputUpdate>,
        ) -> Self {
            self.kinesis_firehose_input_update = input;
            self
        }
        /// <p>Describes the data format on the streaming source, and
        /// how record elements on the streaming source map to columns of the in-application stream that is created.</p>
        pub fn input_schema_update(mut self, input: crate::model::InputSchemaUpdate) -> Self {
            self.input_schema_update = Some(input);
            self
        }
        /// <p>Describes the data format on the streaming source, and
        /// how record elements on the streaming source map to columns of the in-application stream that is created.</p>
        pub fn set_input_schema_update(
            mut self,
            input: std::option::Option<crate::model::InputSchemaUpdate>,
        ) -> Self {
            self.input_schema_update = input;
            self
        }
        /// <p>Describes the parallelism updates (the number in-application
        /// streams Amazon Kinesis Analytics creates for the specific streaming source).</p>
        pub fn input_parallelism_update(
            mut self,
            input: crate::model::InputParallelismUpdate,
        ) -> Self {
            self.input_parallelism_update = Some(input);
            self
        }
        /// <p>Describes the parallelism updates (the number in-application
        /// streams Amazon Kinesis Analytics creates for the specific streaming source).</p>
        pub fn set_input_parallelism_update(
            mut self,
            input: std::option::Option<crate::model::InputParallelismUpdate>,
        ) -> Self {
            self.input_parallelism_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InputUpdate`](crate::model::InputUpdate)
        pub fn build(self) -> crate::model::InputUpdate {
            crate::model::InputUpdate {
                input_id: self.input_id,
                name_prefix_update: self.name_prefix_update,
                input_processing_configuration_update: self.input_processing_configuration_update,
                kinesis_streams_input_update: self.kinesis_streams_input_update,
                kinesis_firehose_input_update: self.kinesis_firehose_input_update,
                input_schema_update: self.input_schema_update,
                input_parallelism_update: self.input_parallelism_update,
            }
        }
    }
}
impl InputUpdate {
    /// Creates a new builder-style object to manufacture [`InputUpdate`](crate::model::InputUpdate)
    pub fn builder() -> crate::model::input_update::Builder {
        crate::model::input_update::Builder::default()
    }
}

/// <p>Provides updates to the parallelism count.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputParallelismUpdate {
    /// <p>Number of in-application streams to create for the specified
    /// streaming source.</p>
    pub count_update: std::option::Option<i32>,
}
impl std::fmt::Debug for InputParallelismUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputParallelismUpdate");
        formatter.field("count_update", &self.count_update);
        formatter.finish()
    }
}
/// See [`InputParallelismUpdate`](crate::model::InputParallelismUpdate)
pub mod input_parallelism_update {
    /// A builder for [`InputParallelismUpdate`](crate::model::InputParallelismUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count_update: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of in-application streams to create for the specified
        /// streaming source.</p>
        pub fn count_update(mut self, input: i32) -> Self {
            self.count_update = Some(input);
            self
        }
        /// <p>Number of in-application streams to create for the specified
        /// streaming source.</p>
        pub fn set_count_update(mut self, input: std::option::Option<i32>) -> Self {
            self.count_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InputParallelismUpdate`](crate::model::InputParallelismUpdate)
        pub fn build(self) -> crate::model::InputParallelismUpdate {
            crate::model::InputParallelismUpdate {
                count_update: self.count_update,
            }
        }
    }
}
impl InputParallelismUpdate {
    /// Creates a new builder-style object to manufacture [`InputParallelismUpdate`](crate::model::InputParallelismUpdate)
    pub fn builder() -> crate::model::input_parallelism_update::Builder {
        crate::model::input_parallelism_update::Builder::default()
    }
}

/// <p>Describes updates for the application's input schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSchemaUpdate {
    /// <p>Specifies the format of the records on the streaming source.</p>
    pub record_format_update: std::option::Option<crate::model::RecordFormat>,
    /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
    pub record_encoding_update: std::option::Option<std::string::String>,
    /// <p>A list of <code>RecordColumn</code> objects. Each object describes the mapping
    /// of the streaming source element to the corresponding column in the in-application stream. </p>
    pub record_column_updates: std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
}
impl std::fmt::Debug for InputSchemaUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSchemaUpdate");
        formatter.field("record_format_update", &self.record_format_update);
        formatter.field("record_encoding_update", &self.record_encoding_update);
        formatter.field("record_column_updates", &self.record_column_updates);
        formatter.finish()
    }
}
/// See [`InputSchemaUpdate`](crate::model::InputSchemaUpdate)
pub mod input_schema_update {
    /// A builder for [`InputSchemaUpdate`](crate::model::InputSchemaUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_format_update: std::option::Option<crate::model::RecordFormat>,
        pub(crate) record_encoding_update: std::option::Option<std::string::String>,
        pub(crate) record_column_updates:
            std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
    }
    impl Builder {
        /// <p>Specifies the format of the records on the streaming source.</p>
        pub fn record_format_update(mut self, input: crate::model::RecordFormat) -> Self {
            self.record_format_update = Some(input);
            self
        }
        /// <p>Specifies the format of the records on the streaming source.</p>
        pub fn set_record_format_update(
            mut self,
            input: std::option::Option<crate::model::RecordFormat>,
        ) -> Self {
            self.record_format_update = input;
            self
        }
        /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
        pub fn record_encoding_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_encoding_update = Some(input.into());
            self
        }
        /// <p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>
        pub fn set_record_encoding_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_encoding_update = input;
            self
        }
        /// Appends an item to `record_column_updates`.
        ///
        /// To override the contents of this collection use [`set_record_column_updates`](Self::set_record_column_updates).
        ///
        /// <p>A list of <code>RecordColumn</code> objects. Each object describes the mapping
        /// of the streaming source element to the corresponding column in the in-application stream. </p>
        pub fn record_column_updates(
            mut self,
            input: impl Into<crate::model::RecordColumn>,
        ) -> Self {
            let mut v = self.record_column_updates.unwrap_or_default();
            v.push(input.into());
            self.record_column_updates = Some(v);
            self
        }
        /// <p>A list of <code>RecordColumn</code> objects. Each object describes the mapping
        /// of the streaming source element to the corresponding column in the in-application stream. </p>
        pub fn set_record_column_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordColumn>>,
        ) -> Self {
            self.record_column_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSchemaUpdate`](crate::model::InputSchemaUpdate)
        pub fn build(self) -> crate::model::InputSchemaUpdate {
            crate::model::InputSchemaUpdate {
                record_format_update: self.record_format_update,
                record_encoding_update: self.record_encoding_update,
                record_column_updates: self.record_column_updates,
            }
        }
    }
}
impl InputSchemaUpdate {
    /// Creates a new builder-style object to manufacture [`InputSchemaUpdate`](crate::model::InputSchemaUpdate)
    pub fn builder() -> crate::model::input_schema_update::Builder {
        crate::model::input_schema_update::Builder::default()
    }
}

/// <p>When updating application input configuration, provides information about an  
/// Amazon Kinesis Firehose delivery stream as the streaming source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseInputUpdate {
    /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery stream to
    /// read.</p>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
    /// on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseInputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseInputUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseInputUpdate`](crate::model::KinesisFirehoseInputUpdate)
pub mod kinesis_firehose_input_update {
    /// A builder for [`KinesisFirehoseInputUpdate`](crate::model::KinesisFirehoseInputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery stream to
        /// read.</p>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery stream to
        /// read.</p>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseInputUpdate`](crate::model::KinesisFirehoseInputUpdate)
        pub fn build(self) -> crate::model::KinesisFirehoseInputUpdate {
            crate::model::KinesisFirehoseInputUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl KinesisFirehoseInputUpdate {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseInputUpdate`](crate::model::KinesisFirehoseInputUpdate)
    pub fn builder() -> crate::model::kinesis_firehose_input_update::Builder {
        crate::model::kinesis_firehose_input_update::Builder::default()
    }
}

/// <p>When updating application input configuration, provides information about an
/// Amazon Kinesis stream as the streaming source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsInputUpdate {
    /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.</p>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsInputUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsInputUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`KinesisStreamsInputUpdate`](crate::model::KinesisStreamsInputUpdate)
pub mod kinesis_streams_input_update {
    /// A builder for [`KinesisStreamsInputUpdate`](crate::model::KinesisStreamsInputUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.</p>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.</p>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsInputUpdate`](crate::model::KinesisStreamsInputUpdate)
        pub fn build(self) -> crate::model::KinesisStreamsInputUpdate {
            crate::model::KinesisStreamsInputUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl KinesisStreamsInputUpdate {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsInputUpdate`](crate::model::KinesisStreamsInputUpdate)
    pub fn builder() -> crate::model::kinesis_streams_input_update::Builder {
        crate::model::kinesis_streams_input_update::Builder::default()
    }
}

/// <p>Describes updates to an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputProcessingConfigurationUpdate {
    /// <p>Provides update information for an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
    pub input_lambda_processor_update:
        std::option::Option<crate::model::InputLambdaProcessorUpdate>,
}
impl std::fmt::Debug for InputProcessingConfigurationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputProcessingConfigurationUpdate");
        formatter.field(
            "input_lambda_processor_update",
            &self.input_lambda_processor_update,
        );
        formatter.finish()
    }
}
/// See [`InputProcessingConfigurationUpdate`](crate::model::InputProcessingConfigurationUpdate)
pub mod input_processing_configuration_update {
    /// A builder for [`InputProcessingConfigurationUpdate`](crate::model::InputProcessingConfigurationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_lambda_processor_update:
            std::option::Option<crate::model::InputLambdaProcessorUpdate>,
    }
    impl Builder {
        /// <p>Provides update information for an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
        pub fn input_lambda_processor_update(
            mut self,
            input: crate::model::InputLambdaProcessorUpdate,
        ) -> Self {
            self.input_lambda_processor_update = Some(input);
            self
        }
        /// <p>Provides update information for an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
        pub fn set_input_lambda_processor_update(
            mut self,
            input: std::option::Option<crate::model::InputLambdaProcessorUpdate>,
        ) -> Self {
            self.input_lambda_processor_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InputProcessingConfigurationUpdate`](crate::model::InputProcessingConfigurationUpdate)
        pub fn build(self) -> crate::model::InputProcessingConfigurationUpdate {
            crate::model::InputProcessingConfigurationUpdate {
                input_lambda_processor_update: self.input_lambda_processor_update,
            }
        }
    }
}
impl InputProcessingConfigurationUpdate {
    /// Creates a new builder-style object to manufacture [`InputProcessingConfigurationUpdate`](crate::model::InputProcessingConfigurationUpdate)
    pub fn builder() -> crate::model::input_processing_configuration_update::Builder {
        crate::model::input_processing_configuration_update::Builder::default()
    }
}

/// <p>Represents an update to the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLambdaProcessorUpdate {
    /// <p>The Amazon Resource Name (ARN) of the new <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that
    /// is used to preprocess the records in the stream.</p>
    /// <note>
    /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
    /// </p>
    /// </note>
    pub resource_arn_update: std::option::Option<std::string::String>,
    /// <p>The ARN of the new IAM role that is used to access the AWS Lambda
    /// function.</p>
    pub role_arn_update: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputLambdaProcessorUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLambdaProcessorUpdate");
        formatter.field("resource_arn_update", &self.resource_arn_update);
        formatter.field("role_arn_update", &self.role_arn_update);
        formatter.finish()
    }
}
/// See [`InputLambdaProcessorUpdate`](crate::model::InputLambdaProcessorUpdate)
pub mod input_lambda_processor_update {
    /// A builder for [`InputLambdaProcessorUpdate`](crate::model::InputLambdaProcessorUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn_update: std::option::Option<std::string::String>,
        pub(crate) role_arn_update: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the new <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that
        /// is used to preprocess the records in the stream.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn resource_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn_update = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that
        /// is used to preprocess the records in the stream.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn set_resource_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_arn_update = input;
            self
        }
        /// <p>The ARN of the new IAM role that is used to access the AWS Lambda
        /// function.</p>
        pub fn role_arn_update(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_update = Some(input.into());
            self
        }
        /// <p>The ARN of the new IAM role that is used to access the AWS Lambda
        /// function.</p>
        pub fn set_role_arn_update(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLambdaProcessorUpdate`](crate::model::InputLambdaProcessorUpdate)
        pub fn build(self) -> crate::model::InputLambdaProcessorUpdate {
            crate::model::InputLambdaProcessorUpdate {
                resource_arn_update: self.resource_arn_update,
                role_arn_update: self.role_arn_update,
            }
        }
    }
}
impl InputLambdaProcessorUpdate {
    /// Creates a new builder-style object to manufacture [`InputLambdaProcessorUpdate`](crate::model::InputLambdaProcessorUpdate)
    pub fn builder() -> crate::model::input_lambda_processor_update::Builder {
        crate::model::input_lambda_processor_update::Builder::default()
    }
}

/// <p>A key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Note that
/// the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
/// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the key-value tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the key-value tag. The value is optional.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the key-value tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the key-value tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the key-value tag. The value is optional.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the key-value tag. The value is optional.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>When you start your application,
/// you provide this configuration, which identifies the input source and the point
/// in the input source at which you want the application to start processing records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputConfiguration {
    /// <p>Input source ID. You can get this ID by calling
    /// the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Point at which you want the application to start processing
    /// records from the streaming source.</p>
    pub input_starting_position_configuration:
        std::option::Option<crate::model::InputStartingPositionConfiguration>,
}
impl std::fmt::Debug for InputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputConfiguration");
        formatter.field("id", &self.id);
        formatter.field(
            "input_starting_position_configuration",
            &self.input_starting_position_configuration,
        );
        formatter.finish()
    }
}
/// See [`InputConfiguration`](crate::model::InputConfiguration)
pub mod input_configuration {
    /// A builder for [`InputConfiguration`](crate::model::InputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_starting_position_configuration:
            std::option::Option<crate::model::InputStartingPositionConfiguration>,
    }
    impl Builder {
        /// <p>Input source ID. You can get this ID by calling
        /// the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Input source ID. You can get this ID by calling
        /// the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Point at which you want the application to start processing
        /// records from the streaming source.</p>
        pub fn input_starting_position_configuration(
            mut self,
            input: crate::model::InputStartingPositionConfiguration,
        ) -> Self {
            self.input_starting_position_configuration = Some(input);
            self
        }
        /// <p>Point at which you want the application to start processing
        /// records from the streaming source.</p>
        pub fn set_input_starting_position_configuration(
            mut self,
            input: std::option::Option<crate::model::InputStartingPositionConfiguration>,
        ) -> Self {
            self.input_starting_position_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`InputConfiguration`](crate::model::InputConfiguration)
        pub fn build(self) -> crate::model::InputConfiguration {
            crate::model::InputConfiguration {
                id: self.id,
                input_starting_position_configuration: self.input_starting_position_configuration,
            }
        }
    }
}
impl InputConfiguration {
    /// Creates a new builder-style object to manufacture [`InputConfiguration`](crate::model::InputConfiguration)
    pub fn builder() -> crate::model::input_configuration::Builder {
        crate::model::input_configuration::Builder::default()
    }
}

/// <p>Describes the point at which the application reads from
/// the streaming source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputStartingPositionConfiguration {
    /// <p>The starting position on the stream.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NOW</code> - Start reading just after the most recent record in the
    /// stream, start at the request time stamp that the customer issued.</p>
    ///
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream,
    /// which is the oldest record available in the stream. This option is not available
    /// for an Amazon Kinesis Firehose delivery stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.</p>
    /// </li>
    /// </ul>
    pub input_starting_position: std::option::Option<crate::model::InputStartingPosition>,
}
impl std::fmt::Debug for InputStartingPositionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputStartingPositionConfiguration");
        formatter.field("input_starting_position", &self.input_starting_position);
        formatter.finish()
    }
}
/// See [`InputStartingPositionConfiguration`](crate::model::InputStartingPositionConfiguration)
pub mod input_starting_position_configuration {
    /// A builder for [`InputStartingPositionConfiguration`](crate::model::InputStartingPositionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_starting_position:
            std::option::Option<crate::model::InputStartingPosition>,
    }
    impl Builder {
        /// <p>The starting position on the stream.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NOW</code> - Start reading just after the most recent record in the
        /// stream, start at the request time stamp that the customer issued.</p>
        ///
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream,
        /// which is the oldest record available in the stream. This option is not available
        /// for an Amazon Kinesis Firehose delivery stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.</p>
        /// </li>
        /// </ul>
        pub fn input_starting_position(
            mut self,
            input: crate::model::InputStartingPosition,
        ) -> Self {
            self.input_starting_position = Some(input);
            self
        }
        /// <p>The starting position on the stream.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NOW</code> - Start reading just after the most recent record in the
        /// stream, start at the request time stamp that the customer issued.</p>
        ///
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream,
        /// which is the oldest record available in the stream. This option is not available
        /// for an Amazon Kinesis Firehose delivery stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.</p>
        /// </li>
        /// </ul>
        pub fn set_input_starting_position(
            mut self,
            input: std::option::Option<crate::model::InputStartingPosition>,
        ) -> Self {
            self.input_starting_position = input;
            self
        }
        /// Consumes the builder and constructs a [`InputStartingPositionConfiguration`](crate::model::InputStartingPositionConfiguration)
        pub fn build(self) -> crate::model::InputStartingPositionConfiguration {
            crate::model::InputStartingPositionConfiguration {
                input_starting_position: self.input_starting_position,
            }
        }
    }
}
impl InputStartingPositionConfiguration {
    /// Creates a new builder-style object to manufacture [`InputStartingPositionConfiguration`](crate::model::InputStartingPositionConfiguration)
    pub fn builder() -> crate::model::input_starting_position_configuration::Builder {
        crate::model::input_starting_position_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputStartingPosition {
    #[allow(missing_docs)] // documentation missing in model
    LastStoppedPoint,
    #[allow(missing_docs)] // documentation missing in model
    Now,
    #[allow(missing_docs)] // documentation missing in model
    TrimHorizon,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputStartingPosition {
    fn from(s: &str) -> Self {
        match s {
            "LAST_STOPPED_POINT" => InputStartingPosition::LastStoppedPoint,
            "NOW" => InputStartingPosition::Now,
            "TRIM_HORIZON" => InputStartingPosition::TrimHorizon,
            other => InputStartingPosition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputStartingPosition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputStartingPosition::from(s))
    }
}
impl InputStartingPosition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputStartingPosition::LastStoppedPoint => "LAST_STOPPED_POINT",
            InputStartingPosition::Now => "NOW",
            InputStartingPosition::TrimHorizon => "TRIM_HORIZON",
            InputStartingPosition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAST_STOPPED_POINT", "NOW", "TRIM_HORIZON"]
    }
}
impl AsRef<str> for InputStartingPosition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
/// </note>
/// <p>Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSummary {
    /// <p>Name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>ARN of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>Status of the application.</p>
    pub application_status: std::option::Option<crate::model::ApplicationStatus>,
}
impl std::fmt::Debug for ApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSummary");
        formatter.field("application_name", &self.application_name);
        formatter.field("application_arn", &self.application_arn);
        formatter.field("application_status", &self.application_status);
        formatter.finish()
    }
}
/// See [`ApplicationSummary`](crate::model::ApplicationSummary)
pub mod application_summary {
    /// A builder for [`ApplicationSummary`](crate::model::ApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) application_status: std::option::Option<crate::model::ApplicationStatus>,
    }
    impl Builder {
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>Status of the application.</p>
        pub fn application_status(mut self, input: crate::model::ApplicationStatus) -> Self {
            self.application_status = Some(input);
            self
        }
        /// <p>Status of the application.</p>
        pub fn set_application_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationStatus>,
        ) -> Self {
            self.application_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSummary`](crate::model::ApplicationSummary)
        pub fn build(self) -> crate::model::ApplicationSummary {
            crate::model::ApplicationSummary {
                application_name: self.application_name,
                application_arn: self.application_arn,
                application_status: self.application_status,
            }
        }
    }
}
impl ApplicationSummary {
    /// Creates a new builder-style object to manufacture [`ApplicationSummary`](crate::model::ApplicationSummary)
    pub fn builder() -> crate::model::application_summary::Builder {
        crate::model::application_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ApplicationStatus::Deleting,
            "READY" => ApplicationStatus::Ready,
            "RUNNING" => ApplicationStatus::Running,
            "STARTING" => ApplicationStatus::Starting,
            "STOPPING" => ApplicationStatus::Stopping,
            "UPDATING" => ApplicationStatus::Updating,
            other => ApplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationStatus::from(s))
    }
}
impl ApplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationStatus::Deleting => "DELETING",
            ApplicationStatus::Ready => "READY",
            ApplicationStatus::Running => "RUNNING",
            ApplicationStatus::Starting => "STARTING",
            ApplicationStatus::Stopping => "STOPPING",
            ApplicationStatus::Updating => "UPDATING",
            ApplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING", "READY", "RUNNING", "STARTING", "STOPPING", "UPDATING",
        ]
    }
}
impl AsRef<str> for ApplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a description of a processor that is used to preprocess the records in the
/// stream before being processed by your application code. Currently, the only input
/// processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS
/// Lambda</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputProcessingConfiguration {
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records
    /// in the stream before being processed by your application code.</p>
    pub input_lambda_processor: std::option::Option<crate::model::InputLambdaProcessor>,
}
impl std::fmt::Debug for InputProcessingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputProcessingConfiguration");
        formatter.field("input_lambda_processor", &self.input_lambda_processor);
        formatter.finish()
    }
}
/// See [`InputProcessingConfiguration`](crate::model::InputProcessingConfiguration)
pub mod input_processing_configuration {
    /// A builder for [`InputProcessingConfiguration`](crate::model::InputProcessingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_lambda_processor: std::option::Option<crate::model::InputLambdaProcessor>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records
        /// in the stream before being processed by your application code.</p>
        pub fn input_lambda_processor(mut self, input: crate::model::InputLambdaProcessor) -> Self {
            self.input_lambda_processor = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records
        /// in the stream before being processed by your application code.</p>
        pub fn set_input_lambda_processor(
            mut self,
            input: std::option::Option<crate::model::InputLambdaProcessor>,
        ) -> Self {
            self.input_lambda_processor = input;
            self
        }
        /// Consumes the builder and constructs a [`InputProcessingConfiguration`](crate::model::InputProcessingConfiguration)
        pub fn build(self) -> crate::model::InputProcessingConfiguration {
            crate::model::InputProcessingConfiguration {
                input_lambda_processor: self.input_lambda_processor,
            }
        }
    }
}
impl InputProcessingConfiguration {
    /// Creates a new builder-style object to manufacture [`InputProcessingConfiguration`](crate::model::InputProcessingConfiguration)
    pub fn builder() -> crate::model::input_processing_configuration::Builder {
        crate::model::input_processing_configuration::Builder::default()
    }
}

/// <p>An object that contains the Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that
/// is used to preprocess records in the stream, and the ARN of the IAM role that is used to
/// access the AWS Lambda function. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLambdaProcessor {
    /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates
    /// on records in the stream.</p>
    /// <note>
    /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
    /// </p>
    /// </note>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputLambdaProcessor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLambdaProcessor");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`InputLambdaProcessor`](crate::model::InputLambdaProcessor)
pub mod input_lambda_processor {
    /// A builder for [`InputLambdaProcessor`](crate::model::InputLambdaProcessor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates
        /// on records in the stream.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates
        /// on records in the stream.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLambdaProcessor`](crate::model::InputLambdaProcessor)
        pub fn build(self) -> crate::model::InputLambdaProcessor {
            crate::model::InputLambdaProcessor {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl InputLambdaProcessor {
    /// Creates a new builder-style object to manufacture [`InputLambdaProcessor`](crate::model::InputLambdaProcessor)
    pub fn builder() -> crate::model::input_lambda_processor::Builder {
        crate::model::input_lambda_processor::Builder::default()
    }
}

/// <p>Provides a description of an Amazon S3 data source, including the Amazon Resource
/// Name (ARN) of the S3 bucket, the ARN of the IAM role that is used to access the bucket,
/// and the name of the Amazon S3 object that contains the data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Configuration {
    /// <p>IAM ARN of the role used to access the data.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the S3 bucket that contains the data.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The name of the object that contains the data.</p>
    pub file_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Configuration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("file_key", &self.file_key);
        formatter.finish()
    }
}
/// See [`S3Configuration`](crate::model::S3Configuration)
pub mod s3_configuration {
    /// A builder for [`S3Configuration`](crate::model::S3Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) file_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>IAM ARN of the role used to access the data.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>IAM ARN of the role used to access the data.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>ARN of the S3 bucket that contains the data.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>ARN of the S3 bucket that contains the data.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The name of the object that contains the data.</p>
        pub fn file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key = Some(input.into());
            self
        }
        /// <p>The name of the object that contains the data.</p>
        pub fn set_file_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Configuration`](crate::model::S3Configuration)
        pub fn build(self) -> crate::model::S3Configuration {
            crate::model::S3Configuration {
                role_arn: self.role_arn,
                bucket_arn: self.bucket_arn,
                file_key: self.file_key,
            }
        }
    }
}
impl S3Configuration {
    /// Creates a new builder-style object to manufacture [`S3Configuration`](crate::model::S3Configuration)
    pub fn builder() -> crate::model::s3_configuration::Builder {
        crate::model::s3_configuration::Builder::default()
    }
}

/// <note>
/// <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p>
/// </note>
/// <p>Provides a description of the application, including the application Amazon Resource Name (ARN), status, latest version, and input and output configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationDetail {
    /// <p>Name of the application.</p>
    pub application_name: std::option::Option<std::string::String>,
    /// <p>Description of the application.</p>
    pub application_description: std::option::Option<std::string::String>,
    /// <p>ARN of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>Status of the application.</p>
    pub application_status: std::option::Option<crate::model::ApplicationStatus>,
    /// <p>Time stamp when the application version was created.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Time stamp when the application was last updated.</p>
    pub last_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Describes the application input configuration.
    /// For more information,
    /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
    ///
    /// </p>
    pub input_descriptions: std::option::Option<std::vec::Vec<crate::model::InputDescription>>,
    /// <p>Describes the application output configuration.
    /// For more information,
    /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.
    ///
    /// </p>
    pub output_descriptions: std::option::Option<std::vec::Vec<crate::model::OutputDescription>>,
    /// <p>Describes reference data sources configured for the application.
    ///
    /// For more information,
    /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
    ///
    /// </p>
    pub reference_data_source_descriptions:
        std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceDescription>>,
    /// <p>Describes the CloudWatch log streams that are configured to receive application
    /// messages. For more information about using CloudWatch log streams with Amazon Kinesis
    /// Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
    /// CloudWatch Logs</a>. </p>
    pub cloud_watch_logging_option_descriptions:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOptionDescription>>,
    /// <p>Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.</p>
    pub application_code: std::option::Option<std::string::String>,
    /// <p>Provides the current application version.</p>
    pub application_version_id: std::option::Option<i64>,
}
impl std::fmt::Debug for ApplicationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationDetail");
        formatter.field("application_name", &self.application_name);
        formatter.field("application_description", &self.application_description);
        formatter.field("application_arn", &self.application_arn);
        formatter.field("application_status", &self.application_status);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("last_update_timestamp", &self.last_update_timestamp);
        formatter.field("input_descriptions", &self.input_descriptions);
        formatter.field("output_descriptions", &self.output_descriptions);
        formatter.field(
            "reference_data_source_descriptions",
            &self.reference_data_source_descriptions,
        );
        formatter.field(
            "cloud_watch_logging_option_descriptions",
            &self.cloud_watch_logging_option_descriptions,
        );
        formatter.field("application_code", &self.application_code);
        formatter.field("application_version_id", &self.application_version_id);
        formatter.finish()
    }
}
/// See [`ApplicationDetail`](crate::model::ApplicationDetail)
pub mod application_detail {
    /// A builder for [`ApplicationDetail`](crate::model::ApplicationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_name: std::option::Option<std::string::String>,
        pub(crate) application_description: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) application_status: std::option::Option<crate::model::ApplicationStatus>,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_descriptions:
            std::option::Option<std::vec::Vec<crate::model::InputDescription>>,
        pub(crate) output_descriptions:
            std::option::Option<std::vec::Vec<crate::model::OutputDescription>>,
        pub(crate) reference_data_source_descriptions:
            std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceDescription>>,
        pub(crate) cloud_watch_logging_option_descriptions:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchLoggingOptionDescription>>,
        pub(crate) application_code: std::option::Option<std::string::String>,
        pub(crate) application_version_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Name of the application.</p>
        pub fn application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_name = Some(input.into());
            self
        }
        /// <p>Name of the application.</p>
        pub fn set_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_name = input;
            self
        }
        /// <p>Description of the application.</p>
        pub fn application_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_description = Some(input.into());
            self
        }
        /// <p>Description of the application.</p>
        pub fn set_application_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_description = input;
            self
        }
        /// <p>ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>Status of the application.</p>
        pub fn application_status(mut self, input: crate::model::ApplicationStatus) -> Self {
            self.application_status = Some(input);
            self
        }
        /// <p>Status of the application.</p>
        pub fn set_application_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationStatus>,
        ) -> Self {
            self.application_status = input;
            self
        }
        /// <p>Time stamp when the application version was created.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>Time stamp when the application version was created.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// <p>Time stamp when the application was last updated.</p>
        pub fn last_update_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_timestamp = Some(input);
            self
        }
        /// <p>Time stamp when the application was last updated.</p>
        pub fn set_last_update_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_timestamp = input;
            self
        }
        /// Appends an item to `input_descriptions`.
        ///
        /// To override the contents of this collection use [`set_input_descriptions`](Self::set_input_descriptions).
        ///
        /// <p>Describes the application input configuration.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
        ///
        /// </p>
        pub fn input_descriptions(
            mut self,
            input: impl Into<crate::model::InputDescription>,
        ) -> Self {
            let mut v = self.input_descriptions.unwrap_or_default();
            v.push(input.into());
            self.input_descriptions = Some(v);
            self
        }
        /// <p>Describes the application input configuration.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
        ///
        /// </p>
        pub fn set_input_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDescription>>,
        ) -> Self {
            self.input_descriptions = input;
            self
        }
        /// Appends an item to `output_descriptions`.
        ///
        /// To override the contents of this collection use [`set_output_descriptions`](Self::set_output_descriptions).
        ///
        /// <p>Describes the application output configuration.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.
        ///
        /// </p>
        pub fn output_descriptions(
            mut self,
            input: impl Into<crate::model::OutputDescription>,
        ) -> Self {
            let mut v = self.output_descriptions.unwrap_or_default();
            v.push(input.into());
            self.output_descriptions = Some(v);
            self
        }
        /// <p>Describes the application output configuration.
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.
        ///
        /// </p>
        pub fn set_output_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDescription>>,
        ) -> Self {
            self.output_descriptions = input;
            self
        }
        /// Appends an item to `reference_data_source_descriptions`.
        ///
        /// To override the contents of this collection use [`set_reference_data_source_descriptions`](Self::set_reference_data_source_descriptions).
        ///
        /// <p>Describes reference data sources configured for the application.
        ///
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
        ///
        /// </p>
        pub fn reference_data_source_descriptions(
            mut self,
            input: impl Into<crate::model::ReferenceDataSourceDescription>,
        ) -> Self {
            let mut v = self.reference_data_source_descriptions.unwrap_or_default();
            v.push(input.into());
            self.reference_data_source_descriptions = Some(v);
            self
        }
        /// <p>Describes reference data sources configured for the application.
        ///
        /// For more information,
        /// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
        ///
        /// </p>
        pub fn set_reference_data_source_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReferenceDataSourceDescription>>,
        ) -> Self {
            self.reference_data_source_descriptions = input;
            self
        }
        /// Appends an item to `cloud_watch_logging_option_descriptions`.
        ///
        /// To override the contents of this collection use [`set_cloud_watch_logging_option_descriptions`](Self::set_cloud_watch_logging_option_descriptions).
        ///
        /// <p>Describes the CloudWatch log streams that are configured to receive application
        /// messages. For more information about using CloudWatch log streams with Amazon Kinesis
        /// Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
        /// CloudWatch Logs</a>. </p>
        pub fn cloud_watch_logging_option_descriptions(
            mut self,
            input: impl Into<crate::model::CloudWatchLoggingOptionDescription>,
        ) -> Self {
            let mut v = self
                .cloud_watch_logging_option_descriptions
                .unwrap_or_default();
            v.push(input.into());
            self.cloud_watch_logging_option_descriptions = Some(v);
            self
        }
        /// <p>Describes the CloudWatch log streams that are configured to receive application
        /// messages. For more information about using CloudWatch log streams with Amazon Kinesis
        /// Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
        /// CloudWatch Logs</a>. </p>
        pub fn set_cloud_watch_logging_option_descriptions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CloudWatchLoggingOptionDescription>,
            >,
        ) -> Self {
            self.cloud_watch_logging_option_descriptions = input;
            self
        }
        /// <p>Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.</p>
        pub fn application_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_code = Some(input.into());
            self
        }
        /// <p>Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.</p>
        pub fn set_application_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_code = input;
            self
        }
        /// <p>Provides the current application version.</p>
        pub fn application_version_id(mut self, input: i64) -> Self {
            self.application_version_id = Some(input);
            self
        }
        /// <p>Provides the current application version.</p>
        pub fn set_application_version_id(mut self, input: std::option::Option<i64>) -> Self {
            self.application_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationDetail`](crate::model::ApplicationDetail)
        pub fn build(self) -> crate::model::ApplicationDetail {
            crate::model::ApplicationDetail {
                application_name: self.application_name,
                application_description: self.application_description,
                application_arn: self.application_arn,
                application_status: self.application_status,
                create_timestamp: self.create_timestamp,
                last_update_timestamp: self.last_update_timestamp,
                input_descriptions: self.input_descriptions,
                output_descriptions: self.output_descriptions,
                reference_data_source_descriptions: self.reference_data_source_descriptions,
                cloud_watch_logging_option_descriptions: self
                    .cloud_watch_logging_option_descriptions,
                application_code: self.application_code,
                application_version_id: self.application_version_id,
            }
        }
    }
}
impl ApplicationDetail {
    /// Creates a new builder-style object to manufacture [`ApplicationDetail`](crate::model::ApplicationDetail)
    pub fn builder() -> crate::model::application_detail::Builder {
        crate::model::application_detail::Builder::default()
    }
}

/// <p>Description of the CloudWatch logging option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLoggingOptionDescription {
    /// <p>ID of the CloudWatch logging option description.</p>
    pub cloud_watch_logging_option_id: std::option::Option<std::string::String>,
    /// <p>ARN of the CloudWatch log to receive application messages.</p>
    pub log_stream_arn: std::option::Option<std::string::String>,
    /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchLoggingOptionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLoggingOptionDescription");
        formatter.field(
            "cloud_watch_logging_option_id",
            &self.cloud_watch_logging_option_id,
        );
        formatter.field("log_stream_arn", &self.log_stream_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchLoggingOptionDescription`](crate::model::CloudWatchLoggingOptionDescription)
pub mod cloud_watch_logging_option_description {
    /// A builder for [`CloudWatchLoggingOptionDescription`](crate::model::CloudWatchLoggingOptionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logging_option_id: std::option::Option<std::string::String>,
        pub(crate) log_stream_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the CloudWatch logging option description.</p>
        pub fn cloud_watch_logging_option_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = Some(input.into());
            self
        }
        /// <p>ID of the CloudWatch logging option description.</p>
        pub fn set_cloud_watch_logging_option_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logging_option_id = input;
            self
        }
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn log_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_arn = Some(input.into());
            self
        }
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn set_log_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_arn = input;
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLoggingOptionDescription`](crate::model::CloudWatchLoggingOptionDescription)
        pub fn build(self) -> crate::model::CloudWatchLoggingOptionDescription {
            crate::model::CloudWatchLoggingOptionDescription {
                cloud_watch_logging_option_id: self.cloud_watch_logging_option_id,
                log_stream_arn: self.log_stream_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CloudWatchLoggingOptionDescription {
    /// Creates a new builder-style object to manufacture [`CloudWatchLoggingOptionDescription`](crate::model::CloudWatchLoggingOptionDescription)
    pub fn builder() -> crate::model::cloud_watch_logging_option_description::Builder {
        crate::model::cloud_watch_logging_option_description::Builder::default()
    }
}

/// <p>Describes the reference data source configured for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferenceDataSourceDescription {
    /// <p>ID of the reference data source. This is the ID
    /// that Amazon Kinesis Analytics assigns when you add the reference data source
    /// to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>The in-application table name created by the specific reference data source configuration.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.</p>
    pub s3_reference_data_source_description:
        std::option::Option<crate::model::S3ReferenceDataSourceDescription>,
    /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
    pub reference_schema: std::option::Option<crate::model::SourceSchema>,
}
impl std::fmt::Debug for ReferenceDataSourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferenceDataSourceDescription");
        formatter.field("reference_id", &self.reference_id);
        formatter.field("table_name", &self.table_name);
        formatter.field(
            "s3_reference_data_source_description",
            &self.s3_reference_data_source_description,
        );
        formatter.field("reference_schema", &self.reference_schema);
        formatter.finish()
    }
}
/// See [`ReferenceDataSourceDescription`](crate::model::ReferenceDataSourceDescription)
pub mod reference_data_source_description {
    /// A builder for [`ReferenceDataSourceDescription`](crate::model::ReferenceDataSourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) s3_reference_data_source_description:
            std::option::Option<crate::model::S3ReferenceDataSourceDescription>,
        pub(crate) reference_schema: std::option::Option<crate::model::SourceSchema>,
    }
    impl Builder {
        /// <p>ID of the reference data source. This is the ID
        /// that Amazon Kinesis Analytics assigns when you add the reference data source
        /// to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>ID of the reference data source. This is the ID
        /// that Amazon Kinesis Analytics assigns when you add the reference data source
        /// to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The in-application table name created by the specific reference data source configuration.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The in-application table name created by the specific reference data source configuration.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.</p>
        pub fn s3_reference_data_source_description(
            mut self,
            input: crate::model::S3ReferenceDataSourceDescription,
        ) -> Self {
            self.s3_reference_data_source_description = Some(input);
            self
        }
        /// <p>Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.</p>
        pub fn set_s3_reference_data_source_description(
            mut self,
            input: std::option::Option<crate::model::S3ReferenceDataSourceDescription>,
        ) -> Self {
            self.s3_reference_data_source_description = input;
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
        pub fn reference_schema(mut self, input: crate::model::SourceSchema) -> Self {
            self.reference_schema = Some(input);
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
        pub fn set_reference_schema(
            mut self,
            input: std::option::Option<crate::model::SourceSchema>,
        ) -> Self {
            self.reference_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferenceDataSourceDescription`](crate::model::ReferenceDataSourceDescription)
        pub fn build(self) -> crate::model::ReferenceDataSourceDescription {
            crate::model::ReferenceDataSourceDescription {
                reference_id: self.reference_id,
                table_name: self.table_name,
                s3_reference_data_source_description: self.s3_reference_data_source_description,
                reference_schema: self.reference_schema,
            }
        }
    }
}
impl ReferenceDataSourceDescription {
    /// Creates a new builder-style object to manufacture [`ReferenceDataSourceDescription`](crate::model::ReferenceDataSourceDescription)
    pub fn builder() -> crate::model::reference_data_source_description::Builder {
        crate::model::reference_data_source_description::Builder::default()
    }
}

/// <p>Provides the bucket name and object key name that stores the reference data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ReferenceDataSourceDescription {
    /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>Amazon S3 object key name.</p>
    pub file_key: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to populate the in-application reference table.</p>
    pub reference_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3ReferenceDataSourceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ReferenceDataSourceDescription");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("file_key", &self.file_key);
        formatter.field("reference_role_arn", &self.reference_role_arn);
        formatter.finish()
    }
}
/// See [`S3ReferenceDataSourceDescription`](crate::model::S3ReferenceDataSourceDescription)
pub mod s3_reference_data_source_description {
    /// A builder for [`S3ReferenceDataSourceDescription`](crate::model::S3ReferenceDataSourceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) file_key: std::option::Option<std::string::String>,
        pub(crate) reference_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>Amazon S3 object key name.</p>
        pub fn file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key = Some(input.into());
            self
        }
        /// <p>Amazon S3 object key name.</p>
        pub fn set_file_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_key = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to populate the in-application reference table.</p>
        pub fn reference_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to populate the in-application reference table.</p>
        pub fn set_reference_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reference_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ReferenceDataSourceDescription`](crate::model::S3ReferenceDataSourceDescription)
        pub fn build(self) -> crate::model::S3ReferenceDataSourceDescription {
            crate::model::S3ReferenceDataSourceDescription {
                bucket_arn: self.bucket_arn,
                file_key: self.file_key,
                reference_role_arn: self.reference_role_arn,
            }
        }
    }
}
impl S3ReferenceDataSourceDescription {
    /// Creates a new builder-style object to manufacture [`S3ReferenceDataSourceDescription`](crate::model::S3ReferenceDataSourceDescription)
    pub fn builder() -> crate::model::s3_reference_data_source_description::Builder {
        crate::model::s3_reference_data_source_description::Builder::default()
    }
}

/// <p>Describes the application output configuration, which includes  
/// the in-application stream name and the destination where the stream data
/// is written. The destination can be an Amazon Kinesis stream or an  
/// Amazon Kinesis Firehose delivery stream.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputDescription {
    /// <p>A unique identifier for the output configuration.</p>
    pub output_id: std::option::Option<std::string::String>,
    /// <p>Name of the in-application stream configured as output.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Describes Amazon Kinesis stream configured as the
    /// destination where output is written.</p>
    pub kinesis_streams_output_description:
        std::option::Option<crate::model::KinesisStreamsOutputDescription>,
    /// <p>Describes the Amazon Kinesis Firehose delivery stream configured as the
    /// destination where output is written.</p>
    pub kinesis_firehose_output_description:
        std::option::Option<crate::model::KinesisFirehoseOutputDescription>,
    /// <p>Describes the AWS Lambda function configured as the destination where output is
    /// written.</p>
    pub lambda_output_description: std::option::Option<crate::model::LambdaOutputDescription>,
    /// <p>Data format used for writing data to the destination.</p>
    pub destination_schema: std::option::Option<crate::model::DestinationSchema>,
}
impl std::fmt::Debug for OutputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputDescription");
        formatter.field("output_id", &self.output_id);
        formatter.field("name", &self.name);
        formatter.field(
            "kinesis_streams_output_description",
            &self.kinesis_streams_output_description,
        );
        formatter.field(
            "kinesis_firehose_output_description",
            &self.kinesis_firehose_output_description,
        );
        formatter.field("lambda_output_description", &self.lambda_output_description);
        formatter.field("destination_schema", &self.destination_schema);
        formatter.finish()
    }
}
/// See [`OutputDescription`](crate::model::OutputDescription)
pub mod output_description {
    /// A builder for [`OutputDescription`](crate::model::OutputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) kinesis_streams_output_description:
            std::option::Option<crate::model::KinesisStreamsOutputDescription>,
        pub(crate) kinesis_firehose_output_description:
            std::option::Option<crate::model::KinesisFirehoseOutputDescription>,
        pub(crate) lambda_output_description:
            std::option::Option<crate::model::LambdaOutputDescription>,
        pub(crate) destination_schema: std::option::Option<crate::model::DestinationSchema>,
    }
    impl Builder {
        /// <p>A unique identifier for the output configuration.</p>
        pub fn output_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the output configuration.</p>
        pub fn set_output_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_id = input;
            self
        }
        /// <p>Name of the in-application stream configured as output.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the in-application stream configured as output.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Describes Amazon Kinesis stream configured as the
        /// destination where output is written.</p>
        pub fn kinesis_streams_output_description(
            mut self,
            input: crate::model::KinesisStreamsOutputDescription,
        ) -> Self {
            self.kinesis_streams_output_description = Some(input);
            self
        }
        /// <p>Describes Amazon Kinesis stream configured as the
        /// destination where output is written.</p>
        pub fn set_kinesis_streams_output_description(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsOutputDescription>,
        ) -> Self {
            self.kinesis_streams_output_description = input;
            self
        }
        /// <p>Describes the Amazon Kinesis Firehose delivery stream configured as the
        /// destination where output is written.</p>
        pub fn kinesis_firehose_output_description(
            mut self,
            input: crate::model::KinesisFirehoseOutputDescription,
        ) -> Self {
            self.kinesis_firehose_output_description = Some(input);
            self
        }
        /// <p>Describes the Amazon Kinesis Firehose delivery stream configured as the
        /// destination where output is written.</p>
        pub fn set_kinesis_firehose_output_description(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseOutputDescription>,
        ) -> Self {
            self.kinesis_firehose_output_description = input;
            self
        }
        /// <p>Describes the AWS Lambda function configured as the destination where output is
        /// written.</p>
        pub fn lambda_output_description(
            mut self,
            input: crate::model::LambdaOutputDescription,
        ) -> Self {
            self.lambda_output_description = Some(input);
            self
        }
        /// <p>Describes the AWS Lambda function configured as the destination where output is
        /// written.</p>
        pub fn set_lambda_output_description(
            mut self,
            input: std::option::Option<crate::model::LambdaOutputDescription>,
        ) -> Self {
            self.lambda_output_description = input;
            self
        }
        /// <p>Data format used for writing data to the destination.</p>
        pub fn destination_schema(mut self, input: crate::model::DestinationSchema) -> Self {
            self.destination_schema = Some(input);
            self
        }
        /// <p>Data format used for writing data to the destination.</p>
        pub fn set_destination_schema(
            mut self,
            input: std::option::Option<crate::model::DestinationSchema>,
        ) -> Self {
            self.destination_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputDescription`](crate::model::OutputDescription)
        pub fn build(self) -> crate::model::OutputDescription {
            crate::model::OutputDescription {
                output_id: self.output_id,
                name: self.name,
                kinesis_streams_output_description: self.kinesis_streams_output_description,
                kinesis_firehose_output_description: self.kinesis_firehose_output_description,
                lambda_output_description: self.lambda_output_description,
                destination_schema: self.destination_schema,
            }
        }
    }
}
impl OutputDescription {
    /// Creates a new builder-style object to manufacture [`OutputDescription`](crate::model::OutputDescription)
    pub fn builder() -> crate::model::output_description::Builder {
        crate::model::output_description::Builder::default()
    }
}

/// <p>For an application output, describes the AWS Lambda function configured as its
/// destination. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaOutputDescription {
    /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LambdaOutputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaOutputDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`LambdaOutputDescription`](crate::model::LambdaOutputDescription)
pub mod lambda_output_description {
    /// A builder for [`LambdaOutputDescription`](crate::model::LambdaOutputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaOutputDescription`](crate::model::LambdaOutputDescription)
        pub fn build(self) -> crate::model::LambdaOutputDescription {
            crate::model::LambdaOutputDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl LambdaOutputDescription {
    /// Creates a new builder-style object to manufacture [`LambdaOutputDescription`](crate::model::LambdaOutputDescription)
    pub fn builder() -> crate::model::lambda_output_description::Builder {
        crate::model::lambda_output_description::Builder::default()
    }
}

/// <p>
/// For an application output, describes
/// the Amazon Kinesis Firehose delivery stream configured as its destination.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseOutputDescription {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseOutputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseOutputDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseOutputDescription`](crate::model::KinesisFirehoseOutputDescription)
pub mod kinesis_firehose_output_description {
    /// A builder for [`KinesisFirehoseOutputDescription`](crate::model::KinesisFirehoseOutputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseOutputDescription`](crate::model::KinesisFirehoseOutputDescription)
        pub fn build(self) -> crate::model::KinesisFirehoseOutputDescription {
            crate::model::KinesisFirehoseOutputDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisFirehoseOutputDescription {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseOutputDescription`](crate::model::KinesisFirehoseOutputDescription)
    pub fn builder() -> crate::model::kinesis_firehose_output_description::Builder {
        crate::model::kinesis_firehose_output_description::Builder::default()
    }
}

/// <p>
/// For an application output, describes
/// the Amazon Kinesis stream configured as its destination.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsOutputDescription {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsOutputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsOutputDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamsOutputDescription`](crate::model::KinesisStreamsOutputDescription)
pub mod kinesis_streams_output_description {
    /// A builder for [`KinesisStreamsOutputDescription`](crate::model::KinesisStreamsOutputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsOutputDescription`](crate::model::KinesisStreamsOutputDescription)
        pub fn build(self) -> crate::model::KinesisStreamsOutputDescription {
            crate::model::KinesisStreamsOutputDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisStreamsOutputDescription {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsOutputDescription`](crate::model::KinesisStreamsOutputDescription)
    pub fn builder() -> crate::model::kinesis_streams_output_description::Builder {
        crate::model::kinesis_streams_output_description::Builder::default()
    }
}

/// <p>Describes the application input configuration.
/// For more information,
/// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDescription {
    /// <p>Input ID associated with the application input.
    /// This is the ID that Amazon Kinesis Analytics assigns to each
    /// input configuration you add to your application. </p>
    pub input_id: std::option::Option<std::string::String>,
    /// <p>In-application name prefix.</p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>Returns the in-application stream names that are mapped to the
    /// stream source.</p>
    pub in_app_stream_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The description of the preprocessor that executes on records in this input before the application's code is run.</p>
    pub input_processing_configuration_description:
        std::option::Option<crate::model::InputProcessingConfigurationDescription>,
    /// <p>If an Amazon Kinesis stream is configured as streaming source, provides Amazon
    /// Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis
    /// Analytics to access the stream on your behalf.</p>
    pub kinesis_streams_input_description:
        std::option::Option<crate::model::KinesisStreamsInputDescription>,
    /// <p>If an Amazon Kinesis Firehose delivery stream is configured as a streaming source,
    /// provides the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics
    /// to access the stream on your behalf.</p>
    pub kinesis_firehose_input_description:
        std::option::Option<crate::model::KinesisFirehoseInputDescription>,
    /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding
    /// columns in the in-application stream that is being created. </p>
    pub input_schema: std::option::Option<crate::model::SourceSchema>,
    /// <p>Describes the configured parallelism (number of in-application streams
    /// mapped to the streaming source).</p>
    pub input_parallelism: std::option::Option<crate::model::InputParallelism>,
    /// <p>Point at which the application is configured to read from the input stream.</p>
    pub input_starting_position_configuration:
        std::option::Option<crate::model::InputStartingPositionConfiguration>,
}
impl std::fmt::Debug for InputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDescription");
        formatter.field("input_id", &self.input_id);
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field("in_app_stream_names", &self.in_app_stream_names);
        formatter.field(
            "input_processing_configuration_description",
            &self.input_processing_configuration_description,
        );
        formatter.field(
            "kinesis_streams_input_description",
            &self.kinesis_streams_input_description,
        );
        formatter.field(
            "kinesis_firehose_input_description",
            &self.kinesis_firehose_input_description,
        );
        formatter.field("input_schema", &self.input_schema);
        formatter.field("input_parallelism", &self.input_parallelism);
        formatter.field(
            "input_starting_position_configuration",
            &self.input_starting_position_configuration,
        );
        formatter.finish()
    }
}
/// See [`InputDescription`](crate::model::InputDescription)
pub mod input_description {
    /// A builder for [`InputDescription`](crate::model::InputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) in_app_stream_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) input_processing_configuration_description:
            std::option::Option<crate::model::InputProcessingConfigurationDescription>,
        pub(crate) kinesis_streams_input_description:
            std::option::Option<crate::model::KinesisStreamsInputDescription>,
        pub(crate) kinesis_firehose_input_description:
            std::option::Option<crate::model::KinesisFirehoseInputDescription>,
        pub(crate) input_schema: std::option::Option<crate::model::SourceSchema>,
        pub(crate) input_parallelism: std::option::Option<crate::model::InputParallelism>,
        pub(crate) input_starting_position_configuration:
            std::option::Option<crate::model::InputStartingPositionConfiguration>,
    }
    impl Builder {
        /// <p>Input ID associated with the application input.
        /// This is the ID that Amazon Kinesis Analytics assigns to each
        /// input configuration you add to your application. </p>
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// <p>Input ID associated with the application input.
        /// This is the ID that Amazon Kinesis Analytics assigns to each
        /// input configuration you add to your application. </p>
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// <p>In-application name prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>In-application name prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// Appends an item to `in_app_stream_names`.
        ///
        /// To override the contents of this collection use [`set_in_app_stream_names`](Self::set_in_app_stream_names).
        ///
        /// <p>Returns the in-application stream names that are mapped to the
        /// stream source.</p>
        pub fn in_app_stream_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.in_app_stream_names.unwrap_or_default();
            v.push(input.into());
            self.in_app_stream_names = Some(v);
            self
        }
        /// <p>Returns the in-application stream names that are mapped to the
        /// stream source.</p>
        pub fn set_in_app_stream_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.in_app_stream_names = input;
            self
        }
        /// <p>The description of the preprocessor that executes on records in this input before the application's code is run.</p>
        pub fn input_processing_configuration_description(
            mut self,
            input: crate::model::InputProcessingConfigurationDescription,
        ) -> Self {
            self.input_processing_configuration_description = Some(input);
            self
        }
        /// <p>The description of the preprocessor that executes on records in this input before the application's code is run.</p>
        pub fn set_input_processing_configuration_description(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfigurationDescription>,
        ) -> Self {
            self.input_processing_configuration_description = input;
            self
        }
        /// <p>If an Amazon Kinesis stream is configured as streaming source, provides Amazon
        /// Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis
        /// Analytics to access the stream on your behalf.</p>
        pub fn kinesis_streams_input_description(
            mut self,
            input: crate::model::KinesisStreamsInputDescription,
        ) -> Self {
            self.kinesis_streams_input_description = Some(input);
            self
        }
        /// <p>If an Amazon Kinesis stream is configured as streaming source, provides Amazon
        /// Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis
        /// Analytics to access the stream on your behalf.</p>
        pub fn set_kinesis_streams_input_description(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsInputDescription>,
        ) -> Self {
            self.kinesis_streams_input_description = input;
            self
        }
        /// <p>If an Amazon Kinesis Firehose delivery stream is configured as a streaming source,
        /// provides the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics
        /// to access the stream on your behalf.</p>
        pub fn kinesis_firehose_input_description(
            mut self,
            input: crate::model::KinesisFirehoseInputDescription,
        ) -> Self {
            self.kinesis_firehose_input_description = Some(input);
            self
        }
        /// <p>If an Amazon Kinesis Firehose delivery stream is configured as a streaming source,
        /// provides the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics
        /// to access the stream on your behalf.</p>
        pub fn set_kinesis_firehose_input_description(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseInputDescription>,
        ) -> Self {
            self.kinesis_firehose_input_description = input;
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding
        /// columns in the in-application stream that is being created. </p>
        pub fn input_schema(mut self, input: crate::model::SourceSchema) -> Self {
            self.input_schema = Some(input);
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding
        /// columns in the in-application stream that is being created. </p>
        pub fn set_input_schema(
            mut self,
            input: std::option::Option<crate::model::SourceSchema>,
        ) -> Self {
            self.input_schema = input;
            self
        }
        /// <p>Describes the configured parallelism (number of in-application streams
        /// mapped to the streaming source).</p>
        pub fn input_parallelism(mut self, input: crate::model::InputParallelism) -> Self {
            self.input_parallelism = Some(input);
            self
        }
        /// <p>Describes the configured parallelism (number of in-application streams
        /// mapped to the streaming source).</p>
        pub fn set_input_parallelism(
            mut self,
            input: std::option::Option<crate::model::InputParallelism>,
        ) -> Self {
            self.input_parallelism = input;
            self
        }
        /// <p>Point at which the application is configured to read from the input stream.</p>
        pub fn input_starting_position_configuration(
            mut self,
            input: crate::model::InputStartingPositionConfiguration,
        ) -> Self {
            self.input_starting_position_configuration = Some(input);
            self
        }
        /// <p>Point at which the application is configured to read from the input stream.</p>
        pub fn set_input_starting_position_configuration(
            mut self,
            input: std::option::Option<crate::model::InputStartingPositionConfiguration>,
        ) -> Self {
            self.input_starting_position_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDescription`](crate::model::InputDescription)
        pub fn build(self) -> crate::model::InputDescription {
            crate::model::InputDescription {
                input_id: self.input_id,
                name_prefix: self.name_prefix,
                in_app_stream_names: self.in_app_stream_names,
                input_processing_configuration_description: self
                    .input_processing_configuration_description,
                kinesis_streams_input_description: self.kinesis_streams_input_description,
                kinesis_firehose_input_description: self.kinesis_firehose_input_description,
                input_schema: self.input_schema,
                input_parallelism: self.input_parallelism,
                input_starting_position_configuration: self.input_starting_position_configuration,
            }
        }
    }
}
impl InputDescription {
    /// Creates a new builder-style object to manufacture [`InputDescription`](crate::model::InputDescription)
    pub fn builder() -> crate::model::input_description::Builder {
        crate::model::input_description::Builder::default()
    }
}

/// <p>Describes the number of in-application streams to create for a given
/// streaming source. For information about parallelism,
/// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputParallelism {
    /// <p>Number of in-application streams to create.
    /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.
    /// </p>
    pub count: std::option::Option<i32>,
}
impl std::fmt::Debug for InputParallelism {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputParallelism");
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`InputParallelism`](crate::model::InputParallelism)
pub mod input_parallelism {
    /// A builder for [`InputParallelism`](crate::model::InputParallelism)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of in-application streams to create.
        /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.
        /// </p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>Number of in-application streams to create.
        /// For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.
        /// </p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`InputParallelism`](crate::model::InputParallelism)
        pub fn build(self) -> crate::model::InputParallelism {
            crate::model::InputParallelism { count: self.count }
        }
    }
}
impl InputParallelism {
    /// Creates a new builder-style object to manufacture [`InputParallelism`](crate::model::InputParallelism)
    pub fn builder() -> crate::model::input_parallelism::Builder {
        crate::model::input_parallelism::Builder::default()
    }
}

/// <p>
/// Describes the Amazon Kinesis Firehose delivery stream that is configured as the streaming source
/// in the application input configuration.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseInputDescription {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseInputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseInputDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseInputDescription`](crate::model::KinesisFirehoseInputDescription)
pub mod kinesis_firehose_input_description {
    /// A builder for [`KinesisFirehoseInputDescription`](crate::model::KinesisFirehoseInputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseInputDescription`](crate::model::KinesisFirehoseInputDescription)
        pub fn build(self) -> crate::model::KinesisFirehoseInputDescription {
            crate::model::KinesisFirehoseInputDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisFirehoseInputDescription {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseInputDescription`](crate::model::KinesisFirehoseInputDescription)
    pub fn builder() -> crate::model::kinesis_firehose_input_description::Builder {
        crate::model::kinesis_firehose_input_description::Builder::default()
    }
}

/// <p>
/// Describes the Amazon Kinesis stream that is configured as the streaming source
/// in the application input configuration.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsInputDescription {
    /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsInputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsInputDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamsInputDescription`](crate::model::KinesisStreamsInputDescription)
pub mod kinesis_streams_input_description {
    /// A builder for [`KinesisStreamsInputDescription`](crate::model::KinesisStreamsInputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsInputDescription`](crate::model::KinesisStreamsInputDescription)
        pub fn build(self) -> crate::model::KinesisStreamsInputDescription {
            crate::model::KinesisStreamsInputDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisStreamsInputDescription {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsInputDescription`](crate::model::KinesisStreamsInputDescription)
    pub fn builder() -> crate::model::kinesis_streams_input_description::Builder {
        crate::model::kinesis_streams_input_description::Builder::default()
    }
}

/// <p>Provides configuration information about an input processor. Currently, the only input processor available is
/// <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputProcessingConfigurationDescription {
    /// <p>Provides configuration information about the associated <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html">InputLambdaProcessorDescription</a>.</p>
    pub input_lambda_processor_description:
        std::option::Option<crate::model::InputLambdaProcessorDescription>,
}
impl std::fmt::Debug for InputProcessingConfigurationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputProcessingConfigurationDescription");
        formatter.field(
            "input_lambda_processor_description",
            &self.input_lambda_processor_description,
        );
        formatter.finish()
    }
}
/// See [`InputProcessingConfigurationDescription`](crate::model::InputProcessingConfigurationDescription)
pub mod input_processing_configuration_description {
    /// A builder for [`InputProcessingConfigurationDescription`](crate::model::InputProcessingConfigurationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_lambda_processor_description:
            std::option::Option<crate::model::InputLambdaProcessorDescription>,
    }
    impl Builder {
        /// <p>Provides configuration information about the associated <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html">InputLambdaProcessorDescription</a>.</p>
        pub fn input_lambda_processor_description(
            mut self,
            input: crate::model::InputLambdaProcessorDescription,
        ) -> Self {
            self.input_lambda_processor_description = Some(input);
            self
        }
        /// <p>Provides configuration information about the associated <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html">InputLambdaProcessorDescription</a>.</p>
        pub fn set_input_lambda_processor_description(
            mut self,
            input: std::option::Option<crate::model::InputLambdaProcessorDescription>,
        ) -> Self {
            self.input_lambda_processor_description = input;
            self
        }
        /// Consumes the builder and constructs a [`InputProcessingConfigurationDescription`](crate::model::InputProcessingConfigurationDescription)
        pub fn build(self) -> crate::model::InputProcessingConfigurationDescription {
            crate::model::InputProcessingConfigurationDescription {
                input_lambda_processor_description: self.input_lambda_processor_description,
            }
        }
    }
}
impl InputProcessingConfigurationDescription {
    /// Creates a new builder-style object to manufacture [`InputProcessingConfigurationDescription`](crate::model::InputProcessingConfigurationDescription)
    pub fn builder() -> crate::model::input_processing_configuration_description::Builder {
        crate::model::input_processing_configuration_description::Builder::default()
    }
}

/// <p>An object that contains the Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that
/// is used to preprocess records in the stream, and the ARN of the IAM role that is  used
/// to access the AWS Lambda expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLambdaProcessorDescription {
    /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess the records in the stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputLambdaProcessorDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLambdaProcessorDescription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`InputLambdaProcessorDescription`](crate::model::InputLambdaProcessorDescription)
pub mod input_lambda_processor_description {
    /// A builder for [`InputLambdaProcessorDescription`](crate::model::InputLambdaProcessorDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess the records in the stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess the records in the stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLambdaProcessorDescription`](crate::model::InputLambdaProcessorDescription)
        pub fn build(self) -> crate::model::InputLambdaProcessorDescription {
            crate::model::InputLambdaProcessorDescription {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl InputLambdaProcessorDescription {
    /// Creates a new builder-style object to manufacture [`InputLambdaProcessorDescription`](crate::model::InputLambdaProcessorDescription)
    pub fn builder() -> crate::model::input_lambda_processor_description::Builder {
        crate::model::input_lambda_processor_description::Builder::default()
    }
}

/// <p>Provides a description of CloudWatch logging options, including the log stream
/// Amazon Resource Name (ARN) and the role ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLoggingOption {
    /// <p>ARN of the CloudWatch log to receive application messages.</p>
    pub log_stream_arn: std::option::Option<std::string::String>,
    /// <p>IAM ARN of the role to use to send application messages. Note: To write application
    /// messages to CloudWatch, the IAM role that is used must have the
    /// <code>PutLogEvents</code> policy action enabled.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchLoggingOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLoggingOption");
        formatter.field("log_stream_arn", &self.log_stream_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchLoggingOption`](crate::model::CloudWatchLoggingOption)
pub mod cloud_watch_logging_option {
    /// A builder for [`CloudWatchLoggingOption`](crate::model::CloudWatchLoggingOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_stream_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn log_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_arn = Some(input.into());
            self
        }
        /// <p>ARN of the CloudWatch log to receive application messages.</p>
        pub fn set_log_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_arn = input;
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application
        /// messages to CloudWatch, the IAM role that is used must have the
        /// <code>PutLogEvents</code> policy action enabled.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>IAM ARN of the role to use to send application messages. Note: To write application
        /// messages to CloudWatch, the IAM role that is used must have the
        /// <code>PutLogEvents</code> policy action enabled.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLoggingOption`](crate::model::CloudWatchLoggingOption)
        pub fn build(self) -> crate::model::CloudWatchLoggingOption {
            crate::model::CloudWatchLoggingOption {
                log_stream_arn: self.log_stream_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CloudWatchLoggingOption {
    /// Creates a new builder-style object to manufacture [`CloudWatchLoggingOption`](crate::model::CloudWatchLoggingOption)
    pub fn builder() -> crate::model::cloud_watch_logging_option::Builder {
        crate::model::cloud_watch_logging_option::Builder::default()
    }
}

/// <p>
/// Describes application output configuration in which you identify
/// an in-application stream and a destination where you want the
/// in-application stream data to be written. The destination can be
/// an Amazon Kinesis stream or an Amazon Kinesis Firehose delivery stream.
/// </p>
///
/// <p></p>
/// <p>For limits on how many destinations an application can write and other
/// limitations, see
/// <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// <p>Name of the in-application stream.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Identifies an Amazon Kinesis stream
    /// as the destination.</p>
    pub kinesis_streams_output: std::option::Option<crate::model::KinesisStreamsOutput>,
    /// <p>Identifies an Amazon Kinesis Firehose delivery stream as the destination.</p>
    pub kinesis_firehose_output: std::option::Option<crate::model::KinesisFirehoseOutput>,
    /// <p>Identifies an AWS Lambda function as the destination.</p>
    pub lambda_output: std::option::Option<crate::model::LambdaOutput>,
    /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
    pub destination_schema: std::option::Option<crate::model::DestinationSchema>,
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field("name", &self.name);
        formatter.field("kinesis_streams_output", &self.kinesis_streams_output);
        formatter.field("kinesis_firehose_output", &self.kinesis_firehose_output);
        formatter.field("lambda_output", &self.lambda_output);
        formatter.field("destination_schema", &self.destination_schema);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) kinesis_streams_output: std::option::Option<crate::model::KinesisStreamsOutput>,
        pub(crate) kinesis_firehose_output:
            std::option::Option<crate::model::KinesisFirehoseOutput>,
        pub(crate) lambda_output: std::option::Option<crate::model::LambdaOutput>,
        pub(crate) destination_schema: std::option::Option<crate::model::DestinationSchema>,
    }
    impl Builder {
        /// <p>Name of the in-application stream.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the in-application stream.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Identifies an Amazon Kinesis stream
        /// as the destination.</p>
        pub fn kinesis_streams_output(mut self, input: crate::model::KinesisStreamsOutput) -> Self {
            self.kinesis_streams_output = Some(input);
            self
        }
        /// <p>Identifies an Amazon Kinesis stream
        /// as the destination.</p>
        pub fn set_kinesis_streams_output(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsOutput>,
        ) -> Self {
            self.kinesis_streams_output = input;
            self
        }
        /// <p>Identifies an Amazon Kinesis Firehose delivery stream as the destination.</p>
        pub fn kinesis_firehose_output(
            mut self,
            input: crate::model::KinesisFirehoseOutput,
        ) -> Self {
            self.kinesis_firehose_output = Some(input);
            self
        }
        /// <p>Identifies an Amazon Kinesis Firehose delivery stream as the destination.</p>
        pub fn set_kinesis_firehose_output(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseOutput>,
        ) -> Self {
            self.kinesis_firehose_output = input;
            self
        }
        /// <p>Identifies an AWS Lambda function as the destination.</p>
        pub fn lambda_output(mut self, input: crate::model::LambdaOutput) -> Self {
            self.lambda_output = Some(input);
            self
        }
        /// <p>Identifies an AWS Lambda function as the destination.</p>
        pub fn set_lambda_output(
            mut self,
            input: std::option::Option<crate::model::LambdaOutput>,
        ) -> Self {
            self.lambda_output = input;
            self
        }
        /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
        pub fn destination_schema(mut self, input: crate::model::DestinationSchema) -> Self {
            self.destination_schema = Some(input);
            self
        }
        /// <p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>
        pub fn set_destination_schema(
            mut self,
            input: std::option::Option<crate::model::DestinationSchema>,
        ) -> Self {
            self.destination_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                name: self.name,
                kinesis_streams_output: self.kinesis_streams_output,
                kinesis_firehose_output: self.kinesis_firehose_output,
                lambda_output: self.lambda_output,
                destination_schema: self.destination_schema,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// <p>When configuring application output, identifies an AWS Lambda function as the
/// destination. You provide the function Amazon Resource Name (ARN) and also an IAM role
/// ARN that Amazon Kinesis Analytics can use to write to the function on your behalf. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaOutput {
    /// <p>Amazon Resource Name (ARN) of the destination Lambda function to write
    /// to.</p>
    /// <note>
    /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
    /// </p>
    /// </note>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`LambdaOutput`](crate::model::LambdaOutput)
pub mod lambda_output {
    /// A builder for [`LambdaOutput`](crate::model::LambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function to write
        /// to.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the destination Lambda function to write
        /// to.</p>
        /// <note>
        /// <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
        /// </p>
        /// </note>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaOutput`](crate::model::LambdaOutput)
        pub fn build(self) -> crate::model::LambdaOutput {
            crate::model::LambdaOutput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl LambdaOutput {
    /// Creates a new builder-style object to manufacture [`LambdaOutput`](crate::model::LambdaOutput)
    pub fn builder() -> crate::model::lambda_output::Builder {
        crate::model::lambda_output::Builder::default()
    }
}

/// <p>When configuring application output,
/// identifies an Amazon Kinesis Firehose delivery stream as the destination.
/// You provide the stream Amazon Resource Name (ARN) and an IAM role  
/// that enables Amazon Kinesis Analytics to write to the stream on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseOutput {
    /// <p>ARN of the destination Amazon Kinesis Firehose delivery stream to write to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseOutput`](crate::model::KinesisFirehoseOutput)
pub mod kinesis_firehose_output {
    /// A builder for [`KinesisFirehoseOutput`](crate::model::KinesisFirehoseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the destination Amazon Kinesis Firehose delivery stream to write to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the destination Amazon Kinesis Firehose delivery stream to write to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseOutput`](crate::model::KinesisFirehoseOutput)
        pub fn build(self) -> crate::model::KinesisFirehoseOutput {
            crate::model::KinesisFirehoseOutput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisFirehoseOutput {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseOutput`](crate::model::KinesisFirehoseOutput)
    pub fn builder() -> crate::model::kinesis_firehose_output::Builder {
        crate::model::kinesis_firehose_output::Builder::default()
    }
}

/// <p>When configuring application output, identifies an Amazon Kinesis stream as the
/// destination. You provide the stream Amazon Resource Name (ARN) and also an IAM role ARN
/// that Amazon Kinesis Analytics can use to write to the stream on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsOutput {
    /// <p>ARN of the destination Amazon Kinesis stream to write to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamsOutput`](crate::model::KinesisStreamsOutput)
pub mod kinesis_streams_output {
    /// A builder for [`KinesisStreamsOutput`](crate::model::KinesisStreamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the destination Amazon Kinesis stream to write to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the destination Amazon Kinesis stream to write to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsOutput`](crate::model::KinesisStreamsOutput)
        pub fn build(self) -> crate::model::KinesisStreamsOutput {
            crate::model::KinesisStreamsOutput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisStreamsOutput {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsOutput`](crate::model::KinesisStreamsOutput)
    pub fn builder() -> crate::model::kinesis_streams_output::Builder {
        crate::model::kinesis_streams_output::Builder::default()
    }
}

/// <p>When you configure the application input, you specify the streaming source,  the
/// in-application stream name that is created, and the mapping between the two.
/// For more information,
/// see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Input {
    /// <p>Name prefix to use when creating an in-application stream. Suppose that you specify
    /// a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as
    /// per the <code>InputParallelism</code> count you specified) in-application streams with
    /// names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on. </p>
    pub name_prefix: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> for the input. An input
    /// processor transforms records as they are received from the stream, before the
    /// application's SQL code executes. Currently, the only input processing configuration
    /// available is <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
    pub input_processing_configuration:
        std::option::Option<crate::model::InputProcessingConfiguration>,
    /// <p>If the streaming source is an Amazon Kinesis stream,
    /// identifies the stream's Amazon Resource Name (ARN) and an IAM role
    /// that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>
    /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
    pub kinesis_streams_input: std::option::Option<crate::model::KinesisStreamsInput>,
    /// <p>If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies
    /// the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to
    /// access the stream on your behalf.</p>
    /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
    pub kinesis_firehose_input: std::option::Option<crate::model::KinesisFirehoseInput>,
    /// <p>Describes the number of in-application streams to create. </p>
    /// <p>Data from your source is routed to these in-application input streams.</p>
    /// <p>    (see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.</p>
    pub input_parallelism: std::option::Option<crate::model::InputParallelism>,
    /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.</p>
    /// <p>Also used to describe the format of the reference data source.</p>
    pub input_schema: std::option::Option<crate::model::SourceSchema>,
}
impl std::fmt::Debug for Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Input");
        formatter.field("name_prefix", &self.name_prefix);
        formatter.field(
            "input_processing_configuration",
            &self.input_processing_configuration,
        );
        formatter.field("kinesis_streams_input", &self.kinesis_streams_input);
        formatter.field("kinesis_firehose_input", &self.kinesis_firehose_input);
        formatter.field("input_parallelism", &self.input_parallelism);
        formatter.field("input_schema", &self.input_schema);
        formatter.finish()
    }
}
/// See [`Input`](crate::model::Input)
pub mod input {
    /// A builder for [`Input`](crate::model::Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_prefix: std::option::Option<std::string::String>,
        pub(crate) input_processing_configuration:
            std::option::Option<crate::model::InputProcessingConfiguration>,
        pub(crate) kinesis_streams_input: std::option::Option<crate::model::KinesisStreamsInput>,
        pub(crate) kinesis_firehose_input: std::option::Option<crate::model::KinesisFirehoseInput>,
        pub(crate) input_parallelism: std::option::Option<crate::model::InputParallelism>,
        pub(crate) input_schema: std::option::Option<crate::model::SourceSchema>,
    }
    impl Builder {
        /// <p>Name prefix to use when creating an in-application stream. Suppose that you specify
        /// a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as
        /// per the <code>InputParallelism</code> count you specified) in-application streams with
        /// names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on. </p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_prefix = Some(input.into());
            self
        }
        /// <p>Name prefix to use when creating an in-application stream. Suppose that you specify
        /// a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as
        /// per the <code>InputParallelism</code> count you specified) in-application streams with
        /// names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on. </p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_prefix = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> for the input. An input
        /// processor transforms records as they are received from the stream, before the
        /// application's SQL code executes. Currently, the only input processing configuration
        /// available is <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
        pub fn input_processing_configuration(
            mut self,
            input: crate::model::InputProcessingConfiguration,
        ) -> Self {
            self.input_processing_configuration = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> for the input. An input
        /// processor transforms records as they are received from the stream, before the
        /// application's SQL code executes. Currently, the only input processing configuration
        /// available is <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>
        pub fn set_input_processing_configuration(
            mut self,
            input: std::option::Option<crate::model::InputProcessingConfiguration>,
        ) -> Self {
            self.input_processing_configuration = input;
            self
        }
        /// <p>If the streaming source is an Amazon Kinesis stream,
        /// identifies the stream's Amazon Resource Name (ARN) and an IAM role
        /// that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>
        /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
        pub fn kinesis_streams_input(mut self, input: crate::model::KinesisStreamsInput) -> Self {
            self.kinesis_streams_input = Some(input);
            self
        }
        /// <p>If the streaming source is an Amazon Kinesis stream,
        /// identifies the stream's Amazon Resource Name (ARN) and an IAM role
        /// that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>
        /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
        pub fn set_kinesis_streams_input(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamsInput>,
        ) -> Self {
            self.kinesis_streams_input = input;
            self
        }
        /// <p>If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies
        /// the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to
        /// access the stream on your behalf.</p>
        /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
        pub fn kinesis_firehose_input(mut self, input: crate::model::KinesisFirehoseInput) -> Self {
            self.kinesis_firehose_input = Some(input);
            self
        }
        /// <p>If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies
        /// the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to
        /// access the stream on your behalf.</p>
        /// <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>
        pub fn set_kinesis_firehose_input(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseInput>,
        ) -> Self {
            self.kinesis_firehose_input = input;
            self
        }
        /// <p>Describes the number of in-application streams to create. </p>
        /// <p>Data from your source is routed to these in-application input streams.</p>
        /// <p>    (see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.</p>
        pub fn input_parallelism(mut self, input: crate::model::InputParallelism) -> Self {
            self.input_parallelism = Some(input);
            self
        }
        /// <p>Describes the number of in-application streams to create. </p>
        /// <p>Data from your source is routed to these in-application input streams.</p>
        /// <p>    (see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.</p>
        pub fn set_input_parallelism(
            mut self,
            input: std::option::Option<crate::model::InputParallelism>,
        ) -> Self {
            self.input_parallelism = input;
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.</p>
        /// <p>Also used to describe the format of the reference data source.</p>
        pub fn input_schema(mut self, input: crate::model::SourceSchema) -> Self {
            self.input_schema = Some(input);
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.</p>
        /// <p>Also used to describe the format of the reference data source.</p>
        pub fn set_input_schema(
            mut self,
            input: std::option::Option<crate::model::SourceSchema>,
        ) -> Self {
            self.input_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`Input`](crate::model::Input)
        pub fn build(self) -> crate::model::Input {
            crate::model::Input {
                name_prefix: self.name_prefix,
                input_processing_configuration: self.input_processing_configuration,
                kinesis_streams_input: self.kinesis_streams_input,
                kinesis_firehose_input: self.kinesis_firehose_input,
                input_parallelism: self.input_parallelism,
                input_schema: self.input_schema,
            }
        }
    }
}
impl Input {
    /// Creates a new builder-style object to manufacture [`Input`](crate::model::Input)
    pub fn builder() -> crate::model::input::Builder {
        crate::model::input::Builder::default()
    }
}

/// <p> Identifies an Amazon Kinesis Firehose delivery stream as the streaming source. You
/// provide the delivery stream's Amazon Resource Name (ARN) and an IAM role ARN that
/// enables Amazon Kinesis Analytics to access the stream on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseInput {
    /// <p>ARN of the input delivery stream.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
    /// on your behalf. You need to make sure that the role has the necessary permissions to
    /// access the stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisFirehoseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseInput`](crate::model::KinesisFirehoseInput)
pub mod kinesis_firehose_input {
    /// A builder for [`KinesisFirehoseInput`](crate::model::KinesisFirehoseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the input delivery stream.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the input delivery stream.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to make sure that the role has the necessary permissions to
        /// access the stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream
        /// on your behalf. You need to make sure that the role has the necessary permissions to
        /// access the stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseInput`](crate::model::KinesisFirehoseInput)
        pub fn build(self) -> crate::model::KinesisFirehoseInput {
            crate::model::KinesisFirehoseInput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisFirehoseInput {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseInput`](crate::model::KinesisFirehoseInput)
    pub fn builder() -> crate::model::kinesis_firehose_input::Builder {
        crate::model::kinesis_firehose_input::Builder::default()
    }
}

/// <p> Identifies an Amazon Kinesis stream as the streaming source. You provide the
/// stream's Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis
/// Analytics to access the stream on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamsInput {
    /// <p>ARN of the input Amazon Kinesis stream to read.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisStreamsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamsInput`](crate::model::KinesisStreamsInput)
pub mod kinesis_streams_input {
    /// A builder for [`KinesisStreamsInput`](crate::model::KinesisStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the input Amazon Kinesis stream to read.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of the input Amazon Kinesis stream to read.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamsInput`](crate::model::KinesisStreamsInput)
        pub fn build(self) -> crate::model::KinesisStreamsInput {
            crate::model::KinesisStreamsInput {
                resource_arn: self.resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl KinesisStreamsInput {
    /// Creates a new builder-style object to manufacture [`KinesisStreamsInput`](crate::model::KinesisStreamsInput)
    pub fn builder() -> crate::model::kinesis_streams_input::Builder {
        crate::model::kinesis_streams_input::Builder::default()
    }
}

/// <p>Describes the reference data source by providing the source information (S3 bucket name and object key name), the resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon S3 object to the in-application table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferenceDataSource {
    /// <p>Name of the in-application table to create.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.
    ///
    /// An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application. </p>
    pub s3_reference_data_source: std::option::Option<crate::model::S3ReferenceDataSource>,
    /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
    pub reference_schema: std::option::Option<crate::model::SourceSchema>,
}
impl std::fmt::Debug for ReferenceDataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferenceDataSource");
        formatter.field("table_name", &self.table_name);
        formatter.field("s3_reference_data_source", &self.s3_reference_data_source);
        formatter.field("reference_schema", &self.reference_schema);
        formatter.finish()
    }
}
/// See [`ReferenceDataSource`](crate::model::ReferenceDataSource)
pub mod reference_data_source {
    /// A builder for [`ReferenceDataSource`](crate::model::ReferenceDataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) s3_reference_data_source:
            std::option::Option<crate::model::S3ReferenceDataSource>,
        pub(crate) reference_schema: std::option::Option<crate::model::SourceSchema>,
    }
    impl Builder {
        /// <p>Name of the in-application table to create.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the in-application table to create.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.
        ///
        /// An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application. </p>
        pub fn s3_reference_data_source(
            mut self,
            input: crate::model::S3ReferenceDataSource,
        ) -> Self {
            self.s3_reference_data_source = Some(input);
            self
        }
        /// <p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.
        ///
        /// An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application. </p>
        pub fn set_s3_reference_data_source(
            mut self,
            input: std::option::Option<crate::model::S3ReferenceDataSource>,
        ) -> Self {
            self.s3_reference_data_source = input;
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
        pub fn reference_schema(mut self, input: crate::model::SourceSchema) -> Self {
            self.reference_schema = Some(input);
            self
        }
        /// <p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>
        pub fn set_reference_schema(
            mut self,
            input: std::option::Option<crate::model::SourceSchema>,
        ) -> Self {
            self.reference_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferenceDataSource`](crate::model::ReferenceDataSource)
        pub fn build(self) -> crate::model::ReferenceDataSource {
            crate::model::ReferenceDataSource {
                table_name: self.table_name,
                s3_reference_data_source: self.s3_reference_data_source,
                reference_schema: self.reference_schema,
            }
        }
    }
}
impl ReferenceDataSource {
    /// Creates a new builder-style object to manufacture [`ReferenceDataSource`](crate::model::ReferenceDataSource)
    pub fn builder() -> crate::model::reference_data_source::Builder {
        crate::model::reference_data_source::Builder::default()
    }
}

/// <p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.</p>
/// <p>An Amazon Kinesis Analytics application loads reference data only once. If the data changes,
/// you call the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation to trigger
/// reloading of data into your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ReferenceDataSource {
    /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>Object key name containing reference data.</p>
    pub file_key: std::option::Option<std::string::String>,
    /// <p>ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.</p>
    pub reference_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3ReferenceDataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ReferenceDataSource");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("file_key", &self.file_key);
        formatter.field("reference_role_arn", &self.reference_role_arn);
        formatter.finish()
    }
}
/// See [`S3ReferenceDataSource`](crate::model::S3ReferenceDataSource)
pub mod s3_reference_data_source {
    /// A builder for [`S3ReferenceDataSource`](crate::model::S3ReferenceDataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) file_key: std::option::Option<std::string::String>,
        pub(crate) reference_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>Object key name containing reference data.</p>
        pub fn file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key = Some(input.into());
            self
        }
        /// <p>Object key name containing reference data.</p>
        pub fn set_file_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_key = input;
            self
        }
        /// <p>ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.</p>
        pub fn reference_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.</p>
        pub fn set_reference_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reference_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ReferenceDataSource`](crate::model::S3ReferenceDataSource)
        pub fn build(self) -> crate::model::S3ReferenceDataSource {
            crate::model::S3ReferenceDataSource {
                bucket_arn: self.bucket_arn,
                file_key: self.file_key,
                reference_role_arn: self.reference_role_arn,
            }
        }
    }
}
impl S3ReferenceDataSource {
    /// Creates a new builder-style object to manufacture [`S3ReferenceDataSource`](crate::model::S3ReferenceDataSource)
    pub fn builder() -> crate::model::s3_reference_data_source::Builder {
        crate::model::s3_reference_data_source::Builder::default()
    }
}
