// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamModeOutput {}
impl std::fmt::Debug for UpdateStreamModeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamModeOutput");
        formatter.finish()
    }
}
/// See [`UpdateStreamModeOutput`](crate::output::UpdateStreamModeOutput)
pub mod update_stream_mode_output {
    /// A builder for [`UpdateStreamModeOutput`](crate::output::UpdateStreamModeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateStreamModeOutput`](crate::output::UpdateStreamModeOutput)
        pub fn build(self) -> crate::output::UpdateStreamModeOutput {
            crate::output::UpdateStreamModeOutput {}
        }
    }
}
impl UpdateStreamModeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStreamModeOutput`](crate::output::UpdateStreamModeOutput)
    pub fn builder() -> crate::output::update_stream_mode_output::Builder {
        crate::output::update_stream_mode_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateShardCountOutput {
    /// <p>The name of the stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The current number of shards.</p>
    pub current_shard_count: std::option::Option<i32>,
    /// <p>The updated number of shards.</p>
    pub target_shard_count: std::option::Option<i32>,
}
impl UpdateShardCountOutput {
    /// <p>The name of the stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The current number of shards.</p>
    pub fn current_shard_count(&self) -> std::option::Option<i32> {
        self.current_shard_count
    }
    /// <p>The updated number of shards.</p>
    pub fn target_shard_count(&self) -> std::option::Option<i32> {
        self.target_shard_count
    }
}
impl std::fmt::Debug for UpdateShardCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateShardCountOutput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("current_shard_count", &self.current_shard_count);
        formatter.field("target_shard_count", &self.target_shard_count);
        formatter.finish()
    }
}
/// See [`UpdateShardCountOutput`](crate::output::UpdateShardCountOutput)
pub mod update_shard_count_output {
    /// A builder for [`UpdateShardCountOutput`](crate::output::UpdateShardCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) current_shard_count: std::option::Option<i32>,
        pub(crate) target_shard_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The current number of shards.</p>
        pub fn current_shard_count(mut self, input: i32) -> Self {
            self.current_shard_count = Some(input);
            self
        }
        /// <p>The current number of shards.</p>
        pub fn set_current_shard_count(mut self, input: std::option::Option<i32>) -> Self {
            self.current_shard_count = input;
            self
        }
        /// <p>The updated number of shards.</p>
        pub fn target_shard_count(mut self, input: i32) -> Self {
            self.target_shard_count = Some(input);
            self
        }
        /// <p>The updated number of shards.</p>
        pub fn set_target_shard_count(mut self, input: std::option::Option<i32>) -> Self {
            self.target_shard_count = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateShardCountOutput`](crate::output::UpdateShardCountOutput)
        pub fn build(self) -> crate::output::UpdateShardCountOutput {
            crate::output::UpdateShardCountOutput {
                stream_name: self.stream_name,
                current_shard_count: self.current_shard_count,
                target_shard_count: self.target_shard_count,
            }
        }
    }
}
impl UpdateShardCountOutput {
    /// Creates a new builder-style object to manufacture [`UpdateShardCountOutput`](crate::output::UpdateShardCountOutput)
    pub fn builder() -> crate::output::update_shard_count_output::Builder {
        crate::output::update_shard_count_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopStreamEncryptionOutput {}
impl std::fmt::Debug for StopStreamEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopStreamEncryptionOutput");
        formatter.finish()
    }
}
/// See [`StopStreamEncryptionOutput`](crate::output::StopStreamEncryptionOutput)
pub mod stop_stream_encryption_output {
    /// A builder for [`StopStreamEncryptionOutput`](crate::output::StopStreamEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopStreamEncryptionOutput`](crate::output::StopStreamEncryptionOutput)
        pub fn build(self) -> crate::output::StopStreamEncryptionOutput {
            crate::output::StopStreamEncryptionOutput {}
        }
    }
}
impl StopStreamEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`StopStreamEncryptionOutput`](crate::output::StopStreamEncryptionOutput)
    pub fn builder() -> crate::output::stop_stream_encryption_output::Builder {
        crate::output::stop_stream_encryption_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartStreamEncryptionOutput {}
impl std::fmt::Debug for StartStreamEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStreamEncryptionOutput");
        formatter.finish()
    }
}
/// See [`StartStreamEncryptionOutput`](crate::output::StartStreamEncryptionOutput)
pub mod start_stream_encryption_output {
    /// A builder for [`StartStreamEncryptionOutput`](crate::output::StartStreamEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartStreamEncryptionOutput`](crate::output::StartStreamEncryptionOutput)
        pub fn build(self) -> crate::output::StartStreamEncryptionOutput {
            crate::output::StartStreamEncryptionOutput {}
        }
    }
}
impl StartStreamEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`StartStreamEncryptionOutput`](crate::output::StartStreamEncryptionOutput)
    pub fn builder() -> crate::output::start_stream_encryption_output::Builder {
        crate::output::start_stream_encryption_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SplitShardOutput {}
impl std::fmt::Debug for SplitShardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SplitShardOutput");
        formatter.finish()
    }
}
/// See [`SplitShardOutput`](crate::output::SplitShardOutput)
pub mod split_shard_output {
    /// A builder for [`SplitShardOutput`](crate::output::SplitShardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SplitShardOutput`](crate::output::SplitShardOutput)
        pub fn build(self) -> crate::output::SplitShardOutput {
            crate::output::SplitShardOutput {}
        }
    }
}
impl SplitShardOutput {
    /// Creates a new builder-style object to manufacture [`SplitShardOutput`](crate::output::SplitShardOutput)
    pub fn builder() -> crate::output::split_shard_output::Builder {
        crate::output::split_shard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromStreamOutput {}
impl std::fmt::Debug for RemoveTagsFromStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromStreamOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromStreamOutput`](crate::output::RemoveTagsFromStreamOutput)
pub mod remove_tags_from_stream_output {
    /// A builder for [`RemoveTagsFromStreamOutput`](crate::output::RemoveTagsFromStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromStreamOutput`](crate::output::RemoveTagsFromStreamOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromStreamOutput {
            crate::output::RemoveTagsFromStreamOutput {}
        }
    }
}
impl RemoveTagsFromStreamOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromStreamOutput`](crate::output::RemoveTagsFromStreamOutput)
    pub fn builder() -> crate::output::remove_tags_from_stream_output::Builder {
        crate::output::remove_tags_from_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterStreamConsumerOutput {
    /// <p>An object that represents the details of the consumer you registered. When you
    /// register a consumer, it gets an ARN that is generated by Kinesis Data Streams.</p>
    pub consumer: std::option::Option<crate::model::Consumer>,
}
impl RegisterStreamConsumerOutput {
    /// <p>An object that represents the details of the consumer you registered. When you
    /// register a consumer, it gets an ARN that is generated by Kinesis Data Streams.</p>
    pub fn consumer(&self) -> std::option::Option<&crate::model::Consumer> {
        self.consumer.as_ref()
    }
}
impl std::fmt::Debug for RegisterStreamConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterStreamConsumerOutput");
        formatter.field("consumer", &self.consumer);
        formatter.finish()
    }
}
/// See [`RegisterStreamConsumerOutput`](crate::output::RegisterStreamConsumerOutput)
pub mod register_stream_consumer_output {
    /// A builder for [`RegisterStreamConsumerOutput`](crate::output::RegisterStreamConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer: std::option::Option<crate::model::Consumer>,
    }
    impl Builder {
        /// <p>An object that represents the details of the consumer you registered. When you
        /// register a consumer, it gets an ARN that is generated by Kinesis Data Streams.</p>
        pub fn consumer(mut self, input: crate::model::Consumer) -> Self {
            self.consumer = Some(input);
            self
        }
        /// <p>An object that represents the details of the consumer you registered. When you
        /// register a consumer, it gets an ARN that is generated by Kinesis Data Streams.</p>
        pub fn set_consumer(mut self, input: std::option::Option<crate::model::Consumer>) -> Self {
            self.consumer = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterStreamConsumerOutput`](crate::output::RegisterStreamConsumerOutput)
        pub fn build(self) -> crate::output::RegisterStreamConsumerOutput {
            crate::output::RegisterStreamConsumerOutput {
                consumer: self.consumer,
            }
        }
    }
}
impl RegisterStreamConsumerOutput {
    /// Creates a new builder-style object to manufacture [`RegisterStreamConsumerOutput`](crate::output::RegisterStreamConsumerOutput)
    pub fn builder() -> crate::output::register_stream_consumer_output::Builder {
        crate::output::register_stream_consumer_output::Builder::default()
    }
}

/// <p>
/// <code>PutRecords</code> results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordsOutput {
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code>
    /// request.</p>
    pub failed_record_count: std::option::Option<i32>,
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is
    /// successfully added to a stream includes <code>SequenceNumber</code> and
    /// <code>ShardId</code> in the result. A record that fails to be added to a stream
    /// includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub records: std::option::Option<std::vec::Vec<crate::model::PutRecordsResultEntry>>,
    /// <p>The encryption type used on the records. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records using a
    /// customer-managed Amazon Web Services KMS key.</p>
    /// </li>
    /// </ul>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
}
impl PutRecordsOutput {
    /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code>
    /// request.</p>
    pub fn failed_record_count(&self) -> std::option::Option<i32> {
        self.failed_record_count
    }
    /// <p>An array of successfully and unsuccessfully processed record results. A record that is
    /// successfully added to a stream includes <code>SequenceNumber</code> and
    /// <code>ShardId</code> in the result. A record that fails to be added to a stream
    /// includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
    pub fn records(&self) -> std::option::Option<&[crate::model::PutRecordsResultEntry]> {
        self.records.as_deref()
    }
    /// <p>The encryption type used on the records. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records using a
    /// customer-managed Amazon Web Services KMS key.</p>
    /// </li>
    /// </ul>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
}
impl std::fmt::Debug for PutRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordsOutput");
        formatter.field("failed_record_count", &self.failed_record_count);
        formatter.field("records", &self.records);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`PutRecordsOutput`](crate::output::PutRecordsOutput)
pub mod put_records_output {
    /// A builder for [`PutRecordsOutput`](crate::output::PutRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_record_count: std::option::Option<i32>,
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::PutRecordsResultEntry>>,
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
    }
    impl Builder {
        /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code>
        /// request.</p>
        pub fn failed_record_count(mut self, input: i32) -> Self {
            self.failed_record_count = Some(input);
            self
        }
        /// <p>The number of unsuccessfully processed records in a <code>PutRecords</code>
        /// request.</p>
        pub fn set_failed_record_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_record_count = input;
            self
        }
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>An array of successfully and unsuccessfully processed record results. A record that is
        /// successfully added to a stream includes <code>SequenceNumber</code> and
        /// <code>ShardId</code> in the result. A record that fails to be added to a stream
        /// includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
        pub fn records(mut self, input: impl Into<crate::model::PutRecordsResultEntry>) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input.into());
            self.records = Some(v);
            self
        }
        /// <p>An array of successfully and unsuccessfully processed record results. A record that is
        /// successfully added to a stream includes <code>SequenceNumber</code> and
        /// <code>ShardId</code> in the result. A record that fails to be added to a stream
        /// includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutRecordsResultEntry>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// <p>The encryption type used on the records. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records using a
        /// customer-managed Amazon Web Services KMS key.</p>
        /// </li>
        /// </ul>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The encryption type used on the records. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records using a
        /// customer-managed Amazon Web Services KMS key.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordsOutput`](crate::output::PutRecordsOutput)
        pub fn build(self) -> crate::output::PutRecordsOutput {
            crate::output::PutRecordsOutput {
                failed_record_count: self.failed_record_count,
                records: self.records,
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl PutRecordsOutput {
    /// Creates a new builder-style object to manufacture [`PutRecordsOutput`](crate::output::PutRecordsOutput)
    pub fn builder() -> crate::output::put_records_output::Builder {
        crate::output::put_records_output::Builder::default()
    }
}

/// <p>Represents the output for <code>PutRecord</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordOutput {
    /// <p>The shard ID of the shard where the data record was placed.</p>
    pub shard_id: std::option::Option<std::string::String>,
    /// <p>The sequence number identifier that was assigned to the put data record. The sequence
    /// number for the record is unique across all records in the stream. A sequence number is
    /// the identifier associated with every record put into the stream.</p>
    pub sequence_number: std::option::Option<std::string::String>,
    /// <p>The encryption type to use on the record. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed Amazon Web Services KMS key.</p>
    /// </li>
    /// </ul>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
}
impl PutRecordOutput {
    /// <p>The shard ID of the shard where the data record was placed.</p>
    pub fn shard_id(&self) -> std::option::Option<&str> {
        self.shard_id.as_deref()
    }
    /// <p>The sequence number identifier that was assigned to the put data record. The sequence
    /// number for the record is unique across all records in the stream. A sequence number is
    /// the identifier associated with every record put into the stream.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
    /// <p>The encryption type to use on the record. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed Amazon Web Services KMS key.</p>
    /// </li>
    /// </ul>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
}
impl std::fmt::Debug for PutRecordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordOutput");
        formatter.field("shard_id", &self.shard_id);
        formatter.field("sequence_number", &self.sequence_number);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`PutRecordOutput`](crate::output::PutRecordOutput)
pub mod put_record_output {
    /// A builder for [`PutRecordOutput`](crate::output::PutRecordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_id: std::option::Option<std::string::String>,
        pub(crate) sequence_number: std::option::Option<std::string::String>,
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
    }
    impl Builder {
        /// <p>The shard ID of the shard where the data record was placed.</p>
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_id = Some(input.into());
            self
        }
        /// <p>The shard ID of the shard where the data record was placed.</p>
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_id = input;
            self
        }
        /// <p>The sequence number identifier that was assigned to the put data record. The sequence
        /// number for the record is unique across all records in the stream. A sequence number is
        /// the identifier associated with every record put into the stream.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>The sequence number identifier that was assigned to the put data record. The sequence
        /// number for the record is unique across all records in the stream. A sequence number is
        /// the identifier associated with every record put into the stream.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// <p>The encryption type to use on the record. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed Amazon Web Services KMS key.</p>
        /// </li>
        /// </ul>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The encryption type to use on the record. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed Amazon Web Services KMS key.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordOutput`](crate::output::PutRecordOutput)
        pub fn build(self) -> crate::output::PutRecordOutput {
            crate::output::PutRecordOutput {
                shard_id: self.shard_id,
                sequence_number: self.sequence_number,
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl PutRecordOutput {
    /// Creates a new builder-style object to manufacture [`PutRecordOutput`](crate::output::PutRecordOutput)
    pub fn builder() -> crate::output::put_record_output::Builder {
        crate::output::put_record_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeShardsOutput {}
impl std::fmt::Debug for MergeShardsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeShardsOutput");
        formatter.finish()
    }
}
/// See [`MergeShardsOutput`](crate::output::MergeShardsOutput)
pub mod merge_shards_output {
    /// A builder for [`MergeShardsOutput`](crate::output::MergeShardsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`MergeShardsOutput`](crate::output::MergeShardsOutput)
        pub fn build(self) -> crate::output::MergeShardsOutput {
            crate::output::MergeShardsOutput {}
        }
    }
}
impl MergeShardsOutput {
    /// Creates a new builder-style object to manufacture [`MergeShardsOutput`](crate::output::MergeShardsOutput)
    pub fn builder() -> crate::output::merge_shards_output::Builder {
        crate::output::merge_shards_output::Builder::default()
    }
}

/// <p>Represents the output for <code>ListTagsForStream</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForStreamOutput {
    /// <p>A list of tags associated with <code>StreamName</code>, starting with the first tag
    /// after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
    /// </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If set to <code>true</code>, more tags are available. To request additional tags, set
    /// <code>ExclusiveStartTagKey</code> to the key of the last tag returned.</p>
    pub has_more_tags: std::option::Option<bool>,
}
impl ListTagsForStreamOutput {
    /// <p>A list of tags associated with <code>StreamName</code>, starting with the first tag
    /// after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
    /// </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If set to <code>true</code>, more tags are available. To request additional tags, set
    /// <code>ExclusiveStartTagKey</code> to the key of the last tag returned.</p>
    pub fn has_more_tags(&self) -> std::option::Option<bool> {
        self.has_more_tags
    }
}
impl std::fmt::Debug for ListTagsForStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForStreamOutput");
        formatter.field("tags", &self.tags);
        formatter.field("has_more_tags", &self.has_more_tags);
        formatter.finish()
    }
}
/// See [`ListTagsForStreamOutput`](crate::output::ListTagsForStreamOutput)
pub mod list_tags_for_stream_output {
    /// A builder for [`ListTagsForStreamOutput`](crate::output::ListTagsForStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) has_more_tags: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with <code>StreamName</code>, starting with the first tag
        /// after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
        /// </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with <code>StreamName</code>, starting with the first tag
        /// after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If set to <code>true</code>, more tags are available. To request additional tags, set
        /// <code>ExclusiveStartTagKey</code> to the key of the last tag returned.</p>
        pub fn has_more_tags(mut self, input: bool) -> Self {
            self.has_more_tags = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, more tags are available. To request additional tags, set
        /// <code>ExclusiveStartTagKey</code> to the key of the last tag returned.</p>
        pub fn set_has_more_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForStreamOutput`](crate::output::ListTagsForStreamOutput)
        pub fn build(self) -> crate::output::ListTagsForStreamOutput {
            crate::output::ListTagsForStreamOutput {
                tags: self.tags,
                has_more_tags: self.has_more_tags,
            }
        }
    }
}
impl ListTagsForStreamOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForStreamOutput`](crate::output::ListTagsForStreamOutput)
    pub fn builder() -> crate::output::list_tags_for_stream_output::Builder {
        crate::output::list_tags_for_stream_output::Builder::default()
    }
}

/// <p>Represents the output for <code>ListStreams</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamsOutput {
    /// <p>The names of the streams that are associated with the Amazon Web Services account
    /// making the <code>ListStreams</code> request.</p>
    pub stream_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If set to <code>true</code>, there are more streams available to list.</p>
    pub has_more_streams: std::option::Option<bool>,
}
impl ListStreamsOutput {
    /// <p>The names of the streams that are associated with the Amazon Web Services account
    /// making the <code>ListStreams</code> request.</p>
    pub fn stream_names(&self) -> std::option::Option<&[std::string::String]> {
        self.stream_names.as_deref()
    }
    /// <p>If set to <code>true</code>, there are more streams available to list.</p>
    pub fn has_more_streams(&self) -> std::option::Option<bool> {
        self.has_more_streams
    }
}
impl std::fmt::Debug for ListStreamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamsOutput");
        formatter.field("stream_names", &self.stream_names);
        formatter.field("has_more_streams", &self.has_more_streams);
        formatter.finish()
    }
}
/// See [`ListStreamsOutput`](crate::output::ListStreamsOutput)
pub mod list_streams_output {
    /// A builder for [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) has_more_streams: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `stream_names`.
        ///
        /// To override the contents of this collection use [`set_stream_names`](Self::set_stream_names).
        ///
        /// <p>The names of the streams that are associated with the Amazon Web Services account
        /// making the <code>ListStreams</code> request.</p>
        pub fn stream_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.stream_names.unwrap_or_default();
            v.push(input.into());
            self.stream_names = Some(v);
            self
        }
        /// <p>The names of the streams that are associated with the Amazon Web Services account
        /// making the <code>ListStreams</code> request.</p>
        pub fn set_stream_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.stream_names = input;
            self
        }
        /// <p>If set to <code>true</code>, there are more streams available to list.</p>
        pub fn has_more_streams(mut self, input: bool) -> Self {
            self.has_more_streams = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, there are more streams available to list.</p>
        pub fn set_has_more_streams(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamsOutput`](crate::output::ListStreamsOutput)
        pub fn build(self) -> crate::output::ListStreamsOutput {
            crate::output::ListStreamsOutput {
                stream_names: self.stream_names,
                has_more_streams: self.has_more_streams,
            }
        }
    }
}
impl ListStreamsOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    pub fn builder() -> crate::output::list_streams_output::Builder {
        crate::output::list_streams_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamConsumersOutput {
    /// <p>An array of JSON objects. Each object represents one registered consumer.</p>
    pub consumers: std::option::Option<std::vec::Vec<crate::model::Consumer>>,
    /// <p>When the number of consumers that are registered with the data stream is greater than
    /// the default value for the <code>MaxResults</code> parameter, or if you explicitly
    /// specify a value for <code>MaxResults</code> that is less than the number of registered
    /// consumers, the response includes a pagination token named <code>NextToken</code>. You
    /// can specify this <code>NextToken</code> value in a subsequent call to
    /// <code>ListStreamConsumers</code> to list the next set of registered consumers. For
    /// more information about the use of this pagination token when calling the
    /// <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
    /// <important>
    /// <p>Tokens expire after 300 seconds. When you obtain a value for
    /// <code>NextToken</code> in the response to a call to
    /// <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you
    /// specify an expired token in a call to <code>ListStreamConsumers</code>, you get
    /// <code>ExpiredNextTokenException</code>.</p>
    /// </important>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStreamConsumersOutput {
    /// <p>An array of JSON objects. Each object represents one registered consumer.</p>
    pub fn consumers(&self) -> std::option::Option<&[crate::model::Consumer]> {
        self.consumers.as_deref()
    }
    /// <p>When the number of consumers that are registered with the data stream is greater than
    /// the default value for the <code>MaxResults</code> parameter, or if you explicitly
    /// specify a value for <code>MaxResults</code> that is less than the number of registered
    /// consumers, the response includes a pagination token named <code>NextToken</code>. You
    /// can specify this <code>NextToken</code> value in a subsequent call to
    /// <code>ListStreamConsumers</code> to list the next set of registered consumers. For
    /// more information about the use of this pagination token when calling the
    /// <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
    /// <important>
    /// <p>Tokens expire after 300 seconds. When you obtain a value for
    /// <code>NextToken</code> in the response to a call to
    /// <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you
    /// specify an expired token in a call to <code>ListStreamConsumers</code>, you get
    /// <code>ExpiredNextTokenException</code>.</p>
    /// </important>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStreamConsumersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamConsumersOutput");
        formatter.field("consumers", &self.consumers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStreamConsumersOutput`](crate::output::ListStreamConsumersOutput)
pub mod list_stream_consumers_output {
    /// A builder for [`ListStreamConsumersOutput`](crate::output::ListStreamConsumersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumers: std::option::Option<std::vec::Vec<crate::model::Consumer>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `consumers`.
        ///
        /// To override the contents of this collection use [`set_consumers`](Self::set_consumers).
        ///
        /// <p>An array of JSON objects. Each object represents one registered consumer.</p>
        pub fn consumers(mut self, input: impl Into<crate::model::Consumer>) -> Self {
            let mut v = self.consumers.unwrap_or_default();
            v.push(input.into());
            self.consumers = Some(v);
            self
        }
        /// <p>An array of JSON objects. Each object represents one registered consumer.</p>
        pub fn set_consumers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Consumer>>,
        ) -> Self {
            self.consumers = input;
            self
        }
        /// <p>When the number of consumers that are registered with the data stream is greater than
        /// the default value for the <code>MaxResults</code> parameter, or if you explicitly
        /// specify a value for <code>MaxResults</code> that is less than the number of registered
        /// consumers, the response includes a pagination token named <code>NextToken</code>. You
        /// can specify this <code>NextToken</code> value in a subsequent call to
        /// <code>ListStreamConsumers</code> to list the next set of registered consumers. For
        /// more information about the use of this pagination token when calling the
        /// <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
        /// <important>
        /// <p>Tokens expire after 300 seconds. When you obtain a value for
        /// <code>NextToken</code> in the response to a call to
        /// <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you
        /// specify an expired token in a call to <code>ListStreamConsumers</code>, you get
        /// <code>ExpiredNextTokenException</code>.</p>
        /// </important>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When the number of consumers that are registered with the data stream is greater than
        /// the default value for the <code>MaxResults</code> parameter, or if you explicitly
        /// specify a value for <code>MaxResults</code> that is less than the number of registered
        /// consumers, the response includes a pagination token named <code>NextToken</code>. You
        /// can specify this <code>NextToken</code> value in a subsequent call to
        /// <code>ListStreamConsumers</code> to list the next set of registered consumers. For
        /// more information about the use of this pagination token when calling the
        /// <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
        /// <important>
        /// <p>Tokens expire after 300 seconds. When you obtain a value for
        /// <code>NextToken</code> in the response to a call to
        /// <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you
        /// specify an expired token in a call to <code>ListStreamConsumers</code>, you get
        /// <code>ExpiredNextTokenException</code>.</p>
        /// </important>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamConsumersOutput`](crate::output::ListStreamConsumersOutput)
        pub fn build(self) -> crate::output::ListStreamConsumersOutput {
            crate::output::ListStreamConsumersOutput {
                consumers: self.consumers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStreamConsumersOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamConsumersOutput`](crate::output::ListStreamConsumersOutput)
    pub fn builder() -> crate::output::list_stream_consumers_output::Builder {
        crate::output::list_stream_consumers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListShardsOutput {
    /// <p>An array of JSON objects. Each object represents one shard and specifies the IDs of
    /// the shard, the shard's parent, and the shard that's adjacent to the shard's parent. Each
    /// object also contains the starting and ending hash keys and the starting and ending
    /// sequence numbers for the shard.</p>
    pub shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
    /// <p>When the number of shards in the data stream is greater than the default value for the
    /// <code>MaxResults</code> parameter, or if you explicitly specify a value for
    /// <code>MaxResults</code> that is less than the number of shards in the data stream,
    /// the response includes a pagination token named <code>NextToken</code>. You can specify
    /// this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to
    /// list the next set of shards. For more information about the use of this pagination token
    /// when calling the <code>ListShards</code> operation, see <a>ListShardsInput$NextToken</a>.</p>
    /// <important>
    /// <p>Tokens expire after 300 seconds. When you obtain a value for
    /// <code>NextToken</code> in the response to a call to <code>ListShards</code>, you
    /// have 300 seconds to use that value. If you specify an expired token in a call to
    /// <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.</p>
    /// </important>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListShardsOutput {
    /// <p>An array of JSON objects. Each object represents one shard and specifies the IDs of
    /// the shard, the shard's parent, and the shard that's adjacent to the shard's parent. Each
    /// object also contains the starting and ending hash keys and the starting and ending
    /// sequence numbers for the shard.</p>
    pub fn shards(&self) -> std::option::Option<&[crate::model::Shard]> {
        self.shards.as_deref()
    }
    /// <p>When the number of shards in the data stream is greater than the default value for the
    /// <code>MaxResults</code> parameter, or if you explicitly specify a value for
    /// <code>MaxResults</code> that is less than the number of shards in the data stream,
    /// the response includes a pagination token named <code>NextToken</code>. You can specify
    /// this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to
    /// list the next set of shards. For more information about the use of this pagination token
    /// when calling the <code>ListShards</code> operation, see <a>ListShardsInput$NextToken</a>.</p>
    /// <important>
    /// <p>Tokens expire after 300 seconds. When you obtain a value for
    /// <code>NextToken</code> in the response to a call to <code>ListShards</code>, you
    /// have 300 seconds to use that value. If you specify an expired token in a call to
    /// <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.</p>
    /// </important>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListShardsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListShardsOutput");
        formatter.field("shards", &self.shards);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListShardsOutput`](crate::output::ListShardsOutput)
pub mod list_shards_output {
    /// A builder for [`ListShardsOutput`](crate::output::ListShardsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `shards`.
        ///
        /// To override the contents of this collection use [`set_shards`](Self::set_shards).
        ///
        /// <p>An array of JSON objects. Each object represents one shard and specifies the IDs of
        /// the shard, the shard's parent, and the shard that's adjacent to the shard's parent. Each
        /// object also contains the starting and ending hash keys and the starting and ending
        /// sequence numbers for the shard.</p>
        pub fn shards(mut self, input: impl Into<crate::model::Shard>) -> Self {
            let mut v = self.shards.unwrap_or_default();
            v.push(input.into());
            self.shards = Some(v);
            self
        }
        /// <p>An array of JSON objects. Each object represents one shard and specifies the IDs of
        /// the shard, the shard's parent, and the shard that's adjacent to the shard's parent. Each
        /// object also contains the starting and ending hash keys and the starting and ending
        /// sequence numbers for the shard.</p>
        pub fn set_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        ) -> Self {
            self.shards = input;
            self
        }
        /// <p>When the number of shards in the data stream is greater than the default value for the
        /// <code>MaxResults</code> parameter, or if you explicitly specify a value for
        /// <code>MaxResults</code> that is less than the number of shards in the data stream,
        /// the response includes a pagination token named <code>NextToken</code>. You can specify
        /// this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to
        /// list the next set of shards. For more information about the use of this pagination token
        /// when calling the <code>ListShards</code> operation, see <a>ListShardsInput$NextToken</a>.</p>
        /// <important>
        /// <p>Tokens expire after 300 seconds. When you obtain a value for
        /// <code>NextToken</code> in the response to a call to <code>ListShards</code>, you
        /// have 300 seconds to use that value. If you specify an expired token in a call to
        /// <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.</p>
        /// </important>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When the number of shards in the data stream is greater than the default value for the
        /// <code>MaxResults</code> parameter, or if you explicitly specify a value for
        /// <code>MaxResults</code> that is less than the number of shards in the data stream,
        /// the response includes a pagination token named <code>NextToken</code>. You can specify
        /// this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to
        /// list the next set of shards. For more information about the use of this pagination token
        /// when calling the <code>ListShards</code> operation, see <a>ListShardsInput$NextToken</a>.</p>
        /// <important>
        /// <p>Tokens expire after 300 seconds. When you obtain a value for
        /// <code>NextToken</code> in the response to a call to <code>ListShards</code>, you
        /// have 300 seconds to use that value. If you specify an expired token in a call to
        /// <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.</p>
        /// </important>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListShardsOutput`](crate::output::ListShardsOutput)
        pub fn build(self) -> crate::output::ListShardsOutput {
            crate::output::ListShardsOutput {
                shards: self.shards,
                next_token: self.next_token,
            }
        }
    }
}
impl ListShardsOutput {
    /// Creates a new builder-style object to manufacture [`ListShardsOutput`](crate::output::ListShardsOutput)
    pub fn builder() -> crate::output::list_shards_output::Builder {
        crate::output::list_shards_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncreaseStreamRetentionPeriodOutput {}
impl std::fmt::Debug for IncreaseStreamRetentionPeriodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncreaseStreamRetentionPeriodOutput");
        formatter.finish()
    }
}
/// See [`IncreaseStreamRetentionPeriodOutput`](crate::output::IncreaseStreamRetentionPeriodOutput)
pub mod increase_stream_retention_period_output {
    /// A builder for [`IncreaseStreamRetentionPeriodOutput`](crate::output::IncreaseStreamRetentionPeriodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`IncreaseStreamRetentionPeriodOutput`](crate::output::IncreaseStreamRetentionPeriodOutput)
        pub fn build(self) -> crate::output::IncreaseStreamRetentionPeriodOutput {
            crate::output::IncreaseStreamRetentionPeriodOutput {}
        }
    }
}
impl IncreaseStreamRetentionPeriodOutput {
    /// Creates a new builder-style object to manufacture [`IncreaseStreamRetentionPeriodOutput`](crate::output::IncreaseStreamRetentionPeriodOutput)
    pub fn builder() -> crate::output::increase_stream_retention_period_output::Builder {
        crate::output::increase_stream_retention_period_output::Builder::default()
    }
}

/// <p>Represents the output for <code>GetShardIterator</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetShardIteratorOutput {
    /// <p>The position in the shard from which to start reading data records sequentially. A
    /// shard iterator specifies this position using the sequence number of a data record in a
    /// shard.</p>
    pub shard_iterator: std::option::Option<std::string::String>,
}
impl GetShardIteratorOutput {
    /// <p>The position in the shard from which to start reading data records sequentially. A
    /// shard iterator specifies this position using the sequence number of a data record in a
    /// shard.</p>
    pub fn shard_iterator(&self) -> std::option::Option<&str> {
        self.shard_iterator.as_deref()
    }
}
impl std::fmt::Debug for GetShardIteratorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetShardIteratorOutput");
        formatter.field("shard_iterator", &self.shard_iterator);
        formatter.finish()
    }
}
/// See [`GetShardIteratorOutput`](crate::output::GetShardIteratorOutput)
pub mod get_shard_iterator_output {
    /// A builder for [`GetShardIteratorOutput`](crate::output::GetShardIteratorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_iterator: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The position in the shard from which to start reading data records sequentially. A
        /// shard iterator specifies this position using the sequence number of a data record in a
        /// shard.</p>
        pub fn shard_iterator(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_iterator = Some(input.into());
            self
        }
        /// <p>The position in the shard from which to start reading data records sequentially. A
        /// shard iterator specifies this position using the sequence number of a data record in a
        /// shard.</p>
        pub fn set_shard_iterator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shard_iterator = input;
            self
        }
        /// Consumes the builder and constructs a [`GetShardIteratorOutput`](crate::output::GetShardIteratorOutput)
        pub fn build(self) -> crate::output::GetShardIteratorOutput {
            crate::output::GetShardIteratorOutput {
                shard_iterator: self.shard_iterator,
            }
        }
    }
}
impl GetShardIteratorOutput {
    /// Creates a new builder-style object to manufacture [`GetShardIteratorOutput`](crate::output::GetShardIteratorOutput)
    pub fn builder() -> crate::output::get_shard_iterator_output::Builder {
        crate::output::get_shard_iterator_output::Builder::default()
    }
}

/// <p>Represents the output for <a>GetRecords</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecordsOutput {
    /// <p>The data records retrieved from the shard.</p>
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    /// <p>The next position in the shard from which to start sequentially reading data records.
    /// If set to <code>null</code>, the shard has been closed and the requested iterator does
    /// not return any more data. </p>
    pub next_shard_iterator: std::option::Option<std::string::String>,
    /// <p>The number of milliseconds the <a>GetRecords</a> response is from the tip
    /// of the stream, indicating how far behind current time the consumer is. A value of zero
    /// indicates that record processing is caught up, and there are no new records to process
    /// at this moment.</p>
    pub millis_behind_latest: std::option::Option<i64>,
    /// <p>The list of the current shard's child shards, returned in the <code>GetRecords</code>
    /// API's response only when the end of the current shard is reached.</p>
    pub child_shards: std::option::Option<std::vec::Vec<crate::model::ChildShard>>,
}
impl GetRecordsOutput {
    /// <p>The data records retrieved from the shard.</p>
    pub fn records(&self) -> std::option::Option<&[crate::model::Record]> {
        self.records.as_deref()
    }
    /// <p>The next position in the shard from which to start sequentially reading data records.
    /// If set to <code>null</code>, the shard has been closed and the requested iterator does
    /// not return any more data. </p>
    pub fn next_shard_iterator(&self) -> std::option::Option<&str> {
        self.next_shard_iterator.as_deref()
    }
    /// <p>The number of milliseconds the <a>GetRecords</a> response is from the tip
    /// of the stream, indicating how far behind current time the consumer is. A value of zero
    /// indicates that record processing is caught up, and there are no new records to process
    /// at this moment.</p>
    pub fn millis_behind_latest(&self) -> std::option::Option<i64> {
        self.millis_behind_latest
    }
    /// <p>The list of the current shard's child shards, returned in the <code>GetRecords</code>
    /// API's response only when the end of the current shard is reached.</p>
    pub fn child_shards(&self) -> std::option::Option<&[crate::model::ChildShard]> {
        self.child_shards.as_deref()
    }
}
impl std::fmt::Debug for GetRecordsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecordsOutput");
        formatter.field("records", &self.records);
        formatter.field("next_shard_iterator", &self.next_shard_iterator);
        formatter.field("millis_behind_latest", &self.millis_behind_latest);
        formatter.field("child_shards", &self.child_shards);
        formatter.finish()
    }
}
/// See [`GetRecordsOutput`](crate::output::GetRecordsOutput)
pub mod get_records_output {
    /// A builder for [`GetRecordsOutput`](crate::output::GetRecordsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
        pub(crate) next_shard_iterator: std::option::Option<std::string::String>,
        pub(crate) millis_behind_latest: std::option::Option<i64>,
        pub(crate) child_shards: std::option::Option<std::vec::Vec<crate::model::ChildShard>>,
    }
    impl Builder {
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>The data records retrieved from the shard.</p>
        pub fn records(mut self, input: impl Into<crate::model::Record>) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input.into());
            self.records = Some(v);
            self
        }
        /// <p>The data records retrieved from the shard.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// <p>The next position in the shard from which to start sequentially reading data records.
        /// If set to <code>null</code>, the shard has been closed and the requested iterator does
        /// not return any more data. </p>
        pub fn next_shard_iterator(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_shard_iterator = Some(input.into());
            self
        }
        /// <p>The next position in the shard from which to start sequentially reading data records.
        /// If set to <code>null</code>, the shard has been closed and the requested iterator does
        /// not return any more data. </p>
        pub fn set_next_shard_iterator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_shard_iterator = input;
            self
        }
        /// <p>The number of milliseconds the <a>GetRecords</a> response is from the tip
        /// of the stream, indicating how far behind current time the consumer is. A value of zero
        /// indicates that record processing is caught up, and there are no new records to process
        /// at this moment.</p>
        pub fn millis_behind_latest(mut self, input: i64) -> Self {
            self.millis_behind_latest = Some(input);
            self
        }
        /// <p>The number of milliseconds the <a>GetRecords</a> response is from the tip
        /// of the stream, indicating how far behind current time the consumer is. A value of zero
        /// indicates that record processing is caught up, and there are no new records to process
        /// at this moment.</p>
        pub fn set_millis_behind_latest(mut self, input: std::option::Option<i64>) -> Self {
            self.millis_behind_latest = input;
            self
        }
        /// Appends an item to `child_shards`.
        ///
        /// To override the contents of this collection use [`set_child_shards`](Self::set_child_shards).
        ///
        /// <p>The list of the current shard's child shards, returned in the <code>GetRecords</code>
        /// API's response only when the end of the current shard is reached.</p>
        pub fn child_shards(mut self, input: impl Into<crate::model::ChildShard>) -> Self {
            let mut v = self.child_shards.unwrap_or_default();
            v.push(input.into());
            self.child_shards = Some(v);
            self
        }
        /// <p>The list of the current shard's child shards, returned in the <code>GetRecords</code>
        /// API's response only when the end of the current shard is reached.</p>
        pub fn set_child_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChildShard>>,
        ) -> Self {
            self.child_shards = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecordsOutput`](crate::output::GetRecordsOutput)
        pub fn build(self) -> crate::output::GetRecordsOutput {
            crate::output::GetRecordsOutput {
                records: self.records,
                next_shard_iterator: self.next_shard_iterator,
                millis_behind_latest: self.millis_behind_latest,
                child_shards: self.child_shards,
            }
        }
    }
}
impl GetRecordsOutput {
    /// Creates a new builder-style object to manufacture [`GetRecordsOutput`](crate::output::GetRecordsOutput)
    pub fn builder() -> crate::output::get_records_output::Builder {
        crate::output::get_records_output::Builder::default()
    }
}

/// <p>Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableEnhancedMonitoringOutput {
    /// <p>The name of the Kinesis data stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>Represents the current state of the metrics that are in the enhanced state before the
    /// operation.</p>
    pub current_shard_level_metrics: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
    /// <p>Represents the list of all the metrics that would be in the enhanced state after the
    /// operation.</p>
    pub desired_shard_level_metrics: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
}
impl EnableEnhancedMonitoringOutput {
    /// <p>The name of the Kinesis data stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>Represents the current state of the metrics that are in the enhanced state before the
    /// operation.</p>
    pub fn current_shard_level_metrics(&self) -> std::option::Option<&[crate::model::MetricsName]> {
        self.current_shard_level_metrics.as_deref()
    }
    /// <p>Represents the list of all the metrics that would be in the enhanced state after the
    /// operation.</p>
    pub fn desired_shard_level_metrics(&self) -> std::option::Option<&[crate::model::MetricsName]> {
        self.desired_shard_level_metrics.as_deref()
    }
}
impl std::fmt::Debug for EnableEnhancedMonitoringOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableEnhancedMonitoringOutput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field(
            "current_shard_level_metrics",
            &self.current_shard_level_metrics,
        );
        formatter.field(
            "desired_shard_level_metrics",
            &self.desired_shard_level_metrics,
        );
        formatter.finish()
    }
}
/// See [`EnableEnhancedMonitoringOutput`](crate::output::EnableEnhancedMonitoringOutput)
pub mod enable_enhanced_monitoring_output {
    /// A builder for [`EnableEnhancedMonitoringOutput`](crate::output::EnableEnhancedMonitoringOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) current_shard_level_metrics:
            std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        pub(crate) desired_shard_level_metrics:
            std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
    }
    impl Builder {
        /// <p>The name of the Kinesis data stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis data stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Appends an item to `current_shard_level_metrics`.
        ///
        /// To override the contents of this collection use [`set_current_shard_level_metrics`](Self::set_current_shard_level_metrics).
        ///
        /// <p>Represents the current state of the metrics that are in the enhanced state before the
        /// operation.</p>
        pub fn current_shard_level_metrics(
            mut self,
            input: impl Into<crate::model::MetricsName>,
        ) -> Self {
            let mut v = self.current_shard_level_metrics.unwrap_or_default();
            v.push(input.into());
            self.current_shard_level_metrics = Some(v);
            self
        }
        /// <p>Represents the current state of the metrics that are in the enhanced state before the
        /// operation.</p>
        pub fn set_current_shard_level_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        ) -> Self {
            self.current_shard_level_metrics = input;
            self
        }
        /// Appends an item to `desired_shard_level_metrics`.
        ///
        /// To override the contents of this collection use [`set_desired_shard_level_metrics`](Self::set_desired_shard_level_metrics).
        ///
        /// <p>Represents the list of all the metrics that would be in the enhanced state after the
        /// operation.</p>
        pub fn desired_shard_level_metrics(
            mut self,
            input: impl Into<crate::model::MetricsName>,
        ) -> Self {
            let mut v = self.desired_shard_level_metrics.unwrap_or_default();
            v.push(input.into());
            self.desired_shard_level_metrics = Some(v);
            self
        }
        /// <p>Represents the list of all the metrics that would be in the enhanced state after the
        /// operation.</p>
        pub fn set_desired_shard_level_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        ) -> Self {
            self.desired_shard_level_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableEnhancedMonitoringOutput`](crate::output::EnableEnhancedMonitoringOutput)
        pub fn build(self) -> crate::output::EnableEnhancedMonitoringOutput {
            crate::output::EnableEnhancedMonitoringOutput {
                stream_name: self.stream_name,
                current_shard_level_metrics: self.current_shard_level_metrics,
                desired_shard_level_metrics: self.desired_shard_level_metrics,
            }
        }
    }
}
impl EnableEnhancedMonitoringOutput {
    /// Creates a new builder-style object to manufacture [`EnableEnhancedMonitoringOutput`](crate::output::EnableEnhancedMonitoringOutput)
    pub fn builder() -> crate::output::enable_enhanced_monitoring_output::Builder {
        crate::output::enable_enhanced_monitoring_output::Builder::default()
    }
}

/// <p>Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableEnhancedMonitoringOutput {
    /// <p>The name of the Kinesis data stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>Represents the current state of the metrics that are in the enhanced state before the
    /// operation.</p>
    pub current_shard_level_metrics: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
    /// <p>Represents the list of all the metrics that would be in the enhanced state after the
    /// operation.</p>
    pub desired_shard_level_metrics: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
}
impl DisableEnhancedMonitoringOutput {
    /// <p>The name of the Kinesis data stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>Represents the current state of the metrics that are in the enhanced state before the
    /// operation.</p>
    pub fn current_shard_level_metrics(&self) -> std::option::Option<&[crate::model::MetricsName]> {
        self.current_shard_level_metrics.as_deref()
    }
    /// <p>Represents the list of all the metrics that would be in the enhanced state after the
    /// operation.</p>
    pub fn desired_shard_level_metrics(&self) -> std::option::Option<&[crate::model::MetricsName]> {
        self.desired_shard_level_metrics.as_deref()
    }
}
impl std::fmt::Debug for DisableEnhancedMonitoringOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableEnhancedMonitoringOutput");
        formatter.field("stream_name", &self.stream_name);
        formatter.field(
            "current_shard_level_metrics",
            &self.current_shard_level_metrics,
        );
        formatter.field(
            "desired_shard_level_metrics",
            &self.desired_shard_level_metrics,
        );
        formatter.finish()
    }
}
/// See [`DisableEnhancedMonitoringOutput`](crate::output::DisableEnhancedMonitoringOutput)
pub mod disable_enhanced_monitoring_output {
    /// A builder for [`DisableEnhancedMonitoringOutput`](crate::output::DisableEnhancedMonitoringOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) current_shard_level_metrics:
            std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        pub(crate) desired_shard_level_metrics:
            std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
    }
    impl Builder {
        /// <p>The name of the Kinesis data stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis data stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Appends an item to `current_shard_level_metrics`.
        ///
        /// To override the contents of this collection use [`set_current_shard_level_metrics`](Self::set_current_shard_level_metrics).
        ///
        /// <p>Represents the current state of the metrics that are in the enhanced state before the
        /// operation.</p>
        pub fn current_shard_level_metrics(
            mut self,
            input: impl Into<crate::model::MetricsName>,
        ) -> Self {
            let mut v = self.current_shard_level_metrics.unwrap_or_default();
            v.push(input.into());
            self.current_shard_level_metrics = Some(v);
            self
        }
        /// <p>Represents the current state of the metrics that are in the enhanced state before the
        /// operation.</p>
        pub fn set_current_shard_level_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        ) -> Self {
            self.current_shard_level_metrics = input;
            self
        }
        /// Appends an item to `desired_shard_level_metrics`.
        ///
        /// To override the contents of this collection use [`set_desired_shard_level_metrics`](Self::set_desired_shard_level_metrics).
        ///
        /// <p>Represents the list of all the metrics that would be in the enhanced state after the
        /// operation.</p>
        pub fn desired_shard_level_metrics(
            mut self,
            input: impl Into<crate::model::MetricsName>,
        ) -> Self {
            let mut v = self.desired_shard_level_metrics.unwrap_or_default();
            v.push(input.into());
            self.desired_shard_level_metrics = Some(v);
            self
        }
        /// <p>Represents the list of all the metrics that would be in the enhanced state after the
        /// operation.</p>
        pub fn set_desired_shard_level_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        ) -> Self {
            self.desired_shard_level_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableEnhancedMonitoringOutput`](crate::output::DisableEnhancedMonitoringOutput)
        pub fn build(self) -> crate::output::DisableEnhancedMonitoringOutput {
            crate::output::DisableEnhancedMonitoringOutput {
                stream_name: self.stream_name,
                current_shard_level_metrics: self.current_shard_level_metrics,
                desired_shard_level_metrics: self.desired_shard_level_metrics,
            }
        }
    }
}
impl DisableEnhancedMonitoringOutput {
    /// Creates a new builder-style object to manufacture [`DisableEnhancedMonitoringOutput`](crate::output::DisableEnhancedMonitoringOutput)
    pub fn builder() -> crate::output::disable_enhanced_monitoring_output::Builder {
        crate::output::disable_enhanced_monitoring_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStreamSummaryOutput {
    /// <p>A <a>StreamDescriptionSummary</a> containing information about the
    /// stream.</p>
    pub stream_description_summary: std::option::Option<crate::model::StreamDescriptionSummary>,
}
impl DescribeStreamSummaryOutput {
    /// <p>A <a>StreamDescriptionSummary</a> containing information about the
    /// stream.</p>
    pub fn stream_description_summary(
        &self,
    ) -> std::option::Option<&crate::model::StreamDescriptionSummary> {
        self.stream_description_summary.as_ref()
    }
}
impl std::fmt::Debug for DescribeStreamSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStreamSummaryOutput");
        formatter.field(
            "stream_description_summary",
            &self.stream_description_summary,
        );
        formatter.finish()
    }
}
/// See [`DescribeStreamSummaryOutput`](crate::output::DescribeStreamSummaryOutput)
pub mod describe_stream_summary_output {
    /// A builder for [`DescribeStreamSummaryOutput`](crate::output::DescribeStreamSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_description_summary:
            std::option::Option<crate::model::StreamDescriptionSummary>,
    }
    impl Builder {
        /// <p>A <a>StreamDescriptionSummary</a> containing information about the
        /// stream.</p>
        pub fn stream_description_summary(
            mut self,
            input: crate::model::StreamDescriptionSummary,
        ) -> Self {
            self.stream_description_summary = Some(input);
            self
        }
        /// <p>A <a>StreamDescriptionSummary</a> containing information about the
        /// stream.</p>
        pub fn set_stream_description_summary(
            mut self,
            input: std::option::Option<crate::model::StreamDescriptionSummary>,
        ) -> Self {
            self.stream_description_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamSummaryOutput`](crate::output::DescribeStreamSummaryOutput)
        pub fn build(self) -> crate::output::DescribeStreamSummaryOutput {
            crate::output::DescribeStreamSummaryOutput {
                stream_description_summary: self.stream_description_summary,
            }
        }
    }
}
impl DescribeStreamSummaryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamSummaryOutput`](crate::output::DescribeStreamSummaryOutput)
    pub fn builder() -> crate::output::describe_stream_summary_output::Builder {
        crate::output::describe_stream_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStreamConsumerOutput {
    /// <p>An object that represents the details of the consumer.</p>
    pub consumer_description: std::option::Option<crate::model::ConsumerDescription>,
}
impl DescribeStreamConsumerOutput {
    /// <p>An object that represents the details of the consumer.</p>
    pub fn consumer_description(&self) -> std::option::Option<&crate::model::ConsumerDescription> {
        self.consumer_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeStreamConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStreamConsumerOutput");
        formatter.field("consumer_description", &self.consumer_description);
        formatter.finish()
    }
}
/// See [`DescribeStreamConsumerOutput`](crate::output::DescribeStreamConsumerOutput)
pub mod describe_stream_consumer_output {
    /// A builder for [`DescribeStreamConsumerOutput`](crate::output::DescribeStreamConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_description: std::option::Option<crate::model::ConsumerDescription>,
    }
    impl Builder {
        /// <p>An object that represents the details of the consumer.</p>
        pub fn consumer_description(mut self, input: crate::model::ConsumerDescription) -> Self {
            self.consumer_description = Some(input);
            self
        }
        /// <p>An object that represents the details of the consumer.</p>
        pub fn set_consumer_description(
            mut self,
            input: std::option::Option<crate::model::ConsumerDescription>,
        ) -> Self {
            self.consumer_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamConsumerOutput`](crate::output::DescribeStreamConsumerOutput)
        pub fn build(self) -> crate::output::DescribeStreamConsumerOutput {
            crate::output::DescribeStreamConsumerOutput {
                consumer_description: self.consumer_description,
            }
        }
    }
}
impl DescribeStreamConsumerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamConsumerOutput`](crate::output::DescribeStreamConsumerOutput)
    pub fn builder() -> crate::output::describe_stream_consumer_output::Builder {
        crate::output::describe_stream_consumer_output::Builder::default()
    }
}

/// <p>Represents the output for <code>DescribeStream</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStreamOutput {
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of
    /// shard objects that comprise the stream, and whether there are more shards
    /// available.</p>
    pub stream_description: std::option::Option<crate::model::StreamDescription>,
}
impl DescribeStreamOutput {
    /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of
    /// shard objects that comprise the stream, and whether there are more shards
    /// available.</p>
    pub fn stream_description(&self) -> std::option::Option<&crate::model::StreamDescription> {
        self.stream_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStreamOutput");
        formatter.field("stream_description", &self.stream_description);
        formatter.finish()
    }
}
/// See [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
pub mod describe_stream_output {
    /// A builder for [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_description: std::option::Option<crate::model::StreamDescription>,
    }
    impl Builder {
        /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of
        /// shard objects that comprise the stream, and whether there are more shards
        /// available.</p>
        pub fn stream_description(mut self, input: crate::model::StreamDescription) -> Self {
            self.stream_description = Some(input);
            self
        }
        /// <p>The current status of the stream, the stream Amazon Resource Name (ARN), an array of
        /// shard objects that comprise the stream, and whether there are more shards
        /// available.</p>
        pub fn set_stream_description(
            mut self,
            input: std::option::Option<crate::model::StreamDescription>,
        ) -> Self {
            self.stream_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
        pub fn build(self) -> crate::output::DescribeStreamOutput {
            crate::output::DescribeStreamOutput {
                stream_description: self.stream_description,
            }
        }
    }
}
impl DescribeStreamOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
    pub fn builder() -> crate::output::describe_stream_output::Builder {
        crate::output::describe_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLimitsOutput {
    /// <p>The maximum number of shards.</p>
    pub shard_limit: std::option::Option<i32>,
    /// <p>The number of open shards.</p>
    pub open_shard_count: std::option::Option<i32>,
    /// <p> Indicates the number of data streams with the on-demand capacity mode.</p>
    pub on_demand_stream_count: std::option::Option<i32>,
    /// <p> The maximum number of data streams with the on-demand capacity mode. </p>
    pub on_demand_stream_count_limit: std::option::Option<i32>,
}
impl DescribeLimitsOutput {
    /// <p>The maximum number of shards.</p>
    pub fn shard_limit(&self) -> std::option::Option<i32> {
        self.shard_limit
    }
    /// <p>The number of open shards.</p>
    pub fn open_shard_count(&self) -> std::option::Option<i32> {
        self.open_shard_count
    }
    /// <p> Indicates the number of data streams with the on-demand capacity mode.</p>
    pub fn on_demand_stream_count(&self) -> std::option::Option<i32> {
        self.on_demand_stream_count
    }
    /// <p> The maximum number of data streams with the on-demand capacity mode. </p>
    pub fn on_demand_stream_count_limit(&self) -> std::option::Option<i32> {
        self.on_demand_stream_count_limit
    }
}
impl std::fmt::Debug for DescribeLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLimitsOutput");
        formatter.field("shard_limit", &self.shard_limit);
        formatter.field("open_shard_count", &self.open_shard_count);
        formatter.field("on_demand_stream_count", &self.on_demand_stream_count);
        formatter.field(
            "on_demand_stream_count_limit",
            &self.on_demand_stream_count_limit,
        );
        formatter.finish()
    }
}
/// See [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
pub mod describe_limits_output {
    /// A builder for [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_limit: std::option::Option<i32>,
        pub(crate) open_shard_count: std::option::Option<i32>,
        pub(crate) on_demand_stream_count: std::option::Option<i32>,
        pub(crate) on_demand_stream_count_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of shards.</p>
        pub fn shard_limit(mut self, input: i32) -> Self {
            self.shard_limit = Some(input);
            self
        }
        /// <p>The maximum number of shards.</p>
        pub fn set_shard_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.shard_limit = input;
            self
        }
        /// <p>The number of open shards.</p>
        pub fn open_shard_count(mut self, input: i32) -> Self {
            self.open_shard_count = Some(input);
            self
        }
        /// <p>The number of open shards.</p>
        pub fn set_open_shard_count(mut self, input: std::option::Option<i32>) -> Self {
            self.open_shard_count = input;
            self
        }
        /// <p> Indicates the number of data streams with the on-demand capacity mode.</p>
        pub fn on_demand_stream_count(mut self, input: i32) -> Self {
            self.on_demand_stream_count = Some(input);
            self
        }
        /// <p> Indicates the number of data streams with the on-demand capacity mode.</p>
        pub fn set_on_demand_stream_count(mut self, input: std::option::Option<i32>) -> Self {
            self.on_demand_stream_count = input;
            self
        }
        /// <p> The maximum number of data streams with the on-demand capacity mode. </p>
        pub fn on_demand_stream_count_limit(mut self, input: i32) -> Self {
            self.on_demand_stream_count_limit = Some(input);
            self
        }
        /// <p> The maximum number of data streams with the on-demand capacity mode. </p>
        pub fn set_on_demand_stream_count_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.on_demand_stream_count_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
        pub fn build(self) -> crate::output::DescribeLimitsOutput {
            crate::output::DescribeLimitsOutput {
                shard_limit: self.shard_limit,
                open_shard_count: self.open_shard_count,
                on_demand_stream_count: self.on_demand_stream_count,
                on_demand_stream_count_limit: self.on_demand_stream_count_limit,
            }
        }
    }
}
impl DescribeLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
    pub fn builder() -> crate::output::describe_limits_output::Builder {
        crate::output::describe_limits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterStreamConsumerOutput {}
impl std::fmt::Debug for DeregisterStreamConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterStreamConsumerOutput");
        formatter.finish()
    }
}
/// See [`DeregisterStreamConsumerOutput`](crate::output::DeregisterStreamConsumerOutput)
pub mod deregister_stream_consumer_output {
    /// A builder for [`DeregisterStreamConsumerOutput`](crate::output::DeregisterStreamConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterStreamConsumerOutput`](crate::output::DeregisterStreamConsumerOutput)
        pub fn build(self) -> crate::output::DeregisterStreamConsumerOutput {
            crate::output::DeregisterStreamConsumerOutput {}
        }
    }
}
impl DeregisterStreamConsumerOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterStreamConsumerOutput`](crate::output::DeregisterStreamConsumerOutput)
    pub fn builder() -> crate::output::deregister_stream_consumer_output::Builder {
        crate::output::deregister_stream_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamOutput {}
impl std::fmt::Debug for DeleteStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamOutput");
        formatter.finish()
    }
}
/// See [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
pub mod delete_stream_output {
    /// A builder for [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
        pub fn build(self) -> crate::output::DeleteStreamOutput {
            crate::output::DeleteStreamOutput {}
        }
    }
}
impl DeleteStreamOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
    pub fn builder() -> crate::output::delete_stream_output::Builder {
        crate::output::delete_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecreaseStreamRetentionPeriodOutput {}
impl std::fmt::Debug for DecreaseStreamRetentionPeriodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecreaseStreamRetentionPeriodOutput");
        formatter.finish()
    }
}
/// See [`DecreaseStreamRetentionPeriodOutput`](crate::output::DecreaseStreamRetentionPeriodOutput)
pub mod decrease_stream_retention_period_output {
    /// A builder for [`DecreaseStreamRetentionPeriodOutput`](crate::output::DecreaseStreamRetentionPeriodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DecreaseStreamRetentionPeriodOutput`](crate::output::DecreaseStreamRetentionPeriodOutput)
        pub fn build(self) -> crate::output::DecreaseStreamRetentionPeriodOutput {
            crate::output::DecreaseStreamRetentionPeriodOutput {}
        }
    }
}
impl DecreaseStreamRetentionPeriodOutput {
    /// Creates a new builder-style object to manufacture [`DecreaseStreamRetentionPeriodOutput`](crate::output::DecreaseStreamRetentionPeriodOutput)
    pub fn builder() -> crate::output::decrease_stream_retention_period_output::Builder {
        crate::output::decrease_stream_retention_period_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamOutput {}
impl std::fmt::Debug for CreateStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamOutput");
        formatter.finish()
    }
}
/// See [`CreateStreamOutput`](crate::output::CreateStreamOutput)
pub mod create_stream_output {
    /// A builder for [`CreateStreamOutput`](crate::output::CreateStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateStreamOutput`](crate::output::CreateStreamOutput)
        pub fn build(self) -> crate::output::CreateStreamOutput {
            crate::output::CreateStreamOutput {}
        }
    }
}
impl CreateStreamOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamOutput`](crate::output::CreateStreamOutput)
    pub fn builder() -> crate::output::create_stream_output::Builder {
        crate::output::create_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToStreamOutput {}
impl std::fmt::Debug for AddTagsToStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToStreamOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToStreamOutput`](crate::output::AddTagsToStreamOutput)
pub mod add_tags_to_stream_output {
    /// A builder for [`AddTagsToStreamOutput`](crate::output::AddTagsToStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToStreamOutput`](crate::output::AddTagsToStreamOutput)
        pub fn build(self) -> crate::output::AddTagsToStreamOutput {
            crate::output::AddTagsToStreamOutput {}
        }
    }
}
impl AddTagsToStreamOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToStreamOutput`](crate::output::AddTagsToStreamOutput)
    pub fn builder() -> crate::output::add_tags_to_stream_output::Builder {
        crate::output::add_tags_to_stream_output::Builder::default()
    }
}
