// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingType {
    #[allow(missing_docs)] // documentation missing in model
    UniformScaling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingType {
    fn from(s: &str) -> Self {
        match s {
            "UNIFORM_SCALING" => ScalingType::UniformScaling,
            other => ScalingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingType::from(s))
    }
}
impl ScalingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingType::UniformScaling => "UNIFORM_SCALING",
            ScalingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UNIFORM_SCALING"]
    }
}
impl AsRef<str> for ScalingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "KMS" => EncryptionType::Kms,
            "NONE" => EncryptionType::None,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::Kms => "KMS",
            EncryptionType::None => "NONE",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS", "NONE"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the details of the consumer you registered. This type of
/// object is returned by <a>RegisterStreamConsumer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Consumer {
    /// <p>The name of the consumer is something you choose when you register the
    /// consumer.</p>
    pub consumer_name: std::option::Option<std::string::String>,
    /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
    /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
    /// <p>If you delete a consumer and then create a new one with the same name, it won't have
    /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
    /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
    pub consumer_arn: std::option::Option<std::string::String>,
    /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
    /// states.</p>
    pub consumer_status: std::option::Option<crate::model::ConsumerStatus>,
    /// <p></p>
    pub consumer_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl Consumer {
    /// <p>The name of the consumer is something you choose when you register the
    /// consumer.</p>
    pub fn consumer_name(&self) -> std::option::Option<&str> {
        self.consumer_name.as_deref()
    }
    /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
    /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
    /// <p>If you delete a consumer and then create a new one with the same name, it won't have
    /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
    /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
    pub fn consumer_arn(&self) -> std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
    /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
    /// states.</p>
    pub fn consumer_status(&self) -> std::option::Option<&crate::model::ConsumerStatus> {
        self.consumer_status.as_ref()
    }
    /// <p></p>
    pub fn consumer_creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.consumer_creation_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Consumer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Consumer");
        formatter.field("consumer_name", &self.consumer_name);
        formatter.field("consumer_arn", &self.consumer_arn);
        formatter.field("consumer_status", &self.consumer_status);
        formatter.field(
            "consumer_creation_timestamp",
            &self.consumer_creation_timestamp,
        );
        formatter.finish()
    }
}
/// See [`Consumer`](crate::model::Consumer)
pub mod consumer {
    /// A builder for [`Consumer`](crate::model::Consumer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_name: std::option::Option<std::string::String>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
        pub(crate) consumer_status: std::option::Option<crate::model::ConsumerStatus>,
        pub(crate) consumer_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the consumer is something you choose when you register the
        /// consumer.</p>
        pub fn consumer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_name = Some(input.into());
            self
        }
        /// <p>The name of the consumer is something you choose when you register the
        /// consumer.</p>
        pub fn set_consumer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_name = input;
            self
        }
        /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
        /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
        /// <p>If you delete a consumer and then create a new one with the same name, it won't have
        /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
        /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
        /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
        /// <p>If you delete a consumer and then create a new one with the same name, it won't have
        /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
        /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
        /// states.</p>
        pub fn consumer_status(mut self, input: crate::model::ConsumerStatus) -> Self {
            self.consumer_status = Some(input);
            self
        }
        /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
        /// states.</p>
        pub fn set_consumer_status(
            mut self,
            input: std::option::Option<crate::model::ConsumerStatus>,
        ) -> Self {
            self.consumer_status = input;
            self
        }
        /// <p></p>
        pub fn consumer_creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.consumer_creation_timestamp = Some(input);
            self
        }
        /// <p></p>
        pub fn set_consumer_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.consumer_creation_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Consumer`](crate::model::Consumer)
        pub fn build(self) -> crate::model::Consumer {
            crate::model::Consumer {
                consumer_name: self.consumer_name,
                consumer_arn: self.consumer_arn,
                consumer_status: self.consumer_status,
                consumer_creation_timestamp: self.consumer_creation_timestamp,
            }
        }
    }
}
impl Consumer {
    /// Creates a new builder-style object to manufacture [`Consumer`](crate::model::Consumer)
    pub fn builder() -> crate::model::consumer::Builder {
        crate::model::consumer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConsumerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConsumerStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ConsumerStatus::Active,
            "CREATING" => ConsumerStatus::Creating,
            "DELETING" => ConsumerStatus::Deleting,
            other => ConsumerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConsumerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConsumerStatus::from(s))
    }
}
impl ConsumerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConsumerStatus::Active => "ACTIVE",
            ConsumerStatus::Creating => "CREATING",
            ConsumerStatus::Deleting => "DELETING",
            ConsumerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ConsumerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the result of an individual record from a <code>PutRecords</code>
/// request. A record that is successfully added to a stream includes
/// <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that
/// fails to be added to the stream includes <code>ErrorCode</code> and
/// <code>ErrorMessage</code> in the result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordsResultEntry {
    /// <p>The sequence number for an individual record result.</p>
    pub sequence_number: std::option::Option<std::string::String>,
    /// <p>The shard ID for an individual record result.</p>
    pub shard_id: std::option::Option<std::string::String>,
    /// <p>The error code for an individual record result. <code>ErrorCodes</code> can be
    /// either <code>ProvisionedThroughputExceededException</code> or
    /// <code>InternalFailure</code>.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message for an individual record result. An <code>ErrorCode</code> value
    /// of <code>ProvisionedThroughputExceededException</code> has an error message that
    /// includes the account ID, stream name, and shard ID. An <code>ErrorCode</code> value of
    /// <code>InternalFailure</code> has the error message <code>"Internal Service
    /// Failure"</code>.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl PutRecordsResultEntry {
    /// <p>The sequence number for an individual record result.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
    /// <p>The shard ID for an individual record result.</p>
    pub fn shard_id(&self) -> std::option::Option<&str> {
        self.shard_id.as_deref()
    }
    /// <p>The error code for an individual record result. <code>ErrorCodes</code> can be
    /// either <code>ProvisionedThroughputExceededException</code> or
    /// <code>InternalFailure</code>.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message for an individual record result. An <code>ErrorCode</code> value
    /// of <code>ProvisionedThroughputExceededException</code> has an error message that
    /// includes the account ID, stream name, and shard ID. An <code>ErrorCode</code> value of
    /// <code>InternalFailure</code> has the error message <code>"Internal Service
    /// Failure"</code>.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for PutRecordsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordsResultEntry");
        formatter.field("sequence_number", &self.sequence_number);
        formatter.field("shard_id", &self.shard_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutRecordsResultEntry`](crate::model::PutRecordsResultEntry)
pub mod put_records_result_entry {
    /// A builder for [`PutRecordsResultEntry`](crate::model::PutRecordsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sequence_number: std::option::Option<std::string::String>,
        pub(crate) shard_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The sequence number for an individual record result.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>The sequence number for an individual record result.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// <p>The shard ID for an individual record result.</p>
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_id = Some(input.into());
            self
        }
        /// <p>The shard ID for an individual record result.</p>
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_id = input;
            self
        }
        /// <p>The error code for an individual record result. <code>ErrorCodes</code> can be
        /// either <code>ProvisionedThroughputExceededException</code> or
        /// <code>InternalFailure</code>.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code for an individual record result. <code>ErrorCodes</code> can be
        /// either <code>ProvisionedThroughputExceededException</code> or
        /// <code>InternalFailure</code>.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message for an individual record result. An <code>ErrorCode</code> value
        /// of <code>ProvisionedThroughputExceededException</code> has an error message that
        /// includes the account ID, stream name, and shard ID. An <code>ErrorCode</code> value of
        /// <code>InternalFailure</code> has the error message <code>"Internal Service
        /// Failure"</code>.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message for an individual record result. An <code>ErrorCode</code> value
        /// of <code>ProvisionedThroughputExceededException</code> has an error message that
        /// includes the account ID, stream name, and shard ID. An <code>ErrorCode</code> value of
        /// <code>InternalFailure</code> has the error message <code>"Internal Service
        /// Failure"</code>.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordsResultEntry`](crate::model::PutRecordsResultEntry)
        pub fn build(self) -> crate::model::PutRecordsResultEntry {
            crate::model::PutRecordsResultEntry {
                sequence_number: self.sequence_number,
                shard_id: self.shard_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutRecordsResultEntry {
    /// Creates a new builder-style object to manufacture [`PutRecordsResultEntry`](crate::model::PutRecordsResultEntry)
    pub fn builder() -> crate::model::put_records_result_entry::Builder {
        crate::model::put_records_result_entry::Builder::default()
    }
}

/// <p>Represents the output for <code>PutRecords</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRecordsRequestEntry {
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is
    /// serialized. When the data blob (the payload before base64-encoding) is added to the
    /// partition key size, the total size must not exceed the maximum record size (1
    /// MiB).</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The hash value used to determine explicitly the shard that the data record is
    /// assigned to by overriding the partition key hash.</p>
    pub explicit_hash_key: std::option::Option<std::string::String>,
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys
    /// are Unicode strings with a maximum length limit of 256 characters for each key. Amazon
    /// Kinesis Data Streams uses the partition key as input to a hash function that maps the
    /// partition key and associated data to a specific shard. Specifically, an MD5 hash
    /// function is used to map partition keys to 128-bit integer values and to map associated
    /// data records to shards. As a result of this hashing mechanism, all data records with the
    /// same partition key map to the same shard within the stream.</p>
    pub partition_key: std::option::Option<std::string::String>,
}
impl PutRecordsRequestEntry {
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is
    /// serialized. When the data blob (the payload before base64-encoding) is added to the
    /// partition key size, the total size must not exceed the maximum record size (1
    /// MiB).</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// <p>The hash value used to determine explicitly the shard that the data record is
    /// assigned to by overriding the partition key hash.</p>
    pub fn explicit_hash_key(&self) -> std::option::Option<&str> {
        self.explicit_hash_key.as_deref()
    }
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys
    /// are Unicode strings with a maximum length limit of 256 characters for each key. Amazon
    /// Kinesis Data Streams uses the partition key as input to a hash function that maps the
    /// partition key and associated data to a specific shard. Specifically, an MD5 hash
    /// function is used to map partition keys to 128-bit integer values and to map associated
    /// data records to shards. As a result of this hashing mechanism, all data records with the
    /// same partition key map to the same shard within the stream.</p>
    pub fn partition_key(&self) -> std::option::Option<&str> {
        self.partition_key.as_deref()
    }
}
impl std::fmt::Debug for PutRecordsRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRecordsRequestEntry");
        formatter.field("data", &self.data);
        formatter.field("explicit_hash_key", &self.explicit_hash_key);
        formatter.field("partition_key", &self.partition_key);
        formatter.finish()
    }
}
/// See [`PutRecordsRequestEntry`](crate::model::PutRecordsRequestEntry)
pub mod put_records_request_entry {
    /// A builder for [`PutRecordsRequestEntry`](crate::model::PutRecordsRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) explicit_hash_key: std::option::Option<std::string::String>,
        pub(crate) partition_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The data blob to put into the record, which is base64-encoded when the blob is
        /// serialized. When the data blob (the payload before base64-encoding) is added to the
        /// partition key size, the total size must not exceed the maximum record size (1
        /// MiB).</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The data blob to put into the record, which is base64-encoded when the blob is
        /// serialized. When the data blob (the payload before base64-encoding) is added to the
        /// partition key size, the total size must not exceed the maximum record size (1
        /// MiB).</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// <p>The hash value used to determine explicitly the shard that the data record is
        /// assigned to by overriding the partition key hash.</p>
        pub fn explicit_hash_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.explicit_hash_key = Some(input.into());
            self
        }
        /// <p>The hash value used to determine explicitly the shard that the data record is
        /// assigned to by overriding the partition key hash.</p>
        pub fn set_explicit_hash_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explicit_hash_key = input;
            self
        }
        /// <p>Determines which shard in the stream the data record is assigned to. Partition keys
        /// are Unicode strings with a maximum length limit of 256 characters for each key. Amazon
        /// Kinesis Data Streams uses the partition key as input to a hash function that maps the
        /// partition key and associated data to a specific shard. Specifically, an MD5 hash
        /// function is used to map partition keys to 128-bit integer values and to map associated
        /// data records to shards. As a result of this hashing mechanism, all data records with the
        /// same partition key map to the same shard within the stream.</p>
        pub fn partition_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition_key = Some(input.into());
            self
        }
        /// <p>Determines which shard in the stream the data record is assigned to. Partition keys
        /// are Unicode strings with a maximum length limit of 256 characters for each key. Amazon
        /// Kinesis Data Streams uses the partition key as input to a hash function that maps the
        /// partition key and associated data to a specific shard. Specifically, an MD5 hash
        /// function is used to map partition keys to 128-bit integer values and to map associated
        /// data records to shards. As a result of this hashing mechanism, all data records with the
        /// same partition key map to the same shard within the stream.</p>
        pub fn set_partition_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partition_key = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRecordsRequestEntry`](crate::model::PutRecordsRequestEntry)
        pub fn build(self) -> crate::model::PutRecordsRequestEntry {
            crate::model::PutRecordsRequestEntry {
                data: self.data,
                explicit_hash_key: self.explicit_hash_key,
                partition_key: self.partition_key,
            }
        }
    }
}
impl PutRecordsRequestEntry {
    /// Creates a new builder-style object to manufacture [`PutRecordsRequestEntry`](crate::model::PutRecordsRequestEntry)
    pub fn builder() -> crate::model::put_records_request_entry::Builder {
        crate::model::put_records_request_entry::Builder::default()
    }
}

/// <p>Metadata assigned to the stream, consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
    /// Unicode letters, digits, white space, _ . / = + - % @</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>An optional string, typically used to describe or define the tag. Maximum length:
    /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
    /// @</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
    /// Unicode letters, digits, white space, _ . / = + - % @</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>An optional string, typically used to describe or define the tag. Maximum length:
    /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
    /// @</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
        /// Unicode letters, digits, white space, _ . / = + - % @</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
        /// Unicode letters, digits, white space, _ . / = + - % @</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>An optional string, typically used to describe or define the tag. Maximum length:
        /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
        /// @</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>An optional string, typically used to describe or define the tag. Maximum length:
        /// 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - %
        /// @</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A uniquely identified group of data records in a Kinesis data stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Shard {
    /// <p>The unique identifier of the shard within the stream.</p>
    pub shard_id: std::option::Option<std::string::String>,
    /// <p>The shard ID of the shard's parent.</p>
    pub parent_shard_id: std::option::Option<std::string::String>,
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub adjacent_parent_shard_id: std::option::Option<std::string::String>,
    /// <p>The range of possible hash key values for the shard, which is a set of ordered
    /// contiguous positive integers.</p>
    pub hash_key_range: std::option::Option<crate::model::HashKeyRange>,
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub sequence_number_range: std::option::Option<crate::model::SequenceNumberRange>,
}
impl Shard {
    /// <p>The unique identifier of the shard within the stream.</p>
    pub fn shard_id(&self) -> std::option::Option<&str> {
        self.shard_id.as_deref()
    }
    /// <p>The shard ID of the shard's parent.</p>
    pub fn parent_shard_id(&self) -> std::option::Option<&str> {
        self.parent_shard_id.as_deref()
    }
    /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
    pub fn adjacent_parent_shard_id(&self) -> std::option::Option<&str> {
        self.adjacent_parent_shard_id.as_deref()
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered
    /// contiguous positive integers.</p>
    pub fn hash_key_range(&self) -> std::option::Option<&crate::model::HashKeyRange> {
        self.hash_key_range.as_ref()
    }
    /// <p>The range of possible sequence numbers for the shard.</p>
    pub fn sequence_number_range(&self) -> std::option::Option<&crate::model::SequenceNumberRange> {
        self.sequence_number_range.as_ref()
    }
}
impl std::fmt::Debug for Shard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Shard");
        formatter.field("shard_id", &self.shard_id);
        formatter.field("parent_shard_id", &self.parent_shard_id);
        formatter.field("adjacent_parent_shard_id", &self.adjacent_parent_shard_id);
        formatter.field("hash_key_range", &self.hash_key_range);
        formatter.field("sequence_number_range", &self.sequence_number_range);
        formatter.finish()
    }
}
/// See [`Shard`](crate::model::Shard)
pub mod shard {
    /// A builder for [`Shard`](crate::model::Shard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_id: std::option::Option<std::string::String>,
        pub(crate) parent_shard_id: std::option::Option<std::string::String>,
        pub(crate) adjacent_parent_shard_id: std::option::Option<std::string::String>,
        pub(crate) hash_key_range: std::option::Option<crate::model::HashKeyRange>,
        pub(crate) sequence_number_range: std::option::Option<crate::model::SequenceNumberRange>,
    }
    impl Builder {
        /// <p>The unique identifier of the shard within the stream.</p>
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the shard within the stream.</p>
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_id = input;
            self
        }
        /// <p>The shard ID of the shard's parent.</p>
        pub fn parent_shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_shard_id = Some(input.into());
            self
        }
        /// <p>The shard ID of the shard's parent.</p>
        pub fn set_parent_shard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_shard_id = input;
            self
        }
        /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
        pub fn adjacent_parent_shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.adjacent_parent_shard_id = Some(input.into());
            self
        }
        /// <p>The shard ID of the shard adjacent to the shard's parent.</p>
        pub fn set_adjacent_parent_shard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.adjacent_parent_shard_id = input;
            self
        }
        /// <p>The range of possible hash key values for the shard, which is a set of ordered
        /// contiguous positive integers.</p>
        pub fn hash_key_range(mut self, input: crate::model::HashKeyRange) -> Self {
            self.hash_key_range = Some(input);
            self
        }
        /// <p>The range of possible hash key values for the shard, which is a set of ordered
        /// contiguous positive integers.</p>
        pub fn set_hash_key_range(
            mut self,
            input: std::option::Option<crate::model::HashKeyRange>,
        ) -> Self {
            self.hash_key_range = input;
            self
        }
        /// <p>The range of possible sequence numbers for the shard.</p>
        pub fn sequence_number_range(mut self, input: crate::model::SequenceNumberRange) -> Self {
            self.sequence_number_range = Some(input);
            self
        }
        /// <p>The range of possible sequence numbers for the shard.</p>
        pub fn set_sequence_number_range(
            mut self,
            input: std::option::Option<crate::model::SequenceNumberRange>,
        ) -> Self {
            self.sequence_number_range = input;
            self
        }
        /// Consumes the builder and constructs a [`Shard`](crate::model::Shard)
        pub fn build(self) -> crate::model::Shard {
            crate::model::Shard {
                shard_id: self.shard_id,
                parent_shard_id: self.parent_shard_id,
                adjacent_parent_shard_id: self.adjacent_parent_shard_id,
                hash_key_range: self.hash_key_range,
                sequence_number_range: self.sequence_number_range,
            }
        }
    }
}
impl Shard {
    /// Creates a new builder-style object to manufacture [`Shard`](crate::model::Shard)
    pub fn builder() -> crate::model::shard::Builder {
        crate::model::shard::Builder::default()
    }
}

/// <p>The range of possible sequence numbers for the shard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SequenceNumberRange {
    /// <p>The starting sequence number for the range.</p>
    pub starting_sequence_number: std::option::Option<std::string::String>,
    /// <p>The ending sequence number for the range. Shards that are in the OPEN state have an
    /// ending sequence number of <code>null</code>.</p>
    pub ending_sequence_number: std::option::Option<std::string::String>,
}
impl SequenceNumberRange {
    /// <p>The starting sequence number for the range.</p>
    pub fn starting_sequence_number(&self) -> std::option::Option<&str> {
        self.starting_sequence_number.as_deref()
    }
    /// <p>The ending sequence number for the range. Shards that are in the OPEN state have an
    /// ending sequence number of <code>null</code>.</p>
    pub fn ending_sequence_number(&self) -> std::option::Option<&str> {
        self.ending_sequence_number.as_deref()
    }
}
impl std::fmt::Debug for SequenceNumberRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SequenceNumberRange");
        formatter.field("starting_sequence_number", &self.starting_sequence_number);
        formatter.field("ending_sequence_number", &self.ending_sequence_number);
        formatter.finish()
    }
}
/// See [`SequenceNumberRange`](crate::model::SequenceNumberRange)
pub mod sequence_number_range {
    /// A builder for [`SequenceNumberRange`](crate::model::SequenceNumberRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) starting_sequence_number: std::option::Option<std::string::String>,
        pub(crate) ending_sequence_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The starting sequence number for the range.</p>
        pub fn starting_sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.starting_sequence_number = Some(input.into());
            self
        }
        /// <p>The starting sequence number for the range.</p>
        pub fn set_starting_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.starting_sequence_number = input;
            self
        }
        /// <p>The ending sequence number for the range. Shards that are in the OPEN state have an
        /// ending sequence number of <code>null</code>.</p>
        pub fn ending_sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.ending_sequence_number = Some(input.into());
            self
        }
        /// <p>The ending sequence number for the range. Shards that are in the OPEN state have an
        /// ending sequence number of <code>null</code>.</p>
        pub fn set_ending_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ending_sequence_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SequenceNumberRange`](crate::model::SequenceNumberRange)
        pub fn build(self) -> crate::model::SequenceNumberRange {
            crate::model::SequenceNumberRange {
                starting_sequence_number: self.starting_sequence_number,
                ending_sequence_number: self.ending_sequence_number,
            }
        }
    }
}
impl SequenceNumberRange {
    /// Creates a new builder-style object to manufacture [`SequenceNumberRange`](crate::model::SequenceNumberRange)
    pub fn builder() -> crate::model::sequence_number_range::Builder {
        crate::model::sequence_number_range::Builder::default()
    }
}

/// <p>The range of possible hash key values for the shard, which is a set of ordered
/// contiguous positive integers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HashKeyRange {
    /// <p>The starting hash key of the hash key range.</p>
    pub starting_hash_key: std::option::Option<std::string::String>,
    /// <p>The ending hash key of the hash key range.</p>
    pub ending_hash_key: std::option::Option<std::string::String>,
}
impl HashKeyRange {
    /// <p>The starting hash key of the hash key range.</p>
    pub fn starting_hash_key(&self) -> std::option::Option<&str> {
        self.starting_hash_key.as_deref()
    }
    /// <p>The ending hash key of the hash key range.</p>
    pub fn ending_hash_key(&self) -> std::option::Option<&str> {
        self.ending_hash_key.as_deref()
    }
}
impl std::fmt::Debug for HashKeyRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HashKeyRange");
        formatter.field("starting_hash_key", &self.starting_hash_key);
        formatter.field("ending_hash_key", &self.ending_hash_key);
        formatter.finish()
    }
}
/// See [`HashKeyRange`](crate::model::HashKeyRange)
pub mod hash_key_range {
    /// A builder for [`HashKeyRange`](crate::model::HashKeyRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) starting_hash_key: std::option::Option<std::string::String>,
        pub(crate) ending_hash_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The starting hash key of the hash key range.</p>
        pub fn starting_hash_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.starting_hash_key = Some(input.into());
            self
        }
        /// <p>The starting hash key of the hash key range.</p>
        pub fn set_starting_hash_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.starting_hash_key = input;
            self
        }
        /// <p>The ending hash key of the hash key range.</p>
        pub fn ending_hash_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ending_hash_key = Some(input.into());
            self
        }
        /// <p>The ending hash key of the hash key range.</p>
        pub fn set_ending_hash_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ending_hash_key = input;
            self
        }
        /// Consumes the builder and constructs a [`HashKeyRange`](crate::model::HashKeyRange)
        pub fn build(self) -> crate::model::HashKeyRange {
            crate::model::HashKeyRange {
                starting_hash_key: self.starting_hash_key,
                ending_hash_key: self.ending_hash_key,
            }
        }
    }
}
impl HashKeyRange {
    /// Creates a new builder-style object to manufacture [`HashKeyRange`](crate::model::HashKeyRange)
    pub fn builder() -> crate::model::hash_key_range::Builder {
        crate::model::hash_key_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShardFilter {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<crate::model::ShardFilterType>,
    #[allow(missing_docs)] // documentation missing in model
    pub shard_id: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl ShardFilter {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&crate::model::ShardFilterType> {
        self.r#type.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn shard_id(&self) -> std::option::Option<&str> {
        self.shard_id.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for ShardFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShardFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("shard_id", &self.shard_id);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`ShardFilter`](crate::model::ShardFilter)
pub mod shard_filter {
    /// A builder for [`ShardFilter`](crate::model::ShardFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ShardFilterType>,
        pub(crate) shard_id: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: crate::model::ShardFilterType) -> Self {
            self.r#type = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ShardFilterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_id = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ShardFilter`](crate::model::ShardFilter)
        pub fn build(self) -> crate::model::ShardFilter {
            crate::model::ShardFilter {
                r#type: self.r#type,
                shard_id: self.shard_id,
                timestamp: self.timestamp,
            }
        }
    }
}
impl ShardFilter {
    /// Creates a new builder-style object to manufacture [`ShardFilter`](crate::model::ShardFilter)
    pub fn builder() -> crate::model::shard_filter::Builder {
        crate::model::shard_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShardFilterType {
    #[allow(missing_docs)] // documentation missing in model
    AfterShardId,
    #[allow(missing_docs)] // documentation missing in model
    AtLatest,
    #[allow(missing_docs)] // documentation missing in model
    AtTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    AtTrimHorizon,
    #[allow(missing_docs)] // documentation missing in model
    FromTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    FromTrimHorizon,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShardFilterType {
    fn from(s: &str) -> Self {
        match s {
            "AFTER_SHARD_ID" => ShardFilterType::AfterShardId,
            "AT_LATEST" => ShardFilterType::AtLatest,
            "AT_TIMESTAMP" => ShardFilterType::AtTimestamp,
            "AT_TRIM_HORIZON" => ShardFilterType::AtTrimHorizon,
            "FROM_TIMESTAMP" => ShardFilterType::FromTimestamp,
            "FROM_TRIM_HORIZON" => ShardFilterType::FromTrimHorizon,
            other => ShardFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShardFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShardFilterType::from(s))
    }
}
impl ShardFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShardFilterType::AfterShardId => "AFTER_SHARD_ID",
            ShardFilterType::AtLatest => "AT_LATEST",
            ShardFilterType::AtTimestamp => "AT_TIMESTAMP",
            ShardFilterType::AtTrimHorizon => "AT_TRIM_HORIZON",
            ShardFilterType::FromTimestamp => "FROM_TIMESTAMP",
            ShardFilterType::FromTrimHorizon => "FROM_TRIM_HORIZON",
            ShardFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFTER_SHARD_ID",
            "AT_LATEST",
            "AT_TIMESTAMP",
            "AT_TRIM_HORIZON",
            "FROM_TIMESTAMP",
            "FROM_TRIM_HORIZON",
        ]
    }
}
impl AsRef<str> for ShardFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShardIteratorType {
    #[allow(missing_docs)] // documentation missing in model
    AfterSequenceNumber,
    #[allow(missing_docs)] // documentation missing in model
    AtSequenceNumber,
    #[allow(missing_docs)] // documentation missing in model
    AtTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    Latest,
    #[allow(missing_docs)] // documentation missing in model
    TrimHorizon,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShardIteratorType {
    fn from(s: &str) -> Self {
        match s {
            "AFTER_SEQUENCE_NUMBER" => ShardIteratorType::AfterSequenceNumber,
            "AT_SEQUENCE_NUMBER" => ShardIteratorType::AtSequenceNumber,
            "AT_TIMESTAMP" => ShardIteratorType::AtTimestamp,
            "LATEST" => ShardIteratorType::Latest,
            "TRIM_HORIZON" => ShardIteratorType::TrimHorizon,
            other => ShardIteratorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShardIteratorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShardIteratorType::from(s))
    }
}
impl ShardIteratorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShardIteratorType::AfterSequenceNumber => "AFTER_SEQUENCE_NUMBER",
            ShardIteratorType::AtSequenceNumber => "AT_SEQUENCE_NUMBER",
            ShardIteratorType::AtTimestamp => "AT_TIMESTAMP",
            ShardIteratorType::Latest => "LATEST",
            ShardIteratorType::TrimHorizon => "TRIM_HORIZON",
            ShardIteratorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFTER_SEQUENCE_NUMBER",
            "AT_SEQUENCE_NUMBER",
            "AT_TIMESTAMP",
            "LATEST",
            "TRIM_HORIZON",
        ]
    }
}
impl AsRef<str> for ShardIteratorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChildShard {
    #[allow(missing_docs)] // documentation missing in model
    pub shard_id: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub parent_shards: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The range of possible hash key values for the shard, which is a set of ordered
    /// contiguous positive integers.</p>
    pub hash_key_range: std::option::Option<crate::model::HashKeyRange>,
}
impl ChildShard {
    #[allow(missing_docs)] // documentation missing in model
    pub fn shard_id(&self) -> std::option::Option<&str> {
        self.shard_id.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn parent_shards(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_shards.as_deref()
    }
    /// <p>The range of possible hash key values for the shard, which is a set of ordered
    /// contiguous positive integers.</p>
    pub fn hash_key_range(&self) -> std::option::Option<&crate::model::HashKeyRange> {
        self.hash_key_range.as_ref()
    }
}
impl std::fmt::Debug for ChildShard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChildShard");
        formatter.field("shard_id", &self.shard_id);
        formatter.field("parent_shards", &self.parent_shards);
        formatter.field("hash_key_range", &self.hash_key_range);
        formatter.finish()
    }
}
/// See [`ChildShard`](crate::model::ChildShard)
pub mod child_shard {
    /// A builder for [`ChildShard`](crate::model::ChildShard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_id: std::option::Option<std::string::String>,
        pub(crate) parent_shards: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hash_key_range: std::option::Option<crate::model::HashKeyRange>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shard_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shard_id = input;
            self
        }
        /// Appends an item to `parent_shards`.
        ///
        /// To override the contents of this collection use [`set_parent_shards`](Self::set_parent_shards).
        ///
        pub fn parent_shards(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_shards.unwrap_or_default();
            v.push(input.into());
            self.parent_shards = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_parent_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_shards = input;
            self
        }
        /// <p>The range of possible hash key values for the shard, which is a set of ordered
        /// contiguous positive integers.</p>
        pub fn hash_key_range(mut self, input: crate::model::HashKeyRange) -> Self {
            self.hash_key_range = Some(input);
            self
        }
        /// <p>The range of possible hash key values for the shard, which is a set of ordered
        /// contiguous positive integers.</p>
        pub fn set_hash_key_range(
            mut self,
            input: std::option::Option<crate::model::HashKeyRange>,
        ) -> Self {
            self.hash_key_range = input;
            self
        }
        /// Consumes the builder and constructs a [`ChildShard`](crate::model::ChildShard)
        pub fn build(self) -> crate::model::ChildShard {
            crate::model::ChildShard {
                shard_id: self.shard_id,
                parent_shards: self.parent_shards,
                hash_key_range: self.hash_key_range,
            }
        }
    }
}
impl ChildShard {
    /// Creates a new builder-style object to manufacture [`ChildShard`](crate::model::ChildShard)
    pub fn builder() -> crate::model::child_shard::Builder {
        crate::model::child_shard::Builder::default()
    }
}

/// <p>The unit of data of the Kinesis data stream, which is composed of a sequence
/// number, a partition key, and a data blob.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Record {
    /// <p>The unique identifier of the record within its shard.</p>
    pub sequence_number: std::option::Option<std::string::String>,
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub approximate_arrival_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data
    /// Streams, which does not inspect, interpret, or change the data in the blob in any way.
    /// When the data blob (the payload before base64-encoding) is added to the partition key
    /// size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub partition_key: std::option::Option<std::string::String>,
    /// <p>The encryption type used on the record. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed AWS KMS key.</p>
    /// </li>
    /// </ul>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
}
impl Record {
    /// <p>The unique identifier of the record within its shard.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub fn approximate_arrival_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.approximate_arrival_timestamp.as_ref()
    }
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data
    /// Streams, which does not inspect, interpret, or change the data in the blob in any way.
    /// When the data blob (the payload before base64-encoding) is added to the partition key
    /// size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub fn partition_key(&self) -> std::option::Option<&str> {
        self.partition_key.as_deref()
    }
    /// <p>The encryption type used on the record. This parameter can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed AWS KMS key.</p>
    /// </li>
    /// </ul>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
}
impl std::fmt::Debug for Record {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Record");
        formatter.field("sequence_number", &self.sequence_number);
        formatter.field(
            "approximate_arrival_timestamp",
            &self.approximate_arrival_timestamp,
        );
        formatter.field("data", &self.data);
        formatter.field("partition_key", &self.partition_key);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`Record`](crate::model::Record)
pub mod record {
    /// A builder for [`Record`](crate::model::Record)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sequence_number: std::option::Option<std::string::String>,
        pub(crate) approximate_arrival_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) partition_key: std::option::Option<std::string::String>,
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
    }
    impl Builder {
        /// <p>The unique identifier of the record within its shard.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>The unique identifier of the record within its shard.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// <p>The approximate time that the record was inserted into the stream.</p>
        pub fn approximate_arrival_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.approximate_arrival_timestamp = Some(input);
            self
        }
        /// <p>The approximate time that the record was inserted into the stream.</p>
        pub fn set_approximate_arrival_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.approximate_arrival_timestamp = input;
            self
        }
        /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data
        /// Streams, which does not inspect, interpret, or change the data in the blob in any way.
        /// When the data blob (the payload before base64-encoding) is added to the partition key
        /// size, the total size must not exceed the maximum record size (1 MiB).</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data
        /// Streams, which does not inspect, interpret, or change the data in the blob in any way.
        /// When the data blob (the payload before base64-encoding) is added to the partition key
        /// size, the total size must not exceed the maximum record size (1 MiB).</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// <p>Identifies which shard in the stream the data record is assigned to.</p>
        pub fn partition_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition_key = Some(input.into());
            self
        }
        /// <p>Identifies which shard in the stream the data record is assigned to.</p>
        pub fn set_partition_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partition_key = input;
            self
        }
        /// <p>The encryption type used on the record. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed AWS KMS key.</p>
        /// </li>
        /// </ul>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The encryption type used on the record. This parameter can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed AWS KMS key.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Record`](crate::model::Record)
        pub fn build(self) -> crate::model::Record {
            crate::model::Record {
                sequence_number: self.sequence_number,
                approximate_arrival_timestamp: self.approximate_arrival_timestamp,
                data: self.data,
                partition_key: self.partition_key,
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::model::Record)
    pub fn builder() -> crate::model::record::Builder {
        crate::model::record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricsName {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    IncomingBytes,
    #[allow(missing_docs)] // documentation missing in model
    IncomingRecords,
    #[allow(missing_docs)] // documentation missing in model
    IteratorAgeMilliseconds,
    #[allow(missing_docs)] // documentation missing in model
    OutgoingBytes,
    #[allow(missing_docs)] // documentation missing in model
    OutgoingRecords,
    #[allow(missing_docs)] // documentation missing in model
    ReadProvisionedThroughputExceeded,
    #[allow(missing_docs)] // documentation missing in model
    WriteProvisionedThroughputExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricsName {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => MetricsName::All,
            "IncomingBytes" => MetricsName::IncomingBytes,
            "IncomingRecords" => MetricsName::IncomingRecords,
            "IteratorAgeMilliseconds" => MetricsName::IteratorAgeMilliseconds,
            "OutgoingBytes" => MetricsName::OutgoingBytes,
            "OutgoingRecords" => MetricsName::OutgoingRecords,
            "ReadProvisionedThroughputExceeded" => MetricsName::ReadProvisionedThroughputExceeded,
            "WriteProvisionedThroughputExceeded" => MetricsName::WriteProvisionedThroughputExceeded,
            other => MetricsName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricsName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricsName::from(s))
    }
}
impl MetricsName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricsName::All => "ALL",
            MetricsName::IncomingBytes => "IncomingBytes",
            MetricsName::IncomingRecords => "IncomingRecords",
            MetricsName::IteratorAgeMilliseconds => "IteratorAgeMilliseconds",
            MetricsName::OutgoingBytes => "OutgoingBytes",
            MetricsName::OutgoingRecords => "OutgoingRecords",
            MetricsName::ReadProvisionedThroughputExceeded => "ReadProvisionedThroughputExceeded",
            MetricsName::WriteProvisionedThroughputExceeded => "WriteProvisionedThroughputExceeded",
            MetricsName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "IncomingBytes",
            "IncomingRecords",
            "IteratorAgeMilliseconds",
            "OutgoingBytes",
            "OutgoingRecords",
            "ReadProvisionedThroughputExceeded",
            "WriteProvisionedThroughputExceeded",
        ]
    }
}
impl AsRef<str> for MetricsName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the output for <a>DescribeStreamSummary</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamDescriptionSummary {
    /// <p>The name of the stream being described.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the stream being described. The stream status is one of the
    /// following states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
    /// immediately returns and sets <code>StreamStatus</code> to
    /// <code>CREATING</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
    /// the <code>DELETING</code> state until Kinesis Data Streams completes the
    /// deletion.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The stream exists and is ready for read and write
    /// operations or deletion. You should perform read and write operations only on an
    /// <code>ACTIVE</code> stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
    /// write operations continue to work while the stream is in the
    /// <code>UPDATING</code> state.</p>
    /// </li>
    /// </ul>
    pub stream_status: std::option::Option<crate::model::StreamStatus>,
    /// <p>The current retention period, in hours.</p>
    pub retention_period_hours: std::option::Option<i32>,
    /// <p>The approximate time that the stream was created.</p>
    pub stream_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Represents the current enhanced monitoring settings of the stream.</p>
    pub enhanced_monitoring: std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
    /// <p>The encryption type used. This value is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KMS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// </li>
    /// </ul>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
    /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
    /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
    /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN example: <code>
    /// arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Globally unique key ID example:
    /// <code>12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams:
    /// <code>alias/aws/kinesis</code>
    /// </p>
    /// </li>
    /// </ul>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>The number of open shards in the stream.</p>
    pub open_shard_count: std::option::Option<i32>,
    /// <p>The number of enhanced fan-out consumers registered with the stream.</p>
    pub consumer_count: std::option::Option<i32>,
}
impl StreamDescriptionSummary {
    /// <p>The name of the stream being described.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The current status of the stream being described. The stream status is one of the
    /// following states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
    /// immediately returns and sets <code>StreamStatus</code> to
    /// <code>CREATING</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
    /// the <code>DELETING</code> state until Kinesis Data Streams completes the
    /// deletion.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The stream exists and is ready for read and write
    /// operations or deletion. You should perform read and write operations only on an
    /// <code>ACTIVE</code> stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
    /// write operations continue to work while the stream is in the
    /// <code>UPDATING</code> state.</p>
    /// </li>
    /// </ul>
    pub fn stream_status(&self) -> std::option::Option<&crate::model::StreamStatus> {
        self.stream_status.as_ref()
    }
    /// <p>The current retention period, in hours.</p>
    pub fn retention_period_hours(&self) -> std::option::Option<i32> {
        self.retention_period_hours
    }
    /// <p>The approximate time that the stream was created.</p>
    pub fn stream_creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stream_creation_timestamp.as_ref()
    }
    /// <p>Represents the current enhanced monitoring settings of the stream.</p>
    pub fn enhanced_monitoring(&self) -> std::option::Option<&[crate::model::EnhancedMetrics]> {
        self.enhanced_monitoring.as_deref()
    }
    /// <p>The encryption type used. This value is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KMS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
    /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
    /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
    /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN example: <code>
    /// arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Globally unique key ID example:
    /// <code>12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams:
    /// <code>alias/aws/kinesis</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The number of open shards in the stream.</p>
    pub fn open_shard_count(&self) -> std::option::Option<i32> {
        self.open_shard_count
    }
    /// <p>The number of enhanced fan-out consumers registered with the stream.</p>
    pub fn consumer_count(&self) -> std::option::Option<i32> {
        self.consumer_count
    }
}
impl std::fmt::Debug for StreamDescriptionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamDescriptionSummary");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_status", &self.stream_status);
        formatter.field("retention_period_hours", &self.retention_period_hours);
        formatter.field("stream_creation_timestamp", &self.stream_creation_timestamp);
        formatter.field("enhanced_monitoring", &self.enhanced_monitoring);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("key_id", &self.key_id);
        formatter.field("open_shard_count", &self.open_shard_count);
        formatter.field("consumer_count", &self.consumer_count);
        formatter.finish()
    }
}
/// See [`StreamDescriptionSummary`](crate::model::StreamDescriptionSummary)
pub mod stream_description_summary {
    /// A builder for [`StreamDescriptionSummary`](crate::model::StreamDescriptionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_status: std::option::Option<crate::model::StreamStatus>,
        pub(crate) retention_period_hours: std::option::Option<i32>,
        pub(crate) stream_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) enhanced_monitoring:
            std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) open_shard_count: std::option::Option<i32>,
        pub(crate) consumer_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the stream being described.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream being described.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The current status of the stream being described. The stream status is one of the
        /// following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
        /// immediately returns and sets <code>StreamStatus</code> to
        /// <code>CREATING</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
        /// the <code>DELETING</code> state until Kinesis Data Streams completes the
        /// deletion.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The stream exists and is ready for read and write
        /// operations or deletion. You should perform read and write operations only on an
        /// <code>ACTIVE</code> stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
        /// write operations continue to work while the stream is in the
        /// <code>UPDATING</code> state.</p>
        /// </li>
        /// </ul>
        pub fn stream_status(mut self, input: crate::model::StreamStatus) -> Self {
            self.stream_status = Some(input);
            self
        }
        /// <p>The current status of the stream being described. The stream status is one of the
        /// following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
        /// immediately returns and sets <code>StreamStatus</code> to
        /// <code>CREATING</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
        /// the <code>DELETING</code> state until Kinesis Data Streams completes the
        /// deletion.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The stream exists and is ready for read and write
        /// operations or deletion. You should perform read and write operations only on an
        /// <code>ACTIVE</code> stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
        /// write operations continue to work while the stream is in the
        /// <code>UPDATING</code> state.</p>
        /// </li>
        /// </ul>
        pub fn set_stream_status(
            mut self,
            input: std::option::Option<crate::model::StreamStatus>,
        ) -> Self {
            self.stream_status = input;
            self
        }
        /// <p>The current retention period, in hours.</p>
        pub fn retention_period_hours(mut self, input: i32) -> Self {
            self.retention_period_hours = Some(input);
            self
        }
        /// <p>The current retention period, in hours.</p>
        pub fn set_retention_period_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period_hours = input;
            self
        }
        /// <p>The approximate time that the stream was created.</p>
        pub fn stream_creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stream_creation_timestamp = Some(input);
            self
        }
        /// <p>The approximate time that the stream was created.</p>
        pub fn set_stream_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stream_creation_timestamp = input;
            self
        }
        /// Appends an item to `enhanced_monitoring`.
        ///
        /// To override the contents of this collection use [`set_enhanced_monitoring`](Self::set_enhanced_monitoring).
        ///
        /// <p>Represents the current enhanced monitoring settings of the stream.</p>
        pub fn enhanced_monitoring(
            mut self,
            input: impl Into<crate::model::EnhancedMetrics>,
        ) -> Self {
            let mut v = self.enhanced_monitoring.unwrap_or_default();
            v.push(input.into());
            self.enhanced_monitoring = Some(v);
            self
        }
        /// <p>Represents the current enhanced monitoring settings of the stream.</p>
        pub fn set_enhanced_monitoring(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
        ) -> Self {
            self.enhanced_monitoring = input;
            self
        }
        /// <p>The encryption type used. This value is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KMS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The encryption type used. This value is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KMS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
        /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
        /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
        /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Key ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN example: <code>
        /// arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Globally unique key ID example:
        /// <code>12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name example: <code>alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Master key owned by Kinesis Data Streams:
        /// <code>alias/aws/kinesis</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
        /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
        /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
        /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Key ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN example: <code>
        /// arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Globally unique key ID example:
        /// <code>12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name example: <code>alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Master key owned by Kinesis Data Streams:
        /// <code>alias/aws/kinesis</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>The number of open shards in the stream.</p>
        pub fn open_shard_count(mut self, input: i32) -> Self {
            self.open_shard_count = Some(input);
            self
        }
        /// <p>The number of open shards in the stream.</p>
        pub fn set_open_shard_count(mut self, input: std::option::Option<i32>) -> Self {
            self.open_shard_count = input;
            self
        }
        /// <p>The number of enhanced fan-out consumers registered with the stream.</p>
        pub fn consumer_count(mut self, input: i32) -> Self {
            self.consumer_count = Some(input);
            self
        }
        /// <p>The number of enhanced fan-out consumers registered with the stream.</p>
        pub fn set_consumer_count(mut self, input: std::option::Option<i32>) -> Self {
            self.consumer_count = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamDescriptionSummary`](crate::model::StreamDescriptionSummary)
        pub fn build(self) -> crate::model::StreamDescriptionSummary {
            crate::model::StreamDescriptionSummary {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                stream_status: self.stream_status,
                retention_period_hours: self.retention_period_hours,
                stream_creation_timestamp: self.stream_creation_timestamp,
                enhanced_monitoring: self.enhanced_monitoring,
                encryption_type: self.encryption_type,
                key_id: self.key_id,
                open_shard_count: self.open_shard_count,
                consumer_count: self.consumer_count,
            }
        }
    }
}
impl StreamDescriptionSummary {
    /// Creates a new builder-style object to manufacture [`StreamDescriptionSummary`](crate::model::StreamDescriptionSummary)
    pub fn builder() -> crate::model::stream_description_summary::Builder {
        crate::model::stream_description_summary::Builder::default()
    }
}

/// <p>Represents enhanced metrics types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnhancedMetrics {
    /// <p>List of shard-level metrics.</p>
    /// <p>The following are the valid shard-level metrics. The value "<code>ALL</code>"
    /// enhances every metric.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IncomingBytes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IncomingRecords</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OutgoingBytes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OutgoingRecords</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WriteProvisionedThroughputExceeded</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadProvisionedThroughputExceeded</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IteratorAgeMilliseconds</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
    /// Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon
    /// Kinesis Data Streams Developer Guide</i>.</p>
    pub shard_level_metrics: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
}
impl EnhancedMetrics {
    /// <p>List of shard-level metrics.</p>
    /// <p>The following are the valid shard-level metrics. The value "<code>ALL</code>"
    /// enhances every metric.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IncomingBytes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IncomingRecords</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OutgoingBytes</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OutgoingRecords</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WriteProvisionedThroughputExceeded</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadProvisionedThroughputExceeded</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IteratorAgeMilliseconds</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
    /// Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon
    /// Kinesis Data Streams Developer Guide</i>.</p>
    pub fn shard_level_metrics(&self) -> std::option::Option<&[crate::model::MetricsName]> {
        self.shard_level_metrics.as_deref()
    }
}
impl std::fmt::Debug for EnhancedMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnhancedMetrics");
        formatter.field("shard_level_metrics", &self.shard_level_metrics);
        formatter.finish()
    }
}
/// See [`EnhancedMetrics`](crate::model::EnhancedMetrics)
pub mod enhanced_metrics {
    /// A builder for [`EnhancedMetrics`](crate::model::EnhancedMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shard_level_metrics:
            std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
    }
    impl Builder {
        /// Appends an item to `shard_level_metrics`.
        ///
        /// To override the contents of this collection use [`set_shard_level_metrics`](Self::set_shard_level_metrics).
        ///
        /// <p>List of shard-level metrics.</p>
        /// <p>The following are the valid shard-level metrics. The value "<code>ALL</code>"
        /// enhances every metric.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IncomingBytes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IncomingRecords</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OutgoingBytes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OutgoingRecords</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WriteProvisionedThroughputExceeded</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadProvisionedThroughputExceeded</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IteratorAgeMilliseconds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
        /// Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon
        /// Kinesis Data Streams Developer Guide</i>.</p>
        pub fn shard_level_metrics(mut self, input: impl Into<crate::model::MetricsName>) -> Self {
            let mut v = self.shard_level_metrics.unwrap_or_default();
            v.push(input.into());
            self.shard_level_metrics = Some(v);
            self
        }
        /// <p>List of shard-level metrics.</p>
        /// <p>The following are the valid shard-level metrics. The value "<code>ALL</code>"
        /// enhances every metric.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IncomingBytes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IncomingRecords</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OutgoingBytes</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OutgoingRecords</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WriteProvisionedThroughputExceeded</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadProvisionedThroughputExceeded</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IteratorAgeMilliseconds</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
        /// Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon
        /// Kinesis Data Streams Developer Guide</i>.</p>
        pub fn set_shard_level_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsName>>,
        ) -> Self {
            self.shard_level_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`EnhancedMetrics`](crate::model::EnhancedMetrics)
        pub fn build(self) -> crate::model::EnhancedMetrics {
            crate::model::EnhancedMetrics {
                shard_level_metrics: self.shard_level_metrics,
            }
        }
    }
}
impl EnhancedMetrics {
    /// Creates a new builder-style object to manufacture [`EnhancedMetrics`](crate::model::EnhancedMetrics)
    pub fn builder() -> crate::model::enhanced_metrics::Builder {
        crate::model::enhanced_metrics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StreamStatus::Active,
            "CREATING" => StreamStatus::Creating,
            "DELETING" => StreamStatus::Deleting,
            "UPDATING" => StreamStatus::Updating,
            other => StreamStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamStatus::from(s))
    }
}
impl StreamStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamStatus::Active => "ACTIVE",
            StreamStatus::Creating => "CREATING",
            StreamStatus::Deleting => "DELETING",
            StreamStatus::Updating => "UPDATING",
            StreamStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for StreamStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the details of a registered consumer. This type of object is
/// returned by <a>DescribeStreamConsumer</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConsumerDescription {
    /// <p>The name of the consumer is something you choose when you register the
    /// consumer.</p>
    pub consumer_name: std::option::Option<std::string::String>,
    /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
    /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
    /// <p>If you delete a consumer and then create a new one with the same name, it won't have
    /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
    /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
    pub consumer_arn: std::option::Option<std::string::String>,
    /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
    /// states.</p>
    pub consumer_status: std::option::Option<crate::model::ConsumerStatus>,
    /// <p></p>
    pub consumer_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the stream with which you registered the consumer.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl ConsumerDescription {
    /// <p>The name of the consumer is something you choose when you register the
    /// consumer.</p>
    pub fn consumer_name(&self) -> std::option::Option<&str> {
        self.consumer_name.as_deref()
    }
    /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
    /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
    /// <p>If you delete a consumer and then create a new one with the same name, it won't have
    /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
    /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
    pub fn consumer_arn(&self) -> std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
    /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
    /// states.</p>
    pub fn consumer_status(&self) -> std::option::Option<&crate::model::ConsumerStatus> {
        self.consumer_status.as_ref()
    }
    /// <p></p>
    pub fn consumer_creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.consumer_creation_timestamp.as_ref()
    }
    /// <p>The ARN of the stream with which you registered the consumer.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl std::fmt::Debug for ConsumerDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConsumerDescription");
        formatter.field("consumer_name", &self.consumer_name);
        formatter.field("consumer_arn", &self.consumer_arn);
        formatter.field("consumer_status", &self.consumer_status);
        formatter.field(
            "consumer_creation_timestamp",
            &self.consumer_creation_timestamp,
        );
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}
/// See [`ConsumerDescription`](crate::model::ConsumerDescription)
pub mod consumer_description {
    /// A builder for [`ConsumerDescription`](crate::model::ConsumerDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_name: std::option::Option<std::string::String>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
        pub(crate) consumer_status: std::option::Option<crate::model::ConsumerStatus>,
        pub(crate) consumer_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the consumer is something you choose when you register the
        /// consumer.</p>
        pub fn consumer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_name = Some(input.into());
            self
        }
        /// <p>The name of the consumer is something you choose when you register the
        /// consumer.</p>
        pub fn set_consumer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_name = input;
            self
        }
        /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
        /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
        /// <p>If you delete a consumer and then create a new one with the same name, it won't have
        /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
        /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>When you register a consumer, Kinesis Data Streams generates an ARN for it. You need
        /// this ARN to be able to call <a>SubscribeToShard</a>.</p>
        /// <p>If you delete a consumer and then create a new one with the same name, it won't have
        /// the same ARN. That's because consumer ARNs contain the creation timestamp. This is
        /// important to keep in mind if you have IAM policies that reference consumer ARNs.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
        /// states.</p>
        pub fn consumer_status(mut self, input: crate::model::ConsumerStatus) -> Self {
            self.consumer_status = Some(input);
            self
        }
        /// <p>A consumer can't read data while in the <code>CREATING</code> or <code>DELETING</code>
        /// states.</p>
        pub fn set_consumer_status(
            mut self,
            input: std::option::Option<crate::model::ConsumerStatus>,
        ) -> Self {
            self.consumer_status = input;
            self
        }
        /// <p></p>
        pub fn consumer_creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.consumer_creation_timestamp = Some(input);
            self
        }
        /// <p></p>
        pub fn set_consumer_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.consumer_creation_timestamp = input;
            self
        }
        /// <p>The ARN of the stream with which you registered the consumer.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the stream with which you registered the consumer.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConsumerDescription`](crate::model::ConsumerDescription)
        pub fn build(self) -> crate::model::ConsumerDescription {
            crate::model::ConsumerDescription {
                consumer_name: self.consumer_name,
                consumer_arn: self.consumer_arn,
                consumer_status: self.consumer_status,
                consumer_creation_timestamp: self.consumer_creation_timestamp,
                stream_arn: self.stream_arn,
            }
        }
    }
}
impl ConsumerDescription {
    /// Creates a new builder-style object to manufacture [`ConsumerDescription`](crate::model::ConsumerDescription)
    pub fn builder() -> crate::model::consumer_description::Builder {
        crate::model::consumer_description::Builder::default()
    }
}

/// <p>Represents the output for <a>DescribeStream</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamDescription {
    /// <p>The name of the stream being described.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the stream being described. The stream status is one of the
    /// following states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
    /// immediately returns and sets <code>StreamStatus</code> to
    /// <code>CREATING</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
    /// the <code>DELETING</code> state until Kinesis Data Streams completes the
    /// deletion.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The stream exists and is ready for read and write
    /// operations or deletion. You should perform read and write operations only on an
    /// <code>ACTIVE</code> stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
    /// write operations continue to work while the stream is in the
    /// <code>UPDATING</code> state.</p>
    /// </li>
    /// </ul>
    pub stream_status: std::option::Option<crate::model::StreamStatus>,
    /// <p>The shards that comprise the stream.</p>
    pub shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
    /// <p>If set to <code>true</code>, more shards in the stream are available to
    /// describe.</p>
    pub has_more_shards: std::option::Option<bool>,
    /// <p>The current retention period, in hours. Minimum value of 24. Maximum value of
    /// 168.</p>
    pub retention_period_hours: std::option::Option<i32>,
    /// <p>The approximate time that the stream was created.</p>
    pub stream_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Represents the current enhanced monitoring settings of the stream.</p>
    pub enhanced_monitoring: std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
    /// <p>The server-side encryption type used on the stream. This parameter can be one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed AWS KMS key.</p>
    /// </li>
    /// </ul>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
    /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
    /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
    /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Globally unique key ID example:
    /// <code>12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams:
    /// <code>alias/aws/kinesis</code>
    /// </p>
    /// </li>
    /// </ul>
    pub key_id: std::option::Option<std::string::String>,
}
impl StreamDescription {
    /// <p>The name of the stream being described.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The current status of the stream being described. The stream status is one of the
    /// following states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
    /// immediately returns and sets <code>StreamStatus</code> to
    /// <code>CREATING</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
    /// the <code>DELETING</code> state until Kinesis Data Streams completes the
    /// deletion.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The stream exists and is ready for read and write
    /// operations or deletion. You should perform read and write operations only on an
    /// <code>ACTIVE</code> stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
    /// write operations continue to work while the stream is in the
    /// <code>UPDATING</code> state.</p>
    /// </li>
    /// </ul>
    pub fn stream_status(&self) -> std::option::Option<&crate::model::StreamStatus> {
        self.stream_status.as_ref()
    }
    /// <p>The shards that comprise the stream.</p>
    pub fn shards(&self) -> std::option::Option<&[crate::model::Shard]> {
        self.shards.as_deref()
    }
    /// <p>If set to <code>true</code>, more shards in the stream are available to
    /// describe.</p>
    pub fn has_more_shards(&self) -> std::option::Option<bool> {
        self.has_more_shards
    }
    /// <p>The current retention period, in hours. Minimum value of 24. Maximum value of
    /// 168.</p>
    pub fn retention_period_hours(&self) -> std::option::Option<i32> {
        self.retention_period_hours
    }
    /// <p>The approximate time that the stream was created.</p>
    pub fn stream_creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stream_creation_timestamp.as_ref()
    }
    /// <p>Represents the current enhanced monitoring settings of the stream.</p>
    pub fn enhanced_monitoring(&self) -> std::option::Option<&[crate::model::EnhancedMetrics]> {
        self.enhanced_monitoring.as_deref()
    }
    /// <p>The server-side encryption type used on the stream. This parameter can be one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code>: Use server-side encryption on the records in the stream
    /// using a customer-managed AWS KMS key.</p>
    /// </li>
    /// </ul>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
    /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
    /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
    /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
    /// <ul>
    /// <li>
    /// <p>Key ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN example:
    /// <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Globally unique key ID example:
    /// <code>12345678-1234-1234-1234-123456789012</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name example: <code>alias/MyAliasName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Master key owned by Kinesis Data Streams:
    /// <code>alias/aws/kinesis</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for StreamDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamDescription");
        formatter.field("stream_name", &self.stream_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_status", &self.stream_status);
        formatter.field("shards", &self.shards);
        formatter.field("has_more_shards", &self.has_more_shards);
        formatter.field("retention_period_hours", &self.retention_period_hours);
        formatter.field("stream_creation_timestamp", &self.stream_creation_timestamp);
        formatter.field("enhanced_monitoring", &self.enhanced_monitoring);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`StreamDescription`](crate::model::StreamDescription)
pub mod stream_description {
    /// A builder for [`StreamDescription`](crate::model::StreamDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_status: std::option::Option<crate::model::StreamStatus>,
        pub(crate) shards: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        pub(crate) has_more_shards: std::option::Option<bool>,
        pub(crate) retention_period_hours: std::option::Option<i32>,
        pub(crate) stream_creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) enhanced_monitoring:
            std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stream being described.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the stream being described.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream being described.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The current status of the stream being described. The stream status is one of the
        /// following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
        /// immediately returns and sets <code>StreamStatus</code> to
        /// <code>CREATING</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
        /// the <code>DELETING</code> state until Kinesis Data Streams completes the
        /// deletion.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The stream exists and is ready for read and write
        /// operations or deletion. You should perform read and write operations only on an
        /// <code>ACTIVE</code> stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
        /// write operations continue to work while the stream is in the
        /// <code>UPDATING</code> state.</p>
        /// </li>
        /// </ul>
        pub fn stream_status(mut self, input: crate::model::StreamStatus) -> Self {
            self.stream_status = Some(input);
            self
        }
        /// <p>The current status of the stream being described. The stream status is one of the
        /// following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The stream is being created. Kinesis Data Streams
        /// immediately returns and sets <code>StreamStatus</code> to
        /// <code>CREATING</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The stream is being deleted. The specified stream is in
        /// the <code>DELETING</code> state until Kinesis Data Streams completes the
        /// deletion.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The stream exists and is ready for read and write
        /// operations or deletion. You should perform read and write operations only on an
        /// <code>ACTIVE</code> stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - Shards in the stream are being merged or split. Read and
        /// write operations continue to work while the stream is in the
        /// <code>UPDATING</code> state.</p>
        /// </li>
        /// </ul>
        pub fn set_stream_status(
            mut self,
            input: std::option::Option<crate::model::StreamStatus>,
        ) -> Self {
            self.stream_status = input;
            self
        }
        /// Appends an item to `shards`.
        ///
        /// To override the contents of this collection use [`set_shards`](Self::set_shards).
        ///
        /// <p>The shards that comprise the stream.</p>
        pub fn shards(mut self, input: impl Into<crate::model::Shard>) -> Self {
            let mut v = self.shards.unwrap_or_default();
            v.push(input.into());
            self.shards = Some(v);
            self
        }
        /// <p>The shards that comprise the stream.</p>
        pub fn set_shards(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Shard>>,
        ) -> Self {
            self.shards = input;
            self
        }
        /// <p>If set to <code>true</code>, more shards in the stream are available to
        /// describe.</p>
        pub fn has_more_shards(mut self, input: bool) -> Self {
            self.has_more_shards = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, more shards in the stream are available to
        /// describe.</p>
        pub fn set_has_more_shards(mut self, input: std::option::Option<bool>) -> Self {
            self.has_more_shards = input;
            self
        }
        /// <p>The current retention period, in hours. Minimum value of 24. Maximum value of
        /// 168.</p>
        pub fn retention_period_hours(mut self, input: i32) -> Self {
            self.retention_period_hours = Some(input);
            self
        }
        /// <p>The current retention period, in hours. Minimum value of 24. Maximum value of
        /// 168.</p>
        pub fn set_retention_period_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period_hours = input;
            self
        }
        /// <p>The approximate time that the stream was created.</p>
        pub fn stream_creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stream_creation_timestamp = Some(input);
            self
        }
        /// <p>The approximate time that the stream was created.</p>
        pub fn set_stream_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stream_creation_timestamp = input;
            self
        }
        /// Appends an item to `enhanced_monitoring`.
        ///
        /// To override the contents of this collection use [`set_enhanced_monitoring`](Self::set_enhanced_monitoring).
        ///
        /// <p>Represents the current enhanced monitoring settings of the stream.</p>
        pub fn enhanced_monitoring(
            mut self,
            input: impl Into<crate::model::EnhancedMetrics>,
        ) -> Self {
            let mut v = self.enhanced_monitoring.unwrap_or_default();
            v.push(input.into());
            self.enhanced_monitoring = Some(v);
            self
        }
        /// <p>Represents the current enhanced monitoring settings of the stream.</p>
        pub fn set_enhanced_monitoring(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnhancedMetrics>>,
        ) -> Self {
            self.enhanced_monitoring = input;
            self
        }
        /// <p>The server-side encryption type used on the stream. This parameter can be one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed AWS KMS key.</p>
        /// </li>
        /// </ul>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The server-side encryption type used on the stream. This parameter can be one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not encrypt the records in the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code>: Use server-side encryption on the records in the stream
        /// using a customer-managed AWS KMS key.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
        /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
        /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
        /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Key ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Globally unique key ID example:
        /// <code>12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name example: <code>alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Master key owned by Kinesis Data Streams:
        /// <code>alias/aws/kinesis</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The GUID for the customer-managed AWS KMS key to use for encryption. This value can
        /// be a globally unique identifier, a fully specified ARN to either an alias or a key, or
        /// an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data
        /// Streams by specifying the alias <code>aws/kinesis</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Key ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN example:
        /// <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Globally unique key ID example:
        /// <code>12345678-1234-1234-1234-123456789012</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name example: <code>alias/MyAliasName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Master key owned by Kinesis Data Streams:
        /// <code>alias/aws/kinesis</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamDescription`](crate::model::StreamDescription)
        pub fn build(self) -> crate::model::StreamDescription {
            crate::model::StreamDescription {
                stream_name: self.stream_name,
                stream_arn: self.stream_arn,
                stream_status: self.stream_status,
                shards: self.shards,
                has_more_shards: self.has_more_shards,
                retention_period_hours: self.retention_period_hours,
                stream_creation_timestamp: self.stream_creation_timestamp,
                enhanced_monitoring: self.enhanced_monitoring,
                encryption_type: self.encryption_type,
                key_id: self.key_id,
            }
        }
    }
}
impl StreamDescription {
    /// Creates a new builder-style object to manufacture [`StreamDescription`](crate::model::StreamDescription)
    pub fn builder() -> crate::model::stream_description::Builder {
        crate::model::stream_description::Builder::default()
    }
}
