// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTagsToStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToStreamError {
    /// Kind of error that occurred.
    pub kind: AddTagsToStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToStreamErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            AddTagsToStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            AddTagsToStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddTagsToStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddTagsToStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToStreamError {
    fn code(&self) -> Option<&str> {
        AddTagsToStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToStreamError {
    /// Creates a new `AddTagsToStreamError`.
    pub fn new(kind: AddTagsToStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToStreamErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AddTagsToStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            AddTagsToStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            AddTagsToStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddTagsToStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddTagsToStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamError {
    /// Kind of error that occurred.
    pub kind: CreateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamError {
    fn code(&self) -> Option<&str> {
        CreateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamError {
    /// Creates a new `CreateStreamError`.
    pub fn new(kind: CreateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for CreateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            CreateStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DecreaseStreamRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DecreaseStreamRetentionPeriodError {
    /// Kind of error that occurred.
    pub kind: DecreaseStreamRetentionPeriodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DecreaseStreamRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DecreaseStreamRetentionPeriodErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DecreaseStreamRetentionPeriodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DecreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DecreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DecreaseStreamRetentionPeriodErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DecreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DecreaseStreamRetentionPeriodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DecreaseStreamRetentionPeriodError {
    fn code(&self) -> Option<&str> {
        DecreaseStreamRetentionPeriodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DecreaseStreamRetentionPeriodError {
    /// Creates a new `DecreaseStreamRetentionPeriodError`.
    pub fn new(
        kind: DecreaseStreamRetentionPeriodErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DecreaseStreamRetentionPeriodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DecreaseStreamRetentionPeriodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DecreaseStreamRetentionPeriodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DecreaseStreamRetentionPeriodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DecreaseStreamRetentionPeriodErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseStreamRetentionPeriodErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseStreamRetentionPeriodErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseStreamRetentionPeriodErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DecreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DecreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DecreaseStreamRetentionPeriodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DecreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            DecreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DecreaseStreamRetentionPeriodErrorKind::LimitExceededException(_inner) => Some(_inner),
            DecreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DecreaseStreamRetentionPeriodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamErrorKind {
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamError {
    fn code(&self) -> Option<&str> {
        DeleteStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamError {
    /// Creates a new `DeleteStreamError`.
    pub fn new(kind: DeleteStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterStreamConsumerError {
    /// Kind of error that occurred.
    pub kind: DeregisterStreamConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterStreamConsumerErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterStreamConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterStreamConsumerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DeregisterStreamConsumerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeregisterStreamConsumerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeregisterStreamConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterStreamConsumerError {
    fn code(&self) -> Option<&str> {
        DeregisterStreamConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterStreamConsumerError {
    /// Creates a new `DeregisterStreamConsumerError`.
    pub fn new(kind: DeregisterStreamConsumerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterStreamConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterStreamConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterStreamConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterStreamConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterStreamConsumerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterStreamConsumerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterStreamConsumerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterStreamConsumerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterStreamConsumerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterStreamConsumerErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeregisterStreamConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterStreamConsumerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DeregisterStreamConsumerErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeregisterStreamConsumerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeregisterStreamConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLimitsErrorKind {
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLimitsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLimitsError {
    /// Creates a new `DescribeLimitsError`.
    pub fn new(kind: DescribeLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLimitsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLimitsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for DescribeLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLimitsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStreamError {
    /// Kind of error that occurred.
    pub kind: DescribeStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStreamErrorKind {
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStreamError {
    fn code(&self) -> Option<&str> {
        DescribeStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStreamError {
    /// Creates a new `DescribeStreamError`.
    pub fn new(kind: DescribeStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStreamConsumerError {
    /// Kind of error that occurred.
    pub kind: DescribeStreamConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStreamConsumerErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStreamConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStreamConsumerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DescribeStreamConsumerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeStreamConsumerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStreamConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStreamConsumerError {
    fn code(&self) -> Option<&str> {
        DescribeStreamConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStreamConsumerError {
    /// Creates a new `DescribeStreamConsumerError`.
    pub fn new(kind: DescribeStreamConsumerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStreamConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStreamConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStreamConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStreamConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStreamConsumerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamConsumerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamConsumerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamConsumerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamConsumerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamConsumerErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStreamConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStreamConsumerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DescribeStreamConsumerErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeStreamConsumerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStreamConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStreamSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStreamSummaryError {
    /// Kind of error that occurred.
    pub kind: DescribeStreamSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStreamSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStreamSummaryErrorKind {
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStreamSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStreamSummaryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeStreamSummaryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStreamSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStreamSummaryError {
    fn code(&self) -> Option<&str> {
        DescribeStreamSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStreamSummaryError {
    /// Creates a new `DescribeStreamSummaryError`.
    pub fn new(kind: DescribeStreamSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStreamSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStreamSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStreamSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStreamSummaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStreamSummaryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamSummaryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamSummaryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamSummaryErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStreamSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStreamSummaryErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeStreamSummaryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStreamSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableEnhancedMonitoring` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableEnhancedMonitoringError {
    /// Kind of error that occurred.
    pub kind: DisableEnhancedMonitoringErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableEnhancedMonitoring` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableEnhancedMonitoringErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableEnhancedMonitoringError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableEnhancedMonitoringErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            DisableEnhancedMonitoringErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DisableEnhancedMonitoringErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DisableEnhancedMonitoringErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableEnhancedMonitoringErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableEnhancedMonitoringError {
    fn code(&self) -> Option<&str> {
        DisableEnhancedMonitoringError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableEnhancedMonitoringError {
    /// Creates a new `DisableEnhancedMonitoringError`.
    pub fn new(kind: DisableEnhancedMonitoringErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableEnhancedMonitoringError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableEnhancedMonitoringErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableEnhancedMonitoringError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableEnhancedMonitoringErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableEnhancedMonitoringErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableEnhancedMonitoringErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableEnhancedMonitoringErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableEnhancedMonitoringErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableEnhancedMonitoringErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableEnhancedMonitoringErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableEnhancedMonitoringErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableEnhancedMonitoringErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableEnhancedMonitoringError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableEnhancedMonitoringErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            DisableEnhancedMonitoringErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DisableEnhancedMonitoringErrorKind::LimitExceededException(_inner) => Some(_inner),
            DisableEnhancedMonitoringErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableEnhancedMonitoringErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableEnhancedMonitoring` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableEnhancedMonitoringError {
    /// Kind of error that occurred.
    pub kind: EnableEnhancedMonitoringErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableEnhancedMonitoring` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableEnhancedMonitoringErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableEnhancedMonitoringError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableEnhancedMonitoringErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            EnableEnhancedMonitoringErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            EnableEnhancedMonitoringErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableEnhancedMonitoringErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableEnhancedMonitoringErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableEnhancedMonitoringError {
    fn code(&self) -> Option<&str> {
        EnableEnhancedMonitoringError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableEnhancedMonitoringError {
    /// Creates a new `EnableEnhancedMonitoringError`.
    pub fn new(kind: EnableEnhancedMonitoringErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableEnhancedMonitoringError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableEnhancedMonitoringErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableEnhancedMonitoringError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableEnhancedMonitoringErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableEnhancedMonitoringErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableEnhancedMonitoringErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableEnhancedMonitoringErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableEnhancedMonitoringErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableEnhancedMonitoringErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableEnhancedMonitoringErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableEnhancedMonitoringErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableEnhancedMonitoringErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableEnhancedMonitoringError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableEnhancedMonitoringErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            EnableEnhancedMonitoringErrorKind::ResourceInUseException(_inner) => Some(_inner),
            EnableEnhancedMonitoringErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableEnhancedMonitoringErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableEnhancedMonitoringErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecordsError {
    /// Kind of error that occurred.
    pub kind: GetRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecordsErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The provided iterator exceeds the maximum age allowed.</p>
    ExpiredIteratorException(crate::error::ExpiredIteratorException),
    /// <p>The AWS access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>AWS Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>The request rate for the stream is too high, or the requested data is too large for
    /// the available throughput. Reduce the frequency or size of your requests. For more
    /// information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
    /// <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
    /// Exponential Backoff in AWS</a> in the <i>AWS General
    /// Reference</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The request was rejected because the state of the specified resource isn't valid
    /// for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>AWS Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecordsErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::ExpiredIteratorException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::KmsOptInRequired(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::KmsThrottlingException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecordsError {
    fn code(&self) -> Option<&str> {
        GetRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecordsError {
    /// Creates a new `GetRecordsError`.
    pub fn new(kind: GetRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecordsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsDisabledException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::ExpiredIteratorException`.
    pub fn is_expired_iterator_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::ExpiredIteratorException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsOptInRequired(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordsErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, GetRecordsErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `GetRecordsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecordsErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            GetRecordsErrorKind::KmsDisabledException(_inner) => Some(_inner),
            GetRecordsErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            GetRecordsErrorKind::ExpiredIteratorException(_inner) => Some(_inner),
            GetRecordsErrorKind::KmsOptInRequired(_inner) => Some(_inner),
            GetRecordsErrorKind::KmsThrottlingException(_inner) => Some(_inner),
            GetRecordsErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            GetRecordsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            GetRecordsErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            GetRecordsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetShardIterator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetShardIteratorError {
    /// Kind of error that occurred.
    pub kind: GetShardIteratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetShardIterator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetShardIteratorErrorKind {
    /// <p>The request rate for the stream is too high, or the requested data is too large for
    /// the available throughput. Reduce the frequency or size of your requests. For more
    /// information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
    /// <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
    /// Exponential Backoff in AWS</a> in the <i>AWS General
    /// Reference</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetShardIteratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetShardIteratorErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetShardIteratorErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            GetShardIteratorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetShardIteratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetShardIteratorError {
    fn code(&self) -> Option<&str> {
        GetShardIteratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetShardIteratorError {
    /// Creates a new `GetShardIteratorError`.
    pub fn new(kind: GetShardIteratorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetShardIteratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetShardIteratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetShardIteratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetShardIteratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetShardIteratorErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetShardIteratorErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetShardIteratorErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetShardIteratorErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetShardIteratorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetShardIteratorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetShardIteratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetShardIteratorErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            GetShardIteratorErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            GetShardIteratorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetShardIteratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `IncreaseStreamRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct IncreaseStreamRetentionPeriodError {
    /// Kind of error that occurred.
    pub kind: IncreaseStreamRetentionPeriodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `IncreaseStreamRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum IncreaseStreamRetentionPeriodErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for IncreaseStreamRetentionPeriodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            IncreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            IncreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            IncreaseStreamRetentionPeriodErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            IncreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            IncreaseStreamRetentionPeriodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for IncreaseStreamRetentionPeriodError {
    fn code(&self) -> Option<&str> {
        IncreaseStreamRetentionPeriodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl IncreaseStreamRetentionPeriodError {
    /// Creates a new `IncreaseStreamRetentionPeriodError`.
    pub fn new(
        kind: IncreaseStreamRetentionPeriodErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `IncreaseStreamRetentionPeriodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: IncreaseStreamRetentionPeriodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `IncreaseStreamRetentionPeriodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: IncreaseStreamRetentionPeriodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `IncreaseStreamRetentionPeriodErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseStreamRetentionPeriodErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseStreamRetentionPeriodErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseStreamRetentionPeriodErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `IncreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            IncreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for IncreaseStreamRetentionPeriodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            IncreaseStreamRetentionPeriodErrorKind::InvalidArgumentException(_inner) => {
                Some(_inner)
            }
            IncreaseStreamRetentionPeriodErrorKind::ResourceInUseException(_inner) => Some(_inner),
            IncreaseStreamRetentionPeriodErrorKind::LimitExceededException(_inner) => Some(_inner),
            IncreaseStreamRetentionPeriodErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            IncreaseStreamRetentionPeriodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListShards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListShardsError {
    /// Kind of error that occurred.
    pub kind: ListShardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListShards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListShardsErrorKind {
    /// <p>The pagination token passed to the operation is expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListShardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListShardsErrorKind::ExpiredNextTokenException(_inner) => _inner.fmt(f),
            ListShardsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListShardsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            ListShardsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListShardsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListShardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListShardsError {
    fn code(&self) -> Option<&str> {
        ListShardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListShardsError {
    /// Creates a new `ListShardsError`.
    pub fn new(kind: ListShardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListShardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListShardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListShardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListShardsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListShardsErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShardsErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListShardsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, ListShardsErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `ListShardsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, ListShardsErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `ListShardsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListShardsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `ListShardsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShardsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListShardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListShardsErrorKind::ExpiredNextTokenException(_inner) => Some(_inner),
            ListShardsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListShardsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            ListShardsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListShardsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListShardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreamConsumers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamConsumersError {
    /// Kind of error that occurred.
    pub kind: ListStreamConsumersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreamConsumers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamConsumersErrorKind {
    /// <p>The pagination token passed to the operation is expired.</p>
    ExpiredNextTokenException(crate::error::ExpiredNextTokenException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamConsumersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamConsumersErrorKind::ExpiredNextTokenException(_inner) => _inner.fmt(f),
            ListStreamConsumersErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListStreamConsumersErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            ListStreamConsumersErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListStreamConsumersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStreamConsumersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamConsumersError {
    fn code(&self) -> Option<&str> {
        ListStreamConsumersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamConsumersError {
    /// Creates a new `ListStreamConsumersError`.
    pub fn new(kind: ListStreamConsumersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamConsumersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamConsumersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamConsumersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamConsumersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStreamConsumersErrorKind::ExpiredNextTokenException`.
    pub fn is_expired_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamConsumersErrorKind::ExpiredNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStreamConsumersErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamConsumersErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStreamConsumersErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamConsumersErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStreamConsumersErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamConsumersErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStreamConsumersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamConsumersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListStreamConsumersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamConsumersErrorKind::ExpiredNextTokenException(_inner) => Some(_inner),
            ListStreamConsumersErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListStreamConsumersErrorKind::ResourceInUseException(_inner) => Some(_inner),
            ListStreamConsumersErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListStreamConsumersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStreamConsumersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamsError {
    /// Kind of error that occurred.
    pub kind: ListStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamsErrorKind {
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamsError {
    fn code(&self) -> Option<&str> {
        ListStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamsError {
    /// Creates a new `ListStreamsError`.
    pub fn new(kind: ListStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStreamsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListStreamsErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for ListStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForStreamError {
    /// Kind of error that occurred.
    pub kind: ListTagsForStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForStreamErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForStreamError {
    fn code(&self) -> Option<&str> {
        ListTagsForStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForStreamError {
    /// Creates a new `ListTagsForStreamError`.
    pub fn new(kind: ListTagsForStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergeShards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergeShardsError {
    /// Kind of error that occurred.
    pub kind: MergeShardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergeShards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergeShardsErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergeShardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergeShardsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            MergeShardsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            MergeShardsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            MergeShardsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            MergeShardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergeShardsError {
    fn code(&self) -> Option<&str> {
        MergeShardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergeShardsError {
    /// Creates a new `MergeShardsError`.
    pub fn new(kind: MergeShardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergeShardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergeShardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergeShardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergeShardsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergeShardsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeShardsErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeShardsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, MergeShardsErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `MergeShardsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, MergeShardsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `MergeShardsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeShardsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for MergeShardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergeShardsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            MergeShardsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            MergeShardsErrorKind::LimitExceededException(_inner) => Some(_inner),
            MergeShardsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            MergeShardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRecordError {
    /// Kind of error that occurred.
    pub kind: PutRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRecordErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The AWS access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>AWS Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>The request rate for the stream is too high, or the requested data is too large for
    /// the available throughput. Reduce the frequency or size of your requests. For more
    /// information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
    /// <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
    /// Exponential Backoff in AWS</a> in the <i>AWS General
    /// Reference</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The request was rejected because the state of the specified resource isn't valid
    /// for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>AWS Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRecordErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::KmsOptInRequired(_inner) => _inner.fmt(f),
            PutRecordErrorKind::KmsThrottlingException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRecordError {
    fn code(&self) -> Option<&str> {
        PutRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRecordError {
    /// Creates a new `PutRecordError`.
    pub fn new(kind: PutRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRecordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsDisabledException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsOptInRequired(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `PutRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRecordErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for PutRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRecordErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            PutRecordErrorKind::KmsDisabledException(_inner) => Some(_inner),
            PutRecordErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            PutRecordErrorKind::KmsOptInRequired(_inner) => Some(_inner),
            PutRecordErrorKind::KmsThrottlingException(_inner) => Some(_inner),
            PutRecordErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            PutRecordErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            PutRecordErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            PutRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRecordsError {
    /// Kind of error that occurred.
    pub kind: PutRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRecordsErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The AWS access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>AWS Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>The request rate for the stream is too high, or the requested data is too large for
    /// the available throughput. Reduce the frequency or size of your requests. For more
    /// information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
    /// <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
    /// Exponential Backoff in AWS</a> in the <i>AWS General
    /// Reference</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The request was rejected because the state of the specified resource isn't valid
    /// for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>AWS Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRecordsErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::KmsOptInRequired(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::KmsThrottlingException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRecordsError {
    fn code(&self) -> Option<&str> {
        PutRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRecordsError {
    /// Creates a new `PutRecordsError`.
    pub fn new(kind: PutRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRecordsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsDisabledException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsOptInRequired(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordsErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, PutRecordsErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `PutRecordsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRecordsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRecordsErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            PutRecordsErrorKind::KmsDisabledException(_inner) => Some(_inner),
            PutRecordsErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            PutRecordsErrorKind::KmsOptInRequired(_inner) => Some(_inner),
            PutRecordsErrorKind::KmsThrottlingException(_inner) => Some(_inner),
            PutRecordsErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            PutRecordsErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            PutRecordsErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            PutRecordsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterStreamConsumerError {
    /// Kind of error that occurred.
    pub kind: RegisterStreamConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterStreamConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterStreamConsumerErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterStreamConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterStreamConsumerErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            RegisterStreamConsumerErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            RegisterStreamConsumerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterStreamConsumerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RegisterStreamConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterStreamConsumerError {
    fn code(&self) -> Option<&str> {
        RegisterStreamConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterStreamConsumerError {
    /// Creates a new `RegisterStreamConsumerError`.
    pub fn new(kind: RegisterStreamConsumerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterStreamConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterStreamConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterStreamConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterStreamConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterStreamConsumerErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterStreamConsumerErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterStreamConsumerErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterStreamConsumerErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterStreamConsumerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterStreamConsumerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterStreamConsumerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterStreamConsumerErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RegisterStreamConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterStreamConsumerErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            RegisterStreamConsumerErrorKind::ResourceInUseException(_inner) => Some(_inner),
            RegisterStreamConsumerErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterStreamConsumerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RegisterStreamConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromStreamError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromStreamErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromStreamErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            RemoveTagsFromStreamErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            RemoveTagsFromStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RemoveTagsFromStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsFromStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromStreamError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromStreamError {
    /// Creates a new `RemoveTagsFromStreamError`.
    pub fn new(kind: RemoveTagsFromStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromStreamErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromStreamErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromStreamErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromStreamErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromStreamErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromStreamErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            RemoveTagsFromStreamErrorKind::ResourceInUseException(_inner) => Some(_inner),
            RemoveTagsFromStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            RemoveTagsFromStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveTagsFromStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SplitShard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SplitShardError {
    /// Kind of error that occurred.
    pub kind: SplitShardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SplitShard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SplitShardErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SplitShardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SplitShardErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            SplitShardErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            SplitShardErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            SplitShardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SplitShardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SplitShardError {
    fn code(&self) -> Option<&str> {
        SplitShardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SplitShardError {
    /// Creates a new `SplitShardError`.
    pub fn new(kind: SplitShardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SplitShardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SplitShardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SplitShardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SplitShardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SplitShardErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(&self.kind, SplitShardErrorKind::InvalidArgumentException(_))
    }
    /// Returns `true` if the error kind is `SplitShardErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, SplitShardErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `SplitShardErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, SplitShardErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `SplitShardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SplitShardErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for SplitShardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SplitShardErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            SplitShardErrorKind::ResourceInUseException(_inner) => Some(_inner),
            SplitShardErrorKind::LimitExceededException(_inner) => Some(_inner),
            SplitShardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SplitShardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartStreamEncryptionError {
    /// Kind of error that occurred.
    pub kind: StartStreamEncryptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartStreamEncryptionErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The AWS access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>AWS Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The request was rejected because the state of the specified resource isn't valid
    /// for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>AWS Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartStreamEncryptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartStreamEncryptionErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::KmsOptInRequired(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::KmsThrottlingException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartStreamEncryptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartStreamEncryptionError {
    fn code(&self) -> Option<&str> {
        StartStreamEncryptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartStreamEncryptionError {
    /// Creates a new `StartStreamEncryptionError`.
    pub fn new(kind: StartStreamEncryptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartStreamEncryptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartStreamEncryptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartStreamEncryptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartStreamEncryptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsOptInRequired(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::KmsInvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartStreamEncryptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartStreamEncryptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartStreamEncryptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartStreamEncryptionErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::KmsDisabledException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::KmsOptInRequired(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::KmsThrottlingException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartStreamEncryptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopStreamEncryptionError {
    /// Kind of error that occurred.
    pub kind: StopStreamEncryptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopStreamEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopStreamEncryptionErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopStreamEncryptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopStreamEncryptionErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            StopStreamEncryptionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StopStreamEncryptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StopStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopStreamEncryptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopStreamEncryptionError {
    fn code(&self) -> Option<&str> {
        StopStreamEncryptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopStreamEncryptionError {
    /// Creates a new `StopStreamEncryptionError`.
    pub fn new(kind: StopStreamEncryptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopStreamEncryptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopStreamEncryptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopStreamEncryptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopStreamEncryptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopStreamEncryptionErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStreamEncryptionErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `StopStreamEncryptionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStreamEncryptionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StopStreamEncryptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStreamEncryptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StopStreamEncryptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStreamEncryptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopStreamEncryptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopStreamEncryptionErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            StopStreamEncryptionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StopStreamEncryptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            StopStreamEncryptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopStreamEncryptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateShardCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateShardCountError {
    /// Kind of error that occurred.
    pub kind: UpdateShardCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateShardCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateShardCountErrorKind {
    /// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
    /// For more information, see the returned message.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>The resource is not available for this operation. For successful operation, the
    /// resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource could not be found. The stream might not be specified
    /// correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateShardCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateShardCountErrorKind::InvalidArgumentException(_inner) => _inner.fmt(f),
            UpdateShardCountErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateShardCountErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateShardCountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateShardCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateShardCountError {
    fn code(&self) -> Option<&str> {
        UpdateShardCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateShardCountError {
    /// Creates a new `UpdateShardCountError`.
    pub fn new(kind: UpdateShardCountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateShardCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateShardCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateShardCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateShardCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateShardCountErrorKind::InvalidArgumentException`.
    pub fn is_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShardCountErrorKind::InvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateShardCountErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShardCountErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateShardCountErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShardCountErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateShardCountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShardCountErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateShardCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateShardCountErrorKind::InvalidArgumentException(_inner) => Some(_inner),
            UpdateShardCountErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateShardCountErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateShardCountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateShardCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requested resource could not be found. The stream might not be specified
/// correctly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The requested resource exceeds the maximum number allowed, or the number of
/// concurrent stream requests exceeds the maximum number allowed. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The resource is not available for this operation. For successful operation, the
/// resource must be in the <code>ACTIVE</code> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
/// For more information, see the returned message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgumentException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgumentException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgumentException {}
/// See [`InvalidArgumentException`](crate::error::InvalidArgumentException)
pub mod invalid_argument_exception {
    /// A builder for [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgumentException`](crate::error::InvalidArgumentException)
        pub fn build(self) -> crate::error::InvalidArgumentException {
            crate::error::InvalidArgumentException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgumentException {
    /// Creates a new builder-style object to manufacture [`InvalidArgumentException`](crate::error::InvalidArgumentException)
    pub fn builder() -> crate::error::invalid_argument_exception::Builder {
        crate::error::invalid_argument_exception::Builder::default()
    }
}

/// <p>The request was rejected because the state of the specified resource isn't valid
/// for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
/// Customer Master Key</a> in the <i>AWS Key Management Service Developer
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidStateException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInvalidStateException [KMSInvalidStateException]")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidStateException {}
/// See [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
pub mod kms_invalid_state_exception {
    /// A builder for [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
        pub fn build(self) -> crate::error::KmsInvalidStateException {
            crate::error::KmsInvalidStateException {
                message: self.message,
            }
        }
    }
}
impl KmsInvalidStateException {
    /// Creates a new builder-style object to manufacture [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    pub fn builder() -> crate::error::kms_invalid_state_exception::Builder {
        crate::error::kms_invalid_state_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling. For more information about
/// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
/// the <i>AWS Key Management Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsThrottlingException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsThrottlingException [KMSThrottlingException]")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsThrottlingException {}
/// See [`KmsThrottlingException`](crate::error::KmsThrottlingException)
pub mod kms_throttling_exception {
    /// A builder for [`KmsThrottlingException`](crate::error::KmsThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsThrottlingException`](crate::error::KmsThrottlingException)
        pub fn build(self) -> crate::error::KmsThrottlingException {
            crate::error::KmsThrottlingException {
                message: self.message,
            }
        }
    }
}
impl KmsThrottlingException {
    /// Creates a new builder-style object to manufacture [`KmsThrottlingException`](crate::error::KmsThrottlingException)
    pub fn builder() -> crate::error::kms_throttling_exception::Builder {
        crate::error::kms_throttling_exception::Builder::default()
    }
}

/// <p>The AWS access key ID needs a subscription for the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsOptInRequired {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsOptInRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsOptInRequired");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsOptInRequired {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsOptInRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsOptInRequired [KMSOptInRequired]")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsOptInRequired {}
/// See [`KmsOptInRequired`](crate::error::KmsOptInRequired)
pub mod kms_opt_in_required {
    /// A builder for [`KmsOptInRequired`](crate::error::KmsOptInRequired)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsOptInRequired`](crate::error::KmsOptInRequired)
        pub fn build(self) -> crate::error::KmsOptInRequired {
            crate::error::KmsOptInRequired {
                message: self.message,
            }
        }
    }
}
impl KmsOptInRequired {
    /// Creates a new builder-style object to manufacture [`KmsOptInRequired`](crate::error::KmsOptInRequired)
    pub fn builder() -> crate::error::kms_opt_in_required::Builder {
        crate::error::kms_opt_in_required::Builder::default()
    }
}

/// <p>The request was rejected because the specified entity or resource can't be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsNotFoundException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsNotFoundException [KMSNotFoundException]")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsNotFoundException {}
/// See [`KmsNotFoundException`](crate::error::KmsNotFoundException)
pub mod kms_not_found_exception {
    /// A builder for [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsNotFoundException`](crate::error::KmsNotFoundException)
        pub fn build(self) -> crate::error::KmsNotFoundException {
            crate::error::KmsNotFoundException {
                message: self.message,
            }
        }
    }
}
impl KmsNotFoundException {
    /// Creates a new builder-style object to manufacture [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    pub fn builder() -> crate::error::kms_not_found_exception::Builder {
        crate::error::kms_not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified customer master key (CMK) isn't
/// enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsDisabledException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsDisabledException [KMSDisabledException]")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsDisabledException {}
/// See [`KmsDisabledException`](crate::error::KmsDisabledException)
pub mod kms_disabled_exception {
    /// A builder for [`KmsDisabledException`](crate::error::KmsDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsDisabledException`](crate::error::KmsDisabledException)
        pub fn build(self) -> crate::error::KmsDisabledException {
            crate::error::KmsDisabledException {
                message: self.message,
            }
        }
    }
}
impl KmsDisabledException {
    /// Creates a new builder-style object to manufacture [`KmsDisabledException`](crate::error::KmsDisabledException)
    pub fn builder() -> crate::error::kms_disabled_exception::Builder {
        crate::error::kms_disabled_exception::Builder::default()
    }
}

/// <p>The ciphertext references a key that doesn't exist or that you don't have access
/// to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsAccessDeniedException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsAccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsAccessDeniedException [KMSAccessDeniedException]")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsAccessDeniedException {}
/// See [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
pub mod kms_access_denied_exception {
    /// A builder for [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
        pub fn build(self) -> crate::error::KmsAccessDeniedException {
            crate::error::KmsAccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl KmsAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    pub fn builder() -> crate::error::kms_access_denied_exception::Builder {
        crate::error::kms_access_denied_exception::Builder::default()
    }
}

/// <p>The request rate for the stream is too high, or the requested data is too large for
/// the available throughput. Reduce the frequency or size of your requests. For more
/// information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
/// <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
/// Exponential Backoff in AWS</a> in the <i>AWS General
/// Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughputExceededException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughputExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProvisionedThroughputExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProvisionedThroughputExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedThroughputExceededException {}
/// See [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
pub mod provisioned_throughput_exceeded_exception {
    /// A builder for [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
        pub fn build(self) -> crate::error::ProvisionedThroughputExceededException {
            crate::error::ProvisionedThroughputExceededException {
                message: self.message,
            }
        }
    }
}
impl ProvisionedThroughputExceededException {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    pub fn builder() -> crate::error::provisioned_throughput_exceeded_exception::Builder {
        crate::error::provisioned_throughput_exceeded_exception::Builder::default()
    }
}

/// <p>The pagination token passed to the operation is expired.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredNextTokenException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredNextTokenException {}
/// See [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
pub mod expired_next_token_exception {
    /// A builder for [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
        pub fn build(self) -> crate::error::ExpiredNextTokenException {
            crate::error::ExpiredNextTokenException {
                message: self.message,
            }
        }
    }
}
impl ExpiredNextTokenException {
    /// Creates a new builder-style object to manufacture [`ExpiredNextTokenException`](crate::error::ExpiredNextTokenException)
    pub fn builder() -> crate::error::expired_next_token_exception::Builder {
        crate::error::expired_next_token_exception::Builder::default()
    }
}

/// <p>The provided iterator exceeds the maximum age allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpiredIteratorException {
    /// <p>A message that provides information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExpiredIteratorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpiredIteratorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExpiredIteratorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExpiredIteratorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExpiredIteratorException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExpiredIteratorException {}
/// See [`ExpiredIteratorException`](crate::error::ExpiredIteratorException)
pub mod expired_iterator_exception {
    /// A builder for [`ExpiredIteratorException`](crate::error::ExpiredIteratorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that provides information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpiredIteratorException`](crate::error::ExpiredIteratorException)
        pub fn build(self) -> crate::error::ExpiredIteratorException {
            crate::error::ExpiredIteratorException {
                message: self.message,
            }
        }
    }
}
impl ExpiredIteratorException {
    /// Creates a new builder-style object to manufacture [`ExpiredIteratorException`](crate::error::ExpiredIteratorException)
    pub fn builder() -> crate::error::expired_iterator_exception::Builder {
        crate::error::expired_iterator_exception::Builder::default()
    }
}
