// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableOutput {
    /// <p>The Amazon Resource Name (ARN) of the modified table.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl UpdateTableOutput {
    /// <p>The Amazon Resource Name (ARN) of the modified table.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`UpdateTableOutput`](crate::output::UpdateTableOutput)
pub mod update_table_output {
    /// A builder for [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the modified table.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the modified table.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableOutput`](crate::output::UpdateTableOutput)
        pub fn build(self) -> crate::output::UpdateTableOutput {
            crate::output::UpdateTableOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl UpdateTableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    pub fn builder() -> crate::output::update_table_output::Builder {
        crate::output::update_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableOutput {
    /// <p>The Amazon Resource Name (ARN) of the restored table.</p>
    pub restored_table_arn: std::option::Option<std::string::String>,
}
impl RestoreTableOutput {
    /// <p>The Amazon Resource Name (ARN) of the restored table.</p>
    pub fn restored_table_arn(&self) -> std::option::Option<&str> {
        self.restored_table_arn.as_deref()
    }
}
impl std::fmt::Debug for RestoreTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableOutput");
        formatter.field("restored_table_arn", &self.restored_table_arn);
        formatter.finish()
    }
}
/// See [`RestoreTableOutput`](crate::output::RestoreTableOutput)
pub mod restore_table_output {
    /// A builder for [`RestoreTableOutput`](crate::output::RestoreTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restored_table_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the restored table.</p>
        pub fn restored_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.restored_table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the restored table.</p>
        pub fn set_restored_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restored_table_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableOutput`](crate::output::RestoreTableOutput)
        pub fn build(self) -> crate::output::RestoreTableOutput {
            crate::output::RestoreTableOutput {
                restored_table_arn: self.restored_table_arn,
            }
        }
    }
}
impl RestoreTableOutput {
    /// Creates a new builder-style object to manufacture [`RestoreTableOutput`](crate::output::RestoreTableOutput)
    pub fn builder() -> crate::output::restore_table_output::Builder {
        crate::output::restore_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                next_token: self.next_token,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of tables.</p>
    pub tables: std::option::Option<std::vec::Vec<crate::model::TableSummary>>,
}
impl ListTablesOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of tables.</p>
    pub fn tables(&self) -> std::option::Option<&[crate::model::TableSummary]> {
        self.tables.as_deref()
    }
}
impl std::fmt::Debug for ListTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("tables", &self.tables);
        formatter.finish()
    }
}
/// See [`ListTablesOutput`](crate::output::ListTablesOutput)
pub mod list_tables_output {
    /// A builder for [`ListTablesOutput`](crate::output::ListTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tables: std::option::Option<std::vec::Vec<crate::model::TableSummary>>,
    }
    impl Builder {
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `tables`.
        ///
        /// To override the contents of this collection use [`set_tables`](Self::set_tables).
        ///
        /// <p>A list of tables.</p>
        pub fn tables(mut self, input: crate::model::TableSummary) -> Self {
            let mut v = self.tables.unwrap_or_default();
            v.push(input);
            self.tables = Some(v);
            self
        }
        /// <p>A list of tables.</p>
        pub fn set_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableSummary>>,
        ) -> Self {
            self.tables = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesOutput`](crate::output::ListTablesOutput)
        pub fn build(self) -> crate::output::ListTablesOutput {
            crate::output::ListTablesOutput {
                next_token: self.next_token,
                tables: self.tables,
            }
        }
    }
}
impl ListTablesOutput {
    /// Creates a new builder-style object to manufacture [`ListTablesOutput`](crate::output::ListTablesOutput)
    pub fn builder() -> crate::output::list_tables_output::Builder {
        crate::output::list_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyspacesOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of keyspaces.</p>
    pub keyspaces: std::option::Option<std::vec::Vec<crate::model::KeyspaceSummary>>,
}
impl ListKeyspacesOutput {
    /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of keyspaces.</p>
    pub fn keyspaces(&self) -> std::option::Option<&[crate::model::KeyspaceSummary]> {
        self.keyspaces.as_deref()
    }
}
impl std::fmt::Debug for ListKeyspacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyspacesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("keyspaces", &self.keyspaces);
        formatter.finish()
    }
}
/// See [`ListKeyspacesOutput`](crate::output::ListKeyspacesOutput)
pub mod list_keyspaces_output {
    /// A builder for [`ListKeyspacesOutput`](crate::output::ListKeyspacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) keyspaces: std::option::Option<std::vec::Vec<crate::model::KeyspaceSummary>>,
    }
    impl Builder {
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `keyspaces`.
        ///
        /// To override the contents of this collection use [`set_keyspaces`](Self::set_keyspaces).
        ///
        /// <p>A list of keyspaces.</p>
        pub fn keyspaces(mut self, input: crate::model::KeyspaceSummary) -> Self {
            let mut v = self.keyspaces.unwrap_or_default();
            v.push(input);
            self.keyspaces = Some(v);
            self
        }
        /// <p>A list of keyspaces.</p>
        pub fn set_keyspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyspaceSummary>>,
        ) -> Self {
            self.keyspaces = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyspacesOutput`](crate::output::ListKeyspacesOutput)
        pub fn build(self) -> crate::output::ListKeyspacesOutput {
            crate::output::ListKeyspacesOutput {
                next_token: self.next_token,
                keyspaces: self.keyspaces,
            }
        }
    }
}
impl ListKeyspacesOutput {
    /// Creates a new builder-style object to manufacture [`ListKeyspacesOutput`](crate::output::ListKeyspacesOutput)
    pub fn builder() -> crate::output::list_keyspaces_output::Builder {
        crate::output::list_keyspaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableOutput {
    /// <p>The name of the keyspace that the specified table is stored in.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the specified table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the specified table.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The creation timestamp of the specified table.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the specified table.</p>
    pub status: std::option::Option<crate::model::TableStatus>,
    /// <p>The schema definition of the specified table.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaDefinition>,
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> </p>
    pub capacity_specification: std::option::Option<crate::model::CapacitySpecificationSummary>,
    /// <p>The encryption settings of the specified table.</p>
    pub encryption_specification: std::option::Option<crate::model::EncryptionSpecification>,
    /// <p>The point-in-time recovery status of the specified table.</p>
    pub point_in_time_recovery: std::option::Option<crate::model::PointInTimeRecoverySummary>,
    /// <p>The custom Time to Live settings of the specified table.</p>
    pub ttl: std::option::Option<crate::model::TimeToLive>,
    /// <p>The default Time to Live settings of the specified table.</p>
    pub default_time_to_live: std::option::Option<i32>,
    /// <p>The the description of the specified table.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl GetTableOutput {
    /// <p>The name of the keyspace that the specified table is stored in.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the specified table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the specified table.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The creation timestamp of the specified table.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The current status of the specified table.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TableStatus> {
        self.status.as_ref()
    }
    /// <p>The schema definition of the specified table.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaDefinition> {
        self.schema_definition.as_ref()
    }
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> </p>
    pub fn capacity_specification(
        &self,
    ) -> std::option::Option<&crate::model::CapacitySpecificationSummary> {
        self.capacity_specification.as_ref()
    }
    /// <p>The encryption settings of the specified table.</p>
    pub fn encryption_specification(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionSpecification> {
        self.encryption_specification.as_ref()
    }
    /// <p>The point-in-time recovery status of the specified table.</p>
    pub fn point_in_time_recovery(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecoverySummary> {
        self.point_in_time_recovery.as_ref()
    }
    /// <p>The custom Time to Live settings of the specified table.</p>
    pub fn ttl(&self) -> std::option::Option<&crate::model::TimeToLive> {
        self.ttl.as_ref()
    }
    /// <p>The default Time to Live settings of the specified table.</p>
    pub fn default_time_to_live(&self) -> std::option::Option<i32> {
        self.default_time_to_live
    }
    /// <p>The the description of the specified table.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for GetTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableOutput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("status", &self.status);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.field("capacity_specification", &self.capacity_specification);
        formatter.field("encryption_specification", &self.encryption_specification);
        formatter.field("point_in_time_recovery", &self.point_in_time_recovery);
        formatter.field("ttl", &self.ttl);
        formatter.field("default_time_to_live", &self.default_time_to_live);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`GetTableOutput`](crate::output::GetTableOutput)
pub mod get_table_output {
    /// A builder for [`GetTableOutput`](crate::output::GetTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::TableStatus>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaDefinition>,
        pub(crate) capacity_specification:
            std::option::Option<crate::model::CapacitySpecificationSummary>,
        pub(crate) encryption_specification:
            std::option::Option<crate::model::EncryptionSpecification>,
        pub(crate) point_in_time_recovery:
            std::option::Option<crate::model::PointInTimeRecoverySummary>,
        pub(crate) ttl: std::option::Option<crate::model::TimeToLive>,
        pub(crate) default_time_to_live: std::option::Option<i32>,
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>The name of the keyspace that the specified table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace that the specified table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the specified table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the specified table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specified table.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the specified table.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The creation timestamp of the specified table.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The creation timestamp of the specified table.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The current status of the specified table.</p>
        pub fn status(mut self, input: crate::model::TableStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the specified table.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::TableStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The schema definition of the specified table.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaDefinition) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>The schema definition of the specified table.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaDefinition>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> </p>
        pub fn capacity_specification(
            mut self,
            input: crate::model::CapacitySpecificationSummary,
        ) -> Self {
            self.capacity_specification = Some(input);
            self
        }
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> </p>
        pub fn set_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecificationSummary>,
        ) -> Self {
            self.capacity_specification = input;
            self
        }
        /// <p>The encryption settings of the specified table.</p>
        pub fn encryption_specification(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.encryption_specification = Some(input);
            self
        }
        /// <p>The encryption settings of the specified table.</p>
        pub fn set_encryption_specification(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.encryption_specification = input;
            self
        }
        /// <p>The point-in-time recovery status of the specified table.</p>
        pub fn point_in_time_recovery(
            mut self,
            input: crate::model::PointInTimeRecoverySummary,
        ) -> Self {
            self.point_in_time_recovery = Some(input);
            self
        }
        /// <p>The point-in-time recovery status of the specified table.</p>
        pub fn set_point_in_time_recovery(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoverySummary>,
        ) -> Self {
            self.point_in_time_recovery = input;
            self
        }
        /// <p>The custom Time to Live settings of the specified table.</p>
        pub fn ttl(mut self, input: crate::model::TimeToLive) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The custom Time to Live settings of the specified table.</p>
        pub fn set_ttl(mut self, input: std::option::Option<crate::model::TimeToLive>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>The default Time to Live settings of the specified table.</p>
        pub fn default_time_to_live(mut self, input: i32) -> Self {
            self.default_time_to_live = Some(input);
            self
        }
        /// <p>The default Time to Live settings of the specified table.</p>
        pub fn set_default_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.default_time_to_live = input;
            self
        }
        /// <p>The the description of the specified table.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>The the description of the specified table.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableOutput`](crate::output::GetTableOutput)
        pub fn build(self) -> crate::output::GetTableOutput {
            crate::output::GetTableOutput {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
                resource_arn: self.resource_arn,
                creation_timestamp: self.creation_timestamp,
                status: self.status,
                schema_definition: self.schema_definition,
                capacity_specification: self.capacity_specification,
                encryption_specification: self.encryption_specification,
                point_in_time_recovery: self.point_in_time_recovery,
                ttl: self.ttl,
                default_time_to_live: self.default_time_to_live,
                comment: self.comment,
            }
        }
    }
}
impl GetTableOutput {
    /// Creates a new builder-style object to manufacture [`GetTableOutput`](crate::output::GetTableOutput)
    pub fn builder() -> crate::output::get_table_output::Builder {
        crate::output::get_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyspaceOutput {
    /// <p>The name of the keyspace.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the keyspace.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl GetKeyspaceOutput {
    /// <p>The name of the keyspace.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The ARN of the keyspace.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for GetKeyspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyspaceOutput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`GetKeyspaceOutput`](crate::output::GetKeyspaceOutput)
pub mod get_keyspace_output {
    /// A builder for [`GetKeyspaceOutput`](crate::output::GetKeyspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The ARN of the keyspace.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the keyspace.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyspaceOutput`](crate::output::GetKeyspaceOutput)
        pub fn build(self) -> crate::output::GetKeyspaceOutput {
            crate::output::GetKeyspaceOutput {
                keyspace_name: self.keyspace_name,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl GetKeyspaceOutput {
    /// Creates a new builder-style object to manufacture [`GetKeyspaceOutput`](crate::output::GetKeyspaceOutput)
    pub fn builder() -> crate::output::get_keyspace_output::Builder {
        crate::output::get_keyspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableOutput {}
impl std::fmt::Debug for DeleteTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableOutput");
        formatter.finish()
    }
}
/// See [`DeleteTableOutput`](crate::output::DeleteTableOutput)
pub mod delete_table_output {
    /// A builder for [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTableOutput`](crate::output::DeleteTableOutput)
        pub fn build(self) -> crate::output::DeleteTableOutput {
            crate::output::DeleteTableOutput {}
        }
    }
}
impl DeleteTableOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    pub fn builder() -> crate::output::delete_table_output::Builder {
        crate::output::delete_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeyspaceOutput {}
impl std::fmt::Debug for DeleteKeyspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeyspaceOutput");
        formatter.finish()
    }
}
/// See [`DeleteKeyspaceOutput`](crate::output::DeleteKeyspaceOutput)
pub mod delete_keyspace_output {
    /// A builder for [`DeleteKeyspaceOutput`](crate::output::DeleteKeyspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteKeyspaceOutput`](crate::output::DeleteKeyspaceOutput)
        pub fn build(self) -> crate::output::DeleteKeyspaceOutput {
            crate::output::DeleteKeyspaceOutput {}
        }
    }
}
impl DeleteKeyspaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteKeyspaceOutput`](crate::output::DeleteKeyspaceOutput)
    pub fn builder() -> crate::output::delete_keyspace_output::Builder {
        crate::output::delete_keyspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTableOutput {
    /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl CreateTableOutput {
    /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTableOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`CreateTableOutput`](crate::output::CreateTableOutput)
pub mod create_table_output {
    /// A builder for [`CreateTableOutput`](crate::output::CreateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTableOutput`](crate::output::CreateTableOutput)
        pub fn build(self) -> crate::output::CreateTableOutput {
            crate::output::CreateTableOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl CreateTableOutput {
    /// Creates a new builder-style object to manufacture [`CreateTableOutput`](crate::output::CreateTableOutput)
    pub fn builder() -> crate::output::create_table_output::Builder {
        crate::output::create_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeyspaceOutput {
    /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl CreateKeyspaceOutput {
    /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateKeyspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeyspaceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`CreateKeyspaceOutput`](crate::output::CreateKeyspaceOutput)
pub mod create_keyspace_output {
    /// A builder for [`CreateKeyspaceOutput`](crate::output::CreateKeyspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyspaceOutput`](crate::output::CreateKeyspaceOutput)
        pub fn build(self) -> crate::output::CreateKeyspaceOutput {
            crate::output::CreateKeyspaceOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl CreateKeyspaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateKeyspaceOutput`](crate::output::CreateKeyspaceOutput)
    pub fn builder() -> crate::output::create_keyspace_output::Builder {
        crate::output::create_keyspace_output::Builder::default()
    }
}
