// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Enable custom Time to Live (TTL) settings for rows and columns without setting a TTL default for the specified table.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_enabling">Enabling TTL on tables</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeToLive {
    /// <p>Shows how to enable custom Time to Live (TTL) settings for the specified table.</p>
    pub status: std::option::Option<crate::model::TimeToLiveStatus>,
}
impl TimeToLive {
    /// <p>Shows how to enable custom Time to Live (TTL) settings for the specified table.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TimeToLiveStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for TimeToLive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeToLive");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`TimeToLive`](crate::model::TimeToLive)
pub mod time_to_live {
    /// A builder for [`TimeToLive`](crate::model::TimeToLive)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::TimeToLiveStatus>,
    }
    impl Builder {
        /// <p>Shows how to enable custom Time to Live (TTL) settings for the specified table.</p>
        pub fn status(mut self, input: crate::model::TimeToLiveStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Shows how to enable custom Time to Live (TTL) settings for the specified table.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeToLive`](crate::model::TimeToLive)
        pub fn build(self) -> crate::model::TimeToLive {
            crate::model::TimeToLive {
                status: self.status,
            }
        }
    }
}
impl TimeToLive {
    /// Creates a new builder-style object to manufacture [`TimeToLive`](crate::model::TimeToLive)
    pub fn builder() -> crate::model::time_to_live::Builder {
        crate::model::time_to_live::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeToLiveStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeToLiveStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => TimeToLiveStatus::Enabled,
            other => TimeToLiveStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeToLiveStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeToLiveStatus::from(s))
    }
}
impl TimeToLiveStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeToLiveStatus::Enabled => "ENABLED",
            TimeToLiveStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED"]
    }
}
impl AsRef<str> for TimeToLiveStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Point-in-time recovery (PITR) helps protect your Amazon Keyspaces tables from accidental write or delete operations by providing you continuous backups of your table data.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRecovery {
    /// <p>The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    pub status: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
}
impl PointInTimeRecovery {
    /// <p>The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    pub fn status(&self) -> std::option::Option<&crate::model::PointInTimeRecoveryStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PointInTimeRecovery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRecovery");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PointInTimeRecovery`](crate::model::PointInTimeRecovery)
pub mod point_in_time_recovery {
    /// A builder for [`PointInTimeRecovery`](crate::model::PointInTimeRecovery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
    }
    impl Builder {
        /// <p>The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        pub fn status(mut self, input: crate::model::PointInTimeRecoveryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRecovery`](crate::model::PointInTimeRecovery)
        pub fn build(self) -> crate::model::PointInTimeRecovery {
            crate::model::PointInTimeRecovery {
                status: self.status,
            }
        }
    }
}
impl PointInTimeRecovery {
    /// Creates a new builder-style object to manufacture [`PointInTimeRecovery`](crate::model::PointInTimeRecovery)
    pub fn builder() -> crate::model::point_in_time_recovery::Builder {
        crate::model::point_in_time_recovery::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PointInTimeRecoveryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PointInTimeRecoveryStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => PointInTimeRecoveryStatus::Disabled,
            "ENABLED" => PointInTimeRecoveryStatus::Enabled,
            other => PointInTimeRecoveryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PointInTimeRecoveryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PointInTimeRecoveryStatus::from(s))
    }
}
impl PointInTimeRecoveryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PointInTimeRecoveryStatus::Disabled => "DISABLED",
            PointInTimeRecoveryStatus::Enabled => "ENABLED",
            PointInTimeRecoveryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for PointInTimeRecoveryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Amazon Keyspaces encrypts and decrypts the table data at rest transparently and integrates with Key Management Service for storing and managing the encryption key. You can choose one of the following KMS keys (KMS keys):</p>
/// <p>• Amazon Web Services owned key - This is the default encryption type. The key is owned by Amazon Keyspaces (no additional charge). </p>
/// <p>• Customer managed key - This key is stored in your account and is created, owned, and managed by you. You have full control over the customer managed key (KMS charges apply).</p>
/// <p>For more information about encryption at rest in Amazon Keyspaces, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
/// <p>For more information about KMS, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">KMS management service concepts</a> in the <i>Key Management Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionSpecification {
    /// <p>The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub r#type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key, for example <code>kms_key_identifier:ARN</code>.</p>
    pub kms_key_identifier: std::option::Option<std::string::String>,
}
impl EncryptionSpecification {
    /// <p>The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.r#type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key, for example <code>kms_key_identifier:ARN</code>.</p>
    pub fn kms_key_identifier(&self) -> std::option::Option<&str> {
        self.kms_key_identifier.as_deref()
    }
}
impl std::fmt::Debug for EncryptionSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionSpecification");
        formatter.field("r#type", &self.r#type);
        formatter.field("kms_key_identifier", &self.kms_key_identifier);
        formatter.finish()
    }
}
/// See [`EncryptionSpecification`](crate::model::EncryptionSpecification)
pub mod encryption_specification {
    /// A builder for [`EncryptionSpecification`](crate::model::EncryptionSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_key_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key, for example <code>kms_key_identifier:ARN</code>.</p>
        pub fn kms_key_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key, for example <code>kms_key_identifier:ARN</code>.</p>
        pub fn set_kms_key_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_key_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionSpecification`](crate::model::EncryptionSpecification)
        pub fn build(self) -> crate::model::EncryptionSpecification {
            crate::model::EncryptionSpecification {
                r#type: self.r#type,
                kms_key_identifier: self.kms_key_identifier,
            }
        }
    }
}
impl EncryptionSpecification {
    /// Creates a new builder-style object to manufacture [`EncryptionSpecification`](crate::model::EncryptionSpecification)
    pub fn builder() -> crate::model::encryption_specification::Builder {
        crate::model::encryption_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    AwsOwnedKmsKey,
    #[allow(missing_docs)] // documentation missing in model
    CustomerManagedKmsKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OWNED_KMS_KEY" => EncryptionType::AwsOwnedKmsKey,
            "CUSTOMER_MANAGED_KMS_KEY" => EncryptionType::CustomerManagedKmsKey,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::AwsOwnedKmsKey => "AWS_OWNED_KMS_KEY",
            EncryptionType::CustomerManagedKmsKey => "CUSTOMER_MANAGED_KMS_KEY",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OWNED_KMS_KEY", "CUSTOMER_MANAGED_KMS_KEY"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Amazon Keyspaces has two read/write capacity modes for processing reads and writes on your tables: </p>
/// <p>• On-demand (default)</p>
/// <p>• Provisioned</p>
/// <p> The read/write capacity mode that you choose controls how you are charged for read and write throughput and how table throughput capacity is managed.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacitySpecification {
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
    pub read_capacity_units: std::option::Option<i64>,
    /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
    pub write_capacity_units: std::option::Option<i64>,
}
impl CapacitySpecification {
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<i64> {
        self.read_capacity_units
    }
    /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<i64> {
        self.write_capacity_units
    }
}
impl std::fmt::Debug for CapacitySpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacitySpecification");
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.finish()
    }
}
/// See [`CapacitySpecification`](crate::model::CapacitySpecification)
pub mod capacity_specification {
    /// A builder for [`CapacitySpecification`](crate::model::CapacitySpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) read_capacity_units: std::option::Option<i64>,
        pub(crate) write_capacity_units: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
        pub fn read_capacity_units(mut self, input: i64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
        pub fn write_capacity_units(mut self, input: i64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacitySpecification`](crate::model::CapacitySpecification)
        pub fn build(self) -> crate::model::CapacitySpecification {
            crate::model::CapacitySpecification {
                throughput_mode: self.throughput_mode,
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
            }
        }
    }
}
impl CapacitySpecification {
    /// Creates a new builder-style object to manufacture [`CapacitySpecification`](crate::model::CapacitySpecification)
    pub fn builder() -> crate::model::capacity_specification::Builder {
        crate::model::capacity_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThroughputMode {
    #[allow(missing_docs)] // documentation missing in model
    PayPerRequest,
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThroughputMode {
    fn from(s: &str) -> Self {
        match s {
            "PAY_PER_REQUEST" => ThroughputMode::PayPerRequest,
            "PROVISIONED" => ThroughputMode::Provisioned,
            other => ThroughputMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThroughputMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThroughputMode::from(s))
    }
}
impl ThroughputMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThroughputMode::PayPerRequest => "PAY_PER_REQUEST",
            ThroughputMode::Provisioned => "PROVISIONED",
            ThroughputMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PAY_PER_REQUEST", "PROVISIONED"]
    }
}
impl AsRef<str> for ThroughputMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The names and data types of regular columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnDefinition {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the column. For a list of available data types, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl ColumnDefinition {
    /// <p>The name of the column.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the column. For a list of available data types, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ColumnDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnDefinition");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ColumnDefinition`](crate::model::ColumnDefinition)
pub mod column_definition {
    /// A builder for [`ColumnDefinition`](crate::model::ColumnDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the column. For a list of available data types, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The data type of the column. For a list of available data types, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnDefinition`](crate::model::ColumnDefinition)
        pub fn build(self) -> crate::model::ColumnDefinition {
            crate::model::ColumnDefinition {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl ColumnDefinition {
    /// Creates a new builder-style object to manufacture [`ColumnDefinition`](crate::model::ColumnDefinition)
    pub fn builder() -> crate::model::column_definition::Builder {
        crate::model::column_definition::Builder::default()
    }
}

/// <p>Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single Amazon Keyspaces resource.</p>
/// <p>Amazon Web Services-assigned tag names and values are automatically assigned the <code>aws:</code> prefix, which the user cannot assign. Amazon Web Services-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix <code>user:</code> in the Cost Allocation Report. You cannot backdate the application of a tag.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Returns the name of the specified table, the keyspace it is stored in, and the unique identifier in the format of an Amazon Resource Name (ARN).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableSummary {
    /// <p>The name of the keyspace that the table is stored in.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl TableSummary {
    /// <p>The name of the keyspace that the table is stored in.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for TableSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableSummary");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`TableSummary`](crate::model::TableSummary)
pub mod table_summary {
    /// A builder for [`TableSummary`](crate::model::TableSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TableSummary`](crate::model::TableSummary)
        pub fn build(self) -> crate::model::TableSummary {
            crate::model::TableSummary {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl TableSummary {
    /// Creates a new builder-style object to manufacture [`TableSummary`](crate::model::TableSummary)
    pub fn builder() -> crate::model::table_summary::Builder {
        crate::model::table_summary::Builder::default()
    }
}

/// <p>Represents the properties of a keyspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyspaceSummary {
    /// <p>The name of the keyspace.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl KeyspaceSummary {
    /// <p>The name of the keyspace.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for KeyspaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyspaceSummary");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`KeyspaceSummary`](crate::model::KeyspaceSummary)
pub mod keyspace_summary {
    /// A builder for [`KeyspaceSummary`](crate::model::KeyspaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyspaceSummary`](crate::model::KeyspaceSummary)
        pub fn build(self) -> crate::model::KeyspaceSummary {
            crate::model::KeyspaceSummary {
                keyspace_name: self.keyspace_name,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl KeyspaceSummary {
    /// Creates a new builder-style object to manufacture [`KeyspaceSummary`](crate::model::KeyspaceSummary)
    pub fn builder() -> crate::model::keyspace_summary::Builder {
        crate::model::keyspace_summary::Builder::default()
    }
}

/// <p>An optional comment that describes the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Comment {
    /// <p>An optional description of the table.</p>
    pub message: std::option::Option<std::string::String>,
}
impl Comment {
    /// <p>An optional description of the table.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for Comment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Comment");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`Comment`](crate::model::Comment)
pub mod comment {
    /// A builder for [`Comment`](crate::model::Comment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional description of the table.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An optional description of the table.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Comment`](crate::model::Comment)
        pub fn build(self) -> crate::model::Comment {
            crate::model::Comment {
                message: self.message,
            }
        }
    }
}
impl Comment {
    /// Creates a new builder-style object to manufacture [`Comment`](crate::model::Comment)
    pub fn builder() -> crate::model::comment::Builder {
        crate::model::comment::Builder::default()
    }
}

/// <p>The point-in-time recovery status of the specified table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRecoverySummary {
    /// <p>Shows if point-in-time recovery is enabled or disabled for the specified table.</p>
    pub status: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
    /// <p>Specifies the earliest possible restore point of the table in ISO 8601 format.</p>
    pub earliest_restorable_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl PointInTimeRecoverySummary {
    /// <p>Shows if point-in-time recovery is enabled or disabled for the specified table.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PointInTimeRecoveryStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies the earliest possible restore point of the table in ISO 8601 format.</p>
    pub fn earliest_restorable_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earliest_restorable_timestamp.as_ref()
    }
}
impl std::fmt::Debug for PointInTimeRecoverySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRecoverySummary");
        formatter.field("status", &self.status);
        formatter.field(
            "earliest_restorable_timestamp",
            &self.earliest_restorable_timestamp,
        );
        formatter.finish()
    }
}
/// See [`PointInTimeRecoverySummary`](crate::model::PointInTimeRecoverySummary)
pub mod point_in_time_recovery_summary {
    /// A builder for [`PointInTimeRecoverySummary`](crate::model::PointInTimeRecoverySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
        pub(crate) earliest_restorable_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Shows if point-in-time recovery is enabled or disabled for the specified table.</p>
        pub fn status(mut self, input: crate::model::PointInTimeRecoveryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Shows if point-in-time recovery is enabled or disabled for the specified table.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the earliest possible restore point of the table in ISO 8601 format.</p>
        pub fn earliest_restorable_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earliest_restorable_timestamp = Some(input);
            self
        }
        /// <p>Specifies the earliest possible restore point of the table in ISO 8601 format.</p>
        pub fn set_earliest_restorable_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earliest_restorable_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRecoverySummary`](crate::model::PointInTimeRecoverySummary)
        pub fn build(self) -> crate::model::PointInTimeRecoverySummary {
            crate::model::PointInTimeRecoverySummary {
                status: self.status,
                earliest_restorable_timestamp: self.earliest_restorable_timestamp,
            }
        }
    }
}
impl PointInTimeRecoverySummary {
    /// Creates a new builder-style object to manufacture [`PointInTimeRecoverySummary`](crate::model::PointInTimeRecoverySummary)
    pub fn builder() -> crate::model::point_in_time_recovery_summary::Builder {
        crate::model::point_in_time_recovery_summary::Builder::default()
    }
}

/// <p>The read/write throughput capacity mode for a table. The options are:</p>
/// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
/// <p>• <code>throughputMode:PROVISIONED</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacitySpecificationSummary {
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input. </p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
    pub read_capacity_units: std::option::Option<i64>,
    /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
    pub write_capacity_units: std::option::Option<i64>,
    /// <p>The timestamp of the last operation that changed the provisioned throughput capacity of a table.</p>
    pub last_update_to_pay_per_request_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl CapacitySpecificationSummary {
    /// <p>The read/write throughput capacity mode for a table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input. </p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<i64> {
        self.read_capacity_units
    }
    /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<i64> {
        self.write_capacity_units
    }
    /// <p>The timestamp of the last operation that changed the provisioned throughput capacity of a table.</p>
    pub fn last_update_to_pay_per_request_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_to_pay_per_request_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CapacitySpecificationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacitySpecificationSummary");
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.field(
            "last_update_to_pay_per_request_timestamp",
            &self.last_update_to_pay_per_request_timestamp,
        );
        formatter.finish()
    }
}
/// See [`CapacitySpecificationSummary`](crate::model::CapacitySpecificationSummary)
pub mod capacity_specification_summary {
    /// A builder for [`CapacitySpecificationSummary`](crate::model::CapacitySpecificationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) read_capacity_units: std::option::Option<i64>,
        pub(crate) write_capacity_units: std::option::Option<i64>,
        pub(crate) last_update_to_pay_per_request_timestamp:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input. </p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>The read/write throughput capacity mode for a table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input. </p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
        pub fn read_capacity_units(mut self, input: i64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
        pub fn write_capacity_units(mut self, input: i64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// <p>The timestamp of the last operation that changed the provisioned throughput capacity of a table.</p>
        pub fn last_update_to_pay_per_request_timestamp(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_update_to_pay_per_request_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the last operation that changed the provisioned throughput capacity of a table.</p>
        pub fn set_last_update_to_pay_per_request_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_to_pay_per_request_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacitySpecificationSummary`](crate::model::CapacitySpecificationSummary)
        pub fn build(self) -> crate::model::CapacitySpecificationSummary {
            crate::model::CapacitySpecificationSummary {
                throughput_mode: self.throughput_mode,
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
                last_update_to_pay_per_request_timestamp: self
                    .last_update_to_pay_per_request_timestamp,
            }
        }
    }
}
impl CapacitySpecificationSummary {
    /// Creates a new builder-style object to manufacture [`CapacitySpecificationSummary`](crate::model::CapacitySpecificationSummary)
    pub fn builder() -> crate::model::capacity_specification_summary::Builder {
        crate::model::capacity_specification_summary::Builder::default()
    }
}

/// <p>Describes the schema of the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaDefinition {
    /// <p>The regular columns of the table.</p>
    pub all_columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
    /// <p>The columns that are part of the partition key of the table .</p>
    pub partition_keys: std::option::Option<std::vec::Vec<crate::model::PartitionKey>>,
    /// <p>The columns that are part of the clustering key of the table.</p>
    pub clustering_keys: std::option::Option<std::vec::Vec<crate::model::ClusteringKey>>,
    /// <p>The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all rows in the same partition.</p>
    pub static_columns: std::option::Option<std::vec::Vec<crate::model::StaticColumn>>,
}
impl SchemaDefinition {
    /// <p>The regular columns of the table.</p>
    pub fn all_columns(&self) -> std::option::Option<&[crate::model::ColumnDefinition]> {
        self.all_columns.as_deref()
    }
    /// <p>The columns that are part of the partition key of the table .</p>
    pub fn partition_keys(&self) -> std::option::Option<&[crate::model::PartitionKey]> {
        self.partition_keys.as_deref()
    }
    /// <p>The columns that are part of the clustering key of the table.</p>
    pub fn clustering_keys(&self) -> std::option::Option<&[crate::model::ClusteringKey]> {
        self.clustering_keys.as_deref()
    }
    /// <p>The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all rows in the same partition.</p>
    pub fn static_columns(&self) -> std::option::Option<&[crate::model::StaticColumn]> {
        self.static_columns.as_deref()
    }
}
impl std::fmt::Debug for SchemaDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaDefinition");
        formatter.field("all_columns", &self.all_columns);
        formatter.field("partition_keys", &self.partition_keys);
        formatter.field("clustering_keys", &self.clustering_keys);
        formatter.field("static_columns", &self.static_columns);
        formatter.finish()
    }
}
/// See [`SchemaDefinition`](crate::model::SchemaDefinition)
pub mod schema_definition {
    /// A builder for [`SchemaDefinition`](crate::model::SchemaDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) all_columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        pub(crate) partition_keys: std::option::Option<std::vec::Vec<crate::model::PartitionKey>>,
        pub(crate) clustering_keys: std::option::Option<std::vec::Vec<crate::model::ClusteringKey>>,
        pub(crate) static_columns: std::option::Option<std::vec::Vec<crate::model::StaticColumn>>,
    }
    impl Builder {
        /// Appends an item to `all_columns`.
        ///
        /// To override the contents of this collection use [`set_all_columns`](Self::set_all_columns).
        ///
        /// <p>The regular columns of the table.</p>
        pub fn all_columns(mut self, input: crate::model::ColumnDefinition) -> Self {
            let mut v = self.all_columns.unwrap_or_default();
            v.push(input);
            self.all_columns = Some(v);
            self
        }
        /// <p>The regular columns of the table.</p>
        pub fn set_all_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        ) -> Self {
            self.all_columns = input;
            self
        }
        /// Appends an item to `partition_keys`.
        ///
        /// To override the contents of this collection use [`set_partition_keys`](Self::set_partition_keys).
        ///
        /// <p>The columns that are part of the partition key of the table .</p>
        pub fn partition_keys(mut self, input: crate::model::PartitionKey) -> Self {
            let mut v = self.partition_keys.unwrap_or_default();
            v.push(input);
            self.partition_keys = Some(v);
            self
        }
        /// <p>The columns that are part of the partition key of the table .</p>
        pub fn set_partition_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionKey>>,
        ) -> Self {
            self.partition_keys = input;
            self
        }
        /// Appends an item to `clustering_keys`.
        ///
        /// To override the contents of this collection use [`set_clustering_keys`](Self::set_clustering_keys).
        ///
        /// <p>The columns that are part of the clustering key of the table.</p>
        pub fn clustering_keys(mut self, input: crate::model::ClusteringKey) -> Self {
            let mut v = self.clustering_keys.unwrap_or_default();
            v.push(input);
            self.clustering_keys = Some(v);
            self
        }
        /// <p>The columns that are part of the clustering key of the table.</p>
        pub fn set_clustering_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusteringKey>>,
        ) -> Self {
            self.clustering_keys = input;
            self
        }
        /// Appends an item to `static_columns`.
        ///
        /// To override the contents of this collection use [`set_static_columns`](Self::set_static_columns).
        ///
        /// <p>The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all rows in the same partition.</p>
        pub fn static_columns(mut self, input: crate::model::StaticColumn) -> Self {
            let mut v = self.static_columns.unwrap_or_default();
            v.push(input);
            self.static_columns = Some(v);
            self
        }
        /// <p>The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all rows in the same partition.</p>
        pub fn set_static_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StaticColumn>>,
        ) -> Self {
            self.static_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaDefinition`](crate::model::SchemaDefinition)
        pub fn build(self) -> crate::model::SchemaDefinition {
            crate::model::SchemaDefinition {
                all_columns: self.all_columns,
                partition_keys: self.partition_keys,
                clustering_keys: self.clustering_keys,
                static_columns: self.static_columns,
            }
        }
    }
}
impl SchemaDefinition {
    /// Creates a new builder-style object to manufacture [`SchemaDefinition`](crate::model::SchemaDefinition)
    pub fn builder() -> crate::model::schema_definition::Builder {
        crate::model::schema_definition::Builder::default()
    }
}

/// <p>The static columns of the table. Static columns store values that are shared by all rows in the same partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaticColumn {
    /// <p>The name of the static column.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StaticColumn {
    /// <p>The name of the static column.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StaticColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaticColumn");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`StaticColumn`](crate::model::StaticColumn)
pub mod static_column {
    /// A builder for [`StaticColumn`](crate::model::StaticColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the static column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the static column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StaticColumn`](crate::model::StaticColumn)
        pub fn build(self) -> crate::model::StaticColumn {
            crate::model::StaticColumn { name: self.name }
        }
    }
}
impl StaticColumn {
    /// Creates a new builder-style object to manufacture [`StaticColumn`](crate::model::StaticColumn)
    pub fn builder() -> crate::model::static_column::Builder {
        crate::model::static_column::Builder::default()
    }
}

/// <p>The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusteringKey {
    /// <p>The name(s) of the clustering column(s).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
    pub order_by: std::option::Option<crate::model::SortOrder>,
}
impl ClusteringKey {
    /// <p>The name(s) of the clustering column(s).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for ClusteringKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusteringKey");
        formatter.field("name", &self.name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`ClusteringKey`](crate::model::ClusteringKey)
pub mod clustering_key {
    /// A builder for [`ClusteringKey`](crate::model::ClusteringKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) order_by: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The name(s) of the clustering column(s).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name(s) of the clustering column(s).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        pub fn order_by(mut self, input: crate::model::SortOrder) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusteringKey`](crate::model::ClusteringKey)
        pub fn build(self) -> crate::model::ClusteringKey {
            crate::model::ClusteringKey {
                name: self.name,
                order_by: self.order_by,
            }
        }
    }
}
impl ClusteringKey {
    /// Creates a new builder-style object to manufacture [`ClusteringKey`](crate::model::ClusteringKey)
    pub fn builder() -> crate::model::clustering_key::Builder {
        crate::model::clustering_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortOrder::Asc,
            "DESC" => SortOrder::Desc,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Asc => "ASC",
            SortOrder::Desc => "DESC",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The partition key portion of the primary key is required and determines how Amazon Keyspaces stores the data. The partition key can be a single column, or it can be a compound value composed of two or more columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartitionKey {
    /// <p>The name(s) of the partition key column(s).</p>
    pub name: std::option::Option<std::string::String>,
}
impl PartitionKey {
    /// <p>The name(s) of the partition key column(s).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for PartitionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartitionKey");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PartitionKey`](crate::model::PartitionKey)
pub mod partition_key {
    /// A builder for [`PartitionKey`](crate::model::PartitionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name(s) of the partition key column(s).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name(s) of the partition key column(s).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PartitionKey`](crate::model::PartitionKey)
        pub fn build(self) -> crate::model::PartitionKey {
            crate::model::PartitionKey { name: self.name }
        }
    }
}
impl PartitionKey {
    /// Creates a new builder-style object to manufacture [`PartitionKey`](crate::model::PartitionKey)
    pub fn builder() -> crate::model::partition_key::Builder {
        crate::model::partition_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TableStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InaccessibleEncryptionCredentials,
    #[allow(missing_docs)] // documentation missing in model
    Restoring,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TableStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => TableStatus::Active,
            "CREATING" => TableStatus::Creating,
            "DELETED" => TableStatus::Deleted,
            "DELETING" => TableStatus::Deleting,
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS" => TableStatus::InaccessibleEncryptionCredentials,
            "RESTORING" => TableStatus::Restoring,
            "UPDATING" => TableStatus::Updating,
            other => TableStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TableStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TableStatus::from(s))
    }
}
impl TableStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TableStatus::Active => "ACTIVE",
            TableStatus::Creating => "CREATING",
            TableStatus::Deleted => "DELETED",
            TableStatus::Deleting => "DELETING",
            TableStatus::InaccessibleEncryptionCredentials => "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
            TableStatus::Restoring => "RESTORING",
            TableStatus::Updating => "UPDATING",
            TableStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "DELETED",
            "DELETING",
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
            "RESTORING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for TableStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
