// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateKeyspaceInput`](crate::input::CreateKeyspaceInput)
pub mod create_keyspace_input {
    /// A builder for [`CreateKeyspaceInput`](crate::input::CreateKeyspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the keyspace to be created.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace to be created.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyspaceInput`](crate::input::CreateKeyspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeyspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeyspaceInput {
                keyspace_name: self.keyspace_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeyspaceInputOperationOutputAlias = crate::operation::CreateKeyspace;
#[doc(hidden)]
pub type CreateKeyspaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKeyspaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeyspace`](crate::operation::CreateKeyspace)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeyspace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateKeyspaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateKeyspaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.CreateKeyspace",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_keyspace(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeyspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeyspace",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateKeyspaceInput`](crate::input::CreateKeyspaceInput)
    pub fn builder() -> crate::input::create_keyspace_input::Builder {
        crate::input::create_keyspace_input::Builder::default()
    }
}

/// See [`CreateTableInput`](crate::input::CreateTableInput)
pub mod create_table_input {
    /// A builder for [`CreateTableInput`](crate::input::CreateTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaDefinition>,
        pub(crate) comment: std::option::Option<crate::model::Comment>,
        pub(crate) capacity_specification: std::option::Option<crate::model::CapacitySpecification>,
        pub(crate) encryption_specification:
            std::option::Option<crate::model::EncryptionSpecification>,
        pub(crate) point_in_time_recovery: std::option::Option<crate::model::PointInTimeRecovery>,
        pub(crate) ttl: std::option::Option<crate::model::TimeToLive>,
        pub(crate) default_time_to_live: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the keyspace that the table is going to be created in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace that the table is going to be created in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
        /// <p>For each column to be created:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        /// <p>The primary key of the table consists of the following columns:</p>
        /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
        /// <p>• <code>name</code> - The name of each partition key column.</p>
        /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
        /// <p>• <code>name</code> - The name of the clustering column. </p>
        /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaDefinition) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
        /// <p>For each column to be created:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        /// <p>The primary key of the table consists of the following columns:</p>
        /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
        /// <p>• <code>name</code> - The name of each partition key column.</p>
        /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
        /// <p>• <code>name</code> - The name of the clustering column. </p>
        /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaDefinition>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// <p>This parameter allows to enter a description of the table.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>This parameter allows to enter a description of the table.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.capacity_specification = Some(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.capacity_specification = input;
            self
        }
        /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.encryption_specification = Some(input);
            self
        }
        /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.encryption_specification = input;
            self
        }
        /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery(mut self, input: crate::model::PointInTimeRecovery) -> Self {
            self.point_in_time_recovery = Some(input);
            self
        }
        /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.point_in_time_recovery = input;
            self
        }
        /// <p>Enables Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn ttl(mut self, input: crate::model::TimeToLive) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>Enables Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_ttl(mut self, input: std::option::Option<crate::model::TimeToLive>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn default_time_to_live(mut self, input: i32) -> Self {
            self.default_time_to_live = Some(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_default_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.default_time_to_live = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pair tags to be attached to the resource. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the resource. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTableInput`](crate::input::CreateTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTableInput {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
                schema_definition: self.schema_definition,
                comment: self.comment,
                capacity_specification: self.capacity_specification,
                encryption_specification: self.encryption_specification,
                point_in_time_recovery: self.point_in_time_recovery,
                ttl: self.ttl,
                default_time_to_live: self.default_time_to_live,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTableInputOperationOutputAlias = crate::operation::CreateTable;
#[doc(hidden)]
pub type CreateTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTableInput {
    /// Consumes the builder and constructs an Operation<[`CreateTable`](crate::operation::CreateTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.CreateTable",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTable",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTableInput`](crate::input::CreateTableInput)
    pub fn builder() -> crate::input::create_table_input::Builder {
        crate::input::create_table_input::Builder::default()
    }
}

/// See [`DeleteKeyspaceInput`](crate::input::DeleteKeyspaceInput)
pub mod delete_keyspace_input {
    /// A builder for [`DeleteKeyspaceInput`](crate::input::DeleteKeyspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace to be deleted.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace to be deleted.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeyspaceInput`](crate::input::DeleteKeyspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKeyspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKeyspaceInput {
                keyspace_name: self.keyspace_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKeyspaceInputOperationOutputAlias = crate::operation::DeleteKeyspace;
#[doc(hidden)]
pub type DeleteKeyspaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKeyspaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKeyspace`](crate::operation::DeleteKeyspace)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKeyspace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteKeyspaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteKeyspaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.DeleteKeyspace",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_keyspace(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKeyspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKeyspace",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteKeyspaceInput`](crate::input::DeleteKeyspaceInput)
    pub fn builder() -> crate::input::delete_keyspace_input::Builder {
        crate::input::delete_keyspace_input::Builder::default()
    }
}

/// See [`DeleteTableInput`](crate::input::DeleteTableInput)
pub mod delete_table_input {
    /// A builder for [`DeleteTableInput`](crate::input::DeleteTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace of the to be deleted table.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace of the to be deleted table.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the table to be deleted.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to be deleted.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTableInput`](crate::input::DeleteTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTableInput {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTableInputOperationOutputAlias = crate::operation::DeleteTable;
#[doc(hidden)]
pub type DeleteTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTableInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTable`](crate::operation::DeleteTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.DeleteTable",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTable",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTableInput`](crate::input::DeleteTableInput)
    pub fn builder() -> crate::input::delete_table_input::Builder {
        crate::input::delete_table_input::Builder::default()
    }
}

/// See [`GetKeyspaceInput`](crate::input::GetKeyspaceInput)
pub mod get_keyspace_input {
    /// A builder for [`GetKeyspaceInput`](crate::input::GetKeyspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyspaceInput`](crate::input::GetKeyspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKeyspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKeyspaceInput {
                keyspace_name: self.keyspace_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetKeyspaceInputOperationOutputAlias = crate::operation::GetKeyspace;
#[doc(hidden)]
pub type GetKeyspaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKeyspaceInput {
    /// Consumes the builder and constructs an Operation<[`GetKeyspace`](crate::operation::GetKeyspace)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKeyspace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetKeyspaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetKeyspaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.GetKeyspace",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_keyspace(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKeyspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKeyspace",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetKeyspaceInput`](crate::input::GetKeyspaceInput)
    pub fn builder() -> crate::input::get_keyspace_input::Builder {
        crate::input::get_keyspace_input::Builder::default()
    }
}

/// See [`GetTableInput`](crate::input::GetTableInput)
pub mod get_table_input {
    /// A builder for [`GetTableInput`](crate::input::GetTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableInput`](crate::input::GetTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTableInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTableInput {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTableInputOperationOutputAlias = crate::operation::GetTable;
#[doc(hidden)]
pub type GetTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTableInput {
    /// Consumes the builder and constructs an Operation<[`GetTable`](crate::operation::GetTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.GetTable",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTable::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTable",
                    "keyspaces",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTableInput`](crate::input::GetTableInput)
    pub fn builder() -> crate::input::get_table_input::Builder {
        crate::input::get_table_input::Builder::default()
    }
}

/// See [`ListKeyspacesInput`](crate::input::ListKeyspacesInput)
pub mod list_keyspaces_input {
    /// A builder for [`ListKeyspacesInput`](crate::input::ListKeyspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyspacesInput`](crate::input::ListKeyspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListKeyspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListKeyspacesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListKeyspacesInputOperationOutputAlias = crate::operation::ListKeyspaces;
#[doc(hidden)]
pub type ListKeyspacesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListKeyspacesInput {
    /// Consumes the builder and constructs an Operation<[`ListKeyspaces`](crate::operation::ListKeyspaces)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListKeyspaces,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListKeyspacesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListKeyspacesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.ListKeyspaces",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_keyspaces(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListKeyspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListKeyspaces",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListKeyspacesInput`](crate::input::ListKeyspacesInput)
    pub fn builder() -> crate::input::list_keyspaces_input::Builder {
        crate::input::list_keyspaces_input::Builder::default()
    }
}

/// See [`ListTablesInput`](crate::input::ListTablesInput)
pub mod list_tables_input {
    /// A builder for [`ListTablesInput`](crate::input::ListTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesInput`](crate::input::ListTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTablesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                keyspace_name: self.keyspace_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTablesInputOperationOutputAlias = crate::operation::ListTables;
#[doc(hidden)]
pub type ListTablesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTablesInput {
    /// Consumes the builder and constructs an Operation<[`ListTables`](crate::operation::ListTables)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTables,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTablesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTablesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.ListTables",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tables(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTables",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTablesInput`](crate::input::ListTablesInput)
    pub fn builder() -> crate::input::list_tables_input::Builder {
        crate::input::list_tables_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RestoreTableInput`](crate::input::RestoreTableInput)
pub mod restore_table_input {
    /// A builder for [`RestoreTableInput`](crate::input::RestoreTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_keyspace_name: std::option::Option<std::string::String>,
        pub(crate) source_table_name: std::option::Option<std::string::String>,
        pub(crate) target_keyspace_name: std::option::Option<std::string::String>,
        pub(crate) target_table_name: std::option::Option<std::string::String>,
        pub(crate) restore_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) capacity_specification_override:
            std::option::Option<crate::model::CapacitySpecification>,
        pub(crate) encryption_specification_override:
            std::option::Option<crate::model::EncryptionSpecification>,
        pub(crate) point_in_time_recovery_override:
            std::option::Option<crate::model::PointInTimeRecovery>,
        pub(crate) tags_override: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The keyspace name of the source table.</p>
        pub fn source_keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_keyspace_name = Some(input.into());
            self
        }
        /// <p>The keyspace name of the source table.</p>
        pub fn set_source_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_keyspace_name = input;
            self
        }
        /// <p>The name of the source table.</p>
        pub fn source_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table_name = Some(input.into());
            self
        }
        /// <p>The name of the source table.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_table_name = input;
            self
        }
        /// <p>The name of the target keyspace.</p>
        pub fn target_keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the target keyspace.</p>
        pub fn set_target_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_keyspace_name = input;
            self
        }
        /// <p>The name of the target table.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_table_name = Some(input.into());
            self
        }
        /// <p>The name of the target table.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_table_name = input;
            self
        }
        /// <p>The restore timestamp in ISO 8601 format.</p>
        pub fn restore_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.restore_timestamp = Some(input);
            self
        }
        /// <p>The restore timestamp in ISO 8601 format.</p>
        pub fn set_restore_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.restore_timestamp = input;
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification_override(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.capacity_specification_override = Some(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification_override(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.capacity_specification_override = input;
            self
        }
        /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification_override(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.encryption_specification_override = Some(input);
            self
        }
        /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification_override(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.encryption_specification_override = input;
            self
        }
        /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery_override(
            mut self,
            input: crate::model::PointInTimeRecovery,
        ) -> Self {
            self.point_in_time_recovery_override = Some(input);
            self
        }
        /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery_override(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.point_in_time_recovery_override = input;
            self
        }
        /// Appends an item to `tags_override`.
        ///
        /// To override the contents of this collection use [`set_tags_override`](Self::set_tags_override).
        ///
        /// <p>A list of key-value pair tags to be attached to the restored table. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags_override(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_override.unwrap_or_default();
            v.push(input);
            self.tags_override = Some(v);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the restored table. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_override = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableInput`](crate::input::RestoreTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreTableInput {
                source_keyspace_name: self.source_keyspace_name,
                source_table_name: self.source_table_name,
                target_keyspace_name: self.target_keyspace_name,
                target_table_name: self.target_table_name,
                restore_timestamp: self.restore_timestamp,
                capacity_specification_override: self.capacity_specification_override,
                encryption_specification_override: self.encryption_specification_override,
                point_in_time_recovery_override: self.point_in_time_recovery_override,
                tags_override: self.tags_override,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreTableInputOperationOutputAlias = crate::operation::RestoreTable;
#[doc(hidden)]
pub type RestoreTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RestoreTableInput {
    /// Consumes the builder and constructs an Operation<[`RestoreTable`](crate::operation::RestoreTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RestoreTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RestoreTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.RestoreTable",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_restore_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreTable",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RestoreTableInput`](crate::input::RestoreTableInput)
    pub fn builder() -> crate::input::restore_table_input::Builder {
        crate::input::restore_table_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateTableInput`](crate::input::UpdateTableInput)
pub mod update_table_input {
    /// A builder for [`UpdateTableInput`](crate::input::UpdateTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyspace_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) add_columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        pub(crate) capacity_specification: std::option::Option<crate::model::CapacitySpecification>,
        pub(crate) encryption_specification:
            std::option::Option<crate::model::EncryptionSpecification>,
        pub(crate) point_in_time_recovery: std::option::Option<crate::model::PointInTimeRecovery>,
        pub(crate) ttl: std::option::Option<crate::model::TimeToLive>,
        pub(crate) default_time_to_live: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the keyspace the specified table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyspace_name = Some(input.into());
            self
        }
        /// <p>The name of the keyspace the specified table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyspace_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `add_columns`.
        ///
        /// To override the contents of this collection use [`set_add_columns`](Self::set_add_columns).
        ///
        /// <p>For each column to be added to the specified table:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn add_columns(mut self, input: crate::model::ColumnDefinition) -> Self {
            let mut v = self.add_columns.unwrap_or_default();
            v.push(input);
            self.add_columns = Some(v);
            self
        }
        /// <p>For each column to be added to the specified table:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_add_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        ) -> Self {
            self.add_columns = input;
            self
        }
        /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.capacity_specification = Some(input);
            self
        }
        /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.capacity_specification = input;
            self
        }
        /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.encryption_specification = Some(input);
            self
        }
        /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.encryption_specification = input;
            self
        }
        /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery(mut self, input: crate::model::PointInTimeRecovery) -> Self {
            self.point_in_time_recovery = Some(input);
            self
        }
        /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.point_in_time_recovery = input;
            self
        }
        /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn ttl(mut self, input: crate::model::TimeToLive) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_ttl(mut self, input: std::option::Option<crate::model::TimeToLive>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn default_time_to_live(mut self, input: i32) -> Self {
            self.default_time_to_live = Some(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_default_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.default_time_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableInput`](crate::input::UpdateTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTableInput {
                keyspace_name: self.keyspace_name,
                table_name: self.table_name,
                add_columns: self.add_columns,
                capacity_specification: self.capacity_specification,
                encryption_specification: self.encryption_specification,
                point_in_time_recovery: self.point_in_time_recovery,
                ttl: self.ttl,
                default_time_to_live: self.default_time_to_live,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTableInputOperationOutputAlias = crate::operation::UpdateTable;
#[doc(hidden)]
pub type UpdateTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTableInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTable`](crate::operation::UpdateTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "KeyspacesService.UpdateTable",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTable",
            "keyspaces",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTableInput`](crate::input::UpdateTableInput)
    pub fn builder() -> crate::input::update_table_input::Builder {
        crate::input::update_table_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableInput {
    /// <p>The name of the keyspace the specified table is stored in.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>For each column to be added to the specified table:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub add_columns: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
    /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub capacity_specification: std::option::Option<crate::model::CapacitySpecification>,
    /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub encryption_specification: std::option::Option<crate::model::EncryptionSpecification>,
    /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub point_in_time_recovery: std::option::Option<crate::model::PointInTimeRecovery>,
    /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
    /// <p>• <code>status:enabled</code> </p>
    /// <p>• <code>status:disabled</code> </p>
    /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub ttl: std::option::Option<crate::model::TimeToLive>,
    /// <p>The default Time to Live setting in seconds for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub default_time_to_live: std::option::Option<i32>,
}
impl UpdateTableInput {
    /// <p>The name of the keyspace the specified table is stored in.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>For each column to be added to the specified table:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn add_columns(&self) -> std::option::Option<&[crate::model::ColumnDefinition]> {
        self.add_columns.as_deref()
    }
    /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn capacity_specification(
        &self,
    ) -> std::option::Option<&crate::model::CapacitySpecification> {
        self.capacity_specification.as_ref()
    }
    /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn encryption_specification(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionSpecification> {
        self.encryption_specification.as_ref()
    }
    /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn point_in_time_recovery(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecovery> {
        self.point_in_time_recovery.as_ref()
    }
    /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
    /// <p>• <code>status:enabled</code> </p>
    /// <p>• <code>status:disabled</code> </p>
    /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn ttl(&self) -> std::option::Option<&crate::model::TimeToLive> {
        self.ttl.as_ref()
    }
    /// <p>The default Time to Live setting in seconds for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn default_time_to_live(&self) -> std::option::Option<i32> {
        self.default_time_to_live
    }
}
impl std::fmt::Debug for UpdateTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("add_columns", &self.add_columns);
        formatter.field("capacity_specification", &self.capacity_specification);
        formatter.field("encryption_specification", &self.encryption_specification);
        formatter.field("point_in_time_recovery", &self.point_in_time_recovery);
        formatter.field("ttl", &self.ttl);
        formatter.field("default_time_to_live", &self.default_time_to_live);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableInput {
    /// <p>The keyspace name of the source table.</p>
    pub source_keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the source table.</p>
    pub source_table_name: std::option::Option<std::string::String>,
    /// <p>The name of the target keyspace.</p>
    pub target_keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the target table.</p>
    pub target_table_name: std::option::Option<std::string::String>,
    /// <p>The restore timestamp in ISO 8601 format.</p>
    pub restore_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub capacity_specification_override: std::option::Option<crate::model::CapacitySpecification>,
    /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub encryption_specification_override:
        std::option::Option<crate::model::EncryptionSpecification>,
    /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub point_in_time_recovery_override: std::option::Option<crate::model::PointInTimeRecovery>,
    /// <p>A list of key-value pair tags to be attached to the restored table. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub tags_override: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RestoreTableInput {
    /// <p>The keyspace name of the source table.</p>
    pub fn source_keyspace_name(&self) -> std::option::Option<&str> {
        self.source_keyspace_name.as_deref()
    }
    /// <p>The name of the source table.</p>
    pub fn source_table_name(&self) -> std::option::Option<&str> {
        self.source_table_name.as_deref()
    }
    /// <p>The name of the target keyspace.</p>
    pub fn target_keyspace_name(&self) -> std::option::Option<&str> {
        self.target_keyspace_name.as_deref()
    }
    /// <p>The name of the target table.</p>
    pub fn target_table_name(&self) -> std::option::Option<&str> {
        self.target_table_name.as_deref()
    }
    /// <p>The restore timestamp in ISO 8601 format.</p>
    pub fn restore_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.restore_timestamp.as_ref()
    }
    /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn capacity_specification_override(
        &self,
    ) -> std::option::Option<&crate::model::CapacitySpecification> {
        self.capacity_specification_override.as_ref()
    }
    /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn encryption_specification_override(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionSpecification> {
        self.encryption_specification_override.as_ref()
    }
    /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn point_in_time_recovery_override(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecovery> {
        self.point_in_time_recovery_override.as_ref()
    }
    /// <p>A list of key-value pair tags to be attached to the restored table. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn tags_override(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_override.as_deref()
    }
}
impl std::fmt::Debug for RestoreTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableInput");
        formatter.field("source_keyspace_name", &self.source_keyspace_name);
        formatter.field("source_table_name", &self.source_table_name);
        formatter.field("target_keyspace_name", &self.target_keyspace_name);
        formatter.field("target_table_name", &self.target_table_name);
        formatter.field("restore_timestamp", &self.restore_timestamp);
        formatter.field(
            "capacity_specification_override",
            &self.capacity_specification_override,
        );
        formatter.field(
            "encryption_specification_override",
            &self.encryption_specification_override,
        );
        formatter.field(
            "point_in_time_recovery_override",
            &self.point_in_time_recovery_override,
        );
        formatter.field("tags_override", &self.tags_override);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesInput {
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name of the keyspace.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
}
impl ListTablesInput {
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The name of the keyspace.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
}
impl std::fmt::Debug for ListTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyspacesInput {
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListKeyspacesInput {
    /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListKeyspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyspacesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableInput {
    /// <p>The name of the keyspace that the table is stored in.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl GetTableInput {
    /// <p>The name of the keyspace that the table is stored in.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for GetTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyspaceInput {
    /// <p>The name of the keyspace.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
}
impl GetKeyspaceInput {
    /// <p>The name of the keyspace.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
}
impl std::fmt::Debug for GetKeyspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyspaceInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableInput {
    /// <p>The name of the keyspace of the to be deleted table.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the table to be deleted.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DeleteTableInput {
    /// <p>The name of the keyspace of the to be deleted table.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the table to be deleted.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeyspaceInput {
    /// <p>The name of the keyspace to be deleted.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
}
impl DeleteKeyspaceInput {
    /// <p>The name of the keyspace to be deleted.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteKeyspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeyspaceInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTableInput {
    /// <p>The name of the keyspace that the table is going to be created in.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
    /// <p>For each column to be created:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// <p>The primary key of the table consists of the following columns:</p>
    /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
    /// <p>• <code>name</code> - The name of each partition key column.</p>
    /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
    /// <p>• <code>name</code> - The name of the clustering column. </p>
    /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
    /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaDefinition>,
    /// <p>This parameter allows to enter a description of the table.</p>
    pub comment: std::option::Option<crate::model::Comment>,
    /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub capacity_specification: std::option::Option<crate::model::CapacitySpecification>,
    /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub encryption_specification: std::option::Option<crate::model::EncryptionSpecification>,
    /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub point_in_time_recovery: std::option::Option<crate::model::PointInTimeRecovery>,
    /// <p>Enables Time to Live custom settings for the table. The options are:</p>
    /// <p>• <code>status:enabled</code> </p>
    /// <p>• <code>status:disabled</code> </p>
    /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub ttl: std::option::Option<crate::model::TimeToLive>,
    /// <p>The default Time to Live setting in seconds for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub default_time_to_live: std::option::Option<i32>,
    /// <p>A list of key-value pair tags to be attached to the resource. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTableInput {
    /// <p>The name of the keyspace that the table is going to be created in.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
    /// <p>For each column to be created:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// <p>The primary key of the table consists of the following columns:</p>
    /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
    /// <p>• <code>name</code> - The name of each partition key column.</p>
    /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
    /// <p>• <code>name</code> - The name of the clustering column. </p>
    /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
    /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
    /// <p>• <code>name</code> - The name of the column.</p>
    /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaDefinition> {
        self.schema_definition.as_ref()
    }
    /// <p>This parameter allows to enter a description of the table.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
    /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
    /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
    /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
    /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn capacity_specification(
        &self,
    ) -> std::option::Option<&crate::model::CapacitySpecification> {
        self.capacity_specification.as_ref()
    }
    /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
    /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
    /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
    /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn encryption_specification(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionSpecification> {
        self.encryption_specification.as_ref()
    }
    /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
    /// <p>• <code>ENABLED</code> </p>
    /// <p>• <code>DISABLED</code> </p>
    /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn point_in_time_recovery(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecovery> {
        self.point_in_time_recovery.as_ref()
    }
    /// <p>Enables Time to Live custom settings for the table. The options are:</p>
    /// <p>• <code>status:enabled</code> </p>
    /// <p>• <code>status:disabled</code> </p>
    /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn ttl(&self) -> std::option::Option<&crate::model::TimeToLive> {
        self.ttl.as_ref()
    }
    /// <p>The default Time to Live setting in seconds for the table.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn default_time_to_live(&self) -> std::option::Option<i32> {
        self.default_time_to_live
    }
    /// <p>A list of key-value pair tags to be attached to the resource. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTableInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.field("comment", &self.comment);
        formatter.field("capacity_specification", &self.capacity_specification);
        formatter.field("encryption_specification", &self.encryption_specification);
        formatter.field("point_in_time_recovery", &self.point_in_time_recovery);
        formatter.field("ttl", &self.ttl);
        formatter.field("default_time_to_live", &self.default_time_to_live);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeyspaceInput {
    /// <p>The name of the keyspace to be created.</p>
    pub keyspace_name: std::option::Option<std::string::String>,
    /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateKeyspaceInput {
    /// <p>The name of the keyspace to be created.</p>
    pub fn keyspace_name(&self) -> std::option::Option<&str> {
        self.keyspace_name.as_deref()
    }
    /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateKeyspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeyspaceInput");
        formatter.field("keyspace_name", &self.keyspace_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
