// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Keyspaces
///
/// Client for invoking operations on Amazon Keyspaces. Each operation on Amazon Keyspaces is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_keyspaces::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_keyspaces::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_keyspaces::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateKeyspace`](crate::client::fluent_builders::CreateKeyspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::CreateKeyspace::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::CreateKeyspace::set_keyspace_name): <p>The name of the keyspace to be created.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateKeyspace::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateKeyspace::set_tags): <p>A list of key-value pair tags to be attached to the keyspace.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// - On success, responds with [`CreateKeyspaceOutput`](crate::output::CreateKeyspaceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::CreateKeyspaceOutput::resource_arn): <p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>
    /// - On failure, responds with [`SdkError<CreateKeyspaceError>`](crate::error::CreateKeyspaceError)
    pub fn create_keyspace(&self) -> fluent_builders::CreateKeyspace {
        fluent_builders::CreateKeyspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTable`](crate::client::fluent_builders::CreateTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::CreateTable::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::CreateTable::set_keyspace_name): <p>The name of the keyspace that the table is going to be created in.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::CreateTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::CreateTable::set_table_name): <p>The name of the table.</p>
    ///   - [`schema_definition(SchemaDefinition)`](crate::client::fluent_builders::CreateTable::schema_definition) / [`set_schema_definition(Option<SchemaDefinition>)`](crate::client::fluent_builders::CreateTable::set_schema_definition): <p>The <code>schemaDefinition</code> consists of the following parameters.</p>  <p>For each column to be created:</p>  <p>• <code>name</code> - The name of the column.</p>  <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>  <p>The primary key of the table consists of the following columns:</p>  <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>  <p>• <code>name</code> - The name of each partition key column.</p>  <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>  <p>• <code>name</code> - The name of the clustering column. </p>  <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>  <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>  <p>• <code>name</code> - The name of the column.</p>  <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
    ///   - [`comment(Comment)`](crate::client::fluent_builders::CreateTable::comment) / [`set_comment(Option<Comment>)`](crate::client::fluent_builders::CreateTable::set_comment): <p>This parameter allows to enter a description of the table.</p>
    ///   - [`capacity_specification(CapacitySpecification)`](crate::client::fluent_builders::CreateTable::capacity_specification) / [`set_capacity_specification(Option<CapacitySpecification>)`](crate::client::fluent_builders::CreateTable::set_capacity_specification): <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>  <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>  <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>  <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`encryption_specification(EncryptionSpecification)`](crate::client::fluent_builders::CreateTable::encryption_specification) / [`set_encryption_specification(Option<EncryptionSpecification>)`](crate::client::fluent_builders::CreateTable::set_encryption_specification): <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>  <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>  <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>  <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`point_in_time_recovery(PointInTimeRecovery)`](crate::client::fluent_builders::CreateTable::point_in_time_recovery) / [`set_point_in_time_recovery(Option<PointInTimeRecovery>)`](crate::client::fluent_builders::CreateTable::set_point_in_time_recovery): <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>  <p>• <code>ENABLED</code> </p>  <p>• <code>DISABLED</code> </p>  <p>If it's not specified, the default is <code>DISABLED</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`ttl(TimeToLive)`](crate::client::fluent_builders::CreateTable::ttl) / [`set_ttl(Option<TimeToLive>)`](crate::client::fluent_builders::CreateTable::set_ttl): <p>Enables Time to Live custom settings for the table. The options are:</p>  <p>• <code>status:enabled</code> </p>  <p>• <code>status:disabled</code> </p>  <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`default_time_to_live(i32)`](crate::client::fluent_builders::CreateTable::default_time_to_live) / [`set_default_time_to_live(Option<i32>)`](crate::client::fluent_builders::CreateTable::set_default_time_to_live): <p>The default Time to Live setting in seconds for the table.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTable::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTable::set_tags): <p>A list of key-value pair tags to be attached to the resource. </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// - On success, responds with [`CreateTableOutput`](crate::output::CreateTableOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::CreateTableOutput::resource_arn): <p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>
    /// - On failure, responds with [`SdkError<CreateTableError>`](crate::error::CreateTableError)
    pub fn create_table(&self) -> fluent_builders::CreateTable {
        fluent_builders::CreateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKeyspace`](crate::client::fluent_builders::DeleteKeyspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyspace::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::DeleteKeyspace::set_keyspace_name): <p>The name of the keyspace to be deleted.</p>
    /// - On success, responds with [`DeleteKeyspaceOutput`](crate::output::DeleteKeyspaceOutput)

    /// - On failure, responds with [`SdkError<DeleteKeyspaceError>`](crate::error::DeleteKeyspaceError)
    pub fn delete_keyspace(&self) -> fluent_builders::DeleteKeyspace {
        fluent_builders::DeleteKeyspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTable`](crate::client::fluent_builders::DeleteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTable::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::DeleteTable::set_keyspace_name): <p>The name of the keyspace of the to be deleted table.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DeleteTable::set_table_name): <p>The name of the table to be deleted.</p>
    /// - On success, responds with [`DeleteTableOutput`](crate::output::DeleteTableOutput)

    /// - On failure, responds with [`SdkError<DeleteTableError>`](crate::error::DeleteTableError)
    pub fn delete_table(&self) -> fluent_builders::DeleteTable {
        fluent_builders::DeleteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKeyspace`](crate::client::fluent_builders::GetKeyspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::GetKeyspace::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::GetKeyspace::set_keyspace_name): <p>The name of the keyspace.</p>
    /// - On success, responds with [`GetKeyspaceOutput`](crate::output::GetKeyspaceOutput) with field(s):
    ///   - [`keyspace_name(Option<String>)`](crate::output::GetKeyspaceOutput::keyspace_name): <p>The name of the keyspace.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::GetKeyspaceOutput::resource_arn): <p>The ARN of the keyspace.</p>
    /// - On failure, responds with [`SdkError<GetKeyspaceError>`](crate::error::GetKeyspaceError)
    pub fn get_keyspace(&self) -> fluent_builders::GetKeyspace {
        fluent_builders::GetKeyspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTable`](crate::client::fluent_builders::GetTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::GetTable::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::GetTable::set_keyspace_name): <p>The name of the keyspace that the table is stored in.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::GetTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::GetTable::set_table_name): <p>The name of the table.</p>
    /// - On success, responds with [`GetTableOutput`](crate::output::GetTableOutput) with field(s):
    ///   - [`keyspace_name(Option<String>)`](crate::output::GetTableOutput::keyspace_name): <p>The name of the keyspace that the specified table is stored in.</p>
    ///   - [`table_name(Option<String>)`](crate::output::GetTableOutput::table_name): <p>The name of the specified table.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::GetTableOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the specified table.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::GetTableOutput::creation_timestamp): <p>The creation timestamp of the specified table.</p>
    ///   - [`status(Option<TableStatus>)`](crate::output::GetTableOutput::status): <p>The current status of the specified table.</p>
    ///   - [`schema_definition(Option<SchemaDefinition>)`](crate::output::GetTableOutput::schema_definition): <p>The schema definition of the specified table.</p>
    ///   - [`capacity_specification(Option<CapacitySpecificationSummary>)`](crate::output::GetTableOutput::capacity_specification): <p>The read/write throughput capacity mode for a table. The options are:</p>  <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>  <p>• <code>throughputMode:PROVISIONED</code> </p>
    ///   - [`encryption_specification(Option<EncryptionSpecification>)`](crate::output::GetTableOutput::encryption_specification): <p>The encryption settings of the specified table.</p>
    ///   - [`point_in_time_recovery(Option<PointInTimeRecoverySummary>)`](crate::output::GetTableOutput::point_in_time_recovery): <p>The point-in-time recovery status of the specified table.</p>
    ///   - [`ttl(Option<TimeToLive>)`](crate::output::GetTableOutput::ttl): <p>The custom Time to Live settings of the specified table.</p>
    ///   - [`default_time_to_live(Option<i32>)`](crate::output::GetTableOutput::default_time_to_live): <p>The default Time to Live settings of the specified table.</p>
    ///   - [`comment(Option<Comment>)`](crate::output::GetTableOutput::comment): <p>The the description of the specified table.</p>
    /// - On failure, responds with [`SdkError<GetTableError>`](crate::error::GetTableError)
    pub fn get_table(&self) -> fluent_builders::GetTable {
        fluent_builders::GetTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeyspaces`](crate::client::fluent_builders::ListKeyspaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKeyspaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListKeyspaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListKeyspaces::set_next_token): <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListKeyspaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListKeyspaces::set_max_results): <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    /// - On success, responds with [`ListKeyspacesOutput`](crate::output::ListKeyspacesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListKeyspacesOutput::next_token): <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    ///   - [`keyspaces(Option<Vec<KeyspaceSummary>>)`](crate::output::ListKeyspacesOutput::keyspaces): <p>A list of keyspaces.</p>
    /// - On failure, responds with [`SdkError<ListKeyspacesError>`](crate::error::ListKeyspacesError)
    pub fn list_keyspaces(&self) -> fluent_builders::ListKeyspaces {
        fluent_builders::ListKeyspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTables`](crate::client::fluent_builders::ListTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTables::set_next_token): <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTables::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTables::set_max_results): <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::ListTables::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::ListTables::set_keyspace_name): <p>The name of the keyspace.</p>
    /// - On success, responds with [`ListTablesOutput`](crate::output::ListTablesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTablesOutput::next_token): <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    ///   - [`tables(Option<Vec<TableSummary>>)`](crate::output::ListTablesOutput::tables): <p>A list of tables.</p>
    /// - On failure, responds with [`SdkError<ListTablesError>`](crate::error::ListTablesError)
    pub fn list_tables(&self) -> fluent_builders::ListTables {
        fluent_builders::ListTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreTable`](crate::client::fluent_builders::RestoreTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_keyspace_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTable::source_keyspace_name) / [`set_source_keyspace_name(Option<String>)`](crate::client::fluent_builders::RestoreTable::set_source_keyspace_name): <p>The keyspace name of the source table.</p>
    ///   - [`source_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTable::source_table_name) / [`set_source_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTable::set_source_table_name): <p>The name of the source table.</p>
    ///   - [`target_keyspace_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTable::target_keyspace_name) / [`set_target_keyspace_name(Option<String>)`](crate::client::fluent_builders::RestoreTable::set_target_keyspace_name): <p>The name of the target keyspace.</p>
    ///   - [`target_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTable::target_table_name) / [`set_target_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTable::set_target_table_name): <p>The name of the target table.</p>
    ///   - [`restore_timestamp(DateTime)`](crate::client::fluent_builders::RestoreTable::restore_timestamp) / [`set_restore_timestamp(Option<DateTime>)`](crate::client::fluent_builders::RestoreTable::set_restore_timestamp): <p>The restore timestamp in ISO 8601 format.</p>
    ///   - [`capacity_specification_override(CapacitySpecification)`](crate::client::fluent_builders::RestoreTable::capacity_specification_override) / [`set_capacity_specification_override(Option<CapacitySpecification>)`](crate::client::fluent_builders::RestoreTable::set_capacity_specification_override): <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>  <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>  <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>  <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`encryption_specification_override(EncryptionSpecification)`](crate::client::fluent_builders::RestoreTable::encryption_specification_override) / [`set_encryption_specification_override(Option<EncryptionSpecification>)`](crate::client::fluent_builders::RestoreTable::set_encryption_specification_override): <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>  <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>  <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>  <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`point_in_time_recovery_override(PointInTimeRecovery)`](crate::client::fluent_builders::RestoreTable::point_in_time_recovery_override) / [`set_point_in_time_recovery_override(Option<PointInTimeRecovery>)`](crate::client::fluent_builders::RestoreTable::set_point_in_time_recovery_override): <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>  <p>• <code>ENABLED</code> </p>  <p>• <code>DISABLED</code> </p>  <p>If it's not specified, the default is <code>DISABLED</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`tags_override(Vec<Tag>)`](crate::client::fluent_builders::RestoreTable::tags_override) / [`set_tags_override(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreTable::set_tags_override): <p>A list of key-value pair tags to be attached to the restored table. </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// - On success, responds with [`RestoreTableOutput`](crate::output::RestoreTableOutput) with field(s):
    ///   - [`restored_table_arn(Option<String>)`](crate::output::RestoreTableOutput::restored_table_arn): <p>The Amazon Resource Name (ARN) of the restored table.</p>
    /// - On failure, responds with [`SdkError<RestoreTableError>`](crate::error::RestoreTableError)
    pub fn restore_table(&self) -> fluent_builders::RestoreTable {
        fluent_builders::RestoreTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UntagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UntagResource::set_tags): <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTable`](crate::client::fluent_builders::UpdateTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`keyspace_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTable::keyspace_name) / [`set_keyspace_name(Option<String>)`](crate::client::fluent_builders::UpdateTable::set_keyspace_name): <p>The name of the keyspace the specified table is stored in.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTable::set_table_name): <p>The name of the table.</p>
    ///   - [`add_columns(Vec<ColumnDefinition>)`](crate::client::fluent_builders::UpdateTable::add_columns) / [`set_add_columns(Option<Vec<ColumnDefinition>>)`](crate::client::fluent_builders::UpdateTable::set_add_columns): <p>For each column to be added to the specified table:</p>  <p>• <code>name</code> - The name of the column.</p>  <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`capacity_specification(CapacitySpecification)`](crate::client::fluent_builders::UpdateTable::capacity_specification) / [`set_capacity_specification(Option<CapacitySpecification>)`](crate::client::fluent_builders::UpdateTable::set_capacity_specification): <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>  <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>  <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>  <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`encryption_specification(EncryptionSpecification)`](crate::client::fluent_builders::UpdateTable::encryption_specification) / [`set_encryption_specification(Option<EncryptionSpecification>)`](crate::client::fluent_builders::UpdateTable::set_encryption_specification): <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>  <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>  <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>  <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`point_in_time_recovery(PointInTimeRecovery)`](crate::client::fluent_builders::UpdateTable::point_in_time_recovery) / [`set_point_in_time_recovery(Option<PointInTimeRecovery>)`](crate::client::fluent_builders::UpdateTable::set_point_in_time_recovery): <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>  <p>• <code>ENABLED</code> </p>  <p>• <code>DISABLED</code> </p>  <p>If it's not specified, the default is <code>DISABLED</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`ttl(TimeToLive)`](crate::client::fluent_builders::UpdateTable::ttl) / [`set_ttl(Option<TimeToLive>)`](crate::client::fluent_builders::UpdateTable::set_ttl): <p>Modifies Time to Live custom settings for the table. The options are:</p>  <p>• <code>status:enabled</code> </p>  <p>• <code>status:disabled</code> </p>  <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    ///   - [`default_time_to_live(i32)`](crate::client::fluent_builders::UpdateTable::default_time_to_live) / [`set_default_time_to_live(Option<i32>)`](crate::client::fluent_builders::UpdateTable::set_default_time_to_live): <p>The default Time to Live setting in seconds for the table.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateTableOutput`](crate::output::UpdateTableOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::UpdateTableOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the modified table.</p>
    /// - On failure, responds with [`SdkError<UpdateTableError>`](crate::error::UpdateTableError)
    pub fn update_table(&self) -> fluent_builders::UpdateTable {
        fluent_builders::UpdateTable::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateKeyspace`.
    ///
    /// <p>The <code>CreateKeyspace</code> operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.</p>
    /// <p> <code>CreateKeyspace</code> is an asynchronous operation. You can monitor the creation status of the new keyspace by using the <code>GetKeyspace</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create">Creating keyspaces</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeyspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_keyspace_input::Builder,
    }
    impl CreateKeyspace {
        /// Creates a new `CreateKeyspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace to be created.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace to be created.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the keyspace.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTable`.
    ///
    /// <p>The <code>CreateTable</code> operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.</p>
    /// <p> <code>CreateTable</code> is an asynchronous operation. When the request is received, the status of the table is set to <code>CREATING</code>. You can monitor the creation status of the new table by using the <code>GetTable</code> operation, which returns the current <code>status</code> of the table. You can start using a table when the status is <code>ACTIVE</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create">Creating tables</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_table_input::Builder,
    }
    impl CreateTable {
        /// Creates a new `CreateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace that the table is going to be created in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace that the table is going to be created in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
        /// <p>For each column to be created:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        /// <p>The primary key of the table consists of the following columns:</p>
        /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
        /// <p>• <code>name</code> - The name of each partition key column.</p>
        /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
        /// <p>• <code>name</code> - The name of the clustering column. </p>
        /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaDefinition) -> Self {
            self.inner = self.inner.schema_definition(input);
            self
        }
        /// <p>The <code>schemaDefinition</code> consists of the following parameters.</p>
        /// <p>For each column to be created:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        /// <p>The primary key of the table consists of the following columns:</p>
        /// <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p>
        /// <p>• <code>name</code> - The name of each partition key column.</p>
        /// <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>
        /// <p>• <code>name</code> - The name of the clustering column. </p>
        /// <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>
        /// <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaDefinition>,
        ) -> Self {
            self.inner = self.inner.set_schema_definition(input);
            self
        }
        /// <p>This parameter allows to enter a description of the table.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.inner = self.inner.comment(input);
            self
        }
        /// <p>This parameter allows to enter a description of the table.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.inner = self.inner.capacity_specification(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.inner = self.inner.set_capacity_specification(input);
            self
        }
        /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.inner = self.inner.encryption_specification(input);
            self
        }
        /// <p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.inner = self.inner.set_encryption_specification(input);
            self
        }
        /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery(mut self, input: crate::model::PointInTimeRecovery) -> Self {
            self.inner = self.inner.point_in_time_recovery(input);
            self
        }
        /// <p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.inner = self.inner.set_point_in_time_recovery(input);
            self
        }
        /// <p>Enables Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn ttl(mut self, input: crate::model::TimeToLive) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>Enables Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_ttl(mut self, input: std::option::Option<crate::model::TimeToLive>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn default_time_to_live(mut self, input: i32) -> Self {
            self.inner = self.inner.default_time_to_live(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_default_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_time_to_live(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pair tags to be attached to the resource. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the resource. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeyspace`.
    ///
    /// <p>The <code>DeleteKeyspace</code> operation deletes a keyspace and all of its tables. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKeyspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_keyspace_input::Builder,
    }
    impl DeleteKeyspace {
        /// Creates a new `DeleteKeyspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeyspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeyspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace to be deleted.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace to be deleted.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTable`.
    ///
    /// <p>The <code>DeleteTable</code> operation deletes a table and all of its data. After a <code>DeleteTable</code> request is received, the specified table is in the <code>DELETING</code> state until Amazon Keyspaces completes the deletion. If the table is in the <code>ACTIVE</code> state, you can delete it. If a table is either in the <code>CREATING</code> or <code>UPDATING</code> states, then Amazon Keyspaces returns a <code>ResourceInUseException</code>. If the specified table does not exist, Amazon Keyspaces returns a <code>ResourceNotFoundException</code>. If the table is already in the <code>DELETING</code> state, no error is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_table_input::Builder,
    }
    impl DeleteTable {
        /// Creates a new `DeleteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace of the to be deleted table.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace of the to be deleted table.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
        /// <p>The name of the table to be deleted.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to be deleted.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyspace`.
    ///
    /// <p>Returns the name and the Amazon Resource Name (ARN) of the specified table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKeyspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_keyspace_input::Builder,
    }
    impl GetKeyspace {
        /// Creates a new `GetKeyspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTable`.
    ///
    /// <p>Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.</p>
    /// <p>To read table metadata using <code>GetTable</code>, <code>Select</code> action permissions for the table and system tables are required to complete the operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_table_input::Builder,
    }
    impl GetTable {
        /// Creates a new `GetTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace that the table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyspaces`.
    ///
    /// <p>Returns a list of keyspaces.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeyspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_keyspaces_input::Builder,
    }
    impl ListKeyspaces {
        /// Creates a new `ListKeyspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKeyspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKeyspacesPaginator {
            crate::paginator::ListKeyspacesPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTables`.
    ///
    /// <p>Returns a list of tables for a specified keyspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTables {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tables_input::Builder,
    }
    impl ListTables {
        /// Creates a new `ListTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTablesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTablesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTablesPaginator {
            crate::paginator::ListTablesPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of all tags associated with the specified Amazon Keyspaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTable`.
    ///
    /// <p>Restores the specified table to the specified point in time within the <code>earliest_restorable_timestamp</code> and the current time. For more information about restore points, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window"> Time window for PITR continuous backups</a> in the <i>Amazon Keyspaces Developer Guide</i>. </p>
    /// <p>Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.</p>
    /// <p>When you restore using point in time recovery, Amazon Keyspaces restores your source table's schema and data to the state based on the selected timestamp <code>(day:hour:minute:second)</code> to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.</p>
    /// <p>In addition to the table's schema, data, and TTL settings, <code>RestoreTable</code> restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table's schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table's settings as of the current time or when the table was deleted.</p>
    /// <p>You can also overwrite these settings during restore:</p>
    /// <p>• Read/write capacity mode</p>
    /// <p>• Provisioned throughput capacity settings</p>
    /// <p>• Point-in-time (PITR) settings</p>
    /// <p>• Tags</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings">PITR restore settings</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// <p>Note that the following settings are not restored, and you must configure them manually for the new table:</p>
    /// <p>• Automatic scaling policies (for tables that use provisioned capacity mode)</p>
    /// <p>• Identity and Access Management (IAM) policies</p>
    /// <p>• Amazon CloudWatch metrics and alarms</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_table_input::Builder,
    }
    impl RestoreTable {
        /// Creates a new `RestoreTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The keyspace name of the source table.</p>
        pub fn source_keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_keyspace_name(input.into());
            self
        }
        /// <p>The keyspace name of the source table.</p>
        pub fn set_source_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_keyspace_name(input);
            self
        }
        /// <p>The name of the source table.</p>
        pub fn source_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_name(input.into());
            self
        }
        /// <p>The name of the source table.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_name(input);
            self
        }
        /// <p>The name of the target keyspace.</p>
        pub fn target_keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_keyspace_name(input.into());
            self
        }
        /// <p>The name of the target keyspace.</p>
        pub fn set_target_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_keyspace_name(input);
            self
        }
        /// <p>The name of the target table.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_table_name(input.into());
            self
        }
        /// <p>The name of the target table.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_table_name(input);
            self
        }
        /// <p>The restore timestamp in ISO 8601 format.</p>
        pub fn restore_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.restore_timestamp(input);
            self
        }
        /// <p>The restore timestamp in ISO 8601 format.</p>
        pub fn set_restore_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_restore_timestamp(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification_override(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.inner = self.inner.capacity_specification_override(input);
            self
        }
        /// <p>Specifies the read/write throughput capacity mode for the target table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification_override(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.inner = self.inner.set_capacity_specification_override(input);
            self
        }
        /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification_override(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.inner = self.inner.encryption_specification_override(input);
            self
        }
        /// <p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification_override(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.inner = self.inner.set_encryption_specification_override(input);
            self
        }
        /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery_override(
            mut self,
            input: crate::model::PointInTimeRecovery,
        ) -> Self {
            self.inner = self.inner.point_in_time_recovery_override(input);
            self
        }
        /// <p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery_override(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.inner = self.inner.set_point_in_time_recovery_override(input);
            self
        }
        /// Appends an item to `tagsOverride`.
        ///
        /// To override the contents of this collection use [`set_tags_override`](Self::set_tags_override).
        ///
        /// <p>A list of key-value pair tags to be attached to the restored table. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn tags_override(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags_override(input);
            self
        }
        /// <p>A list of key-value pair tags to be attached to the restored table. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_tags_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    /// <p>For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags">Amazon Keyspaces resource access based on tags</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon Keyspaces resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association of tags from a Amazon Keyspaces resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTable`.
    ///
    /// <p>Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_table_input::Builder,
    }
    impl UpdateTable {
        /// Creates a new `UpdateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the keyspace the specified table is stored in.</p>
        pub fn keyspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keyspace_name(input.into());
            self
        }
        /// <p>The name of the keyspace the specified table is stored in.</p>
        pub fn set_keyspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_keyspace_name(input);
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `addColumns`.
        ///
        /// To override the contents of this collection use [`set_add_columns`](Self::set_add_columns).
        ///
        /// <p>For each column to be added to the specified table:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn add_columns(mut self, input: crate::model::ColumnDefinition) -> Self {
            self.inner = self.inner.add_columns(input);
            self
        }
        /// <p>For each column to be added to the specified table:</p>
        /// <p>• <code>name</code> - The name of the column.</p>
        /// <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_add_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_add_columns(input);
            self
        }
        /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn capacity_specification(
            mut self,
            input: crate::model::CapacitySpecification,
        ) -> Self {
            self.inner = self.inner.capacity_specification(input);
            self
        }
        /// <p>Modifies the read/write throughput capacity mode for the table. The options are:</p>
        /// <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p>
        /// <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p>
        /// <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::CapacitySpecification>,
        ) -> Self {
            self.inner = self.inner.set_capacity_specification(input);
            self
        }
        /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn encryption_specification(
            mut self,
            input: crate::model::EncryptionSpecification,
        ) -> Self {
            self.inner = self.inner.encryption_specification(input);
            self
        }
        /// <p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
        /// <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p>
        /// <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p>
        /// <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_encryption_specification(
            mut self,
            input: std::option::Option<crate::model::EncryptionSpecification>,
        ) -> Self {
            self.inner = self.inner.set_encryption_specification(input);
            self
        }
        /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn point_in_time_recovery(mut self, input: crate::model::PointInTimeRecovery) -> Self {
            self.inner = self.inner.point_in_time_recovery(input);
            self
        }
        /// <p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
        /// <p>• <code>ENABLED</code> </p>
        /// <p>• <code>DISABLED</code> </p>
        /// <p>If it's not specified, the default is <code>DISABLED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_point_in_time_recovery(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecovery>,
        ) -> Self {
            self.inner = self.inner.set_point_in_time_recovery(input);
            self
        }
        /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn ttl(mut self, input: crate::model::TimeToLive) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>Modifies Time to Live custom settings for the table. The options are:</p>
        /// <p>• <code>status:enabled</code> </p>
        /// <p>• <code>status:disabled</code> </p>
        /// <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_ttl(mut self, input: std::option::Option<crate::model::TimeToLive>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn default_time_to_live(mut self, input: i32) -> Self {
            self.inner = self.inner.default_time_to_live(input);
            self
        }
        /// <p>The default Time to Live setting in seconds for the table.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>
        pub fn set_default_time_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_time_to_live(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
