// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateEntitiesToExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_entities_to_experience`](crate::client::Client::associate_entities_to_experience).
///
/// See [`crate::client::fluent_builders::AssociateEntitiesToExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateEntitiesToExperience {
    _private: (),
}
impl AssociateEntitiesToExperience {
    /// Creates a new builder-style object to manufacture [`AssociateEntitiesToExperienceInput`](crate::input::AssociateEntitiesToExperienceInput)
    pub fn builder() -> crate::input::associate_entities_to_experience_input::Builder {
        crate::input::associate_entities_to_experience_input::Builder::default()
    }
    /// Creates a new `AssociateEntitiesToExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateEntitiesToExperience {
    type Output = std::result::Result<
        crate::output::AssociateEntitiesToExperienceOutput,
        crate::error::AssociateEntitiesToExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_entities_to_experience_error(response)
        } else {
            crate::operation_deser::parse_associate_entities_to_experience_response(response)
        }
    }
}

/// Operation shape for `AssociatePersonasToEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_personas_to_entities`](crate::client::Client::associate_personas_to_entities).
///
/// See [`crate::client::fluent_builders::AssociatePersonasToEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociatePersonasToEntities {
    _private: (),
}
impl AssociatePersonasToEntities {
    /// Creates a new builder-style object to manufacture [`AssociatePersonasToEntitiesInput`](crate::input::AssociatePersonasToEntitiesInput)
    pub fn builder() -> crate::input::associate_personas_to_entities_input::Builder {
        crate::input::associate_personas_to_entities_input::Builder::default()
    }
    /// Creates a new `AssociatePersonasToEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociatePersonasToEntities {
    type Output = std::result::Result<
        crate::output::AssociatePersonasToEntitiesOutput,
        crate::error::AssociatePersonasToEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_personas_to_entities_error(response)
        } else {
            crate::operation_deser::parse_associate_personas_to_entities_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_document`](crate::client::Client::batch_delete_document).
///
/// See [`crate::client::fluent_builders::BatchDeleteDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteDocument {
    _private: (),
}
impl BatchDeleteDocument {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDocumentInput`](crate::input::BatchDeleteDocumentInput)
    pub fn builder() -> crate::input::batch_delete_document_input::Builder {
        crate::input::batch_delete_document_input::Builder::default()
    }
    /// Creates a new `BatchDeleteDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteDocument {
    type Output = std::result::Result<
        crate::output::BatchDeleteDocumentOutput,
        crate::error::BatchDeleteDocumentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_document_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_document_response(response)
        }
    }
}

/// Operation shape for `BatchGetDocumentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_document_status`](crate::client::Client::batch_get_document_status).
///
/// See [`crate::client::fluent_builders::BatchGetDocumentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetDocumentStatus {
    _private: (),
}
impl BatchGetDocumentStatus {
    /// Creates a new builder-style object to manufacture [`BatchGetDocumentStatusInput`](crate::input::BatchGetDocumentStatusInput)
    pub fn builder() -> crate::input::batch_get_document_status_input::Builder {
        crate::input::batch_get_document_status_input::Builder::default()
    }
    /// Creates a new `BatchGetDocumentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetDocumentStatus {
    type Output = std::result::Result<
        crate::output::BatchGetDocumentStatusOutput,
        crate::error::BatchGetDocumentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_document_status_error(response)
        } else {
            crate::operation_deser::parse_batch_get_document_status_response(response)
        }
    }
}

/// Operation shape for `BatchPutDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_document`](crate::client::Client::batch_put_document).
///
/// See [`crate::client::fluent_builders::BatchPutDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutDocument {
    _private: (),
}
impl BatchPutDocument {
    /// Creates a new builder-style object to manufacture [`BatchPutDocumentInput`](crate::input::BatchPutDocumentInput)
    pub fn builder() -> crate::input::batch_put_document_input::Builder {
        crate::input::batch_put_document_input::Builder::default()
    }
    /// Creates a new `BatchPutDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutDocument {
    type Output = std::result::Result<
        crate::output::BatchPutDocumentOutput,
        crate::error::BatchPutDocumentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_document_error(response)
        } else {
            crate::operation_deser::parse_batch_put_document_response(response)
        }
    }
}

/// Operation shape for `ClearQuerySuggestions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`clear_query_suggestions`](crate::client::Client::clear_query_suggestions).
///
/// See [`crate::client::fluent_builders::ClearQuerySuggestions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClearQuerySuggestions {
    _private: (),
}
impl ClearQuerySuggestions {
    /// Creates a new builder-style object to manufacture [`ClearQuerySuggestionsInput`](crate::input::ClearQuerySuggestionsInput)
    pub fn builder() -> crate::input::clear_query_suggestions_input::Builder {
        crate::input::clear_query_suggestions_input::Builder::default()
    }
    /// Creates a new `ClearQuerySuggestions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClearQuerySuggestions {
    type Output = std::result::Result<
        crate::output::ClearQuerySuggestionsOutput,
        crate::error::ClearQuerySuggestionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_clear_query_suggestions_error(response)
        } else {
            crate::operation_deser::parse_clear_query_suggestions_response(response)
        }
    }
}

/// Operation shape for `CreateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_source`](crate::client::Client::create_data_source).
///
/// See [`crate::client::fluent_builders::CreateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataSource {
    _private: (),
}
impl CreateDataSource {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
    /// Creates a new `CreateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataSource {
    type Output = std::result::Result<
        crate::output::CreateDataSourceOutput,
        crate::error::CreateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_source_error(response)
        } else {
            crate::operation_deser::parse_create_data_source_response(response)
        }
    }
}

/// Operation shape for `CreateExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_experience`](crate::client::Client::create_experience).
///
/// See [`crate::client::fluent_builders::CreateExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExperience {
    _private: (),
}
impl CreateExperience {
    /// Creates a new builder-style object to manufacture [`CreateExperienceInput`](crate::input::CreateExperienceInput)
    pub fn builder() -> crate::input::create_experience_input::Builder {
        crate::input::create_experience_input::Builder::default()
    }
    /// Creates a new `CreateExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExperience {
    type Output = std::result::Result<
        crate::output::CreateExperienceOutput,
        crate::error::CreateExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_experience_error(response)
        } else {
            crate::operation_deser::parse_create_experience_response(response)
        }
    }
}

/// Operation shape for `CreateFaq`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_faq`](crate::client::Client::create_faq).
///
/// See [`crate::client::fluent_builders::CreateFaq`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFaq {
    _private: (),
}
impl CreateFaq {
    /// Creates a new builder-style object to manufacture [`CreateFaqInput`](crate::input::CreateFaqInput)
    pub fn builder() -> crate::input::create_faq_input::Builder {
        crate::input::create_faq_input::Builder::default()
    }
    /// Creates a new `CreateFaq` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFaq {
    type Output = std::result::Result<crate::output::CreateFaqOutput, crate::error::CreateFaqError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_faq_error(response)
        } else {
            crate::operation_deser::parse_create_faq_response(response)
        }
    }
}

/// Operation shape for `CreateIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_index`](crate::client::Client::create_index).
///
/// See [`crate::client::fluent_builders::CreateIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIndex {
    _private: (),
}
impl CreateIndex {
    /// Creates a new builder-style object to manufacture [`CreateIndexInput`](crate::input::CreateIndexInput)
    pub fn builder() -> crate::input::create_index_input::Builder {
        crate::input::create_index_input::Builder::default()
    }
    /// Creates a new `CreateIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIndex {
    type Output =
        std::result::Result<crate::output::CreateIndexOutput, crate::error::CreateIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_index_error(response)
        } else {
            crate::operation_deser::parse_create_index_response(response)
        }
    }
}

/// Operation shape for `CreateQuerySuggestionsBlockList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_query_suggestions_block_list`](crate::client::Client::create_query_suggestions_block_list).
///
/// See [`crate::client::fluent_builders::CreateQuerySuggestionsBlockList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQuerySuggestionsBlockList {
    _private: (),
}
impl CreateQuerySuggestionsBlockList {
    /// Creates a new builder-style object to manufacture [`CreateQuerySuggestionsBlockListInput`](crate::input::CreateQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::create_query_suggestions_block_list_input::Builder {
        crate::input::create_query_suggestions_block_list_input::Builder::default()
    }
    /// Creates a new `CreateQuerySuggestionsBlockList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQuerySuggestionsBlockList {
    type Output = std::result::Result<
        crate::output::CreateQuerySuggestionsBlockListOutput,
        crate::error::CreateQuerySuggestionsBlockListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_query_suggestions_block_list_error(response)
        } else {
            crate::operation_deser::parse_create_query_suggestions_block_list_response(response)
        }
    }
}

/// Operation shape for `CreateThesaurus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_thesaurus`](crate::client::Client::create_thesaurus).
///
/// See [`crate::client::fluent_builders::CreateThesaurus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThesaurus {
    _private: (),
}
impl CreateThesaurus {
    /// Creates a new builder-style object to manufacture [`CreateThesaurusInput`](crate::input::CreateThesaurusInput)
    pub fn builder() -> crate::input::create_thesaurus_input::Builder {
        crate::input::create_thesaurus_input::Builder::default()
    }
    /// Creates a new `CreateThesaurus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThesaurus {
    type Output = std::result::Result<
        crate::output::CreateThesaurusOutput,
        crate::error::CreateThesaurusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_thesaurus_error(response)
        } else {
            crate::operation_deser::parse_create_thesaurus_response(response)
        }
    }
}

/// Operation shape for `DeleteDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_source`](crate::client::Client::delete_data_source).
///
/// See [`crate::client::fluent_builders::DeleteDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataSource {
    _private: (),
}
impl DeleteDataSource {
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
    /// Creates a new `DeleteDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataSource {
    type Output = std::result::Result<
        crate::output::DeleteDataSourceOutput,
        crate::error::DeleteDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_source_error(response)
        } else {
            crate::operation_deser::parse_delete_data_source_response(response)
        }
    }
}

/// Operation shape for `DeleteExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_experience`](crate::client::Client::delete_experience).
///
/// See [`crate::client::fluent_builders::DeleteExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExperience {
    _private: (),
}
impl DeleteExperience {
    /// Creates a new builder-style object to manufacture [`DeleteExperienceInput`](crate::input::DeleteExperienceInput)
    pub fn builder() -> crate::input::delete_experience_input::Builder {
        crate::input::delete_experience_input::Builder::default()
    }
    /// Creates a new `DeleteExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExperience {
    type Output = std::result::Result<
        crate::output::DeleteExperienceOutput,
        crate::error::DeleteExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_experience_error(response)
        } else {
            crate::operation_deser::parse_delete_experience_response(response)
        }
    }
}

/// Operation shape for `DeleteFaq`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_faq`](crate::client::Client::delete_faq).
///
/// See [`crate::client::fluent_builders::DeleteFaq`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFaq {
    _private: (),
}
impl DeleteFaq {
    /// Creates a new builder-style object to manufacture [`DeleteFaqInput`](crate::input::DeleteFaqInput)
    pub fn builder() -> crate::input::delete_faq_input::Builder {
        crate::input::delete_faq_input::Builder::default()
    }
    /// Creates a new `DeleteFaq` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFaq {
    type Output = std::result::Result<crate::output::DeleteFaqOutput, crate::error::DeleteFaqError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_faq_error(response)
        } else {
            crate::operation_deser::parse_delete_faq_response(response)
        }
    }
}

/// Operation shape for `DeleteIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_index`](crate::client::Client::delete_index).
///
/// See [`crate::client::fluent_builders::DeleteIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIndex {
    _private: (),
}
impl DeleteIndex {
    /// Creates a new builder-style object to manufacture [`DeleteIndexInput`](crate::input::DeleteIndexInput)
    pub fn builder() -> crate::input::delete_index_input::Builder {
        crate::input::delete_index_input::Builder::default()
    }
    /// Creates a new `DeleteIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIndex {
    type Output =
        std::result::Result<crate::output::DeleteIndexOutput, crate::error::DeleteIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_index_error(response)
        } else {
            crate::operation_deser::parse_delete_index_response(response)
        }
    }
}

/// Operation shape for `DeletePrincipalMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_principal_mapping`](crate::client::Client::delete_principal_mapping).
///
/// See [`crate::client::fluent_builders::DeletePrincipalMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePrincipalMapping {
    _private: (),
}
impl DeletePrincipalMapping {
    /// Creates a new builder-style object to manufacture [`DeletePrincipalMappingInput`](crate::input::DeletePrincipalMappingInput)
    pub fn builder() -> crate::input::delete_principal_mapping_input::Builder {
        crate::input::delete_principal_mapping_input::Builder::default()
    }
    /// Creates a new `DeletePrincipalMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePrincipalMapping {
    type Output = std::result::Result<
        crate::output::DeletePrincipalMappingOutput,
        crate::error::DeletePrincipalMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_principal_mapping_error(response)
        } else {
            crate::operation_deser::parse_delete_principal_mapping_response(response)
        }
    }
}

/// Operation shape for `DeleteQuerySuggestionsBlockList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_query_suggestions_block_list`](crate::client::Client::delete_query_suggestions_block_list).
///
/// See [`crate::client::fluent_builders::DeleteQuerySuggestionsBlockList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQuerySuggestionsBlockList {
    _private: (),
}
impl DeleteQuerySuggestionsBlockList {
    /// Creates a new builder-style object to manufacture [`DeleteQuerySuggestionsBlockListInput`](crate::input::DeleteQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::delete_query_suggestions_block_list_input::Builder {
        crate::input::delete_query_suggestions_block_list_input::Builder::default()
    }
    /// Creates a new `DeleteQuerySuggestionsBlockList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQuerySuggestionsBlockList {
    type Output = std::result::Result<
        crate::output::DeleteQuerySuggestionsBlockListOutput,
        crate::error::DeleteQuerySuggestionsBlockListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_query_suggestions_block_list_error(response)
        } else {
            crate::operation_deser::parse_delete_query_suggestions_block_list_response(response)
        }
    }
}

/// Operation shape for `DeleteThesaurus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_thesaurus`](crate::client::Client::delete_thesaurus).
///
/// See [`crate::client::fluent_builders::DeleteThesaurus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThesaurus {
    _private: (),
}
impl DeleteThesaurus {
    /// Creates a new builder-style object to manufacture [`DeleteThesaurusInput`](crate::input::DeleteThesaurusInput)
    pub fn builder() -> crate::input::delete_thesaurus_input::Builder {
        crate::input::delete_thesaurus_input::Builder::default()
    }
    /// Creates a new `DeleteThesaurus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThesaurus {
    type Output = std::result::Result<
        crate::output::DeleteThesaurusOutput,
        crate::error::DeleteThesaurusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_thesaurus_error(response)
        } else {
            crate::operation_deser::parse_delete_thesaurus_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_source`](crate::client::Client::describe_data_source).
///
/// See [`crate::client::fluent_builders::DescribeDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSource {
    _private: (),
}
impl DescribeDataSource {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    pub fn builder() -> crate::input::describe_data_source_input::Builder {
        crate::input::describe_data_source_input::Builder::default()
    }
    /// Creates a new `DescribeDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSource {
    type Output = std::result::Result<
        crate::output::DescribeDataSourceOutput,
        crate::error::DescribeDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_source_error(response)
        } else {
            crate::operation_deser::parse_describe_data_source_response(response)
        }
    }
}

/// Operation shape for `DescribeExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_experience`](crate::client::Client::describe_experience).
///
/// See [`crate::client::fluent_builders::DescribeExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExperience {
    _private: (),
}
impl DescribeExperience {
    /// Creates a new builder-style object to manufacture [`DescribeExperienceInput`](crate::input::DescribeExperienceInput)
    pub fn builder() -> crate::input::describe_experience_input::Builder {
        crate::input::describe_experience_input::Builder::default()
    }
    /// Creates a new `DescribeExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExperience {
    type Output = std::result::Result<
        crate::output::DescribeExperienceOutput,
        crate::error::DescribeExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_experience_error(response)
        } else {
            crate::operation_deser::parse_describe_experience_response(response)
        }
    }
}

/// Operation shape for `DescribeFaq`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_faq`](crate::client::Client::describe_faq).
///
/// See [`crate::client::fluent_builders::DescribeFaq`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFaq {
    _private: (),
}
impl DescribeFaq {
    /// Creates a new builder-style object to manufacture [`DescribeFaqInput`](crate::input::DescribeFaqInput)
    pub fn builder() -> crate::input::describe_faq_input::Builder {
        crate::input::describe_faq_input::Builder::default()
    }
    /// Creates a new `DescribeFaq` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFaq {
    type Output =
        std::result::Result<crate::output::DescribeFaqOutput, crate::error::DescribeFaqError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_faq_error(response)
        } else {
            crate::operation_deser::parse_describe_faq_response(response)
        }
    }
}

/// Operation shape for `DescribeIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_index`](crate::client::Client::describe_index).
///
/// See [`crate::client::fluent_builders::DescribeIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIndex {
    _private: (),
}
impl DescribeIndex {
    /// Creates a new builder-style object to manufacture [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    pub fn builder() -> crate::input::describe_index_input::Builder {
        crate::input::describe_index_input::Builder::default()
    }
    /// Creates a new `DescribeIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIndex {
    type Output =
        std::result::Result<crate::output::DescribeIndexOutput, crate::error::DescribeIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_index_error(response)
        } else {
            crate::operation_deser::parse_describe_index_response(response)
        }
    }
}

/// Operation shape for `DescribePrincipalMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_principal_mapping`](crate::client::Client::describe_principal_mapping).
///
/// See [`crate::client::fluent_builders::DescribePrincipalMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePrincipalMapping {
    _private: (),
}
impl DescribePrincipalMapping {
    /// Creates a new builder-style object to manufacture [`DescribePrincipalMappingInput`](crate::input::DescribePrincipalMappingInput)
    pub fn builder() -> crate::input::describe_principal_mapping_input::Builder {
        crate::input::describe_principal_mapping_input::Builder::default()
    }
    /// Creates a new `DescribePrincipalMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePrincipalMapping {
    type Output = std::result::Result<
        crate::output::DescribePrincipalMappingOutput,
        crate::error::DescribePrincipalMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_principal_mapping_error(response)
        } else {
            crate::operation_deser::parse_describe_principal_mapping_response(response)
        }
    }
}

/// Operation shape for `DescribeQuerySuggestionsBlockList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_query_suggestions_block_list`](crate::client::Client::describe_query_suggestions_block_list).
///
/// See [`crate::client::fluent_builders::DescribeQuerySuggestionsBlockList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQuerySuggestionsBlockList {
    _private: (),
}
impl DescribeQuerySuggestionsBlockList {
    /// Creates a new builder-style object to manufacture [`DescribeQuerySuggestionsBlockListInput`](crate::input::DescribeQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::describe_query_suggestions_block_list_input::Builder {
        crate::input::describe_query_suggestions_block_list_input::Builder::default()
    }
    /// Creates a new `DescribeQuerySuggestionsBlockList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQuerySuggestionsBlockList {
    type Output = std::result::Result<
        crate::output::DescribeQuerySuggestionsBlockListOutput,
        crate::error::DescribeQuerySuggestionsBlockListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_query_suggestions_block_list_error(response)
        } else {
            crate::operation_deser::parse_describe_query_suggestions_block_list_response(response)
        }
    }
}

/// Operation shape for `DescribeQuerySuggestionsConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_query_suggestions_config`](crate::client::Client::describe_query_suggestions_config).
///
/// See [`crate::client::fluent_builders::DescribeQuerySuggestionsConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQuerySuggestionsConfig {
    _private: (),
}
impl DescribeQuerySuggestionsConfig {
    /// Creates a new builder-style object to manufacture [`DescribeQuerySuggestionsConfigInput`](crate::input::DescribeQuerySuggestionsConfigInput)
    pub fn builder() -> crate::input::describe_query_suggestions_config_input::Builder {
        crate::input::describe_query_suggestions_config_input::Builder::default()
    }
    /// Creates a new `DescribeQuerySuggestionsConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQuerySuggestionsConfig {
    type Output = std::result::Result<
        crate::output::DescribeQuerySuggestionsConfigOutput,
        crate::error::DescribeQuerySuggestionsConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_query_suggestions_config_error(response)
        } else {
            crate::operation_deser::parse_describe_query_suggestions_config_response(response)
        }
    }
}

/// Operation shape for `DescribeThesaurus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_thesaurus`](crate::client::Client::describe_thesaurus).
///
/// See [`crate::client::fluent_builders::DescribeThesaurus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThesaurus {
    _private: (),
}
impl DescribeThesaurus {
    /// Creates a new builder-style object to manufacture [`DescribeThesaurusInput`](crate::input::DescribeThesaurusInput)
    pub fn builder() -> crate::input::describe_thesaurus_input::Builder {
        crate::input::describe_thesaurus_input::Builder::default()
    }
    /// Creates a new `DescribeThesaurus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThesaurus {
    type Output = std::result::Result<
        crate::output::DescribeThesaurusOutput,
        crate::error::DescribeThesaurusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_thesaurus_error(response)
        } else {
            crate::operation_deser::parse_describe_thesaurus_response(response)
        }
    }
}

/// Operation shape for `DisassociateEntitiesFromExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_entities_from_experience`](crate::client::Client::disassociate_entities_from_experience).
///
/// See [`crate::client::fluent_builders::DisassociateEntitiesFromExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateEntitiesFromExperience {
    _private: (),
}
impl DisassociateEntitiesFromExperience {
    /// Creates a new builder-style object to manufacture [`DisassociateEntitiesFromExperienceInput`](crate::input::DisassociateEntitiesFromExperienceInput)
    pub fn builder() -> crate::input::disassociate_entities_from_experience_input::Builder {
        crate::input::disassociate_entities_from_experience_input::Builder::default()
    }
    /// Creates a new `DisassociateEntitiesFromExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateEntitiesFromExperience {
    type Output = std::result::Result<
        crate::output::DisassociateEntitiesFromExperienceOutput,
        crate::error::DisassociateEntitiesFromExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_entities_from_experience_error(response)
        } else {
            crate::operation_deser::parse_disassociate_entities_from_experience_response(response)
        }
    }
}

/// Operation shape for `DisassociatePersonasFromEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_personas_from_entities`](crate::client::Client::disassociate_personas_from_entities).
///
/// See [`crate::client::fluent_builders::DisassociatePersonasFromEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociatePersonasFromEntities {
    _private: (),
}
impl DisassociatePersonasFromEntities {
    /// Creates a new builder-style object to manufacture [`DisassociatePersonasFromEntitiesInput`](crate::input::DisassociatePersonasFromEntitiesInput)
    pub fn builder() -> crate::input::disassociate_personas_from_entities_input::Builder {
        crate::input::disassociate_personas_from_entities_input::Builder::default()
    }
    /// Creates a new `DisassociatePersonasFromEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociatePersonasFromEntities {
    type Output = std::result::Result<
        crate::output::DisassociatePersonasFromEntitiesOutput,
        crate::error::DisassociatePersonasFromEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_personas_from_entities_error(response)
        } else {
            crate::operation_deser::parse_disassociate_personas_from_entities_response(response)
        }
    }
}

/// Operation shape for `GetQuerySuggestions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_suggestions`](crate::client::Client::get_query_suggestions).
///
/// See [`crate::client::fluent_builders::GetQuerySuggestions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQuerySuggestions {
    _private: (),
}
impl GetQuerySuggestions {
    /// Creates a new builder-style object to manufacture [`GetQuerySuggestionsInput`](crate::input::GetQuerySuggestionsInput)
    pub fn builder() -> crate::input::get_query_suggestions_input::Builder {
        crate::input::get_query_suggestions_input::Builder::default()
    }
    /// Creates a new `GetQuerySuggestions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQuerySuggestions {
    type Output = std::result::Result<
        crate::output::GetQuerySuggestionsOutput,
        crate::error::GetQuerySuggestionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_suggestions_error(response)
        } else {
            crate::operation_deser::parse_get_query_suggestions_response(response)
        }
    }
}

/// Operation shape for `GetSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_snapshots`](crate::client::Client::get_snapshots).
///
/// See [`crate::client::fluent_builders::GetSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSnapshots {
    _private: (),
}
impl GetSnapshots {
    /// Creates a new builder-style object to manufacture [`GetSnapshotsInput`](crate::input::GetSnapshotsInput)
    pub fn builder() -> crate::input::get_snapshots_input::Builder {
        crate::input::get_snapshots_input::Builder::default()
    }
    /// Creates a new `GetSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSnapshots {
    type Output =
        std::result::Result<crate::output::GetSnapshotsOutput, crate::error::GetSnapshotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_snapshots_error(response)
        } else {
            crate::operation_deser::parse_get_snapshots_response(response)
        }
    }
}

/// Operation shape for `ListDataSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_sources`](crate::client::Client::list_data_sources).
///
/// See [`crate::client::fluent_builders::ListDataSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataSources {
    _private: (),
}
impl ListDataSources {
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
    /// Creates a new `ListDataSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataSources {
    type Output = std::result::Result<
        crate::output::ListDataSourcesOutput,
        crate::error::ListDataSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_sources_error(response)
        } else {
            crate::operation_deser::parse_list_data_sources_response(response)
        }
    }
}

/// Operation shape for `ListDataSourceSyncJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_source_sync_jobs`](crate::client::Client::list_data_source_sync_jobs).
///
/// See [`crate::client::fluent_builders::ListDataSourceSyncJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataSourceSyncJobs {
    _private: (),
}
impl ListDataSourceSyncJobs {
    /// Creates a new builder-style object to manufacture [`ListDataSourceSyncJobsInput`](crate::input::ListDataSourceSyncJobsInput)
    pub fn builder() -> crate::input::list_data_source_sync_jobs_input::Builder {
        crate::input::list_data_source_sync_jobs_input::Builder::default()
    }
    /// Creates a new `ListDataSourceSyncJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataSourceSyncJobs {
    type Output = std::result::Result<
        crate::output::ListDataSourceSyncJobsOutput,
        crate::error::ListDataSourceSyncJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_source_sync_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_data_source_sync_jobs_response(response)
        }
    }
}

/// Operation shape for `ListEntityPersonas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entity_personas`](crate::client::Client::list_entity_personas).
///
/// See [`crate::client::fluent_builders::ListEntityPersonas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntityPersonas {
    _private: (),
}
impl ListEntityPersonas {
    /// Creates a new builder-style object to manufacture [`ListEntityPersonasInput`](crate::input::ListEntityPersonasInput)
    pub fn builder() -> crate::input::list_entity_personas_input::Builder {
        crate::input::list_entity_personas_input::Builder::default()
    }
    /// Creates a new `ListEntityPersonas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntityPersonas {
    type Output = std::result::Result<
        crate::output::ListEntityPersonasOutput,
        crate::error::ListEntityPersonasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entity_personas_error(response)
        } else {
            crate::operation_deser::parse_list_entity_personas_response(response)
        }
    }
}

/// Operation shape for `ListExperienceEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_experience_entities`](crate::client::Client::list_experience_entities).
///
/// See [`crate::client::fluent_builders::ListExperienceEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExperienceEntities {
    _private: (),
}
impl ListExperienceEntities {
    /// Creates a new builder-style object to manufacture [`ListExperienceEntitiesInput`](crate::input::ListExperienceEntitiesInput)
    pub fn builder() -> crate::input::list_experience_entities_input::Builder {
        crate::input::list_experience_entities_input::Builder::default()
    }
    /// Creates a new `ListExperienceEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExperienceEntities {
    type Output = std::result::Result<
        crate::output::ListExperienceEntitiesOutput,
        crate::error::ListExperienceEntitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_experience_entities_error(response)
        } else {
            crate::operation_deser::parse_list_experience_entities_response(response)
        }
    }
}

/// Operation shape for `ListExperiences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_experiences`](crate::client::Client::list_experiences).
///
/// See [`crate::client::fluent_builders::ListExperiences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExperiences {
    _private: (),
}
impl ListExperiences {
    /// Creates a new builder-style object to manufacture [`ListExperiencesInput`](crate::input::ListExperiencesInput)
    pub fn builder() -> crate::input::list_experiences_input::Builder {
        crate::input::list_experiences_input::Builder::default()
    }
    /// Creates a new `ListExperiences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExperiences {
    type Output = std::result::Result<
        crate::output::ListExperiencesOutput,
        crate::error::ListExperiencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_experiences_error(response)
        } else {
            crate::operation_deser::parse_list_experiences_response(response)
        }
    }
}

/// Operation shape for `ListFaqs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_faqs`](crate::client::Client::list_faqs).
///
/// See [`crate::client::fluent_builders::ListFaqs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFaqs {
    _private: (),
}
impl ListFaqs {
    /// Creates a new builder-style object to manufacture [`ListFaqsInput`](crate::input::ListFaqsInput)
    pub fn builder() -> crate::input::list_faqs_input::Builder {
        crate::input::list_faqs_input::Builder::default()
    }
    /// Creates a new `ListFaqs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFaqs {
    type Output = std::result::Result<crate::output::ListFaqsOutput, crate::error::ListFaqsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_faqs_error(response)
        } else {
            crate::operation_deser::parse_list_faqs_response(response)
        }
    }
}

/// Operation shape for `ListGroupsOlderThanOrderingId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_groups_older_than_ordering_id`](crate::client::Client::list_groups_older_than_ordering_id).
///
/// See [`crate::client::fluent_builders::ListGroupsOlderThanOrderingId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroupsOlderThanOrderingId {
    _private: (),
}
impl ListGroupsOlderThanOrderingId {
    /// Creates a new builder-style object to manufacture [`ListGroupsOlderThanOrderingIdInput`](crate::input::ListGroupsOlderThanOrderingIdInput)
    pub fn builder() -> crate::input::list_groups_older_than_ordering_id_input::Builder {
        crate::input::list_groups_older_than_ordering_id_input::Builder::default()
    }
    /// Creates a new `ListGroupsOlderThanOrderingId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroupsOlderThanOrderingId {
    type Output = std::result::Result<
        crate::output::ListGroupsOlderThanOrderingIdOutput,
        crate::error::ListGroupsOlderThanOrderingIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_groups_older_than_ordering_id_error(response)
        } else {
            crate::operation_deser::parse_list_groups_older_than_ordering_id_response(response)
        }
    }
}

/// Operation shape for `ListIndices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_indices`](crate::client::Client::list_indices).
///
/// See [`crate::client::fluent_builders::ListIndices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIndices {
    _private: (),
}
impl ListIndices {
    /// Creates a new builder-style object to manufacture [`ListIndicesInput`](crate::input::ListIndicesInput)
    pub fn builder() -> crate::input::list_indices_input::Builder {
        crate::input::list_indices_input::Builder::default()
    }
    /// Creates a new `ListIndices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIndices {
    type Output =
        std::result::Result<crate::output::ListIndicesOutput, crate::error::ListIndicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_indices_error(response)
        } else {
            crate::operation_deser::parse_list_indices_response(response)
        }
    }
}

/// Operation shape for `ListQuerySuggestionsBlockLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_query_suggestions_block_lists`](crate::client::Client::list_query_suggestions_block_lists).
///
/// See [`crate::client::fluent_builders::ListQuerySuggestionsBlockLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQuerySuggestionsBlockLists {
    _private: (),
}
impl ListQuerySuggestionsBlockLists {
    /// Creates a new builder-style object to manufacture [`ListQuerySuggestionsBlockListsInput`](crate::input::ListQuerySuggestionsBlockListsInput)
    pub fn builder() -> crate::input::list_query_suggestions_block_lists_input::Builder {
        crate::input::list_query_suggestions_block_lists_input::Builder::default()
    }
    /// Creates a new `ListQuerySuggestionsBlockLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQuerySuggestionsBlockLists {
    type Output = std::result::Result<
        crate::output::ListQuerySuggestionsBlockListsOutput,
        crate::error::ListQuerySuggestionsBlockListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_query_suggestions_block_lists_error(response)
        } else {
            crate::operation_deser::parse_list_query_suggestions_block_lists_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListThesauri`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thesauri`](crate::client::Client::list_thesauri).
///
/// See [`crate::client::fluent_builders::ListThesauri`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThesauri {
    _private: (),
}
impl ListThesauri {
    /// Creates a new builder-style object to manufacture [`ListThesauriInput`](crate::input::ListThesauriInput)
    pub fn builder() -> crate::input::list_thesauri_input::Builder {
        crate::input::list_thesauri_input::Builder::default()
    }
    /// Creates a new `ListThesauri` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThesauri {
    type Output =
        std::result::Result<crate::output::ListThesauriOutput, crate::error::ListThesauriError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thesauri_error(response)
        } else {
            crate::operation_deser::parse_list_thesauri_response(response)
        }
    }
}

/// Operation shape for `PutPrincipalMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_principal_mapping`](crate::client::Client::put_principal_mapping).
///
/// See [`crate::client::fluent_builders::PutPrincipalMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPrincipalMapping {
    _private: (),
}
impl PutPrincipalMapping {
    /// Creates a new builder-style object to manufacture [`PutPrincipalMappingInput`](crate::input::PutPrincipalMappingInput)
    pub fn builder() -> crate::input::put_principal_mapping_input::Builder {
        crate::input::put_principal_mapping_input::Builder::default()
    }
    /// Creates a new `PutPrincipalMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPrincipalMapping {
    type Output = std::result::Result<
        crate::output::PutPrincipalMappingOutput,
        crate::error::PutPrincipalMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_principal_mapping_error(response)
        } else {
            crate::operation_deser::parse_put_principal_mapping_response(response)
        }
    }
}

/// Operation shape for `Query`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`query`](crate::client::Client::query).
///
/// See [`crate::client::fluent_builders::Query`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Query {
    _private: (),
}
impl Query {
    /// Creates a new builder-style object to manufacture [`QueryInput`](crate::input::QueryInput)
    pub fn builder() -> crate::input::query_input::Builder {
        crate::input::query_input::Builder::default()
    }
    /// Creates a new `Query` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Query {
    type Output = std::result::Result<crate::output::QueryOutput, crate::error::QueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_query_error(response)
        } else {
            crate::operation_deser::parse_query_response(response)
        }
    }
}

/// Operation shape for `StartDataSourceSyncJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_data_source_sync_job`](crate::client::Client::start_data_source_sync_job).
///
/// See [`crate::client::fluent_builders::StartDataSourceSyncJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDataSourceSyncJob {
    _private: (),
}
impl StartDataSourceSyncJob {
    /// Creates a new builder-style object to manufacture [`StartDataSourceSyncJobInput`](crate::input::StartDataSourceSyncJobInput)
    pub fn builder() -> crate::input::start_data_source_sync_job_input::Builder {
        crate::input::start_data_source_sync_job_input::Builder::default()
    }
    /// Creates a new `StartDataSourceSyncJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDataSourceSyncJob {
    type Output = std::result::Result<
        crate::output::StartDataSourceSyncJobOutput,
        crate::error::StartDataSourceSyncJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_data_source_sync_job_error(response)
        } else {
            crate::operation_deser::parse_start_data_source_sync_job_response(response)
        }
    }
}

/// Operation shape for `StopDataSourceSyncJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_data_source_sync_job`](crate::client::Client::stop_data_source_sync_job).
///
/// See [`crate::client::fluent_builders::StopDataSourceSyncJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDataSourceSyncJob {
    _private: (),
}
impl StopDataSourceSyncJob {
    /// Creates a new builder-style object to manufacture [`StopDataSourceSyncJobInput`](crate::input::StopDataSourceSyncJobInput)
    pub fn builder() -> crate::input::stop_data_source_sync_job_input::Builder {
        crate::input::stop_data_source_sync_job_input::Builder::default()
    }
    /// Creates a new `StopDataSourceSyncJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDataSourceSyncJob {
    type Output = std::result::Result<
        crate::output::StopDataSourceSyncJobOutput,
        crate::error::StopDataSourceSyncJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_data_source_sync_job_error(response)
        } else {
            crate::operation_deser::parse_stop_data_source_sync_job_response(response)
        }
    }
}

/// Operation shape for `SubmitFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`submit_feedback`](crate::client::Client::submit_feedback).
///
/// See [`crate::client::fluent_builders::SubmitFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubmitFeedback {
    _private: (),
}
impl SubmitFeedback {
    /// Creates a new builder-style object to manufacture [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    pub fn builder() -> crate::input::submit_feedback_input::Builder {
        crate::input::submit_feedback_input::Builder::default()
    }
    /// Creates a new `SubmitFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubmitFeedback {
    type Output =
        std::result::Result<crate::output::SubmitFeedbackOutput, crate::error::SubmitFeedbackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_submit_feedback_error(response)
        } else {
            crate::operation_deser::parse_submit_feedback_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_source`](crate::client::Client::update_data_source).
///
/// See [`crate::client::fluent_builders::UpdateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSource {
    _private: (),
}
impl UpdateDataSource {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
    /// Creates a new `UpdateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSource {
    type Output = std::result::Result<
        crate::output::UpdateDataSourceOutput,
        crate::error::UpdateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_source_error(response)
        } else {
            crate::operation_deser::parse_update_data_source_response(response)
        }
    }
}

/// Operation shape for `UpdateExperience`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_experience`](crate::client::Client::update_experience).
///
/// See [`crate::client::fluent_builders::UpdateExperience`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateExperience {
    _private: (),
}
impl UpdateExperience {
    /// Creates a new builder-style object to manufacture [`UpdateExperienceInput`](crate::input::UpdateExperienceInput)
    pub fn builder() -> crate::input::update_experience_input::Builder {
        crate::input::update_experience_input::Builder::default()
    }
    /// Creates a new `UpdateExperience` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateExperience {
    type Output = std::result::Result<
        crate::output::UpdateExperienceOutput,
        crate::error::UpdateExperienceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_experience_error(response)
        } else {
            crate::operation_deser::parse_update_experience_response(response)
        }
    }
}

/// Operation shape for `UpdateIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_index`](crate::client::Client::update_index).
///
/// See [`crate::client::fluent_builders::UpdateIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIndex {
    _private: (),
}
impl UpdateIndex {
    /// Creates a new builder-style object to manufacture [`UpdateIndexInput`](crate::input::UpdateIndexInput)
    pub fn builder() -> crate::input::update_index_input::Builder {
        crate::input::update_index_input::Builder::default()
    }
    /// Creates a new `UpdateIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIndex {
    type Output =
        std::result::Result<crate::output::UpdateIndexOutput, crate::error::UpdateIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_index_error(response)
        } else {
            crate::operation_deser::parse_update_index_response(response)
        }
    }
}

/// Operation shape for `UpdateQuerySuggestionsBlockList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_query_suggestions_block_list`](crate::client::Client::update_query_suggestions_block_list).
///
/// See [`crate::client::fluent_builders::UpdateQuerySuggestionsBlockList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQuerySuggestionsBlockList {
    _private: (),
}
impl UpdateQuerySuggestionsBlockList {
    /// Creates a new builder-style object to manufacture [`UpdateQuerySuggestionsBlockListInput`](crate::input::UpdateQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::update_query_suggestions_block_list_input::Builder {
        crate::input::update_query_suggestions_block_list_input::Builder::default()
    }
    /// Creates a new `UpdateQuerySuggestionsBlockList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQuerySuggestionsBlockList {
    type Output = std::result::Result<
        crate::output::UpdateQuerySuggestionsBlockListOutput,
        crate::error::UpdateQuerySuggestionsBlockListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_query_suggestions_block_list_error(response)
        } else {
            crate::operation_deser::parse_update_query_suggestions_block_list_response(response)
        }
    }
}

/// Operation shape for `UpdateQuerySuggestionsConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_query_suggestions_config`](crate::client::Client::update_query_suggestions_config).
///
/// See [`crate::client::fluent_builders::UpdateQuerySuggestionsConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQuerySuggestionsConfig {
    _private: (),
}
impl UpdateQuerySuggestionsConfig {
    /// Creates a new builder-style object to manufacture [`UpdateQuerySuggestionsConfigInput`](crate::input::UpdateQuerySuggestionsConfigInput)
    pub fn builder() -> crate::input::update_query_suggestions_config_input::Builder {
        crate::input::update_query_suggestions_config_input::Builder::default()
    }
    /// Creates a new `UpdateQuerySuggestionsConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQuerySuggestionsConfig {
    type Output = std::result::Result<
        crate::output::UpdateQuerySuggestionsConfigOutput,
        crate::error::UpdateQuerySuggestionsConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_query_suggestions_config_error(response)
        } else {
            crate::operation_deser::parse_update_query_suggestions_config_response(response)
        }
    }
}

/// Operation shape for `UpdateThesaurus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_thesaurus`](crate::client::Client::update_thesaurus).
///
/// See [`crate::client::fluent_builders::UpdateThesaurus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThesaurus {
    _private: (),
}
impl UpdateThesaurus {
    /// Creates a new builder-style object to manufacture [`UpdateThesaurusInput`](crate::input::UpdateThesaurusInput)
    pub fn builder() -> crate::input::update_thesaurus_input::Builder {
        crate::input::update_thesaurus_input::Builder::default()
    }
    /// Creates a new `UpdateThesaurus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThesaurus {
    type Output = std::result::Result<
        crate::output::UpdateThesaurusOutput,
        crate::error::UpdateThesaurusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_thesaurus_error(response)
        } else {
            crate::operation_deser::parse_update_thesaurus_response(response)
        }
    }
}
