// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateEntitiesToExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateEntitiesToExperienceError {
    /// Kind of error that occurred.
    pub kind: AssociateEntitiesToExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateEntitiesToExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateEntitiesToExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceAlreadyExistException(crate::error::ResourceAlreadyExistException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateEntitiesToExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateEntitiesToExperienceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateEntitiesToExperienceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateEntitiesToExperienceErrorKind::ResourceAlreadyExistException(_inner) => {
                _inner.fmt(f)
            }
            AssociateEntitiesToExperienceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateEntitiesToExperienceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateEntitiesToExperienceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateEntitiesToExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateEntitiesToExperienceError {
    fn code(&self) -> Option<&str> {
        AssociateEntitiesToExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateEntitiesToExperienceError {
    /// Creates a new `AssociateEntitiesToExperienceError`.
    pub fn new(
        kind: AssociateEntitiesToExperienceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateEntitiesToExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateEntitiesToExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateEntitiesToExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateEntitiesToExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::ResourceAlreadyExistException`.
    pub fn is_resource_already_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::ResourceAlreadyExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEntitiesToExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEntitiesToExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateEntitiesToExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateEntitiesToExperienceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateEntitiesToExperienceErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateEntitiesToExperienceErrorKind::ResourceAlreadyExistException(_inner) => {
                Some(_inner)
            }
            AssociateEntitiesToExperienceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateEntitiesToExperienceErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateEntitiesToExperienceErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateEntitiesToExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociatePersonasToEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociatePersonasToEntitiesError {
    /// Kind of error that occurred.
    pub kind: AssociatePersonasToEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociatePersonasToEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociatePersonasToEntitiesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceAlreadyExistException(crate::error::ResourceAlreadyExistException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociatePersonasToEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociatePersonasToEntitiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociatePersonasToEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociatePersonasToEntitiesErrorKind::ResourceAlreadyExistException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePersonasToEntitiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociatePersonasToEntitiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociatePersonasToEntitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociatePersonasToEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociatePersonasToEntitiesError {
    fn code(&self) -> Option<&str> {
        AssociatePersonasToEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociatePersonasToEntitiesError {
    /// Creates a new `AssociatePersonasToEntitiesError`.
    pub fn new(kind: AssociatePersonasToEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociatePersonasToEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociatePersonasToEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociatePersonasToEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociatePersonasToEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::ResourceAlreadyExistException`.
    pub fn is_resource_already_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::ResourceAlreadyExistException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociatePersonasToEntitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociatePersonasToEntitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociatePersonasToEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociatePersonasToEntitiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociatePersonasToEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociatePersonasToEntitiesErrorKind::ResourceAlreadyExistException(_inner) => {
                Some(_inner)
            }
            AssociatePersonasToEntitiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociatePersonasToEntitiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociatePersonasToEntitiesErrorKind::ValidationException(_inner) => Some(_inner),
            AssociatePersonasToEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteDocumentError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteDocumentErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteDocumentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchDeleteDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteDocumentError {
    fn code(&self) -> Option<&str> {
        BatchDeleteDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteDocumentError {
    /// Creates a new `BatchDeleteDocumentError`.
    pub fn new(kind: BatchDeleteDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteDocumentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDocumentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDocumentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchDeleteDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteDocumentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::ConflictException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::ValidationException(_inner) => Some(_inner),
            BatchDeleteDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetDocumentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetDocumentStatusError {
    /// Kind of error that occurred.
    pub kind: BatchGetDocumentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetDocumentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetDocumentStatusErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetDocumentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetDocumentStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetDocumentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetDocumentStatusError {
    fn code(&self) -> Option<&str> {
        BatchGetDocumentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetDocumentStatusError {
    /// Creates a new `BatchGetDocumentStatusError`.
    pub fn new(kind: BatchGetDocumentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetDocumentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetDocumentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetDocumentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetDocumentStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDocumentStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDocumentStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetDocumentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetDocumentStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::ConflictException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetDocumentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchPutDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutDocumentError {
    /// Kind of error that occurred.
    pub kind: BatchPutDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutDocumentErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutDocumentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchPutDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutDocumentError {
    fn code(&self) -> Option<&str> {
        BatchPutDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutDocumentError {
    /// Creates a new `BatchPutDocumentError`.
    pub fn new(kind: BatchPutDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutDocumentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, BatchPutDocumentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutDocumentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutDocumentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchPutDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutDocumentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::ConflictException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::ValidationException(_inner) => Some(_inner),
            BatchPutDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ClearQuerySuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClearQuerySuggestionsError {
    /// Kind of error that occurred.
    pub kind: ClearQuerySuggestionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClearQuerySuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClearQuerySuggestionsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClearQuerySuggestionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClearQuerySuggestionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ClearQuerySuggestionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClearQuerySuggestionsError {
    fn code(&self) -> Option<&str> {
        ClearQuerySuggestionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClearQuerySuggestionsError {
    /// Creates a new `ClearQuerySuggestionsError`.
    pub fn new(kind: ClearQuerySuggestionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClearQuerySuggestionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClearQuerySuggestionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClearQuerySuggestionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClearQuerySuggestionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearQuerySuggestionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearQuerySuggestionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ClearQuerySuggestionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClearQuerySuggestionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::ConflictException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::ValidationException(_inner) => Some(_inner),
            ClearQuerySuggestionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceError {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceAlreadyExistException(crate::error::ResourceAlreadyExistException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ResourceAlreadyExistException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceError {
    fn code(&self) -> Option<&str> {
        CreateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceError {
    /// Creates a new `CreateDataSourceError`.
    pub fn new(kind: CreateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ResourceAlreadyExistException`.
    pub fn is_resource_already_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ResourceAlreadyExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ResourceAlreadyExistException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExperienceError {
    /// Kind of error that occurred.
    pub kind: CreateExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExperienceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExperienceError {
    fn code(&self) -> Option<&str> {
        CreateExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExperienceError {
    /// Creates a new `CreateExperienceError`.
    pub fn new(kind: CreateExperienceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateExperienceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExperienceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateExperienceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateExperienceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateExperienceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExperienceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateExperienceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateExperienceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFaqError {
    /// Kind of error that occurred.
    pub kind: CreateFaqErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFaqErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFaqError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFaqErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFaqErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFaqError {
    fn code(&self) -> Option<&str> {
        CreateFaqError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFaqError {
    /// Creates a new `CreateFaqError`.
    pub fn new(kind: CreateFaqErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFaqError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFaqErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFaqError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFaqErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFaqErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateFaqErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFaqErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFaqError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFaqErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFaqErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFaqErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFaqErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFaqErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateFaqErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFaqErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFaqErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIndexError {
    /// Kind of error that occurred.
    pub kind: CreateIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIndexErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceAlreadyExistException(crate::error::ResourceAlreadyExistException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ResourceAlreadyExistException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIndexError {
    fn code(&self) -> Option<&str> {
        CreateIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIndexError {
    /// Creates a new `CreateIndexError`.
    pub fn new(kind: CreateIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::ResourceAlreadyExistException`.
    pub fn is_resource_already_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::ResourceAlreadyExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIndexErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIndexErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIndexErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateIndexErrorKind::ResourceAlreadyExistException(_inner) => Some(_inner),
            CreateIndexErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateIndexErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIndexErrorKind::ValidationException(_inner) => Some(_inner),
            CreateIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQuerySuggestionsBlockListError {
    /// Kind of error that occurred.
    pub kind: CreateQuerySuggestionsBlockListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQuerySuggestionsBlockListErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQuerySuggestionsBlockListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateQuerySuggestionsBlockListErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQuerySuggestionsBlockListError {
    fn code(&self) -> Option<&str> {
        CreateQuerySuggestionsBlockListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQuerySuggestionsBlockListError {
    /// Creates a new `CreateQuerySuggestionsBlockListError`.
    pub fn new(
        kind: CreateQuerySuggestionsBlockListErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQuerySuggestionsBlockListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQuerySuggestionsBlockListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuerySuggestionsBlockListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuerySuggestionsBlockListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateQuerySuggestionsBlockListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => Some(_inner),
            CreateQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateQuerySuggestionsBlockListErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => Some(_inner),
            CreateQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThesaurusError {
    /// Kind of error that occurred.
    pub kind: CreateThesaurusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThesaurusErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThesaurusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThesaurusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateThesaurusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThesaurusError {
    fn code(&self) -> Option<&str> {
        CreateThesaurusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThesaurusError {
    /// Creates a new `CreateThesaurusError`.
    pub fn new(kind: CreateThesaurusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThesaurusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThesaurusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThesaurusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThesaurusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThesaurusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateThesaurusErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThesaurusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThesaurusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThesaurusErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateThesaurusErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateThesaurusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateThesaurusErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateThesaurusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThesaurusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::ConflictException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::ValidationException(_inner) => Some(_inner),
            CreateThesaurusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSourceError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSourceError {
    fn code(&self) -> Option<&str> {
        DeleteDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSourceError {
    /// Creates a new `DeleteDataSourceError`.
    pub fn new(kind: DeleteDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExperienceError {
    /// Kind of error that occurred.
    pub kind: DeleteExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExperienceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExperienceError {
    fn code(&self) -> Option<&str> {
        DeleteExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExperienceError {
    /// Creates a new `DeleteExperienceError`.
    pub fn new(kind: DeleteExperienceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteExperienceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExperienceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFaqError {
    /// Kind of error that occurred.
    pub kind: DeleteFaqErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFaqErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFaqError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFaqErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFaqErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFaqError {
    fn code(&self) -> Option<&str> {
        DeleteFaqError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFaqError {
    /// Creates a new `DeleteFaqError`.
    pub fn new(kind: DeleteFaqErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFaqError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFaqErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFaqError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFaqErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFaqErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFaqErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFaqError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFaqErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFaqErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFaqErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFaqErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFaqErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFaqErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFaqErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIndexError {
    /// Kind of error that occurred.
    pub kind: DeleteIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIndexErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIndexError {
    fn code(&self) -> Option<&str> {
        DeleteIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIndexError {
    /// Creates a new `DeleteIndexError`.
    pub fn new(kind: DeleteIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIndexErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIndexErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIndexErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIndexErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePrincipalMappingError {
    /// Kind of error that occurred.
    pub kind: DeletePrincipalMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePrincipalMappingErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePrincipalMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePrincipalMappingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePrincipalMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePrincipalMappingError {
    fn code(&self) -> Option<&str> {
        DeletePrincipalMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePrincipalMappingError {
    /// Creates a new `DeletePrincipalMappingError`.
    pub fn new(kind: DeletePrincipalMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePrincipalMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePrincipalMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePrincipalMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePrincipalMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePrincipalMappingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePrincipalMappingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePrincipalMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePrincipalMappingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePrincipalMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQuerySuggestionsBlockListError {
    /// Kind of error that occurred.
    pub kind: DeleteQuerySuggestionsBlockListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQuerySuggestionsBlockListErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQuerySuggestionsBlockListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQuerySuggestionsBlockListError {
    fn code(&self) -> Option<&str> {
        DeleteQuerySuggestionsBlockListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQuerySuggestionsBlockListError {
    /// Creates a new `DeleteQuerySuggestionsBlockListError`.
    pub fn new(
        kind: DeleteQuerySuggestionsBlockListErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQuerySuggestionsBlockListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQuerySuggestionsBlockListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuerySuggestionsBlockListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuerySuggestionsBlockListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteQuerySuggestionsBlockListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThesaurusError {
    /// Kind of error that occurred.
    pub kind: DeleteThesaurusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThesaurusErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThesaurusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThesaurusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteThesaurusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThesaurusError {
    fn code(&self) -> Option<&str> {
        DeleteThesaurusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThesaurusError {
    /// Creates a new `DeleteThesaurusError`.
    pub fn new(kind: DeleteThesaurusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThesaurusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThesaurusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThesaurusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThesaurusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThesaurusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteThesaurusErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThesaurusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThesaurusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteThesaurusErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteThesaurusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteThesaurusErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteThesaurusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThesaurusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteThesaurusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSourceError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSourceError {
    fn code(&self) -> Option<&str> {
        DescribeDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSourceError {
    /// Creates a new `DescribeDataSourceError`.
    pub fn new(kind: DescribeDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExperienceError {
    /// Kind of error that occurred.
    pub kind: DescribeExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExperienceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeExperienceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeExperienceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeExperienceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeExperienceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExperienceError {
    fn code(&self) -> Option<&str> {
        DescribeExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExperienceError {
    /// Creates a new `DescribeExperienceError`.
    pub fn new(kind: DescribeExperienceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExperienceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeExperienceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeExperienceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeExperienceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeExperienceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFaqError {
    /// Kind of error that occurred.
    pub kind: DescribeFaqErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFaq` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFaqErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFaqError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFaqErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeFaqErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFaqErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFaqErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFaqErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFaqErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFaqError {
    fn code(&self) -> Option<&str> {
        DescribeFaqError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFaqError {
    /// Creates a new `DescribeFaqError`.
    pub fn new(kind: DescribeFaqErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFaqError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFaqErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFaqError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFaqErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFaqErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeFaqErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeFaqErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeFaqErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeFaqErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFaqErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFaqErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeFaqErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeFaqErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeFaqErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeFaqError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFaqErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeFaqErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFaqErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFaqErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFaqErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFaqErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIndexError {
    /// Kind of error that occurred.
    pub kind: DescribeIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIndexErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIndexError {
    fn code(&self) -> Option<&str> {
        DescribeIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIndexError {
    /// Creates a new `DescribeIndexError`.
    pub fn new(kind: DescribeIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeIndexErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePrincipalMappingError {
    /// Kind of error that occurred.
    pub kind: DescribePrincipalMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePrincipalMappingErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePrincipalMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePrincipalMappingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePrincipalMappingErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePrincipalMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePrincipalMappingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePrincipalMappingErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePrincipalMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePrincipalMappingError {
    fn code(&self) -> Option<&str> {
        DescribePrincipalMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePrincipalMappingError {
    /// Creates a new `DescribePrincipalMappingError`.
    pub fn new(kind: DescribePrincipalMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePrincipalMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePrincipalMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePrincipalMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePrincipalMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePrincipalMappingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePrincipalMappingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePrincipalMappingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePrincipalMappingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePrincipalMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePrincipalMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePrincipalMappingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePrincipalMappingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePrincipalMappingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePrincipalMappingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePrincipalMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePrincipalMappingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePrincipalMappingErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePrincipalMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePrincipalMappingErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePrincipalMappingErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePrincipalMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQuerySuggestionsBlockListError {
    /// Kind of error that occurred.
    pub kind: DescribeQuerySuggestionsBlockListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQuerySuggestionsBlockListErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQuerySuggestionsBlockListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQuerySuggestionsBlockListError {
    fn code(&self) -> Option<&str> {
        DescribeQuerySuggestionsBlockListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQuerySuggestionsBlockListError {
    /// Creates a new `DescribeQuerySuggestionsBlockListError`.
    pub fn new(
        kind: DescribeQuerySuggestionsBlockListErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQuerySuggestionsBlockListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQuerySuggestionsBlockListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsBlockListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsBlockListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsBlockListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsBlockListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsBlockListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsBlockListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsBlockListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsBlockListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsBlockListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeQuerySuggestionsBlockListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQuerySuggestionsConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQuerySuggestionsConfigError {
    /// Kind of error that occurred.
    pub kind: DescribeQuerySuggestionsConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQuerySuggestionsConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQuerySuggestionsConfigErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQuerySuggestionsConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQuerySuggestionsConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeQuerySuggestionsConfigErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeQuerySuggestionsConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeQuerySuggestionsConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeQuerySuggestionsConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQuerySuggestionsConfigError {
    fn code(&self) -> Option<&str> {
        DescribeQuerySuggestionsConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQuerySuggestionsConfigError {
    /// Creates a new `DescribeQuerySuggestionsConfigError`.
    pub fn new(
        kind: DescribeQuerySuggestionsConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQuerySuggestionsConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQuerySuggestionsConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQuerySuggestionsConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQuerySuggestionsConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuerySuggestionsConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuerySuggestionsConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeQuerySuggestionsConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQuerySuggestionsConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeQuerySuggestionsConfigErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeQuerySuggestionsConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeQuerySuggestionsConfigErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeQuerySuggestionsConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThesaurusError {
    /// Kind of error that occurred.
    pub kind: DescribeThesaurusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThesaurusErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThesaurusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThesaurusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeThesaurusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeThesaurusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThesaurusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThesaurusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeThesaurusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThesaurusError {
    fn code(&self) -> Option<&str> {
        DescribeThesaurusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThesaurusError {
    /// Creates a new `DescribeThesaurusError`.
    pub fn new(kind: DescribeThesaurusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThesaurusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThesaurusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThesaurusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThesaurusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThesaurusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThesaurusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThesaurusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThesaurusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThesaurusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThesaurusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThesaurusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThesaurusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThesaurusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThesaurusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeThesaurusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThesaurusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeThesaurusErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeThesaurusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThesaurusErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThesaurusErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeThesaurusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateEntitiesFromExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateEntitiesFromExperienceError {
    /// Kind of error that occurred.
    pub kind: DisassociateEntitiesFromExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateEntitiesFromExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateEntitiesFromExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateEntitiesFromExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateEntitiesFromExperienceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateEntitiesFromExperienceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateEntitiesFromExperienceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateEntitiesFromExperienceErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateEntitiesFromExperienceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateEntitiesFromExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateEntitiesFromExperienceError {
    fn code(&self) -> Option<&str> {
        DisassociateEntitiesFromExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateEntitiesFromExperienceError {
    /// Creates a new `DisassociateEntitiesFromExperienceError`.
    pub fn new(
        kind: DisassociateEntitiesFromExperienceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateEntitiesFromExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateEntitiesFromExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateEntitiesFromExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateEntitiesFromExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateEntitiesFromExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEntitiesFromExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateEntitiesFromExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEntitiesFromExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateEntitiesFromExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEntitiesFromExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateEntitiesFromExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEntitiesFromExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateEntitiesFromExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateEntitiesFromExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateEntitiesFromExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateEntitiesFromExperienceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateEntitiesFromExperienceErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateEntitiesFromExperienceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateEntitiesFromExperienceErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateEntitiesFromExperienceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateEntitiesFromExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociatePersonasFromEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociatePersonasFromEntitiesError {
    /// Kind of error that occurred.
    pub kind: DisassociatePersonasFromEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociatePersonasFromEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociatePersonasFromEntitiesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociatePersonasFromEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociatePersonasFromEntitiesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePersonasFromEntitiesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePersonasFromEntitiesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociatePersonasFromEntitiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociatePersonasFromEntitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociatePersonasFromEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociatePersonasFromEntitiesError {
    fn code(&self) -> Option<&str> {
        DisassociatePersonasFromEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociatePersonasFromEntitiesError {
    /// Creates a new `DisassociatePersonasFromEntitiesError`.
    pub fn new(
        kind: DisassociatePersonasFromEntitiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociatePersonasFromEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociatePersonasFromEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociatePersonasFromEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociatePersonasFromEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociatePersonasFromEntitiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePersonasFromEntitiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePersonasFromEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePersonasFromEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePersonasFromEntitiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePersonasFromEntitiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePersonasFromEntitiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePersonasFromEntitiesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociatePersonasFromEntitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociatePersonasFromEntitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociatePersonasFromEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociatePersonasFromEntitiesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociatePersonasFromEntitiesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociatePersonasFromEntitiesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociatePersonasFromEntitiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociatePersonasFromEntitiesErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociatePersonasFromEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQuerySuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQuerySuggestionsError {
    /// Kind of error that occurred.
    pub kind: GetQuerySuggestionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQuerySuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQuerySuggestionsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQuerySuggestionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQuerySuggestionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetQuerySuggestionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQuerySuggestionsError {
    fn code(&self) -> Option<&str> {
        GetQuerySuggestionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQuerySuggestionsError {
    /// Creates a new `GetQuerySuggestionsError`.
    pub fn new(kind: GetQuerySuggestionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQuerySuggestionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQuerySuggestionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQuerySuggestionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQuerySuggestionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQuerySuggestionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQuerySuggestionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetQuerySuggestionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQuerySuggestionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::ConflictException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::ValidationException(_inner) => Some(_inner),
            GetQuerySuggestionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSnapshotsError {
    /// Kind of error that occurred.
    pub kind: GetSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSnapshotsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The input to the request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSnapshotsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSnapshotsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetSnapshotsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSnapshotsError {
    fn code(&self) -> Option<&str> {
        GetSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSnapshotsError {
    /// Creates a new `GetSnapshotsError`.
    pub fn new(kind: GetSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSnapshotsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSnapshotsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSnapshotsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSnapshotsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetSnapshotsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSourcesError {
    /// Kind of error that occurred.
    pub kind: ListDataSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSourcesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSourcesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSourcesError {
    fn code(&self) -> Option<&str> {
        ListDataSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSourcesError {
    /// Creates a new `ListDataSourcesError`.
    pub fn new(kind: ListDataSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDataSourcesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDataSourcesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDataSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSourcesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSourceSyncJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSourceSyncJobsError {
    /// Kind of error that occurred.
    pub kind: ListDataSourceSyncJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSourceSyncJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSourceSyncJobsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSourceSyncJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSourceSyncJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDataSourceSyncJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSourceSyncJobsError {
    fn code(&self) -> Option<&str> {
        ListDataSourceSyncJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSourceSyncJobsError {
    /// Creates a new `ListDataSourceSyncJobsError`.
    pub fn new(kind: ListDataSourceSyncJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSourceSyncJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSourceSyncJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSourceSyncJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSourceSyncJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourceSyncJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourceSyncJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDataSourceSyncJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSourceSyncJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDataSourceSyncJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntityPersonas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntityPersonasError {
    /// Kind of error that occurred.
    pub kind: ListEntityPersonasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntityPersonas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntityPersonasErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntityPersonasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntityPersonasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEntityPersonasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEntityPersonasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEntityPersonasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEntityPersonasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEntityPersonasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntityPersonasError {
    fn code(&self) -> Option<&str> {
        ListEntityPersonasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntityPersonasError {
    /// Creates a new `ListEntityPersonasError`.
    pub fn new(kind: ListEntityPersonasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntityPersonasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntityPersonasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntityPersonasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntityPersonasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntityPersonasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityPersonasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityPersonasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityPersonasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityPersonasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityPersonasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityPersonasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityPersonasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntityPersonasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntityPersonasErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEntityPersonasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntityPersonasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEntityPersonasErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEntityPersonasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEntityPersonasErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEntityPersonasErrorKind::ValidationException(_inner) => Some(_inner),
            ListEntityPersonasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExperienceEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExperienceEntitiesError {
    /// Kind of error that occurred.
    pub kind: ListExperienceEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExperienceEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExperienceEntitiesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExperienceEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExperienceEntitiesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListExperienceEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListExperienceEntitiesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListExperienceEntitiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListExperienceEntitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExperienceEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExperienceEntitiesError {
    fn code(&self) -> Option<&str> {
        ListExperienceEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExperienceEntitiesError {
    /// Creates a new `ListExperienceEntitiesError`.
    pub fn new(kind: ListExperienceEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExperienceEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExperienceEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExperienceEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExperienceEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExperienceEntitiesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperienceEntitiesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperienceEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperienceEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperienceEntitiesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperienceEntitiesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperienceEntitiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperienceEntitiesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperienceEntitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperienceEntitiesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListExperienceEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExperienceEntitiesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListExperienceEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListExperienceEntitiesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListExperienceEntitiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListExperienceEntitiesErrorKind::ValidationException(_inner) => Some(_inner),
            ListExperienceEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExperiences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExperiencesError {
    /// Kind of error that occurred.
    pub kind: ListExperiencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExperiences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExperiencesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExperiencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExperiencesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListExperiencesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListExperiencesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListExperiencesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListExperiencesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExperiencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExperiencesError {
    fn code(&self) -> Option<&str> {
        ListExperiencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExperiencesError {
    /// Creates a new `ListExperiencesError`.
    pub fn new(kind: ListExperiencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExperiencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExperiencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExperiencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExperiencesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExperiencesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperiencesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperiencesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperiencesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperiencesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExperiencesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExperiencesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListExperiencesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListExperiencesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListExperiencesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListExperiencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExperiencesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListExperiencesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListExperiencesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListExperiencesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListExperiencesErrorKind::ValidationException(_inner) => Some(_inner),
            ListExperiencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFaqs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFaqsError {
    /// Kind of error that occurred.
    pub kind: ListFaqsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFaqs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFaqsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFaqsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFaqsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFaqsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFaqsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFaqsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFaqsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFaqsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFaqsError {
    fn code(&self) -> Option<&str> {
        ListFaqsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFaqsError {
    /// Creates a new `ListFaqsError`.
    pub fn new(kind: ListFaqsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFaqsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFaqsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFaqsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFaqsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFaqsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFaqsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFaqsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListFaqsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListFaqsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListFaqsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListFaqsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFaqsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFaqsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFaqsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFaqsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFaqsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFaqsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFaqsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFaqsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFaqsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFaqsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupsOlderThanOrderingId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsOlderThanOrderingIdError {
    /// Kind of error that occurred.
    pub kind: ListGroupsOlderThanOrderingIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupsOlderThanOrderingId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsOlderThanOrderingIdErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsOlderThanOrderingIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsOlderThanOrderingIdErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListGroupsOlderThanOrderingIdErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListGroupsOlderThanOrderingIdErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListGroupsOlderThanOrderingIdErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListGroupsOlderThanOrderingIdErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGroupsOlderThanOrderingIdErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListGroupsOlderThanOrderingIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsOlderThanOrderingIdError {
    fn code(&self) -> Option<&str> {
        ListGroupsOlderThanOrderingIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsOlderThanOrderingIdError {
    /// Creates a new `ListGroupsOlderThanOrderingIdError`.
    pub fn new(
        kind: ListGroupsOlderThanOrderingIdErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsOlderThanOrderingIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsOlderThanOrderingIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsOlderThanOrderingIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsOlderThanOrderingIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsOlderThanOrderingIdErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsOlderThanOrderingIdErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListGroupsOlderThanOrderingIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsOlderThanOrderingIdErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListGroupsOlderThanOrderingIdErrorKind::ConflictException(_inner) => Some(_inner),
            ListGroupsOlderThanOrderingIdErrorKind::InternalServerException(_inner) => Some(_inner),
            ListGroupsOlderThanOrderingIdErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListGroupsOlderThanOrderingIdErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGroupsOlderThanOrderingIdErrorKind::ValidationException(_inner) => Some(_inner),
            ListGroupsOlderThanOrderingIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIndicesError {
    /// Kind of error that occurred.
    pub kind: ListIndicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIndicesErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIndicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIndicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIndicesError {
    fn code(&self) -> Option<&str> {
        ListIndicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIndicesError {
    /// Creates a new `ListIndicesError`.
    pub fn new(kind: ListIndicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIndicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIndicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIndicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIndicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListIndicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIndicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIndicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListIndicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIndicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListIndicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQuerySuggestionsBlockLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQuerySuggestionsBlockListsError {
    /// Kind of error that occurred.
    pub kind: ListQuerySuggestionsBlockListsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQuerySuggestionsBlockLists` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQuerySuggestionsBlockListsErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQuerySuggestionsBlockListsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQuerySuggestionsBlockListsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListQuerySuggestionsBlockListsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListQuerySuggestionsBlockListsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListQuerySuggestionsBlockListsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListQuerySuggestionsBlockListsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListQuerySuggestionsBlockListsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQuerySuggestionsBlockListsError {
    fn code(&self) -> Option<&str> {
        ListQuerySuggestionsBlockListsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQuerySuggestionsBlockListsError {
    /// Creates a new `ListQuerySuggestionsBlockListsError`.
    pub fn new(
        kind: ListQuerySuggestionsBlockListsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQuerySuggestionsBlockListsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQuerySuggestionsBlockListsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQuerySuggestionsBlockListsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQuerySuggestionsBlockListsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQuerySuggestionsBlockListsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuerySuggestionsBlockListsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuerySuggestionsBlockListsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuerySuggestionsBlockListsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuerySuggestionsBlockListsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuerySuggestionsBlockListsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuerySuggestionsBlockListsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuerySuggestionsBlockListsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuerySuggestionsBlockListsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuerySuggestionsBlockListsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListQuerySuggestionsBlockListsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQuerySuggestionsBlockListsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListQuerySuggestionsBlockListsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListQuerySuggestionsBlockListsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListQuerySuggestionsBlockListsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListQuerySuggestionsBlockListsErrorKind::ValidationException(_inner) => Some(_inner),
            ListQuerySuggestionsBlockListsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListThesauri` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListThesauriError {
    /// Kind of error that occurred.
    pub kind: ListThesauriErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListThesauri` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListThesauriErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListThesauriError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListThesauriErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListThesauriErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListThesauriErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListThesauriErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListThesauriErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListThesauriErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListThesauriError {
    fn code(&self) -> Option<&str> {
        ListThesauriError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListThesauriError {
    /// Creates a new `ListThesauriError`.
    pub fn new(kind: ListThesauriErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListThesauriError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListThesauriErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListThesauriError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListThesauriErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListThesauriErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListThesauriErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListThesauriErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThesauriErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThesauriErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThesauriErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThesauriErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListThesauriErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListThesauriErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListThesauriErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListThesauriError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListThesauriErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListThesauriErrorKind::InternalServerException(_inner) => Some(_inner),
            ListThesauriErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListThesauriErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListThesauriErrorKind::ValidationException(_inner) => Some(_inner),
            ListThesauriErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPrincipalMappingError {
    /// Kind of error that occurred.
    pub kind: PutPrincipalMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPrincipalMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPrincipalMappingErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPrincipalMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPrincipalMappingErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutPrincipalMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPrincipalMappingError {
    fn code(&self) -> Option<&str> {
        PutPrincipalMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPrincipalMappingError {
    /// Creates a new `PutPrincipalMappingError`.
    pub fn new(kind: PutPrincipalMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPrincipalMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPrincipalMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPrincipalMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPrincipalMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPrincipalMappingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPrincipalMappingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutPrincipalMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPrincipalMappingErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::ConflictException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::InternalServerException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::ValidationException(_inner) => Some(_inner),
            PutPrincipalMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Query` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct QueryError {
    /// Kind of error that occurred.
    pub kind: QueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Query` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum QueryErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for QueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            QueryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            QueryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            QueryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            QueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            QueryErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            QueryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            QueryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            QueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for QueryError {
    fn code(&self) -> Option<&str> {
        QueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl QueryError {
    /// Creates a new `QueryError`.
    pub fn new(kind: QueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `QueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: QueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `QueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: QueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `QueryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ServiceQuotaExceededException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for QueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            QueryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            QueryErrorKind::ConflictException(_inner) => Some(_inner),
            QueryErrorKind::InternalServerException(_inner) => Some(_inner),
            QueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            QueryErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            QueryErrorKind::ThrottlingException(_inner) => Some(_inner),
            QueryErrorKind::ValidationException(_inner) => Some(_inner),
            QueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDataSourceSyncJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDataSourceSyncJobError {
    /// Kind of error that occurred.
    pub kind: StartDataSourceSyncJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDataSourceSyncJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDataSourceSyncJobErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDataSourceSyncJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDataSourceSyncJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartDataSourceSyncJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDataSourceSyncJobError {
    fn code(&self) -> Option<&str> {
        StartDataSourceSyncJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDataSourceSyncJobError {
    /// Creates a new `StartDataSourceSyncJobError`.
    pub fn new(kind: StartDataSourceSyncJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDataSourceSyncJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDataSourceSyncJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDataSourceSyncJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDataSourceSyncJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartDataSourceSyncJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDataSourceSyncJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartDataSourceSyncJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDataSourceSyncJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::ConflictException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::ResourceInUseException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartDataSourceSyncJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDataSourceSyncJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDataSourceSyncJobError {
    /// Kind of error that occurred.
    pub kind: StopDataSourceSyncJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDataSourceSyncJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDataSourceSyncJobErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDataSourceSyncJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDataSourceSyncJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopDataSourceSyncJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopDataSourceSyncJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopDataSourceSyncJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopDataSourceSyncJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopDataSourceSyncJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDataSourceSyncJobError {
    fn code(&self) -> Option<&str> {
        StopDataSourceSyncJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDataSourceSyncJobError {
    /// Creates a new `StopDataSourceSyncJobError`.
    pub fn new(kind: StopDataSourceSyncJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDataSourceSyncJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDataSourceSyncJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDataSourceSyncJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDataSourceSyncJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDataSourceSyncJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDataSourceSyncJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDataSourceSyncJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDataSourceSyncJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDataSourceSyncJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDataSourceSyncJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDataSourceSyncJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDataSourceSyncJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StopDataSourceSyncJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopDataSourceSyncJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StopDataSourceSyncJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDataSourceSyncJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopDataSourceSyncJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopDataSourceSyncJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopDataSourceSyncJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopDataSourceSyncJobErrorKind::ValidationException(_inner) => Some(_inner),
            StopDataSourceSyncJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitFeedbackError {
    /// Kind of error that occurred.
    pub kind: SubmitFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitFeedbackErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitFeedbackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SubmitFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitFeedbackError {
    fn code(&self) -> Option<&str> {
        SubmitFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubmitFeedbackError {
    /// Creates a new `SubmitFeedbackError`.
    pub fn new(kind: SubmitFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitFeedbackErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SubmitFeedbackErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SubmitFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SubmitFeedbackErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SubmitFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitFeedbackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ThrottlingException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            SubmitFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSourceError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSourceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSourceError {
    fn code(&self) -> Option<&str> {
        UpdateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSourceError {
    /// Creates a new `UpdateDataSourceError`.
    pub fn new(kind: UpdateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateExperienceError {
    /// Kind of error that occurred.
    pub kind: UpdateExperienceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateExperience` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateExperienceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateExperienceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateExperienceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateExperienceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateExperienceError {
    fn code(&self) -> Option<&str> {
        UpdateExperienceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateExperienceError {
    /// Creates a new `UpdateExperienceError`.
    pub fn new(kind: UpdateExperienceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateExperienceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateExperienceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateExperienceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateExperienceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperienceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateExperienceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperienceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperienceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperienceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExperienceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExperienceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateExperienceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateExperienceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateExperienceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIndexError {
    /// Kind of error that occurred.
    pub kind: UpdateIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIndexErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIndexErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIndexError {
    fn code(&self) -> Option<&str> {
        UpdateIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIndexError {
    /// Creates a new `UpdateIndexError`.
    pub fn new(kind: UpdateIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateIndexErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateIndexErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateIndexErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIndexErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateIndexErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateIndexErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateIndexErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIndexErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateIndexErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIndexErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIndexErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateIndexErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIndexErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQuerySuggestionsBlockListError {
    /// Kind of error that occurred.
    pub kind: UpdateQuerySuggestionsBlockListErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQuerySuggestionsBlockList` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQuerySuggestionsBlockListErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQuerySuggestionsBlockListError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQuerySuggestionsBlockListError {
    fn code(&self) -> Option<&str> {
        UpdateQuerySuggestionsBlockListError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQuerySuggestionsBlockListError {
    /// Creates a new `UpdateQuerySuggestionsBlockListError`.
    pub fn new(
        kind: UpdateQuerySuggestionsBlockListErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQuerySuggestionsBlockListError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQuerySuggestionsBlockListError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQuerySuggestionsBlockListErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsBlockListErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsBlockListErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateQuerySuggestionsBlockListError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQuerySuggestionsBlockListErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateQuerySuggestionsBlockListErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateQuerySuggestionsBlockListErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateQuerySuggestionsBlockListErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateQuerySuggestionsBlockListErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQuerySuggestionsBlockListErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateQuerySuggestionsBlockListErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQuerySuggestionsConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQuerySuggestionsConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateQuerySuggestionsConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQuerySuggestionsConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQuerySuggestionsConfigErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQuerySuggestionsConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQuerySuggestionsConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsConfigErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQuerySuggestionsConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateQuerySuggestionsConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQuerySuggestionsConfigError {
    fn code(&self) -> Option<&str> {
        UpdateQuerySuggestionsConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQuerySuggestionsConfigError {
    /// Creates a new `UpdateQuerySuggestionsConfigError`.
    pub fn new(kind: UpdateQuerySuggestionsConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQuerySuggestionsConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQuerySuggestionsConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQuerySuggestionsConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQuerySuggestionsConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuerySuggestionsConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuerySuggestionsConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateQuerySuggestionsConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQuerySuggestionsConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateQuerySuggestionsConfigErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateQuerySuggestionsConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateQuerySuggestionsConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateQuerySuggestionsConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQuerySuggestionsConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateQuerySuggestionsConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThesaurusError {
    /// Kind of error that occurred.
    pub kind: UpdateThesaurusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateThesaurus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThesaurusErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThesaurusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThesaurusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateThesaurusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThesaurusError {
    fn code(&self) -> Option<&str> {
        UpdateThesaurusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThesaurusError {
    /// Creates a new `UpdateThesaurusError`.
    pub fn new(kind: UpdateThesaurusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThesaurusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThesaurusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThesaurusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThesaurusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThesaurusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateThesaurusErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThesaurusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThesaurusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateThesaurusErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateThesaurusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateThesaurusErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateThesaurusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThesaurusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateThesaurusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceUnavailableException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceUnavailableException {}
/// See [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
pub mod resource_unavailable_exception {
    /// A builder for [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
        pub fn build(self) -> crate::error::ResourceUnavailableException {
            crate::error::ResourceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ResourceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    pub fn builder() -> crate::error::resource_unavailable_exception::Builder {
        crate::error::resource_unavailable_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The input to the request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistException {}
/// See [`ResourceAlreadyExistException`](crate::error::ResourceAlreadyExistException)
pub mod resource_already_exist_exception {
    /// A builder for [`ResourceAlreadyExistException`](crate::error::ResourceAlreadyExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistException`](crate::error::ResourceAlreadyExistException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistException {
            crate::error::ResourceAlreadyExistException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistException`](crate::error::ResourceAlreadyExistException)
    pub fn builder() -> crate::error::resource_already_exist_exception::Builder {
        crate::error::resource_already_exist_exception::Builder::default()
    }
}
