// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateEntitiesToExperienceInput`](crate::input::AssociateEntitiesToExperienceInput)
pub mod associate_entities_to_experience_input {
    /// A builder for [`AssociateEntitiesToExperienceInput`](crate::input::AssociateEntitiesToExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) entity_list:
            std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `entity_list`.
        ///
        /// To override the contents of this collection use [`set_entity_list`](Self::set_entity_list).
        ///
        /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
        pub fn entity_list(mut self, input: crate::model::EntityConfiguration) -> Self {
            let mut v = self.entity_list.unwrap_or_default();
            v.push(input);
            self.entity_list = Some(v);
            self
        }
        /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
        pub fn set_entity_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
        ) -> Self {
            self.entity_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateEntitiesToExperienceInput`](crate::input::AssociateEntitiesToExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateEntitiesToExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateEntitiesToExperienceInput {
                id: self.id,
                index_id: self.index_id,
                entity_list: self.entity_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateEntitiesToExperienceInputOperationOutputAlias =
    crate::operation::AssociateEntitiesToExperience;
#[doc(hidden)]
pub type AssociateEntitiesToExperienceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateEntitiesToExperienceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateEntitiesToExperience`](crate::operation::AssociateEntitiesToExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateEntitiesToExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateEntitiesToExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateEntitiesToExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateEntitiesToExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.AssociateEntitiesToExperience",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_entities_to_experience(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateEntitiesToExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateEntitiesToExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateEntitiesToExperienceInput`](crate::input::AssociateEntitiesToExperienceInput)
    pub fn builder() -> crate::input::associate_entities_to_experience_input::Builder {
        crate::input::associate_entities_to_experience_input::Builder::default()
    }
}

/// See [`AssociatePersonasToEntitiesInput`](crate::input::AssociatePersonasToEntitiesInput)
pub mod associate_personas_to_entities_input {
    /// A builder for [`AssociatePersonasToEntitiesInput`](crate::input::AssociatePersonasToEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) personas:
            std::option::Option<std::vec::Vec<crate::model::EntityPersonaConfiguration>>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `personas`.
        ///
        /// To override the contents of this collection use [`set_personas`](Self::set_personas).
        ///
        /// <p>The personas that define the specific permissions of users or groups in your Amazon Web Services SSO identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>
        pub fn personas(mut self, input: crate::model::EntityPersonaConfiguration) -> Self {
            let mut v = self.personas.unwrap_or_default();
            v.push(input);
            self.personas = Some(v);
            self
        }
        /// <p>The personas that define the specific permissions of users or groups in your Amazon Web Services SSO identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>
        pub fn set_personas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityPersonaConfiguration>>,
        ) -> Self {
            self.personas = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatePersonasToEntitiesInput`](crate::input::AssociatePersonasToEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociatePersonasToEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociatePersonasToEntitiesInput {
                id: self.id,
                index_id: self.index_id,
                personas: self.personas,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociatePersonasToEntitiesInputOperationOutputAlias =
    crate::operation::AssociatePersonasToEntities;
#[doc(hidden)]
pub type AssociatePersonasToEntitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociatePersonasToEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`AssociatePersonasToEntities`](crate::operation::AssociatePersonasToEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociatePersonasToEntities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociatePersonasToEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociatePersonasToEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociatePersonasToEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.AssociatePersonasToEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_personas_to_entities(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociatePersonasToEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociatePersonasToEntities",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociatePersonasToEntitiesInput`](crate::input::AssociatePersonasToEntitiesInput)
    pub fn builder() -> crate::input::associate_personas_to_entities_input::Builder {
        crate::input::associate_personas_to_entities_input::Builder::default()
    }
}

/// See [`BatchDeleteDocumentInput`](crate::input::BatchDeleteDocumentInput)
pub mod batch_delete_document_input {
    /// A builder for [`BatchDeleteDocumentInput`](crate::input::BatchDeleteDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) document_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_source_sync_job_metric_target:
            std::option::Option<crate::model::DataSourceSyncJobMetricTarget>,
    }
    impl Builder {
        /// <p>The identifier of the index that contains the documents to delete.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the documents to delete.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `document_id_list`.
        ///
        /// To override the contents of this collection use [`set_document_id_list`](Self::set_document_id_list).
        ///
        /// <p>One or more identifiers for documents to delete from the index.</p>
        pub fn document_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.document_id_list.unwrap_or_default();
            v.push(input.into());
            self.document_id_list = Some(v);
            self
        }
        /// <p>One or more identifiers for documents to delete from the index.</p>
        pub fn set_document_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.document_id_list = input;
            self
        }
        /// <p>Maps a particular data source sync job to a particular data source.</p>
        pub fn data_source_sync_job_metric_target(
            mut self,
            input: crate::model::DataSourceSyncJobMetricTarget,
        ) -> Self {
            self.data_source_sync_job_metric_target = Some(input);
            self
        }
        /// <p>Maps a particular data source sync job to a particular data source.</p>
        pub fn set_data_source_sync_job_metric_target(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobMetricTarget>,
        ) -> Self {
            self.data_source_sync_job_metric_target = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDocumentInput`](crate::input::BatchDeleteDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteDocumentInput {
                index_id: self.index_id,
                document_id_list: self.document_id_list,
                data_source_sync_job_metric_target: self.data_source_sync_job_metric_target,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteDocumentInputOperationOutputAlias = crate::operation::BatchDeleteDocument;
#[doc(hidden)]
pub type BatchDeleteDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteDocumentInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteDocument`](crate::operation::BatchDeleteDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.BatchDeleteDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteDocument",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteDocumentInput`](crate::input::BatchDeleteDocumentInput)
    pub fn builder() -> crate::input::batch_delete_document_input::Builder {
        crate::input::batch_delete_document_input::Builder::default()
    }
}

/// See [`BatchGetDocumentStatusInput`](crate::input::BatchGetDocumentStatusInput)
pub mod batch_get_document_status_input {
    /// A builder for [`BatchGetDocumentStatusInput`](crate::input::BatchGetDocumentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) document_info_list:
            std::option::Option<std::vec::Vec<crate::model::DocumentInfo>>,
    }
    impl Builder {
        /// <p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex </a> operation.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex </a> operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `document_info_list`.
        ///
        /// To override the contents of this collection use [`set_document_info_list`](Self::set_document_info_list).
        ///
        /// <p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>
        pub fn document_info_list(mut self, input: crate::model::DocumentInfo) -> Self {
            let mut v = self.document_info_list.unwrap_or_default();
            v.push(input);
            self.document_info_list = Some(v);
            self
        }
        /// <p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>
        pub fn set_document_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentInfo>>,
        ) -> Self {
            self.document_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDocumentStatusInput`](crate::input::BatchGetDocumentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDocumentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDocumentStatusInput {
                index_id: self.index_id,
                document_info_list: self.document_info_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDocumentStatusInputOperationOutputAlias = crate::operation::BatchGetDocumentStatus;
#[doc(hidden)]
pub type BatchGetDocumentStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDocumentStatusInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDocumentStatus`](crate::operation::BatchGetDocumentStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDocumentStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetDocumentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetDocumentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetDocumentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.BatchGetDocumentStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_document_status(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDocumentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDocumentStatus",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDocumentStatusInput`](crate::input::BatchGetDocumentStatusInput)
    pub fn builder() -> crate::input::batch_get_document_status_input::Builder {
        crate::input::batch_get_document_status_input::Builder::default()
    }
}

/// See [`BatchPutDocumentInput`](crate::input::BatchPutDocumentInput)
pub mod batch_put_document_input {
    /// A builder for [`BatchPutDocumentInput`](crate::input::BatchPutDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) documents: std::option::Option<std::vec::Vec<crate::model::Document>>,
        pub(crate) custom_document_enrichment_configuration:
            std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> operation.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `documents`.
        ///
        /// To override the contents of this collection use [`set_documents`](Self::set_documents).
        ///
        /// <p>One or more documents to add to the index.</p>
        /// <p>Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p>
        /// <p>Documents have the following file size limits.</p>
        /// <ul>
        /// <li> <p>5 MB total size for inline documents</p> </li>
        /// <li> <p>50 MB total size for files from an S3 bucket</p> </li>
        /// <li> <p>5 MB extracted text for any file</p> </li>
        /// </ul>
        /// <p>For more information about file size and transaction per second quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn documents(mut self, input: crate::model::Document) -> Self {
            let mut v = self.documents.unwrap_or_default();
            v.push(input);
            self.documents = Some(v);
            self
        }
        /// <p>One or more documents to add to the index.</p>
        /// <p>Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p>
        /// <p>Documents have the following file size limits.</p>
        /// <ul>
        /// <li> <p>5 MB total size for inline documents</p> </li>
        /// <li> <p>50 MB total size for files from an S3 bucket</p> </li>
        /// <li> <p>5 MB extracted text for any file</p> </li>
        /// </ul>
        /// <p>For more information about file size and transaction per second quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn set_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Document>>,
        ) -> Self {
            self.documents = input;
            self
        }
        /// <p>Configuration information for altering your document metadata and content during the document ingestion process when you use the <code>BatchPutDocument</code> operation.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn custom_document_enrichment_configuration(
            mut self,
            input: crate::model::CustomDocumentEnrichmentConfiguration,
        ) -> Self {
            self.custom_document_enrichment_configuration = Some(input);
            self
        }
        /// <p>Configuration information for altering your document metadata and content during the document ingestion process when you use the <code>BatchPutDocument</code> operation.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn set_custom_document_enrichment_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
        ) -> Self {
            self.custom_document_enrichment_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutDocumentInput`](crate::input::BatchPutDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutDocumentInput {
                index_id: self.index_id,
                role_arn: self.role_arn,
                documents: self.documents,
                custom_document_enrichment_configuration: self
                    .custom_document_enrichment_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutDocumentInputOperationOutputAlias = crate::operation::BatchPutDocument;
#[doc(hidden)]
pub type BatchPutDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchPutDocumentInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutDocument`](crate::operation::BatchPutDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchPutDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchPutDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchPutDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.BatchPutDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_put_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutDocument",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchPutDocumentInput`](crate::input::BatchPutDocumentInput)
    pub fn builder() -> crate::input::batch_put_document_input::Builder {
        crate::input::batch_put_document_input::Builder::default()
    }
}

/// See [`ClearQuerySuggestionsInput`](crate::input::ClearQuerySuggestionsInput)
pub mod clear_query_suggestions_input {
    /// A builder for [`ClearQuerySuggestionsInput`](crate::input::ClearQuerySuggestionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to clear query suggestions from.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to clear query suggestions from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ClearQuerySuggestionsInput`](crate::input::ClearQuerySuggestionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClearQuerySuggestionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClearQuerySuggestionsInput {
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ClearQuerySuggestionsInputOperationOutputAlias = crate::operation::ClearQuerySuggestions;
#[doc(hidden)]
pub type ClearQuerySuggestionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ClearQuerySuggestionsInput {
    /// Consumes the builder and constructs an Operation<[`ClearQuerySuggestions`](crate::operation::ClearQuerySuggestions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClearQuerySuggestions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ClearQuerySuggestionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ClearQuerySuggestionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ClearQuerySuggestionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ClearQuerySuggestions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_clear_query_suggestions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClearQuerySuggestions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClearQuerySuggestions",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ClearQuerySuggestionsInput`](crate::input::ClearQuerySuggestionsInput)
    pub fn builder() -> crate::input::clear_query_suggestions_input::Builder {
        crate::input::clear_query_suggestions_input::Builder::default()
    }
}

/// See [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
pub mod create_data_source_input {
    /// A builder for [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) configuration: std::option::Option<crate::model::DataSourceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) custom_document_enrichment_configuration:
            std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
    }
    impl Builder {
        /// <p>A unique name for the data source. A data source name can't be changed without deleting and recreating the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the data source. A data source name can't be changed without deleting and recreating the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the index that should be associated with this data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that should be associated with this data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The type of repository that contains the data source.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of repository that contains the data source.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The connector configuration information that is required to access the repository.</p>
        /// <p>You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>Configuration</code> parameter is required for all other data sources.</p>
        pub fn configuration(mut self, input: crate::model::DataSourceConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The connector configuration information that is required to access the repository.</p>
        /// <p>You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>Configuration</code> parameter is required for all other data sources.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>A description for the data source.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> operation to update the index.</p>
        /// <p>You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> operation to update the index.</p>
        /// <p>You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        /// <p>You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        /// <p>You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A token that you provide to identify the request to create a data source. Multiple calls to the <code>CreateDataSource</code> operation with the same client token will create only one data source.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create a data source. Multiple calls to the <code>CreateDataSource</code> operation with the same client token will create only one data source.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The code for a language. This allows you to support a language for all documents when creating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for a language. This allows you to support a language for all documents when creating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>Configuration information for altering document metadata and content during the document ingestion process when you create a data source.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn custom_document_enrichment_configuration(
            mut self,
            input: crate::model::CustomDocumentEnrichmentConfiguration,
        ) -> Self {
            self.custom_document_enrichment_configuration = Some(input);
            self
        }
        /// <p>Configuration information for altering document metadata and content during the document ingestion process when you create a data source.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn set_custom_document_enrichment_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
        ) -> Self {
            self.custom_document_enrichment_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceInput {
                name: self.name,
                index_id: self.index_id,
                r#type: self.r#type,
                configuration: self.configuration,
                description: self.description,
                schedule: self.schedule,
                role_arn: self.role_arn,
                tags: self.tags,
                client_token: self.client_token,
                language_code: self.language_code,
                custom_document_enrichment_configuration: self
                    .custom_document_enrichment_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceInputOperationOutputAlias = crate::operation::CreateDataSource;
#[doc(hidden)]
pub type CreateDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSource`](crate::operation::CreateDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateDataSource",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
}

/// See [`CreateExperienceInput`](crate::input::CreateExperienceInput)
pub mod create_experience_input {
    /// A builder for [`CreateExperienceInput`](crate::input::CreateExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ExperienceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for your Amazon Kendra experience.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for your Amazon Kendra experience.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides the configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>
        pub fn configuration(mut self, input: crate::model::ExperienceConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Provides the configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ExperienceConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>A description for your Amazon Kendra experience.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for your Amazon Kendra experience.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the <code>CreateExperience</code> operation with the same client token creates only one Amazon Kendra experience.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the <code>CreateExperience</code> operation with the same client token creates only one Amazon Kendra experience.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperienceInput`](crate::input::CreateExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExperienceInput {
                name: self.name,
                index_id: self.index_id,
                role_arn: self.role_arn,
                configuration: self.configuration,
                description: self.description,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExperienceInputOperationOutputAlias = crate::operation::CreateExperience;
#[doc(hidden)]
pub type CreateExperienceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateExperienceInput {
    /// Consumes the builder and constructs an Operation<[`CreateExperience`](crate::operation::CreateExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateExperience",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_experience(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateExperienceInput`](crate::input::CreateExperienceInput)
    pub fn builder() -> crate::input::create_experience_input::Builder {
        crate::input::create_experience_input::Builder::default()
    }
}

/// See [`CreateFaqInput`](crate::input::CreateFaqInput)
pub mod create_faq_input {
    /// A builder for [`CreateFaqInput`](crate::input::CreateFaqInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) s3_path: std::option::Option<crate::model::S3Path>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_format: std::option::Option<crate::model::FaqFileFormat>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The name that should be associated with the FAQ.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that should be associated with the FAQ.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the FAQ.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the FAQ.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The S3 location of the FAQ input data.</p>
        pub fn s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.s3_path = Some(input);
            self
        }
        /// <p>The S3 location of the FAQ input data.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<crate::model::S3Path>) -> Self {
            self.s3_path = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
        /// <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>
        pub fn file_format(mut self, input: crate::model::FaqFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
        /// <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FaqFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> operation with the same client token will create only one FAQ. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> operation with the same client token will create only one FAQ. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFaqInput`](crate::input::CreateFaqInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateFaqInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateFaqInput {
                index_id: self.index_id,
                name: self.name,
                description: self.description,
                s3_path: self.s3_path,
                role_arn: self.role_arn,
                tags: self.tags,
                file_format: self.file_format,
                client_token: self.client_token,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFaqInputOperationOutputAlias = crate::operation::CreateFaq;
#[doc(hidden)]
pub type CreateFaqInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFaqInput {
    /// Consumes the builder and constructs an Operation<[`CreateFaq`](crate::operation::CreateFaq)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFaq,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFaqInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFaqInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFaqInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateFaq",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_faq(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateFaq::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateFaq",
                    "kendra",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFaqInput`](crate::input::CreateFaqInput)
    pub fn builder() -> crate::input::create_faq_input::Builder {
        crate::input::create_faq_input::Builder::default()
    }
}

/// See [`CreateIndexInput`](crate::input::CreateIndexInput)
pub mod create_index_input {
    /// A builder for [`CreateIndexInput`](crate::input::CreateIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) edition: std::option::Option<crate::model::IndexEdition>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) user_token_configurations:
            std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        pub(crate) user_context_policy: std::option::Option<crate::model::UserContextPolicy>,
        pub(crate) user_group_resolution_configuration:
            std::option::Option<crate::model::UserGroupResolutionConfiguration>,
    }
    impl Builder {
        /// <p>The name for the new index.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new index.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases. Once you set the edition for an index, it can't be changed.</p>
        /// <p>The <code>Edition</code> parameter is optional. If you don't supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p>
        /// <p>For more information on quota limits for enterprise and developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn edition(mut self, input: crate::model::IndexEdition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases. Once you set the edition for an index, it can't be changed.</p>
        /// <p>The <code>Edition</code> parameter is optional. If you don't supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p>
        /// <p>For more information on quota limits for enterprise and developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::IndexEdition>,
        ) -> Self {
            self.edition = input;
            self
        }
        /// <p>An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> operation to index documents from an Amazon S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> operation to index documents from an Amazon S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>A description for the index.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the index.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> operation with the same client token will create only one index.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> operation with the same client token will create only one index.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `user_token_configurations`.
        ///
        /// To override the contents of this collection use [`set_user_token_configurations`](Self::set_user_token_configurations).
        ///
        /// <p>The user token configuration.</p>
        pub fn user_token_configurations(
            mut self,
            input: crate::model::UserTokenConfiguration,
        ) -> Self {
            let mut v = self.user_token_configurations.unwrap_or_default();
            v.push(input);
            self.user_token_configurations = Some(v);
            self
        }
        /// <p>The user token configuration.</p>
        pub fn set_user_token_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        ) -> Self {
            self.user_token_configurations = input;
            self
        }
        /// <p>The user context policy.</p>
        /// <dl>
        /// <dt>
        /// ATTRIBUTE_FILTER
        /// </dt>
        /// <dd>
        /// <p>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>. </p>
        /// </dd>
        /// <dt>
        /// USER_TOKEN
        /// </dt>
        /// <dd>
        /// <p>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p>
        /// </dd>
        /// </dl>
        pub fn user_context_policy(mut self, input: crate::model::UserContextPolicy) -> Self {
            self.user_context_policy = Some(input);
            self
        }
        /// <p>The user context policy.</p>
        /// <dl>
        /// <dt>
        /// ATTRIBUTE_FILTER
        /// </dt>
        /// <dd>
        /// <p>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>. </p>
        /// </dd>
        /// <dt>
        /// USER_TOKEN
        /// </dt>
        /// <dd>
        /// <p>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p>
        /// </dd>
        /// </dl>
        pub fn set_user_context_policy(
            mut self,
            input: std::option::Option<crate::model::UserContextPolicy>,
        ) -> Self {
            self.user_context_policy = input;
            self
        }
        /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn user_group_resolution_configuration(
            mut self,
            input: crate::model::UserGroupResolutionConfiguration,
        ) -> Self {
            self.user_group_resolution_configuration = Some(input);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn set_user_group_resolution_configuration(
            mut self,
            input: std::option::Option<crate::model::UserGroupResolutionConfiguration>,
        ) -> Self {
            self.user_group_resolution_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIndexInput`](crate::input::CreateIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIndexInput {
                name: self.name,
                edition: self.edition,
                role_arn: self.role_arn,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                description: self.description,
                client_token: self.client_token,
                tags: self.tags,
                user_token_configurations: self.user_token_configurations,
                user_context_policy: self.user_context_policy,
                user_group_resolution_configuration: self.user_group_resolution_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIndexInputOperationOutputAlias = crate::operation::CreateIndex;
#[doc(hidden)]
pub type CreateIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIndexInput {
    /// Consumes the builder and constructs an Operation<[`CreateIndex`](crate::operation::CreateIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateIndex",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIndex",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIndexInput`](crate::input::CreateIndexInput)
    pub fn builder() -> crate::input::create_index_input::Builder {
        crate::input::create_index_input::Builder::default()
    }
}

/// See [`CreateQuerySuggestionsBlockListInput`](crate::input::CreateQuerySuggestionsBlockListInput)
pub mod create_query_suggestions_block_list_input {
    /// A builder for [`CreateQuerySuggestionsBlockListInput`](crate::input::CreateQuerySuggestionsBlockListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_s3_path: std::option::Option<crate::model::S3Path>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>A user friendly name for the block list.</p>
        /// <p>For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user friendly name for the block list.</p>
        /// <p>For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A user-friendly description for the block list.</p>
        /// <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-friendly description for the block list.</p>
        /// <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The S3 path to your block list text file in your S3 bucket.</p>
        /// <p>Each block word or phrase should be on a separate line in a text file.</p>
        /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
        pub fn source_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.source_s3_path = Some(input);
            self
        }
        /// <p>The S3 path to your block list text file in your S3 bucket.</p>
        /// <p>Each block word or phrase should be on a separate line in a text file.</p>
        /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.source_s3_path = input;
            self
        }
        /// <p>A token that you provide to identify the request to create a query suggestions block list.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create a query suggestions block list.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.</p>
        /// <p>You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.</p>
        /// <p>You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A tag that you can assign to a block list that categorizes the block list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A tag that you can assign to a block list that categorizes the block list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQuerySuggestionsBlockListInput`](crate::input::CreateQuerySuggestionsBlockListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateQuerySuggestionsBlockListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateQuerySuggestionsBlockListInput {
                index_id: self.index_id,
                name: self.name,
                description: self.description,
                source_s3_path: self.source_s3_path,
                client_token: self.client_token,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateQuerySuggestionsBlockListInputOperationOutputAlias =
    crate::operation::CreateQuerySuggestionsBlockList;
#[doc(hidden)]
pub type CreateQuerySuggestionsBlockListInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateQuerySuggestionsBlockListInput {
    /// Consumes the builder and constructs an Operation<[`CreateQuerySuggestionsBlockList`](crate::operation::CreateQuerySuggestionsBlockList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateQuerySuggestionsBlockList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateQuerySuggestionsBlockListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateQuerySuggestionsBlockListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateQuerySuggestionsBlockListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateQuerySuggestionsBlockList",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_query_suggestions_block_list(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateQuerySuggestionsBlockList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateQuerySuggestionsBlockList",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateQuerySuggestionsBlockListInput`](crate::input::CreateQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::create_query_suggestions_block_list_input::Builder {
        crate::input::create_query_suggestions_block_list_input::Builder::default()
    }
}

/// See [`CreateThesaurusInput`](crate::input::CreateThesaurusInput)
pub mod create_thesaurus_input {
    /// A builder for [`CreateThesaurusInput`](crate::input::CreateThesaurusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) source_s3_path: std::option::Option<crate::model::S3Path>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the index for the new thesaurus. </p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the index for the new thesaurus. </p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The name for the new thesaurus.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new thesaurus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for the new thesaurus.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the new thesaurus.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The thesaurus file Amazon S3 source path. </p>
        pub fn source_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.source_s3_path = Some(input);
            self
        }
        /// <p>The thesaurus file Amazon S3 source path. </p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.source_s3_path = input;
            self
        }
        /// <p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation with the same client token will create only one thesaurus. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation with the same client token will create only one thesaurus. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThesaurusInput`](crate::input::CreateThesaurusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThesaurusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThesaurusInput {
                index_id: self.index_id,
                name: self.name,
                description: self.description,
                role_arn: self.role_arn,
                tags: self.tags,
                source_s3_path: self.source_s3_path,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThesaurusInputOperationOutputAlias = crate::operation::CreateThesaurus;
#[doc(hidden)]
pub type CreateThesaurusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThesaurusInput {
    /// Consumes the builder and constructs an Operation<[`CreateThesaurus`](crate::operation::CreateThesaurus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThesaurus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateThesaurusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateThesaurusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateThesaurusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.CreateThesaurus",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_thesaurus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThesaurus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThesaurus",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateThesaurusInput`](crate::input::CreateThesaurusInput)
    pub fn builder() -> crate::input::create_thesaurus_input::Builder {
        crate::input::create_thesaurus_input::Builder::default()
    }
}

/// See [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
pub mod delete_data_source_input {
    /// A builder for [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the data source to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the data source to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The unique identifier of the index associated with the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the index associated with the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSourceInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSourceInputOperationOutputAlias = crate::operation::DeleteDataSource;
#[doc(hidden)]
pub type DeleteDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSource`](crate::operation::DeleteDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
}

/// See [`DeleteExperienceInput`](crate::input::DeleteExperienceInput)
pub mod delete_experience_input {
    /// A builder for [`DeleteExperienceInput`](crate::input::DeleteExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to delete.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to delete.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExperienceInput`](crate::input::DeleteExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteExperienceInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteExperienceInputOperationOutputAlias = crate::operation::DeleteExperience;
#[doc(hidden)]
pub type DeleteExperienceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteExperienceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteExperience`](crate::operation::DeleteExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteExperience",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_experience(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteExperienceInput`](crate::input::DeleteExperienceInput)
    pub fn builder() -> crate::input::delete_experience_input::Builder {
        crate::input::delete_experience_input::Builder::default()
    }
}

/// See [`DeleteFaqInput`](crate::input::DeleteFaqInput)
pub mod delete_faq_input {
    /// A builder for [`DeleteFaqInput`](crate::input::DeleteFaqInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the FAQ to remove.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the FAQ to remove.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The index to remove the FAQ from.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The index to remove the FAQ from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFaqInput`](crate::input::DeleteFaqInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteFaqInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteFaqInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFaqInputOperationOutputAlias = crate::operation::DeleteFaq;
#[doc(hidden)]
pub type DeleteFaqInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFaqInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFaq`](crate::operation::DeleteFaq)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFaq,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFaqInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFaqInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFaqInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteFaq",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_faq(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteFaq::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteFaq",
                    "kendra",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFaqInput`](crate::input::DeleteFaqInput)
    pub fn builder() -> crate::input::delete_faq_input::Builder {
        crate::input::delete_faq_input::Builder::default()
    }
}

/// See [`DeleteIndexInput`](crate::input::DeleteIndexInput)
pub mod delete_index_input {
    /// A builder for [`DeleteIndexInput`](crate::input::DeleteIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the index to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIndexInput`](crate::input::DeleteIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIndexInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteIndexInputOperationOutputAlias = crate::operation::DeleteIndex;
#[doc(hidden)]
pub type DeleteIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIndexInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIndex`](crate::operation::DeleteIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteIndex",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIndex",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIndexInput`](crate::input::DeleteIndexInput)
    pub fn builder() -> crate::input::delete_index_input::Builder {
        crate::input::delete_index_input::Builder::default()
    }
}

/// See [`DeletePrincipalMappingInput`](crate::input::DeletePrincipalMappingInput)
pub mod delete_principal_mapping_input {
    /// A builder for [`DeletePrincipalMappingInput`](crate::input::DeletePrincipalMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) ordering_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to delete a group from.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to delete a group from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The identifier of the data source you want to delete a group from.</p>
        /// <p>This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source you want to delete a group from.</p>
        /// <p>This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The identifier of the group you want to delete.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group you want to delete.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. </p>
        pub fn ordering_id(mut self, input: i64) -> Self {
            self.ordering_id = Some(input);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. </p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.ordering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePrincipalMappingInput`](crate::input::DeletePrincipalMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePrincipalMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePrincipalMappingInput {
                index_id: self.index_id,
                data_source_id: self.data_source_id,
                group_id: self.group_id,
                ordering_id: self.ordering_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePrincipalMappingInputOperationOutputAlias = crate::operation::DeletePrincipalMapping;
#[doc(hidden)]
pub type DeletePrincipalMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePrincipalMappingInput {
    /// Consumes the builder and constructs an Operation<[`DeletePrincipalMapping`](crate::operation::DeletePrincipalMapping)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePrincipalMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePrincipalMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePrincipalMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePrincipalMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeletePrincipalMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_principal_mapping(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePrincipalMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePrincipalMapping",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePrincipalMappingInput`](crate::input::DeletePrincipalMappingInput)
    pub fn builder() -> crate::input::delete_principal_mapping_input::Builder {
        crate::input::delete_principal_mapping_input::Builder::default()
    }
}

/// See [`DeleteQuerySuggestionsBlockListInput`](crate::input::DeleteQuerySuggestionsBlockListInput)
pub mod delete_query_suggestions_block_list_input {
    /// A builder for [`DeleteQuerySuggestionsBlockListInput`](crate::input::DeleteQuerySuggestionsBlockListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the you want to delete a block list from.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the you want to delete a block list from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The unique identifier of the block list that needs to be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the block list that needs to be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQuerySuggestionsBlockListInput`](crate::input::DeleteQuerySuggestionsBlockListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQuerySuggestionsBlockListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQuerySuggestionsBlockListInput {
                index_id: self.index_id,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteQuerySuggestionsBlockListInputOperationOutputAlias =
    crate::operation::DeleteQuerySuggestionsBlockList;
#[doc(hidden)]
pub type DeleteQuerySuggestionsBlockListInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteQuerySuggestionsBlockListInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQuerySuggestionsBlockList`](crate::operation::DeleteQuerySuggestionsBlockList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQuerySuggestionsBlockList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQuerySuggestionsBlockListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQuerySuggestionsBlockListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQuerySuggestionsBlockListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteQuerySuggestionsBlockList",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_query_suggestions_block_list(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQuerySuggestionsBlockList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQuerySuggestionsBlockList",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQuerySuggestionsBlockListInput`](crate::input::DeleteQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::delete_query_suggestions_block_list_input::Builder {
        crate::input::delete_query_suggestions_block_list_input::Builder::default()
    }
}

/// See [`DeleteThesaurusInput`](crate::input::DeleteThesaurusInput)
pub mod delete_thesaurus_input {
    /// A builder for [`DeleteThesaurusInput`](crate::input::DeleteThesaurusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the thesaurus to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the thesaurus to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to delete.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to delete.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThesaurusInput`](crate::input::DeleteThesaurusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThesaurusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThesaurusInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThesaurusInputOperationOutputAlias = crate::operation::DeleteThesaurus;
#[doc(hidden)]
pub type DeleteThesaurusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThesaurusInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThesaurus`](crate::operation::DeleteThesaurus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThesaurus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteThesaurusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteThesaurusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteThesaurusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DeleteThesaurus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_thesaurus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThesaurus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThesaurus",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteThesaurusInput`](crate::input::DeleteThesaurusInput)
    pub fn builder() -> crate::input::delete_thesaurus_input::Builder {
        crate::input::delete_thesaurus_input::Builder::default()
    }
}

/// See [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
pub mod describe_data_source_input {
    /// A builder for [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the data source to describe.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the data source to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSourceInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSourceInputOperationOutputAlias = crate::operation::DescribeDataSource;
#[doc(hidden)]
pub type DescribeDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSource`](crate::operation::DescribeDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    pub fn builder() -> crate::input::describe_data_source_input::Builder {
        crate::input::describe_data_source_input::Builder::default()
    }
}

/// See [`DescribeExperienceInput`](crate::input::DescribeExperienceInput)
pub mod describe_experience_input {
    /// A builder for [`DescribeExperienceInput`](crate::input::DescribeExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience you want to get information on.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience you want to get information on.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to get information on.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to get information on.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExperienceInput`](crate::input::DescribeExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExperienceInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExperienceInputOperationOutputAlias = crate::operation::DescribeExperience;
#[doc(hidden)]
pub type DescribeExperienceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeExperienceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExperience`](crate::operation::DescribeExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeExperience",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_experience(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExperienceInput`](crate::input::DescribeExperienceInput)
    pub fn builder() -> crate::input::describe_experience_input::Builder {
        crate::input::describe_experience_input::Builder::default()
    }
}

/// See [`DescribeFaqInput`](crate::input::DescribeFaqInput)
pub mod describe_faq_input {
    /// A builder for [`DescribeFaqInput`](crate::input::DescribeFaqInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the FAQ.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the FAQ.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFaqInput`](crate::input::DescribeFaqInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFaqInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFaqInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFaqInputOperationOutputAlias = crate::operation::DescribeFaq;
#[doc(hidden)]
pub type DescribeFaqInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFaqInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFaq`](crate::operation::DescribeFaq)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFaq,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFaqInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFaqInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFaqInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeFaq",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_faq(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFaq::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFaq",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFaqInput`](crate::input::DescribeFaqInput)
    pub fn builder() -> crate::input::describe_faq_input::Builder {
        crate::input::describe_faq_input::Builder::default()
    }
}

/// See [`DescribeIndexInput`](crate::input::DescribeIndexInput)
pub mod describe_index_input {
    /// A builder for [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the index to describe.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The name of the index to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIndexInput`](crate::input::DescribeIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIndexInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribeIndexInputOperationOutputAlias = crate::operation::DescribeIndex;
#[doc(hidden)]
pub type DescribeIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIndexInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIndex`](crate::operation::DescribeIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeIndex",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIndex",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    pub fn builder() -> crate::input::describe_index_input::Builder {
        crate::input::describe_index_input::Builder::default()
    }
}

/// See [`DescribePrincipalMappingInput`](crate::input::DescribePrincipalMappingInput)
pub mod describe_principal_mapping_input {
    /// A builder for [`DescribePrincipalMappingInput`](crate::input::DescribePrincipalMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePrincipalMappingInput`](crate::input::DescribePrincipalMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePrincipalMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePrincipalMappingInput {
                index_id: self.index_id,
                data_source_id: self.data_source_id,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePrincipalMappingInputOperationOutputAlias =
    crate::operation::DescribePrincipalMapping;
#[doc(hidden)]
pub type DescribePrincipalMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePrincipalMappingInput {
    /// Consumes the builder and constructs an Operation<[`DescribePrincipalMapping`](crate::operation::DescribePrincipalMapping)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePrincipalMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePrincipalMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePrincipalMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePrincipalMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribePrincipalMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_principal_mapping(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePrincipalMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePrincipalMapping",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePrincipalMappingInput`](crate::input::DescribePrincipalMappingInput)
    pub fn builder() -> crate::input::describe_principal_mapping_input::Builder {
        crate::input::describe_principal_mapping_input::Builder::default()
    }
}

/// See [`DescribeQuerySuggestionsBlockListInput`](crate::input::DescribeQuerySuggestionsBlockListInput)
pub mod describe_query_suggestions_block_list_input {
    /// A builder for [`DescribeQuerySuggestionsBlockListInput`](crate::input::DescribeQuerySuggestionsBlockListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index for the block list.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for the block list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The unique identifier of the block list.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the block list.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQuerySuggestionsBlockListInput`](crate::input::DescribeQuerySuggestionsBlockListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeQuerySuggestionsBlockListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeQuerySuggestionsBlockListInput {
                index_id: self.index_id,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeQuerySuggestionsBlockListInputOperationOutputAlias =
    crate::operation::DescribeQuerySuggestionsBlockList;
#[doc(hidden)]
pub type DescribeQuerySuggestionsBlockListInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeQuerySuggestionsBlockListInput {
    /// Consumes the builder and constructs an Operation<[`DescribeQuerySuggestionsBlockList`](crate::operation::DescribeQuerySuggestionsBlockList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeQuerySuggestionsBlockList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeQuerySuggestionsBlockListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeQuerySuggestionsBlockListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeQuerySuggestionsBlockListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeQuerySuggestionsBlockList",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_query_suggestions_block_list(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeQuerySuggestionsBlockList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeQuerySuggestionsBlockList",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeQuerySuggestionsBlockListInput`](crate::input::DescribeQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::describe_query_suggestions_block_list_input::Builder {
        crate::input::describe_query_suggestions_block_list_input::Builder::default()
    }
}

/// See [`DescribeQuerySuggestionsConfigInput`](crate::input::DescribeQuerySuggestionsConfigInput)
pub mod describe_query_suggestions_config_input {
    /// A builder for [`DescribeQuerySuggestionsConfigInput`](crate::input::DescribeQuerySuggestionsConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to describe query suggestions settings for.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to describe query suggestions settings for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQuerySuggestionsConfigInput`](crate::input::DescribeQuerySuggestionsConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeQuerySuggestionsConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeQuerySuggestionsConfigInput {
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeQuerySuggestionsConfigInputOperationOutputAlias =
    crate::operation::DescribeQuerySuggestionsConfig;
#[doc(hidden)]
pub type DescribeQuerySuggestionsConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeQuerySuggestionsConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeQuerySuggestionsConfig`](crate::operation::DescribeQuerySuggestionsConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeQuerySuggestionsConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeQuerySuggestionsConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeQuerySuggestionsConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeQuerySuggestionsConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeQuerySuggestionsConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_query_suggestions_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeQuerySuggestionsConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeQuerySuggestionsConfig",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeQuerySuggestionsConfigInput`](crate::input::DescribeQuerySuggestionsConfigInput)
    pub fn builder() -> crate::input::describe_query_suggestions_config_input::Builder {
        crate::input::describe_query_suggestions_config_input::Builder::default()
    }
}

/// See [`DescribeThesaurusInput`](crate::input::DescribeThesaurusInput)
pub mod describe_thesaurus_input {
    /// A builder for [`DescribeThesaurusInput`](crate::input::DescribeThesaurusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the thesaurus to describe.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the thesaurus to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to describe.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to describe.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThesaurusInput`](crate::input::DescribeThesaurusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThesaurusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThesaurusInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThesaurusInputOperationOutputAlias = crate::operation::DescribeThesaurus;
#[doc(hidden)]
pub type DescribeThesaurusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThesaurusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThesaurus`](crate::operation::DescribeThesaurus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThesaurus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeThesaurusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeThesaurusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeThesaurusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DescribeThesaurus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_thesaurus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThesaurus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThesaurus",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeThesaurusInput`](crate::input::DescribeThesaurusInput)
    pub fn builder() -> crate::input::describe_thesaurus_input::Builder {
        crate::input::describe_thesaurus_input::Builder::default()
    }
}

/// See [`DisassociateEntitiesFromExperienceInput`](crate::input::DisassociateEntitiesFromExperienceInput)
pub mod disassociate_entities_from_experience_input {
    /// A builder for [`DisassociateEntitiesFromExperienceInput`](crate::input::DisassociateEntitiesFromExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) entity_list:
            std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `entity_list`.
        ///
        /// To override the contents of this collection use [`set_entity_list`](Self::set_entity_list).
        ///
        /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
        pub fn entity_list(mut self, input: crate::model::EntityConfiguration) -> Self {
            let mut v = self.entity_list.unwrap_or_default();
            v.push(input);
            self.entity_list = Some(v);
            self
        }
        /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
        pub fn set_entity_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
        ) -> Self {
            self.entity_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateEntitiesFromExperienceInput`](crate::input::DisassociateEntitiesFromExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateEntitiesFromExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateEntitiesFromExperienceInput {
                id: self.id,
                index_id: self.index_id,
                entity_list: self.entity_list,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateEntitiesFromExperienceInputOperationOutputAlias =
    crate::operation::DisassociateEntitiesFromExperience;
#[doc(hidden)]
pub type DisassociateEntitiesFromExperienceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateEntitiesFromExperienceInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateEntitiesFromExperience`](crate::operation::DisassociateEntitiesFromExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateEntitiesFromExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateEntitiesFromExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateEntitiesFromExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateEntitiesFromExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DisassociateEntitiesFromExperience",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_entities_from_experience(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateEntitiesFromExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateEntitiesFromExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateEntitiesFromExperienceInput`](crate::input::DisassociateEntitiesFromExperienceInput)
    pub fn builder() -> crate::input::disassociate_entities_from_experience_input::Builder {
        crate::input::disassociate_entities_from_experience_input::Builder::default()
    }
}

/// See [`DisassociatePersonasFromEntitiesInput`](crate::input::DisassociatePersonasFromEntitiesInput)
pub mod disassociate_personas_from_entities_input {
    /// A builder for [`DisassociatePersonasFromEntitiesInput`](crate::input::DisassociatePersonasFromEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) entity_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Appends an item to `entity_ids`.
        ///
        /// To override the contents of this collection use [`set_entity_ids`](Self::set_entity_ids).
        ///
        /// <p>The identifiers of users or groups in your Amazon Web Services SSO identity source. For example, user IDs could be user emails.</p>
        pub fn entity_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_ids.unwrap_or_default();
            v.push(input.into());
            self.entity_ids = Some(v);
            self
        }
        /// <p>The identifiers of users or groups in your Amazon Web Services SSO identity source. For example, user IDs could be user emails.</p>
        pub fn set_entity_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociatePersonasFromEntitiesInput`](crate::input::DisassociatePersonasFromEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociatePersonasFromEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociatePersonasFromEntitiesInput {
                id: self.id,
                index_id: self.index_id,
                entity_ids: self.entity_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociatePersonasFromEntitiesInputOperationOutputAlias =
    crate::operation::DisassociatePersonasFromEntities;
#[doc(hidden)]
pub type DisassociatePersonasFromEntitiesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociatePersonasFromEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`DisassociatePersonasFromEntities`](crate::operation::DisassociatePersonasFromEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociatePersonasFromEntities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociatePersonasFromEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociatePersonasFromEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociatePersonasFromEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.DisassociatePersonasFromEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_personas_from_entities(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociatePersonasFromEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociatePersonasFromEntities",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociatePersonasFromEntitiesInput`](crate::input::DisassociatePersonasFromEntitiesInput)
    pub fn builder() -> crate::input::disassociate_personas_from_entities_input::Builder {
        crate::input::disassociate_personas_from_entities_input::Builder::default()
    }
}

/// See [`GetQuerySuggestionsInput`](crate::input::GetQuerySuggestionsInput)
pub mod get_query_suggestions_input {
    /// A builder for [`GetQuerySuggestionsInput`](crate::input::GetQuerySuggestionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) query_text: std::option::Option<std::string::String>,
        pub(crate) max_suggestions_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to get query suggestions from.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to get query suggestions from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The text of a user's query to generate query suggestions.</p>
        /// <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p>
        /// <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>
        pub fn query_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_text = Some(input.into());
            self
        }
        /// <p>The text of a user's query to generate query suggestions.</p>
        /// <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p>
        /// <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_text = input;
            self
        }
        /// <p>The maximum number of query suggestions you want to show to your users.</p>
        pub fn max_suggestions_count(mut self, input: i32) -> Self {
            self.max_suggestions_count = Some(input);
            self
        }
        /// <p>The maximum number of query suggestions you want to show to your users.</p>
        pub fn set_max_suggestions_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_suggestions_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQuerySuggestionsInput`](crate::input::GetQuerySuggestionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQuerySuggestionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQuerySuggestionsInput {
                index_id: self.index_id,
                query_text: self.query_text,
                max_suggestions_count: self.max_suggestions_count,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQuerySuggestionsInputOperationOutputAlias = crate::operation::GetQuerySuggestions;
#[doc(hidden)]
pub type GetQuerySuggestionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetQuerySuggestionsInput {
    /// Consumes the builder and constructs an Operation<[`GetQuerySuggestions`](crate::operation::GetQuerySuggestions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQuerySuggestions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQuerySuggestionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQuerySuggestionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQuerySuggestionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.GetQuerySuggestions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_query_suggestions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQuerySuggestions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQuerySuggestions",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQuerySuggestionsInput`](crate::input::GetQuerySuggestionsInput)
    pub fn builder() -> crate::input::get_query_suggestions_input::Builder {
        crate::input::get_query_suggestions_input::Builder::default()
    }
}

/// See [`GetSnapshotsInput`](crate::input::GetSnapshotsInput)
pub mod get_snapshots_input {
    /// A builder for [`GetSnapshotsInput`](crate::input::GetSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) interval: std::option::Option<crate::model::Interval>,
        pub(crate) metric_type: std::option::Option<crate::model::MetricType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index to get search metrics data.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index to get search metrics data.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:</p>
        /// <ul>
        /// <li> <p> <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.</p> </li>
        /// <li> <p> <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
        /// <li> <p> <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
        /// <li> <p> <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before the current date.</p> </li>
        /// <li> <p> <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day of the month.</p> </li>
        /// <li> <p> <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and ending on last day of the month.</p> </li>
        /// </ul>
        pub fn interval(mut self, input: crate::model::Interval) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:</p>
        /// <ul>
        /// <li> <p> <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.</p> </li>
        /// <li> <p> <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
        /// <li> <p> <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
        /// <li> <p> <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before the current date.</p> </li>
        /// <li> <p> <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day of the month.</p> </li>
        /// <li> <p> <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and ending on last day of the month.</p> </li>
        /// </ul>
        pub fn set_interval(mut self, input: std::option::Option<crate::model::Interval>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The metric you want to retrieve. You can specify only one metric per call.</p>
        /// <p>For more information about the metrics you can view, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search analytics</a>.</p>
        pub fn metric_type(mut self, input: crate::model::MetricType) -> Self {
            self.metric_type = Some(input);
            self
        }
        /// <p>The metric you want to retrieve. You can specify only one metric per call.</p>
        /// <p>For more information about the metrics you can view, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search analytics</a>.</p>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::MetricType>,
        ) -> Self {
            self.metric_type = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of returned data for the metric.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of returned data for the metric.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotsInput`](crate::input::GetSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSnapshotsInput {
                index_id: self.index_id,
                interval: self.interval,
                metric_type: self.metric_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSnapshotsInputOperationOutputAlias = crate::operation::GetSnapshots;
#[doc(hidden)]
pub type GetSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`GetSnapshots`](crate::operation::GetSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.GetSnapshots",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_snapshots(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSnapshots",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSnapshotsInput`](crate::input::GetSnapshotsInput)
    pub fn builder() -> crate::input::get_snapshots_input::Builder {
        crate::input::get_snapshots_input::Builder::default()
    }
}

/// See [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
pub mod list_data_sources_input {
    /// A builder for [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (<code>DataSourceSummaryItems</code>). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (<code>DataSourceSummaryItems</code>). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSourcesInput {
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSourcesInputOperationOutputAlias = crate::operation::ListDataSources;
#[doc(hidden)]
pub type ListDataSourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSources`](crate::operation::ListDataSources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListDataSources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_data_sources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSources",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
}

/// See [`ListDataSourceSyncJobsInput`](crate::input::ListDataSourceSyncJobsInput)
pub mod list_data_source_sync_jobs_input {
    /// A builder for [`ListDataSourceSyncJobsInput`](crate::input::ListDataSourceSyncJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) start_time_filter: std::option::Option<crate::model::TimeRange>,
        pub(crate) status_filter: std::option::Option<crate::model::DataSourceSyncJobStatus>,
    }
    impl Builder {
        /// <p>The identifier of the data source.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of jobs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. </p>
        pub fn start_time_filter(mut self, input: crate::model::TimeRange) -> Self {
            self.start_time_filter = Some(input);
            self
        }
        /// <p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. </p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.start_time_filter = input;
            self
        }
        /// <p>When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>
        pub fn status_filter(mut self, input: crate::model::DataSourceSyncJobStatus) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p>When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobStatus>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSourceSyncJobsInput`](crate::input::ListDataSourceSyncJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSourceSyncJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSourceSyncJobsInput {
                id: self.id,
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
                start_time_filter: self.start_time_filter,
                status_filter: self.status_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSourceSyncJobsInputOperationOutputAlias = crate::operation::ListDataSourceSyncJobs;
#[doc(hidden)]
pub type ListDataSourceSyncJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSourceSyncJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSourceSyncJobs`](crate::operation::ListDataSourceSyncJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSourceSyncJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSourceSyncJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSourceSyncJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSourceSyncJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListDataSourceSyncJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_data_source_sync_jobs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSourceSyncJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSourceSyncJobs",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSourceSyncJobsInput`](crate::input::ListDataSourceSyncJobsInput)
    pub fn builder() -> crate::input::list_data_source_sync_jobs_input::Builder {
        crate::input::list_data_source_sync_jobs_input::Builder::default()
    }
}

/// See [`ListEntityPersonasInput`](crate::input::ListEntityPersonasInput)
pub mod list_entity_personas_input {
    /// A builder for [`ListEntityPersonasInput`](crate::input::ListEntityPersonasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of returned users or groups.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of returned users or groups.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntityPersonasInput`](crate::input::ListEntityPersonasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntityPersonasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntityPersonasInput {
                id: self.id,
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntityPersonasInputOperationOutputAlias = crate::operation::ListEntityPersonas;
#[doc(hidden)]
pub type ListEntityPersonasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEntityPersonasInput {
    /// Consumes the builder and constructs an Operation<[`ListEntityPersonas`](crate::operation::ListEntityPersonas)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntityPersonas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntityPersonasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntityPersonasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntityPersonasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListEntityPersonas",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_entity_personas(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntityPersonas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntityPersonas",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntityPersonasInput`](crate::input::ListEntityPersonasInput)
    pub fn builder() -> crate::input::list_entity_personas_input::Builder {
        crate::input::list_entity_personas_input::Builder::default()
    }
}

/// See [`ListExperienceEntitiesInput`](crate::input::ListExperienceEntitiesInput)
pub mod list_experience_entities_input {
    /// A builder for [`ListExperienceEntitiesInput`](crate::input::ListExperienceEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExperienceEntitiesInput`](crate::input::ListExperienceEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExperienceEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExperienceEntitiesInput {
                id: self.id,
                index_id: self.index_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExperienceEntitiesInputOperationOutputAlias = crate::operation::ListExperienceEntities;
#[doc(hidden)]
pub type ListExperienceEntitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExperienceEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListExperienceEntities`](crate::operation::ListExperienceEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExperienceEntities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExperienceEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExperienceEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExperienceEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListExperienceEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_experience_entities(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExperienceEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExperienceEntities",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExperienceEntitiesInput`](crate::input::ListExperienceEntitiesInput)
    pub fn builder() -> crate::input::list_experience_entities_input::Builder {
        crate::input::list_experience_entities_input::Builder::default()
    }
}

/// See [`ListExperiencesInput`](crate::input::ListExperiencesInput)
pub mod list_experiences_input {
    /// A builder for [`ListExperiencesInput`](crate::input::ListExperiencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon Kendra experiences.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon Kendra experiences.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of returned Amazon Kendra experiences.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of returned Amazon Kendra experiences.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExperiencesInput`](crate::input::ListExperiencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExperiencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExperiencesInput {
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExperiencesInputOperationOutputAlias = crate::operation::ListExperiences;
#[doc(hidden)]
pub type ListExperiencesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExperiencesInput {
    /// Consumes the builder and constructs an Operation<[`ListExperiences`](crate::operation::ListExperiences)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExperiences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExperiencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExperiencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExperiencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListExperiences",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_experiences(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExperiences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExperiences",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExperiencesInput`](crate::input::ListExperiencesInput)
    pub fn builder() -> crate::input::list_experiences_input::Builder {
        crate::input::list_experiences_input::Builder::default()
    }
}

/// See [`ListFaqsInput`](crate::input::ListFaqsInput)
pub mod list_faqs_input {
    /// A builder for [`ListFaqsInput`](crate::input::ListFaqsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The index that contains the FAQ lists.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The index that contains the FAQ lists.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of FAQs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of FAQs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFaqsInput`](crate::input::ListFaqsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListFaqsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListFaqsInput {
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFaqsInputOperationOutputAlias = crate::operation::ListFaqs;
#[doc(hidden)]
pub type ListFaqsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFaqsInput {
    /// Consumes the builder and constructs an Operation<[`ListFaqs`](crate::operation::ListFaqs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFaqs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFaqsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFaqsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFaqsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListFaqs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_faqs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListFaqs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListFaqs", "kendra",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFaqsInput`](crate::input::ListFaqsInput)
    pub fn builder() -> crate::input::list_faqs_input::Builder {
        crate::input::list_faqs_input::Builder::default()
    }
}

/// See [`ListGroupsOlderThanOrderingIdInput`](crate::input::ListGroupsOlderThanOrderingIdInput)
pub mod list_groups_older_than_ordering_id_input {
    /// A builder for [`ListGroupsOlderThanOrderingIdInput`](crate::input::ListGroupsOlderThanOrderingIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) ordering_id: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>
        pub fn ordering_id(mut self, input: i64) -> Self {
            self.ordering_id = Some(input);
            self
        }
        /// <p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.ordering_id = input;
            self
        }
        /// <p> If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of returned groups that are mapped to users before a given ordering or timestamp identifier. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of returned groups that are mapped to users before a given ordering or timestamp identifier. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsOlderThanOrderingIdInput`](crate::input::ListGroupsOlderThanOrderingIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsOlderThanOrderingIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsOlderThanOrderingIdInput {
                index_id: self.index_id,
                data_source_id: self.data_source_id,
                ordering_id: self.ordering_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsOlderThanOrderingIdInputOperationOutputAlias =
    crate::operation::ListGroupsOlderThanOrderingId;
#[doc(hidden)]
pub type ListGroupsOlderThanOrderingIdInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupsOlderThanOrderingIdInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupsOlderThanOrderingId`](crate::operation::ListGroupsOlderThanOrderingId)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupsOlderThanOrderingId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsOlderThanOrderingIdInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsOlderThanOrderingIdInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsOlderThanOrderingIdInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListGroupsOlderThanOrderingId",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_groups_older_than_ordering_id(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupsOlderThanOrderingId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupsOlderThanOrderingId",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsOlderThanOrderingIdInput`](crate::input::ListGroupsOlderThanOrderingIdInput)
    pub fn builder() -> crate::input::list_groups_older_than_ordering_id_input::Builder {
        crate::input::list_groups_older_than_ordering_id_input::Builder::default()
    }
}

/// See [`ListIndicesInput`](crate::input::ListIndicesInput)
pub mod list_indices_input {
    /// A builder for [`ListIndicesInput`](crate::input::ListIndicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (<code>DataSourceSummaryItems</code>). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (<code>DataSourceSummaryItems</code>). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIndicesInput`](crate::input::ListIndicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIndicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIndicesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIndicesInputOperationOutputAlias = crate::operation::ListIndices;
#[doc(hidden)]
pub type ListIndicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIndicesInput {
    /// Consumes the builder and constructs an Operation<[`ListIndices`](crate::operation::ListIndices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIndices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIndicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIndicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIndicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListIndices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_indices(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIndices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIndices",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIndicesInput`](crate::input::ListIndicesInput)
    pub fn builder() -> crate::input::list_indices_input::Builder {
        crate::input::list_indices_input::Builder::default()
    }
}

/// See [`ListQuerySuggestionsBlockListsInput`](crate::input::ListQuerySuggestionsBlockListsInput)
pub mod list_query_suggestions_block_lists_input {
    /// A builder for [`ListQuerySuggestionsBlockListsInput`](crate::input::ListQuerySuggestionsBlockListsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index for a list of all block lists that exist for that index.</p>
        /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for a list of all block lists that exist for that index.</p>
        /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of block lists to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of block lists to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQuerySuggestionsBlockListsInput`](crate::input::ListQuerySuggestionsBlockListsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQuerySuggestionsBlockListsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQuerySuggestionsBlockListsInput {
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQuerySuggestionsBlockListsInputOperationOutputAlias =
    crate::operation::ListQuerySuggestionsBlockLists;
#[doc(hidden)]
pub type ListQuerySuggestionsBlockListsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListQuerySuggestionsBlockListsInput {
    /// Consumes the builder and constructs an Operation<[`ListQuerySuggestionsBlockLists`](crate::operation::ListQuerySuggestionsBlockLists)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQuerySuggestionsBlockLists,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQuerySuggestionsBlockListsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQuerySuggestionsBlockListsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQuerySuggestionsBlockListsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListQuerySuggestionsBlockLists",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_query_suggestions_block_lists(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQuerySuggestionsBlockLists::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQuerySuggestionsBlockLists",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQuerySuggestionsBlockListsInput`](crate::input::ListQuerySuggestionsBlockListsInput)
    pub fn builder() -> crate::input::list_query_suggestions_block_lists_input::Builder {
        crate::input::list_query_suggestions_block_lists_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListThesauriInput`](crate::input::ListThesauriInput)
pub mod list_thesauri_input {
    /// A builder for [`ListThesauriInput`](crate::input::ListThesauriInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index associated with the thesaurus to list.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of thesauri to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of thesauri to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThesauriInput`](crate::input::ListThesauriInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThesauriInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThesauriInput {
                index_id: self.index_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListThesauriInputOperationOutputAlias = crate::operation::ListThesauri;
#[doc(hidden)]
pub type ListThesauriInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThesauriInput {
    /// Consumes the builder and constructs an Operation<[`ListThesauri`](crate::operation::ListThesauri)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThesauri,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListThesauriInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListThesauriInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListThesauriInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.ListThesauri",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_thesauri(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThesauri::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThesauri",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListThesauriInput`](crate::input::ListThesauriInput)
    pub fn builder() -> crate::input::list_thesauri_input::Builder {
        crate::input::list_thesauri_input::Builder::default()
    }
}

/// See [`PutPrincipalMappingInput`](crate::input::PutPrincipalMappingInput)
pub mod put_principal_mapping_input {
    /// A builder for [`PutPrincipalMappingInput`](crate::input::PutPrincipalMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_members: std::option::Option<crate::model::GroupMembers>,
        pub(crate) ordering_id: std::option::Option<i64>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to map users to their groups.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to map users to their groups.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The identifier of the data source you want to map users to their groups.</p>
        /// <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source you want to map users to their groups.</p>
        /// <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The identifier of the group you want to map its users to.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group you want to map its users to.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The list that contains your users or sub groups that belong the same group.</p>
        /// <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p>
        /// <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>
        pub fn group_members(mut self, input: crate::model::GroupMembers) -> Self {
            self.group_members = Some(input);
            self
        }
        /// <p>The list that contains your users or sub groups that belong the same group.</p>
        /// <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p>
        /// <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>
        pub fn set_group_members(
            mut self,
            input: std::option::Option<crate::model::GroupMembers>,
        ) -> Self {
            self.group_members = input;
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.</p>
        pub fn ordering_id(mut self, input: i64) -> Self {
            self.ordering_id = Some(input);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.</p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.ordering_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPrincipalMappingInput`](crate::input::PutPrincipalMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutPrincipalMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutPrincipalMappingInput {
                index_id: self.index_id,
                data_source_id: self.data_source_id,
                group_id: self.group_id,
                group_members: self.group_members,
                ordering_id: self.ordering_id,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPrincipalMappingInputOperationOutputAlias = crate::operation::PutPrincipalMapping;
#[doc(hidden)]
pub type PutPrincipalMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutPrincipalMappingInput {
    /// Consumes the builder and constructs an Operation<[`PutPrincipalMapping`](crate::operation::PutPrincipalMapping)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPrincipalMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPrincipalMappingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPrincipalMappingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPrincipalMappingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.PutPrincipalMapping",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_principal_mapping(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutPrincipalMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutPrincipalMapping",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPrincipalMappingInput`](crate::input::PutPrincipalMappingInput)
    pub fn builder() -> crate::input::put_principal_mapping_input::Builder {
        crate::input::put_principal_mapping_input::Builder::default()
    }
}

/// See [`QueryInput`](crate::input::QueryInput)
pub mod query_input {
    /// A builder for [`QueryInput`](crate::input::QueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) query_text: std::option::Option<std::string::String>,
        pub(crate) attribute_filter: std::option::Option<crate::model::AttributeFilter>,
        pub(crate) facets: std::option::Option<std::vec::Vec<crate::model::Facet>>,
        pub(crate) requested_document_attributes:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) query_result_type_filter: std::option::Option<crate::model::QueryResultType>,
        pub(crate) document_relevance_override_configurations:
            std::option::Option<std::vec::Vec<crate::model::DocumentRelevanceConfiguration>>,
        pub(crate) page_number: std::option::Option<i32>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) sorting_configuration: std::option::Option<crate::model::SortingConfiguration>,
        pub(crate) user_context: std::option::Option<crate::model::UserContext>,
        pub(crate) visitor_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the index to search. The identifier is returned in the response from the <code>CreateIndex</code> operation.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the index to search. The identifier is returned in the response from the <code>CreateIndex</code> operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The text to search for.</p>
        pub fn query_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_text = Some(input.into());
            self
        }
        /// <p>The text to search for.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_text = input;
            self
        }
        /// <p>Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p>
        /// <p>The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.</p>
        pub fn attribute_filter(mut self, input: crate::model::AttributeFilter) -> Self {
            self.attribute_filter = Some(input);
            self
        }
        /// <p>Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p>
        /// <p>The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.</p>
        pub fn set_attribute_filter(
            mut self,
            input: std::option::Option<crate::model::AttributeFilter>,
        ) -> Self {
            self.attribute_filter = input;
            self
        }
        /// Appends an item to `facets`.
        ///
        /// To override the contents of this collection use [`set_facets`](Self::set_facets).
        ///
        /// <p>An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user.</p>
        pub fn facets(mut self, input: crate::model::Facet) -> Self {
            let mut v = self.facets.unwrap_or_default();
            v.push(input);
            self.facets = Some(v);
            self
        }
        /// <p>An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user.</p>
        pub fn set_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Facet>>,
        ) -> Self {
            self.facets = input;
            self
        }
        /// Appends an item to `requested_document_attributes`.
        ///
        /// To override the contents of this collection use [`set_requested_document_attributes`](Self::set_requested_document_attributes).
        ///
        /// <p>An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. </p>
        pub fn requested_document_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.requested_document_attributes.unwrap_or_default();
            v.push(input.into());
            self.requested_document_attributes = Some(v);
            self
        }
        /// <p>An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. </p>
        pub fn set_requested_document_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.requested_document_attributes = input;
            self
        }
        /// <p>Sets the type of query. Only results for the specified query type are returned.</p>
        pub fn query_result_type_filter(mut self, input: crate::model::QueryResultType) -> Self {
            self.query_result_type_filter = Some(input);
            self
        }
        /// <p>Sets the type of query. Only results for the specified query type are returned.</p>
        pub fn set_query_result_type_filter(
            mut self,
            input: std::option::Option<crate::model::QueryResultType>,
        ) -> Self {
            self.query_result_type_filter = input;
            self
        }
        /// Appends an item to `document_relevance_override_configurations`.
        ///
        /// To override the contents of this collection use [`set_document_relevance_override_configurations`](Self::set_document_relevance_override_configurations).
        ///
        /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
        /// <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
        /// <p>If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
        /// <p>If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>
        pub fn document_relevance_override_configurations(
            mut self,
            input: crate::model::DocumentRelevanceConfiguration,
        ) -> Self {
            let mut v = self
                .document_relevance_override_configurations
                .unwrap_or_default();
            v.push(input);
            self.document_relevance_override_configurations = Some(v);
            self
        }
        /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
        /// <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
        /// <p>If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
        /// <p>If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>
        pub fn set_document_relevance_override_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRelevanceConfiguration>>,
        ) -> Self {
            self.document_relevance_override_configurations = input;
            self
        }
        /// <p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>
        pub fn page_number(mut self, input: i32) -> Self {
            self.page_number = Some(input);
            self
        }
        /// <p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>
        pub fn set_page_number(mut self, input: std::option::Option<i32>) -> Self {
            self.page_number = input;
            self
        }
        /// <p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
        /// <p>If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>
        pub fn sorting_configuration(mut self, input: crate::model::SortingConfiguration) -> Self {
            self.sorting_configuration = Some(input);
            self
        }
        /// <p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
        /// <p>If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>
        pub fn set_sorting_configuration(
            mut self,
            input: std::option::Option<crate::model::SortingConfiguration>,
        ) -> Self {
            self.sorting_configuration = input;
            self
        }
        /// <p>The user context token or user and group information.</p>
        pub fn user_context(mut self, input: crate::model::UserContext) -> Self {
            self.user_context = Some(input);
            self
        }
        /// <p>The user context token or user and group information.</p>
        pub fn set_user_context(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.user_context = input;
            self
        }
        /// <p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the <code>VisitorId</code>.</p>
        pub fn visitor_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.visitor_id = Some(input.into());
            self
        }
        /// <p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the <code>VisitorId</code>.</p>
        pub fn set_visitor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.visitor_id = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryInput`](crate::input::QueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::QueryInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::QueryInput {
                index_id: self.index_id,
                query_text: self.query_text,
                attribute_filter: self.attribute_filter,
                facets: self.facets,
                requested_document_attributes: self.requested_document_attributes,
                query_result_type_filter: self.query_result_type_filter,
                document_relevance_override_configurations: self
                    .document_relevance_override_configurations,
                page_number: self.page_number,
                page_size: self.page_size,
                sorting_configuration: self.sorting_configuration,
                user_context: self.user_context,
                visitor_id: self.visitor_id,
            })
        }
    }
}
#[doc(hidden)]
pub type QueryInputOperationOutputAlias = crate::operation::Query;
#[doc(hidden)]
pub type QueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl QueryInput {
    /// Consumes the builder and constructs an Operation<[`Query`](crate::operation::Query)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Query,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::QueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::QueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::QueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.Query",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Query::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("Query", "kendra"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`QueryInput`](crate::input::QueryInput)
    pub fn builder() -> crate::input::query_input::Builder {
        crate::input::query_input::Builder::default()
    }
}

/// See [`StartDataSourceSyncJobInput`](crate::input::StartDataSourceSyncJobInput)
pub mod start_data_source_sync_job_input {
    /// A builder for [`StartDataSourceSyncJobInput`](crate::input::StartDataSourceSyncJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the data source to synchronize.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source to synchronize.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDataSourceSyncJobInput`](crate::input::StartDataSourceSyncJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDataSourceSyncJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDataSourceSyncJobInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDataSourceSyncJobInputOperationOutputAlias = crate::operation::StartDataSourceSyncJob;
#[doc(hidden)]
pub type StartDataSourceSyncJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartDataSourceSyncJobInput {
    /// Consumes the builder and constructs an Operation<[`StartDataSourceSyncJob`](crate::operation::StartDataSourceSyncJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDataSourceSyncJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDataSourceSyncJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDataSourceSyncJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDataSourceSyncJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.StartDataSourceSyncJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_data_source_sync_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDataSourceSyncJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDataSourceSyncJob",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDataSourceSyncJobInput`](crate::input::StartDataSourceSyncJobInput)
    pub fn builder() -> crate::input::start_data_source_sync_job_input::Builder {
        crate::input::start_data_source_sync_job_input::Builder::default()
    }
}

/// See [`StopDataSourceSyncJobInput`](crate::input::StopDataSourceSyncJobInput)
pub mod stop_data_source_sync_job_input {
    /// A builder for [`StopDataSourceSyncJobInput`](crate::input::StopDataSourceSyncJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the data source for which to stop the synchronization jobs.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source for which to stop the synchronization jobs.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDataSourceSyncJobInput`](crate::input::StopDataSourceSyncJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopDataSourceSyncJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopDataSourceSyncJobInput {
                id: self.id,
                index_id: self.index_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopDataSourceSyncJobInputOperationOutputAlias = crate::operation::StopDataSourceSyncJob;
#[doc(hidden)]
pub type StopDataSourceSyncJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopDataSourceSyncJobInput {
    /// Consumes the builder and constructs an Operation<[`StopDataSourceSyncJob`](crate::operation::StopDataSourceSyncJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopDataSourceSyncJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopDataSourceSyncJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopDataSourceSyncJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopDataSourceSyncJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.StopDataSourceSyncJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_data_source_sync_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopDataSourceSyncJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopDataSourceSyncJob",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopDataSourceSyncJobInput`](crate::input::StopDataSourceSyncJobInput)
    pub fn builder() -> crate::input::stop_data_source_sync_job_input::Builder {
        crate::input::stop_data_source_sync_job_input::Builder::default()
    }
}

/// See [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
pub mod submit_feedback_input {
    /// A builder for [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) click_feedback_items:
            std::option::Option<std::vec::Vec<crate::model::ClickFeedback>>,
        pub(crate) relevance_feedback_items:
            std::option::Option<std::vec::Vec<crate::model::RelevanceFeedback>>,
    }
    impl Builder {
        /// <p>The identifier of the index that was queried.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that was queried.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Appends an item to `click_feedback_items`.
        ///
        /// To override the contents of this collection use [`set_click_feedback_items`](Self::set_click_feedback_items).
        ///
        /// <p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>
        pub fn click_feedback_items(mut self, input: crate::model::ClickFeedback) -> Self {
            let mut v = self.click_feedback_items.unwrap_or_default();
            v.push(input);
            self.click_feedback_items = Some(v);
            self
        }
        /// <p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>
        pub fn set_click_feedback_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClickFeedback>>,
        ) -> Self {
            self.click_feedback_items = input;
            self
        }
        /// Appends an item to `relevance_feedback_items`.
        ///
        /// To override the contents of this collection use [`set_relevance_feedback_items`](Self::set_relevance_feedback_items).
        ///
        /// <p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>
        pub fn relevance_feedback_items(mut self, input: crate::model::RelevanceFeedback) -> Self {
            let mut v = self.relevance_feedback_items.unwrap_or_default();
            v.push(input);
            self.relevance_feedback_items = Some(v);
            self
        }
        /// <p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>
        pub fn set_relevance_feedback_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelevanceFeedback>>,
        ) -> Self {
            self.relevance_feedback_items = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubmitFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubmitFeedbackInput {
                index_id: self.index_id,
                query_id: self.query_id,
                click_feedback_items: self.click_feedback_items,
                relevance_feedback_items: self.relevance_feedback_items,
            })
        }
    }
}
#[doc(hidden)]
pub type SubmitFeedbackInputOperationOutputAlias = crate::operation::SubmitFeedback;
#[doc(hidden)]
pub type SubmitFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SubmitFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`SubmitFeedback`](crate::operation::SubmitFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubmitFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubmitFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubmitFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubmitFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.SubmitFeedback",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_submit_feedback(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubmitFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubmitFeedback",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubmitFeedbackInput`](crate::input::SubmitFeedbackInput)
    pub fn builder() -> crate::input::submit_feedback_input::Builder {
        crate::input::submit_feedback_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
pub mod update_data_source_input {
    /// A builder for [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::DataSourceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) custom_document_enrichment_configuration:
            std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier of the data source to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the data source to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the data source to update. The name of the data source can't be updated. To rename a data source you must delete the data source and re-create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source to update. The name of the data source can't be updated. To rename a data source you must delete the data source and re-create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the index that contains the data source to update.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index that contains the data source to update.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>Configuration information for an Amazon Kendra data source.</p>
        pub fn configuration(mut self, input: crate::model::DataSourceConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Configuration information for an Amazon Kendra data source.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new update schedule for the data source.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The new update schedule for the data source.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The code for a language. This allows you to support a language for all documents when updating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for a language. This allows you to support a language for all documents when updating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>Configuration information for altering document metadata and content during the document ingestion process when you update a data source.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn custom_document_enrichment_configuration(
            mut self,
            input: crate::model::CustomDocumentEnrichmentConfiguration,
        ) -> Self {
            self.custom_document_enrichment_configuration = Some(input);
            self
        }
        /// <p>Configuration information for altering document metadata and content during the document ingestion process when you update a data source.</p>
        /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
        pub fn set_custom_document_enrichment_configuration(
            mut self,
            input: std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
        ) -> Self {
            self.custom_document_enrichment_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataSourceInput {
                id: self.id,
                name: self.name,
                index_id: self.index_id,
                configuration: self.configuration,
                description: self.description,
                schedule: self.schedule,
                role_arn: self.role_arn,
                language_code: self.language_code,
                custom_document_enrichment_configuration: self
                    .custom_document_enrichment_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataSourceInputOperationOutputAlias = crate::operation::UpdateDataSource;
#[doc(hidden)]
pub type UpdateDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataSource`](crate::operation::UpdateDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataSource",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
}

/// See [`UpdateExperienceInput`](crate::input::UpdateExperienceInput)
pub mod update_experience_input {
    /// A builder for [`UpdateExperienceInput`](crate::input::UpdateExperienceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ExperienceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of your Amazon Kendra experience you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of your Amazon Kendra experience you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of your Amazon Kendra experience you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of your Amazon Kendra experience you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to update.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for your Amazon Kendra experience you want to update.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides the user configuration information. This includes the Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.</p>
        pub fn configuration(mut self, input: crate::model::ExperienceConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Provides the user configuration information. This includes the Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ExperienceConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The description of your Amazon Kendra experience you want to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of your Amazon Kendra experience you want to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperienceInput`](crate::input::UpdateExperienceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateExperienceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateExperienceInput {
                id: self.id,
                name: self.name,
                index_id: self.index_id,
                role_arn: self.role_arn,
                configuration: self.configuration,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateExperienceInputOperationOutputAlias = crate::operation::UpdateExperience;
#[doc(hidden)]
pub type UpdateExperienceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateExperienceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateExperience`](crate::operation::UpdateExperience)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateExperience,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateExperienceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateExperienceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateExperienceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateExperience",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_experience(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateExperience::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateExperience",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateExperienceInput`](crate::input::UpdateExperienceInput)
    pub fn builder() -> crate::input::update_experience_input::Builder {
        crate::input::update_experience_input::Builder::default()
    }
}

/// See [`UpdateIndexInput`](crate::input::UpdateIndexInput)
pub mod update_index_input {
    /// A builder for [`UpdateIndexInput`](crate::input::UpdateIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) document_metadata_configuration_updates:
            std::option::Option<std::vec::Vec<crate::model::DocumentMetadataConfiguration>>,
        pub(crate) capacity_units: std::option::Option<crate::model::CapacityUnitsConfiguration>,
        pub(crate) user_token_configurations:
            std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        pub(crate) user_context_policy: std::option::Option<crate::model::UserContextPolicy>,
        pub(crate) user_group_resolution_configuration:
            std::option::Option<crate::model::UserGroupResolutionConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the index to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the index to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the index to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the index to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A new description for the index.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description for the index.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `document_metadata_configuration_updates`.
        ///
        /// To override the contents of this collection use [`set_document_metadata_configuration_updates`](Self::set_document_metadata_configuration_updates).
        ///
        /// <p>The document metadata to update. </p>
        pub fn document_metadata_configuration_updates(
            mut self,
            input: crate::model::DocumentMetadataConfiguration,
        ) -> Self {
            let mut v = self
                .document_metadata_configuration_updates
                .unwrap_or_default();
            v.push(input);
            self.document_metadata_configuration_updates = Some(v);
            self
        }
        /// <p>The document metadata to update. </p>
        pub fn set_document_metadata_configuration_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentMetadataConfiguration>>,
        ) -> Self {
            self.document_metadata_configuration_updates = input;
            self
        }
        /// <p>Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day.</p>
        /// <p>If you are using extra storage units, you can't reduce the storage capacity below that required to meet the storage needs for your index.</p>
        pub fn capacity_units(mut self, input: crate::model::CapacityUnitsConfiguration) -> Self {
            self.capacity_units = Some(input);
            self
        }
        /// <p>Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day.</p>
        /// <p>If you are using extra storage units, you can't reduce the storage capacity below that required to meet the storage needs for your index.</p>
        pub fn set_capacity_units(
            mut self,
            input: std::option::Option<crate::model::CapacityUnitsConfiguration>,
        ) -> Self {
            self.capacity_units = input;
            self
        }
        /// Appends an item to `user_token_configurations`.
        ///
        /// To override the contents of this collection use [`set_user_token_configurations`](Self::set_user_token_configurations).
        ///
        /// <p>The user token configuration.</p>
        pub fn user_token_configurations(
            mut self,
            input: crate::model::UserTokenConfiguration,
        ) -> Self {
            let mut v = self.user_token_configurations.unwrap_or_default();
            v.push(input);
            self.user_token_configurations = Some(v);
            self
        }
        /// <p>The user token configuration.</p>
        pub fn set_user_token_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        ) -> Self {
            self.user_token_configurations = input;
            self
        }
        /// <p>The user context policy.</p>
        pub fn user_context_policy(mut self, input: crate::model::UserContextPolicy) -> Self {
            self.user_context_policy = Some(input);
            self
        }
        /// <p>The user context policy.</p>
        pub fn set_user_context_policy(
            mut self,
            input: std::option::Option<crate::model::UserContextPolicy>,
        ) -> Self {
            self.user_context_policy = input;
            self
        }
        /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn user_group_resolution_configuration(
            mut self,
            input: crate::model::UserGroupResolutionConfiguration,
        ) -> Self {
            self.user_group_resolution_configuration = Some(input);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn set_user_group_resolution_configuration(
            mut self,
            input: std::option::Option<crate::model::UserGroupResolutionConfiguration>,
        ) -> Self {
            self.user_group_resolution_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIndexInput`](crate::input::UpdateIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIndexInput {
                id: self.id,
                name: self.name,
                role_arn: self.role_arn,
                description: self.description,
                document_metadata_configuration_updates: self
                    .document_metadata_configuration_updates,
                capacity_units: self.capacity_units,
                user_token_configurations: self.user_token_configurations,
                user_context_policy: self.user_context_policy,
                user_group_resolution_configuration: self.user_group_resolution_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIndexInputOperationOutputAlias = crate::operation::UpdateIndex;
#[doc(hidden)]
pub type UpdateIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIndexInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIndex`](crate::operation::UpdateIndex)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIndexInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIndexInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIndexInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateIndex",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_index(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIndex",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIndexInput`](crate::input::UpdateIndexInput)
    pub fn builder() -> crate::input::update_index_input::Builder {
        crate::input::update_index_input::Builder::default()
    }
}

/// See [`UpdateQuerySuggestionsBlockListInput`](crate::input::UpdateQuerySuggestionsBlockListInput)
pub mod update_query_suggestions_block_list_input {
    /// A builder for [`UpdateQuerySuggestionsBlockListInput`](crate::input::UpdateQuerySuggestionsBlockListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_s3_path: std::option::Option<crate::model::S3Path>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the index for a block list.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index for a block list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The unique identifier of a block list.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a block list.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of a block list.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a block list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description for a block list.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for a block list.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The S3 path where your block list text file sits in S3.</p>
        /// <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p>
        /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>
        pub fn source_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.source_s3_path = Some(input);
            self
        }
        /// <p>The S3 path where your block list text file sits in S3.</p>
        /// <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p>
        /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.source_s3_path = input;
            self
        }
        /// <p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateQuerySuggestionsBlockListInput`](crate::input::UpdateQuerySuggestionsBlockListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateQuerySuggestionsBlockListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateQuerySuggestionsBlockListInput {
                index_id: self.index_id,
                id: self.id,
                name: self.name,
                description: self.description,
                source_s3_path: self.source_s3_path,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateQuerySuggestionsBlockListInputOperationOutputAlias =
    crate::operation::UpdateQuerySuggestionsBlockList;
#[doc(hidden)]
pub type UpdateQuerySuggestionsBlockListInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateQuerySuggestionsBlockListInput {
    /// Consumes the builder and constructs an Operation<[`UpdateQuerySuggestionsBlockList`](crate::operation::UpdateQuerySuggestionsBlockList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateQuerySuggestionsBlockList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateQuerySuggestionsBlockListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateQuerySuggestionsBlockListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateQuerySuggestionsBlockListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateQuerySuggestionsBlockList",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_query_suggestions_block_list(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateQuerySuggestionsBlockList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateQuerySuggestionsBlockList",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateQuerySuggestionsBlockListInput`](crate::input::UpdateQuerySuggestionsBlockListInput)
    pub fn builder() -> crate::input::update_query_suggestions_block_list_input::Builder {
        crate::input::update_query_suggestions_block_list_input::Builder::default()
    }
}

/// See [`UpdateQuerySuggestionsConfigInput`](crate::input::UpdateQuerySuggestionsConfigInput)
pub mod update_query_suggestions_config_input {
    /// A builder for [`UpdateQuerySuggestionsConfigInput`](crate::input::UpdateQuerySuggestionsConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::Mode>,
        pub(crate) query_log_look_back_window_in_days: std::option::Option<i32>,
        pub(crate) include_queries_without_user_information: std::option::Option<bool>,
        pub(crate) minimum_number_of_querying_users: std::option::Option<i32>,
        pub(crate) minimum_query_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the index you want to update query suggestions settings for.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index you want to update query suggestions settings for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
        /// <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p>
        /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>
        pub fn mode(mut self, input: crate::model::Mode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
        /// <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p>
        /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::Mode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>How recent your queries are in your query log time window.</p>
        /// <p>The time window is the number of days from current day to past days.</p>
        /// <p>By default, Amazon Kendra sets this to 180.</p>
        pub fn query_log_look_back_window_in_days(mut self, input: i32) -> Self {
            self.query_log_look_back_window_in_days = Some(input);
            self
        }
        /// <p>How recent your queries are in your query log time window.</p>
        /// <p>The time window is the number of days from current day to past days.</p>
        /// <p>By default, Amazon Kendra sets this to 180.</p>
        pub fn set_query_log_look_back_window_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.query_log_look_back_window_in_days = input;
            self
        }
        /// <p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p>
        /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p>
        /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p>
        /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>
        pub fn include_queries_without_user_information(mut self, input: bool) -> Self {
            self.include_queries_without_user_information = Some(input);
            self
        }
        /// <p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p>
        /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p>
        /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p>
        /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>
        pub fn set_include_queries_without_user_information(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_queries_without_user_information = input;
            self
        }
        /// <p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>
        /// <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn minimum_number_of_querying_users(mut self, input: i32) -> Self {
            self.minimum_number_of_querying_users = Some(input);
            self
        }
        /// <p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>
        /// <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn set_minimum_number_of_querying_users(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.minimum_number_of_querying_users = input;
            self
        }
        /// <p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p>
        /// <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn minimum_query_count(mut self, input: i32) -> Self {
            self.minimum_query_count = Some(input);
            self
        }
        /// <p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p>
        /// <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn set_minimum_query_count(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_query_count = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateQuerySuggestionsConfigInput`](crate::input::UpdateQuerySuggestionsConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateQuerySuggestionsConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateQuerySuggestionsConfigInput {
                index_id: self.index_id,
                mode: self.mode,
                query_log_look_back_window_in_days: self.query_log_look_back_window_in_days,
                include_queries_without_user_information: self
                    .include_queries_without_user_information,
                minimum_number_of_querying_users: self.minimum_number_of_querying_users,
                minimum_query_count: self.minimum_query_count,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateQuerySuggestionsConfigInputOperationOutputAlias =
    crate::operation::UpdateQuerySuggestionsConfig;
#[doc(hidden)]
pub type UpdateQuerySuggestionsConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateQuerySuggestionsConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateQuerySuggestionsConfig`](crate::operation::UpdateQuerySuggestionsConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateQuerySuggestionsConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateQuerySuggestionsConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateQuerySuggestionsConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateQuerySuggestionsConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateQuerySuggestionsConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_query_suggestions_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateQuerySuggestionsConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateQuerySuggestionsConfig",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateQuerySuggestionsConfigInput`](crate::input::UpdateQuerySuggestionsConfigInput)
    pub fn builder() -> crate::input::update_query_suggestions_config_input::Builder {
        crate::input::update_query_suggestions_config_input::Builder::default()
    }
}

/// See [`UpdateThesaurusInput`](crate::input::UpdateThesaurusInput)
pub mod update_thesaurus_input {
    /// A builder for [`UpdateThesaurusInput`](crate::input::UpdateThesaurusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) source_s3_path: std::option::Option<crate::model::S3Path>,
    }
    impl Builder {
        /// <p>The identifier of the thesaurus to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the thesaurus to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The updated name of the thesaurus.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name of the thesaurus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to update.</p>
        pub fn index_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_id = Some(input.into());
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to update.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_id = input;
            self
        }
        /// <p>The updated description of the thesaurus.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the thesaurus.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated role ARN of the thesaurus.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The updated role ARN of the thesaurus.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3 bucket.</p>
        pub fn source_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.source_s3_path = Some(input);
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3 bucket.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.source_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThesaurusInput`](crate::input::UpdateThesaurusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateThesaurusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateThesaurusInput {
                id: self.id,
                name: self.name,
                index_id: self.index_id,
                description: self.description,
                role_arn: self.role_arn,
                source_s3_path: self.source_s3_path,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateThesaurusInputOperationOutputAlias = crate::operation::UpdateThesaurus;
#[doc(hidden)]
pub type UpdateThesaurusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateThesaurusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateThesaurus`](crate::operation::UpdateThesaurus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateThesaurus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateThesaurusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateThesaurusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateThesaurusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSKendraFrontendService.UpdateThesaurus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_thesaurus(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateThesaurus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateThesaurus",
            "kendra",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateThesaurusInput`](crate::input::UpdateThesaurusInput)
    pub fn builder() -> crate::input::update_thesaurus_input::Builder {
        crate::input::update_thesaurus_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThesaurusInput {
    /// <p>The identifier of the thesaurus to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The updated name of the thesaurus.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the index associated with the thesaurus to update.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The updated description of the thesaurus.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated role ARN of the thesaurus.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Information required to find a specific file in an Amazon S3 bucket.</p>
    pub source_s3_path: std::option::Option<crate::model::S3Path>,
}
impl UpdateThesaurusInput {
    /// <p>The identifier of the thesaurus to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The updated name of the thesaurus.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the index associated with the thesaurus to update.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The updated description of the thesaurus.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated role ARN of the thesaurus.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Information required to find a specific file in an Amazon S3 bucket.</p>
    pub fn source_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.source_s3_path.as_ref()
    }
}
impl std::fmt::Debug for UpdateThesaurusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThesaurusInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("index_id", &self.index_id);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("source_s3_path", &self.source_s3_path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateQuerySuggestionsConfigInput {
    /// <p>The identifier of the index you want to update query suggestions settings for.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
    /// <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p>
    /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>
    pub mode: std::option::Option<crate::model::Mode>,
    /// <p>How recent your queries are in your query log time window.</p>
    /// <p>The time window is the number of days from current day to past days.</p>
    /// <p>By default, Amazon Kendra sets this to 180.</p>
    pub query_log_look_back_window_in_days: std::option::Option<i32>,
    /// <p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p>
    /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p>
    /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p>
    /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>
    pub include_queries_without_user_information: std::option::Option<bool>,
    /// <p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>
    /// <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p>
    /// <p>How you tune this setting depends on your specific needs.</p>
    pub minimum_number_of_querying_users: std::option::Option<i32>,
    /// <p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p>
    /// <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p>
    /// <p>How you tune this setting depends on your specific needs.</p>
    pub minimum_query_count: std::option::Option<i32>,
}
impl UpdateQuerySuggestionsConfigInput {
    /// <p>The identifier of the index you want to update query suggestions settings for.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
    /// <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p>
    /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::Mode> {
        self.mode.as_ref()
    }
    /// <p>How recent your queries are in your query log time window.</p>
    /// <p>The time window is the number of days from current day to past days.</p>
    /// <p>By default, Amazon Kendra sets this to 180.</p>
    pub fn query_log_look_back_window_in_days(&self) -> std::option::Option<i32> {
        self.query_log_look_back_window_in_days
    }
    /// <p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p>
    /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p>
    /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p>
    /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>
    pub fn include_queries_without_user_information(&self) -> std::option::Option<bool> {
        self.include_queries_without_user_information
    }
    /// <p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>
    /// <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p>
    /// <p>How you tune this setting depends on your specific needs.</p>
    pub fn minimum_number_of_querying_users(&self) -> std::option::Option<i32> {
        self.minimum_number_of_querying_users
    }
    /// <p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p>
    /// <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p>
    /// <p>How you tune this setting depends on your specific needs.</p>
    pub fn minimum_query_count(&self) -> std::option::Option<i32> {
        self.minimum_query_count
    }
}
impl std::fmt::Debug for UpdateQuerySuggestionsConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateQuerySuggestionsConfigInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("mode", &self.mode);
        formatter.field(
            "query_log_look_back_window_in_days",
            &self.query_log_look_back_window_in_days,
        );
        formatter.field(
            "include_queries_without_user_information",
            &self.include_queries_without_user_information,
        );
        formatter.field(
            "minimum_number_of_querying_users",
            &self.minimum_number_of_querying_users,
        );
        formatter.field("minimum_query_count", &self.minimum_query_count);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index for a block list.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of a block list.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of a block list.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for a block list.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The S3 path where your block list text file sits in S3.</p>
    /// <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p>
    /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>
    pub source_s3_path: std::option::Option<crate::model::S3Path>,
    /// <p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl UpdateQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index for a block list.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The unique identifier of a block list.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of a block list.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description for a block list.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The S3 path where your block list text file sits in S3.</p>
    /// <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p>
    /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>
    pub fn source_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.source_s3_path.as_ref()
    }
    /// <p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateQuerySuggestionsBlockListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateQuerySuggestionsBlockListInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("source_s3_path", &self.source_s3_path);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIndexInput {
    /// <p>The identifier of the index to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the index to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A new description for the index.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The document metadata to update. </p>
    pub document_metadata_configuration_updates:
        std::option::Option<std::vec::Vec<crate::model::DocumentMetadataConfiguration>>,
    /// <p>Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day.</p>
    /// <p>If you are using extra storage units, you can't reduce the storage capacity below that required to meet the storage needs for your index.</p>
    pub capacity_units: std::option::Option<crate::model::CapacityUnitsConfiguration>,
    /// <p>The user token configuration.</p>
    pub user_token_configurations:
        std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
    /// <p>The user context policy.</p>
    pub user_context_policy: std::option::Option<crate::model::UserContextPolicy>,
    /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
    pub user_group_resolution_configuration:
        std::option::Option<crate::model::UserGroupResolutionConfiguration>,
}
impl UpdateIndexInput {
    /// <p>The identifier of the index to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the index to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A new description for the index.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The document metadata to update. </p>
    pub fn document_metadata_configuration_updates(
        &self,
    ) -> std::option::Option<&[crate::model::DocumentMetadataConfiguration]> {
        self.document_metadata_configuration_updates.as_deref()
    }
    /// <p>Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day.</p>
    /// <p>If you are using extra storage units, you can't reduce the storage capacity below that required to meet the storage needs for your index.</p>
    pub fn capacity_units(&self) -> std::option::Option<&crate::model::CapacityUnitsConfiguration> {
        self.capacity_units.as_ref()
    }
    /// <p>The user token configuration.</p>
    pub fn user_token_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::UserTokenConfiguration]> {
        self.user_token_configurations.as_deref()
    }
    /// <p>The user context policy.</p>
    pub fn user_context_policy(&self) -> std::option::Option<&crate::model::UserContextPolicy> {
        self.user_context_policy.as_ref()
    }
    /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
    pub fn user_group_resolution_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UserGroupResolutionConfiguration> {
        self.user_group_resolution_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIndexInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("description", &self.description);
        formatter.field(
            "document_metadata_configuration_updates",
            &self.document_metadata_configuration_updates,
        );
        formatter.field("capacity_units", &self.capacity_units);
        formatter.field("user_token_configurations", &self.user_token_configurations);
        formatter.field("user_context_policy", &self.user_context_policy);
        formatter.field(
            "user_group_resolution_configuration",
            &self.user_group_resolution_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of your Amazon Kendra experience you want to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience you want to update.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Provides the user configuration information. This includes the Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.</p>
    pub configuration: std::option::Option<crate::model::ExperienceConfiguration>,
    /// <p>The description of your Amazon Kendra experience you want to update.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of your Amazon Kendra experience you want to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience you want to update.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Provides the user configuration information. This includes the Amazon Web Services SSO field name that contains the identifiers of your users, such as their emails.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ExperienceConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The description of your Amazon Kendra experience you want to update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperienceInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("index_id", &self.index_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourceInput {
    /// <p>The unique identifier of the data source to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the data source to update. The name of the data source can't be updated. To rename a data source you must delete the data source and re-create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the data source to update.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>Configuration information for an Amazon Kendra data source.</p>
    pub configuration: std::option::Option<crate::model::DataSourceConfiguration>,
    /// <p>The new description for the data source.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The new update schedule for the data source.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The code for a language. This allows you to support a language for all documents when updating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
    /// <p>Configuration information for altering document metadata and content during the document ingestion process when you update a data source.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub custom_document_enrichment_configuration:
        std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
}
impl UpdateDataSourceInput {
    /// <p>The unique identifier of the data source to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the data source to update. The name of the data source can't be updated. To rename a data source you must delete the data source and re-create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the index that contains the data source to update.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>Configuration information for an Amazon Kendra data source.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::DataSourceConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The new description for the data source.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The new update schedule for the data source.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The code for a language. This allows you to support a language for all documents when updating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// <p>Configuration information for altering document metadata and content during the document ingestion process when you update a data source.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub fn custom_document_enrichment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDocumentEnrichmentConfiguration> {
        self.custom_document_enrichment_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourceInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("index_id", &self.index_id);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("schedule", &self.schedule);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("language_code", &self.language_code);
        formatter.field(
            "custom_document_enrichment_configuration",
            &self.custom_document_enrichment_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitFeedbackInput {
    /// <p>The identifier of the index that was queried.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> operation.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>
    pub click_feedback_items: std::option::Option<std::vec::Vec<crate::model::ClickFeedback>>,
    /// <p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>
    pub relevance_feedback_items:
        std::option::Option<std::vec::Vec<crate::model::RelevanceFeedback>>,
}
impl SubmitFeedbackInput {
    /// <p>The identifier of the index that was queried.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> operation.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>
    pub fn click_feedback_items(&self) -> std::option::Option<&[crate::model::ClickFeedback]> {
        self.click_feedback_items.as_deref()
    }
    /// <p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>
    pub fn relevance_feedback_items(
        &self,
    ) -> std::option::Option<&[crate::model::RelevanceFeedback]> {
        self.relevance_feedback_items.as_deref()
    }
}
impl std::fmt::Debug for SubmitFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitFeedbackInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("query_id", &self.query_id);
        formatter.field("click_feedback_items", &self.click_feedback_items);
        formatter.field("relevance_feedback_items", &self.relevance_feedback_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDataSourceSyncJobInput {
    /// <p>The identifier of the data source for which to stop the synchronization jobs.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl StopDataSourceSyncJobInput {
    /// <p>The identifier of the data source for which to stop the synchronization jobs.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index that contains the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for StopDataSourceSyncJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDataSourceSyncJobInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDataSourceSyncJobInput {
    /// <p>The identifier of the data source to synchronize.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl StartDataSourceSyncJobInput {
    /// <p>The identifier of the data source to synchronize.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index that contains the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for StartDataSourceSyncJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDataSourceSyncJobInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryInput {
    /// <p>The unique identifier of the index to search. The identifier is returned in the response from the <code>CreateIndex</code> operation.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The text to search for.</p>
    pub query_text: std::option::Option<std::string::String>,
    /// <p>Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p>
    /// <p>The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.</p>
    pub attribute_filter: std::option::Option<crate::model::AttributeFilter>,
    /// <p>An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user.</p>
    pub facets: std::option::Option<std::vec::Vec<crate::model::Facet>>,
    /// <p>An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. </p>
    pub requested_document_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Sets the type of query. Only results for the specified query type are returned.</p>
    pub query_result_type_filter: std::option::Option<crate::model::QueryResultType>,
    /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
    /// <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
    /// <p>If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
    /// <p>If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>
    pub document_relevance_override_configurations:
        std::option::Option<std::vec::Vec<crate::model::DocumentRelevanceConfiguration>>,
    /// <p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>
    pub page_number: std::option::Option<i32>,
    /// <p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>
    pub page_size: std::option::Option<i32>,
    /// <p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
    /// <p>If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>
    pub sorting_configuration: std::option::Option<crate::model::SortingConfiguration>,
    /// <p>The user context token or user and group information.</p>
    pub user_context: std::option::Option<crate::model::UserContext>,
    /// <p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the <code>VisitorId</code>.</p>
    pub visitor_id: std::option::Option<std::string::String>,
}
impl QueryInput {
    /// <p>The unique identifier of the index to search. The identifier is returned in the response from the <code>CreateIndex</code> operation.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The text to search for.</p>
    pub fn query_text(&self) -> std::option::Option<&str> {
        self.query_text.as_deref()
    }
    /// <p>Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p>
    /// <p>The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.</p>
    pub fn attribute_filter(&self) -> std::option::Option<&crate::model::AttributeFilter> {
        self.attribute_filter.as_ref()
    }
    /// <p>An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user.</p>
    pub fn facets(&self) -> std::option::Option<&[crate::model::Facet]> {
        self.facets.as_deref()
    }
    /// <p>An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. </p>
    pub fn requested_document_attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.requested_document_attributes.as_deref()
    }
    /// <p>Sets the type of query. Only results for the specified query type are returned.</p>
    pub fn query_result_type_filter(&self) -> std::option::Option<&crate::model::QueryResultType> {
        self.query_result_type_filter.as_ref()
    }
    /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
    /// <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
    /// <p>If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
    /// <p>If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>
    pub fn document_relevance_override_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DocumentRelevanceConfiguration]> {
        self.document_relevance_override_configurations.as_deref()
    }
    /// <p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>
    pub fn page_number(&self) -> std::option::Option<i32> {
        self.page_number
    }
    /// <p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
    /// <p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
    /// <p>If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>
    pub fn sorting_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SortingConfiguration> {
        self.sorting_configuration.as_ref()
    }
    /// <p>The user context token or user and group information.</p>
    pub fn user_context(&self) -> std::option::Option<&crate::model::UserContext> {
        self.user_context.as_ref()
    }
    /// <p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the <code>VisitorId</code>.</p>
    pub fn visitor_id(&self) -> std::option::Option<&str> {
        self.visitor_id.as_deref()
    }
}
impl std::fmt::Debug for QueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("query_text", &self.query_text);
        formatter.field("attribute_filter", &self.attribute_filter);
        formatter.field("facets", &self.facets);
        formatter.field(
            "requested_document_attributes",
            &self.requested_document_attributes,
        );
        formatter.field("query_result_type_filter", &self.query_result_type_filter);
        formatter.field(
            "document_relevance_override_configurations",
            &self.document_relevance_override_configurations,
        );
        formatter.field("page_number", &self.page_number);
        formatter.field("page_size", &self.page_size);
        formatter.field("sorting_configuration", &self.sorting_configuration);
        formatter.field("user_context", &self.user_context);
        formatter.field("visitor_id", &self.visitor_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPrincipalMappingInput {
    /// <p>The identifier of the index you want to map users to their groups.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source you want to map users to their groups.</p>
    /// <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the group you want to map its users to.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The list that contains your users or sub groups that belong the same group.</p>
    /// <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p>
    /// <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>
    pub group_members: std::option::Option<crate::model::GroupMembers>,
    /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
    /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p>
    /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.</p>
    pub ordering_id: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl PutPrincipalMappingInput {
    /// <p>The identifier of the index you want to map users to their groups.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifier of the data source you want to map users to their groups.</p>
    /// <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The identifier of the group you want to map its users to.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The list that contains your users or sub groups that belong the same group.</p>
    /// <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p>
    /// <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>
    pub fn group_members(&self) -> std::option::Option<&crate::model::GroupMembers> {
        self.group_members.as_ref()
    }
    /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
    /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p>
    /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.</p>
    pub fn ordering_id(&self) -> std::option::Option<i64> {
        self.ordering_id
    }
    /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for PutPrincipalMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPrincipalMappingInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("group_members", &self.group_members);
        formatter.field("ordering_id", &self.ordering_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThesauriInput {
    /// <p>The identifier of the index associated with the thesaurus to list.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of thesauri to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListThesauriInput {
    /// <p>The identifier of the index associated with the thesaurus to list.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of thesauri to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListThesauriInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThesauriInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQuerySuggestionsBlockListsInput {
    /// <p>The identifier of the index for a list of all block lists that exist for that index.</p>
    /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of block lists to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListQuerySuggestionsBlockListsInput {
    /// <p>The identifier of the index for a list of all block lists that exist for that index.</p>
    /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of block lists to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListQuerySuggestionsBlockListsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQuerySuggestionsBlockListsInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIndicesInput {
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (<code>DataSourceSummaryItems</code>). </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of data sources to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListIndicesInput {
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (<code>DataSourceSummaryItems</code>). </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of data sources to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListIndicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIndicesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsOlderThanOrderingIdInput {
    /// <p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>
    pub ordering_id: std::option::Option<i64>,
    /// <p> If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of returned groups that are mapped to users before a given ordering or timestamp identifier. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListGroupsOlderThanOrderingIdInput {
    /// <p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>
    pub fn ordering_id(&self) -> std::option::Option<i64> {
        self.ordering_id
    }
    /// <p> If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of returned groups that are mapped to users before a given ordering or timestamp identifier. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListGroupsOlderThanOrderingIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsOlderThanOrderingIdInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("ordering_id", &self.ordering_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFaqsInput {
    /// <p>The index that contains the FAQ lists.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of FAQs.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFaqsInput {
    /// <p>The index that contains the FAQ lists.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of FAQs.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFaqsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFaqsInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExperiencesInput {
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon Kendra experiences.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of returned Amazon Kendra experiences.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListExperiencesInput {
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon Kendra experiences.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of returned Amazon Kendra experiences.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListExperiencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExperiencesInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExperienceEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExperienceEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExperienceEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExperienceEntitiesInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntityPersonasInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of returned users or groups.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEntityPersonasInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of returned users or groups.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEntityPersonasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntityPersonasInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSourceSyncJobsInput {
    /// <p>The identifier of the data source.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of jobs.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. </p>
    pub start_time_filter: std::option::Option<crate::model::TimeRange>,
    /// <p>When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>
    pub status_filter: std::option::Option<crate::model::DataSourceSyncJobStatus>,
}
impl ListDataSourceSyncJobsInput {
    /// <p>The identifier of the data source.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index that contains the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of jobs.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. </p>
    pub fn start_time_filter(&self) -> std::option::Option<&crate::model::TimeRange> {
        self.start_time_filter.as_ref()
    }
    /// <p>When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::DataSourceSyncJobStatus> {
        self.status_filter.as_ref()
    }
}
impl std::fmt::Debug for ListDataSourceSyncJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSourceSyncJobsInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("start_time_filter", &self.start_time_filter);
        formatter.field("status_filter", &self.status_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSourcesInput {
    /// <p>The identifier of the index that contains the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (<code>DataSourceSummaryItems</code>). </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of data sources to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDataSourcesInput {
    /// <p>The identifier of the index that contains the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (<code>DataSourceSummaryItems</code>). </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of data sources to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDataSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSourcesInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotsInput {
    /// <p>The identifier of the index to get search metrics data.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:</p>
    /// <ul>
    /// <li> <p> <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.</p> </li>
    /// <li> <p> <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
    /// <li> <p> <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
    /// <li> <p> <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before the current date.</p> </li>
    /// <li> <p> <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day of the month.</p> </li>
    /// <li> <p> <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and ending on last day of the month.</p> </li>
    /// </ul>
    pub interval: std::option::Option<crate::model::Interval>,
    /// <p>The metric you want to retrieve. You can specify only one metric per call.</p>
    /// <p>For more information about the metrics you can view, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search analytics</a>.</p>
    pub metric_type: std::option::Option<crate::model::MetricType>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of returned data for the metric.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetSnapshotsInput {
    /// <p>The identifier of the index to get search metrics data.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:</p>
    /// <ul>
    /// <li> <p> <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.</p> </li>
    /// <li> <p> <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
    /// <li> <p> <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following Saturday.</p> </li>
    /// <li> <p> <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before the current date.</p> </li>
    /// <li> <p> <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day of the month.</p> </li>
    /// <li> <p> <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and ending on last day of the month.</p> </li>
    /// </ul>
    pub fn interval(&self) -> std::option::Option<&crate::model::Interval> {
        self.interval.as_ref()
    }
    /// <p>The metric you want to retrieve. You can specify only one metric per call.</p>
    /// <p>For more information about the metrics you can view, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search analytics</a>.</p>
    pub fn metric_type(&self) -> std::option::Option<&crate::model::MetricType> {
        self.metric_type.as_ref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of returned data for the metric.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetSnapshotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotsInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("interval", &self.interval);
        formatter.field("metric_type", &self.metric_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQuerySuggestionsInput {
    /// <p>The identifier of the index you want to get query suggestions from.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The text of a user's query to generate query suggestions.</p>
    /// <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p>
    /// <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>
    pub query_text: std::option::Option<std::string::String>,
    /// <p>The maximum number of query suggestions you want to show to your users.</p>
    pub max_suggestions_count: std::option::Option<i32>,
}
impl GetQuerySuggestionsInput {
    /// <p>The identifier of the index you want to get query suggestions from.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The text of a user's query to generate query suggestions.</p>
    /// <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p>
    /// <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>
    pub fn query_text(&self) -> std::option::Option<&str> {
        self.query_text.as_deref()
    }
    /// <p>The maximum number of query suggestions you want to show to your users.</p>
    pub fn max_suggestions_count(&self) -> std::option::Option<i32> {
        self.max_suggestions_count
    }
}
impl std::fmt::Debug for GetQuerySuggestionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQuerySuggestionsInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("query_text", &self.query_text);
        formatter.field("max_suggestions_count", &self.max_suggestions_count);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociatePersonasFromEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifiers of users or groups in your Amazon Web Services SSO identity source. For example, user IDs could be user emails.</p>
    pub entity_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociatePersonasFromEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifiers of users or groups in your Amazon Web Services SSO identity source. For example, user IDs could be user emails.</p>
    pub fn entity_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_ids.as_deref()
    }
}
impl std::fmt::Debug for DisassociatePersonasFromEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociatePersonasFromEntitiesInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("entity_ids", &self.entity_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateEntitiesFromExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
    pub entity_list: std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
}
impl DisassociateEntitiesFromExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
    pub fn entity_list(&self) -> std::option::Option<&[crate::model::EntityConfiguration]> {
        self.entity_list.as_deref()
    }
}
impl std::fmt::Debug for DisassociateEntitiesFromExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateEntitiesFromExperienceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("entity_list", &self.entity_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThesaurusInput {
    /// <p>The identifier of the thesaurus to describe.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index associated with the thesaurus to describe.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DescribeThesaurusInput {
    /// <p>The identifier of the thesaurus to describe.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index associated with the thesaurus to describe.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeThesaurusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThesaurusInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeQuerySuggestionsConfigInput {
    /// <p>The identifier of the index you want to describe query suggestions settings for.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DescribeQuerySuggestionsConfigInput {
    /// <p>The identifier of the index you want to describe query suggestions settings for.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeQuerySuggestionsConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeQuerySuggestionsConfigInput");
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index for the block list.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the block list.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index for the block list.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The unique identifier of the block list.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeQuerySuggestionsBlockListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeQuerySuggestionsBlockListInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePrincipalMappingInput {
    /// <p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl DescribePrincipalMappingInput {
    /// <p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePrincipalMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePrincipalMappingInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIndexInput {
    /// <p>The name of the index to describe.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeIndexInput {
    /// <p>The name of the index to describe.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIndexInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFaqInput {
    /// <p>The unique identifier of the FAQ.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the FAQ.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DescribeFaqInput {
    /// <p>The unique identifier of the FAQ.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index that contains the FAQ.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFaqInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFaqInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to get information on.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience you want to get information on.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DescribeExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to get information on.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience you want to get information on.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExperienceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSourceInput {
    /// <p>The unique identifier of the data source to describe.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that contains the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DescribeDataSourceInput {
    /// <p>The unique identifier of the data source to describe.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index that contains the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSourceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThesaurusInput {
    /// <p>The identifier of the thesaurus to delete.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index associated with the thesaurus to delete.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DeleteThesaurusInput {
    /// <p>The identifier of the thesaurus to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index associated with the thesaurus to delete.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteThesaurusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThesaurusInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQuerySuggestionsBlockListInput {
    /// <p>The identifier of the you want to delete a block list from.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the block list that needs to be deleted.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteQuerySuggestionsBlockListInput {
    /// <p>The identifier of the you want to delete a block list from.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The unique identifier of the block list that needs to be deleted.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteQuerySuggestionsBlockListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQuerySuggestionsBlockListInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePrincipalMappingInput {
    /// <p>The identifier of the index you want to delete a group from.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source you want to delete a group from.</p>
    /// <p>This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the group you want to delete.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
    /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p>
    /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. </p>
    pub ordering_id: std::option::Option<i64>,
}
impl DeletePrincipalMappingInput {
    /// <p>The identifier of the index you want to delete a group from.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The identifier of the data source you want to delete a group from.</p>
    /// <p>This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The identifier of the group you want to delete.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p>
    /// <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn't get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p>
    /// <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. </p>
    pub fn ordering_id(&self) -> std::option::Option<i64> {
        self.ordering_id
    }
}
impl std::fmt::Debug for DeletePrincipalMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePrincipalMappingInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("ordering_id", &self.ordering_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIndexInput {
    /// <p>The identifier of the index to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteIndexInput {
    /// <p>The identifier of the index to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIndexInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFaqInput {
    /// <p>The identifier of the FAQ to remove.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The index to remove the FAQ from.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DeleteFaqInput {
    /// <p>The identifier of the FAQ to remove.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The index to remove the FAQ from.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFaqInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFaqInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to delete.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience you want to delete.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DeleteExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience you want to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience you want to delete.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExperienceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSourceInput {
    /// <p>The unique identifier of the data source to delete.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the index associated with the data source.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl DeleteDataSourceInput {
    /// <p>The unique identifier of the data source to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The unique identifier of the index associated with the data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSourceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThesaurusInput {
    /// <p>The unique identifier of the index for the new thesaurus. </p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The name for the new thesaurus.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description for the new thesaurus.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The thesaurus file Amazon S3 source path. </p>
    pub source_s3_path: std::option::Option<crate::model::S3Path>,
    /// <p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation with the same client token will create only one thesaurus. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateThesaurusInput {
    /// <p>The unique identifier of the index for the new thesaurus. </p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The name for the new thesaurus.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description for the new thesaurus.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The thesaurus file Amazon S3 source path. </p>
    pub fn source_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.source_s3_path.as_ref()
    }
    /// <p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation with the same client token will create only one thesaurus. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateThesaurusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThesaurusInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("source_s3_path", &self.source_s3_path);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>A user friendly name for the block list.</p>
    /// <p>For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A user-friendly description for the block list.</p>
    /// <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The S3 path to your block list text file in your S3 bucket.</p>
    /// <p>Each block word or phrase should be on a separate line in a text file.</p>
    /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
    pub source_s3_path: std::option::Option<crate::model::S3Path>,
    /// <p>A token that you provide to identify the request to create a query suggestions block list.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.</p>
    /// <p>You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A tag that you can assign to a block list that categorizes the block list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateQuerySuggestionsBlockListInput {
    /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>A user friendly name for the block list.</p>
    /// <p>For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A user-friendly description for the block list.</p>
    /// <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The S3 path to your block list text file in your S3 bucket.</p>
    /// <p>Each block word or phrase should be on a separate line in a text file.</p>
    /// <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>
    pub fn source_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.source_s3_path.as_ref()
    }
    /// <p>A token that you provide to identify the request to create a query suggestions block list.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.</p>
    /// <p>You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A tag that you can assign to a block list that categorizes the block list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateQuerySuggestionsBlockListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQuerySuggestionsBlockListInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("source_s3_path", &self.source_s3_path);
        formatter.field("client_token", &self.client_token);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIndexInput {
    /// <p>The name for the new index.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases. Once you set the edition for an index, it can't be changed.</p>
    /// <p>The <code>Edition</code> parameter is optional. If you don't supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p>
    /// <p>For more information on quota limits for enterprise and developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
    pub edition: std::option::Option<crate::model::IndexEdition>,
    /// <p>An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> operation to index documents from an Amazon S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>A description for the index.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> operation with the same client token will create only one index.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The user token configuration.</p>
    pub user_token_configurations:
        std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
    /// <p>The user context policy.</p>
    /// <dl>
    /// <dt>
    /// ATTRIBUTE_FILTER
    /// </dt>
    /// <dd>
    /// <p>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>. </p>
    /// </dd>
    /// <dt>
    /// USER_TOKEN
    /// </dt>
    /// <dd>
    /// <p>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p>
    /// </dd>
    /// </dl>
    pub user_context_policy: std::option::Option<crate::model::UserContextPolicy>,
    /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
    pub user_group_resolution_configuration:
        std::option::Option<crate::model::UserGroupResolutionConfiguration>,
}
impl CreateIndexInput {
    /// <p>The name for the new index.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases. Once you set the edition for an index, it can't be changed.</p>
    /// <p>The <code>Edition</code> parameter is optional. If you don't supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p>
    /// <p>For more information on quota limits for enterprise and developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
    pub fn edition(&self) -> std::option::Option<&crate::model::IndexEdition> {
        self.edition.as_ref()
    }
    /// <p>An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> operation to index documents from an Amazon S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
    /// <p>A description for the index.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> operation with the same client token will create only one index.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The user token configuration.</p>
    pub fn user_token_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::UserTokenConfiguration]> {
        self.user_token_configurations.as_deref()
    }
    /// <p>The user context policy.</p>
    /// <dl>
    /// <dt>
    /// ATTRIBUTE_FILTER
    /// </dt>
    /// <dd>
    /// <p>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>. </p>
    /// </dd>
    /// <dt>
    /// USER_TOKEN
    /// </dt>
    /// <dd>
    /// <p>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p>
    /// </dd>
    /// </dl>
    pub fn user_context_policy(&self) -> std::option::Option<&crate::model::UserContextPolicy> {
        self.user_context_policy.as_ref()
    }
    /// <p>Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
    pub fn user_group_resolution_configuration(
        &self,
    ) -> std::option::Option<&crate::model::UserGroupResolutionConfiguration> {
        self.user_group_resolution_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIndexInput");
        formatter.field("name", &self.name);
        formatter.field("edition", &self.edition);
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.field("user_token_configurations", &self.user_token_configurations);
        formatter.field("user_context_policy", &self.user_context_policy);
        formatter.field(
            "user_group_resolution_configuration",
            &self.user_group_resolution_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFaqInput {
    /// <p>The identifier of the index that contains the FAQ.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The name that should be associated with the FAQ.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the FAQ.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The S3 location of the FAQ input data.</p>
    pub s3_path: std::option::Option<crate::model::S3Path>,
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
    /// <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>
    pub file_format: std::option::Option<crate::model::FaqFileFormat>,
    /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> operation with the same client token will create only one FAQ. </p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
}
impl CreateFaqInput {
    /// <p>The identifier of the index that contains the FAQ.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The name that should be associated with the FAQ.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the FAQ.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The S3 location of the FAQ input data.</p>
    pub fn s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.s3_path.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p>
    /// <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::FaqFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> operation with the same client token will create only one FAQ. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
}
impl std::fmt::Debug for CreateFaqInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFaqInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("s3_path", &self.s3_path);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("file_format", &self.file_format);
        formatter.field("client_token", &self.client_token);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExperienceInput {
    /// <p>A name for your Amazon Kendra experience.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Provides the configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>
    pub configuration: std::option::Option<crate::model::ExperienceConfiguration>,
    /// <p>A description for your Amazon Kendra experience.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the <code>CreateExperience</code> operation with the same client token creates only one Amazon Kendra experience.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateExperienceInput {
    /// <p>A name for your Amazon Kendra experience.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> operations, <code>QuerySuggestions</code> operations, <code>SubmitFeedback</code> operations, and Amazon Web Services SSO that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Provides the configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ExperienceConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>A description for your Amazon Kendra experience.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the <code>CreateExperience</code> operation with the same client token creates only one Amazon Kendra experience.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExperienceInput");
        formatter.field("name", &self.name);
        formatter.field("index_id", &self.index_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceInput {
    /// <p>A unique name for the data source. A data source name can't be changed without deleting and recreating the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the index that should be associated with this data source.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The type of repository that contains the data source.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The connector configuration information that is required to access the repository.</p>
    /// <p>You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    /// <p>The <code>Configuration</code> parameter is required for all other data sources.</p>
    pub configuration: std::option::Option<crate::model::DataSourceConfiguration>,
    /// <p>A description for the data source.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> operation to update the index.</p>
    /// <p>You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    /// <p>You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    /// <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A token that you provide to identify the request to create a data source. Multiple calls to the <code>CreateDataSource</code> operation with the same client token will create only one data source.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The code for a language. This allows you to support a language for all documents when creating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
    /// <p>Configuration information for altering document metadata and content during the document ingestion process when you create a data source.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub custom_document_enrichment_configuration:
        std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
}
impl CreateDataSourceInput {
    /// <p>A unique name for the data source. A data source name can't be changed without deleting and recreating the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the index that should be associated with this data source.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The type of repository that contains the data source.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The connector configuration information that is required to access the repository.</p>
    /// <p>You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    /// <p>The <code>Configuration</code> parameter is required for all other data sources.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::DataSourceConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>A description for the data source.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> operation to update the index.</p>
    /// <p>You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    /// <p>You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>
    /// <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A token that you provide to identify the request to create a data source. Multiple calls to the <code>CreateDataSource</code> operation with the same client token will create only one data source.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The code for a language. This allows you to support a language for all documents when creating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
    /// <p>Configuration information for altering document metadata and content during the document ingestion process when you create a data source.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub fn custom_document_enrichment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDocumentEnrichmentConfiguration> {
        self.custom_document_enrichment_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceInput");
        formatter.field("name", &self.name);
        formatter.field("index_id", &self.index_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("schedule", &self.schedule);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("language_code", &self.language_code);
        formatter.field(
            "custom_document_enrichment_configuration",
            &self.custom_document_enrichment_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClearQuerySuggestionsInput {
    /// <p>The identifier of the index you want to clear query suggestions from.</p>
    pub index_id: std::option::Option<std::string::String>,
}
impl ClearQuerySuggestionsInput {
    /// <p>The identifier of the index you want to clear query suggestions from.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
}
impl std::fmt::Debug for ClearQuerySuggestionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClearQuerySuggestionsInput");
        formatter.field("index_id", &self.index_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutDocumentInput {
    /// <p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> operation.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>One or more documents to add to the index.</p>
    /// <p>Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p>
    /// <p>Documents have the following file size limits.</p>
    /// <ul>
    /// <li> <p>5 MB total size for inline documents</p> </li>
    /// <li> <p>50 MB total size for files from an S3 bucket</p> </li>
    /// <li> <p>5 MB extracted text for any file</p> </li>
    /// </ul>
    /// <p>For more information about file size and transaction per second quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
    pub documents: std::option::Option<std::vec::Vec<crate::model::Document>>,
    /// <p>Configuration information for altering your document metadata and content during the document ingestion process when you use the <code>BatchPutDocument</code> operation.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub custom_document_enrichment_configuration:
        std::option::Option<crate::model::CustomDocumentEnrichmentConfiguration>,
}
impl BatchPutDocumentInput {
    /// <p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> operation.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>One or more documents to add to the index.</p>
    /// <p>Documents can include custom attributes. For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p>
    /// <p>Documents have the following file size limits.</p>
    /// <ul>
    /// <li> <p>5 MB total size for inline documents</p> </li>
    /// <li> <p>50 MB total size for files from an S3 bucket</p> </li>
    /// <li> <p>5 MB extracted text for any file</p> </li>
    /// </ul>
    /// <p>For more information about file size and transaction per second quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
    pub fn documents(&self) -> std::option::Option<&[crate::model::Document]> {
        self.documents.as_deref()
    }
    /// <p>Configuration information for altering your document metadata and content during the document ingestion process when you use the <code>BatchPutDocument</code> operation.</p>
    /// <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>
    pub fn custom_document_enrichment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CustomDocumentEnrichmentConfiguration> {
        self.custom_document_enrichment_configuration.as_ref()
    }
}
impl std::fmt::Debug for BatchPutDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutDocumentInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("documents", &self.documents);
        formatter.field(
            "custom_document_enrichment_configuration",
            &self.custom_document_enrichment_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDocumentStatusInput {
    /// <p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex </a> operation.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>
    pub document_info_list: std::option::Option<std::vec::Vec<crate::model::DocumentInfo>>,
}
impl BatchGetDocumentStatusInput {
    /// <p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex </a> operation.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>
    pub fn document_info_list(&self) -> std::option::Option<&[crate::model::DocumentInfo]> {
        self.document_info_list.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDocumentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDocumentStatusInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("document_info_list", &self.document_info_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDocumentInput {
    /// <p>The identifier of the index that contains the documents to delete.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>One or more identifiers for documents to delete from the index.</p>
    pub document_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Maps a particular data source sync job to a particular data source.</p>
    pub data_source_sync_job_metric_target:
        std::option::Option<crate::model::DataSourceSyncJobMetricTarget>,
}
impl BatchDeleteDocumentInput {
    /// <p>The identifier of the index that contains the documents to delete.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>One or more identifiers for documents to delete from the index.</p>
    pub fn document_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.document_id_list.as_deref()
    }
    /// <p>Maps a particular data source sync job to a particular data source.</p>
    pub fn data_source_sync_job_metric_target(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceSyncJobMetricTarget> {
        self.data_source_sync_job_metric_target.as_ref()
    }
}
impl std::fmt::Debug for BatchDeleteDocumentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDocumentInput");
        formatter.field("index_id", &self.index_id);
        formatter.field("document_id_list", &self.document_id_list);
        formatter.field(
            "data_source_sync_job_metric_target",
            &self.data_source_sync_job_metric_target,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatePersonasToEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>The personas that define the specific permissions of users or groups in your Amazon Web Services SSO identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>
    pub personas: std::option::Option<std::vec::Vec<crate::model::EntityPersonaConfiguration>>,
}
impl AssociatePersonasToEntitiesInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>The personas that define the specific permissions of users or groups in your Amazon Web Services SSO identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>
    pub fn personas(&self) -> std::option::Option<&[crate::model::EntityPersonaConfiguration]> {
        self.personas.as_deref()
    }
}
impl std::fmt::Debug for AssociatePersonasToEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatePersonasToEntitiesInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("personas", &self.personas);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateEntitiesToExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub index_id: std::option::Option<std::string::String>,
    /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
    pub entity_list: std::option::Option<std::vec::Vec<crate::model::EntityConfiguration>>,
}
impl AssociateEntitiesToExperienceInput {
    /// <p>The identifier of your Amazon Kendra experience.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the index for your Amazon Kendra experience.</p>
    pub fn index_id(&self) -> std::option::Option<&str> {
        self.index_id.as_deref()
    }
    /// <p>Lists users or groups in your Amazon Web Services SSO identity source.</p>
    pub fn entity_list(&self) -> std::option::Option<&[crate::model::EntityConfiguration]> {
        self.entity_list.as_deref()
    }
}
impl std::fmt::Debug for AssociateEntitiesToExperienceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateEntitiesToExperienceInput");
        formatter.field("id", &self.id);
        formatter.field("index_id", &self.index_id);
        formatter.field("entity_list", &self.entity_list);
        formatter.finish()
    }
}
