// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information required to find a specific file in an Amazon S3
/// bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Path {
    /// <p>The name of the S3 bucket that contains the file.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the file.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3Path {
    /// <p>The name of the S3 bucket that contains the file.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the file.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3Path {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Path");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3Path`](crate::model::S3Path)
pub mod s3_path {
    /// A builder for [`S3Path`](crate::model::S3Path)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket that contains the file.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that contains the file.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the file.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the file.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Path`](crate::model::S3Path)
        pub fn build(self) -> crate::model::S3Path {
            crate::model::S3Path {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3Path {
    /// Creates a new builder-style object to manufacture [`S3Path`](crate::model::S3Path)
    pub fn builder() -> crate::model::s3_path::Builder {
        crate::model::s3_path::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mode {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    LearnOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mode {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => Mode::Enabled,
            "LEARN_ONLY" => Mode::LearnOnly,
            other => Mode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mode::from(s))
    }
}
impl Mode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mode::Enabled => "ENABLED",
            Mode::LearnOnly => "LEARN_ONLY",
            Mode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "LEARN_ONLY"]
    }
}
impl AsRef<str> for Mode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the configuration information to fetch access levels
/// of groups and users from an AWS Single Sign-On identity
/// source. This is useful for setting up user context filtering, where
/// Amazon Kendra filters search results for different users based on their
/// group's access to documents. You can also map your users to their
/// groups for user context filtering using the
/// <a href="https://docs.aws.amazon.com/latest/dg/API_PutPrincipalMapping.html">PutPrincipalMapping
/// operation</a>.</p>
/// <p>To set up an AWS SSO identity source in the console to use with
/// Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started
/// with an AWS SSO identity source</a>. You must also grant the required
/// permissions to use AWS SSO with Amazon Kendra. For more information, see
/// <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso">IAM roles for
/// AWS Single Sign-On</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserGroupResolutionConfiguration {
    /// <p>The identity store provider (mode) you want to use to fetch access levels of groups and
    /// users. AWS Single Sign-On is currently the only available mode. Your users and groups
    /// must
    /// exist in an AWS SSO identity source in order to use this mode.</p>
    pub user_group_resolution_mode: std::option::Option<crate::model::UserGroupResolutionMode>,
}
impl UserGroupResolutionConfiguration {
    /// <p>The identity store provider (mode) you want to use to fetch access levels of groups and
    /// users. AWS Single Sign-On is currently the only available mode. Your users and groups
    /// must
    /// exist in an AWS SSO identity source in order to use this mode.</p>
    pub fn user_group_resolution_mode(
        &self,
    ) -> std::option::Option<&crate::model::UserGroupResolutionMode> {
        self.user_group_resolution_mode.as_ref()
    }
}
impl std::fmt::Debug for UserGroupResolutionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserGroupResolutionConfiguration");
        formatter.field(
            "user_group_resolution_mode",
            &self.user_group_resolution_mode,
        );
        formatter.finish()
    }
}
/// See [`UserGroupResolutionConfiguration`](crate::model::UserGroupResolutionConfiguration)
pub mod user_group_resolution_configuration {
    /// A builder for [`UserGroupResolutionConfiguration`](crate::model::UserGroupResolutionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_group_resolution_mode:
            std::option::Option<crate::model::UserGroupResolutionMode>,
    }
    impl Builder {
        /// <p>The identity store provider (mode) you want to use to fetch access levels of groups and
        /// users. AWS Single Sign-On is currently the only available mode. Your users and groups
        /// must
        /// exist in an AWS SSO identity source in order to use this mode.</p>
        pub fn user_group_resolution_mode(
            mut self,
            input: crate::model::UserGroupResolutionMode,
        ) -> Self {
            self.user_group_resolution_mode = Some(input);
            self
        }
        /// <p>The identity store provider (mode) you want to use to fetch access levels of groups and
        /// users. AWS Single Sign-On is currently the only available mode. Your users and groups
        /// must
        /// exist in an AWS SSO identity source in order to use this mode.</p>
        pub fn set_user_group_resolution_mode(
            mut self,
            input: std::option::Option<crate::model::UserGroupResolutionMode>,
        ) -> Self {
            self.user_group_resolution_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UserGroupResolutionConfiguration`](crate::model::UserGroupResolutionConfiguration)
        pub fn build(self) -> crate::model::UserGroupResolutionConfiguration {
            crate::model::UserGroupResolutionConfiguration {
                user_group_resolution_mode: self.user_group_resolution_mode,
            }
        }
    }
}
impl UserGroupResolutionConfiguration {
    /// Creates a new builder-style object to manufacture [`UserGroupResolutionConfiguration`](crate::model::UserGroupResolutionConfiguration)
    pub fn builder() -> crate::model::user_group_resolution_configuration::Builder {
        crate::model::user_group_resolution_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserGroupResolutionMode {
    #[allow(missing_docs)] // documentation missing in model
    AwsSso,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserGroupResolutionMode {
    fn from(s: &str) -> Self {
        match s {
            "AWS_SSO" => UserGroupResolutionMode::AwsSso,
            "NONE" => UserGroupResolutionMode::None,
            other => UserGroupResolutionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserGroupResolutionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserGroupResolutionMode::from(s))
    }
}
impl UserGroupResolutionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserGroupResolutionMode::AwsSso => "AWS_SSO",
            UserGroupResolutionMode::None => "NONE",
            UserGroupResolutionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_SSO", "NONE"]
    }
}
impl AsRef<str> for UserGroupResolutionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserContextPolicy {
    #[allow(missing_docs)] // documentation missing in model
    AttributeFilter,
    #[allow(missing_docs)] // documentation missing in model
    UserToken,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserContextPolicy {
    fn from(s: &str) -> Self {
        match s {
            "ATTRIBUTE_FILTER" => UserContextPolicy::AttributeFilter,
            "USER_TOKEN" => UserContextPolicy::UserToken,
            other => UserContextPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserContextPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserContextPolicy::from(s))
    }
}
impl UserContextPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserContextPolicy::AttributeFilter => "ATTRIBUTE_FILTER",
            UserContextPolicy::UserToken => "USER_TOKEN",
            UserContextPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ATTRIBUTE_FILTER", "USER_TOKEN"]
    }
}
impl AsRef<str> for UserContextPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for a token configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserTokenConfiguration {
    /// <p>Information about the JWT token type configuration.</p>
    pub jwt_token_type_configuration: std::option::Option<crate::model::JwtTokenTypeConfiguration>,
    /// <p>Information about the JSON token type configuration.</p>
    pub json_token_type_configuration:
        std::option::Option<crate::model::JsonTokenTypeConfiguration>,
}
impl UserTokenConfiguration {
    /// <p>Information about the JWT token type configuration.</p>
    pub fn jwt_token_type_configuration(
        &self,
    ) -> std::option::Option<&crate::model::JwtTokenTypeConfiguration> {
        self.jwt_token_type_configuration.as_ref()
    }
    /// <p>Information about the JSON token type configuration.</p>
    pub fn json_token_type_configuration(
        &self,
    ) -> std::option::Option<&crate::model::JsonTokenTypeConfiguration> {
        self.json_token_type_configuration.as_ref()
    }
}
impl std::fmt::Debug for UserTokenConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserTokenConfiguration");
        formatter.field(
            "jwt_token_type_configuration",
            &self.jwt_token_type_configuration,
        );
        formatter.field(
            "json_token_type_configuration",
            &self.json_token_type_configuration,
        );
        formatter.finish()
    }
}
/// See [`UserTokenConfiguration`](crate::model::UserTokenConfiguration)
pub mod user_token_configuration {
    /// A builder for [`UserTokenConfiguration`](crate::model::UserTokenConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jwt_token_type_configuration:
            std::option::Option<crate::model::JwtTokenTypeConfiguration>,
        pub(crate) json_token_type_configuration:
            std::option::Option<crate::model::JsonTokenTypeConfiguration>,
    }
    impl Builder {
        /// <p>Information about the JWT token type configuration.</p>
        pub fn jwt_token_type_configuration(
            mut self,
            input: crate::model::JwtTokenTypeConfiguration,
        ) -> Self {
            self.jwt_token_type_configuration = Some(input);
            self
        }
        /// <p>Information about the JWT token type configuration.</p>
        pub fn set_jwt_token_type_configuration(
            mut self,
            input: std::option::Option<crate::model::JwtTokenTypeConfiguration>,
        ) -> Self {
            self.jwt_token_type_configuration = input;
            self
        }
        /// <p>Information about the JSON token type configuration.</p>
        pub fn json_token_type_configuration(
            mut self,
            input: crate::model::JsonTokenTypeConfiguration,
        ) -> Self {
            self.json_token_type_configuration = Some(input);
            self
        }
        /// <p>Information about the JSON token type configuration.</p>
        pub fn set_json_token_type_configuration(
            mut self,
            input: std::option::Option<crate::model::JsonTokenTypeConfiguration>,
        ) -> Self {
            self.json_token_type_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UserTokenConfiguration`](crate::model::UserTokenConfiguration)
        pub fn build(self) -> crate::model::UserTokenConfiguration {
            crate::model::UserTokenConfiguration {
                jwt_token_type_configuration: self.jwt_token_type_configuration,
                json_token_type_configuration: self.json_token_type_configuration,
            }
        }
    }
}
impl UserTokenConfiguration {
    /// Creates a new builder-style object to manufacture [`UserTokenConfiguration`](crate::model::UserTokenConfiguration)
    pub fn builder() -> crate::model::user_token_configuration::Builder {
        crate::model::user_token_configuration::Builder::default()
    }
}

/// <p>Configuration information for the JSON token type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonTokenTypeConfiguration {
    /// <p>The user name attribute field.</p>
    pub user_name_attribute_field: std::option::Option<std::string::String>,
    /// <p>The group attribute field.</p>
    pub group_attribute_field: std::option::Option<std::string::String>,
}
impl JsonTokenTypeConfiguration {
    /// <p>The user name attribute field.</p>
    pub fn user_name_attribute_field(&self) -> std::option::Option<&str> {
        self.user_name_attribute_field.as_deref()
    }
    /// <p>The group attribute field.</p>
    pub fn group_attribute_field(&self) -> std::option::Option<&str> {
        self.group_attribute_field.as_deref()
    }
}
impl std::fmt::Debug for JsonTokenTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonTokenTypeConfiguration");
        formatter.field("user_name_attribute_field", &self.user_name_attribute_field);
        formatter.field("group_attribute_field", &self.group_attribute_field);
        formatter.finish()
    }
}
/// See [`JsonTokenTypeConfiguration`](crate::model::JsonTokenTypeConfiguration)
pub mod json_token_type_configuration {
    /// A builder for [`JsonTokenTypeConfiguration`](crate::model::JsonTokenTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name_attribute_field: std::option::Option<std::string::String>,
        pub(crate) group_attribute_field: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name attribute field.</p>
        pub fn user_name_attribute_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name_attribute_field = Some(input.into());
            self
        }
        /// <p>The user name attribute field.</p>
        pub fn set_user_name_attribute_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_name_attribute_field = input;
            self
        }
        /// <p>The group attribute field.</p>
        pub fn group_attribute_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_attribute_field = Some(input.into());
            self
        }
        /// <p>The group attribute field.</p>
        pub fn set_group_attribute_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_attribute_field = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonTokenTypeConfiguration`](crate::model::JsonTokenTypeConfiguration)
        pub fn build(self) -> crate::model::JsonTokenTypeConfiguration {
            crate::model::JsonTokenTypeConfiguration {
                user_name_attribute_field: self.user_name_attribute_field,
                group_attribute_field: self.group_attribute_field,
            }
        }
    }
}
impl JsonTokenTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`JsonTokenTypeConfiguration`](crate::model::JsonTokenTypeConfiguration)
    pub fn builder() -> crate::model::json_token_type_configuration::Builder {
        crate::model::json_token_type_configuration::Builder::default()
    }
}

/// <p>Configuration information for the JWT token type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JwtTokenTypeConfiguration {
    /// <p>The location of the key.</p>
    pub key_location: std::option::Option<crate::model::KeyLocation>,
    /// <p>The signing key URL.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the secret.</p>
    pub secret_manager_arn: std::option::Option<std::string::String>,
    /// <p>The user name attribute field.</p>
    pub user_name_attribute_field: std::option::Option<std::string::String>,
    /// <p>The group attribute field.</p>
    pub group_attribute_field: std::option::Option<std::string::String>,
    /// <p>The issuer of the token.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The regular expression that identifies the claim.</p>
    pub claim_regex: std::option::Option<std::string::String>,
}
impl JwtTokenTypeConfiguration {
    /// <p>The location of the key.</p>
    pub fn key_location(&self) -> std::option::Option<&crate::model::KeyLocation> {
        self.key_location.as_ref()
    }
    /// <p>The signing key URL.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the secret.</p>
    pub fn secret_manager_arn(&self) -> std::option::Option<&str> {
        self.secret_manager_arn.as_deref()
    }
    /// <p>The user name attribute field.</p>
    pub fn user_name_attribute_field(&self) -> std::option::Option<&str> {
        self.user_name_attribute_field.as_deref()
    }
    /// <p>The group attribute field.</p>
    pub fn group_attribute_field(&self) -> std::option::Option<&str> {
        self.group_attribute_field.as_deref()
    }
    /// <p>The issuer of the token.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The regular expression that identifies the claim.</p>
    pub fn claim_regex(&self) -> std::option::Option<&str> {
        self.claim_regex.as_deref()
    }
}
impl std::fmt::Debug for JwtTokenTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JwtTokenTypeConfiguration");
        formatter.field("key_location", &self.key_location);
        formatter.field("url", &self.url);
        formatter.field("secret_manager_arn", &self.secret_manager_arn);
        formatter.field("user_name_attribute_field", &self.user_name_attribute_field);
        formatter.field("group_attribute_field", &self.group_attribute_field);
        formatter.field("issuer", &self.issuer);
        formatter.field("claim_regex", &self.claim_regex);
        formatter.finish()
    }
}
/// See [`JwtTokenTypeConfiguration`](crate::model::JwtTokenTypeConfiguration)
pub mod jwt_token_type_configuration {
    /// A builder for [`JwtTokenTypeConfiguration`](crate::model::JwtTokenTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_location: std::option::Option<crate::model::KeyLocation>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) secret_manager_arn: std::option::Option<std::string::String>,
        pub(crate) user_name_attribute_field: std::option::Option<std::string::String>,
        pub(crate) group_attribute_field: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) claim_regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the key.</p>
        pub fn key_location(mut self, input: crate::model::KeyLocation) -> Self {
            self.key_location = Some(input);
            self
        }
        /// <p>The location of the key.</p>
        pub fn set_key_location(
            mut self,
            input: std::option::Option<crate::model::KeyLocation>,
        ) -> Self {
            self.key_location = input;
            self
        }
        /// <p>The signing key URL.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The signing key URL.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the secret.</p>
        pub fn secret_manager_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_manager_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the secret.</p>
        pub fn set_secret_manager_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_manager_arn = input;
            self
        }
        /// <p>The user name attribute field.</p>
        pub fn user_name_attribute_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name_attribute_field = Some(input.into());
            self
        }
        /// <p>The user name attribute field.</p>
        pub fn set_user_name_attribute_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_name_attribute_field = input;
            self
        }
        /// <p>The group attribute field.</p>
        pub fn group_attribute_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_attribute_field = Some(input.into());
            self
        }
        /// <p>The group attribute field.</p>
        pub fn set_group_attribute_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_attribute_field = input;
            self
        }
        /// <p>The issuer of the token.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The issuer of the token.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The regular expression that identifies the claim.</p>
        pub fn claim_regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.claim_regex = Some(input.into());
            self
        }
        /// <p>The regular expression that identifies the claim.</p>
        pub fn set_claim_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.claim_regex = input;
            self
        }
        /// Consumes the builder and constructs a [`JwtTokenTypeConfiguration`](crate::model::JwtTokenTypeConfiguration)
        pub fn build(self) -> crate::model::JwtTokenTypeConfiguration {
            crate::model::JwtTokenTypeConfiguration {
                key_location: self.key_location,
                url: self.url,
                secret_manager_arn: self.secret_manager_arn,
                user_name_attribute_field: self.user_name_attribute_field,
                group_attribute_field: self.group_attribute_field,
                issuer: self.issuer,
                claim_regex: self.claim_regex,
            }
        }
    }
}
impl JwtTokenTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`JwtTokenTypeConfiguration`](crate::model::JwtTokenTypeConfiguration)
    pub fn builder() -> crate::model::jwt_token_type_configuration::Builder {
        crate::model::jwt_token_type_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyLocation {
    #[allow(missing_docs)] // documentation missing in model
    SecretManager,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyLocation {
    fn from(s: &str) -> Self {
        match s {
            "SECRET_MANAGER" => KeyLocation::SecretManager,
            "URL" => KeyLocation::Url,
            other => KeyLocation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyLocation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyLocation::from(s))
    }
}
impl KeyLocation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyLocation::SecretManager => "SECRET_MANAGER",
            KeyLocation::Url => "URL",
            KeyLocation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SECRET_MANAGER", "URL"]
    }
}
impl AsRef<str> for KeyLocation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies capacity units configured for your enterprise edition index.
/// You can add and remove capacity units to tune an index to your
/// requirements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityUnitsConfiguration {
    /// <p>The amount of extra storage capacity for an index.
    /// A single capacity unit provides 30 GB of storage space or 100,000 documents,
    /// whichever is reached first.</p>
    pub storage_capacity_units: std::option::Option<i32>,
    /// <p>The amount of extra query capacity for an index and
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>
    /// capacity.</p>
    /// <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately
    /// 8,000 queries per day.</p>
    /// <p>
    /// <code>GetQuerySuggestions</code> capacity is five times the
    /// provisioned query capacity for an index, or the base capacity of 2.5 calls per second,
    /// whichever is higher. For example, the base capacity for an index is 0.1 queries per
    /// second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second.
    /// If you add another 0.1 queries per second to total 0.2 queries per second for an index, the
    /// <code>GetQuerySuggestions</code> capacity is 2.5 calls per second
    /// (higher than five times 0.2 queries per second).</p>
    pub query_capacity_units: std::option::Option<i32>,
}
impl CapacityUnitsConfiguration {
    /// <p>The amount of extra storage capacity for an index.
    /// A single capacity unit provides 30 GB of storage space or 100,000 documents,
    /// whichever is reached first.</p>
    pub fn storage_capacity_units(&self) -> std::option::Option<i32> {
        self.storage_capacity_units
    }
    /// <p>The amount of extra query capacity for an index and
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>
    /// capacity.</p>
    /// <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately
    /// 8,000 queries per day.</p>
    /// <p>
    /// <code>GetQuerySuggestions</code> capacity is five times the
    /// provisioned query capacity for an index, or the base capacity of 2.5 calls per second,
    /// whichever is higher. For example, the base capacity for an index is 0.1 queries per
    /// second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second.
    /// If you add another 0.1 queries per second to total 0.2 queries per second for an index, the
    /// <code>GetQuerySuggestions</code> capacity is 2.5 calls per second
    /// (higher than five times 0.2 queries per second).</p>
    pub fn query_capacity_units(&self) -> std::option::Option<i32> {
        self.query_capacity_units
    }
}
impl std::fmt::Debug for CapacityUnitsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityUnitsConfiguration");
        formatter.field("storage_capacity_units", &self.storage_capacity_units);
        formatter.field("query_capacity_units", &self.query_capacity_units);
        formatter.finish()
    }
}
/// See [`CapacityUnitsConfiguration`](crate::model::CapacityUnitsConfiguration)
pub mod capacity_units_configuration {
    /// A builder for [`CapacityUnitsConfiguration`](crate::model::CapacityUnitsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_capacity_units: std::option::Option<i32>,
        pub(crate) query_capacity_units: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of extra storage capacity for an index.
        /// A single capacity unit provides 30 GB of storage space or 100,000 documents,
        /// whichever is reached first.</p>
        pub fn storage_capacity_units(mut self, input: i32) -> Self {
            self.storage_capacity_units = Some(input);
            self
        }
        /// <p>The amount of extra storage capacity for an index.
        /// A single capacity unit provides 30 GB of storage space or 100,000 documents,
        /// whichever is reached first.</p>
        pub fn set_storage_capacity_units(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_capacity_units = input;
            self
        }
        /// <p>The amount of extra query capacity for an index and
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>
        /// capacity.</p>
        /// <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately
        /// 8,000 queries per day.</p>
        /// <p>
        /// <code>GetQuerySuggestions</code> capacity is five times the
        /// provisioned query capacity for an index, or the base capacity of 2.5 calls per second,
        /// whichever is higher. For example, the base capacity for an index is 0.1 queries per
        /// second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second.
        /// If you add another 0.1 queries per second to total 0.2 queries per second for an index, the
        /// <code>GetQuerySuggestions</code> capacity is 2.5 calls per second
        /// (higher than five times 0.2 queries per second).</p>
        pub fn query_capacity_units(mut self, input: i32) -> Self {
            self.query_capacity_units = Some(input);
            self
        }
        /// <p>The amount of extra query capacity for an index and
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>
        /// capacity.</p>
        /// <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately
        /// 8,000 queries per day.</p>
        /// <p>
        /// <code>GetQuerySuggestions</code> capacity is five times the
        /// provisioned query capacity for an index, or the base capacity of 2.5 calls per second,
        /// whichever is higher. For example, the base capacity for an index is 0.1 queries per
        /// second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second.
        /// If you add another 0.1 queries per second to total 0.2 queries per second for an index, the
        /// <code>GetQuerySuggestions</code> capacity is 2.5 calls per second
        /// (higher than five times 0.2 queries per second).</p>
        pub fn set_query_capacity_units(mut self, input: std::option::Option<i32>) -> Self {
            self.query_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityUnitsConfiguration`](crate::model::CapacityUnitsConfiguration)
        pub fn build(self) -> crate::model::CapacityUnitsConfiguration {
            crate::model::CapacityUnitsConfiguration {
                storage_capacity_units: self.storage_capacity_units,
                query_capacity_units: self.query_capacity_units,
            }
        }
    }
}
impl CapacityUnitsConfiguration {
    /// Creates a new builder-style object to manufacture [`CapacityUnitsConfiguration`](crate::model::CapacityUnitsConfiguration)
    pub fn builder() -> crate::model::capacity_units_configuration::Builder {
        crate::model::capacity_units_configuration::Builder::default()
    }
}

/// <p>Specifies the properties of a custom index field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentMetadataConfiguration {
    /// <p>The name of the index field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the index field. </p>
    pub r#type: std::option::Option<crate::model::DocumentAttributeValueType>,
    /// <p>Provides manual tuning parameters to determine how the field
    /// affects the search results.</p>
    pub relevance: std::option::Option<crate::model::Relevance>,
    /// <p>Provides information about how the field is used during a
    /// search.</p>
    pub search: std::option::Option<crate::model::Search>,
}
impl DocumentMetadataConfiguration {
    /// <p>The name of the index field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the index field. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DocumentAttributeValueType> {
        self.r#type.as_ref()
    }
    /// <p>Provides manual tuning parameters to determine how the field
    /// affects the search results.</p>
    pub fn relevance(&self) -> std::option::Option<&crate::model::Relevance> {
        self.relevance.as_ref()
    }
    /// <p>Provides information about how the field is used during a
    /// search.</p>
    pub fn search(&self) -> std::option::Option<&crate::model::Search> {
        self.search.as_ref()
    }
}
impl std::fmt::Debug for DocumentMetadataConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentMetadataConfiguration");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("relevance", &self.relevance);
        formatter.field("search", &self.search);
        formatter.finish()
    }
}
/// See [`DocumentMetadataConfiguration`](crate::model::DocumentMetadataConfiguration)
pub mod document_metadata_configuration {
    /// A builder for [`DocumentMetadataConfiguration`](crate::model::DocumentMetadataConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DocumentAttributeValueType>,
        pub(crate) relevance: std::option::Option<crate::model::Relevance>,
        pub(crate) search: std::option::Option<crate::model::Search>,
    }
    impl Builder {
        /// <p>The name of the index field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the index field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the index field. </p>
        pub fn r#type(mut self, input: crate::model::DocumentAttributeValueType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data type of the index field. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentAttributeValueType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Provides manual tuning parameters to determine how the field
        /// affects the search results.</p>
        pub fn relevance(mut self, input: crate::model::Relevance) -> Self {
            self.relevance = Some(input);
            self
        }
        /// <p>Provides manual tuning parameters to determine how the field
        /// affects the search results.</p>
        pub fn set_relevance(
            mut self,
            input: std::option::Option<crate::model::Relevance>,
        ) -> Self {
            self.relevance = input;
            self
        }
        /// <p>Provides information about how the field is used during a
        /// search.</p>
        pub fn search(mut self, input: crate::model::Search) -> Self {
            self.search = Some(input);
            self
        }
        /// <p>Provides information about how the field is used during a
        /// search.</p>
        pub fn set_search(mut self, input: std::option::Option<crate::model::Search>) -> Self {
            self.search = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentMetadataConfiguration`](crate::model::DocumentMetadataConfiguration)
        pub fn build(self) -> crate::model::DocumentMetadataConfiguration {
            crate::model::DocumentMetadataConfiguration {
                name: self.name,
                r#type: self.r#type,
                relevance: self.relevance,
                search: self.search,
            }
        }
    }
}
impl DocumentMetadataConfiguration {
    /// Creates a new builder-style object to manufacture [`DocumentMetadataConfiguration`](crate::model::DocumentMetadataConfiguration)
    pub fn builder() -> crate::model::document_metadata_configuration::Builder {
        crate::model::document_metadata_configuration::Builder::default()
    }
}

/// <p>Provides information about how a custom index field is used during
/// a search.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Search {
    /// <p>Indicates that the field can be used to create search facets, a
    /// count of results for each value in the field. The default is
    /// <code>false</code> .</p>
    pub facetable: bool,
    /// <p>Determines whether the field is used in the search. If the
    /// <code>Searchable</code> field is <code>true</code>, you can use
    /// relevance tuning to manually tune how Amazon Kendra weights the field in
    /// the search. The default is <code>true</code> for string fields and
    /// <code>false</code> for number and date fields.</p>
    pub searchable: bool,
    /// <p>Determines whether the field is returned in the query response.
    /// The default is <code>true</code>.</p>
    pub displayable: bool,
    /// <p>Determines whether the field can be used to sort the results of a
    /// query. If you specify sorting on a field that does not have
    /// <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an
    /// exception. The default is <code>false</code>.</p>
    pub sortable: bool,
}
impl Search {
    /// <p>Indicates that the field can be used to create search facets, a
    /// count of results for each value in the field. The default is
    /// <code>false</code> .</p>
    pub fn facetable(&self) -> bool {
        self.facetable
    }
    /// <p>Determines whether the field is used in the search. If the
    /// <code>Searchable</code> field is <code>true</code>, you can use
    /// relevance tuning to manually tune how Amazon Kendra weights the field in
    /// the search. The default is <code>true</code> for string fields and
    /// <code>false</code> for number and date fields.</p>
    pub fn searchable(&self) -> bool {
        self.searchable
    }
    /// <p>Determines whether the field is returned in the query response.
    /// The default is <code>true</code>.</p>
    pub fn displayable(&self) -> bool {
        self.displayable
    }
    /// <p>Determines whether the field can be used to sort the results of a
    /// query. If you specify sorting on a field that does not have
    /// <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an
    /// exception. The default is <code>false</code>.</p>
    pub fn sortable(&self) -> bool {
        self.sortable
    }
}
impl std::fmt::Debug for Search {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Search");
        formatter.field("facetable", &self.facetable);
        formatter.field("searchable", &self.searchable);
        formatter.field("displayable", &self.displayable);
        formatter.field("sortable", &self.sortable);
        formatter.finish()
    }
}
/// See [`Search`](crate::model::Search)
pub mod search {
    /// A builder for [`Search`](crate::model::Search)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) facetable: std::option::Option<bool>,
        pub(crate) searchable: std::option::Option<bool>,
        pub(crate) displayable: std::option::Option<bool>,
        pub(crate) sortable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates that the field can be used to create search facets, a
        /// count of results for each value in the field. The default is
        /// <code>false</code> .</p>
        pub fn facetable(mut self, input: bool) -> Self {
            self.facetable = Some(input);
            self
        }
        /// <p>Indicates that the field can be used to create search facets, a
        /// count of results for each value in the field. The default is
        /// <code>false</code> .</p>
        pub fn set_facetable(mut self, input: std::option::Option<bool>) -> Self {
            self.facetable = input;
            self
        }
        /// <p>Determines whether the field is used in the search. If the
        /// <code>Searchable</code> field is <code>true</code>, you can use
        /// relevance tuning to manually tune how Amazon Kendra weights the field in
        /// the search. The default is <code>true</code> for string fields and
        /// <code>false</code> for number and date fields.</p>
        pub fn searchable(mut self, input: bool) -> Self {
            self.searchable = Some(input);
            self
        }
        /// <p>Determines whether the field is used in the search. If the
        /// <code>Searchable</code> field is <code>true</code>, you can use
        /// relevance tuning to manually tune how Amazon Kendra weights the field in
        /// the search. The default is <code>true</code> for string fields and
        /// <code>false</code> for number and date fields.</p>
        pub fn set_searchable(mut self, input: std::option::Option<bool>) -> Self {
            self.searchable = input;
            self
        }
        /// <p>Determines whether the field is returned in the query response.
        /// The default is <code>true</code>.</p>
        pub fn displayable(mut self, input: bool) -> Self {
            self.displayable = Some(input);
            self
        }
        /// <p>Determines whether the field is returned in the query response.
        /// The default is <code>true</code>.</p>
        pub fn set_displayable(mut self, input: std::option::Option<bool>) -> Self {
            self.displayable = input;
            self
        }
        /// <p>Determines whether the field can be used to sort the results of a
        /// query. If you specify sorting on a field that does not have
        /// <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an
        /// exception. The default is <code>false</code>.</p>
        pub fn sortable(mut self, input: bool) -> Self {
            self.sortable = Some(input);
            self
        }
        /// <p>Determines whether the field can be used to sort the results of a
        /// query. If you specify sorting on a field that does not have
        /// <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an
        /// exception. The default is <code>false</code>.</p>
        pub fn set_sortable(mut self, input: std::option::Option<bool>) -> Self {
            self.sortable = input;
            self
        }
        /// Consumes the builder and constructs a [`Search`](crate::model::Search)
        pub fn build(self) -> crate::model::Search {
            crate::model::Search {
                facetable: self.facetable.unwrap_or_default(),
                searchable: self.searchable.unwrap_or_default(),
                displayable: self.displayable.unwrap_or_default(),
                sortable: self.sortable.unwrap_or_default(),
            }
        }
    }
}
impl Search {
    /// Creates a new builder-style object to manufacture [`Search`](crate::model::Search)
    pub fn builder() -> crate::model::search::Builder {
        crate::model::search::Builder::default()
    }
}

/// <p>Provides information for manually tuning the relevance of a field
/// in a search. When a query includes terms that match the field, the
/// results are given a boost in the response based on these tuning
/// parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Relevance {
    /// <p>Indicates that this field determines how "fresh" a document is.
    /// For example, if document 1 was created on November 5, and document 2
    /// was created on October 31, document 1 is "fresher" than document 2.
    /// You can only set the <code>Freshness</code> field on one
    /// <code>DATE</code> type field. Only applies to <code>DATE</code>
    /// fields.</p>
    pub freshness: std::option::Option<bool>,
    /// <p>The relative importance of the field in the search. Larger numbers
    /// provide more of a boost than smaller numbers.</p>
    pub importance: std::option::Option<i32>,
    /// <p>Specifies the time period that the boost applies to. For example,
    /// to make the boost apply to documents with the field value within the
    /// last month, you would use "2628000s". Once the field value is beyond
    /// the specified range, the effect of the boost drops off. The higher
    /// the importance, the faster the effect drops off. If you don't
    /// specify a value, the default is 3 months. The value of the field is
    /// a numeric string followed by the character "s", for example "86400s"
    /// for one day, or "604800s" for one week. </p>
    /// <p>Only applies to <code>DATE</code> fields.</p>
    pub duration: std::option::Option<std::string::String>,
    /// <p>Determines how values should be interpreted.</p>
    /// <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>,
    /// higher numbers are better. For example, a document with a rating
    /// score of 10 is higher ranking than a document with a rating score of
    /// 1.</p>
    /// <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>,
    /// lower numbers are better. For example, in a task tracking
    /// application, a priority 1 task is more important than a priority 5
    /// task.</p>
    /// <p>Only applies to <code>LONG</code> and <code>DOUBLE</code>
    /// fields.</p>
    pub rank_order: std::option::Option<crate::model::Order>,
    /// <p>A list of values that should be given a different boost when they
    /// appear in the result list. For example, if you are boosting a field
    /// called "department," query terms that match the department field are
    /// boosted in the result. However, you can add entries from the
    /// department field to boost documents with those values higher. </p>
    /// <p>For example, you can add entries to the map with names of
    /// departments. If you add "HR",5 and "Legal",3 those departments are
    /// given special attention when they appear in the metadata of a
    /// document. When those terms appear they are given the specified
    /// importance instead of the regular importance for the boost.</p>
    pub value_importance_map:
        std::option::Option<std::collections::HashMap<std::string::String, i32>>,
}
impl Relevance {
    /// <p>Indicates that this field determines how "fresh" a document is.
    /// For example, if document 1 was created on November 5, and document 2
    /// was created on October 31, document 1 is "fresher" than document 2.
    /// You can only set the <code>Freshness</code> field on one
    /// <code>DATE</code> type field. Only applies to <code>DATE</code>
    /// fields.</p>
    pub fn freshness(&self) -> std::option::Option<bool> {
        self.freshness
    }
    /// <p>The relative importance of the field in the search. Larger numbers
    /// provide more of a boost than smaller numbers.</p>
    pub fn importance(&self) -> std::option::Option<i32> {
        self.importance
    }
    /// <p>Specifies the time period that the boost applies to. For example,
    /// to make the boost apply to documents with the field value within the
    /// last month, you would use "2628000s". Once the field value is beyond
    /// the specified range, the effect of the boost drops off. The higher
    /// the importance, the faster the effect drops off. If you don't
    /// specify a value, the default is 3 months. The value of the field is
    /// a numeric string followed by the character "s", for example "86400s"
    /// for one day, or "604800s" for one week. </p>
    /// <p>Only applies to <code>DATE</code> fields.</p>
    pub fn duration(&self) -> std::option::Option<&str> {
        self.duration.as_deref()
    }
    /// <p>Determines how values should be interpreted.</p>
    /// <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>,
    /// higher numbers are better. For example, a document with a rating
    /// score of 10 is higher ranking than a document with a rating score of
    /// 1.</p>
    /// <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>,
    /// lower numbers are better. For example, in a task tracking
    /// application, a priority 1 task is more important than a priority 5
    /// task.</p>
    /// <p>Only applies to <code>LONG</code> and <code>DOUBLE</code>
    /// fields.</p>
    pub fn rank_order(&self) -> std::option::Option<&crate::model::Order> {
        self.rank_order.as_ref()
    }
    /// <p>A list of values that should be given a different boost when they
    /// appear in the result list. For example, if you are boosting a field
    /// called "department," query terms that match the department field are
    /// boosted in the result. However, you can add entries from the
    /// department field to boost documents with those values higher. </p>
    /// <p>For example, you can add entries to the map with names of
    /// departments. If you add "HR",5 and "Legal",3 those departments are
    /// given special attention when they appear in the metadata of a
    /// document. When those terms appear they are given the specified
    /// importance instead of the regular importance for the boost.</p>
    pub fn value_importance_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.value_importance_map.as_ref()
    }
}
impl std::fmt::Debug for Relevance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Relevance");
        formatter.field("freshness", &self.freshness);
        formatter.field("importance", &self.importance);
        formatter.field("duration", &self.duration);
        formatter.field("rank_order", &self.rank_order);
        formatter.field("value_importance_map", &self.value_importance_map);
        formatter.finish()
    }
}
/// See [`Relevance`](crate::model::Relevance)
pub mod relevance {
    /// A builder for [`Relevance`](crate::model::Relevance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) freshness: std::option::Option<bool>,
        pub(crate) importance: std::option::Option<i32>,
        pub(crate) duration: std::option::Option<std::string::String>,
        pub(crate) rank_order: std::option::Option<crate::model::Order>,
        pub(crate) value_importance_map:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    }
    impl Builder {
        /// <p>Indicates that this field determines how "fresh" a document is.
        /// For example, if document 1 was created on November 5, and document 2
        /// was created on October 31, document 1 is "fresher" than document 2.
        /// You can only set the <code>Freshness</code> field on one
        /// <code>DATE</code> type field. Only applies to <code>DATE</code>
        /// fields.</p>
        pub fn freshness(mut self, input: bool) -> Self {
            self.freshness = Some(input);
            self
        }
        /// <p>Indicates that this field determines how "fresh" a document is.
        /// For example, if document 1 was created on November 5, and document 2
        /// was created on October 31, document 1 is "fresher" than document 2.
        /// You can only set the <code>Freshness</code> field on one
        /// <code>DATE</code> type field. Only applies to <code>DATE</code>
        /// fields.</p>
        pub fn set_freshness(mut self, input: std::option::Option<bool>) -> Self {
            self.freshness = input;
            self
        }
        /// <p>The relative importance of the field in the search. Larger numbers
        /// provide more of a boost than smaller numbers.</p>
        pub fn importance(mut self, input: i32) -> Self {
            self.importance = Some(input);
            self
        }
        /// <p>The relative importance of the field in the search. Larger numbers
        /// provide more of a boost than smaller numbers.</p>
        pub fn set_importance(mut self, input: std::option::Option<i32>) -> Self {
            self.importance = input;
            self
        }
        /// <p>Specifies the time period that the boost applies to. For example,
        /// to make the boost apply to documents with the field value within the
        /// last month, you would use "2628000s". Once the field value is beyond
        /// the specified range, the effect of the boost drops off. The higher
        /// the importance, the faster the effect drops off. If you don't
        /// specify a value, the default is 3 months. The value of the field is
        /// a numeric string followed by the character "s", for example "86400s"
        /// for one day, or "604800s" for one week. </p>
        /// <p>Only applies to <code>DATE</code> fields.</p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration = Some(input.into());
            self
        }
        /// <p>Specifies the time period that the boost applies to. For example,
        /// to make the boost apply to documents with the field value within the
        /// last month, you would use "2628000s". Once the field value is beyond
        /// the specified range, the effect of the boost drops off. The higher
        /// the importance, the faster the effect drops off. If you don't
        /// specify a value, the default is 3 months. The value of the field is
        /// a numeric string followed by the character "s", for example "86400s"
        /// for one day, or "604800s" for one week. </p>
        /// <p>Only applies to <code>DATE</code> fields.</p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.duration = input;
            self
        }
        /// <p>Determines how values should be interpreted.</p>
        /// <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>,
        /// higher numbers are better. For example, a document with a rating
        /// score of 10 is higher ranking than a document with a rating score of
        /// 1.</p>
        /// <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>,
        /// lower numbers are better. For example, in a task tracking
        /// application, a priority 1 task is more important than a priority 5
        /// task.</p>
        /// <p>Only applies to <code>LONG</code> and <code>DOUBLE</code>
        /// fields.</p>
        pub fn rank_order(mut self, input: crate::model::Order) -> Self {
            self.rank_order = Some(input);
            self
        }
        /// <p>Determines how values should be interpreted.</p>
        /// <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>,
        /// higher numbers are better. For example, a document with a rating
        /// score of 10 is higher ranking than a document with a rating score of
        /// 1.</p>
        /// <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>,
        /// lower numbers are better. For example, in a task tracking
        /// application, a priority 1 task is more important than a priority 5
        /// task.</p>
        /// <p>Only applies to <code>LONG</code> and <code>DOUBLE</code>
        /// fields.</p>
        pub fn set_rank_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.rank_order = input;
            self
        }
        /// Adds a key-value pair to `value_importance_map`.
        ///
        /// To override the contents of this collection use [`set_value_importance_map`](Self::set_value_importance_map).
        ///
        /// <p>A list of values that should be given a different boost when they
        /// appear in the result list. For example, if you are boosting a field
        /// called "department," query terms that match the department field are
        /// boosted in the result. However, you can add entries from the
        /// department field to boost documents with those values higher. </p>
        /// <p>For example, you can add entries to the map with names of
        /// departments. If you add "HR",5 and "Legal",3 those departments are
        /// given special attention when they appear in the metadata of a
        /// document. When those terms appear they are given the specified
        /// importance instead of the regular importance for the boost.</p>
        pub fn value_importance_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.value_importance_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.value_importance_map = Some(hash_map);
            self
        }
        /// <p>A list of values that should be given a different boost when they
        /// appear in the result list. For example, if you are boosting a field
        /// called "department," query terms that match the department field are
        /// boosted in the result. However, you can add entries from the
        /// department field to boost documents with those values higher. </p>
        /// <p>For example, you can add entries to the map with names of
        /// departments. If you add "HR",5 and "Legal",3 those departments are
        /// given special attention when they appear in the metadata of a
        /// document. When those terms appear they are given the specified
        /// importance instead of the regular importance for the boost.</p>
        pub fn set_value_importance_map(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.value_importance_map = input;
            self
        }
        /// Consumes the builder and constructs a [`Relevance`](crate::model::Relevance)
        pub fn build(self) -> crate::model::Relevance {
            crate::model::Relevance {
                freshness: self.freshness,
                importance: self.importance,
                duration: self.duration,
                rank_order: self.rank_order,
                value_importance_map: self.value_importance_map,
            }
        }
    }
}
impl Relevance {
    /// Creates a new builder-style object to manufacture [`Relevance`](crate::model::Relevance)
    pub fn builder() -> crate::model::relevance::Builder {
        crate::model::relevance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Order {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Order {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => Order::Ascending,
            "DESCENDING" => Order::Descending,
            other => Order::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Order {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Order::from(s))
    }
}
impl Order {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Order::Ascending => "ASCENDING",
            Order::Descending => "DESCENDING",
            Order::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for Order {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentAttributeValueType {
    #[allow(missing_docs)] // documentation missing in model
    DateValue,
    #[allow(missing_docs)] // documentation missing in model
    LongValue,
    #[allow(missing_docs)] // documentation missing in model
    StringListValue,
    #[allow(missing_docs)] // documentation missing in model
    StringValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentAttributeValueType {
    fn from(s: &str) -> Self {
        match s {
            "DATE_VALUE" => DocumentAttributeValueType::DateValue,
            "LONG_VALUE" => DocumentAttributeValueType::LongValue,
            "STRING_LIST_VALUE" => DocumentAttributeValueType::StringListValue,
            "STRING_VALUE" => DocumentAttributeValueType::StringValue,
            other => DocumentAttributeValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentAttributeValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentAttributeValueType::from(s))
    }
}
impl DocumentAttributeValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentAttributeValueType::DateValue => "DATE_VALUE",
            DocumentAttributeValueType::LongValue => "LONG_VALUE",
            DocumentAttributeValueType::StringListValue => "STRING_LIST_VALUE",
            DocumentAttributeValueType::StringValue => "STRING_VALUE",
            DocumentAttributeValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DATE_VALUE",
            "LONG_VALUE",
            "STRING_LIST_VALUE",
            "STRING_VALUE",
        ]
    }
}
impl AsRef<str> for DocumentAttributeValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information for a Amazon Kendra data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceConfiguration {
    /// <p>Provides information to create a data source connector for a
    /// document repository in an Amazon S3 bucket.</p>
    pub s3_configuration: std::option::Option<crate::model::S3DataSourceConfiguration>,
    /// <p>Provides information necessary to create a data source connector
    /// for a Microsoft SharePoint site.</p>
    pub share_point_configuration: std::option::Option<crate::model::SharePointConfiguration>,
    /// <p>Provides information necessary to create a data source connector
    /// for a database.</p>
    pub database_configuration: std::option::Option<crate::model::DatabaseConfiguration>,
    /// <p>Provides configuration information for data sources that connect
    /// to a Salesforce site.</p>
    pub salesforce_configuration: std::option::Option<crate::model::SalesforceConfiguration>,
    /// <p>Provides configuration for data sources that connect to Microsoft
    /// OneDrive.</p>
    pub one_drive_configuration: std::option::Option<crate::model::OneDriveConfiguration>,
    /// <p>Provides configuration for data sources that connect to ServiceNow
    /// instances.</p>
    pub service_now_configuration: std::option::Option<crate::model::ServiceNowConfiguration>,
    /// <p>Provides configuration information for connecting to a Confluence
    /// data source.</p>
    pub confluence_configuration: std::option::Option<crate::model::ConfluenceConfiguration>,
    /// <p>Provides configuration for data sources that connect to Google
    /// Drive. </p>
    pub google_drive_configuration: std::option::Option<crate::model::GoogleDriveConfiguration>,
    /// <p>Provides the configuration information required for Amazon Kendra
    /// web crawler.</p>
    pub web_crawler_configuration: std::option::Option<crate::model::WebCrawlerConfiguration>,
    /// <p>Provides the configuration information to connect to WorkDocs
    /// as your data source.</p>
    pub work_docs_configuration: std::option::Option<crate::model::WorkDocsConfiguration>,
}
impl DataSourceConfiguration {
    /// <p>Provides information to create a data source connector for a
    /// document repository in an Amazon S3 bucket.</p>
    pub fn s3_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DataSourceConfiguration> {
        self.s3_configuration.as_ref()
    }
    /// <p>Provides information necessary to create a data source connector
    /// for a Microsoft SharePoint site.</p>
    pub fn share_point_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SharePointConfiguration> {
        self.share_point_configuration.as_ref()
    }
    /// <p>Provides information necessary to create a data source connector
    /// for a database.</p>
    pub fn database_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DatabaseConfiguration> {
        self.database_configuration.as_ref()
    }
    /// <p>Provides configuration information for data sources that connect
    /// to a Salesforce site.</p>
    pub fn salesforce_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceConfiguration> {
        self.salesforce_configuration.as_ref()
    }
    /// <p>Provides configuration for data sources that connect to Microsoft
    /// OneDrive.</p>
    pub fn one_drive_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OneDriveConfiguration> {
        self.one_drive_configuration.as_ref()
    }
    /// <p>Provides configuration for data sources that connect to ServiceNow
    /// instances.</p>
    pub fn service_now_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowConfiguration> {
        self.service_now_configuration.as_ref()
    }
    /// <p>Provides configuration information for connecting to a Confluence
    /// data source.</p>
    pub fn confluence_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceConfiguration> {
        self.confluence_configuration.as_ref()
    }
    /// <p>Provides configuration for data sources that connect to Google
    /// Drive. </p>
    pub fn google_drive_configuration(
        &self,
    ) -> std::option::Option<&crate::model::GoogleDriveConfiguration> {
        self.google_drive_configuration.as_ref()
    }
    /// <p>Provides the configuration information required for Amazon Kendra
    /// web crawler.</p>
    pub fn web_crawler_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WebCrawlerConfiguration> {
        self.web_crawler_configuration.as_ref()
    }
    /// <p>Provides the configuration information to connect to WorkDocs
    /// as your data source.</p>
    pub fn work_docs_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WorkDocsConfiguration> {
        self.work_docs_configuration.as_ref()
    }
}
impl std::fmt::Debug for DataSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceConfiguration");
        formatter.field("s3_configuration", &self.s3_configuration);
        formatter.field("share_point_configuration", &self.share_point_configuration);
        formatter.field("database_configuration", &self.database_configuration);
        formatter.field("salesforce_configuration", &self.salesforce_configuration);
        formatter.field("one_drive_configuration", &self.one_drive_configuration);
        formatter.field("service_now_configuration", &self.service_now_configuration);
        formatter.field("confluence_configuration", &self.confluence_configuration);
        formatter.field(
            "google_drive_configuration",
            &self.google_drive_configuration,
        );
        formatter.field("web_crawler_configuration", &self.web_crawler_configuration);
        formatter.field("work_docs_configuration", &self.work_docs_configuration);
        formatter.finish()
    }
}
/// See [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
pub mod data_source_configuration {
    /// A builder for [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_configuration: std::option::Option<crate::model::S3DataSourceConfiguration>,
        pub(crate) share_point_configuration:
            std::option::Option<crate::model::SharePointConfiguration>,
        pub(crate) database_configuration: std::option::Option<crate::model::DatabaseConfiguration>,
        pub(crate) salesforce_configuration:
            std::option::Option<crate::model::SalesforceConfiguration>,
        pub(crate) one_drive_configuration:
            std::option::Option<crate::model::OneDriveConfiguration>,
        pub(crate) service_now_configuration:
            std::option::Option<crate::model::ServiceNowConfiguration>,
        pub(crate) confluence_configuration:
            std::option::Option<crate::model::ConfluenceConfiguration>,
        pub(crate) google_drive_configuration:
            std::option::Option<crate::model::GoogleDriveConfiguration>,
        pub(crate) web_crawler_configuration:
            std::option::Option<crate::model::WebCrawlerConfiguration>,
        pub(crate) work_docs_configuration:
            std::option::Option<crate::model::WorkDocsConfiguration>,
    }
    impl Builder {
        /// <p>Provides information to create a data source connector for a
        /// document repository in an Amazon S3 bucket.</p>
        pub fn s3_configuration(mut self, input: crate::model::S3DataSourceConfiguration) -> Self {
            self.s3_configuration = Some(input);
            self
        }
        /// <p>Provides information to create a data source connector for a
        /// document repository in an Amazon S3 bucket.</p>
        pub fn set_s3_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DataSourceConfiguration>,
        ) -> Self {
            self.s3_configuration = input;
            self
        }
        /// <p>Provides information necessary to create a data source connector
        /// for a Microsoft SharePoint site.</p>
        pub fn share_point_configuration(
            mut self,
            input: crate::model::SharePointConfiguration,
        ) -> Self {
            self.share_point_configuration = Some(input);
            self
        }
        /// <p>Provides information necessary to create a data source connector
        /// for a Microsoft SharePoint site.</p>
        pub fn set_share_point_configuration(
            mut self,
            input: std::option::Option<crate::model::SharePointConfiguration>,
        ) -> Self {
            self.share_point_configuration = input;
            self
        }
        /// <p>Provides information necessary to create a data source connector
        /// for a database.</p>
        pub fn database_configuration(
            mut self,
            input: crate::model::DatabaseConfiguration,
        ) -> Self {
            self.database_configuration = Some(input);
            self
        }
        /// <p>Provides information necessary to create a data source connector
        /// for a database.</p>
        pub fn set_database_configuration(
            mut self,
            input: std::option::Option<crate::model::DatabaseConfiguration>,
        ) -> Self {
            self.database_configuration = input;
            self
        }
        /// <p>Provides configuration information for data sources that connect
        /// to a Salesforce site.</p>
        pub fn salesforce_configuration(
            mut self,
            input: crate::model::SalesforceConfiguration,
        ) -> Self {
            self.salesforce_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for data sources that connect
        /// to a Salesforce site.</p>
        pub fn set_salesforce_configuration(
            mut self,
            input: std::option::Option<crate::model::SalesforceConfiguration>,
        ) -> Self {
            self.salesforce_configuration = input;
            self
        }
        /// <p>Provides configuration for data sources that connect to Microsoft
        /// OneDrive.</p>
        pub fn one_drive_configuration(
            mut self,
            input: crate::model::OneDriveConfiguration,
        ) -> Self {
            self.one_drive_configuration = Some(input);
            self
        }
        /// <p>Provides configuration for data sources that connect to Microsoft
        /// OneDrive.</p>
        pub fn set_one_drive_configuration(
            mut self,
            input: std::option::Option<crate::model::OneDriveConfiguration>,
        ) -> Self {
            self.one_drive_configuration = input;
            self
        }
        /// <p>Provides configuration for data sources that connect to ServiceNow
        /// instances.</p>
        pub fn service_now_configuration(
            mut self,
            input: crate::model::ServiceNowConfiguration,
        ) -> Self {
            self.service_now_configuration = Some(input);
            self
        }
        /// <p>Provides configuration for data sources that connect to ServiceNow
        /// instances.</p>
        pub fn set_service_now_configuration(
            mut self,
            input: std::option::Option<crate::model::ServiceNowConfiguration>,
        ) -> Self {
            self.service_now_configuration = input;
            self
        }
        /// <p>Provides configuration information for connecting to a Confluence
        /// data source.</p>
        pub fn confluence_configuration(
            mut self,
            input: crate::model::ConfluenceConfiguration,
        ) -> Self {
            self.confluence_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for connecting to a Confluence
        /// data source.</p>
        pub fn set_confluence_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfluenceConfiguration>,
        ) -> Self {
            self.confluence_configuration = input;
            self
        }
        /// <p>Provides configuration for data sources that connect to Google
        /// Drive. </p>
        pub fn google_drive_configuration(
            mut self,
            input: crate::model::GoogleDriveConfiguration,
        ) -> Self {
            self.google_drive_configuration = Some(input);
            self
        }
        /// <p>Provides configuration for data sources that connect to Google
        /// Drive. </p>
        pub fn set_google_drive_configuration(
            mut self,
            input: std::option::Option<crate::model::GoogleDriveConfiguration>,
        ) -> Self {
            self.google_drive_configuration = input;
            self
        }
        /// <p>Provides the configuration information required for Amazon Kendra
        /// web crawler.</p>
        pub fn web_crawler_configuration(
            mut self,
            input: crate::model::WebCrawlerConfiguration,
        ) -> Self {
            self.web_crawler_configuration = Some(input);
            self
        }
        /// <p>Provides the configuration information required for Amazon Kendra
        /// web crawler.</p>
        pub fn set_web_crawler_configuration(
            mut self,
            input: std::option::Option<crate::model::WebCrawlerConfiguration>,
        ) -> Self {
            self.web_crawler_configuration = input;
            self
        }
        /// <p>Provides the configuration information to connect to WorkDocs
        /// as your data source.</p>
        pub fn work_docs_configuration(
            mut self,
            input: crate::model::WorkDocsConfiguration,
        ) -> Self {
            self.work_docs_configuration = Some(input);
            self
        }
        /// <p>Provides the configuration information to connect to WorkDocs
        /// as your data source.</p>
        pub fn set_work_docs_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkDocsConfiguration>,
        ) -> Self {
            self.work_docs_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
        pub fn build(self) -> crate::model::DataSourceConfiguration {
            crate::model::DataSourceConfiguration {
                s3_configuration: self.s3_configuration,
                share_point_configuration: self.share_point_configuration,
                database_configuration: self.database_configuration,
                salesforce_configuration: self.salesforce_configuration,
                one_drive_configuration: self.one_drive_configuration,
                service_now_configuration: self.service_now_configuration,
                confluence_configuration: self.confluence_configuration,
                google_drive_configuration: self.google_drive_configuration,
                web_crawler_configuration: self.web_crawler_configuration,
                work_docs_configuration: self.work_docs_configuration,
            }
        }
    }
}
impl DataSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
    pub fn builder() -> crate::model::data_source_configuration::Builder {
        crate::model::data_source_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information to connect to Amazon WorkDocs
/// as your data source.</p>
/// <p>Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland
/// regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkDocsConfiguration {
    /// <p>The identifier of the directory corresponding to your
    /// Amazon WorkDocs site repository.</p>
    /// <p>You can find the organization ID in the
    /// <a href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to
    /// <b>Active Directory</b>, then
    /// <b>Directories</b>. Your Amazon WorkDocs site directory has an
    /// ID, which is the organization ID. You can also set up a new Amazon WorkDocs
    /// directory in the AWS Directory Service console and enable a Amazon WorkDocs site
    /// for the directory in the Amazon WorkDocs console.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>
    /// <code>TRUE</code> to include comments on documents
    /// in your index. Including comments in your index means each comment
    /// is a document that can be searched on.</p>
    /// <p>The default is set to <code>FALSE</code>.</p>
    pub crawl_comments: bool,
    /// <p>
    /// <code>TRUE</code> to use the change logs to update documents in your
    /// index instead of scanning all documents.</p>
    /// <p>If you are syncing your Amazon WorkDocs data source with your index for the
    /// first time, all documents are scanned. After your first sync, you can
    /// use the change logs to update your documents in your index for
    /// future syncs.</p>
    /// <p>The default is set to <code>FALSE</code>.</p>
    pub use_change_log: bool,
    /// <p>A list of regular expression patterns to include certain files
    /// in your Amazon WorkDocs site repository. Files that match the patterns
    /// are included in the index. Files that don't match the patterns are
    /// excluded from the index. If a file matches both an inclusion pattern
    /// and an exclusion pattern, the exclusion pattern takes precedence and
    /// the file isn’t included in the index.</p>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns to exclude certain files
    /// in your Amazon WorkDocs site repository. Files that match the patterns
    /// are excluded from the index. Files that don’t match the patterns
    /// are included in the index. If a file matches both an inclusion
    /// pattern and an exclusion pattern, the exclusion pattern takes
    /// precedence and the file isn’t included in the index.</p>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map
    /// Amazon WorkDocs field names to custom index field names in Amazon Kendra. You must first
    /// create the custom index fields using the <code>UpdateIndex</code> operation before
    /// you map to Amazon WorkDocs fields. For more information, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
    /// Data Source Fields</a>. The Amazon WorkDocs data source field names
    /// need to exist in your Amazon WorkDocs custom metadata.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl WorkDocsConfiguration {
    /// <p>The identifier of the directory corresponding to your
    /// Amazon WorkDocs site repository.</p>
    /// <p>You can find the organization ID in the
    /// <a href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to
    /// <b>Active Directory</b>, then
    /// <b>Directories</b>. Your Amazon WorkDocs site directory has an
    /// ID, which is the organization ID. You can also set up a new Amazon WorkDocs
    /// directory in the AWS Directory Service console and enable a Amazon WorkDocs site
    /// for the directory in the Amazon WorkDocs console.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>
    /// <code>TRUE</code> to include comments on documents
    /// in your index. Including comments in your index means each comment
    /// is a document that can be searched on.</p>
    /// <p>The default is set to <code>FALSE</code>.</p>
    pub fn crawl_comments(&self) -> bool {
        self.crawl_comments
    }
    /// <p>
    /// <code>TRUE</code> to use the change logs to update documents in your
    /// index instead of scanning all documents.</p>
    /// <p>If you are syncing your Amazon WorkDocs data source with your index for the
    /// first time, all documents are scanned. After your first sync, you can
    /// use the change logs to update your documents in your index for
    /// future syncs.</p>
    /// <p>The default is set to <code>FALSE</code>.</p>
    pub fn use_change_log(&self) -> bool {
        self.use_change_log
    }
    /// <p>A list of regular expression patterns to include certain files
    /// in your Amazon WorkDocs site repository. Files that match the patterns
    /// are included in the index. Files that don't match the patterns are
    /// excluded from the index. If a file matches both an inclusion pattern
    /// and an exclusion pattern, the exclusion pattern takes precedence and
    /// the file isn’t included in the index.</p>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns to exclude certain files
    /// in your Amazon WorkDocs site repository. Files that match the patterns
    /// are excluded from the index. Files that don’t match the patterns
    /// are included in the index. If a file matches both an inclusion
    /// pattern and an exclusion pattern, the exclusion pattern takes
    /// precedence and the file isn’t included in the index.</p>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map
    /// Amazon WorkDocs field names to custom index field names in Amazon Kendra. You must first
    /// create the custom index fields using the <code>UpdateIndex</code> operation before
    /// you map to Amazon WorkDocs fields. For more information, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
    /// Data Source Fields</a>. The Amazon WorkDocs data source field names
    /// need to exist in your Amazon WorkDocs custom metadata.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for WorkDocsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkDocsConfiguration");
        formatter.field("organization_id", &self.organization_id);
        formatter.field("crawl_comments", &self.crawl_comments);
        formatter.field("use_change_log", &self.use_change_log);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`WorkDocsConfiguration`](crate::model::WorkDocsConfiguration)
pub mod work_docs_configuration {
    /// A builder for [`WorkDocsConfiguration`](crate::model::WorkDocsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) crawl_comments: std::option::Option<bool>,
        pub(crate) use_change_log: std::option::Option<bool>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>The identifier of the directory corresponding to your
        /// Amazon WorkDocs site repository.</p>
        /// <p>You can find the organization ID in the
        /// <a href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to
        /// <b>Active Directory</b>, then
        /// <b>Directories</b>. Your Amazon WorkDocs site directory has an
        /// ID, which is the organization ID. You can also set up a new Amazon WorkDocs
        /// directory in the AWS Directory Service console and enable a Amazon WorkDocs site
        /// for the directory in the Amazon WorkDocs console.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>The identifier of the directory corresponding to your
        /// Amazon WorkDocs site repository.</p>
        /// <p>You can find the organization ID in the
        /// <a href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to
        /// <b>Active Directory</b>, then
        /// <b>Directories</b>. Your Amazon WorkDocs site directory has an
        /// ID, which is the organization ID. You can also set up a new Amazon WorkDocs
        /// directory in the AWS Directory Service console and enable a Amazon WorkDocs site
        /// for the directory in the Amazon WorkDocs console.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>
        /// <code>TRUE</code> to include comments on documents
        /// in your index. Including comments in your index means each comment
        /// is a document that can be searched on.</p>
        /// <p>The default is set to <code>FALSE</code>.</p>
        pub fn crawl_comments(mut self, input: bool) -> Self {
            self.crawl_comments = Some(input);
            self
        }
        /// <p>
        /// <code>TRUE</code> to include comments on documents
        /// in your index. Including comments in your index means each comment
        /// is a document that can be searched on.</p>
        /// <p>The default is set to <code>FALSE</code>.</p>
        pub fn set_crawl_comments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_comments = input;
            self
        }
        /// <p>
        /// <code>TRUE</code> to use the change logs to update documents in your
        /// index instead of scanning all documents.</p>
        /// <p>If you are syncing your Amazon WorkDocs data source with your index for the
        /// first time, all documents are scanned. After your first sync, you can
        /// use the change logs to update your documents in your index for
        /// future syncs.</p>
        /// <p>The default is set to <code>FALSE</code>.</p>
        pub fn use_change_log(mut self, input: bool) -> Self {
            self.use_change_log = Some(input);
            self
        }
        /// <p>
        /// <code>TRUE</code> to use the change logs to update documents in your
        /// index instead of scanning all documents.</p>
        /// <p>If you are syncing your Amazon WorkDocs data source with your index for the
        /// first time, all documents are scanned. After your first sync, you can
        /// use the change logs to update your documents in your index for
        /// future syncs.</p>
        /// <p>The default is set to <code>FALSE</code>.</p>
        pub fn set_use_change_log(mut self, input: std::option::Option<bool>) -> Self {
            self.use_change_log = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of regular expression patterns to include certain files
        /// in your Amazon WorkDocs site repository. Files that match the patterns
        /// are included in the index. Files that don't match the patterns are
        /// excluded from the index. If a file matches both an inclusion pattern
        /// and an exclusion pattern, the exclusion pattern takes precedence and
        /// the file isn’t included in the index.</p>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns to include certain files
        /// in your Amazon WorkDocs site repository. Files that match the patterns
        /// are included in the index. Files that don't match the patterns are
        /// excluded from the index. If a file matches both an inclusion pattern
        /// and an exclusion pattern, the exclusion pattern takes precedence and
        /// the file isn’t included in the index.</p>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>A list of regular expression patterns to exclude certain files
        /// in your Amazon WorkDocs site repository. Files that match the patterns
        /// are excluded from the index. Files that don’t match the patterns
        /// are included in the index. If a file matches both an inclusion
        /// pattern and an exclusion pattern, the exclusion pattern takes
        /// precedence and the file isn’t included in the index.</p>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns to exclude certain files
        /// in your Amazon WorkDocs site repository. Files that match the patterns
        /// are excluded from the index. Files that don’t match the patterns
        /// are included in the index. If a file matches both an inclusion
        /// pattern and an exclusion pattern, the exclusion pattern takes
        /// precedence and the file isn’t included in the index.</p>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map
        /// Amazon WorkDocs field names to custom index field names in Amazon Kendra. You must first
        /// create the custom index fields using the <code>UpdateIndex</code> operation before
        /// you map to Amazon WorkDocs fields. For more information, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
        /// Data Source Fields</a>. The Amazon WorkDocs data source field names
        /// need to exist in your Amazon WorkDocs custom metadata.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map
        /// Amazon WorkDocs field names to custom index field names in Amazon Kendra. You must first
        /// create the custom index fields using the <code>UpdateIndex</code> operation before
        /// you map to Amazon WorkDocs fields. For more information, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
        /// Data Source Fields</a>. The Amazon WorkDocs data source field names
        /// need to exist in your Amazon WorkDocs custom metadata.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkDocsConfiguration`](crate::model::WorkDocsConfiguration)
        pub fn build(self) -> crate::model::WorkDocsConfiguration {
            crate::model::WorkDocsConfiguration {
                organization_id: self.organization_id,
                crawl_comments: self.crawl_comments.unwrap_or_default(),
                use_change_log: self.use_change_log.unwrap_or_default(),
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl WorkDocsConfiguration {
    /// Creates a new builder-style object to manufacture [`WorkDocsConfiguration`](crate::model::WorkDocsConfiguration)
    pub fn builder() -> crate::model::work_docs_configuration::Builder {
        crate::model::work_docs_configuration::Builder::default()
    }
}

/// <p>Maps a column or attribute in the data source to an index field.
/// You must first create the fields in the index using the
/// <code>UpdateIndex</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceToIndexFieldMapping {
    /// <p>The name of the column or attribute in the data source.</p>
    pub data_source_field_name: std::option::Option<std::string::String>,
    /// <p>The type of data stored in the column or attribute.</p>
    pub date_field_format: std::option::Option<std::string::String>,
    /// <p>The name of the field in the index.</p>
    pub index_field_name: std::option::Option<std::string::String>,
}
impl DataSourceToIndexFieldMapping {
    /// <p>The name of the column or attribute in the data source.</p>
    pub fn data_source_field_name(&self) -> std::option::Option<&str> {
        self.data_source_field_name.as_deref()
    }
    /// <p>The type of data stored in the column or attribute.</p>
    pub fn date_field_format(&self) -> std::option::Option<&str> {
        self.date_field_format.as_deref()
    }
    /// <p>The name of the field in the index.</p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
}
impl std::fmt::Debug for DataSourceToIndexFieldMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceToIndexFieldMapping");
        formatter.field("data_source_field_name", &self.data_source_field_name);
        formatter.field("date_field_format", &self.date_field_format);
        formatter.field("index_field_name", &self.index_field_name);
        formatter.finish()
    }
}
/// See [`DataSourceToIndexFieldMapping`](crate::model::DataSourceToIndexFieldMapping)
pub mod data_source_to_index_field_mapping {
    /// A builder for [`DataSourceToIndexFieldMapping`](crate::model::DataSourceToIndexFieldMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_field_name: std::option::Option<std::string::String>,
        pub(crate) date_field_format: std::option::Option<std::string::String>,
        pub(crate) index_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column or attribute in the data source.</p>
        pub fn data_source_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_field_name = Some(input.into());
            self
        }
        /// <p>The name of the column or attribute in the data source.</p>
        pub fn set_data_source_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_field_name = input;
            self
        }
        /// <p>The type of data stored in the column or attribute.</p>
        pub fn date_field_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_field_format = Some(input.into());
            self
        }
        /// <p>The type of data stored in the column or attribute.</p>
        pub fn set_date_field_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_field_format = input;
            self
        }
        /// <p>The name of the field in the index.</p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field in the index.</p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceToIndexFieldMapping`](crate::model::DataSourceToIndexFieldMapping)
        pub fn build(self) -> crate::model::DataSourceToIndexFieldMapping {
            crate::model::DataSourceToIndexFieldMapping {
                data_source_field_name: self.data_source_field_name,
                date_field_format: self.date_field_format,
                index_field_name: self.index_field_name,
            }
        }
    }
}
impl DataSourceToIndexFieldMapping {
    /// Creates a new builder-style object to manufacture [`DataSourceToIndexFieldMapping`](crate::model::DataSourceToIndexFieldMapping)
    pub fn builder() -> crate::model::data_source_to_index_field_mapping::Builder {
        crate::model::data_source_to_index_field_mapping::Builder::default()
    }
}

/// <p>Provides the configuration information required for Amazon Kendra
/// web crawler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebCrawlerConfiguration {
    /// <p>Specifies the seed or starting point URLs of the
    /// websites or the sitemap URLs of the websites you want to crawl.</p>
    /// <p>You can include website subdomains. You can list up to 100 seed
    /// URLs and up to three sitemap URLs.</p>
    /// <p>You can only crawl websites that use the secure communication protocol,
    /// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
    /// crawling a website, it could be that the website is blocked from crawling.</p>
    /// <p>
    /// <i>When selecting websites to index, you must adhere to
    /// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
    /// and all other Amazon terms. Remember that you must only use the Amazon Kendra
    /// web crawler to index your own webpages, or webpages that you have
    /// authorization to index.</i>
    /// </p>
    pub urls: std::option::Option<crate::model::Urls>,
    /// <p>Specifies the number of levels in a website that you want to crawl.</p>
    /// <p>The first level begins from the website seed or starting point URL.
    /// For example, if a website has 3 levels – index level (i.e. seed in this
    /// example), sections level, and subsections level – and you are only
    /// interested in crawling information up to the sections level (i.e.
    /// levels 0-1), you can set your depth to 1.</p>
    /// <p>The default crawl depth is set to 2.</p>
    pub crawl_depth: std::option::Option<i32>,
    /// <p>The maximum number of URLs on a webpage to include when crawling a website.
    /// This number is per webpage.</p>
    /// <p>As a website’s webpages are crawled, any URLs the webpages link to are
    /// also crawled. URLs on a webpage are crawled in order of appearance.</p>
    /// <p>The default maximum links per page is 100.</p>
    pub max_links_per_page: std::option::Option<i32>,
    /// <p>The maximum size (in MB) of a webpage or attachment to crawl.</p>
    /// <p>Files larger than this size (in MB) are skipped/not crawled.</p>
    /// <p>The default maximum size of a webpage or attachment is set to 50 MB.</p>
    pub max_content_size_per_page_in_mega_bytes: std::option::Option<f32>,
    /// <p>The maximum number of URLs crawled per website host per minute.</p>
    /// <p>A minimum of one URL is required.</p>
    /// <p>The default maximum number of URLs crawled per website host per minute is 300.</p>
    pub max_urls_per_minute_crawl_rate: std::option::Option<i32>,
    /// <p>The regular expression pattern to include certain URLs to crawl.</p>
    /// <p>If there is a regular expression pattern to exclude certain URLs that
    /// conflicts with the include pattern, the exclude pattern takes precedence.</p>
    pub url_inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The regular expression pattern to exclude certain URLs to crawl.</p>
    /// <p>If there is a regular expression pattern to include certain URLs that
    /// conflicts with the exclude pattern, the exclude pattern takes precedence.</p>
    pub url_exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides configuration information required to connect to your internal
    /// websites via a web proxy.</p>
    /// <p>You must provide the website host name and port number. For example, the
    /// host name of https://a.example.com/page1.html is "a.example.com" and the
    /// port is 443, the standard port for HTTPS.</p>
    /// <p>Web proxy credentials are optional and you can use them to connect to a
    /// web proxy server that requires basic authentication. To store web proxy
    /// credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>.</p>
    pub proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
    /// <p>Provides configuration information required to connect to websites using
    /// authentication.</p>
    /// <p>You can connect to websites using basic authentication of user name and password.</p>
    /// <p>You must provide the website host name and port number. For example, the host name
    /// of https://a.example.com/page1.html is "a.example.com" and the port is 443, the
    /// standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store
    /// your authentication credentials.</p>
    pub authentication_configuration:
        std::option::Option<crate::model::AuthenticationConfiguration>,
}
impl WebCrawlerConfiguration {
    /// <p>Specifies the seed or starting point URLs of the
    /// websites or the sitemap URLs of the websites you want to crawl.</p>
    /// <p>You can include website subdomains. You can list up to 100 seed
    /// URLs and up to three sitemap URLs.</p>
    /// <p>You can only crawl websites that use the secure communication protocol,
    /// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
    /// crawling a website, it could be that the website is blocked from crawling.</p>
    /// <p>
    /// <i>When selecting websites to index, you must adhere to
    /// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
    /// and all other Amazon terms. Remember that you must only use the Amazon Kendra
    /// web crawler to index your own webpages, or webpages that you have
    /// authorization to index.</i>
    /// </p>
    pub fn urls(&self) -> std::option::Option<&crate::model::Urls> {
        self.urls.as_ref()
    }
    /// <p>Specifies the number of levels in a website that you want to crawl.</p>
    /// <p>The first level begins from the website seed or starting point URL.
    /// For example, if a website has 3 levels – index level (i.e. seed in this
    /// example), sections level, and subsections level – and you are only
    /// interested in crawling information up to the sections level (i.e.
    /// levels 0-1), you can set your depth to 1.</p>
    /// <p>The default crawl depth is set to 2.</p>
    pub fn crawl_depth(&self) -> std::option::Option<i32> {
        self.crawl_depth
    }
    /// <p>The maximum number of URLs on a webpage to include when crawling a website.
    /// This number is per webpage.</p>
    /// <p>As a website’s webpages are crawled, any URLs the webpages link to are
    /// also crawled. URLs on a webpage are crawled in order of appearance.</p>
    /// <p>The default maximum links per page is 100.</p>
    pub fn max_links_per_page(&self) -> std::option::Option<i32> {
        self.max_links_per_page
    }
    /// <p>The maximum size (in MB) of a webpage or attachment to crawl.</p>
    /// <p>Files larger than this size (in MB) are skipped/not crawled.</p>
    /// <p>The default maximum size of a webpage or attachment is set to 50 MB.</p>
    pub fn max_content_size_per_page_in_mega_bytes(&self) -> std::option::Option<f32> {
        self.max_content_size_per_page_in_mega_bytes
    }
    /// <p>The maximum number of URLs crawled per website host per minute.</p>
    /// <p>A minimum of one URL is required.</p>
    /// <p>The default maximum number of URLs crawled per website host per minute is 300.</p>
    pub fn max_urls_per_minute_crawl_rate(&self) -> std::option::Option<i32> {
        self.max_urls_per_minute_crawl_rate
    }
    /// <p>The regular expression pattern to include certain URLs to crawl.</p>
    /// <p>If there is a regular expression pattern to exclude certain URLs that
    /// conflicts with the include pattern, the exclude pattern takes precedence.</p>
    pub fn url_inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.url_inclusion_patterns.as_deref()
    }
    /// <p>The regular expression pattern to exclude certain URLs to crawl.</p>
    /// <p>If there is a regular expression pattern to include certain URLs that
    /// conflicts with the exclude pattern, the exclude pattern takes precedence.</p>
    pub fn url_exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.url_exclusion_patterns.as_deref()
    }
    /// <p>Provides configuration information required to connect to your internal
    /// websites via a web proxy.</p>
    /// <p>You must provide the website host name and port number. For example, the
    /// host name of https://a.example.com/page1.html is "a.example.com" and the
    /// port is 443, the standard port for HTTPS.</p>
    /// <p>Web proxy credentials are optional and you can use them to connect to a
    /// web proxy server that requires basic authentication. To store web proxy
    /// credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>.</p>
    pub fn proxy_configuration(&self) -> std::option::Option<&crate::model::ProxyConfiguration> {
        self.proxy_configuration.as_ref()
    }
    /// <p>Provides configuration information required to connect to websites using
    /// authentication.</p>
    /// <p>You can connect to websites using basic authentication of user name and password.</p>
    /// <p>You must provide the website host name and port number. For example, the host name
    /// of https://a.example.com/page1.html is "a.example.com" and the port is 443, the
    /// standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store
    /// your authentication credentials.</p>
    pub fn authentication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationConfiguration> {
        self.authentication_configuration.as_ref()
    }
}
impl std::fmt::Debug for WebCrawlerConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebCrawlerConfiguration");
        formatter.field("urls", &self.urls);
        formatter.field("crawl_depth", &self.crawl_depth);
        formatter.field("max_links_per_page", &self.max_links_per_page);
        formatter.field(
            "max_content_size_per_page_in_mega_bytes",
            &self.max_content_size_per_page_in_mega_bytes,
        );
        formatter.field(
            "max_urls_per_minute_crawl_rate",
            &self.max_urls_per_minute_crawl_rate,
        );
        formatter.field("url_inclusion_patterns", &self.url_inclusion_patterns);
        formatter.field("url_exclusion_patterns", &self.url_exclusion_patterns);
        formatter.field("proxy_configuration", &self.proxy_configuration);
        formatter.field(
            "authentication_configuration",
            &self.authentication_configuration,
        );
        formatter.finish()
    }
}
/// See [`WebCrawlerConfiguration`](crate::model::WebCrawlerConfiguration)
pub mod web_crawler_configuration {
    /// A builder for [`WebCrawlerConfiguration`](crate::model::WebCrawlerConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) urls: std::option::Option<crate::model::Urls>,
        pub(crate) crawl_depth: std::option::Option<i32>,
        pub(crate) max_links_per_page: std::option::Option<i32>,
        pub(crate) max_content_size_per_page_in_mega_bytes: std::option::Option<f32>,
        pub(crate) max_urls_per_minute_crawl_rate: std::option::Option<i32>,
        pub(crate) url_inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) url_exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
        pub(crate) authentication_configuration:
            std::option::Option<crate::model::AuthenticationConfiguration>,
    }
    impl Builder {
        /// <p>Specifies the seed or starting point URLs of the
        /// websites or the sitemap URLs of the websites you want to crawl.</p>
        /// <p>You can include website subdomains. You can list up to 100 seed
        /// URLs and up to three sitemap URLs.</p>
        /// <p>You can only crawl websites that use the secure communication protocol,
        /// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
        /// crawling a website, it could be that the website is blocked from crawling.</p>
        /// <p>
        /// <i>When selecting websites to index, you must adhere to
        /// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
        /// and all other Amazon terms. Remember that you must only use the Amazon Kendra
        /// web crawler to index your own webpages, or webpages that you have
        /// authorization to index.</i>
        /// </p>
        pub fn urls(mut self, input: crate::model::Urls) -> Self {
            self.urls = Some(input);
            self
        }
        /// <p>Specifies the seed or starting point URLs of the
        /// websites or the sitemap URLs of the websites you want to crawl.</p>
        /// <p>You can include website subdomains. You can list up to 100 seed
        /// URLs and up to three sitemap URLs.</p>
        /// <p>You can only crawl websites that use the secure communication protocol,
        /// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
        /// crawling a website, it could be that the website is blocked from crawling.</p>
        /// <p>
        /// <i>When selecting websites to index, you must adhere to
        /// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
        /// and all other Amazon terms. Remember that you must only use the Amazon Kendra
        /// web crawler to index your own webpages, or webpages that you have
        /// authorization to index.</i>
        /// </p>
        pub fn set_urls(mut self, input: std::option::Option<crate::model::Urls>) -> Self {
            self.urls = input;
            self
        }
        /// <p>Specifies the number of levels in a website that you want to crawl.</p>
        /// <p>The first level begins from the website seed or starting point URL.
        /// For example, if a website has 3 levels – index level (i.e. seed in this
        /// example), sections level, and subsections level – and you are only
        /// interested in crawling information up to the sections level (i.e.
        /// levels 0-1), you can set your depth to 1.</p>
        /// <p>The default crawl depth is set to 2.</p>
        pub fn crawl_depth(mut self, input: i32) -> Self {
            self.crawl_depth = Some(input);
            self
        }
        /// <p>Specifies the number of levels in a website that you want to crawl.</p>
        /// <p>The first level begins from the website seed or starting point URL.
        /// For example, if a website has 3 levels – index level (i.e. seed in this
        /// example), sections level, and subsections level – and you are only
        /// interested in crawling information up to the sections level (i.e.
        /// levels 0-1), you can set your depth to 1.</p>
        /// <p>The default crawl depth is set to 2.</p>
        pub fn set_crawl_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.crawl_depth = input;
            self
        }
        /// <p>The maximum number of URLs on a webpage to include when crawling a website.
        /// This number is per webpage.</p>
        /// <p>As a website’s webpages are crawled, any URLs the webpages link to are
        /// also crawled. URLs on a webpage are crawled in order of appearance.</p>
        /// <p>The default maximum links per page is 100.</p>
        pub fn max_links_per_page(mut self, input: i32) -> Self {
            self.max_links_per_page = Some(input);
            self
        }
        /// <p>The maximum number of URLs on a webpage to include when crawling a website.
        /// This number is per webpage.</p>
        /// <p>As a website’s webpages are crawled, any URLs the webpages link to are
        /// also crawled. URLs on a webpage are crawled in order of appearance.</p>
        /// <p>The default maximum links per page is 100.</p>
        pub fn set_max_links_per_page(mut self, input: std::option::Option<i32>) -> Self {
            self.max_links_per_page = input;
            self
        }
        /// <p>The maximum size (in MB) of a webpage or attachment to crawl.</p>
        /// <p>Files larger than this size (in MB) are skipped/not crawled.</p>
        /// <p>The default maximum size of a webpage or attachment is set to 50 MB.</p>
        pub fn max_content_size_per_page_in_mega_bytes(mut self, input: f32) -> Self {
            self.max_content_size_per_page_in_mega_bytes = Some(input);
            self
        }
        /// <p>The maximum size (in MB) of a webpage or attachment to crawl.</p>
        /// <p>Files larger than this size (in MB) are skipped/not crawled.</p>
        /// <p>The default maximum size of a webpage or attachment is set to 50 MB.</p>
        pub fn set_max_content_size_per_page_in_mega_bytes(
            mut self,
            input: std::option::Option<f32>,
        ) -> Self {
            self.max_content_size_per_page_in_mega_bytes = input;
            self
        }
        /// <p>The maximum number of URLs crawled per website host per minute.</p>
        /// <p>A minimum of one URL is required.</p>
        /// <p>The default maximum number of URLs crawled per website host per minute is 300.</p>
        pub fn max_urls_per_minute_crawl_rate(mut self, input: i32) -> Self {
            self.max_urls_per_minute_crawl_rate = Some(input);
            self
        }
        /// <p>The maximum number of URLs crawled per website host per minute.</p>
        /// <p>A minimum of one URL is required.</p>
        /// <p>The default maximum number of URLs crawled per website host per minute is 300.</p>
        pub fn set_max_urls_per_minute_crawl_rate(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_urls_per_minute_crawl_rate = input;
            self
        }
        /// Appends an item to `url_inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_url_inclusion_patterns`](Self::set_url_inclusion_patterns).
        ///
        /// <p>The regular expression pattern to include certain URLs to crawl.</p>
        /// <p>If there is a regular expression pattern to exclude certain URLs that
        /// conflicts with the include pattern, the exclude pattern takes precedence.</p>
        pub fn url_inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.url_inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.url_inclusion_patterns = Some(v);
            self
        }
        /// <p>The regular expression pattern to include certain URLs to crawl.</p>
        /// <p>If there is a regular expression pattern to exclude certain URLs that
        /// conflicts with the include pattern, the exclude pattern takes precedence.</p>
        pub fn set_url_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.url_inclusion_patterns = input;
            self
        }
        /// Appends an item to `url_exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_url_exclusion_patterns`](Self::set_url_exclusion_patterns).
        ///
        /// <p>The regular expression pattern to exclude certain URLs to crawl.</p>
        /// <p>If there is a regular expression pattern to include certain URLs that
        /// conflicts with the exclude pattern, the exclude pattern takes precedence.</p>
        pub fn url_exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.url_exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.url_exclusion_patterns = Some(v);
            self
        }
        /// <p>The regular expression pattern to exclude certain URLs to crawl.</p>
        /// <p>If there is a regular expression pattern to include certain URLs that
        /// conflicts with the exclude pattern, the exclude pattern takes precedence.</p>
        pub fn set_url_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.url_exclusion_patterns = input;
            self
        }
        /// <p>Provides configuration information required to connect to your internal
        /// websites via a web proxy.</p>
        /// <p>You must provide the website host name and port number. For example, the
        /// host name of https://a.example.com/page1.html is "a.example.com" and the
        /// port is 443, the standard port for HTTPS.</p>
        /// <p>Web proxy credentials are optional and you can use them to connect to a
        /// web proxy server that requires basic authentication. To store web proxy
        /// credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>.</p>
        pub fn proxy_configuration(mut self, input: crate::model::ProxyConfiguration) -> Self {
            self.proxy_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information required to connect to your internal
        /// websites via a web proxy.</p>
        /// <p>You must provide the website host name and port number. For example, the
        /// host name of https://a.example.com/page1.html is "a.example.com" and the
        /// port is 443, the standard port for HTTPS.</p>
        /// <p>Web proxy credentials are optional and you can use them to connect to a
        /// web proxy server that requires basic authentication. To store web proxy
        /// credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>.</p>
        pub fn set_proxy_configuration(
            mut self,
            input: std::option::Option<crate::model::ProxyConfiguration>,
        ) -> Self {
            self.proxy_configuration = input;
            self
        }
        /// <p>Provides configuration information required to connect to websites using
        /// authentication.</p>
        /// <p>You can connect to websites using basic authentication of user name and password.</p>
        /// <p>You must provide the website host name and port number. For example, the host name
        /// of https://a.example.com/page1.html is "a.example.com" and the port is 443, the
        /// standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store
        /// your authentication credentials.</p>
        pub fn authentication_configuration(
            mut self,
            input: crate::model::AuthenticationConfiguration,
        ) -> Self {
            self.authentication_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information required to connect to websites using
        /// authentication.</p>
        /// <p>You can connect to websites using basic authentication of user name and password.</p>
        /// <p>You must provide the website host name and port number. For example, the host name
        /// of https://a.example.com/page1.html is "a.example.com" and the port is 443, the
        /// standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store
        /// your authentication credentials.</p>
        pub fn set_authentication_configuration(
            mut self,
            input: std::option::Option<crate::model::AuthenticationConfiguration>,
        ) -> Self {
            self.authentication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`WebCrawlerConfiguration`](crate::model::WebCrawlerConfiguration)
        pub fn build(self) -> crate::model::WebCrawlerConfiguration {
            crate::model::WebCrawlerConfiguration {
                urls: self.urls,
                crawl_depth: self.crawl_depth,
                max_links_per_page: self.max_links_per_page,
                max_content_size_per_page_in_mega_bytes: self
                    .max_content_size_per_page_in_mega_bytes,
                max_urls_per_minute_crawl_rate: self.max_urls_per_minute_crawl_rate,
                url_inclusion_patterns: self.url_inclusion_patterns,
                url_exclusion_patterns: self.url_exclusion_patterns,
                proxy_configuration: self.proxy_configuration,
                authentication_configuration: self.authentication_configuration,
            }
        }
    }
}
impl WebCrawlerConfiguration {
    /// Creates a new builder-style object to manufacture [`WebCrawlerConfiguration`](crate::model::WebCrawlerConfiguration)
    pub fn builder() -> crate::model::web_crawler_configuration::Builder {
        crate::model::web_crawler_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information to connect to websites that require
/// user authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationConfiguration {
    /// <p>The list of configuration information that's required to connect to and
    /// crawl a website host using basic authentication credentials.</p>
    /// <p>The list includes the name and port number of the website host.</p>
    pub basic_authentication:
        std::option::Option<std::vec::Vec<crate::model::BasicAuthenticationConfiguration>>,
}
impl AuthenticationConfiguration {
    /// <p>The list of configuration information that's required to connect to and
    /// crawl a website host using basic authentication credentials.</p>
    /// <p>The list includes the name and port number of the website host.</p>
    pub fn basic_authentication(
        &self,
    ) -> std::option::Option<&[crate::model::BasicAuthenticationConfiguration]> {
        self.basic_authentication.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationConfiguration");
        formatter.field("basic_authentication", &self.basic_authentication);
        formatter.finish()
    }
}
/// See [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
pub mod authentication_configuration {
    /// A builder for [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basic_authentication:
            std::option::Option<std::vec::Vec<crate::model::BasicAuthenticationConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `basic_authentication`.
        ///
        /// To override the contents of this collection use [`set_basic_authentication`](Self::set_basic_authentication).
        ///
        /// <p>The list of configuration information that's required to connect to and
        /// crawl a website host using basic authentication credentials.</p>
        /// <p>The list includes the name and port number of the website host.</p>
        pub fn basic_authentication(
            mut self,
            input: impl Into<crate::model::BasicAuthenticationConfiguration>,
        ) -> Self {
            let mut v = self.basic_authentication.unwrap_or_default();
            v.push(input.into());
            self.basic_authentication = Some(v);
            self
        }
        /// <p>The list of configuration information that's required to connect to and
        /// crawl a website host using basic authentication credentials.</p>
        /// <p>The list includes the name and port number of the website host.</p>
        pub fn set_basic_authentication(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BasicAuthenticationConfiguration>,
            >,
        ) -> Self {
            self.basic_authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
        pub fn build(self) -> crate::model::AuthenticationConfiguration {
            crate::model::AuthenticationConfiguration {
                basic_authentication: self.basic_authentication,
            }
        }
    }
}
impl AuthenticationConfiguration {
    /// Creates a new builder-style object to manufacture [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    pub fn builder() -> crate::model::authentication_configuration::Builder {
        crate::model::authentication_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information to connect to websites that require
/// basic user authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BasicAuthenticationConfiguration {
    /// <p>The name of the website host you want to connect to using
    /// authentication credentials.</p>
    /// <p>For example, the host name of https://a.example.com/page1.html is
    /// "a.example.com".</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>The port number of the website host you want to connect to using
    /// authentication credentials.</p>
    /// <p>For example, the port for https://a.example.com/page1.html is 443,
    /// the standard port for HTTPS.</p>
    pub port: std::option::Option<i32>,
    /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
    /// </p>
    /// <p>You use a secret if basic authentication credentials are required to connect
    /// to a website. The secret stores your credentials of user name and password.</p>
    pub credentials: std::option::Option<std::string::String>,
}
impl BasicAuthenticationConfiguration {
    /// <p>The name of the website host you want to connect to using
    /// authentication credentials.</p>
    /// <p>For example, the host name of https://a.example.com/page1.html is
    /// "a.example.com".</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>The port number of the website host you want to connect to using
    /// authentication credentials.</p>
    /// <p>For example, the port for https://a.example.com/page1.html is 443,
    /// the standard port for HTTPS.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
    /// </p>
    /// <p>You use a secret if basic authentication credentials are required to connect
    /// to a website. The secret stores your credentials of user name and password.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
}
impl std::fmt::Debug for BasicAuthenticationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BasicAuthenticationConfiguration");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("credentials", &self.credentials);
        formatter.finish()
    }
}
/// See [`BasicAuthenticationConfiguration`](crate::model::BasicAuthenticationConfiguration)
pub mod basic_authentication_configuration {
    /// A builder for [`BasicAuthenticationConfiguration`](crate::model::BasicAuthenticationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) credentials: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the website host you want to connect to using
        /// authentication credentials.</p>
        /// <p>For example, the host name of https://a.example.com/page1.html is
        /// "a.example.com".</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>The name of the website host you want to connect to using
        /// authentication credentials.</p>
        /// <p>For example, the host name of https://a.example.com/page1.html is
        /// "a.example.com".</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>The port number of the website host you want to connect to using
        /// authentication credentials.</p>
        /// <p>For example, the port for https://a.example.com/page1.html is 443,
        /// the standard port for HTTPS.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number of the website host you want to connect to using
        /// authentication credentials.</p>
        /// <p>For example, the port for https://a.example.com/page1.html is 443,
        /// the standard port for HTTPS.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
        /// </p>
        /// <p>You use a secret if basic authentication credentials are required to connect
        /// to a website. The secret stores your credentials of user name and password.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
        /// </p>
        /// <p>You use a secret if basic authentication credentials are required to connect
        /// to a website. The secret stores your credentials of user name and password.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`BasicAuthenticationConfiguration`](crate::model::BasicAuthenticationConfiguration)
        pub fn build(self) -> crate::model::BasicAuthenticationConfiguration {
            crate::model::BasicAuthenticationConfiguration {
                host: self.host,
                port: self.port,
                credentials: self.credentials,
            }
        }
    }
}
impl BasicAuthenticationConfiguration {
    /// Creates a new builder-style object to manufacture [`BasicAuthenticationConfiguration`](crate::model::BasicAuthenticationConfiguration)
    pub fn builder() -> crate::model::basic_authentication_configuration::Builder {
        crate::model::basic_authentication_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information for a web proxy to connect to
/// website hosts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProxyConfiguration {
    /// <p>The name of the website host you want to connect to
    /// via a web proxy server.</p>
    /// <p>For example, the host name of https://a.example.com/page1.html
    /// is "a.example.com".</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>The port number of the website host you want to connect
    /// to via a web proxy server. </p>
    /// <p>For example, the port for https://a.example.com/page1.html
    /// is 443, the standard port for HTTPS.</p>
    pub port: std::option::Option<i32>,
    /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
    /// </p>
    /// <p>The credentials are optional. You use a secret if web proxy credentials
    /// are required to connect to a website host. Amazon Kendra currently support basic
    /// authentication to connect to a web proxy server. The secret stores your
    /// credentials.</p>
    pub credentials: std::option::Option<std::string::String>,
}
impl ProxyConfiguration {
    /// <p>The name of the website host you want to connect to
    /// via a web proxy server.</p>
    /// <p>For example, the host name of https://a.example.com/page1.html
    /// is "a.example.com".</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>The port number of the website host you want to connect
    /// to via a web proxy server. </p>
    /// <p>For example, the port for https://a.example.com/page1.html
    /// is 443, the standard port for HTTPS.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
    /// </p>
    /// <p>The credentials are optional. You use a secret if web proxy credentials
    /// are required to connect to a website host. Amazon Kendra currently support basic
    /// authentication to connect to a web proxy server. The secret stores your
    /// credentials.</p>
    pub fn credentials(&self) -> std::option::Option<&str> {
        self.credentials.as_deref()
    }
}
impl std::fmt::Debug for ProxyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProxyConfiguration");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("credentials", &self.credentials);
        formatter.finish()
    }
}
/// See [`ProxyConfiguration`](crate::model::ProxyConfiguration)
pub mod proxy_configuration {
    /// A builder for [`ProxyConfiguration`](crate::model::ProxyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) credentials: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the website host you want to connect to
        /// via a web proxy server.</p>
        /// <p>For example, the host name of https://a.example.com/page1.html
        /// is "a.example.com".</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>The name of the website host you want to connect to
        /// via a web proxy server.</p>
        /// <p>For example, the host name of https://a.example.com/page1.html
        /// is "a.example.com".</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>The port number of the website host you want to connect
        /// to via a web proxy server. </p>
        /// <p>For example, the port for https://a.example.com/page1.html
        /// is 443, the standard port for HTTPS.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number of the website host you want to connect
        /// to via a web proxy server. </p>
        /// <p>For example, the port for https://a.example.com/page1.html
        /// is 443, the standard port for HTTPS.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
        /// </p>
        /// <p>The credentials are optional. You use a secret if web proxy credentials
        /// are required to connect to a website host. Amazon Kendra currently support basic
        /// authentication to connect to a web proxy server. The secret stores your
        /// credentials.</p>
        pub fn credentials(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials = Some(input.into());
            self
        }
        /// <p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>
        /// </p>
        /// <p>The credentials are optional. You use a secret if web proxy credentials
        /// are required to connect to a website host. Amazon Kendra currently support basic
        /// authentication to connect to a web proxy server. The secret stores your
        /// credentials.</p>
        pub fn set_credentials(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`ProxyConfiguration`](crate::model::ProxyConfiguration)
        pub fn build(self) -> crate::model::ProxyConfiguration {
            crate::model::ProxyConfiguration {
                host: self.host,
                port: self.port,
                credentials: self.credentials,
            }
        }
    }
}
impl ProxyConfiguration {
    /// Creates a new builder-style object to manufacture [`ProxyConfiguration`](crate::model::ProxyConfiguration)
    pub fn builder() -> crate::model::proxy_configuration::Builder {
        crate::model::proxy_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information of the URLs to crawl.</p>
/// <p>You can only crawl websites that use the secure communication protocol,
/// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
/// crawling a website, it could be that the website is blocked from crawling.</p>
/// <p>
/// <i>When selecting websites to index, you must adhere to
/// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
/// and all other Amazon terms. Remember that you must only use the Amazon Kendra web
/// crawler to index your own webpages, or webpages that you have authorization to
/// index.</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Urls {
    /// <p>Provides the configuration of the seed or starting point URLs of the websites
    /// you want to crawl.</p>
    /// <p>You can choose to crawl only the website host names, or the website host names
    /// with subdomains, or the website host names with subdomains and other domains
    /// that the webpages link to.</p>
    /// <p>You can list up to 100 seed URLs.</p>
    pub seed_url_configuration: std::option::Option<crate::model::SeedUrlConfiguration>,
    /// <p>Provides the configuration of the sitemap URLs of the websites you want to crawl.</p>
    /// <p>Only URLs belonging to the same website host names are crawled. You can list up to
    /// three sitemap URLs.</p>
    pub site_maps_configuration: std::option::Option<crate::model::SiteMapsConfiguration>,
}
impl Urls {
    /// <p>Provides the configuration of the seed or starting point URLs of the websites
    /// you want to crawl.</p>
    /// <p>You can choose to crawl only the website host names, or the website host names
    /// with subdomains, or the website host names with subdomains and other domains
    /// that the webpages link to.</p>
    /// <p>You can list up to 100 seed URLs.</p>
    pub fn seed_url_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SeedUrlConfiguration> {
        self.seed_url_configuration.as_ref()
    }
    /// <p>Provides the configuration of the sitemap URLs of the websites you want to crawl.</p>
    /// <p>Only URLs belonging to the same website host names are crawled. You can list up to
    /// three sitemap URLs.</p>
    pub fn site_maps_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SiteMapsConfiguration> {
        self.site_maps_configuration.as_ref()
    }
}
impl std::fmt::Debug for Urls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Urls");
        formatter.field("seed_url_configuration", &self.seed_url_configuration);
        formatter.field("site_maps_configuration", &self.site_maps_configuration);
        formatter.finish()
    }
}
/// See [`Urls`](crate::model::Urls)
pub mod urls {
    /// A builder for [`Urls`](crate::model::Urls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) seed_url_configuration: std::option::Option<crate::model::SeedUrlConfiguration>,
        pub(crate) site_maps_configuration:
            std::option::Option<crate::model::SiteMapsConfiguration>,
    }
    impl Builder {
        /// <p>Provides the configuration of the seed or starting point URLs of the websites
        /// you want to crawl.</p>
        /// <p>You can choose to crawl only the website host names, or the website host names
        /// with subdomains, or the website host names with subdomains and other domains
        /// that the webpages link to.</p>
        /// <p>You can list up to 100 seed URLs.</p>
        pub fn seed_url_configuration(mut self, input: crate::model::SeedUrlConfiguration) -> Self {
            self.seed_url_configuration = Some(input);
            self
        }
        /// <p>Provides the configuration of the seed or starting point URLs of the websites
        /// you want to crawl.</p>
        /// <p>You can choose to crawl only the website host names, or the website host names
        /// with subdomains, or the website host names with subdomains and other domains
        /// that the webpages link to.</p>
        /// <p>You can list up to 100 seed URLs.</p>
        pub fn set_seed_url_configuration(
            mut self,
            input: std::option::Option<crate::model::SeedUrlConfiguration>,
        ) -> Self {
            self.seed_url_configuration = input;
            self
        }
        /// <p>Provides the configuration of the sitemap URLs of the websites you want to crawl.</p>
        /// <p>Only URLs belonging to the same website host names are crawled. You can list up to
        /// three sitemap URLs.</p>
        pub fn site_maps_configuration(
            mut self,
            input: crate::model::SiteMapsConfiguration,
        ) -> Self {
            self.site_maps_configuration = Some(input);
            self
        }
        /// <p>Provides the configuration of the sitemap URLs of the websites you want to crawl.</p>
        /// <p>Only URLs belonging to the same website host names are crawled. You can list up to
        /// three sitemap URLs.</p>
        pub fn set_site_maps_configuration(
            mut self,
            input: std::option::Option<crate::model::SiteMapsConfiguration>,
        ) -> Self {
            self.site_maps_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Urls`](crate::model::Urls)
        pub fn build(self) -> crate::model::Urls {
            crate::model::Urls {
                seed_url_configuration: self.seed_url_configuration,
                site_maps_configuration: self.site_maps_configuration,
            }
        }
    }
}
impl Urls {
    /// Creates a new builder-style object to manufacture [`Urls`](crate::model::Urls)
    pub fn builder() -> crate::model::urls::Builder {
        crate::model::urls::Builder::default()
    }
}

/// <p>Provides the configuration information of the sitemap URLs to crawl.</p>
/// <p>
/// <i>When selecting websites to index, you must adhere to
/// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
/// and all other Amazon terms. Remember that you must only use the Amazon Kendra web
/// crawler to index your own webpages, or webpages that you have authorization
/// to index.</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SiteMapsConfiguration {
    /// <p>The list of sitemap URLs of the websites
    /// you want to crawl.</p>
    /// <p>The list can include a maximum of three sitemap URLs.</p>
    pub site_maps: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SiteMapsConfiguration {
    /// <p>The list of sitemap URLs of the websites
    /// you want to crawl.</p>
    /// <p>The list can include a maximum of three sitemap URLs.</p>
    pub fn site_maps(&self) -> std::option::Option<&[std::string::String]> {
        self.site_maps.as_deref()
    }
}
impl std::fmt::Debug for SiteMapsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SiteMapsConfiguration");
        formatter.field("site_maps", &self.site_maps);
        formatter.finish()
    }
}
/// See [`SiteMapsConfiguration`](crate::model::SiteMapsConfiguration)
pub mod site_maps_configuration {
    /// A builder for [`SiteMapsConfiguration`](crate::model::SiteMapsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_maps: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `site_maps`.
        ///
        /// To override the contents of this collection use [`set_site_maps`](Self::set_site_maps).
        ///
        /// <p>The list of sitemap URLs of the websites
        /// you want to crawl.</p>
        /// <p>The list can include a maximum of three sitemap URLs.</p>
        pub fn site_maps(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.site_maps.unwrap_or_default();
            v.push(input.into());
            self.site_maps = Some(v);
            self
        }
        /// <p>The list of sitemap URLs of the websites
        /// you want to crawl.</p>
        /// <p>The list can include a maximum of three sitemap URLs.</p>
        pub fn set_site_maps(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.site_maps = input;
            self
        }
        /// Consumes the builder and constructs a [`SiteMapsConfiguration`](crate::model::SiteMapsConfiguration)
        pub fn build(self) -> crate::model::SiteMapsConfiguration {
            crate::model::SiteMapsConfiguration {
                site_maps: self.site_maps,
            }
        }
    }
}
impl SiteMapsConfiguration {
    /// Creates a new builder-style object to manufacture [`SiteMapsConfiguration`](crate::model::SiteMapsConfiguration)
    pub fn builder() -> crate::model::site_maps_configuration::Builder {
        crate::model::site_maps_configuration::Builder::default()
    }
}

/// <p>Provides the configuration information of the seed or starting point URLs to crawl.</p>
/// <p>
/// <i>When selecting websites to index, you must adhere to
/// the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a>
/// and all other Amazon terms. Remember that you must only use the Amazon Kendra web
/// crawler to index your own webpages, or webpages that you have authorization
/// to index.</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SeedUrlConfiguration {
    /// <p>The list of seed or starting point URLs of the
    /// websites you want to crawl.</p>
    /// <p>The list can include a maximum of 100 seed URLs.</p>
    pub seed_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can choose one of the following modes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HOST_ONLY</code> – crawl only the website host names.
    /// For example, if the seed URL is "abc.example.com",
    /// then only URLs with host name "abc.example.com" are crawled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUBDOMAINS</code> – crawl the website host names with
    /// subdomains. For example, if the seed URL is  "abc.example.com", then
    /// "a.abc.example.com" and "b.abc.example.com" are also crawled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EVERYTHING</code> – crawl the website host names with
    /// subdomains and other domains that the webpages link to.</p>
    /// </li>
    /// </ul>
    /// <p>The default mode is set to <code>HOST_ONLY</code>.</p>
    pub web_crawler_mode: std::option::Option<crate::model::WebCrawlerMode>,
}
impl SeedUrlConfiguration {
    /// <p>The list of seed or starting point URLs of the
    /// websites you want to crawl.</p>
    /// <p>The list can include a maximum of 100 seed URLs.</p>
    pub fn seed_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.seed_urls.as_deref()
    }
    /// <p>You can choose one of the following modes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HOST_ONLY</code> – crawl only the website host names.
    /// For example, if the seed URL is "abc.example.com",
    /// then only URLs with host name "abc.example.com" are crawled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUBDOMAINS</code> – crawl the website host names with
    /// subdomains. For example, if the seed URL is  "abc.example.com", then
    /// "a.abc.example.com" and "b.abc.example.com" are also crawled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EVERYTHING</code> – crawl the website host names with
    /// subdomains and other domains that the webpages link to.</p>
    /// </li>
    /// </ul>
    /// <p>The default mode is set to <code>HOST_ONLY</code>.</p>
    pub fn web_crawler_mode(&self) -> std::option::Option<&crate::model::WebCrawlerMode> {
        self.web_crawler_mode.as_ref()
    }
}
impl std::fmt::Debug for SeedUrlConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SeedUrlConfiguration");
        formatter.field("seed_urls", &self.seed_urls);
        formatter.field("web_crawler_mode", &self.web_crawler_mode);
        formatter.finish()
    }
}
/// See [`SeedUrlConfiguration`](crate::model::SeedUrlConfiguration)
pub mod seed_url_configuration {
    /// A builder for [`SeedUrlConfiguration`](crate::model::SeedUrlConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) seed_urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) web_crawler_mode: std::option::Option<crate::model::WebCrawlerMode>,
    }
    impl Builder {
        /// Appends an item to `seed_urls`.
        ///
        /// To override the contents of this collection use [`set_seed_urls`](Self::set_seed_urls).
        ///
        /// <p>The list of seed or starting point URLs of the
        /// websites you want to crawl.</p>
        /// <p>The list can include a maximum of 100 seed URLs.</p>
        pub fn seed_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.seed_urls.unwrap_or_default();
            v.push(input.into());
            self.seed_urls = Some(v);
            self
        }
        /// <p>The list of seed or starting point URLs of the
        /// websites you want to crawl.</p>
        /// <p>The list can include a maximum of 100 seed URLs.</p>
        pub fn set_seed_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.seed_urls = input;
            self
        }
        /// <p>You can choose one of the following modes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HOST_ONLY</code> – crawl only the website host names.
        /// For example, if the seed URL is "abc.example.com",
        /// then only URLs with host name "abc.example.com" are crawled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUBDOMAINS</code> – crawl the website host names with
        /// subdomains. For example, if the seed URL is  "abc.example.com", then
        /// "a.abc.example.com" and "b.abc.example.com" are also crawled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EVERYTHING</code> – crawl the website host names with
        /// subdomains and other domains that the webpages link to.</p>
        /// </li>
        /// </ul>
        /// <p>The default mode is set to <code>HOST_ONLY</code>.</p>
        pub fn web_crawler_mode(mut self, input: crate::model::WebCrawlerMode) -> Self {
            self.web_crawler_mode = Some(input);
            self
        }
        /// <p>You can choose one of the following modes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HOST_ONLY</code> – crawl only the website host names.
        /// For example, if the seed URL is "abc.example.com",
        /// then only URLs with host name "abc.example.com" are crawled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUBDOMAINS</code> – crawl the website host names with
        /// subdomains. For example, if the seed URL is  "abc.example.com", then
        /// "a.abc.example.com" and "b.abc.example.com" are also crawled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EVERYTHING</code> – crawl the website host names with
        /// subdomains and other domains that the webpages link to.</p>
        /// </li>
        /// </ul>
        /// <p>The default mode is set to <code>HOST_ONLY</code>.</p>
        pub fn set_web_crawler_mode(
            mut self,
            input: std::option::Option<crate::model::WebCrawlerMode>,
        ) -> Self {
            self.web_crawler_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`SeedUrlConfiguration`](crate::model::SeedUrlConfiguration)
        pub fn build(self) -> crate::model::SeedUrlConfiguration {
            crate::model::SeedUrlConfiguration {
                seed_urls: self.seed_urls,
                web_crawler_mode: self.web_crawler_mode,
            }
        }
    }
}
impl SeedUrlConfiguration {
    /// Creates a new builder-style object to manufacture [`SeedUrlConfiguration`](crate::model::SeedUrlConfiguration)
    pub fn builder() -> crate::model::seed_url_configuration::Builder {
        crate::model::seed_url_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WebCrawlerMode {
    #[allow(missing_docs)] // documentation missing in model
    Everything,
    #[allow(missing_docs)] // documentation missing in model
    HostOnly,
    #[allow(missing_docs)] // documentation missing in model
    Subdomains,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WebCrawlerMode {
    fn from(s: &str) -> Self {
        match s {
            "EVERYTHING" => WebCrawlerMode::Everything,
            "HOST_ONLY" => WebCrawlerMode::HostOnly,
            "SUBDOMAINS" => WebCrawlerMode::Subdomains,
            other => WebCrawlerMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WebCrawlerMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WebCrawlerMode::from(s))
    }
}
impl WebCrawlerMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WebCrawlerMode::Everything => "EVERYTHING",
            WebCrawlerMode::HostOnly => "HOST_ONLY",
            WebCrawlerMode::Subdomains => "SUBDOMAINS",
            WebCrawlerMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVERYTHING", "HOST_ONLY", "SUBDOMAINS"]
    }
}
impl AsRef<str> for WebCrawlerMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for data sources that connect
/// to Google Drive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GoogleDriveConfiguration {
    /// <p>The Amazon Resource Name (ARN) of a Secrets Managersecret
    /// that contains the credentials required to connect to Google Drive.
    /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
    /// source</a>.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>A list of regular expression patterns that apply to path on Google
    /// Drive. Items that match the pattern are included in the index from
    /// both shared drives and users' My Drives. Items that don't match the
    /// pattern are excluded from the index. If an item matches both an
    /// inclusion pattern and an exclusion pattern, it is excluded from the
    /// index.</p>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns that apply to the path on
    /// Google Drive. Items that match the pattern are excluded from the
    /// index from both shared drives and users' My Drives. Items that don't
    /// match the pattern are included in the index. If an item matches both
    /// an exclusion pattern and an inclusion pattern, it is excluded from
    /// the index.</p>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Defines mapping between a field in the Google Drive and a Amazon Kendra
    /// index field.</p>
    /// <p>If you are using the console, you can define index fields when
    /// creating the mapping. If you are using the API, you must first
    /// create the field using the <code>UpdateIndex</code>
    /// operation.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>A list of MIME types to exclude from the index. All documents
    /// matching the specified MIME type are excluded. </p>
    /// <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
    /// source</a>.</p>
    pub exclude_mime_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of email addresses of the users. Documents owned by these
    /// users are excluded from the index. Documents shared with excluded
    /// users are indexed unless they are excluded in another way.</p>
    pub exclude_user_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of identifiers or shared drives to exclude from the index.
    /// All files and folders stored on the shared drive are
    /// excluded.</p>
    pub exclude_shared_drives: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GoogleDriveConfiguration {
    /// <p>The Amazon Resource Name (ARN) of a Secrets Managersecret
    /// that contains the credentials required to connect to Google Drive.
    /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
    /// source</a>.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>A list of regular expression patterns that apply to path on Google
    /// Drive. Items that match the pattern are included in the index from
    /// both shared drives and users' My Drives. Items that don't match the
    /// pattern are excluded from the index. If an item matches both an
    /// inclusion pattern and an exclusion pattern, it is excluded from the
    /// index.</p>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns that apply to the path on
    /// Google Drive. Items that match the pattern are excluded from the
    /// index from both shared drives and users' My Drives. Items that don't
    /// match the pattern are included in the index. If an item matches both
    /// an exclusion pattern and an inclusion pattern, it is excluded from
    /// the index.</p>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
    /// <p>Defines mapping between a field in the Google Drive and a Amazon Kendra
    /// index field.</p>
    /// <p>If you are using the console, you can define index fields when
    /// creating the mapping. If you are using the API, you must first
    /// create the field using the <code>UpdateIndex</code>
    /// operation.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>A list of MIME types to exclude from the index. All documents
    /// matching the specified MIME type are excluded. </p>
    /// <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
    /// source</a>.</p>
    pub fn exclude_mime_types(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_mime_types.as_deref()
    }
    /// <p>A list of email addresses of the users. Documents owned by these
    /// users are excluded from the index. Documents shared with excluded
    /// users are indexed unless they are excluded in another way.</p>
    pub fn exclude_user_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_user_accounts.as_deref()
    }
    /// <p>A list of identifiers or shared drives to exclude from the index.
    /// All files and folders stored on the shared drive are
    /// excluded.</p>
    pub fn exclude_shared_drives(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_shared_drives.as_deref()
    }
}
impl std::fmt::Debug for GoogleDriveConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GoogleDriveConfiguration");
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("exclude_mime_types", &self.exclude_mime_types);
        formatter.field("exclude_user_accounts", &self.exclude_user_accounts);
        formatter.field("exclude_shared_drives", &self.exclude_shared_drives);
        formatter.finish()
    }
}
/// See [`GoogleDriveConfiguration`](crate::model::GoogleDriveConfiguration)
pub mod google_drive_configuration {
    /// A builder for [`GoogleDriveConfiguration`](crate::model::GoogleDriveConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) exclude_mime_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_user_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_shared_drives: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a Secrets Managersecret
        /// that contains the credentials required to connect to Google Drive.
        /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
        /// source</a>.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Secrets Managersecret
        /// that contains the credentials required to connect to Google Drive.
        /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
        /// source</a>.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of regular expression patterns that apply to path on Google
        /// Drive. Items that match the pattern are included in the index from
        /// both shared drives and users' My Drives. Items that don't match the
        /// pattern are excluded from the index. If an item matches both an
        /// inclusion pattern and an exclusion pattern, it is excluded from the
        /// index.</p>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns that apply to path on Google
        /// Drive. Items that match the pattern are included in the index from
        /// both shared drives and users' My Drives. Items that don't match the
        /// pattern are excluded from the index. If an item matches both an
        /// inclusion pattern and an exclusion pattern, it is excluded from the
        /// index.</p>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>A list of regular expression patterns that apply to the path on
        /// Google Drive. Items that match the pattern are excluded from the
        /// index from both shared drives and users' My Drives. Items that don't
        /// match the pattern are included in the index. If an item matches both
        /// an exclusion pattern and an inclusion pattern, it is excluded from
        /// the index.</p>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns that apply to the path on
        /// Google Drive. Items that match the pattern are excluded from the
        /// index from both shared drives and users' My Drives. Items that don't
        /// match the pattern are included in the index. If an item matches both
        /// an exclusion pattern and an inclusion pattern, it is excluded from
        /// the index.</p>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>Defines mapping between a field in the Google Drive and a Amazon Kendra
        /// index field.</p>
        /// <p>If you are using the console, you can define index fields when
        /// creating the mapping. If you are using the API, you must first
        /// create the field using the <code>UpdateIndex</code>
        /// operation.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>Defines mapping between a field in the Google Drive and a Amazon Kendra
        /// index field.</p>
        /// <p>If you are using the console, you can define index fields when
        /// creating the mapping. If you are using the API, you must first
        /// create the field using the <code>UpdateIndex</code>
        /// operation.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Appends an item to `exclude_mime_types`.
        ///
        /// To override the contents of this collection use [`set_exclude_mime_types`](Self::set_exclude_mime_types).
        ///
        /// <p>A list of MIME types to exclude from the index. All documents
        /// matching the specified MIME type are excluded. </p>
        /// <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
        /// source</a>.</p>
        pub fn exclude_mime_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclude_mime_types.unwrap_or_default();
            v.push(input.into());
            self.exclude_mime_types = Some(v);
            self
        }
        /// <p>A list of MIME types to exclude from the index. All documents
        /// matching the specified MIME type are excluded. </p>
        /// <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data
        /// source</a>.</p>
        pub fn set_exclude_mime_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_mime_types = input;
            self
        }
        /// Appends an item to `exclude_user_accounts`.
        ///
        /// To override the contents of this collection use [`set_exclude_user_accounts`](Self::set_exclude_user_accounts).
        ///
        /// <p>A list of email addresses of the users. Documents owned by these
        /// users are excluded from the index. Documents shared with excluded
        /// users are indexed unless they are excluded in another way.</p>
        pub fn exclude_user_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclude_user_accounts.unwrap_or_default();
            v.push(input.into());
            self.exclude_user_accounts = Some(v);
            self
        }
        /// <p>A list of email addresses of the users. Documents owned by these
        /// users are excluded from the index. Documents shared with excluded
        /// users are indexed unless they are excluded in another way.</p>
        pub fn set_exclude_user_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_user_accounts = input;
            self
        }
        /// Appends an item to `exclude_shared_drives`.
        ///
        /// To override the contents of this collection use [`set_exclude_shared_drives`](Self::set_exclude_shared_drives).
        ///
        /// <p>A list of identifiers or shared drives to exclude from the index.
        /// All files and folders stored on the shared drive are
        /// excluded.</p>
        pub fn exclude_shared_drives(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclude_shared_drives.unwrap_or_default();
            v.push(input.into());
            self.exclude_shared_drives = Some(v);
            self
        }
        /// <p>A list of identifiers or shared drives to exclude from the index.
        /// All files and folders stored on the shared drive are
        /// excluded.</p>
        pub fn set_exclude_shared_drives(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_shared_drives = input;
            self
        }
        /// Consumes the builder and constructs a [`GoogleDriveConfiguration`](crate::model::GoogleDriveConfiguration)
        pub fn build(self) -> crate::model::GoogleDriveConfiguration {
            crate::model::GoogleDriveConfiguration {
                secret_arn: self.secret_arn,
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
                field_mappings: self.field_mappings,
                exclude_mime_types: self.exclude_mime_types,
                exclude_user_accounts: self.exclude_user_accounts,
                exclude_shared_drives: self.exclude_shared_drives,
            }
        }
    }
}
impl GoogleDriveConfiguration {
    /// Creates a new builder-style object to manufacture [`GoogleDriveConfiguration`](crate::model::GoogleDriveConfiguration)
    pub fn builder() -> crate::model::google_drive_configuration::Builder {
        crate::model::google_drive_configuration::Builder::default()
    }
}

/// <p>Provides configuration information for data sources that connect
/// to Confluence.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceConfiguration {
    /// <p>The URL of your Confluence instance. Use the full URL of the
    /// server. For example, <code>https://server.example.com:port/</code>.
    /// You can also use an IP address, for example,
    /// <code>https://192.168.1.113/</code>.</p>
    pub server_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the key/value pairs required to connect to your
    /// Confluence server. The secret must contain a JSON structure with the
    /// following keys:</p>
    /// <ul>
    /// <li>
    /// <p>username - The user name or email address of a user with
    /// administrative privileges for the Confluence server.</p>
    /// </li>
    /// <li>
    /// <p>password - The password associated with the user logging
    /// in to the Confluence server.</p>
    /// </li>
    /// </ul>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the version of the Confluence installation that you are
    /// connecting to.</p>
    pub version: std::option::Option<crate::model::ConfluenceVersion>,
    /// <p>Specifies configuration information for indexing Confluence
    /// spaces.</p>
    pub space_configuration: std::option::Option<crate::model::ConfluenceSpaceConfiguration>,
    /// <p>Specifies configuration information for indexing Confluence
    /// pages.</p>
    pub page_configuration: std::option::Option<crate::model::ConfluencePageConfiguration>,
    /// <p> Specifies configuration information for indexing Confluence
    /// blogs.</p>
    pub blog_configuration: std::option::Option<crate::model::ConfluenceBlogConfiguration>,
    /// <p>Specifies configuration information for indexing attachments to
    /// Confluence blogs and pages.</p>
    pub attachment_configuration:
        std::option::Option<crate::model::ConfluenceAttachmentConfiguration>,
    /// <p>Specifies the information for connecting to an Amazon VPC.</p>
    pub vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
    /// <p>A list of regular expression patterns that apply to a URL on the
    /// Confluence server. An inclusion pattern can apply to a blog post, a
    /// page, a space, or an attachment. Items that match the patterns are
    /// included in the index. Items that don't match the pattern are
    /// excluded from the index. If an item matches both an inclusion
    /// pattern and an exclusion pattern, the item isn't included in the
    /// index.</p>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns that apply to a URL on the
    /// Confluence server. An exclusion pattern can apply to a blog post, a
    /// page, a space, or an attachment. Items that match the pattern are
    /// excluded from the index. Items that don't match the pattern are
    /// included in the index. If a item matches both an exclusion pattern
    /// and an inclusion pattern, the item isn't included in the
    /// index.</p>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ConfluenceConfiguration {
    /// <p>The URL of your Confluence instance. Use the full URL of the
    /// server. For example, <code>https://server.example.com:port/</code>.
    /// You can also use an IP address, for example,
    /// <code>https://192.168.1.113/</code>.</p>
    pub fn server_url(&self) -> std::option::Option<&str> {
        self.server_url.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the key/value pairs required to connect to your
    /// Confluence server. The secret must contain a JSON structure with the
    /// following keys:</p>
    /// <ul>
    /// <li>
    /// <p>username - The user name or email address of a user with
    /// administrative privileges for the Confluence server.</p>
    /// </li>
    /// <li>
    /// <p>password - The password associated with the user logging
    /// in to the Confluence server.</p>
    /// </li>
    /// </ul>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>Specifies the version of the Confluence installation that you are
    /// connecting to.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::ConfluenceVersion> {
        self.version.as_ref()
    }
    /// <p>Specifies configuration information for indexing Confluence
    /// spaces.</p>
    pub fn space_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceSpaceConfiguration> {
        self.space_configuration.as_ref()
    }
    /// <p>Specifies configuration information for indexing Confluence
    /// pages.</p>
    pub fn page_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConfluencePageConfiguration> {
        self.page_configuration.as_ref()
    }
    /// <p> Specifies configuration information for indexing Confluence
    /// blogs.</p>
    pub fn blog_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceBlogConfiguration> {
        self.blog_configuration.as_ref()
    }
    /// <p>Specifies configuration information for indexing attachments to
    /// Confluence blogs and pages.</p>
    pub fn attachment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceAttachmentConfiguration> {
        self.attachment_configuration.as_ref()
    }
    /// <p>Specifies the information for connecting to an Amazon VPC.</p>
    pub fn vpc_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceVpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p>A list of regular expression patterns that apply to a URL on the
    /// Confluence server. An inclusion pattern can apply to a blog post, a
    /// page, a space, or an attachment. Items that match the patterns are
    /// included in the index. Items that don't match the pattern are
    /// excluded from the index. If an item matches both an inclusion
    /// pattern and an exclusion pattern, the item isn't included in the
    /// index.</p>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns that apply to a URL on the
    /// Confluence server. An exclusion pattern can apply to a blog post, a
    /// page, a space, or an attachment. Items that match the pattern are
    /// excluded from the index. Items that don't match the pattern are
    /// included in the index. If a item matches both an exclusion pattern
    /// and an inclusion pattern, the item isn't included in the
    /// index.</p>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceConfiguration");
        formatter.field("server_url", &self.server_url);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("version", &self.version);
        formatter.field("space_configuration", &self.space_configuration);
        formatter.field("page_configuration", &self.page_configuration);
        formatter.field("blog_configuration", &self.blog_configuration);
        formatter.field("attachment_configuration", &self.attachment_configuration);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.finish()
    }
}
/// See [`ConfluenceConfiguration`](crate::model::ConfluenceConfiguration)
pub mod confluence_configuration {
    /// A builder for [`ConfluenceConfiguration`](crate::model::ConfluenceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_url: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::ConfluenceVersion>,
        pub(crate) space_configuration:
            std::option::Option<crate::model::ConfluenceSpaceConfiguration>,
        pub(crate) page_configuration:
            std::option::Option<crate::model::ConfluencePageConfiguration>,
        pub(crate) blog_configuration:
            std::option::Option<crate::model::ConfluenceBlogConfiguration>,
        pub(crate) attachment_configuration:
            std::option::Option<crate::model::ConfluenceAttachmentConfiguration>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The URL of your Confluence instance. Use the full URL of the
        /// server. For example, <code>https://server.example.com:port/</code>.
        /// You can also use an IP address, for example,
        /// <code>https://192.168.1.113/</code>.</p>
        pub fn server_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_url = Some(input.into());
            self
        }
        /// <p>The URL of your Confluence instance. Use the full URL of the
        /// server. For example, <code>https://server.example.com:port/</code>.
        /// You can also use an IP address, for example,
        /// <code>https://192.168.1.113/</code>.</p>
        pub fn set_server_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_url = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the key/value pairs required to connect to your
        /// Confluence server. The secret must contain a JSON structure with the
        /// following keys:</p>
        /// <ul>
        /// <li>
        /// <p>username - The user name or email address of a user with
        /// administrative privileges for the Confluence server.</p>
        /// </li>
        /// <li>
        /// <p>password - The password associated with the user logging
        /// in to the Confluence server.</p>
        /// </li>
        /// </ul>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the key/value pairs required to connect to your
        /// Confluence server. The secret must contain a JSON structure with the
        /// following keys:</p>
        /// <ul>
        /// <li>
        /// <p>username - The user name or email address of a user with
        /// administrative privileges for the Confluence server.</p>
        /// </li>
        /// <li>
        /// <p>password - The password associated with the user logging
        /// in to the Confluence server.</p>
        /// </li>
        /// </ul>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>Specifies the version of the Confluence installation that you are
        /// connecting to.</p>
        pub fn version(mut self, input: crate::model::ConfluenceVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>Specifies the version of the Confluence installation that you are
        /// connecting to.</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::ConfluenceVersion>,
        ) -> Self {
            self.version = input;
            self
        }
        /// <p>Specifies configuration information for indexing Confluence
        /// spaces.</p>
        pub fn space_configuration(
            mut self,
            input: crate::model::ConfluenceSpaceConfiguration,
        ) -> Self {
            self.space_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information for indexing Confluence
        /// spaces.</p>
        pub fn set_space_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfluenceSpaceConfiguration>,
        ) -> Self {
            self.space_configuration = input;
            self
        }
        /// <p>Specifies configuration information for indexing Confluence
        /// pages.</p>
        pub fn page_configuration(
            mut self,
            input: crate::model::ConfluencePageConfiguration,
        ) -> Self {
            self.page_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information for indexing Confluence
        /// pages.</p>
        pub fn set_page_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfluencePageConfiguration>,
        ) -> Self {
            self.page_configuration = input;
            self
        }
        /// <p> Specifies configuration information for indexing Confluence
        /// blogs.</p>
        pub fn blog_configuration(
            mut self,
            input: crate::model::ConfluenceBlogConfiguration,
        ) -> Self {
            self.blog_configuration = Some(input);
            self
        }
        /// <p> Specifies configuration information for indexing Confluence
        /// blogs.</p>
        pub fn set_blog_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfluenceBlogConfiguration>,
        ) -> Self {
            self.blog_configuration = input;
            self
        }
        /// <p>Specifies configuration information for indexing attachments to
        /// Confluence blogs and pages.</p>
        pub fn attachment_configuration(
            mut self,
            input: crate::model::ConfluenceAttachmentConfiguration,
        ) -> Self {
            self.attachment_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information for indexing attachments to
        /// Confluence blogs and pages.</p>
        pub fn set_attachment_configuration(
            mut self,
            input: std::option::Option<crate::model::ConfluenceAttachmentConfiguration>,
        ) -> Self {
            self.attachment_configuration = input;
            self
        }
        /// <p>Specifies the information for connecting to an Amazon VPC.</p>
        pub fn vpc_configuration(
            mut self,
            input: crate::model::DataSourceVpcConfiguration,
        ) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>Specifies the information for connecting to an Amazon VPC.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of regular expression patterns that apply to a URL on the
        /// Confluence server. An inclusion pattern can apply to a blog post, a
        /// page, a space, or an attachment. Items that match the patterns are
        /// included in the index. Items that don't match the pattern are
        /// excluded from the index. If an item matches both an inclusion
        /// pattern and an exclusion pattern, the item isn't included in the
        /// index.</p>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns that apply to a URL on the
        /// Confluence server. An inclusion pattern can apply to a blog post, a
        /// page, a space, or an attachment. Items that match the patterns are
        /// included in the index. Items that don't match the pattern are
        /// excluded from the index. If an item matches both an inclusion
        /// pattern and an exclusion pattern, the item isn't included in the
        /// index.</p>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>A list of regular expression patterns that apply to a URL on the
        /// Confluence server. An exclusion pattern can apply to a blog post, a
        /// page, a space, or an attachment. Items that match the pattern are
        /// excluded from the index. Items that don't match the pattern are
        /// included in the index. If a item matches both an exclusion pattern
        /// and an inclusion pattern, the item isn't included in the
        /// index.</p>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns that apply to a URL on the
        /// Confluence server. An exclusion pattern can apply to a blog post, a
        /// page, a space, or an attachment. Items that match the pattern are
        /// excluded from the index. Items that don't match the pattern are
        /// included in the index. If a item matches both an exclusion pattern
        /// and an inclusion pattern, the item isn't included in the
        /// index.</p>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceConfiguration`](crate::model::ConfluenceConfiguration)
        pub fn build(self) -> crate::model::ConfluenceConfiguration {
            crate::model::ConfluenceConfiguration {
                server_url: self.server_url,
                secret_arn: self.secret_arn,
                version: self.version,
                space_configuration: self.space_configuration,
                page_configuration: self.page_configuration,
                blog_configuration: self.blog_configuration,
                attachment_configuration: self.attachment_configuration,
                vpc_configuration: self.vpc_configuration,
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
            }
        }
    }
}
impl ConfluenceConfiguration {
    /// Creates a new builder-style object to manufacture [`ConfluenceConfiguration`](crate::model::ConfluenceConfiguration)
    pub fn builder() -> crate::model::confluence_configuration::Builder {
        crate::model::confluence_configuration::Builder::default()
    }
}

/// <p>Provides information for connecting to an Amazon VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceVpcConfiguration {
    /// <p>A list of identifiers for subnets within your Amazon VPC. The
    /// subnets should be able to connect to each other in the VPC, and they
    /// should have outgoing access to the Internet through a NAT
    /// device.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of identifiers of security groups within your Amazon VPC.
    /// The security groups should enable Amazon Kendra to connect to the data
    /// source.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DataSourceVpcConfiguration {
    /// <p>A list of identifiers for subnets within your Amazon VPC. The
    /// subnets should be able to connect to each other in the VPC, and they
    /// should have outgoing access to the Internet through a NAT
    /// device.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>A list of identifiers of security groups within your Amazon VPC.
    /// The security groups should enable Amazon Kendra to connect to the data
    /// source.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for DataSourceVpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceVpcConfiguration");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`DataSourceVpcConfiguration`](crate::model::DataSourceVpcConfiguration)
pub mod data_source_vpc_configuration {
    /// A builder for [`DataSourceVpcConfiguration`](crate::model::DataSourceVpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of identifiers for subnets within your Amazon VPC. The
        /// subnets should be able to connect to each other in the VPC, and they
        /// should have outgoing access to the Internet through a NAT
        /// device.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of identifiers for subnets within your Amazon VPC. The
        /// subnets should be able to connect to each other in the VPC, and they
        /// should have outgoing access to the Internet through a NAT
        /// device.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of identifiers of security groups within your Amazon VPC.
        /// The security groups should enable Amazon Kendra to connect to the data
        /// source.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of identifiers of security groups within your Amazon VPC.
        /// The security groups should enable Amazon Kendra to connect to the data
        /// source.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceVpcConfiguration`](crate::model::DataSourceVpcConfiguration)
        pub fn build(self) -> crate::model::DataSourceVpcConfiguration {
            crate::model::DataSourceVpcConfiguration {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl DataSourceVpcConfiguration {
    /// Creates a new builder-style object to manufacture [`DataSourceVpcConfiguration`](crate::model::DataSourceVpcConfiguration)
    pub fn builder() -> crate::model::data_source_vpc_configuration::Builder {
        crate::model::data_source_vpc_configuration::Builder::default()
    }
}

/// <p>Specifies the attachment settings for the Confluence data source.
/// Attachment settings are optional, if you don't specify settings
/// attachments, Amazon Kendra won't index them.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceAttachmentConfiguration {
    /// <p>Indicates whether Amazon Kendra indexes attachments to the pages and blogs
    /// in the Confluence data source. </p>
    pub crawl_attachments: bool,
    /// <p>Defines how attachment metadata fields should be mapped to index
    /// fields. Before you can map a field, you must first create an index
    /// field with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>AttachentFieldMappings</code> parameter,
    /// you must specify at least one field mapping.</p>
    pub attachment_field_mappings:
        std::option::Option<std::vec::Vec<crate::model::ConfluenceAttachmentToIndexFieldMapping>>,
}
impl ConfluenceAttachmentConfiguration {
    /// <p>Indicates whether Amazon Kendra indexes attachments to the pages and blogs
    /// in the Confluence data source. </p>
    pub fn crawl_attachments(&self) -> bool {
        self.crawl_attachments
    }
    /// <p>Defines how attachment metadata fields should be mapped to index
    /// fields. Before you can map a field, you must first create an index
    /// field with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>AttachentFieldMappings</code> parameter,
    /// you must specify at least one field mapping.</p>
    pub fn attachment_field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfluenceAttachmentToIndexFieldMapping]> {
        self.attachment_field_mappings.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceAttachmentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceAttachmentConfiguration");
        formatter.field("crawl_attachments", &self.crawl_attachments);
        formatter.field("attachment_field_mappings", &self.attachment_field_mappings);
        formatter.finish()
    }
}
/// See [`ConfluenceAttachmentConfiguration`](crate::model::ConfluenceAttachmentConfiguration)
pub mod confluence_attachment_configuration {
    /// A builder for [`ConfluenceAttachmentConfiguration`](crate::model::ConfluenceAttachmentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawl_attachments: std::option::Option<bool>,
        pub(crate) attachment_field_mappings: std::option::Option<
            std::vec::Vec<crate::model::ConfluenceAttachmentToIndexFieldMapping>,
        >,
    }
    impl Builder {
        /// <p>Indicates whether Amazon Kendra indexes attachments to the pages and blogs
        /// in the Confluence data source. </p>
        pub fn crawl_attachments(mut self, input: bool) -> Self {
            self.crawl_attachments = Some(input);
            self
        }
        /// <p>Indicates whether Amazon Kendra indexes attachments to the pages and blogs
        /// in the Confluence data source. </p>
        pub fn set_crawl_attachments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_attachments = input;
            self
        }
        /// Appends an item to `attachment_field_mappings`.
        ///
        /// To override the contents of this collection use [`set_attachment_field_mappings`](Self::set_attachment_field_mappings).
        ///
        /// <p>Defines how attachment metadata fields should be mapped to index
        /// fields. Before you can map a field, you must first create an index
        /// field with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>AttachentFieldMappings</code> parameter,
        /// you must specify at least one field mapping.</p>
        pub fn attachment_field_mappings(
            mut self,
            input: impl Into<crate::model::ConfluenceAttachmentToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.attachment_field_mappings.unwrap_or_default();
            v.push(input.into());
            self.attachment_field_mappings = Some(v);
            self
        }
        /// <p>Defines how attachment metadata fields should be mapped to index
        /// fields. Before you can map a field, you must first create an index
        /// field with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>AttachentFieldMappings</code> parameter,
        /// you must specify at least one field mapping.</p>
        pub fn set_attachment_field_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ConfluenceAttachmentToIndexFieldMapping>,
            >,
        ) -> Self {
            self.attachment_field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceAttachmentConfiguration`](crate::model::ConfluenceAttachmentConfiguration)
        pub fn build(self) -> crate::model::ConfluenceAttachmentConfiguration {
            crate::model::ConfluenceAttachmentConfiguration {
                crawl_attachments: self.crawl_attachments.unwrap_or_default(),
                attachment_field_mappings: self.attachment_field_mappings,
            }
        }
    }
}
impl ConfluenceAttachmentConfiguration {
    /// Creates a new builder-style object to manufacture [`ConfluenceAttachmentConfiguration`](crate::model::ConfluenceAttachmentConfiguration)
    pub fn builder() -> crate::model::confluence_attachment_configuration::Builder {
        crate::model::confluence_attachment_configuration::Builder::default()
    }
}

/// <p>Defines the mapping between a field in the Confluence data source
/// to a Amazon Kendra index field.</p>
/// <p>You must first create the index field using the
/// <code>UpdateIndex</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceAttachmentToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    /// <p>You must first create the index field using the
    /// <code>UpdateIndex</code> operation. </p>
    pub data_source_field_name: std::option::Option<crate::model::ConfluenceAttachmentFieldName>,
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub date_field_format: std::option::Option<std::string::String>,
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub index_field_name: std::option::Option<std::string::String>,
}
impl ConfluenceAttachmentToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    /// <p>You must first create the index field using the
    /// <code>UpdateIndex</code> operation. </p>
    pub fn data_source_field_name(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceAttachmentFieldName> {
        self.data_source_field_name.as_ref()
    }
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub fn date_field_format(&self) -> std::option::Option<&str> {
        self.date_field_format.as_deref()
    }
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceAttachmentToIndexFieldMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceAttachmentToIndexFieldMapping");
        formatter.field("data_source_field_name", &self.data_source_field_name);
        formatter.field("date_field_format", &self.date_field_format);
        formatter.field("index_field_name", &self.index_field_name);
        formatter.finish()
    }
}
/// See [`ConfluenceAttachmentToIndexFieldMapping`](crate::model::ConfluenceAttachmentToIndexFieldMapping)
pub mod confluence_attachment_to_index_field_mapping {
    /// A builder for [`ConfluenceAttachmentToIndexFieldMapping`](crate::model::ConfluenceAttachmentToIndexFieldMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_field_name:
            std::option::Option<crate::model::ConfluenceAttachmentFieldName>,
        pub(crate) date_field_format: std::option::Option<std::string::String>,
        pub(crate) index_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field in the data source. </p>
        /// <p>You must first create the index field using the
        /// <code>UpdateIndex</code> operation. </p>
        pub fn data_source_field_name(
            mut self,
            input: crate::model::ConfluenceAttachmentFieldName,
        ) -> Self {
            self.data_source_field_name = Some(input);
            self
        }
        /// <p>The name of the field in the data source. </p>
        /// <p>You must first create the index field using the
        /// <code>UpdateIndex</code> operation. </p>
        pub fn set_data_source_field_name(
            mut self,
            input: std::option::Option<crate::model::ConfluenceAttachmentFieldName>,
        ) -> Self {
            self.data_source_field_name = input;
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn date_field_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_field_format = Some(input.into());
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn set_date_field_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_field_format = input;
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceAttachmentToIndexFieldMapping`](crate::model::ConfluenceAttachmentToIndexFieldMapping)
        pub fn build(self) -> crate::model::ConfluenceAttachmentToIndexFieldMapping {
            crate::model::ConfluenceAttachmentToIndexFieldMapping {
                data_source_field_name: self.data_source_field_name,
                date_field_format: self.date_field_format,
                index_field_name: self.index_field_name,
            }
        }
    }
}
impl ConfluenceAttachmentToIndexFieldMapping {
    /// Creates a new builder-style object to manufacture [`ConfluenceAttachmentToIndexFieldMapping`](crate::model::ConfluenceAttachmentToIndexFieldMapping)
    pub fn builder() -> crate::model::confluence_attachment_to_index_field_mapping::Builder {
        crate::model::confluence_attachment_to_index_field_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfluenceAttachmentFieldName {
    #[allow(missing_docs)] // documentation missing in model
    Author,
    #[allow(missing_docs)] // documentation missing in model
    ContentType,
    #[allow(missing_docs)] // documentation missing in model
    CreatedDate,
    #[allow(missing_docs)] // documentation missing in model
    DisplayUrl,
    #[allow(missing_docs)] // documentation missing in model
    FileSize,
    #[allow(missing_docs)] // documentation missing in model
    ItemType,
    #[allow(missing_docs)] // documentation missing in model
    ParentId,
    #[allow(missing_docs)] // documentation missing in model
    SpaceKey,
    #[allow(missing_docs)] // documentation missing in model
    SpaceName,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfluenceAttachmentFieldName {
    fn from(s: &str) -> Self {
        match s {
            "AUTHOR" => ConfluenceAttachmentFieldName::Author,
            "CONTENT_TYPE" => ConfluenceAttachmentFieldName::ContentType,
            "CREATED_DATE" => ConfluenceAttachmentFieldName::CreatedDate,
            "DISPLAY_URL" => ConfluenceAttachmentFieldName::DisplayUrl,
            "FILE_SIZE" => ConfluenceAttachmentFieldName::FileSize,
            "ITEM_TYPE" => ConfluenceAttachmentFieldName::ItemType,
            "PARENT_ID" => ConfluenceAttachmentFieldName::ParentId,
            "SPACE_KEY" => ConfluenceAttachmentFieldName::SpaceKey,
            "SPACE_NAME" => ConfluenceAttachmentFieldName::SpaceName,
            "URL" => ConfluenceAttachmentFieldName::Url,
            "VERSION" => ConfluenceAttachmentFieldName::Version,
            other => ConfluenceAttachmentFieldName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfluenceAttachmentFieldName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfluenceAttachmentFieldName::from(s))
    }
}
impl ConfluenceAttachmentFieldName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfluenceAttachmentFieldName::Author => "AUTHOR",
            ConfluenceAttachmentFieldName::ContentType => "CONTENT_TYPE",
            ConfluenceAttachmentFieldName::CreatedDate => "CREATED_DATE",
            ConfluenceAttachmentFieldName::DisplayUrl => "DISPLAY_URL",
            ConfluenceAttachmentFieldName::FileSize => "FILE_SIZE",
            ConfluenceAttachmentFieldName::ItemType => "ITEM_TYPE",
            ConfluenceAttachmentFieldName::ParentId => "PARENT_ID",
            ConfluenceAttachmentFieldName::SpaceKey => "SPACE_KEY",
            ConfluenceAttachmentFieldName::SpaceName => "SPACE_NAME",
            ConfluenceAttachmentFieldName::Url => "URL",
            ConfluenceAttachmentFieldName::Version => "VERSION",
            ConfluenceAttachmentFieldName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTHOR",
            "CONTENT_TYPE",
            "CREATED_DATE",
            "DISPLAY_URL",
            "FILE_SIZE",
            "ITEM_TYPE",
            "PARENT_ID",
            "SPACE_KEY",
            "SPACE_NAME",
            "URL",
            "VERSION",
        ]
    }
}
impl AsRef<str> for ConfluenceAttachmentFieldName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the blog settings for the Confluence data source. Blogs
/// are always indexed unless filtered from the index by the
/// <code>ExclusionPatterns</code> or <code>InclusionPatterns</code>
/// fields in the <code>ConfluenceConfiguration</code> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceBlogConfiguration {
    /// <p>Defines how blog metadata fields should be mapped to index fields.
    /// Before you can map a field, you must first create an index field
    /// with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>BlogFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub blog_field_mappings:
        std::option::Option<std::vec::Vec<crate::model::ConfluenceBlogToIndexFieldMapping>>,
}
impl ConfluenceBlogConfiguration {
    /// <p>Defines how blog metadata fields should be mapped to index fields.
    /// Before you can map a field, you must first create an index field
    /// with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>BlogFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub fn blog_field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfluenceBlogToIndexFieldMapping]> {
        self.blog_field_mappings.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceBlogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceBlogConfiguration");
        formatter.field("blog_field_mappings", &self.blog_field_mappings);
        formatter.finish()
    }
}
/// See [`ConfluenceBlogConfiguration`](crate::model::ConfluenceBlogConfiguration)
pub mod confluence_blog_configuration {
    /// A builder for [`ConfluenceBlogConfiguration`](crate::model::ConfluenceBlogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blog_field_mappings:
            std::option::Option<std::vec::Vec<crate::model::ConfluenceBlogToIndexFieldMapping>>,
    }
    impl Builder {
        /// Appends an item to `blog_field_mappings`.
        ///
        /// To override the contents of this collection use [`set_blog_field_mappings`](Self::set_blog_field_mappings).
        ///
        /// <p>Defines how blog metadata fields should be mapped to index fields.
        /// Before you can map a field, you must first create an index field
        /// with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>BlogFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn blog_field_mappings(
            mut self,
            input: impl Into<crate::model::ConfluenceBlogToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.blog_field_mappings.unwrap_or_default();
            v.push(input.into());
            self.blog_field_mappings = Some(v);
            self
        }
        /// <p>Defines how blog metadata fields should be mapped to index fields.
        /// Before you can map a field, you must first create an index field
        /// with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>BlogFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn set_blog_field_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ConfluenceBlogToIndexFieldMapping>,
            >,
        ) -> Self {
            self.blog_field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceBlogConfiguration`](crate::model::ConfluenceBlogConfiguration)
        pub fn build(self) -> crate::model::ConfluenceBlogConfiguration {
            crate::model::ConfluenceBlogConfiguration {
                blog_field_mappings: self.blog_field_mappings,
            }
        }
    }
}
impl ConfluenceBlogConfiguration {
    /// Creates a new builder-style object to manufacture [`ConfluenceBlogConfiguration`](crate::model::ConfluenceBlogConfiguration)
    pub fn builder() -> crate::model::confluence_blog_configuration::Builder {
        crate::model::confluence_blog_configuration::Builder::default()
    }
}

/// <p>Defines the mapping between a blog field in the Confluence data
/// source to a Amazon Kendra index field.</p>
/// <p>You must first create the index field using the
/// <code>UpdateIndex</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceBlogToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub data_source_field_name: std::option::Option<crate::model::ConfluenceBlogFieldName>,
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub date_field_format: std::option::Option<std::string::String>,
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub index_field_name: std::option::Option<std::string::String>,
}
impl ConfluenceBlogToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub fn data_source_field_name(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceBlogFieldName> {
        self.data_source_field_name.as_ref()
    }
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub fn date_field_format(&self) -> std::option::Option<&str> {
        self.date_field_format.as_deref()
    }
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceBlogToIndexFieldMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceBlogToIndexFieldMapping");
        formatter.field("data_source_field_name", &self.data_source_field_name);
        formatter.field("date_field_format", &self.date_field_format);
        formatter.field("index_field_name", &self.index_field_name);
        formatter.finish()
    }
}
/// See [`ConfluenceBlogToIndexFieldMapping`](crate::model::ConfluenceBlogToIndexFieldMapping)
pub mod confluence_blog_to_index_field_mapping {
    /// A builder for [`ConfluenceBlogToIndexFieldMapping`](crate::model::ConfluenceBlogToIndexFieldMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_field_name:
            std::option::Option<crate::model::ConfluenceBlogFieldName>,
        pub(crate) date_field_format: std::option::Option<std::string::String>,
        pub(crate) index_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field in the data source. </p>
        pub fn data_source_field_name(
            mut self,
            input: crate::model::ConfluenceBlogFieldName,
        ) -> Self {
            self.data_source_field_name = Some(input);
            self
        }
        /// <p>The name of the field in the data source. </p>
        pub fn set_data_source_field_name(
            mut self,
            input: std::option::Option<crate::model::ConfluenceBlogFieldName>,
        ) -> Self {
            self.data_source_field_name = input;
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn date_field_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_field_format = Some(input.into());
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn set_date_field_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_field_format = input;
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceBlogToIndexFieldMapping`](crate::model::ConfluenceBlogToIndexFieldMapping)
        pub fn build(self) -> crate::model::ConfluenceBlogToIndexFieldMapping {
            crate::model::ConfluenceBlogToIndexFieldMapping {
                data_source_field_name: self.data_source_field_name,
                date_field_format: self.date_field_format,
                index_field_name: self.index_field_name,
            }
        }
    }
}
impl ConfluenceBlogToIndexFieldMapping {
    /// Creates a new builder-style object to manufacture [`ConfluenceBlogToIndexFieldMapping`](crate::model::ConfluenceBlogToIndexFieldMapping)
    pub fn builder() -> crate::model::confluence_blog_to_index_field_mapping::Builder {
        crate::model::confluence_blog_to_index_field_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfluenceBlogFieldName {
    #[allow(missing_docs)] // documentation missing in model
    Author,
    #[allow(missing_docs)] // documentation missing in model
    DisplayUrl,
    #[allow(missing_docs)] // documentation missing in model
    ItemType,
    #[allow(missing_docs)] // documentation missing in model
    Labels,
    #[allow(missing_docs)] // documentation missing in model
    PublishDate,
    #[allow(missing_docs)] // documentation missing in model
    SpaceKey,
    #[allow(missing_docs)] // documentation missing in model
    SpaceName,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfluenceBlogFieldName {
    fn from(s: &str) -> Self {
        match s {
            "AUTHOR" => ConfluenceBlogFieldName::Author,
            "DISPLAY_URL" => ConfluenceBlogFieldName::DisplayUrl,
            "ITEM_TYPE" => ConfluenceBlogFieldName::ItemType,
            "LABELS" => ConfluenceBlogFieldName::Labels,
            "PUBLISH_DATE" => ConfluenceBlogFieldName::PublishDate,
            "SPACE_KEY" => ConfluenceBlogFieldName::SpaceKey,
            "SPACE_NAME" => ConfluenceBlogFieldName::SpaceName,
            "URL" => ConfluenceBlogFieldName::Url,
            "VERSION" => ConfluenceBlogFieldName::Version,
            other => ConfluenceBlogFieldName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfluenceBlogFieldName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfluenceBlogFieldName::from(s))
    }
}
impl ConfluenceBlogFieldName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfluenceBlogFieldName::Author => "AUTHOR",
            ConfluenceBlogFieldName::DisplayUrl => "DISPLAY_URL",
            ConfluenceBlogFieldName::ItemType => "ITEM_TYPE",
            ConfluenceBlogFieldName::Labels => "LABELS",
            ConfluenceBlogFieldName::PublishDate => "PUBLISH_DATE",
            ConfluenceBlogFieldName::SpaceKey => "SPACE_KEY",
            ConfluenceBlogFieldName::SpaceName => "SPACE_NAME",
            ConfluenceBlogFieldName::Url => "URL",
            ConfluenceBlogFieldName::Version => "VERSION",
            ConfluenceBlogFieldName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTHOR",
            "DISPLAY_URL",
            "ITEM_TYPE",
            "LABELS",
            "PUBLISH_DATE",
            "SPACE_KEY",
            "SPACE_NAME",
            "URL",
            "VERSION",
        ]
    }
}
impl AsRef<str> for ConfluenceBlogFieldName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the page settings for the Confluence data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluencePageConfiguration {
    /// <p>Defines how page metadata fields should be mapped to index fields.
    /// Before you can map a field, you must first create an index field
    /// with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>PageFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub page_field_mappings:
        std::option::Option<std::vec::Vec<crate::model::ConfluencePageToIndexFieldMapping>>,
}
impl ConfluencePageConfiguration {
    /// <p>Defines how page metadata fields should be mapped to index fields.
    /// Before you can map a field, you must first create an index field
    /// with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>PageFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub fn page_field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfluencePageToIndexFieldMapping]> {
        self.page_field_mappings.as_deref()
    }
}
impl std::fmt::Debug for ConfluencePageConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluencePageConfiguration");
        formatter.field("page_field_mappings", &self.page_field_mappings);
        formatter.finish()
    }
}
/// See [`ConfluencePageConfiguration`](crate::model::ConfluencePageConfiguration)
pub mod confluence_page_configuration {
    /// A builder for [`ConfluencePageConfiguration`](crate::model::ConfluencePageConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_field_mappings:
            std::option::Option<std::vec::Vec<crate::model::ConfluencePageToIndexFieldMapping>>,
    }
    impl Builder {
        /// Appends an item to `page_field_mappings`.
        ///
        /// To override the contents of this collection use [`set_page_field_mappings`](Self::set_page_field_mappings).
        ///
        /// <p>Defines how page metadata fields should be mapped to index fields.
        /// Before you can map a field, you must first create an index field
        /// with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>PageFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn page_field_mappings(
            mut self,
            input: impl Into<crate::model::ConfluencePageToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.page_field_mappings.unwrap_or_default();
            v.push(input.into());
            self.page_field_mappings = Some(v);
            self
        }
        /// <p>Defines how page metadata fields should be mapped to index fields.
        /// Before you can map a field, you must first create an index field
        /// with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>PageFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn set_page_field_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ConfluencePageToIndexFieldMapping>,
            >,
        ) -> Self {
            self.page_field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluencePageConfiguration`](crate::model::ConfluencePageConfiguration)
        pub fn build(self) -> crate::model::ConfluencePageConfiguration {
            crate::model::ConfluencePageConfiguration {
                page_field_mappings: self.page_field_mappings,
            }
        }
    }
}
impl ConfluencePageConfiguration {
    /// Creates a new builder-style object to manufacture [`ConfluencePageConfiguration`](crate::model::ConfluencePageConfiguration)
    pub fn builder() -> crate::model::confluence_page_configuration::Builder {
        crate::model::confluence_page_configuration::Builder::default()
    }
}

/// <p>Defines the mapping between a field in the Confluence data source
/// to a Amazon Kendra index field.</p>
/// <p>You must first create the index field using the
/// <code>UpdateIndex</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluencePageToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub data_source_field_name: std::option::Option<crate::model::ConfluencePageFieldName>,
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub date_field_format: std::option::Option<std::string::String>,
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub index_field_name: std::option::Option<std::string::String>,
}
impl ConfluencePageToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub fn data_source_field_name(
        &self,
    ) -> std::option::Option<&crate::model::ConfluencePageFieldName> {
        self.data_source_field_name.as_ref()
    }
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub fn date_field_format(&self) -> std::option::Option<&str> {
        self.date_field_format.as_deref()
    }
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
}
impl std::fmt::Debug for ConfluencePageToIndexFieldMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluencePageToIndexFieldMapping");
        formatter.field("data_source_field_name", &self.data_source_field_name);
        formatter.field("date_field_format", &self.date_field_format);
        formatter.field("index_field_name", &self.index_field_name);
        formatter.finish()
    }
}
/// See [`ConfluencePageToIndexFieldMapping`](crate::model::ConfluencePageToIndexFieldMapping)
pub mod confluence_page_to_index_field_mapping {
    /// A builder for [`ConfluencePageToIndexFieldMapping`](crate::model::ConfluencePageToIndexFieldMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_field_name:
            std::option::Option<crate::model::ConfluencePageFieldName>,
        pub(crate) date_field_format: std::option::Option<std::string::String>,
        pub(crate) index_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field in the data source. </p>
        pub fn data_source_field_name(
            mut self,
            input: crate::model::ConfluencePageFieldName,
        ) -> Self {
            self.data_source_field_name = Some(input);
            self
        }
        /// <p>The name of the field in the data source. </p>
        pub fn set_data_source_field_name(
            mut self,
            input: std::option::Option<crate::model::ConfluencePageFieldName>,
        ) -> Self {
            self.data_source_field_name = input;
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn date_field_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_field_format = Some(input.into());
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn set_date_field_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_field_format = input;
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluencePageToIndexFieldMapping`](crate::model::ConfluencePageToIndexFieldMapping)
        pub fn build(self) -> crate::model::ConfluencePageToIndexFieldMapping {
            crate::model::ConfluencePageToIndexFieldMapping {
                data_source_field_name: self.data_source_field_name,
                date_field_format: self.date_field_format,
                index_field_name: self.index_field_name,
            }
        }
    }
}
impl ConfluencePageToIndexFieldMapping {
    /// Creates a new builder-style object to manufacture [`ConfluencePageToIndexFieldMapping`](crate::model::ConfluencePageToIndexFieldMapping)
    pub fn builder() -> crate::model::confluence_page_to_index_field_mapping::Builder {
        crate::model::confluence_page_to_index_field_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfluencePageFieldName {
    #[allow(missing_docs)] // documentation missing in model
    Author,
    #[allow(missing_docs)] // documentation missing in model
    ContentStatus,
    #[allow(missing_docs)] // documentation missing in model
    CreatedDate,
    #[allow(missing_docs)] // documentation missing in model
    DisplayUrl,
    #[allow(missing_docs)] // documentation missing in model
    ItemType,
    #[allow(missing_docs)] // documentation missing in model
    Labels,
    #[allow(missing_docs)] // documentation missing in model
    ModifiedDate,
    #[allow(missing_docs)] // documentation missing in model
    ParentId,
    #[allow(missing_docs)] // documentation missing in model
    SpaceKey,
    #[allow(missing_docs)] // documentation missing in model
    SpaceName,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfluencePageFieldName {
    fn from(s: &str) -> Self {
        match s {
            "AUTHOR" => ConfluencePageFieldName::Author,
            "CONTENT_STATUS" => ConfluencePageFieldName::ContentStatus,
            "CREATED_DATE" => ConfluencePageFieldName::CreatedDate,
            "DISPLAY_URL" => ConfluencePageFieldName::DisplayUrl,
            "ITEM_TYPE" => ConfluencePageFieldName::ItemType,
            "LABELS" => ConfluencePageFieldName::Labels,
            "MODIFIED_DATE" => ConfluencePageFieldName::ModifiedDate,
            "PARENT_ID" => ConfluencePageFieldName::ParentId,
            "SPACE_KEY" => ConfluencePageFieldName::SpaceKey,
            "SPACE_NAME" => ConfluencePageFieldName::SpaceName,
            "URL" => ConfluencePageFieldName::Url,
            "VERSION" => ConfluencePageFieldName::Version,
            other => ConfluencePageFieldName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfluencePageFieldName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfluencePageFieldName::from(s))
    }
}
impl ConfluencePageFieldName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfluencePageFieldName::Author => "AUTHOR",
            ConfluencePageFieldName::ContentStatus => "CONTENT_STATUS",
            ConfluencePageFieldName::CreatedDate => "CREATED_DATE",
            ConfluencePageFieldName::DisplayUrl => "DISPLAY_URL",
            ConfluencePageFieldName::ItemType => "ITEM_TYPE",
            ConfluencePageFieldName::Labels => "LABELS",
            ConfluencePageFieldName::ModifiedDate => "MODIFIED_DATE",
            ConfluencePageFieldName::ParentId => "PARENT_ID",
            ConfluencePageFieldName::SpaceKey => "SPACE_KEY",
            ConfluencePageFieldName::SpaceName => "SPACE_NAME",
            ConfluencePageFieldName::Url => "URL",
            ConfluencePageFieldName::Version => "VERSION",
            ConfluencePageFieldName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTHOR",
            "CONTENT_STATUS",
            "CREATED_DATE",
            "DISPLAY_URL",
            "ITEM_TYPE",
            "LABELS",
            "MODIFIED_DATE",
            "PARENT_ID",
            "SPACE_KEY",
            "SPACE_NAME",
            "URL",
            "VERSION",
        ]
    }
}
impl AsRef<str> for ConfluencePageFieldName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the configuration for indexing Confluence spaces.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceSpaceConfiguration {
    /// <p>Specifies whether Amazon Kendra should index personal spaces. Users can
    /// add restrictions to items in personal spaces. If personal spaces are
    /// indexed, queries without user context information may return
    /// restricted items from a personal space in their results. For more
    /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on
    /// user context</a>.</p>
    pub crawl_personal_spaces: bool,
    /// <p>Specifies whether Amazon Kendra should index archived spaces.</p>
    pub crawl_archived_spaces: bool,
    /// <p>A list of space keys for Confluence spaces. If you include a key,
    /// the blogs, documents, and attachments in the space are indexed.
    /// Spaces that aren't in the list aren't indexed. A space in the list
    /// must exist. Otherwise, Amazon Kendra logs an error when the data source is
    /// synchronized. If a space is in both the <code>IncludeSpaces</code>
    /// and the <code>ExcludeSpaces</code> list, the space is
    /// excluded.</p>
    pub include_spaces: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of space keys of Confluence spaces. If you include a key,
    /// the blogs, documents, and attachments in the space are not indexed.
    /// If a space is in both the <code>ExcludeSpaces</code> and the
    /// <code>IncludeSpaces</code> list, the space is excluded.</p>
    pub exclude_spaces: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Defines how space metadata fields should be mapped to index
    /// fields. Before you can map a field, you must first create an index
    /// field with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>SpaceFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub space_field_mappings:
        std::option::Option<std::vec::Vec<crate::model::ConfluenceSpaceToIndexFieldMapping>>,
}
impl ConfluenceSpaceConfiguration {
    /// <p>Specifies whether Amazon Kendra should index personal spaces. Users can
    /// add restrictions to items in personal spaces. If personal spaces are
    /// indexed, queries without user context information may return
    /// restricted items from a personal space in their results. For more
    /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on
    /// user context</a>.</p>
    pub fn crawl_personal_spaces(&self) -> bool {
        self.crawl_personal_spaces
    }
    /// <p>Specifies whether Amazon Kendra should index archived spaces.</p>
    pub fn crawl_archived_spaces(&self) -> bool {
        self.crawl_archived_spaces
    }
    /// <p>A list of space keys for Confluence spaces. If you include a key,
    /// the blogs, documents, and attachments in the space are indexed.
    /// Spaces that aren't in the list aren't indexed. A space in the list
    /// must exist. Otherwise, Amazon Kendra logs an error when the data source is
    /// synchronized. If a space is in both the <code>IncludeSpaces</code>
    /// and the <code>ExcludeSpaces</code> list, the space is
    /// excluded.</p>
    pub fn include_spaces(&self) -> std::option::Option<&[std::string::String]> {
        self.include_spaces.as_deref()
    }
    /// <p>A list of space keys of Confluence spaces. If you include a key,
    /// the blogs, documents, and attachments in the space are not indexed.
    /// If a space is in both the <code>ExcludeSpaces</code> and the
    /// <code>IncludeSpaces</code> list, the space is excluded.</p>
    pub fn exclude_spaces(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_spaces.as_deref()
    }
    /// <p>Defines how space metadata fields should be mapped to index
    /// fields. Before you can map a field, you must first create an index
    /// field with a matching type using the console or the
    /// <code>UpdateIndex</code> operation.</p>
    /// <p>If you specify the <code>SpaceFieldMappings</code> parameter, you
    /// must specify at least one field mapping.</p>
    pub fn space_field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::ConfluenceSpaceToIndexFieldMapping]> {
        self.space_field_mappings.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceSpaceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceSpaceConfiguration");
        formatter.field("crawl_personal_spaces", &self.crawl_personal_spaces);
        formatter.field("crawl_archived_spaces", &self.crawl_archived_spaces);
        formatter.field("include_spaces", &self.include_spaces);
        formatter.field("exclude_spaces", &self.exclude_spaces);
        formatter.field("space_field_mappings", &self.space_field_mappings);
        formatter.finish()
    }
}
/// See [`ConfluenceSpaceConfiguration`](crate::model::ConfluenceSpaceConfiguration)
pub mod confluence_space_configuration {
    /// A builder for [`ConfluenceSpaceConfiguration`](crate::model::ConfluenceSpaceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawl_personal_spaces: std::option::Option<bool>,
        pub(crate) crawl_archived_spaces: std::option::Option<bool>,
        pub(crate) include_spaces: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_spaces: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) space_field_mappings:
            std::option::Option<std::vec::Vec<crate::model::ConfluenceSpaceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon Kendra should index personal spaces. Users can
        /// add restrictions to items in personal spaces. If personal spaces are
        /// indexed, queries without user context information may return
        /// restricted items from a personal space in their results. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on
        /// user context</a>.</p>
        pub fn crawl_personal_spaces(mut self, input: bool) -> Self {
            self.crawl_personal_spaces = Some(input);
            self
        }
        /// <p>Specifies whether Amazon Kendra should index personal spaces. Users can
        /// add restrictions to items in personal spaces. If personal spaces are
        /// indexed, queries without user context information may return
        /// restricted items from a personal space in their results. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on
        /// user context</a>.</p>
        pub fn set_crawl_personal_spaces(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_personal_spaces = input;
            self
        }
        /// <p>Specifies whether Amazon Kendra should index archived spaces.</p>
        pub fn crawl_archived_spaces(mut self, input: bool) -> Self {
            self.crawl_archived_spaces = Some(input);
            self
        }
        /// <p>Specifies whether Amazon Kendra should index archived spaces.</p>
        pub fn set_crawl_archived_spaces(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_archived_spaces = input;
            self
        }
        /// Appends an item to `include_spaces`.
        ///
        /// To override the contents of this collection use [`set_include_spaces`](Self::set_include_spaces).
        ///
        /// <p>A list of space keys for Confluence spaces. If you include a key,
        /// the blogs, documents, and attachments in the space are indexed.
        /// Spaces that aren't in the list aren't indexed. A space in the list
        /// must exist. Otherwise, Amazon Kendra logs an error when the data source is
        /// synchronized. If a space is in both the <code>IncludeSpaces</code>
        /// and the <code>ExcludeSpaces</code> list, the space is
        /// excluded.</p>
        pub fn include_spaces(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.include_spaces.unwrap_or_default();
            v.push(input.into());
            self.include_spaces = Some(v);
            self
        }
        /// <p>A list of space keys for Confluence spaces. If you include a key,
        /// the blogs, documents, and attachments in the space are indexed.
        /// Spaces that aren't in the list aren't indexed. A space in the list
        /// must exist. Otherwise, Amazon Kendra logs an error when the data source is
        /// synchronized. If a space is in both the <code>IncludeSpaces</code>
        /// and the <code>ExcludeSpaces</code> list, the space is
        /// excluded.</p>
        pub fn set_include_spaces(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.include_spaces = input;
            self
        }
        /// Appends an item to `exclude_spaces`.
        ///
        /// To override the contents of this collection use [`set_exclude_spaces`](Self::set_exclude_spaces).
        ///
        /// <p>A list of space keys of Confluence spaces. If you include a key,
        /// the blogs, documents, and attachments in the space are not indexed.
        /// If a space is in both the <code>ExcludeSpaces</code> and the
        /// <code>IncludeSpaces</code> list, the space is excluded.</p>
        pub fn exclude_spaces(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclude_spaces.unwrap_or_default();
            v.push(input.into());
            self.exclude_spaces = Some(v);
            self
        }
        /// <p>A list of space keys of Confluence spaces. If you include a key,
        /// the blogs, documents, and attachments in the space are not indexed.
        /// If a space is in both the <code>ExcludeSpaces</code> and the
        /// <code>IncludeSpaces</code> list, the space is excluded.</p>
        pub fn set_exclude_spaces(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_spaces = input;
            self
        }
        /// Appends an item to `space_field_mappings`.
        ///
        /// To override the contents of this collection use [`set_space_field_mappings`](Self::set_space_field_mappings).
        ///
        /// <p>Defines how space metadata fields should be mapped to index
        /// fields. Before you can map a field, you must first create an index
        /// field with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>SpaceFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn space_field_mappings(
            mut self,
            input: impl Into<crate::model::ConfluenceSpaceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.space_field_mappings.unwrap_or_default();
            v.push(input.into());
            self.space_field_mappings = Some(v);
            self
        }
        /// <p>Defines how space metadata fields should be mapped to index
        /// fields. Before you can map a field, you must first create an index
        /// field with a matching type using the console or the
        /// <code>UpdateIndex</code> operation.</p>
        /// <p>If you specify the <code>SpaceFieldMappings</code> parameter, you
        /// must specify at least one field mapping.</p>
        pub fn set_space_field_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ConfluenceSpaceToIndexFieldMapping>,
            >,
        ) -> Self {
            self.space_field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceSpaceConfiguration`](crate::model::ConfluenceSpaceConfiguration)
        pub fn build(self) -> crate::model::ConfluenceSpaceConfiguration {
            crate::model::ConfluenceSpaceConfiguration {
                crawl_personal_spaces: self.crawl_personal_spaces.unwrap_or_default(),
                crawl_archived_spaces: self.crawl_archived_spaces.unwrap_or_default(),
                include_spaces: self.include_spaces,
                exclude_spaces: self.exclude_spaces,
                space_field_mappings: self.space_field_mappings,
            }
        }
    }
}
impl ConfluenceSpaceConfiguration {
    /// Creates a new builder-style object to manufacture [`ConfluenceSpaceConfiguration`](crate::model::ConfluenceSpaceConfiguration)
    pub fn builder() -> crate::model::confluence_space_configuration::Builder {
        crate::model::confluence_space_configuration::Builder::default()
    }
}

/// <p>Defines the mapping between a field in the Confluence data source
/// to a Amazon Kendra index field.</p>
/// <p>You must first create the index field using the
/// <code>UpdateIndex</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfluenceSpaceToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub data_source_field_name: std::option::Option<crate::model::ConfluenceSpaceFieldName>,
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub date_field_format: std::option::Option<std::string::String>,
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub index_field_name: std::option::Option<std::string::String>,
}
impl ConfluenceSpaceToIndexFieldMapping {
    /// <p>The name of the field in the data source. </p>
    pub fn data_source_field_name(
        &self,
    ) -> std::option::Option<&crate::model::ConfluenceSpaceFieldName> {
        self.data_source_field_name.as_ref()
    }
    /// <p>The format for date fields in the data source. If the field
    /// specified in <code>DataSourceFieldName</code> is a date field you
    /// must specify the date format. If the field is not a date field, an
    /// exception is thrown.</p>
    pub fn date_field_format(&self) -> std::option::Option<&str> {
        self.date_field_format.as_deref()
    }
    /// <p>The name of the index field to map to the Confluence data source
    /// field. The index field type must match the Confluence field
    /// type.</p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
}
impl std::fmt::Debug for ConfluenceSpaceToIndexFieldMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfluenceSpaceToIndexFieldMapping");
        formatter.field("data_source_field_name", &self.data_source_field_name);
        formatter.field("date_field_format", &self.date_field_format);
        formatter.field("index_field_name", &self.index_field_name);
        formatter.finish()
    }
}
/// See [`ConfluenceSpaceToIndexFieldMapping`](crate::model::ConfluenceSpaceToIndexFieldMapping)
pub mod confluence_space_to_index_field_mapping {
    /// A builder for [`ConfluenceSpaceToIndexFieldMapping`](crate::model::ConfluenceSpaceToIndexFieldMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_field_name:
            std::option::Option<crate::model::ConfluenceSpaceFieldName>,
        pub(crate) date_field_format: std::option::Option<std::string::String>,
        pub(crate) index_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field in the data source. </p>
        pub fn data_source_field_name(
            mut self,
            input: crate::model::ConfluenceSpaceFieldName,
        ) -> Self {
            self.data_source_field_name = Some(input);
            self
        }
        /// <p>The name of the field in the data source. </p>
        pub fn set_data_source_field_name(
            mut self,
            input: std::option::Option<crate::model::ConfluenceSpaceFieldName>,
        ) -> Self {
            self.data_source_field_name = input;
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn date_field_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_field_format = Some(input.into());
            self
        }
        /// <p>The format for date fields in the data source. If the field
        /// specified in <code>DataSourceFieldName</code> is a date field you
        /// must specify the date format. If the field is not a date field, an
        /// exception is thrown.</p>
        pub fn set_date_field_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_field_format = input;
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>The name of the index field to map to the Confluence data source
        /// field. The index field type must match the Confluence field
        /// type.</p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfluenceSpaceToIndexFieldMapping`](crate::model::ConfluenceSpaceToIndexFieldMapping)
        pub fn build(self) -> crate::model::ConfluenceSpaceToIndexFieldMapping {
            crate::model::ConfluenceSpaceToIndexFieldMapping {
                data_source_field_name: self.data_source_field_name,
                date_field_format: self.date_field_format,
                index_field_name: self.index_field_name,
            }
        }
    }
}
impl ConfluenceSpaceToIndexFieldMapping {
    /// Creates a new builder-style object to manufacture [`ConfluenceSpaceToIndexFieldMapping`](crate::model::ConfluenceSpaceToIndexFieldMapping)
    pub fn builder() -> crate::model::confluence_space_to_index_field_mapping::Builder {
        crate::model::confluence_space_to_index_field_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfluenceSpaceFieldName {
    #[allow(missing_docs)] // documentation missing in model
    DisplayUrl,
    #[allow(missing_docs)] // documentation missing in model
    ItemType,
    #[allow(missing_docs)] // documentation missing in model
    SpaceKey,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfluenceSpaceFieldName {
    fn from(s: &str) -> Self {
        match s {
            "DISPLAY_URL" => ConfluenceSpaceFieldName::DisplayUrl,
            "ITEM_TYPE" => ConfluenceSpaceFieldName::ItemType,
            "SPACE_KEY" => ConfluenceSpaceFieldName::SpaceKey,
            "URL" => ConfluenceSpaceFieldName::Url,
            other => ConfluenceSpaceFieldName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfluenceSpaceFieldName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfluenceSpaceFieldName::from(s))
    }
}
impl ConfluenceSpaceFieldName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfluenceSpaceFieldName::DisplayUrl => "DISPLAY_URL",
            ConfluenceSpaceFieldName::ItemType => "ITEM_TYPE",
            ConfluenceSpaceFieldName::SpaceKey => "SPACE_KEY",
            ConfluenceSpaceFieldName::Url => "URL",
            ConfluenceSpaceFieldName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISPLAY_URL", "ITEM_TYPE", "SPACE_KEY", "URL"]
    }
}
impl AsRef<str> for ConfluenceSpaceFieldName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfluenceVersion {
    #[allow(missing_docs)] // documentation missing in model
    Cloud,
    #[allow(missing_docs)] // documentation missing in model
    Server,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfluenceVersion {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD" => ConfluenceVersion::Cloud,
            "SERVER" => ConfluenceVersion::Server,
            other => ConfluenceVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfluenceVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfluenceVersion::from(s))
    }
}
impl ConfluenceVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfluenceVersion::Cloud => "CLOUD",
            ConfluenceVersion::Server => "SERVER",
            ConfluenceVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD", "SERVER"]
    }
}
impl AsRef<str> for ConfluenceVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information required to connect to a
/// ServiceNow data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowConfiguration {
    /// <p>The ServiceNow instance that the data source connects to. The host
    /// endpoint should look like the following:
    /// <code>{instance}.service-now.com.</code>
    /// </p>
    pub host_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Secrets Manager secret
    /// that contains the user name and password required to connect to the
    /// ServiceNow instance.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the release that the ServiceNow host is running.
    /// If the host is not running the <code>LONDON</code> release, use
    /// <code>OTHERS</code>.</p>
    pub service_now_build_version: std::option::Option<crate::model::ServiceNowBuildVersionType>,
    /// <p>Provides configuration information for crawling knowledge articles
    /// in the ServiceNow site.</p>
    pub knowledge_article_configuration:
        std::option::Option<crate::model::ServiceNowKnowledgeArticleConfiguration>,
    /// <p>Provides configuration information for crawling service catalogs
    /// in the ServiceNow site.</p>
    pub service_catalog_configuration:
        std::option::Option<crate::model::ServiceNowServiceCatalogConfiguration>,
    /// <p>Determines the type of authentication used to connect to the
    /// ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is
    /// authenticated using the user name and password provided in the AWS
    /// Secrets Manager secret in the <code>SecretArn</code> field. When you
    /// choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the OAuth
    /// token and secret provided in the Secrets Manager secret, and the
    /// user name and password are used to determine which information Amazon Kendra
    /// has access to.</p>
    /// <p>When you use <code>OAUTH2</code> authentication, you must generate
    /// a token and a client secret using the ServiceNow console. For more
    /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
    /// ServiceNow data source</a>.</p>
    pub authentication_type: std::option::Option<crate::model::ServiceNowAuthenticationType>,
}
impl ServiceNowConfiguration {
    /// <p>The ServiceNow instance that the data source connects to. The host
    /// endpoint should look like the following:
    /// <code>{instance}.service-now.com.</code>
    /// </p>
    pub fn host_url(&self) -> std::option::Option<&str> {
        self.host_url.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Secrets Manager secret
    /// that contains the user name and password required to connect to the
    /// ServiceNow instance.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The identifier of the release that the ServiceNow host is running.
    /// If the host is not running the <code>LONDON</code> release, use
    /// <code>OTHERS</code>.</p>
    pub fn service_now_build_version(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowBuildVersionType> {
        self.service_now_build_version.as_ref()
    }
    /// <p>Provides configuration information for crawling knowledge articles
    /// in the ServiceNow site.</p>
    pub fn knowledge_article_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowKnowledgeArticleConfiguration> {
        self.knowledge_article_configuration.as_ref()
    }
    /// <p>Provides configuration information for crawling service catalogs
    /// in the ServiceNow site.</p>
    pub fn service_catalog_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowServiceCatalogConfiguration> {
        self.service_catalog_configuration.as_ref()
    }
    /// <p>Determines the type of authentication used to connect to the
    /// ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is
    /// authenticated using the user name and password provided in the AWS
    /// Secrets Manager secret in the <code>SecretArn</code> field. When you
    /// choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the OAuth
    /// token and secret provided in the Secrets Manager secret, and the
    /// user name and password are used to determine which information Amazon Kendra
    /// has access to.</p>
    /// <p>When you use <code>OAUTH2</code> authentication, you must generate
    /// a token and a client secret using the ServiceNow console. For more
    /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
    /// ServiceNow data source</a>.</p>
    pub fn authentication_type(
        &self,
    ) -> std::option::Option<&crate::model::ServiceNowAuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for ServiceNowConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowConfiguration");
        formatter.field("host_url", &self.host_url);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("service_now_build_version", &self.service_now_build_version);
        formatter.field(
            "knowledge_article_configuration",
            &self.knowledge_article_configuration,
        );
        formatter.field(
            "service_catalog_configuration",
            &self.service_catalog_configuration,
        );
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}
/// See [`ServiceNowConfiguration`](crate::model::ServiceNowConfiguration)
pub mod service_now_configuration {
    /// A builder for [`ServiceNowConfiguration`](crate::model::ServiceNowConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_url: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) service_now_build_version:
            std::option::Option<crate::model::ServiceNowBuildVersionType>,
        pub(crate) knowledge_article_configuration:
            std::option::Option<crate::model::ServiceNowKnowledgeArticleConfiguration>,
        pub(crate) service_catalog_configuration:
            std::option::Option<crate::model::ServiceNowServiceCatalogConfiguration>,
        pub(crate) authentication_type:
            std::option::Option<crate::model::ServiceNowAuthenticationType>,
    }
    impl Builder {
        /// <p>The ServiceNow instance that the data source connects to. The host
        /// endpoint should look like the following:
        /// <code>{instance}.service-now.com.</code>
        /// </p>
        pub fn host_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_url = Some(input.into());
            self
        }
        /// <p>The ServiceNow instance that the data source connects to. The host
        /// endpoint should look like the following:
        /// <code>{instance}.service-now.com.</code>
        /// </p>
        pub fn set_host_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_url = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Secrets Manager secret
        /// that contains the user name and password required to connect to the
        /// ServiceNow instance.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Secrets Manager secret
        /// that contains the user name and password required to connect to the
        /// ServiceNow instance.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The identifier of the release that the ServiceNow host is running.
        /// If the host is not running the <code>LONDON</code> release, use
        /// <code>OTHERS</code>.</p>
        pub fn service_now_build_version(
            mut self,
            input: crate::model::ServiceNowBuildVersionType,
        ) -> Self {
            self.service_now_build_version = Some(input);
            self
        }
        /// <p>The identifier of the release that the ServiceNow host is running.
        /// If the host is not running the <code>LONDON</code> release, use
        /// <code>OTHERS</code>.</p>
        pub fn set_service_now_build_version(
            mut self,
            input: std::option::Option<crate::model::ServiceNowBuildVersionType>,
        ) -> Self {
            self.service_now_build_version = input;
            self
        }
        /// <p>Provides configuration information for crawling knowledge articles
        /// in the ServiceNow site.</p>
        pub fn knowledge_article_configuration(
            mut self,
            input: crate::model::ServiceNowKnowledgeArticleConfiguration,
        ) -> Self {
            self.knowledge_article_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for crawling knowledge articles
        /// in the ServiceNow site.</p>
        pub fn set_knowledge_article_configuration(
            mut self,
            input: std::option::Option<crate::model::ServiceNowKnowledgeArticleConfiguration>,
        ) -> Self {
            self.knowledge_article_configuration = input;
            self
        }
        /// <p>Provides configuration information for crawling service catalogs
        /// in the ServiceNow site.</p>
        pub fn service_catalog_configuration(
            mut self,
            input: crate::model::ServiceNowServiceCatalogConfiguration,
        ) -> Self {
            self.service_catalog_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for crawling service catalogs
        /// in the ServiceNow site.</p>
        pub fn set_service_catalog_configuration(
            mut self,
            input: std::option::Option<crate::model::ServiceNowServiceCatalogConfiguration>,
        ) -> Self {
            self.service_catalog_configuration = input;
            self
        }
        /// <p>Determines the type of authentication used to connect to the
        /// ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is
        /// authenticated using the user name and password provided in the AWS
        /// Secrets Manager secret in the <code>SecretArn</code> field. When you
        /// choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the OAuth
        /// token and secret provided in the Secrets Manager secret, and the
        /// user name and password are used to determine which information Amazon Kendra
        /// has access to.</p>
        /// <p>When you use <code>OAUTH2</code> authentication, you must generate
        /// a token and a client secret using the ServiceNow console. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
        /// ServiceNow data source</a>.</p>
        pub fn authentication_type(
            mut self,
            input: crate::model::ServiceNowAuthenticationType,
        ) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>Determines the type of authentication used to connect to the
        /// ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is
        /// authenticated using the user name and password provided in the AWS
        /// Secrets Manager secret in the <code>SecretArn</code> field. When you
        /// choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the OAuth
        /// token and secret provided in the Secrets Manager secret, and the
        /// user name and password are used to determine which information Amazon Kendra
        /// has access to.</p>
        /// <p>When you use <code>OAUTH2</code> authentication, you must generate
        /// a token and a client secret using the ServiceNow console. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
        /// ServiceNow data source</a>.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::ServiceNowAuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowConfiguration`](crate::model::ServiceNowConfiguration)
        pub fn build(self) -> crate::model::ServiceNowConfiguration {
            crate::model::ServiceNowConfiguration {
                host_url: self.host_url,
                secret_arn: self.secret_arn,
                service_now_build_version: self.service_now_build_version,
                knowledge_article_configuration: self.knowledge_article_configuration,
                service_catalog_configuration: self.service_catalog_configuration,
                authentication_type: self.authentication_type,
            }
        }
    }
}
impl ServiceNowConfiguration {
    /// Creates a new builder-style object to manufacture [`ServiceNowConfiguration`](crate::model::ServiceNowConfiguration)
    pub fn builder() -> crate::model::service_now_configuration::Builder {
        crate::model::service_now_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNowAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    HttpBasic,
    #[allow(missing_docs)] // documentation missing in model
    Oauth2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNowAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "HTTP_BASIC" => ServiceNowAuthenticationType::HttpBasic,
            "OAUTH2" => ServiceNowAuthenticationType::Oauth2,
            other => ServiceNowAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNowAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNowAuthenticationType::from(s))
    }
}
impl ServiceNowAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNowAuthenticationType::HttpBasic => "HTTP_BASIC",
            ServiceNowAuthenticationType::Oauth2 => "OAUTH2",
            ServiceNowAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP_BASIC", "OAUTH2"]
    }
}
impl AsRef<str> for ServiceNowAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for crawling service catalog
/// items in the ServiceNow site</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowServiceCatalogConfiguration {
    /// <p>Indicates whether Amazon Kendra should crawl attachments to the service
    /// catalog items. </p>
    pub crawl_attachments: bool,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the file name of the attachment.</p>
    pub include_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the file name of the attachment.</p>
    pub exclude_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document contents field in the Amazon Kendra index.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document title field.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
    /// must create the index field before you map the field.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl ServiceNowServiceCatalogConfiguration {
    /// <p>Indicates whether Amazon Kendra should crawl attachments to the service
    /// catalog items. </p>
    pub fn crawl_attachments(&self) -> bool {
        self.crawl_attachments
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the file name of the attachment.</p>
    pub fn include_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.include_attachment_file_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the file name of the attachment.</p>
    pub fn exclude_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_attachment_file_patterns.as_deref()
    }
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document contents field in the Amazon Kendra index.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document title field.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
    /// must create the index field before you map the field.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowServiceCatalogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowServiceCatalogConfiguration");
        formatter.field("crawl_attachments", &self.crawl_attachments);
        formatter.field(
            "include_attachment_file_patterns",
            &self.include_attachment_file_patterns,
        );
        formatter.field(
            "exclude_attachment_file_patterns",
            &self.exclude_attachment_file_patterns,
        );
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`ServiceNowServiceCatalogConfiguration`](crate::model::ServiceNowServiceCatalogConfiguration)
pub mod service_now_service_catalog_configuration {
    /// A builder for [`ServiceNowServiceCatalogConfiguration`](crate::model::ServiceNowServiceCatalogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawl_attachments: std::option::Option<bool>,
        pub(crate) include_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>Indicates whether Amazon Kendra should crawl attachments to the service
        /// catalog items. </p>
        pub fn crawl_attachments(mut self, input: bool) -> Self {
            self.crawl_attachments = Some(input);
            self
        }
        /// <p>Indicates whether Amazon Kendra should crawl attachments to the service
        /// catalog items. </p>
        pub fn set_crawl_attachments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_attachments = input;
            self
        }
        /// Appends an item to `include_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_include_attachment_file_patterns`](Self::set_include_attachment_file_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the file name of the attachment.</p>
        pub fn include_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.include_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.include_attachment_file_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the file name of the attachment.</p>
        pub fn set_include_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.include_attachment_file_patterns = input;
            self
        }
        /// Appends an item to `exclude_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclude_attachment_file_patterns`](Self::set_exclude_attachment_file_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the file name of the attachment.</p>
        pub fn exclude_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclude_attachment_file_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the file name of the attachment.</p>
        pub fn set_exclude_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_attachment_file_patterns = input;
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document contents field in the Amazon Kendra index.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document contents field in the Amazon Kendra index.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document title field.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document title field.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
        /// must create the index field before you map the field.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
        /// must create the index field before you map the field.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowServiceCatalogConfiguration`](crate::model::ServiceNowServiceCatalogConfiguration)
        pub fn build(self) -> crate::model::ServiceNowServiceCatalogConfiguration {
            crate::model::ServiceNowServiceCatalogConfiguration {
                crawl_attachments: self.crawl_attachments.unwrap_or_default(),
                include_attachment_file_patterns: self.include_attachment_file_patterns,
                exclude_attachment_file_patterns: self.exclude_attachment_file_patterns,
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl ServiceNowServiceCatalogConfiguration {
    /// Creates a new builder-style object to manufacture [`ServiceNowServiceCatalogConfiguration`](crate::model::ServiceNowServiceCatalogConfiguration)
    pub fn builder() -> crate::model::service_now_service_catalog_configuration::Builder {
        crate::model::service_now_service_catalog_configuration::Builder::default()
    }
}

/// <p>Provides configuration information for crawling knowledge articles
/// in the ServiceNow site.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowKnowledgeArticleConfiguration {
    /// <p>Indicates whether Amazon Kendra should index attachments to knowledge
    /// articles.</p>
    pub crawl_attachments: bool,
    /// <p>List of regular expressions applied to knowledge articles. Items
    /// that don't match the inclusion pattern are not indexed. The regex is
    /// applied to the field specified in the
    /// <code>PatternTargetField</code>.</p>
    pub include_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of regular expressions applied to knowledge articles. Items
    /// that don't match the inclusion pattern are not indexed. The regex is
    /// applied to the field specified in the
    /// <code>PatternTargetField</code>
    /// </p>
    pub exclude_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document contents field in the Amazon Kendra index.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document title field.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
    /// must create the index field before you map the field.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>A query that selects the knowledge articles to index. The query
    /// can return articles from multiple knowledge bases, and the knowledge
    /// bases can be public or private.</p>
    /// <p>The query string must be one generated by the ServiceNow console.
    /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying
    /// documents to index with a query</a>. </p>
    pub filter_query: std::option::Option<std::string::String>,
}
impl ServiceNowKnowledgeArticleConfiguration {
    /// <p>Indicates whether Amazon Kendra should index attachments to knowledge
    /// articles.</p>
    pub fn crawl_attachments(&self) -> bool {
        self.crawl_attachments
    }
    /// <p>List of regular expressions applied to knowledge articles. Items
    /// that don't match the inclusion pattern are not indexed. The regex is
    /// applied to the field specified in the
    /// <code>PatternTargetField</code>.</p>
    pub fn include_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.include_attachment_file_patterns.as_deref()
    }
    /// <p>List of regular expressions applied to knowledge articles. Items
    /// that don't match the inclusion pattern are not indexed. The regex is
    /// applied to the field specified in the
    /// <code>PatternTargetField</code>
    /// </p>
    pub fn exclude_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_attachment_file_patterns.as_deref()
    }
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document contents field in the Amazon Kendra index.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the ServiceNow field that is mapped to the index
    /// document title field.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
    /// must create the index field before you map the field.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>A query that selects the knowledge articles to index. The query
    /// can return articles from multiple knowledge bases, and the knowledge
    /// bases can be public or private.</p>
    /// <p>The query string must be one generated by the ServiceNow console.
    /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying
    /// documents to index with a query</a>. </p>
    pub fn filter_query(&self) -> std::option::Option<&str> {
        self.filter_query.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowKnowledgeArticleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowKnowledgeArticleConfiguration");
        formatter.field("crawl_attachments", &self.crawl_attachments);
        formatter.field(
            "include_attachment_file_patterns",
            &self.include_attachment_file_patterns,
        );
        formatter.field(
            "exclude_attachment_file_patterns",
            &self.exclude_attachment_file_patterns,
        );
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("filter_query", &self.filter_query);
        formatter.finish()
    }
}
/// See [`ServiceNowKnowledgeArticleConfiguration`](crate::model::ServiceNowKnowledgeArticleConfiguration)
pub mod service_now_knowledge_article_configuration {
    /// A builder for [`ServiceNowKnowledgeArticleConfiguration`](crate::model::ServiceNowKnowledgeArticleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawl_attachments: std::option::Option<bool>,
        pub(crate) include_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) filter_query: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether Amazon Kendra should index attachments to knowledge
        /// articles.</p>
        pub fn crawl_attachments(mut self, input: bool) -> Self {
            self.crawl_attachments = Some(input);
            self
        }
        /// <p>Indicates whether Amazon Kendra should index attachments to knowledge
        /// articles.</p>
        pub fn set_crawl_attachments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_attachments = input;
            self
        }
        /// Appends an item to `include_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_include_attachment_file_patterns`](Self::set_include_attachment_file_patterns).
        ///
        /// <p>List of regular expressions applied to knowledge articles. Items
        /// that don't match the inclusion pattern are not indexed. The regex is
        /// applied to the field specified in the
        /// <code>PatternTargetField</code>.</p>
        pub fn include_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.include_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.include_attachment_file_patterns = Some(v);
            self
        }
        /// <p>List of regular expressions applied to knowledge articles. Items
        /// that don't match the inclusion pattern are not indexed. The regex is
        /// applied to the field specified in the
        /// <code>PatternTargetField</code>.</p>
        pub fn set_include_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.include_attachment_file_patterns = input;
            self
        }
        /// Appends an item to `exclude_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclude_attachment_file_patterns`](Self::set_exclude_attachment_file_patterns).
        ///
        /// <p>List of regular expressions applied to knowledge articles. Items
        /// that don't match the inclusion pattern are not indexed. The regex is
        /// applied to the field specified in the
        /// <code>PatternTargetField</code>
        /// </p>
        pub fn exclude_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclude_attachment_file_patterns = Some(v);
            self
        }
        /// <p>List of regular expressions applied to knowledge articles. Items
        /// that don't match the inclusion pattern are not indexed. The regex is
        /// applied to the field specified in the
        /// <code>PatternTargetField</code>
        /// </p>
        pub fn set_exclude_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_attachment_file_patterns = input;
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document contents field in the Amazon Kendra index.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document contents field in the Amazon Kendra index.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document title field.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the ServiceNow field that is mapped to the index
        /// document title field.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
        /// must create the index field before you map the field.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>Mapping between ServiceNow fields and Amazon Kendra index fields. You
        /// must create the index field before you map the field.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// <p>A query that selects the knowledge articles to index. The query
        /// can return articles from multiple knowledge bases, and the knowledge
        /// bases can be public or private.</p>
        /// <p>The query string must be one generated by the ServiceNow console.
        /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying
        /// documents to index with a query</a>. </p>
        pub fn filter_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_query = Some(input.into());
            self
        }
        /// <p>A query that selects the knowledge articles to index. The query
        /// can return articles from multiple knowledge bases, and the knowledge
        /// bases can be public or private.</p>
        /// <p>The query string must be one generated by the ServiceNow console.
        /// For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying
        /// documents to index with a query</a>. </p>
        pub fn set_filter_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_query = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowKnowledgeArticleConfiguration`](crate::model::ServiceNowKnowledgeArticleConfiguration)
        pub fn build(self) -> crate::model::ServiceNowKnowledgeArticleConfiguration {
            crate::model::ServiceNowKnowledgeArticleConfiguration {
                crawl_attachments: self.crawl_attachments.unwrap_or_default(),
                include_attachment_file_patterns: self.include_attachment_file_patterns,
                exclude_attachment_file_patterns: self.exclude_attachment_file_patterns,
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
                filter_query: self.filter_query,
            }
        }
    }
}
impl ServiceNowKnowledgeArticleConfiguration {
    /// Creates a new builder-style object to manufacture [`ServiceNowKnowledgeArticleConfiguration`](crate::model::ServiceNowKnowledgeArticleConfiguration)
    pub fn builder() -> crate::model::service_now_knowledge_article_configuration::Builder {
        crate::model::service_now_knowledge_article_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNowBuildVersionType {
    #[allow(missing_docs)] // documentation missing in model
    London,
    #[allow(missing_docs)] // documentation missing in model
    Others,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNowBuildVersionType {
    fn from(s: &str) -> Self {
        match s {
            "LONDON" => ServiceNowBuildVersionType::London,
            "OTHERS" => ServiceNowBuildVersionType::Others,
            other => ServiceNowBuildVersionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNowBuildVersionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNowBuildVersionType::from(s))
    }
}
impl ServiceNowBuildVersionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNowBuildVersionType::London => "LONDON",
            ServiceNowBuildVersionType::Others => "OTHERS",
            ServiceNowBuildVersionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LONDON", "OTHERS"]
    }
}
impl AsRef<str> for ServiceNowBuildVersionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for data sources that connect
/// to OneDrive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OneDriveConfiguration {
    /// <p>The Azure Active Directory domain of the organization. </p>
    pub tenant_domain: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the user name and password to connect to OneDrive. The
    /// user namd should be the application ID for the OneDrive application,
    /// and the password is the application key for the OneDrive
    /// application.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>A list of user accounts whose documents should be indexed.</p>
    pub one_drive_users: std::option::Option<crate::model::OneDriveUsers>,
    /// <p>A list of regular expression patterns. Documents that match the
    /// pattern are included in the index. Documents that don't match the
    /// pattern are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index. </p>
    /// <p>The exclusion pattern is applied to the file name.</p>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of regular expressions applied to documents. Items that match
    /// the exclusion pattern are not indexed. If you provide both an
    /// inclusion pattern and an exclusion pattern, any item that matches
    /// the exclusion pattern isn't indexed. </p>
    /// <p>The exclusion pattern is applied to the file name.</p>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
    /// map Microsoft OneDrive fields to custom fields in the Amazon Kendra
    /// index. You must first create the index fields before you map
    /// OneDrive fields.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>A Boolean value that specifies whether local
    /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
    /// </p>
    pub disable_local_groups: bool,
}
impl OneDriveConfiguration {
    /// <p>The Azure Active Directory domain of the organization. </p>
    pub fn tenant_domain(&self) -> std::option::Option<&str> {
        self.tenant_domain.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the user name and password to connect to OneDrive. The
    /// user namd should be the application ID for the OneDrive application,
    /// and the password is the application key for the OneDrive
    /// application.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>A list of user accounts whose documents should be indexed.</p>
    pub fn one_drive_users(&self) -> std::option::Option<&crate::model::OneDriveUsers> {
        self.one_drive_users.as_ref()
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// pattern are included in the index. Documents that don't match the
    /// pattern are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index. </p>
    /// <p>The exclusion pattern is applied to the file name.</p>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>List of regular expressions applied to documents. Items that match
    /// the exclusion pattern are not indexed. If you provide both an
    /// inclusion pattern and an exclusion pattern, any item that matches
    /// the exclusion pattern isn't indexed. </p>
    /// <p>The exclusion pattern is applied to the file name.</p>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
    /// map Microsoft OneDrive fields to custom fields in the Amazon Kendra
    /// index. You must first create the index fields before you map
    /// OneDrive fields.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>A Boolean value that specifies whether local
    /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
    /// </p>
    pub fn disable_local_groups(&self) -> bool {
        self.disable_local_groups
    }
}
impl std::fmt::Debug for OneDriveConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OneDriveConfiguration");
        formatter.field("tenant_domain", &self.tenant_domain);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("one_drive_users", &self.one_drive_users);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("disable_local_groups", &self.disable_local_groups);
        formatter.finish()
    }
}
/// See [`OneDriveConfiguration`](crate::model::OneDriveConfiguration)
pub mod one_drive_configuration {
    /// A builder for [`OneDriveConfiguration`](crate::model::OneDriveConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tenant_domain: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) one_drive_users: std::option::Option<crate::model::OneDriveUsers>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) disable_local_groups: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Azure Active Directory domain of the organization. </p>
        pub fn tenant_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.tenant_domain = Some(input.into());
            self
        }
        /// <p>The Azure Active Directory domain of the organization. </p>
        pub fn set_tenant_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tenant_domain = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the user name and password to connect to OneDrive. The
        /// user namd should be the application ID for the OneDrive application,
        /// and the password is the application key for the OneDrive
        /// application.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the user name and password to connect to OneDrive. The
        /// user namd should be the application ID for the OneDrive application,
        /// and the password is the application key for the OneDrive
        /// application.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>A list of user accounts whose documents should be indexed.</p>
        pub fn one_drive_users(mut self, input: crate::model::OneDriveUsers) -> Self {
            self.one_drive_users = Some(input);
            self
        }
        /// <p>A list of user accounts whose documents should be indexed.</p>
        pub fn set_one_drive_users(
            mut self,
            input: std::option::Option<crate::model::OneDriveUsers>,
        ) -> Self {
            self.one_drive_users = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// pattern are included in the index. Documents that don't match the
        /// pattern are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index. </p>
        /// <p>The exclusion pattern is applied to the file name.</p>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// pattern are included in the index. Documents that don't match the
        /// pattern are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index. </p>
        /// <p>The exclusion pattern is applied to the file name.</p>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>List of regular expressions applied to documents. Items that match
        /// the exclusion pattern are not indexed. If you provide both an
        /// inclusion pattern and an exclusion pattern, any item that matches
        /// the exclusion pattern isn't indexed. </p>
        /// <p>The exclusion pattern is applied to the file name.</p>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>List of regular expressions applied to documents. Items that match
        /// the exclusion pattern are not indexed. If you provide both an
        /// inclusion pattern and an exclusion pattern, any item that matches
        /// the exclusion pattern isn't indexed. </p>
        /// <p>The exclusion pattern is applied to the file name.</p>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
        /// map Microsoft OneDrive fields to custom fields in the Amazon Kendra
        /// index. You must first create the index fields before you map
        /// OneDrive fields.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
        /// map Microsoft OneDrive fields to custom fields in the Amazon Kendra
        /// index. You must first create the index fields before you map
        /// OneDrive fields.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// <p>A Boolean value that specifies whether local
        /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
        /// </p>
        pub fn disable_local_groups(mut self, input: bool) -> Self {
            self.disable_local_groups = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether local
        /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
        /// </p>
        pub fn set_disable_local_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_local_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`OneDriveConfiguration`](crate::model::OneDriveConfiguration)
        pub fn build(self) -> crate::model::OneDriveConfiguration {
            crate::model::OneDriveConfiguration {
                tenant_domain: self.tenant_domain,
                secret_arn: self.secret_arn,
                one_drive_users: self.one_drive_users,
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
                field_mappings: self.field_mappings,
                disable_local_groups: self.disable_local_groups.unwrap_or_default(),
            }
        }
    }
}
impl OneDriveConfiguration {
    /// Creates a new builder-style object to manufacture [`OneDriveConfiguration`](crate::model::OneDriveConfiguration)
    pub fn builder() -> crate::model::one_drive_configuration::Builder {
        crate::model::one_drive_configuration::Builder::default()
    }
}

/// <p>User accounts whose documents should be indexed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OneDriveUsers {
    /// <p>A list of users whose documents should be indexed. Specify the
    /// user names in email format, for example,
    /// <code>username@tenantdomain</code>. If you need to index the
    /// documents of more than 100 users, use the
    /// <code>OneDriveUserS3Path</code> field to specify the location of
    /// a file containing a list of users.</p>
    pub one_drive_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The S3 bucket location of a file containing a list of users whose
    /// documents should be indexed.</p>
    pub one_drive_user_s3_path: std::option::Option<crate::model::S3Path>,
}
impl OneDriveUsers {
    /// <p>A list of users whose documents should be indexed. Specify the
    /// user names in email format, for example,
    /// <code>username@tenantdomain</code>. If you need to index the
    /// documents of more than 100 users, use the
    /// <code>OneDriveUserS3Path</code> field to specify the location of
    /// a file containing a list of users.</p>
    pub fn one_drive_user_list(&self) -> std::option::Option<&[std::string::String]> {
        self.one_drive_user_list.as_deref()
    }
    /// <p>The S3 bucket location of a file containing a list of users whose
    /// documents should be indexed.</p>
    pub fn one_drive_user_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.one_drive_user_s3_path.as_ref()
    }
}
impl std::fmt::Debug for OneDriveUsers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OneDriveUsers");
        formatter.field("one_drive_user_list", &self.one_drive_user_list);
        formatter.field("one_drive_user_s3_path", &self.one_drive_user_s3_path);
        formatter.finish()
    }
}
/// See [`OneDriveUsers`](crate::model::OneDriveUsers)
pub mod one_drive_users {
    /// A builder for [`OneDriveUsers`](crate::model::OneDriveUsers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) one_drive_user_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) one_drive_user_s3_path: std::option::Option<crate::model::S3Path>,
    }
    impl Builder {
        /// Appends an item to `one_drive_user_list`.
        ///
        /// To override the contents of this collection use [`set_one_drive_user_list`](Self::set_one_drive_user_list).
        ///
        /// <p>A list of users whose documents should be indexed. Specify the
        /// user names in email format, for example,
        /// <code>username@tenantdomain</code>. If you need to index the
        /// documents of more than 100 users, use the
        /// <code>OneDriveUserS3Path</code> field to specify the location of
        /// a file containing a list of users.</p>
        pub fn one_drive_user_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.one_drive_user_list.unwrap_or_default();
            v.push(input.into());
            self.one_drive_user_list = Some(v);
            self
        }
        /// <p>A list of users whose documents should be indexed. Specify the
        /// user names in email format, for example,
        /// <code>username@tenantdomain</code>. If you need to index the
        /// documents of more than 100 users, use the
        /// <code>OneDriveUserS3Path</code> field to specify the location of
        /// a file containing a list of users.</p>
        pub fn set_one_drive_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.one_drive_user_list = input;
            self
        }
        /// <p>The S3 bucket location of a file containing a list of users whose
        /// documents should be indexed.</p>
        pub fn one_drive_user_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.one_drive_user_s3_path = Some(input);
            self
        }
        /// <p>The S3 bucket location of a file containing a list of users whose
        /// documents should be indexed.</p>
        pub fn set_one_drive_user_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.one_drive_user_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`OneDriveUsers`](crate::model::OneDriveUsers)
        pub fn build(self) -> crate::model::OneDriveUsers {
            crate::model::OneDriveUsers {
                one_drive_user_list: self.one_drive_user_list,
                one_drive_user_s3_path: self.one_drive_user_s3_path,
            }
        }
    }
}
impl OneDriveUsers {
    /// Creates a new builder-style object to manufacture [`OneDriveUsers`](crate::model::OneDriveUsers)
    pub fn builder() -> crate::model::one_drive_users::Builder {
        crate::model::one_drive_users::Builder::default()
    }
}

/// <p>Provides configuration information for connecting to a Salesforce
/// data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceConfiguration {
    /// <p>The instance URL for the Salesforce site that you want to
    /// index.</p>
    pub server_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the key/value pairs required to connect to your
    /// Salesforce instance. The secret must contain a JSON structure with
    /// the following keys:</p>
    /// <ul>
    /// <li>
    /// <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra
    /// connects to get an OAUTH token. </p>
    /// </li>
    /// <li>
    /// <p>consumerKey - The application public key generated when
    /// you created your Salesforce application.</p>
    /// </li>
    /// <li>
    /// <p>consumerSecret - The application private key generated
    /// when you created your Salesforce application.</p>
    /// </li>
    /// <li>
    /// <p>password - The password associated with the user logging
    /// in to the Salesforce instance.</p>
    /// </li>
    /// <li>
    /// <p>securityToken - The token associated with the user account
    /// logging in to the Salesforce instance.</p>
    /// </li>
    /// <li>
    /// <p>username - The user name of the user logging in to the
    /// Salesforce instance.</p>
    /// </li>
    /// </ul>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the Salesforce standard objects that Amazon Kendra
    /// indexes.</p>
    pub standard_object_configurations:
        std::option::Option<std::vec::Vec<crate::model::SalesforceStandardObjectConfiguration>>,
    /// <p>Specifies configuration information for the knowledge article
    /// types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
    /// articles and the standard fields of knowledge articles, or the
    /// custom fields of custom knowledge articles, but not both.</p>
    pub knowledge_article_configuration:
        std::option::Option<crate::model::SalesforceKnowledgeArticleConfiguration>,
    /// <p>Specifies configuration information for Salesforce chatter
    /// feeds.</p>
    pub chatter_feed_configuration:
        std::option::Option<crate::model::SalesforceChatterFeedConfiguration>,
    /// <p>Indicates whether Amazon Kendra should index attachments to Salesforce
    /// objects.</p>
    pub crawl_attachments: bool,
    /// <p>Provides configuration information for processing attachments to
    /// Salesforce standard objects. </p>
    pub standard_object_attachment_configuration:
        std::option::Option<crate::model::SalesforceStandardObjectAttachmentConfiguration>,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the name of the attached file.</p>
    pub include_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the name of the attached file.</p>
    pub exclude_attachment_file_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SalesforceConfiguration {
    /// <p>The instance URL for the Salesforce site that you want to
    /// index.</p>
    pub fn server_url(&self) -> std::option::Option<&str> {
        self.server_url.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
    /// that contains the key/value pairs required to connect to your
    /// Salesforce instance. The secret must contain a JSON structure with
    /// the following keys:</p>
    /// <ul>
    /// <li>
    /// <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra
    /// connects to get an OAUTH token. </p>
    /// </li>
    /// <li>
    /// <p>consumerKey - The application public key generated when
    /// you created your Salesforce application.</p>
    /// </li>
    /// <li>
    /// <p>consumerSecret - The application private key generated
    /// when you created your Salesforce application.</p>
    /// </li>
    /// <li>
    /// <p>password - The password associated with the user logging
    /// in to the Salesforce instance.</p>
    /// </li>
    /// <li>
    /// <p>securityToken - The token associated with the user account
    /// logging in to the Salesforce instance.</p>
    /// </li>
    /// <li>
    /// <p>username - The user name of the user logging in to the
    /// Salesforce instance.</p>
    /// </li>
    /// </ul>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>Specifies the Salesforce standard objects that Amazon Kendra
    /// indexes.</p>
    pub fn standard_object_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SalesforceStandardObjectConfiguration]> {
        self.standard_object_configurations.as_deref()
    }
    /// <p>Specifies configuration information for the knowledge article
    /// types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
    /// articles and the standard fields of knowledge articles, or the
    /// custom fields of custom knowledge articles, but not both.</p>
    pub fn knowledge_article_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceKnowledgeArticleConfiguration> {
        self.knowledge_article_configuration.as_ref()
    }
    /// <p>Specifies configuration information for Salesforce chatter
    /// feeds.</p>
    pub fn chatter_feed_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceChatterFeedConfiguration> {
        self.chatter_feed_configuration.as_ref()
    }
    /// <p>Indicates whether Amazon Kendra should index attachments to Salesforce
    /// objects.</p>
    pub fn crawl_attachments(&self) -> bool {
        self.crawl_attachments
    }
    /// <p>Provides configuration information for processing attachments to
    /// Salesforce standard objects. </p>
    pub fn standard_object_attachment_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceStandardObjectAttachmentConfiguration> {
        self.standard_object_attachment_configuration.as_ref()
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the name of the attached file.</p>
    pub fn include_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.include_attachment_file_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the name of the attached file.</p>
    pub fn exclude_attachment_file_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_attachment_file_patterns.as_deref()
    }
}
impl std::fmt::Debug for SalesforceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceConfiguration");
        formatter.field("server_url", &self.server_url);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field(
            "standard_object_configurations",
            &self.standard_object_configurations,
        );
        formatter.field(
            "knowledge_article_configuration",
            &self.knowledge_article_configuration,
        );
        formatter.field(
            "chatter_feed_configuration",
            &self.chatter_feed_configuration,
        );
        formatter.field("crawl_attachments", &self.crawl_attachments);
        formatter.field(
            "standard_object_attachment_configuration",
            &self.standard_object_attachment_configuration,
        );
        formatter.field(
            "include_attachment_file_patterns",
            &self.include_attachment_file_patterns,
        );
        formatter.field(
            "exclude_attachment_file_patterns",
            &self.exclude_attachment_file_patterns,
        );
        formatter.finish()
    }
}
/// See [`SalesforceConfiguration`](crate::model::SalesforceConfiguration)
pub mod salesforce_configuration {
    /// A builder for [`SalesforceConfiguration`](crate::model::SalesforceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_url: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) standard_object_configurations:
            std::option::Option<std::vec::Vec<crate::model::SalesforceStandardObjectConfiguration>>,
        pub(crate) knowledge_article_configuration:
            std::option::Option<crate::model::SalesforceKnowledgeArticleConfiguration>,
        pub(crate) chatter_feed_configuration:
            std::option::Option<crate::model::SalesforceChatterFeedConfiguration>,
        pub(crate) crawl_attachments: std::option::Option<bool>,
        pub(crate) standard_object_attachment_configuration:
            std::option::Option<crate::model::SalesforceStandardObjectAttachmentConfiguration>,
        pub(crate) include_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude_attachment_file_patterns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The instance URL for the Salesforce site that you want to
        /// index.</p>
        pub fn server_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_url = Some(input.into());
            self
        }
        /// <p>The instance URL for the Salesforce site that you want to
        /// index.</p>
        pub fn set_server_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_url = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the key/value pairs required to connect to your
        /// Salesforce instance. The secret must contain a JSON structure with
        /// the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra
        /// connects to get an OAUTH token. </p>
        /// </li>
        /// <li>
        /// <p>consumerKey - The application public key generated when
        /// you created your Salesforce application.</p>
        /// </li>
        /// <li>
        /// <p>consumerSecret - The application private key generated
        /// when you created your Salesforce application.</p>
        /// </li>
        /// <li>
        /// <p>password - The password associated with the user logging
        /// in to the Salesforce instance.</p>
        /// </li>
        /// <li>
        /// <p>securityToken - The token associated with the user account
        /// logging in to the Salesforce instance.</p>
        /// </li>
        /// <li>
        /// <p>username - The user name of the user logging in to the
        /// Salesforce instance.</p>
        /// </li>
        /// </ul>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Secrets Managersecret
        /// that contains the key/value pairs required to connect to your
        /// Salesforce instance. The secret must contain a JSON structure with
        /// the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra
        /// connects to get an OAUTH token. </p>
        /// </li>
        /// <li>
        /// <p>consumerKey - The application public key generated when
        /// you created your Salesforce application.</p>
        /// </li>
        /// <li>
        /// <p>consumerSecret - The application private key generated
        /// when you created your Salesforce application.</p>
        /// </li>
        /// <li>
        /// <p>password - The password associated with the user logging
        /// in to the Salesforce instance.</p>
        /// </li>
        /// <li>
        /// <p>securityToken - The token associated with the user account
        /// logging in to the Salesforce instance.</p>
        /// </li>
        /// <li>
        /// <p>username - The user name of the user logging in to the
        /// Salesforce instance.</p>
        /// </li>
        /// </ul>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Appends an item to `standard_object_configurations`.
        ///
        /// To override the contents of this collection use [`set_standard_object_configurations`](Self::set_standard_object_configurations).
        ///
        /// <p>Specifies the Salesforce standard objects that Amazon Kendra
        /// indexes.</p>
        pub fn standard_object_configurations(
            mut self,
            input: impl Into<crate::model::SalesforceStandardObjectConfiguration>,
        ) -> Self {
            let mut v = self.standard_object_configurations.unwrap_or_default();
            v.push(input.into());
            self.standard_object_configurations = Some(v);
            self
        }
        /// <p>Specifies the Salesforce standard objects that Amazon Kendra
        /// indexes.</p>
        pub fn set_standard_object_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SalesforceStandardObjectConfiguration>,
            >,
        ) -> Self {
            self.standard_object_configurations = input;
            self
        }
        /// <p>Specifies configuration information for the knowledge article
        /// types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
        /// articles and the standard fields of knowledge articles, or the
        /// custom fields of custom knowledge articles, but not both.</p>
        pub fn knowledge_article_configuration(
            mut self,
            input: crate::model::SalesforceKnowledgeArticleConfiguration,
        ) -> Self {
            self.knowledge_article_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information for the knowledge article
        /// types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
        /// articles and the standard fields of knowledge articles, or the
        /// custom fields of custom knowledge articles, but not both.</p>
        pub fn set_knowledge_article_configuration(
            mut self,
            input: std::option::Option<crate::model::SalesforceKnowledgeArticleConfiguration>,
        ) -> Self {
            self.knowledge_article_configuration = input;
            self
        }
        /// <p>Specifies configuration information for Salesforce chatter
        /// feeds.</p>
        pub fn chatter_feed_configuration(
            mut self,
            input: crate::model::SalesforceChatterFeedConfiguration,
        ) -> Self {
            self.chatter_feed_configuration = Some(input);
            self
        }
        /// <p>Specifies configuration information for Salesforce chatter
        /// feeds.</p>
        pub fn set_chatter_feed_configuration(
            mut self,
            input: std::option::Option<crate::model::SalesforceChatterFeedConfiguration>,
        ) -> Self {
            self.chatter_feed_configuration = input;
            self
        }
        /// <p>Indicates whether Amazon Kendra should index attachments to Salesforce
        /// objects.</p>
        pub fn crawl_attachments(mut self, input: bool) -> Self {
            self.crawl_attachments = Some(input);
            self
        }
        /// <p>Indicates whether Amazon Kendra should index attachments to Salesforce
        /// objects.</p>
        pub fn set_crawl_attachments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_attachments = input;
            self
        }
        /// <p>Provides configuration information for processing attachments to
        /// Salesforce standard objects. </p>
        pub fn standard_object_attachment_configuration(
            mut self,
            input: crate::model::SalesforceStandardObjectAttachmentConfiguration,
        ) -> Self {
            self.standard_object_attachment_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for processing attachments to
        /// Salesforce standard objects. </p>
        pub fn set_standard_object_attachment_configuration(
            mut self,
            input: std::option::Option<
                crate::model::SalesforceStandardObjectAttachmentConfiguration,
            >,
        ) -> Self {
            self.standard_object_attachment_configuration = input;
            self
        }
        /// Appends an item to `include_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_include_attachment_file_patterns`](Self::set_include_attachment_file_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the name of the attached file.</p>
        pub fn include_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.include_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.include_attachment_file_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the name of the attached file.</p>
        pub fn set_include_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.include_attachment_file_patterns = input;
            self
        }
        /// Appends an item to `exclude_attachment_file_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclude_attachment_file_patterns`](Self::set_exclude_attachment_file_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the name of the attached file.</p>
        pub fn exclude_attachment_file_patterns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_attachment_file_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclude_attachment_file_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the name of the attached file.</p>
        pub fn set_exclude_attachment_file_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_attachment_file_patterns = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceConfiguration`](crate::model::SalesforceConfiguration)
        pub fn build(self) -> crate::model::SalesforceConfiguration {
            crate::model::SalesforceConfiguration {
                server_url: self.server_url,
                secret_arn: self.secret_arn,
                standard_object_configurations: self.standard_object_configurations,
                knowledge_article_configuration: self.knowledge_article_configuration,
                chatter_feed_configuration: self.chatter_feed_configuration,
                crawl_attachments: self.crawl_attachments.unwrap_or_default(),
                standard_object_attachment_configuration: self
                    .standard_object_attachment_configuration,
                include_attachment_file_patterns: self.include_attachment_file_patterns,
                exclude_attachment_file_patterns: self.exclude_attachment_file_patterns,
            }
        }
    }
}
impl SalesforceConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceConfiguration`](crate::model::SalesforceConfiguration)
    pub fn builder() -> crate::model::salesforce_configuration::Builder {
        crate::model::salesforce_configuration::Builder::default()
    }
}

/// <p>Provides configuration information for processing attachments to
/// Salesforce standard objects. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceStandardObjectAttachmentConfiguration {
    /// <p>The name of the field used for the document title.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>One or more objects that map fields in attachments to Amazon Kendra
    /// index fields.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl SalesforceStandardObjectAttachmentConfiguration {
    /// <p>The name of the field used for the document title.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>One or more objects that map fields in attachments to Amazon Kendra
    /// index fields.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for SalesforceStandardObjectAttachmentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceStandardObjectAttachmentConfiguration");
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`SalesforceStandardObjectAttachmentConfiguration`](crate::model::SalesforceStandardObjectAttachmentConfiguration)
pub mod salesforce_standard_object_attachment_configuration {
    /// A builder for [`SalesforceStandardObjectAttachmentConfiguration`](crate::model::SalesforceStandardObjectAttachmentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>The name of the field used for the document title.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field used for the document title.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>One or more objects that map fields in attachments to Amazon Kendra
        /// index fields.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>One or more objects that map fields in attachments to Amazon Kendra
        /// index fields.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceStandardObjectAttachmentConfiguration`](crate::model::SalesforceStandardObjectAttachmentConfiguration)
        pub fn build(self) -> crate::model::SalesforceStandardObjectAttachmentConfiguration {
            crate::model::SalesforceStandardObjectAttachmentConfiguration {
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl SalesforceStandardObjectAttachmentConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceStandardObjectAttachmentConfiguration`](crate::model::SalesforceStandardObjectAttachmentConfiguration)
    pub fn builder() -> crate::model::salesforce_standard_object_attachment_configuration::Builder {
        crate::model::salesforce_standard_object_attachment_configuration::Builder::default()
    }
}

/// <p>Defines configuration for syncing a Salesforce chatter feed. The
/// contents of the object comes from the Salesforce FeedItem
/// table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceChatterFeedConfiguration {
    /// <p>The name of the column in the Salesforce FeedItem table that
    /// contains the content to index. Typically this is the
    /// <code>Body</code> column.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the column in the Salesforce FeedItem table that
    /// contains the title of the document. This is typically the
    /// <code>Title</code> column.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>Maps fields from a Salesforce chatter feed into Amazon Kendra index
    /// fields.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>Filters the documents in the feed based on status of the user.
    /// When you specify <code>ACTIVE_USERS</code> only documents from users
    /// who have an active account are indexed. When you specify
    /// <code>STANDARD_USER</code> only documents for Salesforce
    /// standard users are documented. You can specify both.</p>
    pub include_filter_types:
        std::option::Option<std::vec::Vec<crate::model::SalesforceChatterFeedIncludeFilterType>>,
}
impl SalesforceChatterFeedConfiguration {
    /// <p>The name of the column in the Salesforce FeedItem table that
    /// contains the content to index. Typically this is the
    /// <code>Body</code> column.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the column in the Salesforce FeedItem table that
    /// contains the title of the document. This is typically the
    /// <code>Title</code> column.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>Maps fields from a Salesforce chatter feed into Amazon Kendra index
    /// fields.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>Filters the documents in the feed based on status of the user.
    /// When you specify <code>ACTIVE_USERS</code> only documents from users
    /// who have an active account are indexed. When you specify
    /// <code>STANDARD_USER</code> only documents for Salesforce
    /// standard users are documented. You can specify both.</p>
    pub fn include_filter_types(
        &self,
    ) -> std::option::Option<&[crate::model::SalesforceChatterFeedIncludeFilterType]> {
        self.include_filter_types.as_deref()
    }
}
impl std::fmt::Debug for SalesforceChatterFeedConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceChatterFeedConfiguration");
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("include_filter_types", &self.include_filter_types);
        formatter.finish()
    }
}
/// See [`SalesforceChatterFeedConfiguration`](crate::model::SalesforceChatterFeedConfiguration)
pub mod salesforce_chatter_feed_configuration {
    /// A builder for [`SalesforceChatterFeedConfiguration`](crate::model::SalesforceChatterFeedConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) include_filter_types: std::option::Option<
            std::vec::Vec<crate::model::SalesforceChatterFeedIncludeFilterType>,
        >,
    }
    impl Builder {
        /// <p>The name of the column in the Salesforce FeedItem table that
        /// contains the content to index. Typically this is the
        /// <code>Body</code> column.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the column in the Salesforce FeedItem table that
        /// contains the content to index. Typically this is the
        /// <code>Body</code> column.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the column in the Salesforce FeedItem table that
        /// contains the title of the document. This is typically the
        /// <code>Title</code> column.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the column in the Salesforce FeedItem table that
        /// contains the title of the document. This is typically the
        /// <code>Title</code> column.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>Maps fields from a Salesforce chatter feed into Amazon Kendra index
        /// fields.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>Maps fields from a Salesforce chatter feed into Amazon Kendra index
        /// fields.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Appends an item to `include_filter_types`.
        ///
        /// To override the contents of this collection use [`set_include_filter_types`](Self::set_include_filter_types).
        ///
        /// <p>Filters the documents in the feed based on status of the user.
        /// When you specify <code>ACTIVE_USERS</code> only documents from users
        /// who have an active account are indexed. When you specify
        /// <code>STANDARD_USER</code> only documents for Salesforce
        /// standard users are documented. You can specify both.</p>
        pub fn include_filter_types(
            mut self,
            input: impl Into<crate::model::SalesforceChatterFeedIncludeFilterType>,
        ) -> Self {
            let mut v = self.include_filter_types.unwrap_or_default();
            v.push(input.into());
            self.include_filter_types = Some(v);
            self
        }
        /// <p>Filters the documents in the feed based on status of the user.
        /// When you specify <code>ACTIVE_USERS</code> only documents from users
        /// who have an active account are indexed. When you specify
        /// <code>STANDARD_USER</code> only documents for Salesforce
        /// standard users are documented. You can specify both.</p>
        pub fn set_include_filter_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SalesforceChatterFeedIncludeFilterType>,
            >,
        ) -> Self {
            self.include_filter_types = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceChatterFeedConfiguration`](crate::model::SalesforceChatterFeedConfiguration)
        pub fn build(self) -> crate::model::SalesforceChatterFeedConfiguration {
            crate::model::SalesforceChatterFeedConfiguration {
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
                include_filter_types: self.include_filter_types,
            }
        }
    }
}
impl SalesforceChatterFeedConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceChatterFeedConfiguration`](crate::model::SalesforceChatterFeedConfiguration)
    pub fn builder() -> crate::model::salesforce_chatter_feed_configuration::Builder {
        crate::model::salesforce_chatter_feed_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SalesforceChatterFeedIncludeFilterType {
    #[allow(missing_docs)] // documentation missing in model
    ActiveUser,
    #[allow(missing_docs)] // documentation missing in model
    StandardUser,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SalesforceChatterFeedIncludeFilterType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE_USER" => SalesforceChatterFeedIncludeFilterType::ActiveUser,
            "STANDARD_USER" => SalesforceChatterFeedIncludeFilterType::StandardUser,
            other => SalesforceChatterFeedIncludeFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SalesforceChatterFeedIncludeFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SalesforceChatterFeedIncludeFilterType::from(s))
    }
}
impl SalesforceChatterFeedIncludeFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SalesforceChatterFeedIncludeFilterType::ActiveUser => "ACTIVE_USER",
            SalesforceChatterFeedIncludeFilterType::StandardUser => "STANDARD_USER",
            SalesforceChatterFeedIncludeFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE_USER", "STANDARD_USER"]
    }
}
impl AsRef<str> for SalesforceChatterFeedIncludeFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies configuration information for the knowledge article
/// types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
/// articles and the standard fields of knowledge articles, or the
/// custom fields of custom knowledge articles, but not both </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceKnowledgeArticleConfiguration {
    /// <p>Specifies the document states that should be included when
    /// Amazon Kendra indexes knowledge articles. You must specify at least one
    /// state.</p>
    pub included_states:
        std::option::Option<std::vec::Vec<crate::model::SalesforceKnowledgeArticleState>>,
    /// <p>Provides configuration information for standard Salesforce
    /// knowledge articles.</p>
    pub standard_knowledge_article_type_configuration:
        std::option::Option<crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration>,
    /// <p>Provides configuration information for custom Salesforce knowledge
    /// articles.</p>
    pub custom_knowledge_article_type_configurations: std::option::Option<
        std::vec::Vec<crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration>,
    >,
}
impl SalesforceKnowledgeArticleConfiguration {
    /// <p>Specifies the document states that should be included when
    /// Amazon Kendra indexes knowledge articles. You must specify at least one
    /// state.</p>
    pub fn included_states(
        &self,
    ) -> std::option::Option<&[crate::model::SalesforceKnowledgeArticleState]> {
        self.included_states.as_deref()
    }
    /// <p>Provides configuration information for standard Salesforce
    /// knowledge articles.</p>
    pub fn standard_knowledge_article_type_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration>
    {
        self.standard_knowledge_article_type_configuration.as_ref()
    }
    /// <p>Provides configuration information for custom Salesforce knowledge
    /// articles.</p>
    pub fn custom_knowledge_article_type_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration]>
    {
        self.custom_knowledge_article_type_configurations.as_deref()
    }
}
impl std::fmt::Debug for SalesforceKnowledgeArticleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceKnowledgeArticleConfiguration");
        formatter.field("included_states", &self.included_states);
        formatter.field(
            "standard_knowledge_article_type_configuration",
            &self.standard_knowledge_article_type_configuration,
        );
        formatter.field(
            "custom_knowledge_article_type_configurations",
            &self.custom_knowledge_article_type_configurations,
        );
        formatter.finish()
    }
}
/// See [`SalesforceKnowledgeArticleConfiguration`](crate::model::SalesforceKnowledgeArticleConfiguration)
pub mod salesforce_knowledge_article_configuration {
    /// A builder for [`SalesforceKnowledgeArticleConfiguration`](crate::model::SalesforceKnowledgeArticleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) included_states:
            std::option::Option<std::vec::Vec<crate::model::SalesforceKnowledgeArticleState>>,
        pub(crate) standard_knowledge_article_type_configuration:
            std::option::Option<crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration>,
        pub(crate) custom_knowledge_article_type_configurations: std::option::Option<
            std::vec::Vec<crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration>,
        >,
    }
    impl Builder {
        /// Appends an item to `included_states`.
        ///
        /// To override the contents of this collection use [`set_included_states`](Self::set_included_states).
        ///
        /// <p>Specifies the document states that should be included when
        /// Amazon Kendra indexes knowledge articles. You must specify at least one
        /// state.</p>
        pub fn included_states(
            mut self,
            input: impl Into<crate::model::SalesforceKnowledgeArticleState>,
        ) -> Self {
            let mut v = self.included_states.unwrap_or_default();
            v.push(input.into());
            self.included_states = Some(v);
            self
        }
        /// <p>Specifies the document states that should be included when
        /// Amazon Kendra indexes knowledge articles. You must specify at least one
        /// state.</p>
        pub fn set_included_states(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SalesforceKnowledgeArticleState>,
            >,
        ) -> Self {
            self.included_states = input;
            self
        }
        /// <p>Provides configuration information for standard Salesforce
        /// knowledge articles.</p>
        pub fn standard_knowledge_article_type_configuration(
            mut self,
            input: crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration,
        ) -> Self {
            self.standard_knowledge_article_type_configuration = Some(input);
            self
        }
        /// <p>Provides configuration information for standard Salesforce
        /// knowledge articles.</p>
        pub fn set_standard_knowledge_article_type_configuration(
            mut self,
            input: std::option::Option<
                crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration,
            >,
        ) -> Self {
            self.standard_knowledge_article_type_configuration = input;
            self
        }
        /// Appends an item to `custom_knowledge_article_type_configurations`.
        ///
        /// To override the contents of this collection use [`set_custom_knowledge_article_type_configurations`](Self::set_custom_knowledge_article_type_configurations).
        ///
        /// <p>Provides configuration information for custom Salesforce knowledge
        /// articles.</p>
        pub fn custom_knowledge_article_type_configurations(
            mut self,
            input: impl Into<crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration>,
        ) -> Self {
            let mut v = self
                .custom_knowledge_article_type_configurations
                .unwrap_or_default();
            v.push(input.into());
            self.custom_knowledge_article_type_configurations = Some(v);
            self
        }
        /// <p>Provides configuration information for custom Salesforce knowledge
        /// articles.</p>
        pub fn set_custom_knowledge_article_type_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration>,
            >,
        ) -> Self {
            self.custom_knowledge_article_type_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceKnowledgeArticleConfiguration`](crate::model::SalesforceKnowledgeArticleConfiguration)
        pub fn build(self) -> crate::model::SalesforceKnowledgeArticleConfiguration {
            crate::model::SalesforceKnowledgeArticleConfiguration {
                included_states: self.included_states,
                standard_knowledge_article_type_configuration: self
                    .standard_knowledge_article_type_configuration,
                custom_knowledge_article_type_configurations: self
                    .custom_knowledge_article_type_configurations,
            }
        }
    }
}
impl SalesforceKnowledgeArticleConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceKnowledgeArticleConfiguration`](crate::model::SalesforceKnowledgeArticleConfiguration)
    pub fn builder() -> crate::model::salesforce_knowledge_article_configuration::Builder {
        crate::model::salesforce_knowledge_article_configuration::Builder::default()
    }
}

/// <p>Provides configuration information for indexing Salesforce custom
/// articles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceCustomKnowledgeArticleTypeConfiguration {
    /// <p>The name of the configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the field in the custom knowledge article that
    /// contains the document data to index.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the field in the custom knowledge article that
    /// contains the document title.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>One or more objects that map fields in the custom knowledge
    /// article to fields in the Amazon Kendra index.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl SalesforceCustomKnowledgeArticleTypeConfiguration {
    /// <p>The name of the configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the field in the custom knowledge article that
    /// contains the document data to index.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the field in the custom knowledge article that
    /// contains the document title.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>One or more objects that map fields in the custom knowledge
    /// article to fields in the Amazon Kendra index.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for SalesforceCustomKnowledgeArticleTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceCustomKnowledgeArticleTypeConfiguration");
        formatter.field("name", &self.name);
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`SalesforceCustomKnowledgeArticleTypeConfiguration`](crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration)
pub mod salesforce_custom_knowledge_article_type_configuration {
    /// A builder for [`SalesforceCustomKnowledgeArticleTypeConfiguration`](crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>The name of the configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the field in the custom knowledge article that
        /// contains the document data to index.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field in the custom knowledge article that
        /// contains the document data to index.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the field in the custom knowledge article that
        /// contains the document title.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field in the custom knowledge article that
        /// contains the document title.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>One or more objects that map fields in the custom knowledge
        /// article to fields in the Amazon Kendra index.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>One or more objects that map fields in the custom knowledge
        /// article to fields in the Amazon Kendra index.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceCustomKnowledgeArticleTypeConfiguration`](crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration)
        pub fn build(self) -> crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration {
            crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration {
                name: self.name,
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl SalesforceCustomKnowledgeArticleTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceCustomKnowledgeArticleTypeConfiguration`](crate::model::SalesforceCustomKnowledgeArticleTypeConfiguration)
    pub fn builder() -> crate::model::salesforce_custom_knowledge_article_type_configuration::Builder
    {
        crate::model::salesforce_custom_knowledge_article_type_configuration::Builder::default()
    }
}

/// <p>Provides configuration information for standard Salesforce
/// knowledge articles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceStandardKnowledgeArticleTypeConfiguration {
    /// <p>The name of the field that contains the document data to
    /// index.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the field that contains the document title.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>One or more objects that map fields in the knowledge article to
    /// Amazon Kendra index fields. The index field must exist before you can map
    /// a Salesforce field to it.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl SalesforceStandardKnowledgeArticleTypeConfiguration {
    /// <p>The name of the field that contains the document data to
    /// index.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the field that contains the document title.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>One or more objects that map fields in the knowledge article to
    /// Amazon Kendra index fields. The index field must exist before you can map
    /// a Salesforce field to it.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for SalesforceStandardKnowledgeArticleTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceStandardKnowledgeArticleTypeConfiguration");
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`SalesforceStandardKnowledgeArticleTypeConfiguration`](crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration)
pub mod salesforce_standard_knowledge_article_type_configuration {
    /// A builder for [`SalesforceStandardKnowledgeArticleTypeConfiguration`](crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>The name of the field that contains the document data to
        /// index.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field that contains the document data to
        /// index.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the field that contains the document title.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field that contains the document title.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>One or more objects that map fields in the knowledge article to
        /// Amazon Kendra index fields. The index field must exist before you can map
        /// a Salesforce field to it.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>One or more objects that map fields in the knowledge article to
        /// Amazon Kendra index fields. The index field must exist before you can map
        /// a Salesforce field to it.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceStandardKnowledgeArticleTypeConfiguration`](crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration)
        pub fn build(self) -> crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration {
            crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration {
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl SalesforceStandardKnowledgeArticleTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceStandardKnowledgeArticleTypeConfiguration`](crate::model::SalesforceStandardKnowledgeArticleTypeConfiguration)
    pub fn builder(
    ) -> crate::model::salesforce_standard_knowledge_article_type_configuration::Builder {
        crate::model::salesforce_standard_knowledge_article_type_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SalesforceKnowledgeArticleState {
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Published,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SalesforceKnowledgeArticleState {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVED" => SalesforceKnowledgeArticleState::Archived,
            "DRAFT" => SalesforceKnowledgeArticleState::Draft,
            "PUBLISHED" => SalesforceKnowledgeArticleState::Published,
            other => SalesforceKnowledgeArticleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SalesforceKnowledgeArticleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SalesforceKnowledgeArticleState::from(s))
    }
}
impl SalesforceKnowledgeArticleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SalesforceKnowledgeArticleState::Archived => "ARCHIVED",
            SalesforceKnowledgeArticleState::Draft => "DRAFT",
            SalesforceKnowledgeArticleState::Published => "PUBLISHED",
            SalesforceKnowledgeArticleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVED", "DRAFT", "PUBLISHED"]
    }
}
impl AsRef<str> for SalesforceKnowledgeArticleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies configuration information for indexing a single standard
/// object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceStandardObjectConfiguration {
    /// <p>The name of the standard object.</p>
    pub name: std::option::Option<crate::model::SalesforceStandardObjectName>,
    /// <p>The name of the field in the standard object table that contains
    /// the document contents.</p>
    pub document_data_field_name: std::option::Option<std::string::String>,
    /// <p>The name of the field in the standard object table that contains
    /// the document title.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>One or more objects that map fields in the standard object to
    /// Amazon Kendra index fields. The index field must exist before you can map
    /// a Salesforce field to it.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
}
impl SalesforceStandardObjectConfiguration {
    /// <p>The name of the standard object.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SalesforceStandardObjectName> {
        self.name.as_ref()
    }
    /// <p>The name of the field in the standard object table that contains
    /// the document contents.</p>
    pub fn document_data_field_name(&self) -> std::option::Option<&str> {
        self.document_data_field_name.as_deref()
    }
    /// <p>The name of the field in the standard object table that contains
    /// the document title.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>One or more objects that map fields in the standard object to
    /// Amazon Kendra index fields. The index field must exist before you can map
    /// a Salesforce field to it.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
}
impl std::fmt::Debug for SalesforceStandardObjectConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceStandardObjectConfiguration");
        formatter.field("name", &self.name);
        formatter.field("document_data_field_name", &self.document_data_field_name);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.finish()
    }
}
/// See [`SalesforceStandardObjectConfiguration`](crate::model::SalesforceStandardObjectConfiguration)
pub mod salesforce_standard_object_configuration {
    /// A builder for [`SalesforceStandardObjectConfiguration`](crate::model::SalesforceStandardObjectConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SalesforceStandardObjectName>,
        pub(crate) document_data_field_name: std::option::Option<std::string::String>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    }
    impl Builder {
        /// <p>The name of the standard object.</p>
        pub fn name(mut self, input: crate::model::SalesforceStandardObjectName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the standard object.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SalesforceStandardObjectName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the field in the standard object table that contains
        /// the document contents.</p>
        pub fn document_data_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field in the standard object table that contains
        /// the document contents.</p>
        pub fn set_document_data_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_field_name = input;
            self
        }
        /// <p>The name of the field in the standard object table that contains
        /// the document title.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The name of the field in the standard object table that contains
        /// the document title.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>One or more objects that map fields in the standard object to
        /// Amazon Kendra index fields. The index field must exist before you can map
        /// a Salesforce field to it.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>One or more objects that map fields in the standard object to
        /// Amazon Kendra index fields. The index field must exist before you can map
        /// a Salesforce field to it.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceStandardObjectConfiguration`](crate::model::SalesforceStandardObjectConfiguration)
        pub fn build(self) -> crate::model::SalesforceStandardObjectConfiguration {
            crate::model::SalesforceStandardObjectConfiguration {
                name: self.name,
                document_data_field_name: self.document_data_field_name,
                document_title_field_name: self.document_title_field_name,
                field_mappings: self.field_mappings,
            }
        }
    }
}
impl SalesforceStandardObjectConfiguration {
    /// Creates a new builder-style object to manufacture [`SalesforceStandardObjectConfiguration`](crate::model::SalesforceStandardObjectConfiguration)
    pub fn builder() -> crate::model::salesforce_standard_object_configuration::Builder {
        crate::model::salesforce_standard_object_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SalesforceStandardObjectName {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Campaign,
    #[allow(missing_docs)] // documentation missing in model
    Case,
    #[allow(missing_docs)] // documentation missing in model
    Contact,
    #[allow(missing_docs)] // documentation missing in model
    Contract,
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Idea,
    #[allow(missing_docs)] // documentation missing in model
    Lead,
    #[allow(missing_docs)] // documentation missing in model
    Opportunity,
    #[allow(missing_docs)] // documentation missing in model
    Partner,
    #[allow(missing_docs)] // documentation missing in model
    Pricebook,
    #[allow(missing_docs)] // documentation missing in model
    Product,
    #[allow(missing_docs)] // documentation missing in model
    Profile,
    #[allow(missing_docs)] // documentation missing in model
    Solution,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SalesforceStandardObjectName {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => SalesforceStandardObjectName::Account,
            "CAMPAIGN" => SalesforceStandardObjectName::Campaign,
            "CASE" => SalesforceStandardObjectName::Case,
            "CONTACT" => SalesforceStandardObjectName::Contact,
            "CONTRACT" => SalesforceStandardObjectName::Contract,
            "DOCUMENT" => SalesforceStandardObjectName::Document,
            "GROUP" => SalesforceStandardObjectName::Group,
            "IDEA" => SalesforceStandardObjectName::Idea,
            "LEAD" => SalesforceStandardObjectName::Lead,
            "OPPORTUNITY" => SalesforceStandardObjectName::Opportunity,
            "PARTNER" => SalesforceStandardObjectName::Partner,
            "PRICEBOOK" => SalesforceStandardObjectName::Pricebook,
            "PRODUCT" => SalesforceStandardObjectName::Product,
            "PROFILE" => SalesforceStandardObjectName::Profile,
            "SOLUTION" => SalesforceStandardObjectName::Solution,
            "TASK" => SalesforceStandardObjectName::Task,
            "USER" => SalesforceStandardObjectName::User,
            other => SalesforceStandardObjectName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SalesforceStandardObjectName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SalesforceStandardObjectName::from(s))
    }
}
impl SalesforceStandardObjectName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SalesforceStandardObjectName::Account => "ACCOUNT",
            SalesforceStandardObjectName::Campaign => "CAMPAIGN",
            SalesforceStandardObjectName::Case => "CASE",
            SalesforceStandardObjectName::Contact => "CONTACT",
            SalesforceStandardObjectName::Contract => "CONTRACT",
            SalesforceStandardObjectName::Document => "DOCUMENT",
            SalesforceStandardObjectName::Group => "GROUP",
            SalesforceStandardObjectName::Idea => "IDEA",
            SalesforceStandardObjectName::Lead => "LEAD",
            SalesforceStandardObjectName::Opportunity => "OPPORTUNITY",
            SalesforceStandardObjectName::Partner => "PARTNER",
            SalesforceStandardObjectName::Pricebook => "PRICEBOOK",
            SalesforceStandardObjectName::Product => "PRODUCT",
            SalesforceStandardObjectName::Profile => "PROFILE",
            SalesforceStandardObjectName::Solution => "SOLUTION",
            SalesforceStandardObjectName::Task => "TASK",
            SalesforceStandardObjectName::User => "USER",
            SalesforceStandardObjectName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT",
            "CAMPAIGN",
            "CASE",
            "CONTACT",
            "CONTRACT",
            "DOCUMENT",
            "GROUP",
            "IDEA",
            "LEAD",
            "OPPORTUNITY",
            "PARTNER",
            "PRICEBOOK",
            "PRODUCT",
            "PROFILE",
            "SOLUTION",
            "TASK",
            "USER",
        ]
    }
}
impl AsRef<str> for SalesforceStandardObjectName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the information necessary to connect a database to an
/// index. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseConfiguration {
    /// <p>The type of database engine that runs the database.</p>
    pub database_engine_type: std::option::Option<crate::model::DatabaseEngineType>,
    /// <p>The information necessary to connect to a database.</p>
    pub connection_configuration: std::option::Option<crate::model::ConnectionConfiguration>,
    /// <p>Provides information for connecting to an Amazon VPC.</p>
    pub vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
    /// <p>Information about where the index should get the document
    /// information from the database.</p>
    pub column_configuration: std::option::Option<crate::model::ColumnConfiguration>,
    /// <p>Information about the database column that provides information
    /// for user context filtering.</p>
    pub acl_configuration: std::option::Option<crate::model::AclConfiguration>,
    /// <p>Provides information about how Amazon Kendra uses quote marks around SQL
    /// identifiers when querying a database data source.</p>
    pub sql_configuration: std::option::Option<crate::model::SqlConfiguration>,
}
impl DatabaseConfiguration {
    /// <p>The type of database engine that runs the database.</p>
    pub fn database_engine_type(&self) -> std::option::Option<&crate::model::DatabaseEngineType> {
        self.database_engine_type.as_ref()
    }
    /// <p>The information necessary to connect to a database.</p>
    pub fn connection_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionConfiguration> {
        self.connection_configuration.as_ref()
    }
    /// <p>Provides information for connecting to an Amazon VPC.</p>
    pub fn vpc_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceVpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p>Information about where the index should get the document
    /// information from the database.</p>
    pub fn column_configuration(&self) -> std::option::Option<&crate::model::ColumnConfiguration> {
        self.column_configuration.as_ref()
    }
    /// <p>Information about the database column that provides information
    /// for user context filtering.</p>
    pub fn acl_configuration(&self) -> std::option::Option<&crate::model::AclConfiguration> {
        self.acl_configuration.as_ref()
    }
    /// <p>Provides information about how Amazon Kendra uses quote marks around SQL
    /// identifiers when querying a database data source.</p>
    pub fn sql_configuration(&self) -> std::option::Option<&crate::model::SqlConfiguration> {
        self.sql_configuration.as_ref()
    }
}
impl std::fmt::Debug for DatabaseConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseConfiguration");
        formatter.field("database_engine_type", &self.database_engine_type);
        formatter.field("connection_configuration", &self.connection_configuration);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field("column_configuration", &self.column_configuration);
        formatter.field("acl_configuration", &self.acl_configuration);
        formatter.field("sql_configuration", &self.sql_configuration);
        formatter.finish()
    }
}
/// See [`DatabaseConfiguration`](crate::model::DatabaseConfiguration)
pub mod database_configuration {
    /// A builder for [`DatabaseConfiguration`](crate::model::DatabaseConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_engine_type: std::option::Option<crate::model::DatabaseEngineType>,
        pub(crate) connection_configuration:
            std::option::Option<crate::model::ConnectionConfiguration>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        pub(crate) column_configuration: std::option::Option<crate::model::ColumnConfiguration>,
        pub(crate) acl_configuration: std::option::Option<crate::model::AclConfiguration>,
        pub(crate) sql_configuration: std::option::Option<crate::model::SqlConfiguration>,
    }
    impl Builder {
        /// <p>The type of database engine that runs the database.</p>
        pub fn database_engine_type(mut self, input: crate::model::DatabaseEngineType) -> Self {
            self.database_engine_type = Some(input);
            self
        }
        /// <p>The type of database engine that runs the database.</p>
        pub fn set_database_engine_type(
            mut self,
            input: std::option::Option<crate::model::DatabaseEngineType>,
        ) -> Self {
            self.database_engine_type = input;
            self
        }
        /// <p>The information necessary to connect to a database.</p>
        pub fn connection_configuration(
            mut self,
            input: crate::model::ConnectionConfiguration,
        ) -> Self {
            self.connection_configuration = Some(input);
            self
        }
        /// <p>The information necessary to connect to a database.</p>
        pub fn set_connection_configuration(
            mut self,
            input: std::option::Option<crate::model::ConnectionConfiguration>,
        ) -> Self {
            self.connection_configuration = input;
            self
        }
        /// <p>Provides information for connecting to an Amazon VPC.</p>
        pub fn vpc_configuration(
            mut self,
            input: crate::model::DataSourceVpcConfiguration,
        ) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>Provides information for connecting to an Amazon VPC.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// <p>Information about where the index should get the document
        /// information from the database.</p>
        pub fn column_configuration(mut self, input: crate::model::ColumnConfiguration) -> Self {
            self.column_configuration = Some(input);
            self
        }
        /// <p>Information about where the index should get the document
        /// information from the database.</p>
        pub fn set_column_configuration(
            mut self,
            input: std::option::Option<crate::model::ColumnConfiguration>,
        ) -> Self {
            self.column_configuration = input;
            self
        }
        /// <p>Information about the database column that provides information
        /// for user context filtering.</p>
        pub fn acl_configuration(mut self, input: crate::model::AclConfiguration) -> Self {
            self.acl_configuration = Some(input);
            self
        }
        /// <p>Information about the database column that provides information
        /// for user context filtering.</p>
        pub fn set_acl_configuration(
            mut self,
            input: std::option::Option<crate::model::AclConfiguration>,
        ) -> Self {
            self.acl_configuration = input;
            self
        }
        /// <p>Provides information about how Amazon Kendra uses quote marks around SQL
        /// identifiers when querying a database data source.</p>
        pub fn sql_configuration(mut self, input: crate::model::SqlConfiguration) -> Self {
            self.sql_configuration = Some(input);
            self
        }
        /// <p>Provides information about how Amazon Kendra uses quote marks around SQL
        /// identifiers when querying a database data source.</p>
        pub fn set_sql_configuration(
            mut self,
            input: std::option::Option<crate::model::SqlConfiguration>,
        ) -> Self {
            self.sql_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseConfiguration`](crate::model::DatabaseConfiguration)
        pub fn build(self) -> crate::model::DatabaseConfiguration {
            crate::model::DatabaseConfiguration {
                database_engine_type: self.database_engine_type,
                connection_configuration: self.connection_configuration,
                vpc_configuration: self.vpc_configuration,
                column_configuration: self.column_configuration,
                acl_configuration: self.acl_configuration,
                sql_configuration: self.sql_configuration,
            }
        }
    }
}
impl DatabaseConfiguration {
    /// Creates a new builder-style object to manufacture [`DatabaseConfiguration`](crate::model::DatabaseConfiguration)
    pub fn builder() -> crate::model::database_configuration::Builder {
        crate::model::database_configuration::Builder::default()
    }
}

/// <p>Provides information that configures Amazon Kendra to use a SQL
/// database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlConfiguration {
    /// <p>Determines whether Amazon Kendra encloses SQL identifiers for tables and
    /// column names in double quotes (") when making a database
    /// query.</p>
    /// <p>By default, Amazon Kendra passes SQL identifiers the way that they are
    /// entered into the data source configuration. It does not change the
    /// case of identifiers or enclose them in quotes.</p>
    /// <p>PostgreSQL internally converts uppercase characters to lower case
    /// characters in identifiers unless they are quoted. Choosing this
    /// option encloses identifiers in quotes so that PostgreSQL does not
    /// convert the character's case.</p>
    /// <p>For MySQL databases, you must enable the <code>ansi_quotes</code>
    /// option when you set this field to <code>DOUBLE_QUOTES</code>.</p>
    pub query_identifiers_enclosing_option:
        std::option::Option<crate::model::QueryIdentifiersEnclosingOption>,
}
impl SqlConfiguration {
    /// <p>Determines whether Amazon Kendra encloses SQL identifiers for tables and
    /// column names in double quotes (") when making a database
    /// query.</p>
    /// <p>By default, Amazon Kendra passes SQL identifiers the way that they are
    /// entered into the data source configuration. It does not change the
    /// case of identifiers or enclose them in quotes.</p>
    /// <p>PostgreSQL internally converts uppercase characters to lower case
    /// characters in identifiers unless they are quoted. Choosing this
    /// option encloses identifiers in quotes so that PostgreSQL does not
    /// convert the character's case.</p>
    /// <p>For MySQL databases, you must enable the <code>ansi_quotes</code>
    /// option when you set this field to <code>DOUBLE_QUOTES</code>.</p>
    pub fn query_identifiers_enclosing_option(
        &self,
    ) -> std::option::Option<&crate::model::QueryIdentifiersEnclosingOption> {
        self.query_identifiers_enclosing_option.as_ref()
    }
}
impl std::fmt::Debug for SqlConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlConfiguration");
        formatter.field(
            "query_identifiers_enclosing_option",
            &self.query_identifiers_enclosing_option,
        );
        formatter.finish()
    }
}
/// See [`SqlConfiguration`](crate::model::SqlConfiguration)
pub mod sql_configuration {
    /// A builder for [`SqlConfiguration`](crate::model::SqlConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_identifiers_enclosing_option:
            std::option::Option<crate::model::QueryIdentifiersEnclosingOption>,
    }
    impl Builder {
        /// <p>Determines whether Amazon Kendra encloses SQL identifiers for tables and
        /// column names in double quotes (") when making a database
        /// query.</p>
        /// <p>By default, Amazon Kendra passes SQL identifiers the way that they are
        /// entered into the data source configuration. It does not change the
        /// case of identifiers or enclose them in quotes.</p>
        /// <p>PostgreSQL internally converts uppercase characters to lower case
        /// characters in identifiers unless they are quoted. Choosing this
        /// option encloses identifiers in quotes so that PostgreSQL does not
        /// convert the character's case.</p>
        /// <p>For MySQL databases, you must enable the <code>ansi_quotes</code>
        /// option when you set this field to <code>DOUBLE_QUOTES</code>.</p>
        pub fn query_identifiers_enclosing_option(
            mut self,
            input: crate::model::QueryIdentifiersEnclosingOption,
        ) -> Self {
            self.query_identifiers_enclosing_option = Some(input);
            self
        }
        /// <p>Determines whether Amazon Kendra encloses SQL identifiers for tables and
        /// column names in double quotes (") when making a database
        /// query.</p>
        /// <p>By default, Amazon Kendra passes SQL identifiers the way that they are
        /// entered into the data source configuration. It does not change the
        /// case of identifiers or enclose them in quotes.</p>
        /// <p>PostgreSQL internally converts uppercase characters to lower case
        /// characters in identifiers unless they are quoted. Choosing this
        /// option encloses identifiers in quotes so that PostgreSQL does not
        /// convert the character's case.</p>
        /// <p>For MySQL databases, you must enable the <code>ansi_quotes</code>
        /// option when you set this field to <code>DOUBLE_QUOTES</code>.</p>
        pub fn set_query_identifiers_enclosing_option(
            mut self,
            input: std::option::Option<crate::model::QueryIdentifiersEnclosingOption>,
        ) -> Self {
            self.query_identifiers_enclosing_option = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlConfiguration`](crate::model::SqlConfiguration)
        pub fn build(self) -> crate::model::SqlConfiguration {
            crate::model::SqlConfiguration {
                query_identifiers_enclosing_option: self.query_identifiers_enclosing_option,
            }
        }
    }
}
impl SqlConfiguration {
    /// Creates a new builder-style object to manufacture [`SqlConfiguration`](crate::model::SqlConfiguration)
    pub fn builder() -> crate::model::sql_configuration::Builder {
        crate::model::sql_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryIdentifiersEnclosingOption {
    #[allow(missing_docs)] // documentation missing in model
    DoubleQuotes,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryIdentifiersEnclosingOption {
    fn from(s: &str) -> Self {
        match s {
            "DOUBLE_QUOTES" => QueryIdentifiersEnclosingOption::DoubleQuotes,
            "NONE" => QueryIdentifiersEnclosingOption::None,
            other => QueryIdentifiersEnclosingOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryIdentifiersEnclosingOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryIdentifiersEnclosingOption::from(s))
    }
}
impl QueryIdentifiersEnclosingOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryIdentifiersEnclosingOption::DoubleQuotes => "DOUBLE_QUOTES",
            QueryIdentifiersEnclosingOption::None => "NONE",
            QueryIdentifiersEnclosingOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOUBLE_QUOTES", "NONE"]
    }
}
impl AsRef<str> for QueryIdentifiersEnclosingOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the column that should be used for
/// filtering the query response by groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AclConfiguration {
    /// <p>A list of groups, separated by semi-colons, that filters a query
    /// response based on user context. The document is only returned to
    /// users that are in one of the groups specified in the
    /// <code>UserContext</code> field of the <code>Query</code>
    /// operation.</p>
    pub allowed_groups_column_name: std::option::Option<std::string::String>,
}
impl AclConfiguration {
    /// <p>A list of groups, separated by semi-colons, that filters a query
    /// response based on user context. The document is only returned to
    /// users that are in one of the groups specified in the
    /// <code>UserContext</code> field of the <code>Query</code>
    /// operation.</p>
    pub fn allowed_groups_column_name(&self) -> std::option::Option<&str> {
        self.allowed_groups_column_name.as_deref()
    }
}
impl std::fmt::Debug for AclConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AclConfiguration");
        formatter.field(
            "allowed_groups_column_name",
            &self.allowed_groups_column_name,
        );
        formatter.finish()
    }
}
/// See [`AclConfiguration`](crate::model::AclConfiguration)
pub mod acl_configuration {
    /// A builder for [`AclConfiguration`](crate::model::AclConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_groups_column_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of groups, separated by semi-colons, that filters a query
        /// response based on user context. The document is only returned to
        /// users that are in one of the groups specified in the
        /// <code>UserContext</code> field of the <code>Query</code>
        /// operation.</p>
        pub fn allowed_groups_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_groups_column_name = Some(input.into());
            self
        }
        /// <p>A list of groups, separated by semi-colons, that filters a query
        /// response based on user context. The document is only returned to
        /// users that are in one of the groups specified in the
        /// <code>UserContext</code> field of the <code>Query</code>
        /// operation.</p>
        pub fn set_allowed_groups_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_groups_column_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AclConfiguration`](crate::model::AclConfiguration)
        pub fn build(self) -> crate::model::AclConfiguration {
            crate::model::AclConfiguration {
                allowed_groups_column_name: self.allowed_groups_column_name,
            }
        }
    }
}
impl AclConfiguration {
    /// Creates a new builder-style object to manufacture [`AclConfiguration`](crate::model::AclConfiguration)
    pub fn builder() -> crate::model::acl_configuration::Builder {
        crate::model::acl_configuration::Builder::default()
    }
}

/// <p>Provides information about how Amazon Kendra should use the columns of
/// a database in an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnConfiguration {
    /// <p>The column that provides the document's unique identifier.</p>
    pub document_id_column_name: std::option::Option<std::string::String>,
    /// <p>The column that contains the contents of the document.</p>
    pub document_data_column_name: std::option::Option<std::string::String>,
    /// <p>The column that contains the title of the document.</p>
    pub document_title_column_name: std::option::Option<std::string::String>,
    /// <p>An array of objects that map database column names to the
    /// corresponding fields in an index. You must first create the fields
    /// in the index using the <code>UpdateIndex</code> operation.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>One to five columns that indicate when a document in the database
    /// has changed.</p>
    pub change_detecting_columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ColumnConfiguration {
    /// <p>The column that provides the document's unique identifier.</p>
    pub fn document_id_column_name(&self) -> std::option::Option<&str> {
        self.document_id_column_name.as_deref()
    }
    /// <p>The column that contains the contents of the document.</p>
    pub fn document_data_column_name(&self) -> std::option::Option<&str> {
        self.document_data_column_name.as_deref()
    }
    /// <p>The column that contains the title of the document.</p>
    pub fn document_title_column_name(&self) -> std::option::Option<&str> {
        self.document_title_column_name.as_deref()
    }
    /// <p>An array of objects that map database column names to the
    /// corresponding fields in an index. You must first create the fields
    /// in the index using the <code>UpdateIndex</code> operation.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>One to five columns that indicate when a document in the database
    /// has changed.</p>
    pub fn change_detecting_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.change_detecting_columns.as_deref()
    }
}
impl std::fmt::Debug for ColumnConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnConfiguration");
        formatter.field("document_id_column_name", &self.document_id_column_name);
        formatter.field("document_data_column_name", &self.document_data_column_name);
        formatter.field(
            "document_title_column_name",
            &self.document_title_column_name,
        );
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("change_detecting_columns", &self.change_detecting_columns);
        formatter.finish()
    }
}
/// See [`ColumnConfiguration`](crate::model::ColumnConfiguration)
pub mod column_configuration {
    /// A builder for [`ColumnConfiguration`](crate::model::ColumnConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_id_column_name: std::option::Option<std::string::String>,
        pub(crate) document_data_column_name: std::option::Option<std::string::String>,
        pub(crate) document_title_column_name: std::option::Option<std::string::String>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) change_detecting_columns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The column that provides the document's unique identifier.</p>
        pub fn document_id_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id_column_name = Some(input.into());
            self
        }
        /// <p>The column that provides the document's unique identifier.</p>
        pub fn set_document_id_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_id_column_name = input;
            self
        }
        /// <p>The column that contains the contents of the document.</p>
        pub fn document_data_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_data_column_name = Some(input.into());
            self
        }
        /// <p>The column that contains the contents of the document.</p>
        pub fn set_document_data_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_data_column_name = input;
            self
        }
        /// <p>The column that contains the title of the document.</p>
        pub fn document_title_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_column_name = Some(input.into());
            self
        }
        /// <p>The column that contains the title of the document.</p>
        pub fn set_document_title_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_column_name = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>An array of objects that map database column names to the
        /// corresponding fields in an index. You must first create the fields
        /// in the index using the <code>UpdateIndex</code> operation.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>An array of objects that map database column names to the
        /// corresponding fields in an index. You must first create the fields
        /// in the index using the <code>UpdateIndex</code> operation.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// Appends an item to `change_detecting_columns`.
        ///
        /// To override the contents of this collection use [`set_change_detecting_columns`](Self::set_change_detecting_columns).
        ///
        /// <p>One to five columns that indicate when a document in the database
        /// has changed.</p>
        pub fn change_detecting_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.change_detecting_columns.unwrap_or_default();
            v.push(input.into());
            self.change_detecting_columns = Some(v);
            self
        }
        /// <p>One to five columns that indicate when a document in the database
        /// has changed.</p>
        pub fn set_change_detecting_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.change_detecting_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnConfiguration`](crate::model::ColumnConfiguration)
        pub fn build(self) -> crate::model::ColumnConfiguration {
            crate::model::ColumnConfiguration {
                document_id_column_name: self.document_id_column_name,
                document_data_column_name: self.document_data_column_name,
                document_title_column_name: self.document_title_column_name,
                field_mappings: self.field_mappings,
                change_detecting_columns: self.change_detecting_columns,
            }
        }
    }
}
impl ColumnConfiguration {
    /// Creates a new builder-style object to manufacture [`ColumnConfiguration`](crate::model::ColumnConfiguration)
    pub fn builder() -> crate::model::column_configuration::Builder {
        crate::model::column_configuration::Builder::default()
    }
}

/// <p>Provides the information necessary to connect to a
/// database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionConfiguration {
    /// <p>The name of the host for the database. Can be either a string
    /// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>
    pub database_host: std::option::Option<std::string::String>,
    /// <p>The port that the database uses for connections.</p>
    pub database_port: std::option::Option<i32>,
    /// <p>The name of the database containing the document data.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table that contains the document data.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
    /// The credentials should be a user/password pair. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a
    /// Database Data Source</a>. For more information about
    /// Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
    /// Secrets Manager</a> in the <i> Secrets Manager
    /// </i> user guide.</p>
    pub secret_arn: std::option::Option<std::string::String>,
}
impl ConnectionConfiguration {
    /// <p>The name of the host for the database. Can be either a string
    /// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>
    pub fn database_host(&self) -> std::option::Option<&str> {
        self.database_host.as_deref()
    }
    /// <p>The port that the database uses for connections.</p>
    pub fn database_port(&self) -> std::option::Option<i32> {
        self.database_port
    }
    /// <p>The name of the database containing the document data.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table that contains the document data.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
    /// The credentials should be a user/password pair. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a
    /// Database Data Source</a>. For more information about
    /// Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
    /// Secrets Manager</a> in the <i> Secrets Manager
    /// </i> user guide.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
}
impl std::fmt::Debug for ConnectionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionConfiguration");
        formatter.field("database_host", &self.database_host);
        formatter.field("database_port", &self.database_port);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.finish()
    }
}
/// See [`ConnectionConfiguration`](crate::model::ConnectionConfiguration)
pub mod connection_configuration {
    /// A builder for [`ConnectionConfiguration`](crate::model::ConnectionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_host: std::option::Option<std::string::String>,
        pub(crate) database_port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the host for the database. Can be either a string
        /// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>
        pub fn database_host(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_host = Some(input.into());
            self
        }
        /// <p>The name of the host for the database. Can be either a string
        /// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>
        pub fn set_database_host(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_host = input;
            self
        }
        /// <p>The port that the database uses for connections.</p>
        pub fn database_port(mut self, input: i32) -> Self {
            self.database_port = Some(input);
            self
        }
        /// <p>The port that the database uses for connections.</p>
        pub fn set_database_port(mut self, input: std::option::Option<i32>) -> Self {
            self.database_port = input;
            self
        }
        /// <p>The name of the database containing the document data.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database containing the document data.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table that contains the document data.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table that contains the document data.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
        /// The credentials should be a user/password pair. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a
        /// Database Data Source</a>. For more information about
        /// Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
        /// Secrets Manager</a> in the <i> Secrets Manager
        /// </i> user guide.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager.
        /// The credentials should be a user/password pair. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a
        /// Database Data Source</a>. For more information about
        /// Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
        /// Secrets Manager</a> in the <i> Secrets Manager
        /// </i> user guide.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionConfiguration`](crate::model::ConnectionConfiguration)
        pub fn build(self) -> crate::model::ConnectionConfiguration {
            crate::model::ConnectionConfiguration {
                database_host: self.database_host,
                database_port: self.database_port,
                database_name: self.database_name,
                table_name: self.table_name,
                secret_arn: self.secret_arn,
            }
        }
    }
}
impl ConnectionConfiguration {
    /// Creates a new builder-style object to manufacture [`ConnectionConfiguration`](crate::model::ConnectionConfiguration)
    pub fn builder() -> crate::model::connection_configuration::Builder {
        crate::model::connection_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatabaseEngineType {
    #[allow(missing_docs)] // documentation missing in model
    RdsAuroraMysql,
    #[allow(missing_docs)] // documentation missing in model
    RdsAuroraPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    RdsMysql,
    #[allow(missing_docs)] // documentation missing in model
    RdsPostgresql,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatabaseEngineType {
    fn from(s: &str) -> Self {
        match s {
            "RDS_AURORA_MYSQL" => DatabaseEngineType::RdsAuroraMysql,
            "RDS_AURORA_POSTGRESQL" => DatabaseEngineType::RdsAuroraPostgresql,
            "RDS_MYSQL" => DatabaseEngineType::RdsMysql,
            "RDS_POSTGRESQL" => DatabaseEngineType::RdsPostgresql,
            other => DatabaseEngineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatabaseEngineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatabaseEngineType::from(s))
    }
}
impl DatabaseEngineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatabaseEngineType::RdsAuroraMysql => "RDS_AURORA_MYSQL",
            DatabaseEngineType::RdsAuroraPostgresql => "RDS_AURORA_POSTGRESQL",
            DatabaseEngineType::RdsMysql => "RDS_MYSQL",
            DatabaseEngineType::RdsPostgresql => "RDS_POSTGRESQL",
            DatabaseEngineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "RDS_AURORA_MYSQL",
            "RDS_AURORA_POSTGRESQL",
            "RDS_MYSQL",
            "RDS_POSTGRESQL",
        ]
    }
}
impl AsRef<str> for DatabaseEngineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for connecting to a Microsoft
/// SharePoint data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharePointConfiguration {
    /// <p>The version of Microsoft SharePoint that you are using as a data
    /// source.</p>
    pub share_point_version: std::option::Option<crate::model::SharePointVersion>,
    /// <p>The URLs of the Microsoft SharePoint site that contains the
    /// documents that should be indexed.</p>
    pub urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of credentials stored in
    /// Secrets Manager. The credentials should be a user/password pair.
    /// If you use SharePoint Server, you also need to provide the sever
    /// domain name as part of the credentials. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
    /// Microsoft SharePoint Data Source</a>. For more information
    /// about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
    /// Secrets Manager</a> in the <i>Secrets Manager
    /// </i> user guide.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>
    /// <code>TRUE</code> to include attachments to documents stored in
    /// your Microsoft SharePoint site in the index; otherwise,
    /// <code>FALSE</code>.</p>
    pub crawl_attachments: bool,
    /// <p>Set to <code>TRUE</code> to use the Microsoft SharePoint change
    /// log to determine the documents that need to be updated in the index.
    /// Depending on the size of the SharePoint change log, it may take
    /// longer for Amazon Kendra to use the change log than it takes it to
    /// determine the changed documents using the Amazon Kendra document
    /// crawler.</p>
    pub use_change_log: bool,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the display URL of the SharePoint
    /// document.</p>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the display URL of the SharePoint
    /// document.</p>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides information for connecting to an Amazon VPC.</p>
    pub vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
    /// map Microsoft SharePoint attributes to custom fields in the Amazon Kendra
    /// index. You must first create the index fields using the
    /// <code>UpdateIndex</code> operation before you map SharePoint
    /// attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
    /// Fields</a>.</p>
    pub field_mappings:
        std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
    /// <p>The Microsoft SharePoint attribute field that contains the title
    /// of the document.</p>
    pub document_title_field_name: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether local
    /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
    /// </p>
    pub disable_local_groups: bool,
    /// <p>Information required to find a specific file in an Amazon S3
    /// bucket.</p>
    pub ssl_certificate_s3_path: std::option::Option<crate::model::S3Path>,
}
impl SharePointConfiguration {
    /// <p>The version of Microsoft SharePoint that you are using as a data
    /// source.</p>
    pub fn share_point_version(&self) -> std::option::Option<&crate::model::SharePointVersion> {
        self.share_point_version.as_ref()
    }
    /// <p>The URLs of the Microsoft SharePoint site that contains the
    /// documents that should be indexed.</p>
    pub fn urls(&self) -> std::option::Option<&[std::string::String]> {
        self.urls.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of credentials stored in
    /// Secrets Manager. The credentials should be a user/password pair.
    /// If you use SharePoint Server, you also need to provide the sever
    /// domain name as part of the credentials. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
    /// Microsoft SharePoint Data Source</a>. For more information
    /// about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
    /// Secrets Manager</a> in the <i>Secrets Manager
    /// </i> user guide.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>
    /// <code>TRUE</code> to include attachments to documents stored in
    /// your Microsoft SharePoint site in the index; otherwise,
    /// <code>FALSE</code>.</p>
    pub fn crawl_attachments(&self) -> bool {
        self.crawl_attachments
    }
    /// <p>Set to <code>TRUE</code> to use the Microsoft SharePoint change
    /// log to determine the documents that need to be updated in the index.
    /// Depending on the size of the SharePoint change log, it may take
    /// longer for Amazon Kendra to use the change log than it takes it to
    /// determine the changed documents using the Amazon Kendra document
    /// crawler.</p>
    pub fn use_change_log(&self) -> bool {
        self.use_change_log
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are included in the index. Documents that don't match the
    /// patterns are excluded from the index. If a document matches both an
    /// inclusion pattern and an exclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the display URL of the SharePoint
    /// document.</p>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>A list of regular expression patterns. Documents that match the
    /// patterns are excluded from the index. Documents that don't match the
    /// patterns are included in the index. If a document matches both an
    /// exclusion pattern and an inclusion pattern, the document is not
    /// included in the index.</p>
    /// <p>The regex is applied to the display URL of the SharePoint
    /// document.</p>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
    /// <p>Provides information for connecting to an Amazon VPC.</p>
    pub fn vpc_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceVpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
    /// map Microsoft SharePoint attributes to custom fields in the Amazon Kendra
    /// index. You must first create the index fields using the
    /// <code>UpdateIndex</code> operation before you map SharePoint
    /// attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
    /// Fields</a>.</p>
    pub fn field_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceToIndexFieldMapping]> {
        self.field_mappings.as_deref()
    }
    /// <p>The Microsoft SharePoint attribute field that contains the title
    /// of the document.</p>
    pub fn document_title_field_name(&self) -> std::option::Option<&str> {
        self.document_title_field_name.as_deref()
    }
    /// <p>A Boolean value that specifies whether local
    /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
    /// </p>
    pub fn disable_local_groups(&self) -> bool {
        self.disable_local_groups
    }
    /// <p>Information required to find a specific file in an Amazon S3
    /// bucket.</p>
    pub fn ssl_certificate_s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.ssl_certificate_s3_path.as_ref()
    }
}
impl std::fmt::Debug for SharePointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharePointConfiguration");
        formatter.field("share_point_version", &self.share_point_version);
        formatter.field("urls", &self.urls);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("crawl_attachments", &self.crawl_attachments);
        formatter.field("use_change_log", &self.use_change_log);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field("field_mappings", &self.field_mappings);
        formatter.field("document_title_field_name", &self.document_title_field_name);
        formatter.field("disable_local_groups", &self.disable_local_groups);
        formatter.field("ssl_certificate_s3_path", &self.ssl_certificate_s3_path);
        formatter.finish()
    }
}
/// See [`SharePointConfiguration`](crate::model::SharePointConfiguration)
pub mod share_point_configuration {
    /// A builder for [`SharePointConfiguration`](crate::model::SharePointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_point_version: std::option::Option<crate::model::SharePointVersion>,
        pub(crate) urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) crawl_attachments: std::option::Option<bool>,
        pub(crate) use_change_log: std::option::Option<bool>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        pub(crate) field_mappings:
            std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        pub(crate) document_title_field_name: std::option::Option<std::string::String>,
        pub(crate) disable_local_groups: std::option::Option<bool>,
        pub(crate) ssl_certificate_s3_path: std::option::Option<crate::model::S3Path>,
    }
    impl Builder {
        /// <p>The version of Microsoft SharePoint that you are using as a data
        /// source.</p>
        pub fn share_point_version(mut self, input: crate::model::SharePointVersion) -> Self {
            self.share_point_version = Some(input);
            self
        }
        /// <p>The version of Microsoft SharePoint that you are using as a data
        /// source.</p>
        pub fn set_share_point_version(
            mut self,
            input: std::option::Option<crate::model::SharePointVersion>,
        ) -> Self {
            self.share_point_version = input;
            self
        }
        /// Appends an item to `urls`.
        ///
        /// To override the contents of this collection use [`set_urls`](Self::set_urls).
        ///
        /// <p>The URLs of the Microsoft SharePoint site that contains the
        /// documents that should be indexed.</p>
        pub fn urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.urls.unwrap_or_default();
            v.push(input.into());
            self.urls = Some(v);
            self
        }
        /// <p>The URLs of the Microsoft SharePoint site that contains the
        /// documents that should be indexed.</p>
        pub fn set_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.urls = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of credentials stored in
        /// Secrets Manager. The credentials should be a user/password pair.
        /// If you use SharePoint Server, you also need to provide the sever
        /// domain name as part of the credentials. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
        /// Microsoft SharePoint Data Source</a>. For more information
        /// about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
        /// Secrets Manager</a> in the <i>Secrets Manager
        /// </i> user guide.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of credentials stored in
        /// Secrets Manager. The credentials should be a user/password pair.
        /// If you use SharePoint Server, you also need to provide the sever
        /// domain name as part of the credentials. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
        /// Microsoft SharePoint Data Source</a>. For more information
        /// about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
        /// Secrets Manager</a> in the <i>Secrets Manager
        /// </i> user guide.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>
        /// <code>TRUE</code> to include attachments to documents stored in
        /// your Microsoft SharePoint site in the index; otherwise,
        /// <code>FALSE</code>.</p>
        pub fn crawl_attachments(mut self, input: bool) -> Self {
            self.crawl_attachments = Some(input);
            self
        }
        /// <p>
        /// <code>TRUE</code> to include attachments to documents stored in
        /// your Microsoft SharePoint site in the index; otherwise,
        /// <code>FALSE</code>.</p>
        pub fn set_crawl_attachments(mut self, input: std::option::Option<bool>) -> Self {
            self.crawl_attachments = input;
            self
        }
        /// <p>Set to <code>TRUE</code> to use the Microsoft SharePoint change
        /// log to determine the documents that need to be updated in the index.
        /// Depending on the size of the SharePoint change log, it may take
        /// longer for Amazon Kendra to use the change log than it takes it to
        /// determine the changed documents using the Amazon Kendra document
        /// crawler.</p>
        pub fn use_change_log(mut self, input: bool) -> Self {
            self.use_change_log = Some(input);
            self
        }
        /// <p>Set to <code>TRUE</code> to use the Microsoft SharePoint change
        /// log to determine the documents that need to be updated in the index.
        /// Depending on the size of the SharePoint change log, it may take
        /// longer for Amazon Kendra to use the change log than it takes it to
        /// determine the changed documents using the Amazon Kendra document
        /// crawler.</p>
        pub fn set_use_change_log(mut self, input: std::option::Option<bool>) -> Self {
            self.use_change_log = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the display URL of the SharePoint
        /// document.</p>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are included in the index. Documents that don't match the
        /// patterns are excluded from the index. If a document matches both an
        /// inclusion pattern and an exclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the display URL of the SharePoint
        /// document.</p>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the display URL of the SharePoint
        /// document.</p>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>A list of regular expression patterns. Documents that match the
        /// patterns are excluded from the index. Documents that don't match the
        /// patterns are included in the index. If a document matches both an
        /// exclusion pattern and an inclusion pattern, the document is not
        /// included in the index.</p>
        /// <p>The regex is applied to the display URL of the SharePoint
        /// document.</p>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// <p>Provides information for connecting to an Amazon VPC.</p>
        pub fn vpc_configuration(
            mut self,
            input: crate::model::DataSourceVpcConfiguration,
        ) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>Provides information for connecting to an Amazon VPC.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceVpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Appends an item to `field_mappings`.
        ///
        /// To override the contents of this collection use [`set_field_mappings`](Self::set_field_mappings).
        ///
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
        /// map Microsoft SharePoint attributes to custom fields in the Amazon Kendra
        /// index. You must first create the index fields using the
        /// <code>UpdateIndex</code> operation before you map SharePoint
        /// attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
        /// Fields</a>.</p>
        pub fn field_mappings(
            mut self,
            input: impl Into<crate::model::DataSourceToIndexFieldMapping>,
        ) -> Self {
            let mut v = self.field_mappings.unwrap_or_default();
            v.push(input.into());
            self.field_mappings = Some(v);
            self
        }
        /// <p>A list of <code>DataSourceToIndexFieldMapping</code> objects that
        /// map Microsoft SharePoint attributes to custom fields in the Amazon Kendra
        /// index. You must first create the index fields using the
        /// <code>UpdateIndex</code> operation before you map SharePoint
        /// attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source
        /// Fields</a>.</p>
        pub fn set_field_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceToIndexFieldMapping>>,
        ) -> Self {
            self.field_mappings = input;
            self
        }
        /// <p>The Microsoft SharePoint attribute field that contains the title
        /// of the document.</p>
        pub fn document_title_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_title_field_name = Some(input.into());
            self
        }
        /// <p>The Microsoft SharePoint attribute field that contains the title
        /// of the document.</p>
        pub fn set_document_title_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_title_field_name = input;
            self
        }
        /// <p>A Boolean value that specifies whether local
        /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
        /// </p>
        pub fn disable_local_groups(mut self, input: bool) -> Self {
            self.disable_local_groups = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether local
        /// groups are disabled (<code>True</code>) or enabled (<code>False</code>).
        /// </p>
        pub fn set_disable_local_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_local_groups = input;
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn ssl_certificate_s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.ssl_certificate_s3_path = Some(input);
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn set_ssl_certificate_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.ssl_certificate_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`SharePointConfiguration`](crate::model::SharePointConfiguration)
        pub fn build(self) -> crate::model::SharePointConfiguration {
            crate::model::SharePointConfiguration {
                share_point_version: self.share_point_version,
                urls: self.urls,
                secret_arn: self.secret_arn,
                crawl_attachments: self.crawl_attachments.unwrap_or_default(),
                use_change_log: self.use_change_log.unwrap_or_default(),
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
                vpc_configuration: self.vpc_configuration,
                field_mappings: self.field_mappings,
                document_title_field_name: self.document_title_field_name,
                disable_local_groups: self.disable_local_groups.unwrap_or_default(),
                ssl_certificate_s3_path: self.ssl_certificate_s3_path,
            }
        }
    }
}
impl SharePointConfiguration {
    /// Creates a new builder-style object to manufacture [`SharePointConfiguration`](crate::model::SharePointConfiguration)
    pub fn builder() -> crate::model::share_point_configuration::Builder {
        crate::model::share_point_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SharePointVersion {
    #[allow(missing_docs)] // documentation missing in model
    Sharepoint2013,
    #[allow(missing_docs)] // documentation missing in model
    Sharepoint2016,
    #[allow(missing_docs)] // documentation missing in model
    SharepointOnline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SharePointVersion {
    fn from(s: &str) -> Self {
        match s {
            "SHAREPOINT_2013" => SharePointVersion::Sharepoint2013,
            "SHAREPOINT_2016" => SharePointVersion::Sharepoint2016,
            "SHAREPOINT_ONLINE" => SharePointVersion::SharepointOnline,
            other => SharePointVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SharePointVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SharePointVersion::from(s))
    }
}
impl SharePointVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SharePointVersion::Sharepoint2013 => "SHAREPOINT_2013",
            SharePointVersion::Sharepoint2016 => "SHAREPOINT_2016",
            SharePointVersion::SharepointOnline => "SHAREPOINT_ONLINE",
            SharePointVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHAREPOINT_2013", "SHAREPOINT_2016", "SHAREPOINT_ONLINE"]
    }
}
impl AsRef<str> for SharePointVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for a data source to index
/// documents in an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DataSourceConfiguration {
    /// <p>The name of the bucket that contains the documents.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>A list of S3 prefixes for the documents that should be included in
    /// the index.</p>
    pub inclusion_prefixes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of glob patterns for documents that should be indexed. If a
    /// document that matches an inclusion pattern also matches an exclusion
    /// pattern, the document is not indexed.</p>
    /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>*.txt</i> will include all text files
    /// in a directory (files with the extension .txt).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>**/*.txt</i> will include all text
    /// files in a directory and its subdirectories.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>*tax*</i> will include all files in
    /// a directory that contain 'tax' in the file name, such as 'tax',
    /// 'taxes', 'income_tax'.</p>
    /// </li>
    /// </ul>
    pub inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of glob patterns for documents that should not be indexed.
    /// If a document that matches an inclusion prefix or inclusion pattern
    /// also matches an exclusion pattern, the document is not
    /// indexed.</p>
    /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>*.png , *.jpg</i> will exclude
    /// all PNG and JPEG image files in a directory
    /// (files with the extensions .png and .jpg).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>*internal*</i> will exclude all
    /// files in a directory that contain 'internal' in the file name,
    /// such as 'internal', 'internal_only', 'company_internal'.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>**/*internal*</i> will exclude
    /// all internal-related files in a directory and its subdirectories.</p>
    /// </li>
    /// </ul>
    pub exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Document metadata files that contain information such as the
    /// document access control information, source URI, document author,
    /// and custom attributes. Each metadata file contains metadata about a
    /// single document.</p>
    pub documents_metadata_configuration:
        std::option::Option<crate::model::DocumentsMetadataConfiguration>,
    /// <p>Provides the path to the S3 bucket that contains the user context
    /// filtering files for the data source. For the format of the file, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>
    pub access_control_list_configuration:
        std::option::Option<crate::model::AccessControlListConfiguration>,
}
impl S3DataSourceConfiguration {
    /// <p>The name of the bucket that contains the documents.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>A list of S3 prefixes for the documents that should be included in
    /// the index.</p>
    pub fn inclusion_prefixes(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_prefixes.as_deref()
    }
    /// <p>A list of glob patterns for documents that should be indexed. If a
    /// document that matches an inclusion pattern also matches an exclusion
    /// pattern, the document is not indexed.</p>
    /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>*.txt</i> will include all text files
    /// in a directory (files with the extension .txt).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>**/*.txt</i> will include all text
    /// files in a directory and its subdirectories.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>*tax*</i> will include all files in
    /// a directory that contain 'tax' in the file name, such as 'tax',
    /// 'taxes', 'income_tax'.</p>
    /// </li>
    /// </ul>
    pub fn inclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.inclusion_patterns.as_deref()
    }
    /// <p>A list of glob patterns for documents that should not be indexed.
    /// If a document that matches an inclusion prefix or inclusion pattern
    /// also matches an exclusion pattern, the document is not
    /// indexed.</p>
    /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>*.png , *.jpg</i> will exclude
    /// all PNG and JPEG image files in a directory
    /// (files with the extensions .png and .jpg).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>*internal*</i> will exclude all
    /// files in a directory that contain 'internal' in the file name,
    /// such as 'internal', 'internal_only', 'company_internal'.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>**/*internal*</i> will exclude
    /// all internal-related files in a directory and its subdirectories.</p>
    /// </li>
    /// </ul>
    pub fn exclusion_patterns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_patterns.as_deref()
    }
    /// <p>Document metadata files that contain information such as the
    /// document access control information, source URI, document author,
    /// and custom attributes. Each metadata file contains metadata about a
    /// single document.</p>
    pub fn documents_metadata_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DocumentsMetadataConfiguration> {
        self.documents_metadata_configuration.as_ref()
    }
    /// <p>Provides the path to the S3 bucket that contains the user context
    /// filtering files for the data source. For the format of the file, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>
    pub fn access_control_list_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AccessControlListConfiguration> {
        self.access_control_list_configuration.as_ref()
    }
}
impl std::fmt::Debug for S3DataSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DataSourceConfiguration");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("inclusion_prefixes", &self.inclusion_prefixes);
        formatter.field("inclusion_patterns", &self.inclusion_patterns);
        formatter.field("exclusion_patterns", &self.exclusion_patterns);
        formatter.field(
            "documents_metadata_configuration",
            &self.documents_metadata_configuration,
        );
        formatter.field(
            "access_control_list_configuration",
            &self.access_control_list_configuration,
        );
        formatter.finish()
    }
}
/// See [`S3DataSourceConfiguration`](crate::model::S3DataSourceConfiguration)
pub mod s3_data_source_configuration {
    /// A builder for [`S3DataSourceConfiguration`](crate::model::S3DataSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) inclusion_prefixes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) inclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclusion_patterns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) documents_metadata_configuration:
            std::option::Option<crate::model::DocumentsMetadataConfiguration>,
        pub(crate) access_control_list_configuration:
            std::option::Option<crate::model::AccessControlListConfiguration>,
    }
    impl Builder {
        /// <p>The name of the bucket that contains the documents.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket that contains the documents.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Appends an item to `inclusion_prefixes`.
        ///
        /// To override the contents of this collection use [`set_inclusion_prefixes`](Self::set_inclusion_prefixes).
        ///
        /// <p>A list of S3 prefixes for the documents that should be included in
        /// the index.</p>
        pub fn inclusion_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_prefixes.unwrap_or_default();
            v.push(input.into());
            self.inclusion_prefixes = Some(v);
            self
        }
        /// <p>A list of S3 prefixes for the documents that should be included in
        /// the index.</p>
        pub fn set_inclusion_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_prefixes = input;
            self
        }
        /// Appends an item to `inclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_inclusion_patterns`](Self::set_inclusion_patterns).
        ///
        /// <p>A list of glob patterns for documents that should be indexed. If a
        /// document that matches an inclusion pattern also matches an exclusion
        /// pattern, the document is not indexed.</p>
        /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>*.txt</i> will include all text files
        /// in a directory (files with the extension .txt).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>**/*.txt</i> will include all text
        /// files in a directory and its subdirectories.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>*tax*</i> will include all files in
        /// a directory that contain 'tax' in the file name, such as 'tax',
        /// 'taxes', 'income_tax'.</p>
        /// </li>
        /// </ul>
        pub fn inclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.inclusion_patterns = Some(v);
            self
        }
        /// <p>A list of glob patterns for documents that should be indexed. If a
        /// document that matches an inclusion pattern also matches an exclusion
        /// pattern, the document is not indexed.</p>
        /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>*.txt</i> will include all text files
        /// in a directory (files with the extension .txt).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>**/*.txt</i> will include all text
        /// files in a directory and its subdirectories.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>*tax*</i> will include all files in
        /// a directory that contain 'tax' in the file name, such as 'tax',
        /// 'taxes', 'income_tax'.</p>
        /// </li>
        /// </ul>
        pub fn set_inclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inclusion_patterns = input;
            self
        }
        /// Appends an item to `exclusion_patterns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_patterns`](Self::set_exclusion_patterns).
        ///
        /// <p>A list of glob patterns for documents that should not be indexed.
        /// If a document that matches an inclusion prefix or inclusion pattern
        /// also matches an exclusion pattern, the document is not
        /// indexed.</p>
        /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>*.png , *.jpg</i> will exclude
        /// all PNG and JPEG image files in a directory
        /// (files with the extensions .png and .jpg).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>*internal*</i> will exclude all
        /// files in a directory that contain 'internal' in the file name,
        /// such as 'internal', 'internal_only', 'company_internal'.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>**/*internal*</i> will exclude
        /// all internal-related files in a directory and its subdirectories.</p>
        /// </li>
        /// </ul>
        pub fn exclusion_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_patterns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_patterns = Some(v);
            self
        }
        /// <p>A list of glob patterns for documents that should not be indexed.
        /// If a document that matches an inclusion prefix or inclusion pattern
        /// also matches an exclusion pattern, the document is not
        /// indexed.</p>
        /// <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a>
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>*.png , *.jpg</i> will exclude
        /// all PNG and JPEG image files in a directory
        /// (files with the extensions .png and .jpg).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>*internal*</i> will exclude all
        /// files in a directory that contain 'internal' in the file name,
        /// such as 'internal', 'internal_only', 'company_internal'.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>**/*internal*</i> will exclude
        /// all internal-related files in a directory and its subdirectories.</p>
        /// </li>
        /// </ul>
        pub fn set_exclusion_patterns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_patterns = input;
            self
        }
        /// <p>Document metadata files that contain information such as the
        /// document access control information, source URI, document author,
        /// and custom attributes. Each metadata file contains metadata about a
        /// single document.</p>
        pub fn documents_metadata_configuration(
            mut self,
            input: crate::model::DocumentsMetadataConfiguration,
        ) -> Self {
            self.documents_metadata_configuration = Some(input);
            self
        }
        /// <p>Document metadata files that contain information such as the
        /// document access control information, source URI, document author,
        /// and custom attributes. Each metadata file contains metadata about a
        /// single document.</p>
        pub fn set_documents_metadata_configuration(
            mut self,
            input: std::option::Option<crate::model::DocumentsMetadataConfiguration>,
        ) -> Self {
            self.documents_metadata_configuration = input;
            self
        }
        /// <p>Provides the path to the S3 bucket that contains the user context
        /// filtering files for the data source. For the format of the file, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>
        pub fn access_control_list_configuration(
            mut self,
            input: crate::model::AccessControlListConfiguration,
        ) -> Self {
            self.access_control_list_configuration = Some(input);
            self
        }
        /// <p>Provides the path to the S3 bucket that contains the user context
        /// filtering files for the data source. For the format of the file, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>
        pub fn set_access_control_list_configuration(
            mut self,
            input: std::option::Option<crate::model::AccessControlListConfiguration>,
        ) -> Self {
            self.access_control_list_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DataSourceConfiguration`](crate::model::S3DataSourceConfiguration)
        pub fn build(self) -> crate::model::S3DataSourceConfiguration {
            crate::model::S3DataSourceConfiguration {
                bucket_name: self.bucket_name,
                inclusion_prefixes: self.inclusion_prefixes,
                inclusion_patterns: self.inclusion_patterns,
                exclusion_patterns: self.exclusion_patterns,
                documents_metadata_configuration: self.documents_metadata_configuration,
                access_control_list_configuration: self.access_control_list_configuration,
            }
        }
    }
}
impl S3DataSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`S3DataSourceConfiguration`](crate::model::S3DataSourceConfiguration)
    pub fn builder() -> crate::model::s3_data_source_configuration::Builder {
        crate::model::s3_data_source_configuration::Builder::default()
    }
}

/// <p>Access Control List files for the documents in a data source. For
/// the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data
/// sources</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlListConfiguration {
    /// <p>Path to the Amazon Web Services S3 bucket that contains the ACL files.</p>
    pub key_path: std::option::Option<std::string::String>,
}
impl AccessControlListConfiguration {
    /// <p>Path to the Amazon Web Services S3 bucket that contains the ACL files.</p>
    pub fn key_path(&self) -> std::option::Option<&str> {
        self.key_path.as_deref()
    }
}
impl std::fmt::Debug for AccessControlListConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlListConfiguration");
        formatter.field("key_path", &self.key_path);
        formatter.finish()
    }
}
/// See [`AccessControlListConfiguration`](crate::model::AccessControlListConfiguration)
pub mod access_control_list_configuration {
    /// A builder for [`AccessControlListConfiguration`](crate::model::AccessControlListConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Path to the Amazon Web Services S3 bucket that contains the ACL files.</p>
        pub fn key_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_path = Some(input.into());
            self
        }
        /// <p>Path to the Amazon Web Services S3 bucket that contains the ACL files.</p>
        pub fn set_key_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_path = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlListConfiguration`](crate::model::AccessControlListConfiguration)
        pub fn build(self) -> crate::model::AccessControlListConfiguration {
            crate::model::AccessControlListConfiguration {
                key_path: self.key_path,
            }
        }
    }
}
impl AccessControlListConfiguration {
    /// Creates a new builder-style object to manufacture [`AccessControlListConfiguration`](crate::model::AccessControlListConfiguration)
    pub fn builder() -> crate::model::access_control_list_configuration::Builder {
        crate::model::access_control_list_configuration::Builder::default()
    }
}

/// <p>Document metadata files that contain information such as the
/// document access control information, source URI, document author,
/// and custom attributes. Each metadata file contains metadata about a
/// single document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentsMetadataConfiguration {
    /// <p>A prefix used to filter metadata configuration files in the Amazon Web Services S3
    /// bucket. The S3 bucket might contain multiple metadata files. Use
    /// <code>S3Prefix</code> to include only the desired metadata
    /// files.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
}
impl DocumentsMetadataConfiguration {
    /// <p>A prefix used to filter metadata configuration files in the Amazon Web Services S3
    /// bucket. The S3 bucket might contain multiple metadata files. Use
    /// <code>S3Prefix</code> to include only the desired metadata
    /// files.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for DocumentsMetadataConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentsMetadataConfiguration");
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.finish()
    }
}
/// See [`DocumentsMetadataConfiguration`](crate::model::DocumentsMetadataConfiguration)
pub mod documents_metadata_configuration {
    /// A builder for [`DocumentsMetadataConfiguration`](crate::model::DocumentsMetadataConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A prefix used to filter metadata configuration files in the Amazon Web Services S3
        /// bucket. The S3 bucket might contain multiple metadata files. Use
        /// <code>S3Prefix</code> to include only the desired metadata
        /// files.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>A prefix used to filter metadata configuration files in the Amazon Web Services S3
        /// bucket. The S3 bucket might contain multiple metadata files. Use
        /// <code>S3Prefix</code> to include only the desired metadata
        /// files.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentsMetadataConfiguration`](crate::model::DocumentsMetadataConfiguration)
        pub fn build(self) -> crate::model::DocumentsMetadataConfiguration {
            crate::model::DocumentsMetadataConfiguration {
                s3_prefix: self.s3_prefix,
            }
        }
    }
}
impl DocumentsMetadataConfiguration {
    /// Creates a new builder-style object to manufacture [`DocumentsMetadataConfiguration`](crate::model::DocumentsMetadataConfiguration)
    pub fn builder() -> crate::model::documents_metadata_configuration::Builder {
        crate::model::documents_metadata_configuration::Builder::default()
    }
}

/// <p>A list of key/value pairs that identify an index, FAQ, or data source.
/// Tag keys and values can consist of Unicode letters, digits, white space,
/// and any of the following symbols: _ . : / = + - @.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag. Keys are not case sensitive and must be unique
    /// for the index, FAQ, or data source.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with the tag. The value may be an empty string
    /// but it can't be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag. Keys are not case sensitive and must be unique
    /// for the index, FAQ, or data source.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value associated with the tag. The value may be an empty string
    /// but it can't be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag. Keys are not case sensitive and must be unique
        /// for the index, FAQ, or data source.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag. Keys are not case sensitive and must be unique
        /// for the index, FAQ, or data source.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with the tag. The value may be an empty string
        /// but it can't be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with the tag. The value may be an empty string
        /// but it can't be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Provides feedback on how relevant a document is to a search. Your
/// application uses the <code>SubmitFeedback</code> operation to
/// provide relevance information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelevanceFeedback {
    /// <p>The unique identifier of the search result that the user provided
    /// relevance feedback for.</p>
    pub result_id: std::option::Option<std::string::String>,
    /// <p>Whether to document was relevant or not relevant to the
    /// search.</p>
    pub relevance_value: std::option::Option<crate::model::RelevanceType>,
}
impl RelevanceFeedback {
    /// <p>The unique identifier of the search result that the user provided
    /// relevance feedback for.</p>
    pub fn result_id(&self) -> std::option::Option<&str> {
        self.result_id.as_deref()
    }
    /// <p>Whether to document was relevant or not relevant to the
    /// search.</p>
    pub fn relevance_value(&self) -> std::option::Option<&crate::model::RelevanceType> {
        self.relevance_value.as_ref()
    }
}
impl std::fmt::Debug for RelevanceFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelevanceFeedback");
        formatter.field("result_id", &self.result_id);
        formatter.field("relevance_value", &self.relevance_value);
        formatter.finish()
    }
}
/// See [`RelevanceFeedback`](crate::model::RelevanceFeedback)
pub mod relevance_feedback {
    /// A builder for [`RelevanceFeedback`](crate::model::RelevanceFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_id: std::option::Option<std::string::String>,
        pub(crate) relevance_value: std::option::Option<crate::model::RelevanceType>,
    }
    impl Builder {
        /// <p>The unique identifier of the search result that the user provided
        /// relevance feedback for.</p>
        pub fn result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the search result that the user provided
        /// relevance feedback for.</p>
        pub fn set_result_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_id = input;
            self
        }
        /// <p>Whether to document was relevant or not relevant to the
        /// search.</p>
        pub fn relevance_value(mut self, input: crate::model::RelevanceType) -> Self {
            self.relevance_value = Some(input);
            self
        }
        /// <p>Whether to document was relevant or not relevant to the
        /// search.</p>
        pub fn set_relevance_value(
            mut self,
            input: std::option::Option<crate::model::RelevanceType>,
        ) -> Self {
            self.relevance_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RelevanceFeedback`](crate::model::RelevanceFeedback)
        pub fn build(self) -> crate::model::RelevanceFeedback {
            crate::model::RelevanceFeedback {
                result_id: self.result_id,
                relevance_value: self.relevance_value,
            }
        }
    }
}
impl RelevanceFeedback {
    /// Creates a new builder-style object to manufacture [`RelevanceFeedback`](crate::model::RelevanceFeedback)
    pub fn builder() -> crate::model::relevance_feedback::Builder {
        crate::model::relevance_feedback::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelevanceType {
    #[allow(missing_docs)] // documentation missing in model
    NotRelevant,
    #[allow(missing_docs)] // documentation missing in model
    Relevant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelevanceType {
    fn from(s: &str) -> Self {
        match s {
            "NOT_RELEVANT" => RelevanceType::NotRelevant,
            "RELEVANT" => RelevanceType::Relevant,
            other => RelevanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelevanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelevanceType::from(s))
    }
}
impl RelevanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelevanceType::NotRelevant => "NOT_RELEVANT",
            RelevanceType::Relevant => "RELEVANT",
            RelevanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_RELEVANT", "RELEVANT"]
    }
}
impl AsRef<str> for RelevanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Gathers information about when a particular result was clicked by
/// a user. Your application uses the <code>SubmitFeedback</code>
/// operation to provide click information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClickFeedback {
    /// <p>The unique identifier of the search result that was
    /// clicked.</p>
    pub result_id: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp of the date and time that the result was
    /// clicked.</p>
    pub click_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ClickFeedback {
    /// <p>The unique identifier of the search result that was
    /// clicked.</p>
    pub fn result_id(&self) -> std::option::Option<&str> {
        self.result_id.as_deref()
    }
    /// <p>The Unix timestamp of the date and time that the result was
    /// clicked.</p>
    pub fn click_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.click_time.as_ref()
    }
}
impl std::fmt::Debug for ClickFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClickFeedback");
        formatter.field("result_id", &self.result_id);
        formatter.field("click_time", &self.click_time);
        formatter.finish()
    }
}
/// See [`ClickFeedback`](crate::model::ClickFeedback)
pub mod click_feedback {
    /// A builder for [`ClickFeedback`](crate::model::ClickFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_id: std::option::Option<std::string::String>,
        pub(crate) click_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the search result that was
        /// clicked.</p>
        pub fn result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the search result that was
        /// clicked.</p>
        pub fn set_result_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_id = input;
            self
        }
        /// <p>The Unix timestamp of the date and time that the result was
        /// clicked.</p>
        pub fn click_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.click_time = Some(input);
            self
        }
        /// <p>The Unix timestamp of the date and time that the result was
        /// clicked.</p>
        pub fn set_click_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.click_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ClickFeedback`](crate::model::ClickFeedback)
        pub fn build(self) -> crate::model::ClickFeedback {
            crate::model::ClickFeedback {
                result_id: self.result_id,
                click_time: self.click_time,
            }
        }
    }
}
impl ClickFeedback {
    /// Creates a new builder-style object to manufacture [`ClickFeedback`](crate::model::ClickFeedback)
    pub fn builder() -> crate::model::click_feedback::Builder {
        crate::model::click_feedback::Builder::default()
    }
}

/// <p>The facet values for the documents in the response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FacetResult {
    /// <p>The key for the facet values. This is the same as the
    /// <code>DocumentAttributeKey</code> provided in the query.</p>
    pub document_attribute_key: std::option::Option<std::string::String>,
    /// <p>The data type of the facet value. This is the same as the type
    /// defined for the index field when it was created.</p>
    pub document_attribute_value_type:
        std::option::Option<crate::model::DocumentAttributeValueType>,
    /// <p>An array of key/value pairs, where the key is the value of the
    /// attribute and the count is the number of documents that share the key
    /// value.</p>
    pub document_attribute_value_count_pairs:
        std::option::Option<std::vec::Vec<crate::model::DocumentAttributeValueCountPair>>,
}
impl FacetResult {
    /// <p>The key for the facet values. This is the same as the
    /// <code>DocumentAttributeKey</code> provided in the query.</p>
    pub fn document_attribute_key(&self) -> std::option::Option<&str> {
        self.document_attribute_key.as_deref()
    }
    /// <p>The data type of the facet value. This is the same as the type
    /// defined for the index field when it was created.</p>
    pub fn document_attribute_value_type(
        &self,
    ) -> std::option::Option<&crate::model::DocumentAttributeValueType> {
        self.document_attribute_value_type.as_ref()
    }
    /// <p>An array of key/value pairs, where the key is the value of the
    /// attribute and the count is the number of documents that share the key
    /// value.</p>
    pub fn document_attribute_value_count_pairs(
        &self,
    ) -> std::option::Option<&[crate::model::DocumentAttributeValueCountPair]> {
        self.document_attribute_value_count_pairs.as_deref()
    }
}
impl std::fmt::Debug for FacetResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FacetResult");
        formatter.field("document_attribute_key", &self.document_attribute_key);
        formatter.field(
            "document_attribute_value_type",
            &self.document_attribute_value_type,
        );
        formatter.field(
            "document_attribute_value_count_pairs",
            &self.document_attribute_value_count_pairs,
        );
        formatter.finish()
    }
}
/// See [`FacetResult`](crate::model::FacetResult)
pub mod facet_result {
    /// A builder for [`FacetResult`](crate::model::FacetResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_attribute_key: std::option::Option<std::string::String>,
        pub(crate) document_attribute_value_type:
            std::option::Option<crate::model::DocumentAttributeValueType>,
        pub(crate) document_attribute_value_count_pairs:
            std::option::Option<std::vec::Vec<crate::model::DocumentAttributeValueCountPair>>,
    }
    impl Builder {
        /// <p>The key for the facet values. This is the same as the
        /// <code>DocumentAttributeKey</code> provided in the query.</p>
        pub fn document_attribute_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_attribute_key = Some(input.into());
            self
        }
        /// <p>The key for the facet values. This is the same as the
        /// <code>DocumentAttributeKey</code> provided in the query.</p>
        pub fn set_document_attribute_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_attribute_key = input;
            self
        }
        /// <p>The data type of the facet value. This is the same as the type
        /// defined for the index field when it was created.</p>
        pub fn document_attribute_value_type(
            mut self,
            input: crate::model::DocumentAttributeValueType,
        ) -> Self {
            self.document_attribute_value_type = Some(input);
            self
        }
        /// <p>The data type of the facet value. This is the same as the type
        /// defined for the index field when it was created.</p>
        pub fn set_document_attribute_value_type(
            mut self,
            input: std::option::Option<crate::model::DocumentAttributeValueType>,
        ) -> Self {
            self.document_attribute_value_type = input;
            self
        }
        /// Appends an item to `document_attribute_value_count_pairs`.
        ///
        /// To override the contents of this collection use [`set_document_attribute_value_count_pairs`](Self::set_document_attribute_value_count_pairs).
        ///
        /// <p>An array of key/value pairs, where the key is the value of the
        /// attribute and the count is the number of documents that share the key
        /// value.</p>
        pub fn document_attribute_value_count_pairs(
            mut self,
            input: impl Into<crate::model::DocumentAttributeValueCountPair>,
        ) -> Self {
            let mut v = self
                .document_attribute_value_count_pairs
                .unwrap_or_default();
            v.push(input.into());
            self.document_attribute_value_count_pairs = Some(v);
            self
        }
        /// <p>An array of key/value pairs, where the key is the value of the
        /// attribute and the count is the number of documents that share the key
        /// value.</p>
        pub fn set_document_attribute_value_count_pairs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DocumentAttributeValueCountPair>,
            >,
        ) -> Self {
            self.document_attribute_value_count_pairs = input;
            self
        }
        /// Consumes the builder and constructs a [`FacetResult`](crate::model::FacetResult)
        pub fn build(self) -> crate::model::FacetResult {
            crate::model::FacetResult {
                document_attribute_key: self.document_attribute_key,
                document_attribute_value_type: self.document_attribute_value_type,
                document_attribute_value_count_pairs: self.document_attribute_value_count_pairs,
            }
        }
    }
}
impl FacetResult {
    /// Creates a new builder-style object to manufacture [`FacetResult`](crate::model::FacetResult)
    pub fn builder() -> crate::model::facet_result::Builder {
        crate::model::facet_result::Builder::default()
    }
}

/// <p>Provides the count of documents that match a particular attribute
/// when doing a faceted search.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentAttributeValueCountPair {
    /// <p>The value of the attribute. For example, "HR."</p>
    pub document_attribute_value: std::option::Option<crate::model::DocumentAttributeValue>,
    /// <p>The number of documents in the response that have the attribute
    /// value for the key.</p>
    pub count: std::option::Option<i32>,
}
impl DocumentAttributeValueCountPair {
    /// <p>The value of the attribute. For example, "HR."</p>
    pub fn document_attribute_value(
        &self,
    ) -> std::option::Option<&crate::model::DocumentAttributeValue> {
        self.document_attribute_value.as_ref()
    }
    /// <p>The number of documents in the response that have the attribute
    /// value for the key.</p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for DocumentAttributeValueCountPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentAttributeValueCountPair");
        formatter.field("document_attribute_value", &self.document_attribute_value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`DocumentAttributeValueCountPair`](crate::model::DocumentAttributeValueCountPair)
pub mod document_attribute_value_count_pair {
    /// A builder for [`DocumentAttributeValueCountPair`](crate::model::DocumentAttributeValueCountPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_attribute_value:
            std::option::Option<crate::model::DocumentAttributeValue>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value of the attribute. For example, "HR."</p>
        pub fn document_attribute_value(
            mut self,
            input: crate::model::DocumentAttributeValue,
        ) -> Self {
            self.document_attribute_value = Some(input);
            self
        }
        /// <p>The value of the attribute. For example, "HR."</p>
        pub fn set_document_attribute_value(
            mut self,
            input: std::option::Option<crate::model::DocumentAttributeValue>,
        ) -> Self {
            self.document_attribute_value = input;
            self
        }
        /// <p>The number of documents in the response that have the attribute
        /// value for the key.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of documents in the response that have the attribute
        /// value for the key.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentAttributeValueCountPair`](crate::model::DocumentAttributeValueCountPair)
        pub fn build(self) -> crate::model::DocumentAttributeValueCountPair {
            crate::model::DocumentAttributeValueCountPair {
                document_attribute_value: self.document_attribute_value,
                count: self.count,
            }
        }
    }
}
impl DocumentAttributeValueCountPair {
    /// Creates a new builder-style object to manufacture [`DocumentAttributeValueCountPair`](crate::model::DocumentAttributeValueCountPair)
    pub fn builder() -> crate::model::document_attribute_value_count_pair::Builder {
        crate::model::document_attribute_value_count_pair::Builder::default()
    }
}

/// <p>The value of a custom document attribute. You can only provide one
/// value for a custom attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentAttributeValue {
    /// <p>A string, such as "department".</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>A list of strings. </p>
    pub string_list_value: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A long integer value.</p>
    pub long_value: std::option::Option<i64>,
    /// <p>A date expressed as an ISO 8601 string.</p>
    /// <p>It is important for the time zone to be included
    /// in the ISO 8601 date-time format. For example,
    /// 20120325T123010+01:00 is the ISO 8601 date-time format
    /// for March 25th 2012 at 12:30PM (plus 10 seconds) in
    /// Central European Time.</p>
    pub date_value: std::option::Option<aws_smithy_types::DateTime>,
}
impl DocumentAttributeValue {
    /// <p>A string, such as "department".</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>A list of strings. </p>
    pub fn string_list_value(&self) -> std::option::Option<&[std::string::String]> {
        self.string_list_value.as_deref()
    }
    /// <p>A long integer value.</p>
    pub fn long_value(&self) -> std::option::Option<i64> {
        self.long_value
    }
    /// <p>A date expressed as an ISO 8601 string.</p>
    /// <p>It is important for the time zone to be included
    /// in the ISO 8601 date-time format. For example,
    /// 20120325T123010+01:00 is the ISO 8601 date-time format
    /// for March 25th 2012 at 12:30PM (plus 10 seconds) in
    /// Central European Time.</p>
    pub fn date_value(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_value.as_ref()
    }
}
impl std::fmt::Debug for DocumentAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentAttributeValue");
        formatter.field("string_value", &self.string_value);
        formatter.field("string_list_value", &self.string_list_value);
        formatter.field("long_value", &self.long_value);
        formatter.field("date_value", &self.date_value);
        formatter.finish()
    }
}
/// See [`DocumentAttributeValue`](crate::model::DocumentAttributeValue)
pub mod document_attribute_value {
    /// A builder for [`DocumentAttributeValue`](crate::model::DocumentAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) string_list_value: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) long_value: std::option::Option<i64>,
        pub(crate) date_value: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A string, such as "department".</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>A string, such as "department".</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// Appends an item to `string_list_value`.
        ///
        /// To override the contents of this collection use [`set_string_list_value`](Self::set_string_list_value).
        ///
        /// <p>A list of strings. </p>
        pub fn string_list_value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_list_value.unwrap_or_default();
            v.push(input.into());
            self.string_list_value = Some(v);
            self
        }
        /// <p>A list of strings. </p>
        pub fn set_string_list_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_list_value = input;
            self
        }
        /// <p>A long integer value.</p>
        pub fn long_value(mut self, input: i64) -> Self {
            self.long_value = Some(input);
            self
        }
        /// <p>A long integer value.</p>
        pub fn set_long_value(mut self, input: std::option::Option<i64>) -> Self {
            self.long_value = input;
            self
        }
        /// <p>A date expressed as an ISO 8601 string.</p>
        /// <p>It is important for the time zone to be included
        /// in the ISO 8601 date-time format. For example,
        /// 20120325T123010+01:00 is the ISO 8601 date-time format
        /// for March 25th 2012 at 12:30PM (plus 10 seconds) in
        /// Central European Time.</p>
        pub fn date_value(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_value = Some(input);
            self
        }
        /// <p>A date expressed as an ISO 8601 string.</p>
        /// <p>It is important for the time zone to be included
        /// in the ISO 8601 date-time format. For example,
        /// 20120325T123010+01:00 is the ISO 8601 date-time format
        /// for March 25th 2012 at 12:30PM (plus 10 seconds) in
        /// Central European Time.</p>
        pub fn set_date_value(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentAttributeValue`](crate::model::DocumentAttributeValue)
        pub fn build(self) -> crate::model::DocumentAttributeValue {
            crate::model::DocumentAttributeValue {
                string_value: self.string_value,
                string_list_value: self.string_list_value,
                long_value: self.long_value,
                date_value: self.date_value,
            }
        }
    }
}
impl DocumentAttributeValue {
    /// Creates a new builder-style object to manufacture [`DocumentAttributeValue`](crate::model::DocumentAttributeValue)
    pub fn builder() -> crate::model::document_attribute_value::Builder {
        crate::model::document_attribute_value::Builder::default()
    }
}

/// <p>A single query result.</p>
/// <p>A query result contains information about a document returned by the
/// query. This includes the original location of the document, a list of
/// attributes assigned to the document, and relevant text from the
/// document that satisfies the query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryResultItem {
    /// <p>The unique identifier for the query result.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of document. </p>
    pub r#type: std::option::Option<crate::model::QueryResultType>,
    /// <p>One or more additional attributes associated with the query
    /// result.</p>
    pub additional_attributes:
        std::option::Option<std::vec::Vec<crate::model::AdditionalResultAttribute>>,
    /// <p>The unique identifier for the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The title of the document. Contains the text of the title and
    /// information for highlighting the relevant terms in the title.</p>
    pub document_title: std::option::Option<crate::model::TextWithHighlights>,
    /// <p>An extract of the text in the document. Contains information about
    /// highlighting the relevant terms in the excerpt.</p>
    pub document_excerpt: std::option::Option<crate::model::TextWithHighlights>,
    /// <p>The URI of the original location of the document.</p>
    pub document_uri: std::option::Option<std::string::String>,
    /// <p>An array of document attributes for the document that the query
    /// result maps to. For example, the document author (Author) or the source
    /// URI (SourceUri) of the document.</p>
    pub document_attributes: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
    /// <p>Indicates the confidence that Amazon Kendra has that a result matches the
    /// query that you provided. Each result is placed into a bin that
    /// indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
    /// <code>MEDIUM</code> and <code>LOW</code>. You can use the score to
    /// determine if a response meets the confidence needed for your
    /// application.</p>
    /// <p>The field is only set to <code>LOW</code> when the <code>Type</code>
    /// field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that
    /// the result matches the query.</p>
    pub score_attributes: std::option::Option<crate::model::ScoreAttributes>,
    /// <p>A token that identifies a particular result from a particular query.
    /// Use this token to provide click-through feedback for the result. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
    /// </a>.</p>
    pub feedback_token: std::option::Option<std::string::String>,
}
impl QueryResultItem {
    /// <p>The unique identifier for the query result.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of document. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::QueryResultType> {
        self.r#type.as_ref()
    }
    /// <p>One or more additional attributes associated with the query
    /// result.</p>
    pub fn additional_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalResultAttribute]> {
        self.additional_attributes.as_deref()
    }
    /// <p>The unique identifier for the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The title of the document. Contains the text of the title and
    /// information for highlighting the relevant terms in the title.</p>
    pub fn document_title(&self) -> std::option::Option<&crate::model::TextWithHighlights> {
        self.document_title.as_ref()
    }
    /// <p>An extract of the text in the document. Contains information about
    /// highlighting the relevant terms in the excerpt.</p>
    pub fn document_excerpt(&self) -> std::option::Option<&crate::model::TextWithHighlights> {
        self.document_excerpt.as_ref()
    }
    /// <p>The URI of the original location of the document.</p>
    pub fn document_uri(&self) -> std::option::Option<&str> {
        self.document_uri.as_deref()
    }
    /// <p>An array of document attributes for the document that the query
    /// result maps to. For example, the document author (Author) or the source
    /// URI (SourceUri) of the document.</p>
    pub fn document_attributes(&self) -> std::option::Option<&[crate::model::DocumentAttribute]> {
        self.document_attributes.as_deref()
    }
    /// <p>Indicates the confidence that Amazon Kendra has that a result matches the
    /// query that you provided. Each result is placed into a bin that
    /// indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
    /// <code>MEDIUM</code> and <code>LOW</code>. You can use the score to
    /// determine if a response meets the confidence needed for your
    /// application.</p>
    /// <p>The field is only set to <code>LOW</code> when the <code>Type</code>
    /// field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that
    /// the result matches the query.</p>
    pub fn score_attributes(&self) -> std::option::Option<&crate::model::ScoreAttributes> {
        self.score_attributes.as_ref()
    }
    /// <p>A token that identifies a particular result from a particular query.
    /// Use this token to provide click-through feedback for the result. For
    /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
    /// </a>.</p>
    pub fn feedback_token(&self) -> std::option::Option<&str> {
        self.feedback_token.as_deref()
    }
}
impl std::fmt::Debug for QueryResultItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryResultItem");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("additional_attributes", &self.additional_attributes);
        formatter.field("document_id", &self.document_id);
        formatter.field("document_title", &self.document_title);
        formatter.field("document_excerpt", &self.document_excerpt);
        formatter.field("document_uri", &self.document_uri);
        formatter.field("document_attributes", &self.document_attributes);
        formatter.field("score_attributes", &self.score_attributes);
        formatter.field("feedback_token", &self.feedback_token);
        formatter.finish()
    }
}
/// See [`QueryResultItem`](crate::model::QueryResultItem)
pub mod query_result_item {
    /// A builder for [`QueryResultItem`](crate::model::QueryResultItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::QueryResultType>,
        pub(crate) additional_attributes:
            std::option::Option<std::vec::Vec<crate::model::AdditionalResultAttribute>>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) document_title: std::option::Option<crate::model::TextWithHighlights>,
        pub(crate) document_excerpt: std::option::Option<crate::model::TextWithHighlights>,
        pub(crate) document_uri: std::option::Option<std::string::String>,
        pub(crate) document_attributes:
            std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
        pub(crate) score_attributes: std::option::Option<crate::model::ScoreAttributes>,
        pub(crate) feedback_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the query result.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the query result.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of document. </p>
        pub fn r#type(mut self, input: crate::model::QueryResultType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of document. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::QueryResultType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `additional_attributes`.
        ///
        /// To override the contents of this collection use [`set_additional_attributes`](Self::set_additional_attributes).
        ///
        /// <p>One or more additional attributes associated with the query
        /// result.</p>
        pub fn additional_attributes(
            mut self,
            input: impl Into<crate::model::AdditionalResultAttribute>,
        ) -> Self {
            let mut v = self.additional_attributes.unwrap_or_default();
            v.push(input.into());
            self.additional_attributes = Some(v);
            self
        }
        /// <p>One or more additional attributes associated with the query
        /// result.</p>
        pub fn set_additional_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdditionalResultAttribute>>,
        ) -> Self {
            self.additional_attributes = input;
            self
        }
        /// <p>The unique identifier for the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The title of the document. Contains the text of the title and
        /// information for highlighting the relevant terms in the title.</p>
        pub fn document_title(mut self, input: crate::model::TextWithHighlights) -> Self {
            self.document_title = Some(input);
            self
        }
        /// <p>The title of the document. Contains the text of the title and
        /// information for highlighting the relevant terms in the title.</p>
        pub fn set_document_title(
            mut self,
            input: std::option::Option<crate::model::TextWithHighlights>,
        ) -> Self {
            self.document_title = input;
            self
        }
        /// <p>An extract of the text in the document. Contains information about
        /// highlighting the relevant terms in the excerpt.</p>
        pub fn document_excerpt(mut self, input: crate::model::TextWithHighlights) -> Self {
            self.document_excerpt = Some(input);
            self
        }
        /// <p>An extract of the text in the document. Contains information about
        /// highlighting the relevant terms in the excerpt.</p>
        pub fn set_document_excerpt(
            mut self,
            input: std::option::Option<crate::model::TextWithHighlights>,
        ) -> Self {
            self.document_excerpt = input;
            self
        }
        /// <p>The URI of the original location of the document.</p>
        pub fn document_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_uri = Some(input.into());
            self
        }
        /// <p>The URI of the original location of the document.</p>
        pub fn set_document_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_uri = input;
            self
        }
        /// Appends an item to `document_attributes`.
        ///
        /// To override the contents of this collection use [`set_document_attributes`](Self::set_document_attributes).
        ///
        /// <p>An array of document attributes for the document that the query
        /// result maps to. For example, the document author (Author) or the source
        /// URI (SourceUri) of the document.</p>
        pub fn document_attributes(
            mut self,
            input: impl Into<crate::model::DocumentAttribute>,
        ) -> Self {
            let mut v = self.document_attributes.unwrap_or_default();
            v.push(input.into());
            self.document_attributes = Some(v);
            self
        }
        /// <p>An array of document attributes for the document that the query
        /// result maps to. For example, the document author (Author) or the source
        /// URI (SourceUri) of the document.</p>
        pub fn set_document_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
        ) -> Self {
            self.document_attributes = input;
            self
        }
        /// <p>Indicates the confidence that Amazon Kendra has that a result matches the
        /// query that you provided. Each result is placed into a bin that
        /// indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
        /// <code>MEDIUM</code> and <code>LOW</code>. You can use the score to
        /// determine if a response meets the confidence needed for your
        /// application.</p>
        /// <p>The field is only set to <code>LOW</code> when the <code>Type</code>
        /// field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that
        /// the result matches the query.</p>
        pub fn score_attributes(mut self, input: crate::model::ScoreAttributes) -> Self {
            self.score_attributes = Some(input);
            self
        }
        /// <p>Indicates the confidence that Amazon Kendra has that a result matches the
        /// query that you provided. Each result is placed into a bin that
        /// indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
        /// <code>MEDIUM</code> and <code>LOW</code>. You can use the score to
        /// determine if a response meets the confidence needed for your
        /// application.</p>
        /// <p>The field is only set to <code>LOW</code> when the <code>Type</code>
        /// field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that
        /// the result matches the query.</p>
        pub fn set_score_attributes(
            mut self,
            input: std::option::Option<crate::model::ScoreAttributes>,
        ) -> Self {
            self.score_attributes = input;
            self
        }
        /// <p>A token that identifies a particular result from a particular query.
        /// Use this token to provide click-through feedback for the result. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
        /// </a>.</p>
        pub fn feedback_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_token = Some(input.into());
            self
        }
        /// <p>A token that identifies a particular result from a particular query.
        /// Use this token to provide click-through feedback for the result. For
        /// more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
        /// </a>.</p>
        pub fn set_feedback_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_token = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryResultItem`](crate::model::QueryResultItem)
        pub fn build(self) -> crate::model::QueryResultItem {
            crate::model::QueryResultItem {
                id: self.id,
                r#type: self.r#type,
                additional_attributes: self.additional_attributes,
                document_id: self.document_id,
                document_title: self.document_title,
                document_excerpt: self.document_excerpt,
                document_uri: self.document_uri,
                document_attributes: self.document_attributes,
                score_attributes: self.score_attributes,
                feedback_token: self.feedback_token,
            }
        }
    }
}
impl QueryResultItem {
    /// Creates a new builder-style object to manufacture [`QueryResultItem`](crate::model::QueryResultItem)
    pub fn builder() -> crate::model::query_result_item::Builder {
        crate::model::query_result_item::Builder::default()
    }
}

/// <p>Provides a relative ranking that indicates how confident Amazon Kendra is
/// that the response matches the query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScoreAttributes {
    /// <p>A relative ranking for how well the response matches the
    /// query.</p>
    pub score_confidence: std::option::Option<crate::model::ScoreConfidence>,
}
impl ScoreAttributes {
    /// <p>A relative ranking for how well the response matches the
    /// query.</p>
    pub fn score_confidence(&self) -> std::option::Option<&crate::model::ScoreConfidence> {
        self.score_confidence.as_ref()
    }
}
impl std::fmt::Debug for ScoreAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScoreAttributes");
        formatter.field("score_confidence", &self.score_confidence);
        formatter.finish()
    }
}
/// See [`ScoreAttributes`](crate::model::ScoreAttributes)
pub mod score_attributes {
    /// A builder for [`ScoreAttributes`](crate::model::ScoreAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score_confidence: std::option::Option<crate::model::ScoreConfidence>,
    }
    impl Builder {
        /// <p>A relative ranking for how well the response matches the
        /// query.</p>
        pub fn score_confidence(mut self, input: crate::model::ScoreConfidence) -> Self {
            self.score_confidence = Some(input);
            self
        }
        /// <p>A relative ranking for how well the response matches the
        /// query.</p>
        pub fn set_score_confidence(
            mut self,
            input: std::option::Option<crate::model::ScoreConfidence>,
        ) -> Self {
            self.score_confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`ScoreAttributes`](crate::model::ScoreAttributes)
        pub fn build(self) -> crate::model::ScoreAttributes {
            crate::model::ScoreAttributes {
                score_confidence: self.score_confidence,
            }
        }
    }
}
impl ScoreAttributes {
    /// Creates a new builder-style object to manufacture [`ScoreAttributes`](crate::model::ScoreAttributes)
    pub fn builder() -> crate::model::score_attributes::Builder {
        crate::model::score_attributes::Builder::default()
    }
}

/// Enumeration for query score confidence.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScoreConfidence {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    NotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    VeryHigh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScoreConfidence {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => ScoreConfidence::High,
            "LOW" => ScoreConfidence::Low,
            "MEDIUM" => ScoreConfidence::Medium,
            "NOT_AVAILABLE" => ScoreConfidence::NotAvailable,
            "VERY_HIGH" => ScoreConfidence::VeryHigh,
            other => ScoreConfidence::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScoreConfidence {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScoreConfidence::from(s))
    }
}
impl ScoreConfidence {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScoreConfidence::High => "HIGH",
            ScoreConfidence::Low => "LOW",
            ScoreConfidence::Medium => "MEDIUM",
            ScoreConfidence::NotAvailable => "NOT_AVAILABLE",
            ScoreConfidence::VeryHigh => "VERY_HIGH",
            ScoreConfidence::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM", "NOT_AVAILABLE", "VERY_HIGH"]
    }
}
impl AsRef<str> for ScoreConfidence {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A custom attribute value assigned to a document. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentAttribute {
    /// <p>The identifier for the attribute.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the attribute.</p>
    pub value: std::option::Option<crate::model::DocumentAttributeValue>,
}
impl DocumentAttribute {
    /// <p>The identifier for the attribute.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the attribute.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::DocumentAttributeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for DocumentAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentAttribute");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DocumentAttribute`](crate::model::DocumentAttribute)
pub mod document_attribute {
    /// A builder for [`DocumentAttribute`](crate::model::DocumentAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::DocumentAttributeValue>,
    }
    impl Builder {
        /// <p>The identifier for the attribute.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The identifier for the attribute.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn value(mut self, input: crate::model::DocumentAttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::DocumentAttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentAttribute`](crate::model::DocumentAttribute)
        pub fn build(self) -> crate::model::DocumentAttribute {
            crate::model::DocumentAttribute {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl DocumentAttribute {
    /// Creates a new builder-style object to manufacture [`DocumentAttribute`](crate::model::DocumentAttribute)
    pub fn builder() -> crate::model::document_attribute::Builder {
        crate::model::document_attribute::Builder::default()
    }
}

/// <p>Provides text and information about where to highlight the
/// text.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextWithHighlights {
    /// <p>The text to display to the user.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The beginning and end of the text that should be
    /// highlighted.</p>
    pub highlights: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
}
impl TextWithHighlights {
    /// <p>The text to display to the user.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The beginning and end of the text that should be
    /// highlighted.</p>
    pub fn highlights(&self) -> std::option::Option<&[crate::model::Highlight]> {
        self.highlights.as_deref()
    }
}
impl std::fmt::Debug for TextWithHighlights {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextWithHighlights");
        formatter.field("text", &self.text);
        formatter.field("highlights", &self.highlights);
        formatter.finish()
    }
}
/// See [`TextWithHighlights`](crate::model::TextWithHighlights)
pub mod text_with_highlights {
    /// A builder for [`TextWithHighlights`](crate::model::TextWithHighlights)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) highlights: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
    }
    impl Builder {
        /// <p>The text to display to the user.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text to display to the user.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `highlights`.
        ///
        /// To override the contents of this collection use [`set_highlights`](Self::set_highlights).
        ///
        /// <p>The beginning and end of the text that should be
        /// highlighted.</p>
        pub fn highlights(mut self, input: impl Into<crate::model::Highlight>) -> Self {
            let mut v = self.highlights.unwrap_or_default();
            v.push(input.into());
            self.highlights = Some(v);
            self
        }
        /// <p>The beginning and end of the text that should be
        /// highlighted.</p>
        pub fn set_highlights(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
        ) -> Self {
            self.highlights = input;
            self
        }
        /// Consumes the builder and constructs a [`TextWithHighlights`](crate::model::TextWithHighlights)
        pub fn build(self) -> crate::model::TextWithHighlights {
            crate::model::TextWithHighlights {
                text: self.text,
                highlights: self.highlights,
            }
        }
    }
}
impl TextWithHighlights {
    /// Creates a new builder-style object to manufacture [`TextWithHighlights`](crate::model::TextWithHighlights)
    pub fn builder() -> crate::model::text_with_highlights::Builder {
        crate::model::text_with_highlights::Builder::default()
    }
}

/// <p>Provides information that you can use to highlight a search result
/// so that your users can quickly identify terms in the
/// response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Highlight {
    /// <p>The zero-based location in the response string where the highlight
    /// starts.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>The zero-based location in the response string where the highlight
    /// ends.</p>
    pub end_offset: std::option::Option<i32>,
    /// <p>Indicates whether the response is the best response. True if this
    /// is the best response; otherwise, false.</p>
    pub top_answer: bool,
    /// <p>The highlight type. </p>
    pub r#type: std::option::Option<crate::model::HighlightType>,
}
impl Highlight {
    /// <p>The zero-based location in the response string where the highlight
    /// starts.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>The zero-based location in the response string where the highlight
    /// ends.</p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
    /// <p>Indicates whether the response is the best response. True if this
    /// is the best response; otherwise, false.</p>
    pub fn top_answer(&self) -> bool {
        self.top_answer
    }
    /// <p>The highlight type. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HighlightType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Highlight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Highlight");
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.field("top_answer", &self.top_answer);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Highlight`](crate::model::Highlight)
pub mod highlight {
    /// A builder for [`Highlight`](crate::model::Highlight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
        pub(crate) top_answer: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<crate::model::HighlightType>,
    }
    impl Builder {
        /// <p>The zero-based location in the response string where the highlight
        /// starts.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>The zero-based location in the response string where the highlight
        /// starts.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>The zero-based location in the response string where the highlight
        /// ends.</p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>The zero-based location in the response string where the highlight
        /// ends.</p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// <p>Indicates whether the response is the best response. True if this
        /// is the best response; otherwise, false.</p>
        pub fn top_answer(mut self, input: bool) -> Self {
            self.top_answer = Some(input);
            self
        }
        /// <p>Indicates whether the response is the best response. True if this
        /// is the best response; otherwise, false.</p>
        pub fn set_top_answer(mut self, input: std::option::Option<bool>) -> Self {
            self.top_answer = input;
            self
        }
        /// <p>The highlight type. </p>
        pub fn r#type(mut self, input: crate::model::HighlightType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The highlight type. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::HighlightType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Highlight`](crate::model::Highlight)
        pub fn build(self) -> crate::model::Highlight {
            crate::model::Highlight {
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
                top_answer: self.top_answer.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl Highlight {
    /// Creates a new builder-style object to manufacture [`Highlight`](crate::model::Highlight)
    pub fn builder() -> crate::model::highlight::Builder {
        crate::model::highlight::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HighlightType {
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    ThesaurusSynonym,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HighlightType {
    fn from(s: &str) -> Self {
        match s {
            "STANDARD" => HighlightType::Standard,
            "THESAURUS_SYNONYM" => HighlightType::ThesaurusSynonym,
            other => HighlightType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HighlightType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HighlightType::from(s))
    }
}
impl HighlightType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HighlightType::Standard => "STANDARD",
            HighlightType::ThesaurusSynonym => "THESAURUS_SYNONYM",
            HighlightType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STANDARD", "THESAURUS_SYNONYM"]
    }
}
impl AsRef<str> for HighlightType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An attribute returned from an index query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalResultAttribute {
    /// <p>The key that identifies the attribute.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The data type of the <code>Value</code> property.</p>
    pub value_type: std::option::Option<crate::model::AdditionalResultAttributeValueType>,
    /// <p>An object that contains the attribute value.</p>
    pub value: std::option::Option<crate::model::AdditionalResultAttributeValue>,
}
impl AdditionalResultAttribute {
    /// <p>The key that identifies the attribute.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The data type of the <code>Value</code> property.</p>
    pub fn value_type(
        &self,
    ) -> std::option::Option<&crate::model::AdditionalResultAttributeValueType> {
        self.value_type.as_ref()
    }
    /// <p>An object that contains the attribute value.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::AdditionalResultAttributeValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for AdditionalResultAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalResultAttribute");
        formatter.field("key", &self.key);
        formatter.field("value_type", &self.value_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AdditionalResultAttribute`](crate::model::AdditionalResultAttribute)
pub mod additional_result_attribute {
    /// A builder for [`AdditionalResultAttribute`](crate::model::AdditionalResultAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value_type:
            std::option::Option<crate::model::AdditionalResultAttributeValueType>,
        pub(crate) value: std::option::Option<crate::model::AdditionalResultAttributeValue>,
    }
    impl Builder {
        /// <p>The key that identifies the attribute.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that identifies the attribute.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The data type of the <code>Value</code> property.</p>
        pub fn value_type(
            mut self,
            input: crate::model::AdditionalResultAttributeValueType,
        ) -> Self {
            self.value_type = Some(input);
            self
        }
        /// <p>The data type of the <code>Value</code> property.</p>
        pub fn set_value_type(
            mut self,
            input: std::option::Option<crate::model::AdditionalResultAttributeValueType>,
        ) -> Self {
            self.value_type = input;
            self
        }
        /// <p>An object that contains the attribute value.</p>
        pub fn value(mut self, input: crate::model::AdditionalResultAttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>An object that contains the attribute value.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AdditionalResultAttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalResultAttribute`](crate::model::AdditionalResultAttribute)
        pub fn build(self) -> crate::model::AdditionalResultAttribute {
            crate::model::AdditionalResultAttribute {
                key: self.key,
                value_type: self.value_type,
                value: self.value,
            }
        }
    }
}
impl AdditionalResultAttribute {
    /// Creates a new builder-style object to manufacture [`AdditionalResultAttribute`](crate::model::AdditionalResultAttribute)
    pub fn builder() -> crate::model::additional_result_attribute::Builder {
        crate::model::additional_result_attribute::Builder::default()
    }
}

/// <p>An attribute returned with a document from a search.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalResultAttributeValue {
    /// <p>The text associated with the attribute and information about the
    /// highlight to apply to the text.</p>
    pub text_with_highlights_value: std::option::Option<crate::model::TextWithHighlights>,
}
impl AdditionalResultAttributeValue {
    /// <p>The text associated with the attribute and information about the
    /// highlight to apply to the text.</p>
    pub fn text_with_highlights_value(
        &self,
    ) -> std::option::Option<&crate::model::TextWithHighlights> {
        self.text_with_highlights_value.as_ref()
    }
}
impl std::fmt::Debug for AdditionalResultAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalResultAttributeValue");
        formatter.field(
            "text_with_highlights_value",
            &self.text_with_highlights_value,
        );
        formatter.finish()
    }
}
/// See [`AdditionalResultAttributeValue`](crate::model::AdditionalResultAttributeValue)
pub mod additional_result_attribute_value {
    /// A builder for [`AdditionalResultAttributeValue`](crate::model::AdditionalResultAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_with_highlights_value:
            std::option::Option<crate::model::TextWithHighlights>,
    }
    impl Builder {
        /// <p>The text associated with the attribute and information about the
        /// highlight to apply to the text.</p>
        pub fn text_with_highlights_value(
            mut self,
            input: crate::model::TextWithHighlights,
        ) -> Self {
            self.text_with_highlights_value = Some(input);
            self
        }
        /// <p>The text associated with the attribute and information about the
        /// highlight to apply to the text.</p>
        pub fn set_text_with_highlights_value(
            mut self,
            input: std::option::Option<crate::model::TextWithHighlights>,
        ) -> Self {
            self.text_with_highlights_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalResultAttributeValue`](crate::model::AdditionalResultAttributeValue)
        pub fn build(self) -> crate::model::AdditionalResultAttributeValue {
            crate::model::AdditionalResultAttributeValue {
                text_with_highlights_value: self.text_with_highlights_value,
            }
        }
    }
}
impl AdditionalResultAttributeValue {
    /// Creates a new builder-style object to manufacture [`AdditionalResultAttributeValue`](crate::model::AdditionalResultAttributeValue)
    pub fn builder() -> crate::model::additional_result_attribute_value::Builder {
        crate::model::additional_result_attribute_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdditionalResultAttributeValueType {
    #[allow(missing_docs)] // documentation missing in model
    TextWithHighlightsValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdditionalResultAttributeValueType {
    fn from(s: &str) -> Self {
        match s {
            "TEXT_WITH_HIGHLIGHTS_VALUE" => {
                AdditionalResultAttributeValueType::TextWithHighlightsValue
            }
            other => AdditionalResultAttributeValueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdditionalResultAttributeValueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdditionalResultAttributeValueType::from(s))
    }
}
impl AdditionalResultAttributeValueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdditionalResultAttributeValueType::TextWithHighlightsValue => {
                "TEXT_WITH_HIGHLIGHTS_VALUE"
            }
            AdditionalResultAttributeValueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TEXT_WITH_HIGHLIGHTS_VALUE"]
    }
}
impl AsRef<str> for AdditionalResultAttributeValueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryResultType {
    #[allow(missing_docs)] // documentation missing in model
    Answer,
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    QuestionAnswer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryResultType {
    fn from(s: &str) -> Self {
        match s {
            "ANSWER" => QueryResultType::Answer,
            "DOCUMENT" => QueryResultType::Document,
            "QUESTION_ANSWER" => QueryResultType::QuestionAnswer,
            other => QueryResultType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryResultType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryResultType::from(s))
    }
}
impl QueryResultType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryResultType::Answer => "ANSWER",
            QueryResultType::Document => "DOCUMENT",
            QueryResultType::QuestionAnswer => "QUESTION_ANSWER",
            QueryResultType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANSWER", "DOCUMENT", "QUESTION_ANSWER"]
    }
}
impl AsRef<str> for QueryResultType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the user context for
/// an
/// Amazon Kendra index.</p>
/// <p>This is used for filtering search results for different users based on their access
/// to documents.</p>
/// <p>You provide one of the following:</p>
/// <ul>
/// <li>
/// <p>User token</p>
/// </li>
/// <li>
/// <p>User ID, the groups the user belongs to, and any data sources the groups can
/// access.</p>
/// </li>
/// </ul>
/// <p>If you provide both, an exception is thrown.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserContext {
    /// <p>The user context token for filtering search results for a user. It must
    /// be a JWT or a JSON token.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>The identifier of the user you want to filter search results based on their
    /// access to documents.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The list of groups you want to filter search results based on the
    /// groups' access to documents.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of data source groups you want to filter search results
    /// based on groups' access to documents in that data source.</p>
    pub data_source_groups: std::option::Option<std::vec::Vec<crate::model::DataSourceGroup>>,
}
impl UserContext {
    /// <p>The user context token for filtering search results for a user. It must
    /// be a JWT or a JSON token.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>The identifier of the user you want to filter search results based on their
    /// access to documents.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The list of groups you want to filter search results based on the
    /// groups' access to documents.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>The list of data source groups you want to filter search results
    /// based on groups' access to documents in that data source.</p>
    pub fn data_source_groups(&self) -> std::option::Option<&[crate::model::DataSourceGroup]> {
        self.data_source_groups.as_deref()
    }
}
impl std::fmt::Debug for UserContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserContext");
        formatter.field("token", &self.token);
        formatter.field("user_id", &self.user_id);
        formatter.field("groups", &self.groups);
        formatter.field("data_source_groups", &self.data_source_groups);
        formatter.finish()
    }
}
/// See [`UserContext`](crate::model::UserContext)
pub mod user_context {
    /// A builder for [`UserContext`](crate::model::UserContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_source_groups:
            std::option::Option<std::vec::Vec<crate::model::DataSourceGroup>>,
    }
    impl Builder {
        /// <p>The user context token for filtering search results for a user. It must
        /// be a JWT or a JSON token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The user context token for filtering search results for a user. It must
        /// be a JWT or a JSON token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The identifier of the user you want to filter search results based on their
        /// access to documents.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user you want to filter search results based on their
        /// access to documents.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The list of groups you want to filter search results based on the
        /// groups' access to documents.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The list of groups you want to filter search results based on the
        /// groups' access to documents.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Appends an item to `data_source_groups`.
        ///
        /// To override the contents of this collection use [`set_data_source_groups`](Self::set_data_source_groups).
        ///
        /// <p>The list of data source groups you want to filter search results
        /// based on groups' access to documents in that data source.</p>
        pub fn data_source_groups(
            mut self,
            input: impl Into<crate::model::DataSourceGroup>,
        ) -> Self {
            let mut v = self.data_source_groups.unwrap_or_default();
            v.push(input.into());
            self.data_source_groups = Some(v);
            self
        }
        /// <p>The list of data source groups you want to filter search results
        /// based on groups' access to documents in that data source.</p>
        pub fn set_data_source_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceGroup>>,
        ) -> Self {
            self.data_source_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`UserContext`](crate::model::UserContext)
        pub fn build(self) -> crate::model::UserContext {
            crate::model::UserContext {
                token: self.token,
                user_id: self.user_id,
                groups: self.groups,
                data_source_groups: self.data_source_groups,
            }
        }
    }
}
impl UserContext {
    /// Creates a new builder-style object to manufacture [`UserContext`](crate::model::UserContext)
    pub fn builder() -> crate::model::user_context::Builder {
        crate::model::user_context::Builder::default()
    }
}

/// <p>
/// Data source information for user context filtering.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceGroup {
    /// <p>The identifier of the group you want to add to your list
    /// of groups. This is for filtering search results based on the
    /// groups' access to documents.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source group you want to add
    /// to your list of data source groups. This is for filtering
    /// search results based on the groups' access to documents in
    /// that data source.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl DataSourceGroup {
    /// <p>The identifier of the group you want to add to your list
    /// of groups. This is for filtering search results based on the
    /// groups' access to documents.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The identifier of the data source group you want to add
    /// to your list of data source groups. This is for filtering
    /// search results based on the groups' access to documents in
    /// that data source.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for DataSourceGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceGroup");
        formatter.field("group_id", &self.group_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`DataSourceGroup`](crate::model::DataSourceGroup)
pub mod data_source_group {
    /// A builder for [`DataSourceGroup`](crate::model::DataSourceGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the group you want to add to your list
        /// of groups. This is for filtering search results based on the
        /// groups' access to documents.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the group you want to add to your list
        /// of groups. This is for filtering search results based on the
        /// groups' access to documents.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The identifier of the data source group you want to add
        /// to your list of data source groups. This is for filtering
        /// search results based on the groups' access to documents in
        /// that data source.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source group you want to add
        /// to your list of data source groups. This is for filtering
        /// search results based on the groups' access to documents in
        /// that data source.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceGroup`](crate::model::DataSourceGroup)
        pub fn build(self) -> crate::model::DataSourceGroup {
            crate::model::DataSourceGroup {
                group_id: self.group_id,
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl DataSourceGroup {
    /// Creates a new builder-style object to manufacture [`DataSourceGroup`](crate::model::DataSourceGroup)
    pub fn builder() -> crate::model::data_source_group::Builder {
        crate::model::data_source_group::Builder::default()
    }
}

/// <p>Specifies the document attribute to use to sort the response to a
/// Amazon Kendra query. You can specify a single attribute for sorting. The
/// attribute must have the <code>Sortable</code> flag set to
/// <code>true</code>, otherwise Amazon Kendra returns an exception.</p>
/// <p>You can sort attributes of the following types.</p>
/// <ul>
/// <li>
/// <p>Date value</p>
/// </li>
/// <li>
/// <p>Long value</p>
/// </li>
/// <li>
/// <p>String value</p>
/// </li>
/// </ul>
/// <p>You can't sort attributes of the following type.</p>
/// <ul>
/// <li>
/// <p>String list value</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortingConfiguration {
    /// <p>The name of the document attribute used to sort the response. You
    /// can use any field that has the <code>Sortable</code> flag set to
    /// true.</p>
    /// <p>You can also sort by any of the following built-in
    /// attributes:</p>
    /// <ul>
    /// <li>
    /// <p>_category</p>
    /// </li>
    /// <li>
    /// <p>_created_at</p>
    /// </li>
    /// <li>
    /// <p>_last_updated_at</p>
    /// </li>
    /// <li>
    /// <p>_version</p>
    /// </li>
    /// <li>
    /// <p>_view_count</p>
    /// </li>
    /// </ul>
    pub document_attribute_key: std::option::Option<std::string::String>,
    /// <p>The order that the results should be returned in. In case of ties,
    /// the relevance assigned to the result by Amazon Kendra is used as the
    /// tie-breaker.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl SortingConfiguration {
    /// <p>The name of the document attribute used to sort the response. You
    /// can use any field that has the <code>Sortable</code> flag set to
    /// true.</p>
    /// <p>You can also sort by any of the following built-in
    /// attributes:</p>
    /// <ul>
    /// <li>
    /// <p>_category</p>
    /// </li>
    /// <li>
    /// <p>_created_at</p>
    /// </li>
    /// <li>
    /// <p>_last_updated_at</p>
    /// </li>
    /// <li>
    /// <p>_version</p>
    /// </li>
    /// <li>
    /// <p>_view_count</p>
    /// </li>
    /// </ul>
    pub fn document_attribute_key(&self) -> std::option::Option<&str> {
        self.document_attribute_key.as_deref()
    }
    /// <p>The order that the results should be returned in. In case of ties,
    /// the relevance assigned to the result by Amazon Kendra is used as the
    /// tie-breaker.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for SortingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortingConfiguration");
        formatter.field("document_attribute_key", &self.document_attribute_key);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`SortingConfiguration`](crate::model::SortingConfiguration)
pub mod sorting_configuration {
    /// A builder for [`SortingConfiguration`](crate::model::SortingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_attribute_key: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The name of the document attribute used to sort the response. You
        /// can use any field that has the <code>Sortable</code> flag set to
        /// true.</p>
        /// <p>You can also sort by any of the following built-in
        /// attributes:</p>
        /// <ul>
        /// <li>
        /// <p>_category</p>
        /// </li>
        /// <li>
        /// <p>_created_at</p>
        /// </li>
        /// <li>
        /// <p>_last_updated_at</p>
        /// </li>
        /// <li>
        /// <p>_version</p>
        /// </li>
        /// <li>
        /// <p>_view_count</p>
        /// </li>
        /// </ul>
        pub fn document_attribute_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_attribute_key = Some(input.into());
            self
        }
        /// <p>The name of the document attribute used to sort the response. You
        /// can use any field that has the <code>Sortable</code> flag set to
        /// true.</p>
        /// <p>You can also sort by any of the following built-in
        /// attributes:</p>
        /// <ul>
        /// <li>
        /// <p>_category</p>
        /// </li>
        /// <li>
        /// <p>_created_at</p>
        /// </li>
        /// <li>
        /// <p>_last_updated_at</p>
        /// </li>
        /// <li>
        /// <p>_version</p>
        /// </li>
        /// <li>
        /// <p>_view_count</p>
        /// </li>
        /// </ul>
        pub fn set_document_attribute_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_attribute_key = input;
            self
        }
        /// <p>The order that the results should be returned in. In case of ties,
        /// the relevance assigned to the result by Amazon Kendra is used as the
        /// tie-breaker.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order that the results should be returned in. In case of ties,
        /// the relevance assigned to the result by Amazon Kendra is used as the
        /// tie-breaker.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`SortingConfiguration`](crate::model::SortingConfiguration)
        pub fn build(self) -> crate::model::SortingConfiguration {
            crate::model::SortingConfiguration {
                document_attribute_key: self.document_attribute_key,
                sort_order: self.sort_order,
            }
        }
    }
}
impl SortingConfiguration {
    /// Creates a new builder-style object to manufacture [`SortingConfiguration`](crate::model::SortingConfiguration)
    pub fn builder() -> crate::model::sorting_configuration::Builder {
        crate::model::sorting_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortOrder::Asc,
            "DESC" => SortOrder::Desc,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Asc => "ASC",
            SortOrder::Desc => "DESC",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Overrides the document relevance properties of a custom index field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentRelevanceConfiguration {
    /// <p>The name of the tuning configuration to override document relevance
    /// at the index level.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Provides information for manually tuning the relevance of a field
    /// in a search. When a query includes terms that match the field, the
    /// results are given a boost in the response based on these tuning
    /// parameters.</p>
    pub relevance: std::option::Option<crate::model::Relevance>,
}
impl DocumentRelevanceConfiguration {
    /// <p>The name of the tuning configuration to override document relevance
    /// at the index level.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Provides information for manually tuning the relevance of a field
    /// in a search. When a query includes terms that match the field, the
    /// results are given a boost in the response based on these tuning
    /// parameters.</p>
    pub fn relevance(&self) -> std::option::Option<&crate::model::Relevance> {
        self.relevance.as_ref()
    }
}
impl std::fmt::Debug for DocumentRelevanceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentRelevanceConfiguration");
        formatter.field("name", &self.name);
        formatter.field("relevance", &self.relevance);
        formatter.finish()
    }
}
/// See [`DocumentRelevanceConfiguration`](crate::model::DocumentRelevanceConfiguration)
pub mod document_relevance_configuration {
    /// A builder for [`DocumentRelevanceConfiguration`](crate::model::DocumentRelevanceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) relevance: std::option::Option<crate::model::Relevance>,
    }
    impl Builder {
        /// <p>The name of the tuning configuration to override document relevance
        /// at the index level.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the tuning configuration to override document relevance
        /// at the index level.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Provides information for manually tuning the relevance of a field
        /// in a search. When a query includes terms that match the field, the
        /// results are given a boost in the response based on these tuning
        /// parameters.</p>
        pub fn relevance(mut self, input: crate::model::Relevance) -> Self {
            self.relevance = Some(input);
            self
        }
        /// <p>Provides information for manually tuning the relevance of a field
        /// in a search. When a query includes terms that match the field, the
        /// results are given a boost in the response based on these tuning
        /// parameters.</p>
        pub fn set_relevance(
            mut self,
            input: std::option::Option<crate::model::Relevance>,
        ) -> Self {
            self.relevance = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentRelevanceConfiguration`](crate::model::DocumentRelevanceConfiguration)
        pub fn build(self) -> crate::model::DocumentRelevanceConfiguration {
            crate::model::DocumentRelevanceConfiguration {
                name: self.name,
                relevance: self.relevance,
            }
        }
    }
}
impl DocumentRelevanceConfiguration {
    /// Creates a new builder-style object to manufacture [`DocumentRelevanceConfiguration`](crate::model::DocumentRelevanceConfiguration)
    pub fn builder() -> crate::model::document_relevance_configuration::Builder {
        crate::model::document_relevance_configuration::Builder::default()
    }
}

/// <p>Information about a document attribute</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Facet {
    /// <p>The unique key for the document attribute.</p>
    pub document_attribute_key: std::option::Option<std::string::String>,
}
impl Facet {
    /// <p>The unique key for the document attribute.</p>
    pub fn document_attribute_key(&self) -> std::option::Option<&str> {
        self.document_attribute_key.as_deref()
    }
}
impl std::fmt::Debug for Facet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Facet");
        formatter.field("document_attribute_key", &self.document_attribute_key);
        formatter.finish()
    }
}
/// See [`Facet`](crate::model::Facet)
pub mod facet {
    /// A builder for [`Facet`](crate::model::Facet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_attribute_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique key for the document attribute.</p>
        pub fn document_attribute_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_attribute_key = Some(input.into());
            self
        }
        /// <p>The unique key for the document attribute.</p>
        pub fn set_document_attribute_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_attribute_key = input;
            self
        }
        /// Consumes the builder and constructs a [`Facet`](crate::model::Facet)
        pub fn build(self) -> crate::model::Facet {
            crate::model::Facet {
                document_attribute_key: self.document_attribute_key,
            }
        }
    }
}
impl Facet {
    /// Creates a new builder-style object to manufacture [`Facet`](crate::model::Facet)
    pub fn builder() -> crate::model::facet::Builder {
        crate::model::facet::Builder::default()
    }
}

/// <p>Provides filtering the query results based on document
/// attributes.</p>
/// <p>When you use the <code>AndAllFilters</code> or
/// <code>OrAllFilters</code>, filters you can use 2 layers under the
/// first attribute filter. For example, you can use:</p>
/// <p>
/// <code><AndAllFilters></code>
/// </p>
/// <ol>
/// <li>
/// <p>
/// <code> <OrAllFilters></code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code> <EqualTo></code>
/// </p>
/// </li>
/// </ol>
/// <p>If you use more than 2 layers, you receive a
/// <code>ValidationException</code> exception with the message
/// "<code>AttributeFilter</code> cannot have a depth of more
/// than 2."</p>
/// <p>If you use more than 10 attribute filters in a given list for
/// <code>AndAllFilters</code> or <code>OrAllFilters</code>, you receive
/// a <code>ValidationException</code> with the message
/// "<code>AttributeFilter</code> cannot have a length of more than 10".</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeFilter {
    /// <p>Performs a logical <code>AND</code> operation on all supplied
    /// filters.</p>
    pub and_all_filters: std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
    /// <p>Performs a logical <code>OR</code> operation on all supplied
    /// filters.</p>
    pub or_all_filters: std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
    /// <p>Performs a logical <code>NOT</code> operation on all supplied
    /// filters.</p>
    pub not_filter: std::option::Option<std::boxed::Box<crate::model::AttributeFilter>>,
    /// <p>Performs an equals operation on two document attributes.</p>
    pub equals_to: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Returns true when a document contains all of the specified document
    /// attributes. This filter is only applicable to
    /// <code>StringListValue</code> metadata.</p>
    pub contains_all: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Returns true when a document contains any of the specified document
    /// attributes. This filter is only applicable to
    /// <code>StringListValue</code> metadata.</p>
    pub contains_any: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Performs a greater than operation on two document attributes. Use
    /// with a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub greater_than: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Performs a greater or equals than operation on two document
    /// attributes. Use with a document attribute of type <code>Date</code>
    /// or <code>Long</code>.</p>
    pub greater_than_or_equals: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Performs a less than operation on two document attributes. Use with
    /// a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub less_than: std::option::Option<crate::model::DocumentAttribute>,
    /// <p>Performs a less than or equals operation on two document attributes.
    /// Use with a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub less_than_or_equals: std::option::Option<crate::model::DocumentAttribute>,
}
impl AttributeFilter {
    /// <p>Performs a logical <code>AND</code> operation on all supplied
    /// filters.</p>
    pub fn and_all_filters(&self) -> std::option::Option<&[crate::model::AttributeFilter]> {
        self.and_all_filters.as_deref()
    }
    /// <p>Performs a logical <code>OR</code> operation on all supplied
    /// filters.</p>
    pub fn or_all_filters(&self) -> std::option::Option<&[crate::model::AttributeFilter]> {
        self.or_all_filters.as_deref()
    }
    /// <p>Performs a logical <code>NOT</code> operation on all supplied
    /// filters.</p>
    pub fn not_filter(&self) -> std::option::Option<&crate::model::AttributeFilter> {
        self.not_filter.as_deref()
    }
    /// <p>Performs an equals operation on two document attributes.</p>
    pub fn equals_to(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.equals_to.as_ref()
    }
    /// <p>Returns true when a document contains all of the specified document
    /// attributes. This filter is only applicable to
    /// <code>StringListValue</code> metadata.</p>
    pub fn contains_all(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.contains_all.as_ref()
    }
    /// <p>Returns true when a document contains any of the specified document
    /// attributes. This filter is only applicable to
    /// <code>StringListValue</code> metadata.</p>
    pub fn contains_any(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.contains_any.as_ref()
    }
    /// <p>Performs a greater than operation on two document attributes. Use
    /// with a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub fn greater_than(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.greater_than.as_ref()
    }
    /// <p>Performs a greater or equals than operation on two document
    /// attributes. Use with a document attribute of type <code>Date</code>
    /// or <code>Long</code>.</p>
    pub fn greater_than_or_equals(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.greater_than_or_equals.as_ref()
    }
    /// <p>Performs a less than operation on two document attributes. Use with
    /// a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub fn less_than(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.less_than.as_ref()
    }
    /// <p>Performs a less than or equals operation on two document attributes.
    /// Use with a document attribute of type <code>Date</code> or
    /// <code>Long</code>.</p>
    pub fn less_than_or_equals(&self) -> std::option::Option<&crate::model::DocumentAttribute> {
        self.less_than_or_equals.as_ref()
    }
}
impl std::fmt::Debug for AttributeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeFilter");
        formatter.field("and_all_filters", &self.and_all_filters);
        formatter.field("or_all_filters", &self.or_all_filters);
        formatter.field("not_filter", &self.not_filter);
        formatter.field("equals_to", &self.equals_to);
        formatter.field("contains_all", &self.contains_all);
        formatter.field("contains_any", &self.contains_any);
        formatter.field("greater_than", &self.greater_than);
        formatter.field("greater_than_or_equals", &self.greater_than_or_equals);
        formatter.field("less_than", &self.less_than);
        formatter.field("less_than_or_equals", &self.less_than_or_equals);
        formatter.finish()
    }
}
/// See [`AttributeFilter`](crate::model::AttributeFilter)
pub mod attribute_filter {
    /// A builder for [`AttributeFilter`](crate::model::AttributeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) and_all_filters:
            std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
        pub(crate) or_all_filters:
            std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
        pub(crate) not_filter: std::option::Option<std::boxed::Box<crate::model::AttributeFilter>>,
        pub(crate) equals_to: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) contains_all: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) contains_any: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) greater_than: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) greater_than_or_equals: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) less_than: std::option::Option<crate::model::DocumentAttribute>,
        pub(crate) less_than_or_equals: std::option::Option<crate::model::DocumentAttribute>,
    }
    impl Builder {
        /// Appends an item to `and_all_filters`.
        ///
        /// To override the contents of this collection use [`set_and_all_filters`](Self::set_and_all_filters).
        ///
        /// <p>Performs a logical <code>AND</code> operation on all supplied
        /// filters.</p>
        pub fn and_all_filters(mut self, input: impl Into<crate::model::AttributeFilter>) -> Self {
            let mut v = self.and_all_filters.unwrap_or_default();
            v.push(input.into());
            self.and_all_filters = Some(v);
            self
        }
        /// <p>Performs a logical <code>AND</code> operation on all supplied
        /// filters.</p>
        pub fn set_and_all_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
        ) -> Self {
            self.and_all_filters = input;
            self
        }
        /// Appends an item to `or_all_filters`.
        ///
        /// To override the contents of this collection use [`set_or_all_filters`](Self::set_or_all_filters).
        ///
        /// <p>Performs a logical <code>OR</code> operation on all supplied
        /// filters.</p>
        pub fn or_all_filters(mut self, input: impl Into<crate::model::AttributeFilter>) -> Self {
            let mut v = self.or_all_filters.unwrap_or_default();
            v.push(input.into());
            self.or_all_filters = Some(v);
            self
        }
        /// <p>Performs a logical <code>OR</code> operation on all supplied
        /// filters.</p>
        pub fn set_or_all_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeFilter>>,
        ) -> Self {
            self.or_all_filters = input;
            self
        }
        /// <p>Performs a logical <code>NOT</code> operation on all supplied
        /// filters.</p>
        pub fn not_filter(
            mut self,
            input: impl Into<std::boxed::Box<crate::model::AttributeFilter>>,
        ) -> Self {
            self.not_filter = Some(input.into());
            self
        }
        /// <p>Performs a logical <code>NOT</code> operation on all supplied
        /// filters.</p>
        pub fn set_not_filter(
            mut self,
            input: std::option::Option<std::boxed::Box<crate::model::AttributeFilter>>,
        ) -> Self {
            self.not_filter = input;
            self
        }
        /// <p>Performs an equals operation on two document attributes.</p>
        pub fn equals_to(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.equals_to = Some(input);
            self
        }
        /// <p>Performs an equals operation on two document attributes.</p>
        pub fn set_equals_to(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.equals_to = input;
            self
        }
        /// <p>Returns true when a document contains all of the specified document
        /// attributes. This filter is only applicable to
        /// <code>StringListValue</code> metadata.</p>
        pub fn contains_all(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.contains_all = Some(input);
            self
        }
        /// <p>Returns true when a document contains all of the specified document
        /// attributes. This filter is only applicable to
        /// <code>StringListValue</code> metadata.</p>
        pub fn set_contains_all(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.contains_all = input;
            self
        }
        /// <p>Returns true when a document contains any of the specified document
        /// attributes. This filter is only applicable to
        /// <code>StringListValue</code> metadata.</p>
        pub fn contains_any(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.contains_any = Some(input);
            self
        }
        /// <p>Returns true when a document contains any of the specified document
        /// attributes. This filter is only applicable to
        /// <code>StringListValue</code> metadata.</p>
        pub fn set_contains_any(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.contains_any = input;
            self
        }
        /// <p>Performs a greater than operation on two document attributes. Use
        /// with a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn greater_than(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.greater_than = Some(input);
            self
        }
        /// <p>Performs a greater than operation on two document attributes. Use
        /// with a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn set_greater_than(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.greater_than = input;
            self
        }
        /// <p>Performs a greater or equals than operation on two document
        /// attributes. Use with a document attribute of type <code>Date</code>
        /// or <code>Long</code>.</p>
        pub fn greater_than_or_equals(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.greater_than_or_equals = Some(input);
            self
        }
        /// <p>Performs a greater or equals than operation on two document
        /// attributes. Use with a document attribute of type <code>Date</code>
        /// or <code>Long</code>.</p>
        pub fn set_greater_than_or_equals(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.greater_than_or_equals = input;
            self
        }
        /// <p>Performs a less than operation on two document attributes. Use with
        /// a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn less_than(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.less_than = Some(input);
            self
        }
        /// <p>Performs a less than operation on two document attributes. Use with
        /// a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn set_less_than(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.less_than = input;
            self
        }
        /// <p>Performs a less than or equals operation on two document attributes.
        /// Use with a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn less_than_or_equals(mut self, input: crate::model::DocumentAttribute) -> Self {
            self.less_than_or_equals = Some(input);
            self
        }
        /// <p>Performs a less than or equals operation on two document attributes.
        /// Use with a document attribute of type <code>Date</code> or
        /// <code>Long</code>.</p>
        pub fn set_less_than_or_equals(
            mut self,
            input: std::option::Option<crate::model::DocumentAttribute>,
        ) -> Self {
            self.less_than_or_equals = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeFilter`](crate::model::AttributeFilter)
        pub fn build(self) -> crate::model::AttributeFilter {
            crate::model::AttributeFilter {
                and_all_filters: self.and_all_filters,
                or_all_filters: self.or_all_filters,
                not_filter: self.not_filter,
                equals_to: self.equals_to,
                contains_all: self.contains_all,
                contains_any: self.contains_any,
                greater_than: self.greater_than,
                greater_than_or_equals: self.greater_than_or_equals,
                less_than: self.less_than,
                less_than_or_equals: self.less_than_or_equals,
            }
        }
    }
}
impl AttributeFilter {
    /// Creates a new builder-style object to manufacture [`AttributeFilter`](crate::model::AttributeFilter)
    pub fn builder() -> crate::model::attribute_filter::Builder {
        crate::model::attribute_filter::Builder::default()
    }
}

/// <p>A list of users or sub groups that belong to a group. Users and groups
/// are useful for filtering search results to different users based on their
/// group's access to documents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupMembers {
    /// <p>A list of sub groups that belong to a group. For example, the sub
    /// groups "Research", "Engineering", and "Sales and Marketing" all belong
    /// to the group "Company".</p>
    pub member_groups: std::option::Option<std::vec::Vec<crate::model::MemberGroup>>,
    /// <p>A list of users that belong to a group. For example, a list of interns
    /// all belong to the "Interns" group.</p>
    pub member_users: std::option::Option<std::vec::Vec<crate::model::MemberUser>>,
    /// <p>If you have more than 1000 users and/or sub groups for a single group,
    /// you need to provide the path to the S3 file that lists your users and sub
    /// groups for a group. Your sub groups can contain more than 1000 users, but
    /// the list of sub groups that belong to a group (and/or users) must be no
    /// more than 1000.</p>
    /// <p>You can download this
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
    /// S3 file</a> that uses the correct format for listing group members. Note,
    /// <code>dataSourceId</code> is optional. The value of <code>type</code>
    /// for a group is always <code>GROUP</code> and for a user it is
    /// always <code>USER</code>.</p>
    pub s3_pathfor_group_members: std::option::Option<crate::model::S3Path>,
}
impl GroupMembers {
    /// <p>A list of sub groups that belong to a group. For example, the sub
    /// groups "Research", "Engineering", and "Sales and Marketing" all belong
    /// to the group "Company".</p>
    pub fn member_groups(&self) -> std::option::Option<&[crate::model::MemberGroup]> {
        self.member_groups.as_deref()
    }
    /// <p>A list of users that belong to a group. For example, a list of interns
    /// all belong to the "Interns" group.</p>
    pub fn member_users(&self) -> std::option::Option<&[crate::model::MemberUser]> {
        self.member_users.as_deref()
    }
    /// <p>If you have more than 1000 users and/or sub groups for a single group,
    /// you need to provide the path to the S3 file that lists your users and sub
    /// groups for a group. Your sub groups can contain more than 1000 users, but
    /// the list of sub groups that belong to a group (and/or users) must be no
    /// more than 1000.</p>
    /// <p>You can download this
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
    /// S3 file</a> that uses the correct format for listing group members. Note,
    /// <code>dataSourceId</code> is optional. The value of <code>type</code>
    /// for a group is always <code>GROUP</code> and for a user it is
    /// always <code>USER</code>.</p>
    pub fn s3_pathfor_group_members(&self) -> std::option::Option<&crate::model::S3Path> {
        self.s3_pathfor_group_members.as_ref()
    }
}
impl std::fmt::Debug for GroupMembers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupMembers");
        formatter.field("member_groups", &self.member_groups);
        formatter.field("member_users", &self.member_users);
        formatter.field("s3_pathfor_group_members", &self.s3_pathfor_group_members);
        formatter.finish()
    }
}
/// See [`GroupMembers`](crate::model::GroupMembers)
pub mod group_members {
    /// A builder for [`GroupMembers`](crate::model::GroupMembers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_groups: std::option::Option<std::vec::Vec<crate::model::MemberGroup>>,
        pub(crate) member_users: std::option::Option<std::vec::Vec<crate::model::MemberUser>>,
        pub(crate) s3_pathfor_group_members: std::option::Option<crate::model::S3Path>,
    }
    impl Builder {
        /// Appends an item to `member_groups`.
        ///
        /// To override the contents of this collection use [`set_member_groups`](Self::set_member_groups).
        ///
        /// <p>A list of sub groups that belong to a group. For example, the sub
        /// groups "Research", "Engineering", and "Sales and Marketing" all belong
        /// to the group "Company".</p>
        pub fn member_groups(mut self, input: impl Into<crate::model::MemberGroup>) -> Self {
            let mut v = self.member_groups.unwrap_or_default();
            v.push(input.into());
            self.member_groups = Some(v);
            self
        }
        /// <p>A list of sub groups that belong to a group. For example, the sub
        /// groups "Research", "Engineering", and "Sales and Marketing" all belong
        /// to the group "Company".</p>
        pub fn set_member_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberGroup>>,
        ) -> Self {
            self.member_groups = input;
            self
        }
        /// Appends an item to `member_users`.
        ///
        /// To override the contents of this collection use [`set_member_users`](Self::set_member_users).
        ///
        /// <p>A list of users that belong to a group. For example, a list of interns
        /// all belong to the "Interns" group.</p>
        pub fn member_users(mut self, input: impl Into<crate::model::MemberUser>) -> Self {
            let mut v = self.member_users.unwrap_or_default();
            v.push(input.into());
            self.member_users = Some(v);
            self
        }
        /// <p>A list of users that belong to a group. For example, a list of interns
        /// all belong to the "Interns" group.</p>
        pub fn set_member_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberUser>>,
        ) -> Self {
            self.member_users = input;
            self
        }
        /// <p>If you have more than 1000 users and/or sub groups for a single group,
        /// you need to provide the path to the S3 file that lists your users and sub
        /// groups for a group. Your sub groups can contain more than 1000 users, but
        /// the list of sub groups that belong to a group (and/or users) must be no
        /// more than 1000.</p>
        /// <p>You can download this
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
        /// S3 file</a> that uses the correct format for listing group members. Note,
        /// <code>dataSourceId</code> is optional. The value of <code>type</code>
        /// for a group is always <code>GROUP</code> and for a user it is
        /// always <code>USER</code>.</p>
        pub fn s3_pathfor_group_members(mut self, input: crate::model::S3Path) -> Self {
            self.s3_pathfor_group_members = Some(input);
            self
        }
        /// <p>If you have more than 1000 users and/or sub groups for a single group,
        /// you need to provide the path to the S3 file that lists your users and sub
        /// groups for a group. Your sub groups can contain more than 1000 users, but
        /// the list of sub groups that belong to a group (and/or users) must be no
        /// more than 1000.</p>
        /// <p>You can download this
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
        /// S3 file</a> that uses the correct format for listing group members. Note,
        /// <code>dataSourceId</code> is optional. The value of <code>type</code>
        /// for a group is always <code>GROUP</code> and for a user it is
        /// always <code>USER</code>.</p>
        pub fn set_s3_pathfor_group_members(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.s3_pathfor_group_members = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupMembers`](crate::model::GroupMembers)
        pub fn build(self) -> crate::model::GroupMembers {
            crate::model::GroupMembers {
                member_groups: self.member_groups,
                member_users: self.member_users,
                s3_pathfor_group_members: self.s3_pathfor_group_members,
            }
        }
    }
}
impl GroupMembers {
    /// Creates a new builder-style object to manufacture [`GroupMembers`](crate::model::GroupMembers)
    pub fn builder() -> crate::model::group_members::Builder {
        crate::model::group_members::Builder::default()
    }
}

/// <p>The users that belong to a group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberUser {
    /// <p>The identifier of the user you want to map to a group.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl MemberUser {
    /// <p>The identifier of the user you want to map to a group.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for MemberUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberUser");
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`MemberUser`](crate::model::MemberUser)
pub mod member_user {
    /// A builder for [`MemberUser`](crate::model::MemberUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the user you want to map to a group.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user you want to map to a group.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberUser`](crate::model::MemberUser)
        pub fn build(self) -> crate::model::MemberUser {
            crate::model::MemberUser {
                user_id: self.user_id,
            }
        }
    }
}
impl MemberUser {
    /// Creates a new builder-style object to manufacture [`MemberUser`](crate::model::MemberUser)
    pub fn builder() -> crate::model::member_user::Builder {
        crate::model::member_user::Builder::default()
    }
}

/// <p>The sub groups that belong to a group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberGroup {
    /// <p>The identifier of the sub group you want to map to a group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the data source for the sub group
    /// you want to map to a group.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl MemberGroup {
    /// <p>The identifier of the sub group you want to map to a group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The identifier of the data source for the sub group
    /// you want to map to a group.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for MemberGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberGroup");
        formatter.field("group_id", &self.group_id);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`MemberGroup`](crate::model::MemberGroup)
pub mod member_group {
    /// A builder for [`MemberGroup`](crate::model::MemberGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the sub group you want to map to a group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the sub group you want to map to a group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The identifier of the data source for the sub group
        /// you want to map to a group.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source for the sub group
        /// you want to map to a group.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberGroup`](crate::model::MemberGroup)
        pub fn build(self) -> crate::model::MemberGroup {
            crate::model::MemberGroup {
                group_id: self.group_id,
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl MemberGroup {
    /// Creates a new builder-style object to manufacture [`MemberGroup`](crate::model::MemberGroup)
    pub fn builder() -> crate::model::member_group::Builder {
        crate::model::member_group::Builder::default()
    }
}

/// <p>An array of summary information for a thesaurus or multiple thesauri.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThesaurusSummary {
    /// <p>The identifier of the thesaurus.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the thesaurus.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the thesaurus.</p>
    pub status: std::option::Option<crate::model::ThesaurusStatus>,
    /// <p>The Unix datetime that the thesaurus was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix datetime that the thesaurus was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ThesaurusSummary {
    /// <p>The identifier of the thesaurus.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the thesaurus.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the thesaurus.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ThesaurusStatus> {
        self.status.as_ref()
    }
    /// <p>The Unix datetime that the thesaurus was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix datetime that the thesaurus was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for ThesaurusSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThesaurusSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`ThesaurusSummary`](crate::model::ThesaurusSummary)
pub mod thesaurus_summary {
    /// A builder for [`ThesaurusSummary`](crate::model::ThesaurusSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ThesaurusStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the thesaurus.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the thesaurus.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the thesaurus.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the thesaurus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the thesaurus.</p>
        pub fn status(mut self, input: crate::model::ThesaurusStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the thesaurus.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ThesaurusStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Unix datetime that the thesaurus was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix datetime that the thesaurus was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix datetime that the thesaurus was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix datetime that the thesaurus was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ThesaurusSummary`](crate::model::ThesaurusSummary)
        pub fn build(self) -> crate::model::ThesaurusSummary {
            crate::model::ThesaurusSummary {
                id: self.id,
                name: self.name,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl ThesaurusSummary {
    /// Creates a new builder-style object to manufacture [`ThesaurusSummary`](crate::model::ThesaurusSummary)
    pub fn builder() -> crate::model::thesaurus_summary::Builder {
        crate::model::thesaurus_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThesaurusStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    ActiveButUpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThesaurusStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ThesaurusStatus::Active,
            "ACTIVE_BUT_UPDATE_FAILED" => ThesaurusStatus::ActiveButUpdateFailed,
            "CREATING" => ThesaurusStatus::Creating,
            "DELETING" => ThesaurusStatus::Deleting,
            "FAILED" => ThesaurusStatus::Failed,
            "UPDATING" => ThesaurusStatus::Updating,
            other => ThesaurusStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThesaurusStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThesaurusStatus::from(s))
    }
}
impl ThesaurusStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThesaurusStatus::Active => "ACTIVE",
            ThesaurusStatus::ActiveButUpdateFailed => "ACTIVE_BUT_UPDATE_FAILED",
            ThesaurusStatus::Creating => "CREATING",
            ThesaurusStatus::Deleting => "DELETING",
            ThesaurusStatus::Failed => "FAILED",
            ThesaurusStatus::Updating => "UPDATING",
            ThesaurusStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ACTIVE_BUT_UPDATE_FAILED",
            "CREATING",
            "DELETING",
            "FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ThesaurusStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information on a query suggestions block list.</p>
/// <p>This includes information on the block list ID, block list name, when the
/// block list was created, when the block list was last updated, and the count
/// of block words/phrases in the block list.</p>
/// <p>For information on the current quota limits for block lists, see
/// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
/// for Amazon Kendra</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuerySuggestionsBlockListSummary {
    /// <p>The identifier of a block list.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the block list.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the block list.</p>
    pub status: std::option::Option<crate::model::QuerySuggestionsBlockListStatus>,
    /// <p>The date-time summary information for a query suggestions
    /// block list was last created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date-time the block list was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of items in the block list file.</p>
    pub item_count: std::option::Option<i32>,
}
impl QuerySuggestionsBlockListSummary {
    /// <p>The identifier of a block list.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the block list.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the block list.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::QuerySuggestionsBlockListStatus> {
        self.status.as_ref()
    }
    /// <p>The date-time summary information for a query suggestions
    /// block list was last created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date-time the block list was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The number of items in the block list file.</p>
    pub fn item_count(&self) -> std::option::Option<i32> {
        self.item_count
    }
}
impl std::fmt::Debug for QuerySuggestionsBlockListSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuerySuggestionsBlockListSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("item_count", &self.item_count);
        formatter.finish()
    }
}
/// See [`QuerySuggestionsBlockListSummary`](crate::model::QuerySuggestionsBlockListSummary)
pub mod query_suggestions_block_list_summary {
    /// A builder for [`QuerySuggestionsBlockListSummary`](crate::model::QuerySuggestionsBlockListSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::QuerySuggestionsBlockListStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) item_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of a block list.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of a block list.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the block list.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the block list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the block list.</p>
        pub fn status(mut self, input: crate::model::QuerySuggestionsBlockListStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the block list.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QuerySuggestionsBlockListStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date-time summary information for a query suggestions
        /// block list was last created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date-time summary information for a query suggestions
        /// block list was last created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date-time the block list was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date-time the block list was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The number of items in the block list file.</p>
        pub fn item_count(mut self, input: i32) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of items in the block list file.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i32>) -> Self {
            self.item_count = input;
            self
        }
        /// Consumes the builder and constructs a [`QuerySuggestionsBlockListSummary`](crate::model::QuerySuggestionsBlockListSummary)
        pub fn build(self) -> crate::model::QuerySuggestionsBlockListSummary {
            crate::model::QuerySuggestionsBlockListSummary {
                id: self.id,
                name: self.name,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
                item_count: self.item_count,
            }
        }
    }
}
impl QuerySuggestionsBlockListSummary {
    /// Creates a new builder-style object to manufacture [`QuerySuggestionsBlockListSummary`](crate::model::QuerySuggestionsBlockListSummary)
    pub fn builder() -> crate::model::query_suggestions_block_list_summary::Builder {
        crate::model::query_suggestions_block_list_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuerySuggestionsBlockListStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    ActiveButUpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuerySuggestionsBlockListStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => QuerySuggestionsBlockListStatus::Active,
            "ACTIVE_BUT_UPDATE_FAILED" => QuerySuggestionsBlockListStatus::ActiveButUpdateFailed,
            "CREATING" => QuerySuggestionsBlockListStatus::Creating,
            "DELETING" => QuerySuggestionsBlockListStatus::Deleting,
            "FAILED" => QuerySuggestionsBlockListStatus::Failed,
            "UPDATING" => QuerySuggestionsBlockListStatus::Updating,
            other => QuerySuggestionsBlockListStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuerySuggestionsBlockListStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuerySuggestionsBlockListStatus::from(s))
    }
}
impl QuerySuggestionsBlockListStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuerySuggestionsBlockListStatus::Active => "ACTIVE",
            QuerySuggestionsBlockListStatus::ActiveButUpdateFailed => "ACTIVE_BUT_UPDATE_FAILED",
            QuerySuggestionsBlockListStatus::Creating => "CREATING",
            QuerySuggestionsBlockListStatus::Deleting => "DELETING",
            QuerySuggestionsBlockListStatus::Failed => "FAILED",
            QuerySuggestionsBlockListStatus::Updating => "UPDATING",
            QuerySuggestionsBlockListStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ACTIVE_BUT_UPDATE_FAILED",
            "CREATING",
            "DELETING",
            "FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for QuerySuggestionsBlockListStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of information about an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexConfigurationSummary {
    /// <p>The name of the index.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the index. Use this to identify the index
    /// when you are using operations such as <code>Query</code>,
    /// <code>DescribeIndex</code>, <code>UpdateIndex</code>, and
    /// <code>DeleteIndex</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the index is a enterprise edition index or a
    /// developer edition index. </p>
    pub edition: std::option::Option<crate::model::IndexEdition>,
    /// <p>The Unix timestamp when the index was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Unix timestamp when the index was last updated by the
    /// <code>UpdateIndex</code> operation.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the index. When the status is
    /// <code>ACTIVE</code>, the index is ready to search.</p>
    pub status: std::option::Option<crate::model::IndexStatus>,
}
impl IndexConfigurationSummary {
    /// <p>The name of the index.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique identifier for the index. Use this to identify the index
    /// when you are using operations such as <code>Query</code>,
    /// <code>DescribeIndex</code>, <code>UpdateIndex</code>, and
    /// <code>DeleteIndex</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Indicates whether the index is a enterprise edition index or a
    /// developer edition index. </p>
    pub fn edition(&self) -> std::option::Option<&crate::model::IndexEdition> {
        self.edition.as_ref()
    }
    /// <p>The Unix timestamp when the index was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Unix timestamp when the index was last updated by the
    /// <code>UpdateIndex</code> operation.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The current status of the index. When the status is
    /// <code>ACTIVE</code>, the index is ready to search.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::IndexStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for IndexConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexConfigurationSummary");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("edition", &self.edition);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`IndexConfigurationSummary`](crate::model::IndexConfigurationSummary)
pub mod index_configuration_summary {
    /// A builder for [`IndexConfigurationSummary`](crate::model::IndexConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) edition: std::option::Option<crate::model::IndexEdition>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::IndexStatus>,
    }
    impl Builder {
        /// <p>The name of the index.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the index.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the index. Use this to identify the index
        /// when you are using operations such as <code>Query</code>,
        /// <code>DescribeIndex</code>, <code>UpdateIndex</code>, and
        /// <code>DeleteIndex</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the index. Use this to identify the index
        /// when you are using operations such as <code>Query</code>,
        /// <code>DescribeIndex</code>, <code>UpdateIndex</code>, and
        /// <code>DeleteIndex</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Indicates whether the index is a enterprise edition index or a
        /// developer edition index. </p>
        pub fn edition(mut self, input: crate::model::IndexEdition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>Indicates whether the index is a enterprise edition index or a
        /// developer edition index. </p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::IndexEdition>,
        ) -> Self {
            self.edition = input;
            self
        }
        /// <p>The Unix timestamp when the index was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp when the index was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix timestamp when the index was last updated by the
        /// <code>UpdateIndex</code> operation.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix timestamp when the index was last updated by the
        /// <code>UpdateIndex</code> operation.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The current status of the index. When the status is
        /// <code>ACTIVE</code>, the index is ready to search.</p>
        pub fn status(mut self, input: crate::model::IndexStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the index. When the status is
        /// <code>ACTIVE</code>, the index is ready to search.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::IndexStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexConfigurationSummary`](crate::model::IndexConfigurationSummary)
        pub fn build(self) -> crate::model::IndexConfigurationSummary {
            crate::model::IndexConfigurationSummary {
                name: self.name,
                id: self.id,
                edition: self.edition,
                created_at: self.created_at,
                updated_at: self.updated_at,
                status: self.status,
            }
        }
    }
}
impl IndexConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`IndexConfigurationSummary`](crate::model::IndexConfigurationSummary)
    pub fn builder() -> crate::model::index_configuration_summary::Builder {
        crate::model::index_configuration_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IndexStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    SystemUpdating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IndexStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => IndexStatus::Active,
            "CREATING" => IndexStatus::Creating,
            "DELETING" => IndexStatus::Deleting,
            "FAILED" => IndexStatus::Failed,
            "SYSTEM_UPDATING" => IndexStatus::SystemUpdating,
            "UPDATING" => IndexStatus::Updating,
            other => IndexStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IndexStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IndexStatus::from(s))
    }
}
impl IndexStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IndexStatus::Active => "ACTIVE",
            IndexStatus::Creating => "CREATING",
            IndexStatus::Deleting => "DELETING",
            IndexStatus::Failed => "FAILED",
            IndexStatus::SystemUpdating => "SYSTEM_UPDATING",
            IndexStatus::Updating => "UPDATING",
            IndexStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "DELETING",
            "FAILED",
            "SYSTEM_UPDATING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for IndexStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IndexEdition {
    #[allow(missing_docs)] // documentation missing in model
    DeveloperEdition,
    #[allow(missing_docs)] // documentation missing in model
    EnterpriseEdition,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IndexEdition {
    fn from(s: &str) -> Self {
        match s {
            "DEVELOPER_EDITION" => IndexEdition::DeveloperEdition,
            "ENTERPRISE_EDITION" => IndexEdition::EnterpriseEdition,
            other => IndexEdition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IndexEdition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IndexEdition::from(s))
    }
}
impl IndexEdition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IndexEdition::DeveloperEdition => "DEVELOPER_EDITION",
            IndexEdition::EnterpriseEdition => "ENTERPRISE_EDITION",
            IndexEdition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEVELOPER_EDITION", "ENTERPRISE_EDITION"]
    }
}
impl AsRef<str> for IndexEdition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Group summary information.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupSummary {
    /// <p>
    /// The identifier of the group you want group summary information on.
    /// </p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>
    /// The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code>
    /// action.
    /// </p>
    pub ordering_id: std::option::Option<i64>,
}
impl GroupSummary {
    /// <p>
    /// The identifier of the group you want group summary information on.
    /// </p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>
    /// The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code>
    /// action.
    /// </p>
    pub fn ordering_id(&self) -> std::option::Option<i64> {
        self.ordering_id
    }
}
impl std::fmt::Debug for GroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupSummary");
        formatter.field("group_id", &self.group_id);
        formatter.field("ordering_id", &self.ordering_id);
        formatter.finish()
    }
}
/// See [`GroupSummary`](crate::model::GroupSummary)
pub mod group_summary {
    /// A builder for [`GroupSummary`](crate::model::GroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) ordering_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// The identifier of the group you want group summary information on.
        /// </p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>
        /// The identifier of the group you want group summary information on.
        /// </p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>
        /// The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code>
        /// action.
        /// </p>
        pub fn ordering_id(mut self, input: i64) -> Self {
            self.ordering_id = Some(input);
            self
        }
        /// <p>
        /// The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code>
        /// action.
        /// </p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.ordering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupSummary`](crate::model::GroupSummary)
        pub fn build(self) -> crate::model::GroupSummary {
            crate::model::GroupSummary {
                group_id: self.group_id,
                ordering_id: self.ordering_id,
            }
        }
    }
}
impl GroupSummary {
    /// Creates a new builder-style object to manufacture [`GroupSummary`](crate::model::GroupSummary)
    pub fn builder() -> crate::model::group_summary::Builder {
        crate::model::group_summary::Builder::default()
    }
}

/// <p>Provides information about a frequently asked questions and answer
/// contained in an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaqSummary {
    /// <p>The unique identifier of the FAQ.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name that you assigned the FAQ when you created or updated the
    /// FAQ.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the FAQ. When the status is
    /// <code>ACTIVE</code> the FAQ is ready for use.</p>
    pub status: std::option::Option<crate::model::FaqStatus>,
    /// <p>The UNIX datetime that the FAQ was added to the index.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The UNIX datetime that the FAQ was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The file type used to create the FAQ. </p>
    pub file_format: std::option::Option<crate::model::FaqFileFormat>,
    /// <p>The code for a language. This shows a supported language for the FAQ document
    /// as part of the summary information for FAQs. English is supported by default.  
    /// For more information on supported languages, including their codes,
    /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
    /// documents in languages other than English</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
}
impl FaqSummary {
    /// <p>The unique identifier of the FAQ.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name that you assigned the FAQ when you created or updated the
    /// FAQ.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the FAQ. When the status is
    /// <code>ACTIVE</code> the FAQ is ready for use.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FaqStatus> {
        self.status.as_ref()
    }
    /// <p>The UNIX datetime that the FAQ was added to the index.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The UNIX datetime that the FAQ was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The file type used to create the FAQ. </p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::FaqFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>The code for a language. This shows a supported language for the FAQ document
    /// as part of the summary information for FAQs. English is supported by default.  
    /// For more information on supported languages, including their codes,
    /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
    /// documents in languages other than English</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
}
impl std::fmt::Debug for FaqSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaqSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("file_format", &self.file_format);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}
/// See [`FaqSummary`](crate::model::FaqSummary)
pub mod faq_summary {
    /// A builder for [`FaqSummary`](crate::model::FaqSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FaqStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) file_format: std::option::Option<crate::model::FaqFileFormat>,
        pub(crate) language_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the FAQ.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the FAQ.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name that you assigned the FAQ when you created or updated the
        /// FAQ.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that you assigned the FAQ when you created or updated the
        /// FAQ.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the FAQ. When the status is
        /// <code>ACTIVE</code> the FAQ is ready for use.</p>
        pub fn status(mut self, input: crate::model::FaqStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the FAQ. When the status is
        /// <code>ACTIVE</code> the FAQ is ready for use.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::FaqStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The UNIX datetime that the FAQ was added to the index.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The UNIX datetime that the FAQ was added to the index.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The UNIX datetime that the FAQ was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The UNIX datetime that the FAQ was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The file type used to create the FAQ. </p>
        pub fn file_format(mut self, input: crate::model::FaqFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file type used to create the FAQ. </p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FaqFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>The code for a language. This shows a supported language for the FAQ document
        /// as part of the summary information for FAQs. English is supported by default.  
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for a language. This shows a supported language for the FAQ document
        /// as part of the summary information for FAQs. English is supported by default.  
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`FaqSummary`](crate::model::FaqSummary)
        pub fn build(self) -> crate::model::FaqSummary {
            crate::model::FaqSummary {
                id: self.id,
                name: self.name,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
                file_format: self.file_format,
                language_code: self.language_code,
            }
        }
    }
}
impl FaqSummary {
    /// Creates a new builder-style object to manufacture [`FaqSummary`](crate::model::FaqSummary)
    pub fn builder() -> crate::model::faq_summary::Builder {
        crate::model::faq_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FaqFileFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    CsvWithHeader,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FaqFileFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => FaqFileFormat::Csv,
            "CSV_WITH_HEADER" => FaqFileFormat::CsvWithHeader,
            "JSON" => FaqFileFormat::Json,
            other => FaqFileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FaqFileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FaqFileFormat::from(s))
    }
}
impl FaqFileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FaqFileFormat::Csv => "CSV",
            FaqFileFormat::CsvWithHeader => "CSV_WITH_HEADER",
            FaqFileFormat::Json => "JSON",
            FaqFileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "CSV_WITH_HEADER", "JSON"]
    }
}
impl AsRef<str> for FaqFileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FaqStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FaqStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FaqStatus::Active,
            "CREATING" => FaqStatus::Creating,
            "DELETING" => FaqStatus::Deleting,
            "FAILED" => FaqStatus::Failed,
            "UPDATING" => FaqStatus::Updating,
            other => FaqStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FaqStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FaqStatus::from(s))
    }
}
impl FaqStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FaqStatus::Active => "ACTIVE",
            FaqStatus::Creating => "CREATING",
            FaqStatus::Deleting => "DELETING",
            FaqStatus::Failed => "FAILED",
            FaqStatus::Updating => "UPDATING",
            FaqStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for FaqStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a synchronization job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceSyncJob {
    /// <p>A unique identifier for the synchronization job.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>The UNIX datetime that the synchronization job was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The UNIX datetime that the synchronization job was
    /// completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The execution status of the synchronization job. When the
    /// <code>Status</code> field is set to <code>SUCCEEDED</code>, the
    /// synchronization job is done. If the status code is set to
    /// <code>FAILED</code>, the <code>ErrorCode</code> and
    /// <code>ErrorMessage</code> fields give you the reason for the
    /// failure.</p>
    pub status: std::option::Option<crate::model::DataSourceSyncJobStatus>,
    /// <p>If the <code>Status</code> field is set to <code>ERROR</code>, the
    /// <code>ErrorMessage</code> field contains a description of the
    /// error that caused the synchronization to fail.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>If the <code>Status</code> field is set to <code>FAILED</code>,
    /// the <code>ErrorCode</code> field contains a the reason that the
    /// synchronization failed.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>If the reason that the synchronization failed is due to an error
    /// with the underlying data source, this field contains a code that
    /// identifies the error.</p>
    pub data_source_error_code: std::option::Option<std::string::String>,
    /// <p>Maps a batch delete document request to a specific data source
    /// sync job. This is optional and should only be supplied when
    /// documents are deleted by a data source connector.</p>
    pub metrics: std::option::Option<crate::model::DataSourceSyncJobMetrics>,
}
impl DataSourceSyncJob {
    /// <p>A unique identifier for the synchronization job.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>The UNIX datetime that the synchronization job was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The UNIX datetime that the synchronization job was
    /// completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The execution status of the synchronization job. When the
    /// <code>Status</code> field is set to <code>SUCCEEDED</code>, the
    /// synchronization job is done. If the status code is set to
    /// <code>FAILED</code>, the <code>ErrorCode</code> and
    /// <code>ErrorMessage</code> fields give you the reason for the
    /// failure.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DataSourceSyncJobStatus> {
        self.status.as_ref()
    }
    /// <p>If the <code>Status</code> field is set to <code>ERROR</code>, the
    /// <code>ErrorMessage</code> field contains a description of the
    /// error that caused the synchronization to fail.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>If the <code>Status</code> field is set to <code>FAILED</code>,
    /// the <code>ErrorCode</code> field contains a the reason that the
    /// synchronization failed.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>If the reason that the synchronization failed is due to an error
    /// with the underlying data source, this field contains a code that
    /// identifies the error.</p>
    pub fn data_source_error_code(&self) -> std::option::Option<&str> {
        self.data_source_error_code.as_deref()
    }
    /// <p>Maps a batch delete document request to a specific data source
    /// sync job. This is optional and should only be supplied when
    /// documents are deleted by a data source connector.</p>
    pub fn metrics(&self) -> std::option::Option<&crate::model::DataSourceSyncJobMetrics> {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for DataSourceSyncJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceSyncJob");
        formatter.field("execution_id", &self.execution_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status", &self.status);
        formatter.field("error_message", &self.error_message);
        formatter.field("error_code", &self.error_code);
        formatter.field("data_source_error_code", &self.data_source_error_code);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`DataSourceSyncJob`](crate::model::DataSourceSyncJob)
pub mod data_source_sync_job {
    /// A builder for [`DataSourceSyncJob`](crate::model::DataSourceSyncJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::DataSourceSyncJobStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) data_source_error_code: std::option::Option<std::string::String>,
        pub(crate) metrics: std::option::Option<crate::model::DataSourceSyncJobMetrics>,
    }
    impl Builder {
        /// <p>A unique identifier for the synchronization job.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the synchronization job.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>The UNIX datetime that the synchronization job was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The UNIX datetime that the synchronization job was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The UNIX datetime that the synchronization job was
        /// completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The UNIX datetime that the synchronization job was
        /// completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The execution status of the synchronization job. When the
        /// <code>Status</code> field is set to <code>SUCCEEDED</code>, the
        /// synchronization job is done. If the status code is set to
        /// <code>FAILED</code>, the <code>ErrorCode</code> and
        /// <code>ErrorMessage</code> fields give you the reason for the
        /// failure.</p>
        pub fn status(mut self, input: crate::model::DataSourceSyncJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The execution status of the synchronization job. When the
        /// <code>Status</code> field is set to <code>SUCCEEDED</code>, the
        /// synchronization job is done. If the status code is set to
        /// <code>FAILED</code>, the <code>ErrorCode</code> and
        /// <code>ErrorMessage</code> fields give you the reason for the
        /// failure.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the <code>Status</code> field is set to <code>ERROR</code>, the
        /// <code>ErrorMessage</code> field contains a description of the
        /// error that caused the synchronization to fail.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>If the <code>Status</code> field is set to <code>ERROR</code>, the
        /// <code>ErrorMessage</code> field contains a description of the
        /// error that caused the synchronization to fail.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>If the <code>Status</code> field is set to <code>FAILED</code>,
        /// the <code>ErrorCode</code> field contains a the reason that the
        /// synchronization failed.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>If the <code>Status</code> field is set to <code>FAILED</code>,
        /// the <code>ErrorCode</code> field contains a the reason that the
        /// synchronization failed.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>If the reason that the synchronization failed is due to an error
        /// with the underlying data source, this field contains a code that
        /// identifies the error.</p>
        pub fn data_source_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_error_code = Some(input.into());
            self
        }
        /// <p>If the reason that the synchronization failed is due to an error
        /// with the underlying data source, this field contains a code that
        /// identifies the error.</p>
        pub fn set_data_source_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_error_code = input;
            self
        }
        /// <p>Maps a batch delete document request to a specific data source
        /// sync job. This is optional and should only be supplied when
        /// documents are deleted by a data source connector.</p>
        pub fn metrics(mut self, input: crate::model::DataSourceSyncJobMetrics) -> Self {
            self.metrics = Some(input);
            self
        }
        /// <p>Maps a batch delete document request to a specific data source
        /// sync job. This is optional and should only be supplied when
        /// documents are deleted by a data source connector.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobMetrics>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceSyncJob`](crate::model::DataSourceSyncJob)
        pub fn build(self) -> crate::model::DataSourceSyncJob {
            crate::model::DataSourceSyncJob {
                execution_id: self.execution_id,
                start_time: self.start_time,
                end_time: self.end_time,
                status: self.status,
                error_message: self.error_message,
                error_code: self.error_code,
                data_source_error_code: self.data_source_error_code,
                metrics: self.metrics,
            }
        }
    }
}
impl DataSourceSyncJob {
    /// Creates a new builder-style object to manufacture [`DataSourceSyncJob`](crate::model::DataSourceSyncJob)
    pub fn builder() -> crate::model::data_source_sync_job::Builder {
        crate::model::data_source_sync_job::Builder::default()
    }
}

/// <p>Maps a batch delete document request to a specific data source
/// sync job. This is optional and should only be supplied when
/// documents are deleted by a data source connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceSyncJobMetrics {
    /// <p>The number of documents added from the data source up to now in
    /// the data source sync.</p>
    pub documents_added: std::option::Option<std::string::String>,
    /// <p>The number of documents modified in the data source up to now in
    /// the data source sync run.</p>
    pub documents_modified: std::option::Option<std::string::String>,
    /// <p>The number of documents deleted from the data source up to now in
    /// the data source sync run.</p>
    pub documents_deleted: std::option::Option<std::string::String>,
    /// <p>The number of documents that failed to sync from the data source
    /// up to now in the data source sync run.</p>
    pub documents_failed: std::option::Option<std::string::String>,
    /// <p>The current number of documents crawled by the current sync job in
    /// the data source.</p>
    pub documents_scanned: std::option::Option<std::string::String>,
}
impl DataSourceSyncJobMetrics {
    /// <p>The number of documents added from the data source up to now in
    /// the data source sync.</p>
    pub fn documents_added(&self) -> std::option::Option<&str> {
        self.documents_added.as_deref()
    }
    /// <p>The number of documents modified in the data source up to now in
    /// the data source sync run.</p>
    pub fn documents_modified(&self) -> std::option::Option<&str> {
        self.documents_modified.as_deref()
    }
    /// <p>The number of documents deleted from the data source up to now in
    /// the data source sync run.</p>
    pub fn documents_deleted(&self) -> std::option::Option<&str> {
        self.documents_deleted.as_deref()
    }
    /// <p>The number of documents that failed to sync from the data source
    /// up to now in the data source sync run.</p>
    pub fn documents_failed(&self) -> std::option::Option<&str> {
        self.documents_failed.as_deref()
    }
    /// <p>The current number of documents crawled by the current sync job in
    /// the data source.</p>
    pub fn documents_scanned(&self) -> std::option::Option<&str> {
        self.documents_scanned.as_deref()
    }
}
impl std::fmt::Debug for DataSourceSyncJobMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceSyncJobMetrics");
        formatter.field("documents_added", &self.documents_added);
        formatter.field("documents_modified", &self.documents_modified);
        formatter.field("documents_deleted", &self.documents_deleted);
        formatter.field("documents_failed", &self.documents_failed);
        formatter.field("documents_scanned", &self.documents_scanned);
        formatter.finish()
    }
}
/// See [`DataSourceSyncJobMetrics`](crate::model::DataSourceSyncJobMetrics)
pub mod data_source_sync_job_metrics {
    /// A builder for [`DataSourceSyncJobMetrics`](crate::model::DataSourceSyncJobMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) documents_added: std::option::Option<std::string::String>,
        pub(crate) documents_modified: std::option::Option<std::string::String>,
        pub(crate) documents_deleted: std::option::Option<std::string::String>,
        pub(crate) documents_failed: std::option::Option<std::string::String>,
        pub(crate) documents_scanned: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of documents added from the data source up to now in
        /// the data source sync.</p>
        pub fn documents_added(mut self, input: impl Into<std::string::String>) -> Self {
            self.documents_added = Some(input.into());
            self
        }
        /// <p>The number of documents added from the data source up to now in
        /// the data source sync.</p>
        pub fn set_documents_added(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documents_added = input;
            self
        }
        /// <p>The number of documents modified in the data source up to now in
        /// the data source sync run.</p>
        pub fn documents_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.documents_modified = Some(input.into());
            self
        }
        /// <p>The number of documents modified in the data source up to now in
        /// the data source sync run.</p>
        pub fn set_documents_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documents_modified = input;
            self
        }
        /// <p>The number of documents deleted from the data source up to now in
        /// the data source sync run.</p>
        pub fn documents_deleted(mut self, input: impl Into<std::string::String>) -> Self {
            self.documents_deleted = Some(input.into());
            self
        }
        /// <p>The number of documents deleted from the data source up to now in
        /// the data source sync run.</p>
        pub fn set_documents_deleted(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documents_deleted = input;
            self
        }
        /// <p>The number of documents that failed to sync from the data source
        /// up to now in the data source sync run.</p>
        pub fn documents_failed(mut self, input: impl Into<std::string::String>) -> Self {
            self.documents_failed = Some(input.into());
            self
        }
        /// <p>The number of documents that failed to sync from the data source
        /// up to now in the data source sync run.</p>
        pub fn set_documents_failed(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documents_failed = input;
            self
        }
        /// <p>The current number of documents crawled by the current sync job in
        /// the data source.</p>
        pub fn documents_scanned(mut self, input: impl Into<std::string::String>) -> Self {
            self.documents_scanned = Some(input.into());
            self
        }
        /// <p>The current number of documents crawled by the current sync job in
        /// the data source.</p>
        pub fn set_documents_scanned(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.documents_scanned = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceSyncJobMetrics`](crate::model::DataSourceSyncJobMetrics)
        pub fn build(self) -> crate::model::DataSourceSyncJobMetrics {
            crate::model::DataSourceSyncJobMetrics {
                documents_added: self.documents_added,
                documents_modified: self.documents_modified,
                documents_deleted: self.documents_deleted,
                documents_failed: self.documents_failed,
                documents_scanned: self.documents_scanned,
            }
        }
    }
}
impl DataSourceSyncJobMetrics {
    /// Creates a new builder-style object to manufacture [`DataSourceSyncJobMetrics`](crate::model::DataSourceSyncJobMetrics)
    pub fn builder() -> crate::model::data_source_sync_job_metrics::Builder {
        crate::model::data_source_sync_job_metrics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "InternalError" => ErrorCode::InternalError,
            "InvalidRequest" => ErrorCode::InvalidRequest,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::InternalError => "InternalError",
            ErrorCode::InvalidRequest => "InvalidRequest",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InternalError", "InvalidRequest"]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceSyncJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Incomplete,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    Syncing,
    #[allow(missing_docs)] // documentation missing in model
    SyncingIndexing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceSyncJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => DataSourceSyncJobStatus::Aborted,
            "FAILED" => DataSourceSyncJobStatus::Failed,
            "INCOMPLETE" => DataSourceSyncJobStatus::Incomplete,
            "STOPPING" => DataSourceSyncJobStatus::Stopping,
            "SUCCEEDED" => DataSourceSyncJobStatus::Succeeded,
            "SYNCING" => DataSourceSyncJobStatus::Syncing,
            "SYNCING_INDEXING" => DataSourceSyncJobStatus::SyncingIndexing,
            other => DataSourceSyncJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceSyncJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceSyncJobStatus::from(s))
    }
}
impl DataSourceSyncJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceSyncJobStatus::Aborted => "ABORTED",
            DataSourceSyncJobStatus::Failed => "FAILED",
            DataSourceSyncJobStatus::Incomplete => "INCOMPLETE",
            DataSourceSyncJobStatus::Stopping => "STOPPING",
            DataSourceSyncJobStatus::Succeeded => "SUCCEEDED",
            DataSourceSyncJobStatus::Syncing => "SYNCING",
            DataSourceSyncJobStatus::SyncingIndexing => "SYNCING_INDEXING",
            DataSourceSyncJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABORTED",
            "FAILED",
            "INCOMPLETE",
            "STOPPING",
            "SUCCEEDED",
            "SYNCING",
            "SYNCING_INDEXING",
        ]
    }
}
impl AsRef<str> for DataSourceSyncJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a range of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRange {
    /// <p>The UNIX datetime of the beginning of the time range.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The UNIX datetime of the end of the time range.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeRange {
    /// <p>The UNIX datetime of the beginning of the time range.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The UNIX datetime of the end of the time range.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for TimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`TimeRange`](crate::model::TimeRange)
pub mod time_range {
    /// A builder for [`TimeRange`](crate::model::TimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The UNIX datetime of the beginning of the time range.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The UNIX datetime of the beginning of the time range.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The UNIX datetime of the end of the time range.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The UNIX datetime of the end of the time range.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRange`](crate::model::TimeRange)
        pub fn build(self) -> crate::model::TimeRange {
            crate::model::TimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl TimeRange {
    /// Creates a new builder-style object to manufacture [`TimeRange`](crate::model::TimeRange)
    pub fn builder() -> crate::model::time_range::Builder {
        crate::model::time_range::Builder::default()
    }
}

/// <p>Summary information for a Amazon Kendra data source. Returned in a call
/// to the <code>DescribeDataSource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceSummary {
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the data source.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of the data source.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The UNIX datetime that the data source was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The UNIX datetime that the data source was lasted updated. </p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the data source. When the status is
    /// <code>ACTIVE</code> the data source is ready to use.</p>
    pub status: std::option::Option<crate::model::DataSourceStatus>,
    /// <p>The code for a language. This shows a supported language for all documents
    /// in the data source. English is supported by default.  
    /// For more information on supported languages, including their codes,
    /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
    /// documents in languages other than English</a>.</p>
    pub language_code: std::option::Option<std::string::String>,
}
impl DataSourceSummary {
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the data source.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of the data source.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The UNIX datetime that the data source was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The UNIX datetime that the data source was lasted updated. </p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The status of the data source. When the status is
    /// <code>ACTIVE</code> the data source is ready to use.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DataSourceStatus> {
        self.status.as_ref()
    }
    /// <p>The code for a language. This shows a supported language for all documents
    /// in the data source. English is supported by default.  
    /// For more information on supported languages, including their codes,
    /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
    /// documents in languages other than English</a>.</p>
    pub fn language_code(&self) -> std::option::Option<&str> {
        self.language_code.as_deref()
    }
}
impl std::fmt::Debug for DataSourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceSummary");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}
/// See [`DataSourceSummary`](crate::model::DataSourceSummary)
pub mod data_source_summary {
    /// A builder for [`DataSourceSummary`](crate::model::DataSourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::DataSourceStatus>,
        pub(crate) language_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the data source.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the data source.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of the data source.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the data source.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The UNIX datetime that the data source was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The UNIX datetime that the data source was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The UNIX datetime that the data source was lasted updated. </p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The UNIX datetime that the data source was lasted updated. </p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The status of the data source. When the status is
        /// <code>ACTIVE</code> the data source is ready to use.</p>
        pub fn status(mut self, input: crate::model::DataSourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the data source. When the status is
        /// <code>ACTIVE</code> the data source is ready to use.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The code for a language. This shows a supported language for all documents
        /// in the data source. English is supported by default.  
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// <p>The code for a language. This shows a supported language for all documents
        /// in the data source. English is supported by default.  
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceSummary`](crate::model::DataSourceSummary)
        pub fn build(self) -> crate::model::DataSourceSummary {
            crate::model::DataSourceSummary {
                name: self.name,
                id: self.id,
                r#type: self.r#type,
                created_at: self.created_at,
                updated_at: self.updated_at,
                status: self.status,
                language_code: self.language_code,
            }
        }
    }
}
impl DataSourceSummary {
    /// Creates a new builder-style object to manufacture [`DataSourceSummary`](crate::model::DataSourceSummary)
    pub fn builder() -> crate::model::data_source_summary::Builder {
        crate::model::data_source_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DataSourceStatus::Active,
            "CREATING" => DataSourceStatus::Creating,
            "DELETING" => DataSourceStatus::Deleting,
            "FAILED" => DataSourceStatus::Failed,
            "UPDATING" => DataSourceStatus::Updating,
            other => DataSourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceStatus::from(s))
    }
}
impl DataSourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceStatus::Active => "ACTIVE",
            DataSourceStatus::Creating => "CREATING",
            DataSourceStatus::Deleting => "DELETING",
            DataSourceStatus::Failed => "FAILED",
            DataSourceStatus::Updating => "UPDATING",
            DataSourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for DataSourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Confluence,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Database,
    #[allow(missing_docs)] // documentation missing in model
    Googledrive,
    #[allow(missing_docs)] // documentation missing in model
    Onedrive,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Salesforce,
    #[allow(missing_docs)] // documentation missing in model
    Servicenow,
    #[allow(missing_docs)] // documentation missing in model
    Sharepoint,
    #[allow(missing_docs)] // documentation missing in model
    Webcrawler,
    #[allow(missing_docs)] // documentation missing in model
    Workdocs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "CONFLUENCE" => DataSourceType::Confluence,
            "CUSTOM" => DataSourceType::Custom,
            "DATABASE" => DataSourceType::Database,
            "GOOGLEDRIVE" => DataSourceType::Googledrive,
            "ONEDRIVE" => DataSourceType::Onedrive,
            "S3" => DataSourceType::S3,
            "SALESFORCE" => DataSourceType::Salesforce,
            "SERVICENOW" => DataSourceType::Servicenow,
            "SHAREPOINT" => DataSourceType::Sharepoint,
            "WEBCRAWLER" => DataSourceType::Webcrawler,
            "WORKDOCS" => DataSourceType::Workdocs,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::Confluence => "CONFLUENCE",
            DataSourceType::Custom => "CUSTOM",
            DataSourceType::Database => "DATABASE",
            DataSourceType::Googledrive => "GOOGLEDRIVE",
            DataSourceType::Onedrive => "ONEDRIVE",
            DataSourceType::S3 => "S3",
            DataSourceType::Salesforce => "SALESFORCE",
            DataSourceType::Servicenow => "SERVICENOW",
            DataSourceType::Sharepoint => "SHAREPOINT",
            DataSourceType::Webcrawler => "WEBCRAWLER",
            DataSourceType::Workdocs => "WORKDOCS",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFLUENCE",
            "CUSTOM",
            "DATABASE",
            "GOOGLEDRIVE",
            "ONEDRIVE",
            "S3",
            "SALESFORCE",
            "SERVICENOW",
            "SHAREPOINT",
            "WEBCRAWLER",
            "WORKDOCS",
        ]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A single query suggestion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Suggestion {
    /// <p>The unique UUID (universally unique identifier) of a single
    /// query suggestion.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value for the unique UUID (universally unique identifier)
    /// of a single query suggestion.</p>
    /// <p>The value is the text string of a suggestion.</p>
    pub value: std::option::Option<crate::model::SuggestionValue>,
}
impl Suggestion {
    /// <p>The unique UUID (universally unique identifier) of a single
    /// query suggestion.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value for the unique UUID (universally unique identifier)
    /// of a single query suggestion.</p>
    /// <p>The value is the text string of a suggestion.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::SuggestionValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for Suggestion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Suggestion");
        formatter.field("id", &self.id);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Suggestion`](crate::model::Suggestion)
pub mod suggestion {
    /// A builder for [`Suggestion`](crate::model::Suggestion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::SuggestionValue>,
    }
    impl Builder {
        /// <p>The unique UUID (universally unique identifier) of a single
        /// query suggestion.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique UUID (universally unique identifier) of a single
        /// query suggestion.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value for the unique UUID (universally unique identifier)
        /// of a single query suggestion.</p>
        /// <p>The value is the text string of a suggestion.</p>
        pub fn value(mut self, input: crate::model::SuggestionValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value for the unique UUID (universally unique identifier)
        /// of a single query suggestion.</p>
        /// <p>The value is the text string of a suggestion.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::SuggestionValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Suggestion`](crate::model::Suggestion)
        pub fn build(self) -> crate::model::Suggestion {
            crate::model::Suggestion {
                id: self.id,
                value: self.value,
            }
        }
    }
}
impl Suggestion {
    /// Creates a new builder-style object to manufacture [`Suggestion`](crate::model::Suggestion)
    pub fn builder() -> crate::model::suggestion::Builder {
        crate::model::suggestion::Builder::default()
    }
}

/// <p>The <code>SuggestionTextWithHighlights</code> structure information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestionValue {
    /// <p>The <code>SuggestionTextWithHighlights</code> structure that contains
    /// the query suggestion text and highlights.</p>
    pub text: std::option::Option<crate::model::SuggestionTextWithHighlights>,
}
impl SuggestionValue {
    /// <p>The <code>SuggestionTextWithHighlights</code> structure that contains
    /// the query suggestion text and highlights.</p>
    pub fn text(&self) -> std::option::Option<&crate::model::SuggestionTextWithHighlights> {
        self.text.as_ref()
    }
}
impl std::fmt::Debug for SuggestionValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestionValue");
        formatter.field("text", &self.text);
        formatter.finish()
    }
}
/// See [`SuggestionValue`](crate::model::SuggestionValue)
pub mod suggestion_value {
    /// A builder for [`SuggestionValue`](crate::model::SuggestionValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<crate::model::SuggestionTextWithHighlights>,
    }
    impl Builder {
        /// <p>The <code>SuggestionTextWithHighlights</code> structure that contains
        /// the query suggestion text and highlights.</p>
        pub fn text(mut self, input: crate::model::SuggestionTextWithHighlights) -> Self {
            self.text = Some(input);
            self
        }
        /// <p>The <code>SuggestionTextWithHighlights</code> structure that contains
        /// the query suggestion text and highlights.</p>
        pub fn set_text(
            mut self,
            input: std::option::Option<crate::model::SuggestionTextWithHighlights>,
        ) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestionValue`](crate::model::SuggestionValue)
        pub fn build(self) -> crate::model::SuggestionValue {
            crate::model::SuggestionValue { text: self.text }
        }
    }
}
impl SuggestionValue {
    /// Creates a new builder-style object to manufacture [`SuggestionValue`](crate::model::SuggestionValue)
    pub fn builder() -> crate::model::suggestion_value::Builder {
        crate::model::suggestion_value::Builder::default()
    }
}

/// <p>Provides text and information about where to highlight the query suggestion text.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestionTextWithHighlights {
    /// <p>The query suggestion text to display to the user.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The beginning and end of the query suggestion text that should be highlighted.</p>
    pub highlights: std::option::Option<std::vec::Vec<crate::model::SuggestionHighlight>>,
}
impl SuggestionTextWithHighlights {
    /// <p>The query suggestion text to display to the user.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The beginning and end of the query suggestion text that should be highlighted.</p>
    pub fn highlights(&self) -> std::option::Option<&[crate::model::SuggestionHighlight]> {
        self.highlights.as_deref()
    }
}
impl std::fmt::Debug for SuggestionTextWithHighlights {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestionTextWithHighlights");
        formatter.field("text", &self.text);
        formatter.field("highlights", &self.highlights);
        formatter.finish()
    }
}
/// See [`SuggestionTextWithHighlights`](crate::model::SuggestionTextWithHighlights)
pub mod suggestion_text_with_highlights {
    /// A builder for [`SuggestionTextWithHighlights`](crate::model::SuggestionTextWithHighlights)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) highlights:
            std::option::Option<std::vec::Vec<crate::model::SuggestionHighlight>>,
    }
    impl Builder {
        /// <p>The query suggestion text to display to the user.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The query suggestion text to display to the user.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `highlights`.
        ///
        /// To override the contents of this collection use [`set_highlights`](Self::set_highlights).
        ///
        /// <p>The beginning and end of the query suggestion text that should be highlighted.</p>
        pub fn highlights(mut self, input: impl Into<crate::model::SuggestionHighlight>) -> Self {
            let mut v = self.highlights.unwrap_or_default();
            v.push(input.into());
            self.highlights = Some(v);
            self
        }
        /// <p>The beginning and end of the query suggestion text that should be highlighted.</p>
        pub fn set_highlights(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuggestionHighlight>>,
        ) -> Self {
            self.highlights = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestionTextWithHighlights`](crate::model::SuggestionTextWithHighlights)
        pub fn build(self) -> crate::model::SuggestionTextWithHighlights {
            crate::model::SuggestionTextWithHighlights {
                text: self.text,
                highlights: self.highlights,
            }
        }
    }
}
impl SuggestionTextWithHighlights {
    /// Creates a new builder-style object to manufacture [`SuggestionTextWithHighlights`](crate::model::SuggestionTextWithHighlights)
    pub fn builder() -> crate::model::suggestion_text_with_highlights::Builder {
        crate::model::suggestion_text_with_highlights::Builder::default()
    }
}

/// <p>The text highlights for a single query suggestion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestionHighlight {
    /// <p>The zero-based location in the response string where the highlight starts.</p>
    pub begin_offset: std::option::Option<i32>,
    /// <p>The zero-based location in the response string where the highlight ends.</p>
    pub end_offset: std::option::Option<i32>,
}
impl SuggestionHighlight {
    /// <p>The zero-based location in the response string where the highlight starts.</p>
    pub fn begin_offset(&self) -> std::option::Option<i32> {
        self.begin_offset
    }
    /// <p>The zero-based location in the response string where the highlight ends.</p>
    pub fn end_offset(&self) -> std::option::Option<i32> {
        self.end_offset
    }
}
impl std::fmt::Debug for SuggestionHighlight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestionHighlight");
        formatter.field("begin_offset", &self.begin_offset);
        formatter.field("end_offset", &self.end_offset);
        formatter.finish()
    }
}
/// See [`SuggestionHighlight`](crate::model::SuggestionHighlight)
pub mod suggestion_highlight {
    /// A builder for [`SuggestionHighlight`](crate::model::SuggestionHighlight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_offset: std::option::Option<i32>,
        pub(crate) end_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The zero-based location in the response string where the highlight starts.</p>
        pub fn begin_offset(mut self, input: i32) -> Self {
            self.begin_offset = Some(input);
            self
        }
        /// <p>The zero-based location in the response string where the highlight starts.</p>
        pub fn set_begin_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset = input;
            self
        }
        /// <p>The zero-based location in the response string where the highlight ends.</p>
        pub fn end_offset(mut self, input: i32) -> Self {
            self.end_offset = Some(input);
            self
        }
        /// <p>The zero-based location in the response string where the highlight ends.</p>
        pub fn set_end_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestionHighlight`](crate::model::SuggestionHighlight)
        pub fn build(self) -> crate::model::SuggestionHighlight {
            crate::model::SuggestionHighlight {
                begin_offset: self.begin_offset,
                end_offset: self.end_offset,
            }
        }
    }
}
impl SuggestionHighlight {
    /// Creates a new builder-style object to manufacture [`SuggestionHighlight`](crate::model::SuggestionHighlight)
    pub fn builder() -> crate::model::suggestion_highlight::Builder {
        crate::model::suggestion_highlight::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuerySuggestionsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuerySuggestionsStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => QuerySuggestionsStatus::Active,
            "UPDATING" => QuerySuggestionsStatus::Updating,
            other => QuerySuggestionsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuerySuggestionsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuerySuggestionsStatus::from(s))
    }
}
impl QuerySuggestionsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuerySuggestionsStatus::Active => "ACTIVE",
            QuerySuggestionsStatus::Updating => "UPDATING",
            QuerySuggestionsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "UPDATING"]
    }
}
impl AsRef<str> for QuerySuggestionsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information on the processing of <code>PUT</code> and <code>DELETE</code> actions
/// for mapping users to their groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupOrderingIdSummary {
    /// <p>The current processing status of actions for mapping users to their groups.
    /// The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
    /// <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>
    pub status: std::option::Option<crate::model::PrincipalMappingStatus>,
    /// <p>The last date-time an action was updated. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date-time an action was received by Amazon Kendra. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users to
    /// their groups.</p>
    pub received_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The order in which actions should complete processing. An action can
    /// be a <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub ordering_id: std::option::Option<i64>,
    /// <p>The reason an action could not be processed. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl GroupOrderingIdSummary {
    /// <p>The current processing status of actions for mapping users to their groups.
    /// The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
    /// <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PrincipalMappingStatus> {
        self.status.as_ref()
    }
    /// <p>The last date-time an action was updated. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The date-time an action was received by Amazon Kendra. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users to
    /// their groups.</p>
    pub fn received_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.received_at.as_ref()
    }
    /// <p>The order in which actions should complete processing. An action can
    /// be a <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub fn ordering_id(&self) -> std::option::Option<i64> {
        self.ordering_id
    }
    /// <p>The reason an action could not be processed. An action can be a
    /// <code>PUT</code> or <code>DELETE</code> action for mapping users
    /// to their groups.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for GroupOrderingIdSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupOrderingIdSummary");
        formatter.field("status", &self.status);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("received_at", &self.received_at);
        formatter.field("ordering_id", &self.ordering_id);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`GroupOrderingIdSummary`](crate::model::GroupOrderingIdSummary)
pub mod group_ordering_id_summary {
    /// A builder for [`GroupOrderingIdSummary`](crate::model::GroupOrderingIdSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::PrincipalMappingStatus>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) received_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ordering_id: std::option::Option<i64>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current processing status of actions for mapping users to their groups.
        /// The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
        /// <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>
        pub fn status(mut self, input: crate::model::PrincipalMappingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current processing status of actions for mapping users to their groups.
        /// The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>,
        /// <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PrincipalMappingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The last date-time an action was updated. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The last date-time an action was updated. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The date-time an action was received by Amazon Kendra. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users to
        /// their groups.</p>
        pub fn received_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.received_at = Some(input);
            self
        }
        /// <p>The date-time an action was received by Amazon Kendra. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users to
        /// their groups.</p>
        pub fn set_received_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.received_at = input;
            self
        }
        /// <p>The order in which actions should complete processing. An action can
        /// be a <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn ordering_id(mut self, input: i64) -> Self {
            self.ordering_id = Some(input);
            self
        }
        /// <p>The order in which actions should complete processing. An action can
        /// be a <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.ordering_id = input;
            self
        }
        /// <p>The reason an action could not be processed. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason an action could not be processed. An action can be a
        /// <code>PUT</code> or <code>DELETE</code> action for mapping users
        /// to their groups.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupOrderingIdSummary`](crate::model::GroupOrderingIdSummary)
        pub fn build(self) -> crate::model::GroupOrderingIdSummary {
            crate::model::GroupOrderingIdSummary {
                status: self.status,
                last_updated_at: self.last_updated_at,
                received_at: self.received_at,
                ordering_id: self.ordering_id,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl GroupOrderingIdSummary {
    /// Creates a new builder-style object to manufacture [`GroupOrderingIdSummary`](crate::model::GroupOrderingIdSummary)
    pub fn builder() -> crate::model::group_ordering_id_summary::Builder {
        crate::model::group_ordering_id_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalMappingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalMappingStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => PrincipalMappingStatus::Deleted,
            "DELETING" => PrincipalMappingStatus::Deleting,
            "FAILED" => PrincipalMappingStatus::Failed,
            "PROCESSING" => PrincipalMappingStatus::Processing,
            "SUCCEEDED" => PrincipalMappingStatus::Succeeded,
            other => PrincipalMappingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalMappingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalMappingStatus::from(s))
    }
}
impl PrincipalMappingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalMappingStatus::Deleted => "DELETED",
            PrincipalMappingStatus::Deleting => "DELETING",
            PrincipalMappingStatus::Failed => "FAILED",
            PrincipalMappingStatus::Processing => "PROCESSING",
            PrincipalMappingStatus::Succeeded => "SUCCEEDED",
            PrincipalMappingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "DELETING", "FAILED", "PROCESSING", "SUCCEEDED"]
    }
}
impl AsRef<str> for PrincipalMappingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the number of documents and the number
/// of questions and answers in an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexStatistics {
    /// <p>The number of question and answer topics in the index.</p>
    pub faq_statistics: std::option::Option<crate::model::FaqStatistics>,
    /// <p>The number of text documents indexed.</p>
    pub text_document_statistics: std::option::Option<crate::model::TextDocumentStatistics>,
}
impl IndexStatistics {
    /// <p>The number of question and answer topics in the index.</p>
    pub fn faq_statistics(&self) -> std::option::Option<&crate::model::FaqStatistics> {
        self.faq_statistics.as_ref()
    }
    /// <p>The number of text documents indexed.</p>
    pub fn text_document_statistics(
        &self,
    ) -> std::option::Option<&crate::model::TextDocumentStatistics> {
        self.text_document_statistics.as_ref()
    }
}
impl std::fmt::Debug for IndexStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexStatistics");
        formatter.field("faq_statistics", &self.faq_statistics);
        formatter.field("text_document_statistics", &self.text_document_statistics);
        formatter.finish()
    }
}
/// See [`IndexStatistics`](crate::model::IndexStatistics)
pub mod index_statistics {
    /// A builder for [`IndexStatistics`](crate::model::IndexStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) faq_statistics: std::option::Option<crate::model::FaqStatistics>,
        pub(crate) text_document_statistics:
            std::option::Option<crate::model::TextDocumentStatistics>,
    }
    impl Builder {
        /// <p>The number of question and answer topics in the index.</p>
        pub fn faq_statistics(mut self, input: crate::model::FaqStatistics) -> Self {
            self.faq_statistics = Some(input);
            self
        }
        /// <p>The number of question and answer topics in the index.</p>
        pub fn set_faq_statistics(
            mut self,
            input: std::option::Option<crate::model::FaqStatistics>,
        ) -> Self {
            self.faq_statistics = input;
            self
        }
        /// <p>The number of text documents indexed.</p>
        pub fn text_document_statistics(
            mut self,
            input: crate::model::TextDocumentStatistics,
        ) -> Self {
            self.text_document_statistics = Some(input);
            self
        }
        /// <p>The number of text documents indexed.</p>
        pub fn set_text_document_statistics(
            mut self,
            input: std::option::Option<crate::model::TextDocumentStatistics>,
        ) -> Self {
            self.text_document_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexStatistics`](crate::model::IndexStatistics)
        pub fn build(self) -> crate::model::IndexStatistics {
            crate::model::IndexStatistics {
                faq_statistics: self.faq_statistics,
                text_document_statistics: self.text_document_statistics,
            }
        }
    }
}
impl IndexStatistics {
    /// Creates a new builder-style object to manufacture [`IndexStatistics`](crate::model::IndexStatistics)
    pub fn builder() -> crate::model::index_statistics::Builder {
        crate::model::index_statistics::Builder::default()
    }
}

/// <p>Provides information about text documents indexed in an
/// index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextDocumentStatistics {
    /// <p>The number of text documents indexed.</p>
    pub indexed_text_documents_count: i32,
    /// <p>The total size, in bytes, of the indexed documents.</p>
    pub indexed_text_bytes: i64,
}
impl TextDocumentStatistics {
    /// <p>The number of text documents indexed.</p>
    pub fn indexed_text_documents_count(&self) -> i32 {
        self.indexed_text_documents_count
    }
    /// <p>The total size, in bytes, of the indexed documents.</p>
    pub fn indexed_text_bytes(&self) -> i64 {
        self.indexed_text_bytes
    }
}
impl std::fmt::Debug for TextDocumentStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextDocumentStatistics");
        formatter.field(
            "indexed_text_documents_count",
            &self.indexed_text_documents_count,
        );
        formatter.field("indexed_text_bytes", &self.indexed_text_bytes);
        formatter.finish()
    }
}
/// See [`TextDocumentStatistics`](crate::model::TextDocumentStatistics)
pub mod text_document_statistics {
    /// A builder for [`TextDocumentStatistics`](crate::model::TextDocumentStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) indexed_text_documents_count: std::option::Option<i32>,
        pub(crate) indexed_text_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of text documents indexed.</p>
        pub fn indexed_text_documents_count(mut self, input: i32) -> Self {
            self.indexed_text_documents_count = Some(input);
            self
        }
        /// <p>The number of text documents indexed.</p>
        pub fn set_indexed_text_documents_count(mut self, input: std::option::Option<i32>) -> Self {
            self.indexed_text_documents_count = input;
            self
        }
        /// <p>The total size, in bytes, of the indexed documents.</p>
        pub fn indexed_text_bytes(mut self, input: i64) -> Self {
            self.indexed_text_bytes = Some(input);
            self
        }
        /// <p>The total size, in bytes, of the indexed documents.</p>
        pub fn set_indexed_text_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.indexed_text_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`TextDocumentStatistics`](crate::model::TextDocumentStatistics)
        pub fn build(self) -> crate::model::TextDocumentStatistics {
            crate::model::TextDocumentStatistics {
                indexed_text_documents_count: self.indexed_text_documents_count.unwrap_or_default(),
                indexed_text_bytes: self.indexed_text_bytes.unwrap_or_default(),
            }
        }
    }
}
impl TextDocumentStatistics {
    /// Creates a new builder-style object to manufacture [`TextDocumentStatistics`](crate::model::TextDocumentStatistics)
    pub fn builder() -> crate::model::text_document_statistics::Builder {
        crate::model::text_document_statistics::Builder::default()
    }
}

/// <p>Provides statistical information about the FAQ questions and
/// answers contained in an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaqStatistics {
    /// <p>The total number of FAQ questions and answers contained in the
    /// index.</p>
    pub indexed_question_answers_count: i32,
}
impl FaqStatistics {
    /// <p>The total number of FAQ questions and answers contained in the
    /// index.</p>
    pub fn indexed_question_answers_count(&self) -> i32 {
        self.indexed_question_answers_count
    }
}
impl std::fmt::Debug for FaqStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaqStatistics");
        formatter.field(
            "indexed_question_answers_count",
            &self.indexed_question_answers_count,
        );
        formatter.finish()
    }
}
/// See [`FaqStatistics`](crate::model::FaqStatistics)
pub mod faq_statistics {
    /// A builder for [`FaqStatistics`](crate::model::FaqStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) indexed_question_answers_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total number of FAQ questions and answers contained in the
        /// index.</p>
        pub fn indexed_question_answers_count(mut self, input: i32) -> Self {
            self.indexed_question_answers_count = Some(input);
            self
        }
        /// <p>The total number of FAQ questions and answers contained in the
        /// index.</p>
        pub fn set_indexed_question_answers_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.indexed_question_answers_count = input;
            self
        }
        /// Consumes the builder and constructs a [`FaqStatistics`](crate::model::FaqStatistics)
        pub fn build(self) -> crate::model::FaqStatistics {
            crate::model::FaqStatistics {
                indexed_question_answers_count: self
                    .indexed_question_answers_count
                    .unwrap_or_default(),
            }
        }
    }
}
impl FaqStatistics {
    /// Creates a new builder-style object to manufacture [`FaqStatistics`](crate::model::FaqStatistics)
    pub fn builder() -> crate::model::faq_statistics::Builder {
        crate::model::faq_statistics::Builder::default()
    }
}

/// <p>Provides the identifier of the KMScustomer master key (CMK)
/// used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support
/// asymmetric CMKs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionConfiguration {
    /// <p>The identifier of the KMScustomer master key (CMK). Amazon Kendra
    /// doesn't support asymmetric CMKs.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl ServerSideEncryptionConfiguration {
    /// <p>The identifier of the KMScustomer master key (CMK). Amazon Kendra
    /// doesn't support asymmetric CMKs.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for ServerSideEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionConfiguration");
        formatter.field("kms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
pub mod server_side_encryption_configuration {
    /// A builder for [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the KMScustomer master key (CMK). Amazon Kendra
        /// doesn't support asymmetric CMKs.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the KMScustomer master key (CMK). Amazon Kendra
        /// doesn't support asymmetric CMKs.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
        pub fn build(self) -> crate::model::ServerSideEncryptionConfiguration {
            crate::model::ServerSideEncryptionConfiguration {
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ServerSideEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    pub fn builder() -> crate::model::server_side_encryption_configuration::Builder {
        crate::model::server_side_encryption_configuration::Builder::default()
    }
}

/// <p>Provides information about a document that could not be
/// indexed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutDocumentResponseFailedDocument {
    /// <p>The unique identifier of the document.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of error that caused the document to fail to be
    /// indexed.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>A description of the reason why the document could not be
    /// indexed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchPutDocumentResponseFailedDocument {
    /// <p>The unique identifier of the document.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of error that caused the document to fail to be
    /// indexed.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A description of the reason why the document could not be
    /// indexed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchPutDocumentResponseFailedDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutDocumentResponseFailedDocument");
        formatter.field("id", &self.id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchPutDocumentResponseFailedDocument`](crate::model::BatchPutDocumentResponseFailedDocument)
pub mod batch_put_document_response_failed_document {
    /// A builder for [`BatchPutDocumentResponseFailedDocument`](crate::model::BatchPutDocumentResponseFailedDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of error that caused the document to fail to be
        /// indexed.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The type of error that caused the document to fail to be
        /// indexed.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A description of the reason why the document could not be
        /// indexed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A description of the reason why the document could not be
        /// indexed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutDocumentResponseFailedDocument`](crate::model::BatchPutDocumentResponseFailedDocument)
        pub fn build(self) -> crate::model::BatchPutDocumentResponseFailedDocument {
            crate::model::BatchPutDocumentResponseFailedDocument {
                id: self.id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchPutDocumentResponseFailedDocument {
    /// Creates a new builder-style object to manufacture [`BatchPutDocumentResponseFailedDocument`](crate::model::BatchPutDocumentResponseFailedDocument)
    pub fn builder() -> crate::model::batch_put_document_response_failed_document::Builder {
        crate::model::batch_put_document_response_failed_document::Builder::default()
    }
}

/// <p>A document in an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Document {
    /// <p>A unique identifier of the document in the index.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The title of the document.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The contents of the document. </p>
    /// <p>Documents passed to the <code>Blob</code> parameter must be base64
    /// encoded. Your code might not need to encode the document file bytes
    /// if you're using an Amazon Web Services SDK to call Amazon Kendra operations. If you are
    /// calling the Amazon Kendra endpoint directly using REST, you must base64
    /// encode the contents before sending.</p>
    pub blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Information required to find a specific file in an Amazon S3
    /// bucket.</p>
    pub s3_path: std::option::Option<crate::model::S3Path>,
    /// <p>Custom attributes to apply to the document. Use the custom
    /// attributes to provide additional information for searching, to
    /// provide facets for refining searches, and to provide additional
    /// information in the query response.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
    /// <p>Information on user and group access rights, which is used for
    /// user context filtering.</p>
    pub access_control_list: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    /// <p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
    /// that define the hierarchy for which documents users should have access to.</p>
    pub hierarchical_access_control_list:
        std::option::Option<std::vec::Vec<crate::model::HierarchicalPrincipal>>,
    /// <p>The file type of the document in the <code>Blob</code>
    /// field.</p>
    pub content_type: std::option::Option<crate::model::ContentType>,
}
impl Document {
    /// <p>A unique identifier of the document in the index.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The title of the document.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The contents of the document. </p>
    /// <p>Documents passed to the <code>Blob</code> parameter must be base64
    /// encoded. Your code might not need to encode the document file bytes
    /// if you're using an Amazon Web Services SDK to call Amazon Kendra operations. If you are
    /// calling the Amazon Kendra endpoint directly using REST, you must base64
    /// encode the contents before sending.</p>
    pub fn blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.blob.as_ref()
    }
    /// <p>Information required to find a specific file in an Amazon S3
    /// bucket.</p>
    pub fn s3_path(&self) -> std::option::Option<&crate::model::S3Path> {
        self.s3_path.as_ref()
    }
    /// <p>Custom attributes to apply to the document. Use the custom
    /// attributes to provide additional information for searching, to
    /// provide facets for refining searches, and to provide additional
    /// information in the query response.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::DocumentAttribute]> {
        self.attributes.as_deref()
    }
    /// <p>Information on user and group access rights, which is used for
    /// user context filtering.</p>
    pub fn access_control_list(&self) -> std::option::Option<&[crate::model::Principal]> {
        self.access_control_list.as_deref()
    }
    /// <p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
    /// that define the hierarchy for which documents users should have access to.</p>
    pub fn hierarchical_access_control_list(
        &self,
    ) -> std::option::Option<&[crate::model::HierarchicalPrincipal]> {
        self.hierarchical_access_control_list.as_deref()
    }
    /// <p>The file type of the document in the <code>Blob</code>
    /// field.</p>
    pub fn content_type(&self) -> std::option::Option<&crate::model::ContentType> {
        self.content_type.as_ref()
    }
}
impl std::fmt::Debug for Document {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Document");
        formatter.field("id", &self.id);
        formatter.field("title", &self.title);
        formatter.field("blob", &self.blob);
        formatter.field("s3_path", &self.s3_path);
        formatter.field("attributes", &self.attributes);
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field(
            "hierarchical_access_control_list",
            &self.hierarchical_access_control_list,
        );
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`Document`](crate::model::Document)
pub mod document {
    /// A builder for [`Document`](crate::model::Document)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) s3_path: std::option::Option<crate::model::S3Path>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
        pub(crate) access_control_list: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        pub(crate) hierarchical_access_control_list:
            std::option::Option<std::vec::Vec<crate::model::HierarchicalPrincipal>>,
        pub(crate) content_type: std::option::Option<crate::model::ContentType>,
    }
    impl Builder {
        /// <p>A unique identifier of the document in the index.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier of the document in the index.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The title of the document.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the document.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The contents of the document. </p>
        /// <p>Documents passed to the <code>Blob</code> parameter must be base64
        /// encoded. Your code might not need to encode the document file bytes
        /// if you're using an Amazon Web Services SDK to call Amazon Kendra operations. If you are
        /// calling the Amazon Kendra endpoint directly using REST, you must base64
        /// encode the contents before sending.</p>
        pub fn blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.blob = Some(input);
            self
        }
        /// <p>The contents of the document. </p>
        /// <p>Documents passed to the <code>Blob</code> parameter must be base64
        /// encoded. Your code might not need to encode the document file bytes
        /// if you're using an Amazon Web Services SDK to call Amazon Kendra operations. If you are
        /// calling the Amazon Kendra endpoint directly using REST, you must base64
        /// encode the contents before sending.</p>
        pub fn set_blob(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.blob = input;
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn s3_path(mut self, input: crate::model::S3Path) -> Self {
            self.s3_path = Some(input);
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<crate::model::S3Path>) -> Self {
            self.s3_path = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Custom attributes to apply to the document. Use the custom
        /// attributes to provide additional information for searching, to
        /// provide facets for refining searches, and to provide additional
        /// information in the query response.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::DocumentAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Custom attributes to apply to the document. Use the custom
        /// attributes to provide additional information for searching, to
        /// provide facets for refining searches, and to provide additional
        /// information in the query response.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `access_control_list`.
        ///
        /// To override the contents of this collection use [`set_access_control_list`](Self::set_access_control_list).
        ///
        /// <p>Information on user and group access rights, which is used for
        /// user context filtering.</p>
        pub fn access_control_list(mut self, input: impl Into<crate::model::Principal>) -> Self {
            let mut v = self.access_control_list.unwrap_or_default();
            v.push(input.into());
            self.access_control_list = Some(v);
            self
        }
        /// <p>Information on user and group access rights, which is used for
        /// user context filtering.</p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// Appends an item to `hierarchical_access_control_list`.
        ///
        /// To override the contents of this collection use [`set_hierarchical_access_control_list`](Self::set_hierarchical_access_control_list).
        ///
        /// <p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
        /// that define the hierarchy for which documents users should have access to.</p>
        pub fn hierarchical_access_control_list(
            mut self,
            input: impl Into<crate::model::HierarchicalPrincipal>,
        ) -> Self {
            let mut v = self.hierarchical_access_control_list.unwrap_or_default();
            v.push(input.into());
            self.hierarchical_access_control_list = Some(v);
            self
        }
        /// <p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
        /// that define the hierarchy for which documents users should have access to.</p>
        pub fn set_hierarchical_access_control_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HierarchicalPrincipal>>,
        ) -> Self {
            self.hierarchical_access_control_list = input;
            self
        }
        /// <p>The file type of the document in the <code>Blob</code>
        /// field.</p>
        pub fn content_type(mut self, input: crate::model::ContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The file type of the document in the <code>Blob</code>
        /// field.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::ContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Document`](crate::model::Document)
        pub fn build(self) -> crate::model::Document {
            crate::model::Document {
                id: self.id,
                title: self.title,
                blob: self.blob,
                s3_path: self.s3_path,
                attributes: self.attributes,
                access_control_list: self.access_control_list,
                hierarchical_access_control_list: self.hierarchical_access_control_list,
                content_type: self.content_type,
            }
        }
    }
}
impl Document {
    /// Creates a new builder-style object to manufacture [`Document`](crate::model::Document)
    pub fn builder() -> crate::model::document::Builder {
        crate::model::document::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentType {
    #[allow(missing_docs)] // documentation missing in model
    Html,
    #[allow(missing_docs)] // documentation missing in model
    MsWord,
    #[allow(missing_docs)] // documentation missing in model
    Pdf,
    #[allow(missing_docs)] // documentation missing in model
    PlainText,
    #[allow(missing_docs)] // documentation missing in model
    Ppt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentType {
    fn from(s: &str) -> Self {
        match s {
            "HTML" => ContentType::Html,
            "MS_WORD" => ContentType::MsWord,
            "PDF" => ContentType::Pdf,
            "PLAIN_TEXT" => ContentType::PlainText,
            "PPT" => ContentType::Ppt,
            other => ContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentType::from(s))
    }
}
impl ContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentType::Html => "HTML",
            ContentType::MsWord => "MS_WORD",
            ContentType::Pdf => "PDF",
            ContentType::PlainText => "PLAIN_TEXT",
            ContentType::Ppt => "PPT",
            ContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTML", "MS_WORD", "PDF", "PLAIN_TEXT", "PPT"]
    }
}
impl AsRef<str> for ContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information to define the hierarchy for which documents users should have access to.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchicalPrincipal {
    /// <p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
    /// that define the hierarchy for which documents users should have access to.
    /// Each hierarchical list specifies which user or group has allow or deny
    /// access for each document.</p>
    pub principal_list: std::option::Option<std::vec::Vec<crate::model::Principal>>,
}
impl HierarchicalPrincipal {
    /// <p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
    /// that define the hierarchy for which documents users should have access to.
    /// Each hierarchical list specifies which user or group has allow or deny
    /// access for each document.</p>
    pub fn principal_list(&self) -> std::option::Option<&[crate::model::Principal]> {
        self.principal_list.as_deref()
    }
}
impl std::fmt::Debug for HierarchicalPrincipal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchicalPrincipal");
        formatter.field("principal_list", &self.principal_list);
        formatter.finish()
    }
}
/// See [`HierarchicalPrincipal`](crate::model::HierarchicalPrincipal)
pub mod hierarchical_principal {
    /// A builder for [`HierarchicalPrincipal`](crate::model::HierarchicalPrincipal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_list: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    }
    impl Builder {
        /// Appends an item to `principal_list`.
        ///
        /// To override the contents of this collection use [`set_principal_list`](Self::set_principal_list).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
        /// that define the hierarchy for which documents users should have access to.
        /// Each hierarchical list specifies which user or group has allow or deny
        /// access for each document.</p>
        pub fn principal_list(mut self, input: impl Into<crate::model::Principal>) -> Self {
            let mut v = self.principal_list.unwrap_or_default();
            v.push(input.into());
            self.principal_list = Some(v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
        /// that define the hierarchy for which documents users should have access to.
        /// Each hierarchical list specifies which user or group has allow or deny
        /// access for each document.</p>
        pub fn set_principal_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.principal_list = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchicalPrincipal`](crate::model::HierarchicalPrincipal)
        pub fn build(self) -> crate::model::HierarchicalPrincipal {
            crate::model::HierarchicalPrincipal {
                principal_list: self.principal_list,
            }
        }
    }
}
impl HierarchicalPrincipal {
    /// Creates a new builder-style object to manufacture [`HierarchicalPrincipal`](crate::model::HierarchicalPrincipal)
    pub fn builder() -> crate::model::hierarchical_principal::Builder {
        crate::model::hierarchical_principal::Builder::default()
    }
}

/// <p>Provides user and group information for document access
/// filtering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Principal {
    /// <p>The name of the user or group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of principal.</p>
    pub r#type: std::option::Option<crate::model::PrincipalType>,
    /// <p>Whether to allow or deny access to the principal.</p>
    pub access: std::option::Option<crate::model::ReadAccessType>,
    /// <p>The identifier of the data source the principal should
    /// access documents from.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl Principal {
    /// <p>The name of the user or group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of principal.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PrincipalType> {
        self.r#type.as_ref()
    }
    /// <p>Whether to allow or deny access to the principal.</p>
    pub fn access(&self) -> std::option::Option<&crate::model::ReadAccessType> {
        self.access.as_ref()
    }
    /// <p>The identifier of the data source the principal should
    /// access documents from.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for Principal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Principal");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("access", &self.access);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`Principal`](crate::model::Principal)
pub mod principal {
    /// A builder for [`Principal`](crate::model::Principal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) access: std::option::Option<crate::model::ReadAccessType>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user or group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user or group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of principal.</p>
        pub fn r#type(mut self, input: crate::model::PrincipalType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of principal.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PrincipalType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Whether to allow or deny access to the principal.</p>
        pub fn access(mut self, input: crate::model::ReadAccessType) -> Self {
            self.access = Some(input);
            self
        }
        /// <p>Whether to allow or deny access to the principal.</p>
        pub fn set_access(
            mut self,
            input: std::option::Option<crate::model::ReadAccessType>,
        ) -> Self {
            self.access = input;
            self
        }
        /// <p>The identifier of the data source the principal should
        /// access documents from.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The identifier of the data source the principal should
        /// access documents from.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Principal`](crate::model::Principal)
        pub fn build(self) -> crate::model::Principal {
            crate::model::Principal {
                name: self.name,
                r#type: self.r#type,
                access: self.access,
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl Principal {
    /// Creates a new builder-style object to manufacture [`Principal`](crate::model::Principal)
    pub fn builder() -> crate::model::principal::Builder {
        crate::model::principal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReadAccessType {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReadAccessType {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => ReadAccessType::Allow,
            "DENY" => ReadAccessType::Deny,
            other => ReadAccessType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReadAccessType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReadAccessType::from(s))
    }
}
impl ReadAccessType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReadAccessType::Allow => "ALLOW",
            ReadAccessType::Deny => "DENY",
            ReadAccessType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for ReadAccessType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => PrincipalType::Group,
            "USER" => PrincipalType::User,
            other => PrincipalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalType::from(s))
    }
}
impl PrincipalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalType::Group => "GROUP",
            PrincipalType::User => "USER",
            PrincipalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "USER"]
    }
}
impl AsRef<str> for PrincipalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the status of documents submitted for indexing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Status {
    /// <p>The unique identifier of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The current status of a document.</p>
    /// <p>If the document was submitted for deletion, the status is
    /// <code>NOT_FOUND</code> after the document is deleted.</p>
    pub document_status: std::option::Option<crate::model::DocumentStatus>,
    /// <p>Indicates the source of the error.</p>
    pub failure_code: std::option::Option<std::string::String>,
    /// <p>Provides detailed information about why the document couldn't be
    /// indexed. Use this information to correct the error before you
    /// resubmit the document for indexing.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl Status {
    /// <p>The unique identifier of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>The current status of a document.</p>
    /// <p>If the document was submitted for deletion, the status is
    /// <code>NOT_FOUND</code> after the document is deleted.</p>
    pub fn document_status(&self) -> std::option::Option<&crate::model::DocumentStatus> {
        self.document_status.as_ref()
    }
    /// <p>Indicates the source of the error.</p>
    pub fn failure_code(&self) -> std::option::Option<&str> {
        self.failure_code.as_deref()
    }
    /// <p>Provides detailed information about why the document couldn't be
    /// indexed. Use this information to correct the error before you
    /// resubmit the document for indexing.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for Status {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Status");
        formatter.field("document_id", &self.document_id);
        formatter.field("document_status", &self.document_status);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`Status`](crate::model::Status)
pub mod status {
    /// A builder for [`Status`](crate::model::Status)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) document_status: std::option::Option<crate::model::DocumentStatus>,
        pub(crate) failure_code: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The current status of a document.</p>
        /// <p>If the document was submitted for deletion, the status is
        /// <code>NOT_FOUND</code> after the document is deleted.</p>
        pub fn document_status(mut self, input: crate::model::DocumentStatus) -> Self {
            self.document_status = Some(input);
            self
        }
        /// <p>The current status of a document.</p>
        /// <p>If the document was submitted for deletion, the status is
        /// <code>NOT_FOUND</code> after the document is deleted.</p>
        pub fn set_document_status(
            mut self,
            input: std::option::Option<crate::model::DocumentStatus>,
        ) -> Self {
            self.document_status = input;
            self
        }
        /// <p>Indicates the source of the error.</p>
        pub fn failure_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_code = Some(input.into());
            self
        }
        /// <p>Indicates the source of the error.</p>
        pub fn set_failure_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Provides detailed information about why the document couldn't be
        /// indexed. Use this information to correct the error before you
        /// resubmit the document for indexing.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>Provides detailed information about why the document couldn't be
        /// indexed. Use this information to correct the error before you
        /// resubmit the document for indexing.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Status`](crate::model::Status)
        pub fn build(self) -> crate::model::Status {
            crate::model::Status {
                document_id: self.document_id,
                document_status: self.document_status,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl Status {
    /// Creates a new builder-style object to manufacture [`Status`](crate::model::Status)
    pub fn builder() -> crate::model::status::Builder {
        crate::model::status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Indexed,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Updated,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DocumentStatus::Failed,
            "INDEXED" => DocumentStatus::Indexed,
            "NOT_FOUND" => DocumentStatus::NotFound,
            "PROCESSING" => DocumentStatus::Processing,
            "UPDATED" => DocumentStatus::Updated,
            "UPDATE_FAILED" => DocumentStatus::UpdateFailed,
            other => DocumentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentStatus::from(s))
    }
}
impl DocumentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentStatus::Failed => "FAILED",
            DocumentStatus::Indexed => "INDEXED",
            DocumentStatus::NotFound => "NOT_FOUND",
            DocumentStatus::Processing => "PROCESSING",
            DocumentStatus::Updated => "UPDATED",
            DocumentStatus::UpdateFailed => "UPDATE_FAILED",
            DocumentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "INDEXED",
            "NOT_FOUND",
            "PROCESSING",
            "UPDATED",
            "UPDATE_FAILED",
        ]
    }
}
impl AsRef<str> for DocumentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a response when the status of a document could not be retrieved.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDocumentStatusResponseError {
    /// <p>The unique identifier of the document whose status could not be retrieved.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>Indicates the source of the error.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>States that the API could not get the status of a document. This could be
    /// because the request is not valid or there is a system error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchGetDocumentStatusResponseError {
    /// <p>The unique identifier of the document whose status could not be retrieved.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>Indicates the source of the error.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>States that the API could not get the status of a document. This could be
    /// because the request is not valid or there is a system error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDocumentStatusResponseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDocumentStatusResponseError");
        formatter.field("document_id", &self.document_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchGetDocumentStatusResponseError`](crate::model::BatchGetDocumentStatusResponseError)
pub mod batch_get_document_status_response_error {
    /// A builder for [`BatchGetDocumentStatusResponseError`](crate::model::BatchGetDocumentStatusResponseError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the document whose status could not be retrieved.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the document whose status could not be retrieved.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>Indicates the source of the error.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Indicates the source of the error.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>States that the API could not get the status of a document. This could be
        /// because the request is not valid or there is a system error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>States that the API could not get the status of a document. This could be
        /// because the request is not valid or there is a system error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDocumentStatusResponseError`](crate::model::BatchGetDocumentStatusResponseError)
        pub fn build(self) -> crate::model::BatchGetDocumentStatusResponseError {
            crate::model::BatchGetDocumentStatusResponseError {
                document_id: self.document_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchGetDocumentStatusResponseError {
    /// Creates a new builder-style object to manufacture [`BatchGetDocumentStatusResponseError`](crate::model::BatchGetDocumentStatusResponseError)
    pub fn builder() -> crate::model::batch_get_document_status_response_error::Builder {
        crate::model::batch_get_document_status_response_error::Builder::default()
    }
}

/// <p>Identifies a document for which to retrieve status
/// information</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentInfo {
    /// <p>The unique identifier of the document.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>Attributes that identify a specific version of a document to
    /// check.</p>
    /// <p>The only valid attributes are:</p>
    /// <ul>
    /// <li>
    /// <p>version</p>
    /// </li>
    /// <li>
    /// <p>datasourceId</p>
    /// </li>
    /// <li>
    /// <p>jobExecutionId</p>
    /// </li>
    /// </ul>
    /// <p>The attributes follow these rules:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>dataSourceId</code> and <code>jobExecutionId</code>
    /// must be used together.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>version</code> is ignored if
    /// <code>dataSourceId</code> and
    /// <code>jobExecutionId</code> are not provided.</p>
    /// </li>
    /// <li>
    /// <p>If <code>dataSourceId</code> and
    /// <code>jobExecutionId</code> are provided, but
    /// <code>version</code> is not, the version defaults to
    /// "0".</p>
    /// </li>
    /// </ul>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
}
impl DocumentInfo {
    /// <p>The unique identifier of the document.</p>
    pub fn document_id(&self) -> std::option::Option<&str> {
        self.document_id.as_deref()
    }
    /// <p>Attributes that identify a specific version of a document to
    /// check.</p>
    /// <p>The only valid attributes are:</p>
    /// <ul>
    /// <li>
    /// <p>version</p>
    /// </li>
    /// <li>
    /// <p>datasourceId</p>
    /// </li>
    /// <li>
    /// <p>jobExecutionId</p>
    /// </li>
    /// </ul>
    /// <p>The attributes follow these rules:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>dataSourceId</code> and <code>jobExecutionId</code>
    /// must be used together.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>version</code> is ignored if
    /// <code>dataSourceId</code> and
    /// <code>jobExecutionId</code> are not provided.</p>
    /// </li>
    /// <li>
    /// <p>If <code>dataSourceId</code> and
    /// <code>jobExecutionId</code> are provided, but
    /// <code>version</code> is not, the version defaults to
    /// "0".</p>
    /// </li>
    /// </ul>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::DocumentAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for DocumentInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentInfo");
        formatter.field("document_id", &self.document_id);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DocumentInfo`](crate::model::DocumentInfo)
pub mod document_info {
    /// A builder for [`DocumentInfo`](crate::model::DocumentInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
    }
    impl Builder {
        /// <p>The unique identifier of the document.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the document.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Attributes that identify a specific version of a document to
        /// check.</p>
        /// <p>The only valid attributes are:</p>
        /// <ul>
        /// <li>
        /// <p>version</p>
        /// </li>
        /// <li>
        /// <p>datasourceId</p>
        /// </li>
        /// <li>
        /// <p>jobExecutionId</p>
        /// </li>
        /// </ul>
        /// <p>The attributes follow these rules:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>dataSourceId</code> and <code>jobExecutionId</code>
        /// must be used together.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code> is ignored if
        /// <code>dataSourceId</code> and
        /// <code>jobExecutionId</code> are not provided.</p>
        /// </li>
        /// <li>
        /// <p>If <code>dataSourceId</code> and
        /// <code>jobExecutionId</code> are provided, but
        /// <code>version</code> is not, the version defaults to
        /// "0".</p>
        /// </li>
        /// </ul>
        pub fn attributes(mut self, input: impl Into<crate::model::DocumentAttribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>Attributes that identify a specific version of a document to
        /// check.</p>
        /// <p>The only valid attributes are:</p>
        /// <ul>
        /// <li>
        /// <p>version</p>
        /// </li>
        /// <li>
        /// <p>datasourceId</p>
        /// </li>
        /// <li>
        /// <p>jobExecutionId</p>
        /// </li>
        /// </ul>
        /// <p>The attributes follow these rules:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>dataSourceId</code> and <code>jobExecutionId</code>
        /// must be used together.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code> is ignored if
        /// <code>dataSourceId</code> and
        /// <code>jobExecutionId</code> are not provided.</p>
        /// </li>
        /// <li>
        /// <p>If <code>dataSourceId</code> and
        /// <code>jobExecutionId</code> are provided, but
        /// <code>version</code> is not, the version defaults to
        /// "0".</p>
        /// </li>
        /// </ul>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentInfo`](crate::model::DocumentInfo)
        pub fn build(self) -> crate::model::DocumentInfo {
            crate::model::DocumentInfo {
                document_id: self.document_id,
                attributes: self.attributes,
            }
        }
    }
}
impl DocumentInfo {
    /// Creates a new builder-style object to manufacture [`DocumentInfo`](crate::model::DocumentInfo)
    pub fn builder() -> crate::model::document_info::Builder {
        crate::model::document_info::Builder::default()
    }
}

/// <p>Provides information about documents that could not be removed
/// from an index by the <code>BatchDeleteDocument</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDocumentResponseFailedDocument {
    /// <p>The identifier of the document that couldn't be removed from the
    /// index.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The error code for why the document couldn't be removed from the
    /// index.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>An explanation for why the document couldn't be removed from the
    /// index.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchDeleteDocumentResponseFailedDocument {
    /// <p>The identifier of the document that couldn't be removed from the
    /// index.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The error code for why the document couldn't be removed from the
    /// index.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>An explanation for why the document couldn't be removed from the
    /// index.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteDocumentResponseFailedDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDocumentResponseFailedDocument");
        formatter.field("id", &self.id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchDeleteDocumentResponseFailedDocument`](crate::model::BatchDeleteDocumentResponseFailedDocument)
pub mod batch_delete_document_response_failed_document {
    /// A builder for [`BatchDeleteDocumentResponseFailedDocument`](crate::model::BatchDeleteDocumentResponseFailedDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the document that couldn't be removed from the
        /// index.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the document that couldn't be removed from the
        /// index.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The error code for why the document couldn't be removed from the
        /// index.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code for why the document couldn't be removed from the
        /// index.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An explanation for why the document couldn't be removed from the
        /// index.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An explanation for why the document couldn't be removed from the
        /// index.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDocumentResponseFailedDocument`](crate::model::BatchDeleteDocumentResponseFailedDocument)
        pub fn build(self) -> crate::model::BatchDeleteDocumentResponseFailedDocument {
            crate::model::BatchDeleteDocumentResponseFailedDocument {
                id: self.id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchDeleteDocumentResponseFailedDocument {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDocumentResponseFailedDocument`](crate::model::BatchDeleteDocumentResponseFailedDocument)
    pub fn builder() -> crate::model::batch_delete_document_response_failed_document::Builder {
        crate::model::batch_delete_document_response_failed_document::Builder::default()
    }
}

/// <p>Maps a particular data source sync job to a particular data
/// source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceSyncJobMetricTarget {
    /// <p>The ID of the data source that is running the sync job.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The ID of the sync job that is running on the data source.</p>
    /// <p>If the ID of a sync job is not provided and there is a sync job
    /// running, then the ID of this sync job is used and metrics are
    /// generated for this sync job.</p>
    /// <p>If the ID of a sync job is not provided and there is no sync job
    /// running, then no metrics are generated and documents are  
    /// indexed/deleted at the index level without sync job metrics included.</p>
    pub data_source_sync_job_id: std::option::Option<std::string::String>,
}
impl DataSourceSyncJobMetricTarget {
    /// <p>The ID of the data source that is running the sync job.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The ID of the sync job that is running on the data source.</p>
    /// <p>If the ID of a sync job is not provided and there is a sync job
    /// running, then the ID of this sync job is used and metrics are
    /// generated for this sync job.</p>
    /// <p>If the ID of a sync job is not provided and there is no sync job
    /// running, then no metrics are generated and documents are  
    /// indexed/deleted at the index level without sync job metrics included.</p>
    pub fn data_source_sync_job_id(&self) -> std::option::Option<&str> {
        self.data_source_sync_job_id.as_deref()
    }
}
impl std::fmt::Debug for DataSourceSyncJobMetricTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceSyncJobMetricTarget");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_source_sync_job_id", &self.data_source_sync_job_id);
        formatter.finish()
    }
}
/// See [`DataSourceSyncJobMetricTarget`](crate::model::DataSourceSyncJobMetricTarget)
pub mod data_source_sync_job_metric_target {
    /// A builder for [`DataSourceSyncJobMetricTarget`](crate::model::DataSourceSyncJobMetricTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_source_sync_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the data source that is running the sync job.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source that is running the sync job.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The ID of the sync job that is running on the data source.</p>
        /// <p>If the ID of a sync job is not provided and there is a sync job
        /// running, then the ID of this sync job is used and metrics are
        /// generated for this sync job.</p>
        /// <p>If the ID of a sync job is not provided and there is no sync job
        /// running, then no metrics are generated and documents are  
        /// indexed/deleted at the index level without sync job metrics included.</p>
        pub fn data_source_sync_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_sync_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the sync job that is running on the data source.</p>
        /// <p>If the ID of a sync job is not provided and there is a sync job
        /// running, then the ID of this sync job is used and metrics are
        /// generated for this sync job.</p>
        /// <p>If the ID of a sync job is not provided and there is no sync job
        /// running, then no metrics are generated and documents are  
        /// indexed/deleted at the index level without sync job metrics included.</p>
        pub fn set_data_source_sync_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_sync_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceSyncJobMetricTarget`](crate::model::DataSourceSyncJobMetricTarget)
        pub fn build(self) -> crate::model::DataSourceSyncJobMetricTarget {
            crate::model::DataSourceSyncJobMetricTarget {
                data_source_id: self.data_source_id,
                data_source_sync_job_id: self.data_source_sync_job_id,
            }
        }
    }
}
impl DataSourceSyncJobMetricTarget {
    /// Creates a new builder-style object to manufacture [`DataSourceSyncJobMetricTarget`](crate::model::DataSourceSyncJobMetricTarget)
    pub fn builder() -> crate::model::data_source_sync_job_metric_target::Builder {
        crate::model::data_source_sync_job_metric_target::Builder::default()
    }
}
