// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSKendraFrontendService`.
///
/// This client allows ergonomic access to a `AWSKendraFrontendService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchDeleteDocument` operation.
    ///
    /// See [`BatchDeleteDocument`](crate::client::fluent_builders::BatchDeleteDocument) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_document(&self) -> fluent_builders::BatchDeleteDocument<C, M, R> {
        fluent_builders::BatchDeleteDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDocumentStatus` operation.
    ///
    /// See [`BatchGetDocumentStatus`](crate::client::fluent_builders::BatchGetDocumentStatus) for more information about the
    /// operation and its arguments.
    pub fn batch_get_document_status(&self) -> fluent_builders::BatchGetDocumentStatus<C, M, R> {
        fluent_builders::BatchGetDocumentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchPutDocument` operation.
    ///
    /// See [`BatchPutDocument`](crate::client::fluent_builders::BatchPutDocument) for more information about the
    /// operation and its arguments.
    pub fn batch_put_document(&self) -> fluent_builders::BatchPutDocument<C, M, R> {
        fluent_builders::BatchPutDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ClearQuerySuggestions` operation.
    ///
    /// See [`ClearQuerySuggestions`](crate::client::fluent_builders::ClearQuerySuggestions) for more information about the
    /// operation and its arguments.
    pub fn clear_query_suggestions(&self) -> fluent_builders::ClearQuerySuggestions<C, M, R> {
        fluent_builders::ClearQuerySuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSource` operation.
    ///
    /// See [`CreateDataSource`](crate::client::fluent_builders::CreateDataSource) for more information about the
    /// operation and its arguments.
    pub fn create_data_source(&self) -> fluent_builders::CreateDataSource<C, M, R> {
        fluent_builders::CreateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFaq` operation.
    ///
    /// See [`CreateFaq`](crate::client::fluent_builders::CreateFaq) for more information about the
    /// operation and its arguments.
    pub fn create_faq(&self) -> fluent_builders::CreateFaq<C, M, R> {
        fluent_builders::CreateFaq::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIndex` operation.
    ///
    /// See [`CreateIndex`](crate::client::fluent_builders::CreateIndex) for more information about the
    /// operation and its arguments.
    pub fn create_index(&self) -> fluent_builders::CreateIndex<C, M, R> {
        fluent_builders::CreateIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQuerySuggestionsBlockList` operation.
    ///
    /// See [`CreateQuerySuggestionsBlockList`](crate::client::fluent_builders::CreateQuerySuggestionsBlockList) for more information about the
    /// operation and its arguments.
    pub fn create_query_suggestions_block_list(
        &self,
    ) -> fluent_builders::CreateQuerySuggestionsBlockList<C, M, R> {
        fluent_builders::CreateQuerySuggestionsBlockList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThesaurus` operation.
    ///
    /// See [`CreateThesaurus`](crate::client::fluent_builders::CreateThesaurus) for more information about the
    /// operation and its arguments.
    pub fn create_thesaurus(&self) -> fluent_builders::CreateThesaurus<C, M, R> {
        fluent_builders::CreateThesaurus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSource` operation.
    ///
    /// See [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) for more information about the
    /// operation and its arguments.
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource<C, M, R> {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFaq` operation.
    ///
    /// See [`DeleteFaq`](crate::client::fluent_builders::DeleteFaq) for more information about the
    /// operation and its arguments.
    pub fn delete_faq(&self) -> fluent_builders::DeleteFaq<C, M, R> {
        fluent_builders::DeleteFaq::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIndex` operation.
    ///
    /// See [`DeleteIndex`](crate::client::fluent_builders::DeleteIndex) for more information about the
    /// operation and its arguments.
    pub fn delete_index(&self) -> fluent_builders::DeleteIndex<C, M, R> {
        fluent_builders::DeleteIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePrincipalMapping` operation.
    ///
    /// See [`DeletePrincipalMapping`](crate::client::fluent_builders::DeletePrincipalMapping) for more information about the
    /// operation and its arguments.
    pub fn delete_principal_mapping(&self) -> fluent_builders::DeletePrincipalMapping<C, M, R> {
        fluent_builders::DeletePrincipalMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQuerySuggestionsBlockList` operation.
    ///
    /// See [`DeleteQuerySuggestionsBlockList`](crate::client::fluent_builders::DeleteQuerySuggestionsBlockList) for more information about the
    /// operation and its arguments.
    pub fn delete_query_suggestions_block_list(
        &self,
    ) -> fluent_builders::DeleteQuerySuggestionsBlockList<C, M, R> {
        fluent_builders::DeleteQuerySuggestionsBlockList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThesaurus` operation.
    ///
    /// See [`DeleteThesaurus`](crate::client::fluent_builders::DeleteThesaurus) for more information about the
    /// operation and its arguments.
    pub fn delete_thesaurus(&self) -> fluent_builders::DeleteThesaurus<C, M, R> {
        fluent_builders::DeleteThesaurus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSource` operation.
    ///
    /// See [`DescribeDataSource`](crate::client::fluent_builders::DescribeDataSource) for more information about the
    /// operation and its arguments.
    pub fn describe_data_source(&self) -> fluent_builders::DescribeDataSource<C, M, R> {
        fluent_builders::DescribeDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFaq` operation.
    ///
    /// See [`DescribeFaq`](crate::client::fluent_builders::DescribeFaq) for more information about the
    /// operation and its arguments.
    pub fn describe_faq(&self) -> fluent_builders::DescribeFaq<C, M, R> {
        fluent_builders::DescribeFaq::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIndex` operation.
    ///
    /// See [`DescribeIndex`](crate::client::fluent_builders::DescribeIndex) for more information about the
    /// operation and its arguments.
    pub fn describe_index(&self) -> fluent_builders::DescribeIndex<C, M, R> {
        fluent_builders::DescribeIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePrincipalMapping` operation.
    ///
    /// See [`DescribePrincipalMapping`](crate::client::fluent_builders::DescribePrincipalMapping) for more information about the
    /// operation and its arguments.
    pub fn describe_principal_mapping(&self) -> fluent_builders::DescribePrincipalMapping<C, M, R> {
        fluent_builders::DescribePrincipalMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeQuerySuggestionsBlockList` operation.
    ///
    /// See [`DescribeQuerySuggestionsBlockList`](crate::client::fluent_builders::DescribeQuerySuggestionsBlockList) for more information about the
    /// operation and its arguments.
    pub fn describe_query_suggestions_block_list(
        &self,
    ) -> fluent_builders::DescribeQuerySuggestionsBlockList<C, M, R> {
        fluent_builders::DescribeQuerySuggestionsBlockList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeQuerySuggestionsConfig` operation.
    ///
    /// See [`DescribeQuerySuggestionsConfig`](crate::client::fluent_builders::DescribeQuerySuggestionsConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_query_suggestions_config(
        &self,
    ) -> fluent_builders::DescribeQuerySuggestionsConfig<C, M, R> {
        fluent_builders::DescribeQuerySuggestionsConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThesaurus` operation.
    ///
    /// See [`DescribeThesaurus`](crate::client::fluent_builders::DescribeThesaurus) for more information about the
    /// operation and its arguments.
    pub fn describe_thesaurus(&self) -> fluent_builders::DescribeThesaurus<C, M, R> {
        fluent_builders::DescribeThesaurus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQuerySuggestions` operation.
    ///
    /// See [`GetQuerySuggestions`](crate::client::fluent_builders::GetQuerySuggestions) for more information about the
    /// operation and its arguments.
    pub fn get_query_suggestions(&self) -> fluent_builders::GetQuerySuggestions<C, M, R> {
        fluent_builders::GetQuerySuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSources` operation.
    ///
    /// See [`ListDataSources`](crate::client::fluent_builders::ListDataSources) for more information about the
    /// operation and its arguments.
    pub fn list_data_sources(&self) -> fluent_builders::ListDataSources<C, M, R> {
        fluent_builders::ListDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSourceSyncJobs` operation.
    ///
    /// See [`ListDataSourceSyncJobs`](crate::client::fluent_builders::ListDataSourceSyncJobs) for more information about the
    /// operation and its arguments.
    pub fn list_data_source_sync_jobs(&self) -> fluent_builders::ListDataSourceSyncJobs<C, M, R> {
        fluent_builders::ListDataSourceSyncJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFaqs` operation.
    ///
    /// See [`ListFaqs`](crate::client::fluent_builders::ListFaqs) for more information about the
    /// operation and its arguments.
    pub fn list_faqs(&self) -> fluent_builders::ListFaqs<C, M, R> {
        fluent_builders::ListFaqs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupsOlderThanOrderingId` operation.
    ///
    /// See [`ListGroupsOlderThanOrderingId`](crate::client::fluent_builders::ListGroupsOlderThanOrderingId) for more information about the
    /// operation and its arguments.
    pub fn list_groups_older_than_ordering_id(
        &self,
    ) -> fluent_builders::ListGroupsOlderThanOrderingId<C, M, R> {
        fluent_builders::ListGroupsOlderThanOrderingId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIndices` operation.
    ///
    /// See [`ListIndices`](crate::client::fluent_builders::ListIndices) for more information about the
    /// operation and its arguments.
    pub fn list_indices(&self) -> fluent_builders::ListIndices<C, M, R> {
        fluent_builders::ListIndices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQuerySuggestionsBlockLists` operation.
    ///
    /// See [`ListQuerySuggestionsBlockLists`](crate::client::fluent_builders::ListQuerySuggestionsBlockLists) for more information about the
    /// operation and its arguments.
    pub fn list_query_suggestions_block_lists(
        &self,
    ) -> fluent_builders::ListQuerySuggestionsBlockLists<C, M, R> {
        fluent_builders::ListQuerySuggestionsBlockLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThesauri` operation.
    ///
    /// See [`ListThesauri`](crate::client::fluent_builders::ListThesauri) for more information about the
    /// operation and its arguments.
    pub fn list_thesauri(&self) -> fluent_builders::ListThesauri<C, M, R> {
        fluent_builders::ListThesauri::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPrincipalMapping` operation.
    ///
    /// See [`PutPrincipalMapping`](crate::client::fluent_builders::PutPrincipalMapping) for more information about the
    /// operation and its arguments.
    pub fn put_principal_mapping(&self) -> fluent_builders::PutPrincipalMapping<C, M, R> {
        fluent_builders::PutPrincipalMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Query` operation.
    ///
    /// See [`Query`](crate::client::fluent_builders::Query) for more information about the
    /// operation and its arguments.
    pub fn query(&self) -> fluent_builders::Query<C, M, R> {
        fluent_builders::Query::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDataSourceSyncJob` operation.
    ///
    /// See [`StartDataSourceSyncJob`](crate::client::fluent_builders::StartDataSourceSyncJob) for more information about the
    /// operation and its arguments.
    pub fn start_data_source_sync_job(&self) -> fluent_builders::StartDataSourceSyncJob<C, M, R> {
        fluent_builders::StartDataSourceSyncJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDataSourceSyncJob` operation.
    ///
    /// See [`StopDataSourceSyncJob`](crate::client::fluent_builders::StopDataSourceSyncJob) for more information about the
    /// operation and its arguments.
    pub fn stop_data_source_sync_job(&self) -> fluent_builders::StopDataSourceSyncJob<C, M, R> {
        fluent_builders::StopDataSourceSyncJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SubmitFeedback` operation.
    ///
    /// See [`SubmitFeedback`](crate::client::fluent_builders::SubmitFeedback) for more information about the
    /// operation and its arguments.
    pub fn submit_feedback(&self) -> fluent_builders::SubmitFeedback<C, M, R> {
        fluent_builders::SubmitFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSource` operation.
    ///
    /// See [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) for more information about the
    /// operation and its arguments.
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource<C, M, R> {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIndex` operation.
    ///
    /// See [`UpdateIndex`](crate::client::fluent_builders::UpdateIndex) for more information about the
    /// operation and its arguments.
    pub fn update_index(&self) -> fluent_builders::UpdateIndex<C, M, R> {
        fluent_builders::UpdateIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQuerySuggestionsBlockList` operation.
    ///
    /// See [`UpdateQuerySuggestionsBlockList`](crate::client::fluent_builders::UpdateQuerySuggestionsBlockList) for more information about the
    /// operation and its arguments.
    pub fn update_query_suggestions_block_list(
        &self,
    ) -> fluent_builders::UpdateQuerySuggestionsBlockList<C, M, R> {
        fluent_builders::UpdateQuerySuggestionsBlockList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQuerySuggestionsConfig` operation.
    ///
    /// See [`UpdateQuerySuggestionsConfig`](crate::client::fluent_builders::UpdateQuerySuggestionsConfig) for more information about the
    /// operation and its arguments.
    pub fn update_query_suggestions_config(
        &self,
    ) -> fluent_builders::UpdateQuerySuggestionsConfig<C, M, R> {
        fluent_builders::UpdateQuerySuggestionsConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThesaurus` operation.
    ///
    /// See [`UpdateThesaurus`](crate::client::fluent_builders::UpdateThesaurus) for more information about the
    /// operation and its arguments.
    pub fn update_thesaurus(&self) -> fluent_builders::UpdateThesaurus<C, M, R> {
        fluent_builders::UpdateThesaurus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteDocument`.
    ///
    /// <p>Removes one or more documents from an index. The documents must have
    /// been added with the <code>BatchPutDocument</code> operation.</p>
    /// <p>The documents are deleted asynchronously. You can see the progress of
    /// the deletion by using Amazon Web Services CloudWatch. Any error messages related to the
    /// processing of the batch are sent to you CloudWatch log.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_document_input::Builder,
    }
    impl<C, M, R> BatchDeleteDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteDocumentInputOperationOutputAlias,
                crate::output::BatchDeleteDocumentOutput,
                crate::error::BatchDeleteDocumentError,
                crate::input::BatchDeleteDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index that contains the documents to
        /// delete.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the documents to
        /// delete.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// Appends an item to `DocumentIdList`.
        ///
        /// To override the contents of this collection use [`set_document_id_list`](Self::set_document_id_list).
        ///
        /// <p>One or more identifiers for documents to delete from the index.</p>
        pub fn document_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id_list(inp);
            self
        }
        /// <p>One or more identifiers for documents to delete from the index.</p>
        pub fn set_document_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_document_id_list(input);
            self
        }
        /// <p>Maps a particular data source sync job to a particular data
        /// source.</p>
        pub fn data_source_sync_job_metric_target(
            mut self,
            inp: crate::model::DataSourceSyncJobMetricTarget,
        ) -> Self {
            self.inner = self.inner.data_source_sync_job_metric_target(inp);
            self
        }
        /// <p>Maps a particular data source sync job to a particular data
        /// source.</p>
        pub fn set_data_source_sync_job_metric_target(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobMetricTarget>,
        ) -> Self {
            self.inner = self.inner.set_data_source_sync_job_metric_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDocumentStatus`.
    ///
    /// <p>Returns the indexing status for one or more documents submitted
    /// with the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">
    /// BatchPutDocument</a> operation.</p>
    /// <p>When you use the <code>BatchPutDocument</code> operation,
    /// documents are indexed asynchronously. You can use the
    /// <code>BatchGetDocumentStatus</code> operation to get the current
    /// status of a list of documents so that you can determine if they have
    /// been successfully indexed.</p>
    /// <p>You can also use the <code>BatchGetDocumentStatus</code> operation
    /// to check the status of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html">
    /// BatchDeleteDocument</a> operation. When a document is
    /// deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the
    /// status.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDocumentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_document_status_input::Builder,
    }
    impl<C, M, R> BatchGetDocumentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDocumentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDocumentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDocumentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDocumentStatusInputOperationOutputAlias,
                crate::output::BatchGetDocumentStatusOutput,
                crate::error::BatchGetDocumentStatusError,
                crate::input::BatchGetDocumentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index to add documents to. The index ID is
        /// returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex
        /// </a> operation.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index to add documents to. The index ID is
        /// returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex
        /// </a> operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// Appends an item to `DocumentInfoList`.
        ///
        /// To override the contents of this collection use [`set_document_info_list`](Self::set_document_info_list).
        ///
        /// <p>A list of <code>DocumentInfo</code> objects that identify the
        /// documents for which to get the status. You identify the documents by
        /// their document ID and optional attributes.</p>
        pub fn document_info_list(mut self, inp: impl Into<crate::model::DocumentInfo>) -> Self {
            self.inner = self.inner.document_info_list(inp);
            self
        }
        /// <p>A list of <code>DocumentInfo</code> objects that identify the
        /// documents for which to get the status. You identify the documents by
        /// their document ID and optional attributes.</p>
        pub fn set_document_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentInfo>>,
        ) -> Self {
            self.inner = self.inner.set_document_info_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchPutDocument`.
    ///
    /// <p>Adds one or more documents to an index.</p>
    /// <p>The <code>BatchPutDocument</code> operation enables you to ingest
    /// inline documents or a set of documents stored in an Amazon S3 bucket. Use
    /// this operation to ingest your text and unstructured text into an index,
    /// add custom attributes to the documents, and to attach an access control
    /// list to the documents added to the index.</p>
    /// <p>The documents are indexed asynchronously. You can see the progress of
    /// the batch using Amazon Web Services CloudWatch. Any error messages related to processing
    /// the batch are sent to your Amazon Web Services CloudWatch log.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchPutDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_document_input::Builder,
    }
    impl<C, M, R> BatchPutDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutDocumentInputOperationOutputAlias,
                crate::output::BatchPutDocumentOutput,
                crate::error::BatchPutDocumentError,
                crate::input::BatchPutDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index to add the documents to. You need to
        /// create the index first using the <code>CreateIndex</code>
        /// operation.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index to add the documents to. You need to
        /// create the index first using the <code>CreateIndex</code>
        /// operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the
        /// <code>BatchPutDocument</code> operation. For more information, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM
        /// Roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that is allowed to run the
        /// <code>BatchPutDocument</code> operation. For more information, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM
        /// Roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Documents`.
        ///
        /// To override the contents of this collection use [`set_documents`](Self::set_documents).
        ///
        /// <p>One or more documents to add to the index.</p>
        /// <p>Documents can include custom attributes. For example,
        /// 'DataSourceId' and 'DataSourceSyncJobId' are custom
        /// attributes that provide information on the synchronization
        /// of documents running on a data source. Note,
        /// 'DataSourceSyncJobId' could be an optional custom attribute
        /// as Amazon Kendra will use the ID of a running sync job.</p>
        /// <p>Documents have the following file size limits.</p>
        /// <ul>
        /// <li>
        /// <p>5 MB total size for inline documents</p>
        /// </li>
        /// <li>
        /// <p>50 MB total size for files from an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>5 MB extracted text for any file</p>
        /// </li>
        /// </ul>
        /// <p>For more information about file size and transaction per second
        /// quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn documents(mut self, inp: impl Into<crate::model::Document>) -> Self {
            self.inner = self.inner.documents(inp);
            self
        }
        /// <p>One or more documents to add to the index.</p>
        /// <p>Documents can include custom attributes. For example,
        /// 'DataSourceId' and 'DataSourceSyncJobId' are custom
        /// attributes that provide information on the synchronization
        /// of documents running on a data source. Note,
        /// 'DataSourceSyncJobId' could be an optional custom attribute
        /// as Amazon Kendra will use the ID of a running sync job.</p>
        /// <p>Documents have the following file size limits.</p>
        /// <ul>
        /// <li>
        /// <p>5 MB total size for inline documents</p>
        /// </li>
        /// <li>
        /// <p>50 MB total size for files from an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>5 MB extracted text for any file</p>
        /// </li>
        /// </ul>
        /// <p>For more information about file size and transaction per second
        /// quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn set_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Document>>,
        ) -> Self {
            self.inner = self.inner.set_documents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClearQuerySuggestions`.
    ///
    /// <p>Clears existing query suggestions from an index.</p>
    /// <p>This deletes existing suggestions only, not the queries
    /// in the query log. After you clear suggestions, Amazon Kendra learns
    /// new suggestions based on new queries added to the query log
    /// from the time you cleared suggestions. If you do not see any
    /// new suggestions, then please allow Amazon Kendra to collect
    /// enough queries to learn new suggestions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ClearQuerySuggestions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::clear_query_suggestions_input::Builder,
    }
    impl<C, M, R> ClearQuerySuggestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ClearQuerySuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClearQuerySuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ClearQuerySuggestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ClearQuerySuggestionsInputOperationOutputAlias,
                crate::output::ClearQuerySuggestionsOutput,
                crate::error::ClearQuerySuggestionsError,
                crate::input::ClearQuerySuggestionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to clear query suggestions from.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to clear query suggestions from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSource`.
    ///
    /// <p>Creates a data source that you want to use with an Amazon Kendra index. </p>
    /// <p>You specify a name, data source connector type and description for
    /// your data source. You also specify configuration information for the
    /// data source connector.</p>
    /// <p>
    /// <code>CreateDataSource</code> is a synchronous operation. The
    /// operation returns 200 if the data source was successfully created.
    /// Otherwise, an exception is raised.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_input::Builder,
    }
    impl<C, M, R> CreateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceInputOperationOutputAlias,
                crate::output::CreateDataSourceOutput,
                crate::error::CreateDataSourceError,
                crate::input::CreateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the data source. A data source name can't be changed
        /// without deleting and recreating the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the data source. A data source name can't be changed
        /// without deleting and recreating the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier of the index that should be associated with this data
        /// source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that should be associated with this data
        /// source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The type of repository that contains the data source.</p>
        pub fn r#type(mut self, inp: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of repository that contains the data source.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The connector configuration information that is required to access the
        /// repository.</p>
        /// <p>You can't specify the <code>Configuration</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>Configuration</code> parameter is required for all other
        /// data sources.</p>
        pub fn configuration(mut self, inp: crate::model::DataSourceConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The connector configuration information that is required to access the
        /// repository.</p>
        /// <p>You can't specify the <code>Configuration</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>Configuration</code> parameter is required for all other
        /// data sources.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>A description for the data source.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Sets the frequency that Amazon Kendra will check the documents in your
        /// repository and update the index. If you don't set a schedule Amazon Kendra
        /// will not periodically update the index. You can call the
        /// <code>StartDataSourceSyncJob</code> operation to update the
        /// index.</p>
        /// <p>You can't specify the <code>Schedule</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>Sets the frequency that Amazon Kendra will check the documents in your
        /// repository and update the index. If you don't set a schedule Amazon Kendra
        /// will not periodically update the index. You can call the
        /// <code>StartDataSourceSyncJob</code> operation to update the
        /// index.</p>
        /// <p>You can't specify the <code>Schedule</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the
        /// data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
        /// Amazon Kendra</a>.</p>
        /// <p>You can't specify the <code>RoleArn</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>RoleArn</code> parameter is required for all other data
        /// sources.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the
        /// data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
        /// Amazon Kendra</a>.</p>
        /// <p>You can't specify the <code>RoleArn</code> parameter when the
        /// <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do,
        /// you receive a <code>ValidationException</code> exception.</p>
        /// <p>The <code>RoleArn</code> parameter is required for all other data
        /// sources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the data source. You can use
        /// the tags to identify and organize your resources and to control access to
        /// resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs that identify the data source. You can use
        /// the tags to identify and organize your resources and to control access to
        /// resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A token that you provide to identify the request to create a data
        /// source. Multiple calls to the <code>CreateDataSource</code> operation with
        /// the same client token will create only one data source.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that you provide to identify the request to create a data
        /// source. Multiple calls to the <code>CreateDataSource</code> operation with
        /// the same client token will create only one data source.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The code for a language. This allows you to support a language for all
        /// documents when creating the data source. English is supported
        /// by default. For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The code for a language. This allows you to support a language for all
        /// documents when creating the data source. English is supported
        /// by default. For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFaq`.
    ///
    /// <p>Creates an new set of frequently asked question (FAQ) questions and answers.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFaq<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_faq_input::Builder,
    }
    impl<C, M, R> CreateFaq<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFaq`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFaqOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFaqError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFaqInputOperationOutputAlias,
                crate::output::CreateFaqOutput,
                crate::error::CreateFaqError,
                crate::input::CreateFaqInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The name that should be associated with the FAQ.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that should be associated with the FAQ.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the FAQ.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the FAQ.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The S3 location of the FAQ input data.</p>
        pub fn s3_path(mut self, inp: crate::model::S3Path) -> Self {
            self.inner = self.inner.s3_path(inp);
            self
        }
        /// <p>The S3 location of the FAQ input data.</p>
        pub fn set_s3_path(mut self, input: std::option::Option<crate::model::S3Path>) -> Self {
            self.inner = self.inner.set_s3_path(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that
        /// contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that
        /// contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and
        /// organize your resources and to control access to resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and
        /// organize your resources and to control access to resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format
        /// that includes customs attributes in a header, and a JSON format that includes custom
        /// attributes.</p>
        /// <p>The format must match the format of the file stored in the S3 bucket identified in the
        /// <code>S3Path</code> parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
        /// answers</a>.</p>
        pub fn file_format(mut self, inp: crate::model::FaqFileFormat) -> Self {
            self.inner = self.inner.file_format(inp);
            self
        }
        /// <p>The format of the input file. You can choose between a basic CSV format, a CSV format
        /// that includes customs attributes in a header, and a JSON format that includes custom
        /// attributes.</p>
        /// <p>The format must match the format of the file stored in the S3 bucket identified in the
        /// <code>S3Path</code> parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
        /// answers</a>.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::FaqFileFormat>,
        ) -> Self {
            self.inner = self.inner.set_file_format(input);
            self
        }
        /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to
        /// the <code>CreateFaqRequest</code> operation with the same client token will create only
        /// one FAQ. </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that you provide to identify the request to create a FAQ. Multiple calls to
        /// the <code>CreateFaqRequest</code> operation with the same client token will create only
        /// one FAQ. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The code for a language. This allows you to support a language
        /// for the FAQ document. English is supported by default.
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The code for a language. This allows you to support a language
        /// for the FAQ document. English is supported by default.
        /// For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIndex`.
    ///
    /// <p>Creates a new Amazon Kendra index. Index creation is an asynchronous
    /// operation. To determine if index creation has completed, check the
    /// <code>Status</code> field returned from a call to
    /// <code>DescribeIndex</code>. The <code>Status</code> field is set to
    /// <code>ACTIVE</code> when the index is ready to use.</p>
    /// <p>Once the index is active you can index your documents using the
    /// <code>BatchPutDocument</code> operation or using one of the supported
    /// data sources. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_index_input::Builder,
    }
    impl<C, M, R> CreateIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIndexInputOperationOutputAlias,
                crate::output::CreateIndexOutput,
                crate::error::CreateIndexError,
                crate::input::CreateIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the new index.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new index.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Kendra edition to use for the index. Choose
        /// <code>DEVELOPER_EDITION</code> for indexes intended for development,
        /// testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
        /// production databases. Once you set the edition for an index, it can't be
        /// changed.</p>
        /// <p>The <code>Edition</code> parameter is optional. If you don't supply a
        /// value, the default is <code>ENTERPRISE_EDITION</code>.</p>
        /// <p>For more information on quota limits for enterprise and developer editions,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn edition(mut self, inp: crate::model::IndexEdition) -> Self {
            self.inner = self.inner.edition(inp);
            self
        }
        /// <p>The Amazon Kendra edition to use for the index. Choose
        /// <code>DEVELOPER_EDITION</code> for indexes intended for development,
        /// testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your
        /// production databases. Once you set the edition for an index, it can't be
        /// changed.</p>
        /// <p>The <code>Edition</code> parameter is optional. If you don't supply a
        /// value, the default is <code>ENTERPRISE_EDITION</code>.</p>
        /// <p>For more information on quota limits for enterprise and developer editions,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>
        pub fn set_edition(
            mut self,
            input: std::option::Option<crate::model::IndexEdition>,
        ) -> Self {
            self.inner = self.inner.set_edition(input);
            self
        }
        /// <p>An Identity and Access Management(IAM) role that gives
        /// Amazon Kendra permissions to access your Amazon CloudWatch logs and
        /// metrics. This is also the role used when you use the
        /// <code>BatchPutDocument</code> operation to index documents from an
        /// Amazon S3 bucket.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>An Identity and Access Management(IAM) role that gives
        /// Amazon Kendra permissions to access your Amazon CloudWatch logs and
        /// metrics. This is also the role used when you use the
        /// <code>BatchPutDocument</code> operation to index documents from an
        /// Amazon S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The identifier of the KMScustomer managed key (CMK) to use to
        /// encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support
        /// asymmetric CMKs.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            inp: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(inp);
            self
        }
        /// <p>The identifier of the KMScustomer managed key (CMK) to use to
        /// encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support
        /// asymmetric CMKs.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
        /// <p>A description for the index.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the index.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A token that you provide to identify the request to create an index.
        /// Multiple calls to the <code>CreateIndex</code> operation with the same
        /// client token will create only one index.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that you provide to identify the request to create an index.
        /// Multiple calls to the <code>CreateIndex</code> operation with the same
        /// client token will create only one index.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the index. You can use the
        /// tags to identify and organize your resources and to control access to
        /// resources.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs that identify the index. You can use the
        /// tags to identify and organize your resources and to control access to
        /// resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `UserTokenConfigurations`.
        ///
        /// To override the contents of this collection use [`set_user_token_configurations`](Self::set_user_token_configurations).
        ///
        /// <p>The user token configuration.</p>
        pub fn user_token_configurations(
            mut self,
            inp: impl Into<crate::model::UserTokenConfiguration>,
        ) -> Self {
            self.inner = self.inner.user_token_configurations(inp);
            self
        }
        /// <p>The user token configuration.</p>
        pub fn set_user_token_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_user_token_configurations(input);
            self
        }
        /// <p>The user context policy.</p>
        /// <dl>
        /// <dt>ATTRIBUTE_FILTER</dt>
        /// <dd>
        /// <p>All indexed content is searchable and displayable
        /// for all users. If you want to filter search results on
        /// user context, you can use the attribute filters of
        /// <code>_user_id</code> and <code>_group_ids</code> or
        /// you can provide user and group information in <code>UserContext</code>.
        /// </p>
        /// </dd>
        /// <dt>USER_TOKEN</dt>
        /// <dd>
        /// <p>Enables token-based user access control to filter
        /// search results on user context. All documents with no
        /// access control and all documents accessible to the user
        /// will be searchable and displayable.
        /// </p>
        /// </dd>
        /// </dl>
        pub fn user_context_policy(mut self, inp: crate::model::UserContextPolicy) -> Self {
            self.inner = self.inner.user_context_policy(inp);
            self
        }
        /// <p>The user context policy.</p>
        /// <dl>
        /// <dt>ATTRIBUTE_FILTER</dt>
        /// <dd>
        /// <p>All indexed content is searchable and displayable
        /// for all users. If you want to filter search results on
        /// user context, you can use the attribute filters of
        /// <code>_user_id</code> and <code>_group_ids</code> or
        /// you can provide user and group information in <code>UserContext</code>.
        /// </p>
        /// </dd>
        /// <dt>USER_TOKEN</dt>
        /// <dd>
        /// <p>Enables token-based user access control to filter
        /// search results on user context. All documents with no
        /// access control and all documents accessible to the user
        /// will be searchable and displayable.
        /// </p>
        /// </dd>
        /// </dl>
        pub fn set_user_context_policy(
            mut self,
            input: std::option::Option<crate::model::UserContextPolicy>,
        ) -> Self {
            self.inner = self.inner.set_user_context_policy(input);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an AWS Single Sign-On
        /// identity source. To configure this, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn user_group_resolution_configuration(
            mut self,
            inp: crate::model::UserGroupResolutionConfiguration,
        ) -> Self {
            self.inner = self.inner.user_group_resolution_configuration(inp);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an AWS Single Sign-On
        /// identity source. To configure this, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn set_user_group_resolution_configuration(
            mut self,
            input: std::option::Option<crate::model::UserGroupResolutionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_user_group_resolution_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQuerySuggestionsBlockList`.
    ///
    /// <p>Creates a block list to exlcude certain queries from suggestions.</p>
    /// <p>Any query that contains words or phrases specified in the block
    /// list is blocked or filtered out from being shown as a suggestion.</p>
    /// <p>You need to provide the file location of your block list text file
    /// in your S3 bucket. In your text file, enter each block word or phrase
    /// on a separate line.</p>
    /// <p>For information on the current quota limits for block lists, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
    /// for Amazon Kendra</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateQuerySuggestionsBlockList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_query_suggestions_block_list_input::Builder,
    }
    impl<C, M, R> CreateQuerySuggestionsBlockList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQuerySuggestionsBlockList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQuerySuggestionsBlockListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQuerySuggestionsBlockListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQuerySuggestionsBlockListInputOperationOutputAlias,
                crate::output::CreateQuerySuggestionsBlockListOutput,
                crate::error::CreateQuerySuggestionsBlockListError,
                crate::input::CreateQuerySuggestionsBlockListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to create a query suggestions block list for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>A user friendly name for the block list.</p>
        /// <p>For example, the block list named 'offensive-words' includes all
        /// offensive words that could appear in user queries and need to be
        /// blocked from suggestions.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A user friendly name for the block list.</p>
        /// <p>For example, the block list named 'offensive-words' includes all
        /// offensive words that could appear in user queries and need to be
        /// blocked from suggestions.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A user-friendly description for the block list.</p>
        /// <p>For example, the description "List of all offensive words that can
        /// appear in user queries and need to be blocked from suggestions."</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A user-friendly description for the block list.</p>
        /// <p>For example, the description "List of all offensive words that can
        /// appear in user queries and need to be blocked from suggestions."</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The S3 path to your block list text file in your S3 bucket.</p>
        /// <p>Each block word or phrase should be on a separate line in a text file.</p>
        /// <p>For information on the current quota limits for block lists, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
        /// for Amazon Kendra</a>.</p>
        pub fn source_s3_path(mut self, inp: crate::model::S3Path) -> Self {
            self.inner = self.inner.source_s3_path(inp);
            self
        }
        /// <p>The S3 path to your block list text file in your S3 bucket.</p>
        /// <p>Each block word or phrase should be on a separate line in a text file.</p>
        /// <p>For information on the current quota limits for block lists, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
        /// for Amazon Kendra</a>.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_path(input);
            self
        }
        /// <p>A token that you provide to identify the request to create a
        /// query suggestions block list.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that you provide to identify the request to create a
        /// query suggestions block list.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to
        /// access the block list text file in your S3 bucket.</p>
        /// <p>You need permissions to the role ARN (Amazon Resource Name).
        /// The role needs S3 read permissions to your file in S3 and needs
        /// to give STS (Security Token Service) assume role permissions
        /// to Amazon Kendra.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The IAM (Identity and Access Management) role used by Amazon Kendra to
        /// access the block list text file in your S3 bucket.</p>
        /// <p>You need permissions to the role ARN (Amazon Resource Name).
        /// The role needs S3 read permissions to your file in S3 and needs
        /// to give STS (Security Token Service) assume role permissions
        /// to Amazon Kendra.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A tag that you can assign to a block list that categorizes
        /// the block list.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A tag that you can assign to a block list that categorizes
        /// the block list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThesaurus`.
    ///
    /// <p>Creates a thesaurus for an index. The thesaurus
    /// contains a list of synonyms in Solr format.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateThesaurus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thesaurus_input::Builder,
    }
    impl<C, M, R> CreateThesaurus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThesaurus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThesaurusOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThesaurusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThesaurusInputOperationOutputAlias,
                crate::output::CreateThesaurusOutput,
                crate::error::CreateThesaurusError,
                crate::input::CreateThesaurusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the index for the new thesaurus.
        /// </p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The unique identifier of the index for the new thesaurus.
        /// </p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The name for the new thesaurus.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new thesaurus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description for the new thesaurus.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the new thesaurus.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions
        /// to access thesaurus file specified in <code>SourceS3Path</code>.
        /// </p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions
        /// to access thesaurus file specified in <code>SourceS3Path</code>.
        /// </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that identify the thesaurus. You can use
        /// the tags to identify and organize your resources and to control
        /// access to resources.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs that identify the thesaurus. You can use
        /// the tags to identify and organize your resources and to control
        /// access to resources.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The thesaurus file Amazon S3 source path.
        /// </p>
        pub fn source_s3_path(mut self, inp: crate::model::S3Path) -> Self {
            self.inner = self.inner.source_s3_path(inp);
            self
        }
        /// <p>The thesaurus file Amazon S3 source path.
        /// </p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_path(input);
            self
        }
        /// <p>A token that you provide to identify the request to create a
        /// thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation
        /// with the same client token will create only one thesaurus.
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A token that you provide to identify the request to create a
        /// thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation
        /// with the same client token will create only one thesaurus.
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Deletes an Amazon Kendra data source. An exception is not thrown if the
    /// data source is already being deleted. While the data source is being
    /// deleted, the <code>Status</code> field returned by a call to the
    /// <code>DescribeDataSource</code> operation is set to
    /// <code>DELETING</code>. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl<C, M, R> DeleteDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSourceInputOperationOutputAlias,
                crate::output::DeleteDataSourceOutput,
                crate::error::DeleteDataSourceError,
                crate::input::DeleteDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the data source to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the data source to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The unique identifier of the index associated with the data
        /// source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The unique identifier of the index associated with the data
        /// source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFaq`.
    ///
    /// <p>Removes an FAQ from an index.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFaq<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_faq_input::Builder,
    }
    impl<C, M, R> DeleteFaq<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFaq`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFaqOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFaqError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFaqInputOperationOutputAlias,
                crate::output::DeleteFaqOutput,
                crate::error::DeleteFaqError,
                crate::input::DeleteFaqInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the FAQ to remove.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the FAQ to remove.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The index to remove the FAQ from.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The index to remove the FAQ from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIndex`.
    ///
    /// <p>Deletes an existing Amazon Kendra index. An exception is not thrown if
    /// the index is already being deleted. While the index is being deleted, the
    /// <code>Status</code> field returned by a call to the
    /// <code>DescribeIndex</code> operation is set to
    /// <code>DELETING</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_index_input::Builder,
    }
    impl<C, M, R> DeleteIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIndexInputOperationOutputAlias,
                crate::output::DeleteIndexOutput,
                crate::error::DeleteIndexError,
                crate::input::DeleteIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the index to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePrincipalMapping`.
    ///
    /// <p>Deletes a group so that all users and sub groups that belong to the group can
    /// no longer access documents only available to that group.</p>
    /// <p>For example, after deleting the group "Summer Interns", all interns who
    /// belonged to that group no longer see intern-only documents in their search
    /// results.</p>
    /// <p>If you want to delete or replace users or sub groups of a group, you need to
    /// use the <code>PutPrincipalMapping</code> operation. For example, if a user in
    /// the group "Engineering" leaves the engineering team and another user takes
    /// their place, you provide an updated list of users or sub groups that belong
    /// to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You
    /// can update your internal list of users or sub groups and input this list
    /// when calling <code>PutPrincipalMapping</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePrincipalMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_principal_mapping_input::Builder,
    }
    impl<C, M, R> DeletePrincipalMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePrincipalMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePrincipalMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePrincipalMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePrincipalMappingInputOperationOutputAlias,
                crate::output::DeletePrincipalMappingOutput,
                crate::error::DeletePrincipalMappingError,
                crate::input::DeletePrincipalMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to delete a group from.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to delete a group from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The identifier of the data source you want to delete a group from.</p>
        /// <p>This is useful if a group is tied to multiple data sources and you want
        /// to delete a group from accessing documents in a certain data source. For example,
        /// the groups "Research", "Engineering", and "Sales and Marketing" are all tied to
        /// the company's documents stored in the data sources Confluence and Salesforce.
        /// You want to delete "Research" and "Engineering" groups from Salesforce, so that
        /// these groups cannot access customer-related documents stored in Salesforce.
        /// Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The identifier of the data source you want to delete a group from.</p>
        /// <p>This is useful if a group is tied to multiple data sources and you want
        /// to delete a group from accessing documents in a certain data source. For example,
        /// the groups "Research", "Engineering", and "Sales and Marketing" are all tied to
        /// the company's documents stored in the data sources Confluence and Salesforce.
        /// You want to delete "Research" and "Engineering" groups from Salesforce, so that
        /// these groups cannot access customer-related documents stored in Salesforce.
        /// Only "Sales and Marketing" should access documents in the Salesforce data source.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>The identifier of the group you want to delete.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier of the group you want to delete.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not
        /// override the latest <code>DELETE</code> action with previous actions.
        /// The highest number ID, which is the ordering ID, is the latest action
        /// you want to process and apply on top of other actions with lower number
        /// IDs. This prevents previous actions with lower number IDs from possibly
        /// overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group
        /// members list. You would then provide this list when calling
        /// <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action
        /// for that updated group with the latest members list doesn't get overwritten
        /// by earlier <code>DELETE</code> actions for the same group which are yet to
        /// be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the
        /// action was received by Amazon Kendra.
        /// </p>
        pub fn ordering_id(mut self, inp: i64) -> Self {
            self.inner = self.inner.ordering_id(inp);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not
        /// override the latest <code>DELETE</code> action with previous actions.
        /// The highest number ID, which is the ordering ID, is the latest action
        /// you want to process and apply on top of other actions with lower number
        /// IDs. This prevents previous actions with lower number IDs from possibly
        /// overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a group
        /// members list. You would then provide this list when calling
        /// <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action
        /// for that updated group with the latest members list doesn't get overwritten
        /// by earlier <code>DELETE</code> actions for the same group which are yet to
        /// be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the
        /// action was received by Amazon Kendra.
        /// </p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ordering_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQuerySuggestionsBlockList`.
    ///
    /// <p>Deletes a block list used for query suggestions for an index.</p>
    /// <p>A deleted block list might not take effect right away. Amazon Kendra
    /// needs to refresh the entire suggestions list to add back the
    /// queries that were previously blocked.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteQuerySuggestionsBlockList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_query_suggestions_block_list_input::Builder,
    }
    impl<C, M, R> DeleteQuerySuggestionsBlockList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQuerySuggestionsBlockList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQuerySuggestionsBlockListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQuerySuggestionsBlockListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQuerySuggestionsBlockListInputOperationOutputAlias,
                crate::output::DeleteQuerySuggestionsBlockListOutput,
                crate::error::DeleteQuerySuggestionsBlockListError,
                crate::input::DeleteQuerySuggestionsBlockListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the you want to delete a block list from.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the you want to delete a block list from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The unique identifier of the block list that needs to be deleted.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the block list that needs to be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThesaurus`.
    ///
    /// <p>Deletes an existing Amazon Kendra thesaurus.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteThesaurus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thesaurus_input::Builder,
    }
    impl<C, M, R> DeleteThesaurus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThesaurus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThesaurusOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThesaurusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThesaurusInputOperationOutputAlias,
                crate::output::DeleteThesaurusOutput,
                crate::error::DeleteThesaurusError,
                crate::input::DeleteThesaurusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the thesaurus to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the thesaurus to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to delete.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to delete.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSource`.
    ///
    /// <p>Gets information about a Amazon Kendra data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_source_input::Builder,
    }
    impl<C, M, R> DescribeDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourceInputOperationOutputAlias,
                crate::output::DescribeDataSourceOutput,
                crate::error::DescribeDataSourceError,
                crate::input::DescribeDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the data source to describe.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the data source to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFaq`.
    ///
    /// <p>Gets information about an FAQ list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFaq<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_faq_input::Builder,
    }
    impl<C, M, R> DescribeFaq<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFaq`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFaqOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFaqError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFaqInputOperationOutputAlias,
                crate::output::DescribeFaqOutput,
                crate::error::DescribeFaqError,
                crate::input::DescribeFaqInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the FAQ.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the FAQ.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the FAQ.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIndex`.
    ///
    /// <p>Describes an existing Amazon Kendra index</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_index_input::Builder,
    }
    impl<C, M, R> DescribeIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIndexInputOperationOutputAlias,
                crate::output::DescribeIndexOutput,
                crate::error::DescribeIndexError,
                crate::input::DescribeIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to describe.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The name of the index to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePrincipalMapping`.
    ///
    /// <p>Describes the processing of <code>PUT</code> and <code>DELETE</code> actions
    /// for mapping users to their groups. This includes information on the status of
    /// actions currently processing or yet to be processed, when actions were last updated,
    /// when actions were received by Amazon Kendra, the latest action that should process
    /// and apply after other actions, and useful error messages if an action could
    /// not be processed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePrincipalMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_principal_mapping_input::Builder,
    }
    impl<C, M, R> DescribePrincipalMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePrincipalMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePrincipalMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePrincipalMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePrincipalMappingInputOperationOutputAlias,
                crate::output::DescribePrincipalMappingOutput,
                crate::error::DescribePrincipalMappingError,
                crate::input::DescribePrincipalMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index required to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping users
        /// to their groups.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index required to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping users
        /// to their groups.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The identifier of the data source to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping
        /// users to their groups.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The identifier of the data source to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping
        /// users to their groups.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>The identifier of the group required to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping users
        /// to their groups.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier of the group required to check the processing of
        /// <code>PUT</code> and <code>DELETE</code> actions for mapping users
        /// to their groups.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQuerySuggestionsBlockList`.
    ///
    /// <p>Describes a block list used for query suggestions for an index.</p>
    /// <p>This is used to check the current settings that are applied to a
    /// block list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeQuerySuggestionsBlockList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_query_suggestions_block_list_input::Builder,
    }
    impl<C, M, R> DescribeQuerySuggestionsBlockList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQuerySuggestionsBlockList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQuerySuggestionsBlockListOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQuerySuggestionsBlockListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQuerySuggestionsBlockListInputOperationOutputAlias,
                crate::output::DescribeQuerySuggestionsBlockListOutput,
                crate::error::DescribeQuerySuggestionsBlockListError,
                crate::input::DescribeQuerySuggestionsBlockListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index for the block list.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index for the block list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The unique identifier of the block list.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the block list.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQuerySuggestionsConfig`.
    ///
    /// <p>Describes the settings of query suggestions for an index.</p>
    /// <p>This is used to check the current settings applied
    /// to query suggestions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeQuerySuggestionsConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_query_suggestions_config_input::Builder,
    }
    impl<C, M, R> DescribeQuerySuggestionsConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQuerySuggestionsConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQuerySuggestionsConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQuerySuggestionsConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQuerySuggestionsConfigInputOperationOutputAlias,
                crate::output::DescribeQuerySuggestionsConfigOutput,
                crate::error::DescribeQuerySuggestionsConfigError,
                crate::input::DescribeQuerySuggestionsConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to describe query suggestions
        /// settings for.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to describe query suggestions
        /// settings for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThesaurus`.
    ///
    /// <p>Describes an existing Amazon Kendra thesaurus.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeThesaurus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thesaurus_input::Builder,
    }
    impl<C, M, R> DescribeThesaurus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThesaurus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThesaurusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThesaurusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThesaurusInputOperationOutputAlias,
                crate::output::DescribeThesaurusOutput,
                crate::error::DescribeThesaurusError,
                crate::input::DescribeThesaurusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the thesaurus to describe.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the thesaurus to describe.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to describe.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to describe.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQuerySuggestions`.
    ///
    /// <p>Fetches the queries that are suggested to your users.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetQuerySuggestions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_suggestions_input::Builder,
    }
    impl<C, M, R> GetQuerySuggestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQuerySuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQuerySuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQuerySuggestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQuerySuggestionsInputOperationOutputAlias,
                crate::output::GetQuerySuggestionsOutput,
                crate::error::GetQuerySuggestionsError,
                crate::input::GetQuerySuggestionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to get query suggestions from.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to get query suggestions from.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The text of a user's query to generate query suggestions.</p>
        /// <p>A query is suggested if the query prefix matches
        /// what a user starts to type as their query.</p>
        /// <p>Amazon Kendra does not show any suggestions if a user
        /// types fewer than two characters or more than 60 characters.
        /// A query must also have at least one search result and contain
        /// at least one word of more than four characters.</p>
        pub fn query_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_text(inp);
            self
        }
        /// <p>The text of a user's query to generate query suggestions.</p>
        /// <p>A query is suggested if the query prefix matches
        /// what a user starts to type as their query.</p>
        /// <p>Amazon Kendra does not show any suggestions if a user
        /// types fewer than two characters or more than 60 characters.
        /// A query must also have at least one search result and contain
        /// at least one word of more than four characters.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_text(input);
            self
        }
        /// <p>The maximum number of query suggestions you want to show
        /// to your users.</p>
        pub fn max_suggestions_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_suggestions_count(inp);
            self
        }
        /// <p>The maximum number of query suggestions you want to show
        /// to your users.</p>
        pub fn set_max_suggestions_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_suggestions_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSources`.
    ///
    /// <p>Lists the data sources that you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataSources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sources_input::Builder,
    }
    impl<C, M, R> ListDataSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSourcesInputOperationOutputAlias,
                crate::output::ListDataSourcesOutput,
                crate::error::ListDataSourcesError,
                crate::input::ListDataSourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to
        /// retrieve), Amazon Kendra returns a pagination token in the response. You
        /// can use this pagination token to retrieve the next set of data sources
        /// (<code>DataSourceSummaryItems</code>). </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to
        /// retrieve), Amazon Kendra returns a pagination token in the response. You
        /// can use this pagination token to retrieve the next set of data sources
        /// (<code>DataSourceSummaryItems</code>). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSourceSyncJobs`.
    ///
    /// <p>Gets statistics about synchronizing Amazon Kendra with a data
    /// source.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataSourceSyncJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_source_sync_jobs_input::Builder,
    }
    impl<C, M, R> ListDataSourceSyncJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSourceSyncJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourceSyncJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourceSyncJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSourceSyncJobsInputOperationOutputAlias,
                crate::output::ListDataSourceSyncJobsOutput,
                crate::error::ListDataSourceSyncJobsError,
                crate::input::ListDataSourceSyncJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the data source.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the data source.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of jobs.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of synchronization jobs to return in the response.
        /// If there are fewer results in the list, this response contains only the
        /// actual results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of synchronization jobs to return in the response.
        /// If there are fewer results in the list, this response contains only the
        /// actual results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When specified, the synchronization jobs returned in the list are
        /// limited to jobs between the specified dates. </p>
        pub fn start_time_filter(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.start_time_filter(inp);
            self
        }
        /// <p>When specified, the synchronization jobs returned in the list are
        /// limited to jobs between the specified dates. </p>
        pub fn set_start_time_filter(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time_filter(input);
            self
        }
        /// <p>When specified, only returns synchronization jobs with the
        /// <code>Status</code> field equal to the specified status.</p>
        pub fn status_filter(mut self, inp: crate::model::DataSourceSyncJobStatus) -> Self {
            self.inner = self.inner.status_filter(inp);
            self
        }
        /// <p>When specified, only returns synchronization jobs with the
        /// <code>Status</code> field equal to the specified status.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::DataSourceSyncJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFaqs`.
    ///
    /// <p>Gets a list of FAQ lists associated with an index.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFaqs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_faqs_input::Builder,
    }
    impl<C, M, R> ListFaqs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFaqs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFaqsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFaqsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFaqsInputOperationOutputAlias,
                crate::output::ListFaqsOutput,
                crate::error::ListFaqsError,
                crate::input::ListFaqsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The index that contains the FAQ lists.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The index that contains the FAQ lists.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of FAQs.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of FAQs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of FAQs to return in the response. If there are fewer results in
        /// the list, this response contains only the actual results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of FAQs to return in the response. If there are fewer results in
        /// the list, this response contains only the actual results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupsOlderThanOrderingId`.
    ///
    /// <p>Provides a list of groups that are mapped to users before a
    /// given ordering or timestamp identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupsOlderThanOrderingId<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_older_than_ordering_id_input::Builder,
    }
    impl<C, M, R> ListGroupsOlderThanOrderingId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupsOlderThanOrderingId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOlderThanOrderingIdOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsOlderThanOrderingIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsOlderThanOrderingIdInputOperationOutputAlias,
                crate::output::ListGroupsOlderThanOrderingIdOutput,
                crate::error::ListGroupsOlderThanOrderingIdError,
                crate::input::ListGroupsOlderThanOrderingIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index for getting a list of groups mapped
        /// to users before a given ordering or timestamp identifier.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index for getting a list of groups mapped
        /// to users before a given ordering or timestamp identifier.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The identifier of the data source for getting a list of groups mapped
        /// to users before a given ordering timestamp identifier.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The identifier of the data source for getting a list of groups mapped
        /// to users before a given ordering timestamp identifier.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>The timestamp identifier used for the latest <code>PUT</code> or
        /// <code>DELETE</code> action for mapping users to their groups.</p>
        pub fn ordering_id(mut self, inp: i64) -> Self {
            self.inner = self.inner.ordering_id(inp);
            self
        }
        /// <p>The timestamp identifier used for the latest <code>PUT</code> or
        /// <code>DELETE</code> action for mapping users to their groups.</p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ordering_id(input);
            self
        }
        /// <p>
        /// If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of groups that are mapped to users before a
        /// given ordering or timestamp identifier.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of groups that are mapped to users before a
        /// given ordering or timestamp identifier.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of returned groups that are mapped to users before a
        /// given ordering or timestamp identifier.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of returned groups that are mapped to users before a
        /// given ordering or timestamp identifier.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIndices`.
    ///
    /// <p>Lists the Amazon Kendra indexes that you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIndices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_indices_input::Builder,
    }
    impl<C, M, R> ListIndices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIndices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIndicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIndicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIndicesInputOperationOutputAlias,
                crate::output::ListIndicesOutput,
                crate::error::ListIndicesError,
                crate::input::ListIndicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the previous response was incomplete (because there is more data to
        /// retrieve), Amazon Kendra returns a pagination token in the response. You
        /// can use this pagination token to retrieve the next set of indexes
        /// (<code>DataSourceSummaryItems</code>). </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to
        /// retrieve), Amazon Kendra returns a pagination token in the response. You
        /// can use this pagination token to retrieve the next set of indexes
        /// (<code>DataSourceSummaryItems</code>). </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of data sources to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQuerySuggestionsBlockLists`.
    ///
    /// <p>Lists the block lists used for query suggestions for an index.</p>
    /// <p>For information on the current quota limits for block lists, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
    /// for Amazon Kendra</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListQuerySuggestionsBlockLists<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_query_suggestions_block_lists_input::Builder,
    }
    impl<C, M, R> ListQuerySuggestionsBlockLists<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQuerySuggestionsBlockLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQuerySuggestionsBlockListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQuerySuggestionsBlockListsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQuerySuggestionsBlockListsInputOperationOutputAlias,
                crate::output::ListQuerySuggestionsBlockListsOutput,
                crate::error::ListQuerySuggestionsBlockListsError,
                crate::input::ListQuerySuggestionsBlockListsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index for a list of all block lists that exist for
        /// that index.</p>
        /// <p>For information on the current quota limits for block lists, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
        /// for Amazon Kendra</a>.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index for a list of all block lists that exist for
        /// that index.</p>
        /// <p>For information on the current quota limits for block lists, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
        /// for Amazon Kendra</a>.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of block lists to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of block lists to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of tags associated with a specified resource. Indexes,
    /// FAQs, and data sources can have tags associated with them.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// get a list of tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// get a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThesauri`.
    ///
    /// <p>Lists the Amazon Kendra thesauri associated with an index.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListThesauri<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thesauri_input::Builder,
    }
    impl<C, M, R> ListThesauri<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThesauri`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThesauriOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThesauriError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThesauriInputOperationOutputAlias,
                crate::output::ListThesauriOutput,
                crate::error::ListThesauriError,
                crate::input::ListThesauriInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index associated with the thesaurus to list.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>).
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Kendra returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>).
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of thesauri to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of thesauri to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPrincipalMapping`.
    ///
    /// <p>Maps users to their groups so that you only need to provide
    /// the user ID when you issue the query.</p>
    /// <p>You can also map sub groups to groups.
    /// For example, the group "Company Intellectual Property Teams" includes
    /// sub groups "Research" and "Engineering". These sub groups include their
    /// own list of users or people who work in these teams. Only users who work
    /// in research and engineering, and therefore belong in the intellectual
    /// property group, can see top-secret company documents in their search
    /// results.</p>
    /// <p>You map users to their groups when you want to filter search results
    /// for different users based on their group’s access to documents. For more
    /// information on filtering search results for different users, see
    /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering
    /// on user context</a>.</p>
    /// <p>If more than five <code>PUT</code> actions for a group are currently
    /// processing, a validation exception is thrown.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutPrincipalMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_principal_mapping_input::Builder,
    }
    impl<C, M, R> PutPrincipalMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPrincipalMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPrincipalMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPrincipalMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPrincipalMappingInputOperationOutputAlias,
                crate::output::PutPrincipalMappingOutput,
                crate::error::PutPrincipalMappingError,
                crate::input::PutPrincipalMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to map users to their groups.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to map users to their groups.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The identifier of the data source you want to map users to their groups.</p>
        /// <p>This is useful if a group is tied to multiple data sources, but you only want
        /// the group to access documents of a certain data source. For example, the groups
        /// "Research", "Engineering", and "Sales and Marketing" are all tied to the company's
        /// documents stored in the data sources Confluence and Salesforce. However,
        /// "Sales and Marketing" team only needs access to customer-related documents
        /// stored in Salesforce.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The identifier of the data source you want to map users to their groups.</p>
        /// <p>This is useful if a group is tied to multiple data sources, but you only want
        /// the group to access documents of a certain data source. For example, the groups
        /// "Research", "Engineering", and "Sales and Marketing" are all tied to the company's
        /// documents stored in the data sources Confluence and Salesforce. However,
        /// "Sales and Marketing" team only needs access to customer-related documents
        /// stored in Salesforce.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>The identifier of the group you want to map its users to.</p>
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// <p>The identifier of the group you want to map its users to.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The list that contains your users or sub groups that belong
        /// the same group.</p>
        /// <p>For example, the group "Company" includes the user "CEO" and the
        /// sub groups "Research", "Engineering", and "Sales and Marketing".</p>
        /// <p>If you have more than 1000 users and/or sub groups for a single group,
        /// you need to provide the path to the S3 file that lists your users and
        /// sub groups for a group. Your sub groups can contain more than 1000 users,
        /// but the list of sub groups that belong to a group (and/or users) must be
        /// no more than 1000.</p>
        pub fn group_members(mut self, inp: crate::model::GroupMembers) -> Self {
            self.inner = self.inner.group_members(inp);
            self
        }
        /// <p>The list that contains your users or sub groups that belong
        /// the same group.</p>
        /// <p>For example, the group "Company" includes the user "CEO" and the
        /// sub groups "Research", "Engineering", and "Sales and Marketing".</p>
        /// <p>If you have more than 1000 users and/or sub groups for a single group,
        /// you need to provide the path to the S3 file that lists your users and
        /// sub groups for a group. Your sub groups can contain more than 1000 users,
        /// but the list of sub groups that belong to a group (and/or users) must be
        /// no more than 1000.</p>
        pub fn set_group_members(
            mut self,
            input: std::option::Option<crate::model::GroupMembers>,
        ) -> Self {
            self.inner = self.inner.set_group_members(input);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override
        /// the latest <code>PUT</code> action with previous actions. The highest number
        /// ID, which is the ordering ID, is the latest action you want to process and
        /// apply on top of other actions with lower number IDs. This prevents previous
        /// actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a
        /// group members list. You would then provide this list when calling
        /// <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action
        /// for that updated group with the latest members list doesn't get overwritten
        /// by earlier <code>PUT</code> actions for the same group which are yet to
        /// be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the
        /// action was received by Amazon Kendra.</p>
        pub fn ordering_id(mut self, inp: i64) -> Self {
            self.inner = self.inner.ordering_id(inp);
            self
        }
        /// <p>The timestamp identifier you specify to ensure Amazon Kendra does not override
        /// the latest <code>PUT</code> action with previous actions. The highest number
        /// ID, which is the ordering ID, is the latest action you want to process and
        /// apply on top of other actions with lower number IDs. This prevents previous
        /// actions with lower number IDs from possibly overriding the latest action.</p>
        /// <p>The ordering ID can be the UNIX time of the last update you made to a
        /// group members list. You would then provide this list when calling
        /// <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action
        /// for that updated group with the latest members list doesn't get overwritten
        /// by earlier <code>PUT</code> actions for the same group which are yet to
        /// be processed.</p>
        /// <p>The default ordering ID is the current UNIX time in milliseconds that the
        /// action was received by Amazon Kendra.</p>
        pub fn set_ordering_id(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ordering_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file
        /// that contains your list of users or sub groups that belong to a group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a role that has access to the S3 file
        /// that contains your list of users or sub groups that belong to a group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Query`.
    ///
    /// <p>Searches an active index. Use this API to search your documents
    /// using query. The <code>Query</code> operation enables to do faceted
    /// search and to filter results based on document attributes.</p>
    /// <p>It also enables you to provide user context that Amazon Kendra uses
    /// to enforce document access control in the search results. </p>
    /// <p>Amazon Kendra searches your index for text content and question and
    /// answer (FAQ) content. By default the response contains three types of
    /// results.</p>
    /// <ul>
    /// <li>
    /// <p>Relevant passages</p>
    /// </li>
    /// <li>
    /// <p>Matching FAQs</p>
    /// </li>
    /// <li>
    /// <p>Relevant documents</p>
    /// </li>
    /// </ul>
    /// <p>You can specify that the query return only one type of result using
    /// the <code>QueryResultTypeConfig</code> parameter.</p>
    /// <p>Each query returns the 100 most relevant results. </p>
    #[derive(std::fmt::Debug)]
    pub struct Query<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::query_input::Builder,
    }
    impl<C, M, R> Query<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Query`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::QueryInputOperationOutputAlias,
                crate::output::QueryOutput,
                crate::error::QueryError,
                crate::input::QueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the index to search. The identifier is
        /// returned in the response from the <code>CreateIndex</code>
        /// operation.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The unique identifier of the index to search. The identifier is
        /// returned in the response from the <code>CreateIndex</code>
        /// operation.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The text to search for.</p>
        pub fn query_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_text(inp);
            self
        }
        /// <p>The text to search for.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_text(input);
            self
        }
        /// <p>Enables filtered searches based on document attributes. You can only
        /// provide one attribute filter; however, the <code>AndAllFilters</code>,
        /// <code>NotFilter</code>, and <code>OrAllFilters</code> parameters
        /// contain a list of other filters.</p>
        /// <p>The <code>AttributeFilter</code> parameter enables you to create a
        /// set of filtering rules that a document must satisfy to be included in
        /// the query results.</p>
        pub fn attribute_filter(mut self, inp: crate::model::AttributeFilter) -> Self {
            self.inner = self.inner.attribute_filter(inp);
            self
        }
        /// <p>Enables filtered searches based on document attributes. You can only
        /// provide one attribute filter; however, the <code>AndAllFilters</code>,
        /// <code>NotFilter</code>, and <code>OrAllFilters</code> parameters
        /// contain a list of other filters.</p>
        /// <p>The <code>AttributeFilter</code> parameter enables you to create a
        /// set of filtering rules that a document must satisfy to be included in
        /// the query results.</p>
        pub fn set_attribute_filter(
            mut self,
            input: std::option::Option<crate::model::AttributeFilter>,
        ) -> Self {
            self.inner = self.inner.set_attribute_filter(input);
            self
        }
        /// Appends an item to `Facets`.
        ///
        /// To override the contents of this collection use [`set_facets`](Self::set_facets).
        ///
        /// <p>An array of documents attributes. Amazon Kendra returns a count for
        /// each attribute key specified. You can use this information to help
        /// narrow the search for your user.</p>
        pub fn facets(mut self, inp: impl Into<crate::model::Facet>) -> Self {
            self.inner = self.inner.facets(inp);
            self
        }
        /// <p>An array of documents attributes. Amazon Kendra returns a count for
        /// each attribute key specified. You can use this information to help
        /// narrow the search for your user.</p>
        pub fn set_facets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Facet>>,
        ) -> Self {
            self.inner = self.inner.set_facets(input);
            self
        }
        /// Appends an item to `RequestedDocumentAttributes`.
        ///
        /// To override the contents of this collection use [`set_requested_document_attributes`](Self::set_requested_document_attributes).
        ///
        /// <p>An array of document attributes to include in the response. No other
        /// document attributes are included in the response. By default all
        /// document attributes are included in the response. </p>
        pub fn requested_document_attributes(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.requested_document_attributes(inp);
            self
        }
        /// <p>An array of document attributes to include in the response. No other
        /// document attributes are included in the response. By default all
        /// document attributes are included in the response. </p>
        pub fn set_requested_document_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_requested_document_attributes(input);
            self
        }
        /// <p>Sets the type of query. Only results for the specified query type
        /// are returned.</p>
        pub fn query_result_type_filter(mut self, inp: crate::model::QueryResultType) -> Self {
            self.inner = self.inner.query_result_type_filter(inp);
            self
        }
        /// <p>Sets the type of query. Only results for the specified query type
        /// are returned.</p>
        pub fn set_query_result_type_filter(
            mut self,
            input: std::option::Option<crate::model::QueryResultType>,
        ) -> Self {
            self.inner = self.inner.set_query_result_type_filter(input);
            self
        }
        /// Appends an item to `DocumentRelevanceOverrideConfigurations`.
        ///
        /// To override the contents of this collection use [`set_document_relevance_override_configurations`](Self::set_document_relevance_override_configurations).
        ///
        /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
        /// <p>If you use this API to override the relevance tuning configured at the index
        /// level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
        /// <p>If there is relevance tuning configured at the index level, but you do not use this API
        /// to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
        /// <p>If there is relevance tuning configured for fields at the index level,
        /// but you use this API to override only some of these fields, then for the fields you did not override,
        /// the importance is set to 1.</p>
        pub fn document_relevance_override_configurations(
            mut self,
            inp: impl Into<crate::model::DocumentRelevanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.document_relevance_override_configurations(inp);
            self
        }
        /// <p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p>
        /// <p>If you use this API to override the relevance tuning configured at the index
        /// level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p>
        /// <p>If there is relevance tuning configured at the index level, but you do not use this API
        /// to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p>
        /// <p>If there is relevance tuning configured for fields at the index level,
        /// but you use this API to override only some of these fields, then for the fields you did not override,
        /// the importance is set to 1.</p>
        pub fn set_document_relevance_override_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRelevanceConfiguration>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_document_relevance_override_configurations(input);
            self
        }
        /// <p>Query results are returned in pages the size of the
        /// <code>PageSize</code> parameter. By default, Amazon Kendra returns
        /// the first page of results. Use this parameter to get result pages after
        /// the first one.</p>
        pub fn page_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_number(inp);
            self
        }
        /// <p>Query results are returned in pages the size of the
        /// <code>PageSize</code> parameter. By default, Amazon Kendra returns
        /// the first page of results. Use this parameter to get result pages after
        /// the first one.</p>
        pub fn set_page_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_number(input);
            self
        }
        /// <p>Sets the number of results that are returned in each page of
        /// results. The default page size is 10. The maximum number of results
        /// returned is 100. If you ask for more than 100 results, only 100 are
        /// returned.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>Sets the number of results that are returned in each page of
        /// results. The default page size is 10. The maximum number of results
        /// returned is 100. If you ask for more than 100 results, only 100 are
        /// returned.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Provides information that determines how the results of the query
        /// are sorted. You can set the field that Amazon Kendra should sort the results
        /// on, and specify whether the results should be sorted in ascending or
        /// descending order. In the case of ties in sorting the results, the
        /// results are sorted by relevance.</p>
        /// <p>If you don't provide sorting configuration, the results are sorted
        /// by the relevance that Amazon Kendra determines for the result.</p>
        pub fn sorting_configuration(mut self, inp: crate::model::SortingConfiguration) -> Self {
            self.inner = self.inner.sorting_configuration(inp);
            self
        }
        /// <p>Provides information that determines how the results of the query
        /// are sorted. You can set the field that Amazon Kendra should sort the results
        /// on, and specify whether the results should be sorted in ascending or
        /// descending order. In the case of ties in sorting the results, the
        /// results are sorted by relevance.</p>
        /// <p>If you don't provide sorting configuration, the results are sorted
        /// by the relevance that Amazon Kendra determines for the result.</p>
        pub fn set_sorting_configuration(
            mut self,
            input: std::option::Option<crate::model::SortingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_sorting_configuration(input);
            self
        }
        /// <p>The user context token or user and group information.</p>
        pub fn user_context(mut self, inp: crate::model::UserContext) -> Self {
            self.inner = self.inner.user_context(inp);
            self
        }
        /// <p>The user context token or user and group information.</p>
        pub fn set_user_context(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.inner = self.inner.set_user_context(input);
            self
        }
        /// <p>Provides an identifier for a specific user. The
        /// <code>VisitorId</code> should be a unique identifier, such as a
        /// GUID. Don't use personally identifiable information, such as the user's
        /// email address, as the <code>VisitorId</code>.</p>
        pub fn visitor_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.visitor_id(inp);
            self
        }
        /// <p>Provides an identifier for a specific user. The
        /// <code>VisitorId</code> should be a unique identifier, such as a
        /// GUID. Don't use personally identifiable information, such as the user's
        /// email address, as the <code>VisitorId</code>.</p>
        pub fn set_visitor_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_visitor_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDataSourceSyncJob`.
    ///
    /// <p>Starts a synchronization job for a data source. If a synchronization
    /// job is already in progress, Amazon Kendra returns a
    /// <code>ResourceInUseException</code> exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDataSourceSyncJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_data_source_sync_job_input::Builder,
    }
    impl<C, M, R> StartDataSourceSyncJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDataSourceSyncJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDataSourceSyncJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDataSourceSyncJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDataSourceSyncJobInputOperationOutputAlias,
                crate::output::StartDataSourceSyncJobOutput,
                crate::error::StartDataSourceSyncJobError,
                crate::input::StartDataSourceSyncJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the data source to synchronize.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the data source to synchronize.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopDataSourceSyncJob`.
    ///
    /// <p>Stops a running synchronization job. You can't stop a scheduled
    /// synchronization job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopDataSourceSyncJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_data_source_sync_job_input::Builder,
    }
    impl<C, M, R> StopDataSourceSyncJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopDataSourceSyncJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopDataSourceSyncJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopDataSourceSyncJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopDataSourceSyncJobInputOperationOutputAlias,
                crate::output::StopDataSourceSyncJobOutput,
                crate::error::StopDataSourceSyncJobError,
                crate::input::StopDataSourceSyncJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the data source for which to stop the
        /// synchronization jobs.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the data source for which to stop the
        /// synchronization jobs.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubmitFeedback`.
    ///
    /// <p>Enables you to provide feedback to Amazon Kendra to improve the
    /// performance of your index. </p>
    #[derive(std::fmt::Debug)]
    pub struct SubmitFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::submit_feedback_input::Builder,
    }
    impl<C, M, R> SubmitFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SubmitFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubmitFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::SubmitFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SubmitFeedbackInputOperationOutputAlias,
                crate::output::SubmitFeedbackOutput,
                crate::error::SubmitFeedbackError,
                crate::input::SubmitFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index that was queried.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that was queried.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The identifier of the specific query for which you are submitting
        /// feedback. The query ID is returned in the response to the
        /// <code>Query</code> operation.</p>
        pub fn query_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(inp);
            self
        }
        /// <p>The identifier of the specific query for which you are submitting
        /// feedback. The query ID is returned in the response to the
        /// <code>Query</code> operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
        /// Appends an item to `ClickFeedbackItems`.
        ///
        /// To override the contents of this collection use [`set_click_feedback_items`](Self::set_click_feedback_items).
        ///
        /// <p>Tells Amazon Kendra that a particular search result link was chosen
        /// by the user. </p>
        pub fn click_feedback_items(mut self, inp: impl Into<crate::model::ClickFeedback>) -> Self {
            self.inner = self.inner.click_feedback_items(inp);
            self
        }
        /// <p>Tells Amazon Kendra that a particular search result link was chosen
        /// by the user. </p>
        pub fn set_click_feedback_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClickFeedback>>,
        ) -> Self {
            self.inner = self.inner.set_click_feedback_items(input);
            self
        }
        /// Appends an item to `RelevanceFeedbackItems`.
        ///
        /// To override the contents of this collection use [`set_relevance_feedback_items`](Self::set_relevance_feedback_items).
        ///
        /// <p>Provides Amazon Kendra with relevant or not relevant feedback for
        /// whether a particular item was relevant to the search.</p>
        pub fn relevance_feedback_items(
            mut self,
            inp: impl Into<crate::model::RelevanceFeedback>,
        ) -> Self {
            self.inner = self.inner.relevance_feedback_items(inp);
            self
        }
        /// <p>Provides Amazon Kendra with relevant or not relevant feedback for
        /// whether a particular item was relevant to the search.</p>
        pub fn set_relevance_feedback_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelevanceFeedback>>,
        ) -> Self {
            self.inner = self.inner.set_relevance_feedback_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tag to the specified index, FAQ, or data source
    /// resource. If the tag already exists, the existing value is replaced with
    /// the new value.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag
        /// already exists, the existing value is replaced with the new value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag keys to add to the index, FAQ, or data source. If a tag
        /// already exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an index, FAQ, or a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// remove the tag from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to
        /// remove the tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a
        /// tag key does not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys to remove from the index, FAQ, or data source. If a
        /// tag key does not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates an existing Amazon Kendra data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl<C, M, R> UpdateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourceInputOperationOutputAlias,
                crate::output::UpdateDataSourceOutput,
                crate::error::UpdateDataSourceError,
                crate::input::UpdateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the data source to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of the data source to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the data source to update. The name of the data source
        /// can't be updated. To rename a data source you must delete the data source
        /// and re-create it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data source to update. The name of the data source
        /// can't be updated. To rename a data source you must delete the data source
        /// and re-create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier of the index that contains the data source to
        /// update.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index that contains the data source to
        /// update.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>Configuration information for a Amazon Kendra data source.</p>
        pub fn configuration(mut self, inp: crate::model::DataSourceConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Configuration information for a Amazon Kendra data source.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new update schedule for the data source.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The new update schedule for the data source.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new role to use when the data
        /// source is accessing resources on your behalf.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new role to use when the data
        /// source is accessing resources on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The code for a language. This allows you to support a language for all
        /// documents when updating the data source. English is supported
        /// by default. For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language_code(inp);
            self
        }
        /// <p>The code for a language. This allows you to support a language for all
        /// documents when updating the data source. English is supported
        /// by default. For more information on supported languages, including their codes,
        /// see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
        /// documents in languages other than English</a>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIndex`.
    ///
    /// <p>Updates an existing Amazon Kendra index.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_index_input::Builder,
    }
    impl<C, M, R> UpdateIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIndexInputOperationOutputAlias,
                crate::output::UpdateIndexOutput,
                crate::error::UpdateIndexError,
                crate::input::UpdateIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the index to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the index to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the index to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new IAM role that gives Amazon Kendra permission to access your
        /// Amazon CloudWatch logs.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>A new IAM role that gives Amazon Kendra permission to access your
        /// Amazon CloudWatch logs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A new description for the index.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description for the index.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `DocumentMetadataConfigurationUpdates`.
        ///
        /// To override the contents of this collection use [`set_document_metadata_configuration_updates`](Self::set_document_metadata_configuration_updates).
        ///
        /// <p>The document metadata to update. </p>
        pub fn document_metadata_configuration_updates(
            mut self,
            inp: impl Into<crate::model::DocumentMetadataConfiguration>,
        ) -> Self {
            self.inner = self.inner.document_metadata_configuration_updates(inp);
            self
        }
        /// <p>The document metadata to update. </p>
        pub fn set_document_metadata_configuration_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentMetadataConfiguration>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_document_metadata_configuration_updates(input);
            self
        }
        /// <p>Sets the number of additional storage and query capacity units that
        /// should be used by the index. You can change the capacity of the index up
        /// to 5 times per day.</p>
        /// <p>If you are using extra storage units, you can't reduce the storage
        /// capacity below that required to meet the storage needs for your
        /// index.</p>
        pub fn capacity_units(mut self, inp: crate::model::CapacityUnitsConfiguration) -> Self {
            self.inner = self.inner.capacity_units(inp);
            self
        }
        /// <p>Sets the number of additional storage and query capacity units that
        /// should be used by the index. You can change the capacity of the index up
        /// to 5 times per day.</p>
        /// <p>If you are using extra storage units, you can't reduce the storage
        /// capacity below that required to meet the storage needs for your
        /// index.</p>
        pub fn set_capacity_units(
            mut self,
            input: std::option::Option<crate::model::CapacityUnitsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_capacity_units(input);
            self
        }
        /// Appends an item to `UserTokenConfigurations`.
        ///
        /// To override the contents of this collection use [`set_user_token_configurations`](Self::set_user_token_configurations).
        ///
        /// <p>The user token configuration.</p>
        pub fn user_token_configurations(
            mut self,
            inp: impl Into<crate::model::UserTokenConfiguration>,
        ) -> Self {
            self.inner = self.inner.user_token_configurations(inp);
            self
        }
        /// <p>The user token configuration.</p>
        pub fn set_user_token_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserTokenConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_user_token_configurations(input);
            self
        }
        /// <p>The user context policy.</p>
        pub fn user_context_policy(mut self, inp: crate::model::UserContextPolicy) -> Self {
            self.inner = self.inner.user_context_policy(inp);
            self
        }
        /// <p>The user context policy.</p>
        pub fn set_user_context_policy(
            mut self,
            input: std::option::Option<crate::model::UserContextPolicy>,
        ) -> Self {
            self.inner = self.inner.set_user_context_policy(input);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an AWS Single Sign-On
        /// identity source. To configure this, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn user_group_resolution_configuration(
            mut self,
            inp: crate::model::UserGroupResolutionConfiguration,
        ) -> Self {
            self.inner = self.inner.user_group_resolution_configuration(inp);
            self
        }
        /// <p>Enables fetching access levels of groups and users from an AWS Single Sign-On
        /// identity source. To configure this, see
        /// <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>.</p>
        pub fn set_user_group_resolution_configuration(
            mut self,
            input: std::option::Option<crate::model::UserGroupResolutionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_user_group_resolution_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuerySuggestionsBlockList`.
    ///
    /// <p>Updates a block list used for query suggestions for an index.</p>
    /// <p>Updates to a block list might not take effect right away. Amazon Kendra
    /// needs to refresh the entire suggestions list to apply any updates to the
    /// block list. Other changes not related to the block list apply immediately.</p>
    /// <p>If a block list is updating, then you need to wait for the first update to
    /// finish before submitting another update.</p>
    /// <p>Amazon Kendra supports partial updates, so you only need to provide the fields
    /// you want to update.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQuerySuggestionsBlockList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_query_suggestions_block_list_input::Builder,
    }
    impl<C, M, R> UpdateQuerySuggestionsBlockList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuerySuggestionsBlockList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuerySuggestionsBlockListOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuerySuggestionsBlockListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuerySuggestionsBlockListInputOperationOutputAlias,
                crate::output::UpdateQuerySuggestionsBlockListOutput,
                crate::error::UpdateQuerySuggestionsBlockListError,
                crate::input::UpdateQuerySuggestionsBlockListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index for a block list.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index for a block list.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The unique identifier of a block list.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier of a block list.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of a block list.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a block list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description for a block list.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for a block list.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The S3 path where your block list text file sits in S3.</p>
        /// <p>If you update your block list and provide the same path to the
        /// block list text file in S3, then Amazon Kendra reloads the file to refresh
        /// the block list. Amazon Kendra does not automatically refresh your block list.
        /// You need to call the <code>UpdateQuerySuggestionsBlockList</code> API
        /// to refresh you block list.</p>
        /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes
        /// all query suggestions with the latest content in the S3 file. This
        /// means changes might not take effect immediately.</p>
        pub fn source_s3_path(mut self, inp: crate::model::S3Path) -> Self {
            self.inner = self.inner.source_s3_path(inp);
            self
        }
        /// <p>The S3 path where your block list text file sits in S3.</p>
        /// <p>If you update your block list and provide the same path to the
        /// block list text file in S3, then Amazon Kendra reloads the file to refresh
        /// the block list. Amazon Kendra does not automatically refresh your block list.
        /// You need to call the <code>UpdateQuerySuggestionsBlockList</code> API
        /// to refresh you block list.</p>
        /// <p>If you update your block list, then Amazon Kendra asynchronously refreshes
        /// all query suggestions with the latest content in the S3 file. This
        /// means changes might not take effect immediately.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_path(input);
            self
        }
        /// <p>The IAM (Identity and Access Management) role used to access the
        /// block list text file in S3.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The IAM (Identity and Access Management) role used to access the
        /// block list text file in S3.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuerySuggestionsConfig`.
    ///
    /// <p>Updates the settings of query suggestions for an index.</p>
    /// <p>Amazon Kendra supports partial updates, so you only need to provide
    /// the fields you want to update.</p>
    /// <p>If an update is currently processing (i.e. 'happening'), you
    /// need to wait for the update to finish before making another update.</p>
    /// <p>Updates to query suggestions settings might not take effect right away.
    /// The time for your updated settings to take effect depends on the updates
    /// made and the number of search queries in your index.</p>
    /// <p>You can still enable/disable query suggestions at any time.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQuerySuggestionsConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_query_suggestions_config_input::Builder,
    }
    impl<C, M, R> UpdateQuerySuggestionsConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuerySuggestionsConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuerySuggestionsConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuerySuggestionsConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuerySuggestionsConfigInputOperationOutputAlias,
                crate::output::UpdateQuerySuggestionsConfigOutput,
                crate::error::UpdateQuerySuggestionsConfigError,
                crate::input::UpdateQuerySuggestionsConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the index you want to update query suggestions settings for.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index you want to update query suggestions settings for.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
        /// <p>By default, Amazon Kendra enables query suggestions.
        /// <code>LEARN_ONLY</code> mode allows you to turn off query suggestions.
        /// You can to update this at any time.</p>
        /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new
        /// queries to keep suggestions up to date for when you are ready to
        /// switch to ENABLED mode again.</p>
        pub fn mode(mut self, inp: crate::model::Mode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p>
        /// <p>By default, Amazon Kendra enables query suggestions.
        /// <code>LEARN_ONLY</code> mode allows you to turn off query suggestions.
        /// You can to update this at any time.</p>
        /// <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new
        /// queries to keep suggestions up to date for when you are ready to
        /// switch to ENABLED mode again.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::Mode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>How recent your queries are in your query log time window.</p>
        /// <p>The time window is the number of days from current day to past days.</p>
        /// <p>By default, Amazon Kendra sets this to 180.</p>
        pub fn query_log_look_back_window_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.query_log_look_back_window_in_days(inp);
            self
        }
        /// <p>How recent your queries are in your query log time window.</p>
        /// <p>The time window is the number of days from current day to past days.</p>
        /// <p>By default, Amazon Kendra sets this to 180.</p>
        pub fn set_query_log_look_back_window_in_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_query_log_look_back_window_in_days(input);
            self
        }
        /// <p>
        /// <code>TRUE</code> to include queries without user information (i.e. all queries,
        /// irrespective of the user), otherwise <code>FALSE</code> to only include queries
        /// with user information.</p>
        /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this
        /// flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user
        /// information.</p>
        /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
        /// <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code>
        /// unique users for suggestions.</p>
        /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns
        /// from all queries.</p>
        pub fn include_queries_without_user_information(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_queries_without_user_information(inp);
            self
        }
        /// <p>
        /// <code>TRUE</code> to include queries without user information (i.e. all queries,
        /// irrespective of the user), otherwise <code>FALSE</code> to only include queries
        /// with user information.</p>
        /// <p>If you pass user information to Amazon Kendra along with the queries, you can set this
        /// flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user
        /// information.</p>
        /// <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least
        /// <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code>
        /// unique users for suggestions.</p>
        /// <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns
        /// from all queries.</p>
        pub fn set_include_queries_without_user_information(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_include_queries_without_user_information(input);
            self
        }
        /// <p>The minimum number of unique users who must search a query in order for the query
        /// to be eligible to suggest to your users.</p>
        /// <p>Increasing this number might decrease the number of suggestions. However, this
        /// ensures a query is searched by many users and is truly popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn minimum_number_of_querying_users(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_number_of_querying_users(inp);
            self
        }
        /// <p>The minimum number of unique users who must search a query in order for the query
        /// to be eligible to suggest to your users.</p>
        /// <p>Increasing this number might decrease the number of suggestions. However, this
        /// ensures a query is searched by many users and is truly popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn set_minimum_number_of_querying_users(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_minimum_number_of_querying_users(input);
            self
        }
        /// <p>The the minimum number of times a query must be searched in order to be
        /// eligible to suggest to your users.</p>
        /// <p>Decreasing this number increases the number of suggestions. However, this
        /// affects the quality of suggestions as it sets a low bar for a query to be
        /// considered popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn minimum_query_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_query_count(inp);
            self
        }
        /// <p>The the minimum number of times a query must be searched in order to be
        /// eligible to suggest to your users.</p>
        /// <p>Decreasing this number increases the number of suggestions. However, this
        /// affects the quality of suggestions as it sets a low bar for a query to be
        /// considered popular to suggest to users.</p>
        /// <p>How you tune this setting depends on your specific needs.</p>
        pub fn set_minimum_query_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_query_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThesaurus`.
    ///
    /// <p>Updates a thesaurus file associated with an index.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateThesaurus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_thesaurus_input::Builder,
    }
    impl<C, M, R> UpdateThesaurus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThesaurus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThesaurusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThesaurusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThesaurusInputOperationOutputAlias,
                crate::output::UpdateThesaurusOutput,
                crate::error::UpdateThesaurusError,
                crate::input::UpdateThesaurusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the thesaurus to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the thesaurus to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The updated name of the thesaurus.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The updated name of the thesaurus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to update.</p>
        pub fn index_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_id(inp);
            self
        }
        /// <p>The identifier of the index associated with the thesaurus to update.</p>
        pub fn set_index_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_id(input);
            self
        }
        /// <p>The updated description of the thesaurus.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated description of the thesaurus.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated role ARN of the thesaurus.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The updated role ARN of the thesaurus.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn source_s3_path(mut self, inp: crate::model::S3Path) -> Self {
            self.inner = self.inner.source_s3_path(inp);
            self
        }
        /// <p>Information required to find a specific file in an Amazon S3
        /// bucket.</p>
        pub fn set_source_s3_path(
            mut self,
            input: std::option::Option<crate::model::S3Path>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_path(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
