// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Managed Streaming for Kafka Connect
///
/// Client for invoking operations on Managed Streaming for Kafka Connect. Each operation on Managed Streaming for Kafka Connect is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_kafkaconnect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_kafkaconnect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_kafkaconnect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateConnector` operation.
    ///
    /// See [`CreateConnector`](crate::client::fluent_builders::CreateConnector) for more information about the
    /// operation and its arguments.
    pub fn create_connector(&self) -> fluent_builders::CreateConnector<C, M, R> {
        fluent_builders::CreateConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomPlugin` operation.
    ///
    /// See [`CreateCustomPlugin`](crate::client::fluent_builders::CreateCustomPlugin) for more information about the
    /// operation and its arguments.
    pub fn create_custom_plugin(&self) -> fluent_builders::CreateCustomPlugin<C, M, R> {
        fluent_builders::CreateCustomPlugin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkerConfiguration` operation.
    ///
    /// See [`CreateWorkerConfiguration`](crate::client::fluent_builders::CreateWorkerConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_worker_configuration(
        &self,
    ) -> fluent_builders::CreateWorkerConfiguration<C, M, R> {
        fluent_builders::CreateWorkerConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnector` operation.
    ///
    /// See [`DeleteConnector`](crate::client::fluent_builders::DeleteConnector) for more information about the
    /// operation and its arguments.
    pub fn delete_connector(&self) -> fluent_builders::DeleteConnector<C, M, R> {
        fluent_builders::DeleteConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnector` operation.
    ///
    /// See [`DescribeConnector`](crate::client::fluent_builders::DescribeConnector) for more information about the
    /// operation and its arguments.
    pub fn describe_connector(&self) -> fluent_builders::DescribeConnector<C, M, R> {
        fluent_builders::DescribeConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomPlugin` operation.
    ///
    /// See [`DescribeCustomPlugin`](crate::client::fluent_builders::DescribeCustomPlugin) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_plugin(&self) -> fluent_builders::DescribeCustomPlugin<C, M, R> {
        fluent_builders::DescribeCustomPlugin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkerConfiguration` operation.
    ///
    /// See [`DescribeWorkerConfiguration`](crate::client::fluent_builders::DescribeWorkerConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_worker_configuration(
        &self,
    ) -> fluent_builders::DescribeWorkerConfiguration<C, M, R> {
        fluent_builders::DescribeWorkerConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnectors` operation.
    ///
    /// See [`ListConnectors`](crate::client::fluent_builders::ListConnectors) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListConnectors::into_paginator).
    pub fn list_connectors(&self) -> fluent_builders::ListConnectors<C, M, R> {
        fluent_builders::ListConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomPlugins` operation.
    ///
    /// See [`ListCustomPlugins`](crate::client::fluent_builders::ListCustomPlugins) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCustomPlugins::into_paginator).
    pub fn list_custom_plugins(&self) -> fluent_builders::ListCustomPlugins<C, M, R> {
        fluent_builders::ListCustomPlugins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkerConfigurations` operation.
    ///
    /// See [`ListWorkerConfigurations`](crate::client::fluent_builders::ListWorkerConfigurations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkerConfigurations::into_paginator).
    pub fn list_worker_configurations(&self) -> fluent_builders::ListWorkerConfigurations<C, M, R> {
        fluent_builders::ListWorkerConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnector` operation.
    ///
    /// See [`UpdateConnector`](crate::client::fluent_builders::UpdateConnector) for more information about the
    /// operation and its arguments.
    pub fn update_connector(&self) -> fluent_builders::UpdateConnector<C, M, R> {
        fluent_builders::UpdateConnector::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConnector`.
    ///
    /// <p>Creates a connector using the specified properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connector_input::Builder,
    }
    impl<C, M, R> CreateConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectorInputOperationOutputAlias,
                crate::output::CreateConnectorOutput,
                crate::error::CreateConnectorError,
                crate::input::CreateConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>
        pub fn capacity(mut self, input: crate::model::Capacity) -> Self {
            self.inner = self.inner.capacity(input);
            self
        }
        /// <p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>
        pub fn set_capacity(mut self, input: std::option::Option<crate::model::Capacity>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// Adds a key-value pair to `connectorConfiguration`.
        ///
        /// To override the contents of this collection use [`set_connector_configuration`](Self::set_connector_configuration).
        ///
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn connector_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.connector_configuration(k.into(), v.into());
            self
        }
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn set_connector_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_connector_configuration(input);
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_description(input.into());
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_description(input);
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_name(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_name(input);
            self
        }
        /// <p>Specifies which Apache Kafka cluster to connect to.</p>
        pub fn kafka_cluster(mut self, input: crate::model::KafkaCluster) -> Self {
            self.inner = self.inner.kafka_cluster(input);
            self
        }
        /// <p>Specifies which Apache Kafka cluster to connect to.</p>
        pub fn set_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::KafkaCluster>,
        ) -> Self {
            self.inner = self.inner.set_kafka_cluster(input);
            self
        }
        /// <p>Details of the client authentication used by the Apache Kafka cluster.</p>
        pub fn kafka_cluster_client_authentication(
            mut self,
            input: crate::model::KafkaClusterClientAuthentication,
        ) -> Self {
            self.inner = self.inner.kafka_cluster_client_authentication(input);
            self
        }
        /// <p>Details of the client authentication used by the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_client_authentication(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthentication>,
        ) -> Self {
            self.inner = self.inner.set_kafka_cluster_client_authentication(input);
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn kafka_cluster_encryption_in_transit(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransit,
        ) -> Self {
            self.inner = self.inner.kafka_cluster_encryption_in_transit(input);
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_encryption_in_transit(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransit>,
        ) -> Self {
            self.inner = self.inner.set_kafka_cluster_encryption_in_transit(input);
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn kafka_connect_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kafka_connect_version(input.into());
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn set_kafka_connect_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kafka_connect_version(input);
            self
        }
        /// <p>Details about log delivery.</p>
        pub fn log_delivery(mut self, input: crate::model::LogDelivery) -> Self {
            self.inner = self.inner.log_delivery(input);
            self
        }
        /// <p>Details about log delivery.</p>
        pub fn set_log_delivery(
            mut self,
            input: std::option::Option<crate::model::LogDelivery>,
        ) -> Self {
            self.inner = self.inner.set_log_delivery(input);
            self
        }
        /// Appends an item to `plugins`.
        ///
        /// To override the contents of this collection use [`set_plugins`](Self::set_plugins).
        ///
        /// <p>Specifies which plugins to use for the connector.</p>
        pub fn plugins(mut self, input: crate::model::Plugin) -> Self {
            self.inner = self.inner.plugins(input);
            self
        }
        /// <p>Specifies which plugins to use for the connector.</p>
        pub fn set_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Plugin>>,
        ) -> Self {
            self.inner = self.inner.set_plugins(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>
        pub fn service_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>
        pub fn set_service_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_execution_role_arn(input);
            self
        }
        /// <p>Specifies which worker configuration to use with the connector.</p>
        pub fn worker_configuration(mut self, input: crate::model::WorkerConfiguration) -> Self {
            self.inner = self.inner.worker_configuration(input);
            self
        }
        /// <p>Specifies which worker configuration to use with the connector.</p>
        pub fn set_worker_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkerConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_worker_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomPlugin`.
    ///
    /// <p>Creates a custom plugin using the specified properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomPlugin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_plugin_input::Builder,
    }
    impl<C, M, R> CreateCustomPlugin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomPlugin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomPluginOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomPluginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomPluginInputOperationOutputAlias,
                crate::output::CreateCustomPluginOutput,
                crate::error::CreateCustomPluginError,
                crate::input::CreateCustomPluginInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the plugin file.</p>
        pub fn content_type(mut self, input: crate::model::CustomPluginContentType) -> Self {
            self.inner = self.inner.content_type(input);
            self
        }
        /// <p>The type of the plugin file.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::CustomPluginContentType>,
        ) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>A summary description of the custom plugin.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A summary description of the custom plugin.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information about the location of a custom plugin.</p>
        pub fn location(mut self, input: crate::model::CustomPluginLocation) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>Information about the location of a custom plugin.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::CustomPluginLocation>,
        ) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkerConfiguration`.
    ///
    /// <p>Creates a worker configuration using the specified properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkerConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_worker_configuration_input::Builder,
    }
    impl<C, M, R> CreateWorkerConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkerConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkerConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkerConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkerConfigurationInputOperationOutputAlias,
                crate::output::CreateWorkerConfigurationOutput,
                crate::error::CreateWorkerConfigurationError,
                crate::input::CreateWorkerConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A summary description of the worker configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A summary description of the worker configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Base64 encoded contents of connect-distributed.properties file.</p>
        pub fn properties_file_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.properties_file_content(input.into());
            self
        }
        /// <p>Base64 encoded contents of connect-distributed.properties file.</p>
        pub fn set_properties_file_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_properties_file_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnector`.
    ///
    /// <p>Deletes the specified connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connector_input::Builder,
    }
    impl<C, M, R> DeleteConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectorInputOperationOutputAlias,
                crate::output::DeleteConnectorOutput,
                crate::error::DeleteConnectorError,
                crate::input::DeleteConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_arn(input);
            self
        }
        /// <p>The current version of the connector that you want to delete.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The current version of the connector that you want to delete.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnector`.
    ///
    /// <p>Returns summary information about the connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connector_input::Builder,
    }
    impl<C, M, R> DescribeConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectorInputOperationOutputAlias,
                crate::output::DescribeConnectorOutput,
                crate::error::DescribeConnectorError,
                crate::input::DescribeConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomPlugin`.
    ///
    /// <p>A summary description of the custom plugin.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomPlugin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_plugin_input::Builder,
    }
    impl<C, M, R> DescribeCustomPlugin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomPlugin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomPluginOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomPluginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomPluginInputOperationOutputAlias,
                crate::output::DescribeCustomPluginOutput,
                crate::error::DescribeCustomPluginError,
                crate::input::DescribeCustomPluginInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns information about a custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_plugin_arn(input.into());
            self
        }
        /// <p>Returns information about a custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_plugin_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkerConfiguration`.
    ///
    /// <p>Returns information about a worker configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkerConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_worker_configuration_input::Builder,
    }
    impl<C, M, R> DescribeWorkerConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkerConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkerConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkerConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkerConfigurationInputOperationOutputAlias,
                crate::output::DescribeWorkerConfigurationOutput,
                crate::error::DescribeWorkerConfigurationError,
                crate::input::DescribeWorkerConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_worker_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectors`.
    ///
    /// <p>Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connectors_input::Builder,
    }
    impl<C, M, R> ListConnectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectorsInputOperationOutputAlias,
                crate::output::ListConnectorsOutput,
                crate::error::ListConnectorsError,
                crate::input::ListConnectorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConnectorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConnectorsPaginator<C, M, R> {
            crate::paginator::ListConnectorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name prefix that you want to use to search for and list connectors.</p>
        pub fn connector_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_name_prefix(input.into());
            self
        }
        /// <p>The name prefix that you want to use to search for and list connectors.</p>
        pub fn set_connector_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_name_prefix(input);
            self
        }
        /// <p>The maximum number of connectors to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of connectors to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomPlugins`.
    ///
    /// <p>Returns a list of all of the custom plugins in this account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomPlugins<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_plugins_input::Builder,
    }
    impl<C, M, R> ListCustomPlugins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomPlugins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomPluginsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomPluginsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomPluginsInputOperationOutputAlias,
                crate::output::ListCustomPluginsOutput,
                crate::error::ListCustomPluginsError,
                crate::input::ListCustomPluginsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomPluginsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomPluginsPaginator<C, M, R> {
            crate::paginator::ListCustomPluginsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of custom plugins to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of custom plugins to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkerConfigurations`.
    ///
    /// <p>Returns a list of all of the worker configurations in this account and Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkerConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_worker_configurations_input::Builder,
    }
    impl<C, M, R> ListWorkerConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkerConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkerConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkerConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkerConfigurationsInputOperationOutputAlias,
                crate::output::ListWorkerConfigurationsOutput,
                crate::error::ListWorkerConfigurationsError,
                crate::input::ListWorkerConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkerConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListWorkerConfigurationsPaginator<C, M, R> {
            crate::paginator::ListWorkerConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of worker configurations to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of worker configurations to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnector`.
    ///
    /// <p>Updates the specified connector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connector_input::Builder,
    }
    impl<C, M, R> UpdateConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectorInputOperationOutputAlias,
                crate::output::UpdateConnectorOutput,
                crate::error::UpdateConnectorError,
                crate::input::UpdateConnectorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The target capacity.</p>
        pub fn capacity(mut self, input: crate::model::CapacityUpdate) -> Self {
            self.inner = self.inner.capacity(input);
            self
        }
        /// <p>The target capacity.</p>
        pub fn set_capacity(
            mut self,
            input: std::option::Option<crate::model::CapacityUpdate>,
        ) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_arn(input);
            self
        }
        /// <p>The current version of the connector that you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_version(input.into());
            self
        }
        /// <p>The current version of the connector that you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_version(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
