// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectorError {
    /// Kind of error that occurred.
    pub kind: CreateConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectorErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another name.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectorError {
    fn code(&self) -> Option<&str> {
        CreateConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectorError {
    /// Creates a new `CreateConnectorError`.
    pub fn new(kind: CreateConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectorErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectorErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectorErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateConnectorErrorKind::ConflictException(_inner) => Some(_inner),
            CreateConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateConnectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateConnectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateConnectorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomPluginError {
    /// Kind of error that occurred.
    pub kind: CreateCustomPluginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomPluginErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another name.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomPluginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomPluginErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateCustomPluginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomPluginError {
    fn code(&self) -> Option<&str> {
        CreateCustomPluginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomPluginError {
    /// Creates a new `CreateCustomPluginError`.
    pub fn new(kind: CreateCustomPluginErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomPluginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomPluginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomPluginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomPluginErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomPluginErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomPluginErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateCustomPluginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomPluginErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateCustomPluginErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkerConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateWorkerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkerConfigurationErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another name.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkerConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateWorkerConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateWorkerConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateWorkerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkerConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateWorkerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkerConfigurationError {
    /// Creates a new `CreateWorkerConfigurationError`.
    pub fn new(kind: CreateWorkerConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkerConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkerConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateWorkerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkerConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreateWorkerConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateWorkerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectorError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectorErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectorError {
    fn code(&self) -> Option<&str> {
        DeleteConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectorError {
    /// Creates a new `DeleteConnectorError`.
    pub fn new(kind: DeleteConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectorErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectorErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomPluginError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomPluginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomPluginErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomPluginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomPluginErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteCustomPluginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomPluginError {
    fn code(&self) -> Option<&str> {
        DeleteCustomPluginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomPluginError {
    /// Creates a new `DeleteCustomPluginError`.
    pub fn new(kind: DeleteCustomPluginErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomPluginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomPluginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomPluginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomPluginErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomPluginErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomPluginErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteCustomPluginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomPluginErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteCustomPluginErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectorError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectorErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectorError {
    fn code(&self) -> Option<&str> {
        DescribeConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectorError {
    /// Creates a new `DescribeConnectorError`.
    pub fn new(kind: DescribeConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeConnectorErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomPluginError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomPluginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomPlugin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomPluginErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomPluginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomPluginErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeCustomPluginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomPluginError {
    fn code(&self) -> Option<&str> {
        DescribeCustomPluginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomPluginError {
    /// Creates a new `DescribeCustomPluginError`.
    pub fn new(kind: DescribeCustomPluginErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomPluginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomPluginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomPluginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomPluginErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomPluginErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomPluginErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeCustomPluginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomPluginErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeCustomPluginErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkerConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkerConfigurationErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkerConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeWorkerConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeWorkerConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkerConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeWorkerConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkerConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeWorkerConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeWorkerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkerConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeWorkerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkerConfigurationError {
    /// Creates a new `DescribeWorkerConfigurationError`.
    pub fn new(kind: DescribeWorkerConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkerConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkerConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeWorkerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkerConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeWorkerConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeWorkerConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeWorkerConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeWorkerConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeWorkerConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeWorkerConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeWorkerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConnectorsError {
    /// Kind of error that occurred.
    pub kind: ListConnectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConnectorsErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConnectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConnectorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListConnectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConnectorsError {
    fn code(&self) -> Option<&str> {
        ListConnectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConnectorsError {
    /// Creates a new `ListConnectorsError`.
    pub fn new(kind: ListConnectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConnectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConnectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConnectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConnectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListConnectorsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListConnectorsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListConnectorsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConnectorsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectorsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListConnectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConnectorsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListConnectorsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListConnectorsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListConnectorsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListConnectorsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListConnectorsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListConnectorsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListConnectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomPlugins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomPluginsError {
    /// Kind of error that occurred.
    pub kind: ListCustomPluginsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomPlugins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomPluginsErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomPluginsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomPluginsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListCustomPluginsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomPluginsError {
    fn code(&self) -> Option<&str> {
        ListCustomPluginsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomPluginsError {
    /// Creates a new `ListCustomPluginsError`.
    pub fn new(kind: ListCustomPluginsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomPluginsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomPluginsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomPluginsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomPluginsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListCustomPluginsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomPluginsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomPluginsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListCustomPluginsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomPluginsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListCustomPluginsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkerConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkerConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListWorkerConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkerConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkerConfigurationsErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkerConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkerConfigurationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListWorkerConfigurationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListWorkerConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkerConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListWorkerConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkerConfigurationsError {
    /// Creates a new `ListWorkerConfigurationsError`.
    pub fn new(kind: ListWorkerConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkerConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkerConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkerConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkerConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkerConfigurationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkerConfigurationsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListWorkerConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkerConfigurationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListWorkerConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectorError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectorErrorKind {
    /// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectorError {
    fn code(&self) -> Option<&str> {
        UpdateConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectorError {
    /// Creates a new `UpdateConnectorError`.
    pub fn new(kind: UpdateConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateConnectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateConnectorErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateConnectorErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectorErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectorErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectorErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
