// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorState {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorState {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => ConnectorState::Creating,
            "DELETING" => ConnectorState::Deleting,
            "FAILED" => ConnectorState::Failed,
            "RUNNING" => ConnectorState::Running,
            "UPDATING" => ConnectorState::Updating,
            other => ConnectorState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorState::from(s))
    }
}
impl ConnectorState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorState::Creating => "CREATING",
            ConnectorState::Deleting => "DELETING",
            ConnectorState::Failed => "FAILED",
            ConnectorState::Running => "RUNNING",
            ConnectorState::Updating => "UPDATING",
            ConnectorState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATING", "DELETING", "FAILED", "RUNNING", "UPDATING"]
    }
}
impl AsRef<str> for ConnectorState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The target capacity for the connector. The capacity can be auto scaled or provisioned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityUpdate {
    /// <p>The target auto scaling setting.</p>
    pub auto_scaling: std::option::Option<crate::model::AutoScalingUpdate>,
    /// <p>The target settings for provisioned capacity.</p>
    pub provisioned_capacity: std::option::Option<crate::model::ProvisionedCapacityUpdate>,
}
impl CapacityUpdate {
    /// <p>The target auto scaling setting.</p>
    pub fn auto_scaling(&self) -> std::option::Option<&crate::model::AutoScalingUpdate> {
        self.auto_scaling.as_ref()
    }
    /// <p>The target settings for provisioned capacity.</p>
    pub fn provisioned_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedCapacityUpdate> {
        self.provisioned_capacity.as_ref()
    }
}
impl std::fmt::Debug for CapacityUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityUpdate");
        formatter.field("auto_scaling", &self.auto_scaling);
        formatter.field("provisioned_capacity", &self.provisioned_capacity);
        formatter.finish()
    }
}
/// See [`CapacityUpdate`](crate::model::CapacityUpdate)
pub mod capacity_update {
    /// A builder for [`CapacityUpdate`](crate::model::CapacityUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling: std::option::Option<crate::model::AutoScalingUpdate>,
        pub(crate) provisioned_capacity:
            std::option::Option<crate::model::ProvisionedCapacityUpdate>,
    }
    impl Builder {
        /// <p>The target auto scaling setting.</p>
        pub fn auto_scaling(mut self, input: crate::model::AutoScalingUpdate) -> Self {
            self.auto_scaling = Some(input);
            self
        }
        /// <p>The target auto scaling setting.</p>
        pub fn set_auto_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingUpdate>,
        ) -> Self {
            self.auto_scaling = input;
            self
        }
        /// <p>The target settings for provisioned capacity.</p>
        pub fn provisioned_capacity(
            mut self,
            input: crate::model::ProvisionedCapacityUpdate,
        ) -> Self {
            self.provisioned_capacity = Some(input);
            self
        }
        /// <p>The target settings for provisioned capacity.</p>
        pub fn set_provisioned_capacity(
            mut self,
            input: std::option::Option<crate::model::ProvisionedCapacityUpdate>,
        ) -> Self {
            self.provisioned_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityUpdate`](crate::model::CapacityUpdate)
        pub fn build(self) -> crate::model::CapacityUpdate {
            crate::model::CapacityUpdate {
                auto_scaling: self.auto_scaling,
                provisioned_capacity: self.provisioned_capacity,
            }
        }
    }
}
impl CapacityUpdate {
    /// Creates a new builder-style object to manufacture [`CapacityUpdate`](crate::model::CapacityUpdate)
    pub fn builder() -> crate::model::capacity_update::Builder {
        crate::model::capacity_update::Builder::default()
    }
}

/// <p>An update to a connector's fixed capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedCapacityUpdate {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The number of workers that are allocated to the connector.</p>
    pub worker_count: i32,
}
impl ProvisionedCapacityUpdate {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The number of workers that are allocated to the connector.</p>
    pub fn worker_count(&self) -> i32 {
        self.worker_count
    }
}
impl std::fmt::Debug for ProvisionedCapacityUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedCapacityUpdate");
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("worker_count", &self.worker_count);
        formatter.finish()
    }
}
/// See [`ProvisionedCapacityUpdate`](crate::model::ProvisionedCapacityUpdate)
pub mod provisioned_capacity_update {
    /// A builder for [`ProvisionedCapacityUpdate`](crate::model::ProvisionedCapacityUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) worker_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn worker_count(mut self, input: i32) -> Self {
            self.worker_count = Some(input);
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn set_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.worker_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedCapacityUpdate`](crate::model::ProvisionedCapacityUpdate)
        pub fn build(self) -> crate::model::ProvisionedCapacityUpdate {
            crate::model::ProvisionedCapacityUpdate {
                mcu_count: self.mcu_count.unwrap_or_default(),
                worker_count: self.worker_count.unwrap_or_default(),
            }
        }
    }
}
impl ProvisionedCapacityUpdate {
    /// Creates a new builder-style object to manufacture [`ProvisionedCapacityUpdate`](crate::model::ProvisionedCapacityUpdate)
    pub fn builder() -> crate::model::provisioned_capacity_update::Builder {
        crate::model::provisioned_capacity_update::Builder::default()
    }
}

/// <p>The updates to the auto scaling parameters for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingUpdate {
    /// <p>The target maximum number of workers allocated to the connector.</p>
    pub max_worker_count: i32,
    /// <p>The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The target minimum number of workers allocated to the connector.</p>
    pub min_worker_count: i32,
    /// <p>The target sacle-in policy for the connector.</p>
    pub scale_in_policy: std::option::Option<crate::model::ScaleInPolicyUpdate>,
    /// <p>The target sacle-out policy for the connector.</p>
    pub scale_out_policy: std::option::Option<crate::model::ScaleOutPolicyUpdate>,
}
impl AutoScalingUpdate {
    /// <p>The target maximum number of workers allocated to the connector.</p>
    pub fn max_worker_count(&self) -> i32 {
        self.max_worker_count
    }
    /// <p>The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The target minimum number of workers allocated to the connector.</p>
    pub fn min_worker_count(&self) -> i32 {
        self.min_worker_count
    }
    /// <p>The target sacle-in policy for the connector.</p>
    pub fn scale_in_policy(&self) -> std::option::Option<&crate::model::ScaleInPolicyUpdate> {
        self.scale_in_policy.as_ref()
    }
    /// <p>The target sacle-out policy for the connector.</p>
    pub fn scale_out_policy(&self) -> std::option::Option<&crate::model::ScaleOutPolicyUpdate> {
        self.scale_out_policy.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingUpdate");
        formatter.field("max_worker_count", &self.max_worker_count);
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("min_worker_count", &self.min_worker_count);
        formatter.field("scale_in_policy", &self.scale_in_policy);
        formatter.field("scale_out_policy", &self.scale_out_policy);
        formatter.finish()
    }
}
/// See [`AutoScalingUpdate`](crate::model::AutoScalingUpdate)
pub mod auto_scaling_update {
    /// A builder for [`AutoScalingUpdate`](crate::model::AutoScalingUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_worker_count: std::option::Option<i32>,
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) min_worker_count: std::option::Option<i32>,
        pub(crate) scale_in_policy: std::option::Option<crate::model::ScaleInPolicyUpdate>,
        pub(crate) scale_out_policy: std::option::Option<crate::model::ScaleOutPolicyUpdate>,
    }
    impl Builder {
        /// <p>The target maximum number of workers allocated to the connector.</p>
        pub fn max_worker_count(mut self, input: i32) -> Self {
            self.max_worker_count = Some(input);
            self
        }
        /// <p>The target maximum number of workers allocated to the connector.</p>
        pub fn set_max_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_worker_count = input;
            self
        }
        /// <p>The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The target minimum number of workers allocated to the connector.</p>
        pub fn min_worker_count(mut self, input: i32) -> Self {
            self.min_worker_count = Some(input);
            self
        }
        /// <p>The target minimum number of workers allocated to the connector.</p>
        pub fn set_min_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.min_worker_count = input;
            self
        }
        /// <p>The target sacle-in policy for the connector.</p>
        pub fn scale_in_policy(mut self, input: crate::model::ScaleInPolicyUpdate) -> Self {
            self.scale_in_policy = Some(input);
            self
        }
        /// <p>The target sacle-in policy for the connector.</p>
        pub fn set_scale_in_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleInPolicyUpdate>,
        ) -> Self {
            self.scale_in_policy = input;
            self
        }
        /// <p>The target sacle-out policy for the connector.</p>
        pub fn scale_out_policy(mut self, input: crate::model::ScaleOutPolicyUpdate) -> Self {
            self.scale_out_policy = Some(input);
            self
        }
        /// <p>The target sacle-out policy for the connector.</p>
        pub fn set_scale_out_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleOutPolicyUpdate>,
        ) -> Self {
            self.scale_out_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingUpdate`](crate::model::AutoScalingUpdate)
        pub fn build(self) -> crate::model::AutoScalingUpdate {
            crate::model::AutoScalingUpdate {
                max_worker_count: self.max_worker_count.unwrap_or_default(),
                mcu_count: self.mcu_count.unwrap_or_default(),
                min_worker_count: self.min_worker_count.unwrap_or_default(),
                scale_in_policy: self.scale_in_policy,
                scale_out_policy: self.scale_out_policy,
            }
        }
    }
}
impl AutoScalingUpdate {
    /// Creates a new builder-style object to manufacture [`AutoScalingUpdate`](crate::model::AutoScalingUpdate)
    pub fn builder() -> crate::model::auto_scaling_update::Builder {
        crate::model::auto_scaling_update::Builder::default()
    }
}

/// <p>An update to the connector's scale-out policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleOutPolicyUpdate {
    /// <p>The target CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleOutPolicyUpdate {
    /// <p>The target CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleOutPolicyUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleOutPolicyUpdate");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleOutPolicyUpdate`](crate::model::ScaleOutPolicyUpdate)
pub mod scale_out_policy_update {
    /// A builder for [`ScaleOutPolicyUpdate`](crate::model::ScaleOutPolicyUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The target CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>The target CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleOutPolicyUpdate`](crate::model::ScaleOutPolicyUpdate)
        pub fn build(self) -> crate::model::ScaleOutPolicyUpdate {
            crate::model::ScaleOutPolicyUpdate {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleOutPolicyUpdate {
    /// Creates a new builder-style object to manufacture [`ScaleOutPolicyUpdate`](crate::model::ScaleOutPolicyUpdate)
    pub fn builder() -> crate::model::scale_out_policy_update::Builder {
        crate::model::scale_out_policy_update::Builder::default()
    }
}

/// <p>An update to the connector's scale-in policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleInPolicyUpdate {
    /// <p>The target CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleInPolicyUpdate {
    /// <p>The target CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleInPolicyUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleInPolicyUpdate");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleInPolicyUpdate`](crate::model::ScaleInPolicyUpdate)
pub mod scale_in_policy_update {
    /// A builder for [`ScaleInPolicyUpdate`](crate::model::ScaleInPolicyUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The target CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>The target CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleInPolicyUpdate`](crate::model::ScaleInPolicyUpdate)
        pub fn build(self) -> crate::model::ScaleInPolicyUpdate {
            crate::model::ScaleInPolicyUpdate {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleInPolicyUpdate {
    /// Creates a new builder-style object to manufacture [`ScaleInPolicyUpdate`](crate::model::ScaleInPolicyUpdate)
    pub fn builder() -> crate::model::scale_in_policy_update::Builder {
        crate::model::scale_in_policy_update::Builder::default()
    }
}

/// <p>The summary of a worker configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerConfigurationSummary {
    /// <p>The time that a worker configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of a worker configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The latest revision of a worker configuration.</p>
    pub latest_revision: std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
    /// <p>The name of the worker configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl WorkerConfigurationSummary {
    /// <p>The time that a worker configuration was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of a worker configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The latest revision of a worker configuration.</p>
    pub fn latest_revision(
        &self,
    ) -> std::option::Option<&crate::model::WorkerConfigurationRevisionSummary> {
        self.latest_revision.as_ref()
    }
    /// <p>The name of the worker configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub fn worker_configuration_arn(&self) -> std::option::Option<&str> {
        self.worker_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for WorkerConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerConfigurationSummary");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}
/// See [`WorkerConfigurationSummary`](crate::model::WorkerConfigurationSummary)
pub mod worker_configuration_summary {
    /// A builder for [`WorkerConfigurationSummary`](crate::model::WorkerConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) latest_revision:
            std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that a worker configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that a worker configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of a worker configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a worker configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The latest revision of a worker configuration.</p>
        pub fn latest_revision(
            mut self,
            input: crate::model::WorkerConfigurationRevisionSummary,
        ) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of a worker configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerConfigurationSummary`](crate::model::WorkerConfigurationSummary)
        pub fn build(self) -> crate::model::WorkerConfigurationSummary {
            crate::model::WorkerConfigurationSummary {
                creation_time: self.creation_time,
                description: self.description,
                latest_revision: self.latest_revision,
                name: self.name,
                worker_configuration_arn: self.worker_configuration_arn,
            }
        }
    }
}
impl WorkerConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`WorkerConfigurationSummary`](crate::model::WorkerConfigurationSummary)
    pub fn builder() -> crate::model::worker_configuration_summary::Builder {
        crate::model::worker_configuration_summary::Builder::default()
    }
}

/// <p>The summary of a worker configuration revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerConfigurationRevisionSummary {
    /// <p>The time that a worker configuration revision was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of a worker configuration revision.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The revision of a worker configuration.</p>
    pub revision: i64,
}
impl WorkerConfigurationRevisionSummary {
    /// <p>The time that a worker configuration revision was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of a worker configuration revision.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The revision of a worker configuration.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
}
impl std::fmt::Debug for WorkerConfigurationRevisionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerConfigurationRevisionSummary");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`WorkerConfigurationRevisionSummary`](crate::model::WorkerConfigurationRevisionSummary)
pub mod worker_configuration_revision_summary {
    /// A builder for [`WorkerConfigurationRevisionSummary`](crate::model::WorkerConfigurationRevisionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The time that a worker configuration revision was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that a worker configuration revision was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of a worker configuration revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a worker configuration revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The revision of a worker configuration.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of a worker configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerConfigurationRevisionSummary`](crate::model::WorkerConfigurationRevisionSummary)
        pub fn build(self) -> crate::model::WorkerConfigurationRevisionSummary {
            crate::model::WorkerConfigurationRevisionSummary {
                creation_time: self.creation_time,
                description: self.description,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl WorkerConfigurationRevisionSummary {
    /// Creates a new builder-style object to manufacture [`WorkerConfigurationRevisionSummary`](crate::model::WorkerConfigurationRevisionSummary)
    pub fn builder() -> crate::model::worker_configuration_revision_summary::Builder {
        crate::model::worker_configuration_revision_summary::Builder::default()
    }
}

/// <p>A summary of the custom plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginSummary {
    /// <p>The time that the custom plugin was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
    /// <p>The state of the custom plugin.</p>
    pub custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
    /// <p>A description of the custom plugin.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The latest revision of the custom plugin.</p>
    pub latest_revision: std::option::Option<crate::model::CustomPluginRevisionSummary>,
    /// <p>The name of the custom plugin.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CustomPluginSummary {
    /// <p>The time that the custom plugin was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub fn custom_plugin_arn(&self) -> std::option::Option<&str> {
        self.custom_plugin_arn.as_deref()
    }
    /// <p>The state of the custom plugin.</p>
    pub fn custom_plugin_state(&self) -> std::option::Option<&crate::model::CustomPluginState> {
        self.custom_plugin_state.as_ref()
    }
    /// <p>A description of the custom plugin.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The latest revision of the custom plugin.</p>
    pub fn latest_revision(
        &self,
    ) -> std::option::Option<&crate::model::CustomPluginRevisionSummary> {
        self.latest_revision.as_ref()
    }
    /// <p>The name of the custom plugin.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CustomPluginSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginSummary");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.field("custom_plugin_state", &self.custom_plugin_state);
        formatter.field("description", &self.description);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CustomPluginSummary`](crate::model::CustomPluginSummary)
pub mod custom_plugin_summary {
    /// A builder for [`CustomPluginSummary`](crate::model::CustomPluginSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
        pub(crate) custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::CustomPluginRevisionSummary>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that the custom plugin was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the custom plugin was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn custom_plugin_state(mut self, input: crate::model::CustomPluginState) -> Self {
            self.custom_plugin_state = Some(input);
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn set_custom_plugin_state(
            mut self,
            input: std::option::Option<crate::model::CustomPluginState>,
        ) -> Self {
            self.custom_plugin_state = input;
            self
        }
        /// <p>A description of the custom plugin.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the custom plugin.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The latest revision of the custom plugin.</p>
        pub fn latest_revision(mut self, input: crate::model::CustomPluginRevisionSummary) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of the custom plugin.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::CustomPluginRevisionSummary>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginSummary`](crate::model::CustomPluginSummary)
        pub fn build(self) -> crate::model::CustomPluginSummary {
            crate::model::CustomPluginSummary {
                creation_time: self.creation_time,
                custom_plugin_arn: self.custom_plugin_arn,
                custom_plugin_state: self.custom_plugin_state,
                description: self.description,
                latest_revision: self.latest_revision,
                name: self.name,
            }
        }
    }
}
impl CustomPluginSummary {
    /// Creates a new builder-style object to manufacture [`CustomPluginSummary`](crate::model::CustomPluginSummary)
    pub fn builder() -> crate::model::custom_plugin_summary::Builder {
        crate::model::custom_plugin_summary::Builder::default()
    }
}

/// <p>Details about the revision of a custom plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginRevisionSummary {
    /// <p>The format of the plugin file.</p>
    pub content_type: std::option::Option<crate::model::CustomPluginContentType>,
    /// <p>The time that the custom plugin was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the custom plugin.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Details about the custom plugin file.</p>
    pub file_description: std::option::Option<crate::model::CustomPluginFileDescription>,
    /// <p>Information about the location of the custom plugin.</p>
    pub location: std::option::Option<crate::model::CustomPluginLocationDescription>,
    /// <p>The revision of the custom plugin.</p>
    pub revision: i64,
}
impl CustomPluginRevisionSummary {
    /// <p>The format of the plugin file.</p>
    pub fn content_type(&self) -> std::option::Option<&crate::model::CustomPluginContentType> {
        self.content_type.as_ref()
    }
    /// <p>The time that the custom plugin was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of the custom plugin.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Details about the custom plugin file.</p>
    pub fn file_description(
        &self,
    ) -> std::option::Option<&crate::model::CustomPluginFileDescription> {
        self.file_description.as_ref()
    }
    /// <p>Information about the location of the custom plugin.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::CustomPluginLocationDescription> {
        self.location.as_ref()
    }
    /// <p>The revision of the custom plugin.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
}
impl std::fmt::Debug for CustomPluginRevisionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginRevisionSummary");
        formatter.field("content_type", &self.content_type);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("file_description", &self.file_description);
        formatter.field("location", &self.location);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`CustomPluginRevisionSummary`](crate::model::CustomPluginRevisionSummary)
pub mod custom_plugin_revision_summary {
    /// A builder for [`CustomPluginRevisionSummary`](crate::model::CustomPluginRevisionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<crate::model::CustomPluginContentType>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) file_description: std::option::Option<crate::model::CustomPluginFileDescription>,
        pub(crate) location: std::option::Option<crate::model::CustomPluginLocationDescription>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The format of the plugin file.</p>
        pub fn content_type(mut self, input: crate::model::CustomPluginContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The format of the plugin file.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::CustomPluginContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The time that the custom plugin was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the custom plugin was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the custom plugin.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the custom plugin.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Details about the custom plugin file.</p>
        pub fn file_description(
            mut self,
            input: crate::model::CustomPluginFileDescription,
        ) -> Self {
            self.file_description = Some(input);
            self
        }
        /// <p>Details about the custom plugin file.</p>
        pub fn set_file_description(
            mut self,
            input: std::option::Option<crate::model::CustomPluginFileDescription>,
        ) -> Self {
            self.file_description = input;
            self
        }
        /// <p>Information about the location of the custom plugin.</p>
        pub fn location(mut self, input: crate::model::CustomPluginLocationDescription) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Information about the location of the custom plugin.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::CustomPluginLocationDescription>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginRevisionSummary`](crate::model::CustomPluginRevisionSummary)
        pub fn build(self) -> crate::model::CustomPluginRevisionSummary {
            crate::model::CustomPluginRevisionSummary {
                content_type: self.content_type,
                creation_time: self.creation_time,
                description: self.description,
                file_description: self.file_description,
                location: self.location,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl CustomPluginRevisionSummary {
    /// Creates a new builder-style object to manufacture [`CustomPluginRevisionSummary`](crate::model::CustomPluginRevisionSummary)
    pub fn builder() -> crate::model::custom_plugin_revision_summary::Builder {
        crate::model::custom_plugin_revision_summary::Builder::default()
    }
}

/// <p>Information about the location of a custom plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginLocationDescription {
    /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
    pub s3_location: std::option::Option<crate::model::S3LocationDescription>,
}
impl CustomPluginLocationDescription {
    /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3LocationDescription> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for CustomPluginLocationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginLocationDescription");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`CustomPluginLocationDescription`](crate::model::CustomPluginLocationDescription)
pub mod custom_plugin_location_description {
    /// A builder for [`CustomPluginLocationDescription`](crate::model::CustomPluginLocationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3LocationDescription>,
    }
    impl Builder {
        /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
        pub fn s3_location(mut self, input: crate::model::S3LocationDescription) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3LocationDescription>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginLocationDescription`](crate::model::CustomPluginLocationDescription)
        pub fn build(self) -> crate::model::CustomPluginLocationDescription {
            crate::model::CustomPluginLocationDescription {
                s3_location: self.s3_location,
            }
        }
    }
}
impl CustomPluginLocationDescription {
    /// Creates a new builder-style object to manufacture [`CustomPluginLocationDescription`](crate::model::CustomPluginLocationDescription)
    pub fn builder() -> crate::model::custom_plugin_location_description::Builder {
        crate::model::custom_plugin_location_description::Builder::default()
    }
}

/// <p>The description of the location of an object in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LocationDescription {
    /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The file key for an object in an S3 bucket.</p>
    pub file_key: std::option::Option<std::string::String>,
    /// <p>The version of an object in an S3 bucket.</p>
    pub object_version: std::option::Option<std::string::String>,
}
impl S3LocationDescription {
    /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The file key for an object in an S3 bucket.</p>
    pub fn file_key(&self) -> std::option::Option<&str> {
        self.file_key.as_deref()
    }
    /// <p>The version of an object in an S3 bucket.</p>
    pub fn object_version(&self) -> std::option::Option<&str> {
        self.object_version.as_deref()
    }
}
impl std::fmt::Debug for S3LocationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LocationDescription");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("file_key", &self.file_key);
        formatter.field("object_version", &self.object_version);
        formatter.finish()
    }
}
/// See [`S3LocationDescription`](crate::model::S3LocationDescription)
pub mod s3_location_description {
    /// A builder for [`S3LocationDescription`](crate::model::S3LocationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) file_key: std::option::Option<std::string::String>,
        pub(crate) object_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The file key for an object in an S3 bucket.</p>
        pub fn file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key = Some(input.into());
            self
        }
        /// <p>The file key for an object in an S3 bucket.</p>
        pub fn set_file_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_key = input;
            self
        }
        /// <p>The version of an object in an S3 bucket.</p>
        pub fn object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_version = Some(input.into());
            self
        }
        /// <p>The version of an object in an S3 bucket.</p>
        pub fn set_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LocationDescription`](crate::model::S3LocationDescription)
        pub fn build(self) -> crate::model::S3LocationDescription {
            crate::model::S3LocationDescription {
                bucket_arn: self.bucket_arn,
                file_key: self.file_key,
                object_version: self.object_version,
            }
        }
    }
}
impl S3LocationDescription {
    /// Creates a new builder-style object to manufacture [`S3LocationDescription`](crate::model::S3LocationDescription)
    pub fn builder() -> crate::model::s3_location_description::Builder {
        crate::model::s3_location_description::Builder::default()
    }
}

/// <p>Details about a custom plugin file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginFileDescription {
    /// <p>The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.</p>
    pub file_md5: std::option::Option<std::string::String>,
    /// <p>The size in bytes of the custom plugin file. You can use it to validate the file.</p>
    pub file_size: i64,
}
impl CustomPluginFileDescription {
    /// <p>The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.</p>
    pub fn file_md5(&self) -> std::option::Option<&str> {
        self.file_md5.as_deref()
    }
    /// <p>The size in bytes of the custom plugin file. You can use it to validate the file.</p>
    pub fn file_size(&self) -> i64 {
        self.file_size
    }
}
impl std::fmt::Debug for CustomPluginFileDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginFileDescription");
        formatter.field("file_md5", &self.file_md5);
        formatter.field("file_size", &self.file_size);
        formatter.finish()
    }
}
/// See [`CustomPluginFileDescription`](crate::model::CustomPluginFileDescription)
pub mod custom_plugin_file_description {
    /// A builder for [`CustomPluginFileDescription`](crate::model::CustomPluginFileDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_md5: std::option::Option<std::string::String>,
        pub(crate) file_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.</p>
        pub fn file_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_md5 = Some(input.into());
            self
        }
        /// <p>The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.</p>
        pub fn set_file_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_md5 = input;
            self
        }
        /// <p>The size in bytes of the custom plugin file. You can use it to validate the file.</p>
        pub fn file_size(mut self, input: i64) -> Self {
            self.file_size = Some(input);
            self
        }
        /// <p>The size in bytes of the custom plugin file. You can use it to validate the file.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.file_size = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginFileDescription`](crate::model::CustomPluginFileDescription)
        pub fn build(self) -> crate::model::CustomPluginFileDescription {
            crate::model::CustomPluginFileDescription {
                file_md5: self.file_md5,
                file_size: self.file_size.unwrap_or_default(),
            }
        }
    }
}
impl CustomPluginFileDescription {
    /// Creates a new builder-style object to manufacture [`CustomPluginFileDescription`](crate::model::CustomPluginFileDescription)
    pub fn builder() -> crate::model::custom_plugin_file_description::Builder {
        crate::model::custom_plugin_file_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomPluginContentType {
    #[allow(missing_docs)] // documentation missing in model
    Jar,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomPluginContentType {
    fn from(s: &str) -> Self {
        match s {
            "JAR" => CustomPluginContentType::Jar,
            "ZIP" => CustomPluginContentType::Zip,
            other => CustomPluginContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomPluginContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomPluginContentType::from(s))
    }
}
impl CustomPluginContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomPluginContentType::Jar => "JAR",
            CustomPluginContentType::Zip => "ZIP",
            CustomPluginContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JAR", "ZIP"]
    }
}
impl AsRef<str> for CustomPluginContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomPluginState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomPluginState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CustomPluginState::Active,
            "CREATE_FAILED" => CustomPluginState::CreateFailed,
            "CREATING" => CustomPluginState::Creating,
            "DELETING" => CustomPluginState::Deleting,
            "UPDATE_FAILED" => CustomPluginState::UpdateFailed,
            "UPDATING" => CustomPluginState::Updating,
            other => CustomPluginState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomPluginState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomPluginState::from(s))
    }
}
impl CustomPluginState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomPluginState::Active => "ACTIVE",
            CustomPluginState::CreateFailed => "CREATE_FAILED",
            CustomPluginState::Creating => "CREATING",
            CustomPluginState::Deleting => "DELETING",
            CustomPluginState::UpdateFailed => "UPDATE_FAILED",
            CustomPluginState::Updating => "UPDATING",
            CustomPluginState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATING",
            "DELETING",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for CustomPluginState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary of a connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorSummary {
    /// <p>The connector's compute capacity settings.</p>
    pub capacity: std::option::Option<crate::model::CapacityDescription>,
    /// <p>The Amazon Resource Name (ARN) of the connector.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The description of the connector.</p>
    pub connector_description: std::option::Option<std::string::String>,
    /// <p>The name of the connector.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>The state of the connector.</p>
    pub connector_state: std::option::Option<crate::model::ConnectorState>,
    /// <p>The time that the connector was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current version of the connector.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
    pub kafka_cluster: std::option::Option<crate::model::KafkaClusterDescription>,
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
    pub kafka_cluster_client_authentication:
        std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
    /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
    pub kafka_cluster_encryption_in_transit:
        std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
    /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
    pub kafka_connect_version: std::option::Option<std::string::String>,
    /// <p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>
    pub log_delivery: std::option::Option<crate::model::LogDeliveryDescription>,
    /// <p>Specifies which plugins were used for this connector.</p>
    pub plugins: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
    pub service_execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The worker configurations that are in use with the connector.</p>
    pub worker_configuration: std::option::Option<crate::model::WorkerConfigurationDescription>,
}
impl ConnectorSummary {
    /// <p>The connector's compute capacity settings.</p>
    pub fn capacity(&self) -> std::option::Option<&crate::model::CapacityDescription> {
        self.capacity.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the connector.</p>
    pub fn connector_arn(&self) -> std::option::Option<&str> {
        self.connector_arn.as_deref()
    }
    /// <p>The description of the connector.</p>
    pub fn connector_description(&self) -> std::option::Option<&str> {
        self.connector_description.as_deref()
    }
    /// <p>The name of the connector.</p>
    pub fn connector_name(&self) -> std::option::Option<&str> {
        self.connector_name.as_deref()
    }
    /// <p>The state of the connector.</p>
    pub fn connector_state(&self) -> std::option::Option<&crate::model::ConnectorState> {
        self.connector_state.as_ref()
    }
    /// <p>The time that the connector was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The current version of the connector.</p>
    pub fn current_version(&self) -> std::option::Option<&str> {
        self.current_version.as_deref()
    }
    /// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
    pub fn kafka_cluster(&self) -> std::option::Option<&crate::model::KafkaClusterDescription> {
        self.kafka_cluster.as_ref()
    }
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
    pub fn kafka_cluster_client_authentication(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterClientAuthenticationDescription> {
        self.kafka_cluster_client_authentication.as_ref()
    }
    /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
    pub fn kafka_cluster_encryption_in_transit(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterEncryptionInTransitDescription> {
        self.kafka_cluster_encryption_in_transit.as_ref()
    }
    /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
    pub fn kafka_connect_version(&self) -> std::option::Option<&str> {
        self.kafka_connect_version.as_deref()
    }
    /// <p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>
    pub fn log_delivery(&self) -> std::option::Option<&crate::model::LogDeliveryDescription> {
        self.log_delivery.as_ref()
    }
    /// <p>Specifies which plugins were used for this connector.</p>
    pub fn plugins(&self) -> std::option::Option<&[crate::model::PluginDescription]> {
        self.plugins.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
    pub fn service_execution_role_arn(&self) -> std::option::Option<&str> {
        self.service_execution_role_arn.as_deref()
    }
    /// <p>The worker configurations that are in use with the connector.</p>
    pub fn worker_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WorkerConfigurationDescription> {
        self.worker_configuration.as_ref()
    }
}
impl std::fmt::Debug for ConnectorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorSummary");
        formatter.field("capacity", &self.capacity);
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_description", &self.connector_description);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("connector_state", &self.connector_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("current_version", &self.current_version);
        formatter.field("kafka_cluster", &self.kafka_cluster);
        formatter.field(
            "kafka_cluster_client_authentication",
            &self.kafka_cluster_client_authentication,
        );
        formatter.field(
            "kafka_cluster_encryption_in_transit",
            &self.kafka_cluster_encryption_in_transit,
        );
        formatter.field("kafka_connect_version", &self.kafka_connect_version);
        formatter.field("log_delivery", &self.log_delivery);
        formatter.field("plugins", &self.plugins);
        formatter.field(
            "service_execution_role_arn",
            &self.service_execution_role_arn,
        );
        formatter.field("worker_configuration", &self.worker_configuration);
        formatter.finish()
    }
}
/// See [`ConnectorSummary`](crate::model::ConnectorSummary)
pub mod connector_summary {
    /// A builder for [`ConnectorSummary`](crate::model::ConnectorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<crate::model::CapacityDescription>,
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_description: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) connector_state: std::option::Option<crate::model::ConnectorState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) kafka_cluster: std::option::Option<crate::model::KafkaClusterDescription>,
        pub(crate) kafka_cluster_client_authentication:
            std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
        pub(crate) kafka_cluster_encryption_in_transit:
            std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
        pub(crate) kafka_connect_version: std::option::Option<std::string::String>,
        pub(crate) log_delivery: std::option::Option<crate::model::LogDeliveryDescription>,
        pub(crate) plugins: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
        pub(crate) service_execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) worker_configuration:
            std::option::Option<crate::model::WorkerConfigurationDescription>,
    }
    impl Builder {
        /// <p>The connector's compute capacity settings.</p>
        pub fn capacity(mut self, input: crate::model::CapacityDescription) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>The connector's compute capacity settings.</p>
        pub fn set_capacity(
            mut self,
            input: std::option::Option<crate::model::CapacityDescription>,
        ) -> Self {
            self.capacity = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The description of the connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_description = Some(input.into());
            self
        }
        /// <p>The description of the connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_description = input;
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>The state of the connector.</p>
        pub fn connector_state(mut self, input: crate::model::ConnectorState) -> Self {
            self.connector_state = Some(input);
            self
        }
        /// <p>The state of the connector.</p>
        pub fn set_connector_state(
            mut self,
            input: std::option::Option<crate::model::ConnectorState>,
        ) -> Self {
            self.connector_state = input;
            self
        }
        /// <p>The time that the connector was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the connector was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The current version of the connector.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the connector.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
        pub fn kafka_cluster(mut self, input: crate::model::KafkaClusterDescription) -> Self {
            self.kafka_cluster = Some(input);
            self
        }
        /// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
        pub fn set_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterDescription>,
        ) -> Self {
            self.kafka_cluster = input;
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
        pub fn kafka_cluster_client_authentication(
            mut self,
            input: crate::model::KafkaClusterClientAuthenticationDescription,
        ) -> Self {
            self.kafka_cluster_client_authentication = Some(input);
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
        pub fn set_kafka_cluster_client_authentication(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
        ) -> Self {
            self.kafka_cluster_client_authentication = input;
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn kafka_cluster_encryption_in_transit(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransitDescription,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = Some(input);
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_encryption_in_transit(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = input;
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn kafka_connect_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.kafka_connect_version = Some(input.into());
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn set_kafka_connect_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kafka_connect_version = input;
            self
        }
        /// <p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>
        pub fn log_delivery(mut self, input: crate::model::LogDeliveryDescription) -> Self {
            self.log_delivery = Some(input);
            self
        }
        /// <p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>
        pub fn set_log_delivery(
            mut self,
            input: std::option::Option<crate::model::LogDeliveryDescription>,
        ) -> Self {
            self.log_delivery = input;
            self
        }
        /// Appends an item to `plugins`.
        ///
        /// To override the contents of this collection use [`set_plugins`](Self::set_plugins).
        ///
        /// <p>Specifies which plugins were used for this connector.</p>
        pub fn plugins(mut self, input: crate::model::PluginDescription) -> Self {
            let mut v = self.plugins.unwrap_or_default();
            v.push(input);
            self.plugins = Some(v);
            self
        }
        /// <p>Specifies which plugins were used for this connector.</p>
        pub fn set_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
        ) -> Self {
            self.plugins = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
        pub fn service_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
        pub fn set_service_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_execution_role_arn = input;
            self
        }
        /// <p>The worker configurations that are in use with the connector.</p>
        pub fn worker_configuration(
            mut self,
            input: crate::model::WorkerConfigurationDescription,
        ) -> Self {
            self.worker_configuration = Some(input);
            self
        }
        /// <p>The worker configurations that are in use with the connector.</p>
        pub fn set_worker_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkerConfigurationDescription>,
        ) -> Self {
            self.worker_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorSummary`](crate::model::ConnectorSummary)
        pub fn build(self) -> crate::model::ConnectorSummary {
            crate::model::ConnectorSummary {
                capacity: self.capacity,
                connector_arn: self.connector_arn,
                connector_description: self.connector_description,
                connector_name: self.connector_name,
                connector_state: self.connector_state,
                creation_time: self.creation_time,
                current_version: self.current_version,
                kafka_cluster: self.kafka_cluster,
                kafka_cluster_client_authentication: self.kafka_cluster_client_authentication,
                kafka_cluster_encryption_in_transit: self.kafka_cluster_encryption_in_transit,
                kafka_connect_version: self.kafka_connect_version,
                log_delivery: self.log_delivery,
                plugins: self.plugins,
                service_execution_role_arn: self.service_execution_role_arn,
                worker_configuration: self.worker_configuration,
            }
        }
    }
}
impl ConnectorSummary {
    /// Creates a new builder-style object to manufacture [`ConnectorSummary`](crate::model::ConnectorSummary)
    pub fn builder() -> crate::model::connector_summary::Builder {
        crate::model::connector_summary::Builder::default()
    }
}

/// <p>The description of the worker configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerConfigurationDescription {
    /// <p>The revision of the worker configuration.</p>
    pub revision: i64,
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl WorkerConfigurationDescription {
    /// <p>The revision of the worker configuration.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub fn worker_configuration_arn(&self) -> std::option::Option<&str> {
        self.worker_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for WorkerConfigurationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerConfigurationDescription");
        formatter.field("revision", &self.revision);
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}
/// See [`WorkerConfigurationDescription`](crate::model::WorkerConfigurationDescription)
pub mod worker_configuration_description {
    /// A builder for [`WorkerConfigurationDescription`](crate::model::WorkerConfigurationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision: std::option::Option<i64>,
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The revision of the worker configuration.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the worker configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerConfigurationDescription`](crate::model::WorkerConfigurationDescription)
        pub fn build(self) -> crate::model::WorkerConfigurationDescription {
            crate::model::WorkerConfigurationDescription {
                revision: self.revision.unwrap_or_default(),
                worker_configuration_arn: self.worker_configuration_arn,
            }
        }
    }
}
impl WorkerConfigurationDescription {
    /// Creates a new builder-style object to manufacture [`WorkerConfigurationDescription`](crate::model::WorkerConfigurationDescription)
    pub fn builder() -> crate::model::worker_configuration_description::Builder {
        crate::model::worker_configuration_description::Builder::default()
    }
}

/// <p>The description of the plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PluginDescription {
    /// <p>Details about a custom plugin.</p>
    pub custom_plugin: std::option::Option<crate::model::CustomPluginDescription>,
}
impl PluginDescription {
    /// <p>Details about a custom plugin.</p>
    pub fn custom_plugin(&self) -> std::option::Option<&crate::model::CustomPluginDescription> {
        self.custom_plugin.as_ref()
    }
}
impl std::fmt::Debug for PluginDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PluginDescription");
        formatter.field("custom_plugin", &self.custom_plugin);
        formatter.finish()
    }
}
/// See [`PluginDescription`](crate::model::PluginDescription)
pub mod plugin_description {
    /// A builder for [`PluginDescription`](crate::model::PluginDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin: std::option::Option<crate::model::CustomPluginDescription>,
    }
    impl Builder {
        /// <p>Details about a custom plugin.</p>
        pub fn custom_plugin(mut self, input: crate::model::CustomPluginDescription) -> Self {
            self.custom_plugin = Some(input);
            self
        }
        /// <p>Details about a custom plugin.</p>
        pub fn set_custom_plugin(
            mut self,
            input: std::option::Option<crate::model::CustomPluginDescription>,
        ) -> Self {
            self.custom_plugin = input;
            self
        }
        /// Consumes the builder and constructs a [`PluginDescription`](crate::model::PluginDescription)
        pub fn build(self) -> crate::model::PluginDescription {
            crate::model::PluginDescription {
                custom_plugin: self.custom_plugin,
            }
        }
    }
}
impl PluginDescription {
    /// Creates a new builder-style object to manufacture [`PluginDescription`](crate::model::PluginDescription)
    pub fn builder() -> crate::model::plugin_description::Builder {
        crate::model::plugin_description::Builder::default()
    }
}

/// <p>Details about a custom plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginDescription {
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
    /// <p>The revision of the custom plugin.</p>
    pub revision: i64,
}
impl CustomPluginDescription {
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub fn custom_plugin_arn(&self) -> std::option::Option<&str> {
        self.custom_plugin_arn.as_deref()
    }
    /// <p>The revision of the custom plugin.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
}
impl std::fmt::Debug for CustomPluginDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginDescription");
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`CustomPluginDescription`](crate::model::CustomPluginDescription)
pub mod custom_plugin_description {
    /// A builder for [`CustomPluginDescription`](crate::model::CustomPluginDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginDescription`](crate::model::CustomPluginDescription)
        pub fn build(self) -> crate::model::CustomPluginDescription {
            crate::model::CustomPluginDescription {
                custom_plugin_arn: self.custom_plugin_arn,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl CustomPluginDescription {
    /// Creates a new builder-style object to manufacture [`CustomPluginDescription`](crate::model::CustomPluginDescription)
    pub fn builder() -> crate::model::custom_plugin_description::Builder {
        crate::model::custom_plugin_description::Builder::default()
    }
}

/// <p>The description of the log delivery settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDeliveryDescription {
    /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
    pub worker_log_delivery: std::option::Option<crate::model::WorkerLogDeliveryDescription>,
}
impl LogDeliveryDescription {
    /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
    pub fn worker_log_delivery(
        &self,
    ) -> std::option::Option<&crate::model::WorkerLogDeliveryDescription> {
        self.worker_log_delivery.as_ref()
    }
}
impl std::fmt::Debug for LogDeliveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDeliveryDescription");
        formatter.field("worker_log_delivery", &self.worker_log_delivery);
        formatter.finish()
    }
}
/// See [`LogDeliveryDescription`](crate::model::LogDeliveryDescription)
pub mod log_delivery_description {
    /// A builder for [`LogDeliveryDescription`](crate::model::LogDeliveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_log_delivery:
            std::option::Option<crate::model::WorkerLogDeliveryDescription>,
    }
    impl Builder {
        /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
        pub fn worker_log_delivery(
            mut self,
            input: crate::model::WorkerLogDeliveryDescription,
        ) -> Self {
            self.worker_log_delivery = Some(input);
            self
        }
        /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
        pub fn set_worker_log_delivery(
            mut self,
            input: std::option::Option<crate::model::WorkerLogDeliveryDescription>,
        ) -> Self {
            self.worker_log_delivery = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDeliveryDescription`](crate::model::LogDeliveryDescription)
        pub fn build(self) -> crate::model::LogDeliveryDescription {
            crate::model::LogDeliveryDescription {
                worker_log_delivery: self.worker_log_delivery,
            }
        }
    }
}
impl LogDeliveryDescription {
    /// Creates a new builder-style object to manufacture [`LogDeliveryDescription`](crate::model::LogDeliveryDescription)
    pub fn builder() -> crate::model::log_delivery_description::Builder {
        crate::model::log_delivery_description::Builder::default()
    }
}

/// <p>Workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerLogDeliveryDescription {
    /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsLogDeliveryDescription>,
    /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
    pub firehose: std::option::Option<crate::model::FirehoseLogDeliveryDescription>,
    /// <p>Details about delivering logs to Amazon S3.</p>
    pub s3: std::option::Option<crate::model::S3LogDeliveryDescription>,
}
impl WorkerLogDeliveryDescription {
    /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
    pub fn cloud_watch_logs(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsLogDeliveryDescription> {
        self.cloud_watch_logs.as_ref()
    }
    /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
    pub fn firehose(&self) -> std::option::Option<&crate::model::FirehoseLogDeliveryDescription> {
        self.firehose.as_ref()
    }
    /// <p>Details about delivering logs to Amazon S3.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3LogDeliveryDescription> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for WorkerLogDeliveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerLogDeliveryDescription");
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.field("firehose", &self.firehose);
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`WorkerLogDeliveryDescription`](crate::model::WorkerLogDeliveryDescription)
pub mod worker_log_delivery_description {
    /// A builder for [`WorkerLogDeliveryDescription`](crate::model::WorkerLogDeliveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs:
            std::option::Option<crate::model::CloudWatchLogsLogDeliveryDescription>,
        pub(crate) firehose: std::option::Option<crate::model::FirehoseLogDeliveryDescription>,
        pub(crate) s3: std::option::Option<crate::model::S3LogDeliveryDescription>,
    }
    impl Builder {
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn cloud_watch_logs(
            mut self,
            input: crate::model::CloudWatchLogsLogDeliveryDescription,
        ) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsLogDeliveryDescription>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
        pub fn firehose(mut self, input: crate::model::FirehoseLogDeliveryDescription) -> Self {
            self.firehose = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
        pub fn set_firehose(
            mut self,
            input: std::option::Option<crate::model::FirehoseLogDeliveryDescription>,
        ) -> Self {
            self.firehose = input;
            self
        }
        /// <p>Details about delivering logs to Amazon S3.</p>
        pub fn s3(mut self, input: crate::model::S3LogDeliveryDescription) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon S3.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3LogDeliveryDescription>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerLogDeliveryDescription`](crate::model::WorkerLogDeliveryDescription)
        pub fn build(self) -> crate::model::WorkerLogDeliveryDescription {
            crate::model::WorkerLogDeliveryDescription {
                cloud_watch_logs: self.cloud_watch_logs,
                firehose: self.firehose,
                s3: self.s3,
            }
        }
    }
}
impl WorkerLogDeliveryDescription {
    /// Creates a new builder-style object to manufacture [`WorkerLogDeliveryDescription`](crate::model::WorkerLogDeliveryDescription)
    pub fn builder() -> crate::model::worker_log_delivery_description::Builder {
        crate::model::worker_log_delivery_description::Builder::default()
    }
}

/// <p>The description of the details about delivering logs to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LogDeliveryDescription {
    /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
    pub enabled: bool,
    /// <p>The S3 prefix that is the destination for log delivery.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3LogDeliveryDescription {
    /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The S3 prefix that is the destination for log delivery.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3LogDeliveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LogDeliveryDescription");
        formatter.field("bucket", &self.bucket);
        formatter.field("enabled", &self.enabled);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3LogDeliveryDescription`](crate::model::S3LogDeliveryDescription)
pub mod s3_log_delivery_description {
    /// A builder for [`S3LogDeliveryDescription`](crate::model::S3LogDeliveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The S3 prefix that is the destination for log delivery.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The S3 prefix that is the destination for log delivery.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LogDeliveryDescription`](crate::model::S3LogDeliveryDescription)
        pub fn build(self) -> crate::model::S3LogDeliveryDescription {
            crate::model::S3LogDeliveryDescription {
                bucket: self.bucket,
                enabled: self.enabled.unwrap_or_default(),
                prefix: self.prefix,
            }
        }
    }
}
impl S3LogDeliveryDescription {
    /// Creates a new builder-style object to manufacture [`S3LogDeliveryDescription`](crate::model::S3LogDeliveryDescription)
    pub fn builder() -> crate::model::s3_log_delivery_description::Builder {
        crate::model::s3_log_delivery_description::Builder::default()
    }
}

/// <p>A description of the settings for delivering logs to Amazon Kinesis Data Firehose.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirehoseLogDeliveryDescription {
    /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
    pub delivery_stream: std::option::Option<std::string::String>,
    /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
    pub enabled: bool,
}
impl FirehoseLogDeliveryDescription {
    /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
    pub fn delivery_stream(&self) -> std::option::Option<&str> {
        self.delivery_stream.as_deref()
    }
    /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for FirehoseLogDeliveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirehoseLogDeliveryDescription");
        formatter.field("delivery_stream", &self.delivery_stream);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`FirehoseLogDeliveryDescription`](crate::model::FirehoseLogDeliveryDescription)
pub mod firehose_log_delivery_description {
    /// A builder for [`FirehoseLogDeliveryDescription`](crate::model::FirehoseLogDeliveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
        pub fn delivery_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
        pub fn set_delivery_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream = input;
            self
        }
        /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`FirehoseLogDeliveryDescription`](crate::model::FirehoseLogDeliveryDescription)
        pub fn build(self) -> crate::model::FirehoseLogDeliveryDescription {
            crate::model::FirehoseLogDeliveryDescription {
                delivery_stream: self.delivery_stream,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl FirehoseLogDeliveryDescription {
    /// Creates a new builder-style object to manufacture [`FirehoseLogDeliveryDescription`](crate::model::FirehoseLogDeliveryDescription)
    pub fn builder() -> crate::model::firehose_log_delivery_description::Builder {
        crate::model::firehose_log_delivery_description::Builder::default()
    }
}

/// <p>A description of the log delivery settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsLogDeliveryDescription {
    /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
    pub enabled: bool,
    /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl CloudWatchLogsLogDeliveryDescription {
    /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsLogDeliveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsLogDeliveryDescription");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsLogDeliveryDescription`](crate::model::CloudWatchLogsLogDeliveryDescription)
pub mod cloud_watch_logs_log_delivery_description {
    /// A builder for [`CloudWatchLogsLogDeliveryDescription`](crate::model::CloudWatchLogsLogDeliveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsLogDeliveryDescription`](crate::model::CloudWatchLogsLogDeliveryDescription)
        pub fn build(self) -> crate::model::CloudWatchLogsLogDeliveryDescription {
            crate::model::CloudWatchLogsLogDeliveryDescription {
                enabled: self.enabled.unwrap_or_default(),
                log_group: self.log_group,
            }
        }
    }
}
impl CloudWatchLogsLogDeliveryDescription {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsLogDeliveryDescription`](crate::model::CloudWatchLogsLogDeliveryDescription)
    pub fn builder() -> crate::model::cloud_watch_logs_log_delivery_description::Builder {
        crate::model::cloud_watch_logs_log_delivery_description::Builder::default()
    }
}

/// <p>The description of the encryption in transit to the Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaClusterEncryptionInTransitDescription {
    /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
    pub encryption_type: std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
}
impl KafkaClusterEncryptionInTransitDescription {
    /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
    pub fn encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterEncryptionInTransitType> {
        self.encryption_type.as_ref()
    }
}
impl std::fmt::Debug for KafkaClusterEncryptionInTransitDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaClusterEncryptionInTransitDescription");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`KafkaClusterEncryptionInTransitDescription`](crate::model::KafkaClusterEncryptionInTransitDescription)
pub mod kafka_cluster_encryption_in_transit_description {
    /// A builder for [`KafkaClusterEncryptionInTransitDescription`](crate::model::KafkaClusterEncryptionInTransitDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type:
            std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
    }
    impl Builder {
        /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
        pub fn encryption_type(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransitType,
        ) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaClusterEncryptionInTransitDescription`](crate::model::KafkaClusterEncryptionInTransitDescription)
        pub fn build(self) -> crate::model::KafkaClusterEncryptionInTransitDescription {
            crate::model::KafkaClusterEncryptionInTransitDescription {
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl KafkaClusterEncryptionInTransitDescription {
    /// Creates a new builder-style object to manufacture [`KafkaClusterEncryptionInTransitDescription`](crate::model::KafkaClusterEncryptionInTransitDescription)
    pub fn builder() -> crate::model::kafka_cluster_encryption_in_transit_description::Builder {
        crate::model::kafka_cluster_encryption_in_transit_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KafkaClusterEncryptionInTransitType {
    #[allow(missing_docs)] // documentation missing in model
    Plaintext,
    #[allow(missing_docs)] // documentation missing in model
    Tls,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KafkaClusterEncryptionInTransitType {
    fn from(s: &str) -> Self {
        match s {
            "PLAINTEXT" => KafkaClusterEncryptionInTransitType::Plaintext,
            "TLS" => KafkaClusterEncryptionInTransitType::Tls,
            other => KafkaClusterEncryptionInTransitType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KafkaClusterEncryptionInTransitType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KafkaClusterEncryptionInTransitType::from(s))
    }
}
impl KafkaClusterEncryptionInTransitType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KafkaClusterEncryptionInTransitType::Plaintext => "PLAINTEXT",
            KafkaClusterEncryptionInTransitType::Tls => "TLS",
            KafkaClusterEncryptionInTransitType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PLAINTEXT", "TLS"]
    }
}
impl AsRef<str> for KafkaClusterEncryptionInTransitType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The client authentication information used in order to authenticate with the Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaClusterClientAuthenticationDescription {
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
    pub authentication_type:
        std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
}
impl KafkaClusterClientAuthenticationDescription {
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
    pub fn authentication_type(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterClientAuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for KafkaClusterClientAuthenticationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaClusterClientAuthenticationDescription");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}
/// See [`KafkaClusterClientAuthenticationDescription`](crate::model::KafkaClusterClientAuthenticationDescription)
pub mod kafka_cluster_client_authentication_description {
    /// A builder for [`KafkaClusterClientAuthenticationDescription`](crate::model::KafkaClusterClientAuthenticationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_type:
            std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
    }
    impl Builder {
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
        pub fn authentication_type(
            mut self,
            input: crate::model::KafkaClusterClientAuthenticationType,
        ) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaClusterClientAuthenticationDescription`](crate::model::KafkaClusterClientAuthenticationDescription)
        pub fn build(self) -> crate::model::KafkaClusterClientAuthenticationDescription {
            crate::model::KafkaClusterClientAuthenticationDescription {
                authentication_type: self.authentication_type,
            }
        }
    }
}
impl KafkaClusterClientAuthenticationDescription {
    /// Creates a new builder-style object to manufacture [`KafkaClusterClientAuthenticationDescription`](crate::model::KafkaClusterClientAuthenticationDescription)
    pub fn builder() -> crate::model::kafka_cluster_client_authentication_description::Builder {
        crate::model::kafka_cluster_client_authentication_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KafkaClusterClientAuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KafkaClusterClientAuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "IAM" => KafkaClusterClientAuthenticationType::Iam,
            "NONE" => KafkaClusterClientAuthenticationType::None,
            other => KafkaClusterClientAuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KafkaClusterClientAuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KafkaClusterClientAuthenticationType::from(s))
    }
}
impl KafkaClusterClientAuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KafkaClusterClientAuthenticationType::Iam => "IAM",
            KafkaClusterClientAuthenticationType::None => "NONE",
            KafkaClusterClientAuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM", "NONE"]
    }
}
impl AsRef<str> for KafkaClusterClientAuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of how to connect to the Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaClusterDescription {
    /// <p>The Apache Kafka cluster to which the connector is connected.</p>
    pub apache_kafka_cluster: std::option::Option<crate::model::ApacheKafkaClusterDescription>,
}
impl KafkaClusterDescription {
    /// <p>The Apache Kafka cluster to which the connector is connected.</p>
    pub fn apache_kafka_cluster(
        &self,
    ) -> std::option::Option<&crate::model::ApacheKafkaClusterDescription> {
        self.apache_kafka_cluster.as_ref()
    }
}
impl std::fmt::Debug for KafkaClusterDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaClusterDescription");
        formatter.field("apache_kafka_cluster", &self.apache_kafka_cluster);
        formatter.finish()
    }
}
/// See [`KafkaClusterDescription`](crate::model::KafkaClusterDescription)
pub mod kafka_cluster_description {
    /// A builder for [`KafkaClusterDescription`](crate::model::KafkaClusterDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apache_kafka_cluster:
            std::option::Option<crate::model::ApacheKafkaClusterDescription>,
    }
    impl Builder {
        /// <p>The Apache Kafka cluster to which the connector is connected.</p>
        pub fn apache_kafka_cluster(
            mut self,
            input: crate::model::ApacheKafkaClusterDescription,
        ) -> Self {
            self.apache_kafka_cluster = Some(input);
            self
        }
        /// <p>The Apache Kafka cluster to which the connector is connected.</p>
        pub fn set_apache_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::ApacheKafkaClusterDescription>,
        ) -> Self {
            self.apache_kafka_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaClusterDescription`](crate::model::KafkaClusterDescription)
        pub fn build(self) -> crate::model::KafkaClusterDescription {
            crate::model::KafkaClusterDescription {
                apache_kafka_cluster: self.apache_kafka_cluster,
            }
        }
    }
}
impl KafkaClusterDescription {
    /// Creates a new builder-style object to manufacture [`KafkaClusterDescription`](crate::model::KafkaClusterDescription)
    pub fn builder() -> crate::model::kafka_cluster_description::Builder {
        crate::model::kafka_cluster_description::Builder::default()
    }
}

/// <p>The description of the Apache Kafka cluster to which the connector is connected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApacheKafkaClusterDescription {
    /// <p>The bootstrap servers of the cluster.</p>
    pub bootstrap_servers: std::option::Option<std::string::String>,
    /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
    pub vpc: std::option::Option<crate::model::VpcDescription>,
}
impl ApacheKafkaClusterDescription {
    /// <p>The bootstrap servers of the cluster.</p>
    pub fn bootstrap_servers(&self) -> std::option::Option<&str> {
        self.bootstrap_servers.as_deref()
    }
    /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::VpcDescription> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for ApacheKafkaClusterDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApacheKafkaClusterDescription");
        formatter.field("bootstrap_servers", &self.bootstrap_servers);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`ApacheKafkaClusterDescription`](crate::model::ApacheKafkaClusterDescription)
pub mod apache_kafka_cluster_description {
    /// A builder for [`ApacheKafkaClusterDescription`](crate::model::ApacheKafkaClusterDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bootstrap_servers: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::VpcDescription>,
    }
    impl Builder {
        /// <p>The bootstrap servers of the cluster.</p>
        pub fn bootstrap_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.bootstrap_servers = Some(input.into());
            self
        }
        /// <p>The bootstrap servers of the cluster.</p>
        pub fn set_bootstrap_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bootstrap_servers = input;
            self
        }
        /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
        pub fn vpc(mut self, input: crate::model::VpcDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::VpcDescription>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`ApacheKafkaClusterDescription`](crate::model::ApacheKafkaClusterDescription)
        pub fn build(self) -> crate::model::ApacheKafkaClusterDescription {
            crate::model::ApacheKafkaClusterDescription {
                bootstrap_servers: self.bootstrap_servers,
                vpc: self.vpc,
            }
        }
    }
}
impl ApacheKafkaClusterDescription {
    /// Creates a new builder-style object to manufacture [`ApacheKafkaClusterDescription`](crate::model::ApacheKafkaClusterDescription)
    pub fn builder() -> crate::model::apache_kafka_cluster_description::Builder {
        crate::model::apache_kafka_cluster_description::Builder::default()
    }
}

/// <p>The description of the VPC in which the connector resides.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcDescription {
    /// <p>The security groups for the connector.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnets for the connector.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcDescription {
    /// <p>The security groups for the connector.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The subnets for the connector.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for VpcDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcDescription");
        formatter.field("security_groups", &self.security_groups);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`VpcDescription`](crate::model::VpcDescription)
pub mod vpc_description {
    /// A builder for [`VpcDescription`](crate::model::VpcDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the connector.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the connector.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The subnets for the connector.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The subnets for the connector.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcDescription`](crate::model::VpcDescription)
        pub fn build(self) -> crate::model::VpcDescription {
            crate::model::VpcDescription {
                security_groups: self.security_groups,
                subnets: self.subnets,
            }
        }
    }
}
impl VpcDescription {
    /// Creates a new builder-style object to manufacture [`VpcDescription`](crate::model::VpcDescription)
    pub fn builder() -> crate::model::vpc_description::Builder {
        crate::model::vpc_description::Builder::default()
    }
}

/// <p>A description of the connector's capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityDescription {
    /// <p>Describes the connector's auto scaling capacity.</p>
    pub auto_scaling: std::option::Option<crate::model::AutoScalingDescription>,
    /// <p>Describes a connector's provisioned capacity.</p>
    pub provisioned_capacity: std::option::Option<crate::model::ProvisionedCapacityDescription>,
}
impl CapacityDescription {
    /// <p>Describes the connector's auto scaling capacity.</p>
    pub fn auto_scaling(&self) -> std::option::Option<&crate::model::AutoScalingDescription> {
        self.auto_scaling.as_ref()
    }
    /// <p>Describes a connector's provisioned capacity.</p>
    pub fn provisioned_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedCapacityDescription> {
        self.provisioned_capacity.as_ref()
    }
}
impl std::fmt::Debug for CapacityDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityDescription");
        formatter.field("auto_scaling", &self.auto_scaling);
        formatter.field("provisioned_capacity", &self.provisioned_capacity);
        formatter.finish()
    }
}
/// See [`CapacityDescription`](crate::model::CapacityDescription)
pub mod capacity_description {
    /// A builder for [`CapacityDescription`](crate::model::CapacityDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling: std::option::Option<crate::model::AutoScalingDescription>,
        pub(crate) provisioned_capacity:
            std::option::Option<crate::model::ProvisionedCapacityDescription>,
    }
    impl Builder {
        /// <p>Describes the connector's auto scaling capacity.</p>
        pub fn auto_scaling(mut self, input: crate::model::AutoScalingDescription) -> Self {
            self.auto_scaling = Some(input);
            self
        }
        /// <p>Describes the connector's auto scaling capacity.</p>
        pub fn set_auto_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScalingDescription>,
        ) -> Self {
            self.auto_scaling = input;
            self
        }
        /// <p>Describes a connector's provisioned capacity.</p>
        pub fn provisioned_capacity(
            mut self,
            input: crate::model::ProvisionedCapacityDescription,
        ) -> Self {
            self.provisioned_capacity = Some(input);
            self
        }
        /// <p>Describes a connector's provisioned capacity.</p>
        pub fn set_provisioned_capacity(
            mut self,
            input: std::option::Option<crate::model::ProvisionedCapacityDescription>,
        ) -> Self {
            self.provisioned_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityDescription`](crate::model::CapacityDescription)
        pub fn build(self) -> crate::model::CapacityDescription {
            crate::model::CapacityDescription {
                auto_scaling: self.auto_scaling,
                provisioned_capacity: self.provisioned_capacity,
            }
        }
    }
}
impl CapacityDescription {
    /// Creates a new builder-style object to manufacture [`CapacityDescription`](crate::model::CapacityDescription)
    pub fn builder() -> crate::model::capacity_description::Builder {
        crate::model::capacity_description::Builder::default()
    }
}

/// <p>The description of a connector's provisioned capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedCapacityDescription {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The number of workers that are allocated to the connector.</p>
    pub worker_count: i32,
}
impl ProvisionedCapacityDescription {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The number of workers that are allocated to the connector.</p>
    pub fn worker_count(&self) -> i32 {
        self.worker_count
    }
}
impl std::fmt::Debug for ProvisionedCapacityDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedCapacityDescription");
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("worker_count", &self.worker_count);
        formatter.finish()
    }
}
/// See [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
pub mod provisioned_capacity_description {
    /// A builder for [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) worker_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn worker_count(mut self, input: i32) -> Self {
            self.worker_count = Some(input);
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn set_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.worker_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
        pub fn build(self) -> crate::model::ProvisionedCapacityDescription {
            crate::model::ProvisionedCapacityDescription {
                mcu_count: self.mcu_count.unwrap_or_default(),
                worker_count: self.worker_count.unwrap_or_default(),
            }
        }
    }
}
impl ProvisionedCapacityDescription {
    /// Creates a new builder-style object to manufacture [`ProvisionedCapacityDescription`](crate::model::ProvisionedCapacityDescription)
    pub fn builder() -> crate::model::provisioned_capacity_description::Builder {
        crate::model::provisioned_capacity_description::Builder::default()
    }
}

/// <p>Information about the auto scaling parameters for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingDescription {
    /// <p>The maximum number of workers allocated to the connector.</p>
    pub max_worker_count: i32,
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The minimum number of workers allocated to the connector.</p>
    pub min_worker_count: i32,
    /// <p>The sacle-in policy for the connector.</p>
    pub scale_in_policy: std::option::Option<crate::model::ScaleInPolicyDescription>,
    /// <p>The sacle-out policy for the connector.&gt;</p>
    pub scale_out_policy: std::option::Option<crate::model::ScaleOutPolicyDescription>,
}
impl AutoScalingDescription {
    /// <p>The maximum number of workers allocated to the connector.</p>
    pub fn max_worker_count(&self) -> i32 {
        self.max_worker_count
    }
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The minimum number of workers allocated to the connector.</p>
    pub fn min_worker_count(&self) -> i32 {
        self.min_worker_count
    }
    /// <p>The sacle-in policy for the connector.</p>
    pub fn scale_in_policy(&self) -> std::option::Option<&crate::model::ScaleInPolicyDescription> {
        self.scale_in_policy.as_ref()
    }
    /// <p>The sacle-out policy for the connector.&gt;</p>
    pub fn scale_out_policy(
        &self,
    ) -> std::option::Option<&crate::model::ScaleOutPolicyDescription> {
        self.scale_out_policy.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingDescription");
        formatter.field("max_worker_count", &self.max_worker_count);
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("min_worker_count", &self.min_worker_count);
        formatter.field("scale_in_policy", &self.scale_in_policy);
        formatter.field("scale_out_policy", &self.scale_out_policy);
        formatter.finish()
    }
}
/// See [`AutoScalingDescription`](crate::model::AutoScalingDescription)
pub mod auto_scaling_description {
    /// A builder for [`AutoScalingDescription`](crate::model::AutoScalingDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_worker_count: std::option::Option<i32>,
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) min_worker_count: std::option::Option<i32>,
        pub(crate) scale_in_policy: std::option::Option<crate::model::ScaleInPolicyDescription>,
        pub(crate) scale_out_policy: std::option::Option<crate::model::ScaleOutPolicyDescription>,
    }
    impl Builder {
        /// <p>The maximum number of workers allocated to the connector.</p>
        pub fn max_worker_count(mut self, input: i32) -> Self {
            self.max_worker_count = Some(input);
            self
        }
        /// <p>The maximum number of workers allocated to the connector.</p>
        pub fn set_max_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_worker_count = input;
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The minimum number of workers allocated to the connector.</p>
        pub fn min_worker_count(mut self, input: i32) -> Self {
            self.min_worker_count = Some(input);
            self
        }
        /// <p>The minimum number of workers allocated to the connector.</p>
        pub fn set_min_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.min_worker_count = input;
            self
        }
        /// <p>The sacle-in policy for the connector.</p>
        pub fn scale_in_policy(mut self, input: crate::model::ScaleInPolicyDescription) -> Self {
            self.scale_in_policy = Some(input);
            self
        }
        /// <p>The sacle-in policy for the connector.</p>
        pub fn set_scale_in_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleInPolicyDescription>,
        ) -> Self {
            self.scale_in_policy = input;
            self
        }
        /// <p>The sacle-out policy for the connector.&gt;</p>
        pub fn scale_out_policy(mut self, input: crate::model::ScaleOutPolicyDescription) -> Self {
            self.scale_out_policy = Some(input);
            self
        }
        /// <p>The sacle-out policy for the connector.&gt;</p>
        pub fn set_scale_out_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleOutPolicyDescription>,
        ) -> Self {
            self.scale_out_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingDescription`](crate::model::AutoScalingDescription)
        pub fn build(self) -> crate::model::AutoScalingDescription {
            crate::model::AutoScalingDescription {
                max_worker_count: self.max_worker_count.unwrap_or_default(),
                mcu_count: self.mcu_count.unwrap_or_default(),
                min_worker_count: self.min_worker_count.unwrap_or_default(),
                scale_in_policy: self.scale_in_policy,
                scale_out_policy: self.scale_out_policy,
            }
        }
    }
}
impl AutoScalingDescription {
    /// Creates a new builder-style object to manufacture [`AutoScalingDescription`](crate::model::AutoScalingDescription)
    pub fn builder() -> crate::model::auto_scaling_description::Builder {
        crate::model::auto_scaling_description::Builder::default()
    }
}

/// <p>The description of the scale-out policy for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleOutPolicyDescription {
    /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleOutPolicyDescription {
    /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleOutPolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleOutPolicyDescription");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleOutPolicyDescription`](crate::model::ScaleOutPolicyDescription)
pub mod scale_out_policy_description {
    /// A builder for [`ScaleOutPolicyDescription`](crate::model::ScaleOutPolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleOutPolicyDescription`](crate::model::ScaleOutPolicyDescription)
        pub fn build(self) -> crate::model::ScaleOutPolicyDescription {
            crate::model::ScaleOutPolicyDescription {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleOutPolicyDescription {
    /// Creates a new builder-style object to manufacture [`ScaleOutPolicyDescription`](crate::model::ScaleOutPolicyDescription)
    pub fn builder() -> crate::model::scale_out_policy_description::Builder {
        crate::model::scale_out_policy_description::Builder::default()
    }
}

/// <p>The description of the scale-in policy for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleInPolicyDescription {
    /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleInPolicyDescription {
    /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleInPolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleInPolicyDescription");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleInPolicyDescription`](crate::model::ScaleInPolicyDescription)
pub mod scale_in_policy_description {
    /// A builder for [`ScaleInPolicyDescription`](crate::model::ScaleInPolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleInPolicyDescription`](crate::model::ScaleInPolicyDescription)
        pub fn build(self) -> crate::model::ScaleInPolicyDescription {
            crate::model::ScaleInPolicyDescription {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleInPolicyDescription {
    /// Creates a new builder-style object to manufacture [`ScaleInPolicyDescription`](crate::model::ScaleInPolicyDescription)
    pub fn builder() -> crate::model::scale_in_policy_description::Builder {
        crate::model::scale_in_policy_description::Builder::default()
    }
}

/// <p>The description of the worker configuration revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerConfigurationRevisionDescription {
    /// <p>The time that the worker configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the worker configuration revision.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Base64 encoded contents of the connect-distributed.properties file.</p>
    pub properties_file_content: std::option::Option<std::string::String>,
    /// <p>The description of a revision of the worker configuration.</p>
    pub revision: i64,
}
impl WorkerConfigurationRevisionDescription {
    /// <p>The time that the worker configuration was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of the worker configuration revision.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Base64 encoded contents of the connect-distributed.properties file.</p>
    pub fn properties_file_content(&self) -> std::option::Option<&str> {
        self.properties_file_content.as_deref()
    }
    /// <p>The description of a revision of the worker configuration.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
}
impl std::fmt::Debug for WorkerConfigurationRevisionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerConfigurationRevisionDescription");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field(
            "properties_file_content",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`WorkerConfigurationRevisionDescription`](crate::model::WorkerConfigurationRevisionDescription)
pub mod worker_configuration_revision_description {
    /// A builder for [`WorkerConfigurationRevisionDescription`](crate::model::WorkerConfigurationRevisionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) properties_file_content: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The time that the worker configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the worker configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the worker configuration revision.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the worker configuration revision.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Base64 encoded contents of the connect-distributed.properties file.</p>
        pub fn properties_file_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties_file_content = Some(input.into());
            self
        }
        /// <p>Base64 encoded contents of the connect-distributed.properties file.</p>
        pub fn set_properties_file_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.properties_file_content = input;
            self
        }
        /// <p>The description of a revision of the worker configuration.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The description of a revision of the worker configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerConfigurationRevisionDescription`](crate::model::WorkerConfigurationRevisionDescription)
        pub fn build(self) -> crate::model::WorkerConfigurationRevisionDescription {
            crate::model::WorkerConfigurationRevisionDescription {
                creation_time: self.creation_time,
                description: self.description,
                properties_file_content: self.properties_file_content,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl WorkerConfigurationRevisionDescription {
    /// Creates a new builder-style object to manufacture [`WorkerConfigurationRevisionDescription`](crate::model::WorkerConfigurationRevisionDescription)
    pub fn builder() -> crate::model::worker_configuration_revision_description::Builder {
        crate::model::worker_configuration_revision_description::Builder::default()
    }
}

/// <p>Details about the state of a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateDescription {
    /// <p>A code that describes the state of a resource.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message that describes the state of a resource.</p>
    pub message: std::option::Option<std::string::String>,
}
impl StateDescription {
    /// <p>A code that describes the state of a resource.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A message that describes the state of a resource.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for StateDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateDescription");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`StateDescription`](crate::model::StateDescription)
pub mod state_description {
    /// A builder for [`StateDescription`](crate::model::StateDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A code that describes the state of a resource.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A code that describes the state of a resource.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that describes the state of a resource.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that describes the state of a resource.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateDescription`](crate::model::StateDescription)
        pub fn build(self) -> crate::model::StateDescription {
            crate::model::StateDescription {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl StateDescription {
    /// Creates a new builder-style object to manufacture [`StateDescription`](crate::model::StateDescription)
    pub fn builder() -> crate::model::state_description::Builder {
        crate::model::state_description::Builder::default()
    }
}

/// <p>Information about the location of a custom plugin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPluginLocation {
    /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl CustomPluginLocation {
    /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for CustomPluginLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPluginLocation");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`CustomPluginLocation`](crate::model::CustomPluginLocation)
pub mod custom_plugin_location {
    /// A builder for [`CustomPluginLocation`](crate::model::CustomPluginLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPluginLocation`](crate::model::CustomPluginLocation)
        pub fn build(self) -> crate::model::CustomPluginLocation {
            crate::model::CustomPluginLocation {
                s3_location: self.s3_location,
            }
        }
    }
}
impl CustomPluginLocation {
    /// Creates a new builder-style object to manufacture [`CustomPluginLocation`](crate::model::CustomPluginLocation)
    pub fn builder() -> crate::model::custom_plugin_location::Builder {
        crate::model::custom_plugin_location::Builder::default()
    }
}

/// <p>The location of an object in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The file key for an object in an S3 bucket.</p>
    pub file_key: std::option::Option<std::string::String>,
    /// <p>The version of an object in an S3 bucket.</p>
    pub object_version: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The file key for an object in an S3 bucket.</p>
    pub fn file_key(&self) -> std::option::Option<&str> {
        self.file_key.as_deref()
    }
    /// <p>The version of an object in an S3 bucket.</p>
    pub fn object_version(&self) -> std::option::Option<&str> {
        self.object_version.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("file_key", &self.file_key);
        formatter.field("object_version", &self.object_version);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) file_key: std::option::Option<std::string::String>,
        pub(crate) object_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an S3 bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The file key for an object in an S3 bucket.</p>
        pub fn file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_key = Some(input.into());
            self
        }
        /// <p>The file key for an object in an S3 bucket.</p>
        pub fn set_file_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_key = input;
            self
        }
        /// <p>The version of an object in an S3 bucket.</p>
        pub fn object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_version = Some(input.into());
            self
        }
        /// <p>The version of an object in an S3 bucket.</p>
        pub fn set_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket_arn: self.bucket_arn,
                file_key: self.file_key,
                object_version: self.object_version,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>The configuration of the workers, which are the processes that run the connector logic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerConfiguration {
    /// <p>The revision of the worker configuration.</p>
    pub revision: i64,
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl WorkerConfiguration {
    /// <p>The revision of the worker configuration.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
    /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
    pub fn worker_configuration_arn(&self) -> std::option::Option<&str> {
        self.worker_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for WorkerConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerConfiguration");
        formatter.field("revision", &self.revision);
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}
/// See [`WorkerConfiguration`](crate::model::WorkerConfiguration)
pub mod worker_configuration {
    /// A builder for [`WorkerConfiguration`](crate::model::WorkerConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision: std::option::Option<i64>,
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The revision of the worker configuration.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the worker configuration.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerConfiguration`](crate::model::WorkerConfiguration)
        pub fn build(self) -> crate::model::WorkerConfiguration {
            crate::model::WorkerConfiguration {
                revision: self.revision.unwrap_or_default(),
                worker_configuration_arn: self.worker_configuration_arn,
            }
        }
    }
}
impl WorkerConfiguration {
    /// Creates a new builder-style object to manufacture [`WorkerConfiguration`](crate::model::WorkerConfiguration)
    pub fn builder() -> crate::model::worker_configuration::Builder {
        crate::model::worker_configuration::Builder::default()
    }
}

/// <p>A plugin is an AWS resource that contains the code that defines your connector logic. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Plugin {
    /// <p>Details about a custom plugin.</p>
    pub custom_plugin: std::option::Option<crate::model::CustomPlugin>,
}
impl Plugin {
    /// <p>Details about a custom plugin.</p>
    pub fn custom_plugin(&self) -> std::option::Option<&crate::model::CustomPlugin> {
        self.custom_plugin.as_ref()
    }
}
impl std::fmt::Debug for Plugin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Plugin");
        formatter.field("custom_plugin", &self.custom_plugin);
        formatter.finish()
    }
}
/// See [`Plugin`](crate::model::Plugin)
pub mod plugin {
    /// A builder for [`Plugin`](crate::model::Plugin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin: std::option::Option<crate::model::CustomPlugin>,
    }
    impl Builder {
        /// <p>Details about a custom plugin.</p>
        pub fn custom_plugin(mut self, input: crate::model::CustomPlugin) -> Self {
            self.custom_plugin = Some(input);
            self
        }
        /// <p>Details about a custom plugin.</p>
        pub fn set_custom_plugin(
            mut self,
            input: std::option::Option<crate::model::CustomPlugin>,
        ) -> Self {
            self.custom_plugin = input;
            self
        }
        /// Consumes the builder and constructs a [`Plugin`](crate::model::Plugin)
        pub fn build(self) -> crate::model::Plugin {
            crate::model::Plugin {
                custom_plugin: self.custom_plugin,
            }
        }
    }
}
impl Plugin {
    /// Creates a new builder-style object to manufacture [`Plugin`](crate::model::Plugin)
    pub fn builder() -> crate::model::plugin::Builder {
        crate::model::plugin::Builder::default()
    }
}

/// <p>A plugin is an AWS resource that contains the code that defines a connector's logic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPlugin {
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
    /// <p>The revision of the custom plugin.</p>
    pub revision: i64,
}
impl CustomPlugin {
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub fn custom_plugin_arn(&self) -> std::option::Option<&str> {
        self.custom_plugin_arn.as_deref()
    }
    /// <p>The revision of the custom plugin.</p>
    pub fn revision(&self) -> i64 {
        self.revision
    }
}
impl std::fmt::Debug for CustomPlugin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPlugin");
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`CustomPlugin`](crate::model::CustomPlugin)
pub mod custom_plugin {
    /// A builder for [`CustomPlugin`](crate::model::CustomPlugin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPlugin`](crate::model::CustomPlugin)
        pub fn build(self) -> crate::model::CustomPlugin {
            crate::model::CustomPlugin {
                custom_plugin_arn: self.custom_plugin_arn,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl CustomPlugin {
    /// Creates a new builder-style object to manufacture [`CustomPlugin`](crate::model::CustomPlugin)
    pub fn builder() -> crate::model::custom_plugin::Builder {
        crate::model::custom_plugin::Builder::default()
    }
}

/// <p>Details about log delivery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDelivery {
    /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
    pub worker_log_delivery: std::option::Option<crate::model::WorkerLogDelivery>,
}
impl LogDelivery {
    /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
    pub fn worker_log_delivery(&self) -> std::option::Option<&crate::model::WorkerLogDelivery> {
        self.worker_log_delivery.as_ref()
    }
}
impl std::fmt::Debug for LogDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDelivery");
        formatter.field("worker_log_delivery", &self.worker_log_delivery);
        formatter.finish()
    }
}
/// See [`LogDelivery`](crate::model::LogDelivery)
pub mod log_delivery {
    /// A builder for [`LogDelivery`](crate::model::LogDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_log_delivery: std::option::Option<crate::model::WorkerLogDelivery>,
    }
    impl Builder {
        /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
        pub fn worker_log_delivery(mut self, input: crate::model::WorkerLogDelivery) -> Self {
            self.worker_log_delivery = Some(input);
            self
        }
        /// <p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
        pub fn set_worker_log_delivery(
            mut self,
            input: std::option::Option<crate::model::WorkerLogDelivery>,
        ) -> Self {
            self.worker_log_delivery = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDelivery`](crate::model::LogDelivery)
        pub fn build(self) -> crate::model::LogDelivery {
            crate::model::LogDelivery {
                worker_log_delivery: self.worker_log_delivery,
            }
        }
    }
}
impl LogDelivery {
    /// Creates a new builder-style object to manufacture [`LogDelivery`](crate::model::LogDelivery)
    pub fn builder() -> crate::model::log_delivery::Builder {
        crate::model::log_delivery::Builder::default()
    }
}

/// <p>Workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkerLogDelivery {
    /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsLogDelivery>,
    /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
    pub firehose: std::option::Option<crate::model::FirehoseLogDelivery>,
    /// <p>Details about delivering logs to Amazon S3.</p>
    pub s3: std::option::Option<crate::model::S3LogDelivery>,
}
impl WorkerLogDelivery {
    /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
    pub fn cloud_watch_logs(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsLogDelivery> {
        self.cloud_watch_logs.as_ref()
    }
    /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
    pub fn firehose(&self) -> std::option::Option<&crate::model::FirehoseLogDelivery> {
        self.firehose.as_ref()
    }
    /// <p>Details about delivering logs to Amazon S3.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3LogDelivery> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for WorkerLogDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkerLogDelivery");
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.field("firehose", &self.firehose);
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`WorkerLogDelivery`](crate::model::WorkerLogDelivery)
pub mod worker_log_delivery {
    /// A builder for [`WorkerLogDelivery`](crate::model::WorkerLogDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsLogDelivery>,
        pub(crate) firehose: std::option::Option<crate::model::FirehoseLogDelivery>,
        pub(crate) s3: std::option::Option<crate::model::S3LogDelivery>,
    }
    impl Builder {
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn cloud_watch_logs(mut self, input: crate::model::CloudWatchLogsLogDelivery) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsLogDelivery>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
        pub fn firehose(mut self, input: crate::model::FirehoseLogDelivery) -> Self {
            self.firehose = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>
        pub fn set_firehose(
            mut self,
            input: std::option::Option<crate::model::FirehoseLogDelivery>,
        ) -> Self {
            self.firehose = input;
            self
        }
        /// <p>Details about delivering logs to Amazon S3.</p>
        pub fn s3(mut self, input: crate::model::S3LogDelivery) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon S3.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3LogDelivery>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkerLogDelivery`](crate::model::WorkerLogDelivery)
        pub fn build(self) -> crate::model::WorkerLogDelivery {
            crate::model::WorkerLogDelivery {
                cloud_watch_logs: self.cloud_watch_logs,
                firehose: self.firehose,
                s3: self.s3,
            }
        }
    }
}
impl WorkerLogDelivery {
    /// Creates a new builder-style object to manufacture [`WorkerLogDelivery`](crate::model::WorkerLogDelivery)
    pub fn builder() -> crate::model::worker_log_delivery::Builder {
        crate::model::worker_log_delivery::Builder::default()
    }
}

/// <p>Details about delivering logs to Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LogDelivery {
    /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
    pub enabled: bool,
    /// <p>The S3 prefix that is the destination for log delivery.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3LogDelivery {
    /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The S3 prefix that is the destination for log delivery.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3LogDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LogDelivery");
        formatter.field("bucket", &self.bucket);
        formatter.field("enabled", &self.enabled);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3LogDelivery`](crate::model::S3LogDelivery)
pub mod s3_log_delivery {
    /// A builder for [`S3LogDelivery`](crate::model::S3LogDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that is the destination for log delivery.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The S3 prefix that is the destination for log delivery.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The S3 prefix that is the destination for log delivery.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LogDelivery`](crate::model::S3LogDelivery)
        pub fn build(self) -> crate::model::S3LogDelivery {
            crate::model::S3LogDelivery {
                bucket: self.bucket,
                enabled: self.enabled.unwrap_or_default(),
                prefix: self.prefix,
            }
        }
    }
}
impl S3LogDelivery {
    /// Creates a new builder-style object to manufacture [`S3LogDelivery`](crate::model::S3LogDelivery)
    pub fn builder() -> crate::model::s3_log_delivery::Builder {
        crate::model::s3_log_delivery::Builder::default()
    }
}

/// <p>The settings for delivering logs to Amazon Kinesis Data Firehose.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirehoseLogDelivery {
    /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
    pub delivery_stream: std::option::Option<std::string::String>,
    /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
    pub enabled: bool,
}
impl FirehoseLogDelivery {
    /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
    pub fn delivery_stream(&self) -> std::option::Option<&str> {
        self.delivery_stream.as_deref()
    }
    /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for FirehoseLogDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirehoseLogDelivery");
        formatter.field("delivery_stream", &self.delivery_stream);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`FirehoseLogDelivery`](crate::model::FirehoseLogDelivery)
pub mod firehose_log_delivery {
    /// A builder for [`FirehoseLogDelivery`](crate::model::FirehoseLogDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
        pub fn delivery_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>
        pub fn set_delivery_stream(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream = input;
            self
        }
        /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`FirehoseLogDelivery`](crate::model::FirehoseLogDelivery)
        pub fn build(self) -> crate::model::FirehoseLogDelivery {
            crate::model::FirehoseLogDelivery {
                delivery_stream: self.delivery_stream,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl FirehoseLogDelivery {
    /// Creates a new builder-style object to manufacture [`FirehoseLogDelivery`](crate::model::FirehoseLogDelivery)
    pub fn builder() -> crate::model::firehose_log_delivery::Builder {
        crate::model::firehose_log_delivery::Builder::default()
    }
}

/// <p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsLogDelivery {
    /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
    pub enabled: bool,
    /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
    pub log_group: std::option::Option<std::string::String>,
}
impl CloudWatchLogsLogDelivery {
    /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
    pub fn log_group(&self) -> std::option::Option<&str> {
        self.log_group.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsLogDelivery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsLogDelivery");
        formatter.field("enabled", &self.enabled);
        formatter.field("log_group", &self.log_group);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsLogDelivery`](crate::model::CloudWatchLogsLogDelivery)
pub mod cloud_watch_logs_log_delivery {
    /// A builder for [`CloudWatchLogsLogDelivery`](crate::model::CloudWatchLogsLogDelivery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch log group that is the destination for log delivery.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsLogDelivery`](crate::model::CloudWatchLogsLogDelivery)
        pub fn build(self) -> crate::model::CloudWatchLogsLogDelivery {
            crate::model::CloudWatchLogsLogDelivery {
                enabled: self.enabled.unwrap_or_default(),
                log_group: self.log_group,
            }
        }
    }
}
impl CloudWatchLogsLogDelivery {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsLogDelivery`](crate::model::CloudWatchLogsLogDelivery)
    pub fn builder() -> crate::model::cloud_watch_logs_log_delivery::Builder {
        crate::model::cloud_watch_logs_log_delivery::Builder::default()
    }
}

/// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaClusterEncryptionInTransit {
    /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
    pub encryption_type: std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
}
impl KafkaClusterEncryptionInTransit {
    /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
    pub fn encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterEncryptionInTransitType> {
        self.encryption_type.as_ref()
    }
}
impl std::fmt::Debug for KafkaClusterEncryptionInTransit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaClusterEncryptionInTransit");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`KafkaClusterEncryptionInTransit`](crate::model::KafkaClusterEncryptionInTransit)
pub mod kafka_cluster_encryption_in_transit {
    /// A builder for [`KafkaClusterEncryptionInTransit`](crate::model::KafkaClusterEncryptionInTransit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type:
            std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
    }
    impl Builder {
        /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
        pub fn encryption_type(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransitType,
        ) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransitType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaClusterEncryptionInTransit`](crate::model::KafkaClusterEncryptionInTransit)
        pub fn build(self) -> crate::model::KafkaClusterEncryptionInTransit {
            crate::model::KafkaClusterEncryptionInTransit {
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl KafkaClusterEncryptionInTransit {
    /// Creates a new builder-style object to manufacture [`KafkaClusterEncryptionInTransit`](crate::model::KafkaClusterEncryptionInTransit)
    pub fn builder() -> crate::model::kafka_cluster_encryption_in_transit::Builder {
        crate::model::kafka_cluster_encryption_in_transit::Builder::default()
    }
}

/// <p>The client authentication information used in order to authenticate with the Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaClusterClientAuthentication {
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
    pub authentication_type:
        std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
}
impl KafkaClusterClientAuthentication {
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
    pub fn authentication_type(
        &self,
    ) -> std::option::Option<&crate::model::KafkaClusterClientAuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for KafkaClusterClientAuthentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaClusterClientAuthentication");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}
/// See [`KafkaClusterClientAuthentication`](crate::model::KafkaClusterClientAuthentication)
pub mod kafka_cluster_client_authentication {
    /// A builder for [`KafkaClusterClientAuthentication`](crate::model::KafkaClusterClientAuthentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_type:
            std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
    }
    impl Builder {
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
        pub fn authentication_type(
            mut self,
            input: crate::model::KafkaClusterClientAuthenticationType,
        ) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaClusterClientAuthentication`](crate::model::KafkaClusterClientAuthentication)
        pub fn build(self) -> crate::model::KafkaClusterClientAuthentication {
            crate::model::KafkaClusterClientAuthentication {
                authentication_type: self.authentication_type,
            }
        }
    }
}
impl KafkaClusterClientAuthentication {
    /// Creates a new builder-style object to manufacture [`KafkaClusterClientAuthentication`](crate::model::KafkaClusterClientAuthentication)
    pub fn builder() -> crate::model::kafka_cluster_client_authentication::Builder {
        crate::model::kafka_cluster_client_authentication::Builder::default()
    }
}

/// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaCluster {
    /// <p>The Apache Kafka cluster to which the connector is connected.</p>
    pub apache_kafka_cluster: std::option::Option<crate::model::ApacheKafkaCluster>,
}
impl KafkaCluster {
    /// <p>The Apache Kafka cluster to which the connector is connected.</p>
    pub fn apache_kafka_cluster(&self) -> std::option::Option<&crate::model::ApacheKafkaCluster> {
        self.apache_kafka_cluster.as_ref()
    }
}
impl std::fmt::Debug for KafkaCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaCluster");
        formatter.field("apache_kafka_cluster", &self.apache_kafka_cluster);
        formatter.finish()
    }
}
/// See [`KafkaCluster`](crate::model::KafkaCluster)
pub mod kafka_cluster {
    /// A builder for [`KafkaCluster`](crate::model::KafkaCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apache_kafka_cluster: std::option::Option<crate::model::ApacheKafkaCluster>,
    }
    impl Builder {
        /// <p>The Apache Kafka cluster to which the connector is connected.</p>
        pub fn apache_kafka_cluster(mut self, input: crate::model::ApacheKafkaCluster) -> Self {
            self.apache_kafka_cluster = Some(input);
            self
        }
        /// <p>The Apache Kafka cluster to which the connector is connected.</p>
        pub fn set_apache_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::ApacheKafkaCluster>,
        ) -> Self {
            self.apache_kafka_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaCluster`](crate::model::KafkaCluster)
        pub fn build(self) -> crate::model::KafkaCluster {
            crate::model::KafkaCluster {
                apache_kafka_cluster: self.apache_kafka_cluster,
            }
        }
    }
}
impl KafkaCluster {
    /// Creates a new builder-style object to manufacture [`KafkaCluster`](crate::model::KafkaCluster)
    pub fn builder() -> crate::model::kafka_cluster::Builder {
        crate::model::kafka_cluster::Builder::default()
    }
}

/// <p>The details of the Apache Kafka cluster to which the connector is connected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApacheKafkaCluster {
    /// <p>The bootstrap servers of the cluster.</p>
    pub bootstrap_servers: std::option::Option<std::string::String>,
    /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
}
impl ApacheKafkaCluster {
    /// <p>The bootstrap servers of the cluster.</p>
    pub fn bootstrap_servers(&self) -> std::option::Option<&str> {
        self.bootstrap_servers.as_deref()
    }
    /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for ApacheKafkaCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApacheKafkaCluster");
        formatter.field("bootstrap_servers", &self.bootstrap_servers);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`ApacheKafkaCluster`](crate::model::ApacheKafkaCluster)
pub mod apache_kafka_cluster {
    /// A builder for [`ApacheKafkaCluster`](crate::model::ApacheKafkaCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bootstrap_servers: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
    }
    impl Builder {
        /// <p>The bootstrap servers of the cluster.</p>
        pub fn bootstrap_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.bootstrap_servers = Some(input.into());
            self
        }
        /// <p>The bootstrap servers of the cluster.</p>
        pub fn set_bootstrap_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bootstrap_servers = input;
            self
        }
        /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`ApacheKafkaCluster`](crate::model::ApacheKafkaCluster)
        pub fn build(self) -> crate::model::ApacheKafkaCluster {
            crate::model::ApacheKafkaCluster {
                bootstrap_servers: self.bootstrap_servers,
                vpc: self.vpc,
            }
        }
    }
}
impl ApacheKafkaCluster {
    /// Creates a new builder-style object to manufacture [`ApacheKafkaCluster`](crate::model::ApacheKafkaCluster)
    pub fn builder() -> crate::model::apache_kafka_cluster::Builder {
        crate::model::apache_kafka_cluster::Builder::default()
    }
}

/// <p>Information about the VPC in which the connector resides.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Vpc {
    /// <p>The security groups for the connector.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnets for the connector.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Vpc {
    /// <p>The security groups for the connector.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The subnets for the connector.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for Vpc {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Vpc");
        formatter.field("security_groups", &self.security_groups);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`Vpc`](crate::model::Vpc)
pub mod vpc {
    /// A builder for [`Vpc`](crate::model::Vpc)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the connector.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the connector.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The subnets for the connector.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The subnets for the connector.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`Vpc`](crate::model::Vpc)
        pub fn build(self) -> crate::model::Vpc {
            crate::model::Vpc {
                security_groups: self.security_groups,
                subnets: self.subnets,
            }
        }
    }
}
impl Vpc {
    /// Creates a new builder-style object to manufacture [`Vpc`](crate::model::Vpc)
    pub fn builder() -> crate::model::vpc::Builder {
        crate::model::vpc::Builder::default()
    }
}

/// <p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Capacity {
    /// <p>Information about the auto scaling parameters for the connector.</p>
    pub auto_scaling: std::option::Option<crate::model::AutoScaling>,
    /// <p>Details about a fixed capacity allocated to a connector.</p>
    pub provisioned_capacity: std::option::Option<crate::model::ProvisionedCapacity>,
}
impl Capacity {
    /// <p>Information about the auto scaling parameters for the connector.</p>
    pub fn auto_scaling(&self) -> std::option::Option<&crate::model::AutoScaling> {
        self.auto_scaling.as_ref()
    }
    /// <p>Details about a fixed capacity allocated to a connector.</p>
    pub fn provisioned_capacity(&self) -> std::option::Option<&crate::model::ProvisionedCapacity> {
        self.provisioned_capacity.as_ref()
    }
}
impl std::fmt::Debug for Capacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Capacity");
        formatter.field("auto_scaling", &self.auto_scaling);
        formatter.field("provisioned_capacity", &self.provisioned_capacity);
        formatter.finish()
    }
}
/// See [`Capacity`](crate::model::Capacity)
pub mod capacity {
    /// A builder for [`Capacity`](crate::model::Capacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling: std::option::Option<crate::model::AutoScaling>,
        pub(crate) provisioned_capacity: std::option::Option<crate::model::ProvisionedCapacity>,
    }
    impl Builder {
        /// <p>Information about the auto scaling parameters for the connector.</p>
        pub fn auto_scaling(mut self, input: crate::model::AutoScaling) -> Self {
            self.auto_scaling = Some(input);
            self
        }
        /// <p>Information about the auto scaling parameters for the connector.</p>
        pub fn set_auto_scaling(
            mut self,
            input: std::option::Option<crate::model::AutoScaling>,
        ) -> Self {
            self.auto_scaling = input;
            self
        }
        /// <p>Details about a fixed capacity allocated to a connector.</p>
        pub fn provisioned_capacity(mut self, input: crate::model::ProvisionedCapacity) -> Self {
            self.provisioned_capacity = Some(input);
            self
        }
        /// <p>Details about a fixed capacity allocated to a connector.</p>
        pub fn set_provisioned_capacity(
            mut self,
            input: std::option::Option<crate::model::ProvisionedCapacity>,
        ) -> Self {
            self.provisioned_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`Capacity`](crate::model::Capacity)
        pub fn build(self) -> crate::model::Capacity {
            crate::model::Capacity {
                auto_scaling: self.auto_scaling,
                provisioned_capacity: self.provisioned_capacity,
            }
        }
    }
}
impl Capacity {
    /// Creates a new builder-style object to manufacture [`Capacity`](crate::model::Capacity)
    pub fn builder() -> crate::model::capacity::Builder {
        crate::model::capacity::Builder::default()
    }
}

/// <p>Details about a connector's provisioned capacity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedCapacity {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The number of workers that are allocated to the connector.</p>
    pub worker_count: i32,
}
impl ProvisionedCapacity {
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The number of workers that are allocated to the connector.</p>
    pub fn worker_count(&self) -> i32 {
        self.worker_count
    }
}
impl std::fmt::Debug for ProvisionedCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedCapacity");
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("worker_count", &self.worker_count);
        formatter.finish()
    }
}
/// See [`ProvisionedCapacity`](crate::model::ProvisionedCapacity)
pub mod provisioned_capacity {
    /// A builder for [`ProvisionedCapacity`](crate::model::ProvisionedCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) worker_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn worker_count(mut self, input: i32) -> Self {
            self.worker_count = Some(input);
            self
        }
        /// <p>The number of workers that are allocated to the connector.</p>
        pub fn set_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.worker_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedCapacity`](crate::model::ProvisionedCapacity)
        pub fn build(self) -> crate::model::ProvisionedCapacity {
            crate::model::ProvisionedCapacity {
                mcu_count: self.mcu_count.unwrap_or_default(),
                worker_count: self.worker_count.unwrap_or_default(),
            }
        }
    }
}
impl ProvisionedCapacity {
    /// Creates a new builder-style object to manufacture [`ProvisionedCapacity`](crate::model::ProvisionedCapacity)
    pub fn builder() -> crate::model::provisioned_capacity::Builder {
        crate::model::provisioned_capacity::Builder::default()
    }
}

/// <p>Specifies how the connector scales.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScaling {
    /// <p>The maximum number of workers allocated to the connector.</p>
    pub max_worker_count: i32,
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub mcu_count: i32,
    /// <p>The minimum number of workers allocated to the connector.</p>
    pub min_worker_count: i32,
    /// <p>The sacle-in policy for the connector.</p>
    pub scale_in_policy: std::option::Option<crate::model::ScaleInPolicy>,
    /// <p>The sacle-out policy for the connector.</p>
    pub scale_out_policy: std::option::Option<crate::model::ScaleOutPolicy>,
}
impl AutoScaling {
    /// <p>The maximum number of workers allocated to the connector.</p>
    pub fn max_worker_count(&self) -> i32 {
        self.max_worker_count
    }
    /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
    pub fn mcu_count(&self) -> i32 {
        self.mcu_count
    }
    /// <p>The minimum number of workers allocated to the connector.</p>
    pub fn min_worker_count(&self) -> i32 {
        self.min_worker_count
    }
    /// <p>The sacle-in policy for the connector.</p>
    pub fn scale_in_policy(&self) -> std::option::Option<&crate::model::ScaleInPolicy> {
        self.scale_in_policy.as_ref()
    }
    /// <p>The sacle-out policy for the connector.</p>
    pub fn scale_out_policy(&self) -> std::option::Option<&crate::model::ScaleOutPolicy> {
        self.scale_out_policy.as_ref()
    }
}
impl std::fmt::Debug for AutoScaling {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScaling");
        formatter.field("max_worker_count", &self.max_worker_count);
        formatter.field("mcu_count", &self.mcu_count);
        formatter.field("min_worker_count", &self.min_worker_count);
        formatter.field("scale_in_policy", &self.scale_in_policy);
        formatter.field("scale_out_policy", &self.scale_out_policy);
        formatter.finish()
    }
}
/// See [`AutoScaling`](crate::model::AutoScaling)
pub mod auto_scaling {
    /// A builder for [`AutoScaling`](crate::model::AutoScaling)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_worker_count: std::option::Option<i32>,
        pub(crate) mcu_count: std::option::Option<i32>,
        pub(crate) min_worker_count: std::option::Option<i32>,
        pub(crate) scale_in_policy: std::option::Option<crate::model::ScaleInPolicy>,
        pub(crate) scale_out_policy: std::option::Option<crate::model::ScaleOutPolicy>,
    }
    impl Builder {
        /// <p>The maximum number of workers allocated to the connector.</p>
        pub fn max_worker_count(mut self, input: i32) -> Self {
            self.max_worker_count = Some(input);
            self
        }
        /// <p>The maximum number of workers allocated to the connector.</p>
        pub fn set_max_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_worker_count = input;
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn mcu_count(mut self, input: i32) -> Self {
            self.mcu_count = Some(input);
            self
        }
        /// <p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>
        pub fn set_mcu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.mcu_count = input;
            self
        }
        /// <p>The minimum number of workers allocated to the connector.</p>
        pub fn min_worker_count(mut self, input: i32) -> Self {
            self.min_worker_count = Some(input);
            self
        }
        /// <p>The minimum number of workers allocated to the connector.</p>
        pub fn set_min_worker_count(mut self, input: std::option::Option<i32>) -> Self {
            self.min_worker_count = input;
            self
        }
        /// <p>The sacle-in policy for the connector.</p>
        pub fn scale_in_policy(mut self, input: crate::model::ScaleInPolicy) -> Self {
            self.scale_in_policy = Some(input);
            self
        }
        /// <p>The sacle-in policy for the connector.</p>
        pub fn set_scale_in_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleInPolicy>,
        ) -> Self {
            self.scale_in_policy = input;
            self
        }
        /// <p>The sacle-out policy for the connector.</p>
        pub fn scale_out_policy(mut self, input: crate::model::ScaleOutPolicy) -> Self {
            self.scale_out_policy = Some(input);
            self
        }
        /// <p>The sacle-out policy for the connector.</p>
        pub fn set_scale_out_policy(
            mut self,
            input: std::option::Option<crate::model::ScaleOutPolicy>,
        ) -> Self {
            self.scale_out_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScaling`](crate::model::AutoScaling)
        pub fn build(self) -> crate::model::AutoScaling {
            crate::model::AutoScaling {
                max_worker_count: self.max_worker_count.unwrap_or_default(),
                mcu_count: self.mcu_count.unwrap_or_default(),
                min_worker_count: self.min_worker_count.unwrap_or_default(),
                scale_in_policy: self.scale_in_policy,
                scale_out_policy: self.scale_out_policy,
            }
        }
    }
}
impl AutoScaling {
    /// Creates a new builder-style object to manufacture [`AutoScaling`](crate::model::AutoScaling)
    pub fn builder() -> crate::model::auto_scaling::Builder {
        crate::model::auto_scaling::Builder::default()
    }
}

/// <p>The scale-out policy for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleOutPolicy {
    /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleOutPolicy {
    /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleOutPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleOutPolicy");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleOutPolicy`](crate::model::ScaleOutPolicy)
pub mod scale_out_policy {
    /// A builder for [`ScaleOutPolicy`](crate::model::ScaleOutPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleOutPolicy`](crate::model::ScaleOutPolicy)
        pub fn build(self) -> crate::model::ScaleOutPolicy {
            crate::model::ScaleOutPolicy {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleOutPolicy {
    /// Creates a new builder-style object to manufacture [`ScaleOutPolicy`](crate::model::ScaleOutPolicy)
    pub fn builder() -> crate::model::scale_out_policy::Builder {
        crate::model::scale_out_policy::Builder::default()
    }
}

/// <p>The scale-in policy for the connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScaleInPolicy {
    /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub cpu_utilization_percentage: i32,
}
impl ScaleInPolicy {
    /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
    pub fn cpu_utilization_percentage(&self) -> i32 {
        self.cpu_utilization_percentage
    }
}
impl std::fmt::Debug for ScaleInPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScaleInPolicy");
        formatter.field(
            "cpu_utilization_percentage",
            &self.cpu_utilization_percentage,
        );
        formatter.finish()
    }
}
/// See [`ScaleInPolicy`](crate::model::ScaleInPolicy)
pub mod scale_in_policy {
    /// A builder for [`ScaleInPolicy`](crate::model::ScaleInPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_utilization_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn cpu_utilization_percentage(mut self, input: i32) -> Self {
            self.cpu_utilization_percentage = Some(input);
            self
        }
        /// <p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>
        pub fn set_cpu_utilization_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`ScaleInPolicy`](crate::model::ScaleInPolicy)
        pub fn build(self) -> crate::model::ScaleInPolicy {
            crate::model::ScaleInPolicy {
                cpu_utilization_percentage: self.cpu_utilization_percentage.unwrap_or_default(),
            }
        }
    }
}
impl ScaleInPolicy {
    /// Creates a new builder-style object to manufacture [`ScaleInPolicy`](crate::model::ScaleInPolicy)
    pub fn builder() -> crate::model::scale_in_policy::Builder {
        crate::model::scale_in_policy::Builder::default()
    }
}
