// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectorOutput {
    /// <p>The Amazon Resource Name (ARN) of the connector.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connector.</p>
    pub connector_state: std::option::Option<crate::model::ConnectorState>,
}
impl std::fmt::Debug for UpdateConnectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectorOutput");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_state", &self.connector_state);
        formatter.finish()
    }
}
/// See [`UpdateConnectorOutput`](crate::output::UpdateConnectorOutput)
pub mod update_connector_output {
    /// A builder for [`UpdateConnectorOutput`](crate::output::UpdateConnectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_state: std::option::Option<crate::model::ConnectorState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The state of the connector.</p>
        pub fn connector_state(mut self, input: crate::model::ConnectorState) -> Self {
            self.connector_state = Some(input);
            self
        }
        /// <p>The state of the connector.</p>
        pub fn set_connector_state(
            mut self,
            input: std::option::Option<crate::model::ConnectorState>,
        ) -> Self {
            self.connector_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectorOutput`](crate::output::UpdateConnectorOutput)
        pub fn build(self) -> crate::output::UpdateConnectorOutput {
            crate::output::UpdateConnectorOutput {
                connector_arn: self.connector_arn,
                connector_state: self.connector_state,
            }
        }
    }
}
impl UpdateConnectorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectorOutput`](crate::output::UpdateConnectorOutput)
    pub fn builder() -> crate::output::update_connector_output::Builder {
        crate::output::update_connector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkerConfigurationsOutput {
    /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of worker configuration descriptions.</p>
    pub worker_configurations:
        std::option::Option<std::vec::Vec<crate::model::WorkerConfigurationSummary>>,
}
impl std::fmt::Debug for ListWorkerConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkerConfigurationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("worker_configurations", &self.worker_configurations);
        formatter.finish()
    }
}
/// See [`ListWorkerConfigurationsOutput`](crate::output::ListWorkerConfigurationsOutput)
pub mod list_worker_configurations_output {
    /// A builder for [`ListWorkerConfigurationsOutput`](crate::output::ListWorkerConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) worker_configurations:
            std::option::Option<std::vec::Vec<crate::model::WorkerConfigurationSummary>>,
    }
    impl Builder {
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `worker_configurations`.
        ///
        /// To override the contents of this collection use [`set_worker_configurations`](Self::set_worker_configurations).
        ///
        /// <p>An array of worker configuration descriptions.</p>
        pub fn worker_configurations(
            mut self,
            input: impl Into<crate::model::WorkerConfigurationSummary>,
        ) -> Self {
            let mut v = self.worker_configurations.unwrap_or_default();
            v.push(input.into());
            self.worker_configurations = Some(v);
            self
        }
        /// <p>An array of worker configuration descriptions.</p>
        pub fn set_worker_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkerConfigurationSummary>>,
        ) -> Self {
            self.worker_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkerConfigurationsOutput`](crate::output::ListWorkerConfigurationsOutput)
        pub fn build(self) -> crate::output::ListWorkerConfigurationsOutput {
            crate::output::ListWorkerConfigurationsOutput {
                next_token: self.next_token,
                worker_configurations: self.worker_configurations,
            }
        }
    }
}
impl ListWorkerConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkerConfigurationsOutput`](crate::output::ListWorkerConfigurationsOutput)
    pub fn builder() -> crate::output::list_worker_configurations_output::Builder {
        crate::output::list_worker_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomPluginsOutput {
    /// <p>An array of custom plugin descriptions.</p>
    pub custom_plugins: std::option::Option<std::vec::Vec<crate::model::CustomPluginSummary>>,
    /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCustomPluginsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomPluginsOutput");
        formatter.field("custom_plugins", &self.custom_plugins);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCustomPluginsOutput`](crate::output::ListCustomPluginsOutput)
pub mod list_custom_plugins_output {
    /// A builder for [`ListCustomPluginsOutput`](crate::output::ListCustomPluginsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugins:
            std::option::Option<std::vec::Vec<crate::model::CustomPluginSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `custom_plugins`.
        ///
        /// To override the contents of this collection use [`set_custom_plugins`](Self::set_custom_plugins).
        ///
        /// <p>An array of custom plugin descriptions.</p>
        pub fn custom_plugins(
            mut self,
            input: impl Into<crate::model::CustomPluginSummary>,
        ) -> Self {
            let mut v = self.custom_plugins.unwrap_or_default();
            v.push(input.into());
            self.custom_plugins = Some(v);
            self
        }
        /// <p>An array of custom plugin descriptions.</p>
        pub fn set_custom_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomPluginSummary>>,
        ) -> Self {
            self.custom_plugins = input;
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomPluginsOutput`](crate::output::ListCustomPluginsOutput)
        pub fn build(self) -> crate::output::ListCustomPluginsOutput {
            crate::output::ListCustomPluginsOutput {
                custom_plugins: self.custom_plugins,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCustomPluginsOutput {
    /// Creates a new builder-style object to manufacture [`ListCustomPluginsOutput`](crate::output::ListCustomPluginsOutput)
    pub fn builder() -> crate::output::list_custom_plugins_output::Builder {
        crate::output::list_custom_plugins_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorsOutput {
    /// <p>An array of connector descriptions.</p>
    pub connectors: std::option::Option<std::vec::Vec<crate::model::ConnectorSummary>>,
    /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where it left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConnectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorsOutput");
        formatter.field("connectors", &self.connectors);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConnectorsOutput`](crate::output::ListConnectorsOutput)
pub mod list_connectors_output {
    /// A builder for [`ListConnectorsOutput`](crate::output::ListConnectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connectors: std::option::Option<std::vec::Vec<crate::model::ConnectorSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connectors`.
        ///
        /// To override the contents of this collection use [`set_connectors`](Self::set_connectors).
        ///
        /// <p>An array of connector descriptions.</p>
        pub fn connectors(mut self, input: impl Into<crate::model::ConnectorSummary>) -> Self {
            let mut v = self.connectors.unwrap_or_default();
            v.push(input.into());
            self.connectors = Some(v);
            self
        }
        /// <p>An array of connector descriptions.</p>
        pub fn set_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorSummary>>,
        ) -> Self {
            self.connectors = input;
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where it left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where it left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorsOutput`](crate::output::ListConnectorsOutput)
        pub fn build(self) -> crate::output::ListConnectorsOutput {
            crate::output::ListConnectorsOutput {
                connectors: self.connectors,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConnectorsOutput {
    /// Creates a new builder-style object to manufacture [`ListConnectorsOutput`](crate::output::ListConnectorsOutput)
    pub fn builder() -> crate::output::list_connectors_output::Builder {
        crate::output::list_connectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkerConfigurationOutput {
    /// <p>The time that the worker configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the worker configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The latest revision of the custom configuration.</p>
    pub latest_revision: std::option::Option<crate::model::WorkerConfigurationRevisionDescription>,
    /// <p>The name of the worker configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the custom configuration.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeWorkerConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkerConfigurationOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}
/// See [`DescribeWorkerConfigurationOutput`](crate::output::DescribeWorkerConfigurationOutput)
pub mod describe_worker_configuration_output {
    /// A builder for [`DescribeWorkerConfigurationOutput`](crate::output::DescribeWorkerConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) latest_revision:
            std::option::Option<crate::model::WorkerConfigurationRevisionDescription>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that the worker configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the worker configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the worker configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the worker configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The latest revision of the custom configuration.</p>
        pub fn latest_revision(
            mut self,
            input: crate::model::WorkerConfigurationRevisionDescription,
        ) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of the custom configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::WorkerConfigurationRevisionDescription>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom configuration.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom configuration.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkerConfigurationOutput`](crate::output::DescribeWorkerConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeWorkerConfigurationOutput {
            crate::output::DescribeWorkerConfigurationOutput {
                creation_time: self.creation_time,
                description: self.description,
                latest_revision: self.latest_revision,
                name: self.name,
                worker_configuration_arn: self.worker_configuration_arn,
            }
        }
    }
}
impl DescribeWorkerConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkerConfigurationOutput`](crate::output::DescribeWorkerConfigurationOutput)
    pub fn builder() -> crate::output::describe_worker_configuration_output::Builder {
        crate::output::describe_worker_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomPluginOutput {
    /// <p>The time that the custom plugin was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
    /// <p>The state of the custom plugin.</p>
    pub custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
    /// <p>The description of the custom plugin.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The latest successfully created revision of the custom plugin. If there are no successfully created revisions, this field will be absent.</p>
    pub latest_revision: std::option::Option<crate::model::CustomPluginRevisionSummary>,
    /// <p>The name of the custom plugin.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCustomPluginOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomPluginOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.field("custom_plugin_state", &self.custom_plugin_state);
        formatter.field("description", &self.description);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DescribeCustomPluginOutput`](crate::output::DescribeCustomPluginOutput)
pub mod describe_custom_plugin_output {
    /// A builder for [`DescribeCustomPluginOutput`](crate::output::DescribeCustomPluginOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
        pub(crate) custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) latest_revision: std::option::Option<crate::model::CustomPluginRevisionSummary>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that the custom plugin was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the custom plugin was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn custom_plugin_state(mut self, input: crate::model::CustomPluginState) -> Self {
            self.custom_plugin_state = Some(input);
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn set_custom_plugin_state(
            mut self,
            input: std::option::Option<crate::model::CustomPluginState>,
        ) -> Self {
            self.custom_plugin_state = input;
            self
        }
        /// <p>The description of the custom plugin.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the custom plugin.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The latest successfully created revision of the custom plugin. If there are no successfully created revisions, this field will be absent.</p>
        pub fn latest_revision(mut self, input: crate::model::CustomPluginRevisionSummary) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest successfully created revision of the custom plugin. If there are no successfully created revisions, this field will be absent.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::CustomPluginRevisionSummary>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomPluginOutput`](crate::output::DescribeCustomPluginOutput)
        pub fn build(self) -> crate::output::DescribeCustomPluginOutput {
            crate::output::DescribeCustomPluginOutput {
                creation_time: self.creation_time,
                custom_plugin_arn: self.custom_plugin_arn,
                custom_plugin_state: self.custom_plugin_state,
                description: self.description,
                latest_revision: self.latest_revision,
                name: self.name,
            }
        }
    }
}
impl DescribeCustomPluginOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomPluginOutput`](crate::output::DescribeCustomPluginOutput)
    pub fn builder() -> crate::output::describe_custom_plugin_output::Builder {
        crate::output::describe_custom_plugin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorOutput {
    /// <p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>
    pub capacity: std::option::Option<crate::model::CapacityDescription>,
    /// <p>The Amazon Resource Name (ARN) of the connector.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>A map of keys to values that represent the configuration for the connector.</p>
    pub connector_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A summary description of the connector.</p>
    pub connector_description: std::option::Option<std::string::String>,
    /// <p>The name of the connector.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>The state of the connector.</p>
    pub connector_state: std::option::Option<crate::model::ConnectorState>,
    /// <p>The time the connector was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current version of the connector.</p>
    pub current_version: std::option::Option<std::string::String>,
    /// <p>The Apache Kafka cluster that the connector is connected to.</p>
    pub kafka_cluster: std::option::Option<crate::model::KafkaClusterDescription>,
    /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
    pub kafka_cluster_client_authentication:
        std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
    /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
    pub kafka_cluster_encryption_in_transit:
        std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
    /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
    pub kafka_connect_version: std::option::Option<std::string::String>,
    /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
    pub log_delivery: std::option::Option<crate::model::LogDeliveryDescription>,
    /// <p>Specifies which plugins were used for this connector.</p>
    pub plugins: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
    pub service_execution_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies which worker configuration was used for the connector.</p>
    pub worker_configuration: std::option::Option<crate::model::WorkerConfigurationDescription>,
}
impl std::fmt::Debug for DescribeConnectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorOutput");
        formatter.field("capacity", &self.capacity);
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_configuration", &self.connector_configuration);
        formatter.field("connector_description", &self.connector_description);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("connector_state", &self.connector_state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("current_version", &self.current_version);
        formatter.field("kafka_cluster", &self.kafka_cluster);
        formatter.field(
            "kafka_cluster_client_authentication",
            &self.kafka_cluster_client_authentication,
        );
        formatter.field(
            "kafka_cluster_encryption_in_transit",
            &self.kafka_cluster_encryption_in_transit,
        );
        formatter.field("kafka_connect_version", &self.kafka_connect_version);
        formatter.field("log_delivery", &self.log_delivery);
        formatter.field("plugins", &self.plugins);
        formatter.field(
            "service_execution_role_arn",
            &self.service_execution_role_arn,
        );
        formatter.field("worker_configuration", &self.worker_configuration);
        formatter.finish()
    }
}
/// See [`DescribeConnectorOutput`](crate::output::DescribeConnectorOutput)
pub mod describe_connector_output {
    /// A builder for [`DescribeConnectorOutput`](crate::output::DescribeConnectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<crate::model::CapacityDescription>,
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) connector_description: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) connector_state: std::option::Option<crate::model::ConnectorState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) current_version: std::option::Option<std::string::String>,
        pub(crate) kafka_cluster: std::option::Option<crate::model::KafkaClusterDescription>,
        pub(crate) kafka_cluster_client_authentication:
            std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
        pub(crate) kafka_cluster_encryption_in_transit:
            std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
        pub(crate) kafka_connect_version: std::option::Option<std::string::String>,
        pub(crate) log_delivery: std::option::Option<crate::model::LogDeliveryDescription>,
        pub(crate) plugins: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
        pub(crate) service_execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) worker_configuration:
            std::option::Option<crate::model::WorkerConfigurationDescription>,
    }
    impl Builder {
        /// <p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>
        pub fn capacity(mut self, input: crate::model::CapacityDescription) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>
        pub fn set_capacity(
            mut self,
            input: std::option::Option<crate::model::CapacityDescription>,
        ) -> Self {
            self.capacity = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// Adds a key-value pair to `connector_configuration`.
        ///
        /// To override the contents of this collection use [`set_connector_configuration`](Self::set_connector_configuration).
        ///
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn connector_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.connector_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connector_configuration = Some(hash_map);
            self
        }
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn set_connector_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.connector_configuration = input;
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_description = Some(input.into());
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_description = input;
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>The state of the connector.</p>
        pub fn connector_state(mut self, input: crate::model::ConnectorState) -> Self {
            self.connector_state = Some(input);
            self
        }
        /// <p>The state of the connector.</p>
        pub fn set_connector_state(
            mut self,
            input: std::option::Option<crate::model::ConnectorState>,
        ) -> Self {
            self.connector_state = input;
            self
        }
        /// <p>The time the connector was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the connector was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The current version of the connector.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the connector.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The Apache Kafka cluster that the connector is connected to.</p>
        pub fn kafka_cluster(mut self, input: crate::model::KafkaClusterDescription) -> Self {
            self.kafka_cluster = Some(input);
            self
        }
        /// <p>The Apache Kafka cluster that the connector is connected to.</p>
        pub fn set_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterDescription>,
        ) -> Self {
            self.kafka_cluster = input;
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
        pub fn kafka_cluster_client_authentication(
            mut self,
            input: crate::model::KafkaClusterClientAuthenticationDescription,
        ) -> Self {
            self.kafka_cluster_client_authentication = Some(input);
            self
        }
        /// <p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>
        pub fn set_kafka_cluster_client_authentication(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthenticationDescription>,
        ) -> Self {
            self.kafka_cluster_client_authentication = input;
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn kafka_cluster_encryption_in_transit(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransitDescription,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = Some(input);
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_encryption_in_transit(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransitDescription>,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = input;
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn kafka_connect_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.kafka_connect_version = Some(input.into());
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn set_kafka_connect_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kafka_connect_version = input;
            self
        }
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn log_delivery(mut self, input: crate::model::LogDeliveryDescription) -> Self {
            self.log_delivery = Some(input);
            self
        }
        /// <p>Details about delivering logs to Amazon CloudWatch Logs.</p>
        pub fn set_log_delivery(
            mut self,
            input: std::option::Option<crate::model::LogDeliveryDescription>,
        ) -> Self {
            self.log_delivery = input;
            self
        }
        /// Appends an item to `plugins`.
        ///
        /// To override the contents of this collection use [`set_plugins`](Self::set_plugins).
        ///
        /// <p>Specifies which plugins were used for this connector.</p>
        pub fn plugins(mut self, input: impl Into<crate::model::PluginDescription>) -> Self {
            let mut v = self.plugins.unwrap_or_default();
            v.push(input.into());
            self.plugins = Some(v);
            self
        }
        /// <p>Specifies which plugins were used for this connector.</p>
        pub fn set_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PluginDescription>>,
        ) -> Self {
            self.plugins = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
        pub fn service_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>
        pub fn set_service_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_execution_role_arn = input;
            self
        }
        /// <p>Specifies which worker configuration was used for the connector.</p>
        pub fn worker_configuration(
            mut self,
            input: crate::model::WorkerConfigurationDescription,
        ) -> Self {
            self.worker_configuration = Some(input);
            self
        }
        /// <p>Specifies which worker configuration was used for the connector.</p>
        pub fn set_worker_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkerConfigurationDescription>,
        ) -> Self {
            self.worker_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorOutput`](crate::output::DescribeConnectorOutput)
        pub fn build(self) -> crate::output::DescribeConnectorOutput {
            crate::output::DescribeConnectorOutput {
                capacity: self.capacity,
                connector_arn: self.connector_arn,
                connector_configuration: self.connector_configuration,
                connector_description: self.connector_description,
                connector_name: self.connector_name,
                connector_state: self.connector_state,
                creation_time: self.creation_time,
                current_version: self.current_version,
                kafka_cluster: self.kafka_cluster,
                kafka_cluster_client_authentication: self.kafka_cluster_client_authentication,
                kafka_cluster_encryption_in_transit: self.kafka_cluster_encryption_in_transit,
                kafka_connect_version: self.kafka_connect_version,
                log_delivery: self.log_delivery,
                plugins: self.plugins,
                service_execution_role_arn: self.service_execution_role_arn,
                worker_configuration: self.worker_configuration,
            }
        }
    }
}
impl DescribeConnectorOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConnectorOutput`](crate::output::DescribeConnectorOutput)
    pub fn builder() -> crate::output::describe_connector_output::Builder {
        crate::output::describe_connector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectorOutput {
    /// <p>The Amazon Resource Name (ARN) of the connector that you requested to delete.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The state of the connector that you requested to delete.</p>
    pub connector_state: std::option::Option<crate::model::ConnectorState>,
}
impl std::fmt::Debug for DeleteConnectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectorOutput");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_state", &self.connector_state);
        formatter.finish()
    }
}
/// See [`DeleteConnectorOutput`](crate::output::DeleteConnectorOutput)
pub mod delete_connector_output {
    /// A builder for [`DeleteConnectorOutput`](crate::output::DeleteConnectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_state: std::option::Option<crate::model::ConnectorState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the connector that you requested to delete.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you requested to delete.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The state of the connector that you requested to delete.</p>
        pub fn connector_state(mut self, input: crate::model::ConnectorState) -> Self {
            self.connector_state = Some(input);
            self
        }
        /// <p>The state of the connector that you requested to delete.</p>
        pub fn set_connector_state(
            mut self,
            input: std::option::Option<crate::model::ConnectorState>,
        ) -> Self {
            self.connector_state = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectorOutput`](crate::output::DeleteConnectorOutput)
        pub fn build(self) -> crate::output::DeleteConnectorOutput {
            crate::output::DeleteConnectorOutput {
                connector_arn: self.connector_arn,
                connector_state: self.connector_state,
            }
        }
    }
}
impl DeleteConnectorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectorOutput`](crate::output::DeleteConnectorOutput)
    pub fn builder() -> crate::output::delete_connector_output::Builder {
        crate::output::delete_connector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkerConfigurationOutput {
    /// <p>The time that the worker configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The latest revision of the worker configuration.</p>
    pub latest_revision: std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
    /// <p>The name of the worker configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateWorkerConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkerConfigurationOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("latest_revision", &self.latest_revision);
        formatter.field("name", &self.name);
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}
/// See [`CreateWorkerConfigurationOutput`](crate::output::CreateWorkerConfigurationOutput)
pub mod create_worker_configuration_output {
    /// A builder for [`CreateWorkerConfigurationOutput`](crate::output::CreateWorkerConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_revision:
            std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that the worker configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the worker configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The latest revision of the worker configuration.</p>
        pub fn latest_revision(
            mut self,
            input: crate::model::WorkerConfigurationRevisionSummary,
        ) -> Self {
            self.latest_revision = Some(input);
            self
        }
        /// <p>The latest revision of the worker configuration.</p>
        pub fn set_latest_revision(
            mut self,
            input: std::option::Option<crate::model::WorkerConfigurationRevisionSummary>,
        ) -> Self {
            self.latest_revision = input;
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkerConfigurationOutput`](crate::output::CreateWorkerConfigurationOutput)
        pub fn build(self) -> crate::output::CreateWorkerConfigurationOutput {
            crate::output::CreateWorkerConfigurationOutput {
                creation_time: self.creation_time,
                latest_revision: self.latest_revision,
                name: self.name,
                worker_configuration_arn: self.worker_configuration_arn,
            }
        }
    }
}
impl CreateWorkerConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkerConfigurationOutput`](crate::output::CreateWorkerConfigurationOutput)
    pub fn builder() -> crate::output::create_worker_configuration_output::Builder {
        crate::output::create_worker_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomPluginOutput {
    /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
    /// <p>The state of the custom plugin.</p>
    pub custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
    /// <p>The name of the custom plugin.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The revision of the custom plugin.</p>
    pub revision: i64,
}
impl std::fmt::Debug for CreateCustomPluginOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomPluginOutput");
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.field("custom_plugin_state", &self.custom_plugin_state);
        formatter.field("name", &self.name);
        formatter.field("revision", &self.revision);
        formatter.finish()
    }
}
/// See [`CreateCustomPluginOutput`](crate::output::CreateCustomPluginOutput)
pub mod create_custom_plugin_output {
    /// A builder for [`CreateCustomPluginOutput`](crate::output::CreateCustomPluginOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
        pub(crate) custom_plugin_state: std::option::Option<crate::model::CustomPluginState>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn custom_plugin_state(mut self, input: crate::model::CustomPluginState) -> Self {
            self.custom_plugin_state = Some(input);
            self
        }
        /// <p>The state of the custom plugin.</p>
        pub fn set_custom_plugin_state(
            mut self,
            input: std::option::Option<crate::model::CustomPluginState>,
        ) -> Self {
            self.custom_plugin_state = input;
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn revision(mut self, input: i64) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the custom plugin.</p>
        pub fn set_revision(mut self, input: std::option::Option<i64>) -> Self {
            self.revision = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomPluginOutput`](crate::output::CreateCustomPluginOutput)
        pub fn build(self) -> crate::output::CreateCustomPluginOutput {
            crate::output::CreateCustomPluginOutput {
                custom_plugin_arn: self.custom_plugin_arn,
                custom_plugin_state: self.custom_plugin_state,
                name: self.name,
                revision: self.revision.unwrap_or_default(),
            }
        }
    }
}
impl CreateCustomPluginOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomPluginOutput`](crate::output::CreateCustomPluginOutput)
    pub fn builder() -> crate::output::create_custom_plugin_output::Builder {
        crate::output::create_custom_plugin_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorOutput {
    /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the connector.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the connector.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>The state of the connector.</p>
    pub connector_state: std::option::Option<crate::model::ConnectorState>,
}
impl std::fmt::Debug for CreateConnectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorOutput");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("connector_state", &self.connector_state);
        formatter.finish()
    }
}
/// See [`CreateConnectorOutput`](crate::output::CreateConnectorOutput)
pub mod create_connector_output {
    /// A builder for [`CreateConnectorOutput`](crate::output::CreateConnectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) connector_state: std::option::Option<crate::model::ConnectorState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the connector.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon assigned to the connector.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>The state of the connector.</p>
        pub fn connector_state(mut self, input: crate::model::ConnectorState) -> Self {
            self.connector_state = Some(input);
            self
        }
        /// <p>The state of the connector.</p>
        pub fn set_connector_state(
            mut self,
            input: std::option::Option<crate::model::ConnectorState>,
        ) -> Self {
            self.connector_state = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorOutput`](crate::output::CreateConnectorOutput)
        pub fn build(self) -> crate::output::CreateConnectorOutput {
            crate::output::CreateConnectorOutput {
                connector_arn: self.connector_arn,
                connector_name: self.connector_name,
                connector_state: self.connector_state,
            }
        }
    }
}
impl CreateConnectorOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectorOutput`](crate::output::CreateConnectorOutput)
    pub fn builder() -> crate::output::create_connector_output::Builder {
        crate::output::create_connector_output::Builder::default()
    }
}
