// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateConnectorInput`](crate::input::CreateConnectorInput)
pub mod create_connector_input {
    /// A builder for [`CreateConnectorInput`](crate::input::CreateConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<crate::model::Capacity>,
        pub(crate) connector_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) connector_description: std::option::Option<std::string::String>,
        pub(crate) connector_name: std::option::Option<std::string::String>,
        pub(crate) kafka_cluster: std::option::Option<crate::model::KafkaCluster>,
        pub(crate) kafka_cluster_client_authentication:
            std::option::Option<crate::model::KafkaClusterClientAuthentication>,
        pub(crate) kafka_cluster_encryption_in_transit:
            std::option::Option<crate::model::KafkaClusterEncryptionInTransit>,
        pub(crate) kafka_connect_version: std::option::Option<std::string::String>,
        pub(crate) log_delivery: std::option::Option<crate::model::LogDelivery>,
        pub(crate) plugins: std::option::Option<std::vec::Vec<crate::model::Plugin>>,
        pub(crate) service_execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) worker_configuration: std::option::Option<crate::model::WorkerConfiguration>,
    }
    impl Builder {
        /// <p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>
        pub fn capacity(mut self, input: crate::model::Capacity) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>
        pub fn set_capacity(mut self, input: std::option::Option<crate::model::Capacity>) -> Self {
            self.capacity = input;
            self
        }
        /// Adds a key-value pair to `connector_configuration`.
        ///
        /// To override the contents of this collection use [`set_connector_configuration`](Self::set_connector_configuration).
        ///
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn connector_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.connector_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connector_configuration = Some(hash_map);
            self
        }
        /// <p>A map of keys to values that represent the configuration for the connector.</p>
        pub fn set_connector_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.connector_configuration = input;
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn connector_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_description = Some(input.into());
            self
        }
        /// <p>A summary description of the connector.</p>
        pub fn set_connector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_description = input;
            self
        }
        /// <p>The name of the connector.</p>
        pub fn connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name = Some(input.into());
            self
        }
        /// <p>The name of the connector.</p>
        pub fn set_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name = input;
            self
        }
        /// <p>Specifies which Apache Kafka cluster to connect to.</p>
        pub fn kafka_cluster(mut self, input: crate::model::KafkaCluster) -> Self {
            self.kafka_cluster = Some(input);
            self
        }
        /// <p>Specifies which Apache Kafka cluster to connect to.</p>
        pub fn set_kafka_cluster(
            mut self,
            input: std::option::Option<crate::model::KafkaCluster>,
        ) -> Self {
            self.kafka_cluster = input;
            self
        }
        /// <p>Details of the client authentication used by the Apache Kafka cluster.</p>
        pub fn kafka_cluster_client_authentication(
            mut self,
            input: crate::model::KafkaClusterClientAuthentication,
        ) -> Self {
            self.kafka_cluster_client_authentication = Some(input);
            self
        }
        /// <p>Details of the client authentication used by the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_client_authentication(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterClientAuthentication>,
        ) -> Self {
            self.kafka_cluster_client_authentication = input;
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn kafka_cluster_encryption_in_transit(
            mut self,
            input: crate::model::KafkaClusterEncryptionInTransit,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = Some(input);
            self
        }
        /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
        pub fn set_kafka_cluster_encryption_in_transit(
            mut self,
            input: std::option::Option<crate::model::KafkaClusterEncryptionInTransit>,
        ) -> Self {
            self.kafka_cluster_encryption_in_transit = input;
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn kafka_connect_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.kafka_connect_version = Some(input.into());
            self
        }
        /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
        pub fn set_kafka_connect_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kafka_connect_version = input;
            self
        }
        /// <p>Details about log delivery.</p>
        pub fn log_delivery(mut self, input: crate::model::LogDelivery) -> Self {
            self.log_delivery = Some(input);
            self
        }
        /// <p>Details about log delivery.</p>
        pub fn set_log_delivery(
            mut self,
            input: std::option::Option<crate::model::LogDelivery>,
        ) -> Self {
            self.log_delivery = input;
            self
        }
        /// Appends an item to `plugins`.
        ///
        /// To override the contents of this collection use [`set_plugins`](Self::set_plugins).
        ///
        /// <p>Specifies which plugins to use for the connector.</p>
        pub fn plugins(mut self, input: impl Into<crate::model::Plugin>) -> Self {
            let mut v = self.plugins.unwrap_or_default();
            v.push(input.into());
            self.plugins = Some(v);
            self
        }
        /// <p>Specifies which plugins to use for the connector.</p>
        pub fn set_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Plugin>>,
        ) -> Self {
            self.plugins = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>
        pub fn service_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>
        pub fn set_service_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_execution_role_arn = input;
            self
        }
        /// <p>Specifies which worker configuration to use with the connector.</p>
        pub fn worker_configuration(mut self, input: crate::model::WorkerConfiguration) -> Self {
            self.worker_configuration = Some(input);
            self
        }
        /// <p>Specifies which worker configuration to use with the connector.</p>
        pub fn set_worker_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkerConfiguration>,
        ) -> Self {
            self.worker_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorInput`](crate::input::CreateConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectorInput {
                capacity: self.capacity,
                connector_configuration: self.connector_configuration,
                connector_description: self.connector_description,
                connector_name: self.connector_name,
                kafka_cluster: self.kafka_cluster,
                kafka_cluster_client_authentication: self.kafka_cluster_client_authentication,
                kafka_cluster_encryption_in_transit: self.kafka_cluster_encryption_in_transit,
                kafka_connect_version: self.kafka_connect_version,
                log_delivery: self.log_delivery,
                plugins: self.plugins,
                service_execution_role_arn: self.service_execution_role_arn,
                worker_configuration: self.worker_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectorInputOperationOutputAlias = crate::operation::CreateConnector;
#[doc(hidden)]
pub type CreateConnectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectorInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnector`](crate::operation::CreateConnector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/connectors").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connector(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnector",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectorInput`](crate::input::CreateConnectorInput)
    pub fn builder() -> crate::input::create_connector_input::Builder {
        crate::input::create_connector_input::Builder::default()
    }
}

/// See [`CreateCustomPluginInput`](crate::input::CreateCustomPluginInput)
pub mod create_custom_plugin_input {
    /// A builder for [`CreateCustomPluginInput`](crate::input::CreateCustomPluginInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<crate::model::CustomPluginContentType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::CustomPluginLocation>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the plugin file.</p>
        pub fn content_type(mut self, input: crate::model::CustomPluginContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The type of the plugin file.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::CustomPluginContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// <p>A summary description of the custom plugin.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A summary description of the custom plugin.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the location of a custom plugin.</p>
        pub fn location(mut self, input: crate::model::CustomPluginLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Information about the location of a custom plugin.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::CustomPluginLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom plugin.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomPluginInput`](crate::input::CreateCustomPluginInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomPluginInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomPluginInput {
                content_type: self.content_type,
                description: self.description,
                location: self.location,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomPluginInputOperationOutputAlias = crate::operation::CreateCustomPlugin;
#[doc(hidden)]
pub type CreateCustomPluginInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomPluginInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomPlugin`](crate::operation::CreateCustomPlugin)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomPlugin,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomPluginInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/custom-plugins").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomPluginInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomPluginInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_plugin(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomPlugin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomPlugin",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomPluginInput`](crate::input::CreateCustomPluginInput)
    pub fn builder() -> crate::input::create_custom_plugin_input::Builder {
        crate::input::create_custom_plugin_input::Builder::default()
    }
}

/// See [`CreateWorkerConfigurationInput`](crate::input::CreateWorkerConfigurationInput)
pub mod create_worker_configuration_input {
    /// A builder for [`CreateWorkerConfigurationInput`](crate::input::CreateWorkerConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) properties_file_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A summary description of the worker configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A summary description of the worker configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the worker configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Base64 encoded contents of connect-distributed.properties file.</p>
        pub fn properties_file_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.properties_file_content = Some(input.into());
            self
        }
        /// <p>Base64 encoded contents of connect-distributed.properties file.</p>
        pub fn set_properties_file_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.properties_file_content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkerConfigurationInput`](crate::input::CreateWorkerConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkerConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkerConfigurationInput {
                description: self.description,
                name: self.name,
                properties_file_content: self.properties_file_content,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkerConfigurationInputOperationOutputAlias =
    crate::operation::CreateWorkerConfiguration;
#[doc(hidden)]
pub type CreateWorkerConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkerConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkerConfiguration`](crate::operation::CreateWorkerConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkerConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkerConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/worker-configurations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkerConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkerConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_worker_configuration(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkerConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkerConfiguration",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkerConfigurationInput`](crate::input::CreateWorkerConfigurationInput)
    pub fn builder() -> crate::input::create_worker_configuration_input::Builder {
        crate::input::create_worker_configuration_input::Builder::default()
    }
}

/// See [`DeleteConnectorInput`](crate::input::DeleteConnectorInput)
pub mod delete_connector_input {
    /// A builder for [`DeleteConnectorInput`](crate::input::DeleteConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The current version of the connector that you want to delete.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the connector that you want to delete.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectorInput`](crate::input::DeleteConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectorInput {
                connector_arn: self.connector_arn,
                current_version: self.current_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectorInputOperationOutputAlias = crate::operation::DeleteConnector;
#[doc(hidden)]
pub type DeleteConnectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnector`](crate::operation::DeleteConnector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.connector_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_arn",
                        details: "cannot be empty or unset",
                    })?;
            let connector_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if connector_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/connectors/{connectorArn}",
                connectorArn = connector_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteConnectorInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.current_version {
                query.push_kv(
                    "currentVersion",
                    &aws_smithy_http::query::fmt_string(&inner_2),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnector",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectorInput`](crate::input::DeleteConnectorInput)
    pub fn builder() -> crate::input::delete_connector_input::Builder {
        crate::input::delete_connector_input::Builder::default()
    }
}

/// See [`DescribeConnectorInput`](crate::input::DescribeConnectorInput)
pub mod describe_connector_input {
    /// A builder for [`DescribeConnectorInput`](crate::input::DescribeConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectorInput`](crate::input::DescribeConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectorInput {
                connector_arn: self.connector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectorInputOperationOutputAlias = crate::operation::DescribeConnector;
#[doc(hidden)]
pub type DescribeConnectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnector`](crate::operation::DescribeConnector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.connector_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_arn",
                        details: "cannot be empty or unset",
                    })?;
            let connector_arn = aws_smithy_http::label::fmt_string(input_3, false);
            if connector_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/connectors/{connectorArn}",
                connectorArn = connector_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnector",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectorInput`](crate::input::DescribeConnectorInput)
    pub fn builder() -> crate::input::describe_connector_input::Builder {
        crate::input::describe_connector_input::Builder::default()
    }
}

/// See [`DescribeCustomPluginInput`](crate::input::DescribeCustomPluginInput)
pub mod describe_custom_plugin_input {
    /// A builder for [`DescribeCustomPluginInput`](crate::input::DescribeCustomPluginInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_plugin_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns information about a custom plugin.</p>
        pub fn custom_plugin_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_plugin_arn = Some(input.into());
            self
        }
        /// <p>Returns information about a custom plugin.</p>
        pub fn set_custom_plugin_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_plugin_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomPluginInput`](crate::input::DescribeCustomPluginInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomPluginInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomPluginInput {
                custom_plugin_arn: self.custom_plugin_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomPluginInputOperationOutputAlias = crate::operation::DescribeCustomPlugin;
#[doc(hidden)]
pub type DescribeCustomPluginInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCustomPluginInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomPlugin`](crate::operation::DescribeCustomPlugin)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomPlugin,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomPluginInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.custom_plugin_arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "custom_plugin_arn",
                        details: "cannot be empty or unset",
                    })?;
            let custom_plugin_arn = aws_smithy_http::label::fmt_string(input_4, false);
            if custom_plugin_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "custom_plugin_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/custom-plugins/{customPluginArn}",
                customPluginArn = custom_plugin_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomPluginInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomPluginInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomPlugin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomPlugin",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomPluginInput`](crate::input::DescribeCustomPluginInput)
    pub fn builder() -> crate::input::describe_custom_plugin_input::Builder {
        crate::input::describe_custom_plugin_input::Builder::default()
    }
}

/// See [`DescribeWorkerConfigurationInput`](crate::input::DescribeWorkerConfigurationInput)
pub mod describe_worker_configuration_input {
    /// A builder for [`DescribeWorkerConfigurationInput`](crate::input::DescribeWorkerConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>
        pub fn worker_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>
        pub fn set_worker_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.worker_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkerConfigurationInput`](crate::input::DescribeWorkerConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkerConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkerConfigurationInput {
                worker_configuration_arn: self.worker_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkerConfigurationInputOperationOutputAlias =
    crate::operation::DescribeWorkerConfiguration;
#[doc(hidden)]
pub type DescribeWorkerConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkerConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkerConfiguration`](crate::operation::DescribeWorkerConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkerConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkerConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.worker_configuration_arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "worker_configuration_arn",
                        details: "cannot be empty or unset",
                    })?;
            let worker_configuration_arn = aws_smithy_http::label::fmt_string(input_5, false);
            if worker_configuration_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "worker_configuration_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/worker-configurations/{workerConfigurationArn}",
                workerConfigurationArn = worker_configuration_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkerConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkerConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkerConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkerConfiguration",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkerConfigurationInput`](crate::input::DescribeWorkerConfigurationInput)
    pub fn builder() -> crate::input::describe_worker_configuration_input::Builder {
        crate::input::describe_worker_configuration_input::Builder::default()
    }
}

/// See [`ListConnectorsInput`](crate::input::ListConnectorsInput)
pub mod list_connectors_input {
    /// A builder for [`ListConnectorsInput`](crate::input::ListConnectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_name_prefix: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name prefix that you want to use to search for and list connectors.</p>
        pub fn connector_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_name_prefix = Some(input.into());
            self
        }
        /// <p>The name prefix that you want to use to search for and list connectors.</p>
        pub fn set_connector_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_name_prefix = input;
            self
        }
        /// <p>The maximum number of connectors to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of connectors to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorsInput`](crate::input::ListConnectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConnectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConnectorsInput {
                connector_name_prefix: self.connector_name_prefix,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConnectorsInputOperationOutputAlias = crate::operation::ListConnectors;
#[doc(hidden)]
pub type ListConnectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConnectorsInput {
    /// Consumes the builder and constructs an Operation<[`ListConnectors`](crate::operation::ListConnectors)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConnectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConnectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/connectors").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListConnectorsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.connector_name_prefix {
                query.push_kv(
                    "connectorNamePrefix",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConnectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConnectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConnectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConnectors",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConnectorsInput`](crate::input::ListConnectorsInput)
    pub fn builder() -> crate::input::list_connectors_input::Builder {
        crate::input::list_connectors_input::Builder::default()
    }
}

/// See [`ListCustomPluginsInput`](crate::input::ListCustomPluginsInput)
pub mod list_custom_plugins_input {
    /// A builder for [`ListCustomPluginsInput`](crate::input::ListCustomPluginsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of custom plugins to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of custom plugins to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomPluginsInput`](crate::input::ListCustomPluginsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomPluginsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomPluginsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomPluginsInputOperationOutputAlias = crate::operation::ListCustomPlugins;
#[doc(hidden)]
pub type ListCustomPluginsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomPluginsInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomPlugins`](crate::operation::ListCustomPlugins)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomPlugins,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomPluginsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/custom-plugins").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListCustomPluginsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomPluginsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomPluginsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomPlugins::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomPlugins",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomPluginsInput`](crate::input::ListCustomPluginsInput)
    pub fn builder() -> crate::input::list_custom_plugins_input::Builder {
        crate::input::list_custom_plugins_input::Builder::default()
    }
}

/// See [`ListWorkerConfigurationsInput`](crate::input::ListWorkerConfigurationsInput)
pub mod list_worker_configurations_input {
    /// A builder for [`ListWorkerConfigurationsInput`](crate::input::ListWorkerConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of worker configurations to list in one response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of worker configurations to list in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkerConfigurationsInput`](crate::input::ListWorkerConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkerConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkerConfigurationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkerConfigurationsInputOperationOutputAlias =
    crate::operation::ListWorkerConfigurations;
#[doc(hidden)]
pub type ListWorkerConfigurationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkerConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkerConfigurations`](crate::operation::ListWorkerConfigurations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkerConfigurations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkerConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/worker-configurations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListWorkerConfigurationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_9) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_9));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkerConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkerConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkerConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkerConfigurations",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkerConfigurationsInput`](crate::input::ListWorkerConfigurationsInput)
    pub fn builder() -> crate::input::list_worker_configurations_input::Builder {
        crate::input::list_worker_configurations_input::Builder::default()
    }
}

/// See [`UpdateConnectorInput`](crate::input::UpdateConnectorInput)
pub mod update_connector_input {
    /// A builder for [`UpdateConnectorInput`](crate::input::UpdateConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity: std::option::Option<crate::model::CapacityUpdate>,
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) current_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The target capacity.</p>
        pub fn capacity(mut self, input: crate::model::CapacityUpdate) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>The target capacity.</p>
        pub fn set_capacity(
            mut self,
            input: std::option::Option<crate::model::CapacityUpdate>,
        ) -> Self {
            self.capacity = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// <p>The current version of the connector that you want to update.</p>
        pub fn current_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_version = Some(input.into());
            self
        }
        /// <p>The current version of the connector that you want to update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectorInput`](crate::input::UpdateConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectorInput {
                capacity: self.capacity,
                connector_arn: self.connector_arn,
                current_version: self.current_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectorInputOperationOutputAlias = crate::operation::UpdateConnector;
#[doc(hidden)]
pub type UpdateConnectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnector`](crate::operation::UpdateConnector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.connector_arn;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_arn",
                        details: "cannot be empty or unset",
                    })?;
            let connector_arn = aws_smithy_http::label::fmt_string(input_10, false);
            if connector_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/connectors/{connectorArn}",
                connectorArn = connector_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UpdateConnectorInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.current_version {
                query.push_kv(
                    "currentVersion",
                    &aws_smithy_http::query::fmt_string(&inner_11),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connector(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnector",
            "kafkaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectorInput`](crate::input::UpdateConnectorInput)
    pub fn builder() -> crate::input::update_connector_input::Builder {
        crate::input::update_connector_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectorInput {
    /// <p>The target capacity.</p>
    pub capacity: std::option::Option<crate::model::CapacityUpdate>,
    /// <p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the connector that you want to update.</p>
    pub current_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectorInput");
        formatter.field("capacity", &self.capacity);
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("current_version", &self.current_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkerConfigurationsInput {
    /// <p>The maximum number of worker configurations to list in one response.</p>
    pub max_results: i32,
    /// <p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListWorkerConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkerConfigurationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomPluginsInput {
    /// <p>The maximum number of custom plugins to list in one response.</p>
    pub max_results: i32,
    /// <p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCustomPluginsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomPluginsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorsInput {
    /// <p>The name prefix that you want to use to search for and list connectors.</p>
    pub connector_name_prefix: std::option::Option<std::string::String>,
    /// <p>The maximum number of connectors to list in one response.</p>
    pub max_results: i32,
    /// <p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConnectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorsInput");
        formatter.field("connector_name_prefix", &self.connector_name_prefix);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkerConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>
    pub worker_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeWorkerConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkerConfigurationInput");
        formatter.field("worker_configuration_arn", &self.worker_configuration_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomPluginInput {
    /// <p>Returns information about a custom plugin.</p>
    pub custom_plugin_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCustomPluginInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomPluginInput");
        formatter.field("custom_plugin_arn", &self.custom_plugin_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectorInput {
    /// <p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>
    pub connector_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeConnectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectorInput");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectorInput {
    /// <p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>
    pub connector_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the connector that you want to delete.</p>
    pub current_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConnectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectorInput");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("current_version", &self.current_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkerConfigurationInput {
    /// <p>A summary description of the worker configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the worker configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Base64 encoded contents of connect-distributed.properties file.</p>
    pub properties_file_content: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateWorkerConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkerConfigurationInput");
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("properties_file_content", &self.properties_file_content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomPluginInput {
    /// <p>The type of the plugin file.</p>
    pub content_type: std::option::Option<crate::model::CustomPluginContentType>,
    /// <p>A summary description of the custom plugin.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the location of a custom plugin.</p>
    pub location: std::option::Option<crate::model::CustomPluginLocation>,
    /// <p>The name of the custom plugin.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateCustomPluginInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomPluginInput");
        formatter.field("content_type", &self.content_type);
        formatter.field("description", &self.description);
        formatter.field("location", &self.location);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorInput {
    /// <p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>
    pub capacity: std::option::Option<crate::model::Capacity>,
    /// <p>A map of keys to values that represent the configuration for the connector.</p>
    pub connector_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A summary description of the connector.</p>
    pub connector_description: std::option::Option<std::string::String>,
    /// <p>The name of the connector.</p>
    pub connector_name: std::option::Option<std::string::String>,
    /// <p>Specifies which Apache Kafka cluster to connect to.</p>
    pub kafka_cluster: std::option::Option<crate::model::KafkaCluster>,
    /// <p>Details of the client authentication used by the Apache Kafka cluster.</p>
    pub kafka_cluster_client_authentication:
        std::option::Option<crate::model::KafkaClusterClientAuthentication>,
    /// <p>Details of encryption in transit to the Apache Kafka cluster.</p>
    pub kafka_cluster_encryption_in_transit:
        std::option::Option<crate::model::KafkaClusterEncryptionInTransit>,
    /// <p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.</p>
    pub kafka_connect_version: std::option::Option<std::string::String>,
    /// <p>Details about log delivery.</p>
    pub log_delivery: std::option::Option<crate::model::LogDelivery>,
    /// <p>Specifies which plugins to use for the connector.</p>
    pub plugins: std::option::Option<std::vec::Vec<crate::model::Plugin>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>
    pub service_execution_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies which worker configuration to use with the connector.</p>
    pub worker_configuration: std::option::Option<crate::model::WorkerConfiguration>,
}
impl std::fmt::Debug for CreateConnectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorInput");
        formatter.field("capacity", &self.capacity);
        formatter.field("connector_configuration", &self.connector_configuration);
        formatter.field("connector_description", &self.connector_description);
        formatter.field("connector_name", &self.connector_name);
        formatter.field("kafka_cluster", &self.kafka_cluster);
        formatter.field(
            "kafka_cluster_client_authentication",
            &self.kafka_cluster_client_authentication,
        );
        formatter.field(
            "kafka_cluster_encryption_in_transit",
            &self.kafka_cluster_encryption_in_transit,
        );
        formatter.field("kafka_connect_version", &self.kafka_connect_version);
        formatter.field("log_delivery", &self.log_delivery);
        formatter.field("plugins", &self.plugins);
        formatter.field(
            "service_execution_role_arn",
            &self.service_execution_role_arn,
        );
        formatter.field("worker_configuration", &self.worker_configuration);
        formatter.finish()
    }
}
