// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoomOutput {
    /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Room name, from the request.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    pub maximum_message_rate_per_second: i32,
    /// <p>Maximum number of characters in a single message, from the request.</p>
    pub maximum_message_length: i32,
    /// <p>Configuration information for optional review of messages.</p>
    pub message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
    /// <p>Tags attached to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateRoomOutput {
    /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Room name, from the request.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    pub fn maximum_message_rate_per_second(&self) -> i32 {
        self.maximum_message_rate_per_second
    }
    /// <p>Maximum number of characters in a single message, from the request.</p>
    pub fn maximum_message_length(&self) -> i32 {
        self.maximum_message_length
    }
    /// <p>Configuration information for optional review of messages.</p>
    pub fn message_review_handler(
        &self,
    ) -> std::option::Option<&crate::model::MessageReviewHandler> {
        self.message_review_handler.as_ref()
    }
    /// <p>Tags attached to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateRoomOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoomOutput");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field(
            "maximum_message_rate_per_second",
            &self.maximum_message_rate_per_second,
        );
        formatter.field("maximum_message_length", &self.maximum_message_length);
        formatter.field("message_review_handler", &self.message_review_handler);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateRoomOutput`](crate::output::UpdateRoomOutput)
pub mod update_room_output {
    /// A builder for [`UpdateRoomOutput`](crate::output::UpdateRoomOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) maximum_message_rate_per_second: std::option::Option<i32>,
        pub(crate) maximum_message_length: std::option::Option<i32>,
        pub(crate) message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Room name, from the request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Room name, from the request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.maximum_message_rate_per_second = Some(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_message_rate_per_second = input;
            self
        }
        /// <p>Maximum number of characters in a single message, from the request.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.maximum_message_length = Some(input);
            self
        }
        /// <p>Maximum number of characters in a single message, from the request.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_message_length = input;
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.message_review_handler = Some(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.message_review_handler = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags attached to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags attached to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoomOutput`](crate::output::UpdateRoomOutput)
        pub fn build(self) -> crate::output::UpdateRoomOutput {
            crate::output::UpdateRoomOutput {
                arn: self.arn,
                id: self.id,
                name: self.name,
                create_time: self.create_time,
                update_time: self.update_time,
                maximum_message_rate_per_second: self
                    .maximum_message_rate_per_second
                    .unwrap_or_default(),
                maximum_message_length: self.maximum_message_length.unwrap_or_default(),
                message_review_handler: self.message_review_handler,
                tags: self.tags,
            }
        }
    }
}
impl UpdateRoomOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRoomOutput`](crate::output::UpdateRoomOutput)
    pub fn builder() -> crate::output::update_room_output::Builder {
        crate::output::update_room_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEventOutput {
    /// <p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>
    pub id: std::option::Option<std::string::String>,
}
impl SendEventOutput {
    /// <p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for SendEventOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEventOutput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`SendEventOutput`](crate::output::SendEventOutput)
pub mod send_event_output {
    /// A builder for [`SendEventOutput`](crate::output::SendEventOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEventOutput`](crate::output::SendEventOutput)
        pub fn build(self) -> crate::output::SendEventOutput {
            crate::output::SendEventOutput { id: self.id }
        }
    }
}
impl SendEventOutput {
    /// Creates a new builder-style object to manufacture [`SendEventOutput`](crate::output::SendEventOutput)
    pub fn builder() -> crate::output::send_event_output::Builder {
        crate::output::send_event_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoomsOutput {
    /// <p>List of the matching rooms (summary information only).</p>
    pub rooms: std::option::Option<std::vec::Vec<crate::model::RoomSummary>>,
    /// <p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRoomsOutput {
    /// <p>List of the matching rooms (summary information only).</p>
    pub fn rooms(&self) -> std::option::Option<&[crate::model::RoomSummary]> {
        self.rooms.as_deref()
    }
    /// <p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRoomsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoomsOutput");
        formatter.field("rooms", &self.rooms);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRoomsOutput`](crate::output::ListRoomsOutput)
pub mod list_rooms_output {
    /// A builder for [`ListRoomsOutput`](crate::output::ListRoomsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rooms: std::option::Option<std::vec::Vec<crate::model::RoomSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rooms`.
        ///
        /// To override the contents of this collection use [`set_rooms`](Self::set_rooms).
        ///
        /// <p>List of the matching rooms (summary information only).</p>
        pub fn rooms(mut self, input: crate::model::RoomSummary) -> Self {
            let mut v = self.rooms.unwrap_or_default();
            v.push(input);
            self.rooms = Some(v);
            self
        }
        /// <p>List of the matching rooms (summary information only).</p>
        pub fn set_rooms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoomSummary>>,
        ) -> Self {
            self.rooms = input;
            self
        }
        /// <p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoomsOutput`](crate::output::ListRoomsOutput)
        pub fn build(self) -> crate::output::ListRoomsOutput {
            crate::output::ListRoomsOutput {
                rooms: self.rooms,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRoomsOutput {
    /// Creates a new builder-style object to manufacture [`ListRoomsOutput`](crate::output::ListRoomsOutput)
    pub fn builder() -> crate::output::list_rooms_output::Builder {
        crate::output::list_rooms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoomOutput {
    /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Room name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub maximum_message_rate_per_second: i32,
    /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub maximum_message_length: i32,
    /// <p>Configuration information for optional review of messages.</p>
    pub message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
    /// <p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetRoomOutput {
    /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Room name. The value does not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub fn maximum_message_rate_per_second(&self) -> i32 {
        self.maximum_message_rate_per_second
    }
    /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub fn maximum_message_length(&self) -> i32 {
        self.maximum_message_length
    }
    /// <p>Configuration information for optional review of messages.</p>
    pub fn message_review_handler(
        &self,
    ) -> std::option::Option<&crate::model::MessageReviewHandler> {
        self.message_review_handler.as_ref()
    }
    /// <p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetRoomOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoomOutput");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field(
            "maximum_message_rate_per_second",
            &self.maximum_message_rate_per_second,
        );
        formatter.field("maximum_message_length", &self.maximum_message_length);
        formatter.field("message_review_handler", &self.message_review_handler);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetRoomOutput`](crate::output::GetRoomOutput)
pub mod get_room_output {
    /// A builder for [`GetRoomOutput`](crate::output::GetRoomOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) maximum_message_rate_per_second: std::option::Option<i32>,
        pub(crate) maximum_message_length: std::option::Option<i32>,
        pub(crate) message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.maximum_message_rate_per_second = Some(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_message_rate_per_second = input;
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.maximum_message_length = Some(input);
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_message_length = input;
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.message_review_handler = Some(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.message_review_handler = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoomOutput`](crate::output::GetRoomOutput)
        pub fn build(self) -> crate::output::GetRoomOutput {
            crate::output::GetRoomOutput {
                arn: self.arn,
                id: self.id,
                name: self.name,
                create_time: self.create_time,
                update_time: self.update_time,
                maximum_message_rate_per_second: self
                    .maximum_message_rate_per_second
                    .unwrap_or_default(),
                maximum_message_length: self.maximum_message_length.unwrap_or_default(),
                message_review_handler: self.message_review_handler,
                tags: self.tags,
            }
        }
    }
}
impl GetRoomOutput {
    /// Creates a new builder-style object to manufacture [`GetRoomOutput`](crate::output::GetRoomOutput)
    pub fn builder() -> crate::output::get_room_output::Builder {
        crate::output::get_room_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectUserOutput {}
impl std::fmt::Debug for DisconnectUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectUserOutput");
        formatter.finish()
    }
}
/// See [`DisconnectUserOutput`](crate::output::DisconnectUserOutput)
pub mod disconnect_user_output {
    /// A builder for [`DisconnectUserOutput`](crate::output::DisconnectUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisconnectUserOutput`](crate::output::DisconnectUserOutput)
        pub fn build(self) -> crate::output::DisconnectUserOutput {
            crate::output::DisconnectUserOutput {}
        }
    }
}
impl DisconnectUserOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectUserOutput`](crate::output::DisconnectUserOutput)
    pub fn builder() -> crate::output::disconnect_user_output::Builder {
        crate::output::disconnect_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoomOutput {}
impl std::fmt::Debug for DeleteRoomOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoomOutput");
        formatter.finish()
    }
}
/// See [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)
pub mod delete_room_output {
    /// A builder for [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)
        pub fn build(self) -> crate::output::DeleteRoomOutput {
            crate::output::DeleteRoomOutput {}
        }
    }
}
impl DeleteRoomOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)
    pub fn builder() -> crate::output::delete_room_output::Builder {
        crate::output::delete_room_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageOutput {
    /// <p>Operation identifier, generated by Amazon IVS Chat.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteMessageOutput {
    /// <p>Operation identifier, generated by Amazon IVS Chat.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageOutput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
pub mod delete_message_output {
    /// A builder for [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Operation identifier, generated by Amazon IVS Chat.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Operation identifier, generated by Amazon IVS Chat.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
        pub fn build(self) -> crate::output::DeleteMessageOutput {
            crate::output::DeleteMessageOutput { id: self.id }
        }
    }
}
impl DeleteMessageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
    pub fn builder() -> crate::output::delete_message_output::Builder {
        crate::output::delete_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoomOutput {
    /// <p>Room ARN, assigned by the system.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Room name, from the request (if specified).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    pub maximum_message_rate_per_second: i32,
    /// <p>Maximum number of characters in a single message, from the request.</p>
    pub maximum_message_length: i32,
    /// <p>Configuration information for optional review of messages.</p>
    pub message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
    /// <p>Tags attached to the resource, from the request.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRoomOutput {
    /// <p>Room ARN, assigned by the system.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Room name, from the request (if specified).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    pub fn maximum_message_rate_per_second(&self) -> i32 {
        self.maximum_message_rate_per_second
    }
    /// <p>Maximum number of characters in a single message, from the request.</p>
    pub fn maximum_message_length(&self) -> i32 {
        self.maximum_message_length
    }
    /// <p>Configuration information for optional review of messages.</p>
    pub fn message_review_handler(
        &self,
    ) -> std::option::Option<&crate::model::MessageReviewHandler> {
        self.message_review_handler.as_ref()
    }
    /// <p>Tags attached to the resource, from the request.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRoomOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoomOutput");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field(
            "maximum_message_rate_per_second",
            &self.maximum_message_rate_per_second,
        );
        formatter.field("maximum_message_length", &self.maximum_message_length);
        formatter.field("message_review_handler", &self.message_review_handler);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRoomOutput`](crate::output::CreateRoomOutput)
pub mod create_room_output {
    /// A builder for [`CreateRoomOutput`](crate::output::CreateRoomOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) maximum_message_rate_per_second: std::option::Option<i32>,
        pub(crate) maximum_message_length: std::option::Option<i32>,
        pub(crate) message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Room ARN, assigned by the system.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Room ARN, assigned by the system.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Room name, from the request (if specified).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Room name, from the request (if specified).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.maximum_message_rate_per_second = Some(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_message_rate_per_second = input;
            self
        }
        /// <p>Maximum number of characters in a single message, from the request.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.maximum_message_length = Some(input);
            self
        }
        /// <p>Maximum number of characters in a single message, from the request.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_message_length = input;
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.message_review_handler = Some(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.message_review_handler = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags attached to the resource, from the request.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags attached to the resource, from the request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoomOutput`](crate::output::CreateRoomOutput)
        pub fn build(self) -> crate::output::CreateRoomOutput {
            crate::output::CreateRoomOutput {
                arn: self.arn,
                id: self.id,
                name: self.name,
                create_time: self.create_time,
                update_time: self.update_time,
                maximum_message_rate_per_second: self
                    .maximum_message_rate_per_second
                    .unwrap_or_default(),
                maximum_message_length: self.maximum_message_length.unwrap_or_default(),
                message_review_handler: self.message_review_handler,
                tags: self.tags,
            }
        }
    }
}
impl CreateRoomOutput {
    /// Creates a new builder-style object to manufacture [`CreateRoomOutput`](crate::output::CreateRoomOutput)
    pub fn builder() -> crate::output::create_room_output::Builder {
        crate::output::create_room_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChatTokenOutput {
    /// <p>The issued client token, encrypted.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub token_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub session_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateChatTokenOutput {
    /// <p>The issued client token, encrypted.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn token_expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.token_expiration_time.as_ref()
    }
    /// <p>Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    pub fn session_expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.session_expiration_time.as_ref()
    }
}
impl std::fmt::Debug for CreateChatTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChatTokenOutput");
        formatter.field("token", &self.token);
        formatter.field("token_expiration_time", &self.token_expiration_time);
        formatter.field("session_expiration_time", &self.session_expiration_time);
        formatter.finish()
    }
}
/// See [`CreateChatTokenOutput`](crate::output::CreateChatTokenOutput)
pub mod create_chat_token_output {
    /// A builder for [`CreateChatTokenOutput`](crate::output::CreateChatTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) token_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) session_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The issued client token, encrypted.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The issued client token, encrypted.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn token_expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.token_expiration_time = Some(input);
            self
        }
        /// <p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_token_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.token_expiration_time = input;
            self
        }
        /// <p>Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn session_expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.session_expiration_time = Some(input);
            self
        }
        /// <p>Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
        pub fn set_session_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.session_expiration_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChatTokenOutput`](crate::output::CreateChatTokenOutput)
        pub fn build(self) -> crate::output::CreateChatTokenOutput {
            crate::output::CreateChatTokenOutput {
                token: self.token,
                token_expiration_time: self.token_expiration_time,
                session_expiration_time: self.session_expiration_time,
            }
        }
    }
}
impl CreateChatTokenOutput {
    /// Creates a new builder-style object to manufacture [`CreateChatTokenOutput`](crate::output::CreateChatTokenOutput)
    pub fn builder() -> crate::output::create_chat_token_output::Builder {
        crate::output::create_chat_token_output::Builder::default()
    }
}
