// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateChatToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_chat_token`](crate::client::Client::create_chat_token).
///
/// See [`crate::client::fluent_builders::CreateChatToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChatToken {
    _private: (),
}
impl CreateChatToken {
    /// Creates a new builder-style object to manufacture [`CreateChatTokenInput`](crate::input::CreateChatTokenInput)
    pub fn builder() -> crate::input::create_chat_token_input::Builder {
        crate::input::create_chat_token_input::Builder::default()
    }
    /// Creates a new `CreateChatToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChatToken {
    type Output = std::result::Result<
        crate::output::CreateChatTokenOutput,
        crate::error::CreateChatTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_chat_token_error(response)
        } else {
            crate::operation_deser::parse_create_chat_token_response(response)
        }
    }
}

/// Operation shape for `CreateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_room`](crate::client::Client::create_room).
///
/// See [`crate::client::fluent_builders::CreateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoom {
    _private: (),
}
impl CreateRoom {
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
    /// Creates a new `CreateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoom {
    type Output =
        std::result::Result<crate::output::CreateRoomOutput, crate::error::CreateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_room_error(response)
        } else {
            crate::operation_deser::parse_create_room_response(response)
        }
    }
}

/// Operation shape for `DeleteMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_message`](crate::client::Client::delete_message).
///
/// See [`crate::client::fluent_builders::DeleteMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMessage {
    _private: (),
}
impl DeleteMessage {
    /// Creates a new builder-style object to manufacture [`DeleteMessageInput`](crate::input::DeleteMessageInput)
    pub fn builder() -> crate::input::delete_message_input::Builder {
        crate::input::delete_message_input::Builder::default()
    }
    /// Creates a new `DeleteMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMessage {
    type Output =
        std::result::Result<crate::output::DeleteMessageOutput, crate::error::DeleteMessageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_message_error(response)
        } else {
            crate::operation_deser::parse_delete_message_response(response)
        }
    }
}

/// Operation shape for `DeleteRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_room`](crate::client::Client::delete_room).
///
/// See [`crate::client::fluent_builders::DeleteRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoom {
    _private: (),
}
impl DeleteRoom {
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
    /// Creates a new `DeleteRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoom {
    type Output =
        std::result::Result<crate::output::DeleteRoomOutput, crate::error::DeleteRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_room_error(response)
        } else {
            crate::operation_deser::parse_delete_room_response(response)
        }
    }
}

/// Operation shape for `DisconnectUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_user`](crate::client::Client::disconnect_user).
///
/// See [`crate::client::fluent_builders::DisconnectUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectUser {
    _private: (),
}
impl DisconnectUser {
    /// Creates a new builder-style object to manufacture [`DisconnectUserInput`](crate::input::DisconnectUserInput)
    pub fn builder() -> crate::input::disconnect_user_input::Builder {
        crate::input::disconnect_user_input::Builder::default()
    }
    /// Creates a new `DisconnectUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectUser {
    type Output =
        std::result::Result<crate::output::DisconnectUserOutput, crate::error::DisconnectUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_user_error(response)
        } else {
            crate::operation_deser::parse_disconnect_user_response(response)
        }
    }
}

/// Operation shape for `GetRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_room`](crate::client::Client::get_room).
///
/// See [`crate::client::fluent_builders::GetRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRoom {
    _private: (),
}
impl GetRoom {
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
    /// Creates a new `GetRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRoom {
    type Output = std::result::Result<crate::output::GetRoomOutput, crate::error::GetRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_room_error(response)
        } else {
            crate::operation_deser::parse_get_room_response(response)
        }
    }
}

/// Operation shape for `ListRooms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rooms`](crate::client::Client::list_rooms).
///
/// See [`crate::client::fluent_builders::ListRooms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRooms {
    _private: (),
}
impl ListRooms {
    /// Creates a new builder-style object to manufacture [`ListRoomsInput`](crate::input::ListRoomsInput)
    pub fn builder() -> crate::input::list_rooms_input::Builder {
        crate::input::list_rooms_input::Builder::default()
    }
    /// Creates a new `ListRooms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRooms {
    type Output = std::result::Result<crate::output::ListRoomsOutput, crate::error::ListRoomsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rooms_error(response)
        } else {
            crate::operation_deser::parse_list_rooms_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `SendEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_event`](crate::client::Client::send_event).
///
/// See [`crate::client::fluent_builders::SendEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendEvent {
    _private: (),
}
impl SendEvent {
    /// Creates a new builder-style object to manufacture [`SendEventInput`](crate::input::SendEventInput)
    pub fn builder() -> crate::input::send_event_input::Builder {
        crate::input::send_event_input::Builder::default()
    }
    /// Creates a new `SendEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendEvent {
    type Output = std::result::Result<crate::output::SendEventOutput, crate::error::SendEventError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_event_error(response)
        } else {
            crate::operation_deser::parse_send_event_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateRoom`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_room`](crate::client::Client::update_room).
///
/// See [`crate::client::fluent_builders::UpdateRoom`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoom {
    _private: (),
}
impl UpdateRoom {
    /// Creates a new builder-style object to manufacture [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    pub fn builder() -> crate::input::update_room_input::Builder {
        crate::input::update_room_input::Builder::default()
    }
    /// Creates a new `UpdateRoom` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoom {
    type Output =
        std::result::Result<crate::output::UpdateRoomOutput, crate::error::UpdateRoomError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_room_error(response)
        } else {
            crate::operation_deser::parse_update_room_response(response)
        }
    }
}
