// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateChatTokenInput`](crate::input::CreateChatTokenInput)
pub mod create_chat_token_input {
    /// A builder for [`CreateChatTokenInput`](crate::input::CreateChatTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_identifier: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) capabilities:
            std::option::Option<std::vec::Vec<crate::model::ChatTokenCapability>>,
        pub(crate) session_duration_in_minutes: std::option::Option<i32>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.room_identifier = input;
            self
        }
        /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
        pub fn capabilities(mut self, input: crate::model::ChatTokenCapability) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input);
            self.capabilities = Some(v);
            self
        }
        /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChatTokenCapability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
        pub fn session_duration_in_minutes(mut self, input: i32) -> Self {
            self.session_duration_in_minutes = Some(input);
            self
        }
        /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
        pub fn set_session_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.session_duration_in_minutes = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChatTokenInput`](crate::input::CreateChatTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateChatTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateChatTokenInput {
                room_identifier: self.room_identifier,
                user_id: self.user_id,
                capabilities: self.capabilities,
                session_duration_in_minutes: self.session_duration_in_minutes.unwrap_or_default(),
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateChatTokenInputOperationOutputAlias = crate::operation::CreateChatToken;
#[doc(hidden)]
pub type CreateChatTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateChatTokenInput {
    /// Consumes the builder and constructs an Operation<[`CreateChatToken`](crate::operation::CreateChatToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateChatToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateChatTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateChatToken").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateChatTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_chat_token(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateChatToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateChatToken",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateChatTokenInput`](crate::input::CreateChatTokenInput)
    pub fn builder() -> crate::input::create_chat_token_input::Builder {
        crate::input::create_chat_token_input::Builder::default()
    }
}

/// See [`CreateRoomInput`](crate::input::CreateRoomInput)
pub mod create_room_input {
    /// A builder for [`CreateRoomInput`](crate::input::CreateRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) maximum_message_rate_per_second: std::option::Option<i32>,
        pub(crate) maximum_message_length: std::option::Option<i32>,
        pub(crate) message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.maximum_message_rate_per_second = Some(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_message_rate_per_second = input;
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.maximum_message_length = Some(input);
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_message_length = input;
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.message_review_handler = Some(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.message_review_handler = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoomInput`](crate::input::CreateRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoomInput {
                name: self.name,
                maximum_message_rate_per_second: self
                    .maximum_message_rate_per_second
                    .unwrap_or_default(),
                maximum_message_length: self.maximum_message_length.unwrap_or_default(),
                message_review_handler: self.message_review_handler,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoomInputOperationOutputAlias = crate::operation::CreateRoom;
#[doc(hidden)]
pub type CreateRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoomInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoom`](crate::operation::CreateRoom)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRoomInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateRoom").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRoomInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_room(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoom",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRoomInput`](crate::input::CreateRoomInput)
    pub fn builder() -> crate::input::create_room_input::Builder {
        crate::input::create_room_input::Builder::default()
    }
}

/// See [`DeleteMessageInput`](crate::input::DeleteMessageInput)
pub mod delete_message_input {
    /// A builder for [`DeleteMessageInput`](crate::input::DeleteMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_identifier: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.room_identifier = input;
            self
        }
        /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Reason for deleting the message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Reason for deleting the message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMessageInput`](crate::input::DeleteMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMessageInput {
                room_identifier: self.room_identifier,
                id: self.id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMessageInputOperationOutputAlias = crate::operation::DeleteMessage;
#[doc(hidden)]
pub type DeleteMessageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMessageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMessage`](crate::operation::DeleteMessage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMessage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMessageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteMessage").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMessageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_message(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMessage",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMessageInput`](crate::input::DeleteMessageInput)
    pub fn builder() -> crate::input::delete_message_input::Builder {
        crate::input::delete_message_input::Builder::default()
    }
}

/// See [`DeleteRoomInput`](crate::input::DeleteRoomInput)
pub mod delete_room_input {
    /// A builder for [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoomInput`](crate::input::DeleteRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoomInput {
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoomInputOperationOutputAlias = crate::operation::DeleteRoom;
#[doc(hidden)]
pub type DeleteRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRoomInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoom`](crate::operation::DeleteRoom)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRoomInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteRoom").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRoomInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_room(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoom",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoomInput`](crate::input::DeleteRoomInput)
    pub fn builder() -> crate::input::delete_room_input::Builder {
        crate::input::delete_room_input::Builder::default()
    }
}

/// See [`DisconnectUserInput`](crate::input::DisconnectUserInput)
pub mod disconnect_user_input {
    /// A builder for [`DisconnectUserInput`](crate::input::DisconnectUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_identifier: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.room_identifier = input;
            self
        }
        /// <p>ID of the user (connection) to disconnect from the room.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>ID of the user (connection) to disconnect from the room.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>Reason for disconnecting the user.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Reason for disconnecting the user.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DisconnectUserInput`](crate::input::DisconnectUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisconnectUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisconnectUserInput {
                room_identifier: self.room_identifier,
                user_id: self.user_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type DisconnectUserInputOperationOutputAlias = crate::operation::DisconnectUser;
#[doc(hidden)]
pub type DisconnectUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisconnectUserInput {
    /// Consumes the builder and constructs an Operation<[`DisconnectUser`](crate::operation::DisconnectUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisconnectUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisconnectUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DisconnectUser").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisconnectUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disconnect_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisconnectUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisconnectUser",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisconnectUserInput`](crate::input::DisconnectUserInput)
    pub fn builder() -> crate::input::disconnect_user_input::Builder {
        crate::input::disconnect_user_input::Builder::default()
    }
}

/// See [`GetRoomInput`](crate::input::GetRoomInput)
pub mod get_room_input {
    /// A builder for [`GetRoomInput`](crate::input::GetRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoomInput`](crate::input::GetRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRoomInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRoomInput {
                identifier: self.identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoomInputOperationOutputAlias = crate::operation::GetRoom;
#[doc(hidden)]
pub type GetRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRoomInput {
    /// Consumes the builder and constructs an Operation<[`GetRoom`](crate::operation::GetRoom)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRoomInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetRoom").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRoomInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_room(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRoom::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetRoom", "ivschat",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRoomInput`](crate::input::GetRoomInput)
    pub fn builder() -> crate::input::get_room_input::Builder {
        crate::input::get_room_input::Builder::default()
    }
}

/// See [`ListRoomsInput`](crate::input::ListRoomsInput)
pub mod list_rooms_input {
    /// A builder for [`ListRoomsInput`](crate::input::ListRoomsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) message_review_handler_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filters the list to match the specified room name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Filters the list to match the specified room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of rooms to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of rooms to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Filters the list to match the specified message review handler URI.</p>
        pub fn message_review_handler_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_review_handler_uri = Some(input.into());
            self
        }
        /// <p>Filters the list to match the specified message review handler URI.</p>
        pub fn set_message_review_handler_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_review_handler_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoomsInput`](crate::input::ListRoomsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRoomsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRoomsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                message_review_handler_uri: self.message_review_handler_uri,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoomsInputOperationOutputAlias = crate::operation::ListRooms;
#[doc(hidden)]
pub type ListRoomsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoomsInput {
    /// Consumes the builder and constructs an Operation<[`ListRooms`](crate::operation::ListRooms)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRooms,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRoomsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListRooms").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRoomsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_rooms(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRooms::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRooms",
                    "ivschat",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRoomsInput`](crate::input::ListRoomsInput)
    pub fn builder() -> crate::input::list_rooms_input::Builder {
        crate::input::list_rooms_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.resource_arn;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`SendEventInput`](crate::input::SendEventInput)
pub mod send_event_input {
    /// A builder for [`SendEventInput`](crate::input::SendEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) room_identifier: std::option::Option<std::string::String>,
        pub(crate) event_name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.room_identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.room_identifier = input;
            self
        }
        /// <p>Application-defined name of the event to send to clients.</p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_name = Some(input.into());
            self
        }
        /// <p>Application-defined name of the event to send to clients.</p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEventInput`](crate::input::SendEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SendEventInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SendEventInput {
                room_identifier: self.room_identifier,
                event_name: self.event_name,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type SendEventInputOperationOutputAlias = crate::operation::SendEvent;
#[doc(hidden)]
pub type SendEventInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendEventInput {
    /// Consumes the builder and constructs an Operation<[`SendEvent`](crate::operation::SendEvent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendEvent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendEventInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/SendEvent").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendEventInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_event(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SendEvent::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SendEvent",
                    "ivschat",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendEventInput`](crate::input::SendEventInput)
    pub fn builder() -> crate::input::send_event_input::Builder {
        crate::input::send_event_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.resource_arn;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.resource_arn;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.tag_keys {
                    for inner_5 in inner_4 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateRoomInput`](crate::input::UpdateRoomInput)
pub mod update_room_input {
    /// A builder for [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) maximum_message_rate_per_second: std::option::Option<i32>,
        pub(crate) maximum_message_length: std::option::Option<i32>,
        pub(crate) message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
    }
    impl Builder {
        /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.maximum_message_rate_per_second = Some(input);
            self
        }
        /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_message_rate_per_second = input;
            self
        }
        /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.maximum_message_length = Some(input);
            self
        }
        /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_message_length = input;
            self
        }
        /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.message_review_handler = Some(input);
            self
        }
        /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.message_review_handler = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoomInput`](crate::input::UpdateRoomInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRoomInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRoomInput {
                identifier: self.identifier,
                name: self.name,
                maximum_message_rate_per_second: self
                    .maximum_message_rate_per_second
                    .unwrap_or_default(),
                maximum_message_length: self.maximum_message_length.unwrap_or_default(),
                message_review_handler: self.message_review_handler,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRoomInputOperationOutputAlias = crate::operation::UpdateRoom;
#[doc(hidden)]
pub type UpdateRoomInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRoomInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRoom`](crate::operation::UpdateRoom)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRoom,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRoomInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateRoom").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRoomInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_room(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRoom::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRoom",
            "ivschat",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRoomInput`](crate::input::UpdateRoomInput)
    pub fn builder() -> crate::input::update_room_input::Builder {
        crate::input::update_room_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoomInput {
    /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Room name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub maximum_message_rate_per_second: i32,
    /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub maximum_message_length: i32,
    /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
    pub message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
}
impl UpdateRoomInput {
    /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Room name. The value does not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub fn maximum_message_rate_per_second(&self) -> i32 {
        self.maximum_message_rate_per_second
    }
    /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub fn maximum_message_length(&self) -> i32 {
        self.maximum_message_length
    }
    /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
    pub fn message_review_handler(
        &self,
    ) -> std::option::Option<&crate::model::MessageReviewHandler> {
        self.message_review_handler.as_ref()
    }
}
impl std::fmt::Debug for UpdateRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoomInput");
        formatter.field("identifier", &self.identifier);
        formatter.field("name", &self.name);
        formatter.field(
            "maximum_message_rate_per_second",
            &self.maximum_message_rate_per_second,
        );
        formatter.field("maximum_message_length", &self.maximum_message_length);
        formatter.field("message_review_handler", &self.message_review_handler);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Array of tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Array of tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Array of tags to be added or updated.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Array of tags to be added or updated.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEventInput {
    /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
    pub room_identifier: std::option::Option<std::string::String>,
    /// <p>Application-defined name of the event to send to clients.</p>
    pub event_name: std::option::Option<std::string::String>,
    /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SendEventInput {
    /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
    pub fn room_identifier(&self) -> std::option::Option<&str> {
        self.room_identifier.as_deref()
    }
    /// <p>Application-defined name of the event to send to clients.</p>
    pub fn event_name(&self) -> std::option::Option<&str> {
        self.event_name.as_deref()
    }
    /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for SendEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEventInput");
        formatter.field("room_identifier", &self.room_identifier);
        formatter.field("event_name", &self.event_name);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoomsInput {
    /// <p>Filters the list to match the specified room name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of rooms to return. Default: 50.</p>
    pub max_results: i32,
    /// <p>Filters the list to match the specified message review handler URI.</p>
    pub message_review_handler_uri: std::option::Option<std::string::String>,
}
impl ListRoomsInput {
    /// <p>Filters the list to match the specified room name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of rooms to return. Default: 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Filters the list to match the specified message review handler URI.</p>
    pub fn message_review_handler_uri(&self) -> std::option::Option<&str> {
        self.message_review_handler_uri.as_deref()
    }
}
impl std::fmt::Debug for ListRoomsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoomsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field(
            "message_review_handler_uri",
            &self.message_review_handler_uri,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoomInput {
    /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
    pub identifier: std::option::Option<std::string::String>,
}
impl GetRoomInput {
    /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for GetRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoomInput");
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectUserInput {
    /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
    pub room_identifier: std::option::Option<std::string::String>,
    /// <p>ID of the user (connection) to disconnect from the room.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Reason for disconnecting the user.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl DisconnectUserInput {
    /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
    pub fn room_identifier(&self) -> std::option::Option<&str> {
        self.room_identifier.as_deref()
    }
    /// <p>ID of the user (connection) to disconnect from the room.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Reason for disconnecting the user.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for DisconnectUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectUserInput");
        formatter.field("room_identifier", &self.room_identifier);
        formatter.field("user_id", &self.user_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoomInput {
    /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
    pub identifier: std::option::Option<std::string::String>,
}
impl DeleteRoomInput {
    /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoomInput");
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageInput {
    /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
    pub room_identifier: std::option::Option<std::string::String>,
    /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Reason for deleting the message.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl DeleteMessageInput {
    /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
    pub fn room_identifier(&self) -> std::option::Option<&str> {
        self.room_identifier.as_deref()
    }
    /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Reason for deleting the message.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for DeleteMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageInput");
        formatter.field("room_identifier", &self.room_identifier);
        formatter.field("id", &self.id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoomInput {
    /// <p>Room name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub maximum_message_rate_per_second: i32,
    /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub maximum_message_length: i32,
    /// <p>Configuration information for optional review of messages.</p>
    pub message_review_handler: std::option::Option<crate::model::MessageReviewHandler>,
    /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRoomInput {
    /// <p>Room name. The value does not need to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    pub fn maximum_message_rate_per_second(&self) -> i32 {
        self.maximum_message_rate_per_second
    }
    /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    pub fn maximum_message_length(&self) -> i32 {
        self.maximum_message_length
    }
    /// <p>Configuration information for optional review of messages.</p>
    pub fn message_review_handler(
        &self,
    ) -> std::option::Option<&crate::model::MessageReviewHandler> {
        self.message_review_handler.as_ref()
    }
    /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRoomInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoomInput");
        formatter.field("name", &self.name);
        formatter.field(
            "maximum_message_rate_per_second",
            &self.maximum_message_rate_per_second,
        );
        formatter.field("maximum_message_length", &self.maximum_message_length);
        formatter.field("message_review_handler", &self.message_review_handler);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChatTokenInput {
    /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
    pub room_identifier: std::option::Option<std::string::String>,
    /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::ChatTokenCapability>>,
    /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
    pub session_duration_in_minutes: i32,
    /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateChatTokenInput {
    /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
    pub fn room_identifier(&self) -> std::option::Option<&str> {
        self.room_identifier.as_deref()
    }
    /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::ChatTokenCapability]> {
        self.capabilities.as_deref()
    }
    /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
    pub fn session_duration_in_minutes(&self) -> i32 {
        self.session_duration_in_minutes
    }
    /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for CreateChatTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChatTokenInput");
        formatter.field("room_identifier", &self.room_identifier);
        formatter.field("user_id", &self.user_id);
        formatter.field("capabilities", &self.capabilities);
        formatter.field(
            "session_duration_in_minutes",
            &self.session_duration_in_minutes,
        );
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
