// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Interactive Video Service Chat
///
/// Client for invoking operations on Amazon Interactive Video Service Chat. Each operation on Amazon Interactive Video Service Chat is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ivschat::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_ivschat::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_ivschat::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateChatToken`](crate::client::fluent_builders::CreateChatToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`room_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateChatToken::room_identifier) / [`set_room_identifier(Option<String>)`](crate::client::fluent_builders::CreateChatToken::set_room_identifier): <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::CreateChatToken::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::CreateChatToken::set_user_id): <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
    ///   - [`capabilities(Vec<ChatTokenCapability>)`](crate::client::fluent_builders::CreateChatToken::capabilities) / [`set_capabilities(Option<Vec<ChatTokenCapability>>)`](crate::client::fluent_builders::CreateChatToken::set_capabilities): <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
    ///   - [`session_duration_in_minutes(i32)`](crate::client::fluent_builders::CreateChatToken::session_duration_in_minutes) / [`set_session_duration_in_minutes(i32)`](crate::client::fluent_builders::CreateChatToken::set_session_duration_in_minutes): <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::CreateChatToken::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateChatToken::set_attributes): <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
    /// - On success, responds with [`CreateChatTokenOutput`](crate::output::CreateChatTokenOutput) with field(s):
    ///   - [`token(Option<String>)`](crate::output::CreateChatTokenOutput::token): <p>The issued client token, encrypted.</p>
    ///   - [`token_expiration_time(Option<DateTime>)`](crate::output::CreateChatTokenOutput::token_expiration_time): <p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`session_expiration_time(Option<DateTime>)`](crate::output::CreateChatTokenOutput::session_expiration_time): <p>Time after which an end user's session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    /// - On failure, responds with [`SdkError<CreateChatTokenError>`](crate::error::CreateChatTokenError)
    pub fn create_chat_token(&self) -> fluent_builders::CreateChatToken {
        fluent_builders::CreateChatToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoom`](crate::client::fluent_builders::CreateRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRoom::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRoom::set_name): <p>Room name. The value does not need to be unique.</p>
    ///   - [`maximum_message_rate_per_second(i32)`](crate::client::fluent_builders::CreateRoom::maximum_message_rate_per_second) / [`set_maximum_message_rate_per_second(i32)`](crate::client::fluent_builders::CreateRoom::set_maximum_message_rate_per_second): <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    ///   - [`maximum_message_length(i32)`](crate::client::fluent_builders::CreateRoom::maximum_message_length) / [`set_maximum_message_length(i32)`](crate::client::fluent_builders::CreateRoom::set_maximum_message_length): <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    ///   - [`message_review_handler(MessageReviewHandler)`](crate::client::fluent_builders::CreateRoom::message_review_handler) / [`set_message_review_handler(Option<MessageReviewHandler>)`](crate::client::fluent_builders::CreateRoom::set_message_review_handler): <p>Configuration information for optional review of messages.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRoom::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRoom::set_tags): <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
    /// - On success, responds with [`CreateRoomOutput`](crate::output::CreateRoomOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateRoomOutput::arn): <p>Room ARN, assigned by the system.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateRoomOutput::id): <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateRoomOutput::name): <p>Room name, from the request (if specified).</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateRoomOutput::create_time): <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::CreateRoomOutput::update_time): <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`maximum_message_rate_per_second(i32)`](crate::output::CreateRoomOutput::maximum_message_rate_per_second): <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    ///   - [`maximum_message_length(i32)`](crate::output::CreateRoomOutput::maximum_message_length): <p>Maximum number of characters in a single message, from the request.</p>
    ///   - [`message_review_handler(Option<MessageReviewHandler>)`](crate::output::CreateRoomOutput::message_review_handler): <p>Configuration information for optional review of messages.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRoomOutput::tags): <p>Tags attached to the resource, from the request.</p>
    /// - On failure, responds with [`SdkError<CreateRoomError>`](crate::error::CreateRoomError)
    pub fn create_room(&self) -> fluent_builders::CreateRoom {
        fluent_builders::CreateRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMessage`](crate::client::fluent_builders::DeleteMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`room_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteMessage::room_identifier) / [`set_room_identifier(Option<String>)`](crate::client::fluent_builders::DeleteMessage::set_room_identifier): <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteMessage::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteMessage::set_id): <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::DeleteMessage::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::DeleteMessage::set_reason): <p>Reason for deleting the message.</p>
    /// - On success, responds with [`DeleteMessageOutput`](crate::output::DeleteMessageOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::DeleteMessageOutput::id): <p>Operation identifier, generated by Amazon IVS Chat.</p>
    /// - On failure, responds with [`SdkError<DeleteMessageError>`](crate::error::DeleteMessageError)
    pub fn delete_message(&self) -> fluent_builders::DeleteMessage {
        fluent_builders::DeleteMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoom`](crate::client::fluent_builders::DeleteRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteRoom::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::DeleteRoom::set_identifier): <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
    /// - On success, responds with [`DeleteRoomOutput`](crate::output::DeleteRoomOutput)

    /// - On failure, responds with [`SdkError<DeleteRoomError>`](crate::error::DeleteRoomError)
    pub fn delete_room(&self) -> fluent_builders::DeleteRoom {
        fluent_builders::DeleteRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisconnectUser`](crate::client::fluent_builders::DisconnectUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`room_identifier(impl Into<String>)`](crate::client::fluent_builders::DisconnectUser::room_identifier) / [`set_room_identifier(Option<String>)`](crate::client::fluent_builders::DisconnectUser::set_room_identifier): <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DisconnectUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DisconnectUser::set_user_id): <p>ID of the user (connection) to disconnect from the room.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::DisconnectUser::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::DisconnectUser::set_reason): <p>Reason for disconnecting the user.</p>
    /// - On success, responds with [`DisconnectUserOutput`](crate::output::DisconnectUserOutput)

    /// - On failure, responds with [`SdkError<DisconnectUserError>`](crate::error::DisconnectUserError)
    pub fn disconnect_user(&self) -> fluent_builders::DisconnectUser {
        fluent_builders::DisconnectUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRoom`](crate::client::fluent_builders::GetRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetRoom::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetRoom::set_identifier): <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
    /// - On success, responds with [`GetRoomOutput`](crate::output::GetRoomOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetRoomOutput::arn): <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    ///   - [`id(Option<String>)`](crate::output::GetRoomOutput::id): <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    ///   - [`name(Option<String>)`](crate::output::GetRoomOutput::name): <p>Room name. The value does not need to be unique.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::GetRoomOutput::create_time): <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::GetRoomOutput::update_time): <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`maximum_message_rate_per_second(i32)`](crate::output::GetRoomOutput::maximum_message_rate_per_second): <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
    ///   - [`maximum_message_length(i32)`](crate::output::GetRoomOutput::maximum_message_length): <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    ///   - [`message_review_handler(Option<MessageReviewHandler>)`](crate::output::GetRoomOutput::message_review_handler): <p>Configuration information for optional review of messages.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRoomOutput::tags): <p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    /// - On failure, responds with [`SdkError<GetRoomError>`](crate::error::GetRoomError)
    pub fn get_room(&self) -> fluent_builders::GetRoom {
        fluent_builders::GetRoom::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRooms`](crate::client::fluent_builders::ListRooms) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRooms::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListRooms::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListRooms::set_name): <p>Filters the list to match the specified room name.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRooms::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRooms::set_next_token): <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRooms::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRooms::set_max_results): <p>Maximum number of rooms to return. Default: 50.</p>
    ///   - [`message_review_handler_uri(impl Into<String>)`](crate::client::fluent_builders::ListRooms::message_review_handler_uri) / [`set_message_review_handler_uri(Option<String>)`](crate::client::fluent_builders::ListRooms::set_message_review_handler_uri): <p>Filters the list to match the specified message review handler URI.</p>
    /// - On success, responds with [`ListRoomsOutput`](crate::output::ListRoomsOutput) with field(s):
    ///   - [`rooms(Option<Vec<RoomSummary>>)`](crate::output::ListRoomsOutput::rooms): <p>List of the matching rooms (summary information only).</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoomsOutput::next_token): <p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListRoomsError>`](crate::error::ListRoomsError)
    pub fn list_rooms(&self) -> fluent_builders::ListRooms {
        fluent_builders::ListRooms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendEvent`](crate::client::fluent_builders::SendEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`room_identifier(impl Into<String>)`](crate::client::fluent_builders::SendEvent::room_identifier) / [`set_room_identifier(Option<String>)`](crate::client::fluent_builders::SendEvent::set_room_identifier): <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
    ///   - [`event_name(impl Into<String>)`](crate::client::fluent_builders::SendEvent::event_name) / [`set_event_name(Option<String>)`](crate::client::fluent_builders::SendEvent::set_event_name): <p>Application-defined name of the event to send to clients.</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::SendEvent::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::SendEvent::set_attributes): <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
    /// - On success, responds with [`SendEventOutput`](crate::output::SendEventOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::SendEventOutput::id): <p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>
    /// - On failure, responds with [`SdkError<SendEventError>`](crate::error::SendEventError)
    pub fn send_event(&self) -> fluent_builders::SendEvent {
        fluent_builders::SendEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Array of tags to be added or updated.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Array of tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoom`](crate::client::fluent_builders::UpdateRoom) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::UpdateRoom::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::UpdateRoom::set_identifier): <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoom::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRoom::set_name): <p>Room name. The value does not need to be unique.</p>
    ///   - [`maximum_message_rate_per_second(i32)`](crate::client::fluent_builders::UpdateRoom::maximum_message_rate_per_second) / [`set_maximum_message_rate_per_second(i32)`](crate::client::fluent_builders::UpdateRoom::set_maximum_message_rate_per_second): <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
    ///   - [`maximum_message_length(i32)`](crate::client::fluent_builders::UpdateRoom::maximum_message_length) / [`set_maximum_message_length(i32)`](crate::client::fluent_builders::UpdateRoom::set_maximum_message_length): <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
    ///   - [`message_review_handler(MessageReviewHandler)`](crate::client::fluent_builders::UpdateRoom::message_review_handler) / [`set_message_review_handler(Option<MessageReviewHandler>)`](crate::client::fluent_builders::UpdateRoom::set_message_review_handler): <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
    /// - On success, responds with [`UpdateRoomOutput`](crate::output::UpdateRoomOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateRoomOutput::arn): <p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateRoomOutput::id): <p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateRoomOutput::name): <p>Room name, from the request.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::UpdateRoomOutput::create_time): <p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdateRoomOutput::update_time): <p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>
    ///   - [`maximum_message_rate_per_second(i32)`](crate::output::UpdateRoomOutput::maximum_message_rate_per_second): <p>Maximum number of messages per second that a client can send to the room, from the request.</p>
    ///   - [`maximum_message_length(i32)`](crate::output::UpdateRoomOutput::maximum_message_length): <p>Maximum number of characters in a single message, from the request.</p>
    ///   - [`message_review_handler(Option<MessageReviewHandler>)`](crate::output::UpdateRoomOutput::message_review_handler): <p>Configuration information for optional review of messages.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateRoomOutput::tags): <p>Tags attached to the resource.</p>
    /// - On failure, responds with [`SdkError<UpdateRoomError>`](crate::error::UpdateRoomError)
    pub fn update_room(&self) -> fluent_builders::UpdateRoom {
        fluent_builders::UpdateRoom::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateChatToken`.
    ///
    /// <p>Creates an encrypted token that is used to establish an individual WebSocket connection to a room. The token is valid for one minute, and a connection (session) established with the token is valid for the specified duration.</p>
    /// <p>Encryption keys are owned by Amazon IVS Chat and never used directly by your application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChatToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_chat_token_input::Builder,
    }
    impl CreateChatToken {
        /// Creates a new `CreateChatToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChatTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChatTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_identifier(input.into());
            self
        }
        /// <p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_room_identifier(input);
            self
        }
        /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
        pub fn capabilities(mut self, input: crate::model::ChatTokenCapability) -> Self {
            self.inner = self.inner.capabilities(input);
            self
        }
        /// <p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChatTokenCapability>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
        pub fn session_duration_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.session_duration_in_minutes(input);
            self
        }
        /// <p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>
        pub fn set_session_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_session_duration_in_minutes(input);
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoom`.
    ///
    /// <p>Creates a room that allows clients to connect and pass messages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoom {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_room_input::Builder,
    }
    impl CreateRoom {
        /// Creates a new `CreateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoomError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_message_rate_per_second(input);
            self
        }
        /// <p>Maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_message_rate_per_second(input);
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_message_length(input);
            self
        }
        /// <p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_message_length(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.inner = self.inner.message_review_handler(input);
            self
        }
        /// <p>Configuration information for optional review of messages.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.inner = self.inner.set_message_review_handler(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMessage`.
    ///
    /// <p>Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s <code>EventName</code> is <code>aws:DELETE_MESSAGE</code>. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html"> DeleteMessage</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_message_input::Builder,
    }
    impl DeleteMessage {
        /// Creates a new `DeleteMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_identifier(input.into());
            self
        }
        /// <p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_room_identifier(input);
            self
        }
        /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Reason for deleting the message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>Reason for deleting the message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoom`.
    ///
    /// <p>Deletes the specified room.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoom {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_room_input::Builder,
    }
    impl DeleteRoom {
        /// Creates a new `DeleteRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoomError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Identifier of the room to be deleted. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectUser`.
    ///
    /// <p>Disconnects all connections using a specified user ID from a room. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html"> DisconnectUser</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisconnectUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disconnect_user_input::Builder,
    }
    impl DisconnectUser {
        /// Creates a new `DisconnectUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_identifier(input.into());
            self
        }
        /// <p>Identifier of the room from which the user's clients should be disconnected. Currently this must be an ARN.</p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_room_identifier(input);
            self
        }
        /// <p>ID of the user (connection) to disconnect from the room.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>ID of the user (connection) to disconnect from the room.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>Reason for disconnecting the user.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>Reason for disconnecting the user.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRoom`.
    ///
    /// <p>Gets the specified room.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRoom {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_room_input::Builder,
    }
    impl GetRoom {
        /// Creates a new `GetRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoomError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRooms`.
    ///
    /// <p>Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of <code>updateTime</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRooms {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rooms_input::Builder,
    }
    impl ListRooms {
        /// Creates a new `ListRooms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoomsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoomsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoomsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoomsPaginator {
            crate::paginator::ListRoomsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the list to match the specified room name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Filters the list to match the specified room name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of rooms to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of rooms to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Filters the list to match the specified message review handler URI.</p>
        pub fn message_review_handler_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_review_handler_uri(input.into());
            self
        }
        /// <p>Filters the list to match the specified message review handler URI.</p>
        pub fn set_message_review_handler_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_message_review_handler_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about AWS tags for the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEvent`.
    ///
    /// <p>Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_event_input::Builder,
    }
    impl SendEvent {
        /// Creates a new `SendEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
        pub fn room_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.room_identifier(input.into());
            self
        }
        /// <p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>
        pub fn set_room_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_room_identifier(input);
            self
        }
        /// <p>Application-defined name of the event to send to clients.</p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_name(input.into());
            self
        }
        /// <p>Application-defined name of the event to send to clients.</p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_name(input);
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for the AWS resource with the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the resource with the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoom`.
    ///
    /// <p>Updates a room’s configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoom {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_room_input::Builder,
    }
    impl UpdateRoom {
        /// Creates a new `UpdateRoom`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoomOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoomError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Identifier of the room to be updated. Currently this must be an ARN.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Room name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn maximum_message_rate_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_message_rate_per_second(input);
            self
        }
        /// <p>The maximum number of messages per second that a client can send to the room. Default: 10.</p>
        pub fn set_maximum_message_rate_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_message_rate_per_second(input);
            self
        }
        /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn maximum_message_length(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_message_length(input);
            self
        }
        /// <p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>
        pub fn set_maximum_message_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_message_length(input);
            self
        }
        /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
        pub fn message_review_handler(mut self, input: crate::model::MessageReviewHandler) -> Self {
            self.inner = self.inner.message_review_handler(input);
            self
        }
        /// <p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>
        pub fn set_message_review_handler(
            mut self,
            input: std::option::Option<crate::model::MessageReviewHandler>,
        ) -> Self {
            self.inner = self.inner.set_message_review_handler(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
