// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Interactive Video Service
///
/// Client for invoking operations on Amazon Interactive Video Service. Each operation on Amazon Interactive Video Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ivs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ivs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ivs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`BatchGetChannel`](crate::client::fluent_builders::BatchGetChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::BatchGetChannel::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetChannel::set_arns): <p>Array of ARNs, one per channel.</p>
    /// - On success, responds with [`BatchGetChannelOutput`](crate::output::BatchGetChannelOutput) with field(s):
    ///   - [`channels(Option<Vec<Channel>>)`](crate::output::BatchGetChannelOutput::channels): <p></p>
    ///   - [`errors(Option<Vec<BatchError>>)`](crate::output::BatchGetChannelOutput::errors): <p>Each error object is related to a specific ARN in the request.</p>
    /// - On failure, responds with [`SdkError<BatchGetChannelError>`](crate::error::BatchGetChannelError)
    pub fn batch_get_channel(&self) -> fluent_builders::BatchGetChannel<C, M, R> {
        fluent_builders::BatchGetChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetStreamKey`](crate::client::fluent_builders::BatchGetStreamKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::BatchGetStreamKey::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetStreamKey::set_arns): <p>Array of ARNs, one per channel.</p>
    /// - On success, responds with [`BatchGetStreamKeyOutput`](crate::output::BatchGetStreamKeyOutput) with field(s):
    ///   - [`stream_keys(Option<Vec<StreamKey>>)`](crate::output::BatchGetStreamKeyOutput::stream_keys): <p></p>
    ///   - [`errors(Option<Vec<BatchError>>)`](crate::output::BatchGetStreamKeyOutput::errors): <p></p>
    /// - On failure, responds with [`SdkError<BatchGetStreamKeyError>`](crate::error::BatchGetStreamKeyError)
    pub fn batch_get_stream_key(&self) -> fluent_builders::BatchGetStreamKey<C, M, R> {
        fluent_builders::BatchGetStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannel`](crate::client::fluent_builders::CreateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_name): <p>Channel name.</p>
    ///   - [`latency_mode(ChannelLatencyMode)`](crate::client::fluent_builders::CreateChannel::latency_mode) / [`set_latency_mode(Option<ChannelLatencyMode>)`](crate::client::fluent_builders::CreateChannel::set_latency_mode): <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.</p>
    ///   - [`r#type(ChannelType)`](crate::client::fluent_builders::CreateChannel::r#type) / [`set_type(Option<ChannelType>)`](crate::client::fluent_builders::CreateChannel::set_type): <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>  <ul>   <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>   <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>  </ul>
    ///   - [`authorized(bool)`](crate::client::fluent_builders::CreateChannel::authorized) / [`set_authorized(bool)`](crate::client::fluent_builders::CreateChannel::set_authorized): <p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>
    ///   - [`recording_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::recording_configuration_arn) / [`set_recording_configuration_arn(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_recording_configuration_arn): <p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateChannel::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateChannel::set_tags): <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    /// - On success, responds with [`CreateChannelOutput`](crate::output::CreateChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::CreateChannelOutput::channel): <p></p>
    ///   - [`stream_key(Option<StreamKey>)`](crate::output::CreateChannelOutput::stream_key): <p></p>
    /// - On failure, responds with [`SdkError<CreateChannelError>`](crate::error::CreateChannelError)
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecordingConfiguration`](crate::client::fluent_builders::CreateRecordingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRecordingConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRecordingConfiguration::set_name): <p>Recording-configuration name. The value does not need to be unique.</p>
    ///   - [`destination_configuration(DestinationConfiguration)`](crate::client::fluent_builders::CreateRecordingConfiguration::destination_configuration) / [`set_destination_configuration(Option<DestinationConfiguration>)`](crate::client::fluent_builders::CreateRecordingConfiguration::set_destination_configuration): <p>A complex type that contains a destination configuration for where recorded video will be stored.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecordingConfiguration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecordingConfiguration::set_tags): <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    ///   - [`thumbnail_configuration(ThumbnailConfiguration)`](crate::client::fluent_builders::CreateRecordingConfiguration::thumbnail_configuration) / [`set_thumbnail_configuration(Option<ThumbnailConfiguration>)`](crate::client::fluent_builders::CreateRecordingConfiguration::set_thumbnail_configuration): <p>A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.</p>
    /// - On success, responds with [`CreateRecordingConfigurationOutput`](crate::output::CreateRecordingConfigurationOutput) with field(s):
    ///   - [`recording_configuration(Option<RecordingConfiguration>)`](crate::output::CreateRecordingConfigurationOutput::recording_configuration): (undocumented)
    /// - On failure, responds with [`SdkError<CreateRecordingConfigurationError>`](crate::error::CreateRecordingConfigurationError)
    pub fn create_recording_configuration(
        &self,
    ) -> fluent_builders::CreateRecordingConfiguration<C, M, R> {
        fluent_builders::CreateRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamKey`](crate::client::fluent_builders::CreateStreamKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStreamKey::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::CreateStreamKey::set_channel_arn): <p>ARN of the channel for which to create the stream key.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStreamKey::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStreamKey::set_tags): <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    /// - On success, responds with [`CreateStreamKeyOutput`](crate::output::CreateStreamKeyOutput) with field(s):
    ///   - [`stream_key(Option<StreamKey>)`](crate::output::CreateStreamKeyOutput::stream_key): <p>Stream key used to authenticate an RTMPS stream for ingestion.</p>
    /// - On failure, responds with [`SdkError<CreateStreamKeyError>`](crate::error::CreateStreamKeyError)
    pub fn create_stream_key(&self) -> fluent_builders::CreateStreamKey<C, M, R> {
        fluent_builders::CreateStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_arn): <p>ARN of the channel to be deleted.</p>
    /// - On success, responds with [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelError>`](crate::error::DeleteChannelError)
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePlaybackKeyPair`](crate::client::fluent_builders::DeletePlaybackKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeletePlaybackKeyPair::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeletePlaybackKeyPair::set_arn): <p>ARN of the key pair to be deleted.</p>
    /// - On success, responds with [`DeletePlaybackKeyPairOutput`](crate::output::DeletePlaybackKeyPairOutput)

    /// - On failure, responds with [`SdkError<DeletePlaybackKeyPairError>`](crate::error::DeletePlaybackKeyPairError)
    pub fn delete_playback_key_pair(&self) -> fluent_builders::DeletePlaybackKeyPair<C, M, R> {
        fluent_builders::DeletePlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecordingConfiguration`](crate::client::fluent_builders::DeleteRecordingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteRecordingConfiguration::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteRecordingConfiguration::set_arn): <p>ARN of the recording configuration to be deleted.</p>
    /// - On success, responds with [`DeleteRecordingConfigurationOutput`](crate::output::DeleteRecordingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteRecordingConfigurationError>`](crate::error::DeleteRecordingConfigurationError)
    pub fn delete_recording_configuration(
        &self,
    ) -> fluent_builders::DeleteRecordingConfiguration<C, M, R> {
        fluent_builders::DeleteRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStreamKey`](crate::client::fluent_builders::DeleteStreamKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamKey::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteStreamKey::set_arn): <p>ARN of the stream key to be deleted.</p>
    /// - On success, responds with [`DeleteStreamKeyOutput`](crate::output::DeleteStreamKeyOutput)

    /// - On failure, responds with [`SdkError<DeleteStreamKeyError>`](crate::error::DeleteStreamKeyError)
    pub fn delete_stream_key(&self) -> fluent_builders::DeleteStreamKey<C, M, R> {
        fluent_builders::DeleteStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChannel`](crate::client::fluent_builders::GetChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetChannel::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetChannel::set_arn): <p>ARN of the channel for which the configuration is to be retrieved.</p>
    /// - On success, responds with [`GetChannelOutput`](crate::output::GetChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::GetChannelOutput::channel): <p></p>
    /// - On failure, responds with [`SdkError<GetChannelError>`](crate::error::GetChannelError)
    pub fn get_channel(&self) -> fluent_builders::GetChannel<C, M, R> {
        fluent_builders::GetChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPlaybackKeyPair`](crate::client::fluent_builders::GetPlaybackKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetPlaybackKeyPair::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetPlaybackKeyPair::set_arn): <p>ARN of the key pair to be returned.</p>
    /// - On success, responds with [`GetPlaybackKeyPairOutput`](crate::output::GetPlaybackKeyPairOutput) with field(s):
    ///   - [`key_pair(Option<PlaybackKeyPair>)`](crate::output::GetPlaybackKeyPairOutput::key_pair): (undocumented)
    /// - On failure, responds with [`SdkError<GetPlaybackKeyPairError>`](crate::error::GetPlaybackKeyPairError)
    pub fn get_playback_key_pair(&self) -> fluent_builders::GetPlaybackKeyPair<C, M, R> {
        fluent_builders::GetPlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecordingConfiguration`](crate::client::fluent_builders::GetRecordingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetRecordingConfiguration::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetRecordingConfiguration::set_arn): <p>ARN of the recording configuration to be retrieved.</p>
    /// - On success, responds with [`GetRecordingConfigurationOutput`](crate::output::GetRecordingConfigurationOutput) with field(s):
    ///   - [`recording_configuration(Option<RecordingConfiguration>)`](crate::output::GetRecordingConfigurationOutput::recording_configuration): (undocumented)
    /// - On failure, responds with [`SdkError<GetRecordingConfigurationError>`](crate::error::GetRecordingConfigurationError)
    pub fn get_recording_configuration(
        &self,
    ) -> fluent_builders::GetRecordingConfiguration<C, M, R> {
        fluent_builders::GetRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStream`](crate::client::fluent_builders::GetStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetStream::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetStream::set_channel_arn): <p>Channel ARN for stream to be accessed.</p>
    /// - On success, responds with [`GetStreamOutput`](crate::output::GetStreamOutput) with field(s):
    ///   - [`stream(Option<Stream>)`](crate::output::GetStreamOutput::stream): <p></p>
    /// - On failure, responds with [`SdkError<GetStreamError>`](crate::error::GetStreamError)
    pub fn get_stream(&self) -> fluent_builders::GetStream<C, M, R> {
        fluent_builders::GetStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamKey`](crate::client::fluent_builders::GetStreamKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetStreamKey::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetStreamKey::set_arn): <p>ARN for the stream key to be retrieved.</p>
    /// - On success, responds with [`GetStreamKeyOutput`](crate::output::GetStreamKeyOutput) with field(s):
    ///   - [`stream_key(Option<StreamKey>)`](crate::output::GetStreamKeyOutput::stream_key): (undocumented)
    /// - On failure, responds with [`SdkError<GetStreamKeyError>`](crate::error::GetStreamKeyError)
    pub fn get_stream_key(&self) -> fluent_builders::GetStreamKey<C, M, R> {
        fluent_builders::GetStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamSession`](crate::client::fluent_builders::GetStreamSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::GetStreamSession::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::GetStreamSession::set_channel_arn): <p>ARN of the channel resource</p>
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::GetStreamSession::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::GetStreamSession::set_stream_id): <p>Unique identifier for a live or previously live stream in the specified channel. If no <code>streamId</code> is provided, this returns the most recent stream session for the channel, if it exists.</p>
    /// - On success, responds with [`GetStreamSessionOutput`](crate::output::GetStreamSessionOutput) with field(s):
    ///   - [`stream_session(Option<StreamSession>)`](crate::output::GetStreamSessionOutput::stream_session): <p>List of stream details.</p>
    /// - On failure, responds with [`SdkError<GetStreamSessionError>`](crate::error::GetStreamSessionError)
    pub fn get_stream_session(&self) -> fluent_builders::GetStreamSession<C, M, R> {
        fluent_builders::GetStreamSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportPlaybackKeyPair`](crate::client::fluent_builders::ImportPlaybackKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`public_key_material(impl Into<String>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::public_key_material) / [`set_public_key_material(Option<String>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::set_public_key_material): <p>The public portion of a customer-generated key pair.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::set_name): <p>Playback-key-pair name. The value does not need to be unique.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ImportPlaybackKeyPair::set_tags): <p>Any tags provided with the request are added to the playback key pair tags.</p>
    /// - On success, responds with [`ImportPlaybackKeyPairOutput`](crate::output::ImportPlaybackKeyPairOutput) with field(s):
    ///   - [`key_pair(Option<PlaybackKeyPair>)`](crate::output::ImportPlaybackKeyPairOutput::key_pair): <p></p>
    /// - On failure, responds with [`SdkError<ImportPlaybackKeyPairError>`](crate::error::ImportPlaybackKeyPairError)
    pub fn import_playback_key_pair(&self) -> fluent_builders::ImportPlaybackKeyPair<C, M, R> {
        fluent_builders::ImportPlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannels`](crate::client::fluent_builders::ListChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_by_name(impl Into<String>)`](crate::client::fluent_builders::ListChannels::filter_by_name) / [`set_filter_by_name(Option<String>)`](crate::client::fluent_builders::ListChannels::set_filter_by_name): <p>Filters the channel list to match the specified name.</p>
    ///   - [`filter_by_recording_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::ListChannels::filter_by_recording_configuration_arn) / [`set_filter_by_recording_configuration_arn(Option<String>)`](crate::client::fluent_builders::ListChannels::set_filter_by_recording_configuration_arn): <p>Filters the channel list to match the specified recording-configuration ARN.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannels::set_next_token): <p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannels::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListChannels::set_max_results): <p>Maximum number of channels to return. Default: 50.</p>
    /// - On success, responds with [`ListChannelsOutput`](crate::output::ListChannelsOutput) with field(s):
    ///   - [`channels(Option<Vec<ChannelSummary>>)`](crate::output::ListChannelsOutput::channels): <p>List of the matching channels.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsOutput::next_token): <p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListChannelsError>`](crate::error::ListChannelsError)
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPlaybackKeyPairs`](crate::client::fluent_builders::ListPlaybackKeyPairs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPlaybackKeyPairs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPlaybackKeyPairs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPlaybackKeyPairs::set_next_token): <p>Maximum number of key pairs to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPlaybackKeyPairs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPlaybackKeyPairs::set_max_results): <p>The first key pair to retrieve. This is used for pagination; see the <code>nextToken</code> response field. Default: 50.</p>
    /// - On success, responds with [`ListPlaybackKeyPairsOutput`](crate::output::ListPlaybackKeyPairsOutput) with field(s):
    ///   - [`key_pairs(Option<Vec<PlaybackKeyPairSummary>>)`](crate::output::ListPlaybackKeyPairsOutput::key_pairs): <p>List of key pairs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPlaybackKeyPairsOutput::next_token): <p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListPlaybackKeyPairsError>`](crate::error::ListPlaybackKeyPairsError)
    pub fn list_playback_key_pairs(&self) -> fluent_builders::ListPlaybackKeyPairs<C, M, R> {
        fluent_builders::ListPlaybackKeyPairs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecordingConfigurations`](crate::client::fluent_builders::ListRecordingConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecordingConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecordingConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecordingConfigurations::set_next_token): <p>The first recording configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecordingConfigurations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRecordingConfigurations::set_max_results): <p>Maximum number of recording configurations to return. Default: 50. </p>
    /// - On success, responds with [`ListRecordingConfigurationsOutput`](crate::output::ListRecordingConfigurationsOutput) with field(s):
    ///   - [`recording_configurations(Option<Vec<RecordingConfigurationSummary>>)`](crate::output::ListRecordingConfigurationsOutput::recording_configurations): <p>List of the matching recording configurations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRecordingConfigurationsOutput::next_token): <p>If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListRecordingConfigurationsError>`](crate::error::ListRecordingConfigurationsError)
    pub fn list_recording_configurations(
        &self,
    ) -> fluent_builders::ListRecordingConfigurations<C, M, R> {
        fluent_builders::ListRecordingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamKeys`](crate::client::fluent_builders::ListStreamKeys) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamKeys::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListStreamKeys::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListStreamKeys::set_channel_arn): <p>Channel ARN used to filter the list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreamKeys::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreamKeys::set_next_token): <p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreamKeys::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStreamKeys::set_max_results): <p>Maximum number of streamKeys to return. Default: 50.</p>
    /// - On success, responds with [`ListStreamKeysOutput`](crate::output::ListStreamKeysOutput) with field(s):
    ///   - [`stream_keys(Option<Vec<StreamKeySummary>>)`](crate::output::ListStreamKeysOutput::stream_keys): <p>List of stream keys.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamKeysOutput::next_token): <p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListStreamKeysError>`](crate::error::ListStreamKeysError)
    pub fn list_stream_keys(&self) -> fluent_builders::ListStreamKeys<C, M, R> {
        fluent_builders::ListStreamKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreams`](crate::client::fluent_builders::ListStreams) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreams::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_by(StreamFilters)`](crate::client::fluent_builders::ListStreams::filter_by) / [`set_filter_by(Option<StreamFilters>)`](crate::client::fluent_builders::ListStreams::set_filter_by): <p>Filters the stream list to match the specified criterion.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreams::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreams::set_next_token): <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreams::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStreams::set_max_results): <p>Maximum number of streams to return. Default: 50.</p>
    /// - On success, responds with [`ListStreamsOutput`](crate::output::ListStreamsOutput) with field(s):
    ///   - [`streams(Option<Vec<StreamSummary>>)`](crate::output::ListStreamsOutput::streams): <p>List of streams.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamsOutput::next_token): <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListStreamsError>`](crate::error::ListStreamsError)
    pub fn list_streams(&self) -> fluent_builders::ListStreams<C, M, R> {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamSessions`](crate::client::fluent_builders::ListStreamSessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamSessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::ListStreamSessions::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::ListStreamSessions::set_channel_arn): <p>Channel ARN used to filter the list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreamSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreamSessions::set_next_token): <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreamSessions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStreamSessions::set_max_results): <p>Maximum number of streams to return. Default: 50.</p>
    /// - On success, responds with [`ListStreamSessionsOutput`](crate::output::ListStreamSessionsOutput) with field(s):
    ///   - [`stream_sessions(Option<Vec<StreamSessionSummary>>)`](crate::output::ListStreamSessionsOutput::stream_sessions): <p>List of stream sessions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamSessionsOutput::next_token): <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>
    /// - On failure, responds with [`SdkError<ListStreamSessionsError>`](crate::error::ListStreamSessionsError)
    pub fn list_stream_sessions(&self) -> fluent_builders::ListStreamSessions<C, M, R> {
        fluent_builders::ListStreamSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource to be retrieved.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p></p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMetadata`](crate::client::fluent_builders::PutMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::PutMetadata::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::PutMetadata::set_channel_arn): <p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>
    ///   - [`metadata(impl Into<String>)`](crate::client::fluent_builders::PutMetadata::metadata) / [`set_metadata(Option<String>)`](crate::client::fluent_builders::PutMetadata::set_metadata): <p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>
    /// - On success, responds with [`PutMetadataOutput`](crate::output::PutMetadataOutput)

    /// - On failure, responds with [`SdkError<PutMetadataError>`](crate::error::PutMetadataError)
    pub fn put_metadata(&self) -> fluent_builders::PutMetadata<C, M, R> {
        fluent_builders::PutMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopStream`](crate::client::fluent_builders::StopStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_arn(impl Into<String>)`](crate::client::fluent_builders::StopStream::channel_arn) / [`set_channel_arn(Option<String>)`](crate::client::fluent_builders::StopStream::set_channel_arn): <p>ARN of the channel for which the stream is to be stopped.</p>
    /// - On success, responds with [`StopStreamOutput`](crate::output::StopStreamOutput)

    /// - On failure, responds with [`SdkError<StopStreamError>`](crate::error::StopStreamError)
    pub fn stop_stream(&self) -> fluent_builders::StopStream<C, M, R> {
        fluent_builders::StopStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>ARN of the resource for which tags are to be added or updated.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Array of tags to be added or updated.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>ARN of the resource for which tags are to be removed.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Array of tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_arn): <p>ARN of the channel to be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_name): <p>Channel name.</p>
    ///   - [`latency_mode(ChannelLatencyMode)`](crate::client::fluent_builders::UpdateChannel::latency_mode) / [`set_latency_mode(Option<ChannelLatencyMode>)`](crate::client::fluent_builders::UpdateChannel::set_latency_mode): <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>
    ///   - [`r#type(ChannelType)`](crate::client::fluent_builders::UpdateChannel::r#type) / [`set_type(Option<ChannelType>)`](crate::client::fluent_builders::UpdateChannel::set_type): <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately</i>. Valid values:</p>  <ul>   <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>   <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>  </ul>
    ///   - [`authorized(bool)`](crate::client::fluent_builders::UpdateChannel::authorized) / [`set_authorized(bool)`](crate::client::fluent_builders::UpdateChannel::set_authorized): <p>Whether the channel is private (enabled for playback authorization).</p>
    ///   - [`recording_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::recording_configuration_arn) / [`set_recording_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_recording_configuration_arn): <p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled</p>
    /// - On success, responds with [`UpdateChannelOutput`](crate::output::UpdateChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::UpdateChannelOutput::channel): <p>Object specifying a channel.</p>
    /// - On failure, responds with [`SdkError<UpdateChannelError>`](crate::error::UpdateChannelError)
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetChannel`.
    ///
    /// <p>Performs <code>GetChannel</code> on multiple ARNs simultaneously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_channel_input::Builder,
    }
    impl<C, M, R> BatchGetChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetChannelInputOperationOutputAlias,
                crate::output::BatchGetChannelOutput,
                crate::error::BatchGetChannelError,
                crate::input::BatchGetChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>Array of ARNs, one per channel.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>Array of ARNs, one per channel.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetStreamKey`.
    ///
    /// <p>Performs <code>GetStreamKey</code> on multiple ARNs simultaneously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_stream_key_input::Builder,
    }
    impl<C, M, R> BatchGetStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetStreamKeyInputOperationOutputAlias,
                crate::output::BatchGetStreamKeyOutput,
                crate::error::BatchGetStreamKeyError,
                crate::input::BatchGetStreamKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>Array of ARNs, one per channel.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>Array of ARNs, one per channel.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a new channel and an associated stream key to start streaming.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.</p>
        pub fn latency_mode(mut self, input: crate::model::ChannelLatencyMode) -> Self {
            self.inner = self.inner.latency_mode(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.inner = self.inner.set_latency_mode(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>
        /// <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>
        /// <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>
        pub fn authorized(mut self, input: bool) -> Self {
            self.inner = self.inner.authorized(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_authorized(input);
            self
        }
        /// <p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>
        pub fn recording_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recording_configuration_arn(input.into());
            self
        }
        /// <p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recording_configuration_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecordingConfiguration`.
    ///
    /// <p>Creates a new recording configuration, used to enable recording to Amazon S3.</p>
    /// <p> <b>Known issue:</b> In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the <code>state</code> of the recording configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)</p>
    /// <p> <b>Workaround:</b> Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recording_configuration_input::Builder,
    }
    impl<C, M, R> CreateRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecordingConfigurationInputOperationOutputAlias,
                crate::output::CreateRecordingConfigurationOutput,
                crate::error::CreateRecordingConfigurationError,
                crate::input::CreateRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A complex type that contains a destination configuration for where recorded video will be stored.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::DestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.destination_configuration(input);
            self
        }
        /// <p>A complex type that contains a destination configuration for where recorded video will be stored.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::DestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_destination_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.</p>
        pub fn thumbnail_configuration(
            mut self,
            input: crate::model::ThumbnailConfiguration,
        ) -> Self {
            self.inner = self.inner.thumbnail_configuration(input);
            self
        }
        /// <p>A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.</p>
        pub fn set_thumbnail_configuration(
            mut self,
            input: std::option::Option<crate::model::ThumbnailConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_thumbnail_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamKey`.
    ///
    /// <p>Creates a stream key, used to initiate a stream, for the specified channel ARN.</p>
    /// <p>Note that <code>CreateChannel</code> creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use <code>DeleteStreamKey</code> and then CreateStreamKey.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stream_key_input::Builder,
    }
    impl<C, M, R> CreateStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamKeyInputOperationOutputAlias,
                crate::output::CreateStreamKeyOutput,
                crate::error::CreateStreamKeyError,
                crate::input::CreateStreamKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which to create the stream key.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>ARN of the channel for which to create the stream key.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Deletes the specified channel and its associated stream keys.</p>
    /// <p>If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call <code>StopStream</code>, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.) </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the channel to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlaybackKeyPair`.
    ///
    /// <p>Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s <code>privateKey</code>. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_playback_key_pair_input::Builder,
    }
    impl<C, M, R> DeletePlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePlaybackKeyPairInputOperationOutputAlias,
                crate::output::DeletePlaybackKeyPairOutput,
                crate::error::DeletePlaybackKeyPairError,
                crate::input::DeletePlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the key pair to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the key pair to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecordingConfiguration`.
    ///
    /// <p>Deletes the recording configuration for the specified ARN.</p>
    /// <p>If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use <code>UpdateChannel</code> to set the <code>recordingConfigurationArn</code> field to an empty string, then use DeleteRecordingConfiguration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recording_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecordingConfigurationInputOperationOutputAlias,
                crate::output::DeleteRecordingConfigurationOutput,
                crate::error::DeleteRecordingConfigurationError,
                crate::input::DeleteRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the recording configuration to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the recording configuration to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamKey`.
    ///
    /// <p>Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stream_key_input::Builder,
    }
    impl<C, M, R> DeleteStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamKeyInputOperationOutputAlias,
                crate::output::DeleteStreamKeyOutput,
                crate::error::DeleteStreamKeyError,
                crate::input::DeleteStreamKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the stream key to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the stream key to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannel`.
    ///
    /// <p>Gets the channel configuration for the specified channel ARN. See also <code>BatchGetChannel</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_input::Builder,
    }
    impl<C, M, R> GetChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelInputOperationOutputAlias,
                crate::output::GetChannelOutput,
                crate::error::GetChannelError,
                crate::input::GetChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which the configuration is to be retrieved.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the channel for which the configuration is to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPlaybackKeyPair`.
    ///
    /// <p>Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_playback_key_pair_input::Builder,
    }
    impl<C, M, R> GetPlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPlaybackKeyPairInputOperationOutputAlias,
                crate::output::GetPlaybackKeyPairOutput,
                crate::error::GetPlaybackKeyPairError,
                crate::input::GetPlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the key pair to be returned.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the key pair to be returned.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecordingConfiguration`.
    ///
    /// <p>Gets the recording configuration for the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recording_configuration_input::Builder,
    }
    impl<C, M, R> GetRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecordingConfigurationInputOperationOutputAlias,
                crate::output::GetRecordingConfigurationOutput,
                crate::error::GetRecordingConfigurationError,
                crate::input::GetRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the recording configuration to be retrieved.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the recording configuration to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStream`.
    ///
    /// <p>Gets information about the active (live) stream on a specified channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_input::Builder,
    }
    impl<C, M, R> GetStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamInputOperationOutputAlias,
                crate::output::GetStreamOutput,
                crate::error::GetStreamError,
                crate::input::GetStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel ARN for stream to be accessed.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>Channel ARN for stream to be accessed.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamKey`.
    ///
    /// <p>Gets stream-key information for a specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_key_input::Builder,
    }
    impl<C, M, R> GetStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamKeyInputOperationOutputAlias,
                crate::output::GetStreamKeyOutput,
                crate::error::GetStreamKeyError,
                crate::input::GetStreamKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN for the stream key to be retrieved.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN for the stream key to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamSession`.
    ///
    /// <p>Gets metadata on a specified stream.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_session_input::Builder,
    }
    impl<C, M, R> GetStreamSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamSessionInputOperationOutputAlias,
                crate::output::GetStreamSessionOutput,
                crate::error::GetStreamSessionError,
                crate::input::GetStreamSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel resource</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>ARN of the channel resource</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>Unique identifier for a live or previously live stream in the specified channel. If no <code>streamId</code> is provided, this returns the most recent stream session for the channel, if it exists.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>Unique identifier for a live or previously live stream in the specified channel. If no <code>streamId</code> is provided, this returns the most recent stream session for the channel, if it exists.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportPlaybackKeyPair`.
    ///
    /// <p>Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportPlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_playback_key_pair_input::Builder,
    }
    impl<C, M, R> ImportPlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportPlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportPlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportPlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportPlaybackKeyPairInputOperationOutputAlias,
                crate::output::ImportPlaybackKeyPairOutput,
                crate::error::ImportPlaybackKeyPairError,
                crate::input::ImportPlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The public portion of a customer-generated key pair.</p>
        pub fn public_key_material(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_key_material(input.into());
            self
        }
        /// <p>The public portion of a customer-generated key pair.</p>
        pub fn set_public_key_material(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_key_material(input);
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Any tags provided with the request are added to the playback key pair tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Any tags provided with the request are added to the playback key pair tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelsPaginator<C, M, R> {
            crate::paginator::ListChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the channel list to match the specified name.</p>
        pub fn filter_by_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_by_name(input.into());
            self
        }
        /// <p>Filters the channel list to match the specified name.</p>
        pub fn set_filter_by_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_by_name(input);
            self
        }
        /// <p>Filters the channel list to match the specified recording-configuration ARN.</p>
        pub fn filter_by_recording_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .filter_by_recording_configuration_arn(input.into());
            self
        }
        /// <p>Filters the channel list to match the specified recording-configuration ARN.</p>
        pub fn set_filter_by_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_by_recording_configuration_arn(input);
            self
        }
        /// <p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of channels to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of channels to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlaybackKeyPairs`.
    ///
    /// <p>Gets summary information about playback key pairs. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPlaybackKeyPairs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_playback_key_pairs_input::Builder,
    }
    impl<C, M, R> ListPlaybackKeyPairs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPlaybackKeyPairs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlaybackKeyPairsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlaybackKeyPairsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPlaybackKeyPairsInputOperationOutputAlias,
                crate::output::ListPlaybackKeyPairsOutput,
                crate::error::ListPlaybackKeyPairsError,
                crate::input::ListPlaybackKeyPairsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPlaybackKeyPairsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPlaybackKeyPairsPaginator<C, M, R> {
            crate::paginator::ListPlaybackKeyPairsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of key pairs to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Maximum number of key pairs to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The first key pair to retrieve. This is used for pagination; see the <code>nextToken</code> response field. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The first key pair to retrieve. This is used for pagination; see the <code>nextToken</code> response field. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecordingConfigurations`.
    ///
    /// <p>Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecordingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recording_configurations_input::Builder,
    }
    impl<C, M, R> ListRecordingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecordingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordingConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecordingConfigurationsInputOperationOutputAlias,
                crate::output::ListRecordingConfigurationsOutput,
                crate::error::ListRecordingConfigurationsError,
                crate::input::ListRecordingConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecordingConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRecordingConfigurationsPaginator<C, M, R> {
            crate::paginator::ListRecordingConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The first recording configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first recording configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of recording configurations to return. Default: 50. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of recording configurations to return. Default: 50. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamKeys`.
    ///
    /// <p>Gets summary information about stream keys for the specified channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stream_keys_input::Builder,
    }
    impl<C, M, R> ListStreamKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamKeysInputOperationOutputAlias,
                crate::output::ListStreamKeysOutput,
                crate::error::ListStreamKeysError,
                crate::input::ListStreamKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamKeysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamKeysPaginator<C, M, R> {
            crate::paginator::ListStreamKeysPaginator::new(self.handle, self.inner)
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streamKeys to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of streamKeys to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl<C, M, R> ListStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamsInputOperationOutputAlias,
                crate::output::ListStreamsOutput,
                crate::error::ListStreamsError,
                crate::input::ListStreamsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamsPaginator<C, M, R> {
            crate::paginator::ListStreamsPaginator::new(self.handle, self.inner)
        }
        /// <p>Filters the stream list to match the specified criterion.</p>
        pub fn filter_by(mut self, input: crate::model::StreamFilters) -> Self {
            self.inner = self.inner.filter_by(input);
            self
        }
        /// <p>Filters the stream list to match the specified criterion.</p>
        pub fn set_filter_by(
            mut self,
            input: std::option::Option<crate::model::StreamFilters>,
        ) -> Self {
            self.inner = self.inner.set_filter_by(input);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamSessions`.
    ///
    /// <p>Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stream_sessions_input::Builder,
    }
    impl<C, M, R> ListStreamSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamSessionsInputOperationOutputAlias,
                crate::output::ListStreamSessionsOutput,
                crate::error::ListStreamSessionsError,
                crate::input::ListStreamSessionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamSessionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamSessionsPaginator<C, M, R> {
            crate::paginator::ListStreamSessionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about Amazon Web Services tags for the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to be retrieved.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to be retrieved.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMetadata`.
    ///
    /// <p>Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video Stream</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_metadata_input::Builder,
    }
    impl<C, M, R> PutMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMetadataInputOperationOutputAlias,
                crate::output::PutMetadataOutput,
                crate::error::PutMetadataError,
                crate::input::PutMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(input.into());
            self
        }
        /// <p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStream`.
    ///
    /// <p>Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <code>DeleteStreamKey</code> to prevent further streaming to a channel.</p> <note>
    /// <p>Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_stream_input::Builder,
    }
    impl<C, M, R> StopStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopStreamInputOperationOutputAlias,
                crate::output::StopStreamOutput,
                crate::error::StopStreamError,
                crate::input::StopStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which the stream is to be stopped.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(input.into());
            self
        }
        /// <p>ARN of the channel for which the stream is to be stopped.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the resource with the specified ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel to be updated.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>ARN of the channel to be updated.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>
        pub fn latency_mode(mut self, input: crate::model::ChannelLatencyMode) -> Self {
            self.inner = self.inner.latency_mode(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.inner = self.inner.set_latency_mode(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately</i>. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>
        /// <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately</i>. Valid values:</p>
        /// <ul>
        /// <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li>
        /// <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization).</p>
        pub fn authorized(mut self, input: bool) -> Self {
            self.inner = self.inner.authorized(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization).</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_authorized(input);
            self
        }
        /// <p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled</p>
        pub fn recording_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recording_configuration_arn(input.into());
            self
        }
        /// <p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recording_configuration_arn(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
