// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonInteractiveVideoService`.
///
/// This client allows ergonomic access to a `AmazonInteractiveVideoService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchGetChannel` operation.
    ///
    /// See [`BatchGetChannel`](crate::client::fluent_builders::BatchGetChannel) for more information about the
    /// operation and its arguments.
    pub fn batch_get_channel(&self) -> fluent_builders::BatchGetChannel<C, M, R> {
        fluent_builders::BatchGetChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetStreamKey` operation.
    ///
    /// See [`BatchGetStreamKey`](crate::client::fluent_builders::BatchGetStreamKey) for more information about the
    /// operation and its arguments.
    pub fn batch_get_stream_key(&self) -> fluent_builders::BatchGetStreamKey<C, M, R> {
        fluent_builders::BatchGetStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecordingConfiguration` operation.
    ///
    /// See [`CreateRecordingConfiguration`](crate::client::fluent_builders::CreateRecordingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_recording_configuration(
        &self,
    ) -> fluent_builders::CreateRecordingConfiguration<C, M, R> {
        fluent_builders::CreateRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamKey` operation.
    ///
    /// See [`CreateStreamKey`](crate::client::fluent_builders::CreateStreamKey) for more information about the
    /// operation and its arguments.
    pub fn create_stream_key(&self) -> fluent_builders::CreateStreamKey<C, M, R> {
        fluent_builders::CreateStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePlaybackKeyPair` operation.
    ///
    /// See [`DeletePlaybackKeyPair`](crate::client::fluent_builders::DeletePlaybackKeyPair) for more information about the
    /// operation and its arguments.
    pub fn delete_playback_key_pair(&self) -> fluent_builders::DeletePlaybackKeyPair<C, M, R> {
        fluent_builders::DeletePlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecordingConfiguration` operation.
    ///
    /// See [`DeleteRecordingConfiguration`](crate::client::fluent_builders::DeleteRecordingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_recording_configuration(
        &self,
    ) -> fluent_builders::DeleteRecordingConfiguration<C, M, R> {
        fluent_builders::DeleteRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStreamKey` operation.
    ///
    /// See [`DeleteStreamKey`](crate::client::fluent_builders::DeleteStreamKey) for more information about the
    /// operation and its arguments.
    pub fn delete_stream_key(&self) -> fluent_builders::DeleteStreamKey<C, M, R> {
        fluent_builders::DeleteStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChannel` operation.
    ///
    /// See [`GetChannel`](crate::client::fluent_builders::GetChannel) for more information about the
    /// operation and its arguments.
    pub fn get_channel(&self) -> fluent_builders::GetChannel<C, M, R> {
        fluent_builders::GetChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPlaybackKeyPair` operation.
    ///
    /// See [`GetPlaybackKeyPair`](crate::client::fluent_builders::GetPlaybackKeyPair) for more information about the
    /// operation and its arguments.
    pub fn get_playback_key_pair(&self) -> fluent_builders::GetPlaybackKeyPair<C, M, R> {
        fluent_builders::GetPlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecordingConfiguration` operation.
    ///
    /// See [`GetRecordingConfiguration`](crate::client::fluent_builders::GetRecordingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_recording_configuration(
        &self,
    ) -> fluent_builders::GetRecordingConfiguration<C, M, R> {
        fluent_builders::GetRecordingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStream` operation.
    ///
    /// See [`GetStream`](crate::client::fluent_builders::GetStream) for more information about the
    /// operation and its arguments.
    pub fn get_stream(&self) -> fluent_builders::GetStream<C, M, R> {
        fluent_builders::GetStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamKey` operation.
    ///
    /// See [`GetStreamKey`](crate::client::fluent_builders::GetStreamKey) for more information about the
    /// operation and its arguments.
    pub fn get_stream_key(&self) -> fluent_builders::GetStreamKey<C, M, R> {
        fluent_builders::GetStreamKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamSession` operation.
    ///
    /// See [`GetStreamSession`](crate::client::fluent_builders::GetStreamSession) for more information about the
    /// operation and its arguments.
    pub fn get_stream_session(&self) -> fluent_builders::GetStreamSession<C, M, R> {
        fluent_builders::GetStreamSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportPlaybackKeyPair` operation.
    ///
    /// See [`ImportPlaybackKeyPair`](crate::client::fluent_builders::ImportPlaybackKeyPair) for more information about the
    /// operation and its arguments.
    pub fn import_playback_key_pair(&self) -> fluent_builders::ImportPlaybackKeyPair<C, M, R> {
        fluent_builders::ImportPlaybackKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPlaybackKeyPairs` operation.
    ///
    /// See [`ListPlaybackKeyPairs`](crate::client::fluent_builders::ListPlaybackKeyPairs) for more information about the
    /// operation and its arguments.
    pub fn list_playback_key_pairs(&self) -> fluent_builders::ListPlaybackKeyPairs<C, M, R> {
        fluent_builders::ListPlaybackKeyPairs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecordingConfigurations` operation.
    ///
    /// See [`ListRecordingConfigurations`](crate::client::fluent_builders::ListRecordingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_recording_configurations(
        &self,
    ) -> fluent_builders::ListRecordingConfigurations<C, M, R> {
        fluent_builders::ListRecordingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamKeys` operation.
    ///
    /// See [`ListStreamKeys`](crate::client::fluent_builders::ListStreamKeys) for more information about the
    /// operation and its arguments.
    pub fn list_stream_keys(&self) -> fluent_builders::ListStreamKeys<C, M, R> {
        fluent_builders::ListStreamKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreams` operation.
    ///
    /// See [`ListStreams`](crate::client::fluent_builders::ListStreams) for more information about the
    /// operation and its arguments.
    pub fn list_streams(&self) -> fluent_builders::ListStreams<C, M, R> {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamSessions` operation.
    ///
    /// See [`ListStreamSessions`](crate::client::fluent_builders::ListStreamSessions) for more information about the
    /// operation and its arguments.
    pub fn list_stream_sessions(&self) -> fluent_builders::ListStreamSessions<C, M, R> {
        fluent_builders::ListStreamSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMetadata` operation.
    ///
    /// See [`PutMetadata`](crate::client::fluent_builders::PutMetadata) for more information about the
    /// operation and its arguments.
    pub fn put_metadata(&self) -> fluent_builders::PutMetadata<C, M, R> {
        fluent_builders::PutMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopStream` operation.
    ///
    /// See [`StopStream`](crate::client::fluent_builders::StopStream) for more information about the
    /// operation and its arguments.
    pub fn stop_stream(&self) -> fluent_builders::StopStream<C, M, R> {
        fluent_builders::StopStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetChannel`.
    ///
    /// <p>Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_channel_input::Builder,
    }
    impl<C, M, R> BatchGetChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetChannelInputOperationOutputAlias,
                crate::output::BatchGetChannelOutput,
                crate::error::BatchGetChannelError,
                crate::input::BatchGetChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>Array of ARNs, one per channel.</p>
        pub fn arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(inp);
            self
        }
        /// <p>Array of ARNs, one per channel.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetStreamKey`.
    ///
    /// <p>Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_stream_key_input::Builder,
    }
    impl<C, M, R> BatchGetStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetStreamKeyInputOperationOutputAlias,
                crate::output::BatchGetStreamKeyOutput,
                crate::error::BatchGetStreamKeyError,
                crate::input::BatchGetStreamKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>Array of ARNs, one per channel.</p>
        pub fn arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(inp);
            self
        }
        /// <p>Array of ARNs, one per channel.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Creates a new channel and an associated stream key to start streaming.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the
        /// Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and
        /// Standard, respectively.) Default: <code>LOW</code>.</p>
        pub fn latency_mode(mut self, inp: crate::model::ChannelLatencyMode) -> Self {
            self.inner = self.inner.latency_mode(inp);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the
        /// Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and
        /// Standard, respectively.) Default: <code>LOW</code>.</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.inner = self.inner.set_latency_mode(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn authorized(mut self, inp: bool) -> Self {
            self.inner = self.inner.authorized(inp);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_authorized(input);
            self
        }
        /// <p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>
        pub fn recording_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recording_configuration_arn(inp);
            self
        }
        /// <p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recording_configuration_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecordingConfiguration`.
    ///
    /// <p>Creates a new recording configuration, used to enable recording to Amazon S3.</p>
    /// <p>
    /// <b>Known issue:</b> In the us-east-1 region, if you use the
    /// Amazon Web Services CLI to create a recording configuration, it returns success even if the
    /// S3 bucket is in a different region. In this case, the <code>state</code> of the recording
    /// configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>). (In other
    /// regions, the CLI correctly returns failure if the bucket is in a different region.)</p>
    /// <p>
    /// <b>Workaround:</b> Ensure that your S3 bucket is in the same
    /// region as the recording configuration. If you create a recording configuration in a different
    /// region as your S3 bucket, delete that recording configuration and create a new one with an S3
    /// bucket from the correct region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recording_configuration_input::Builder,
    }
    impl<C, M, R> CreateRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecordingConfigurationInputOperationOutputAlias,
                crate::output::CreateRecordingConfigurationOutput,
                crate::error::CreateRecordingConfigurationError,
                crate::input::CreateRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A complex type that contains a destination configuration for where recorded video will be
        /// stored.</p>
        pub fn destination_configuration(
            mut self,
            inp: crate::model::DestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.destination_configuration(inp);
            self
        }
        /// <p>A complex type that contains a destination configuration for where recorded video will be
        /// stored.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::DestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_destination_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamKey`.
    ///
    /// <p>Creates a stream key, used to initiate a stream, for the specified channel ARN.</p>
    /// <p>Note that <a>CreateChannel</a> creates a stream key. If you subsequently use
    /// CreateStreamKey on the same channel, it will fail because a stream key already exists and
    /// there is a limit of 1 stream key per channel. To reset the stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stream_key_input::Builder,
    }
    impl<C, M, R> CreateStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamKeyInputOperationOutputAlias,
                crate::output::CreateStreamKeyOutput,
                crate::error::CreateStreamKeyError,
                crate::input::CreateStreamKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which to create the stream key.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>ARN of the channel for which to create the stream key.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Deletes the specified channel and its associated stream keys.</p>
    /// <p>If you try to delete a live channel, you will get an error (409 ConflictException). To
    /// delete a channel that is live, call <a>StopStream</a>, wait for the Amazon
    /// EventBridge "Stream End" event (to verify that the stream's state was changed from Live to
    /// Offline), then call DeleteChannel. (See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.)
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel to be deleted.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the channel to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlaybackKeyPair`.
    ///
    /// <p>Deletes a specified authorization key pair. This invalidates future viewer tokens
    /// generated using the key pair’s <code>privateKey</code>. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private
    /// Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_playback_key_pair_input::Builder,
    }
    impl<C, M, R> DeletePlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePlaybackKeyPairInputOperationOutputAlias,
                crate::output::DeletePlaybackKeyPairOutput,
                crate::error::DeletePlaybackKeyPairError,
                crate::input::DeletePlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the key pair to be deleted.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the key pair to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecordingConfiguration`.
    ///
    /// <p>Deletes the recording configuration for the specified ARN.</p>
    /// <p>If you try to delete a recording configuration that is associated with a channel, you will
    /// get an error (409 ConflictException). To avoid this, for all channels that reference the
    /// recording configuration, first use <a>UpdateChannel</a> to set the
    /// <code>recordingConfigurationArn</code> field to an empty string, then use
    /// DeleteRecordingConfiguration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recording_configuration_input::Builder,
    }
    impl<C, M, R> DeleteRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecordingConfigurationInputOperationOutputAlias,
                crate::output::DeleteRecordingConfigurationOutput,
                crate::error::DeleteRecordingConfigurationError,
                crate::input::DeleteRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the recording configuration to be deleted.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the recording configuration to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamKey`.
    ///
    /// <p>Deletes the stream key for the specified ARN, so it can no longer be used to
    /// stream.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stream_key_input::Builder,
    }
    impl<C, M, R> DeleteStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamKeyInputOperationOutputAlias,
                crate::output::DeleteStreamKeyOutput,
                crate::error::DeleteStreamKeyError,
                crate::input::DeleteStreamKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the stream key to be deleted.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the stream key to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChannel`.
    ///
    /// <p>Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_channel_input::Builder,
    }
    impl<C, M, R> GetChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChannelInputOperationOutputAlias,
                crate::output::GetChannelOutput,
                crate::error::GetChannelError,
                crate::input::GetChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which the configuration is to be retrieved.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the channel for which the configuration is to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPlaybackKeyPair`.
    ///
    /// <p>Gets a specified playback authorization key pair and returns the <code>arn</code> and
    /// <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to
    /// generate viewer authorization tokens, to grant viewers access to private channels. For more
    /// information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_playback_key_pair_input::Builder,
    }
    impl<C, M, R> GetPlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPlaybackKeyPairInputOperationOutputAlias,
                crate::output::GetPlaybackKeyPairOutput,
                crate::error::GetPlaybackKeyPairError,
                crate::input::GetPlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the key pair to be returned.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the key pair to be returned.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecordingConfiguration`.
    ///
    /// <p>Gets the recording configuration for the specified ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRecordingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recording_configuration_input::Builder,
    }
    impl<C, M, R> GetRecordingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecordingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecordingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecordingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecordingConfigurationInputOperationOutputAlias,
                crate::output::GetRecordingConfigurationOutput,
                crate::error::GetRecordingConfigurationError,
                crate::input::GetRecordingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the recording configuration to be retrieved.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the recording configuration to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStream`.
    ///
    /// <p>Gets information about the active (live) stream on a specified channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_input::Builder,
    }
    impl<C, M, R> GetStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamInputOperationOutputAlias,
                crate::output::GetStreamOutput,
                crate::error::GetStreamError,
                crate::input::GetStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel ARN for stream to be accessed.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>Channel ARN for stream to be accessed.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamKey`.
    ///
    /// <p>Gets stream-key information for a specified ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_key_input::Builder,
    }
    impl<C, M, R> GetStreamKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamKeyInputOperationOutputAlias,
                crate::output::GetStreamKeyOutput,
                crate::error::GetStreamKeyError,
                crate::input::GetStreamKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN for the stream key to be retrieved.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN for the stream key to be retrieved.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamSession`.
    ///
    /// <p>Gets metadata on a specified stream.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_stream_session_input::Builder,
    }
    impl<C, M, R> GetStreamSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamSessionInputOperationOutputAlias,
                crate::output::GetStreamSessionOutput,
                crate::error::GetStreamSessionError,
                crate::input::GetStreamSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel resource</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>ARN of the channel resource</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>Unique identifier for a live or previously live stream in the specified channel. If no
        /// <code>streamId</code> is provided, this returns the most recent stream session for the
        /// channel, if it exists.</p>
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// <p>Unique identifier for a live or previously live stream in the specified channel. If no
        /// <code>streamId</code> is provided, this returns the most recent stream session for the
        /// channel, if it exists.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportPlaybackKeyPair`.
    ///
    /// <p>Imports the public portion of a new key pair and returns its <code>arn</code> and
    /// <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer
    /// authorization tokens, to grant viewers access to private channels. For more information, see
    /// <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up
    /// Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportPlaybackKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_playback_key_pair_input::Builder,
    }
    impl<C, M, R> ImportPlaybackKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportPlaybackKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportPlaybackKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportPlaybackKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportPlaybackKeyPairInputOperationOutputAlias,
                crate::output::ImportPlaybackKeyPairOutput,
                crate::error::ImportPlaybackKeyPairError,
                crate::input::ImportPlaybackKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The public portion of a customer-generated key pair.</p>
        pub fn public_key_material(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_key_material(inp);
            self
        }
        /// <p>The public portion of a customer-generated key pair.</p>
        pub fn set_public_key_material(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_key_material(input);
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Any tags provided with the request are added to the playback key pair tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Any tags provided with the request are added to the playback key pair tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Gets summary information about all channels in your account, in the Amazon Web Services
    /// region where the API request is processed. This list can be filtered to match a specified name
    /// or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If
    /// you try to use both filters, you will get an error (409 ConflictException).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the channel list to match the specified name.</p>
        pub fn filter_by_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_by_name(inp);
            self
        }
        /// <p>Filters the channel list to match the specified name.</p>
        pub fn set_filter_by_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_by_name(input);
            self
        }
        /// <p>Filters the channel list to match the specified recording-configuration ARN.</p>
        pub fn filter_by_recording_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filter_by_recording_configuration_arn(inp);
            self
        }
        /// <p>Filters the channel list to match the specified recording-configuration ARN.</p>
        pub fn set_filter_by_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_by_recording_configuration_arn(input);
            self
        }
        /// <p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of channels to return. Default: 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of channels to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlaybackKeyPairs`.
    ///
    /// <p>Gets summary information about playback key pairs. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private
    /// Channels</a> in the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPlaybackKeyPairs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_playback_key_pairs_input::Builder,
    }
    impl<C, M, R> ListPlaybackKeyPairs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPlaybackKeyPairs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlaybackKeyPairsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlaybackKeyPairsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPlaybackKeyPairsInputOperationOutputAlias,
                crate::output::ListPlaybackKeyPairsOutput,
                crate::error::ListPlaybackKeyPairsError,
                crate::input::ListPlaybackKeyPairsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of key pairs to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Maximum number of key pairs to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The first key pair to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field. Default: 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The first key pair to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecordingConfigurations`.
    ///
    /// <p>Gets summary information about all recording configurations in your account, in the
    /// Amazon Web Services region where the API request is processed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRecordingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recording_configurations_input::Builder,
    }
    impl<C, M, R> ListRecordingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecordingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecordingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecordingConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecordingConfigurationsInputOperationOutputAlias,
                crate::output::ListRecordingConfigurationsOutput,
                crate::error::ListRecordingConfigurationsError,
                crate::input::ListRecordingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The first recording configuration to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The first recording configuration to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of recording configurations to return. Default: 50. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of recording configurations to return. Default: 50. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamKeys`.
    ///
    /// <p>Gets summary information about stream keys for the specified channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stream_keys_input::Builder,
    }
    impl<C, M, R> ListStreamKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamKeysInputOperationOutputAlias,
                crate::output::ListStreamKeysOutput,
                crate::error::ListStreamKeysError,
                crate::input::ListStreamKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The first stream key to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The first stream key to retrieve. This is used for pagination; see the
        /// <code>nextToken</code> response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streamKeys to return. Default: 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of streamKeys to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Gets summary information about live streams in your account, in the Amazon Web Services
    /// region where the API request is processed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl<C, M, R> ListStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamsInputOperationOutputAlias,
                crate::output::ListStreamsOutput,
                crate::error::ListStreamsError,
                crate::input::ListStreamsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filters the stream list to match the specified criterion.</p>
        pub fn filter_by(mut self, inp: crate::model::StreamFilters) -> Self {
            self.inner = self.inner.filter_by(inp);
            self
        }
        /// <p>Filters the stream list to match the specified criterion.</p>
        pub fn set_filter_by(
            mut self,
            input: std::option::Option<crate::model::StreamFilters>,
        ) -> Self {
            self.inner = self.inner.set_filter_by(input);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamSessions`.
    ///
    /// <p>Gets a summary of current and previous streams for a specified channel in your account, in
    /// the AWS region where the API request is processed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stream_sessions_input::Builder,
    }
    impl<C, M, R> ListStreamSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamSessionsInputOperationOutputAlias,
                crate::output::ListStreamSessionsOutput,
                crate::error::ListStreamSessionsError,
                crate::input::ListStreamSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>Channel ARN used to filter the list.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code>
        /// response field.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of streams to return. Default: 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about Amazon Web Services tags for the specified ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to be retrieved.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to be retrieved.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMetadata`.
    ///
    /// <p>Inserts metadata into the active stream of the specified channel. At most 5 requests per
    /// second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient
    /// for your needs, we recommend batching your data into a single PutMetadata call.) At most 155
    /// requests per second per account are allowed. Also see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video Stream</a> in
    /// the <i>Amazon IVS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_metadata_input::Builder,
    }
    impl<C, M, R> PutMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMetadataInputOperationOutputAlias,
                crate::output::PutMetadataOutput,
                crate::error::PutMetadataError,
                crate::input::PutMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel into which metadata is inserted. This channel must have an active
        /// stream.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>ARN of the channel into which metadata is inserted. This channel must have an active
        /// stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
        /// <p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>
        pub fn metadata(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStream`.
    ///
    /// <p>Disconnects the incoming RTMPS stream for the specified channel. Can be used in
    /// conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a
    /// channel.</p>
    /// <note>
    /// <p>Many streaming client-software libraries automatically reconnect a dropped RTMPS
    /// session, so to stop the stream permanently, you may want to first revoke the
    /// <code>streamKey</code> attached to the channel.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StopStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_stream_input::Builder,
    }
    impl<C, M, R> StopStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopStreamInputOperationOutputAlias,
                crate::output::StopStreamOutput,
                crate::error::StopStreamError,
                crate::input::StopStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel for which the stream is to be stopped.</p>
        pub fn channel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_arn(inp);
            self
        }
        /// <p>ARN of the channel for which the stream is to be stopped.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>ARN of the resource for which tags are to be added or updated.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of tags to be added or updated.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Array of tags to be added or updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the resource with the specified ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>ARN of the resource for which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Array of tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Array of tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Updates a channel's configuration. This does not affect an ongoing stream of this channel.
    /// You must stop and restart the stream for the changes to take effect.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of the channel to be updated.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>ARN of the channel to be updated.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the
        /// Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and
        /// Standard, respectively.)</p>
        pub fn latency_mode(mut self, inp: crate::model::ChannelLatencyMode) -> Self {
            self.inner = self.inner.latency_mode(inp);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the
        /// Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and
        /// Standard, respectively.)</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.inner = self.inner.set_latency_mode(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately</i>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately</i>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization).</p>
        pub fn authorized(mut self, inp: bool) -> Self {
            self.inner = self.inner.authorized(inp);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization).</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_authorized(input);
            self
        }
        /// <p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A
        /// value other than an empty string indicates that recording is enabled</p>
        pub fn recording_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recording_configuration_arn(inp);
            self
        }
        /// <p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A
        /// value other than an empty string indicates that recording is enabled</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recording_configuration_arn(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
